#!/bin/sh

#Add a new parameter "Ever connected to Internet (Y/N):" parameter to POT hidden page
#For Internet detection, please use below ways to validate the Internet is really connected 
#successfully or not. Is any way successful, which mean Internet is really connected.
#      Ping www.netgear.com
#      Ping 8.8.8.8 (google primary DNS server)
#      Ping 8.8.4.4 (google secondary DNS server)
#      do DNS lookups for www.netgear.com
#      do DNS lookups for www.google.com
#The default value for this parameter "Ever connected to Internet (Y/N)" is "No". 
#Every time when a router connects to the Internet first time since it boots up, if the Internet
#connection is successful by above detect methods, then the router MUST set this parameter to "Yes". 
#After this parameter is set to "Yes", then this parameter can't be over-written and no need to
#do such Internet checking anymore.

check_netconn()
{
        i=0
        while [ $i -eq 0 ]
        do
                echo "No" >/tmp/POT_netconn
                netconn_status=$(/usr/sbin/netconn get 2>&1 | awk '{print $NF}')
                #check internet connect.
                rm -rf /tmp/netgear_tmp /tmp/google_primary /tmp/google_secondary /tmp/netgear_lookup /tmp/google_lookup
                (ping -c 5 www.netgear.com >/tmp/netgear_tmp 2>/dev/null) &
                (ping -c 5 8.8.8.8 >/tmp/google_primary 2>/dev/null) &
                (ping -c 5 8.8.4.4 >/tmp/google_secondary 2>/dev/null) &
                (nslookup www.netgear.com >/tmp/netgear_lookup 2>/dev/null) &
                (nslookup www.google.com >/tmp/google_lookup 2>/dev/null) &

                #wait for result.
                sleep 6
                killall nslookup 2>/dev/null
                #check result.
                if [ -n "`sed -n '/ttl/p' /tmp/netgear_tmp`" ] || \
                        [ -n "`sed -n '/ttl/p' /tmp/google_primary`" ] || \
                        [ -n "`sed -n '/ttl/p' /tmp/google_secondary`" ] || \
                        [ -n "`sed -n '/name/p' /tmp/netgear_lookup`" ] || \
                        [ -n "`sed -n '/name/p' /tmp/google_lookup`" ] || \
                        [ "$netconn_status" = "Yes" ]
                then
                        /usr/sbin/netconn set
                        echo "Yes" >/tmp/POT_netconn
                        i=1
                fi
        done
        check_POT_netconn
}

check_POT_netconn()
{
        j=0
        while [ $j -eq 0 ]
        do
                sleep 3
                netconn_status=$(/usr/sbin/netconn get 2>&1 | awk '{print $NF}')
                if [ "$netconn_status" = "Yes" ]
                then
                        echo "Yes" >/tmp/POT_netconn
                        exit 0
                else
                        echo "No" >/tmp/POT_netconn
                        j=1
                fi
        done
        check_netconn
}

main()
{
        check_POT_netconn
}

main
