#!/bin/bash

[ "$1" = "" ] && exit 1
[ "$2" = "" ] && exit 1
PROFILE_NAME="$1"
ONE_IMAGE_FINAL="$2"
STAGING_DIR_HOST_BIN=$(cd `dirname $0`; pwd)
TOPDIR="$STAGING_DIR_HOST_BIN/../../../"
mkdir -p $TOPDIR/images

FW_VERSION=`cat $TOPDIR/targets/$PROFILE_NAME/special-buildFS |grep FW_VERSION= |awk -F'=' '{print $2}'`
MODULE_COMMON_NAME=`cat $TOPDIR/targets/$PROFILE_NAME/special-buildFS |grep MODULE_COMMON_NAME= |awk -F'=' '{print $2}'`
FW_REGION=`cat $TOPDIR/targets/$PROFILE_NAME/special-buildFS |grep FW_REGION= |awk -F'=' '{print $2}' |sed 's/"//g'`
HW_ID=`cat $TOPDIR/targets/$PROFILE_NAME/special-buildFS |grep HW_ID= |awk -F'=' '{print $2}' |sed 's/"//g'`
MODULE_LIST=`cat $TOPDIR/targets/$PROFILE_NAME/special-buildFS |grep MODULE_LIST= |awk -F'=' '{print $2}' |sed 's/"//g'`

#For Those projects only have MODULE_NAME but not MODULE_COMMON_NAME
if [ "$MODULE_COMMON_NAME" = "" ]; then
	MODULE_COMMON_NAME=`cat $TOPDIR/targets/$PROFILE_NAME/special-buildFS |grep MODULE_NAME= |awk -F'=' '{print $2}'`
	MODULE_LIST="$MODULE_COMMON_NAME"
fi

#echo "$STAGING_DIR_HOST_BIN/mkdniimg -B $MODULE_NAME -v $FW_VERSION -r $FW_REGION -H $HW_ID -i $ONE_IMAGE_FINAL -o $DNI_IMAGE"
for project in $MODULE_LIST; do \
	DNI_IMAGE="$TOPDIR/images/$project-$FW_VERSION.img"
	rm -rf $DNI_IMAGE
	$STAGING_DIR_HOST_BIN/mkdniimg -B $MODULE_COMMON_NAME -v $FW_VERSION -r "$FW_REGION" -H $HW_ID -i $ONE_IMAGE_FINAL -o $DNI_IMAGE
	cp -fp $TOPDIR/targets/$PROFILE_NAME/bcm${PROFILE_NAME}_linux_raw_squash_image_128.bin  $TOPDIR/images/$project-$FW_VERSION-single.img
done
