#include "dni_util.h"

//porting from net-cgi
void __nprintf(const char *fmt, ...)
{
	va_list ap;
	static FILE *filp;

	if ((filp == NULL) && (filp = fopen("/dev/console", "a")) == NULL)
		return;

	va_start(ap, fmt);
	vfprintf(filp, fmt, ap);
	fputs("\n", filp);
	va_end(ap);
}


// can feplace fscanf() with dni_fscanf()to avoid being considered as a bug
int dni_fscanf(FILE *stream,const char * format,...)
{
  va_list arg;
  int done;

  va_start(arg,format);

  done=vfscanf(stream,format,arg);
  va_end(arg);
  return done;
}

int dni_snprintf(char *s,size_t maxlen,const char *format,...)
{
   va_list arg;
  int done;

  va_start(arg,format);

  done=vsnprintf(s,maxlen,format,arg);
  va_end(arg);
  return done;

}

char * dni_fgets(char *s,int count,FILE *stream)
{
    return fgets(s,count,stream);
}

char *dni_strncat(char *dest, const char *src, size_t n)
{
	if(!src||!dest)
		return NULL;

	return strncat(dest, src, n);
}

int dni_strcmp(const char *p1,const char *p2)
{
    if(!p1||!p2)
        return 1;
    return  strcmp(p1,p2);
}

int dni_strncmp(const char *p1,const char *p2,size_t siz)
{
	if(!p1||!p2)
		 return 1;
	return strncmp(p1, p2, siz);
}

size_t dni_strlen(const char *str)
{
   
   if(!str)
     return 0;
   return strlen(str);

} 

int dni_strcasecmp(const char *s1, const char *s2)
{
        if ( !s1||!s2 )
                return 1;
        return strcasecmp(s1, s2);
}

char *dni_strstr(const char* s1, const char *s2)
{
        if ( !s1 || !s2 )
                return NULL;
        return strstr(s1, s2);
}

char *dni_strcasestr(const char* s1, const char *s2)
{
        if ( !s1 || !s2 )
                return NULL;
        return strcasestr(s1, s2);
}

char *dni_strdup(char *str)
{
        if (!str)
                return NULL;
        return strdup(str);
}

char *dni_itoa(int num)
{
        char buf[64] = {0};
        if ( !num )
                return dni_strdup("");
        dni_snprintf(buf,sizeof(buf), "%d", num);
        return dni_strdup(buf);
}

char *dni_strncpy(char *dest, const char *src, size_t n)
{
    if (src == NULL)
	    return NULL;

    strncpy(dest, src, n);
}
