#!/bin/sh

#HOWTO:
#
#Purpose:
#	After DUT gets ntp time, some other modules(such as trafficmeter) need take some action.
#	We write this script to gather all the action other modules need to take.
#
#Usage:
#	Add new function:
#		func_xxxxxx ()
#		{
#			echo ======your_code_xxxxxx======= >/dev/console
#		}
#	Invoke func_xxxxxx ()
#		For example, in ntpclient.c
#		system("ntp_updated xxxxxx");
#
#Using Occasion:
#	func_common - right after getting ntp time
#	func_daylight - when daylight saving time enabled and right after getting ntp time
#	

CONFIG=/bin/config
wlan_schedule="wlan schedule"

OPTIONS=`for opt in $(grep '^func_.*()' $0 | cut -d_ -f2- | cut -d' ' -f1); do echo $opt; done`;

func_common ()
{
	#update dal value for RAE data#
	d2 -c DalRaFolderPath[0].dalRaNtpGetResult Yes

	touch /tmp/system_time_updated

	#Save ntp synced time for Armor action in next time booting
	[ ! -d /data/dni/ntp ] && mkdir -p /data/dni/ntp
	date +%Y.%m.%d-%H:%M:%S -u > /data/dni/ntp/save_time

	#trigger RAE installation event
	/usr/sbin/ra_installevent ntpsynced

	#Record first NTP Sync Timestamp, if the Timestamp have existed on pot partition, ntpst will do nothing.
	ntpst set -T $($CONFIG get time_zone) -d $(part_path pot)

	# When time updates, and selects "Per Schedule" for "Block Sites" && "Block Services", generate the crond's schedule file again.
	if [ "x$($CONFIG get block_skeyword)" = "x1" ] || [ "x$($CONFIG get blockserv_ctrl)" = "x1" ]; then
		/sbin/cmdsched
		firewall.sh start
	fi

	# Fix Bug 23259, when time updates,it must check whether WIFI should be turned off according WIFI Schedule
	if [ "x$($CONFIG get wladv_schedule_enable)" = "x1" ]; then
		/sbin/cmdsched_wlan_status 11g
		if [ "x$($CONFIG get wlg_onoff_sched)" = "x1" ]; then
			$wlan_schedule 11g off 
			echo "==========ntp:wlan scheudle 11g off" >/dev/console
		else
			$wlan_schedule 11g on
			echo "===========ntp:wlan scheudle 11g on" >/dev/console
		fi
	fi

	if [ "x$($CONFIG get wladv_schedule_enable_a)" = "x1" ]; then
		/sbin/cmdsched_wlan_status 11a
		if [ "x$($CONFIG get wla_onoff_sched)" = "x1" ]; then
			$wlan_schedule 11a off 
			echo "==========ntp:wlan scheudle 11a off" >/dev/console
		else
			$wlan_schedule 11a on
			echo "===========ntp:wlan scheudle 11a on" >/dev/console
		fi
	fi

	if [ "x$($CONFIG get wladv_schedule_enable_tri)" = "x1" -a "$($CONFIG get radio_number)" = "0x7"  ]; then
		/sbin/cmdsched_wlan_status 11h
		if [ "x$($CONFIG get wla_2nd_onoff_sched)" = "x1"  ]; then
			$wlan_schedule 11h off 
			echo "==========ntp:wlan scheudle 11h off" >/dev/console
		else
			$wlan_schedule 11h on
			echo "===========ntp:wlan scheudle 11h on" >/dev/console
		fi
	fi
	
	#guest schedule update
	if [ -n "$($CONFIG get wlg_guest_target_time)" -a "x$($CONFIG get wlg_guest_target_time)" != "x0" ] ||
	   [ -n "$($CONFIG get wla_guest_target_time)" -a "x$($CONFIG get wla_guest_target_time)" != "x0" ] ;then
		echo "===========ntp:guest scheudle update" >/dev/console
		/sbin/guest_sched.sh update
	fi
}

func_daylight ()
{
    # not restart traffic meter when device boot stage
    [ -e /tmp/boot_status ] && exit

	/sbin/cmd_traffic_meter stop
	/sbin/cmd_traffic_meter start
}

func_xcloud ()
{
	#update dal value for RAE data#
	d2 -c DalRaFolderPath[0].dalRaNtpGetResult Yes

	# RAE need to check ntp sync result, will check "/tmp/ntp_RaUpdated"
	touch /tmp/ntp_RaUpdated
	touch /tmp/system_time_updated

	#Save ntp synced time for Armor action in next time booting
	[ ! -d /data/dni/ntp ] && mkdir -p /data/dni/ntp
	date +%Y.%m.%d-%H:%M:%S -u > /data/dni/ntp/save_time

	#trigger RAE installation event
	/usr/sbin/ra_installevent ntpsynced
}

for opt in $OPTIONS; do
	if [ -n "$1" ] && [ "$1" = "$opt" ]; then
		shift
		eval $@
		func_$opt

		exit 0;
	fi
done

echo "Error: Invalid option -$1- of ntp_updated."
