#!/bin/sh
# Blink WPS LED according to LED_STATE

for arg in $@
do
    eval $arg
done

WPS_ERR_file=/tmp/wps_led_err_state
WPS_OVERLAP_file=/tmp/wps_overlap_detected
LOCK_file=/tmp/wps_led_lock

[ "$ACTION" != "BLINK_LED" ] && exit 0

if [ -f $WPS_ERR_file -o -f $WPS_OVERLAP_file ]; then
   [ "$LED_STATE" = "LED_ERROR" ] && exit 0
   [ "$LED_STATE" = "LED_OVERLAP" ] && exit 0
fi

if [ -f $LOCK_file ]; then
   [ "$LED_STATE" = "LED_OFF" ] && exit 0
fi

if [ "x$LED_STATE" = "xLED_ERROR" ]; then
	touch $WPS_ERR_file
fi

if [ "x$LED_STATE" = "xLED_OVERLAP" ];then
	touch ${WPS_OVERLAP_file}
fi

for pid in `ps | grep -e 'wps-update-led' | awk '{print $1}'`; do
    if [ -d /proc/$pid ]; then
        # kill previous BLINK_LED process if above kill can not find them.
        is_error_led=`ps -ww | grep $pid | grep -E 'LED_STATE=LED_ERROR|LED_INVALID_CL_PIN|LED_PIN_INTRUSION'`
	is_blink_led=`ps -ww | grep $pid | grep -e 'ACTION=BLINK_LED'`
        if [ -n "$is_error_led" ]; then
            continue
        elif [ -n "$is_blink_led" -a "$pid" -lt "$$" ]; then
            kill -9 $pid
        fi
    fi
done

. /etc/wlan/wifi_conf

INPROGRESS_INTERVAL=500000      # 0.5s
ERROR_INTERVAL=100000           # 0.1s
ERROR_TIMEOUT=50                # 50 * 0.1s = 5s
OVERLAP_PAUSE_INTERVAL=500000   # 0.5s
OVERLAP_BLINK_TIMEOUT=10        # 10 * 0.1s = 1s
SUCCESS_INTERVAL=30000000       # 30s

if [ "x$DURATION" = "x0" ]; then
	DURATION=240
fi

if [ -e /proc/simple_config/tricolor_led ]; then
    LED_off='[ -f /proc/simple_config/tricolor_led ] && echo 0 > /proc/simple_config/tricolor_led'
    LED_color1_on='[ -f /proc/simple_config/tricolor_led ] && echo 1 > /proc/simple_config/tricolor_led'
    LED_color2_on='[ -f /proc/simple_config/tricolor_led ] && echo 2 > /proc/simple_config/tricolor_led'
elif eval "type ledcontrol" 2>/dev/null >/dev/null; then
    if [ -f /tmp/orbi_project ]; then
        LED_off=''
        LED_color1_on=''
        LED_color2_on=''
    else
        LED_off='/sbin/ledcontrol -n wps -c green -s off'
        LED_color1_on='/sbin/ledcontrol -n wps -c green -s on'
        LED_color2_on=''
    fi
elif [ -e /proc/simple_config/simple_config_led ]; then
    LED_off='echo 1 > /proc/simple_config/simple_config_led'
    LED_color1_on='echo 2 > /proc/simple_config/simple_config_led'
    LED_color2_on=''
else
    LED_off=''
    LED_color1_on=''
    LED_color2_on=''
fi

#if [ "x$PROG_SRC" = "xathr-hostapd" ]; then
    #wps_stop_command='wlan wps --wps_stop'
#else
    #wps_stop_command='echo stop > /proc/simple_config/wps'
#fi
wps_stop_command()
{
	hostapd_cli -i wl0 -p /var/run/hostapd wps_cancel
	hostapd_cli -i wl1 -p /var/run/hostapd wps_cancel
	hostapd_cli -i wl2 -p /var/run/hostapd wps_cancel
}

if eval "type uname" 2>/dev/null >/dev/null; then
    kernel_version=`uname -r | awk -F. '{print $1$2$3}'`
fi

i=0
LED_busy=no
LED_on=$LED_color1_on
if [ "x$PROG_SRC" = "xrealtek" ]; then
   # overwrite LED commands for realtek solution.
   LED_on='echo 1 > /proc/led_ctl/wps_led'
   LED_off='echo 0 > /proc/led_ctl/wps_led'
   LED_color2_on=""
fi

if [ "x$PROG_SRC" != "xrealtek" -a "x$PROG_SRC" != "xathr-hostapd" ]; then
case "$INTERFACE" in
	ath0)
		Other_INTERFACE=ath1
		;;
	ath1 | ath2)
		Other_INTERFACE=ath0
		;;
	*)
		echo "WPS led does not support $INTERFACE"
		exit 1
esac
fi

case "$LED_STATE" in
	LED_INPROGRESS)
		TIMEOUT_=$(($DURATION * 1000000 / $INPROGRESS_INTERVAL))
		INTERVAL=$INPROGRESS_INTERVAL
		#to solve bug 35175 - [Wireless][led]the wps led shows abnormal when i push firmware button.
		#here let it run first,otherwise will lead to wps led first time blink show abnormal. 
		wpsled wps_lock_down off

		echo "********wps inprogress**********" > /dev/console
		;;
	LED_ERROR)
		TIMEOUT_=$ERROR_TIMEOUT
		if [ "x$LED_color2_on" != "x" ]; then
			LED_on=$LED_color2_on
		fi
		INTERVAL=$ERROR_INTERVAL

		echo "**********wps error***********" > /dev/console

		if [ -f /tmp/orbi_project ]; then
			#recover ledstatus
			/sbin/led_ring stop
			if [ `cat /tmp/orbi_type` = "Satellite" ] ;then
				echo "wps_fail" > /var/run/repacd.pipe
				echo "wps_fail" > /var/run/led_ctrl.pipe
			fi
			killall -9 ping-netgear 2> /dev/null
			/sbin/ping-netgear &
		fi

		if [ "$(config get endis_wl_radio)" = "1" -a "$(config get endis_wla_radio)" = "1" ]; then
			if [ "$is_dual_band" = "0" ]; then
				if [ "$(config get endis_wla_2nd_radio)" = "1" ]; then
					touch $LOCK_file
					#wps_stop_command
				fi
			else
				touch $LOCK_file
				#wps_stop_command
			fi
		fi
		;;
	LED_OVERLAP)
		TIMEOUT_=$ERROR_TIMEOUT
		if [ "x$LED_color2_on" != "x" ]; then
			LED_on=$LED_color2_on
		fi
		INTERVAL=$ERROR_INTERVAL

		echo "**********wps overlap***********" > /dev/console

		if [ "$(config get endis_wl_radio)" = "1" -a "$(config get endis_wla_radio)" = "1" ]; then
			if [ "$is_dual_band" = "0" ]; then
				if [ "$(config get endis_wla_2nd_radio)" = "1" ]; then
					touch $LOCK_file
					wps_stop_command
				fi
			else
				touch $LOCK_file
				wps_stop_command
			fi
		fi
		;;
	LED_SUCCESS)
		TIMEOUT_=0
		INTERVAL=$SUCCESS_INTERVAL

		echo "**********wps success***********" > /dev/console

		if [ -f /tmp/orbi_project ]; then
			#recover ledstatus
			/sbin/led_ring stop
			if [ `cat /tmp/orbi_type` = "Satellite" ] ;then
				echo "wps_finish" > /var/run/repacd.pipe
				echo "wps_finish" > /var/run/led_ctrl.pipe
			fi
			killall -9 ping-netgear 2> /dev/null
			/sbin/ping-netgear &
		fi

		if [ "$(config get endis_wl_radio)" = "1" -a "$(config get endis_wla_radio)" = "1" ]; then
			if [ "$is_dual_band" = "0" ]; then
				if [ "$(config get endis_wla_2nd_radio)" = "1" ]; then
					touch $LOCK_file
				fi
			else
				touch $LOCK_file
			fi
			#eval $wps_stop_command
		fi
		;;
	LED_AP_LOCK)
		wpsled wps_lock_down on &
		exit
		;;
	LED_AP_LOCK_OFF)
		wpsled wps_lock_down stop &
		exit
		;;
	LED_PIN_INTRUSION)
		if [ "x$LED_color2_on" != "x" ]; then
			LED_on=$LED_color2_on
		fi
		TIMEOUT_=50
		INTERVAL=$ERROR_INTERVAL
		touch $LOCK_file
		;;
	LED_INVALID_CL_PIN)
		if [ "x$LED_color2_on" != "x" ]; then
			LED_on=$LED_color2_on
		fi
		TIMEOUT_=50
		INTERVAL=$ERROR_INTERVAL
		if [ "$(config get endis_wl_radio)" = "1" -a "$(config get endis_wla_radio)" = "1" ]; then
			if [ "$is_dual_band" = "0" ]; then
				if [ "$(config get endis_wla_2nd_radio)" = "1" ]; then
					touch $LOCK_file
				fi
			else
				touch $LOCK_file
			fi
			#eval $wps_stop_command
		fi
                ;;

	*)
		TIMEOUT_=0
		;;
esac

while [ $i -lt $TIMEOUT_ ]
do
	if [ $LED_busy = "no" ]; then
		eval $LED_on
		LED_busy=yes
	else
		eval $LED_off
		LED_busy=no
	fi
	usleep $INTERVAL
	i=$(($i+1))
# No PBC OVERLAPING LED behavior in NETGEAR spec.
#	if [ "$LED_STATE" = "LED_OVERLAP" -a "$(( $i % $OVERLAP_BLINK_TIMEOUT ))" = "0" ]; then
#		usleep $OVERLAP_PAUSE_INTERVAL
#	fi
done

#for bug 24207/24152 since we will set security type when wps finish, when we read
#wl_sectype, this value still do not set successfully, we will wait 0.5s to read this
#value

usleep 500000

wpsled wps_lock_down on &

CONFIG=/bin/config
if [ "x$($CONFIG get bridge_mode)" = "x1" ]; then
	if [ "$(${CONFIG} get bridge_band_choose)" = "2.4g" -a "$(${CONFIG} get wl_bridge_sectype)" = "1" ] ||
	[ "$(${CONFIG} get bridge_band_choose)" = "5g" -a "$(${CONFIG} get wla_bridge_sectype)" = "1" ]; then
		eval ${LED_off}
	else
		eval ${LED_color1_on}
	fi
else
	if [ "$(${CONFIG} get endis_wl_radio)" = "1" -a "$(${CONFIG} get wl_sectype)" != "1" ] ||
	[ "$(${CONFIG} get endis_wla_radio)" = "1" -a "$(${CONFIG} get wla_sectype)" != "1" ] ||
	[ "$(${CONFIG} get endis_wla_2nd_radio)" = "1" -a "$(${CONFIG} get wla_2nd_sectype)" != "1" -a "x$is_dual_band" = "x0" ]; then
		if [ "$(${CONFIG} get wireless1_vap)" != "1" -a "x${is_single_ssid}" = "x1" ]; then
			eval ${LED_off}
		else
			eval ${LED_color1_on}
		fi
	else
		eval ${LED_off}
	fi
fi

if [ "x$LED_STATE" = "xLED_ERROR" ]; then
	rm -f $WPS_ERR_file
fi

if [ "x$LED_STATE" = "xLED_OVERLAP" ];then
	rm -f ${WPS_OVERLAP_file}
fi

rm -f $PID_file $LOCK_file 

