/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/



/* This is an automated file. Do not edit its contents. */


#ifndef _RDD_DATA_STRUCTURES_AUTO_H_
#define _RDD_DATA_STRUCTURES_AUTO_H_

#define GROUPED_EN_SEGMENTS_NUM       16
#define INVALID_TABLE_ADDRESS         0xFFFFFF

#ifdef __clang__
#define ALIGNMENT(x) __attribute__((align_value((x))))
#else
#define ALIGNMENT(x)
#endif


/* DDR */

/* >>>IPTV_DDR_CONTEXT_TABLE */

/* >>>IPTV_DDR_CONTEXT_ENTRY_STRUCT */
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER	16
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER	16
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER	32
typedef union
{
    uint32_t word_32[22];
    uint64_t dword_64[11];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_ver                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_vid                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_src_ip                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vid                                                               	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	next_entry_idx                                                    	;
        uint16_t	ssid_vector_0_or_flooding_vport                                   	;
        uint16_t	ssid_vector_1                                                     	;
        uint16_t	ssid_vector_2                                                     	;
        uint32_t	radio_dhd_vector                                                  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rdd_vport                                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_proxy_enabled                                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_tx_prio                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications                                                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                                                           	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_ports_vector                                               	;
        uint32_t	src_ip                                                            	;
        uint8_t	src_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER];
        uint8_t	dst_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER];
        uint8_t	result[RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER];
#else
        uint16_t	next_entry_idx                                                    	;
        uint32_t	vid                                                               	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_src_ip                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_vid                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_ver                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ssid_vector_1                                                     	;
        uint16_t	ssid_vector_0_or_flooding_vport                                   	;
        uint32_t	wlan_mcast_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_proxy_enabled                                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rdd_vport                                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	radio_dhd_vector                                                  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ssid_vector_2                                                     	;
        uint32_t	cntr_id                                                           	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications                                                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_tx_prio                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_ports_vector                                               	;
        uint32_t	src_ip                                                            	;
        uint8_t	src_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER];
        uint8_t	dst_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER];
        uint8_t	result[RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_DDR_CONTEXT_ENTRY_STRUCT;

#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ_G(r, g, idx)                                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE_G(v, g, idx)                                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ(r, p)                                           FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE(v, p)                                          FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ(r, p)                                          FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE(v, p)                                         FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ_G(r, g, idx)                                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE_G(v, g, idx)                                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ(r, p)                                         FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE(v, p)                                        FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ_G(r, g, idx)                                      GROUP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE_G(v, g, idx)                                     GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ(r, p)                                             FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE(v, p)                                            FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ_G(r, g, idx)                           GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE_G(v, g, idx)                          GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ(r, p)                                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE(v, p)                                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ(r, p)                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 5, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 5, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 10, 5, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 10, 5, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ_G(r, g, idx)                                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE_G(v, g, idx)                               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ(r, p)                                       FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 5, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE(v, p)                                      FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 5, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 11, 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 11, 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 7, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 7, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 12, 4, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 12, 4, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 12, 4, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 12, 4, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 13, 6, 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 13, 6, 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ_G(r, g, idx)                                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE_G(v, g, idx)                                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ(r, p)                                         FIELD_MREAD_16((uint8_t *)(p) + 14, 0, 10, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE(v, p)                                        FIELD_MWRITE_16((uint8_t *)(p) + 14, 0, 10, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ(r, p)                             MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ_G(r, g, idx, i)                         GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE_G(v, g, idx, i)                        GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ(r, p, i)                                MREAD_I_8((uint8_t *)(p) + 24, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE(v, p, i)                               MWRITE_I_8((uint8_t *)(p) + 24, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ_G(r, g, idx, i)                         GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE_G(v, g, idx, i)                        GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ(r, p, i)                                MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE(v, p, i)                               MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p) + 56, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p) + 56, i, (v))
/* <<<IPTV_DDR_CONTEXT_ENTRY_STRUCT */


#define RDD_IPTV_DDR_CONTEXT_TABLE_SIZE     1024
typedef struct
{
	IPTV_DDR_CONTEXT_ENTRY_STRUCT	entry[ RDD_IPTV_DDR_CONTEXT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_DDR_CONTEXT_TABLE_STRUCT;

/* <<<IPTV_DDR_CONTEXT_TABLE */

/* PSRAM */
/* CORE_0 */

/* >>>DS_TM_PD_FIFO_TABLE */

/* >>>PROCESSING_TX_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q_codel_ts	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	coherent       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn             	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU1_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_timestamp          	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU2_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	serial_num     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcst_bcst_union	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_port   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	union3         	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	ingress_cong             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	reservedSU1_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	bn1_first                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcst_packet              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	bcst_packet              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	_ingress_cong            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	reservedSU2_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	abs3                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	stream_id                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	reservedSU3_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_port                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	lan_vport                	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	data_1588                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mcst_bcst_union	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	flow_id                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU4_union3       	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buffer_number_0_or_abs_0	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop                      	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn0_first                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn_fpm                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs1                     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn_fpm_pool              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint16_t	bn_fpm_num               	; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs0                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	hn             	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	coherent       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q_codel_ts	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	force_copy     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU1_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_timestamp          	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU2_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	serial_num     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	union3         	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ingress_port   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcst_bcst_union	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_1   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	flow                     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU1_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	cong_state               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	reservedSU1_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs3                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	source_port              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU2_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	_ingress_cong            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	bcst_packet              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	mcst_packet              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	reservedSU2_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	data_1588                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	lan_vport                	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	lag_port                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU3_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	stream_id                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of mcst_bcst_union union */
        uint32_t	reservedSU3_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_union3       	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_id                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	is_vport                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU4_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mcst_bcst_union	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0_or_abs_0	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn0_first                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop                      	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU1_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	bn_fpm                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop_fpm                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU2_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	bn_fpm_num               	; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	bn_fpm_pool              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	abs1                     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU3_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	abs0                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	reservedSU4_payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_abs          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PROCESSING_TX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_L_READ( wv )                         FIELD_GET( wv, 31, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_L_WRITE( v, wv )                     FIELD_SET( v, 31, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_L_READ( wv )                      FIELD_GET( wv, 30, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_L_WRITE( v, wv )                  FIELD_SET( v, 30, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_L_READ( wv )                      FIELD_GET( wv, 29, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_L_WRITE( v, wv )                  FIELD_SET( v, 29, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_L_READ( wv )                       FIELD_GET( wv, 28, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_L_WRITE( v, wv )                   FIELD_SET( v, 28, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_L_READ( wv )                     FIELD_GET( wv, 27, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_L_WRITE( v, wv )                 FIELD_SET( v, 27, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_L_READ( wv )                         FIELD_GET( wv, 26, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_L_WRITE( v, wv )                     FIELD_SET( v, 26, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_L_READ( wv )                    FIELD_GET( wv, 25, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_L_WRITE( v, wv )                FIELD_SET( v, 25, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_READ_G(r, g, idx)  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_WRITE_G(v, g, idx) GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_READ(r, p)         FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_WRITE(v, p)        FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_L_READ( wv )       FIELD_GET( wv, 16, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_L_WRITE( v, wv )   FIELD_SET( v, 16, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_READ_G(r, g, idx)           GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_READ(r, p)                  FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_WRITE(v, p)                 FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_L_READ( wv )                FIELD_GET( wv, 16, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_L_WRITE( v, wv )            FIELD_SET( v, 16, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_L_READ( wv )               FIELD_GET( wv, 16, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_L_WRITE( v, wv )           FIELD_SET( v, 16, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 2, 7, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 2, 7, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_L_READ( wv )                 FIELD_GET( wv, 7, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_L_WRITE( v, wv )             FIELD_SET( v, 7, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_L_READ( wv )                     FIELD_GET( wv, 6, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_L_WRITE( v, wv )                 FIELD_SET( v, 6, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_L_READ( wv )                      FIELD_GET( wv, 5, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_L_WRITE( v, wv )                  FIELD_SET( v, 5, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 0, 5, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 0, 5, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 5, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 5, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_L_READ( wv )                            FIELD_GET( wv, 0, 5 )
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_L_WRITE( v, wv )                        FIELD_SET( v, 0, 5, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_L_READ( wv )                    FIELD_GET( wv, 22, 10 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_L_WRITE( v, wv )                FIELD_SET( v, 22, 10, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_L_READ( wv )                      FIELD_GET( wv, 21, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_L_WRITE( v, wv )                  FIELD_SET( v, 21, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 4, 14, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 4, 14, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_L_READ( wv )                        FIELD_GET( wv, 14, 7 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_L_WRITE( v, wv )                    FIELD_SET( v, 14, 7, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_L_READ( wv )                 FIELD_GET( wv, 0, 14 )
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_L_WRITE( v, wv )             FIELD_SET( v, 0, 14, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_L_READ( wv )                          FIELD_GET( wv, 31, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_L_WRITE( v, wv )                      FIELD_SET( v, 31, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_L_READ( wv )                  FIELD_GET( wv, 30, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_L_WRITE( v, wv )              FIELD_SET( v, 30, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_BCST_UNION_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 3, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_BCST_UNION_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 3, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_BCST_UNION_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 3, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_BCST_UNION_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 3, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_BCST_UNION_L_READ( wv )               FIELD_GET( wv, 27, 3 )
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_BCST_UNION_L_WRITE( v, wv )           FIELD_SET( v, 27, 3, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_L_READ( wv )                    FIELD_GET( wv, 28, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_L_WRITE( v, wv )                FIELD_SET( v, 28, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_L_READ( wv )                  FIELD_GET( wv, 27, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_L_WRITE( v, wv )              FIELD_SET( v, 27, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_PACKET_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_PACKET_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_PACKET_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_PACKET_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_PACKET_L_READ( wv )                   FIELD_GET( wv, 29, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_MCST_PACKET_L_WRITE( v, wv )               FIELD_SET( v, 29, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BCST_PACKET_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BCST_PACKET_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BCST_PACKET_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BCST_PACKET_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BCST_PACKET_L_READ( wv )                   FIELD_GET( wv, 28, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BCST_PACKET_L_WRITE( v, wv )               FIELD_SET( v, 28, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR__INGRESS_CONG_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR__INGRESS_CONG_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR__INGRESS_CONG_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR__INGRESS_CONG_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR__INGRESS_CONG_L_READ( wv )                 FIELD_GET( wv, 27, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR__INGRESS_CONG_L_WRITE( v, wv )             FIELD_SET( v, 27, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 3, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 3, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 3, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 3, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_L_READ( wv )                     FIELD_GET( wv, 27, 3 )
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_L_WRITE( v, wv )                 FIELD_SET( v, 27, 3, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_L_READ( wv )                           FIELD_GET( wv, 26, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_L_WRITE( v, wv )                       FIELD_SET( v, 26, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_READ_G(r, g, idx)             GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_READ(r, p)                    FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_WRITE(v, p)                   FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_L_READ( wv )                  FIELD_GET( wv, 18, 8 )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_L_WRITE( v, wv )              FIELD_SET( v, 18, 8, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_L_READ( wv )                          FIELD_GET( wv, 18, 8 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_L_WRITE( v, wv )                      FIELD_SET( v, 18, 8, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)              GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                     FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                    FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_L_READ( wv )                   FIELD_GET( wv, 18, 8 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_L_WRITE( v, wv )               FIELD_SET( v, 18, 8, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 8, 0, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 8, 0, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_L_READ( wv )                      FIELD_GET( wv, 24, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_L_WRITE( v, wv )                  FIELD_SET( v, 24, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 9, 2, 6, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 9, 2, 6, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 6, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 6, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_L_READ( wv )                     FIELD_GET( wv, 18, 6 )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_L_WRITE( v, wv )                 FIELD_SET( v, 18, 6, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_L_READ( wv )                      FIELD_GET( wv, 25, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_L_WRITE( v, wv )                  FIELD_SET( v, 25, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_READ(r, p)                         FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_WRITE(v, p)                        FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_L_READ( wv )                       FIELD_GET( wv, 18, 7 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_L_WRITE( v, wv )                   FIELD_SET( v, 18, 7, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_L_READ( wv )                        FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_L_WRITE( v, wv )                    FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_L_READ( wv )                     FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_L_WRITE( v, wv )                 FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS3_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS3_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS3_READ(r, p)                            FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS3_WRITE(v, p)                           FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS3_L_READ( wv )                          FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS3_L_WRITE( v, wv )                      FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_L_READ( wv )                     FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_L_WRITE( v, wv )                 FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_L_READ( wv )                        FIELD_GET( wv, 31, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_L_WRITE( v, wv )                    FIELD_SET( v, 31, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_L_READ( wv )                  FIELD_GET( wv, 30, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_L_WRITE( v, wv )              FIELD_SET( v, 30, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_L_READ( wv )                           FIELD_GET( wv, 29, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_L_WRITE( v, wv )                       FIELD_SET( v, 29, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_G(r, g, idx)  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_G(v, g, idx) GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ(r, p)         FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE(v, p)        FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_L_READ( wv )       FIELD_GET( wv, 18, 11 )
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_L_WRITE( v, wv )   FIELD_SET( v, 18, 11, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_READ(r, p)                             FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_WRITE(v, p)                            FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_L_READ( wv )                           FIELD_GET( wv, 18, 11 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_L_WRITE( v, wv )                       FIELD_SET( v, 18, 11, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_READ(r, p)                         FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                        FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_L_READ( wv )                       FIELD_GET( wv, 18, 11 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_L_WRITE( v, wv )                   FIELD_SET( v, 18, 11, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS1_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS1_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS1_L_READ( wv )                          FIELD_GET( wv, 18, 11 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS1_L_WRITE( v, wv )                      FIELD_SET( v, 18, 11, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_G(r, g, idx) GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_G(v, g, idx)GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ(r, p)        FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE(v, p)       FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_L_READ( wv )      FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_L_WRITE( v, wv )  FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_L_READ( wv )                     FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_L_WRITE( v, wv )                 FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_L_READ( wv )                        FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_L_WRITE( v, wv )                    FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_L_READ( wv )                   FIELD_GET( wv, 16, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_L_WRITE( v, wv )               FIELD_SET( v, 16, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                      MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_L_READ( wv )                    FIELD_GET( wv, 0, 16 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_L_WRITE( v, wv )                FIELD_SET( v, 0, 16, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS0_READ(r, p)                            FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS0_WRITE(v, p)                           FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS0_L_READ( wv )                          FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS0_L_WRITE( v, wv )                      FIELD_SET( v, 0, 18, wv )
/* <<<PROCESSING_TX_DESCRIPTOR_STRUCT */


#define RDD_DS_TM_PD_FIFO_TABLE_SIZE     320
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_PD_FIFO_TABLE_PTR(core_id)	( DS_TM_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_PD_FIFO_TABLE */


/* >>>G9991_PD_FIFO_TABLE */

#define RDD_G9991_PD_FIFO_TABLE_SIZE     64
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_G9991_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_G9991_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_PD_FIFO_TABLE_PTR(core_id)	( G9991_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<G9991_PD_FIFO_TABLE */


/* >>>DS_TM_SCHEDULING_QUEUE_TABLE */

/* >>>SCHEDULING_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	prefetch_pd           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropped_recently	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_index       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	block_type            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_enable          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropping        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_index       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	queue_bit_mask        	;
        uint8_t	rate_limiter_index    	;
        uint8_t	quantum_number        	;
        uint16_t	deficit_counter       	;
#else
        uint8_t	queue_bit_mask        	;
        uint32_t	scheduler_index       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropping        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_enable          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	block_type            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_index       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropped_recently	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	prefetch_pd           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	deficit_counter       	;
        uint8_t	quantum_number        	;
        uint8_t	rate_limiter_index    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) SCHEDULING_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 0, 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 0, 6, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 5, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 5, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 4, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 4, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 0, 7, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 0, 7, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 7, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 7, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_READ(r, p)                         MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_READ(r, p)                     MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 5, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 5, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_READ(r, p)                         MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_READ(r, p)                        MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<SCHEDULING_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_DS_TM_SCHEDULING_QUEUE_TABLE_SIZE     160
typedef struct
{
	SCHEDULING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_SCHEDULING_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_SCHEDULING_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_SCHEDULING_QUEUE_TABLE_PTR(core_id)	( DS_TM_SCHEDULING_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_SCHEDULING_QUEUE_TABLE */


/* >>>DS_TM_TM_FLOW_CNTR_TABLE */

/* >>>TM_FLOW_CNTR_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	cntr_id   	;
#else
        uint8_t	cntr_id   	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TM_FLOW_CNTR_ENTRY_STRUCT;

#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(TM_FLOW_CNTR_ENTRY_STRUCT), (r))
#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(TM_FLOW_CNTR_ENTRY_STRUCT), (v))
#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<TM_FLOW_CNTR_ENTRY_STRUCT */


#define RDD_DS_TM_TM_FLOW_CNTR_TABLE_SIZE     128
typedef struct
{
	TM_FLOW_CNTR_ENTRY_STRUCT	entry[ RDD_DS_TM_TM_FLOW_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_TM_FLOW_CNTR_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_TM_FLOW_CNTR_TABLE_PTR(core_id)	( DS_TM_TM_FLOW_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_TM_FLOW_CNTR_TABLE */


/* >>>G9991_SCHEDULING_INFO_TABLE */

/* >>>G9991_SCHEDULING_INFO_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	control_sid          	;
        uint32_t	physical_port_mapping	;
        uint16_t	last_served_sid      	;
        uint16_t	drr_counter_address  	;
        uint32_t	reserved             	;
#else
        uint32_t	control_sid          	;
        uint32_t	physical_port_mapping	;
        uint16_t	drr_counter_address  	;
        uint16_t	last_served_sid      	;
        uint32_t	reserved             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) G9991_SCHEDULING_INFO_ENTRY_STRUCT;

#define RDD_G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT), (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT), (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_READ(r, p)                           MREAD_32((uint8_t *)(p), (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_WRITE(v, p)                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT) + 4, (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT) + 4, (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT) + 8, (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT) + 8, (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_READ(r, p)                       MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_READ_G(r, g, idx)            GROUP_MREAD_16((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT) + 10, (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_WRITE_G(v, g, idx)           GROUP_MWRITE_16((g), (idx)*sizeof(G9991_SCHEDULING_INFO_ENTRY_STRUCT) + 10, (v))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_READ(r, p)                   MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_WRITE(v, p)                  MWRITE_16((uint8_t *)(p) + 10, (v))
/* <<<G9991_SCHEDULING_INFO_ENTRY_STRUCT */


#define RDD_G9991_SCHEDULING_INFO_TABLE_SIZE     6
typedef struct
{
	G9991_SCHEDULING_INFO_ENTRY_STRUCT	entry[ RDD_G9991_SCHEDULING_INFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_SCHEDULING_INFO_TABLE_STRUCT;

extern uint32_t RDD_G9991_SCHEDULING_INFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_SCHEDULING_INFO_TABLE_PTR(core_id)	( G9991_SCHEDULING_INFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_SCHEDULING_INFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<G9991_SCHEDULING_INFO_TABLE */


/* >>>G9991_SID_TO_BB_ID */

/* >>>G9991_SID_TO_BB_ID_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	bb_id     	;
#else
        uint8_t	bb_id     	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} G9991_SID_TO_BB_ID_ENTRY_STRUCT;

#define RDD_G9991_SID_TO_BB_ID_ENTRY_BB_ID_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_SID_TO_BB_ID_ENTRY_STRUCT), (r))
#define RDD_G9991_SID_TO_BB_ID_ENTRY_BB_ID_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_SID_TO_BB_ID_ENTRY_STRUCT), (v))
#define RDD_G9991_SID_TO_BB_ID_ENTRY_BB_ID_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_G9991_SID_TO_BB_ID_ENTRY_BB_ID_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<G9991_SID_TO_BB_ID_ENTRY_STRUCT */


#define RDD_G9991_SID_TO_BB_ID_SIZE     32
typedef struct
{
	G9991_SID_TO_BB_ID_ENTRY_STRUCT	entry[ RDD_G9991_SID_TO_BB_ID_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_SID_TO_BB_ID_STRUCT;

extern uint32_t RDD_G9991_SID_TO_BB_ID_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_SID_TO_BB_ID_PTR(core_id)	( G9991_SID_TO_BB_ID_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_SID_TO_BB_ID_ADDRESS_ARR[core_id] ))

/* <<<G9991_SID_TO_BB_ID */


/* >>>BASIC_SCHEDULER_TABLE_DS */

/* >>>BASIC_SCHEDULER_DESCRIPTOR_STRUCT */
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_NUMBER	8
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	rate_limit_enable                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_exists                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset                                                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_index_2                                                   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	slot_budget_bit_vector                                           	;
        uint32_t	parent_index_1                                                   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	last_served_queue                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	status_bit_vector                                                	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_index                                                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint8_t	reservedSU1_slot_budget_bit_vector                                         	;
        uint32_t	complex_scheduler_slot_index                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	reservedSU1_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_status_bit_vector                                              	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_msb                                                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	ovl_rl_en                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	reserved1                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint8_t	reservedSU2_slot_budget_bit_vector                                         	;
        uint32_t	is_positive_budget                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	bbh_queue_lsb                                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	reservedSU2_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_status_bit_vector                                              	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	rate_limiter_index                                               	;
        uint8_t	quantum_number                                                   	;
        uint16_t	deficit_counter                                                  	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	queue_index[RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_NUMBER];
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	status_bit_vector                                                	;
        uint32_t	last_served_queue                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_index_1                                                   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	slot_budget_bit_vector                                           	;
        uint32_t	parent_index_2                                                   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	dwrr_offset                                                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_exists                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_status_bit_vector                                              	;
        uint32_t	reservedSU1_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_slot_index                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint8_t	reservedSU1_slot_budget_bit_vector                                         	;
        uint32_t	complex_scheduler_index                                                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	reservedSU1_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_status_bit_vector                                              	;
        uint32_t	reservedSU2_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_lsb                                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	is_positive_budget                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint8_t	reservedSU2_slot_budget_bit_vector                                         	;
        uint32_t	reserved1                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	ovl_rl_en                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	bbh_queue_msb                                                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	reservedSU2_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	deficit_counter                                                  	;
        uint8_t	quantum_number                                                   	;
        uint8_t	rate_limiter_index                                               	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	queue_index[RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_NUMBER];
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BASIC_SCHEDULER_DESCRIPTOR_STRUCT;

#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 4, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 4, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p), 4, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p), 4, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 2, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 2, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p), 2, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p), 2, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_READ(r, p)                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 0, 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 0, 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ_G(r, g, idx)                     GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE_G(v, g, idx)                    GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ(r, p)                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE(v, p)                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ_G(r, g, idx)                    GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE_G(v, g, idx)                   GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ(r, p)                           MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE(v, p)                          MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ(r, p)                               MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ(r, p)                              MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_READ_G(r, g, idx, i)                        GROUP_MREAD_I_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 8, i, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_WRITE_G(v, g, idx, i)                       GROUP_MWRITE_I_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 8, i, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_READ(r, p, i)                               MREAD_I_8((uint8_t *)(p) + 8, i, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_WRITE(v, p, i)                              MWRITE_I_8((uint8_t *)(p) + 8, i, (v))
/* <<<BASIC_SCHEDULER_DESCRIPTOR_STRUCT */


#define RDD_BASIC_SCHEDULER_TABLE_DS_SIZE     32
typedef struct
{
	BASIC_SCHEDULER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_SCHEDULER_TABLE_DS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_SCHEDULER_TABLE_DS_STRUCT;

extern uint32_t RDD_BASIC_SCHEDULER_TABLE_DS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_SCHEDULER_TABLE_DS_PTR(core_id)	( BASIC_SCHEDULER_TABLE_DS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_SCHEDULER_TABLE_DS_ADDRESS_ARR[core_id] ))

/* <<<BASIC_SCHEDULER_TABLE_DS */


/* >>>BASIC_RATE_LIMITER_TABLE_DS */

/* >>>BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rl_type       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2     	:21	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	block_type    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	block_index   	;
        uint32_t	current_budget	;
        uint32_t	alloc_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved      	;
#else
        uint8_t	block_index   	;
        uint32_t	block_type    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2     	:21	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rl_type       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	current_budget	;
        uint32_t	limit_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT;

#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 2, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 2, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_READ(r, p)                    MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 10, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 10, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 2, (v))
/* <<<BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT */


#define RDD_BASIC_RATE_LIMITER_TABLE_DS_SIZE     128
typedef struct
{
	BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_RATE_LIMITER_TABLE_DS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_RATE_LIMITER_TABLE_DS_STRUCT;

extern uint32_t RDD_BASIC_RATE_LIMITER_TABLE_DS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_RATE_LIMITER_TABLE_DS_PTR(core_id)	( BASIC_RATE_LIMITER_TABLE_DS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_RATE_LIMITER_TABLE_DS_ADDRESS_ARR[core_id] ))

/* <<<BASIC_RATE_LIMITER_TABLE_DS */


/* >>>VLAN_TX_COUNTERS */

/* >>>PACKETS_AND_BYTES_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	packets   	;
        uint32_t	bytes     	;
#else
        uint32_t	packets   	;
        uint32_t	bytes     	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PACKETS_AND_BYTES_STRUCT;

#define RDD_PACKETS_AND_BYTES_PACKETS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT), (r))
#define RDD_PACKETS_AND_BYTES_PACKETS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT), (v))
#define RDD_PACKETS_AND_BYTES_PACKETS_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_PACKETS_AND_BYTES_PACKETS_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_PACKETS_AND_BYTES_BYTES_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT) + 4, (r))
#define RDD_PACKETS_AND_BYTES_BYTES_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT) + 4, (v))
#define RDD_PACKETS_AND_BYTES_BYTES_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PACKETS_AND_BYTES_BYTES_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<PACKETS_AND_BYTES_STRUCT */


#define RDD_VLAN_TX_COUNTERS_SIZE     257
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_VLAN_TX_COUNTERS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VLAN_TX_COUNTERS_STRUCT;

extern uint32_t RDD_VLAN_TX_COUNTERS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VLAN_TX_COUNTERS_PTR(core_id)	( VLAN_TX_COUNTERS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VLAN_TX_COUNTERS_ADDRESS_ARR[core_id] ))

/* <<<VLAN_TX_COUNTERS */


/* >>>DBG_DUMP_TABLE */

/* >>>BYTES_4_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bits      	;
#else
        uint32_t	bits      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) BYTES_4_STRUCT;

#define RDD_BYTES_4_BITS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(BYTES_4_STRUCT), (r))
#define RDD_BYTES_4_BITS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(BYTES_4_STRUCT), (v))
#define RDD_BYTES_4_BITS_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_BYTES_4_BITS_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
/* <<<BYTES_4_STRUCT */


#define RDD_DBG_DUMP_TABLE_SIZE     128
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DBG_DUMP_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DBG_DUMP_TABLE_STRUCT;

extern uint32_t RDD_DBG_DUMP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DBG_DUMP_TABLE_PTR(core_id)	( DBG_DUMP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DBG_DUMP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DBG_DUMP_TABLE */


/* >>>G9991_FIFO_POINTER_VECTOR */

/* >>>G9991_FIFO_POINTER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	ingress_vector	;
        uint32_t	egress_vector 	;
#else
        uint32_t	ingress_vector	;
        uint32_t	egress_vector 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) G9991_FIFO_POINTER_ENTRY_STRUCT;

#define RDD_G9991_FIFO_POINTER_ENTRY_INGRESS_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(G9991_FIFO_POINTER_ENTRY_STRUCT), (r))
#define RDD_G9991_FIFO_POINTER_ENTRY_INGRESS_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(G9991_FIFO_POINTER_ENTRY_STRUCT), (v))
#define RDD_G9991_FIFO_POINTER_ENTRY_INGRESS_VECTOR_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_G9991_FIFO_POINTER_ENTRY_INGRESS_VECTOR_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_G9991_FIFO_POINTER_ENTRY_EGRESS_VECTOR_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(G9991_FIFO_POINTER_ENTRY_STRUCT) + 4, (r))
#define RDD_G9991_FIFO_POINTER_ENTRY_EGRESS_VECTOR_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(G9991_FIFO_POINTER_ENTRY_STRUCT) + 4, (v))
#define RDD_G9991_FIFO_POINTER_ENTRY_EGRESS_VECTOR_READ(r, p)                  MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_G9991_FIFO_POINTER_ENTRY_EGRESS_VECTOR_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<G9991_FIFO_POINTER_ENTRY_STRUCT */


#define RDD_G9991_FIFO_POINTER_VECTOR_SIZE     1
typedef struct
{
	G9991_FIFO_POINTER_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FIFO_POINTER_VECTOR_STRUCT;

extern uint32_t RDD_G9991_FIFO_POINTER_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FIFO_POINTER_VECTOR_PTR(core_id)	( G9991_FIFO_POINTER_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FIFO_POINTER_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<G9991_FIFO_POINTER_VECTOR */


/* >>>G9991_FLOW_CONTROL_PD */

/* >>>PROCESSING_RX_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pd_info           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	fragment_type               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	options                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	reserved0                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	ctrl_key_index              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	ctrl_fragment_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	sfc                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	reserved1                   	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	g9991_tci_sof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_eof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_const             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_sid_1_0           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint8_t	g9991_tci_sid_9_2           	; /* Member of pd_info union */
        uint16_t	g9991_length_time           	; /* Member of pd_info union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	timestamp                   	; /* Member of pd_info union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	serial_num        	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ploam             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	error             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_port      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	bn1_last_or_abs1  	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                        	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	bn1_last                    	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	abs1                        	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_port    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	bn1_last_truncated          	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_or_xdsl       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	error_type_or_cpu_tx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buf_sop           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buffer_number_0   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_xdsl union */
        uint32_t	error_type                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	sop                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buf_sop union */
        uint32_t	bn0_first                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	xdsl                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_xdsl union */
        uint32_t	is_loopback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	cpu_tx                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	g9991_system_port           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reserved2                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	sop_fpm                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buf_sop union */
        uint32_t	bn_fpm_pool                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
        uint16_t	bn_fpm_num                  	; /* Member of buffer_number_0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs_or_xdsl     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_error_type_or_cpu_tx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_buf_sop         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_fpm                      	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pd_info           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reserved0                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	options                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	fragment_type               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                   	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	sfc                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	ctrl_fragment_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	ctrl_key_index              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 3 */
		struct{
        uint16_t	g9991_length_time           	; /* Member of pd_info union */
        uint8_t	g9991_tci_sid_9_2           	; /* Member of pd_info union */
        uint32_t	g9991_tci_sid_1_0           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_const             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_eof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_sof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	timestamp                   	; /* Member of pd_info union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ploam             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	serial_num        	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_last_or_abs1  	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ingress_port      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	error             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_last                    	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	flow                        	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU1_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs1                        	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	source_port                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU2_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	bn1_last_truncated          	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	ssid                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	reservedSU3_ingress_port    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buf_sop           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	error_type_or_cpu_tx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs_or_xdsl       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn0_first                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
        uint32_t	sop                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buf_sop union */
        uint32_t	error_type                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	abs                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_xdsl union */
        uint32_t	reservedSU1_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint16_t	bn_fpm_num                  	; /* Member of buffer_number_0 union */
        uint32_t	bn_fpm_pool                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
        uint32_t	sop_fpm                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buf_sop union */
        uint32_t	reserved2                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	g9991_system_port           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	cpu_tx                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	is_loopback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	xdsl                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_xdsl union */
        uint32_t	reservedSU2_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	bn_fpm                      	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0 union */
        uint32_t	reservedSU3_buf_sop         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_error_type_or_cpu_tx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs_or_xdsl     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PROCESSING_RX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_READ(r, p)                            MREAD_32((uint8_t *)(p), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_WRITE(v, p)                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 11, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 11, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_READ(r, p)                            FIELD_MREAD_32((uint8_t *)(p), 11, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_WRITE(v, p)                           FIELD_MWRITE_32((uint8_t *)(p), 11, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 3, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 3, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_READ(r, p)                                FIELD_MREAD_16((uint8_t *)(p), 3, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_WRITE(v, p)                               FIELD_MWRITE_16((uint8_t *)(p), 3, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 2, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 2, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 2, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 2, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 0, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 0, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 0, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 0, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_READ(r, p)                  MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_WRITE(v, p)                 MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_READ(r, p)                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_READ(r, p)                          MREAD_32((uint8_t *)(p), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_WRITE(v, p)                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_READ(r, p)                         FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_WRITE(v, p)                        FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_READ(r, p)                             FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_WRITE(v, p)                            FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_READ(r, p)                               FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_WRITE(v, p)                              FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                        FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                       FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_READ_G(r, g, idx)            GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_READ(r, p)                   FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_WRITE(v, p)                  FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_READ(r, p)                           FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_WRITE(v, p)                          FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_READ(r, p)                               FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_WRITE(v, p)                              FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_READ(r, p)                               FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_WRITE(v, p)                              FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_XDSL_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_XDSL_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_XDSL_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_XDSL_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_READ_G(r, g, idx)        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 1, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_WRITE_G(v, g, idx)       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 1, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_READ(r, p)               FIELD_MREAD_8((uint8_t *)(p) + 12, 1, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_WRITE(v, p)              FIELD_MWRITE_8((uint8_t *)(p) + 12, 1, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 1, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 1, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 12, 1, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 12, 1, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_IS_LOOPBACK_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 4, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_IS_LOOPBACK_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 4, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_IS_LOOPBACK_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 12, 4, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_IS_LOOPBACK_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 12, 4, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 12, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 12, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_SYSTEM_PORT_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_SYSTEM_PORT_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_SYSTEM_PORT_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 12, 2, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_SYSTEM_PORT_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 12, 2, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUF_SOP_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUF_SOP_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUF_SOP_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUF_SOP_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_READ(r, p)                                FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_WRITE(v, p)                               FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 2, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUFFER_NUMBER_0_READ_G(r, g, idx)             GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUFFER_NUMBER_0_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUFFER_NUMBER_0_READ(r, p)                    FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BUFFER_NUMBER_0_WRITE(v, p)                   FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                         MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_READ(r, p)                             FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_WRITE(v, p)                            FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
/* <<<PROCESSING_RX_DESCRIPTOR_STRUCT */


#define RDD_G9991_FLOW_CONTROL_PD_SIZE     1
typedef struct
{
	PROCESSING_RX_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FLOW_CONTROL_PD_STRUCT;

extern uint32_t RDD_G9991_FLOW_CONTROL_PD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FLOW_CONTROL_PD_PTR(core_id)	( G9991_FLOW_CONTROL_PD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FLOW_CONTROL_PD_ADDRESS_ARR[core_id] ))

/* <<<G9991_FLOW_CONTROL_PD */


/* >>>RUNNER_GLOBAL_REGISTERS_INIT */

#define RDD_RUNNER_GLOBAL_REGISTERS_INIT_SIZE     8
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_RUNNER_GLOBAL_REGISTERS_INIT_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RUNNER_GLOBAL_REGISTERS_INIT_STRUCT;

extern uint32_t RDD_RUNNER_GLOBAL_REGISTERS_INIT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RUNNER_GLOBAL_REGISTERS_INIT_PTR(core_id)	( RUNNER_GLOBAL_REGISTERS_INIT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RUNNER_GLOBAL_REGISTERS_INIT_ADDRESS_ARR[core_id] ))

/* <<<RUNNER_GLOBAL_REGISTERS_INIT */


/* >>>DS_TM_BBH_TX_WAKE_UP_DATA_TABLE */

/* >>>BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_in_bbh	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	queue       	;
        uint32_t	reserved1   	;
#else
        uint8_t	queue       	;
        uint32_t	bytes_in_bbh	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1   	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT;

#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT), 8, 19, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT), 8, 19, (v))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p), 8, 19, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p), 8, 19, (v))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_READ_G(r, g, idx)                 GROUP_MREAD_8((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT) + 3, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_WRITE_G(v, g, idx)                GROUP_MWRITE_8((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT) + 3, (v))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_READ(r, p)                        MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_WRITE(v, p)                       MWRITE_8((uint8_t *)(p) + 3, (v))
/* <<<BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT */


#define RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_SIZE     8
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry[ RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_PTR(core_id)	( DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BBH_TX_WAKE_UP_DATA_TABLE */


/* >>>DS_TM_BBH_TX_EGRESS_COUNTER_TABLE */

/* >>>BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	counter   	;
        uint32_t	reserved0 	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1 	;
#else
        uint32_t	reserved0 	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	counter   	;
        uint32_t	reserved1 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT;

#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT), (r))
#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT), (v))
#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_READ(r, p)                   MREAD_8((uint8_t *)(p), (r))
#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_WRITE(v, p)                  MWRITE_8((uint8_t *)(p), (v))
/* <<<BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT */


#define RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_SIZE     8
typedef struct
{
	BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT	entry[ RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_PTR(core_id)	( DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BBH_TX_EGRESS_COUNTER_TABLE */


/* >>>G9991_FLOW_CONTROL_DRR */

/* >>>BYTES_2_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	bits      	;
#else
        uint16_t	bits      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) BYTES_2_STRUCT;

#define RDD_BYTES_2_BITS_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(BYTES_2_STRUCT), (r))
#define RDD_BYTES_2_BITS_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(BYTES_2_STRUCT), (v))
#define RDD_BYTES_2_BITS_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_BYTES_2_BITS_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<BYTES_2_STRUCT */


#define RDD_G9991_FLOW_CONTROL_DRR_SIZE     32
typedef struct
{
	BYTES_2_STRUCT	entry[ RDD_G9991_FLOW_CONTROL_DRR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FLOW_CONTROL_DRR_STRUCT;

extern uint32_t RDD_G9991_FLOW_CONTROL_DRR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FLOW_CONTROL_DRR_PTR(core_id)	( G9991_FLOW_CONTROL_DRR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FLOW_CONTROL_DRR_ADDRESS_ARR[core_id] ))

/* <<<G9991_FLOW_CONTROL_DRR */


/* >>>G9991_FIFO_DESCRIPTOR_TABLE */

/* >>>G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	remaining_bytes	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	not_sof        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	not_sof        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	remaining_bytes	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT;

#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_REMAINING_BYTES_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT), 1, 15, (r))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_REMAINING_BYTES_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT), 1, 15, (v))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_REMAINING_BYTES_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 1, 15, (r))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_REMAINING_BYTES_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 1, 15, (v))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_NOT_SOF_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT) + 1, 0, 1, (r))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_NOT_SOF_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT) + 1, 0, 1, (v))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_NOT_SOF_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_G9991_FIFO_DESCRIPTOR_ENTRY_NOT_SOF_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
/* <<<G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT */


#define RDD_G9991_FIFO_DESCRIPTOR_TABLE_SIZE     32
typedef struct
{
	G9991_FIFO_DESCRIPTOR_ENTRY_STRUCT	entry[ RDD_G9991_FIFO_DESCRIPTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FIFO_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_G9991_FIFO_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FIFO_DESCRIPTOR_TABLE_PTR(core_id)	( G9991_FIFO_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FIFO_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<G9991_FIFO_DESCRIPTOR_TABLE */


/* >>>REGISTERS_BUFFER */

#define RDD_REGISTERS_BUFFER_SIZE     32
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_REGISTERS_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REGISTERS_BUFFER_STRUCT;

extern uint32_t RDD_REGISTERS_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REGISTERS_BUFFER_PTR(core_id)	( REGISTERS_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REGISTERS_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<REGISTERS_BUFFER */


/* >>>UPDATE_FIFO_TABLE */

/* >>>UPDATE_FIFO_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pd_fifo_write_ptr	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	queue_number     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	queue_number     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pd_fifo_write_ptr	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) UPDATE_FIFO_ENTRY_STRUCT;

#define RDD_UPDATE_FIFO_ENTRY_VALID_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 7, 1, (r))
#define RDD_UPDATE_FIFO_ENTRY_VALID_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 7, 1, (v))
#define RDD_UPDATE_FIFO_ENTRY_VALID_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_UPDATE_FIFO_ENTRY_VALID_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 0, 14, (r))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 0, 14, (v))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 14, (r))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 14, (v))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT) + 2, 0, 9, (r))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT) + 2, 0, 9, (v))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
/* <<<UPDATE_FIFO_ENTRY_STRUCT */


#define RDD_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_UPDATE_FIFO_TABLE_PTR(core_id)	( UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<UPDATE_FIFO_TABLE */


/* >>>DS_TM_SCHEDULING_QUEUE_AGING_VECTOR */

#define RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT;

extern uint32_t RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_PTR(core_id)	( DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_SCHEDULING_QUEUE_AGING_VECTOR */


/* >>>G9991_NOT_FULL_VECTOR */

#define RDD_G9991_NOT_FULL_VECTOR_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_NOT_FULL_VECTOR_STRUCT;

extern uint32_t RDD_G9991_NOT_FULL_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_NOT_FULL_VECTOR_PTR(core_id)	( G9991_NOT_FULL_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_NOT_FULL_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<G9991_NOT_FULL_VECTOR */


/* >>>G9991_FLOW_CONTROL_PACKET_HEDAER */

/* >>>BYTES_8_STRUCT */
#define RDD_BYTES_8_BITS_NUMBER	2
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bits[RDD_BYTES_8_BITS_NUMBER];
#else
        uint32_t	bits[RDD_BYTES_8_BITS_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BYTES_8_STRUCT;

#define RDD_BYTES_8_BITS_READ_G(r, g, idx, i)       GROUP_MREAD_I_32((g), (idx)*sizeof(BYTES_8_STRUCT), i, (r))
#define RDD_BYTES_8_BITS_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_32((g), (idx)*sizeof(BYTES_8_STRUCT), i, (v))
#define RDD_BYTES_8_BITS_READ(r, p, i)              MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_BYTES_8_BITS_WRITE(v, p, i)             MWRITE_I_32((uint8_t *)(p), i, (v))
/* <<<BYTES_8_STRUCT */


#define RDD_G9991_FLOW_CONTROL_PACKET_HEDAER_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FLOW_CONTROL_PACKET_HEDAER_STRUCT;

extern uint32_t RDD_G9991_FLOW_CONTROL_PACKET_HEDAER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FLOW_CONTROL_PACKET_HEDAER_PTR(core_id)	( G9991_FLOW_CONTROL_PACKET_HEDAER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FLOW_CONTROL_PACKET_HEDAER_ADDRESS_ARR[core_id] ))

/* <<<G9991_FLOW_CONTROL_PACKET_HEDAER */


/* >>>COMPLEX_SCHEDULER_TABLE */

/* >>>COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT */
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RESERVED3_NUMBER	3
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_NUMBER	32
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_positive_budget                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue                                                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limiter_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_pir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_sir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	last_served_block_pir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	last_served_block_sir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	status_bit_vector                                                   	;
        uint32_t	slot_budget_bit_vector_0                                            	;
        uint32_t	slot_budget_bit_vector_1                                            	;
        uint32_t	is_scheduler_slot                                                   	;
        uint32_t	is_scheduler_basic                                                  	;
        uint32_t	ovl_rl_en                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_exists                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_index                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_slot_index                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                           	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	deficit_counter                                                     	;
        uint8_t	quantum_number                                                      	;
        uint8_t	reserved3[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RESERVED3_NUMBER];
        uint8_t	block_index[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_NUMBER];
#else
        uint32_t	last_served_block_sir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	last_served_block_pir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_sir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_pir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limiter_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue                                                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_positive_budget                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	status_bit_vector                                                   	;
        uint32_t	slot_budget_bit_vector_0                                            	;
        uint32_t	slot_budget_bit_vector_1                                            	;
        uint32_t	is_scheduler_slot                                                   	;
        uint32_t	is_scheduler_basic                                                  	;
        uint16_t	deficit_counter                                                     	;
        uint32_t	reserved2                                                           	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_slot_index                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_index                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_exists                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ovl_rl_en                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved3[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RESERVED3_NUMBER];
        uint8_t	quantum_number                                                      	;
        uint8_t	block_index[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT;

#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 0, 6, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 0, 6, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 1, 0, 7, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 1, 0, 7, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 7, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 7, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 2, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 2, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 2, 5, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 2, 5, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 3, 0, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 3, 0, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ(r, p)                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_READ(r, p)                    MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_READ(r, p)                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 16, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 16, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_READ(r, p)                           MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 20, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 20, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_READ(r, p)                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 7, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 7, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 24, 7, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 24, 7, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 24, 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 24, 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 5, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 5, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 24, 5, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 24, 5, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 1, 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 1, 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 24, 1, 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 24, 1, 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 4, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 4, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 24, 4, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 24, 4, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 26, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 26, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ(r, p)                             MREAD_16((uint8_t *)(p) + 26, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 26, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 28, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 28, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ(r, p)                              MREAD_8((uint8_t *)(p) + 28, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE(v, p)                             MWRITE_8((uint8_t *)(p) + 28, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_READ_G(r, g, idx, i)                       GROUP_MREAD_I_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 32, i, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_WRITE_G(v, g, idx, i)                      GROUP_MWRITE_I_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 32, i, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_READ(r, p, i)                              MREAD_I_8((uint8_t *)(p) + 32, i, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_WRITE(v, p, i)                             MWRITE_I_8((uint8_t *)(p) + 32, i, (v))
/* <<<COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT */


#define RDD_COMPLEX_SCHEDULER_TABLE_SIZE     16
typedef struct
{
	COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT	entry[ RDD_COMPLEX_SCHEDULER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ COMPLEX_SCHEDULER_TABLE_STRUCT;

extern uint32_t RDD_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_COMPLEX_SCHEDULER_TABLE_PTR(core_id)	( COMPLEX_SCHEDULER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<COMPLEX_SCHEDULER_TABLE */


/* >>>RUNNER_PROFILING_TRACE_BUFFER */

/* >>>TRACE_EVENT_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	timestamp              	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	event_id               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	trace_event_info       	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	incoming_task_num                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reserved                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	task_pc                          	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	incoming_bbhrx_src_addr          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_rd                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr_reply                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	ramrd                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	parser                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhtx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_async                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_sync                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	cpu                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw_self                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	timer                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	acc_type                         	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	trace_event_info       	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	event_id               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	timestamp              	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	task_pc                          	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reserved                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	incoming_task_num                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reservedSU1_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	timer                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw_self                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	cpu                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_sync                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_async                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhtx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	parser                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	ramrd                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr_reply                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_rd                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	incoming_bbhrx_src_addr          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reservedSU2_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	acc_type                         	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reserved2                        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reservedSU3_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) TRACE_EVENT_STRUCT;

#define RDD_TRACE_EVENT_TIMESTAMP_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT), 4, 12, (r))
#define RDD_TRACE_EVENT_TIMESTAMP_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT), 4, 12, (v))
#define RDD_TRACE_EVENT_TIMESTAMP_READ(r, p)                               FIELD_MREAD_16((uint8_t *)(p), 4, 12, (r))
#define RDD_TRACE_EVENT_TIMESTAMP_WRITE(v, p)                              FIELD_MWRITE_16((uint8_t *)(p), 4, 12, (v))
#define RDD_TRACE_EVENT_EVENT_ID_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 1, 2, 2, (r))
#define RDD_TRACE_EVENT_EVENT_ID_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 1, 2, 2, (v))
#define RDD_TRACE_EVENT_EVENT_ID_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 2, (r))
#define RDD_TRACE_EVENT_EVENT_ID_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 2, (v))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 0, 18, (r))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 0, 18, (v))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_READ(r, p)                        FIELD_MREAD_32((uint8_t *)(p) + 0, 0, 18, (r))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_WRITE(v, p)                       FIELD_MWRITE_32((uint8_t *)(p) + 0, 0, 18, (v))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 14, 4, (r))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 14, 4, (v))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 0, 14, 4, (r))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 0, 14, 4, (v))
#define RDD_TRACE_EVENT_TASK_PC_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 13, (r))
#define RDD_TRACE_EVENT_TASK_PC_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 13, (v))
#define RDD_TRACE_EVENT_TASK_PC_READ(r, p)                                 FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 13, (r))
#define RDD_TRACE_EVENT_TASK_PC_WRITE(v, p)                                FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 13, (v))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 12, 6, (r))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 12, 6, (v))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p) + 0, 12, 6, (r))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p) + 0, 12, 6, (v))
#define RDD_TRACE_EVENT_DMA_WR_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 3, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 3, 1, (v))
#define RDD_TRACE_EVENT_DMA_WR_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 1, (v))
#define RDD_TRACE_EVENT_DMA_RD_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 2, 1, (r))
#define RDD_TRACE_EVENT_DMA_RD_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 2, 1, (v))
#define RDD_TRACE_EVENT_DMA_RD_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 1, (r))
#define RDD_TRACE_EVENT_DMA_RD_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 1, (v))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 1, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 1, 1, (v))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 1, (v))
#define RDD_TRACE_EVENT_RAMRD_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 1, (r))
#define RDD_TRACE_EVENT_RAMRD_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 1, (v))
#define RDD_TRACE_EVENT_RAMRD_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_TRACE_EVENT_RAMRD_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_TRACE_EVENT_PARSER_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 7, 1, (r))
#define RDD_TRACE_EVENT_PARSER_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 7, 1, (v))
#define RDD_TRACE_EVENT_PARSER_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r))
#define RDD_TRACE_EVENT_PARSER_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v))
#define RDD_TRACE_EVENT_BBHTX_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 6, 1, (r))
#define RDD_TRACE_EVENT_BBHTX_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 6, 1, (v))
#define RDD_TRACE_EVENT_BBHTX_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_TRACE_EVENT_BBHTX_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 5, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 5, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_SYNC_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 4, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_SYNC_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 4, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_SYNC_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 3, 4, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_SYNC_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 3, 4, 1, (v))
#define RDD_TRACE_EVENT_CPU_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 3, 1, (r))
#define RDD_TRACE_EVENT_CPU_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 3, 1, (v))
#define RDD_TRACE_EVENT_CPU_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 3, 3, 1, (r))
#define RDD_TRACE_EVENT_CPU_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 3, 3, 1, (v))
#define RDD_TRACE_EVENT_FW_SELF_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 2, 1, (r))
#define RDD_TRACE_EVENT_FW_SELF_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 2, 1, (v))
#define RDD_TRACE_EVENT_FW_SELF_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 1, (r))
#define RDD_TRACE_EVENT_FW_SELF_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 1, (v))
#define RDD_TRACE_EVENT_FW_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 1, 1, (r))
#define RDD_TRACE_EVENT_FW_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 1, 1, (v))
#define RDD_TRACE_EVENT_FW_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_TRACE_EVENT_FW_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
#define RDD_TRACE_EVENT_TIMER_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 0, 1, (r))
#define RDD_TRACE_EVENT_TIMER_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 0, 1, (v))
#define RDD_TRACE_EVENT_TIMER_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 1, (r))
#define RDD_TRACE_EVENT_TIMER_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 1, (v))
#define RDD_TRACE_EVENT_ACC_TYPE_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 12, (r))
#define RDD_TRACE_EVENT_ACC_TYPE_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 12, (v))
#define RDD_TRACE_EVENT_ACC_TYPE_READ(r, p)                                FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 12, (r))
#define RDD_TRACE_EVENT_ACC_TYPE_WRITE(v, p)                               FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 12, (v))
/* <<<TRACE_EVENT_STRUCT */


#define RDD_RUNNER_PROFILING_TRACE_BUFFER_SIZE     128
typedef struct
{
	TRACE_EVENT_STRUCT	entry[ RDD_RUNNER_PROFILING_TRACE_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RUNNER_PROFILING_TRACE_BUFFER_STRUCT;

extern uint32_t RDD_RUNNER_PROFILING_TRACE_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RUNNER_PROFILING_TRACE_BUFFER_PTR(core_id)	( RUNNER_PROFILING_TRACE_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RUNNER_PROFILING_TRACE_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<RUNNER_PROFILING_TRACE_BUFFER */


/* >>>DS_TM_BBH_QUEUE_TABLE */

/* >>>BBH_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	wan_type_union 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	mirroring_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_type 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bb_destination 	;
        uint8_t	ingress_counter	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	hw_bbh_qid               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
        uint32_t	reservedSU1_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_bb_destination	;
        uint8_t	reservedSU1_ingress_counter	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved                 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
        uint32_t	reservedSU2_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_bb_destination	;
        uint8_t	reservedSU2_ingress_counter	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	ingress_counter	;
        uint8_t	bb_destination 	;
        uint32_t	scheduler_type 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_type_union 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_ingress_counter	;
        uint8_t	reservedSU1_bb_destination	;
        uint32_t	reservedSU1_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_bbh_qid               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_ingress_counter	;
        uint8_t	reservedSU2_bb_destination	;
        uint32_t	reservedSU2_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) BBH_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 1, 7, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 1, 7, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 1, 7, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 1, 7, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_READ(r, p)                  MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_WRITE(v, p)                 MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_READ(r, p)                 MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 3, (v))
/* <<<BBH_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_DS_TM_BBH_QUEUE_TABLE_SIZE     40
typedef struct
{
	BBH_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_BBH_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BBH_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BBH_QUEUE_TABLE_PTR(core_id)	( DS_TM_BBH_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BBH_QUEUE_TABLE */


/* >>>DEBUG_SCRATCHPAD */

#define RDD_DEBUG_SCRATCHPAD_SIZE     12
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DEBUG_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEBUG_SCRATCHPAD_STRUCT;

extern uint32_t RDD_DEBUG_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEBUG_SCRATCHPAD_PTR(core_id)	( DEBUG_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEBUG_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<DEBUG_SCRATCHPAD */


/* >>>DS_TM_FLUSH_CFG_CPU_TABLE */

/* >>>FLUSH_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pd_num            	;
        uint8_t	flush_aggr        	;
        uint8_t	qm_queue          	;
        uint32_t	ug_counter_address	;
        uint16_t	reserved1         	;
        uint16_t	ug_threshold_low  	;
        uint32_t	ug_counter        	;
#else
        uint8_t	qm_queue          	;
        uint8_t	flush_aggr        	;
        uint8_t	pd_num            	;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ug_counter_address	;
        uint16_t	ug_threshold_low  	;
        uint16_t	reserved1         	;
        uint32_t	ug_counter        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FLUSH_CFG_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ(r, p)                             MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ(r, p)                         MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ_G(r, g, idx)                    GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE_G(v, g, idx)                   GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ(r, p)                           MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE(v, p)                          MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ_G(r, g, idx)            GROUP_MREAD_16((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 10, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE_G(v, g, idx)           GROUP_MWRITE_16((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 10, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ(r, p)                   MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE(v, p)                  MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ(r, p)                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<FLUSH_CFG_ENTRY_STRUCT */


#define RDD_DS_TM_FLUSH_CFG_CPU_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_CPU_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_CPU_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_CPU_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_CPU_TABLE */


/* >>>DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR */

#define RDD_DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_STRUCT;

extern uint32_t RDD_DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_PTR(core_id)	( DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR */


/* >>>G9991_SYSTEM_PORT_BBH_CFG_TABLE */

/* >>>G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	bbh_tx_id 	;
        uint16_t	bbh_id    	;
#else
        uint16_t	bbh_id    	;
        uint16_t	bbh_tx_id 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT;

#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_TX_ID_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT), (r))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_TX_ID_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT), (v))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_TX_ID_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_TX_ID_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_ID_READ_G(r, g, idx)             GROUP_MREAD_16((g), (idx)*sizeof(G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_ID_WRITE_G(v, g, idx)            GROUP_MWRITE_16((g), (idx)*sizeof(G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_ID_READ(r, p)                    MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_G9991_SYSTEM_PORT_BBH_CFG_ENTRY_BBH_ID_WRITE(v, p)                   MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT */


#define RDD_G9991_SYSTEM_PORT_BBH_CFG_TABLE_SIZE     1
typedef struct
{
	G9991_SYSTEM_PORT_BBH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_SYSTEM_PORT_BBH_CFG_TABLE_STRUCT;

extern uint32_t RDD_G9991_SYSTEM_PORT_BBH_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_SYSTEM_PORT_BBH_CFG_TABLE_PTR(core_id)	( G9991_SYSTEM_PORT_BBH_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_SYSTEM_PORT_BBH_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<G9991_SYSTEM_PORT_BBH_CFG_TABLE */


/* >>>GENERAL_QUEUE_DYNAMIC_MNG_TABLE */

/* >>>QUEUE_DYNAMIC_MNG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	qm_queue_us_start  	;
        uint8_t	qm_queue_us_end    	;
        uint8_t	qm_queue_ds_start  	;
        uint8_t	qm_queue_ds_end    	;
        uint8_t	qm_queue_epon_start	;
        uint8_t	qm_queue_sq_start  	;
        uint16_t	reserved           	;
#else
        uint8_t	qm_queue_ds_end    	;
        uint8_t	qm_queue_ds_start  	;
        uint8_t	qm_queue_us_end    	;
        uint8_t	qm_queue_us_start  	;
        uint16_t	reserved           	;
        uint8_t	qm_queue_sq_start  	;
        uint8_t	qm_queue_epon_start	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) QUEUE_DYNAMIC_MNG_ENTRY_STRUCT;

#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT), (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT), (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_READ(r, p)                   MREAD_8((uint8_t *)(p), (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_WRITE(v, p)                  MWRITE_8((uint8_t *)(p), (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 1, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 1, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_READ(r, p)                     MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 2, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 2, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_READ(r, p)                   MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 3, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 3, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_READ(r, p)                     MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 4, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 4, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_READ(r, p)                 MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 5, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 5, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_READ(r, p)                   MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 5, (v))
/* <<<QUEUE_DYNAMIC_MNG_ENTRY_STRUCT */


#define RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_SIZE     1
typedef struct
{
	QUEUE_DYNAMIC_MNG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GENERAL_QUEUE_DYNAMIC_MNG_TABLE_STRUCT;

extern uint32_t RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_PTR(core_id)	( GENERAL_QUEUE_DYNAMIC_MNG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<GENERAL_QUEUE_DYNAMIC_MNG_TABLE */


/* >>>NATC_TBL_CFG */

/* >>>NATC_TBL_CONFIGURATION_STRUCT */
#define RDD_NATC_TBL_CONFIGURATION_RESERVED1_NUMBER	4
typedef union
{
    uint32_t word_32[6];
    uint64_t dword_64[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	key_addr_low                                             	;
        uint32_t	key_addr_high                                            	;
        uint32_t	res_addr_low                                             	;
        uint32_t	res_addr_high                                            	;
        uint32_t	reserved                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	miss_cache_enable                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	key_size                                                 	;
        uint8_t	context_size                                             	;
        uint8_t	reserved0                                                	;
        uint8_t	reserved1[RDD_NATC_TBL_CONFIGURATION_RESERVED1_NUMBER];
#else
        uint32_t	key_addr_low                                             	;
        uint32_t	key_addr_high                                            	;
        uint32_t	res_addr_low                                             	;
        uint32_t	res_addr_high                                            	;
        uint8_t	reserved0                                                	;
        uint8_t	context_size                                             	;
        uint8_t	key_size                                                 	;
        uint32_t	miss_cache_enable                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1[RDD_NATC_TBL_CONFIGURATION_RESERVED1_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NATC_TBL_CONFIGURATION_STRUCT;

#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT), (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT), (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p), (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p), (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 4, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 4, (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_READ(r, p)                     MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 8, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 8, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 12, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 12, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_READ(r, p)                     MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 16, 0, 1, (r))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 16, 0, 1, (v))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 16, 0, 1, (r))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 16, 0, 1, (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_READ_G(r, g, idx)                   GROUP_MREAD_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 17, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_WRITE_G(v, g, idx)                  GROUP_MWRITE_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 17, (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_READ(r, p)                          MREAD_8((uint8_t *)(p) + 17, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_WRITE(v, p)                         MWRITE_8((uint8_t *)(p) + 17, (v))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 18, (r))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 18, (v))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_READ(r, p)                      MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 18, (v))
/* <<<NATC_TBL_CONFIGURATION_STRUCT */


#define RDD_NATC_TBL_CFG_SIZE     2
typedef struct
{
	NATC_TBL_CONFIGURATION_STRUCT	entry[ RDD_NATC_TBL_CFG_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ NATC_TBL_CFG_STRUCT;

extern uint32_t RDD_NATC_TBL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NATC_TBL_CFG_PTR(core_id)	( NATC_TBL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NATC_TBL_CFG_ADDRESS_ARR[core_id] ))

/* <<<NATC_TBL_CFG */


/* >>>DS_TM_FLUSH_CFG_FW_TABLE */

#define RDD_DS_TM_FLUSH_CFG_FW_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_FW_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_FW_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_FW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_FW_TABLE */


/* >>>DS_TM_FLUSH_CFG_CURRENT_TABLE */

#define RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_CURRENT_TABLE */


/* >>>DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE */

#define RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE */


/* >>>G9991_FLOW_CONTROL_DRR_DUMMY */

#define RDD_G9991_FLOW_CONTROL_DRR_DUMMY_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FLOW_CONTROL_DRR_DUMMY_STRUCT;

extern uint32_t RDD_G9991_FLOW_CONTROL_DRR_DUMMY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FLOW_CONTROL_DRR_DUMMY_PTR(core_id)	( G9991_FLOW_CONTROL_DRR_DUMMY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FLOW_CONTROL_DRR_DUMMY_ADDRESS_ARR[core_id] ))

/* <<<G9991_FLOW_CONTROL_DRR_DUMMY */


/* >>>TM_ERROR_DEBUG_COUNTER */

#define RDD_TM_ERROR_DEBUG_COUNTER_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TM_ERROR_DEBUG_COUNTER_STRUCT;

extern uint32_t RDD_TM_ERROR_DEBUG_COUNTER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TM_ERROR_DEBUG_COUNTER_PTR(core_id)	( TM_ERROR_DEBUG_COUNTER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TM_ERROR_DEBUG_COUNTER_ADDRESS_ARR[core_id] ))

/* <<<TM_ERROR_DEBUG_COUNTER */


/* >>>RATE_LIMITER_VALID_TABLE_DS */

#define RDD_RATE_LIMITER_VALID_TABLE_DS_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_RATE_LIMITER_VALID_TABLE_DS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RATE_LIMITER_VALID_TABLE_DS_STRUCT;

extern uint32_t RDD_RATE_LIMITER_VALID_TABLE_DS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RATE_LIMITER_VALID_TABLE_DS_PTR(core_id)	( RATE_LIMITER_VALID_TABLE_DS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RATE_LIMITER_VALID_TABLE_DS_ADDRESS_ARR[core_id] ))

/* <<<RATE_LIMITER_VALID_TABLE_DS */


/* >>>TX_MIRRORING_DISPATCHER_CREDIT_TABLE */

#define RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_MIRRORING_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( TX_MIRRORING_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TX_MIRRORING_DISPATCHER_CREDIT_TABLE */


/* >>>G9991_BBH_TX_BYTES_FIFO_SIZE */

#define RDD_G9991_BBH_TX_BYTES_FIFO_SIZE_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_BBH_TX_BYTES_FIFO_SIZE_STRUCT;

extern uint32_t RDD_G9991_BBH_TX_BYTES_FIFO_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_BBH_TX_BYTES_FIFO_SIZE_PTR(core_id)	( G9991_BBH_TX_BYTES_FIFO_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_BBH_TX_BYTES_FIFO_SIZE_ADDRESS_ARR[core_id] ))

/* <<<G9991_BBH_TX_BYTES_FIFO_SIZE */


/* >>>G9991_NOT_EMPTY_VECTOR */

/* >>>G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	vector           	;
        uint8_t	last_served_sid_0	;
        uint8_t	last_served_sid_1	;
        uint8_t	last_served_sid_2	;
        uint8_t	last_served_sid_3	;
        uint8_t	last_served_sid_4	;
#else
        uint32_t	vector           	;
        uint8_t	last_served_sid_3	;
        uint8_t	last_served_sid_2	;
        uint8_t	last_served_sid_1	;
        uint8_t	last_served_sid_0	;
        uint8_t	last_served_sid_4	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT;

#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_VECTOR_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT), (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_VECTOR_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT), (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_VECTOR_READ(r, p)                            MREAD_32((uint8_t *)(p), (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_VECTOR_WRITE(v, p)                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_0_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 4, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_0_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 4, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_0_READ(r, p)                 MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_0_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_1_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 5, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_1_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 5, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_1_READ(r, p)                 MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_1_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_2_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 6, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_2_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 6, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_2_READ(r, p)                 MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_2_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_3_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 7, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_3_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 7, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_3_READ(r, p)                 MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_3_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 7, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_4_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 8, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_4_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT) + 8, (v))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_4_READ(r, p)                 MREAD_8((uint8_t *)(p) + 8, (r))
#define RDD_G9991_NOT_EMPTY_VECTOR_ENTRY_LAST_SERVED_SID_4_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 8, (v))
/* <<<G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT */


#define RDD_G9991_NOT_EMPTY_VECTOR_SIZE     1
typedef struct
{
	G9991_NOT_EMPTY_VECTOR_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_NOT_EMPTY_VECTOR_STRUCT;

extern uint32_t RDD_G9991_NOT_EMPTY_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_NOT_EMPTY_VECTOR_PTR(core_id)	( G9991_NOT_EMPTY_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_NOT_EMPTY_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<G9991_NOT_EMPTY_VECTOR */


/* >>>G9991_SINGLE_FRAGMENT_CFG_TABLE */

/* >>>G9991_SINGLE_FRAGMENT_CFG_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	enable    	;
#else
        uint8_t	enable    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} G9991_SINGLE_FRAGMENT_CFG_ENTRY_STRUCT;

#define RDD_G9991_SINGLE_FRAGMENT_CFG_ENTRY_ENABLE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(G9991_SINGLE_FRAGMENT_CFG_ENTRY_STRUCT), (r))
#define RDD_G9991_SINGLE_FRAGMENT_CFG_ENTRY_ENABLE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(G9991_SINGLE_FRAGMENT_CFG_ENTRY_STRUCT), (v))
#define RDD_G9991_SINGLE_FRAGMENT_CFG_ENTRY_ENABLE_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_G9991_SINGLE_FRAGMENT_CFG_ENTRY_ENABLE_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<G9991_SINGLE_FRAGMENT_CFG_ENTRY_STRUCT */


#define RDD_G9991_SINGLE_FRAGMENT_CFG_TABLE_SIZE     1
typedef struct
{
	G9991_SINGLE_FRAGMENT_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_SINGLE_FRAGMENT_CFG_TABLE_STRUCT;

extern uint32_t RDD_G9991_SINGLE_FRAGMENT_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_SINGLE_FRAGMENT_CFG_TABLE_PTR(core_id)	( G9991_SINGLE_FRAGMENT_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_SINGLE_FRAGMENT_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<G9991_SINGLE_FRAGMENT_CFG_TABLE */


/* >>>BUDGET_ALLOCATION_TIMER_VALUE */

#define RDD_BUDGET_ALLOCATION_TIMER_VALUE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BUDGET_ALLOCATION_TIMER_VALUE_STRUCT;

extern uint32_t RDD_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BUDGET_ALLOCATION_TIMER_VALUE_PTR(core_id)	( BUDGET_ALLOCATION_TIMER_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[core_id] ))

/* <<<BUDGET_ALLOCATION_TIMER_VALUE */


/* >>>TASK_IDX */

#define RDD_TASK_IDX_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TASK_IDX_STRUCT;

extern uint32_t RDD_TASK_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TASK_IDX_PTR(core_id)	( TASK_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TASK_IDX_ADDRESS_ARR[core_id] ))

/* <<<TASK_IDX */


/* >>>FPM_GLOBAL_CFG */

/* >>>FPM_GLOBAL_CFG_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint16_t	fpm_token_size     	;
        uint8_t	fpm_token_shift    	;
        uint8_t	fpm_token_add_shift	;
        uint16_t	fpm_token_inv_mant 	;
        uint8_t	fpm_token_inv_exp  	;
        uint8_t	reserved1          	;
#else
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint8_t	fpm_token_add_shift	;
        uint8_t	fpm_token_shift    	;
        uint16_t	fpm_token_size     	;
        uint8_t	reserved1          	;
        uint8_t	fpm_token_inv_exp  	;
        uint16_t	fpm_token_inv_mant 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FPM_GLOBAL_CFG_STRUCT;

#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ_G(r, g, idx)                 GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE_G(v, g, idx)                GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ(r, p)                        MREAD_32((uint8_t *)(p), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE(v, p)                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ(r, p)                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ(r, p)                      MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ(r, p)                     MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ(r, p)                 MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ(r, p)                  MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ(r, p)                   MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 14, (v))
/* <<<FPM_GLOBAL_CFG_STRUCT */


#define RDD_FPM_GLOBAL_CFG_SIZE     1
typedef struct
{
	FPM_GLOBAL_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ FPM_GLOBAL_CFG_TABLE_STRUCT;

extern uint32_t RDD_FPM_GLOBAL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FPM_GLOBAL_CFG_PTR(core_id)	( FPM_GLOBAL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FPM_GLOBAL_CFG_ADDRESS_ARR[core_id] ))

/* <<<FPM_GLOBAL_CFG */


/* >>>NULL_BUFFER */

#define RDD_NULL_BUFFER_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ NULL_BUFFER_STRUCT;

extern uint32_t RDD_NULL_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NULL_BUFFER_PTR(core_id)	( NULL_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NULL_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<NULL_BUFFER */


/* >>>MIRRORING_SCRATCH */

#define RDD_MIRRORING_SCRATCH_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MIRRORING_SCRATCH_STRUCT;

extern uint32_t RDD_MIRRORING_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MIRRORING_SCRATCH_PTR(core_id)	( MIRRORING_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MIRRORING_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<MIRRORING_SCRATCH */


/* >>>DEBUG_PRINT_TABLE */

/* >>>DEBUG_PRINT_INFO_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	addr_low  	;
        uint32_t	addr_high 	;
        uint32_t	size      	;
        uint8_t	table_id  	;
        uint32_t	reserved  	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	addr_low  	;
        uint32_t	addr_high 	;
        uint32_t	size      	;
        uint32_t	reserved  	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	table_id  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DEBUG_PRINT_INFO_STRUCT;

#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_L_READ( wv )                FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_L_WRITE( v, wv )            FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_L_READ( wv )               FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_L_WRITE( v, wv )           FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_SIZE_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (r))
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (v))
#define RDD_DEBUG_PRINT_INFO_SIZE_READ(r, p)                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_DEBUG_PRINT_INFO_SIZE_L_READ( wv )                    FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_SIZE_L_WRITE( v, wv )                FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (r))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (v))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ(r, p)                  MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE(v, p)                 MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_L_READ( wv )                FIELD_GET( wv, 24, 8 )
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_L_WRITE( v, wv )            FIELD_SET( v, 24, 8, wv )
/* <<<DEBUG_PRINT_INFO_STRUCT */


#define RDD_DEBUG_PRINT_TABLE_SIZE     1
typedef struct
{
	DEBUG_PRINT_INFO_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEBUG_PRINT_TABLE_STRUCT;

extern uint32_t RDD_DEBUG_PRINT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEBUG_PRINT_TABLE_PTR(core_id)	( DEBUG_PRINT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEBUG_PRINT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DEBUG_PRINT_TABLE */


/* >>>G9991_PHYS_PORT_BB_ID_TABLE */

/* >>>BYTE_1_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	bits      	;
#else
        uint8_t	bits      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} BYTE_1_STRUCT;

#define RDD_BYTE_1_BITS_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(BYTE_1_STRUCT), (r))
#define RDD_BYTE_1_BITS_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(BYTE_1_STRUCT), (v))
#define RDD_BYTE_1_BITS_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_BYTE_1_BITS_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<BYTE_1_STRUCT */


#define RDD_G9991_PHYS_PORT_BB_ID_TABLE_SIZE     6
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_G9991_PHYS_PORT_BB_ID_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_PHYS_PORT_BB_ID_TABLE_STRUCT;

extern uint32_t RDD_G9991_PHYS_PORT_BB_ID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_PHYS_PORT_BB_ID_TABLE_PTR(core_id)	( G9991_PHYS_PORT_BB_ID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_PHYS_PORT_BB_ID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<G9991_PHYS_PORT_BB_ID_TABLE */


/* >>>BBH_TX_DS_FIFO_BYTES_THRESHOLD */

#define RDD_BBH_TX_DS_FIFO_BYTES_THRESHOLD_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_DS_FIFO_BYTES_THRESHOLD_STRUCT;

extern uint32_t RDD_BBH_TX_DS_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_DS_FIFO_BYTES_THRESHOLD_PTR(core_id)	( BBH_TX_DS_FIFO_BYTES_THRESHOLD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_DS_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_DS_FIFO_BYTES_THRESHOLD */


/* >>>G9991_FLOW_CONTROL_VECTOR */

#define RDD_G9991_FLOW_CONTROL_VECTOR_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ G9991_FLOW_CONTROL_VECTOR_STRUCT;

extern uint32_t RDD_G9991_FLOW_CONTROL_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_G9991_FLOW_CONTROL_VECTOR_PTR(core_id)	( G9991_FLOW_CONTROL_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_G9991_FLOW_CONTROL_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<G9991_FLOW_CONTROL_VECTOR */


/* >>>SCHEDULING_FLUSH_GLOBAL_CFG */

#define RDD_SCHEDULING_FLUSH_GLOBAL_CFG_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SCHEDULING_FLUSH_GLOBAL_CFG_STRUCT;

extern uint32_t RDD_SCHEDULING_FLUSH_GLOBAL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SCHEDULING_FLUSH_GLOBAL_CFG_PTR(core_id)	( SCHEDULING_FLUSH_GLOBAL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SCHEDULING_FLUSH_GLOBAL_CFG_ADDRESS_ARR[core_id] ))

/* <<<SCHEDULING_FLUSH_GLOBAL_CFG */


/* >>>TM_VLAN_STATS_ENABLE */

#define RDD_TM_VLAN_STATS_ENABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TM_VLAN_STATS_ENABLE_STRUCT;

extern uint32_t RDD_TM_VLAN_STATS_ENABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TM_VLAN_STATS_ENABLE_PTR(core_id)	( TM_VLAN_STATS_ENABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TM_VLAN_STATS_ENABLE_ADDRESS_ARR[core_id] ))

/* <<<TM_VLAN_STATS_ENABLE */


/* >>>TX_EXCEPTION */

/* >>>TX_EXCEPTION_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved1   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dbg_stat_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	vlan_cntr_en	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	vlan_cntr_en	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dbg_stat_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TX_EXCEPTION_ENTRY_STRUCT;

#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
/* <<<TX_EXCEPTION_ENTRY_STRUCT */


#define RDD_TX_EXCEPTION_SIZE     1
typedef struct
{
	TX_EXCEPTION_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_EXCEPTION_STRUCT;

extern uint32_t RDD_TX_EXCEPTION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_EXCEPTION_PTR(core_id)	( TX_EXCEPTION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_EXCEPTION_ADDRESS_ARR[core_id] ))

/* <<<TX_EXCEPTION */


/* >>>CORE_ID_TABLE */

#define RDD_CORE_ID_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CORE_ID_TABLE_STRUCT;

extern uint32_t RDD_CORE_ID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CORE_ID_TABLE_PTR(core_id)	( CORE_ID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CORE_ID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CORE_ID_TABLE */


/* >>>PENDING_VECTOR */

/* >>>G9991_PENDING_VECTOR_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	vector    	;
#else
        uint32_t	vector    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) G9991_PENDING_VECTOR_ENTRY_STRUCT;

#define RDD_G9991_PENDING_VECTOR_ENTRY_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(G9991_PENDING_VECTOR_ENTRY_STRUCT), (r))
#define RDD_G9991_PENDING_VECTOR_ENTRY_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(G9991_PENDING_VECTOR_ENTRY_STRUCT), (v))
#define RDD_G9991_PENDING_VECTOR_ENTRY_VECTOR_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_G9991_PENDING_VECTOR_ENTRY_VECTOR_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
/* <<<G9991_PENDING_VECTOR_ENTRY_STRUCT */


#define RDD_PENDING_VECTOR_SIZE     1
typedef struct
{
	G9991_PENDING_VECTOR_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PENDING_VECTOR_STRUCT;

extern uint32_t RDD_PENDING_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PENDING_VECTOR_PTR(core_id)	( PENDING_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PENDING_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<PENDING_VECTOR */


/* >>>TX_MIRRORING_CONFIGURATION */

/* >>>MIRRORING_DESCRIPTOR_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	mirror_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_vport 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_queue 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	dst_queue 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_vport 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	mirror_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) MIRRORING_DESCRIPTOR_STRUCT;

#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 1, 6, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 1, 6, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
/* <<<MIRRORING_DESCRIPTOR_STRUCT */


#define RDD_TX_MIRRORING_CONFIGURATION_SIZE     1
typedef struct
{
	MIRRORING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_MIRRORING_CONFIGURATION_STRUCT;

extern uint32_t RDD_TX_MIRRORING_CONFIGURATION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_MIRRORING_CONFIGURATION_PTR(core_id)	( TX_MIRRORING_CONFIGURATION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_MIRRORING_CONFIGURATION_ADDRESS_ARR[core_id] ))

/* <<<TX_MIRRORING_CONFIGURATION */


/* >>>DS_TM_FLUSH_AGGREGATION_TASK_DISABLE */

#define RDD_DS_TM_FLUSH_AGGREGATION_TASK_DISABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_AGGREGATION_TASK_DISABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_AGGREGATION_TASK_DISABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_AGGREGATION_TASK_DISABLE_PTR(core_id)	( DS_TM_FLUSH_AGGREGATION_TASK_DISABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_AGGREGATION_TASK_DISABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_AGGREGATION_TASK_DISABLE */


/* >>>DS_TM_FIRST_QUEUE_MAPPING */

#define RDD_DS_TM_FIRST_QUEUE_MAPPING_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FIRST_QUEUE_MAPPING_STRUCT;

extern uint32_t RDD_DS_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FIRST_QUEUE_MAPPING_PTR(core_id)	( DS_TM_FIRST_QUEUE_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FIRST_QUEUE_MAPPING */


/* >>>DS_TM_FLUSH_CFG_ENABLE_TABLE */

/* >>>FLUSH_CFG_ENABLE_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	enable_fw 	;
        uint8_t	enable_cpu	;
#else
        uint8_t	enable_cpu	;
        uint8_t	enable_fw 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) FLUSH_CFG_ENABLE_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ(r, p)                  MREAD_8((uint8_t *)(p), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE(v, p)                 MWRITE_8((uint8_t *)(p), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<FLUSH_CFG_ENABLE_ENTRY_STRUCT */


#define RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENABLE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_ENABLE_TABLE */


/* >>>SRAM_DUMMY_STORE */

#define RDD_SRAM_DUMMY_STORE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SRAM_DUMMY_STORE_STRUCT;

extern uint32_t RDD_SRAM_DUMMY_STORE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SRAM_DUMMY_STORE_PTR(core_id)	( SRAM_DUMMY_STORE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SRAM_DUMMY_STORE_ADDRESS_ARR[core_id] ))

/* <<<SRAM_DUMMY_STORE */


/* >>>RATE_LIMIT_OVERHEAD */

#define RDD_RATE_LIMIT_OVERHEAD_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RATE_LIMIT_OVERHEAD_STRUCT;

extern uint32_t RDD_RATE_LIMIT_OVERHEAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RATE_LIMIT_OVERHEAD_PTR(core_id)	( RATE_LIMIT_OVERHEAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RATE_LIMIT_OVERHEAD_ADDRESS_ARR[core_id] ))

/* <<<RATE_LIMIT_OVERHEAD */


/* >>>BACKUP_BBH_INGRESS_COUNTERS_TABLE */

#define RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BACKUP_BBH_INGRESS_COUNTERS_TABLE_STRUCT;

extern uint32_t RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_PTR(core_id)	( BACKUP_BBH_INGRESS_COUNTERS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BACKUP_BBH_INGRESS_COUNTERS_TABLE */


/* >>>BACKUP_BBH_EGRESS_COUNTERS_TABLE */

#define RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BACKUP_BBH_EGRESS_COUNTERS_TABLE_STRUCT;

extern uint32_t RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_PTR(core_id)	( BACKUP_BBH_EGRESS_COUNTERS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BACKUP_BBH_EGRESS_COUNTERS_TABLE */


/* >>>DEBUG_PRINT_CORE_LOCK */

#define RDD_DEBUG_PRINT_CORE_LOCK_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEBUG_PRINT_CORE_LOCK_STRUCT;

extern uint32_t RDD_DEBUG_PRINT_CORE_LOCK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEBUG_PRINT_CORE_LOCK_PTR(core_id)	( DEBUG_PRINT_CORE_LOCK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEBUG_PRINT_CORE_LOCK_ADDRESS_ARR[core_id] ))

/* <<<DEBUG_PRINT_CORE_LOCK */

/* CORE_1 */

/* >>>CPU_RECYCLE_SRAM_PD_FIFO */

#define RDD_CPU_RECYCLE_SRAM_PD_FIFO_SIZE     16
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_CPU_RECYCLE_SRAM_PD_FIFO_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_SRAM_PD_FIFO_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_SRAM_PD_FIFO_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_SRAM_PD_FIFO_PTR(core_id)	( CPU_RECYCLE_SRAM_PD_FIFO_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_SRAM_PD_FIFO_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_SRAM_PD_FIFO */


/* >>>DS_CPU_RX_METER_TABLE */

/* >>>CPU_RX_METER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	current_budget  	;
        uint16_t	budget_limit    	;
        uint16_t	allocated_budget	;
        uint8_t	budget_residue  	;
        uint8_t	current_cycle   	;
#else
        uint16_t	budget_limit    	;
        uint16_t	current_budget  	;
        uint8_t	current_cycle   	;
        uint8_t	budget_residue  	;
        uint16_t	allocated_budget	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_RX_METER_ENTRY_STRUCT;

#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_G(r, g, idx)            GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_G(v, g, idx)           GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ(r, p)                   MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE(v, p)                  MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ(r, p)                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ(r, p)                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ(r, p)                   MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ(r, p)                    MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RX_METER_ENTRY_STRUCT */


#define RDD_DS_CPU_RX_METER_TABLE_SIZE     32
typedef struct
{
	CPU_RX_METER_ENTRY_STRUCT	entry[ RDD_DS_CPU_RX_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_CPU_RX_METER_TABLE_STRUCT;

extern uint32_t RDD_DS_CPU_RX_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_CPU_RX_METER_TABLE_PTR(core_id)	( DS_CPU_RX_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_CPU_RX_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_CPU_RX_METER_TABLE */


/* >>>CPU_RX_SCRATCHPAD */

#define RDD_CPU_RX_SCRATCHPAD_SIZE     64
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_RX_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_RX_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_SCRATCHPAD_PTR(core_id)	( CPU_RX_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_SCRATCHPAD */


/* >>>US_CPU_RX_METER_TABLE */

#define RDD_US_CPU_RX_METER_TABLE_SIZE     32
typedef struct
{
	CPU_RX_METER_ENTRY_STRUCT	entry[ RDD_US_CPU_RX_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_CPU_RX_METER_TABLE_STRUCT;

extern uint32_t RDD_US_CPU_RX_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_CPU_RX_METER_TABLE_PTR(core_id)	( US_CPU_RX_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_CPU_RX_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_CPU_RX_METER_TABLE */


/* >>>CPU_RING_INTERRUPT_COUNTER_TABLE */

/* >>>CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	counter   	;
        uint32_t	max_size  	;
#else
        uint32_t	counter   	;
        uint32_t	max_size  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT;

#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT */


#define RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_SIZE     18
typedef struct
{
	CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT	entry[ RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RING_INTERRUPT_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_PTR(core_id)	( CPU_RING_INTERRUPT_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RING_INTERRUPT_COUNTER_TABLE */


/* >>>CPU_RECYCLE_INTERRUPT_COALESCING_TABLE */

/* >>>CPU_INTERRUPT_COALESCING_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	timer_period        	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	not_empty_or_int_vec	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	not_empty                     	; /* Member of not_empty_or_int_vec union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	int_vec                       	; /* Member of not_empty_or_int_vec union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	scratch             	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	recycle_timer_cnt   	;
        uint16_t	recycle_timer_factor	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	timer_period        	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	not_empty_or_int_vec	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	not_empty                     	; /* Member of not_empty_or_int_vec union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	int_vec                       	; /* Member of not_empty_or_int_vec union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	scratch             	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	recycle_timer_factor	;
        uint16_t	recycle_timer_cnt   	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_INTERRUPT_COALESCING_ENTRY_STRUCT;

#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT), (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT), (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_READ(r, p)                         MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_WRITE(v, p)                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_READ(r, p)                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_READ(r, p)                              MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 8, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 8, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_READ(r, p)                              MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_READ_G(r, g, idx)             GROUP_MREAD_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 12, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_WRITE_G(v, g, idx)            GROUP_MWRITE_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 12, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_READ(r, p)                    MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_WRITE(v, p)                   MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 14, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 14, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_READ(r, p)                 MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<CPU_INTERRUPT_COALESCING_ENTRY_STRUCT */


#define RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_SIZE     1
typedef struct
{
	CPU_INTERRUPT_COALESCING_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_PTR(core_id)	( CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_INTERRUPT_COALESCING_TABLE */


/* >>>DS_CPU_REASON_TO_METER_TABLE */

#define RDD_DS_CPU_REASON_TO_METER_TABLE_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DS_CPU_REASON_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_CPU_REASON_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_DS_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_CPU_REASON_TO_METER_TABLE_PTR(core_id)	( DS_CPU_REASON_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_CPU_REASON_TO_METER_TABLE */


/* >>>CPU_RX_COPY_PD_FIFO_TABLE */

#define RDD_CPU_RX_COPY_PD_FIFO_TABLE_SIZE     8
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_CPU_RX_COPY_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_PD_FIFO_TABLE_PTR(core_id)	( CPU_RX_COPY_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_PD_FIFO_TABLE */


/* >>>CPU_FEED_RING_CACHE_TABLE */

#define RDD_CPU_FEED_RING_CACHE_TABLE_SIZE     16
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_FEED_RING_CACHE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_CACHE_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_CACHE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_CACHE_TABLE_PTR(core_id)	( CPU_FEED_RING_CACHE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_CACHE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_CACHE_TABLE */


/* >>>CPU_REASON_AND_VPORT_TO_METER_TABLE */

#define RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_SIZE     120
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_REASON_AND_VPORT_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_PTR(core_id)	( CPU_REASON_AND_VPORT_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_REASON_AND_VPORT_TO_METER_TABLE */


/* >>>CSO_CONTEXT_TABLE */

/* >>>CSO_CONTEXT_ENTRY_STRUCT */
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER	14
typedef union
{
    uint32_t word_32[27];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved                                                     	;
        uint16_t	csum_value                                                   	;
        uint16_t	cam_result                                                   	;
        uint32_t	crc_result                                                   	;
        uint32_t	saved_ret_address                                            	;
        uint32_t	saved_pkt_desc_0                                             	;
        uint32_t	saved_pkt_desc_1                                             	;
        uint32_t	saved_pkt_desc_2                                             	;
        uint32_t	saved_pkt_desc_3                                             	;
        uint32_t	good_csum_packets                                            	;
        uint32_t	no_cso_support_packets                                       	;
        uint32_t	bad_ipv4_hdr_csum_packets                                    	;
        uint32_t	bad_tcp_udp_csum_packets                                     	;
        uint32_t	parser_result[RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER];
        uint16_t	saved_buffer_number                                          	;
        uint16_t	saved_packet_length                                          	;
#else
        uint32_t	reserved                                                     	;
        uint16_t	cam_result                                                   	;
        uint16_t	csum_value                                                   	;
        uint32_t	crc_result                                                   	;
        uint32_t	saved_ret_address                                            	;
        uint32_t	saved_pkt_desc_0                                             	;
        uint32_t	saved_pkt_desc_1                                             	;
        uint32_t	saved_pkt_desc_2                                             	;
        uint32_t	saved_pkt_desc_3                                             	;
        uint32_t	good_csum_packets                                            	;
        uint32_t	no_cso_support_packets                                       	;
        uint32_t	bad_ipv4_hdr_csum_packets                                    	;
        uint32_t	bad_tcp_udp_csum_packets                                     	;
        uint32_t	parser_result[RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER];
        uint16_t	saved_packet_length                                          	;
        uint16_t	saved_buffer_number                                          	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) CSO_CONTEXT_ENTRY_STRUCT;

#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ_G(r, g, idx)                         GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE_G(v, g, idx)                        GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ(r, p)                                MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE(v, p)                               MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ_G(r, g, idx)                         GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE_G(v, g, idx)                        GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ(r, p)                                MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE(v, p)                               MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ(r, p)                                MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ(r, p)                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ(r, p)                          MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ(r, p)                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ(r, p)                          MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ(r, p)                          MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, (r))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, (v))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ(r, p)                         MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 36, (r))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 36, (v))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ(r, p)                    MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 40, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 40, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ(r, p)                 MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 44, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 44, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ(r, p)                  MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ_G(r, g, idx, i)                   GROUP_MREAD_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 48, i, (r))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE_G(v, g, idx, i)                  GROUP_MWRITE_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 48, i, (v))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ(r, p, i)                          MREAD_I_32((uint8_t *)(p) + 48, i, (r))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE(v, p, i)                         MWRITE_I_32((uint8_t *)(p) + 48, i, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 104, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 104, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ(r, p)                       MREAD_16((uint8_t *)(p) + 104, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 104, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 106, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 106, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ(r, p)                       MREAD_16((uint8_t *)(p) + 106, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 106, (v))
/* <<<CSO_CONTEXT_ENTRY_STRUCT */


#define RDD_CSO_CONTEXT_TABLE_SIZE     1
typedef struct
{
	CSO_CONTEXT_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CSO_CONTEXT_TABLE_STRUCT;

extern uint32_t RDD_CSO_CONTEXT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CSO_CONTEXT_TABLE_PTR(core_id)	( CSO_CONTEXT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CSO_CONTEXT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CSO_CONTEXT_TABLE */


/* >>>CPU_RX_INTERRUPT_SCRATCH */

#define RDD_CPU_RX_INTERRUPT_SCRATCH_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_INTERRUPT_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_RX_INTERRUPT_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_INTERRUPT_SCRATCH_PTR(core_id)	( CPU_RX_INTERRUPT_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_INTERRUPT_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_INTERRUPT_SCRATCH */


/* >>>CPU_RX_COPY_INT_SCRATCHPAD */

#define RDD_CPU_RX_COPY_INT_SCRATCHPAD_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RX_COPY_INT_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_INT_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_INT_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_INT_SCRATCHPAD_PTR(core_id)	( CPU_RX_COPY_INT_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_INT_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_INT_SCRATCHPAD */


/* >>>US_CPU_REASON_TO_METER_TABLE */

#define RDD_US_CPU_REASON_TO_METER_TABLE_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_US_CPU_REASON_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_CPU_REASON_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_US_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_CPU_REASON_TO_METER_TABLE_PTR(core_id)	( US_CPU_REASON_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_CPU_REASON_TO_METER_TABLE */


/* >>>IPV6_HOST_ADDRESS_CRC_TABLE */

#define RDD_IPV6_HOST_ADDRESS_CRC_TABLE_SIZE     16
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_IPV6_HOST_ADDRESS_CRC_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPV6_HOST_ADDRESS_CRC_TABLE_STRUCT;

extern uint32_t RDD_IPV6_HOST_ADDRESS_CRC_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPV6_HOST_ADDRESS_CRC_TABLE_PTR(core_id)	( IPV6_HOST_ADDRESS_CRC_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPV6_HOST_ADDRESS_CRC_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPV6_HOST_ADDRESS_CRC_TABLE */


/* >>>CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD */

#define RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_PTR(core_id)	( CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD */


/* >>>VPORT_TO_FLOW_IDX */

#define RDD_VPORT_TO_FLOW_IDX_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_TO_FLOW_IDX_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_TO_FLOW_IDX_STRUCT;

extern uint32_t RDD_VPORT_TO_FLOW_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_TO_FLOW_IDX_PTR(core_id)	( VPORT_TO_FLOW_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_TO_FLOW_IDX_ADDRESS_ARR[core_id] ))

/* <<<VPORT_TO_FLOW_IDX */


/* >>>CPU_VPORT_TO_METER_TABLE */

#define RDD_CPU_VPORT_TO_METER_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_VPORT_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_VPORT_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_CPU_VPORT_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_VPORT_TO_METER_TABLE_PTR(core_id)	( CPU_VPORT_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_VPORT_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_VPORT_TO_METER_TABLE */


/* >>>WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE */

#define RDD_WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<WAN_LOOPBACK_DISPATCHER_CREDIT_TABLE */


/* >>>CPU_RX_COPY_UPDATE_FIFO_TABLE */

#define RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_PTR(core_id)	( CPU_RX_COPY_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_UPDATE_FIFO_TABLE */


/* >>>CPU_FEED_RING_RSV_TABLE */

#define RDD_CPU_FEED_RING_RSV_TABLE_SIZE     16
typedef struct
{
	BYTES_2_STRUCT	entry[ RDD_CPU_FEED_RING_RSV_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_RSV_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_RSV_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_RSV_TABLE_PTR(core_id)	( CPU_FEED_RING_RSV_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_RSV_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_RSV_TABLE */


/* >>>PD_FIFO_TABLE */

#define RDD_PD_FIFO_TABLE_SIZE     2
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PD_FIFO_TABLE_PTR(core_id)	( PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<PD_FIFO_TABLE */


/* >>>CPU_REASON_TO_TC */

#define RDD_CPU_REASON_TO_TC_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_REASON_TO_TC_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_REASON_TO_TC_STRUCT;

extern uint32_t RDD_CPU_REASON_TO_TC_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_REASON_TO_TC_PTR(core_id)	( CPU_REASON_TO_TC_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_REASON_TO_TC_ADDRESS_ARR[core_id] ))

/* <<<CPU_REASON_TO_TC */


/* >>>TC_TO_CPU_RXQ */

#define RDD_TC_TO_CPU_RXQ_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_TC_TO_CPU_RXQ_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TC_TO_CPU_RXQ_STRUCT;

extern uint32_t RDD_TC_TO_CPU_RXQ_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TC_TO_CPU_RXQ_PTR(core_id)	( TC_TO_CPU_RXQ_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TC_TO_CPU_RXQ_ADDRESS_ARR[core_id] ))

/* <<<TC_TO_CPU_RXQ */


/* >>>EXC_TC_TO_CPU_RXQ */

#define RDD_EXC_TC_TO_CPU_RXQ_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_EXC_TC_TO_CPU_RXQ_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EXC_TC_TO_CPU_RXQ_STRUCT;

extern uint32_t RDD_EXC_TC_TO_CPU_RXQ_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EXC_TC_TO_CPU_RXQ_PTR(core_id)	( EXC_TC_TO_CPU_RXQ_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EXC_TC_TO_CPU_RXQ_ADDRESS_ARR[core_id] ))

/* <<<EXC_TC_TO_CPU_RXQ */


/* >>>IPV4_HOST_ADDRESS_TABLE */

#define RDD_IPV4_HOST_ADDRESS_TABLE_SIZE     8
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_IPV4_HOST_ADDRESS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPV4_HOST_ADDRESS_TABLE_STRUCT;

extern uint32_t RDD_IPV4_HOST_ADDRESS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPV4_HOST_ADDRESS_TABLE_PTR(core_id)	( IPV4_HOST_ADDRESS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPV4_HOST_ADDRESS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPV4_HOST_ADDRESS_TABLE */


/* >>>CPU_RX_COPY_DISPATCHER_CREDIT_TABLE */

#define RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_DISPATCHER_CREDIT_TABLE */


/* >>>CPU_FEED_RING_INTERRUPT_THRESHOLD */

#define RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_INTERRUPT_THRESHOLD_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_PTR(core_id)	( CPU_FEED_RING_INTERRUPT_THRESHOLD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_INTERRUPT_THRESHOLD */


/* >>>VPORT_TO_CPU_OBJ */

#define RDD_VPORT_TO_CPU_OBJ_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_TO_CPU_OBJ_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_TO_CPU_OBJ_STRUCT;

extern uint32_t RDD_VPORT_TO_CPU_OBJ_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_TO_CPU_OBJ_PTR(core_id)	( VPORT_TO_CPU_OBJ_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_TO_CPU_OBJ_ADDRESS_ARR[core_id] ))

/* <<<VPORT_TO_CPU_OBJ */


/* >>>CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR */

/* >>>DDR_ADDRESS_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	low       	;
        uint32_t	high      	;
#else
        uint32_t	low       	;
        uint32_t	high      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DDR_ADDRESS_STRUCT;

#define RDD_DDR_ADDRESS_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT), (r))
#define RDD_DDR_ADDRESS_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT), (v))
#define RDD_DDR_ADDRESS_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_DDR_ADDRESS_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_DDR_ADDRESS_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT) + 4, (r))
#define RDD_DDR_ADDRESS_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT) + 4, (v))
#define RDD_DDR_ADDRESS_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DDR_ADDRESS_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<DDR_ADDRESS_STRUCT */


#define RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_PTR(core_id)	( CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR */


/* >>>BCM_SPDSVC_STREAM_RX_TS_TABLE */

/* >>>SPDSVC_RX_TS_STAT_STRUCT */
typedef union
{
    uint32_t word_32[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) SPDSVC_RX_TS_STAT_STRUCT;

#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ(r, p)                     MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE(v, p)                    MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ(r, p)                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 1, (v))
/* <<<SPDSVC_RX_TS_STAT_STRUCT */


#define RDD_BCM_SPDSVC_STREAM_RX_TS_TABLE_SIZE     1
typedef struct
{
	SPDSVC_RX_TS_STAT_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BCM_SPDSVC_STREAM_RX_TS_TABLE_STRUCT;

extern uint32_t RDD_BCM_SPDSVC_STREAM_RX_TS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BCM_SPDSVC_STREAM_RX_TS_TABLE_PTR(core_id)	( BCM_SPDSVC_STREAM_RX_TS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BCM_SPDSVC_STREAM_RX_TS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BCM_SPDSVC_STREAM_RX_TS_TABLE */


/* >>>CPU_FEED_RING_INTERRUPT_COUNTER */

#define RDD_CPU_FEED_RING_INTERRUPT_COUNTER_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_INTERRUPT_COUNTER_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_INTERRUPT_COUNTER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_INTERRUPT_COUNTER_PTR(core_id)	( CPU_FEED_RING_INTERRUPT_COUNTER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_INTERRUPT_COUNTER_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_INTERRUPT_COUNTER */


/* >>>CPU_FEED_RING_CACHE_OFFSET */

#define RDD_CPU_FEED_RING_CACHE_OFFSET_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_CACHE_OFFSET_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_CACHE_OFFSET_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_CACHE_OFFSET_PTR(core_id)	( CPU_FEED_RING_CACHE_OFFSET_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_CACHE_OFFSET_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_CACHE_OFFSET */


/* >>>CSO_DISABLE */

#define RDD_CSO_DISABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CSO_DISABLE_STRUCT;

extern uint32_t RDD_CSO_DISABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CSO_DISABLE_PTR(core_id)	( CSO_DISABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CSO_DISABLE_ADDRESS_ARR[core_id] ))

/* <<<CSO_DISABLE */


/* >>>CPU_RECYCLE_RING_DESCRIPTOR_TABLE */

/* >>>CPU_RING_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	size_of_entry    	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	number_of_entries	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	interrupt_id     	;
        uint16_t	drop_counter     	;
        uint16_t	write_idx        	;
        uint32_t	base_addr_low    	;
        uint16_t	read_idx         	;
        uint8_t	reserved0        	;
        uint8_t	base_addr_high   	;
#else
        uint16_t	interrupt_id     	;
        uint32_t	number_of_entries	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	size_of_entry    	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	write_idx        	;
        uint16_t	drop_counter     	;
        uint32_t	base_addr_low    	;
        uint8_t	base_addr_high   	;
        uint8_t	reserved0        	;
        uint16_t	read_idx         	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_RING_DESCRIPTOR_STRUCT;

#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 3, 5, (r))
#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 3, 5, (v))
#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 3, 5, (r))
#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 3, 5, (v))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 0, 11, (r))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 0, 11, (v))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 11, (r))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 11, (v))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_READ(r, p)                      MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_READ(r, p)                      MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_READ(r, p)                         MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_READ(r, p)                     MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_READ(r, p)                          MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 15, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 15, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_READ(r, p)                    MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 15, (v))
/* <<<CPU_RING_DESCRIPTOR_STRUCT */


#define RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_SIZE     1
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_PTR(core_id)	( CPU_RECYCLE_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_RING_DESCRIPTOR_TABLE */


/* >>>CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE */

#define RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_SIZE     2
typedef struct
{
	DDR_ADDRESS_STRUCT	entry[ RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_PTR(core_id)	( CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE */


/* >>>CPU_INTERRUPT_COALESCING_TABLE */

#define RDD_CPU_INTERRUPT_COALESCING_TABLE_SIZE     1
typedef struct
{
	CPU_INTERRUPT_COALESCING_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_INTERRUPT_COALESCING_TABLE_STRUCT;

extern uint32_t RDD_CPU_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_INTERRUPT_COALESCING_TABLE_PTR(core_id)	( CPU_INTERRUPT_COALESCING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_INTERRUPT_COALESCING_TABLE */


/* >>>CPU_FEED_RING_DESCRIPTOR_TABLE */

#define RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_SIZE     1
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_PTR(core_id)	( CPU_FEED_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_DESCRIPTOR_TABLE */


/* >>>CPU_RX_INTERRUPT_ID_DDR_ADDR */

#define RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_INTERRUPT_ID_DDR_ADDR_STRUCT;

extern uint32_t RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_PTR(core_id)	( CPU_RX_INTERRUPT_ID_DDR_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_INTERRUPT_ID_DDR_ADDR */


/* >>>CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE */

#define RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_SIZE     1
typedef struct
{
	CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_PTR(core_id)	( CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE */


/* >>>CPU_RECYCLE_INTERRUPT_SCRATCH */

#define RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_SIZE     2
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_INTERRUPT_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_PTR(core_id)	( CPU_RECYCLE_INTERRUPT_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_INTERRUPT_SCRATCH */


/* >>>CPU_RX_LOCAL_SCRATCH */

#define RDD_CPU_RX_LOCAL_SCRATCH_SIZE     2
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_RX_LOCAL_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_LOCAL_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_RX_LOCAL_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_LOCAL_SCRATCH_PTR(core_id)	( CPU_RX_LOCAL_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_LOCAL_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_LOCAL_SCRATCH */


/* >>>CPU_FEED_RING_INDEX_DDR_ADDR_TABLE */

#define RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_PTR(core_id)	( CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_INDEX_DDR_ADDR_TABLE */


/* >>>CPU_RECYCLE_SHADOW_RD_IDX */

#define RDD_CPU_RECYCLE_SHADOW_RD_IDX_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_SHADOW_RD_IDX_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_SHADOW_RD_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_SHADOW_RD_IDX_PTR(core_id)	( CPU_RECYCLE_SHADOW_RD_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_SHADOW_RD_IDX_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_SHADOW_RD_IDX */


/* >>>CPU_RECYCLE_SHADOW_WR_IDX */

#define RDD_CPU_RECYCLE_SHADOW_WR_IDX_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_SHADOW_WR_IDX_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_SHADOW_WR_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_SHADOW_WR_IDX_PTR(core_id)	( CPU_RECYCLE_SHADOW_WR_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_SHADOW_WR_IDX_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_SHADOW_WR_IDX */


/* >>>CPU_RECYCLE_NEXT_PTR_TABLE */

#define RDD_CPU_RECYCLE_NEXT_PTR_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_NEXT_PTR_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_NEXT_PTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_NEXT_PTR_TABLE_PTR(core_id)	( CPU_RECYCLE_NEXT_PTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_NEXT_PTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_NEXT_PTR_TABLE */


/* >>>CPU_RING_DESCRIPTORS_TABLE */

#define RDD_CPU_RING_DESCRIPTORS_TABLE_SIZE     16
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry[ RDD_CPU_RING_DESCRIPTORS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RING_DESCRIPTORS_TABLE_STRUCT;

extern uint32_t RDD_CPU_RING_DESCRIPTORS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RING_DESCRIPTORS_TABLE_PTR(core_id)	( CPU_RING_DESCRIPTORS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RING_DESCRIPTORS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RING_DESCRIPTORS_TABLE */

/* CORE_2 */

/* >>>REPORTING_QUEUE_DESCRIPTOR_TABLE */

/* >>>REPORTING_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reported_bytes   	;
        uint32_t	reported_overhead	;
#else
        uint32_t	reported_bytes   	;
        uint32_t	reported_overhead	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) REPORTING_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT), (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT), (v))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_READ(r, p)                    MREAD_32((uint8_t *)(p), (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_WRITE(v, p)                   MWRITE_32((uint8_t *)(p), (v))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<REPORTING_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_SIZE     160
typedef struct
{
	REPORTING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_QUEUE_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_PTR(core_id)	( REPORTING_QUEUE_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_QUEUE_DESCRIPTOR_TABLE */


/* >>>SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE */

#define RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_SIZE     32
typedef struct
{
	SCHEDULING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_PTR(core_id)	( SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE */


/* >>>FW_POLICER_CBS */

/* >>>CBS_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	committed_burst_size	;
#else
        uint32_t	committed_burst_size	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) CBS_ENTRY_STRUCT;

#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CBS_ENTRY_STRUCT), (r))
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CBS_ENTRY_STRUCT), (v))
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
/* <<<CBS_ENTRY_STRUCT */


#define RDD_FW_POLICER_CBS_SIZE     80
typedef struct
{
	CBS_ENTRY_STRUCT	entry[ RDD_FW_POLICER_CBS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FW_POLICER_CBS_STRUCT;

extern uint32_t RDD_FW_POLICER_CBS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FW_POLICER_CBS_PTR(core_id)	( FW_POLICER_CBS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FW_POLICER_CBS_ADDRESS_ARR[core_id] ))

/* <<<FW_POLICER_CBS */


/* >>>CODEL_SQ_TABLE */

/* >>>CODEL_SQ_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	ts        	;
#else
        uint16_t	ts        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) CODEL_SQ_ENTRY_STRUCT;

#define RDD_CODEL_SQ_ENTRY_TS_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CODEL_SQ_ENTRY_STRUCT), (r))
#define RDD_CODEL_SQ_ENTRY_TS_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_SQ_ENTRY_STRUCT), (v))
#define RDD_CODEL_SQ_ENTRY_TS_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_CODEL_SQ_ENTRY_TS_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<CODEL_SQ_ENTRY_STRUCT */


#define RDD_CODEL_SQ_TABLE_SIZE     32
typedef struct
{
	CODEL_SQ_ENTRY_STRUCT	entry[ RDD_CODEL_SQ_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CODEL_SQ_TABLE_STRUCT;

extern uint32_t RDD_CODEL_SQ_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CODEL_SQ_TABLE_PTR(core_id)	( CODEL_SQ_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CODEL_SQ_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CODEL_SQ_TABLE */


/* >>>CPU_TX_DBG_CNTRS_TABLE */

/* >>>CPU_TX_DBG_CNTRS_STRUCT */
#define RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER	5
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
#else
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_TX_DBG_CNTRS_STRUCT;

#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ(r, p)                            MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE(v, p)                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ(r, p)                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ(r, p)                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ(r, p)                               MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ(r, p)                               MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ(r, p)                 MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ(r, p)                       MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ(r, p)                                MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ(r, p)                              MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 40, (v))
/* <<<CPU_TX_DBG_CNTRS_STRUCT */


#define RDD_CPU_TX_DBG_CNTRS_TABLE_SIZE     2
typedef struct
{
	CPU_TX_DBG_CNTRS_STRUCT	entry[ RDD_CPU_TX_DBG_CNTRS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_DBG_CNTRS_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_DBG_CNTRS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_DBG_CNTRS_TABLE_PTR(core_id)	( CPU_TX_DBG_CNTRS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_DBG_CNTRS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_DBG_CNTRS_TABLE */


/* >>>CPU_TX_SCRATCHPAD */

#define RDD_CPU_TX_SCRATCHPAD_SIZE     128
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_TX_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_TX_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_SCRATCHPAD_PTR(core_id)	( CPU_TX_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_SCRATCHPAD */


/* >>>REPORTING_QUEUE_COUNTER_TABLE */

/* >>>REPORTING_QUEUE_COUNTER_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	counter_ptr	;
#else
        uint16_t	counter_ptr	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) REPORTING_QUEUE_COUNTER_STRUCT;

#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(REPORTING_QUEUE_COUNTER_STRUCT), (r))
#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(REPORTING_QUEUE_COUNTER_STRUCT), (v))
#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<REPORTING_QUEUE_COUNTER_STRUCT */


#define RDD_REPORTING_QUEUE_COUNTER_TABLE_SIZE     160
typedef struct
{
	REPORTING_QUEUE_COUNTER_STRUCT	entry[ RDD_REPORTING_QUEUE_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_QUEUE_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_QUEUE_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_QUEUE_COUNTER_TABLE_PTR(core_id)	( REPORTING_QUEUE_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_QUEUE_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_QUEUE_COUNTER_TABLE */


/* >>>SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE */

#define RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_SIZE     1
typedef struct
{
	COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_PTR(core_id)	( SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE */


/* >>>REPORTING_QUEUE_ACCUMULATED_TABLE */

/* >>>REPORTING_ACCUMULATED_DATA_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	accumulated_bytes   	;
        uint32_t	accumulated_overhead	;
#else
        uint32_t	accumulated_bytes   	;
        uint32_t	accumulated_overhead	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) REPORTING_ACCUMULATED_DATA_STRUCT;

#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_BYTES_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(REPORTING_ACCUMULATED_DATA_STRUCT), (r))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_BYTES_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(REPORTING_ACCUMULATED_DATA_STRUCT), (v))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_BYTES_READ(r, p)                    MREAD_32((uint8_t *)(p), (r))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_BYTES_WRITE(v, p)                   MWRITE_32((uint8_t *)(p), (v))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_OVERHEAD_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(REPORTING_ACCUMULATED_DATA_STRUCT) + 4, (r))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_OVERHEAD_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(REPORTING_ACCUMULATED_DATA_STRUCT) + 4, (v))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_OVERHEAD_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_REPORTING_ACCUMULATED_DATA_ACCUMULATED_OVERHEAD_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<REPORTING_ACCUMULATED_DATA_STRUCT */


#define RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_SIZE     16
typedef struct
{
	REPORTING_ACCUMULATED_DATA_STRUCT	entry[ RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_QUEUE_ACCUMULATED_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_PTR(core_id)	( REPORTING_QUEUE_ACCUMULATED_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_QUEUE_ACCUMULATED_TABLE */


/* >>>SERVICE_QUEUES_RATE_LIMITER_TABLE */

#define RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_SIZE     66
typedef struct
{
	BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_RATE_LIMITER_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_PTR(core_id)	( SERVICE_QUEUES_RATE_LIMITER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_RATE_LIMITER_TABLE */


/* >>>FW_POLICER_BUDGET_REMAINDER */

#define RDD_FW_POLICER_BUDGET_REMAINDER_SIZE     80
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_FW_POLICER_BUDGET_REMAINDER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FW_POLICER_BUDGET_REMAINDER_STRUCT;

extern uint32_t RDD_FW_POLICER_BUDGET_REMAINDER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FW_POLICER_BUDGET_REMAINDER_PTR(core_id)	( FW_POLICER_BUDGET_REMAINDER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FW_POLICER_BUDGET_REMAINDER_ADDRESS_ARR[core_id] ))

/* <<<FW_POLICER_BUDGET_REMAINDER */


/* >>>FPM_POOL_NUMBER_MAPPING_TABLE */

/* >>>FPM_POOL_NUMBER_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pool_number	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	pool_number	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} FPM_POOL_NUMBER_STRUCT;

#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FPM_POOL_NUMBER_STRUCT), 0, 2, (r))
#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FPM_POOL_NUMBER_STRUCT), 0, 2, (v))
#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 2, (r))
#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 2, (v))
/* <<<FPM_POOL_NUMBER_STRUCT */


#define RDD_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE     16
typedef struct
{
	FPM_POOL_NUMBER_STRUCT	entry[ RDD_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT;

extern uint32_t RDD_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FPM_POOL_NUMBER_MAPPING_TABLE_PTR(core_id)	( FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<FPM_POOL_NUMBER_MAPPING_TABLE */


/* >>>TX_FLOW_TABLE */

/* >>>TX_FLOW_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	qos_table_ptr	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	qos_table_ptr	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TX_FLOW_ENTRY_STRUCT;

#define RDD_TX_FLOW_ENTRY_VALID_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 7, 1, (r))
#define RDD_TX_FLOW_ENTRY_VALID_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 7, 1, (v))
#define RDD_TX_FLOW_ENTRY_VALID_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_TX_FLOW_ENTRY_VALID_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 0, 7, (r))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 0, 7, (v))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 7, (r))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 7, (v))
/* <<<TX_FLOW_ENTRY_STRUCT */


#define RDD_TX_FLOW_TABLE_SIZE     192
typedef struct
{
	TX_FLOW_ENTRY_STRUCT	entry[ RDD_TX_FLOW_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_FLOW_TABLE_STRUCT;

extern uint32_t RDD_TX_FLOW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_FLOW_TABLE_PTR(core_id)	( TX_FLOW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_FLOW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TX_FLOW_TABLE */


/* >>>QUEUE_THRESHOLD_VECTOR */

#define RDD_QUEUE_THRESHOLD_VECTOR_SIZE     9
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_QUEUE_THRESHOLD_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ QUEUE_THRESHOLD_VECTOR_STRUCT;

extern uint32_t RDD_QUEUE_THRESHOLD_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_QUEUE_THRESHOLD_VECTOR_PTR(core_id)	( QUEUE_THRESHOLD_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_QUEUE_THRESHOLD_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<QUEUE_THRESHOLD_VECTOR */


/* >>>GHOST_REPORTING_GLOBAL_CFG */

/* >>>GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	mac_type      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	disable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved      	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	timer_interval	;
#else
        uint16_t	timer_interval	;
        uint32_t	reserved      	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	disable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mac_type      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT;

#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 5, 3, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 5, 3, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT */


#define RDD_GHOST_REPORTING_GLOBAL_CFG_SIZE     1
typedef struct
{
	GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GHOST_REPORTING_GLOBAL_CFG_STRUCT;

extern uint32_t RDD_GHOST_REPORTING_GLOBAL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GHOST_REPORTING_GLOBAL_CFG_PTR(core_id)	( GHOST_REPORTING_GLOBAL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GHOST_REPORTING_GLOBAL_CFG_ADDRESS_ARR[core_id] ))

/* <<<GHOST_REPORTING_GLOBAL_CFG */


/* >>>BUFFER_ALLOC_REPLY */

#define RDD_BUFFER_ALLOC_REPLY_SIZE     2
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_BUFFER_ALLOC_REPLY_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BUFFER_ALLOC_REPLY_STRUCT;

extern uint32_t RDD_BUFFER_ALLOC_REPLY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BUFFER_ALLOC_REPLY_PTR(core_id)	( BUFFER_ALLOC_REPLY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BUFFER_ALLOC_REPLY_ADDRESS_ARR[core_id] ))

/* <<<BUFFER_ALLOC_REPLY */


/* >>>FW_POLICER_BUDGET */

/* >>>FW_POLICER_BUDGET_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	budget_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	budget_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	budget_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	budget_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) FW_POLICER_BUDGET_ENTRY_STRUCT;

#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT), 2, 14, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT), 2, 14, (v))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 2, 14, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 2, 14, (v))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT) + 1, 0, 2, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT) + 1, 0, 2, (v))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v))
/* <<<FW_POLICER_BUDGET_ENTRY_STRUCT */


#define RDD_FW_POLICER_BUDGET_SIZE     80
typedef struct
{
	FW_POLICER_BUDGET_ENTRY_STRUCT	entry[ RDD_FW_POLICER_BUDGET_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FW_POLICER_BUDGET_STRUCT;

extern uint32_t RDD_FW_POLICER_BUDGET_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FW_POLICER_BUDGET_PTR(core_id)	( FW_POLICER_BUDGET_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FW_POLICER_BUDGET_ADDRESS_ARR[core_id] ))

/* <<<FW_POLICER_BUDGET */


/* >>>SERVICE_QUEUES_UPDATE_FIFO_TABLE */

#define RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_PTR(core_id)	( SERVICE_QUEUES_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_UPDATE_FIFO_TABLE */


/* >>>GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE */

#define RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_STRUCT;

extern uint32_t RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_PTR(core_id)	( GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE */


/* >>>TIMER_COMMON_TIMER_VALUE */

#define RDD_TIMER_COMMON_TIMER_VALUE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TIMER_COMMON_TIMER_VALUE_STRUCT;

extern uint32_t RDD_TIMER_COMMON_TIMER_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TIMER_COMMON_TIMER_VALUE_PTR(core_id)	( TIMER_COMMON_TIMER_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TIMER_COMMON_TIMER_VALUE_ADDRESS_ARR[core_id] ))

/* <<<TIMER_COMMON_TIMER_VALUE */


/* >>>SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE */

#define RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_PTR(core_id)	( SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE */


/* >>>TIMER_COMMON_CTR_REP */

#define RDD_TIMER_COMMON_CTR_REP_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TIMER_COMMON_CTR_REP_STRUCT;

extern uint32_t RDD_TIMER_COMMON_CTR_REP_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TIMER_COMMON_CTR_REP_PTR(core_id)	( TIMER_COMMON_CTR_REP_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TIMER_COMMON_CTR_REP_ADDRESS_ARR[core_id] ))

/* <<<TIMER_COMMON_CTR_REP */


/* >>>SERVICE_QUEUES_PD_FIFO_TABLE */

#define RDD_SERVICE_QUEUES_PD_FIFO_TABLE_SIZE     64
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_PD_FIFO_TABLE_PTR(core_id)	( SERVICE_QUEUES_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_PD_FIFO_TABLE */


/* >>>REPORTING_COUNTER_TABLE */

#define RDD_REPORTING_COUNTER_TABLE_SIZE     40
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_REPORTING_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_COUNTER_TABLE_PTR(core_id)	( REPORTING_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_COUNTER_TABLE */


/* >>>SERVICE_QUEUES_FLUSH_CFG_FW_TABLE */

#define RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_PTR(core_id)	( SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FLUSH_CFG_FW_TABLE */


/* >>>QUEUE_TO_REPORT_BIT_VECTOR */

#define RDD_QUEUE_TO_REPORT_BIT_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_QUEUE_TO_REPORT_BIT_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ QUEUE_TO_REPORT_BIT_VECTOR_STRUCT;

extern uint32_t RDD_QUEUE_TO_REPORT_BIT_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_QUEUE_TO_REPORT_BIT_VECTOR_PTR(core_id)	( QUEUE_TO_REPORT_BIT_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_QUEUE_TO_REPORT_BIT_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<QUEUE_TO_REPORT_BIT_VECTOR */


/* >>>EMAC_FLOW_CTRL_BUDGET */

/* >>>EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	budget    	;
#else
        uint32_t	budget    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT;

#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT), (r))
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT), (v))
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
/* <<<EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT */


#define RDD_EMAC_FLOW_CTRL_BUDGET_SIZE     32
typedef struct
{
	EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT	entry[ RDD_EMAC_FLOW_CTRL_BUDGET_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EMAC_FLOW_CTRL_BUDGET_STRUCT;

extern uint32_t RDD_EMAC_FLOW_CTRL_BUDGET_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EMAC_FLOW_CTRL_BUDGET_PTR(core_id)	( EMAC_FLOW_CTRL_BUDGET_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EMAC_FLOW_CTRL_BUDGET_ADDRESS_ARR[core_id] ))

/* <<<EMAC_FLOW_CTRL_BUDGET */


/* >>>RING_CPU_TX_DESCRIPTOR_DATA_TABLE */

/* >>>RING_CPU_TX_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_egress                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q             	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sk_buf_ptr_high           	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                      	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	data_1588                           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	reserved1                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	fpm_fallback              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_or_egress_0       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	egress_dont_drop          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pkt_buf_ptr_high          	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	ssid                                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU1_egress_dont_drop        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_pkt_buf_ptr_high        	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	flow_or_port_id                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_or_bcast                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	bcast                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reserved_ingress_or_egress          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU2_egress_dont_drop        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_pkt_buf_ptr_high        	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low                     	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved0                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_bn0                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	sk_buf_ptr_high           	;
        uint32_t	packet_length             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q             	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_egress                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                      	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	data_1588                           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	pkt_buf_ptr_high          	;
        uint32_t	reserved                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_dont_drop          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_or_egress_0       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_fallback              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_pkt_buf_ptr_high        	;
        uint32_t	reservedSU1_reserved                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_dont_drop        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	lag_index                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU1_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_pkt_buf_ptr_high        	;
        uint32_t	reservedSU2_reserved                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_dont_drop        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_ingress_or_egress          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	bcast                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	mcast_or_bcast                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU2_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_or_port_id                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	is_vport                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low                     	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	fpm_bn0                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved0                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) RING_CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                              FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                             FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                              FIELD_MREAD_32((uint8_t *)(p) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                             FIELD_MWRITE_32((uint8_t *)(p) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_G(r, g, idx)                     GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_G(v, g, idx)                    GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ(r, p)                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE(v, p)                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_G(r, g, idx)         GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_G(v, g, idx)        GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ(r, p)                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE(v, p)               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ(r, p)                             MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                                  FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                                 FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 6, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 6, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 6, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 6, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                       FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                      FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_G(r, g, idx)                    GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_G(v, g, idx)                   GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ(r, p)                           MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE(v, p)                          MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ(r, p)                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ(r, p)                            MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ(r, p)                                    FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE(v, p)                                   FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ(r, p)                                    FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE(v, p)                                   FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
/* <<<RING_CPU_TX_DESCRIPTOR_STRUCT */


#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_SIZE     2
typedef struct
{
	RING_CPU_TX_DESCRIPTOR_STRUCT	entry[ RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RING_CPU_TX_DESCRIPTOR_DATA_TABLE_STRUCT;

extern uint32_t RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_PTR(core_id)	( RING_CPU_TX_DESCRIPTOR_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<RING_CPU_TX_DESCRIPTOR_DATA_TABLE */


/* >>>EMAC_FLOW_CTRL_BUDGET_REMAINDER */

#define RDD_EMAC_FLOW_CTRL_BUDGET_REMAINDER_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_EMAC_FLOW_CTRL_BUDGET_REMAINDER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EMAC_FLOW_CTRL_BUDGET_REMAINDER_STRUCT;

extern uint32_t RDD_EMAC_FLOW_CTRL_BUDGET_REMAINDER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EMAC_FLOW_CTRL_BUDGET_REMAINDER_PTR(core_id)	( EMAC_FLOW_CTRL_BUDGET_REMAINDER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EMAC_FLOW_CTRL_BUDGET_REMAINDER_ADDRESS_ARR[core_id] ))

/* <<<EMAC_FLOW_CTRL_BUDGET_REMAINDER */


/* >>>SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE */

#define RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_PTR(core_id)	( SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE */


/* >>>CPU_TX_RING_DESCRIPTOR_TABLE */

#define RDD_CPU_TX_RING_DESCRIPTOR_TABLE_SIZE     2
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry[ RDD_CPU_TX_RING_DESCRIPTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_RING_DESCRIPTOR_TABLE_PTR(core_id)	( CPU_TX_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_RING_DESCRIPTOR_TABLE */


/* >>>CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE */

#define RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE */


/* >>>EMAC_FLOW_CTRL_VECTOR */

#define RDD_EMAC_FLOW_CTRL_VECTOR_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ EMAC_FLOW_CTRL_VECTOR_STRUCT;

extern uint32_t RDD_EMAC_FLOW_CTRL_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EMAC_FLOW_CTRL_VECTOR_PTR(core_id)	( EMAC_FLOW_CTRL_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EMAC_FLOW_CTRL_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<EMAC_FLOW_CTRL_VECTOR */


/* >>>CPU_TX_VLAN_STATS_ENABLE */

#define RDD_CPU_TX_VLAN_STATS_ENABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_VLAN_STATS_ENABLE_STRUCT;

extern uint32_t RDD_CPU_TX_VLAN_STATS_ENABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_VLAN_STATS_ENABLE_PTR(core_id)	( CPU_TX_VLAN_STATS_ENABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_VLAN_STATS_ENABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_VLAN_STATS_ENABLE */


/* >>>SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE */

#define RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_PTR(core_id)	( SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE */


/* >>>CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE */

#define RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE */


/* >>>SERVICE_QUEUES_FIRST_QUEUE_MAPPING */

#define RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FIRST_QUEUE_MAPPING_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_PTR(core_id)	( SERVICE_QUEUES_FIRST_QUEUE_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FIRST_QUEUE_MAPPING */


/* >>>BBH_TX_INGRESS_COUNTER_TABLE */

#define RDD_BBH_TX_INGRESS_COUNTER_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_INGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_INGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_INGRESS_COUNTER_TABLE_PTR(core_id)	( BBH_TX_INGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_INGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_INGRESS_COUNTER_TABLE */


/* >>>FW_POLICER_VECTOR */

#define RDD_FW_POLICER_VECTOR_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_FW_POLICER_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FW_POLICER_VECTOR_STRUCT;

extern uint32_t RDD_FW_POLICER_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FW_POLICER_VECTOR_PTR(core_id)	( FW_POLICER_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FW_POLICER_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<FW_POLICER_VECTOR */


/* >>>SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE */

#define RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE */


/* >>>CPU_TX_SYNC_FIFO_TABLE */

/* >>>CPU_TX_SYNC_FIFO_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	write_ptr 	;
        uint16_t	read_ptr  	;
        uint16_t	fifo      	;
        uint16_t	reserved  	;
#else
        uint16_t	read_ptr  	;
        uint16_t	write_ptr 	;
        uint16_t	reserved  	;
        uint16_t	fifo      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_TX_SYNC_FIFO_ENTRY_STRUCT;

#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ(r, p)                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ(r, p)                      MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<CPU_TX_SYNC_FIFO_ENTRY_STRUCT */


#define RDD_CPU_TX_SYNC_FIFO_TABLE_SIZE     2
typedef struct
{
	CPU_TX_SYNC_FIFO_ENTRY_STRUCT	entry[ RDD_CPU_TX_SYNC_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_SYNC_FIFO_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_SYNC_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_SYNC_FIFO_TABLE_PTR(core_id)	( CPU_TX_SYNC_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_SYNC_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_SYNC_FIFO_TABLE */


/* >>>REPORT_BBH_TX_QUEUE_ID_TABLE */

#define RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_SIZE     2
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORT_BBH_TX_QUEUE_ID_TABLE_STRUCT;

extern uint32_t RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_PTR(core_id)	( REPORT_BBH_TX_QUEUE_ID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORT_BBH_TX_QUEUE_ID_TABLE */


/* >>>XGPON_REPORT_ZERO_SENT_TABLE */

#define RDD_XGPON_REPORT_ZERO_SENT_TABLE_SIZE     10
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_XGPON_REPORT_ZERO_SENT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ XGPON_REPORT_ZERO_SENT_TABLE_STRUCT;

extern uint32_t RDD_XGPON_REPORT_ZERO_SENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_XGPON_REPORT_ZERO_SENT_TABLE_PTR(core_id)	( XGPON_REPORT_ZERO_SENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_XGPON_REPORT_ZERO_SENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<XGPON_REPORT_ZERO_SENT_TABLE */


/* >>>CPU_TX_RING_INDICES_VALUES_TABLE */

/* >>>CPU_TX_RING_INDICES_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	read_idx  	;
        uint16_t	write_idx 	;
#else
        uint16_t	write_idx 	;
        uint16_t	read_idx  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) CPU_TX_RING_INDICES_STRUCT;

#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CPU_TX_RING_INDICES_STRUCT */


#define RDD_CPU_TX_RING_INDICES_VALUES_TABLE_SIZE     2
typedef struct
{
	CPU_TX_RING_INDICES_STRUCT	entry[ RDD_CPU_TX_RING_INDICES_VALUES_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_RING_INDICES_VALUES_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_RING_INDICES_VALUES_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_RING_INDICES_VALUES_TABLE_PTR(core_id)	( CPU_TX_RING_INDICES_VALUES_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_RING_INDICES_VALUES_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_RING_INDICES_VALUES_TABLE */


/* >>>BBH_TX_EGRESS_REPORT_COUNTER_TABLE */

#define RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_SIZE     1
typedef struct
{
	BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EGRESS_REPORT_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_PTR(core_id)	( BBH_TX_EGRESS_REPORT_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EGRESS_REPORT_COUNTER_TABLE */


/* >>>SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE */

#define RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENABLE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_PTR(core_id)	( SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE */

/* CORE_3 */

/* >>>US_TM_PD_FIFO_TABLE */

#define RDD_US_TM_PD_FIFO_TABLE_SIZE     320
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_US_TM_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_PD_FIFO_TABLE_PTR(core_id)	( US_TM_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_PD_FIFO_TABLE */


/* >>>US_TM_SCHEDULING_QUEUE_TABLE */

#define RDD_US_TM_SCHEDULING_QUEUE_TABLE_SIZE     160
typedef struct
{
	SCHEDULING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_SCHEDULING_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_SCHEDULING_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_SCHEDULING_QUEUE_TABLE_PTR(core_id)	( US_TM_SCHEDULING_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_SCHEDULING_QUEUE_TABLE */


/* >>>DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD */

#define RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_SIZE     136
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_PTR(core_id)	( DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD */


/* >>>US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE */

#define RDD_US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE_SIZE     1
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE_PTR(core_id)	( US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_1_BBH_TX_WAKE_UP_DATA_TABLE */


/* >>>DIRECT_FLOW_PD_TABLE */

#define RDD_DIRECT_FLOW_PD_TABLE_SIZE     1
typedef struct
{
	PROCESSING_RX_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_PD_TABLE_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_PD_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_PD_TABLE_PTR(core_id)	( DIRECT_FLOW_PD_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_PD_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_PD_TABLE */


/* >>>US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE */

#define RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_PTR(core_id)	( US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE */


/* >>>US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE */

#define RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_SIZE     1
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_PTR(core_id)	( US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE */


/* >>>US_TM_FLUSH_CFG_CPU_TABLE */

#define RDD_US_TM_FLUSH_CFG_CPU_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_CPU_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_CPU_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_CPU_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_CPU_TABLE */


/* >>>BASIC_RATE_LIMITER_TABLE_US */

#define RDD_BASIC_RATE_LIMITER_TABLE_US_SIZE     128
typedef struct
{
	BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_RATE_LIMITER_TABLE_US_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_RATE_LIMITER_TABLE_US_STRUCT;

extern uint32_t RDD_BASIC_RATE_LIMITER_TABLE_US_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_RATE_LIMITER_TABLE_US_PTR(core_id)	( BASIC_RATE_LIMITER_TABLE_US_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_RATE_LIMITER_TABLE_US_ADDRESS_ARR[core_id] ))

/* <<<BASIC_RATE_LIMITER_TABLE_US */


/* >>>BBH_TX_EPON_WAKE_UP_DATA_TABLE */

#define RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_SIZE     1
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EPON_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_PTR(core_id)	( BBH_TX_EPON_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EPON_WAKE_UP_DATA_TABLE */


/* >>>US_TM_FLUSH_CFG_FW_TABLE */

#define RDD_US_TM_FLUSH_CFG_FW_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_FW_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_FW_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_FW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_FW_TABLE */


/* >>>DIRECT_FLOW_CNTR_TABLE */

#define RDD_DIRECT_FLOW_CNTR_TABLE_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_CNTR_TABLE_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_CNTR_TABLE_PTR(core_id)	( DIRECT_FLOW_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_CNTR_TABLE */


/* >>>BBH_TX_EPON_INGRESS_COUNTER_TABLE */

#define RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EPON_INGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_PTR(core_id)	( BBH_TX_EPON_INGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EPON_INGRESS_COUNTER_TABLE */


/* >>>US_TM_FLUSH_CFG_CURRENT_TABLE */

#define RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_CURRENT_TABLE */


/* >>>US_TM_TM_FLOW_CNTR_TABLE */

#define RDD_US_TM_TM_FLOW_CNTR_TABLE_SIZE     128
typedef struct
{
	TM_FLOW_CNTR_ENTRY_STRUCT	entry[ RDD_US_TM_TM_FLOW_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TM_FLOW_CNTR_TABLE_STRUCT;

extern uint32_t RDD_US_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TM_FLOW_CNTR_TABLE_PTR(core_id)	( US_TM_TM_FLOW_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TM_FLOW_CNTR_TABLE */


/* >>>US_TM_CPU_TX_ABS_COUNTERS */

#define RDD_US_TM_CPU_TX_ABS_COUNTERS_SIZE     32
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_CPU_TX_ABS_COUNTERS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_CPU_TX_ABS_COUNTERS_STRUCT;

extern uint32_t RDD_US_TM_CPU_TX_ABS_COUNTERS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_CPU_TX_ABS_COUNTERS_PTR(core_id)	( US_TM_CPU_TX_ABS_COUNTERS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_CPU_TX_ABS_COUNTERS_ADDRESS_ARR[core_id] ))

/* <<<US_TM_CPU_TX_ABS_COUNTERS */


/* >>>US_TM_BBH_QUEUE_TABLE */

#define RDD_US_TM_BBH_QUEUE_TABLE_SIZE     41
typedef struct
{
	BBH_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_BBH_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_BBH_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_BBH_QUEUE_TABLE_PTR(core_id)	( US_TM_BBH_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_BBH_QUEUE_TABLE */


/* >>>US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED */

#define RDD_US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED_STRUCT;

extern uint32_t RDD_US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED_PTR(core_id)	( US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED_ADDRESS_ARR[core_id] ))

/* <<<US_TM_BBH_TX_WAN_1_FIFO_BYTES_USED */


/* >>>OVERALL_RATE_LIMITER_TABLE */

/* >>>OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bbh_queue_en_vec	;
        uint32_t	current_budget  	;
        uint32_t	alloc_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1       	;
#else
        uint32_t	bbh_queue_en_vec	;
        uint32_t	current_budget  	;
        uint32_t	limit_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT;

#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT), (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT), (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 10, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 10, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 2, (v))
/* <<<OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT */


#define RDD_OVERALL_RATE_LIMITER_TABLE_SIZE     1
typedef struct
{
	OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ OVERALL_RATE_LIMITER_TABLE_STRUCT;

extern uint32_t RDD_OVERALL_RATE_LIMITER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_OVERALL_RATE_LIMITER_TABLE_PTR(core_id)	( OVERALL_RATE_LIMITER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_OVERALL_RATE_LIMITER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<OVERALL_RATE_LIMITER_TABLE */


/* >>>BBH_TX_EPON_EGRESS_COUNTER_TABLE */

#define RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EPON_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_PTR(core_id)	( BBH_TX_EPON_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EPON_EGRESS_COUNTER_TABLE */


/* >>>DIRECT_FLOW_EPON_CONTROL_SCRATCH */

#define RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_SIZE     22
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_EPON_CONTROL_SCRATCH_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_PTR(core_id)	( DIRECT_FLOW_EPON_CONTROL_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_EPON_CONTROL_SCRATCH */


/* >>>US_TM_WAN_1_BB_DESTINATION_TABLE */

#define RDD_US_TM_WAN_1_BB_DESTINATION_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_1_BB_DESTINATION_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_1_BB_DESTINATION_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_1_BB_DESTINATION_TABLE_PTR(core_id)	( US_TM_WAN_1_BB_DESTINATION_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_1_BB_DESTINATION_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_1_BB_DESTINATION_TABLE */


/* >>>US_TM_FLUSH_DISPATCHER_CREDIT_TABLE */

#define RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_DISPATCHER_CREDIT_TABLE */


/* >>>DIRECT_FLOW_PAUSE_QUANTA */

/* >>>PAUSE_QUANTA_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	ignore    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	time_unit 	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	time_unit 	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ignore    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) PAUSE_QUANTA_ENTRY_STRUCT;

#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 7, 1, (r))
#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 7, 1, (v))
#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 0, 15, (r))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 0, 15, (v))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 15, (r))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 15, (v))
/* <<<PAUSE_QUANTA_ENTRY_STRUCT */


#define RDD_DIRECT_FLOW_PAUSE_QUANTA_SIZE     1
typedef struct
{
	PAUSE_QUANTA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_PAUSE_QUANTA_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_PAUSE_QUANTA_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_PAUSE_QUANTA_PTR(core_id)	( DIRECT_FLOW_PAUSE_QUANTA_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_PAUSE_QUANTA_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_PAUSE_QUANTA */


/* >>>US_TM_SCHEDULING_QUEUE_AGING_VECTOR */

#define RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT;

extern uint32_t RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_PTR(core_id)	( US_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<US_TM_SCHEDULING_QUEUE_AGING_VECTOR */


/* >>>US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED */

#define RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_STRUCT;

extern uint32_t RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_PTR(core_id)	( US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_ADDRESS_ARR[core_id] ))

/* <<<US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED */


/* >>>US_TM_WAN_0_BB_DESTINATION_TABLE */

#define RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_0_BB_DESTINATION_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_PTR(core_id)	( US_TM_WAN_0_BB_DESTINATION_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_0_BB_DESTINATION_TABLE */


/* >>>BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD */

#define RDD_BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD_STRUCT;

extern uint32_t RDD_BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD_PTR(core_id)	( BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_US_WAN_1_FIFO_BYTES_THRESHOLD */


/* >>>EPON_UPDATE_FIFO_TABLE */

#define RDD_EPON_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_EPON_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EPON_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_EPON_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EPON_UPDATE_FIFO_TABLE_PTR(core_id)	( EPON_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EPON_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<EPON_UPDATE_FIFO_TABLE */


/* >>>US_TM_TX_OCTETS_COUNTERS_TABLE */

#define RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_SIZE     8
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TX_OCTETS_COUNTERS_TABLE_STRUCT;

extern uint32_t RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_PTR(core_id)	( US_TM_TX_OCTETS_COUNTERS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TX_OCTETS_COUNTERS_TABLE */


/* >>>US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR */

#define RDD_US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_STRUCT;

extern uint32_t RDD_US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_PTR(core_id)	( US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<US_TM_SCHEDULING_AGGREGATION_CONTEXT_VECTOR */


/* >>>US_TM_TX_PAUSE_NACK */

#define RDD_US_TM_TX_PAUSE_NACK_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TX_PAUSE_NACK_STRUCT;

extern uint32_t RDD_US_TM_TX_PAUSE_NACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TX_PAUSE_NACK_PTR(core_id)	( US_TM_TX_PAUSE_NACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TX_PAUSE_NACK_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TX_PAUSE_NACK */


/* >>>BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD */

#define RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_STRUCT;

extern uint32_t RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_PTR(core_id)	( BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD */


/* >>>US_TM_FLUSH_CFG_ENABLE_TABLE */

#define RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENABLE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_ENABLE_TABLE */


/* >>>WAN_1_BBH_TX_FIFO_SIZE */

#define RDD_WAN_1_BBH_TX_FIFO_SIZE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ WAN_1_BBH_TX_FIFO_SIZE_STRUCT;

extern uint32_t RDD_WAN_1_BBH_TX_FIFO_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_WAN_1_BBH_TX_FIFO_SIZE_PTR(core_id)	( WAN_1_BBH_TX_FIFO_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_WAN_1_BBH_TX_FIFO_SIZE_ADDRESS_ARR[core_id] ))

/* <<<WAN_1_BBH_TX_FIFO_SIZE */


/* >>>RX_MIRRORING_CONFIGURATION */

#define RDD_RX_MIRRORING_CONFIGURATION_SIZE     1
typedef struct
{
	MIRRORING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_MIRRORING_CONFIGURATION_STRUCT;

extern uint32_t RDD_RX_MIRRORING_CONFIGURATION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_MIRRORING_CONFIGURATION_PTR(core_id)	( RX_MIRRORING_CONFIGURATION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_MIRRORING_CONFIGURATION_ADDRESS_ARR[core_id] ))

/* <<<RX_MIRRORING_CONFIGURATION */


/* >>>BASIC_SCHEDULER_TABLE_US */

#define RDD_BASIC_SCHEDULER_TABLE_US_SIZE     33
typedef struct
{
	BASIC_SCHEDULER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_SCHEDULER_TABLE_US_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_SCHEDULER_TABLE_US_STRUCT;

extern uint32_t RDD_BASIC_SCHEDULER_TABLE_US_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_SCHEDULER_TABLE_US_PTR(core_id)	( BASIC_SCHEDULER_TABLE_US_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_SCHEDULER_TABLE_US_ADDRESS_ARR[core_id] ))

/* <<<BASIC_SCHEDULER_TABLE_US */


/* >>>RATE_LIMITER_VALID_TABLE_US */

#define RDD_RATE_LIMITER_VALID_TABLE_US_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_RATE_LIMITER_VALID_TABLE_US_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RATE_LIMITER_VALID_TABLE_US_STRUCT;

extern uint32_t RDD_RATE_LIMITER_VALID_TABLE_US_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RATE_LIMITER_VALID_TABLE_US_PTR(core_id)	( RATE_LIMITER_VALID_TABLE_US_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RATE_LIMITER_VALID_TABLE_US_ADDRESS_ARR[core_id] ))

/* <<<RATE_LIMITER_VALID_TABLE_US */


/* >>>DIRECT_FLOW_PAUSE_DEBUG */

#define RDD_DIRECT_FLOW_PAUSE_DEBUG_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DIRECT_FLOW_PAUSE_DEBUG_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_PAUSE_DEBUG_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_PAUSE_DEBUG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_PAUSE_DEBUG_PTR(core_id)	( DIRECT_FLOW_PAUSE_DEBUG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_PAUSE_DEBUG_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_PAUSE_DEBUG */


/* >>>US_TM_FLUSH_AGGREGATION_TASK_DISABLE */

#define RDD_US_TM_FLUSH_AGGREGATION_TASK_DISABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_AGGREGATION_TASK_DISABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_AGGREGATION_TASK_DISABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_AGGREGATION_TASK_DISABLE_PTR(core_id)	( US_TM_FLUSH_AGGREGATION_TASK_DISABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_AGGREGATION_TASK_DISABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_AGGREGATION_TASK_DISABLE */


/* >>>DISPATCHER_CREDIT_TABLE */

#define RDD_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DISPATCHER_CREDIT_TABLE */


/* >>>MAC_TYPE */

/* >>>MAC_TYPE_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	type      	;
#else
        uint8_t	type      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} MAC_TYPE_ENTRY_STRUCT;

#define RDD_MAC_TYPE_ENTRY_TYPE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(MAC_TYPE_ENTRY_STRUCT), (r))
#define RDD_MAC_TYPE_ENTRY_TYPE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(MAC_TYPE_ENTRY_STRUCT), (v))
#define RDD_MAC_TYPE_ENTRY_TYPE_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_MAC_TYPE_ENTRY_TYPE_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<MAC_TYPE_ENTRY_STRUCT */


#define RDD_MAC_TYPE_SIZE     1
typedef struct
{
	MAC_TYPE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MAC_TYPE_STRUCT;

extern uint32_t RDD_MAC_TYPE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MAC_TYPE_PTR(core_id)	( MAC_TYPE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MAC_TYPE_ADDRESS_ARR[core_id] ))

/* <<<MAC_TYPE */


/* >>>WAN_0_BBH_TX_FIFO_SIZE */

#define RDD_WAN_0_BBH_TX_FIFO_SIZE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ WAN_0_BBH_TX_FIFO_SIZE_STRUCT;

extern uint32_t RDD_WAN_0_BBH_TX_FIFO_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_WAN_0_BBH_TX_FIFO_SIZE_PTR(core_id)	( WAN_0_BBH_TX_FIFO_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_WAN_0_BBH_TX_FIFO_SIZE_ADDRESS_ARR[core_id] ))

/* <<<WAN_0_BBH_TX_FIFO_SIZE */


/* >>>US_TM_FIRST_QUEUE_MAPPING */

#define RDD_US_TM_FIRST_QUEUE_MAPPING_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FIRST_QUEUE_MAPPING_STRUCT;

extern uint32_t RDD_US_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FIRST_QUEUE_MAPPING_PTR(core_id)	( US_TM_FIRST_QUEUE_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FIRST_QUEUE_MAPPING */


/* >>>RX_MIRRORING_DIRECT_ENABLE */

#define RDD_RX_MIRRORING_DIRECT_ENABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_MIRRORING_DIRECT_ENABLE_STRUCT;

extern uint32_t RDD_RX_MIRRORING_DIRECT_ENABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_MIRRORING_DIRECT_ENABLE_PTR(core_id)	( RX_MIRRORING_DIRECT_ENABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_MIRRORING_DIRECT_ENABLE_ADDRESS_ARR[core_id] ))

/* <<<RX_MIRRORING_DIRECT_ENABLE */


/* >>>US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE */

#define RDD_US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE_PTR(core_id)	( US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_1_BBH_TX_EGRESS_COUNTER_TABLE */


/* >>>US_TM_BBH_TX_TASK_ID */

#define RDD_US_TM_BBH_TX_TASK_ID_SIZE     2
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_US_TM_BBH_TX_TASK_ID_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_BBH_TX_TASK_ID_STRUCT;

extern uint32_t RDD_US_TM_BBH_TX_TASK_ID_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_BBH_TX_TASK_ID_PTR(core_id)	( US_TM_BBH_TX_TASK_ID_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_BBH_TX_TASK_ID_ADDRESS_ARR[core_id] ))

/* <<<US_TM_BBH_TX_TASK_ID */

/* CORE_4 */

/* >>>DS_PACKET_BUFFER */

/* >>>PACKET_BUFFER_STRUCT */
#define RDD_PACKET_BUFFER_PACKET_HEADER_NUMBER	128
#define RDD_PACKET_BUFFER_PARSER_RESULT_NUMBER	56
#define RDD_PACKET_BUFFER_SCRATCH_NUMBER	136
#define RDD_PACKET_BUFFER_PD_NUMBER	16
#define RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_NUMBER	24
#define RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_NUMBER	6
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_NUMBER	128
typedef union
{
    uint32_t word_32[128];
    uint64_t dword_64[64];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	packet_header[RDD_PACKET_BUFFER_PACKET_HEADER_NUMBER];
        uint8_t	parser_result[RDD_PACKET_BUFFER_PARSER_RESULT_NUMBER];
        uint8_t	scratch[RDD_PACKET_BUFFER_SCRATCH_NUMBER];
        uint8_t	pd[RDD_PACKET_BUFFER_PD_NUMBER];
        uint8_t	resolution_context[RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_NUMBER];
        uint32_t	classification_results[RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_NUMBER];
        uint8_t	classification_contexts_list[RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_NUMBER];
#else
        uint8_t	packet_header[RDD_PACKET_BUFFER_PACKET_HEADER_NUMBER];
        uint8_t	parser_result[RDD_PACKET_BUFFER_PARSER_RESULT_NUMBER];
        uint8_t	scratch[RDD_PACKET_BUFFER_SCRATCH_NUMBER];
        uint8_t	pd[RDD_PACKET_BUFFER_PD_NUMBER];
        uint8_t	resolution_context[RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_NUMBER];
        uint32_t	classification_results[RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_NUMBER];
        uint8_t	classification_contexts_list[RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PACKET_BUFFER_STRUCT;

#define RDD_PACKET_BUFFER_PACKET_HEADER_READ_G(r, g, idx, i)                      GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT), i, (r))
#define RDD_PACKET_BUFFER_PACKET_HEADER_WRITE_G(v, g, idx, i)                     GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT), i, (v))
#define RDD_PACKET_BUFFER_PACKET_HEADER_READ(r, p, i)                             MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_PACKET_BUFFER_PACKET_HEADER_WRITE(v, p, i)                            MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_PACKET_BUFFER_PARSER_RESULT_READ_G(r, g, idx, i)                      GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 128, i, (r))
#define RDD_PACKET_BUFFER_PARSER_RESULT_WRITE_G(v, g, idx, i)                     GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 128, i, (v))
#define RDD_PACKET_BUFFER_PARSER_RESULT_READ(r, p, i)                             MREAD_I_8((uint8_t *)(p) + 128, i, (r))
#define RDD_PACKET_BUFFER_PARSER_RESULT_WRITE(v, p, i)                            MWRITE_I_8((uint8_t *)(p) + 128, i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_READ_G(r, g, idx, i)                            GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 184, i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_WRITE_G(v, g, idx, i)                           GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 184, i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_READ(r, p, i)                                   MREAD_I_8((uint8_t *)(p) + 184, i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_WRITE(v, p, i)                                  MWRITE_I_8((uint8_t *)(p) + 184, i, (v))
#define RDD_PACKET_BUFFER_PD_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 320, i, (r))
#define RDD_PACKET_BUFFER_PD_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 320, i, (v))
#define RDD_PACKET_BUFFER_PD_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 320, i, (r))
#define RDD_PACKET_BUFFER_PD_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 320, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_READ_G(r, g, idx, i)                 GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 336, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_WRITE_G(v, g, idx, i)                GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 336, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_READ(r, p, i)                        MREAD_I_8((uint8_t *)(p) + 336, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_CONTEXT_WRITE(v, p, i)                       MWRITE_I_8((uint8_t *)(p) + 336, i, (v))
#define RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_READ_G(r, g, idx, i)             GROUP_MREAD_I_32((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 360, i, (r))
#define RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_WRITE_G(v, g, idx, i)            GROUP_MWRITE_I_32((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 360, i, (v))
#define RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_READ(r, p, i)                    MREAD_I_32((uint8_t *)(p) + 360, i, (r))
#define RDD_PACKET_BUFFER_CLASSIFICATION_RESULTS_WRITE(v, p, i)                   MWRITE_I_32((uint8_t *)(p) + 360, i, (v))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 384, i, (r))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 384, i, (v))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 384, i, (r))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 384, i, (v))
/* <<<PACKET_BUFFER_STRUCT */


#define RDD_DS_PACKET_BUFFER_SIZE     8
typedef struct
{
	PACKET_BUFFER_STRUCT	entry[ RDD_DS_PACKET_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_PACKET_BUFFER_STRUCT;

extern uint32_t RDD_DS_PACKET_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_PACKET_BUFFER_PTR(core_id)	( DS_PACKET_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_PACKET_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<DS_PACKET_BUFFER */


/* >>>RX_FLOW_TABLE */

/* >>>RX_FLOW_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	virtual_port	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	flow_dest   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	exception   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	is_lan      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	cntr_id     	;
#else
        uint8_t	cntr_id     	;
        uint16_t	is_lan      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	exception   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	flow_dest   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	virtual_port	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) RX_FLOW_ENTRY_STRUCT;

#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 3, 5, (r))
#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 3, 5, (v))
#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 3, 5, (r))
#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 3, 5, (v))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 2, 1, (r))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 2, 1, (v))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 1, 1, (r))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 1, 1, (v))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_RX_FLOW_ENTRY_IS_LAN_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 0, 1, (r))
#define RDD_RX_FLOW_ENTRY_IS_LAN_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 0, 1, (v))
#define RDD_RX_FLOW_ENTRY_IS_LAN_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_RX_FLOW_ENTRY_IS_LAN_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT) + 1, (r))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT) + 1, (v))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_READ(r, p)                      MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<RX_FLOW_ENTRY_STRUCT */


#define RDD_RX_FLOW_TABLE_SIZE     320
typedef struct
{
	RX_FLOW_ENTRY_STRUCT	entry[ RDD_RX_FLOW_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_FLOW_TABLE_STRUCT;

extern uint32_t RDD_RX_FLOW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_FLOW_TABLE_PTR(core_id)	( RX_FLOW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_FLOW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<RX_FLOW_TABLE */


/* >>>PBIT_TO_GEM_TABLE */

#define RDD_PBIT_TO_GEM_TABLE_SIZE     32

#define RDD_PBIT_TO_GEM_TABLE_SIZE2    8
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PBIT_TO_GEM_TABLE_SIZE ][ RDD_PBIT_TO_GEM_TABLE_SIZE2 ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PBIT_TO_GEM_TABLE_STRUCT;

extern uint32_t RDD_PBIT_TO_GEM_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PBIT_TO_GEM_TABLE_PTR(core_id)	( PBIT_TO_GEM_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PBIT_TO_GEM_TABLE_ADDRESS_ARR[core_id] ))

/* <<<PBIT_TO_GEM_TABLE */


/* >>>TCAM_IC_CMD_TABLE */

/* >>>TCAM_IC_CMD_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	handler_ptr    	;
        uint8_t	src_offset     	;
        uint8_t	dst_offset     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_handler_ptr  	;
        uint8_t	reservedSU1_src_offset   	;
        uint32_t	reserved1                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
        uint32_t	dst_offset_6bit          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_handler_ptr  	;
        uint8_t	reservedSU2_src_offset   	;
        uint32_t	reserved2                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
        uint32_t	dst_offset_5bit          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	dst_offset     	; /* This is a field union */
        uint8_t	src_offset     	;
        uint16_t	handler_ptr    	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	dst_offset_6bit          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
        uint32_t	reserved1                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
        uint8_t	reservedSU1_src_offset   	;
        uint16_t	reservedSU1_handler_ptr  	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	dst_offset_5bit          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
        uint32_t	reserved2                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dst_offset union */
        uint8_t	reservedSU2_src_offset   	;
        uint16_t	reservedSU2_handler_ptr  	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) TCAM_IC_CMD_STRUCT;

#define RDD_TCAM_IC_CMD_HANDLER_PTR_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT), (r))
#define RDD_TCAM_IC_CMD_HANDLER_PTR_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT), (v))
#define RDD_TCAM_IC_CMD_HANDLER_PTR_READ(r, p)                     MREAD_16((uint8_t *)(p), (r))
#define RDD_TCAM_IC_CMD_HANDLER_PTR_WRITE(v, p)                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_TCAM_IC_CMD_HANDLER_PTR_L_READ( wv )                   FIELD_GET( wv, 16, 16 )
#define RDD_TCAM_IC_CMD_HANDLER_PTR_L_WRITE( v, wv )               FIELD_SET( v, 16, 16, wv )
#define RDD_TCAM_IC_CMD_SRC_OFFSET_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 2, (r))
#define RDD_TCAM_IC_CMD_SRC_OFFSET_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 2, (v))
#define RDD_TCAM_IC_CMD_SRC_OFFSET_READ(r, p)                      MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCAM_IC_CMD_SRC_OFFSET_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCAM_IC_CMD_SRC_OFFSET_L_READ( wv )                    FIELD_GET( wv, 8, 8 )
#define RDD_TCAM_IC_CMD_SRC_OFFSET_L_WRITE( v, wv )                FIELD_SET( v, 8, 8, wv )
#define RDD_TCAM_IC_CMD_DST_OFFSET_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 3, (r))
#define RDD_TCAM_IC_CMD_DST_OFFSET_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 3, (v))
#define RDD_TCAM_IC_CMD_DST_OFFSET_READ(r, p)                      MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCAM_IC_CMD_DST_OFFSET_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCAM_IC_CMD_DST_OFFSET_L_READ( wv )                    FIELD_GET( wv, 0, 8 )
#define RDD_TCAM_IC_CMD_DST_OFFSET_L_WRITE( v, wv )                FIELD_SET( v, 0, 8, wv )
#define RDD_TCAM_IC_CMD_DST_OFFSET_6BIT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 3, 0, 6, (r))
#define RDD_TCAM_IC_CMD_DST_OFFSET_6BIT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 3, 0, 6, (v))
#define RDD_TCAM_IC_CMD_DST_OFFSET_6BIT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 6, (r))
#define RDD_TCAM_IC_CMD_DST_OFFSET_6BIT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 6, (v))
#define RDD_TCAM_IC_CMD_DST_OFFSET_6BIT_L_READ( wv )               FIELD_GET( wv, 0, 6 )
#define RDD_TCAM_IC_CMD_DST_OFFSET_6BIT_L_WRITE( v, wv )           FIELD_SET( v, 0, 6, wv )
#define RDD_TCAM_IC_CMD_DST_OFFSET_5BIT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 3, 0, 5, (r))
#define RDD_TCAM_IC_CMD_DST_OFFSET_5BIT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_IC_CMD_STRUCT) + 3, 0, 5, (v))
#define RDD_TCAM_IC_CMD_DST_OFFSET_5BIT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 5, (r))
#define RDD_TCAM_IC_CMD_DST_OFFSET_5BIT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 5, (v))
#define RDD_TCAM_IC_CMD_DST_OFFSET_5BIT_L_READ( wv )               FIELD_GET( wv, 0, 5 )
#define RDD_TCAM_IC_CMD_DST_OFFSET_5BIT_L_WRITE( v, wv )           FIELD_SET( v, 0, 5, wv )
/* <<<TCAM_IC_CMD_STRUCT */


#define RDD_TCAM_IC_CMD_TABLE_SIZE     9

#define RDD_TCAM_IC_CMD_TABLE_SIZE2    16
typedef struct
{
	TCAM_IC_CMD_STRUCT	entry[ RDD_TCAM_IC_CMD_TABLE_SIZE ][ RDD_TCAM_IC_CMD_TABLE_SIZE2 ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCAM_IC_CMD_TABLE_STRUCT;

extern uint32_t RDD_TCAM_IC_CMD_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCAM_IC_CMD_TABLE_PTR(core_id)	( TCAM_IC_CMD_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCAM_IC_CMD_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCAM_IC_CMD_TABLE */


/* >>>INGRESS_CONGESTION_FLOW_CTRL_TABLE */

/* >>>INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	bbh_id    	;
        uint8_t	enable    	;
#else
        uint8_t	enable    	;
        uint8_t	bbh_id    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT;

#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT), (r))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT), (v))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT) + 1, (r))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT) + 1, (v))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT */


#define RDD_INGRESS_CONGESTION_FLOW_CTRL_TABLE_SIZE     32
typedef struct
{
	INGRESS_CONGESTION_FLOW_CTRL_ENTRY_STRUCT	entry[ RDD_INGRESS_CONGESTION_FLOW_CTRL_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_CONGESTION_FLOW_CTRL_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_CONGESTION_FLOW_CTRL_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_CONGESTION_FLOW_CTRL_TABLE_PTR(core_id)	( INGRESS_CONGESTION_FLOW_CTRL_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_CONGESTION_FLOW_CTRL_TABLE_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_CONGESTION_FLOW_CTRL_TABLE */


/* >>>DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE */

#define RDD_DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_SIZE     40
typedef struct
{
	BYTES_2_STRUCT	entry[ RDD_DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_STRUCT;

extern uint32_t RDD_DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_PTR(core_id)	( DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DEFAULT_VLAN_VID_TO_TX_VLAN_CNTR_TABLE */


/* >>>FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE */

#define RDD_FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE     32
typedef struct
{
	FPM_POOL_NUMBER_STRUCT	entry[ RDD_FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT;

extern uint32_t RDD_FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_PTR(core_id)	( FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<FLOODING_HEADER_FPM_POOL_NUMBER_MAPPING_TABLE */


/* >>>DSCP_TO_PBITS_MAP_TABLE */

#define RDD_DSCP_TO_PBITS_MAP_TABLE_SIZE     4

#define RDD_DSCP_TO_PBITS_MAP_TABLE_SIZE2    64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DSCP_TO_PBITS_MAP_TABLE_SIZE ][ RDD_DSCP_TO_PBITS_MAP_TABLE_SIZE2 ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DSCP_TO_PBITS_MAP_TABLE_STRUCT;

extern uint32_t RDD_DSCP_TO_PBITS_MAP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DSCP_TO_PBITS_MAP_TABLE_PTR(core_id)	( DSCP_TO_PBITS_MAP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DSCP_TO_PBITS_MAP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DSCP_TO_PBITS_MAP_TABLE */


/* >>>TC_TO_QUEUE_TABLE */

/* >>>TC_TO_QUEUE_8_STRUCT */
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_NUMBER	8
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	queue_offset[RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_NUMBER];
#else
        uint8_t	queue_offset[RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TC_TO_QUEUE_8_STRUCT;

#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (r))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (v))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<TC_TO_QUEUE_8_STRUCT */


#define RDD_TC_TO_QUEUE_TABLE_SIZE     65
typedef struct
{
	TC_TO_QUEUE_8_STRUCT	entry[ RDD_TC_TO_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TC_TO_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_TC_TO_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TC_TO_QUEUE_TABLE_PTR(core_id)	( TC_TO_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TC_TO_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TC_TO_QUEUE_TABLE */


/* >>>RX_FLOW_CONTEXT_DDR_ADDR */

/* >>>DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	low       	;
        uint32_t	high      	;
#else
        uint32_t	low       	;
        uint32_t	high      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT;

#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT), (r))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT), (v))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT) + 4, (r))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT) + 4, (v))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DEF_FLOW_CONTEXT_DDR_ADDR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT */


#define RDD_RX_FLOW_CONTEXT_DDR_ADDR_SIZE     1
typedef struct
{
	DEF_FLOW_CONTEXT_DDR_ADDR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_FLOW_CONTEXT_DDR_ADDR_STRUCT;

extern uint32_t RDD_RX_FLOW_CONTEXT_DDR_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_FLOW_CONTEXT_DDR_ADDR_PTR(core_id)	( RX_FLOW_CONTEXT_DDR_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_FLOW_CONTEXT_DDR_ADDR_ADDRESS_ARR[core_id] ))

/* <<<RX_FLOW_CONTEXT_DDR_ADDR */


/* >>>BRIDGE_CFG_TABLE */

/* >>>BRIDGE_CFG_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	hit                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_fw_failed        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_aggregation        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_results_available	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	res_offset              	;
        uint16_t	context_offset          	;
        uint16_t	reserved                	;
#else
        uint16_t	res_offset              	;
        uint32_t	bridge_results_available	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_aggregation        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_fw_failed        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hit                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved                	;
        uint16_t	context_offset          	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BRIDGE_CFG_STRUCT;

#define RDD_BRIDGE_CFG_HIT_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 7, 1, (r))
#define RDD_BRIDGE_CFG_HIT_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 7, 1, (v))
#define RDD_BRIDGE_CFG_HIT_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_BRIDGE_CFG_HIT_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 6, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 6, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 5, 1, (r))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 5, 1, (v))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 1, 0, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 1, 0, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
#define RDD_BRIDGE_CFG_RES_OFFSET_READ_G(r, g, idx)                        GROUP_MREAD_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 2, (r))
#define RDD_BRIDGE_CFG_RES_OFFSET_WRITE_G(v, g, idx)                       GROUP_MWRITE_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 2, (v))
#define RDD_BRIDGE_CFG_RES_OFFSET_READ(r, p)                               MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_BRIDGE_CFG_RES_OFFSET_WRITE(v, p)                              MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 4, (r))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 4, (v))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_READ(r, p)                           MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<BRIDGE_CFG_STRUCT */


#define RDD_BRIDGE_CFG_TABLE_SIZE     2
typedef struct
{
	BRIDGE_CFG_STRUCT	entry[ RDD_BRIDGE_CFG_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BRIDGE_CFG_TABLE_STRUCT;

extern uint32_t RDD_BRIDGE_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BRIDGE_CFG_TABLE_PTR(core_id)	( BRIDGE_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BRIDGE_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BRIDGE_CFG_TABLE */


/* >>>VPORT_TO_LOOKUP_PORT_MAPPING_TABLE */

#define RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_STRUCT;

extern uint32_t RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_PTR(core_id)	( VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VPORT_TO_LOOKUP_PORT_MAPPING_TABLE */


/* >>>PORT_MAC */

/* >>>MAC_ADDRESS_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	reserved  	;
        uint8_t	da1       	;
        uint8_t	da2       	;
        uint8_t	da3       	;
        uint8_t	da4       	;
        uint8_t	da5       	;
        uint8_t	da6       	;
#else
        uint8_t	da2       	;
        uint8_t	da1       	;
        uint16_t	reserved  	;
        uint8_t	da6       	;
        uint8_t	da5       	;
        uint8_t	da4       	;
        uint8_t	da3       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) MAC_ADDRESS_STRUCT;

#define RDD_MAC_ADDRESS_DA1_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 2, (r))
#define RDD_MAC_ADDRESS_DA1_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 2, (v))
#define RDD_MAC_ADDRESS_DA1_READ(r, p)                      MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_MAC_ADDRESS_DA1_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_MAC_ADDRESS_DA2_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 3, (r))
#define RDD_MAC_ADDRESS_DA2_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 3, (v))
#define RDD_MAC_ADDRESS_DA2_READ(r, p)                      MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_MAC_ADDRESS_DA2_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_MAC_ADDRESS_DA3_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 4, (r))
#define RDD_MAC_ADDRESS_DA3_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 4, (v))
#define RDD_MAC_ADDRESS_DA3_READ(r, p)                      MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_MAC_ADDRESS_DA3_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_MAC_ADDRESS_DA4_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 5, (r))
#define RDD_MAC_ADDRESS_DA4_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 5, (v))
#define RDD_MAC_ADDRESS_DA4_READ(r, p)                      MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_MAC_ADDRESS_DA4_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_MAC_ADDRESS_DA5_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 6, (r))
#define RDD_MAC_ADDRESS_DA5_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 6, (v))
#define RDD_MAC_ADDRESS_DA5_READ(r, p)                      MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_MAC_ADDRESS_DA5_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_MAC_ADDRESS_DA6_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 7, (r))
#define RDD_MAC_ADDRESS_DA6_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(MAC_ADDRESS_STRUCT) + 7, (v))
#define RDD_MAC_ADDRESS_DA6_READ(r, p)                      MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_MAC_ADDRESS_DA6_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<MAC_ADDRESS_STRUCT */


#define RDD_PORT_MAC_SIZE     8
typedef struct
{
	MAC_ADDRESS_STRUCT	entry[ RDD_PORT_MAC_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PORT_MAC_STRUCT;

extern uint32_t RDD_PORT_MAC_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PORT_MAC_PTR(core_id)	( PORT_MAC_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PORT_MAC_ADDRESS_ARR[core_id] ))

/* <<<PORT_MAC */


/* >>>DEFAULT_VLAN_VID_TABLE */

/* >>>DEFAULT_VLAN_VID_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	reserved   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	default_vid	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	default_vid	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) DEFAULT_VLAN_VID_ENTRY_STRUCT;

#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(DEFAULT_VLAN_VID_ENTRY_STRUCT), 0, 12, (r))
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(DEFAULT_VLAN_VID_ENTRY_STRUCT), 0, 12, (v))
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<DEFAULT_VLAN_VID_ENTRY_STRUCT */


#define RDD_DEFAULT_VLAN_VID_TABLE_SIZE     40
typedef struct
{
	DEFAULT_VLAN_VID_ENTRY_STRUCT	entry[ RDD_DEFAULT_VLAN_VID_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEFAULT_VLAN_VID_TABLE_STRUCT;

extern uint32_t RDD_DEFAULT_VLAN_VID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEFAULT_VLAN_VID_TABLE_PTR(core_id)	( DEFAULT_VLAN_VID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEFAULT_VLAN_VID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DEFAULT_VLAN_VID_TABLE */


/* >>>MCAST_PROCESSING_TASKS_REPLY */

#define RDD_MCAST_PROCESSING_TASKS_REPLY_SIZE     8
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_MCAST_PROCESSING_TASKS_REPLY_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_PROCESSING_TASKS_REPLY_STRUCT;

extern uint32_t RDD_MCAST_PROCESSING_TASKS_REPLY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_PROCESSING_TASKS_REPLY_PTR(core_id)	( MCAST_PROCESSING_TASKS_REPLY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_PROCESSING_TASKS_REPLY_ADDRESS_ARR[core_id] ))

/* <<<MCAST_PROCESSING_TASKS_REPLY */


/* >>>PBIT_TO_QUEUE_TABLE */

/* >>>PBIT_TO_QUEUE_8_STRUCT */
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_NUMBER	8
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	queue_offset[RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_NUMBER];
#else
        uint8_t	queue_offset[RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PBIT_TO_QUEUE_8_STRUCT;

#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(PBIT_TO_QUEUE_8_STRUCT), i, (r))
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(PBIT_TO_QUEUE_8_STRUCT), i, (v))
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<PBIT_TO_QUEUE_8_STRUCT */


#define RDD_PBIT_TO_QUEUE_TABLE_SIZE     65
typedef struct
{
	PBIT_TO_QUEUE_8_STRUCT	entry[ RDD_PBIT_TO_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PBIT_TO_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_PBIT_TO_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PBIT_TO_QUEUE_TABLE_PTR(core_id)	( PBIT_TO_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PBIT_TO_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<PBIT_TO_QUEUE_TABLE */


/* >>>MCAST_FPM_TOKENS_READ_FLAG */

#define RDD_MCAST_FPM_TOKENS_READ_FLAG_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_FPM_TOKENS_READ_FLAG_STRUCT;

extern uint32_t RDD_MCAST_FPM_TOKENS_READ_FLAG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_FPM_TOKENS_READ_FLAG_PTR(core_id)	( MCAST_FPM_TOKENS_READ_FLAG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_FPM_TOKENS_READ_FLAG_ADDRESS_ARR[core_id] ))

/* <<<MCAST_FPM_TOKENS_READ_FLAG */


/* >>>INGRESS_FILTER_L2_REASON_TABLE */

#define RDD_INGRESS_FILTER_L2_REASON_TABLE_SIZE     16
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_INGRESS_FILTER_L2_REASON_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_L2_REASON_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_L2_REASON_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_L2_REASON_TABLE_PTR(core_id)	( INGRESS_FILTER_L2_REASON_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_L2_REASON_TABLE_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_L2_REASON_TABLE */


/* >>>IPTV_CONFIGURATION_TABLE */

/* >>>HW_IPTV_CONFIGURATION_STRUCT */
typedef union
{
    uint32_t word_32[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	fpm_base_token_size 	;
        uint32_t	reserved0           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn_size1            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn_size0            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset0     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset1     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_pool1_stat2_addr	;
#else
        uint32_t	hn_size0            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn_size1            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	fpm_base_token_size 	;
        uint32_t	ddr_sop_offset1     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset0     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_pool1_stat2_addr	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) HW_IPTV_CONFIGURATION_STRUCT;

#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT), (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT), (v))
#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 2, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 2, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 3, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 3, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 4, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 4, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 4, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 4, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 6, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 6, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 8, (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 8, (v))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_READ(r, p)                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 8, (v))
/* <<<HW_IPTV_CONFIGURATION_STRUCT */


#define RDD_IPTV_CONFIGURATION_TABLE_SIZE     1
typedef struct
{
	HW_IPTV_CONFIGURATION_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_CONFIGURATION_TABLE_STRUCT;

extern uint32_t RDD_IPTV_CONFIGURATION_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_CONFIGURATION_TABLE_PTR(core_id)	( IPTV_CONFIGURATION_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_CONFIGURATION_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPTV_CONFIGURATION_TABLE */


/* >>>MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT */

#define RDD_MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT_STRUCT;

extern uint32_t RDD_MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT_PTR(core_id)	( MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT_ADDRESS_ARR[core_id] ))

/* <<<MCAST_BBH_OVERRUN_MAX_TASKS_LIMIT */


/* >>>MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT */

#define RDD_MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT_STRUCT;

extern uint32_t RDD_MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT_PTR(core_id)	( MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT_ADDRESS_ARR[core_id] ))

/* <<<MCAST_BBH_OVERRUN_MIN_TASKS_LIMIT */


/* >>>GLOBAL_PBIT_TO_DSCP_TABLE */

/* >>>PBIT_TO_DSCP_ENTRY_STRUCT */
#define RDD_PBIT_TO_DSCP_ENTRY_DSCP_NUMBER	9
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	dscp[RDD_PBIT_TO_DSCP_ENTRY_DSCP_NUMBER];
#else
        uint8_t	dscp[RDD_PBIT_TO_DSCP_ENTRY_DSCP_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} PBIT_TO_DSCP_ENTRY_STRUCT;

#define RDD_PBIT_TO_DSCP_ENTRY_DSCP_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(PBIT_TO_DSCP_ENTRY_STRUCT), i, (r))
#define RDD_PBIT_TO_DSCP_ENTRY_DSCP_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(PBIT_TO_DSCP_ENTRY_STRUCT), i, (v))
#define RDD_PBIT_TO_DSCP_ENTRY_DSCP_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_PBIT_TO_DSCP_ENTRY_DSCP_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<PBIT_TO_DSCP_ENTRY_STRUCT */


#define RDD_GLOBAL_PBIT_TO_DSCP_TABLE_SIZE     1
typedef struct
{
	PBIT_TO_DSCP_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GLOBAL_PBIT_TO_DSCP_TABLE_STRUCT;

extern uint32_t RDD_GLOBAL_PBIT_TO_DSCP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GLOBAL_PBIT_TO_DSCP_TABLE_PTR(core_id)	( GLOBAL_PBIT_TO_DSCP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GLOBAL_PBIT_TO_DSCP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<GLOBAL_PBIT_TO_DSCP_TABLE */


/* >>>GLOBAL_PBIT_TO_DSCP_ENABLE */

#define RDD_GLOBAL_PBIT_TO_DSCP_ENABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GLOBAL_PBIT_TO_DSCP_ENABLE_STRUCT;

extern uint32_t RDD_GLOBAL_PBIT_TO_DSCP_ENABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GLOBAL_PBIT_TO_DSCP_ENABLE_PTR(core_id)	( GLOBAL_PBIT_TO_DSCP_ENABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GLOBAL_PBIT_TO_DSCP_ENABLE_ADDRESS_ARR[core_id] ))

/* <<<GLOBAL_PBIT_TO_DSCP_ENABLE */


/* >>>LOOPBACK_WAN_FLOW_TABLE */

#define RDD_LOOPBACK_WAN_FLOW_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ LOOPBACK_WAN_FLOW_TABLE_STRUCT;

extern uint32_t RDD_LOOPBACK_WAN_FLOW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_LOOPBACK_WAN_FLOW_TABLE_PTR(core_id)	( LOOPBACK_WAN_FLOW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_LOOPBACK_WAN_FLOW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<LOOPBACK_WAN_FLOW_TABLE */


/* >>>FORCE_DSCP */

#define RDD_FORCE_DSCP_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ FORCE_DSCP_STRUCT;

extern uint32_t RDD_FORCE_DSCP_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FORCE_DSCP_PTR(core_id)	( FORCE_DSCP_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FORCE_DSCP_ADDRESS_ARR[core_id] ))

/* <<<FORCE_DSCP */


/* >>>MCAST_PROCESSING_TASKS_LOCK */

#define RDD_MCAST_PROCESSING_TASKS_LOCK_SIZE     8
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_MCAST_PROCESSING_TASKS_LOCK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_PROCESSING_TASKS_LOCK_STRUCT;

extern uint32_t RDD_MCAST_PROCESSING_TASKS_LOCK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_PROCESSING_TASKS_LOCK_PTR(core_id)	( MCAST_PROCESSING_TASKS_LOCK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_PROCESSING_TASKS_LOCK_ADDRESS_ARR[core_id] ))

/* <<<MCAST_PROCESSING_TASKS_LOCK */


/* >>>MCAST_BBH_OVERRUN_TASKS_LIMIT */

#define RDD_MCAST_BBH_OVERRUN_TASKS_LIMIT_SIZE     8
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_MCAST_BBH_OVERRUN_TASKS_LIMIT_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_BBH_OVERRUN_TASKS_LIMIT_STRUCT;

extern uint32_t RDD_MCAST_BBH_OVERRUN_TASKS_LIMIT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_BBH_OVERRUN_TASKS_LIMIT_PTR(core_id)	( MCAST_BBH_OVERRUN_TASKS_LIMIT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_BBH_OVERRUN_TASKS_LIMIT_ADDRESS_ARR[core_id] ))

/* <<<MCAST_BBH_OVERRUN_TASKS_LIMIT */


/* >>>GLOBAL_DSCP_TO_PBITS_TABLE */

#define RDD_GLOBAL_DSCP_TO_PBITS_TABLE_SIZE     1

#define RDD_GLOBAL_DSCP_TO_PBITS_TABLE_SIZE2    64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_GLOBAL_DSCP_TO_PBITS_TABLE_SIZE2 ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ GLOBAL_DSCP_TO_PBITS_TABLE_STRUCT;

extern uint32_t RDD_GLOBAL_DSCP_TO_PBITS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GLOBAL_DSCP_TO_PBITS_TABLE_PTR(core_id)	( GLOBAL_DSCP_TO_PBITS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GLOBAL_DSCP_TO_PBITS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<GLOBAL_DSCP_TO_PBITS_TABLE */


/* >>>POLICER_PARAMS_TABLE */

/* >>>POLICER_PARAMS_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	factor_bytes   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dei_mode       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	single_bucket  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbit_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbit_green_val 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbit_yellow_val	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	reserved1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbit_yellow_val	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbit_green_val 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbit_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	single_bucket  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dei_mode       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	factor_bytes   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) POLICER_PARAMS_ENTRY_STRUCT;

#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 5, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 5, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 4, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 4, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_SINGLE_BUCKET_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 3, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_SINGLE_BUCKET_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 3, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_SINGLE_BUCKET_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_SINGLE_BUCKET_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_MODE_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT) + 1, 7, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_MODE_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT) + 1, 7, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_MODE_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_MODE_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_GREEN_VAL_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT) + 1, 4, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_GREEN_VAL_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT) + 1, 4, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_GREEN_VAL_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_GREEN_VAL_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_YELLOW_VAL_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT) + 1, 1, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_YELLOW_VAL_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT) + 1, 1, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_YELLOW_VAL_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 1, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_PBIT_YELLOW_VAL_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 1, 3, (v))
/* <<<POLICER_PARAMS_ENTRY_STRUCT */


#define RDD_POLICER_PARAMS_TABLE_SIZE     80
typedef struct
{
	POLICER_PARAMS_ENTRY_STRUCT	entry[ RDD_POLICER_PARAMS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ POLICER_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_POLICER_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_POLICER_PARAMS_TABLE_PTR(core_id)	( POLICER_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_POLICER_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<POLICER_PARAMS_TABLE */


/* >>>TUNNEL_DST_IP_LKP_TABLE */

#define RDD_TUNNEL_DST_IP_LKP_TABLE_SIZE     16
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_TUNNEL_DST_IP_LKP_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TUNNEL_DST_IP_LKP_TABLE_STRUCT;

extern uint32_t RDD_TUNNEL_DST_IP_LKP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TUNNEL_DST_IP_LKP_TABLE_PTR(core_id)	( TUNNEL_DST_IP_LKP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TUNNEL_DST_IP_LKP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TUNNEL_DST_IP_LKP_TABLE */


/* >>>VPORT_CFG_TABLE */

/* >>>VPORT_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	congestion_flow_control              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	discard_prty                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_control                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_en                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_isolation_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_miss_action                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	da_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	reserved1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bridge_id                            	;
        uint32_t	bridge_and_vlan_ingress_lookup_method	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
        uint32_t	bridge_and_vlan_egress_lookup_method 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
        uint32_t	anti_spoofing_bypass                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_default_vid_set                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	protocol_filters_dis                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_map                 	;
#else
        uint32_t	protocol_filters_dis                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_default_vid_set                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	anti_spoofing_bypass                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_and_vlan_egress_lookup_method 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
        uint32_t	bridge_and_vlan_ingress_lookup_method	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
        uint8_t	bridge_id                            	;
        uint32_t	reserved1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	sa_lookup_miss_action                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	da_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_isolation_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_en                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_control                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	discard_prty                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	congestion_flow_control              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_map                 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) VPORT_CFG_ENTRY_STRUCT;

#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ(r, p)                                          FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE(v, p)                                         FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_READ(r, p)                                          FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_WRITE(v, p)                                         FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (r))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ(r, p)                                          FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE(v, p)                                         FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ(r, p)                                          FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE(v, p)                                         FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 3, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 3, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 3, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 3, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 1, 3, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 1, 3, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 6, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 6, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 3, 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 3, 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 4, (r))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 4, (v))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<VPORT_CFG_ENTRY_STRUCT */


#define RDD_VPORT_CFG_TABLE_SIZE     40
typedef struct
{
	VPORT_CFG_ENTRY_STRUCT	entry[ RDD_VPORT_CFG_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_CFG_TABLE_STRUCT;

extern uint32_t RDD_VPORT_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_CFG_TABLE_PTR(core_id)	( VPORT_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VPORT_CFG_TABLE */


/* >>>NATC_COUNTERS_GENERIC_CONTEXT */

#define RDD_NATC_COUNTERS_GENERIC_CONTEXT_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_NATC_COUNTERS_GENERIC_CONTEXT_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ NATC_COUNTERS_GENERIC_CONTEXT_STRUCT;

extern uint32_t RDD_NATC_COUNTERS_GENERIC_CONTEXT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NATC_COUNTERS_GENERIC_CONTEXT_PTR(core_id)	( NATC_COUNTERS_GENERIC_CONTEXT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NATC_COUNTERS_GENERIC_CONTEXT_ADDRESS_ARR[core_id] ))

/* <<<NATC_COUNTERS_GENERIC_CONTEXT */


/* >>>VPORT_TO_DSCP_TO_PBITS_TABLE */

#define RDD_VPORT_TO_DSCP_TO_PBITS_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_TO_DSCP_TO_PBITS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_TO_DSCP_TO_PBITS_TABLE_STRUCT;

extern uint32_t RDD_VPORT_TO_DSCP_TO_PBITS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_TO_DSCP_TO_PBITS_TABLE_PTR(core_id)	( VPORT_TO_DSCP_TO_PBITS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_TO_DSCP_TO_PBITS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VPORT_TO_DSCP_TO_PBITS_TABLE */


/* >>>SYSTEM_CONFIGURATION */

/* >>>SYSTEM_CONFIGURATION_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	ds_drop_precedence_eligibility_vector	;
        uint16_t	us_drop_precedence_eligibility_vector	;
        uint32_t	full_flow_cache_mode                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_flow_cache_mode                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_lookup_miss_action              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_stats_enable                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	g9991_skip_parser_error              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dp_eligibility_vector_used           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_packet_based_mapping_ds_or_us	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack_flows                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	us_drop_precedence_eligibility_vector	;
        uint16_t	ds_drop_precedence_eligibility_vector	;
        uint32_t	tcp_pure_ack_flows                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_packet_based_mapping_ds_or_us	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dp_eligibility_vector_used           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	g9991_skip_parser_error              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_stats_enable                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_lookup_miss_action              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_flow_cache_mode                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	full_flow_cache_mode                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} SYSTEM_CONFIGURATION_ENTRY_STRUCT;

#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT), (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT), (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 2, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 2, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 6, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 6, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 5, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 5, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 4, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 4, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 3, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 3, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 2, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 2, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 4, 2, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 4, 2, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 1, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 1, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 4, 1, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 4, 1, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 0, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 0, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 1, (v))
/* <<<SYSTEM_CONFIGURATION_ENTRY_STRUCT */


#define RDD_SYSTEM_CONFIGURATION_SIZE     1
typedef struct
{
	SYSTEM_CONFIGURATION_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SYSTEM_CONFIGURATION_STRUCT;

extern uint32_t RDD_SYSTEM_CONFIGURATION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SYSTEM_CONFIGURATION_PTR(core_id)	( SYSTEM_CONFIGURATION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SYSTEM_CONFIGURATION_ADDRESS_ARR[core_id] ))

/* <<<SYSTEM_CONFIGURATION */


/* >>>EMAC_FLOW_CTRL */

/* >>>EMAC_FLOW_CTRL_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rate          	;
        uint32_t	max_burst_size	;
        uint32_t	threshold     	;
        uint32_t	reserved      	;
#else
        uint32_t	rate          	;
        uint32_t	max_burst_size	;
        uint32_t	threshold     	;
        uint32_t	reserved      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) EMAC_FLOW_CTRL_ENTRY_STRUCT;

#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT), (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT), (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_READ(r, p)                           MREAD_32((uint8_t *)(p), (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_WRITE(v, p)                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 4, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 4, (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 8, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 8, (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_READ(r, p)                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 8, (v))
/* <<<EMAC_FLOW_CTRL_ENTRY_STRUCT */


#define RDD_EMAC_FLOW_CTRL_SIZE     32
typedef struct
{
	EMAC_FLOW_CTRL_ENTRY_STRUCT	entry[ RDD_EMAC_FLOW_CTRL_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EMAC_FLOW_CTRL_STRUCT;

extern uint32_t RDD_EMAC_FLOW_CTRL_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EMAC_FLOW_CTRL_PTR(core_id)	( EMAC_FLOW_CTRL_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EMAC_FLOW_CTRL_ADDRESS_ARR[core_id] ))

/* <<<EMAC_FLOW_CTRL */


/* >>>VPORT_CFG_EX_TABLE */

/* >>>VPORT_CFG_EX_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	loopback_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_mac_addr_idx     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	emac_idx              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_unknown_da 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_broadcast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_multicast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_all_traffic	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_dbg_stat_en      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_idx           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	policer_idx           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_dbg_stat_en      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_all_traffic	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_multicast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_broadcast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_unknown_da 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	emac_idx              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_mac_addr_idx     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) VPORT_CFG_EX_ENTRY_STRUCT;

#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 6, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 6, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 0, 6, (r))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 0, 6, (v))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 2, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 2, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 4, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 4, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 3, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 3, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 2, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 2, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 1, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 1, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 0, 7, (r))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 0, 7, (v))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 7, (r))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 7, (v))
/* <<<VPORT_CFG_EX_ENTRY_STRUCT */


#define RDD_VPORT_CFG_EX_TABLE_SIZE     40
typedef struct
{
	VPORT_CFG_EX_ENTRY_STRUCT	entry[ RDD_VPORT_CFG_EX_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_CFG_EX_TABLE_STRUCT;

extern uint32_t RDD_VPORT_CFG_EX_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_CFG_EX_TABLE_PTR(core_id)	( VPORT_CFG_EX_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_CFG_EX_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VPORT_CFG_EX_TABLE */


/* >>>INGRESS_PACKET_BASED_MAPPING */

/* >>>INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	us        	;
        uint8_t	ds        	;
        uint16_t	reserved  	;
#else
        uint16_t	reserved  	;
        uint8_t	ds        	;
        uint8_t	us        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT;

#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_US_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT), (r))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_US_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT), (v))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_US_READ(r, p)                       MREAD_8((uint8_t *)(p), (r))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_US_WRITE(v, p)                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_DS_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT) + 1, (r))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_DS_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT) + 1, (v))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_DS_READ(r, p)                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_INGRESS_PACKET_BASED_MAPPING_ENTRY_DS_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT */


#define RDD_INGRESS_PACKET_BASED_MAPPING_SIZE     1
typedef struct
{
	INGRESS_PACKET_BASED_MAPPING_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_PACKET_BASED_MAPPING_STRUCT;

extern uint32_t RDD_INGRESS_PACKET_BASED_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_PACKET_BASED_MAPPING_PTR(core_id)	( INGRESS_PACKET_BASED_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_PACKET_BASED_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_PACKET_BASED_MAPPING */


/* >>>IC_MCAST_ENABLE */

#define RDD_IC_MCAST_ENABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IC_MCAST_ENABLE_STRUCT;

extern uint32_t RDD_IC_MCAST_ENABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IC_MCAST_ENABLE_PTR(core_id)	( IC_MCAST_ENABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IC_MCAST_ENABLE_ADDRESS_ARR[core_id] ))

/* <<<IC_MCAST_ENABLE */


/* >>>INGRESS_QOS_DONT_DROP_RATIO */

#define RDD_INGRESS_QOS_DONT_DROP_RATIO_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_QOS_DONT_DROP_RATIO_STRUCT;

extern uint32_t RDD_INGRESS_QOS_DONT_DROP_RATIO_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_QOS_DONT_DROP_RATIO_PTR(core_id)	( INGRESS_QOS_DONT_DROP_RATIO_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_QOS_DONT_DROP_RATIO_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_QOS_DONT_DROP_RATIO */


/* >>>TUNNELS_PARSING_CFG */

/* >>>TUNNELS_PARSING_CFG_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved0       	;
        uint8_t	tunneling_enable	;
        uint16_t	res_offset      	;
        uint32_t	reserved1       	;
#else
        uint16_t	res_offset      	;
        uint8_t	tunneling_enable	;
        uint8_t	reserved0       	;
        uint32_t	reserved1       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TUNNELS_PARSING_CFG_STRUCT;

#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 1, (r))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 1, (v))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_L_READ( wv )               FIELD_GET( wv, 16, 8 )
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_L_WRITE( v, wv )           FIELD_SET( v, 16, 8, wv )
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 2, (r))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 2, (v))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_READ(r, p)                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_L_READ( wv )                     FIELD_GET( wv, 0, 16 )
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_L_WRITE( v, wv )                 FIELD_SET( v, 0, 16, wv )
/* <<<TUNNELS_PARSING_CFG_STRUCT */


#define RDD_TUNNELS_PARSING_CFG_SIZE     1
typedef struct
{
	TUNNELS_PARSING_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TUNNELS_PARSING_CFG_TABLE_STRUCT;

extern uint32_t RDD_TUNNELS_PARSING_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TUNNELS_PARSING_CFG_PTR(core_id)	( TUNNELS_PARSING_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TUNNELS_PARSING_CFG_ADDRESS_ARR[core_id] ))

/* <<<TUNNELS_PARSING_CFG */


/* >>>LOOPBACK_QUEUE_TABLE */

#define RDD_LOOPBACK_QUEUE_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_LOOPBACK_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ LOOPBACK_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_LOOPBACK_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_LOOPBACK_QUEUE_TABLE_PTR(core_id)	( LOOPBACK_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_LOOPBACK_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<LOOPBACK_QUEUE_TABLE */


/* >>>IPTV_CFG_TABLE */

/* >>>IPTV_CFG_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset    	;
        uint16_t	context_offset	;
        uint16_t	key_offset    	;
        uint8_t	hash_tbl_idx  	;
        uint8_t	l2_mcast      	;
#else
        uint16_t	context_offset	;
        uint16_t	res_offset    	;
        uint8_t	l2_mcast      	;
        uint8_t	hash_tbl_idx  	;
        uint16_t	key_offset    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_CFG_STRUCT;

#define RDD_IPTV_CFG_RES_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (r))
#define RDD_IPTV_CFG_RES_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (v))
#define RDD_IPTV_CFG_RES_OFFSET_READ(r, p)                     MREAD_16((uint8_t *)(p), (r))
#define RDD_IPTV_CFG_RES_OFFSET_WRITE(v, p)                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (r))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (v))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_CFG_KEY_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (r))
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (v))
#define RDD_IPTV_CFG_KEY_OFFSET_READ(r, p)                     MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (r))
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (v))
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ(r, p)                   MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_CFG_L2_MCAST_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (r))
#define RDD_IPTV_CFG_L2_MCAST_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (v))
#define RDD_IPTV_CFG_L2_MCAST_READ(r, p)                       MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_IPTV_CFG_L2_MCAST_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<IPTV_CFG_STRUCT */


#define RDD_IPTV_CFG_TABLE_SIZE     1
typedef struct
{
	IPTV_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_CFG_TABLE_STRUCT;

extern uint32_t RDD_IPTV_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_CFG_TABLE_PTR(core_id)	( IPTV_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPTV_CFG_TABLE */


/* >>>IPTV_DDR_CTX_TABLE_ADDRESS */

/* >>>IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	low       	;
        uint32_t	high      	;
#else
        uint32_t	low       	;
        uint32_t	high      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT;

#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT), (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT), (v))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT) + 4, (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT) + 4, (v))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT */


#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_SIZE     1
typedef struct
{
	IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_DDR_CTX_TABLE_ADDRESS_TABLE_STRUCT;

extern uint32_t RDD_IPTV_DDR_CTX_TABLE_ADDRESS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_PTR(core_id)	( IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_DDR_CTX_TABLE_ADDRESS_ADDRESS_ARR[core_id] ))

/* <<<IPTV_DDR_CTX_TABLE_ADDRESS */


/* >>>NAT_CACHE_CFG */

/* >>>NAT_CACHE_CFG_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset        	;
        uint16_t	context_offset    	;
        uint16_t	key_offset        	;
        uint32_t	reserved          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	three_tuple_enable	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	esp_filter_action 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	esp_filter_enable 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	context_offset    	;
        uint16_t	res_offset        	;
        uint32_t	esp_filter_enable 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	esp_filter_action 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	three_tuple_enable	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	key_offset        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} NAT_CACHE_CFG_STRUCT;

#define RDD_NAT_CACHE_CFG_RES_OFFSET_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT), (r))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT), (v))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_READ(r, p)                         MREAD_16((uint8_t *)(p), (r))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_WRITE(v, p)                        MWRITE_16((uint8_t *)(p), (v))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_L_READ( wv )                       FIELD_GET( wv, 16, 16 )
#define RDD_NAT_CACHE_CFG_RES_OFFSET_L_WRITE( v, wv )                   FIELD_SET( v, 16, 16, wv )
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 2, (r))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 2, (v))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_READ(r, p)                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_L_READ( wv )                   FIELD_GET( wv, 0, 16 )
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_L_WRITE( v, wv )               FIELD_SET( v, 0, 16, wv )
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_READ(r, p)                         MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_L_READ( wv )                       FIELD_GET( wv, 16, 16 )
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_L_WRITE( v, wv )                   FIELD_SET( v, 16, 16, wv )
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 2, 1, (r))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 2, 1, (v))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 6, 2, 1, (r))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 6, 2, 1, (v))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_L_READ( wv )               FIELD_GET( wv, 10, 1 )
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_L_WRITE( v, wv )           FIELD_SET( v, 10, 1, wv )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 1, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 1, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_L_READ( wv )                FIELD_GET( wv, 9, 1 )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_L_WRITE( v, wv )            FIELD_SET( v, 9, 1, wv )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 0, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 0, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_L_READ( wv )                FIELD_GET( wv, 8, 1 )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_L_WRITE( v, wv )            FIELD_SET( v, 8, 1, wv )
/* <<<NAT_CACHE_CFG_STRUCT */


#define RDD_NAT_CACHE_CFG_SIZE     1
typedef struct
{
	NAT_CACHE_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ NAT_CACHE_CFG_TABLE_STRUCT;

extern uint32_t RDD_NAT_CACHE_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NAT_CACHE_CFG_PTR(core_id)	( NAT_CACHE_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NAT_CACHE_CFG_ADDRESS_ARR[core_id] ))

/* <<<NAT_CACHE_CFG */


/* >>>INGRESS_QOS_WAN_UNTAGGED_PRIORITY */

#define RDD_INGRESS_QOS_WAN_UNTAGGED_PRIORITY_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_QOS_WAN_UNTAGGED_PRIORITY_STRUCT;

extern uint32_t RDD_INGRESS_QOS_WAN_UNTAGGED_PRIORITY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_QOS_WAN_UNTAGGED_PRIORITY_PTR(core_id)	( INGRESS_QOS_WAN_UNTAGGED_PRIORITY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_QOS_WAN_UNTAGGED_PRIORITY_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_QOS_WAN_UNTAGGED_PRIORITY */


/* >>>INGRESS_FILTER_PROFILE_TABLE */

/* >>>INGRESS_FILTER_CTRL_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_bypass   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	action_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	enable_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	action_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_bypass   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) INGRESS_FILTER_CTRL_STRUCT;

#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT), 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT), 0, 31, (v))
#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p), 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p), 0, 31, (v))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 7, 1, (r))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 7, 1, (v))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 0, 31, (v))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p) + 4, 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p) + 4, 0, 31, (v))
/* <<<INGRESS_FILTER_CTRL_STRUCT */


#define RDD_INGRESS_FILTER_PROFILE_TABLE_SIZE     16
typedef struct
{
	INGRESS_FILTER_CTRL_STRUCT	entry[ RDD_INGRESS_FILTER_PROFILE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_PROFILE_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_PROFILE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_PROFILE_TABLE_PTR(core_id)	( INGRESS_FILTER_PROFILE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_PROFILE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_PROFILE_TABLE */


/* >>>TCAM_IC_CFG_TABLE */

/* >>>TCAM_IC_CFG_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset           	;
        uint16_t	context_offset       	;
        uint16_t	cmd_table            	;
        uint16_t	scratch_offset       	;
        uint32_t	table_id             	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_size             	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved             	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	classification_result	;
#else
        uint16_t	context_offset       	;
        uint16_t	res_offset           	;
        uint16_t	scratch_offset       	;
        uint16_t	cmd_table            	;
        uint32_t	enable               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved             	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_size             	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_id             	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	classification_result	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TCAM_IC_CFG_STRUCT;

#define RDD_TCAM_IC_CFG_RES_OFFSET_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT), (r))
#define RDD_TCAM_IC_CFG_RES_OFFSET_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT), (v))
#define RDD_TCAM_IC_CFG_RES_OFFSET_READ(r, p)                            MREAD_16((uint8_t *)(p), (r))
#define RDD_TCAM_IC_CFG_RES_OFFSET_WRITE(v, p)                           MWRITE_16((uint8_t *)(p), (v))
#define RDD_TCAM_IC_CFG_RES_OFFSET_L_READ( wv )                          FIELD_GET( wv, 16, 16 )
#define RDD_TCAM_IC_CFG_RES_OFFSET_L_WRITE( v, wv )                      FIELD_SET( v, 16, 16, wv )
#define RDD_TCAM_IC_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 2, (r))
#define RDD_TCAM_IC_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 2, (v))
#define RDD_TCAM_IC_CFG_CONTEXT_OFFSET_READ(r, p)                        MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_TCAM_IC_CFG_CONTEXT_OFFSET_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_TCAM_IC_CFG_CONTEXT_OFFSET_L_READ( wv )                      FIELD_GET( wv, 0, 16 )
#define RDD_TCAM_IC_CFG_CONTEXT_OFFSET_L_WRITE( v, wv )                  FIELD_SET( v, 0, 16, wv )
#define RDD_TCAM_IC_CFG_CMD_TABLE_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 4, (r))
#define RDD_TCAM_IC_CFG_CMD_TABLE_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 4, (v))
#define RDD_TCAM_IC_CFG_CMD_TABLE_READ(r, p)                             MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCAM_IC_CFG_CMD_TABLE_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCAM_IC_CFG_CMD_TABLE_L_READ( wv )                           FIELD_GET( wv, 16, 16 )
#define RDD_TCAM_IC_CFG_CMD_TABLE_L_WRITE( v, wv )                       FIELD_SET( v, 16, 16, wv )
#define RDD_TCAM_IC_CFG_SCRATCH_OFFSET_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 6, (r))
#define RDD_TCAM_IC_CFG_SCRATCH_OFFSET_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 6, (v))
#define RDD_TCAM_IC_CFG_SCRATCH_OFFSET_READ(r, p)                        MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCAM_IC_CFG_SCRATCH_OFFSET_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_TCAM_IC_CFG_SCRATCH_OFFSET_L_READ( wv )                      FIELD_GET( wv, 0, 16 )
#define RDD_TCAM_IC_CFG_SCRATCH_OFFSET_L_WRITE( v, wv )                  FIELD_SET( v, 0, 16, wv )
#define RDD_TCAM_IC_CFG_TABLE_ID_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 8, 5, 3, (r))
#define RDD_TCAM_IC_CFG_TABLE_ID_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 8, 5, 3, (v))
#define RDD_TCAM_IC_CFG_TABLE_ID_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 3, (r))
#define RDD_TCAM_IC_CFG_TABLE_ID_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 3, (v))
#define RDD_TCAM_IC_CFG_TABLE_ID_L_READ( wv )                            FIELD_GET( wv, 29, 3 )
#define RDD_TCAM_IC_CFG_TABLE_ID_L_WRITE( v, wv )                        FIELD_SET( v, 29, 3, wv )
#define RDD_TCAM_IC_CFG_KEY_SIZE_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 8, 0, 13, (r))
#define RDD_TCAM_IC_CFG_KEY_SIZE_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 8, 0, 13, (v))
#define RDD_TCAM_IC_CFG_KEY_SIZE_READ(r, p)                              FIELD_MREAD_16((uint8_t *)(p) + 8, 0, 13, (r))
#define RDD_TCAM_IC_CFG_KEY_SIZE_WRITE(v, p)                             FIELD_MWRITE_16((uint8_t *)(p) + 8, 0, 13, (v))
#define RDD_TCAM_IC_CFG_KEY_SIZE_L_READ( wv )                            FIELD_GET( wv, 16, 13 )
#define RDD_TCAM_IC_CFG_KEY_SIZE_L_WRITE( v, wv )                        FIELD_SET( v, 16, 13, wv )
#define RDD_TCAM_IC_CFG_ENABLE_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 11, 0, 1, (r))
#define RDD_TCAM_IC_CFG_ENABLE_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 11, 0, 1, (v))
#define RDD_TCAM_IC_CFG_ENABLE_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 1, (r))
#define RDD_TCAM_IC_CFG_ENABLE_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 1, (v))
#define RDD_TCAM_IC_CFG_ENABLE_L_READ( wv )                              FIELD_GET( wv, 0, 1 )
#define RDD_TCAM_IC_CFG_ENABLE_L_WRITE( v, wv )                          FIELD_SET( v, 0, 1, wv )
#define RDD_TCAM_IC_CFG_CLASSIFICATION_RESULT_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 12, (r))
#define RDD_TCAM_IC_CFG_CLASSIFICATION_RESULT_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(TCAM_IC_CFG_STRUCT) + 12, (v))
#define RDD_TCAM_IC_CFG_CLASSIFICATION_RESULT_READ(r, p)                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCAM_IC_CFG_CLASSIFICATION_RESULT_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCAM_IC_CFG_CLASSIFICATION_RESULT_L_READ( wv )               FIELD_GET( wv, 0, 32 )
#define RDD_TCAM_IC_CFG_CLASSIFICATION_RESULT_L_WRITE( v, wv )           FIELD_SET( v, 0, 32, wv )
/* <<<TCAM_IC_CFG_STRUCT */


#define RDD_TCAM_IC_CFG_TABLE_SIZE     8
typedef struct
{
	TCAM_IC_CFG_STRUCT	entry[ RDD_TCAM_IC_CFG_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCAM_IC_CFG_TABLE_STRUCT;

extern uint32_t RDD_TCAM_IC_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCAM_IC_CFG_TABLE_PTR(core_id)	( TCAM_IC_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCAM_IC_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCAM_IC_CFG_TABLE */


/* >>>VPORT_PBIT_TO_DISCARD_PRIO_VECTOR */

#define RDD_VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_STRUCT;

extern uint32_t RDD_VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_PTR(core_id)	( VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_PBIT_TO_DISCARD_PRIO_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<VPORT_PBIT_TO_DISCARD_PRIO_VECTOR */


/* >>>INGRESS_FILTER_CFG */

/* >>>INGRESS_FILTER_CFG_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset	;
#else
        uint16_t	res_offset	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) INGRESS_FILTER_CFG_STRUCT;

#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(INGRESS_FILTER_CFG_STRUCT), (r))
#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(INGRESS_FILTER_CFG_STRUCT), (v))
#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<INGRESS_FILTER_CFG_STRUCT */


#define RDD_INGRESS_FILTER_CFG_SIZE     1
typedef struct
{
	INGRESS_FILTER_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_CFG_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_CFG_PTR(core_id)	( INGRESS_FILTER_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_CFG_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_CFG */


/* >>>CPU_REDIRECT_MODE */

/* >>>CPU_REDIRECT_MODE_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	mode      	;
#else
        uint8_t	mode      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} CPU_REDIRECT_MODE_ENTRY_STRUCT;

#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<CPU_REDIRECT_MODE_ENTRY_STRUCT */


#define RDD_CPU_REDIRECT_MODE_SIZE     1
typedef struct
{
	CPU_REDIRECT_MODE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_REDIRECT_MODE_STRUCT;

extern uint32_t RDD_CPU_REDIRECT_MODE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_REDIRECT_MODE_PTR(core_id)	( CPU_REDIRECT_MODE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_REDIRECT_MODE_ADDRESS_ARR[core_id] ))

/* <<<CPU_REDIRECT_MODE */


/* >>>IPTV_CLASSIFICATION_CFG_TABLE */

/* >>>IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	da_prefix_mode_mac	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_ip 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	reserved1         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_ip 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_mac	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT;

#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
/* <<<IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT */


#define RDD_IPTV_CLASSIFICATION_CFG_TABLE_SIZE     1
typedef struct
{
	IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_CLASSIFICATION_CFG_TABLE_STRUCT;

extern uint32_t RDD_IPTV_CLASSIFICATION_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_CLASSIFICATION_CFG_TABLE_PTR(core_id)	( IPTV_CLASSIFICATION_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_CLASSIFICATION_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPTV_CLASSIFICATION_CFG_TABLE */


/* >>>INGRESS_FILTER_1588_CFG */

#define RDD_INGRESS_FILTER_1588_CFG_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_1588_CFG_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_1588_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_1588_CFG_PTR(core_id)	( INGRESS_FILTER_1588_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_1588_CFG_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_1588_CFG */


/* >>>VLAN_ACTION_GPE_HANDLER_PTR_TABLE */

#define RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_SIZE     17
typedef struct
{
	BYTES_2_STRUCT	entry[ RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VLAN_ACTION_GPE_HANDLER_PTR_TABLE_STRUCT;

extern uint32_t RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_PTR(core_id)	( VLAN_ACTION_GPE_HANDLER_PTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VLAN_ACTION_GPE_HANDLER_PTR_TABLE */


/* >>>TUNNEL_TABLE */

/* >>>TUNNEL_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	local_ip            	;
        uint8_t	tunnel_type         	;
        uint8_t	tunnel_header_length	;
        uint32_t	ip_family           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	layer3_offset       	;
        uint16_t	layer3_total_len    	;
        uint16_t	layer3_chksum       	;
        uint8_t	gre_proto_offset    	;
        uint8_t	layer4_offset       	;
        uint16_t	reserved1           	;
#else
        uint32_t	local_ip            	;
        uint8_t	layer3_offset       	;
        uint32_t	reserved0           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_family           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tunnel_header_length	;
        uint8_t	tunnel_type         	;
        uint16_t	layer3_chksum       	;
        uint16_t	layer3_total_len    	;
        uint16_t	reserved1           	;
        uint8_t	layer4_offset       	;
        uint8_t	gre_proto_offset    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TUNNEL_ENTRY_STRUCT;

#define RDD_TUNNEL_ENTRY_LOCAL_IP_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT), (r))
#define RDD_TUNNEL_ENTRY_LOCAL_IP_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT), (v))
#define RDD_TUNNEL_ENTRY_LOCAL_IP_READ(r, p)                             MREAD_32((uint8_t *)(p), (r))
#define RDD_TUNNEL_ENTRY_LOCAL_IP_WRITE(v, p)                            MWRITE_32((uint8_t *)(p), (v))
#define RDD_TUNNEL_ENTRY_TUNNEL_TYPE_READ_G(r, g, idx)                   GROUP_MREAD_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 4, (r))
#define RDD_TUNNEL_ENTRY_TUNNEL_TYPE_WRITE_G(v, g, idx)                  GROUP_MWRITE_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 4, (v))
#define RDD_TUNNEL_ENTRY_TUNNEL_TYPE_READ(r, p)                          MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_TUNNEL_ENTRY_TUNNEL_TYPE_WRITE(v, p)                         MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_TUNNEL_ENTRY_TUNNEL_HEADER_LENGTH_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 5, (r))
#define RDD_TUNNEL_ENTRY_TUNNEL_HEADER_LENGTH_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 5, (v))
#define RDD_TUNNEL_ENTRY_TUNNEL_HEADER_LENGTH_READ(r, p)                 MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_TUNNEL_ENTRY_TUNNEL_HEADER_LENGTH_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_TUNNEL_ENTRY_IP_FAMILY_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 6, 7, 1, (r))
#define RDD_TUNNEL_ENTRY_IP_FAMILY_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 6, 7, 1, (v))
#define RDD_TUNNEL_ENTRY_IP_FAMILY_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 6, 7, 1, (r))
#define RDD_TUNNEL_ENTRY_IP_FAMILY_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 6, 7, 1, (v))
#define RDD_TUNNEL_ENTRY_LAYER3_OFFSET_READ_G(r, g, idx)                 GROUP_MREAD_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 7, (r))
#define RDD_TUNNEL_ENTRY_LAYER3_OFFSET_WRITE_G(v, g, idx)                GROUP_MWRITE_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 7, (v))
#define RDD_TUNNEL_ENTRY_LAYER3_OFFSET_READ(r, p)                        MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_TUNNEL_ENTRY_LAYER3_OFFSET_WRITE(v, p)                       MWRITE_8((uint8_t *)(p) + 7, (v))
#define RDD_TUNNEL_ENTRY_LAYER3_TOTAL_LEN_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 8, (r))
#define RDD_TUNNEL_ENTRY_LAYER3_TOTAL_LEN_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 8, (v))
#define RDD_TUNNEL_ENTRY_LAYER3_TOTAL_LEN_READ(r, p)                     MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_TUNNEL_ENTRY_LAYER3_TOTAL_LEN_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_TUNNEL_ENTRY_LAYER3_CHKSUM_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 10, (r))
#define RDD_TUNNEL_ENTRY_LAYER3_CHKSUM_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 10, (v))
#define RDD_TUNNEL_ENTRY_LAYER3_CHKSUM_READ(r, p)                        MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_TUNNEL_ENTRY_LAYER3_CHKSUM_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_TUNNEL_ENTRY_GRE_PROTO_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 12, (r))
#define RDD_TUNNEL_ENTRY_GRE_PROTO_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 12, (v))
#define RDD_TUNNEL_ENTRY_GRE_PROTO_OFFSET_READ(r, p)                     MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_TUNNEL_ENTRY_GRE_PROTO_OFFSET_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_TUNNEL_ENTRY_LAYER4_OFFSET_READ_G(r, g, idx)                 GROUP_MREAD_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 13, (r))
#define RDD_TUNNEL_ENTRY_LAYER4_OFFSET_WRITE_G(v, g, idx)                GROUP_MWRITE_8((g), (idx)*sizeof(TUNNEL_ENTRY_STRUCT) + 13, (v))
#define RDD_TUNNEL_ENTRY_LAYER4_OFFSET_READ(r, p)                        MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_TUNNEL_ENTRY_LAYER4_OFFSET_WRITE(v, p)                       MWRITE_8((uint8_t *)(p) + 13, (v))
/* <<<TUNNEL_ENTRY_STRUCT */


#define RDD_TUNNEL_TABLE_SIZE     2
typedef struct
{
	TUNNEL_ENTRY_STRUCT	entry[ RDD_TUNNEL_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TUNNEL_TABLE_STRUCT;

extern uint32_t RDD_TUNNEL_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TUNNEL_TABLE_PTR(core_id)	( TUNNEL_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TUNNEL_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TUNNEL_TABLE */


/* >>>TUNNEL_HEADER_PSRAM_BUFFER */

/* >>>TUNNEL_HEADER_PSRAM_BUFFER_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	number    	;
#else
        uint32_t	number    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) TUNNEL_HEADER_PSRAM_BUFFER_STRUCT;

#define RDD_TUNNEL_HEADER_PSRAM_BUFFER_NUMBER_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(TUNNEL_HEADER_PSRAM_BUFFER_STRUCT), (r))
#define RDD_TUNNEL_HEADER_PSRAM_BUFFER_NUMBER_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(TUNNEL_HEADER_PSRAM_BUFFER_STRUCT), (v))
#define RDD_TUNNEL_HEADER_PSRAM_BUFFER_NUMBER_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_TUNNEL_HEADER_PSRAM_BUFFER_NUMBER_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
/* <<<TUNNEL_HEADER_PSRAM_BUFFER_STRUCT */


#define RDD_TUNNEL_HEADER_PSRAM_BUFFER_SIZE     1
typedef struct
{
	TUNNEL_HEADER_PSRAM_BUFFER_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TUNNEL_HEADER_PSRAM_BUFFER_TABLE_STRUCT;

extern uint32_t RDD_TUNNEL_HEADER_PSRAM_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TUNNEL_HEADER_PSRAM_BUFFER_PTR(core_id)	( TUNNEL_HEADER_PSRAM_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TUNNEL_HEADER_PSRAM_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<TUNNEL_HEADER_PSRAM_BUFFER */


/* >>>BITS_CALC_MASKS_TABLE */

#define RDD_BITS_CALC_MASKS_TABLE_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_BITS_CALC_MASKS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BITS_CALC_MASKS_TABLE_STRUCT;

extern uint32_t RDD_BITS_CALC_MASKS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BITS_CALC_MASKS_TABLE_PTR(core_id)	( BITS_CALC_MASKS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BITS_CALC_MASKS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BITS_CALC_MASKS_TABLE */


/* >>>MULTICAST_KEY_MASK */

/* >>>MULTICAST_KEY_MASK_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	vlan_mask 	;
        uint16_t	etype_mask	;
#else
        uint16_t	etype_mask	;
        uint16_t	vlan_mask 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) MULTICAST_KEY_MASK_ENTRY_STRUCT;

#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<MULTICAST_KEY_MASK_ENTRY_STRUCT */


#define RDD_MULTICAST_KEY_MASK_SIZE     1
typedef struct
{
	MULTICAST_KEY_MASK_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MULTICAST_KEY_MASK_STRUCT;

extern uint32_t RDD_MULTICAST_KEY_MASK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MULTICAST_KEY_MASK_PTR(core_id)	( MULTICAST_KEY_MASK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MULTICAST_KEY_MASK_ADDRESS_ARR[core_id] ))

/* <<<MULTICAST_KEY_MASK */

/* CORE_5 */
/* CORE_6 */
/* CORE_7 */
/* CORE_8 */
/* CORE_9 */
/* CORE_10 */
/* CORE_11 */
/* CORE_12 */
/* CORE_13 */
/* CORE_14 */
/* CORE_15 */

#ifdef G9991

/* >>>RDD_DISP_REOR_VIQ */
typedef enum
{
	DISP_REOR_VIQ_FIRST                  = 0,
	DISP_REOR_VIQ_BBH_RX0_NORMAL         = 0,
	DISP_REOR_VIQ_BBH_RX1_NORMAL         = 1,
	DISP_REOR_VIQ_BBH_RX2_NORMAL         = 2,
	DISP_REOR_VIQ_BBH_RX3_NORMAL         = 3,
	DISP_REOR_VIQ_BBH_RX4_NORMAL         = 4,
	DISP_REOR_VIQ_BBH_RX5_NORMAL         = 5,
	DISP_REOR_VIQ_BBH_RX6_NORMAL         = 6,
	DISP_REOR_VIQ_BBH_RX7_NORMAL         = 7,
	DISP_REOR_VIQ_BBH_RX8_NORMAL         = 8,
	DISP_REOR_VIQ_BBH_RX0_EXCL           = 9,
	DISP_REOR_VIQ_BBH_RX1_EXCL           = 10,
	DISP_REOR_VIQ_BBH_RX2_EXCL           = 11,
	DISP_REOR_VIQ_BBH_RX3_EXCL           = 12,
	DISP_REOR_VIQ_BBH_RX4_EXCL           = 13,
	DISP_REOR_VIQ_BBH_RX5_EXCL           = 14,
	DISP_REOR_VIQ_BBH_RX6_EXCL           = 15,
	DISP_REOR_VIQ_BBH_RX7_EXCL           = 16,
	DISP_REOR_VIQ_BBH_RX8_EXCL           = 17,
	DISP_REOR_VIQ_EPON_TM                = 18,
	DISP_REOR_VIQ_CPU_TX_EGRESS          = 19,
	DISP_REOR_VIQ_CPU_TX_FORWARD         = 20,
	DISP_REOR_VIQ_US_TM_FLUSH            = 21,
	DISP_REOR_VIQ_DS_TM_FLUSH            = 22,
	DISP_REOR_VIQ_TX_MIRRORING           = 23,
	DISP_REOR_VIQ_CPU_RX_COPY            = 29,
	DISP_REOR_VIQ_WAN_LOOPBACK           = 30,
	DISP_REOR_VIQ_DS_TM_FLUSH_BBH_2_3    = 31,
	DISP_REOR_VIQ_LAST                   = 31
} rdd_disp_reor_viq;
/* <<<RDD_DISP_REOR_VIQ */


/* >>>RDD_SID */
typedef enum
{
	SID_FIRST = 0,
	SID_0     = 0,
	SID_1     = 1,
	SID_2     = 2,
	SID_3     = 3,
	SID_4     = 4,
	SID_5     = 5,
	SID_6     = 6,
	SID_7     = 7,
	SID_8     = 8,
	SID_9     = 9,
	SID_10    = 10,
	SID_11    = 11,
	SID_12    = 12,
	SID_13    = 13,
	SID_14    = 14,
	SID_15    = 15,
	SID_16    = 16,
	SID_17    = 17,
	SID_18    = 18,
	SID_19    = 19,
	SID_20    = 20,
	SID_21    = 21,
	SID_22    = 22,
	SID_23    = 23,
	SID_24    = 24,
	SID_25    = 25,
	SID_26    = 26,
	SID_27    = 27,
	SID_28    = 28,
	SID_29    = 29,
	SID_30    = 30,
	SID_31    = 31,
	SID_LAST  = 31
} rdd_sid;
/* <<<RDD_SID */


/* >>>RDD_IMAGE_0_DS_TM_TIMER_INDEX */
typedef enum
{
	IMAGE_0_DS_TM_TIMER_INDEX_FIRST       = 0,
	IMAGE_0_DS_TM_TIMER_INDEX_FLUSH       = 0,
	IMAGE_0_DS_TM_TIMER_INDEX_BUDGET_ALLOCATOR = 2,
	IMAGE_0_DS_TM_TIMER_INDEX_LAST        = 2
} rdd_ds_tm_timer_index;
/* <<<RDD_IMAGE_0_DS_TM_TIMER_INDEX */


/* >>>RDD_IMAGE_1_CPU_IF_1_TIMER_INDEX */
typedef enum
{
	IMAGE_1_CPU_IF_1_TIMER_INDEX_FIRST                    = 0,
	IMAGE_1_CPU_IF_1_TIMER_INDEX_INTERRUPT_COALESCING     = 0,
	IMAGE_1_CPU_IF_1_TIMER_INDEX_CPU_RX_METER_BUDGET_ALLOCATOR = 1,
	IMAGE_1_CPU_IF_1_TIMER_INDEX_LAST                     = 1
} rdd_cpu_if_1_timer_index;
/* <<<RDD_IMAGE_1_CPU_IF_1_TIMER_INDEX */


/* >>>RDD_IMAGE_2_CPU_IF_2_TIMER_INDEX */
typedef enum
{
	IMAGE_2_CPU_IF_2_TIMER_INDEX_FIRST           = 0,
	IMAGE_2_CPU_IF_2_TIMER_INDEX_REPORTING       = 0,
	IMAGE_2_CPU_IF_2_TIMER_INDEX_INTERRUPT_COALESCING = 2,
	IMAGE_2_CPU_IF_2_TIMER_INDEX_TIMER_COMMON    = 3,
	IMAGE_2_CPU_IF_2_TIMER_INDEX_LAST            = 3
} rdd_cpu_if_2_timer_index;
/* <<<RDD_IMAGE_2_CPU_IF_2_TIMER_INDEX */


/* >>>RDD_IMAGE_3_US_TM_TIMER_INDEX */
typedef enum
{
	IMAGE_3_US_TM_TIMER_INDEX_FIRST           = 0,
	IMAGE_3_US_TM_TIMER_INDEX_FLUSH           = 0,
	IMAGE_3_US_TM_TIMER_INDEX_OVL_BUDGET_ALLOCATOR = 1,
	IMAGE_3_US_TM_TIMER_INDEX_BUDGET_ALLOCATOR = 2,
	IMAGE_3_US_TM_TIMER_INDEX_PAUSE_FRAME     = 3,
	IMAGE_3_US_TM_TIMER_INDEX_LAST            = 3
} rdd_us_tm_timer_index;
/* <<<RDD_IMAGE_3_US_TM_TIMER_INDEX */


/* >>>RDD_GENERAL_COUNTER */
typedef enum
{
	GENERAL_COUNTER_FIRST                    = 0,
	GENERAL_COUNTER_WAN_CRC_ERR_ID           = 0,
	GENERAL_COUNTER_RX_IPTV_VALID_PKT        = 1,
	GENERAL_COUNTER_RX_IPTV_VALID_BYTES      = 2,
	GENERAL_COUNTER_IPTV_TOTAL_DROP_PKT      = 3,
	GENERAL_COUNTER_IPTV_TOTAL_DROP_BYTES    = 4,
	GENERAL_COUNTER_LAST                     = 4
} rdd_general_counter;
/* <<<RDD_GENERAL_COUNTER */


/* >>>RDD_QM_QUEUE */
typedef enum
{
	QM_QUEUE_FIRST                         = 0,
	QM_QUEUE_SERVICE_Q_MAX_QUANTITY        = 0,
	QM_QUEUE_SERVICE_Q_DEFAULT_QUANTITY    = 0,
	QM_QUEUE_DYNAMIC_EPON                  = 32,
	QM_QUEUE_US_DEFAULT_QUANTITY           = 64,
	QM_QUEUE_DS_DEFAULT_QUANTITY           = 160,
	QM_QUEUE_CPU_RX                        = 256,
	QM_QUEUE_MAX_DYNAMIC_QUANTITY          = 256,
	QM_QUEUE_CPU_RX_COPY_NORMAL            = 257,
	QM_QUEUE_CPU_RX_COPY_EXCLUSIVE         = 258,
	QM_QUEUE_LAST                          = 258
} rdd_qm_queue;
/* <<<RDD_QM_QUEUE */


/* >>>RDD_IMAGE_0_DS_TM */
typedef enum
{
	IMAGE_0_DS_TM_FIRST                      = 0,
	IMAGE_0_DS_TM_FLOW_CONTROL_THREAD_NUMBER = 0,
	IMAGE_0_DS_TM_BUDGET_ALLOCATION_THREAD_NUMBER = 1,
	IMAGE_0_DS_TM_UPDATE_FIFO_THREAD_NUMBER  = 2,
	IMAGE_0_DS_TM_FLUSH_THREAD_NUMBER        = 3,
	IMAGE_0_DS_TM_LAN0_THREAD_NUMBER         = 4,
	IMAGE_0_DS_TM_LAN1_THREAD_NUMBER         = 5,
	IMAGE_0_DS_TM_LAN2_THREAD_NUMBER         = 6,
	IMAGE_0_DS_TM_LAN3_THREAD_NUMBER         = 7,
	IMAGE_0_DS_TM_LAN4_THREAD_NUMBER         = 8,
	IMAGE_0_DS_TM_LAN5_THREAD_NUMBER         = 9,
	IMAGE_0_DS_TM_LAST                       = 9
} rdd_ds_tm;
/* <<<RDD_IMAGE_0_DS_TM */


/* >>>RDD_IMAGE_1_CPU_IF_1 */
typedef enum
{
	IMAGE_1_CPU_IF_1_FIRST                                  = 2,
	IMAGE_1_CPU_IF_1_CPU_RX_THREAD_NUMBER                   = 2,
	IMAGE_1_CPU_IF_1_INTERRUPT_COALESCING_THREAD_NUMBER     = 3,
	IMAGE_1_CPU_IF_1_CPU_RX_METER_BUDGET_ALLOCATOR_THREAD_NUMBER = 4,
	IMAGE_1_CPU_IF_1_CPU_RECYCLE_THREAD_NUMBER              = 12,
	IMAGE_1_CPU_IF_1_CPU_RX_COPY_THREAD_NUMBER              = 13,
	IMAGE_1_CPU_IF_1_LAST                                   = 13
} rdd_cpu_if_1;
/* <<<RDD_IMAGE_1_CPU_IF_1 */


/* >>>RDD_IMAGE_2_CPU_IF_2 */
typedef enum
{
	IMAGE_2_CPU_IF_2_FIRST                         = 0,
	IMAGE_2_CPU_IF_2_BUDGET_ALLOCATOR_THREAD_NUMBER = 0,
	IMAGE_2_CPU_IF_2_CPU_RECYCLE_THREAD_NUMBER     = 1,
	IMAGE_2_CPU_IF_2_REPORTING_THREAD_NUMBER       = 2,
	IMAGE_2_CPU_IF_2_INTERRUPT_COALESCING_THREAD_NUMBER = 3,
	IMAGE_2_CPU_IF_2_TIMER_COMMON_THREAD_NUMBER    = 4,
	IMAGE_2_CPU_IF_2_CPU_TX_0_THREAD_NUMBER        = 8,
	IMAGE_2_CPU_IF_2_CPU_TX_1_THREAD_NUMBER        = 9,
	IMAGE_2_CPU_IF_2_LAST                          = 9
} rdd_cpu_if_2;
/* <<<RDD_IMAGE_2_CPU_IF_2 */


/* >>>RDD_IMAGE_3_US_TM */
typedef enum
{
	IMAGE_3_US_TM_FIRST                          = 0,
	IMAGE_3_US_TM_DIRECT_FLOW_THREAD_NUMBER      = 0,
	IMAGE_3_US_TM_BUDGET_ALLOCATION_THREAD_NUMBER = 1,
	IMAGE_3_US_TM_OVL_BUDGET_ALLOCATION_THREAD_NUMBER = 2,
	IMAGE_3_US_TM_UPDATE_FIFO_THREAD_NUMBER      = 3,
	IMAGE_3_US_TM_UPDATE_FIFO_EPON_THREAD_NUMBER = 4,
	IMAGE_3_US_TM_FLUSH_THREAD_NUMBER            = 5,
	IMAGE_3_US_TM_WAN_0_THREAD_NUMBER            = 6,
	IMAGE_3_US_TM_WAN_1_THREAD_NUMBER            = 7,
	IMAGE_3_US_TM_WAN_EPON_THREAD_NUMBER         = 8,
	IMAGE_3_US_TM_LAST                           = 8
} rdd_us_tm;
/* <<<RDD_IMAGE_3_US_TM */


/* >>>RDD_IMAGE_4_PROCESSING */
typedef enum
{
	IMAGE_4_PROCESSING_FIRST      = 0,
	IMAGE_4_PROCESSING_0_THREAD_NUMBER = 0,
	IMAGE_4_PROCESSING_1_THREAD_NUMBER = 1,
	IMAGE_4_PROCESSING_2_THREAD_NUMBER = 2,
	IMAGE_4_PROCESSING_3_THREAD_NUMBER = 3,
	IMAGE_4_PROCESSING_4_THREAD_NUMBER = 4,
	IMAGE_4_PROCESSING_5_THREAD_NUMBER = 5,
	IMAGE_4_PROCESSING_6_THREAD_NUMBER = 6,
	IMAGE_4_PROCESSING_7_THREAD_NUMBER = 7,
	IMAGE_4_PROCESSING_LAST       = 7
} rdd_processing;
/* <<<RDD_IMAGE_4_PROCESSING */


/* >>>RDD_PROJ_DEFS */
typedef enum
{
	PROJ_DEFS_FIRST                                = 2,
	PROJ_DEFS_NUMBER_OF_NATC_TABLES                = 2,
	PROJ_DEFS_NUMBER_OF_CPU_RX_METERS              = 32,
	PROJ_DEFS_NUMBER_OF_EMACS                      = 32,
	PROJ_DEFS_RDD_VPORT_LAST                       = 40,
	PROJ_DEFS_NUMBER_OF_VPORTS                     = 40,
	PROJ_DEFS_NUMBER_OF_VPORTS_MULT_3              = 120,
	PROJ_DEFS_DBG_DUMP_TABLE_SIZE                  = 128,
	PROJ_DEFS_NUMBER_OF_VLANS                      = 256,
	PROJ_DEFS_NUMBER_OF_VLANS_PLUS_1               = 257,
	PROJ_DEFS_NUMBER_OF_SHARED_IC_VLAN_COUNTERS    = 1152,
	PROJ_DEFS_NUMBER_OF_IC_COUNTERS                = 1152,
	PROJ_DEFS_HASH_NUM_OF_ENTRIES_IN_RAM           = 6144,
	PROJ_DEFS_LAST                                 = 6144
} rdd_proj_defs;
/* <<<RDD_PROJ_DEFS */


/* >>>RDD_PORT_MCST_BCST_GROUP */
typedef enum
{
	PORT_MCST_BCST_GROUP_FIRST                    = 0,
	PORT_MCST_BCST_GROUP_RX_MULTICAST_PKT         = 0,
	PORT_MCST_BCST_GROUP_RX_BROADCAST_PKT         = 32,
	PORT_MCST_BCST_GROUP_TX_MULTICAST_PKT         = 64,
	PORT_MCST_BCST_GROUP_TX_BROADCAST_PKT         = 96,
	PORT_MCST_BCST_GROUP_TX_BROADCAST_PKT_LAST    = 127,
	PORT_MCST_BCST_GROUP_TX_UNICAST_PKT           = 128,
	PORT_MCST_BCST_GROUP_RX_UNICAST_PKT           = 130,
	PORT_MCST_BCST_GROUP_LAST                     = 130
} rdd_port_mcst_bcst_group;
/* <<<RDD_PORT_MCST_BCST_GROUP */


/* >>>RDD_NATC_TBL_IDX */
typedef enum
{
	NATC_TBL_IDX_FIRST          = 0,
	NATC_TBL_IDX_VLAN_ACTION    = 0,
	NATC_TBL_IDX_DS             = 0,
	NATC_TBL_IDX_COUNTERS       = 1,
	NATC_TBL_IDX_LAST           = 1
} rdd_natc_tbl_idx;
/* <<<RDD_NATC_TBL_IDX */


/* >>>RDD_CTX_SIZE */
typedef enum
{
	CTX_SIZE_FIRST       = 0,
	CTX_SIZE_8           = 0,
	CTX_SIZE_16          = 1,
	CTX_SIZE_24          = 2,
	CTX_SIZE_32          = 3,
	CTX_SIZE_40          = 4,
	CTX_SIZE_48          = 5,
	CTX_SIZE_56          = 6,
	CTX_SIZE_64          = 7,
	CTX_SIZE_72          = 8,
	CTX_SIZE_80          = 9,
	CTX_SIZE_88          = 10,
	CTX_SIZE_96          = 11,
	CTX_SIZE_104         = 12,
	CTX_SIZE_112         = 13,
	CTX_SIZE_120         = 14,
	CTX_SIZE_128         = 15,
	CTX_SIZE_NOT_USED    = 16,
	CTX_SIZE_LAST        = 16
} rdd_ctx_size;
/* <<<RDD_CTX_SIZE */


/* >>>RDD_RNR */
typedef enum
{
	RNR_FIRST        = 0,
	RNR_CORE0_ID     = 0,
	RNR_CORE1_ID     = 1,
	RNR_CORE2_ID     = 2,
	RNR_CORE3_ID     = 3,
	RNR_CORE4_ID     = 4,
	RNR_CORE5_ID     = 5,
	RNR_CORE6_ID     = 6,
	RNR_CORE7_ID     = 7,
	RNR_CORE8_ID     = 8,
	RNR_CORE9_ID     = 9,
	RNR_CORE10_ID    = 10,
	RNR_CORE11_ID    = 11,
	RNR_CORE12_ID    = 12,
	RNR_CORE13_ID    = 13,
	RNR_CORE14_ID    = 14,
	RNR_CORE15_ID    = 15,
	RNR_LAST         = 15
} rdd_rnr;
/* <<<RDD_RNR */


/* >>>RDD_BB_ID */
typedef enum
{
	BB_ID_FIRST                 = 0,
	BB_ID_RNR0                  = 0,
	BB_ID_RNR1                  = 1,
	BB_ID_RNR2                  = 2,
	BB_ID_RNR3                  = 3,
	BB_ID_RNR4                  = 4,
	BB_ID_RNR5                  = 5,
	BB_ID_RNR6                  = 6,
	BB_ID_RNR7                  = 7,
	BB_ID_RNR8                  = 8,
	BB_ID_RNR9                  = 9,
	BB_ID_RNR10                 = 10,
	BB_ID_RNR11                 = 11,
	BB_ID_RNR12                 = 12,
	BB_ID_RNR13                 = 13,
	BB_ID_RNR14                 = 14,
	BB_ID_RNR15                 = 15,
	BB_ID_BBHLB                 = 16,
	BB_ID_CNPL                  = 17,
	BB_ID_DISPATCHER_REORDER    = 18,
	BB_ID_DMA0                  = 19,
	BB_ID_DMA1                  = 20,
	BB_ID_SDMA0                 = 21,
	BB_ID_SDMA1                 = 22,
	BB_ID_FPM                   = 23,
	BB_ID_HASH                  = 24,
	BB_ID_NATC                  = 25,
	BB_ID_QM_CP_SDMA            = 26,
	BB_ID_QM_RNR_GRID           = 27,
	BB_ID_QM_BBHTX              = 28,
	BB_ID_QM_TOP                = 29,
	BB_ID_QM_CP_MACHINE         = 30,
	BB_ID_RX_BBH_0              = 31,
	BB_ID_TX_BBH_0              = 32,
	BB_ID_RX_BBH_1              = 33,
	BB_ID_TX_BBH_1              = 34,
	BB_ID_RX_BBH_2              = 35,
	BB_ID_TX_BBH_2              = 36,
	BB_ID_RX_BBH_3              = 37,
	BB_ID_TX_BBH_3              = 38,
	BB_ID_RX_BBH_4              = 39,
	BB_ID_TX_BBH_4              = 40,
	BB_ID_RX_BBH_5              = 41,
	BB_ID_TX_BBH_5              = 42,
	BB_ID_RX_BBH_6              = 43,
	BB_ID_TX_BBH_6              = 44,
	BB_ID_RX_PON_ETH            = 45,
	BB_ID_TX_PON_ETH_PD         = 46,
	BB_ID_TX_PON_ETH_STAT       = 47,
	BB_ID_SBPM                  = 48,
	BB_ID_TCAM_0                = 49,
	BB_ID_TCAM_1                = 50,
	BB_ID_RX_BBH_7              = 51,
	BB_ID_TX_BBH_7              = 52,
	BB_ID_LAST                  = 52
} rdd_bb_id;
/* <<<RDD_BB_ID */


/* >>>RDD_PBIT_MAP */
typedef enum
{
	PBIT_MAP_FIRST     = 8,
	PBIT_MAP_NON_IP    = 8,
	PBIT_MAP_LAST      = 8
} rdd_pbit_map;
/* <<<RDD_PBIT_MAP */


/* >>>RDD_GLOBAL_CFG_REG */
typedef enum
{
	GLOBAL_CFG_REG_FIRST        = 0,
	GLOBAL_CFG_REG_IS_6858A0    = 0,
	GLOBAL_CFG_REG_LAST         = 0
} rdd_global_cfg_reg;
/* <<<RDD_GLOBAL_CFG_REG */


/* >>>RDD_HASH_TABLE */
typedef enum
{
	HASH_TABLE_FIRST                  = 1,
	HASH_TABLE_IPTV                   = 1,
	HASH_TABLE_ARL                    = 2,
	HASH_TABLE_BRIDGE_AND_VLAN_LKP    = 3,
	HASH_TABLE_LAST                   = 3
} rdd_hash_table;
/* <<<RDD_HASH_TABLE */


/* >>>RDD_BBH_QUEUE */
typedef enum
{
	BBH_QUEUE_FIRST             = 40,
	BBH_QUEUE_WAN_1_ENTRY_ID    = 40,
	BBH_QUEUE_LAST              = 40
} rdd_bbh_queue;
/* <<<RDD_BBH_QUEUE */


/* >>>RDD_NATC */
typedef enum
{
	NATC_FIRST                     = 3,
	NATC_LOOKUP_DEPTH_SIZE_LOG2    = 3,
	NATC_LOOKUP_DEPTH_SIZE         = 8,
	NATC_MAX_TABLES_NUM            = 8,
	NATC_TABLE_KEY_SIZE            = 16,
	NATC_TABLE_RES_SIZE            = 64,
	NATC_MAX_ENTRY_LEN             = 128,
	NATC_LAST                      = 128
} rdd_natc;
/* <<<RDD_NATC */


/* >>>RDD_CLASSIFICATION_RESULT_INDEX */
typedef enum
{
	CLASSIFICATION_RESULT_INDEX_FIRST                 = 0,
	CLASSIFICATION_RESULT_INDEX_INGRESS_FILTERS       = 0,
	CLASSIFICATION_RESULT_INDEX_TUNNELS_PARSING       = 1,
	CLASSIFICATION_RESULT_INDEX_IPTV                  = 1,
	CLASSIFICATION_RESULT_INDEX_TCAM_IC_FLOW          = 1,
	CLASSIFICATION_RESULT_INDEX_NAT_CACHE             = 2,
	CLASSIFICATION_RESULT_INDEX_TCAM_IC_ACL           = 2,
	CLASSIFICATION_RESULT_INDEX_TCAM_IC_QOS           = 3,
	CLASSIFICATION_RESULT_INDEX_TCAM_IC_IP_FLOW       = 3,
	CLASSIFICATION_RESULT_INDEX_BRIDGE                = 4,
	CLASSIFICATION_RESULT_INDEX_TUNNELS_IC_PARSING    = 5,
	CLASSIFICATION_RESULT_INDEX_LAST                  = 5
} rdd_classification_result_index;
/* <<<RDD_CLASSIFICATION_RESULT_INDEX */


/* >>>RDD_RULE_BASED_ACTION_VECTOR */
typedef enum
{
	RULE_BASED_ACTION_VECTOR_FIRST                       = 0,
	RULE_BASED_ACTION_VECTOR_DSCP_REMARK                 = 0,
	RULE_BASED_ACTION_VECTOR_NO_FWD                      = 1,
	RULE_BASED_ACTION_VECTOR_IPTV_COMMON_ACTIONS_EXIT    = 2,
	RULE_BASED_ACTION_VECTOR_VLAN_ACTION                 = 2,
	RULE_BASED_ACTION_VECTOR_DEI_COLOR                   = 3,
	RULE_BASED_ACTION_VECTOR_PBIT_REMARK                 = 4,
	RULE_BASED_ACTION_VECTOR_PBIT_TO_QUEUE               = 5,
	RULE_BASED_ACTION_VECTOR_TC_TO_QUEUE                 = 6,
	RULE_BASED_ACTION_VECTOR_PBIT_TO_GEM                 = 7,
	RULE_BASED_ACTION_VECTOR_DROP_PRECEDENCE             = 8,
	RULE_BASED_ACTION_VECTOR_SERVICE_QUEUE               = 9,
	RULE_BASED_ACTION_VECTOR_PBIT_COLOR                  = 10,
	RULE_BASED_ACTION_VECTOR_LAST                        = 10
} rdd_rule_based_action_vector;
/* <<<RDD_RULE_BASED_ACTION_VECTOR */


/* >>>RDD_FLOW_BASED_ACTION_VECTOR */
typedef enum
{
	FLOW_BASED_ACTION_VECTOR_FIRST                    = 0,
	FLOW_BASED_ACTION_VECTOR_POLICER                  = 0,
	FLOW_BASED_ACTION_VECTOR_TTL_DECREMENT            = 1,
	FLOW_BASED_ACTION_VECTOR_DSCP_REMARK              = 2,
	FLOW_BASED_ACTION_VECTOR_NAT_DS                   = 3,
	FLOW_BASED_ACTION_VECTOR_PPPOE                    = 4,
	FLOW_BASED_ACTION_VECTOR_NAT_US                   = 5,
	FLOW_BASED_ACTION_VECTOR_SKIP_L2_HDR_COPY         = 6,
	FLOW_BASED_ACTION_VECTOR_SKIP_HDR_COPY            = 7,
	FLOW_BASED_ACTION_VECTOR_EXCEPTION                = 8,
	FLOW_BASED_ACTION_VECTOR_NAT_66                   = 9,
	FLOW_BASED_ACTION_VECTOR_SPDSVC                   = 10,
	FLOW_BASED_ACTION_VECTOR_TCPSPDTEST               = 11,
	FLOW_BASED_ACTION_VECTOR_OUTER_PBITS_REMARKING    = 12,
	FLOW_BASED_ACTION_VECTOR_INNER_PBITS_REMARKING    = 13,
	FLOW_BASED_ACTION_VECTOR_QOS_MAPPING_US           = 14,
	FLOW_BASED_ACTION_VECTOR_QOS_MAPPING_DS           = 15,
	FLOW_BASED_ACTION_VECTOR_SERVICE_QUEUE            = 16,
	FLOW_BASED_ACTION_VECTOR_DROP_ELIGIBILITY_EN      = 17,
	FLOW_BASED_ACTION_VECTOR_DSLITE                   = 18,
	FLOW_BASED_ACTION_VECTOR_L2GRE                    = 19,
	FLOW_BASED_ACTION_VECTOR_LLC_SNAP_SET_LEN         = 20,
	FLOW_BASED_ACTION_VECTOR_MAPT                     = 21,
	FLOW_BASED_ACTION_VECTOR_SET_1588                 = 22,
	FLOW_BASED_ACTION_VECTOR_VXLAN                    = 23,
	FLOW_BASED_ACTION_VECTOR_HIGH_MASK                = 255,
	FLOW_BASED_ACTION_VECTOR_LAST                     = 255
} rdd_flow_based_action_vector;
/* <<<RDD_FLOW_BASED_ACTION_VECTOR */


/* >>>RDD_DIRECT_FLOW */
typedef enum
{
	DIRECT_FLOW_FIRST                             = 1,
	DIRECT_FLOW_PAUSE_MAC_CTRL_TYPE               = 1,
	DIRECT_FLOW_PAUSE_TIME_QUANTA_SHIFT_FACTOR    = 12,
	DIRECT_FLOW_LAST                              = 12
} rdd_direct_flow;
/* <<<RDD_DIRECT_FLOW */


/* >>>RDD_LINK_LOCAL_IP */
typedef enum
{
	LINK_LOCAL_IP_FIRST   = 65152,
	LINK_LOCAL_IP_IPV6    = 65152,
	LINK_LOCAL_IP_LAST    = 65152
} rdd_link_local_ip;
/* <<<RDD_LINK_LOCAL_IP */


/* >>>RDD_CPU_IF_RDD */
typedef enum
{
	CPU_IF_RDD_FIRST      = 0,
	CPU_IF_RDD_DATA       = 0,
	CPU_IF_RDD_RECYCLE    = 1,
	CPU_IF_RDD_FEED       = 2,
	CPU_IF_RDD_CPU_TX     = 3,
	CPU_IF_RDD_LAST       = 3
} rdd_cpu_if_rdd;
/* <<<RDD_CPU_IF_RDD */


/* >>>RDD_TM_UPDATE_VECTOR */
typedef enum
{
	TM_UPDATE_VECTOR_FIRST              = 0,
	TM_UPDATE_VECTOR_BS_DWRR_Q          = 0,
	TM_UPDATE_VECTOR_BS_Q_BRL           = 1,
	TM_UPDATE_VECTOR_BS_BRL_Q           = 2,
	TM_UPDATE_VECTOR_CS_DWRR_Q          = 3,
	TM_UPDATE_VECTOR_CS_DWRR_BS         = 4,
	TM_UPDATE_VECTOR_CS_DWRR_CS         = 5,
	TM_UPDATE_VECTOR_CS_BS_Q_BRL        = 6,
	TM_UPDATE_VECTOR_CS_Q_CRL_SIR       = 7,
	TM_UPDATE_VECTOR_CS_Q_CRL_PIR       = 8,
	TM_UPDATE_VECTOR_CS_BS_CRL_SIR_Q    = 9,
	TM_UPDATE_VECTOR_CS_BS_CRL_PIR_Q    = 10,
	TM_UPDATE_VECTOR_CS_CS_CRL_SIR_Q    = 11,
	TM_UPDATE_VECTOR_CS_CS_CRL_PIR_Q    = 12,
	TM_UPDATE_VECTOR_CS_BRL             = 13,
	TM_UPDATE_VECTOR_CS_CS_BRL          = 14,
	TM_UPDATE_VECTOR_OVL_RL             = 15,
	TM_UPDATE_VECTOR_LAST               = 15
} rdd_tm_update_vector;
/* <<<RDD_TM_UPDATE_VECTOR */


/* >>>RDD_CNPL_GROUP */
typedef enum
{
	CNPL_GROUP_FIRST                   = 0,
	CNPL_GROUP_RX_FLOW                 = 0,
	CNPL_GROUP_RX_FLOW_DROP            = 1,
	CNPL_GROUP_TX_FLOW                 = 2,
	CNPL_GROUP_TCAM                    = 3,
	CNPL_GROUP_TWO_BYTE_CNTR           = 4,
	CNPL_GROUP_FOUR_BYTE_CNTR          = 5,
	CNPL_GROUP_TX_QUEUE                = 6,
	CNPL_GROUP_DHD_CTR_CNTRS           = 7,
	CNPL_GROUP_CPU_RX_METER_DROP       = 8,
	CNPL_GROUP_POLICER_GREEN_COLOR     = 9,
	CNPL_GROUP_POLICER_YELLOW_COLOR    = 10,
	CNPL_GROUP_POLICER_RED_COLOR       = 11,
	CNPL_GROUP_EMAC_FLOW_CTRL          = 12,
	CNPL_GROUP_PORT_MCST_BCST          = 12,
	CNPL_GROUP_DHD_CNTRS               = 13,
	CNPL_GROUP_VLAN_RX                 = 14,
	CNPL_GROUP_FW_POLICER              = 15,
	CNPL_GROUP_LAST                    = 15
} rdd_cnpl_group;
/* <<<RDD_CNPL_GROUP */


/* >>>RDD_CNTR_GROUP */
typedef enum
{
	CNTR_GROUP_FIRST                = 0,
	CNTR_GROUP_RX_FLOW              = 0,
	CNTR_GROUP_TX_FLOW              = 1,
	CNTR_GROUP_TCAM_DEF             = 2,
	CNTR_GROUP_VARIOUS              = 3,
	CNTR_GROUP_GENERAL              = 4,
	CNTR_GROUP_TX_QUEUE             = 5,
	CNTR_GROUP_DHD_CTR              = 6,
	CNTR_GROUP_CPU_RX_METER_DROP    = 7,
	CNTR_GROUP_POLICER              = 8,
	CNTR_GROUP_EMAC_FLOW_CTRL       = 9,
	CNTR_GROUP_PORT_MCST_BCST       = 9,
	CNTR_GROUP_DHD_CNTRS            = 10,
	CNTR_GROUP_VLAN_RX              = 11,
	CNTR_GROUP_IPTV_NATC            = 12,
	CNTR_GROUP_FW_POLICER           = 13,
	CNTR_GROUP_GROUPS_NUMBER        = 14,
	CNTR_GROUP_LAST                 = 14
} rdd_cntr_group;
/* <<<RDD_CNTR_GROUP */


/* >>>RDD_CNTR */
typedef enum
{
	CNTR_FIRST                    = 7,
	CNTR_REMAINDER_PERIOD_LOG2    = 7,
	CNTR_REMAINDER_PERIOD         = 128,
	CNTR_MAX_VAL                  = 32767,
	CNTR_VALID_BIT                = 32768,
	CNTR_LAST                     = 32768
} rdd_cntr;
/* <<<RDD_CNTR */


/* >>>RDD_DHD_CTR_GROUP */
typedef enum
{
	DHD_CTR_GROUP_FIRST                      = 0,
	DHD_CTR_GROUP_SPINLOCK_DHD_0             = 0,
	DHD_CTR_GROUP_SPINLOCK_DHD_1             = 1,
	DHD_CTR_GROUP_SPINLOCK_DHD_2             = 2,
	DHD_CTR_GROUP_WRITE_PTR_DHD_0            = 3,
	DHD_CTR_GROUP_WRITE_PTR_DHD_1            = 4,
	DHD_CTR_GROUP_WRITE_PTR_DHD_2            = 5,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_0          = 6,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_1          = 7,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_2          = 8,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_TOTAL      = 9,
	DHD_CTR_GROUP_SPINLOCK_DEBUG_PRINT       = 10,
	DHD_CTR_GROUP_WRITE_PTR_0_DEBUG_PRINT    = 11,
	DHD_CTR_GROUP_WRITE_PTR_1_DEBUG_PRINT    = 12,
	DHD_CTR_GROUP_LAST                       = 12
} rdd_dhd_ctr_group;
/* <<<RDD_DHD_CTR_GROUP */


/* >>>RDD_COUNTER_TX_FLOW_GROUP */
typedef enum
{
	COUNTER_TX_FLOW_GROUP_FIRST              = 0,
	COUNTER_TX_FLOW_GROUP_TX_GEM_FIRST       = 0,
	COUNTER_TX_FLOW_GROUP_TX_VPORT_FIRST     = 128,
	COUNTER_TX_FLOW_GROUP_PATH_STAT_FIRST    = 144,
	COUNTER_TX_FLOW_GROUP_LAST               = 144
} rdd_counter_tx_flow_group;
/* <<<RDD_COUNTER_TX_FLOW_GROUP */


/* >>>RDD_COUNTER */
typedef enum
{
	COUNTER_FIRST                                   = 0,
	COUNTER_TM_PD_NOT_VALID_ID                      = 0,
	COUNTER_TM_ACTION_NOT_VALID_ID                  = 1,
	COUNTER_EPON_TM_PD_NOT_VALID_ID                 = 2,
	COUNTER_G9991_TM_PD_NOT_VALID_ID                = 3,
	COUNTER_PROCESSING_ACTION_NOT_VALID_ID          = 4,
	COUNTER_CPU_RECYCLE_RING_CONGESTION             = 5,
	COUNTER_CPU_RX_FEED_RING_CONGESTION             = 6,
	COUNTER_IPTV_HASH_LKP_MISS_DROP                 = 7,
	COUNTER_IPTV_SRC_IP_VID_LKP_MISS_DROP           = 8,
	COUNTER_IPTV_INVALID_CTX_ENTRY_DROP             = 9,
	COUNTER_IPTV_FPM_SBPM_ALLOC_NACK_DROP           = 10,
	COUNTER_IPTV_FIRST_REPL_DISP_ALLOC_NACK_DROP    = 11,
	COUNTER_IPTV_EXCEPTION_DROP                     = 12,
	COUNTER_IPTV_OTHER_REPL_DISP_ALLOC_NACK_DROP    = 13,
	COUNTER_CPU_TX_COPY_NO_FPM                      = 14,
	COUNTER_CPU_TX_COPY_NO_SBPM                     = 15,
	COUNTER_CPU_RX_TC_TO_RXQ_MAP_DROP               = 16,
	COUNTER_CPU_RX_VPORT_TO_CPU_OBJ_MAP_DROP        = 17,
	COUNTER_ETHERNET_FLOW_DROP_ACTION               = 18,
	COUNTER_SBPM_ALLOC_EXCEPTION_DROP               = 19,
	COUNTER_DROP_CONNECTION_ACTION_DROP_ID          = 20,
	COUNTER_DROP_RESOURCE_CONGESTION_INGRESS        = 21,
	COUNTER_DROP_RESOURCE_CONGESTION_EGRESS         = 22,
	COUNTER_INGRESS_FILTER_DROP_FIRST_DS            = 23,
	COUNTER_INGRESS_FILTER_DROP_FIRST_US            = 47,
	COUNTER_INGRESS_FILTER_DROP_LAST                = 70,
	COUNTER_CPU_RX_METER_DROP                       = 71,
	COUNTER_INGRESS_ISOLATION_DROP                  = 72,
	COUNTER_EGRESS_ISOLATION_DROP                   = 73,
	COUNTER_DA_LKP_MISS_DROP                        = 74,
	COUNTER_SA_LKP_MISS_DROP                        = 75,
	COUNTER_BRIDGE_FW_ELIGABILITY_DROP              = 76,
	COUNTER_DA_LKP_MATCH_DROP                       = 77,
	COUNTER_SA_LKP_MATCH_DROP                       = 78,
	COUNTER_CPU_TX_DISABLED_QUEUE_DROP              = 79,
	COUNTER_DISABLED_TX_FLOW_DROP                   = 80,
	COUNTER_SBPM_LIB_DISP_CONG                      = 81,
	COUNTER_BRIDGE_FLOODING                         = 82,
	COUNTER_DIS_PROTO_DS_IPV4                       = 83,
	COUNTER_DIS_PROTO_DS_IPV6                       = 84,
	COUNTER_DIS_PROTO_DS_PPPOE                      = 85,
	COUNTER_DIS_PROTO_DS_NON_IP                     = 86,
	COUNTER_DIS_PROTO_US_IPV4                       = 87,
	COUNTER_DIS_PROTO_US_IPV6                       = 88,
	COUNTER_DIS_PROTO_US_PPPOE                      = 89,
	COUNTER_DIS_PROTO_US_NON_IP                     = 90,
	COUNTER_RX_WAN_PORT_DROP                        = 91,
	COUNTER_INGRESS_RATE_LIMIT_DROP                 = 92,
	COUNTER_UNDEFINED_QUEUE_DROP                    = 93,
	COUNTER_LOOPBACK_DROP                           = 94,
	COUNTER_SQ_PD_NOT_VALID                         = 95,
	COUNTER_SQ_ACTION_NOT_VALID                     = 96,
	COUNTER_DS_MIRROR_NO_SBPM_DROP                  = 97,
	COUNTER_DS_MIRROR_NO_TOKEN_DROP                 = 98,
	COUNTER_US_MIRROR_NO_SBPM_DROP                  = 99,
	COUNTER_US_MIRROR_NO_TOKEN_DROP                 = 100,
	COUNTER_TX_MIRROR_DROP                          = 101,
	COUNTER_INGRESS_CONGESTION_LAN                  = 102,
	COUNTER_IPTV_PROCESSING_TASKS                   = 103,
	COUNTER_IPTV_PROCESSING_TASKS_LIMIT             = 104,
	COUNTER_IPTV_PROCESSING_TASKS_LOCK              = 105,
	COUNTER_IPTV_CONGESTION_DROP                    = 106,
	COUNTER_TUNNEL_NO_SBPM_DROP                     = 107,
	COUNTER_CODEL_QUEUE_BACK_TO_DROP                = 108,
	COUNTER_CODEL_QUEUE_RECOVER                     = 109,
	COUNTER_CODEL_EMPTY_QUEUE_RECOVER               = 110,
	COUNTER_FC_MCAST_BAD_REPLICATIONS_NUM_DROP      = 111,
	COUNTER_FC_MCAST_CLIENT_FLOW_MISS               = 112,
	COUNTER_G9991_FRAGMENT                          = 113,
	COUNTER_CPU_TX_INGRESS                          = 114,
	COUNTER_CPU_TX_EGRESS                           = 115,
	COUNTER_FLUSH_EGRESS_QUEUE                      = 116,
	COUNTER_IPTV_FPM_BELOW_TRESHOLD_DROP            = 117,
	COUNTER_LAST                                    = 117
} rdd_counter;
/* <<<RDD_COUNTER */


/* >>>RDD_DHD_CNTR */
typedef enum
{
	DHD_CNTR_FIRST                          = 0,
	DHD_CNTR_DHD_RX_DROP_0                  = 0,
	DHD_CNTR_DHD_RX_DROP_1                  = 1,
	DHD_CNTR_DHD_RX_DROP_2                  = 2,
	DHD_CNTR_DHD_TX_FPM_DROP_0              = 3,
	DHD_CNTR_DHD_TX_FPM_DROP_1              = 4,
	DHD_CNTR_DHD_TX_FPM_DROP_2              = 5,
	DHD_CNTR_DHD_TX_HIGH_PRIO_FPM_DROP_0    = 6,
	DHD_CNTR_DHD_TX_HIGH_PRIO_FPM_DROP_1    = 7,
	DHD_CNTR_DHD_TX_HIGH_PRIO_FPM_DROP_2    = 8,
	DHD_CNTR_DHD_TX_DROP_0_SSID_0           = 12,
	DHD_CNTR_DHD_TX_DROP_1_SSID_0           = 28,
	DHD_CNTR_DHD_TX_DROP_2_SSID_0           = 44,
	DHD_CNTR_DHD_TX_FR_FULL_0_AC_0          = 60,
	DHD_CNTR_DHD_TX_FR_FULL_1_AC_0          = 65,
	DHD_CNTR_DHD_TX_FR_FULL_2_AC_0          = 70,
	DHD_CNTR_DHD_DROP_LAST_CNTR             = 74,
	DHD_CNTR_LAST                           = 74
} rdd_dhd_cntr;
/* <<<RDD_DHD_CNTR */


/* >>>RDD_FLOW_DEST */
typedef enum
{
	FLOW_DEST_FIRST      = 0,
	FLOW_DEST_ETH_ID     = 0,
	FLOW_DEST_IPTV_ID    = 1,
	FLOW_DEST_LAST       = 1
} rdd_flow_dest;
/* <<<RDD_FLOW_DEST */


/* >>>RDD_PROTOCOL_FILTER */
typedef enum
{
	PROTOCOL_FILTER_FIRST     = 0,
	PROTOCOL_FILTER_IPV4      = 0,
	PROTOCOL_FILTER_IPV6      = 1,
	PROTOCOL_FILTER_PPPOE     = 2,
	PROTOCOL_FILTER_NON_IP    = 3,
	PROTOCOL_FILTER_LAST      = 3
} rdd_protocol_filter;
/* <<<RDD_PROTOCOL_FILTER */


/* >>>RDD_CONTEXT_EXTENSION_CFG */
typedef enum
{
	CONTEXT_EXTENSION_CFG_FIRST         = 64,
	CONTEXT_EXTENSION_CFG_CTX_OFFSET    = 64,
	CONTEXT_EXTENSION_CFG_LAST          = 64
} rdd_context_extension_cfg;
/* <<<RDD_CONTEXT_EXTENSION_CFG */


/* >>>RDD_NATC_SUB_TBL_IDX */
typedef enum
{
	NATC_SUB_TBL_IDX_FIRST          = 0,
	NATC_SUB_TBL_IDX_L3             = 0,
	NATC_SUB_TBL_IDX_VLAN_ACTION    = 1,
	NATC_SUB_TBL_IDX_L2             = 2,
	NATC_SUB_TBL_IDX_LAST           = 2
} rdd_natc_sub_tbl_idx;
/* <<<RDD_NATC_SUB_TBL_IDX */


/* >>>RDD_TUNNEL_TYPE */
typedef enum
{
	TUNNEL_TYPE_FIRST      = 0,
	TUNNEL_TYPE_L2_GRE     = 0,
	TUNNEL_TYPE_L3_GRE     = 1,
	TUNNEL_TYPE_DS_LITE    = 2,
	TUNNEL_TYPE_VXLAN      = 4,
	TUNNEL_TYPE_LAST       = 4
} rdd_tunnel_type;
/* <<<RDD_TUNNEL_TYPE */


/* >>>RDD_LAYER2_HEADER */
typedef enum
{
	LAYER2_HEADER_FIRST                       = 0,
	LAYER2_HEADER_DST_MAC_OFFSET              = 0,
	LAYER2_HEADER_ETHER_TYPE_SIZE             = 2,
	LAYER2_HEADER_SRC_MAC_OFFSET              = 6,
	LAYER2_HEADER_BROADCOM_TAG_OFFSET         = 12,
	LAYER2_HEADER_ETHER_TYPE_PPPOE_IPV4       = 33,
	LAYER2_HEADER_ETHER_TYPE_PPPOE_IPV6       = 87,
	LAYER2_HEADER_ETHER_TYPE_IPV4             = 2048,
	LAYER2_HEADER_ETHER_TYPE_IPV6             = 34525,
	LAYER2_HEADER_ETHER_TYPE_PPPOE_SESSION    = 34916,
	LAYER2_HEADER_LAST                        = 34916
} rdd_layer2_header;
/* <<<RDD_LAYER2_HEADER */


/* >>>RDD_ACTION */
typedef enum
{
	ACTION_FIRST           = 0,
	ACTION_FORWARD         = 0,
	ACTION_TRAP            = 1,
	ACTION_DROP            = 2,
	ACTION_MULTICAST       = 3,
	ACTION_DROP_LOW_PRI    = 4,
	ACTION_LAST            = 4
} rdd_action;
/* <<<RDD_ACTION */


/* >>>RDD_ENET_HEADER */
typedef enum
{
	ENET_HEADER_FIRST                = 0,
	ENET_HEADER_DA_OFFSET            = 0,
	ENET_HEADER_SA_OFFSET            = 6,
	ENET_HEADER_ETHERTYPE_OFFSET     = 12,
	ENET_HEADER_CTRL_OPCDE_OFFSET    = 14,
	ENET_HEADER_SIZE                 = 16,
	ENET_HEADER_LAST                 = 16
} rdd_enet_header;
/* <<<RDD_ENET_HEADER */


/* >>>RDD_PFC_FRAME */
typedef enum
{
	PFC_FRAME_FIRST                         = 0,
	PFC_FRAME_CLASS_ENABLE_VECTOR_OFFSET    = 0,
	PFC_FRAME_TIME_0_OFFSET                 = 2,
	PFC_FRAME_SIZE                          = 18,
	PFC_FRAME_LAST                          = 18
} rdd_pfc_frame;
/* <<<RDD_PFC_FRAME */


/* >>>RDD_IP_PROTO */
typedef enum
{
	IP_PROTO_FIRST       = 1,
	IP_PROTO_ICMP        = 1,
	IP_PROTO_IPIP        = 4,
	IP_PROTO_TCP         = 6,
	IP_PROTO_UDP         = 17,
	IP_PROTO_IPV6        = 41,
	IP_PROTO_GRE         = 47,
	IP_PROTO_UDP_LITE    = 136,
	IP_PROTO_LAST        = 136
} rdd_ip_proto;
/* <<<RDD_IP_PROTO */


/* >>>RDD_IP_FLAGS */
typedef enum
{
	IP_FLAGS_FIRST                     = 1,
	IP_FLAGS_DO_NOT_FRAGMENT_OFFSET    = 1,
	IP_FLAGS_MORE_FRAGMENTS_OFFSET     = 2,
	IP_FLAGS_LAST                      = 2
} rdd_ip_flags;
/* <<<RDD_IP_FLAGS */


/* >>>RDD_LAYER3_IPV6_HEADER */
typedef enum
{
	LAYER3_IPV6_HEADER_FIRST            = 8,
	LAYER3_IPV6_HEADER_SRC_IP_OFFSET    = 8,
	LAYER3_IPV6_HEADER_DST_IP_OFFSET    = 24,
	LAYER3_IPV6_HEADER_LAST             = 24
} rdd_layer3_ipv6_header;
/* <<<RDD_LAYER3_IPV6_HEADER */


/* >>>RDD_LAYER3_HEADER */
typedef enum
{
	LAYER3_HEADER_FIRST                    = 0,
	LAYER3_HEADER_TRAFIC_CLASS_OFFSET      = 0,
	LAYER3_HEADER_TOS_OFFSET               = 1,
	LAYER3_HEADER_TOTAL_LENGTH_OFFSET      = 2,
	LAYER3_HEADER_PAYLOAD_LENGTH_OFFSET    = 4,
	LAYER3_HEADER_FLAGS_OFFSET             = 6,
	LAYER3_HEADER_HOP_LIMIT_OFFSET         = 7,
	LAYER3_HEADER_TTL_OFFSET               = 8,
	LAYER3_HEADER_PROTOCOL_OFFSET          = 9,
	LAYER3_HEADER_IP_CHECKSUM_OFFSET       = 10,
	LAYER3_HEADER_SRC_IP_OFFSET            = 12,
	LAYER3_HEADER_DST_IP_OFFSET            = 16,
	LAYER3_HEADER_LAST                     = 16
} rdd_layer3_header;
/* <<<RDD_LAYER3_HEADER */


/* >>>RDD_LAYER3_PSEUDO_HEADER */
typedef enum
{
	LAYER3_PSEUDO_HEADER_FIRST                = 0,
	LAYER3_PSEUDO_HEADER_SRC_IP_OFFSET        = 0,
	LAYER3_PSEUDO_HEADER_DST_IP_OFFSET        = 4,
	LAYER3_PSEUDO_HEADER_PROTOCOL_OFFSET      = 8,
	LAYER3_PSEUDO_HEADER_LENGTH_OFFSET        = 10,
	LAYER3_PSEUDO_HEADER_HDR_LENGTH           = 12,
	LAYER3_PSEUDO_HEADER_PROTOCOL_F_WIDTH     = 16,
	LAYER3_PSEUDO_HEADER_PROTOCOL_F_OFFSET    = 16,
	LAYER3_PSEUDO_HEADER_LAST                 = 16
} rdd_layer3_pseudo_header;
/* <<<RDD_LAYER3_PSEUDO_HEADER */


/* >>>RDD_LAYER3_IPV6_PSEUDO_HEADER */
typedef enum
{
	LAYER3_IPV6_PSEUDO_HEADER_FIRST              = 0,
	LAYER3_IPV6_PSEUDO_HEADER_SRC_IP_OFFSET      = 0,
	LAYER3_IPV6_PSEUDO_HEADER_DST_IP_OFFSET      = 16,
	LAYER3_IPV6_PSEUDO_HEADER_LENGTH_OFFSET      = 32,
	LAYER3_IPV6_PSEUDO_HEADER_PROTOCOL_OFFSET    = 36,
	LAYER3_IPV6_PSEUDO_HEADER_HDR_LENGTH         = 40,
	LAYER3_IPV6_PSEUDO_HEADER_LAST               = 40
} rdd_layer3_ipv6_pseudo_header;
/* <<<RDD_LAYER3_IPV6_PSEUDO_HEADER */


/* >>>RDD_LAYER4_HEADER */
typedef enum
{
	LAYER4_HEADER_FIRST                                = 0,
	LAYER4_HEADER_SRC_PORT_OFFSET                      = 0,
	LAYER4_HEADER_ESP_SPI_OFFSET                       = 0,
	LAYER4_HEADER_DST_PORT_OFFSET                      = 2,
	LAYER4_HEADER_UDP_LITE_CHECKSUM_COVERAGE_OFFSET    = 4,
	LAYER4_HEADER_TCP_LENGTH_F_WIDTH                   = 4,
	LAYER4_HEADER_UDP_CHECKSUM_OFFSET                  = 6,
	LAYER4_HEADER_GRE_CALL_ID_OFFSET                   = 6,
	LAYER4_HEADER_UDP_HDR_LENGTH                       = 8,
	LAYER4_HEADER_TCP_LENGTH_OFFSET                    = 12,
	LAYER4_HEADER_TCP_FLAGS_OFFSET                     = 13,
	LAYER4_HEADER_TCP_CHECKSUM_OFFSET                  = 16,
	LAYER4_HEADER_TCP_HDR_MIN_LENGTH                   = 20,
	LAYER4_HEADER_TCP_LENGTH_F_OFFSET                  = 28,
	LAYER4_HEADER_LAST                                 = 28
} rdd_layer4_header;
/* <<<RDD_LAYER4_HEADER */


/* >>>RDD_PARSER_L2_PROTOCOL */
typedef enum
{
	PARSER_L2_PROTOCOL_FIRST             = 1,
	PARSER_L2_PROTOCOL_PPPOE_D           = 1,
	PARSER_L2_PROTOCOL_PPPOE_S           = 2,
	PARSER_L2_PROTOCOL_USER_DEFINED_0    = 8,
	PARSER_L2_PROTOCOL_USER_DEFINED_1    = 9,
	PARSER_L2_PROTOCOL_USER_DEFINED_2    = 10,
	PARSER_L2_PROTOCOL_USER_DEFINED_3    = 11,
	PARSER_L2_PROTOCOL_ARP               = 12,
	PARSER_L2_PROTOCOL__1588             = 13,
	PARSER_L2_PROTOCOL__802_1X           = 14,
	PARSER_L2_PROTOCOL_MASK              = 15,
	PARSER_L2_PROTOCOL__802_1AG_CFM      = 15,
	PARSER_L2_PROTOCOL_LAST              = 15
} rdd_parser_l2_protocol;
/* <<<RDD_PARSER_L2_PROTOCOL */


/* >>>RDD_PARSER_L3_PROTOCOL */
typedef enum
{
	PARSER_L3_PROTOCOL_FIRST    = 0,
	PARSER_L3_PROTOCOL_OTHER    = 0,
	PARSER_L3_PROTOCOL_IPV4     = 1,
	PARSER_L3_PROTOCOL_IPV6     = 2,
	PARSER_L3_PROTOCOL_MASK     = 3,
	PARSER_L3_PROTOCOL_LAST     = 3
} rdd_parser_l3_protocol;
/* <<<RDD_PARSER_L3_PROTOCOL */


/* >>>RDD_PARSER_L4_PROTOCOL */
typedef enum
{
	PARSER_L4_PROTOCOL_FIRST             = 0,
	PARSER_L4_PROTOCOL_OTHER             = 0,
	PARSER_L4_PROTOCOL_TCP               = 1,
	PARSER_L4_PROTOCOL_UDP               = 2,
	PARSER_L4_PROTOCOL_IGMP              = 3,
	PARSER_L4_PROTOCOL_ICMP              = 4,
	PARSER_L4_PROTOCOL_ICMPV6            = 5,
	PARSER_L4_PROTOCOL_ESP               = 6,
	PARSER_L4_PROTOCOL_GRE               = 7,
	PARSER_L4_PROTOCOL_USER_DEFINED_0    = 8,
	PARSER_L4_PROTOCOL_USER_DEFINED_1    = 9,
	PARSER_L4_PROTOCOL_USER_DEFINED_2    = 10,
	PARSER_L4_PROTOCOL_L2TPV3            = 11,
	PARSER_L4_PROTOCOL_USER_DEFINED_3    = 11,
	PARSER_L4_PROTOCOL_RESERVED          = 12,
	PARSER_L4_PROTOCOL_IPV4_OVER_IPV6    = 12,
	PARSER_L4_PROTOCOL_IPV6              = 13,
	PARSER_L4_PROTOCOL_AH                = 14,
	PARSER_L4_PROTOCOL_NOT_PARSED        = 15,
	PARSER_L4_PROTOCOL_MASK              = 15,
	PARSER_L4_PROTOCOL_LAST              = 15
} rdd_parser_l4_protocol;
/* <<<RDD_PARSER_L4_PROTOCOL */


/* >>>RDD_ACTION_ECN */
typedef enum
{
	ACTION_ECN_FIRST               = 0,
	ACTION_ECN_REMARKING_OFFSET    = 0,
	ACTION_ECN_REMARKING_WIDTH     = 2,
	ACTION_ECN_LAST                = 2
} rdd_action_ecn;
/* <<<RDD_ACTION_ECN */


/* >>>RDD_ACTION_DSCP */
typedef enum
{
	ACTION_DSCP_FIRST                             = 2,
	ACTION_DSCP_REMARKING_OFFSET                  = 2,
	ACTION_DSCP_REMARKING_TRAFFIC_CLASS_OFFSET    = 4,
	ACTION_DSCP_REMARKING_WIDTH                   = 6,
	ACTION_DSCP_REMARKING_TRAFFIC_CLASS_WIDTH     = 8,
	ACTION_DSCP_LAST                              = 8
} rdd_action_dscp;
/* <<<RDD_ACTION_DSCP */


/* >>>RDD_ACTION_OUTER */
typedef enum
{
	ACTION_OUTER_FIRST                         = 14,
	ACTION_OUTER_PBITS_REMARKING_VID_OFFSET    = 14,
	ACTION_OUTER_LAST                          = 14
} rdd_action_outer;
/* <<<RDD_ACTION_OUTER */


/* >>>RDD_ACTION_INNER */
typedef enum
{
	ACTION_INNER_FIRST                         = 18,
	ACTION_INNER_PBITS_REMARKING_VID_OFFSET    = 18,
	ACTION_INNER_LAST                          = 18
} rdd_action_inner;
/* <<<RDD_ACTION_INNER */


/* >>>RDD_ACTION_PBITS */
typedef enum
{
	ACTION_PBITS_FIRST                        = 2,
	ACTION_PBITS_REMARKING_DSCP_F_OFFSET      = 2,
	ACTION_PBITS_REMARKING_PACKET_F_WIDTH     = 3,
	ACTION_PBITS_REMARKING_DSCP_F_WIDTH       = 6,
	ACTION_PBITS_REMARKING_PACKET_F_OFFSET    = 13,
	ACTION_PBITS_LAST                         = 13
} rdd_action_pbits;
/* <<<RDD_ACTION_PBITS */


/* >>>RDD_ACTION_DS_LITE */
typedef enum
{
	ACTION_DS_LITE_FIRST   = 40,
	ACTION_DS_LITE_SIZE    = 40,
	ACTION_DS_LITE_LAST    = 40
} rdd_action_ds_lite;
/* <<<RDD_ACTION_DS_LITE */


/* >>>RDD_DS_ACTION_ID */
typedef enum
{
	DS_ACTION_ID_FIRST        = 0,
	DS_ACTION_ID_TRAP         = 0,
	DS_ACTION_ID_TTL          = 2,
	DS_ACTION_ID_DSCP         = 4,
	DS_ACTION_ID_NAT          = 5,
	DS_ACTION_ID_GRE          = 6,
	DS_ACTION_ID_OPBITS       = 7,
	DS_ACTION_ID_IPBITS       = 8,
	DS_ACTION_ID_DS_LITE      = 9,
	DS_ACTION_ID_PPPOE        = 10,
	DS_ACTION_ID_TOTAL_NUM    = 17,
	DS_ACTION_ID_LAST         = 17
} rdd_ds_action_id;
/* <<<RDD_DS_ACTION_ID */


/* >>>RDD_US_ACTION_ID */
typedef enum
{
	US_ACTION_ID_FIRST        = 0,
	US_ACTION_ID_TRAP         = 0,
	US_ACTION_ID_TTL          = 2,
	US_ACTION_ID_DSCP         = 4,
	US_ACTION_ID_NAT          = 5,
	US_ACTION_ID_GRE          = 6,
	US_ACTION_ID_OPBITS       = 7,
	US_ACTION_ID_IPBITS       = 8,
	US_ACTION_ID_DS_LITE      = 9,
	US_ACTION_ID_PPPOE        = 10,
	US_ACTION_ID_TOTAL_NUM    = 17,
	US_ACTION_ID_LAST         = 17
} rdd_us_action_id;
/* <<<RDD_US_ACTION_ID */


/* >>>RDD_RDD_VPORT */
typedef enum
{
	RDD_VPORT_FIRST    = 0,
	RDD_VPORT_ID_0     = 0,
	RDD_VPORT_ID_1     = 1,
	RDD_VPORT_ID_2     = 2,
	RDD_VPORT_ID_3     = 3,
	RDD_VPORT_ID_4     = 4,
	RDD_VPORT_ID_5     = 5,
	RDD_VPORT_ID_6     = 6,
	RDD_VPORT_ID_7     = 7,
	RDD_VPORT_ID_8     = 8,
	RDD_VPORT_ID_9     = 9,
	RDD_VPORT_ID_10    = 10,
	RDD_VPORT_ID_11    = 11,
	RDD_VPORT_ID_12    = 12,
	RDD_VPORT_ID_13    = 13,
	RDD_VPORT_ID_14    = 14,
	RDD_VPORT_ID_15    = 15,
	RDD_VPORT_ID_16    = 16,
	RDD_VPORT_ID_17    = 17,
	RDD_VPORT_ID_18    = 18,
	RDD_VPORT_ID_19    = 19,
	RDD_VPORT_ID_20    = 20,
	RDD_VPORT_ID_21    = 21,
	RDD_VPORT_ID_22    = 22,
	RDD_VPORT_ID_23    = 23,
	RDD_VPORT_ID_24    = 24,
	RDD_VPORT_ID_25    = 25,
	RDD_VPORT_ID_26    = 26,
	RDD_VPORT_ID_27    = 27,
	RDD_VPORT_ID_28    = 28,
	RDD_VPORT_ID_29    = 29,
	RDD_VPORT_ID_30    = 30,
	RDD_VPORT_ID_31    = 31,
	RDD_VPORT_ID_32    = 32,
	RDD_VPORT_ID_33    = 33,
	RDD_VPORT_ID_34    = 34,
	RDD_VPORT_ID_35    = 35,
	RDD_VPORT_ID_36    = 36,
	RDD_VPORT_ID_37    = 37,
	RDD_VPORT_ID_38    = 38,
	RDD_VPORT_ID_39    = 39,
	RDD_VPORT_LAST     = 39
} rdd_rdd_vport;
/* <<<RDD_RDD_VPORT */


/* >>>RDD_DSCP_TO */
typedef enum
{
	DSCP_TO_FIRST                 = 6,
	DSCP_TO_PBITS_SHIFT_OFFSET    = 6,
	DSCP_TO_LAST                  = 6
} rdd_dscp_to;
/* <<<RDD_DSCP_TO */


/* >>>RDD_RESOLUTION_CONTEXT */
typedef enum
{
	RESOLUTION_CONTEXT_FIRST                          = 0,
	RESOLUTION_CONTEXT_VIRTUAL_SRC_PORT_OFFSET        = 0,
	RESOLUTION_CONTEXT_GPE_DMA_OFFSET_WIDTH           = 1,
	RESOLUTION_CONTEXT_GPE_HEADER_LENGTH_WIDTH        = 1,
	RESOLUTION_CONTEXT_GPE_HEADER_IH_PTR_WIDTH        = 2,
	RESOLUTION_CONTEXT_GPE_COMMAND_LIST_PTR_WIDTH     = 2,
	RESOLUTION_CONTEXT_GPE_PACKET_DRR_PTR_WIDTH       = 4,
	RESOLUTION_CONTEXT_GPE_HEADER_LENGTH_OFFSET       = 6,
	RESOLUTION_CONTEXT_GPE_DMA_OFFSET_OFFSET          = 7,
	RESOLUTION_CONTEXT_GPE_COMMAND_LIST_PTR_OFFSET    = 8,
	RESOLUTION_CONTEXT_GPE_HEADER_IH_PTR_OFFSET       = 10,
	RESOLUTION_CONTEXT_GPE_PACKET_DRR_PTR_OFFSET      = 12,
	RESOLUTION_CONTEXT_LAST                           = 12
} rdd_resolution_context;
/* <<<RDD_RESOLUTION_CONTEXT */


/* >>>RDD_FFI */
typedef enum
{
	FFI_FIRST           = 3,
	FFI_8_LOG2_SIZE     = 3,
	FFI_16_LOG2_SIZE    = 4,
	FFI_32_LOG2_SIZE    = 5,
	FFI_8_SIZE          = 8,
	FFI_16_SIZE         = 16,
	FFI_32_SIZE         = 32,
	FFI_LAST            = 32
} rdd_ffi;
/* <<<RDD_FFI */


/* >>>RDD_TUNNEL_TYPE_BIT */
typedef enum
{
	TUNNEL_TYPE_BIT_FIRST      = 0,
	TUNNEL_TYPE_BIT_L3_GRE     = 0,
	TUNNEL_TYPE_BIT_GRE        = 0,
	TUNNEL_TYPE_BIT_L2_GRE     = 0,
	TUNNEL_TYPE_BIT_DS_LITE    = 1,
	TUNNEL_TYPE_BIT_VXLAN      = 2,
	TUNNEL_TYPE_BIT_LAST       = 2
} rdd_tunnel_type_bit;
/* <<<RDD_TUNNEL_TYPE_BIT */


/* >>>RDD_HASH */
typedef enum
{
	HASH_FIRST              = 7,
	HASH_MAX_TABLES_NUM     = 7,
	HASH_CRC_BYTE_SIZE      = 8,
	HASH_MAX_CTX_SIZE       = 18,
	HASH_KEY_SIZE           = 60,
	HASH_CAM_NUM_ENTRIES    = 64,
	HASH_INVALID_IDX        = 65535,
	HASH_LAST               = 65535
} rdd_hash;
/* <<<RDD_HASH */


/* >>>RDD_HASH_LKP */
typedef enum
{
	HASH_LKP_FIRST             = 0,
	HASH_LKP_MISS              = 0,
	HASH_LKP_MATCH_IN_TABLE    = 1,
	HASH_LKP_MATCH_IN_CAM      = 2,
	HASH_LKP_RESERVED          = 3,
	HASH_LKP_LAST              = 3
} rdd_hash_lkp;
/* <<<RDD_HASH_LKP */


/* >>>RDD_ */
typedef enum
{
	BBMSG_SRAM_ADDR_DIV_LOG2     = 3,
	FW_CRC_LEN                   = 4,
	BBMSG_SRAM_ADDR_DIV          = 8,
} rdd_;
/* <<<RDD_ */


/* >>>RDD_OAM_ETHERTYPE */
typedef enum
{
	OAM_ETHERTYPE_FIRST   = 34824,
	OAM_ETHERTYPE_8808    = 34824,
	OAM_ETHERTYPE_8809    = 34825,
	OAM_ETHERTYPE_LAST    = 34825
} rdd_oam_ethertype;
/* <<<RDD_OAM_ETHERTYPE */


/* >>>RDD_MLD_TYPE */
typedef enum
{
	MLD_TYPE_FIRST                           = 130,
	MLD_TYPE_V1_MULTICAST_LISTENER_QUERY     = 130,
	MLD_TYPE_V1_MIN                          = 130,
	MLD_TYPE_V1_MULTICAST_LISTENER_REPORT    = 131,
	MLD_TYPE_V1_MULTICAST_LISTENER_DONE      = 132,
	MLD_TYPE_V1_MAX                          = 132,
	MLD_TYPE_V2_MULTICAST_LISTENER_REPORT    = 143,
	MLD_TYPE_LAST                            = 143
} rdd_mld_type;
/* <<<RDD_MLD_TYPE */


/* >>>RDD_C_DEFS */
typedef enum
{
	C_DEFS_FIRST                                 = 32,
	C_DEFS_CPU_RECYCLE_STACK_SIZE                = 32,
	C_DEFS_CPU_RX_STACK_SIZE                     = 32,
	C_DEFS_GENERAL_TIMER_STACK_SIZE              = 32,
	C_DEFS_DHD_TX_POST_UPDATE_FIFO_STACK_SIZE    = 32,
	C_DEFS_REPORTING_STACK_SIZE                  = 32,
	C_DEFS_COMMON_REPROCESSING_STACK_SIZE        = 32,
	C_DEFS_DHD_TIMER_STACK_SIZE                  = 32,
	C_DEFS_DHD_RX_COMPLETE_STACK_SIZE            = 64,
	C_DEFS_DIRECT_FLOW_STACK_SIZE                = 64,
	C_DEFS_CPU_RX_COPY_STACK_SIZE                = 128,
	C_DEFS_CPU_TX_STACK_SIZE                     = 128,
	C_DEFS_DHD_TX_COMPLETE_STACK_SIZE            = 128,
	C_DEFS_DHD_TX_POST_STACK_SIZE                = 128,
	C_DEFS_SPDSVC_GEN_STACK_SIZE                 = 128,
	C_DEFS_DEFAULT_STACK_SIZE                    = 256,
	C_DEFS_SPDSVC_ANALYZER_STACK_SIZE            = 256,
	C_DEFS_PROCESSING_STACK_SIZE                 = 320,
	C_DEFS_LAST                                  = 320
} rdd_c_defs;
/* <<<RDD_C_DEFS */


/* >>>RDD_CPU_RX_REASON */
typedef enum
{
	CPU_RX_REASON_FIRST                = 0,
	CPU_RX_REASON_OAM                  = 0,
	CPU_RX_REASON_PLOAM                = 0,
	CPU_RX_REASON_OMCI                 = 1,
	CPU_RX_REASON_MPCP                 = 1,
	CPU_RX_REASON_FLOW                 = 2,
	CPU_RX_REASON_MULTICAST            = 3,
	CPU_RX_REASON_BROADCAST            = 4,
	CPU_RX_REASON_IGMP                 = 5,
	CPU_RX_REASON_ICMPV6               = 6,
	CPU_RX_REASON_MAC_TRAP_0           = 7,
	CPU_RX_REASON_MAC_TRAP_1           = 8,
	CPU_RX_REASON_MAC_TRAP_2           = 9,
	CPU_RX_REASON_MAC_TRAP_3           = 10,
	CPU_RX_REASON_DHCP                 = 11,
	CPU_RX_REASON_NON_TCP_UDP          = 12,
	CPU_RX_REASON_LOCAL_IP             = 13,
	CPU_RX_REASON_IP_HEADER_ERROR      = 14,
	CPU_RX_REASON_SA_MOVE              = 15,
	CPU_RX_REASON_UNKNOWN_SA           = 16,
	CPU_RX_REASON_UNKNOWN_DA           = 17,
	CPU_RX_REASON_IP_FRAGMENT          = 18,
	CPU_RX_REASON_MAC_SPOOFING         = 19,
	CPU_RX_REASON_DIRECT_FLOW          = 20,
	CPU_RX_REASON_MCAST_MISS           = 21,
	CPU_RX_REASON_IPSEC                = 22,
	CPU_RX_REASON_MCAST_FWD_TRAP       = 23,
	CPU_RX_REASON_MCAST_EXCEPTION      = 24,
	CPU_RX_REASON_BRIDGE_DA_MAC        = 25,
	CPU_RX_REASON_L2CP                 = 26,
	CPU_RX_REASON_CPU_MIRRORING        = 27,
	CPU_RX_REASON_ETYPE_UDEF_0         = 28,
	CPU_RX_REASON_ETYPE_UDEF_1         = 29,
	CPU_RX_REASON_ETYPE_UDEF_2         = 30,
	CPU_RX_REASON_ETYPE_UDEF_3         = 31,
	CPU_RX_REASON_ETYPE_PPPOE_D        = 32,
	CPU_RX_REASON_ETYPE_PPPOE_S        = 33,
	CPU_RX_REASON_ETYPE_ARP            = 34,
	CPU_RX_REASON__1588                = 35,
	CPU_RX_REASON_ETYPE_802_1X         = 36,
	CPU_RX_REASON_ETYPE_802_1AG_CFM    = 37,
	CPU_RX_REASON_RESERVED0            = 38,
	CPU_RX_REASON_UDP_CSUM_0           = 39,
	CPU_RX_REASON_UNKNOWN_DA_FLOOD     = 40,
	CPU_RX_REASON_IP_FLOW_MISS         = 41,
	CPU_RX_REASON_TCP_FLAGS            = 42,
	CPU_RX_REASON_TTL_EXPIRED          = 43,
	CPU_RX_REASON_MTU_EXCEEDED         = 44,
	CPU_RX_REASON_PARSER_ERROR         = 45,
	CPU_RX_REASON_CPU_REDIRECT         = 46,
	CPU_RX_REASON_L4_ESP               = 47,
	CPU_RX_REASON_UDEF_0               = 48,
	CPU_RX_REASON_UDEF_1               = 49,
	CPU_RX_REASON_UDEF_2               = 50,
	CPU_RX_REASON_UDEF_3               = 51,
	CPU_RX_REASON_UDEF_4               = 52,
	CPU_RX_REASON_UDEF_5               = 53,
	CPU_RX_REASON_UDEF_6               = 54,
	CPU_RX_REASON_UDEF_7               = 55,
	CPU_RX_REASON_UDEF_8               = 56,
	CPU_RX_REASON_UDEF_9               = 57,
	CPU_RX_REASON_UDEF_10              = 58,
	CPU_RX_REASON_UDEF_11              = 59,
	CPU_RX_REASON_UDEF_12              = 60,
	CPU_RX_REASON_UDEF_13              = 61,
	CPU_RX_REASON_UDEF_14              = 62,
	CPU_RX_REASON_UDEF_15              = 63,
	CPU_RX_REASON_LAST                 = 63
} rdd_cpu_rx_reason;
/* <<<RDD_CPU_RX_REASON */


/* >>>RDD_CPU_RX_METER */
typedef enum
{
	CPU_RX_METER_FIRST      = 0,
	CPU_RX_METER_ID_0       = 0,
	CPU_RX_METER_ID_1       = 1,
	CPU_RX_METER_ID_2       = 2,
	CPU_RX_METER_ID_3       = 3,
	CPU_RX_METER_ID_4       = 4,
	CPU_RX_METER_ID_5       = 5,
	CPU_RX_METER_ID_6       = 6,
	CPU_RX_METER_ID_7       = 7,
	CPU_RX_METER_ID_8       = 8,
	CPU_RX_METER_ID_9       = 9,
	CPU_RX_METER_ID_10      = 10,
	CPU_RX_METER_ID_11      = 11,
	CPU_RX_METER_ID_12      = 12,
	CPU_RX_METER_ID_13      = 13,
	CPU_RX_METER_ID_14      = 14,
	CPU_RX_METER_ID_15      = 15,
	CPU_RX_METER_DISABLE    = 255,
	CPU_RX_METER_LAST       = 255
} rdd_cpu_rx_meter;
/* <<<RDD_CPU_RX_METER */


/* >>>RDD_CPU_REDIRECT_TYPE */
typedef enum
{
	CPU_REDIRECT_TYPE_FIRST   = 0,
	CPU_REDIRECT_TYPE_NONE    = 0,
	CPU_REDIRECT_TYPE_ALL     = 1,
	CPU_REDIRECT_TYPE_FLOW    = 2,
	CPU_REDIRECT_TYPE_LAST    = 2
} rdd_cpu_redirect_type;
/* <<<RDD_CPU_REDIRECT_TYPE */


/* >>>RDD_CPU_RX_TC */
typedef enum
{
	CPU_RX_TC_FIRST   = 0,
	CPU_RX_TC_ID_0    = 0,
	CPU_RX_TC_ID_1    = 1,
	CPU_RX_TC_ID_2    = 2,
	CPU_RX_TC_ID_3    = 3,
	CPU_RX_TC_ID_4    = 4,
	CPU_RX_TC_ID_5    = 5,
	CPU_RX_TC_ID_6    = 6,
	CPU_RX_TC_ID_7    = 7,
	CPU_RX_TC_LAST    = 7
} rdd_cpu_rx_tc;
/* <<<RDD_CPU_RX_TC */


/* >>>RDD_CPU_RX_TYPE */
typedef enum
{
	CPU_RX_TYPE_FIRST            = 0,
	CPU_RX_TYPE_FWD              = 0,
	CPU_RX_TYPE_EXCEPTION        = 1,
	CPU_RX_TYPE_SPEED_SERVICE    = 2,
	CPU_RX_TYPE_WAN_LOOPBACK     = 3,
	CPU_RX_TYPE_LAST             = 3
} rdd_cpu_rx_type;
/* <<<RDD_CPU_RX_TYPE */


/* >>>RDD_DEBUG_PRINT_TABLE */
typedef enum
{
	DEBUG_PRINT_TABLE_FIRST   = 16384,
	DEBUG_PRINT_TABLE_SIZE    = 16384,
	DEBUG_PRINT_TABLE_LAST    = 16384
} rdd_debug_print_table;
/* <<<RDD_DEBUG_PRINT_TABLE */


/* >>>RDD_MCAST_DEFS */
typedef enum
{
	MCAST_DEFS_FIRST                     = 255,
	MCAST_DEFS_MAX_CHANNELS_IN_MASTER    = 255,
	MCAST_DEFS_MAX_CHANNELS_IN_HASH      = 1024,
	MCAST_DEFS_MAX_FLOWS_IN_TOTAL        = 8192,
	MCAST_DEFS_LAST                      = 8192
} rdd_mcast_defs;
/* <<<RDD_MCAST_DEFS */


/* >>>RDD_TCAM_IC_CMD_TYPE */
typedef enum
{
	TCAM_IC_CMD_TYPE_FIRST                   = 0,
	TCAM_IC_CMD_TYPE_PARSER_1                = 0,
	TCAM_IC_CMD_TYPE_PARSER_2                = 1,
	TCAM_IC_CMD_TYPE_PARSER_4                = 2,
	TCAM_IC_CMD_TYPE_PARSER_6                = 3,
	TCAM_IC_CMD_TYPE_PARSER_8                = 4,
	TCAM_IC_CMD_TYPE_PARSER_8_NOT_ALIGNED    = 5,
	TCAM_IC_CMD_TYPE_PACKET                  = 6,
	TCAM_IC_CMD_TYPE_L3                      = 7,
	TCAM_IC_CMD_TYPE_L4                      = 8,
	TCAM_IC_CMD_TYPE_INGRESS_PORT            = 9,
	TCAM_IC_CMD_TYPE_GEM_FLOW                = 10,
	TCAM_IC_CMD_TYPE_SOURCE_IP               = 11,
	TCAM_IC_CMD_TYPE_DESTINATION_IP          = 12,
	TCAM_IC_CMD_TYPE_NETWORK_LAYER           = 13,
	TCAM_IC_CMD_TYPE_LAST                    = 13
} rdd_tcam_ic_cmd_type;
/* <<<RDD_TCAM_IC_CMD_TYPE */


/* >>>RDD_TCAM_IC_MODULE */
typedef enum
{
	TCAM_IC_MODULE_FIRST              = 0,
	TCAM_IC_MODULE_FLOW_DS            = 0,
	TCAM_IC_MODULE_FLOW_US            = 1,
	TCAM_IC_MODULE_QOS_DS             = 2,
	TCAM_IC_MODULE_QOS_US             = 3,
	TCAM_IC_MODULE_IP_FLOW_DS         = 4,
	TCAM_IC_MODULE_ACL_DS             = 4,
	TCAM_IC_MODULE_IP_FLOW_US         = 5,
	TCAM_IC_MODULE_ACL_US             = 5,
	TCAM_IC_MODULE_IP_FLOW_MISS_DS    = 6,
	TCAM_IC_MODULE_IP_FLOW_MISS_US    = 7,
	TCAM_IC_MODULE_LAST               = 7
} rdd_tcam_ic_module;
/* <<<RDD_TCAM_IC_MODULE */


/* >>>RDD_TCAM_IC_MODULE_REF_CNT */
typedef enum
{
	TCAM_IC_MODULE_REF_CNT_FIRST                  = 0,
	TCAM_IC_MODULE_REF_CNT_FLOW                   = 0,
	TCAM_IC_MODULE_REF_CNT_QOS                    = 1,
	TCAM_IC_MODULE_REF_CNT_GENERIC_FILTER_ALL     = 2,
	TCAM_IC_MODULE_REF_CNT_GENERIC_FILTER_MISS    = 3,
	TCAM_IC_MODULE_REF_CNT_LAST                   = 3
} rdd_tcam_ic_module_ref_cnt;
/* <<<RDD_TCAM_IC_MODULE_REF_CNT */


/* >>>RDD_BRIDGE_AND_VLAN_LKP_MISS_ACTION */
typedef enum
{
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_FIRST      = 0,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_DROP       = 0,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_TRAP       = 1,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_FORWARD    = 2,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_LAST       = 2
} rdd_bridge_and_vlan_lkp_miss_action;
/* <<<RDD_BRIDGE_AND_VLAN_LKP_MISS_ACTION */


/* >>>RDD_BRIDGE_ARL_LOOKUP_METHOD */
typedef enum
{
	BRIDGE_ARL_LOOKUP_METHOD_FIRST       = 0,
	BRIDGE_ARL_LOOKUP_METHOD_MAC_ONLY    = 0,
	BRIDGE_ARL_LOOKUP_METHOD_MAC_VID     = 1,
	BRIDGE_ARL_LOOKUP_METHOD_LAST        = 1
} rdd_bridge_arl_lookup_method;
/* <<<RDD_BRIDGE_ARL_LOOKUP_METHOD */


/* >>>RDD_BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD */
typedef enum
{
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_FIRST         = 0,
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_VPORT_ONLY    = 0,
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_VPORT_VID     = 1,
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_LAST          = 1
} rdd_bridge_and_vlan_ctx_lookup_method;
/* <<<RDD_BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD */


/* >>>RDD_BRIDGE_FLOW */
typedef enum
{
	BRIDGE_FLOW_FIRST = 0,
	BRIDGE_FLOW_DS    = 0,
	BRIDGE_FLOW_US    = 1,
	BRIDGE_FLOW_LAST  = 1
} rdd_bridge_flow;
/* <<<RDD_BRIDGE_FLOW */


/* >>>RDD_NO_FWD_ACTION */
typedef enum
{
	NO_FWD_ACTION_FIRST   = 0,
	NO_FWD_ACTION_DROP    = 0,
	NO_FWD_ACTION_TRAP    = 1,
	NO_FWD_ACTION_LAST    = 1
} rdd_no_fwd_action;
/* <<<RDD_NO_FWD_ACTION */


/* >>>RDD_INGRESS_FILTER */
typedef enum
{
	INGRESS_FILTER_FIRST                = 0,
	INGRESS_FILTER_DHCP                 = 0,
	INGRESS_FILTER_ETYPE_PPPOE_D        = 1,
	INGRESS_FILTER_ETYPE_PPPOE_S        = 2,
	INGRESS_FILTER_IGMP                 = 3,
	INGRESS_FILTER_MLD                  = 4,
	INGRESS_FILTER_ICMPV6               = 5,
	INGRESS_FILTER_HDR_ERR              = 6,
	INGRESS_FILTER_IP_FRAGMENT          = 7,
	INGRESS_FILTER_ETYPE_UDEF_0         = 8,
	INGRESS_FILTER_ETYPE_UDEF_1         = 9,
	INGRESS_FILTER_ETYPE_UDEF_2         = 10,
	INGRESS_FILTER_ETYPE_UDEF_3         = 11,
	INGRESS_FILTER_ETYPE_ARP            = 12,
	INGRESS_FILTER_ETYPE_PTP_1588       = 13,
	INGRESS_FILTER_ETYPE_802_1X         = 14,
	INGRESS_FILTER_ETYPE_802_1AG_CFM    = 15,
	INGRESS_FILTER_MAC_SPOOFING         = 16,
	INGRESS_FILTER_MAC_DA_EQ_SA         = 16,
	INGRESS_FILTER_IP_MCAST_CONTROL     = 17,
	INGRESS_FILTER_MCAST_IPV4           = 18,
	INGRESS_FILTER_MCAST_IPV6           = 19,
	INGRESS_FILTER_MCAST_L2             = 20,
	INGRESS_FILTER_MCAST                = 21,
	INGRESS_FILTER_BCAST                = 22,
	INGRESS_FILTER_L4_PTP_1588          = 23,
	INGRESS_FILTER_L2CP                 = 24,
	INGRESS_FILTER_LAST                 = 24
} rdd_ingress_filter;
/* <<<RDD_INGRESS_FILTER */


/* >>>RDD_BBMSG_TYPE */
typedef enum
{
	BBMSG_TYPE_FIRST                                              = 0,
	BBMSG_TYPE_RUNNER_BBH_RX_FLOW_CONTROL                         = 0,
	BBMSG_TYPE_QM_PD_FIFO_CREDIT_FREE                             = 0,
	BBMSG_TYPE_BBH_TX_PACKET_DESCRIPTOR                           = 1,
	BBMSG_TYPE_RUNNER_SBPM_BUFFER_ALLOC_MANUAL_TASK_ID            = 1,
	BBMSG_TYPE_QM_UPDATE_FIFO_CREDIT_FREE                         = 1,
	BBMSG_TYPE_FPM_BUFFER_ALLOC_MANUAL_TASK_ID                    = 1,
	BBMSG_TYPE_RUNNER_SBPM_MCAST_INC_REQUEST_MANUAL_TASK_ID       = 2,
	BBMSG_TYPE_FPM_BUFFER_MCAST_INCREMENT_MANUAL_TASK_ID          = 2,
	BBMSG_TYPE_BBH_TX_NACK                                        = 2,
	BBMSG_TYPE_BBH_TX_ACK                                         = 3,
	BBMSG_TYPE_FPM_BUFFER_FREE_MANUAL_TASK_ID                     = 3,
	BBMSG_TYPE_BBH_SBPM_BUFFER_FREE                               = 3,
	BBMSG_TYPE_BBH_GHOST_DBR                                      = 4,
	BBMSG_TYPE_RUNNER_SBPM_CONNECT_MANUAL_TASK_ID                 = 4,
	BBMSG_TYPE_RUNNER_SBPM_GET_NEXT_MANUAL_TASK_ID                = 5,
	BBMSG_TYPE_BBH_TX_REPORT_ACK                                  = 5,
	BBMSG_TYPE_BBH_SBPM_BUFFER_FREE_WITHOUT_CONTEXT               = 6,
	BBMSG_TYPE_RUNNER_SBPM_BUFFER_FREE_WITHOUT_CONTEXT            = 6,
	BBMSG_TYPE_BBH_TX_REPORT_NACK                                 = 7,
	BBMSG_TYPE_RUNNER_SBPM_INGRESS_TO_EGRESS                      = 7,
	BBMSG_TYPE_RUNNER_REORDER_PD_WRITE                            = 8,
	BBMSG_TYPE_RUNNER_DISPATCHER_PD_ACK_MANUAL_TASK_ID            = 9,
	BBMSG_TYPE_RUNNER_DISPATCHER_PD_WRITE                         = 10,
	BBMSG_TYPE_RUNNER_REORDER_TOKEN_REQUEST                       = 11,
	BBMSG_TYPE_RUNNER_REORDER_BUFFER_CONNECT                      = 12,
	BBMSG_TYPE_RUNNER_DISPATCHER_WAKEUP_PENDING                   = 13,
	BBMSG_TYPE_RUNNER_REORDER_CONNECT_REQUEST_BUFFER_CONNECTED    = 14,
	BBMSG_TYPE_RUNNER_REORDER_BUFFER_MULTICAST_CONNECT_REQUEST    = 15,
	BBMSG_TYPE_BBH_RX_DISPATCHER_PD_WRITE                         = 24,
	BBMSG_TYPE_LAST                                               = 24
} rdd_bbmsg_type;
/* <<<RDD_BBMSG_TYPE */


/* >>>RDD_ERR_RX_PD */
typedef enum
{
	ERR_RX_PD_FIRST                 = 1,
	ERR_RX_PD_NO_SBPM               = 1,
	ERR_RX_PD_PACKET_TOO_SHORT      = 2,
	ERR_RX_PD_PACKET_TOO_LONG       = 3,
	ERR_RX_PD_CRC                   = 4,
	ERR_RX_PD_ENCRYPT               = 5,
	ERR_RX_PD_NO_SDMA_CHUNK         = 6,
	ERR_RX_PD_SOP_AFTER_SOP         = 7,
	ERR_RX_PD_THIRD_FLOW_ARRIVAL    = 8,
	ERR_RX_PD_LAST                  = 8
} rdd_err_rx_pd;
/* <<<RDD_ERR_RX_PD */


/* >>>RDD_SBPM_OPCODE */
typedef enum
{
	SBPM_OPCODE_FIRST                   = 0,
	SBPM_OPCODE_MULTI_GET_NEXT          = 0,
	SBPM_OPCODE_BN_ALLOC                = 1,
	SBPM_OPCODE_MCST_INC                = 2,
	SBPM_OPCODE_BN_FREE_WITH_CONTEXT    = 3,
	SBPM_OPCODE_BN_CONNECT              = 4,
	SBPM_OPCODE_GET_NEXT                = 5,
	SBPM_OPCODE_BN_FREE_WO_CONTEXT      = 6,
	SBPM_OPCODE_INGRESS_TO_EGRESS       = 7,
	SBPM_OPCODE_LAST                    = 7
} rdd_sbpm_opcode;
/* <<<RDD_SBPM_OPCODE */


/* >>>RDD_RDD_LAN */
typedef enum
{
	RDD_LAN_FIRST           = 1,
	RDD_LAN_BRIDGE_PORT0    = 1,
	RDD_LAN_BRIDGE_PORT1    = 2,
	RDD_LAN_BRIDGE_PORT2    = 3,
	RDD_LAN_BRIDGE_PORT3    = 4,
	RDD_LAN_BRIDGE_PORT4    = 5,
	RDD_LAN_BRIDGE_PORT5    = 6,
	RDD_LAN_LAST            = 6
} rdd_rdd_lan;
/* <<<RDD_RDD_LAN */


/* >>>RDD_MAC_TYPE */
typedef enum
{
	MAC_TYPE_FIRST    = 0,
	MAC_TYPE_EMAC     = 0,
	MAC_TYPE_GPON     = 1,
	MAC_TYPE_XGPON    = 2,
	MAC_TYPE_EPON     = 3,
	MAC_TYPE_XEPON    = 4,
	MAC_TYPE_DSL      = 5,
	MAC_TYPE_AE10G    = 6,
	MAC_TYPE_AE2P5    = 7,
	MAC_TYPE_LAST     = 7
} rdd_mac_type;
/* <<<RDD_MAC_TYPE */


/* >>>RDD_SBPM */
typedef enum
{
	SBPM_FIRST                    = 16383,
	SBPM_INVALID_BUFFER_NUMBER    = 16383,
	SBPM_LAST                     = 16383
} rdd_sbpm;
/* <<<RDD_SBPM */


/* >>>RDD_FPM_POOL_ID */
typedef enum
{
	FPM_POOL_ID_FIRST            = 0,
	FPM_POOL_ID_EIGHT_BUFFERS    = 0,
	FPM_POOL_ID_FOUR_BUFFERS     = 1,
	FPM_POOL_ID_TWO_BUFFERS      = 2,
	FPM_POOL_ID_ONE_BUFFER       = 3,
	FPM_POOL_ID_LAST             = 3
} rdd_fpm_pool_id;
/* <<<RDD_FPM_POOL_ID */


/* >>>RDD_GPE_COMMAND_LIST */
typedef enum
{
	GPE_COMMAND_LIST_FIRST         = 0,
	GPE_COMMAND_LIST_TERMINATOR    = 0,
	GPE_COMMAND_LIST_LAST          = 0
} rdd_gpe_command_list;
/* <<<RDD_GPE_COMMAND_LIST */


/* >>>RDD_VLAN_ACTION_GPE_OPCODE */
typedef enum
{
	VLAN_ACTION_GPE_OPCODE_FIRST              = 0,
	VLAN_ACTION_GPE_OPCODE_DROP               = 0,
	VLAN_ACTION_GPE_OPCODE_DSCP               = 1,
	VLAN_ACTION_GPE_OPCODE_MAC_HDR_COPY       = 2,
	VLAN_ACTION_GPE_OPCODE_REPLACE_16         = 3,
	VLAN_ACTION_GPE_OPCODE_REPLACE_32         = 4,
	VLAN_ACTION_GPE_OPCODE_REPLACE_BITS_16    = 5,
	VLAN_ACTION_GPE_OPCODE_COPY_BITS_16       = 6,
	VLAN_ACTION_GPE_OPCODE_SKIP_IF            = 7,
	VLAN_ACTION_GPE_OPCODE_LAST               = 7
} rdd_vlan_action_gpe_opcode;
/* <<<RDD_VLAN_ACTION_GPE_OPCODE */


/* >>>RDD_VLAN_ACTION_TPID_VALUE */
typedef enum
{
	VLAN_ACTION_TPID_VALUE_FIRST         = 0,
	VLAN_ACTION_TPID_VALUE_UNASSIGNED    = 0,
	VLAN_ACTION_TPID_VALUE_LAST          = 0
} rdd_vlan_action_tpid_value;
/* <<<RDD_VLAN_ACTION_TPID_VALUE */


/* >>>RDD_VLAN_ACTION_CL_OFFSET */
typedef enum
{
	VLAN_ACTION_CL_OFFSET_FIRST          = 0,
	VLAN_ACTION_CL_OFFSET_UNTAGGED       = 0,
	VLAN_ACTION_CL_OFFSET_1TAG           = 1,
	VLAN_ACTION_CL_OFFSET_2TAGS          = 2,
	VLAN_ACTION_CL_OFFSET_PTAG           = 3,
	VLAN_ACTION_CL_OFFSET_TRANSPARENT    = 255,
	VLAN_ACTION_CL_OFFSET_LAST           = 255
} rdd_vlan_action_cl_offset;
/* <<<RDD_VLAN_ACTION_CL_OFFSET */

#endif


/* Hardware defines */

/* >>>RDD_QM_QUEUE_COUNTER_DATA */
#define QM_QUEUE_COUNTER_DATA_PACKETS_F_OFFSET                                                          0
#define QM_QUEUE_COUNTER_DATA_PACKETS_F_WIDTH                                                           32
#define QM_QUEUE_COUNTER_DATA_QM_QUEUE_COUNTER_DATA_OFFSET                                              0
#define QM_QUEUE_COUNTER_DATA_PACKETS_OFFSET                                                            0
#define QM_QUEUE_COUNTER_DATA_PACKETS_WORD_OFFSET                                                       0
#define QM_QUEUE_COUNTER_DATA_BYTES_F_OFFSET                                                            0
#define QM_QUEUE_COUNTER_DATA_BYTES_F_WIDTH                                                             32
#define QM_QUEUE_COUNTER_DATA_BYTES_OFFSET                                                              4
#define QM_QUEUE_COUNTER_DATA_BYTES_WORD_OFFSET                                                         1

/* >>>QM_QUEUE_COUNTER_DATA_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	packets   	;
        uint32_t	bytes     	;
#else
        uint32_t	packets   	;
        uint32_t	bytes     	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) QM_QUEUE_COUNTER_DATA_STRUCT;

#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<QM_QUEUE_COUNTER_DATA_STRUCT */

/* <<<RDD_QM_QUEUE_COUNTER_DATA */


/* >>>RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY */
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_F_OFFSET                                                           8
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_F_WIDTH                                                            8
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_INGRESS_CONGESTION_FLOW_CTRL_ENTRY_OFFSET                                 0
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_OFFSET                                                             0
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_WORD_OFFSET                                                        0
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_BBH_ID_F_OFFSET_MOD16                                                     8
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_F_OFFSET                                                           0
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_F_WIDTH                                                            8
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_OFFSET                                                             1
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_WORD_OFFSET                                                        0
#define INGRESS_CONGESTION_FLOW_CTRL_ENTRY_ENABLE_F_OFFSET_MOD16                                                     0
/* <<<RDD_INGRESS_CONGESTION_FLOW_CTRL_ENTRY */


/* >>>RDD_G9991_SCHEDULING_INFO_ENTRY */
#define G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_F_OFFSET                                                      0
#define G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_F_WIDTH                                                       32
#define G9991_SCHEDULING_INFO_ENTRY_G9991_SCHEDULING_INFO_ENTRY_OFFSET                                        0
#define G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_OFFSET                                                        0
#define G9991_SCHEDULING_INFO_ENTRY_CONTROL_SID_WORD_OFFSET                                                   0
#define G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_F_OFFSET                                            0
#define G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_F_WIDTH                                             32
#define G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_OFFSET                                              4
#define G9991_SCHEDULING_INFO_ENTRY_PHYSICAL_PORT_MAPPING_WORD_OFFSET                                         1
#define G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_F_OFFSET                                                  16
#define G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_F_WIDTH                                                   16
#define G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_OFFSET                                                    8
#define G9991_SCHEDULING_INFO_ENTRY_LAST_SERVED_SID_WORD_OFFSET                                               2
#define G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_F_OFFSET                                              0
#define G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_F_WIDTH                                               16
#define G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_OFFSET                                                10
#define G9991_SCHEDULING_INFO_ENTRY_DRR_COUNTER_ADDRESS_WORD_OFFSET                                           2
/* <<<RDD_G9991_SCHEDULING_INFO_ENTRY */


/* >>>RDD_MCAST_RESOLUTION */
#define MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_F_OFFSET                                              0
#define MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_F_WIDTH                                               32
#define MCAST_RESOLUTION_MCAST_RESOLUTION_OFFSET                                                   0
#define MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_OFFSET                                                0
#define MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WORD_OFFSET                                           0
#define MCAST_RESOLUTION_IPTV_REPL_0_SOP_F_OFFSET                                                  24
#define MCAST_RESOLUTION_IPTV_REPL_0_SOP_F_WIDTH                                                   8
#define MCAST_RESOLUTION_IPTV_REPL_0_SOP_OFFSET                                                    4
#define MCAST_RESOLUTION_IPTV_REPL_0_SOP_WORD_OFFSET                                               1
#define MCAST_RESOLUTION_IPTV_REPL_0_SOP_F_OFFSET_MOD16                                            8
#define MCAST_RESOLUTION_POOL_NUM_F_OFFSET                                                         22
#define MCAST_RESOLUTION_POOL_NUM_F_WIDTH                                                          2
#define MCAST_RESOLUTION_POOL_NUM_OFFSET                                                           5
#define MCAST_RESOLUTION_POOL_NUM_WORD_OFFSET                                                      1
#define MCAST_RESOLUTION_POOL_NUM_F_OFFSET_MOD8                                                    6
#define MCAST_RESOLUTION_POOL_NUM_F_OFFSET_MOD16                                                   6
#define MCAST_RESOLUTION_REPLICATIONS_F_OFFSET                                                     16
#define MCAST_RESOLUTION_REPLICATIONS_F_WIDTH                                                      6
#define MCAST_RESOLUTION_REPLICATIONS_OFFSET                                                       5
#define MCAST_RESOLUTION_REPLICATIONS_WORD_OFFSET                                                  1
#define MCAST_RESOLUTION_REPLICATIONS_F_OFFSET_MOD8                                                0
#define MCAST_RESOLUTION_REPLICATIONS_F_OFFSET_MOD16                                               0
#define MCAST_RESOLUTION_INGRESS_VPORT_F_OFFSET                                                    8
#define MCAST_RESOLUTION_INGRESS_VPORT_F_WIDTH                                                     8
#define MCAST_RESOLUTION_INGRESS_VPORT_OFFSET                                                      6
#define MCAST_RESOLUTION_INGRESS_VPORT_WORD_OFFSET                                                 1
#define MCAST_RESOLUTION_INGRESS_VPORT_F_OFFSET_MOD16                                              8
#define MCAST_RESOLUTION_TC_F_OFFSET                                                               0
#define MCAST_RESOLUTION_TC_F_WIDTH                                                                3
#define MCAST_RESOLUTION_TC_OFFSET                                                                 7
#define MCAST_RESOLUTION_TC_WORD_OFFSET                                                            1
#define MCAST_RESOLUTION_TC_F_OFFSET_MOD8                                                          0
#define MCAST_RESOLUTION_TC_F_OFFSET_MOD16                                                         0

/* >>>MCAST_RESOLUTION_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	egress_ports_vector	;
        uint8_t	iptv_repl_0_sop    	;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	egress_ports_vector	;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_repl_0_sop    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) MCAST_RESOLUTION_STRUCT;

#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                     MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                       MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v))
#define RDD_MCAST_RESOLUTION_TC_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 7, 0, 3, (v))
/* <<<MCAST_RESOLUTION_STRUCT */

/* <<<RDD_MCAST_RESOLUTION */


/* >>>RDD_NAT_CACHE_L3_LKP_ENTRY */
#define NAT_CACHE_L3_LKP_ENTRY_VALID_F_OFFSET                                                            31
#define NAT_CACHE_L3_LKP_ENTRY_VALID_F_WIDTH                                                             1
#define NAT_CACHE_L3_LKP_ENTRY_NAT_CACHE_L3_LKP_ENTRY_OFFSET                                             0
#define NAT_CACHE_L3_LKP_ENTRY_VALID_OFFSET                                                              0
#define NAT_CACHE_L3_LKP_ENTRY_VALID_WORD_OFFSET                                                         0
#define NAT_CACHE_L3_LKP_ENTRY_VALID_F_OFFSET_MOD8                                                       7
#define NAT_CACHE_L3_LKP_ENTRY_VALID_F_OFFSET_MOD16                                                      15
#define NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_F_OFFSET                                                    24
#define NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_F_WIDTH                                                     7
#define NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_OFFSET                                                      0
#define NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_WORD_OFFSET                                                 0
#define NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_F_OFFSET_MOD8                                               0
#define NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_F_OFFSET_MOD16                                              8
#define NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_F_OFFSET                                                     23
#define NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_F_WIDTH                                                      1
#define NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_OFFSET                                                       1
#define NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_WORD_OFFSET                                                  0
#define NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_F_OFFSET_MOD8                                                7
#define NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_F_OFFSET_MOD16                                               7
#define NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_OFFSET                                             22
#define NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_WIDTH                                              1
#define NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_OFFSET                                               1
#define NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_WORD_OFFSET                                          0
#define NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_OFFSET_MOD8                                        6
#define NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_OFFSET_MOD16                                       6
#define NAT_CACHE_L3_LKP_ENTRY_VPORT_F_OFFSET                                                            16
#define NAT_CACHE_L3_LKP_ENTRY_VPORT_F_WIDTH                                                             6
#define NAT_CACHE_L3_LKP_ENTRY_VPORT_OFFSET                                                              1
#define NAT_CACHE_L3_LKP_ENTRY_VPORT_WORD_OFFSET                                                         0
#define NAT_CACHE_L3_LKP_ENTRY_VPORT_F_OFFSET_MOD8                                                       0
#define NAT_CACHE_L3_LKP_ENTRY_VPORT_F_OFFSET_MOD16                                                      0
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_F_OFFSET                                                       12
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_F_WIDTH                                                        4
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_OFFSET                                                         2
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_WORD_OFFSET                                                    0
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_F_OFFSET_MOD8                                                  4
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_F_OFFSET_MOD16                                                 12
#define NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET                                                     9
#define NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_F_WIDTH                                                      3
#define NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_OFFSET                                                       2
#define NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_WORD_OFFSET                                                  0
#define NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD8                                                1
#define NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD16                                               9
#define NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_F_OFFSET                                                       8
#define NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_F_WIDTH                                                        1
#define NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_OFFSET                                                         2
#define NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_WORD_OFFSET                                                    0
#define NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_F_OFFSET_MOD8                                                  0
#define NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_F_OFFSET_MOD16                                                 8
#define NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_F_OFFSET                                                         0
#define NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_F_WIDTH                                                          8
#define NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_OFFSET                                                           3
#define NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_WORD_OFFSET                                                      0
#define NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_F_OFFSET_MOD16                                                   0
#define NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_F_OFFSET                                                         16
#define NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_F_WIDTH                                                          16
#define NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_OFFSET                                                           4
#define NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_WORD_OFFSET                                                      1
#define NAT_CACHE_L3_LKP_ENTRY_DST_PORT_F_OFFSET                                                         0
#define NAT_CACHE_L3_LKP_ENTRY_DST_PORT_F_WIDTH                                                          16
#define NAT_CACHE_L3_LKP_ENTRY_DST_PORT_OFFSET                                                           6
#define NAT_CACHE_L3_LKP_ENTRY_DST_PORT_WORD_OFFSET                                                      1
#define NAT_CACHE_L3_LKP_ENTRY_SRC_IP_F_OFFSET                                                           0
#define NAT_CACHE_L3_LKP_ENTRY_SRC_IP_F_WIDTH                                                            32
#define NAT_CACHE_L3_LKP_ENTRY_SRC_IP_OFFSET                                                             8
#define NAT_CACHE_L3_LKP_ENTRY_SRC_IP_WORD_OFFSET                                                        2
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_F_OFFSET                                                           0
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_F_WIDTH                                                            32
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_OFFSET                                                             12
#define NAT_CACHE_L3_LKP_ENTRY_DST_IP_WORD_OFFSET                                                        3

/* >>>NAT_CACHE_L3_LKP_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_ip_3_0          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_extend          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	protocol            	;
        uint16_t	src_port            	;
        uint16_t	dst_port            	;
        uint32_t	src_ip              	;
        uint32_t	dst_ip              	;
#else
        uint8_t	protocol            	;
        uint32_t	key_extend          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_ip_3_0          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_port            	;
        uint16_t	src_port            	;
        uint32_t	src_ip              	;
        uint32_t	dst_ip              	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NAT_CACHE_L3_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 0, 7, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 0, 7, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 0, 7, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_ZERO_RESERVED_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 0, 7, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VPORT_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 0, 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VPORT_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 0, 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VPORT_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VPORT_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_READ(r, p)                             MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_READ(r, p)                             MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_READ(r, p)                             MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_READ(r, p)                               MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_READ(r, p)                               MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<NAT_CACHE_L3_LKP_ENTRY_STRUCT */

/* <<<RDD_NAT_CACHE_L3_LKP_ENTRY */


/* >>>RDD_NAT_CACHE_L2_LKP_ENTRY */
#define NAT_CACHE_L2_LKP_ENTRY_VALID_F_OFFSET                                                            31
#define NAT_CACHE_L2_LKP_ENTRY_VALID_F_WIDTH                                                             1
#define NAT_CACHE_L2_LKP_ENTRY_NAT_CACHE_L2_LKP_ENTRY_OFFSET                                             0
#define NAT_CACHE_L2_LKP_ENTRY_VALID_OFFSET                                                              0
#define NAT_CACHE_L2_LKP_ENTRY_VALID_WORD_OFFSET                                                         0
#define NAT_CACHE_L2_LKP_ENTRY_VALID_F_OFFSET_MOD8                                                       7
#define NAT_CACHE_L2_LKP_ENTRY_VALID_F_OFFSET_MOD16                                                      15
#define NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_F_OFFSET                                                      23
#define NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_F_WIDTH                                                       1
#define NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_OFFSET                                                        1
#define NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_WORD_OFFSET                                                   0
#define NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_F_OFFSET_MOD8                                                 7
#define NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_F_OFFSET_MOD16                                                7
#define NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_OFFSET                                             22
#define NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_WIDTH                                              1
#define NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_OFFSET                                               1
#define NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_WORD_OFFSET                                          0
#define NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_OFFSET_MOD8                                        6
#define NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_F_OFFSET_MOD16                                       6
#define NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_F_OFFSET                                                      16
#define NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_F_WIDTH                                                       6
#define NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_OFFSET                                                        1
#define NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_WORD_OFFSET                                                   0
#define NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_F_OFFSET_MOD8                                                 0
#define NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_F_OFFSET_MOD16                                                0
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_F_OFFSET                                          12
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_F_WIDTH                                           4
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_OFFSET                                            2
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_WORD_OFFSET                                       0
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_F_OFFSET_MOD8                                     4
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_F_OFFSET_MOD16                                    12
#define NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET                                                     9
#define NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_F_WIDTH                                                      3
#define NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_OFFSET                                                       2
#define NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_WORD_OFFSET                                                  0
#define NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD8                                                1
#define NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD16                                               9
#define NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_F_OFFSET                                                     8
#define NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_F_WIDTH                                                      1
#define NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_OFFSET                                                       2
#define NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_WORD_OFFSET                                                  0
#define NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_F_OFFSET_MOD8                                                0
#define NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_F_OFFSET_MOD16                                               8
#define NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_F_OFFSET                                                         0
#define NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_F_WIDTH                                                          8
#define NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_OFFSET                                                           3
#define NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_WORD_OFFSET                                                      0
#define NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_F_OFFSET_MOD16                                                   0
#define NAT_CACHE_L2_LKP_ENTRY_ETYPE_F_OFFSET                                                            16
#define NAT_CACHE_L2_LKP_ENTRY_ETYPE_F_WIDTH                                                             16
#define NAT_CACHE_L2_LKP_ENTRY_ETYPE_OFFSET                                                              4
#define NAT_CACHE_L2_LKP_ENTRY_ETYPE_WORD_OFFSET                                                         1
#define NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_F_OFFSET                                                        8
#define NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_F_WIDTH                                                         8
#define NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_OFFSET                                                          6
#define NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_WORD_OFFSET                                                     1
#define NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_F_OFFSET_MOD16                                                  8
#define NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_F_OFFSET                                                     6
#define NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_F_WIDTH                                                      2
#define NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_OFFSET                                                       7
#define NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_WORD_OFFSET                                                  1
#define NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_F_OFFSET_MOD8                                                6
#define NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_F_OFFSET_MOD16                                               6
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_F_OFFSET                                                      3
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_F_WIDTH                                                       3
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_OFFSET                                                        7
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_WORD_OFFSET                                                   1
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_F_OFFSET_MOD8                                                 3
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_F_OFFSET_MOD16                                                3
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_F_OFFSET                                                      0
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_F_WIDTH                                                       3
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_OFFSET                                                        7
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_WORD_OFFSET                                                   1
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_F_OFFSET_MOD8                                                 0
#define NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_F_OFFSET_MOD16                                                0
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_F_OFFSET                                                     16
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_F_WIDTH                                                      16
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_OFFSET                                                       8
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_WORD_OFFSET                                                  2
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_F_OFFSET                                                     0
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_F_WIDTH                                                      16
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_OFFSET                                                       10
#define NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_WORD_OFFSET                                                  2
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_F_OFFSET                                              0
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_F_WIDTH                                               32
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_OFFSET                                                12
#define NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_WORD_OFFSET                                           3

/* >>>NAT_CACHE_L2_LKP_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_llc_snap            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lookup_port            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_mac_dst_mac_crc_3_0	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	wan_flow               	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	etype                  	;
        uint8_t	tos_union              	; /* This is a field union */
        uint32_t	num_of_vlans           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tpid_vlan_0            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tpid_vlan_1            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_etype                	;
        uint8_t	tos                              	; /* Member of tos_union union */
        uint32_t	reservedSU1_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_etype                	;
        uint32_t	dscp                             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	ecn                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	reservedSU2_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	vlan_0_union           	; /* This is a field union */
        uint16_t	vlan_1_union           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	vlan0                            	; /* Member of vlan_0_union union */
        uint16_t	vlan1                            	; /* Member of vlan_1_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	vid0                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	dei0                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	pbit0                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	vid1                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	dei1                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	pbit1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_mac_dst_mac_crc    	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	wan_flow               	;
        uint32_t	tcp_pure_ack           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_mac_dst_mac_crc_3_0	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lookup_port            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_llc_snap            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tpid_vlan_1            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tpid_vlan_0            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_vlans           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos_union              	; /* This is a field union */
        uint16_t	etype                  	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos                              	; /* Member of tos_union union */
        uint16_t	reservedSU1_etype                	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	dscp                             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint16_t	reservedSU2_etype                	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	vlan_1_union           	; /* This is a field union */
        uint16_t	vlan_0_union           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	vlan1                            	; /* Member of vlan_1_union union */
        uint16_t	vlan0                            	; /* Member of vlan_0_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	pbit1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	dei1                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	vid1                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	pbit0                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	dei0                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	vid0                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_mac_dst_mac_crc    	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NAT_CACHE_L2_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 0, 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 0, 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_READ(r, p)                                MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_READ(r, p)                               MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_READ_G(r, g, idx)                              GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_WRITE_G(v, g, idx)                             GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_READ(r, p)                                     MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_WRITE(v, p)                                    MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 2, 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 2, 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 6, 2, 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 6, 2, 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 0, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 0, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 6, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 6, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 7, 6, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 7, 6, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 3, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 3, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 7, 3, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 7, 3, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 7, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 7, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_READ(r, p)                            MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_WRITE(v, p)                           MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_READ(r, p)                                    FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_WRITE(v, p)                                   FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_READ(r, p)                            MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_WRITE(v, p)                           MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_READ(r, p)                                    FIELD_MREAD_16((uint8_t *)(p) + 10, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_WRITE(v, p)                                   FIELD_MWRITE_16((uint8_t *)(p) + 10, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 11, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 11, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_READ(r, p)                     MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<NAT_CACHE_L2_LKP_ENTRY_STRUCT */

/* <<<RDD_NAT_CACHE_L2_LKP_ENTRY */


/* >>>RDD_NAT_CACHE_MC_LKP_ENTRY */
#define NAT_CACHE_MC_LKP_ENTRY_VALID_F_OFFSET                                                            31
#define NAT_CACHE_MC_LKP_ENTRY_VALID_F_WIDTH                                                             1
#define NAT_CACHE_MC_LKP_ENTRY_NAT_CACHE_MC_LKP_ENTRY_OFFSET                                             0
#define NAT_CACHE_MC_LKP_ENTRY_VALID_OFFSET                                                              0
#define NAT_CACHE_MC_LKP_ENTRY_VALID_WORD_OFFSET                                                         0
#define NAT_CACHE_MC_LKP_ENTRY_VALID_F_OFFSET_MOD8                                                       7
#define NAT_CACHE_MC_LKP_ENTRY_VALID_F_OFFSET_MOD16                                                      15
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_F_OFFSET                                                           0
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_F_WIDTH                                                            31
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_OFFSET                                                             0
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WORD_OFFSET                                                        0
#define NAT_CACHE_MC_LKP_ENTRY_DST_IP_F_OFFSET                                                           0
#define NAT_CACHE_MC_LKP_ENTRY_DST_IP_F_WIDTH                                                            32
#define NAT_CACHE_MC_LKP_ENTRY_DST_IP_OFFSET                                                             4
#define NAT_CACHE_MC_LKP_ENTRY_DST_IP_WORD_OFFSET                                                        1
#define NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_F_OFFSET                                                  0
#define NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_F_WIDTH                                                   32
#define NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_OFFSET                                                    8
#define NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WORD_OFFSET                                               2
#define NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_F_OFFSET                                                        24
#define NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_F_WIDTH                                                         8
#define NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_OFFSET                                                          12
#define NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_WORD_OFFSET                                                     3
#define NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_F_OFFSET_MOD16                                                  8
#define NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_F_OFFSET                                                         19
#define NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_F_WIDTH                                                          5
#define NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_OFFSET                                                           13
#define NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WORD_OFFSET                                                      3
#define NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_F_OFFSET_MOD8                                                    3
#define NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_F_OFFSET_MOD16                                                   3
#define NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_F_OFFSET                                                     16
#define NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_F_WIDTH                                                      3
#define NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_OFFSET                                                       13
#define NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WORD_OFFSET                                                  3
#define NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_F_OFFSET_MOD8                                                0
#define NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_F_OFFSET_MOD16                                               0
#define NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_F_OFFSET                                                    14
#define NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_F_WIDTH                                                     2
#define NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_OFFSET                                                      14
#define NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_WORD_OFFSET                                                 3
#define NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_F_OFFSET_MOD8                                               6
#define NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_F_OFFSET_MOD16                                              14
#define NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_F_OFFSET                                                          13
#define NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_F_WIDTH                                                           1
#define NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_OFFSET                                                            14
#define NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WORD_OFFSET                                                       3
#define NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_F_OFFSET_MOD8                                                     5
#define NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_F_OFFSET_MOD16                                                    13
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_F_OFFSET                                                       12
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_F_WIDTH                                                        1
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_OFFSET                                                         14
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_WORD_OFFSET                                                    3
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_F_OFFSET_MOD8                                                  4
#define NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_F_OFFSET_MOD16                                                 12
#define NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_F_OFFSET                                                       4
#define NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_F_WIDTH                                                        8
#define NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_OFFSET                                                         14
#define NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WORD_OFFSET                                                    3
#define NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_F_OFFSET_MOD16                                                 4
#define NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_F_OFFSET                                                     0
#define NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_F_WIDTH                                                      4
#define NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_OFFSET                                                       15
#define NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WORD_OFFSET                                                  3
#define NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_F_OFFSET_MOD8                                                0
#define NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_F_OFFSET_MOD16                                               0

/* >>>NAT_CACHE_MC_LKP_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_ip         	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip         	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	vlans_etype_crc	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	tos_union      	; /* This is a field union */
        uint32_t	rx_vport       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_vlans   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ipv6        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_ip_msb     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	var_size_ctx   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	tos                      	; /* Member of tos_union union */
        uint32_t	reservedSU1_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	dscp                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	ecn                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	reservedSU2_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_ip         	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip         	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	vlans_etype_crc	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	var_size_ctx   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_ip_msb     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ipv6        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_vlans   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rx_vport       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos_union      	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos                      	; /* Member of tos_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	dscp                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NAT_CACHE_MC_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 0, 31, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 0, 31, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p), 0, 31, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p), 0, 31, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ(r, p)                          MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ(r, p)                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_READ(r, p)                       MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ(r, p)                             MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 12, 2, 6, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 12, 2, 6, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 12, 0, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 12, 0, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 3, 5, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 3, 5, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 13, 3, 5, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 13, 3, 5, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 0, 3, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 0, 3, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 3, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 3, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 14, 6, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 14, 6, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 5, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 5, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 14, 5, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 14, 5, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 14, 4, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 14, 4, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 14, 4, 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 14, 4, 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
/* <<<NAT_CACHE_MC_LKP_ENTRY_STRUCT */

/* <<<RDD_NAT_CACHE_MC_LKP_ENTRY */


/* >>>RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY */
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_F_OFFSET                                                            31
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_F_WIDTH                                                             1
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_OFFSET                                    0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_OFFSET                                                              0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WORD_OFFSET                                                         0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_F_OFFSET_MOD8                                                       7
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_F_OFFSET_MOD16                                                      15
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_F_OFFSET                                                     9
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_F_WIDTH                                                      3
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_OFFSET                                                       2
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WORD_OFFSET                                                  0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD8                                                1
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD16                                               9
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_F_OFFSET                                                        24
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_F_WIDTH                                                         1
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_OFFSET                                                          12
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WORD_OFFSET                                                     3
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_F_OFFSET_MOD8                                                   0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_F_OFFSET_MOD16                                                  8
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_F_OFFSET                                                             16
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_F_WIDTH                                                              8
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_OFFSET                                                               13
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WORD_OFFSET                                                          3
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_F_OFFSET_MOD16                                                       0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_F_OFFSET                                                             0
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_F_WIDTH                                                              16
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_OFFSET                                                               14
#define NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WORD_OFFSET                                                          3

/* >>>NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	;
        uint32_t	reserved5   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	port        	;
        uint16_t	rule        	;
#else
        uint32_t	reserved2   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	;
        uint16_t	rule        	;
        uint8_t	port        	;
        uint32_t	extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT;

#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, 0, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, 0, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 12, 0, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 12, 0, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 13, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 13, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ(r, p)                         MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 13, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ(r, p)                         MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT */

/* <<<RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY */


/* >>>RDD_NAT_CACHE_COUNTER_LKP_ENTRY */
#define NAT_CACHE_COUNTER_LKP_ENTRY_VALID_F_OFFSET                                                            31
#define NAT_CACHE_COUNTER_LKP_ENTRY_VALID_F_WIDTH                                                             1
#define NAT_CACHE_COUNTER_LKP_ENTRY_NAT_CACHE_COUNTER_LKP_ENTRY_OFFSET                                        0
#define NAT_CACHE_COUNTER_LKP_ENTRY_VALID_OFFSET                                                              0
#define NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WORD_OFFSET                                                         0
#define NAT_CACHE_COUNTER_LKP_ENTRY_VALID_F_OFFSET_MOD8                                                       7
#define NAT_CACHE_COUNTER_LKP_ENTRY_VALID_F_OFFSET_MOD16                                                      15
#define NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET                                                     16
#define NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_F_WIDTH                                                      8
#define NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_OFFSET                                                       1
#define NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WORD_OFFSET                                                  0
#define NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_F_OFFSET_MOD16                                               0
#define NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_F_OFFSET                                                      0
#define NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_F_WIDTH                                                       32
#define NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_OFFSET                                                        12
#define NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WORD_OFFSET                                                   3

/* >>>NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sub_table_id	;
        uint16_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	counter_key 	;
#else
        uint16_t	reserved1   	;
        uint8_t	sub_table_id	;
        uint32_t	reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	counter_key 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ(r, p)                  MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT */

/* <<<RDD_NAT_CACHE_COUNTER_LKP_ENTRY */


/* >>>RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX */
#define NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_F_OFFSET                                                     4
#define NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_F_WIDTH                                                      4
#define NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_OFFSET                                                       15
#define NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WORD_OFFSET                                                  3
#define NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_F_OFFSET_MOD8                                                4
#define NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_F_OFFSET_MOD16                                               4

/* >>>NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	var_size_ctx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	var_size_ctx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT;

#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (r))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (v))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 15, 4, 4, (r))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 15, 4, 4, (v))
/* <<<NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT */

/* <<<RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX */


/* >>>RDD_NATC_COMMAND_DATA_EXT */
#define NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_EXT_OFFSET                                              0
#define NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_OFFSET                                         0
#define NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WORD_OFFSET                                    0
#define NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_F_OFFSET_MOD16                                 0
#define NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_OFFSET                                                    40
#define NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WORD_OFFSET                                               10
#define NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_F_OFFSET_MOD16                                            8

/* >>>NATC_COMMAND_DATA_EXT_STRUCT */
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_NUMBER	40
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_NUMBER	16
typedef union
{
    uint32_t word_32[14];
    uint64_t dword_64[7];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	natc_command_data_reserved[RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_NUMBER];
        uint8_t	natc_l2_crc_buf[RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_NUMBER];
#else
        uint8_t	natc_command_data_reserved[RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_NUMBER];
        uint8_t	natc_l2_crc_buf[RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NATC_COMMAND_DATA_EXT_STRUCT;

#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ_G(r, g, idx, i)                  GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE_G(v, g, idx, i)                 GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ(r, p, i)                         MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE(v, p, i)                        MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
/* <<<NATC_COMMAND_DATA_EXT_STRUCT */

/* <<<RDD_NATC_COMMAND_DATA_EXT */


/* >>>RDD_HASH_COMMAND */
#define HASH_COMMAND_CONFIGURATION_F_OFFSET                                                    29
#define HASH_COMMAND_CONFIGURATION_F_WIDTH                                                     3
#define HASH_COMMAND_HASH_COMMAND_OFFSET                                                       0
#define HASH_COMMAND_CONFIGURATION_OFFSET                                                      0
#define HASH_COMMAND_CONFIGURATION_WORD_OFFSET                                                 0
#define HASH_COMMAND_CONFIGURATION_F_OFFSET_MOD8                                               5
#define HASH_COMMAND_CONFIGURATION_F_OFFSET_MOD16                                              13
#define HASH_COMMAND_AGING_F_OFFSET                                                            28
#define HASH_COMMAND_AGING_F_WIDTH                                                             1
#define HASH_COMMAND_AGING_OFFSET                                                              0
#define HASH_COMMAND_AGING_WORD_OFFSET                                                         0
#define HASH_COMMAND_AGING_F_OFFSET_MOD8                                                       4
#define HASH_COMMAND_AGING_F_OFFSET_MOD16                                                      12
#define HASH_COMMAND_KEY_1_F_OFFSET                                                            0
#define HASH_COMMAND_KEY_1_F_WIDTH                                                             28
#define HASH_COMMAND_KEY_1_OFFSET                                                              0
#define HASH_COMMAND_KEY_1_WORD_OFFSET                                                         0
#define HASH_COMMAND_KEY_0_F_OFFSET                                                            0
#define HASH_COMMAND_KEY_0_F_WIDTH                                                             32
#define HASH_COMMAND_KEY_0_OFFSET                                                              4
#define HASH_COMMAND_KEY_0_WORD_OFFSET                                                         1

/* >>>HASH_COMMAND_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	configuration	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aging        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_1        	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_0        	;
#else
        uint32_t	key_1        	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aging        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	configuration	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_0        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) HASH_COMMAND_STRUCT;

#define RDD_HASH_COMMAND_CONFIGURATION_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (r))
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (v))
#define RDD_HASH_COMMAND_CONFIGURATION_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_HASH_COMMAND_AGING_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (r))
#define RDD_HASH_COMMAND_AGING_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (v))
#define RDD_HASH_COMMAND_AGING_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_HASH_COMMAND_AGING_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_HASH_COMMAND_KEY_1_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (r))
#define RDD_HASH_COMMAND_KEY_1_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (v))
#define RDD_HASH_COMMAND_KEY_1_READ(r, p)                         FIELD_MREAD_32((uint8_t *)(p), 0, 28, (r))
#define RDD_HASH_COMMAND_KEY_1_WRITE(v, p)                        FIELD_MWRITE_32((uint8_t *)(p), 0, 28, (v))
#define RDD_HASH_COMMAND_KEY_0_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (r))
#define RDD_HASH_COMMAND_KEY_0_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (v))
#define RDD_HASH_COMMAND_KEY_0_READ(r, p)                         MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_HASH_COMMAND_KEY_0_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<HASH_COMMAND_STRUCT */

/* <<<RDD_HASH_COMMAND */


/* >>>RDD_PBIT_TO_DSCP_ENTRY */
#define PBIT_TO_DSCP_ENTRY_PBIT_TO_DSCP_ENTRY_OFFSET                                                 0
#define PBIT_TO_DSCP_ENTRY_DSCP_OFFSET                                                               0
#define PBIT_TO_DSCP_ENTRY_DSCP_WORD_OFFSET                                                          0
#define PBIT_TO_DSCP_ENTRY_DSCP_F_OFFSET_MOD16                                                       0
/* <<<RDD_PBIT_TO_DSCP_ENTRY */


/* >>>RDD_RULE_BASED_RESOLUTION */
#define RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET                                                    31
#define RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_WIDTH                                                     1
#define RULE_BASED_RESOLUTION_RULE_BASED_RESOLUTION_OFFSET                                              0
#define RULE_BASED_RESOLUTION_EGRESS_IS_CPU_OFFSET                                                      0
#define RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WORD_OFFSET                                                 0
#define RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD8                                               7
#define RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD16                                              15
#define RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET                                                    28
#define RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_WIDTH                                                     3
#define RULE_BASED_RESOLUTION_EGRESS_CPU_TC_OFFSET                                                      0
#define RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WORD_OFFSET                                                 0
#define RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD8                                               4
#define RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD16                                              12
#define RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET                                              16
#define RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_WIDTH                                               12
#define RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_OFFSET                                                0
#define RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WORD_OFFSET                                           0
#define RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET_MOD16                                        0
#define RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_OFFSET                                               0
#define RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_WIDTH                                                4
#define RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_OFFSET                                                 3
#define RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WORD_OFFSET                                            0
#define RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_OFFSET_MOD8                                          0
#define RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_OFFSET_MOD16                                         0
#define RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_F_OFFSET                                           16
#define RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_F_WIDTH                                            16
#define RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_OFFSET                                             4
#define RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WORD_OFFSET                                        1

/* >>>RULE_BASED_RESOLUTION_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	egress_is_cpu       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc       	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	disabled_protocols  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	rule2bridge_resolution	; /* This is a field union */
        uint16_t	reserved4           	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	egress_port_resolved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved1                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	bridge_egress_vport           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint8_t	reserved2                     	; /* Member of rule2bridge_resolution union */
        uint16_t	reservedSU1_reserved4         	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	tc_to_queue                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_to_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	dei_color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	vlan_action                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	forw_mode                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	drop_precedence               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_remark                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	service_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved3                     	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint16_t	reservedSU2_reserved4         	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	disabled_protocols  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc       	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_is_cpu       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	reserved4           	;
        uint16_t	rule2bridge_resolution	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_reserved4         	;
        uint8_t	reserved2                     	; /* Member of rule2bridge_resolution union */
        uint32_t	bridge_egress_vport           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved1                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	egress_port_resolved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_reserved4         	;
        uint32_t	reserved3                     	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	service_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_remark                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	drop_precedence               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	forw_mode                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	vlan_action                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	dei_color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_to_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc_to_queue                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) RULE_BASED_RESOLUTION_STRUCT;

#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 4, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 4, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 4, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 4, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)           GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 0, 12, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 0, 12, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                  FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                 FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 3, 0, 4, (r))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 3, 0, 4, (v))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_G(r, g, idx)        GROUP_MREAD_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, (r))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_G(v, g, idx)       GROUP_MWRITE_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, (v))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ(r, p)               MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE(v, p)              MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (r))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (v))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 5, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 5, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 4, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
/* <<<RULE_BASED_RESOLUTION_STRUCT */

/* <<<RDD_RULE_BASED_RESOLUTION */


/* >>>RDD_FLOW_BASED_RESOLUTION */
#define FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET                                                    31
#define FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_WIDTH                                                     1
#define FLOW_BASED_RESOLUTION_FLOW_BASED_RESOLUTION_OFFSET                                              0
#define FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_OFFSET                                                      0
#define FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WORD_OFFSET                                                 0
#define FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD8                                               7
#define FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD16                                              15
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET                                                    28
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_WIDTH                                                     3
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_OFFSET                                                      0
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WORD_OFFSET                                                 0
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD8                                               4
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD16                                              12
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET                                              16
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_WIDTH                                               12
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_OFFSET                                                0
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WORD_OFFSET                                           0
#define FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET_MOD16                                        0

/* >>>FLOW_BASED_RESOLUTION_STRUCT */
#define RDD_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER	2
#define RDD_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER	4
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	egress_is_cpu                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc                                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved                                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved0[RDD_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER];
        uint8_t	reserved1[RDD_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER];
#else
        uint8_t	reserved0[RDD_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER];
        uint32_t	egress_cpu_reserved                                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc                                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_is_cpu                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1[RDD_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FLOW_BASED_RESOLUTION_STRUCT;

#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 4, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 4, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<FLOW_BASED_RESOLUTION_STRUCT */

/* <<<RDD_FLOW_BASED_RESOLUTION */


/* >>>RDD_INGRESS_QOS_MAPPING */
#define INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET                                                     8
#define INGRESS_QOS_MAPPING_INGRESS_DSCP_F_WIDTH                                                      6
#define INGRESS_QOS_MAPPING_INGRESS_DSCP_OFFSET                                                       0
#define INGRESS_QOS_MAPPING_INGRESS_DSCP_WORD_OFFSET                                                  0
#define INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET_MOD8                                                0
#define INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET_MOD16                                               8
#define INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET                                             3
#define INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_WIDTH                                              2
#define INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_OFFSET                                               1
#define INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WORD_OFFSET                                          0
#define INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET_MOD8                                        3
#define INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET_MOD16                                       3
#define INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET                                                     0
#define INGRESS_QOS_MAPPING_INGRESS_PBIT_F_WIDTH                                                      3
#define INGRESS_QOS_MAPPING_INGRESS_PBIT_OFFSET                                                       1
#define INGRESS_QOS_MAPPING_INGRESS_PBIT_WORD_OFFSET                                                  0
#define INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET_MOD8                                                0
#define INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET_MOD16                                               0

/* >>>INGRESS_QOS_MAPPING_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) INGRESS_QOS_MAPPING_STRUCT;

#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT), 0, 6, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT), 0, 6, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 3, 2, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 3, 2, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 3, 2, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 3, 2, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 0, 3, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 0, 3, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 3, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 3, (v))
/* <<<INGRESS_QOS_MAPPING_STRUCT */

/* <<<RDD_INGRESS_QOS_MAPPING */


/* >>>RDD_COMMON_RESOLUTION */
#define COMMON_RESOLUTION_LOOPBACK_F_OFFSET                                                         31
#define COMMON_RESOLUTION_LOOPBACK_F_WIDTH                                                          1
#define COMMON_RESOLUTION_COMMON_RESOLUTION_OFFSET                                                  0
#define COMMON_RESOLUTION_LOOPBACK_OFFSET                                                           0
#define COMMON_RESOLUTION_LOOPBACK_WORD_OFFSET                                                      0
#define COMMON_RESOLUTION_LOOPBACK_F_OFFSET_MOD8                                                    7
#define COMMON_RESOLUTION_LOOPBACK_F_OFFSET_MOD16                                                   15
#define COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_OFFSET                                                30
#define COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_WIDTH                                                 1
#define COMMON_RESOLUTION_CPU_REDIRECT_FLAG_OFFSET                                                  0
#define COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WORD_OFFSET                                             0
#define COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_OFFSET_MOD8                                           6
#define COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_OFFSET_MOD16                                          14
#define COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_OFFSET                                                29
#define COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_WIDTH                                                 1
#define COMMON_RESOLUTION_DMA_HEADER_UPDATE_OFFSET                                                  0
#define COMMON_RESOLUTION_DMA_HEADER_UPDATE_WORD_OFFSET                                             0
#define COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_OFFSET_MOD8                                           5
#define COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_OFFSET_MOD16                                          13
#define COMMON_RESOLUTION_LONG_HEADER_WRITE_F_OFFSET                                                28
#define COMMON_RESOLUTION_LONG_HEADER_WRITE_F_WIDTH                                                 1
#define COMMON_RESOLUTION_LONG_HEADER_WRITE_OFFSET                                                  0
#define COMMON_RESOLUTION_LONG_HEADER_WRITE_WORD_OFFSET                                             0
#define COMMON_RESOLUTION_LONG_HEADER_WRITE_F_OFFSET_MOD8                                           4
#define COMMON_RESOLUTION_LONG_HEADER_WRITE_F_OFFSET_MOD16                                          12
#define COMMON_RESOLUTION_IS_LAN_F_OFFSET                                                           24
#define COMMON_RESOLUTION_IS_LAN_F_WIDTH                                                            1
#define COMMON_RESOLUTION_IS_LAN_OFFSET                                                             0
#define COMMON_RESOLUTION_IS_LAN_WORD_OFFSET                                                        0
#define COMMON_RESOLUTION_IS_LAN_F_OFFSET_MOD8                                                      0
#define COMMON_RESOLUTION_IS_LAN_F_OFFSET_MOD16                                                     8
#define COMMON_RESOLUTION_RX_FLOW_F_OFFSET                                                          16
#define COMMON_RESOLUTION_RX_FLOW_F_WIDTH                                                           8
#define COMMON_RESOLUTION_RX_FLOW_OFFSET                                                            1
#define COMMON_RESOLUTION_RX_FLOW_WORD_OFFSET                                                       0
#define COMMON_RESOLUTION_RX_FLOW_F_OFFSET_MOD16                                                    0
#define COMMON_RESOLUTION_TX_FLOW_F_OFFSET                                                          0
#define COMMON_RESOLUTION_TX_FLOW_F_WIDTH                                                           16
#define COMMON_RESOLUTION_TX_FLOW_OFFSET                                                            2
#define COMMON_RESOLUTION_TX_FLOW_WORD_OFFSET                                                       0
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_OFFSET                                    30
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_WIDTH                                     2
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_OFFSET                                                4
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_OFFSET                                      4
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WORD_OFFSET                                 1
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_OFFSET_MOD8                               6
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_OFFSET_MOD16                              14
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET                                 24
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_WIDTH                                  6
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_OFFSET                                   4
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WORD_OFFSET                              1
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET_MOD8                            0
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET_MOD16                           8
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_OFFSET                                    21
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_WIDTH                                     3
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_OFFSET                                      5
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WORD_OFFSET                                 1
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_OFFSET_MOD8                               5
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_OFFSET_MOD16                              5
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET                         19
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_WIDTH                          2
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_OFFSET                           5
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WORD_OFFSET                      1
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET_MOD8                    3
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET_MOD16                   3
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET                                 16
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_WIDTH                                  3
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_OFFSET                                   5
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WORD_OFFSET                              1
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET_MOD8                            0
#define COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET_MOD16                           0
#define COMMON_RESOLUTION_G9991_EGRESS_VPORT_F_OFFSET                                               0
#define COMMON_RESOLUTION_G9991_EGRESS_VPORT_F_WIDTH                                                16
#define COMMON_RESOLUTION_G9991_EGRESS_VPORT_OFFSET                                                 6
#define COMMON_RESOLUTION_G9991_EGRESS_VPORT_WORD_OFFSET                                            1
#define COMMON_RESOLUTION_TIMESTAMP_F_OFFSET                                                        0
#define COMMON_RESOLUTION_TIMESTAMP_F_WIDTH                                                         32
#define COMMON_RESOLUTION_TIMESTAMP_OFFSET                                                          8
#define COMMON_RESOLUTION_TIMESTAMP_WORD_OFFSET                                                     2
#define COMMON_RESOLUTION_LOOKUP_PORT_F_OFFSET                                                      24
#define COMMON_RESOLUTION_LOOKUP_PORT_F_WIDTH                                                       8
#define COMMON_RESOLUTION_LOOKUP_PORT_OFFSET                                                        12
#define COMMON_RESOLUTION_LOOKUP_PORT_WORD_OFFSET                                                   3
#define COMMON_RESOLUTION_LOOKUP_PORT_F_OFFSET_MOD16                                                8
#define COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_F_OFFSET                                        8
#define COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_F_WIDTH                                         8
#define COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_OFFSET                                          14
#define COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WORD_OFFSET                                     3
#define COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_F_OFFSET_MOD16                                  8
#define COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_F_OFFSET                                             0
#define COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_F_WIDTH                                              8
#define COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_OFFSET                                               15
#define COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WORD_OFFSET                                          3
#define COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_F_OFFSET_MOD16                                       0

/* >>>COMMON_RESOLUTION_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	loopback                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_redirect_flag                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dma_header_update                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	long_header_write                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_0                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_lan                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	rx_flow                                 	;
        uint16_t	tx_flow                                 	;
        uint32_t	ingress_qos_mapping_reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	g9991_egress_vport                      	;
        uint32_t	timestamp                               	;
        uint8_t	lookup_port                             	;
        uint8_t	reserved_1                              	;
        uint8_t	mcast_current_replication               	;
        uint8_t	tunnel_header_length                    	;
#else
        uint16_t	tx_flow                                 	;
        uint8_t	rx_flow                                 	;
        uint32_t	is_lan                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_0                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	long_header_write                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dma_header_update                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_redirect_flag                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	g9991_egress_vport                      	;
        uint32_t	ingress_qos_mapping_ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	timestamp                               	;
        uint8_t	tunnel_header_length                    	;
        uint8_t	mcast_current_replication               	;
        uint8_t	reserved_1                              	;
        uint8_t	lookup_port                             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) COMMON_RESOLUTION_STRUCT;

#define RDD_COMMON_RESOLUTION_LOOPBACK_READ_G(r, g, idx)                                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_COMMON_RESOLUTION_LOOPBACK_WRITE_G(v, g, idx)                                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_COMMON_RESOLUTION_LOOPBACK_READ(r, p)                                                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_COMMON_RESOLUTION_LOOPBACK_WRITE(v, p)                                                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 6, 1, (r))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 6, 1, (v))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 5, 1, (r))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 5, 1, (v))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 4, 1, (r))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 4, 1, (v))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_LAN_READ_G(r, g, idx)                                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE_G(v, g, idx)                                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_LAN_READ(r, p)                                                   FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE(v, p)                                                  FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (r))
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (v))
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ_G(r, g, idx)                                           GROUP_MREAD_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, (r))
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE_G(v, g, idx)                                          GROUP_MWRITE_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, (v))
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ(r, p)                                                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE(v, p)                                                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 6, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 6, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 0, 6, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 0, 6, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 5, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 5, 3, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 3, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 3, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 3, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 0, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 0, 3, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 3, (v))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (r))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (v))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 8, (r))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 8, (v))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 12, (r))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 12, (v))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 14, (r))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 14, (v))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ(r, p)                                MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ_G(r, g, idx)                              GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 15, (r))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE_G(v, g, idx)                             GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 15, (v))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ(r, p)                                     MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE(v, p)                                    MWRITE_8((uint8_t *)(p) + 15, (v))
/* <<<COMMON_RESOLUTION_STRUCT */

/* <<<RDD_COMMON_RESOLUTION */


/* >>>RDD_PACKET_BUFFER_RESOLUTION_ENTRY */
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_F_OFFSET                                       31
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_F_WIDTH                                        1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_OFFSET                                                  0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_OFFSET                                         0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_WORD_OFFSET                                    0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_F_OFFSET_MOD8                                  7
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_F_OFFSET_MOD16                                 15
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_OFFSET                              30
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_WIDTH                               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_OFFSET                                0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WORD_OFFSET                           0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_OFFSET_MOD8                         6
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_F_OFFSET_MOD16                        14
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_OFFSET                              29
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_WIDTH                               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_OFFSET                                0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WORD_OFFSET                           0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_OFFSET_MOD8                         5
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_F_OFFSET_MOD16                        13
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_F_OFFSET                              28
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_F_WIDTH                               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_OFFSET                                0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_WORD_OFFSET                           0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_F_OFFSET_MOD8                         4
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_F_OFFSET_MOD16                        12
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_F_OFFSET                                     25
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_F_WIDTH                                      3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_OFFSET                                       0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WORD_OFFSET                                  0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_F_OFFSET_MOD8                                1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_F_OFFSET_MOD16                               9
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_F_OFFSET                                         24
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_F_WIDTH                                          1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_OFFSET                                           0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WORD_OFFSET                                      0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_F_OFFSET_MOD8                                    0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_F_OFFSET_MOD16                                   8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_F_OFFSET                                        16
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_F_WIDTH                                         8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_OFFSET                                          1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WORD_OFFSET                                     0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_F_OFFSET_MOD16                                  0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_F_OFFSET                                        0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_F_WIDTH                                         16
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_OFFSET                                          2
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WORD_OFFSET                                     0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_OFFSET                  30
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_WIDTH                   2
#define PACKET_BUFFER_RESOLUTION_ENTRY_INGRESS_QOS_MAPPING_OFFSET                                                4
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_OFFSET                    4
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WORD_OFFSET               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_OFFSET_MOD8             6
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_F_OFFSET_MOD16            14
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET               24
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_WIDTH                6
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_OFFSET                 4
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WORD_OFFSET            1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET_MOD8          0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_F_OFFSET_MOD16         8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_OFFSET                  21
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_WIDTH                   3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_OFFSET                    5
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WORD_OFFSET               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_OFFSET_MOD8             5
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_F_OFFSET_MOD16            5
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET       19
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_WIDTH        2
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_OFFSET         5
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WORD_OFFSET    1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET_MOD8  3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_F_OFFSET_MOD16 3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET               16
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_WIDTH                3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_OFFSET                 5
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WORD_OFFSET            1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET_MOD8          0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_F_OFFSET_MOD16         0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_F_OFFSET                             0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_F_WIDTH                              16
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_OFFSET                               6
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WORD_OFFSET                          1
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_F_OFFSET                                      0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_F_WIDTH                                       32
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_OFFSET                                        8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_WORD_OFFSET                                   2
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_F_OFFSET                                    24
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_F_WIDTH                                     8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_OFFSET                                      12
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WORD_OFFSET                                 3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_F_OFFSET_MOD16                              8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_F_OFFSET                                     16
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_F_WIDTH                                      8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_OFFSET                                       13
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WORD_OFFSET                                  3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_F_OFFSET_MOD16                               0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_F_OFFSET                      8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_F_WIDTH                       8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_OFFSET                        14
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WORD_OFFSET                   3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_F_OFFSET_MOD16                8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_F_OFFSET                           0
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_F_WIDTH                            8
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_OFFSET                             15
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WORD_OFFSET                        3
#define PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_F_OFFSET_MOD16                     0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_F_OFFSET             0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_F_WIDTH              32
#define PACKET_BUFFER_RESOLUTION_ENTRY_MCAST_RESOLUTION_OFFSET                                                   16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_OFFSET               16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WORD_OFFSET          4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_F_OFFSET                 24
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_F_WIDTH                  8
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_OFFSET                   20
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WORD_OFFSET              5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_F_OFFSET_MOD16           8
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_F_OFFSET                        22
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_F_WIDTH                         2
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_OFFSET                          21
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WORD_OFFSET                     5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_F_OFFSET_MOD8                   6
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_F_OFFSET_MOD16                  6
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_F_OFFSET                    16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_F_WIDTH                     6
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_OFFSET                      21
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WORD_OFFSET                 5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_F_OFFSET_MOD8               0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_F_OFFSET_MOD16              0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_F_OFFSET                   8
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_F_WIDTH                    8
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_OFFSET                     22
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WORD_OFFSET                5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_F_OFFSET_MOD16             8
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_F_OFFSET                       3
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_F_WIDTH                        5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_OFFSET                         23
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WORD_OFFSET                    5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_F_OFFSET_MOD8                  3
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_F_OFFSET_MOD16                 3
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_F_OFFSET                              0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_F_WIDTH                               3
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_OFFSET                                23
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WORD_OFFSET                           5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_F_OFFSET_MOD8                         0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_F_OFFSET_MOD16                        0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET              31
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_WIDTH               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_RULE_BASED_RESOLUTION_OFFSET                                              16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_OFFSET                16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WORD_OFFSET           4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD8         7
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD16        15
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET              28
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_WIDTH               3
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_OFFSET                16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WORD_OFFSET           4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD8         4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD16        12
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET        16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_WIDTH         12
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_OFFSET          16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WORD_OFFSET     4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET_MOD16  0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_F_OFFSET                  4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_F_WIDTH                   12
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_OFFSET                    18
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_WORD_OFFSET               4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_F_OFFSET_MOD16            4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_OFFSET         0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_WIDTH          4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_OFFSET           19
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WORD_OFFSET      4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_OFFSET_MOD8    0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_F_OFFSET_MOD16   0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_F_OFFSET     16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_F_WIDTH      16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_OFFSET       20
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WORD_OFFSET  5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_F_OFFSET                  0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_F_WIDTH                   16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_OFFSET                    22
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_WORD_OFFSET               5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET              31
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_WIDTH               1
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_BASED_RESOLUTION_OFFSET                                              16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_OFFSET                16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WORD_OFFSET           4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD8         7
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_F_OFFSET_MOD16        15
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET              28
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_WIDTH               3
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_OFFSET                16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WORD_OFFSET           4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD8         4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_F_OFFSET_MOD16        12
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET        16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_WIDTH         12
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_OFFSET          16
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WORD_OFFSET     4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_F_OFFSET_MOD16  0
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_OFFSET                    18
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_WORD_OFFSET               4
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_F_OFFSET_MOD16            8
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_OFFSET                    20
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WORD_OFFSET               5
#define PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_F_OFFSET_MOD16            8

/* >>>PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT */
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER	2
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER	4
typedef union
{
    uint32_t word_32[6];
    uint64_t dword_64[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	COMMON_RESOLUTION_STRUCT COMMON_RESOLUTION;
	union {
		MCAST_RESOLUTION_STRUCT MCAST_RESOLUTION;
		RULE_BASED_RESOLUTION_STRUCT RULE_BASED_RESOLUTION;
		FLOW_BASED_RESOLUTION_STRUCT FLOW_BASED_RESOLUTION;
	};
#else
	union {
		MCAST_RESOLUTION_STRUCT MCAST_RESOLUTION;
		RULE_BASED_RESOLUTION_STRUCT RULE_BASED_RESOLUTION;
		FLOW_BASED_RESOLUTION_STRUCT FLOW_BASED_RESOLUTION;
	};
	COMMON_RESOLUTION_STRUCT COMMON_RESOLUTION;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT;

#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_READ_G(r, g, idx)                                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_WRITE_G(v, g, idx)                                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_READ(r, p)                                                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_WRITE(v, p)                                                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ_G(r, g, idx)                                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE_G(v, g, idx)                                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ(r, p)                                               FIELD_MREAD_8((uint8_t *)(p), 1, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE(v, p)                                              FIELD_MWRITE_8((uint8_t *)(p), 1, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ_G(r, g, idx)                                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE_G(v, g, idx)                                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ(r, p)                                                   FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE(v, p)                                                  FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ_G(r, g, idx)                                           GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE_G(v, g, idx)                                          GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ(r, p)                                                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE(v, p)                                                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 3, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 3, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 13, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ(r, p)                                MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ_G(r, g, idx)                              GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE_G(v, g, idx)                             GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ(r, p)                                     MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE(v, p)                                    MWRITE_8((uint8_t *)(p) + 15, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)                    GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)                   GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                           MREAD_8((uint8_t *)(p) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                          MWRITE_8((uint8_t *)(p) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 21, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 21, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 21, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 21, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                             MREAD_8((uint8_t *)(p) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 3, 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 3, 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 23, 3, 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 23, 3, 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 23, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 23, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)           GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                  FIELD_MREAD_16((uint8_t *)(p) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                 FIELD_MWRITE_16((uint8_t *)(p) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, 4, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, 4, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 18, 4, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 18, 4, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 19, 0, 4, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 19, 0, 4, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 4, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 4, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_G(r, g, idx)        GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_G(v, g, idx)       GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ(r, p)               MREAD_16((uint8_t *)(p) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE(v, p)              MWRITE_16((uint8_t *)(p) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ_G(r, g, idx)                                                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE_G(v, g, idx)                                               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ(r, p)                                                       FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE(v, p)                                                      FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ_G(r, g, idx)                                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE_G(v, g, idx)                                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ(r, p)                                                        FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE(v, p)                                                       FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ_G(r, g, idx)                                                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE_G(v, g, idx)                                                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ(r, p)                                                                FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE(v, p)                                                               FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ_G(r, g, idx)                                                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE_G(v, g, idx)                                                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ(r, p)                                                              FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE(v, p)                                                             FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_READ_G(r, g, idx)                                                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_WRITE_G(v, g, idx)                                                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_READ(r, p)                                                                  FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_WRITE(v, p)                                                                 FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ_G(r, g, idx)                                                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE_G(v, g, idx)                                                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ(r, p)                                                                FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE(v, p)                                                               FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ_G(r, g, idx)                                                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE_G(v, g, idx)                                                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ(r, p)                                                                  FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE(v, p)                                                                 FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ_G(r, g, idx)                                                                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE_G(v, g, idx)                                                                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ(r, p)                                                                         FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE(v, p)                                                                        FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_READ_G(r, g, idx)                                                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_WRITE_G(v, g, idx)                                                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_READ(r, p)                                                            FIELD_MREAD_8((uint8_t *)(p) + 5, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_WRITE(v, p)                                                           FIELD_MWRITE_8((uint8_t *)(p) + 5, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_READ_G(r, g, idx)                                                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_WRITE_G(v, g, idx)                                                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_READ(r, p)                                                                FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_WRITE(v, p)                                                               FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_READ_G(r, g, idx)                                                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_WRITE_G(v, g, idx)                                                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_READ(r, p)                                                              FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_WRITE(v, p)                                                             FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_READ_G(r, g, idx)                                                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_WRITE_G(v, g, idx)                                                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_READ(r, p)                                                                 FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_WRITE(v, p)                                                                FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_READ(r, p)                            MREAD_16((uint8_t *)(p) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_WRITE(v, p)                           MWRITE_16((uint8_t *)(p) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)           GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                  FIELD_MREAD_16((uint8_t *)(p) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                 FIELD_MWRITE_16((uint8_t *)(p) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_READ_G(r, g, idx, i)                  GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_WRITE_G(v, g, idx, i)                 GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_READ(r, p, i)                         MREAD_I_8((uint8_t *)(p) + 18, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_WRITE(v, p, i)                        MWRITE_I_8((uint8_t *)(p) + 18, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ_G(r, g, idx, i)                  GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE_G(v, g, idx, i)                 GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ(r, p, i)                         MREAD_I_8((uint8_t *)(p) + 20, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE(v, p, i)                        MWRITE_I_8((uint8_t *)(p) + 20, i, (v))
/* <<<PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT */

/* <<<RDD_PACKET_BUFFER_RESOLUTION_ENTRY */


/* >>>RDD_FLOW_BASED_CONTEXT */
#define FLOW_BASED_CONTEXT_FLOW_BASED_CONTEXT_OFFSET                                                 0
#define FLOW_BASED_CONTEXT_FLOW_CACHE_OFFSET                                                         0
#define FLOW_BASED_CONTEXT_FLOW_CACHE_WORD_OFFSET                                                    0
#define FLOW_BASED_CONTEXT_FLOW_CACHE_F_OFFSET_MOD16                                                 0
#define FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_OFFSET                                                112
#define FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WORD_OFFSET                                           28
#define FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_F_OFFSET_MOD16                                        8

/* >>>FLOW_BASED_CONTEXT_STRUCT */
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER	64
#define RDD_FLOW_BASED_CONTEXT_RESERVED_NUMBER	48
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER	16
typedef union
{
    uint32_t word_32[32];
    uint64_t dword_64[16];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	flow_cache[RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER];
        uint8_t	reserved[RDD_FLOW_BASED_CONTEXT_RESERVED_NUMBER];
        uint8_t	tcam_ip_flow_result[RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER];
#else
        uint8_t	flow_cache[RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER];
        uint8_t	reserved[RDD_FLOW_BASED_CONTEXT_RESERVED_NUMBER];
        uint8_t	tcam_ip_flow_result[RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FLOW_BASED_CONTEXT_STRUCT;

#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_G(r, g, idx, i)                GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (r))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_G(v, g, idx, i)               GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (v))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ(r, p, i)                       MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE(v, p, i)                      MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (r))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (v))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 112, i, (r))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 112, i, (v))
/* <<<FLOW_BASED_CONTEXT_STRUCT */

/* <<<RDD_FLOW_BASED_CONTEXT */


/* >>>RDD_MC_FLOW_CONTEXT */
#define MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_OFFSET                                                    0
#define MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WORD_OFFSET                                               0
#define MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_F_OFFSET_MOD16                                            0

/* >>>MC_FLOW_CONTEXT_STRUCT */
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER	128
typedef union
{
    uint32_t word_32[32];
    uint64_t dword_64[16];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	mc_flow_context[RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER];
#else
        uint8_t	mc_flow_context[RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) MC_FLOW_CONTEXT_STRUCT;

#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_G(r, g, idx, i)  GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_G(v, g, idx, i) GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ(r, p, i)         MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE(v, p, i)        MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ_G(r, g, idx, i)           GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE_G(v, g, idx, i)          GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ(r, p, i)                  MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE(v, p, i)                 MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_MASTER_READ_G(r, g, idx, i)           GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (r))
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE_G(v, g, idx, i)          GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (v))
#define RDD_MC_FLOW_CONTEXT_MASTER_READ(r, p, i)                  MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE(v, p, i)                 MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<MC_FLOW_CONTEXT_STRUCT */

/* <<<RDD_MC_FLOW_CONTEXT */


/* >>>RDD_RULE_BASED_CONTEXT */
#define RULE_BASED_CONTEXT_RULE_BASED_CONTEXT_OFFSET                                                 0
#define RULE_BASED_CONTEXT_TCAM_RESULT_OFFSET                                                        0
#define RULE_BASED_CONTEXT_TCAM_RESULT_WORD_OFFSET                                                   0
#define RULE_BASED_CONTEXT_TCAM_RESULT_F_OFFSET_MOD16                                                0
#define RULE_BASED_CONTEXT_TCAM_ACL_RESULT_OFFSET                                                    16
#define RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WORD_OFFSET                                               4
#define RULE_BASED_CONTEXT_TCAM_ACL_RESULT_F_OFFSET_MOD16                                            8
#define RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_OFFSET                                                 32
#define RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WORD_OFFSET                                            8
#define RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_F_OFFSET_MOD16                                         8
#define RULE_BASED_CONTEXT_NATC_CONTEXT_OFFSET                                                       40
#define RULE_BASED_CONTEXT_NATC_CONTEXT_WORD_OFFSET                                                  10
#define RULE_BASED_CONTEXT_NATC_CONTEXT_F_OFFSET_MOD16                                               8
#define RULE_BASED_CONTEXT_TCAM_QOS_RESULT_OFFSET                                                    104
#define RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WORD_OFFSET                                               26
#define RULE_BASED_CONTEXT_TCAM_QOS_RESULT_F_OFFSET_MOD16                                            8

/* >>>RULE_BASED_CONTEXT_STRUCT */
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_NUMBER	4
#define RDD_RULE_BASED_CONTEXT_RESERVED0_NUMBER	4
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER	64
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_RESERVED1_NUMBER	8
typedef union
{
    uint32_t word_32[32];
    uint64_t dword_64[16];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	tcam_result[RDD_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER];
        uint8_t	tcam_acl_result[RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_NUMBER];
        uint8_t	bridge_port_vector[RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_NUMBER];
        uint8_t	reserved0[RDD_RULE_BASED_CONTEXT_RESERVED0_NUMBER];
        uint8_t	natc_context[RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER];
        uint8_t	tcam_qos_result[RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER];
        uint8_t	reserved1[RDD_RULE_BASED_CONTEXT_RESERVED1_NUMBER];
#else
        uint8_t	tcam_result[RDD_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER];
        uint8_t	tcam_acl_result[RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_NUMBER];
        uint8_t	bridge_port_vector[RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_NUMBER];
        uint8_t	reserved0[RDD_RULE_BASED_CONTEXT_RESERVED0_NUMBER];
        uint8_t	natc_context[RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER];
        uint8_t	tcam_qos_result[RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER];
        uint8_t	reserved1[RDD_RULE_BASED_CONTEXT_RESERVED1_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) RULE_BASED_CONTEXT_STRUCT;

#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ_G(r, g, idx, i)              GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_G(v, g, idx, i)             GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ(r, p, i)                     MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE(v, p, i)                    MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ_G(r, g, idx, i)          GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE_G(v, g, idx, i)         GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ(r, p, i)                 MREAD_I_8((uint8_t *)(p) + 16, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE(v, p, i)                MWRITE_I_8((uint8_t *)(p) + 16, i, (v))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 32, i, (r))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 32, i, (v))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 32, i, (r))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 32, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_G(r, g, idx, i)             GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_G(v, g, idx, i)            GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ(r, p, i)                    MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE(v, p, i)                   MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_G(r, g, idx, i)          GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_G(v, g, idx, i)         GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ(r, p, i)                 MREAD_I_8((uint8_t *)(p) + 104, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE(v, p, i)                MWRITE_I_8((uint8_t *)(p) + 104, i, (v))
/* <<<RULE_BASED_CONTEXT_STRUCT */

/* <<<RDD_RULE_BASED_CONTEXT */


/* >>>RDD_RULE_BASED_NATC_CONTEXT */
#define RULE_BASED_NATC_CONTEXT_NATC_CONTROL_F_OFFSET                                                     0
#define RULE_BASED_NATC_CONTEXT_NATC_CONTROL_F_WIDTH                                                      32
#define RULE_BASED_NATC_CONTEXT_RULE_BASED_NATC_CONTEXT_OFFSET                                            0
#define RULE_BASED_NATC_CONTEXT_NATC_CONTROL_OFFSET                                                       0
#define RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WORD_OFFSET                                                  0
#define RULE_BASED_NATC_CONTEXT_CMD_LIST_OFFSET                                                           12
#define RULE_BASED_NATC_CONTEXT_CMD_LIST_WORD_OFFSET                                                      3
#define RULE_BASED_NATC_CONTEXT_CMD_LIST_F_OFFSET_MOD16                                                   8

/* >>>RULE_BASED_NATC_CONTEXT_STRUCT */
#define RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER	8
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER	52
#define RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER	64
typedef union
{
    uint32_t word_32[32];
    uint64_t dword_64[16];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	natc_control                                               	;
        uint8_t	reserved0[RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER];
        uint8_t	cmd_list[RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER];
        uint8_t	reserved1[RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER];
#else
        uint32_t	natc_control                                               	;
        uint8_t	reserved0[RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER];
        uint8_t	cmd_list[RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER];
        uint8_t	reserved1[RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) RULE_BASED_NATC_CONTEXT_STRUCT;

#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (r))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (v))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_G(r, g, idx, i)           GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (r))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_G(v, g, idx, i)          GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (v))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ(r, p, i)                  MREAD_I_8((uint8_t *)(p) + 12, i, (r))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE(v, p, i)                 MWRITE_I_8((uint8_t *)(p) + 12, i, (v))
/* <<<RULE_BASED_NATC_CONTEXT_STRUCT */

/* <<<RDD_RULE_BASED_NATC_CONTEXT */


/* >>>RDD_IPTV_CONTEXT */
#define IPTV_CONTEXT_IPTV_CONTEXT_OFFSET                                                       0
#define IPTV_CONTEXT_IPTV_CONTEXT_WORD_OFFSET                                                  0

/* >>>IPTV_CONTEXT_STRUCT */
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER	32
typedef union
{
    uint32_t word_32[32];
    uint64_t dword_64[16];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	iptv_context[RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER];
#else
        uint32_t	iptv_context[RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_CONTEXT_STRUCT;

#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ_G(r, g, idx, i)          GROUP_MREAD_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_G(v, g, idx, i)         GROUP_MWRITE_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ(r, p, i)                 MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE(v, p, i)                MWRITE_I_32((uint8_t *)(p), i, (v))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ_G(r, g, idx, i)          GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE_G(v, g, idx, i)         GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ(r, p, i)                 MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE(v, p, i)                MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (r))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (v))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ_G(r, g, idx, i)              GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE_G(v, g, idx, i)             GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ(r, p, i)                     MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE(v, p, i)                    MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<IPTV_CONTEXT_STRUCT */

/* <<<RDD_IPTV_CONTEXT */


/* >>>RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY */
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_OFFSET                                                 0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_OFFSET                                      0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_WORD_OFFSET                                 0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_F_OFFSET_MOD16                              0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_OFFSET                                        64
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_WORD_OFFSET                                   16
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_F_OFFSET_MOD16                                8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_OFFSET                             112
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WORD_OFFSET                        28
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_F_OFFSET_MOD16                     8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_OFFSET                                                 0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_OFFSET                                     0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_WORD_OFFSET                                0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_F_OFFSET_MOD16                             0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_OFFSET                                 16
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WORD_OFFSET                            4
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_F_OFFSET_MOD16                         8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_OFFSET                              32
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WORD_OFFSET                         8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_F_OFFSET_MOD16                      8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_OFFSET                                       36
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_WORD_OFFSET                                  9
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_F_OFFSET_MOD16                               8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_OFFSET                                    40
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_WORD_OFFSET                               10
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_F_OFFSET_MOD16                            8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_OFFSET                                 104
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WORD_OFFSET                            26
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_F_OFFSET_MOD16                         8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_OFFSET                                       120
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_WORD_OFFSET                                  30
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_F_OFFSET_MOD16                               8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_F_OFFSET                             0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_F_WIDTH                              32
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_OFFSET                                            0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_OFFSET                               0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WORD_OFFSET                          0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_OFFSET                                  4
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_WORD_OFFSET                             1
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_F_OFFSET_MOD16                          8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_OFFSET                                   12
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_WORD_OFFSET                              3
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_F_OFFSET_MOD16                           8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_OFFSET                                  64
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_WORD_OFFSET                             16
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_F_OFFSET_MOD16                          8
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_OFFSET                                          0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_WORD_OFFSET                                     0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_OFFSET                                    0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WORD_OFFSET                               0
#define CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_F_OFFSET_MOD16                            0

/* >>>CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT */
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER	64
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_NUMBER	48
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_NUMBER	4
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_NUMBER	4
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER	64
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_NUMBER	8
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER	8
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER	52
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER	64
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER	32
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER	128
typedef union
{
    uint32_t word_32[32];
    uint64_t dword_64[16];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	union {
		FLOW_BASED_CONTEXT_STRUCT FLOW_BASED_CONTEXT;
		RULE_BASED_CONTEXT_STRUCT RULE_BASED_CONTEXT;
		RULE_BASED_NATC_CONTEXT_STRUCT RULE_BASED_NATC_CONTEXT;
		IPTV_CONTEXT_STRUCT IPTV_CONTEXT;
		MC_FLOW_CONTEXT_STRUCT MC_FLOW_CONTEXT;
	};
#else
	union {
		FLOW_BASED_CONTEXT_STRUCT FLOW_BASED_CONTEXT;
		RULE_BASED_CONTEXT_STRUCT RULE_BASED_CONTEXT;
		RULE_BASED_NATC_CONTEXT_STRUCT RULE_BASED_NATC_CONTEXT;
		IPTV_CONTEXT_STRUCT IPTV_CONTEXT;
		MC_FLOW_CONTEXT_STRUCT MC_FLOW_CONTEXT;
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT;

#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_G(r, g, idx, i)                GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_G(v, g, idx, i)               GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_READ(r, p, i)                       MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE(v, p, i)                      MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_READ_G(r, g, idx, i)                  GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_WRITE_G(v, g, idx, i)                 GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_READ(r, p, i)                         MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_WRITE(v, p, i)                        MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 112, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 112, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 112, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 112, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_READ_G(r, g, idx, i)               GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_G(v, g, idx, i)              GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_READ(r, p, i)                      MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE(v, p, i)                     MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ_G(r, g, idx, i)           GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 16, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE_G(v, g, idx, i)          GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 16, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ(r, p, i)                  MREAD_I_8((uint8_t *)(p) + 16, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE(v, p, i)                 MWRITE_I_8((uint8_t *)(p) + 16, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ_G(r, g, idx, i)        GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 32, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE_G(v, g, idx, i)       GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 32, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ(r, p, i)               MREAD_I_8((uint8_t *)(p) + 32, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE(v, p, i)              MWRITE_I_8((uint8_t *)(p) + 32, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_READ_G(r, g, idx, i)                 GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 36, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_WRITE_G(v, g, idx, i)                GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 36, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_READ(r, p, i)                        MREAD_I_8((uint8_t *)(p) + 36, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_WRITE(v, p, i)                       MWRITE_I_8((uint8_t *)(p) + 36, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_G(r, g, idx, i)              GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 40, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_G(v, g, idx, i)             GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 40, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_READ(r, p, i)                     MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE(v, p, i)                    MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_G(r, g, idx, i)           GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 104, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_G(v, g, idx, i)          GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 104, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ(r, p, i)                  MREAD_I_8((uint8_t *)(p) + 104, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE(v, p, i)                 MWRITE_I_8((uint8_t *)(p) + 104, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_READ_G(r, g, idx, i)                 GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 120, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_WRITE_G(v, g, idx, i)                GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 120, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_READ(r, p, i)                        MREAD_I_8((uint8_t *)(p) + 120, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_WRITE(v, p, i)                       MWRITE_I_8((uint8_t *)(p) + 120, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ(r, p)                   MREAD_32((uint8_t *)(p), (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE(v, p)                  MWRITE_32((uint8_t *)(p), (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_READ_G(r, g, idx, i)            GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 4, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_WRITE_G(v, g, idx, i)           GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 4, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_READ(r, p, i)                   MREAD_I_8((uint8_t *)(p) + 4, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_WRITE(v, p, i)                  MWRITE_I_8((uint8_t *)(p) + 4, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_G(r, g, idx, i)             GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 12, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_G(v, g, idx, i)            GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 12, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ(r, p, i)                    MREAD_I_8((uint8_t *)(p) + 12, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE(v, p, i)                   MWRITE_I_8((uint8_t *)(p) + 12, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_READ_G(r, g, idx, i)            GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_WRITE_G(v, g, idx, i)           GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_READ(r, p, i)                   MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_WRITE(v, p, i)                  MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_READ_G(r, g, idx, i)                    GROUP_MREAD_I_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_G(v, g, idx, i)                   GROUP_MWRITE_I_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_READ(r, p, i)                           MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_WRITE(v, p, i)                          MWRITE_I_32((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_READ_G(r, g, idx, i)                              GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_WRITE_G(v, g, idx, i)                             GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_READ(r, p, i)                                     MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_WRITE(v, p, i)                                    MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_READ_G(r, g, idx, i)                                     GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_WRITE_G(v, g, idx, i)                                    GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_READ(r, p, i)                                            MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_WRITE(v, p, i)                                           MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_G(r, g, idx, i)              GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_G(v, g, idx, i)             GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ(r, p, i)                     MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE(v, p, i)                    MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_READ_G(r, g, idx, i)                                       GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_WRITE_G(v, g, idx, i)                                      GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_READ(r, p, i)                                              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_WRITE(v, p, i)                                             MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_READ_G(r, g, idx, i)                                       GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_WRITE_G(v, g, idx, i)                                      GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_READ(r, p, i)                                              MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_WRITE(v, p, i)                                             MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_READ_G(r, g, idx, i)                                   GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_WRITE_G(v, g, idx, i)                                  GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_READ(r, p, i)                                          MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_WRITE(v, p, i)                                         MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT */

/* <<<RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY */


/* >>>RDD_FLOW_CACHE_CONTEXT_ENTRY */
#define FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_F_OFFSET                                                     0
#define FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_F_WIDTH                                                      32
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_CACHE_CONTEXT_ENTRY_OFFSET                                           0
#define FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_OFFSET                                                       0
#define FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WORD_OFFSET                                                  0
#define FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_F_OFFSET                                                       26
#define FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_F_WIDTH                                                        6
#define FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_OFFSET                                                         4
#define FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_WORD_OFFSET                                                    1
#define FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_F_OFFSET_MOD8                                                  2
#define FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_F_OFFSET_MOD16                                                 10
#define FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_F_OFFSET                                                        24
#define FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_F_WIDTH                                                         2
#define FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_OFFSET                                                          4
#define FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_WORD_OFFSET                                                     1
#define FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_F_OFFSET_MOD8                                                   0
#define FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_F_OFFSET_MOD16                                                  8
#define FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_F_OFFSET                                                   0
#define FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_F_WIDTH                                                    24
#define FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_OFFSET                                                     4
#define FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_WORD_OFFSET                                                1
#define FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_F_OFFSET                                                     26
#define FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_F_WIDTH                                                      6
#define FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_OFFSET                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WORD_OFFSET                                                  2
#define FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_F_OFFSET_MOD8                                                2
#define FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_F_OFFSET_MOD16                                               10
#define FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_F_OFFSET                                                 25
#define FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_F_WIDTH                                                  1
#define FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_OFFSET                                                   8
#define FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_WORD_OFFSET                                              2
#define FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_F_OFFSET_MOD8                                            1
#define FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_F_OFFSET_MOD16                                           9
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_F_OFFSET                                               16
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_F_WIDTH                                                9
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_OFFSET                                                 8
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_WORD_OFFSET                                            2
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_F_OFFSET_MOD16                                         0
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_F_OFFSET                                                  14
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_F_WIDTH                                                   2
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_OFFSET                                                    10
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_WORD_OFFSET                                               2
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_F_OFFSET_MOD8                                             6
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_F_OFFSET_MOD16                                            14
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_F_OFFSET                                                       11
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_F_WIDTH                                                        3
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_OFFSET                                                         10
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_WORD_OFFSET                                                    2
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_F_OFFSET_MOD8                                                  3
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_F_OFFSET_MOD16                                                 11
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_F_OFFSET                                        9
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_F_WIDTH                                         2
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_OFFSET                                          10
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_WORD_OFFSET                                     2
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_F_OFFSET_MOD8                                   1
#define FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_F_OFFSET_MOD16                                  9
#define FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_F_OFFSET                                                           8
#define FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_F_WIDTH                                                            1
#define FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_OFFSET                                                             10
#define FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_WORD_OFFSET                                                        2
#define FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_F_OFFSET_MOD8                                                      0
#define FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_F_OFFSET_MOD16                                                     8
#define FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_F_OFFSET                                                       7
#define FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_F_WIDTH                                                        1
#define FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_OFFSET                                                         11
#define FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WORD_OFFSET                                                    2
#define FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_F_OFFSET_MOD8                                                  7
#define FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_F_OFFSET_MOD16                                                 7
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_F_OFFSET                                                  0
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_F_WIDTH                                                   7
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_OFFSET                                                    11
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_WORD_OFFSET                                               2
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_F_OFFSET_MOD8                                             0
#define FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_F_OFFSET_MOD16                                            0
#define FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_F_OFFSET                                                    31
#define FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_F_WIDTH                                                     1
#define FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_OFFSET                                                      12
#define FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_WORD_OFFSET                                                 3
#define FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_F_OFFSET_MOD8                                               7
#define FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_F_OFFSET_MOD16                                              15
#define FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_F_OFFSET                                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_F_WIDTH                                                      15
#define FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_OFFSET                                                       12
#define FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_WORD_OFFSET                                                  3
#define FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_F_OFFSET                                    0
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_F_WIDTH                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_OFFSET                                      14
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_WORD_OFFSET                                 3
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_F_OFFSET                                                           0
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_F_WIDTH                                                            32
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_OFFSET                                                             16
#define FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_WORD_OFFSET                                                        4
#define FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_F_OFFSET                                                     28
#define FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_F_WIDTH                                                      4
#define FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_OFFSET                                                       20
#define FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_WORD_OFFSET                                                  5
#define FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_F_OFFSET_MOD8                                                4
#define FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_F_OFFSET_MOD16                                               12
#define FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_F_OFFSET                                           23
#define FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_F_WIDTH                                            5
#define FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_OFFSET                                             20
#define FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_WORD_OFFSET                                        5
#define FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_F_OFFSET_MOD8                                      7
#define FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_F_OFFSET_MOD16                                     7
#define FLOW_CACHE_CONTEXT_ENTRY_SSID_F_OFFSET                                                             19
#define FLOW_CACHE_CONTEXT_ENTRY_SSID_F_WIDTH                                                              4
#define FLOW_CACHE_CONTEXT_ENTRY_SSID_OFFSET                                                               21
#define FLOW_CACHE_CONTEXT_ENTRY_SSID_WORD_OFFSET                                                          5
#define FLOW_CACHE_CONTEXT_ENTRY_SSID_F_OFFSET_MOD8                                                        3
#define FLOW_CACHE_CONTEXT_ENTRY_SSID_F_OFFSET_MOD16                                                       3
#define FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_F_OFFSET                                          18
#define FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_F_WIDTH                                           1
#define FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_OFFSET                                            21
#define FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_WORD_OFFSET                                       5
#define FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_F_OFFSET_MOD8                                     2
#define FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_F_OFFSET_MOD16                                    2
#define FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_F_OFFSET                                                         17
#define FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_F_WIDTH                                                          1
#define FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_OFFSET                                                           21
#define FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_WORD_OFFSET                                                      5
#define FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_F_OFFSET_MOD8                                                    1
#define FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_F_OFFSET_MOD16                                                   1
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_QUEUE_F_OFFSET                                                        16
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_QUEUE_F_WIDTH                                                         1
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_QUEUE_OFFSET                                                          21
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_QUEUE_WORD_OFFSET                                                     5
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_QUEUE_F_OFFSET_MOD8                                                   0
#define FLOW_CACHE_CONTEXT_ENTRY_CPU_QUEUE_F_OFFSET_MOD16                                                  0
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_F_OFFSET                                                 13
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_F_WIDTH                                                  3
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_OFFSET                                                   22
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_WORD_OFFSET                                              5
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_F_OFFSET_MOD8                                            5
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_F_OFFSET_MOD16                                           13
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_F_OFFSET                                                 12
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_F_WIDTH                                                  1
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_OFFSET                                                   22
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_WORD_OFFSET                                              5
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_F_OFFSET_MOD8                                            4
#define FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_F_OFFSET_MOD16                                           12
#define FLOW_CACHE_CONTEXT_ENTRY_TC_F_OFFSET                                                               9
#define FLOW_CACHE_CONTEXT_ENTRY_TC_F_WIDTH                                                                3
#define FLOW_CACHE_CONTEXT_ENTRY_TC_OFFSET                                                                 22
#define FLOW_CACHE_CONTEXT_ENTRY_TC_WORD_OFFSET                                                            5
#define FLOW_CACHE_CONTEXT_ENTRY_TC_F_OFFSET_MOD8                                                          1
#define FLOW_CACHE_CONTEXT_ENTRY_TC_F_OFFSET_MOD16                                                         9
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_F_OFFSET                                              8
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_F_WIDTH                                               1
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_OFFSET                                                22
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_WORD_OFFSET                                           5
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_F_OFFSET_MOD8                                         0
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_F_OFFSET_MOD16                                        8
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_F_OFFSET                                                 7
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_F_WIDTH                                                  1
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_OFFSET                                                   23
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_WORD_OFFSET                                              5
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_F_OFFSET_MOD8                                            7
#define FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_F_OFFSET_MOD16                                           7
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_F_OFFSET                                          5
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_F_WIDTH                                           2
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_OFFSET                                            23
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_WORD_OFFSET                                       5
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_F_OFFSET_MOD8                                     5
#define FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_F_OFFSET_MOD16                                    5
#define FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_F_OFFSET                                          3
#define FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_F_WIDTH                                           2
#define FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_OFFSET                                            23
#define FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_WORD_OFFSET                                       5
#define FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_F_OFFSET_MOD8                                     3
#define FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_F_OFFSET_MOD16                                    3
#define FLOW_CACHE_CONTEXT_ENTRY_IP_VERSION_F_OFFSET                                                       2
#define FLOW_CACHE_CONTEXT_ENTRY_IP_VERSION_F_WIDTH                                                        1
#define FLOW_CACHE_CONTEXT_ENTRY_IP_VERSION_OFFSET                                                         23
#define FLOW_CACHE_CONTEXT_ENTRY_IP_VERSION_WORD_OFFSET                                                    5
#define FLOW_CACHE_CONTEXT_ENTRY_IP_VERSION_F_OFFSET_MOD8                                                  2
#define FLOW_CACHE_CONTEXT_ENTRY_IP_VERSION_F_OFFSET_MOD16                                                 2
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_F_OFFSET                                         0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_F_WIDTH                                          2
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_OFFSET                                           23
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_WORD_OFFSET                                      5
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_F_OFFSET_MOD8                                    0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_F_OFFSET_MOD16                                   0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_F_OFFSET                                                          24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_F_WIDTH                                                           8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_OFFSET                                                            24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_WORD_OFFSET                                                       6
#define FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_F_OFFSET_MOD16                                                    8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_F_OFFSET                                                        16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_F_WIDTH                                                         8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_OFFSET                                                          25
#define FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_WORD_OFFSET                                                     6
#define FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_F_OFFSET_MOD16                                                  0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_F_OFFSET                                                        8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_F_WIDTH                                                         8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_OFFSET                                                          26
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_WORD_OFFSET                                                     6
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_F_OFFSET_MOD16                                                  8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_F_OFFSET                                                      0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_OFFSET                                                        27
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_WORD_OFFSET                                                   6
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_F_OFFSET_MOD16                                                0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_F_OFFSET                                                      24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_OFFSET                                                        28
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_WORD_OFFSET                                                   7
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_F_OFFSET_MOD16                                                8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_F_OFFSET                                                      16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_OFFSET                                                        29
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_WORD_OFFSET                                                   7
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_F_OFFSET_MOD16                                                0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_F_OFFSET                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_OFFSET                                                        30
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_WORD_OFFSET                                                   7
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_F_OFFSET_MOD16                                                8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_F_OFFSET                                                      0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_OFFSET                                                        31
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_WORD_OFFSET                                                   7
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_F_OFFSET_MOD16                                                0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_F_OFFSET                                                      24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_OFFSET                                                        32
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_WORD_OFFSET                                                   8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_F_OFFSET_MOD16                                                8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_F_OFFSET                                                      16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_OFFSET                                                        33
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_WORD_OFFSET                                                   8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_F_OFFSET_MOD16                                                0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_F_OFFSET                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_OFFSET                                                        34
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_WORD_OFFSET                                                   8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_F_OFFSET_MOD16                                                8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_F_OFFSET                                                      0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_F_WIDTH                                                       8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_OFFSET                                                        35
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_WORD_OFFSET                                                   8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_F_OFFSET_MOD16                                                0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_F_OFFSET                                                     24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_OFFSET                                                       36
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_WORD_OFFSET                                                  9
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_F_OFFSET                                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_OFFSET                                                       37
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_WORD_OFFSET                                                  9
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_F_OFFSET                                                     8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_OFFSET                                                       38
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_WORD_OFFSET                                                  9
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_F_OFFSET                                                     0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_OFFSET                                                       39
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_WORD_OFFSET                                                  9
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_F_OFFSET                                                     24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_OFFSET                                                       40
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_WORD_OFFSET                                                  10
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_F_OFFSET                                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_OFFSET                                                       41
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_WORD_OFFSET                                                  10
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_F_OFFSET                                                     8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_OFFSET                                                       42
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_WORD_OFFSET                                                  10
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_F_OFFSET                                                     0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_OFFSET                                                       43
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_WORD_OFFSET                                                  10
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_F_OFFSET                                                     24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_OFFSET                                                       44
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_WORD_OFFSET                                                  11
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_F_OFFSET                                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_OFFSET                                                       45
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_WORD_OFFSET                                                  11
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_F_OFFSET                                                     8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_OFFSET                                                       46
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_WORD_OFFSET                                                  11
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_F_OFFSET                                                     0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_OFFSET                                                       47
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_WORD_OFFSET                                                  11
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_F_OFFSET                                                     24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_OFFSET                                                       48
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_WORD_OFFSET                                                  12
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_F_OFFSET                                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_OFFSET                                                       49
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_WORD_OFFSET                                                  12
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_F_OFFSET                                                     8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_OFFSET                                                       50
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_WORD_OFFSET                                                  12
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_F_OFFSET                                                     0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_OFFSET                                                       51
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_WORD_OFFSET                                                  12
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_F_OFFSET                                                     24
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_OFFSET                                                       52
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_WORD_OFFSET                                                  13
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_F_OFFSET                                                     16
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_OFFSET                                                       53
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_WORD_OFFSET                                                  13
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_F_OFFSET                                                     8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_OFFSET                                                       54
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_WORD_OFFSET                                                  13
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_F_OFFSET_MOD16                                               8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_F_OFFSET                                                     0
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_F_WIDTH                                                      8
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_OFFSET                                                       55
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_WORD_OFFSET                                                  13
#define FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_F_OFFSET_MOD16                                               0
#define FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_F_OFFSET                                                16
#define FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_F_WIDTH                                                 16
#define FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_OFFSET                                                  56
#define FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_WORD_OFFSET                                             14
#define FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_F_OFFSET                                                0
#define FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_F_WIDTH                                                 16
#define FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_OFFSET                                                  58
#define FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_WORD_OFFSET                                             14

/* >>>FLOW_CACHE_CONTEXT_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[15];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	natc_control            	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dscp_value              	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn_value               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	actions_vector          	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pathstat_idx            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	qos_mapping_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_vport_union      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ucast_or_mcast0         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	cpu_reason              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio_or_metadata_1_1	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_wfd                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ctx_ext              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ucast_or_mcast2         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_pathstat_idx          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_qos_mapping_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_vport                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	fwd_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	trap_type                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU1_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU1_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id                        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_pathstat_idx          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_qos_mapping_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	to_lan                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	is_vport                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	tx_flow                           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	fwd_and_trap                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reserved0                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU2_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU2_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_idx                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_pathstat_idx          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_qos_mapping_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_egress_vport_union    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_trap                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reserved1                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU3_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flow_prio_or_metadata_1_1	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ucast_or_mcast2       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_tcpspdtest           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	params_union            	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint16_t	nat_port_or_spdtest_stream_id	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_metadata_0_0                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_0_1                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_1_0                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint16_t	nat_port                          	; /* Member of nat_port_or_spdtest_stream_id union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	dhd_wifi_priority                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	dhd_flow_ring_id                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	spdtest_stream_id                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	tcpspdtest_is_upload              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint8_t	queue                             	; /* Member of params_union union */
        uint16_t	reservedSU3_nat_port_or_spdtest_stream_id	;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_proxy_enabled          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	wlan_mcast_tx_prio                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved4                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint8_t	_queue                            	; /* Member of params_union union */
        uint16_t	reservedSU4_nat_port_or_spdtest_stream_id	;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	nat_ip                  	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	metadata_1_2            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_q_or_tunnel_id  	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_l2_pppoe_passthrough 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ucast                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_queue               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_vid_offset        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_vport        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility_en     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_version              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_metadata_1_2          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue                     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reservedSU1_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_cpu_queue             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ip_version            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_metadata_1_2          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tunnel_id                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reserved5                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reservedSU2_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_cpu_queue             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ip_version            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_size                 	;
        uint8_t	l2_offset               	;
        uint8_t	l2_header               	;
        uint8_t	l2_header_1             	;
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_2             	;
        uint8_t	l2_header_3             	;
        uint8_t	l2_header_4             	;
        uint8_t	l2_header_5             	;
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_6             	;
        uint8_t	l2_header_7             	;
        uint8_t	l2_header_8             	;
        uint8_t	l2_header_9             	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_10            	;
        uint8_t	l2_header_11            	;
        uint8_t	l2_header_12            	;
        uint8_t	l2_header_13            	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_14            	;
        uint8_t	l2_header_15            	;
        uint8_t	l2_header_16            	;
        uint8_t	l2_header_17            	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_18            	;
        uint8_t	l2_header_19            	;
        uint8_t	l2_header_20            	;
        uint8_t	l2_header_21            	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_22            	;
        uint8_t	l2_header_23            	;
        uint8_t	l2_header_24            	;
        uint8_t	l2_header_25            	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_26            	;
        uint8_t	l2_header_27            	;
        uint8_t	l2_header_28            	;
        uint8_t	l2_header_29            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	ip_checksum_delta       	;
        uint16_t	l4_checksum_delta       	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	natc_control            	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	actions_vector          	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn_value               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_value              	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ucast_or_mcast2         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_ctx_ext              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_wfd                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio_or_metadata_1_1	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	cpu_reason              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ucast_or_mcast0         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	egress_vport_union      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	qos_mapping_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pathstat_idx            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	policer_id                        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
        uint32_t	reservedSU1_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU1_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	trap_type                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	fwd_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	egress_vport                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	reservedSU1_qos_mapping_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pathstat_idx          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	wlan_mcast_idx                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
        uint32_t	reservedSU2_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU2_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	fwd_and_trap                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	tx_flow                           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	is_vport                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	to_lan                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	reservedSU2_qos_mapping_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pathstat_idx          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_ucast_or_mcast2       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flow_prio_or_metadata_1_1	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	is_trap                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU3_egress_vport_union    	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_qos_mapping_mode      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pathstat_idx          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	nat_port_or_spdtest_stream_id	; /* This is a field union */
        uint32_t	params_union            	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_tcpspdtest           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint16_t	nat_port                          	; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	cpu_metadata_1_0                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_0_1                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_0_0                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU1_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	tcpspdtest_is_upload              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	spdtest_stream_id                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	reserved                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	dhd_flow_ring_id                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	dhd_wifi_priority                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved2                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU2_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	reservedSU3_nat_port_or_spdtest_stream_id	;
        uint8_t	queue                             	; /* Member of params_union union */
        uint32_t	reserved3                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU3_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint16_t	reservedSU4_nat_port_or_spdtest_stream_id	;
        uint8_t	_queue                            	; /* Member of params_union union */
        uint32_t	reserved4                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	wlan_mcast_tx_prio                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	wlan_mcast_proxy_enabled          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU4_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	nat_ip                  	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_version              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility_en     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_vport        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_vid_offset        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_queue               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ucast                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_l2_pppoe_passthrough 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_q_or_tunnel_id  	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	metadata_1_2            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ip_version            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_cpu_queue             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue                     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reservedSU1_metadata_1_2          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ip_version            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_cpu_queue             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	tunnel_id                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reservedSU2_metadata_1_2          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_1             	;
        uint8_t	l2_header               	;
        uint8_t	l2_offset               	;
        uint8_t	l2_size                 	;
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_5             	;
        uint8_t	l2_header_4             	;
        uint8_t	l2_header_3             	;
        uint8_t	l2_header_2             	;
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_9             	;
        uint8_t	l2_header_8             	;
        uint8_t	l2_header_7             	;
        uint8_t	l2_header_6             	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_13            	;
        uint8_t	l2_header_12            	;
        uint8_t	l2_header_11            	;
        uint8_t	l2_header_10            	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_17            	;
        uint8_t	l2_header_16            	;
        uint8_t	l2_header_15            	;
        uint8_t	l2_header_14            	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_21            	;
        uint8_t	l2_header_20            	;
        uint8_t	l2_header_19            	;
        uint8_t	l2_header_18            	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_25            	;
        uint8_t	l2_header_24            	;
        uint8_t	l2_header_23            	;
        uint8_t	l2_header_22            	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_29            	;
        uint8_t	l2_header_28            	;
        uint8_t	l2_header_27            	;
        uint8_t	l2_header_26            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	l4_checksum_delta       	;
        uint16_t	ip_checksum_delta       	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) FLOW_CACHE_CONTEXT_ENTRY_STRUCT;

#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ(r, p)                             MREAD_32((uint8_t *)(p), (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE(v, p)                            MWRITE_32((uint8_t *)(p), (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 4, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 4, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_READ(r, p)                           FIELD_MREAD_32((uint8_t *)(p) + 4, 0, 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_WRITE(v, p)                          FIELD_MWRITE_32((uint8_t *)(p) + 4, 0, 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 8, 0, 9, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 8, 0, 9, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_READ(r, p)                             FIELD_MREAD_16((uint8_t *)(p) + 8, 0, 9, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_WRITE(v, p)                            FIELD_MWRITE_16((uint8_t *)(p) + 8, 0, 9, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_LAN_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_LAN_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_LAN_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 8,