/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/



/* This is an automated file. Do not edit its contents. */


#ifndef _RDD_DATA_STRUCTURES_AUTO_H_
#define _RDD_DATA_STRUCTURES_AUTO_H_

#define GROUPED_EN_SEGMENTS_NUM       6
#define INVALID_TABLE_ADDRESS         0xFFFFFF

#ifdef __clang__
#define ALIGNMENT(x) __attribute__((align_value((x))))
#else
#define ALIGNMENT(x)
#endif


/* DDR */

/* >>>IPTV_DDR_CONTEXT_TABLE */

/* >>>IPTV_DDR_CONTEXT_ENTRY_STRUCT */
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER	16
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER	16
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER	32
typedef union
{
    uint32_t word_32[22];
    uint64_t dword_64[11];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_ver                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_vid                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_src_ip                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vid                                                               	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	next_entry_idx                                                    	;
        uint16_t	ssid_vector_0_or_flooding_vport                                   	;
        uint16_t	ssid_vector_1                                                     	;
        uint16_t	ssid_vector_2                                                     	;
        uint32_t	radio_dhd_vector                                                  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rdd_vport                                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_proxy_enabled                                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_tx_prio                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications                                                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                                                           	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_ports_vector                                               	;
        uint32_t	src_ip                                                            	;
        uint8_t	src_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER];
        uint8_t	dst_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER];
        uint8_t	result[RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER];
#else
        uint16_t	next_entry_idx                                                    	;
        uint32_t	vid                                                               	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_src_ip                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	any_vid                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_ver                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ssid_vector_1                                                     	;
        uint16_t	ssid_vector_0_or_flooding_vport                                   	;
        uint32_t	wlan_mcast_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_proxy_enabled                                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rdd_vport                                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	radio_dhd_vector                                                  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ssid_vector_2                                                     	;
        uint32_t	cntr_id                                                           	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications                                                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_tx_prio                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_ports_vector                                               	;
        uint32_t	src_ip                                                            	;
        uint8_t	src_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_NUMBER];
        uint8_t	dst_ipv6_addr[RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_NUMBER];
        uint8_t	result[RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_DDR_CONTEXT_ENTRY_STRUCT;

#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ_G(r, g, idx)                                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE_G(v, g, idx)                                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_READ(r, p)                                           FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VALID_WRITE(v, p)                                          FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 6, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_READ(r, p)                                          FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_IP_VER_WRITE(v, p)                                         FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ_G(r, g, idx)                                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE_G(v, g, idx)                                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 5, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_READ(r, p)                                         FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_VID_WRITE(v, p)                                        FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 4, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_ANY_SRC_IP_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ_G(r, g, idx)                                      GROUP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE_G(v, g, idx)                                     GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT), 0, 12, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_READ(r, p)                                             FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_VID_WRITE(v, p)                                            FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ_G(r, g, idx)                           GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE_G(v, g, idx)                          GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_READ(r, p)                                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_NEXT_ENTRY_IDX_WRITE(v, p)                                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_READ(r, p)                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_0_OR_FLOODING_VPORT_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_1_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SSID_VECTOR_2_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 5, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 5, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 10, 5, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RADIO_DHD_VECTOR_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 10, 5, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ_G(r, g, idx)                                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE_G(v, g, idx)                               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 10, 0, 5, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_READ(r, p)                                       FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 5, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RDD_VPORT_WRITE(v, p)                                      FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 5, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 11, 7, 1, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_PROXY_ENABLED_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 11, 7, 1, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 7, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_INDEX_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 7, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 12, 4, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 12, 4, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 12, 4, 3, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_WLAN_MCAST_TX_PRIO_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 12, 4, 3, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 13, 6, 2, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_POOL_NUM_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 13, 6, 2, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 6, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_REPLICATIONS_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 6, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ_G(r, g, idx)                                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE_G(v, g, idx)                                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 14, 0, 10, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_READ(r, p)                                         FIELD_MREAD_16((uint8_t *)(p) + 14, 0, 10, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_CNTR_ID_WRITE(v, p)                                        FIELD_MWRITE_16((uint8_t *)(p) + 14, 0, 10, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_READ(r, p)                             MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_EGRESS_PORTS_VECTOR_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 20, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IP_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ_G(r, g, idx, i)                         GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE_G(v, g, idx, i)                        GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 24, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_READ(r, p, i)                                MREAD_I_8((uint8_t *)(p) + 24, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_SRC_IPV6_ADDR_WRITE(v, p, i)                               MWRITE_I_8((uint8_t *)(p) + 24, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ_G(r, g, idx, i)                         GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE_G(v, g, idx, i)                        GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 40, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_READ(r, p, i)                                MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_DST_IPV6_ADDR_WRITE(v, p, i)                               MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_CONTEXT_ENTRY_STRUCT) + 56, i, (v))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p) + 56, i, (r))
#define RDD_IPTV_DDR_CONTEXT_ENTRY_RESULT_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p) + 56, i, (v))
/* <<<IPTV_DDR_CONTEXT_ENTRY_STRUCT */


#define RDD_IPTV_DDR_CONTEXT_TABLE_SIZE     1024
typedef struct
{
	IPTV_DDR_CONTEXT_ENTRY_STRUCT	entry[ RDD_IPTV_DDR_CONTEXT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_DDR_CONTEXT_TABLE_STRUCT;

/* <<<IPTV_DDR_CONTEXT_TABLE */


/* >>>IPTV_DDR_PORT_BUFFER_TABLE */

/* >>>IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT */
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_NUMBER	56
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	header[RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_NUMBER];
        uint32_t	context_0                                               	;
        uint32_t	context_1                                               	;
#else
        uint8_t	header[RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_NUMBER];
        uint32_t	context_0                                               	;
        uint32_t	context_1                                               	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT;

#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_READ_G(r, g, idx, i)          GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT), i, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_WRITE_G(v, g, idx, i)         GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT), i, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_READ(r, p, i)                 MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_WRITE(v, p, i)                MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 56, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 56, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_READ(r, p)                 MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 60, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 60, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_READ(r, p)                 MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 60, (v))
/* <<<IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT */


#define RDD_IPTV_DDR_PORT_BUFFER_TABLE_SIZE     14
typedef struct
{
	IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT	entry[ RDD_IPTV_DDR_PORT_BUFFER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_DDR_PORT_BUFFER_TABLE_STRUCT;

/* <<<IPTV_DDR_PORT_BUFFER_TABLE */


/* >>>WLAN_MCAST_DHD_LIST_TABLE */

/* >>>WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_STRUCT */
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_NUMBER	64
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	dhd_station[RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_NUMBER];
#else
        uint8_t	dhd_station[RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_STRUCT;

#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_STRUCT), i, (r))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_STRUCT), i, (v))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_DHD_STATION_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_STRUCT */


#define RDD_WLAN_MCAST_DHD_LIST_TABLE_SIZE     64
typedef struct
{
	WLAN_MCAST_DHD_LIST_ENTRY_ARRAY_STRUCT	entry[ RDD_WLAN_MCAST_DHD_LIST_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ WLAN_MCAST_DHD_LIST_TABLE_STRUCT;

/* <<<WLAN_MCAST_DHD_LIST_TABLE */


/* >>>WLAN_MCAST_DHD_LIST_FORMAT_TABLE */

/* >>>WLAN_MCAST_DHD_LIST_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	valid     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	index     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	index     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	valid     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} WLAN_MCAST_DHD_LIST_ENTRY_STRUCT;

#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_VALID_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(WLAN_MCAST_DHD_LIST_ENTRY_STRUCT), 7, 1, (r))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_VALID_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(WLAN_MCAST_DHD_LIST_ENTRY_STRUCT), 7, 1, (v))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_VALID_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_VALID_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(WLAN_MCAST_DHD_LIST_ENTRY_STRUCT), 0, 7, (r))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(WLAN_MCAST_DHD_LIST_ENTRY_STRUCT), 0, 7, (v))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_INDEX_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 7, (r))
#define RDD_WLAN_MCAST_DHD_LIST_ENTRY_INDEX_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 7, (v))
/* <<<WLAN_MCAST_DHD_LIST_ENTRY_STRUCT */


#define RDD_WLAN_MCAST_DHD_LIST_FORMAT_TABLE_SIZE     1
typedef struct
{
	WLAN_MCAST_DHD_LIST_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ WLAN_MCAST_DHD_LIST_FORMAT_TABLE_STRUCT;

/* <<<WLAN_MCAST_DHD_LIST_FORMAT_TABLE */

/* PSRAM */
/* CORE_0 */

/* >>>RX_FLOW_TABLE */

/* >>>RX_FLOW_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	virtual_port	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	flow_dest   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	exception   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	is_lan      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	cntr_id     	;
#else
        uint8_t	cntr_id     	;
        uint16_t	is_lan      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	exception   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	flow_dest   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	virtual_port	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) RX_FLOW_ENTRY_STRUCT;

#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 3, 5, (r))
#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 3, 5, (v))
#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 3, 5, (r))
#define RDD_RX_FLOW_ENTRY_VIRTUAL_PORT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 3, 5, (v))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 2, 1, (r))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 2, 1, (v))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_RX_FLOW_ENTRY_FLOW_DEST_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 1, 1, (r))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 1, 1, (v))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_RX_FLOW_ENTRY_EXCEPTION_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_RX_FLOW_ENTRY_IS_LAN_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 0, 1, (r))
#define RDD_RX_FLOW_ENTRY_IS_LAN_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT), 0, 1, (v))
#define RDD_RX_FLOW_ENTRY_IS_LAN_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_RX_FLOW_ENTRY_IS_LAN_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT) + 1, (r))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(RX_FLOW_ENTRY_STRUCT) + 1, (v))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_READ(r, p)                      MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_RX_FLOW_ENTRY_CNTR_ID_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<RX_FLOW_ENTRY_STRUCT */


#define RDD_RX_FLOW_TABLE_SIZE     340
typedef struct
{
	RX_FLOW_ENTRY_STRUCT	entry[ RDD_RX_FLOW_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_FLOW_TABLE_STRUCT;

extern uint32_t RDD_RX_FLOW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_FLOW_TABLE_PTR(core_id)	( RX_FLOW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_FLOW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<RX_FLOW_TABLE */


/* >>>GENERAL_QUEUE_DYNAMIC_MNG_TABLE */

/* >>>QUEUE_DYNAMIC_MNG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	qm_queue_us_start  	;
        uint8_t	qm_queue_us_end    	;
        uint8_t	qm_queue_ds_start  	;
        uint8_t	qm_queue_ds_end    	;
        uint8_t	qm_queue_epon_start	;
        uint8_t	qm_queue_sq_start  	;
        uint16_t	reserved           	;
#else
        uint8_t	qm_queue_ds_end    	;
        uint8_t	qm_queue_ds_start  	;
        uint8_t	qm_queue_us_end    	;
        uint8_t	qm_queue_us_start  	;
        uint16_t	reserved           	;
        uint8_t	qm_queue_sq_start  	;
        uint8_t	qm_queue_epon_start	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) QUEUE_DYNAMIC_MNG_ENTRY_STRUCT;

#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT), (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT), (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_READ(r, p)                   MREAD_8((uint8_t *)(p), (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_START_WRITE(v, p)                  MWRITE_8((uint8_t *)(p), (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 1, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 1, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_READ(r, p)                     MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_US_END_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 2, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 2, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_READ(r, p)                   MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_START_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 3, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 3, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_READ(r, p)                     MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_DS_END_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 4, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 4, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_READ(r, p)                 MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_EPON_START_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 5, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(QUEUE_DYNAMIC_MNG_ENTRY_STRUCT) + 5, (v))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_READ(r, p)                   MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_QUEUE_DYNAMIC_MNG_ENTRY_QM_QUEUE_SQ_START_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 5, (v))
/* <<<QUEUE_DYNAMIC_MNG_ENTRY_STRUCT */


#define RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_SIZE     1
typedef struct
{
	QUEUE_DYNAMIC_MNG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GENERAL_QUEUE_DYNAMIC_MNG_TABLE_STRUCT;

extern uint32_t RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_PTR(core_id)	( GENERAL_QUEUE_DYNAMIC_MNG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GENERAL_QUEUE_DYNAMIC_MNG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<GENERAL_QUEUE_DYNAMIC_MNG_TABLE */


/* >>>SPDTEST_GEN_PARAM */

/* >>>SPDTEST_GEN_CFG_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved          	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) SPDTEST_GEN_CFG_STRUCT;

#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
/* <<<SPDTEST_GEN_CFG_STRUCT */


#define RDD_SPDTEST_GEN_PARAM_SIZE     4
typedef struct
{
	SPDTEST_GEN_CFG_STRUCT	entry[ RDD_SPDTEST_GEN_PARAM_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDTEST_GEN_PARAM_STRUCT;

extern uint32_t RDD_SPDTEST_GEN_PARAM_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDTEST_GEN_PARAM_PTR(core_id)	( SPDTEST_GEN_PARAM_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDTEST_GEN_PARAM_ADDRESS_ARR[core_id] ))

/* <<<SPDTEST_GEN_PARAM */


/* >>>VPORT_CFG_TABLE */

/* >>>VPORT_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	loopback_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	natc_tbl_id                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	emac_idx                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_dbg_stat_en            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	congestion_flow_control     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_rate_limit          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dos_attack_detection_disable	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved0                   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dos_attack_detection_disable	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_rate_limit          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	congestion_flow_control     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_dbg_stat_en            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	emac_idx                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	natc_tbl_id                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) VPORT_CFG_ENTRY_STRUCT;

#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 6, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 6, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (r))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (v))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 3, (r))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 3, (v))
#define RDD_VPORT_CFG_ENTRY_EMAC_IDX_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 2, 3, (r))
#define RDD_VPORT_CFG_ENTRY_EMAC_IDX_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 2, 3, (v))
#define RDD_VPORT_CFG_ENTRY_EMAC_IDX_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 3, (r))
#define RDD_VPORT_CFG_ENTRY_EMAC_IDX_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 3, (v))
#define RDD_VPORT_CFG_ENTRY_VIQ_READ_G(r, g, idx)                                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 0, 15, 3, (r))
#define RDD_VPORT_CFG_ENTRY_VIQ_WRITE_G(v, g, idx)                                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 0, 15, 3, (v))
#define RDD_VPORT_CFG_ENTRY_VIQ_READ(r, p)                                          FIELD_MREAD_32((uint8_t *)(p) + 0, 15, 3, (r))
#define RDD_VPORT_CFG_ENTRY_VIQ_WRITE(v, p)                                         FIELD_MWRITE_32((uint8_t *)(p) + 0, 15, 3, (v))
#define RDD_VPORT_CFG_ENTRY_PORT_DBG_STAT_EN_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_PORT_DBG_STAT_EN_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_PORT_DBG_STAT_EN_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_PORT_DBG_STAT_EN_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_RATE_LIMIT_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_RATE_LIMIT_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_RATE_LIMIT_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_RATE_LIMIT_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DOS_ATTACK_DETECTION_DISABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DOS_ATTACK_DETECTION_DISABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DOS_ATTACK_DETECTION_DISABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DOS_ATTACK_DETECTION_DISABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 1, (v))
/* <<<VPORT_CFG_ENTRY_STRUCT */


#define RDD_VPORT_CFG_TABLE_SIZE     16
typedef struct
{
	VPORT_CFG_ENTRY_STRUCT	entry[ RDD_VPORT_CFG_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_CFG_TABLE_STRUCT;

extern uint32_t RDD_VPORT_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_CFG_TABLE_PTR(core_id)	( VPORT_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VPORT_CFG_TABLE */


/* >>>SPDSVC_ANALYZER_STACK */

/* >>>BYTE_1_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	bits      	;
#else
        uint8_t	bits      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} BYTE_1_STRUCT;

#define RDD_BYTE_1_BITS_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(BYTE_1_STRUCT), (r))
#define RDD_BYTE_1_BITS_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(BYTE_1_STRUCT), (v))
#define RDD_BYTE_1_BITS_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_BYTE_1_BITS_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<BYTE_1_STRUCT */


#define RDD_SPDSVC_ANALYZER_STACK_SIZE     256
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_SPDSVC_ANALYZER_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_ANALYZER_STACK_STRUCT;

extern uint32_t RDD_SPDSVC_ANALYZER_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_ANALYZER_STACK_PTR(core_id)	( SPDSVC_ANALYZER_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_ANALYZER_STACK_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_ANALYZER_STACK */


/* >>>RUNNER_PROFILING_TRACE_BUFFER */

/* >>>TRACE_EVENT_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	timestamp              	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	event_id               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	trace_event_info       	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	incoming_task_num                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reserved                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	task_pc                          	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	incoming_bbhrx_src_addr          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_rd                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr_reply                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	ramrd                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	parser                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhtx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_async                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_sync                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	cpu                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw_self                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	timer                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	acc_type                         	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	trace_event_info       	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	event_id               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	timestamp              	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	task_pc                          	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reserved                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	incoming_task_num                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reservedSU1_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	timer                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	fw_self                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	cpu                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_sync                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhrx_async                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	bbhtx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	parser                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	ramrd                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr_reply                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_rd                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	dma_wr                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	incoming_bbhrx_src_addr          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reservedSU2_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	acc_type                         	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reserved2                        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of trace_event_info union */
        uint32_t	reservedSU3_event_id             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_timestamp            	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) TRACE_EVENT_STRUCT;

#define RDD_TRACE_EVENT_TIMESTAMP_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT), 4, 12, (r))
#define RDD_TRACE_EVENT_TIMESTAMP_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT), 4, 12, (v))
#define RDD_TRACE_EVENT_TIMESTAMP_READ(r, p)                               FIELD_MREAD_16((uint8_t *)(p), 4, 12, (r))
#define RDD_TRACE_EVENT_TIMESTAMP_WRITE(v, p)                              FIELD_MWRITE_16((uint8_t *)(p), 4, 12, (v))
#define RDD_TRACE_EVENT_EVENT_ID_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 1, 2, 2, (r))
#define RDD_TRACE_EVENT_EVENT_ID_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 1, 2, 2, (v))
#define RDD_TRACE_EVENT_EVENT_ID_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 2, (r))
#define RDD_TRACE_EVENT_EVENT_ID_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 2, (v))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 0, 18, (r))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 0, 18, (v))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_READ(r, p)                        FIELD_MREAD_32((uint8_t *)(p) + 0, 0, 18, (r))
#define RDD_TRACE_EVENT_TRACE_EVENT_INFO_WRITE(v, p)                       FIELD_MWRITE_32((uint8_t *)(p) + 0, 0, 18, (v))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 14, 4, (r))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 14, 4, (v))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 0, 14, 4, (r))
#define RDD_TRACE_EVENT_INCOMING_TASK_NUM_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 0, 14, 4, (v))
#define RDD_TRACE_EVENT_TASK_PC_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 13, (r))
#define RDD_TRACE_EVENT_TASK_PC_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 13, (v))
#define RDD_TRACE_EVENT_TASK_PC_READ(r, p)                                 FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 13, (r))
#define RDD_TRACE_EVENT_TASK_PC_WRITE(v, p)                                FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 13, (v))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 12, 6, (r))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 0, 12, 6, (v))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p) + 0, 12, 6, (r))
#define RDD_TRACE_EVENT_INCOMING_BBHRX_SRC_ADDR_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p) + 0, 12, 6, (v))
#define RDD_TRACE_EVENT_DMA_WR_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 3, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 3, 1, (v))
#define RDD_TRACE_EVENT_DMA_WR_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 1, (v))
#define RDD_TRACE_EVENT_DMA_RD_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 2, 1, (r))
#define RDD_TRACE_EVENT_DMA_RD_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 2, 1, (v))
#define RDD_TRACE_EVENT_DMA_RD_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 1, (r))
#define RDD_TRACE_EVENT_DMA_RD_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 1, (v))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 1, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 1, 1, (v))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 1, (r))
#define RDD_TRACE_EVENT_DMA_WR_REPLY_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 1, (v))
#define RDD_TRACE_EVENT_RAMRD_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 1, (r))
#define RDD_TRACE_EVENT_RAMRD_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 1, (v))
#define RDD_TRACE_EVENT_RAMRD_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_TRACE_EVENT_RAMRD_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_TRACE_EVENT_PARSER_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 7, 1, (r))
#define RDD_TRACE_EVENT_PARSER_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 7, 1, (v))
#define RDD_TRACE_EVENT_PARSER_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r))
#define RDD_TRACE_EVENT_PARSER_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v))
#define RDD_TRACE_EVENT_BBHTX_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 6, 1, (r))
#define RDD_TRACE_EVENT_BBHTX_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 6, 1, (v))
#define RDD_TRACE_EVENT_BBHTX_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_TRACE_EVENT_BBHTX_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 5, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 5, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_ASYNC_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_SYNC_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 4, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_SYNC_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 4, 1, (v))
#define RDD_TRACE_EVENT_BBHRX_SYNC_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 3, 4, 1, (r))
#define RDD_TRACE_EVENT_BBHRX_SYNC_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 3, 4, 1, (v))
#define RDD_TRACE_EVENT_CPU_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 3, 1, (r))
#define RDD_TRACE_EVENT_CPU_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 3, 1, (v))
#define RDD_TRACE_EVENT_CPU_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 3, 3, 1, (r))
#define RDD_TRACE_EVENT_CPU_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 3, 3, 1, (v))
#define RDD_TRACE_EVENT_FW_SELF_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 2, 1, (r))
#define RDD_TRACE_EVENT_FW_SELF_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 2, 1, (v))
#define RDD_TRACE_EVENT_FW_SELF_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 1, (r))
#define RDD_TRACE_EVENT_FW_SELF_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 1, (v))
#define RDD_TRACE_EVENT_FW_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 1, 1, (r))
#define RDD_TRACE_EVENT_FW_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 1, 1, (v))
#define RDD_TRACE_EVENT_FW_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_TRACE_EVENT_FW_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
#define RDD_TRACE_EVENT_TIMER_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 0, 1, (r))
#define RDD_TRACE_EVENT_TIMER_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 3, 0, 1, (v))
#define RDD_TRACE_EVENT_TIMER_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 1, (r))
#define RDD_TRACE_EVENT_TIMER_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 1, (v))
#define RDD_TRACE_EVENT_ACC_TYPE_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 12, (r))
#define RDD_TRACE_EVENT_ACC_TYPE_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(TRACE_EVENT_STRUCT) + 2, 0, 12, (v))
#define RDD_TRACE_EVENT_ACC_TYPE_READ(r, p)                                FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 12, (r))
#define RDD_TRACE_EVENT_ACC_TYPE_WRITE(v, p)                               FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 12, (v))
/* <<<TRACE_EVENT_STRUCT */


#define RDD_RUNNER_PROFILING_TRACE_BUFFER_SIZE     128
typedef struct
{
	TRACE_EVENT_STRUCT	entry[ RDD_RUNNER_PROFILING_TRACE_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RUNNER_PROFILING_TRACE_BUFFER_STRUCT;

extern uint32_t RDD_RUNNER_PROFILING_TRACE_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RUNNER_PROFILING_TRACE_BUFFER_PTR(core_id)	( RUNNER_PROFILING_TRACE_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RUNNER_PROFILING_TRACE_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<RUNNER_PROFILING_TRACE_BUFFER */


/* >>>DHD_COMPLETE_COMMON_RADIO_DATA */

/* >>>DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT */
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RESERVED1_NUMBER	3
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_NUMBER	3
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RESERVED2_NUMBER	4
typedef union
{
    uint32_t word_32[30];
    uint64_t dword_64[15];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_complete_fr_base_ptr_low                                         	;
        uint32_t	rx_complete_fr_base_ptr_high                                        	;
        uint32_t	rx_complete_fr_rd_idx_ptr_low                                       	;
        uint32_t	rx_complete_fr_rd_idx_ptr_high                                      	;
        uint32_t	rx_complete_fr_wr_idx_ptr_low                                       	;
        uint32_t	rx_complete_fr_wr_idx_ptr_high                                      	;
        uint32_t	tx_complete_fr_base_ptr_low                                         	;
        uint32_t	tx_complete_fr_base_ptr_high                                        	;
        uint32_t	tx_complete_fr_rd_idx_ptr_low                                       	;
        uint32_t	tx_complete_fr_rd_idx_ptr_high                                      	;
        uint32_t	tx_complete_fr_wr_idx_ptr_low                                       	;
        uint32_t	tx_complete_fr_wr_idx_ptr_high                                      	;
        uint32_t	rx_post_fr_base_ptr_low                                             	;
        uint32_t	rx_post_fr_base_ptr_high                                            	;
        uint32_t	rx_post_fr_rd_idx_ptr_low                                           	;
        uint32_t	rx_post_fr_rd_idx_ptr_high                                          	;
        uint32_t	rx_post_fr_wr_idx_ptr_low                                           	;
        uint32_t	rx_post_fr_wr_idx_ptr_high                                          	;
        uint32_t	dhd_doorbell_low                                                    	;
        uint32_t	dhd_doorbell_high                                                   	;
        uint16_t	rx_complete_rd_idx                                                  	;
        uint16_t	rx_complete_wr_idx                                                  	;
        uint16_t	rx_complete_wr_idx_rsrv                                             	;
        uint16_t	tx_complete_rd_idx                                                  	;
        uint16_t	tx_complete_wr_idx                                                  	;
        uint16_t	tx_complete_wr_idx_rsrv                                             	;
        uint16_t	rx_post_wr_idx                                                      	;
        uint16_t	rx_post_wr_idx_rsrv                                                 	;
        uint32_t	flow_ring_format                                                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	idma_active                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                                                            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	idma_group_shift                                                    	;
        uint16_t	idma_last_group_fr                                                  	;
        uint8_t	fr_ptrs_size_shift                                                  	;
        uint8_t	reserved1[RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RESERVED1_NUMBER];
        uint32_t	scratchpad[RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_NUMBER];
        uint8_t	reserved2[RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RESERVED2_NUMBER];
#else
        uint32_t	rx_complete_fr_base_ptr_low                                         	;
        uint32_t	rx_complete_fr_base_ptr_high                                        	;
        uint32_t	rx_complete_fr_rd_idx_ptr_low                                       	;
        uint32_t	rx_complete_fr_rd_idx_ptr_high                                      	;
        uint32_t	rx_complete_fr_wr_idx_ptr_low                                       	;
        uint32_t	rx_complete_fr_wr_idx_ptr_high                                      	;
        uint32_t	tx_complete_fr_base_ptr_low                                         	;
        uint32_t	tx_complete_fr_base_ptr_high                                        	;
        uint32_t	tx_complete_fr_rd_idx_ptr_low                                       	;
        uint32_t	tx_complete_fr_rd_idx_ptr_high                                      	;
        uint32_t	tx_complete_fr_wr_idx_ptr_low                                       	;
        uint32_t	tx_complete_fr_wr_idx_ptr_high                                      	;
        uint32_t	rx_post_fr_base_ptr_low                                             	;
        uint32_t	rx_post_fr_base_ptr_high                                            	;
        uint32_t	rx_post_fr_rd_idx_ptr_low                                           	;
        uint32_t	rx_post_fr_rd_idx_ptr_high                                          	;
        uint32_t	rx_post_fr_wr_idx_ptr_low                                           	;
        uint32_t	rx_post_fr_wr_idx_ptr_high                                          	;
        uint32_t	dhd_doorbell_low                                                    	;
        uint32_t	dhd_doorbell_high                                                   	;
        uint16_t	rx_complete_wr_idx                                                  	;
        uint16_t	rx_complete_rd_idx                                                  	;
        uint16_t	tx_complete_rd_idx                                                  	;
        uint16_t	rx_complete_wr_idx_rsrv                                             	;
        uint16_t	tx_complete_wr_idx_rsrv                                             	;
        uint16_t	tx_complete_wr_idx                                                  	;
        uint16_t	rx_post_wr_idx_rsrv                                                 	;
        uint16_t	rx_post_wr_idx                                                      	;
        uint16_t	idma_last_group_fr                                                  	;
        uint8_t	idma_group_shift                                                    	;
        uint32_t	reserved                                                            	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	idma_active                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_ring_format                                                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1[RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RESERVED1_NUMBER];
        uint8_t	fr_ptrs_size_shift                                                  	;
        uint32_t	scratchpad[RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_NUMBER];
        uint8_t	reserved2[RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RESERVED2_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT;

#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_LOW_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT), (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_LOW_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT), (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_LOW_READ(r, p)                    MREAD_32((uint8_t *)(p), (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_LOW_WRITE(v, p)                   MWRITE_32((uint8_t *)(p), (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_HIGH_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 4, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_HIGH_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 4, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_HIGH_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_BASE_PTR_HIGH_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 8, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 8, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 12, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 12, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_RD_IDX_PTR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 16, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 16, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 20, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 20, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_FR_WR_IDX_PTR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_LOW_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 24, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_LOW_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 24, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_LOW_READ(r, p)                    MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_LOW_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_HIGH_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 28, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_HIGH_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 28, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_HIGH_READ(r, p)                   MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_BASE_PTR_HIGH_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 32, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 32, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 36, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 36, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_RD_IDX_PTR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 40, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 40, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 44, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 44, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_FR_WR_IDX_PTR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_LOW_READ_G(r, g, idx)                 GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 48, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_LOW_WRITE_G(v, g, idx)                GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 48, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_LOW_READ(r, p)                        MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_LOW_WRITE(v, p)                       MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_HIGH_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 52, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_HIGH_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 52, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_HIGH_READ(r, p)                       MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_BASE_PTR_HIGH_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 56, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 56, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 60, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 60, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_HIGH_READ(r, p)                     MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_RD_IDX_PTR_HIGH_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 64, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 64, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 68, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 68, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_HIGH_READ(r, p)                     MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_FR_WR_IDX_PTR_HIGH_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 72, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 72, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_READ(r, p)                               MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 76, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 76, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_READ(r, p)                              MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_RD_IDX_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 80, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_RD_IDX_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 80, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_RD_IDX_READ(r, p)                             MREAD_16((uint8_t *)(p) + 80, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_RD_IDX_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 80, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 82, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 82, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_READ(r, p)                             MREAD_16((uint8_t *)(p) + 82, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 82, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_RSRV_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 84, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_RSRV_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 84, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_RSRV_READ(r, p)                        MREAD_16((uint8_t *)(p) + 84, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_COMPLETE_WR_IDX_RSRV_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 84, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_RD_IDX_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 86, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_RD_IDX_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 86, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_RD_IDX_READ(r, p)                             MREAD_16((uint8_t *)(p) + 86, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_RD_IDX_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 86, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 88, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 88, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_READ(r, p)                             MREAD_16((uint8_t *)(p) + 88, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 88, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_RSRV_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 90, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_RSRV_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 90, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_RSRV_READ(r, p)                        MREAD_16((uint8_t *)(p) + 90, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_TX_COMPLETE_WR_IDX_RSRV_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 90, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_READ_G(r, g, idx)                          GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 92, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_WRITE_G(v, g, idx)                         GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 92, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_READ(r, p)                                 MREAD_16((uint8_t *)(p) + 92, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_WRITE(v, p)                                MWRITE_16((uint8_t *)(p) + 92, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_RSRV_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 94, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_RSRV_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 94, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_RSRV_READ(r, p)                            MREAD_16((uint8_t *)(p) + 94, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_RX_POST_WR_IDX_RSRV_WRITE(v, p)                           MWRITE_16((uint8_t *)(p) + 94, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 96, 5, 3, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 96, 5, 3, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 96, 5, 3, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 96, 5, 3, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_ACTIVE_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 96, 4, 1, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_ACTIVE_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 96, 4, 1, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_ACTIVE_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 96, 4, 1, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_ACTIVE_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 96, 4, 1, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 97, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 97, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_READ(r, p)                               MREAD_8((uint8_t *)(p) + 97, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 97, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 98, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 98, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_READ(r, p)                             MREAD_16((uint8_t *)(p) + 98, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 98, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 100, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 100, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_READ(r, p)                             MREAD_8((uint8_t *)(p) + 100, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 100, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_READ_G(r, g, idx, i)                           GROUP_MREAD_I_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 104, i, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_WRITE_G(v, g, idx, i)                          GROUP_MWRITE_I_32((g), (idx)*sizeof(DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT) + 104, i, (v))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_READ(r, p, i)                                  MREAD_I_32((uint8_t *)(p) + 104, i, (r))
#define RDD_DHD_COMPLETE_COMMON_RADIO_ENTRY_SCRATCHPAD_WRITE(v, p, i)                                 MWRITE_I_32((uint8_t *)(p) + 104, i, (v))
/* <<<DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT */


#define RDD_DHD_COMPLETE_COMMON_RADIO_DATA_SIZE     3
typedef struct
{
	DHD_COMPLETE_COMMON_RADIO_ENTRY_STRUCT	entry[ RDD_DHD_COMPLETE_COMMON_RADIO_DATA_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_COMPLETE_COMMON_RADIO_DATA_STRUCT;

extern uint32_t RDD_DHD_COMPLETE_COMMON_RADIO_DATA_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_COMPLETE_COMMON_RADIO_DATA_PTR(core_id)	( DHD_COMPLETE_COMMON_RADIO_DATA_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_COMPLETE_COMMON_RADIO_DATA_ADDRESS_ARR[core_id] ))

/* <<<DHD_COMPLETE_COMMON_RADIO_DATA */


/* >>>DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR */

/* >>>DDR_ADDRESS_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	low       	;
        uint32_t	high      	;
#else
        uint32_t	low       	;
        uint32_t	high      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DDR_ADDRESS_STRUCT;

#define RDD_DDR_ADDRESS_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT), (r))
#define RDD_DDR_ADDRESS_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT), (v))
#define RDD_DDR_ADDRESS_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_DDR_ADDRESS_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_DDR_ADDRESS_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT) + 4, (r))
#define RDD_DDR_ADDRESS_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DDR_ADDRESS_STRUCT) + 4, (v))
#define RDD_DDR_ADDRESS_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DDR_ADDRESS_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<DDR_ADDRESS_STRUCT */


#define RDD_DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_STRUCT;

extern uint32_t RDD_DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_PTR(core_id)	( DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[core_id] ))

/* <<<DHD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR */


/* >>>LOOPBACK_QUEUE_TABLE */

#define RDD_LOOPBACK_QUEUE_TABLE_SIZE     16
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_LOOPBACK_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ LOOPBACK_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_LOOPBACK_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_LOOPBACK_QUEUE_TABLE_PTR(core_id)	( LOOPBACK_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_LOOPBACK_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<LOOPBACK_QUEUE_TABLE */


/* >>>DHD_TX_COMPLETE_0_STACK */

#define RDD_DHD_TX_COMPLETE_0_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_COMPLETE_0_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_COMPLETE_0_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_COMPLETE_0_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_COMPLETE_0_STACK_PTR(core_id)	( DHD_TX_COMPLETE_0_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_COMPLETE_0_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_COMPLETE_0_STACK */


/* >>>PROCESSING0_STACK */

#define RDD_PROCESSING0_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING0_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING0_STACK_STRUCT;

extern uint32_t RDD_PROCESSING0_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING0_STACK_PTR(core_id)	( PROCESSING0_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING0_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING0_STACK */


/* >>>DHD_RX_COMPLETE_0_STACK */

#define RDD_DHD_RX_COMPLETE_0_STACK_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_RX_COMPLETE_0_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_COMPLETE_0_STACK_STRUCT;

extern uint32_t RDD_DHD_RX_COMPLETE_0_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_COMPLETE_0_STACK_PTR(core_id)	( DHD_RX_COMPLETE_0_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_COMPLETE_0_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_COMPLETE_0_STACK */


/* >>>DHD_TX_COMPLETE_1_STACK */

#define RDD_DHD_TX_COMPLETE_1_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_COMPLETE_1_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_COMPLETE_1_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_COMPLETE_1_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_COMPLETE_1_STACK_PTR(core_id)	( DHD_TX_COMPLETE_1_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_COMPLETE_1_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_COMPLETE_1_STACK */


/* >>>PROCESSING1_STACK */

#define RDD_PROCESSING1_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING1_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING1_STACK_STRUCT;

extern uint32_t RDD_PROCESSING1_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING1_STACK_PTR(core_id)	( PROCESSING1_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING1_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING1_STACK */


/* >>>DHD_RX_COMPLETE_1_STACK */

#define RDD_DHD_RX_COMPLETE_1_STACK_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_RX_COMPLETE_1_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_COMPLETE_1_STACK_STRUCT;

extern uint32_t RDD_DHD_RX_COMPLETE_1_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_COMPLETE_1_STACK_PTR(core_id)	( DHD_RX_COMPLETE_1_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_COMPLETE_1_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_COMPLETE_1_STACK */


/* >>>DHD_TX_COMPLETE_2_STACK */

#define RDD_DHD_TX_COMPLETE_2_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_COMPLETE_2_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_COMPLETE_2_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_COMPLETE_2_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_COMPLETE_2_STACK_PTR(core_id)	( DHD_TX_COMPLETE_2_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_COMPLETE_2_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_COMPLETE_2_STACK */


/* >>>PROCESSING2_STACK */

#define RDD_PROCESSING2_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING2_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING2_STACK_STRUCT;

extern uint32_t RDD_PROCESSING2_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING2_STACK_PTR(core_id)	( PROCESSING2_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING2_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING2_STACK */


/* >>>DHD_RX_COMPLETE_2_STACK */

#define RDD_DHD_RX_COMPLETE_2_STACK_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_RX_COMPLETE_2_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_COMPLETE_2_STACK_STRUCT;

extern uint32_t RDD_DHD_RX_COMPLETE_2_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_COMPLETE_2_STACK_PTR(core_id)	( DHD_RX_COMPLETE_2_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_COMPLETE_2_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_COMPLETE_2_STACK */


/* >>>DHD_RX_COMPLETE_FLOW_RING_BUFFER */

/* >>>DHD_RX_COMPLETE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[8];
    uint64_t dword_64[4];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	msg_type            	;
        uint8_t	if_id               	;
        uint8_t	common_hdr_flags    	;
        uint8_t	epoch               	;
        uint32_t	request_id          	;
        uint16_t	compl_msg_hdr_status	;
        uint16_t	flow_ring_id        	;
        uint16_t	meta_buf_len        	;
        uint16_t	data_len            	;
        uint16_t	data_offset         	;
        uint16_t	flags               	;
        uint32_t	rx_status_0         	;
        uint32_t	rx_status_1         	;
        uint32_t	dma_done_mark       	;
#else
        uint8_t	epoch               	;
        uint8_t	common_hdr_flags    	;
        uint8_t	if_id               	;
        uint8_t	msg_type            	;
        uint32_t	request_id          	;
        uint16_t	flow_ring_id        	;
        uint16_t	compl_msg_hdr_status	;
        uint16_t	data_len            	;
        uint16_t	meta_buf_len        	;
        uint16_t	flags               	;
        uint16_t	data_offset         	;
        uint32_t	rx_status_0         	;
        uint32_t	rx_status_1         	;
        uint32_t	dma_done_mark       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_RX_COMPLETE_DESCRIPTOR_STRUCT;

#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_MSG_TYPE_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT), (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_MSG_TYPE_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT), (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_MSG_TYPE_READ(r, p)                             MREAD_8((uint8_t *)(p), (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_MSG_TYPE_WRITE(v, p)                            MWRITE_8((uint8_t *)(p), (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_MSG_TYPE_L_READ( wv )                           FIELD_GET( wv, 24, 8 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_MSG_TYPE_L_WRITE( v, wv )                       FIELD_SET( v, 24, 8, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_IF_ID_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_IF_ID_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_IF_ID_READ(r, p)                                MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_IF_ID_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_IF_ID_L_READ( wv )                              FIELD_GET( wv, 16, 8 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_IF_ID_L_WRITE( v, wv )                          FIELD_SET( v, 16, 8, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_READ(r, p)                     MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_L_READ( wv )                   FIELD_GET( wv, 8, 8 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_L_WRITE( v, wv )               FIELD_SET( v, 8, 8, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_EPOCH_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_EPOCH_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_EPOCH_READ(r, p)                                MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_EPOCH_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_EPOCH_L_READ( wv )                              FIELD_GET( wv, 0, 8 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_EPOCH_L_WRITE( v, wv )                          FIELD_SET( v, 0, 8, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_REQUEST_ID_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_REQUEST_ID_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_REQUEST_ID_READ(r, p)                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_REQUEST_ID_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_REQUEST_ID_L_READ( wv )                         FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_REQUEST_ID_L_WRITE( v, wv )                     FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMPL_MSG_HDR_STATUS_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMPL_MSG_HDR_STATUS_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMPL_MSG_HDR_STATUS_READ(r, p)                 MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMPL_MSG_HDR_STATUS_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMPL_MSG_HDR_STATUS_L_READ( wv )               FIELD_GET( wv, 16, 16 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_COMPL_MSG_HDR_STATUS_L_WRITE( v, wv )           FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_READ(r, p)                         MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_L_READ( wv )                       FIELD_GET( wv, 0, 16 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_L_WRITE( v, wv )                   FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_META_BUF_LEN_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_META_BUF_LEN_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_META_BUF_LEN_READ(r, p)                         MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_META_BUF_LEN_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_META_BUF_LEN_L_READ( wv )                       FIELD_GET( wv, 16, 16 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_META_BUF_LEN_L_WRITE( v, wv )                   FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_LEN_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_LEN_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_LEN_READ(r, p)                             MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_LEN_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_LEN_L_READ( wv )                           FIELD_GET( wv, 0, 16 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_LEN_L_WRITE( v, wv )                       FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_OFFSET_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 16, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_OFFSET_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 16, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_OFFSET_READ(r, p)                          MREAD_16((uint8_t *)(p) + 16, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_OFFSET_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 16, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_OFFSET_L_READ( wv )                        FIELD_GET( wv, 16, 16 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DATA_OFFSET_L_WRITE( v, wv )                    FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLAGS_READ_G(r, g, idx)                         GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 18, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLAGS_WRITE_G(v, g, idx)                        GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 18, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLAGS_READ(r, p)                                MREAD_16((uint8_t *)(p) + 18, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLAGS_WRITE(v, p)                               MWRITE_16((uint8_t *)(p) + 18, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLAGS_L_READ( wv )                              FIELD_GET( wv, 0, 16 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_FLAGS_L_WRITE( v, wv )                          FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_0_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 20, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_0_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 20, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_0_READ(r, p)                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_0_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_0_L_READ( wv )                        FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_0_L_WRITE( v, wv )                    FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_1_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 24, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_1_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 24, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_1_READ(r, p)                          MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_1_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_1_L_READ( wv )                        FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_RX_STATUS_1_L_WRITE( v, wv )                    FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_READ_G(r, g, idx)                 GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 28, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_WRITE_G(v, g, idx)                GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_COMPLETE_DESCRIPTOR_STRUCT) + 28, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_READ(r, p)                        MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_WRITE(v, p)                       MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_L_READ( wv )                      FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_L_WRITE( v, wv )                  FIELD_SET( v, 0, 32, wv )
/* <<<DHD_RX_COMPLETE_DESCRIPTOR_STRUCT */


#define RDD_DHD_RX_COMPLETE_FLOW_RING_BUFFER_SIZE     3
typedef struct
{
	DHD_RX_COMPLETE_DESCRIPTOR_STRUCT	entry[ RDD_DHD_RX_COMPLETE_FLOW_RING_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_COMPLETE_FLOW_RING_BUFFER_STRUCT;

extern uint32_t RDD_DHD_RX_COMPLETE_FLOW_RING_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_COMPLETE_FLOW_RING_BUFFER_PTR(core_id)	( DHD_RX_COMPLETE_FLOW_RING_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_COMPLETE_FLOW_RING_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_COMPLETE_FLOW_RING_BUFFER */


/* >>>VPORT_TO_LOOKUP_PORT_MAPPING_TABLE */

#define RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_STRUCT;

extern uint32_t RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_PTR(core_id)	( VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_TO_LOOKUP_PORT_MAPPING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VPORT_TO_LOOKUP_PORT_MAPPING_TABLE */


/* >>>PROCESSING3_STACK */

#define RDD_PROCESSING3_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING3_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING3_STACK_STRUCT;

extern uint32_t RDD_PROCESSING3_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING3_STACK_PTR(core_id)	( PROCESSING3_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING3_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING3_STACK */


/* >>>DHD_TX_COMPLETE_FLOW_RING_BUFFER */

/* >>>DHD_TX_COMPLETE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	msg_type        	;
        uint8_t	if_id           	;
        uint8_t	common_hdr_flags	;
        uint8_t	epoch           	;
        uint32_t	request_id      	;
        uint16_t	status          	;
        uint16_t	flow_ring_id    	;
        uint32_t	dma_done_mark   	;
#else
        uint8_t	epoch           	;
        uint8_t	common_hdr_flags	;
        uint8_t	if_id           	;
        uint8_t	msg_type        	;
        uint32_t	request_id      	;
        uint16_t	flow_ring_id    	;
        uint16_t	status          	;
        uint32_t	dma_done_mark   	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_TX_COMPLETE_DESCRIPTOR_STRUCT;

#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_MSG_TYPE_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT), (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_MSG_TYPE_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT), (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_MSG_TYPE_READ(r, p)                         MREAD_8((uint8_t *)(p), (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_MSG_TYPE_WRITE(v, p)                        MWRITE_8((uint8_t *)(p), (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_MSG_TYPE_L_READ( wv )                       FIELD_GET( wv, 24, 8 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_MSG_TYPE_L_WRITE( v, wv )                   FIELD_SET( v, 24, 8, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_IF_ID_READ_G(r, g, idx)                     GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_IF_ID_WRITE_G(v, g, idx)                    GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_IF_ID_READ(r, p)                            MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_IF_ID_WRITE(v, p)                           MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_IF_ID_L_READ( wv )                          FIELD_GET( wv, 16, 8 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_IF_ID_L_WRITE( v, wv )                      FIELD_SET( v, 16, 8, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_READ(r, p)                 MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_L_READ( wv )               FIELD_GET( wv, 8, 8 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_COMMON_HDR_FLAGS_L_WRITE( v, wv )           FIELD_SET( v, 8, 8, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_EPOCH_READ_G(r, g, idx)                     GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_EPOCH_WRITE_G(v, g, idx)                    GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_EPOCH_READ(r, p)                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_EPOCH_WRITE(v, p)                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_EPOCH_L_READ( wv )                          FIELD_GET( wv, 0, 8 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_EPOCH_L_WRITE( v, wv )                      FIELD_SET( v, 0, 8, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_REQUEST_ID_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_REQUEST_ID_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_REQUEST_ID_READ(r, p)                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_REQUEST_ID_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_REQUEST_ID_L_READ( wv )                     FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_REQUEST_ID_L_WRITE( v, wv )                 FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_STATUS_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_STATUS_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_STATUS_READ(r, p)                           MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_STATUS_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_STATUS_L_READ( wv )                         FIELD_GET( wv, 16, 16 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_STATUS_L_WRITE( v, wv )                     FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_READ(r, p)                     MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_L_READ( wv )                   FIELD_GET( wv, 0, 16 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_FLOW_RING_ID_L_WRITE( v, wv )               FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_COMPLETE_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_READ(r, p)                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_L_READ( wv )                  FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_COMPLETE_DESCRIPTOR_DMA_DONE_MARK_L_WRITE( v, wv )              FIELD_SET( v, 0, 32, wv )
/* <<<DHD_TX_COMPLETE_DESCRIPTOR_STRUCT */


#define RDD_DHD_TX_COMPLETE_FLOW_RING_BUFFER_SIZE     3
typedef struct
{
	DHD_TX_COMPLETE_DESCRIPTOR_STRUCT	entry[ RDD_DHD_TX_COMPLETE_FLOW_RING_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_COMPLETE_FLOW_RING_BUFFER_STRUCT;

extern uint32_t RDD_DHD_TX_COMPLETE_FLOW_RING_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_COMPLETE_FLOW_RING_BUFFER_PTR(core_id)	( DHD_TX_COMPLETE_FLOW_RING_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_COMPLETE_FLOW_RING_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_COMPLETE_FLOW_RING_BUFFER */


/* >>>FPM_POOL_NUMBER_MAPPING_TABLE */

/* >>>FPM_POOL_NUMBER_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pool_number	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	pool_number	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} FPM_POOL_NUMBER_STRUCT;

#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FPM_POOL_NUMBER_STRUCT), 0, 2, (r))
#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FPM_POOL_NUMBER_STRUCT), 0, 2, (v))
#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 2, (r))
#define RDD_FPM_POOL_NUMBER_POOL_NUMBER_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 2, (v))
/* <<<FPM_POOL_NUMBER_STRUCT */


#define RDD_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE     16
typedef struct
{
	FPM_POOL_NUMBER_STRUCT	entry[ RDD_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT;

extern uint32_t RDD_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FPM_POOL_NUMBER_MAPPING_TABLE_PTR(core_id)	( FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<FPM_POOL_NUMBER_MAPPING_TABLE */


/* >>>DHD_RX_POST_FLOW_RING_BUFFER */

/* >>>DHD_RX_POST_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[8];
    uint64_t dword_64[4];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	msg_type             	;
        uint8_t	if_id                	;
        uint8_t	common_hdr_flags     	;
        uint8_t	epoch                	;
        uint32_t	request_id           	;
        uint16_t	meta_buf_len         	;
        uint16_t	data_len             	;
        uint32_t	reserved             	;
        uint32_t	metadata_buf_addr_low	;
        uint32_t	metadata_buf_addr_hi 	;
        uint32_t	data_buf_addr_low    	;
        uint32_t	data_buf_addr_hi     	;
#else
        uint8_t	epoch                	;
        uint8_t	common_hdr_flags     	;
        uint8_t	if_id                	;
        uint8_t	msg_type             	;
        uint32_t	request_id           	;
        uint16_t	data_len             	;
        uint16_t	meta_buf_len         	;
        uint32_t	reserved             	;
        uint32_t	metadata_buf_addr_low	;
        uint32_t	metadata_buf_addr_hi 	;
        uint32_t	data_buf_addr_low    	;
        uint32_t	data_buf_addr_hi     	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_RX_POST_DESCRIPTOR_STRUCT;

#define RDD_DHD_RX_POST_DESCRIPTOR_MSG_TYPE_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT), (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_MSG_TYPE_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT), (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_MSG_TYPE_READ(r, p)                              MREAD_8((uint8_t *)(p), (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_MSG_TYPE_WRITE(v, p)                             MWRITE_8((uint8_t *)(p), (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_MSG_TYPE_L_READ( wv )                            FIELD_GET( wv, 24, 8 )
#define RDD_DHD_RX_POST_DESCRIPTOR_MSG_TYPE_L_WRITE( v, wv )                        FIELD_SET( v, 24, 8, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_IF_ID_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_IF_ID_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_IF_ID_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_IF_ID_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_IF_ID_L_READ( wv )                               FIELD_GET( wv, 16, 8 )
#define RDD_DHD_RX_POST_DESCRIPTOR_IF_ID_L_WRITE( v, wv )                           FIELD_SET( v, 16, 8, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_READ(r, p)                      MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_L_READ( wv )                    FIELD_GET( wv, 8, 8 )
#define RDD_DHD_RX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_L_WRITE( v, wv )                FIELD_SET( v, 8, 8, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_EPOCH_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_EPOCH_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_EPOCH_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_EPOCH_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_EPOCH_L_READ( wv )                               FIELD_GET( wv, 0, 8 )
#define RDD_DHD_RX_POST_DESCRIPTOR_EPOCH_L_WRITE( v, wv )                           FIELD_SET( v, 0, 8, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_REQUEST_ID_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_REQUEST_ID_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_REQUEST_ID_READ(r, p)                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_REQUEST_ID_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_REQUEST_ID_L_READ( wv )                          FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_POST_DESCRIPTOR_REQUEST_ID_L_WRITE( v, wv )                      FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_META_BUF_LEN_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_META_BUF_LEN_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_META_BUF_LEN_READ(r, p)                          MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_META_BUF_LEN_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_META_BUF_LEN_L_READ( wv )                        FIELD_GET( wv, 16, 16 )
#define RDD_DHD_RX_POST_DESCRIPTOR_META_BUF_LEN_L_WRITE( v, wv )                    FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_LEN_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_LEN_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_LEN_READ(r, p)                              MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_LEN_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_LEN_L_READ( wv )                            FIELD_GET( wv, 0, 16 )
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_LEN_L_WRITE( v, wv )                        FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 16, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 16, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_READ(r, p)                 MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_L_READ( wv )               FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_L_WRITE( v, wv )           FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 20, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 20, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_READ(r, p)                  MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_L_READ( wv )                FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_L_WRITE( v, wv )            FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 24, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 24, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_READ(r, p)                     MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_L_READ( wv )                   FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_L_WRITE( v, wv )               FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 28, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DHD_RX_POST_DESCRIPTOR_STRUCT) + 28, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_READ(r, p)                      MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_L_READ( wv )                    FIELD_GET( wv, 0, 32 )
#define RDD_DHD_RX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_L_WRITE( v, wv )                FIELD_SET( v, 0, 32, wv )
/* <<<DHD_RX_POST_DESCRIPTOR_STRUCT */


#define RDD_DHD_RX_POST_FLOW_RING_BUFFER_SIZE     3
typedef struct
{
	DHD_RX_POST_DESCRIPTOR_STRUCT	entry[ RDD_DHD_RX_POST_FLOW_RING_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_POST_FLOW_RING_BUFFER_STRUCT;

extern uint32_t RDD_DHD_RX_POST_FLOW_RING_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_POST_FLOW_RING_BUFFER_PTR(core_id)	( DHD_RX_POST_FLOW_RING_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_POST_FLOW_RING_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_POST_FLOW_RING_BUFFER */


/* >>>RUNNER_GLOBAL_REGISTERS_INIT */

/* >>>BYTES_4_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bits      	;
#else
        uint32_t	bits      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) BYTES_4_STRUCT;

#define RDD_BYTES_4_BITS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(BYTES_4_STRUCT), (r))
#define RDD_BYTES_4_BITS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(BYTES_4_STRUCT), (v))
#define RDD_BYTES_4_BITS_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_BYTES_4_BITS_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
/* <<<BYTES_4_STRUCT */


#define RDD_RUNNER_GLOBAL_REGISTERS_INIT_SIZE     8
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_RUNNER_GLOBAL_REGISTERS_INIT_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RUNNER_GLOBAL_REGISTERS_INIT_STRUCT;

extern uint32_t RDD_RUNNER_GLOBAL_REGISTERS_INIT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RUNNER_GLOBAL_REGISTERS_INIT_PTR(core_id)	( RUNNER_GLOBAL_REGISTERS_INIT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RUNNER_GLOBAL_REGISTERS_INIT_ADDRESS_ARR[core_id] ))

/* <<<RUNNER_GLOBAL_REGISTERS_INIT */


/* >>>PROCESSING_8_TASKS_PACKET_BUFFER */

/* >>>PACKET_BUFFER_STRUCT */
#define RDD_PACKET_BUFFER_PACKET_HEADER_NUMBER	112
#define RDD_PACKET_BUFFER_PARSER_RESULT_NUMBER	104
#define RDD_PACKET_BUFFER_SCRATCH_NUMBER	112
#define RDD_PACKET_BUFFER_SCRATCH_REPLY_NUMBER	16
#define RDD_PACKET_BUFFER_PD_NUMBER	16
#define RDD_PACKET_BUFFER_TCAM_RESULT_NUMBER	20
#define RDD_PACKET_BUFFER_RESERVED1_NUMBER	4
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_NUMBER	128
typedef union
{
    uint32_t word_32[128];
    uint64_t dword_64[64];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	packet_header[RDD_PACKET_BUFFER_PACKET_HEADER_NUMBER];
        uint8_t	parser_result[RDD_PACKET_BUFFER_PARSER_RESULT_NUMBER];
        uint8_t	scratch[RDD_PACKET_BUFFER_SCRATCH_NUMBER];
        uint8_t	scratch_reply[RDD_PACKET_BUFFER_SCRATCH_REPLY_NUMBER];
        uint8_t	pd[RDD_PACKET_BUFFER_PD_NUMBER];
        uint8_t	tcam_result[RDD_PACKET_BUFFER_TCAM_RESULT_NUMBER];
        uint8_t	reserved1[RDD_PACKET_BUFFER_RESERVED1_NUMBER];
        uint8_t	classification_contexts_list[RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_NUMBER];
#else
        uint8_t	packet_header[RDD_PACKET_BUFFER_PACKET_HEADER_NUMBER];
        uint8_t	parser_result[RDD_PACKET_BUFFER_PARSER_RESULT_NUMBER];
        uint8_t	scratch[RDD_PACKET_BUFFER_SCRATCH_NUMBER];
        uint8_t	scratch_reply[RDD_PACKET_BUFFER_SCRATCH_REPLY_NUMBER];
        uint8_t	pd[RDD_PACKET_BUFFER_PD_NUMBER];
        uint8_t	tcam_result[RDD_PACKET_BUFFER_TCAM_RESULT_NUMBER];
        uint8_t	reserved1[RDD_PACKET_BUFFER_RESERVED1_NUMBER];
        uint8_t	classification_contexts_list[RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PACKET_BUFFER_STRUCT;

#define RDD_PACKET_BUFFER_PACKET_HEADER_READ_G(r, g, idx, i)                      GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT), i, (r))
#define RDD_PACKET_BUFFER_PACKET_HEADER_WRITE_G(v, g, idx, i)                     GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT), i, (v))
#define RDD_PACKET_BUFFER_PACKET_HEADER_READ(r, p, i)                             MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_PACKET_BUFFER_PACKET_HEADER_WRITE(v, p, i)                            MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_PACKET_BUFFER_PARSER_RESULT_READ_G(r, g, idx, i)                      GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 112, i, (r))
#define RDD_PACKET_BUFFER_PARSER_RESULT_WRITE_G(v, g, idx, i)                     GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 112, i, (v))
#define RDD_PACKET_BUFFER_PARSER_RESULT_READ(r, p, i)                             MREAD_I_8((uint8_t *)(p) + 112, i, (r))
#define RDD_PACKET_BUFFER_PARSER_RESULT_WRITE(v, p, i)                            MWRITE_I_8((uint8_t *)(p) + 112, i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_READ_G(r, g, idx, i)                            GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 216, i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_WRITE_G(v, g, idx, i)                           GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 216, i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_READ(r, p, i)                                   MREAD_I_8((uint8_t *)(p) + 216, i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_WRITE(v, p, i)                                  MWRITE_I_8((uint8_t *)(p) + 216, i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_REPLY_READ_G(r, g, idx, i)                      GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 328, i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_REPLY_WRITE_G(v, g, idx, i)                     GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 328, i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_REPLY_READ(r, p, i)                             MREAD_I_8((uint8_t *)(p) + 328, i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_REPLY_WRITE(v, p, i)                            MWRITE_I_8((uint8_t *)(p) + 328, i, (v))
#define RDD_PACKET_BUFFER_PD_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 344, i, (r))
#define RDD_PACKET_BUFFER_PD_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 344, i, (v))
#define RDD_PACKET_BUFFER_PD_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 344, i, (r))
#define RDD_PACKET_BUFFER_PD_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 344, i, (v))
#define RDD_PACKET_BUFFER_TCAM_RESULT_READ_G(r, g, idx, i)                        GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 360, i, (r))
#define RDD_PACKET_BUFFER_TCAM_RESULT_WRITE_G(v, g, idx, i)                       GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 360, i, (v))
#define RDD_PACKET_BUFFER_TCAM_RESULT_READ(r, p, i)                               MREAD_I_8((uint8_t *)(p) + 360, i, (r))
#define RDD_PACKET_BUFFER_TCAM_RESULT_WRITE(v, p, i)                              MWRITE_I_8((uint8_t *)(p) + 360, i, (v))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 384, i, (r))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_STRUCT) + 384, i, (v))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 384, i, (r))
#define RDD_PACKET_BUFFER_CLASSIFICATION_CONTEXTS_LIST_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 384, i, (v))
/* <<<PACKET_BUFFER_STRUCT */


#define RDD_PROCESSING_8_TASKS_PACKET_BUFFER_SIZE     8
typedef struct
{
	PACKET_BUFFER_STRUCT	entry[ RDD_PROCESSING_8_TASKS_PACKET_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING_8_TASKS_PACKET_BUFFER_STRUCT;

extern uint32_t RDD_PROCESSING_8_TASKS_PACKET_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING_8_TASKS_PACKET_BUFFER_PTR(core_id)	( PROCESSING_8_TASKS_PACKET_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING_8_TASKS_PACKET_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING_8_TASKS_PACKET_BUFFER */


/* >>>PROCESSING4_STACK */

#define RDD_PROCESSING4_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING4_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING4_STACK_STRUCT;

extern uint32_t RDD_PROCESSING4_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING4_STACK_PTR(core_id)	( PROCESSING4_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING4_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING4_STACK */


/* >>>DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE */

#define RDD_DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_SIZE     12
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_COMPLETE_DISPATCHER_CREDIT_TABLE */


/* >>>DHD_HW_CFG */

/* >>>DHD_HW_CONFIGURATION_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	aggr_timer_period  	;
        uint32_t	reserved0          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	rx_post_fpm_pool   	;
        uint8_t	reserved1          	;
        uint16_t	fpm_thresholds_low 	;
        uint16_t	fpm_thresholds_high	;
        uint16_t	fpm_thresholds_excl	;
        uint16_t	reserved2          	;
#else
        uint32_t	aggr_timer_period  	;
        uint8_t	reserved1          	;
        uint8_t	rx_post_fpm_pool   	;
        uint32_t	ddr_sop_offset     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	fpm_thresholds_high	;
        uint16_t	fpm_thresholds_low 	;
        uint16_t	reserved2          	;
        uint16_t	fpm_thresholds_excl	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_HW_CONFIGURATION_STRUCT;

#define RDD_DHD_HW_CONFIGURATION_AGGR_TIMER_PERIOD_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT), (r))
#define RDD_DHD_HW_CONFIGURATION_AGGR_TIMER_PERIOD_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT), (v))
#define RDD_DHD_HW_CONFIGURATION_AGGR_TIMER_PERIOD_READ(r, p)                   MREAD_32((uint8_t *)(p), (r))
#define RDD_DHD_HW_CONFIGURATION_AGGR_TIMER_PERIOD_WRITE(v, p)                  MWRITE_32((uint8_t *)(p), (v))
#define RDD_DHD_HW_CONFIGURATION_DDR_SOP_OFFSET_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 4, 0, 11, (r))
#define RDD_DHD_HW_CONFIGURATION_DDR_SOP_OFFSET_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 4, 0, 11, (v))
#define RDD_DHD_HW_CONFIGURATION_DDR_SOP_OFFSET_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 4, 0, 11, (r))
#define RDD_DHD_HW_CONFIGURATION_DDR_SOP_OFFSET_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 4, 0, 11, (v))
#define RDD_DHD_HW_CONFIGURATION_RX_POST_FPM_POOL_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 6, (r))
#define RDD_DHD_HW_CONFIGURATION_RX_POST_FPM_POOL_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 6, (v))
#define RDD_DHD_HW_CONFIGURATION_RX_POST_FPM_POOL_READ(r, p)                    MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_DHD_HW_CONFIGURATION_RX_POST_FPM_POOL_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_LOW_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 8, (r))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 8, (v))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_LOW_READ(r, p)                  MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_LOW_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_HIGH_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 10, (r))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 10, (v))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_HIGH_READ(r, p)                 MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_HIGH_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_EXCL_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 12, (r))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_EXCL_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(DHD_HW_CONFIGURATION_STRUCT) + 12, (v))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_EXCL_READ(r, p)                 MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_DHD_HW_CONFIGURATION_FPM_THRESHOLDS_EXCL_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 12, (v))
/* <<<DHD_HW_CONFIGURATION_STRUCT */


#define RDD_DHD_HW_CFG_SIZE     1
typedef struct
{
	DHD_HW_CONFIGURATION_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_HW_CFG_STRUCT;

extern uint32_t RDD_DHD_HW_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_HW_CFG_PTR(core_id)	( DHD_HW_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_HW_CFG_ADDRESS_ARR[core_id] ))

/* <<<DHD_HW_CFG */


/* >>>POLICER_PARAMS_TABLE */

/* >>>POLICER_PARAMS_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	factor_bytes	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dei_mode    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	reserved    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dei_mode    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	factor_bytes	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} POLICER_PARAMS_ENTRY_STRUCT;

#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 5, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 5, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_POLICER_PARAMS_ENTRY_FACTOR_BYTES_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 4, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(POLICER_PARAMS_ENTRY_STRUCT), 4, 1, (v))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_POLICER_PARAMS_ENTRY_DEI_MODE_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
/* <<<POLICER_PARAMS_ENTRY_STRUCT */


#define RDD_POLICER_PARAMS_TABLE_SIZE     80
typedef struct
{
	POLICER_PARAMS_ENTRY_STRUCT	entry[ RDD_POLICER_PARAMS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ POLICER_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_POLICER_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_POLICER_PARAMS_TABLE_PTR(core_id)	( POLICER_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_POLICER_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<POLICER_PARAMS_TABLE */


/* >>>DEBUG_SCRATCHPAD */

#define RDD_DEBUG_SCRATCHPAD_SIZE     12
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DEBUG_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEBUG_SCRATCHPAD_STRUCT;

extern uint32_t RDD_DEBUG_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEBUG_SCRATCHPAD_PTR(core_id)	( DEBUG_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEBUG_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<DEBUG_SCRATCHPAD */


/* >>>PROCESSING5_STACK */

#define RDD_PROCESSING5_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING5_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING5_STACK_STRUCT;

extern uint32_t RDD_PROCESSING5_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING5_STACK_PTR(core_id)	( PROCESSING5_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING5_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING5_STACK */


/* >>>DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE */

#define RDD_DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_SIZE     12
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_COMPLETE_DISPATCHER_CREDIT_TABLE */


/* >>>SPDSVC_ANALYZER_PARAMS_TABLE */

/* >>>SPDSVC_ANALYZER_PARAMS_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	stream    	;
        uint32_t	stream1   	;
        uint32_t	stream2   	;
        uint32_t	stream3   	;
#else
        uint32_t	stream    	;
        uint32_t	stream1   	;
        uint32_t	stream2   	;
        uint32_t	stream3   	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) SPDSVC_ANALYZER_PARAMS_STRUCT;

#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM1_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM1_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM1_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM1_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM2_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT) + 8, (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM2_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT) + 8, (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM2_READ(r, p)                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM2_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM3_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT) + 12, (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM3_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_ANALYZER_PARAMS_STRUCT) + 12, (v))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM3_READ(r, p)                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_SPDSVC_ANALYZER_PARAMS_STREAM3_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<SPDSVC_ANALYZER_PARAMS_STRUCT */


#define RDD_SPDSVC_ANALYZER_PARAMS_TABLE_SIZE     1
typedef struct
{
	SPDSVC_ANALYZER_PARAMS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_ANALYZER_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_ANALYZER_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_ANALYZER_PARAMS_TABLE_PTR(core_id)	( SPDSVC_ANALYZER_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_ANALYZER_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_ANALYZER_PARAMS_TABLE */


/* >>>SPDSVC_ANALYZER_PD_FIFO_TABLE */

/* >>>PROCESSING_TX_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q_codel_ts	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	coherent       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn             	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU1_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_timestamp          	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU2_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	serial_num     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state_stream	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_port   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	union3         	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of cong_state_stream union */
        uint32_t	reservedSU1_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	bn1_first                	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	stream_id                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of cong_state_stream union */
        uint32_t	reservedSU2_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reserved1                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	abs_1                    	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cong_state_stream	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_port                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	lan_vport                	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	from_feed_ring           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	data_1588                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_cong_state_stream	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	flow_id                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU4_union3       	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_sop	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm                   	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm_pool              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm_num               	:17	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop                      	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint16_t	bn0_first                	; /* Member of payload_offset_sop union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                      	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved4                	:23	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	abs_0                    	:29	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	hn             	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	coherent       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q  	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q_codel_ts	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	force_copy     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	second_level_q           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU1_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_hn           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_coherent     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_first_level_q	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_timestamp          	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of second_level_q_codel_ts union */
        uint32_t	reservedSU2_force_copy   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dont_agg     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	serial_num     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	union3         	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ingress_port   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state_stream	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_1   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	flow                     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU1_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of cong_state_stream union */
        uint32_t	reservedSU1_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs_1                    	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	reserved1                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	source_port              	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU2_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	stream_id                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of cong_state_stream union */
        uint32_t	reservedSU2_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	data_1588                	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	from_feed_ring           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of union3 union */
        uint32_t	lan_vport                	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	lag_port                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU3_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cong_state_stream	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_union3       	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_id                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	is_vport                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU4_lan          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_cong_state_stream	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_drop         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	payload_offset_sop	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_0   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn_fpm                   	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop_fpm                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU1_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	bn_fpm_num               	:17	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm_pool              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved3                	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU2_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	bn0_first                	; /* Member of payload_offset_sop union */
        uint32_t	sop                      	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU3_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reserved4                	:23	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	viq                      	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU4_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	abs_0                    	:29	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved5                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU5_target_mem_0 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_agg_pd       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PROCESSING_TX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_L_READ( wv )                         FIELD_GET( wv, 31, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_VALID_L_WRITE( v, wv )                     FIELD_SET( v, 31, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_L_READ( wv )                      FIELD_GET( wv, 30, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_HEADROOM_L_WRITE( v, wv )                  FIELD_SET( v, 30, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_L_READ( wv )                      FIELD_GET( wv, 29, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_DONT_AGG_L_WRITE( v, wv )                  FIELD_SET( v, 29, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_L_READ( wv )                       FIELD_GET( wv, 28, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_MC_COPY_L_WRITE( v, wv )                   FIELD_SET( v, 28, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_L_READ( wv )                     FIELD_GET( wv, 27, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_REPROCESS_L_WRITE( v, wv )                 FIELD_SET( v, 27, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_L_READ( wv )                         FIELD_GET( wv, 26, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_COLOR_L_WRITE( v, wv )                     FIELD_SET( v, 26, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_L_READ( wv )                    FIELD_GET( wv, 25, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FORCE_COPY_L_WRITE( v, wv )                FIELD_SET( v, 25, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_READ_G(r, g, idx)  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_WRITE_G(v, g, idx) GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_READ(r, p)         FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_WRITE(v, p)        FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_L_READ( wv )       FIELD_GET( wv, 16, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_CODEL_TS_L_WRITE( v, wv )   FIELD_SET( v, 16, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_READ_G(r, g, idx)           GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_READ(r, p)                  FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_WRITE(v, p)                 FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_L_READ( wv )                FIELD_GET( wv, 16, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SECOND_LEVEL_Q_L_WRITE( v, wv )            FIELD_SET( v, 16, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_L_READ( wv )               FIELD_GET( wv, 16, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_CODEL_TIMESTAMP_L_WRITE( v, wv )           FIELD_SET( v, 16, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 2, 7, 9, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 2, 7, 9, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_L_READ( wv )                 FIELD_GET( wv, 7, 9 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FIRST_LEVEL_Q_L_WRITE( v, wv )             FIELD_SET( v, 7, 9, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_L_READ( wv )                     FIELD_GET( wv, 6, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLAG_1588_L_WRITE( v, wv )                 FIELD_SET( v, 6, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_L_READ( wv )                      FIELD_GET( wv, 5, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_COHERENT_L_WRITE( v, wv )                  FIELD_SET( v, 5, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 0, 5, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 3, 0, 5, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 5, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 5, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_L_READ( wv )                            FIELD_GET( wv, 0, 5 )
#define RDD_PROCESSING_TX_DESCRIPTOR_HN_L_WRITE( v, wv )                        FIELD_SET( v, 0, 5, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_L_READ( wv )                    FIELD_GET( wv, 22, 10 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SERIAL_NUM_L_WRITE( v, wv )                FIELD_SET( v, 22, 10, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_L_READ( wv )                      FIELD_GET( wv, 21, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_PRIORITY_L_WRITE( v, wv )                  FIELD_SET( v, 21, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_L_READ( wv )                  FIELD_GET( wv, 20, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_CONG_L_WRITE( v, wv )              FIELD_SET( v, 20, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_L_READ( wv )                           FIELD_GET( wv, 19, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_L_WRITE( v, wv )                       FIELD_SET( v, 19, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_L_READ( wv )                 FIELD_GET( wv, 0, 14 )
#define RDD_PROCESSING_TX_DESCRIPTOR_PACKET_LENGTH_L_WRITE( v, wv )             FIELD_SET( v, 0, 14, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_L_READ( wv )                          FIELD_GET( wv, 31, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_DROP_L_WRITE( v, wv )                      FIELD_SET( v, 31, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_L_READ( wv )                  FIELD_GET( wv, 30, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_1_L_WRITE( v, wv )              FIELD_SET( v, 30, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_STREAM_READ_G(r, g, idx)        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_STREAM_WRITE_G(v, g, idx)       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_STREAM_READ(r, p)               FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_STREAM_WRITE(v, p)              FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_STREAM_L_READ( wv )             FIELD_GET( wv, 28, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_STREAM_L_WRITE( v, wv )         FIELD_SET( v, 28, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_L_READ( wv )                    FIELD_GET( wv, 28, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_CONG_STATE_L_WRITE( v, wv )                FIELD_SET( v, 28, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_L_READ( wv )                     FIELD_GET( wv, 28, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_STREAM_ID_L_WRITE( v, wv )                 FIELD_SET( v, 28, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_L_READ( wv )                           FIELD_GET( wv, 27, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_L_WRITE( v, wv )                       FIELD_SET( v, 27, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_READ_G(r, g, idx)             GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_READ(r, p)                    FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_WRITE(v, p)                   FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_L_READ( wv )                  FIELD_GET( wv, 19, 8 )
#define RDD_PROCESSING_TX_DESCRIPTOR_INGRESS_PORT_L_WRITE( v, wv )              FIELD_SET( v, 19, 8, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_L_READ( wv )                          FIELD_GET( wv, 19, 8 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_L_WRITE( v, wv )                      FIELD_SET( v, 19, 8, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)              GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                     FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                    FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_L_READ( wv )                   FIELD_GET( wv, 19, 8 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOURCE_PORT_L_WRITE( v, wv )               FIELD_SET( v, 19, 8, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 1, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 1, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_L_READ( wv )                      FIELD_GET( wv, 25, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAG_PORT_L_WRITE( v, wv )                  FIELD_SET( v, 25, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 6, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 6, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 6, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 6, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_L_READ( wv )                     FIELD_GET( wv, 19, 6 )
#define RDD_PROCESSING_TX_DESCRIPTOR_LAN_VPORT_L_WRITE( v, wv )                 FIELD_SET( v, 19, 6, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_L_READ( wv )                      FIELD_GET( wv, 26, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_IS_VPORT_L_WRITE( v, wv )                  FIELD_SET( v, 26, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 3, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_READ(r, p)                         FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_WRITE(v, p)                        FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_L_READ( wv )                       FIELD_GET( wv, 19, 7 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FLOW_ID_L_WRITE( v, wv )                   FIELD_SET( v, 19, 7, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 19, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 19, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 19, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 19, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_L_READ( wv )                        FIELD_GET( wv, 0, 19 )
#define RDD_PROCESSING_TX_DESCRIPTOR_UNION3_L_WRITE( v, wv )                    FIELD_SET( v, 0, 19, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 19, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 19, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 19, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 19, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_L_READ( wv )                     FIELD_GET( wv, 0, 19 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN1_FIRST_L_WRITE( v, wv )                 FIELD_SET( v, 0, 19, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_1_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 10, 0, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_1_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 10, 0, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_1_READ(r, p)                           FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_1_WRITE(v, p)                          FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_1_L_READ( wv )                         FIELD_GET( wv, 0, 11 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_1_L_WRITE( v, wv )                     FIELD_SET( v, 0, 11, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_FROM_FEED_RING_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FROM_FEED_RING_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FROM_FEED_RING_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_FROM_FEED_RING_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_FROM_FEED_RING_L_READ( wv )                FIELD_GET( wv, 18, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_FROM_FEED_RING_L_WRITE( v, wv )            FIELD_SET( v, 18, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_READ(r, p)                       FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                      FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_L_READ( wv )                     FIELD_GET( wv, 0, 18 )
#define RDD_PROCESSING_TX_DESCRIPTOR_DATA_1588_L_WRITE( v, wv )                 FIELD_SET( v, 0, 18, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_L_READ( wv )                        FIELD_GET( wv, 31, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_AGG_PD_L_WRITE( v, wv )                    FIELD_SET( v, 31, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_L_READ( wv )                  FIELD_GET( wv, 30, 1 )
#define RDD_PROCESSING_TX_DESCRIPTOR_TARGET_MEM_0_L_WRITE( v, wv )              FIELD_SET( v, 30, 1, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ_G(r, g, idx)       GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 30, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE_G(v, g, idx)      GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 30, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ(r, p)              FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 30, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE(v, p)             FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 30, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_L_READ( wv )            FIELD_GET( wv, 0, 30 )
#define RDD_PROCESSING_TX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_L_WRITE( v, wv )        FIELD_SET( v, 0, 30, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 3, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 3, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_READ(r, p)                         FIELD_MREAD_16((uint8_t *)(p) + 12, 3, 11, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                        FIELD_MWRITE_16((uint8_t *)(p) + 12, 3, 11, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_L_READ( wv )                       FIELD_GET( wv, 19, 11 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_FPM_L_WRITE( v, wv )                   FIELD_SET( v, 19, 11, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 19, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 19, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 19, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 19, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_L_READ( wv )                        FIELD_GET( wv, 0, 19 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_L_WRITE( v, wv )                    FIELD_SET( v, 0, 19, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 13, 1, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 13, 1, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 13, 1, 2, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 13, 1, 2, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_L_READ( wv )                   FIELD_GET( wv, 17, 2 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_POOL_L_WRITE( v, wv )               FIELD_SET( v, 17, 2, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)               GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 17, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 17, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                      FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 17, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                     FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 17, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_L_READ( wv )                    FIELD_GET( wv, 0, 17 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_FPM_NUM_L_WRITE( v, wv )                FIELD_SET( v, 0, 17, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_READ(r, p)                          FIELD_MREAD_16((uint8_t *)(p) + 12, 7, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_WRITE(v, p)                         FIELD_MWRITE_16((uint8_t *)(p) + 12, 7, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_L_READ( wv )                        FIELD_GET( wv, 23, 7 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN_NUM_L_WRITE( v, wv )                    FIELD_SET( v, 23, 7, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 13, 0, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 13, 0, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_L_READ( wv )                           FIELD_GET( wv, 16, 7 )
#define RDD_PROCESSING_TX_DESCRIPTOR_SOP_L_WRITE( v, wv )                       FIELD_SET( v, 16, 7, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_READ(r, p)                       MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_L_READ( wv )                     FIELD_GET( wv, 0, 16 )
#define RDD_PROCESSING_TX_DESCRIPTOR_BN0_FIRST_L_WRITE( v, wv )                 FIELD_SET( v, 0, 16, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_VIQ_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_VIQ_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_VIQ_READ(r, p)                             FIELD_MREAD_16((uint8_t *)(p) + 12, 7, 7, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_VIQ_WRITE(v, p)                            FIELD_MWRITE_16((uint8_t *)(p) + 12, 7, 7, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_VIQ_L_READ( wv )                           FIELD_GET( wv, 23, 7 )
#define RDD_PROCESSING_TX_DESCRIPTOR_VIQ_L_WRITE( v, wv )                       FIELD_SET( v, 23, 7, wv )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_0_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 29, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_0_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_TX_DESCRIPTOR_STRUCT) + 12, 0, 29, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_0_READ(r, p)                           FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 29, (r))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_0_WRITE(v, p)                          FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 29, (v))
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_0_L_READ( wv )                         FIELD_GET( wv, 0, 29 )
#define RDD_PROCESSING_TX_DESCRIPTOR_ABS_0_L_WRITE( v, wv )                     FIELD_SET( v, 0, 29, wv )
/* <<<PROCESSING_TX_DESCRIPTOR_STRUCT */


#define RDD_SPDSVC_ANALYZER_PD_FIFO_TABLE_SIZE     4
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_SPDSVC_ANALYZER_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_ANALYZER_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_ANALYZER_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_ANALYZER_PD_FIFO_TABLE_PTR(core_id)	( SPDSVC_ANALYZER_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_ANALYZER_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_ANALYZER_PD_FIFO_TABLE */


/* >>>VLAN_ACTION_GPE_HANDLER_PTR_TABLE */

/* >>>BYTES_2_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	bits      	;
#else
        uint16_t	bits      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) BYTES_2_STRUCT;

#define RDD_BYTES_2_BITS_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(BYTES_2_STRUCT), (r))
#define RDD_BYTES_2_BITS_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(BYTES_2_STRUCT), (v))
#define RDD_BYTES_2_BITS_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_BYTES_2_BITS_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<BYTES_2_STRUCT */


#define RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_SIZE     17
typedef struct
{
	BYTES_2_STRUCT	entry[ RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VLAN_ACTION_GPE_HANDLER_PTR_TABLE_STRUCT;

extern uint32_t RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_PTR(core_id)	( VLAN_ACTION_GPE_HANDLER_PTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VLAN_ACTION_GPE_HANDLER_PTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<VLAN_ACTION_GPE_HANDLER_PTR_TABLE */


/* >>>CODEL_NUM_QUEUES */

#define RDD_CODEL_NUM_QUEUES_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CODEL_NUM_QUEUES_STRUCT;

extern uint32_t RDD_CODEL_NUM_QUEUES_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CODEL_NUM_QUEUES_PTR(core_id)	( CODEL_NUM_QUEUES_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CODEL_NUM_QUEUES_ADDRESS_ARR[core_id] ))

/* <<<CODEL_NUM_QUEUES */


/* >>>MUTEX_TABLE */

#define RDD_MUTEX_TABLE_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MUTEX_TABLE_STRUCT;

extern uint32_t RDD_MUTEX_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MUTEX_TABLE_PTR(core_id)	( MUTEX_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MUTEX_TABLE_ADDRESS_ARR[core_id] ))

/* <<<MUTEX_TABLE */


/* >>>SYSTEM_CONFIGURATION */

/* >>>SYSTEM_CONFIGURATION_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	ds_drop_precedence_eligibility_vector	;
        uint16_t	us_drop_precedence_eligibility_vector	;
        uint32_t	full_flow_cache_mode                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_flow_cache_mode                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_lookup_miss_action              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_stats_enable                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	g9991_skip_parser_error              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dp_eligibility_vector_used           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_packet_based_mapping_ds_or_us	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack_flows                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	us_drop_precedence_eligibility_vector	;
        uint16_t	ds_drop_precedence_eligibility_vector	;
        uint32_t	tcp_pure_ack_flows                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_packet_based_mapping_ds_or_us	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dp_eligibility_vector_used           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	g9991_skip_parser_error              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_stats_enable                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_lookup_miss_action              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_flow_cache_mode                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	full_flow_cache_mode                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} SYSTEM_CONFIGURATION_ENTRY_STRUCT;

#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT), (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT), (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DS_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 2, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 2, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_US_DROP_PRECEDENCE_ELIGIBILITY_VECTOR_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_FULL_FLOW_CACHE_MODE_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 6, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 6, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_L2_FLOW_CACHE_MODE_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 5, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 5, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_IPTV_LOOKUP_MISS_ACTION_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 4, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 4, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_VLAN_STATS_ENABLE_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 3, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 3, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_G9991_SKIP_PARSER_ERROR_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 2, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 2, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 4, 2, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_DP_ELIGIBILITY_VECTOR_USED_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 4, 2, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 1, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 1, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 4, 1, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_INGRESS_PACKET_BASED_MAPPING_DS_OR_US_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 4, 1, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 0, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SYSTEM_CONFIGURATION_ENTRY_STRUCT) + 4, 0, 1, (v))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 1, (r))
#define RDD_SYSTEM_CONFIGURATION_ENTRY_TCP_PURE_ACK_FLOWS_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 1, (v))
/* <<<SYSTEM_CONFIGURATION_ENTRY_STRUCT */


#define RDD_SYSTEM_CONFIGURATION_SIZE     1
typedef struct
{
	SYSTEM_CONFIGURATION_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SYSTEM_CONFIGURATION_STRUCT;

extern uint32_t RDD_SYSTEM_CONFIGURATION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SYSTEM_CONFIGURATION_PTR(core_id)	( SYSTEM_CONFIGURATION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SYSTEM_CONFIGURATION_ADDRESS_ARR[core_id] ))

/* <<<SYSTEM_CONFIGURATION */


/* >>>SPDTEST_NUM_OF_UDP_RX_FLOWS */

#define RDD_SPDTEST_NUM_OF_UDP_RX_FLOWS_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDTEST_NUM_OF_UDP_RX_FLOWS_STRUCT;

extern uint32_t RDD_SPDTEST_NUM_OF_UDP_RX_FLOWS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDTEST_NUM_OF_UDP_RX_FLOWS_PTR(core_id)	( SPDTEST_NUM_OF_UDP_RX_FLOWS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDTEST_NUM_OF_UDP_RX_FLOWS_ADDRESS_ARR[core_id] ))

/* <<<SPDTEST_NUM_OF_UDP_RX_FLOWS */


/* >>>MCAST_MAX_REPLICATION_FLAG_TABLE */

#define RDD_MCAST_MAX_REPLICATION_FLAG_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MCAST_MAX_REPLICATION_FLAG_TABLE_STRUCT;

extern uint32_t RDD_MCAST_MAX_REPLICATION_FLAG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MCAST_MAX_REPLICATION_FLAG_TABLE_PTR(core_id)	( MCAST_MAX_REPLICATION_FLAG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MCAST_MAX_REPLICATION_FLAG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<MCAST_MAX_REPLICATION_FLAG_TABLE */


/* >>>BRIDGE_CFG_TABLE */

/* >>>BRIDGE_CFG_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	hit                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_fw_failed        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_aggregation        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_results_available	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	res_offset              	;
        uint16_t	context_offset          	;
        uint16_t	reserved                	;
#else
        uint16_t	res_offset              	;
        uint32_t	bridge_results_available	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_aggregation        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_fw_failed        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hit                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved                	;
        uint16_t	context_offset          	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BRIDGE_CFG_STRUCT;

#define RDD_BRIDGE_CFG_HIT_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 7, 1, (r))
#define RDD_BRIDGE_CFG_HIT_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 7, 1, (v))
#define RDD_BRIDGE_CFG_HIT_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_BRIDGE_CFG_HIT_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 6, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 6, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_FW_FAILED_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 5, 1, (r))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT), 5, 1, (v))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_BRIDGE_CFG_VLAN_AGGREGATION_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 1, 0, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 1, 0, 1, (v))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_BRIDGE_CFG_BRIDGE_RESULTS_AVAILABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
#define RDD_BRIDGE_CFG_RES_OFFSET_READ_G(r, g, idx)                        GROUP_MREAD_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 2, (r))
#define RDD_BRIDGE_CFG_RES_OFFSET_WRITE_G(v, g, idx)                       GROUP_MWRITE_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 2, (v))
#define RDD_BRIDGE_CFG_RES_OFFSET_READ(r, p)                               MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_BRIDGE_CFG_RES_OFFSET_WRITE(v, p)                              MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 4, (r))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(BRIDGE_CFG_STRUCT) + 4, (v))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_READ(r, p)                           MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_BRIDGE_CFG_CONTEXT_OFFSET_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<BRIDGE_CFG_STRUCT */


#define RDD_BRIDGE_CFG_TABLE_SIZE     2
typedef struct
{
	BRIDGE_CFG_STRUCT	entry[ RDD_BRIDGE_CFG_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BRIDGE_CFG_TABLE_STRUCT;

extern uint32_t RDD_BRIDGE_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BRIDGE_CFG_TABLE_PTR(core_id)	( BRIDGE_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BRIDGE_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BRIDGE_CFG_TABLE */


/* >>>PROCESSING6_STACK */

#define RDD_PROCESSING6_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING6_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING6_STACK_STRUCT;

extern uint32_t RDD_PROCESSING6_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING6_STACK_PTR(core_id)	( PROCESSING6_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING6_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING6_STACK */


/* >>>REGISTERS_BUFFER */

#define RDD_REGISTERS_BUFFER_SIZE     32
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_REGISTERS_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REGISTERS_BUFFER_STRUCT;

extern uint32_t RDD_REGISTERS_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REGISTERS_BUFFER_PTR(core_id)	( REGISTERS_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REGISTERS_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<REGISTERS_BUFFER */


/* >>>SPDSVC_ANALYZER_UPDATE_FIFO_TABLE */

/* >>>UPDATE_FIFO_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pd_fifo_write_ptr	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	queue_number     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	queue_number     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pd_fifo_write_ptr	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) UPDATE_FIFO_ENTRY_STRUCT;

#define RDD_UPDATE_FIFO_ENTRY_VALID_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 7, 1, (r))
#define RDD_UPDATE_FIFO_ENTRY_VALID_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 7, 1, (v))
#define RDD_UPDATE_FIFO_ENTRY_VALID_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_UPDATE_FIFO_ENTRY_VALID_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 0, 14, (r))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT), 0, 14, (v))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 14, (r))
#define RDD_UPDATE_FIFO_ENTRY_PD_FIFO_WRITE_PTR_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 14, (v))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT) + 2, 0, 9, (r))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(UPDATE_FIFO_ENTRY_STRUCT) + 2, 0, 9, (v))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_UPDATE_FIFO_ENTRY_QUEUE_NUMBER_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
/* <<<UPDATE_FIFO_ENTRY_STRUCT */


#define RDD_SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_PTR(core_id)	( SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_ANALYZER_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_ANALYZER_UPDATE_FIFO_TABLE */


/* >>>CODEL_ENABLE_TABLE */

#define RDD_CODEL_ENABLE_TABLE_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CODEL_ENABLE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CODEL_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_CODEL_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CODEL_ENABLE_TABLE_PTR(core_id)	( CODEL_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CODEL_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CODEL_ENABLE_TABLE */


/* >>>TASK_IDX */

#define RDD_TASK_IDX_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TASK_IDX_STRUCT;

extern uint32_t RDD_TASK_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TASK_IDX_PTR(core_id)	( TASK_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TASK_IDX_ADDRESS_ARR[core_id] ))

/* <<<TASK_IDX */


/* >>>TUNNELS_PARSING_CFG */

/* >>>TUNNELS_PARSING_CFG_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved0       	;
        uint8_t	tunneling_enable	;
        uint16_t	res_offset      	;
        uint32_t	reserved1       	;
#else
        uint16_t	res_offset      	;
        uint8_t	tunneling_enable	;
        uint8_t	reserved0       	;
        uint32_t	reserved1       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TUNNELS_PARSING_CFG_STRUCT;

#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 1, (r))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 1, (v))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_L_READ( wv )               FIELD_GET( wv, 16, 8 )
#define RDD_TUNNELS_PARSING_CFG_TUNNELING_ENABLE_L_WRITE( v, wv )           FIELD_SET( v, 16, 8, wv )
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 2, (r))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(TUNNELS_PARSING_CFG_STRUCT) + 2, (v))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_READ(r, p)                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_L_READ( wv )                     FIELD_GET( wv, 0, 16 )
#define RDD_TUNNELS_PARSING_CFG_RES_OFFSET_L_WRITE( v, wv )                 FIELD_SET( v, 0, 16, wv )
/* <<<TUNNELS_PARSING_CFG_STRUCT */


#define RDD_TUNNELS_PARSING_CFG_SIZE     1
typedef struct
{
	TUNNELS_PARSING_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TUNNELS_PARSING_CFG_TABLE_STRUCT;

extern uint32_t RDD_TUNNELS_PARSING_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TUNNELS_PARSING_CFG_PTR(core_id)	( TUNNELS_PARSING_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TUNNELS_PARSING_CFG_ADDRESS_ARR[core_id] ))

/* <<<TUNNELS_PARSING_CFG */


/* >>>PROCESSING7_STACK */

#define RDD_PROCESSING7_STACK_SIZE     320
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_PROCESSING7_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING7_STACK_STRUCT;

extern uint32_t RDD_PROCESSING7_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING7_STACK_PTR(core_id)	( PROCESSING7_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING7_STACK_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING7_STACK */


/* >>>DHD_FPM_REPLY */

#define RDD_DHD_FPM_REPLY_SIZE     24
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_FPM_REPLY_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_FPM_REPLY_STRUCT;

extern uint32_t RDD_DHD_FPM_REPLY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_FPM_REPLY_PTR(core_id)	( DHD_FPM_REPLY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_FPM_REPLY_ADDRESS_ARR[core_id] ))

/* <<<DHD_FPM_REPLY */


/* >>>IPTV_CFG_TABLE */

/* >>>IPTV_CFG_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset    	;
        uint16_t	context_offset	;
        uint16_t	key_offset    	;
        uint8_t	hash_tbl_idx  	;
        uint8_t	l2_mcast      	;
#else
        uint16_t	context_offset	;
        uint16_t	res_offset    	;
        uint8_t	l2_mcast      	;
        uint8_t	hash_tbl_idx  	;
        uint16_t	key_offset    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_CFG_STRUCT;

#define RDD_IPTV_CFG_RES_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (r))
#define RDD_IPTV_CFG_RES_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT), (v))
#define RDD_IPTV_CFG_RES_OFFSET_READ(r, p)                     MREAD_16((uint8_t *)(p), (r))
#define RDD_IPTV_CFG_RES_OFFSET_WRITE(v, p)                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (r))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 2, (v))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_IPTV_CFG_CONTEXT_OFFSET_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_IPTV_CFG_KEY_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (r))
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 4, (v))
#define RDD_IPTV_CFG_KEY_OFFSET_READ(r, p)                     MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_CFG_KEY_OFFSET_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (r))
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 6, (v))
#define RDD_IPTV_CFG_HASH_TBL_IDX_READ(r, p)                   MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_CFG_HASH_TBL_IDX_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_CFG_L2_MCAST_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (r))
#define RDD_IPTV_CFG_L2_MCAST_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_CFG_STRUCT) + 7, (v))
#define RDD_IPTV_CFG_L2_MCAST_READ(r, p)                       MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_IPTV_CFG_L2_MCAST_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<IPTV_CFG_STRUCT */


#define RDD_IPTV_CFG_TABLE_SIZE     1
typedef struct
{
	IPTV_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_CFG_TABLE_STRUCT;

extern uint32_t RDD_IPTV_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_CFG_TABLE_PTR(core_id)	( IPTV_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPTV_CFG_TABLE */


/* >>>INGRESS_FILTER_L2_REASON_TABLE */

#define RDD_INGRESS_FILTER_L2_REASON_TABLE_SIZE     16
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_INGRESS_FILTER_L2_REASON_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_L2_REASON_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_L2_REASON_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_L2_REASON_TABLE_PTR(core_id)	( INGRESS_FILTER_L2_REASON_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_L2_REASON_TABLE_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_L2_REASON_TABLE */


/* >>>SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE */

#define RDD_SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_ANALYZER_DISPATCHER_CREDIT_TABLE */


/* >>>ENABLE_VPORT_MASK */

#define RDD_ENABLE_VPORT_MASK_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ ENABLE_VPORT_MASK_STRUCT;

extern uint32_t RDD_ENABLE_VPORT_MASK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_ENABLE_VPORT_MASK_PTR(core_id)	( ENABLE_VPORT_MASK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_ENABLE_VPORT_MASK_ADDRESS_ARR[core_id] ))

/* <<<ENABLE_VPORT_MASK */


/* >>>DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE */

/* >>>CPU_RING_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	size_of_entry    	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	number_of_entries	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	interrupt_id     	;
        uint16_t	drop_counter     	;
        uint16_t	write_idx        	;
        uint32_t	base_addr_low    	;
        uint16_t	read_idx         	;
        uint8_t	reserved0        	;
        uint8_t	base_addr_high   	;
#else
        uint16_t	interrupt_id     	;
        uint32_t	number_of_entries	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	size_of_entry    	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	write_idx        	;
        uint16_t	drop_counter     	;
        uint32_t	base_addr_low    	;
        uint8_t	base_addr_high   	;
        uint8_t	reserved0        	;
        uint16_t	read_idx         	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_RING_DESCRIPTOR_STRUCT;

#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 3, 5, (r))
#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 3, 5, (v))
#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 3, 5, (r))
#define RDD_CPU_RING_DESCRIPTOR_SIZE_OF_ENTRY_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 3, 5, (v))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 0, 11, (r))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT), 0, 11, (v))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 11, (r))
#define RDD_CPU_RING_DESCRIPTOR_NUMBER_OF_ENTRIES_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 11, (v))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_READ(r, p)                      MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RING_DESCRIPTOR_INTERRUPT_ID_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_READ(r, p)                      MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RING_DESCRIPTOR_DROP_COUNTER_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_READ(r, p)                         MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RING_DESCRIPTOR_WRITE_IDX_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_READ(r, p)                     MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_LOW_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_READ(r, p)                          MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_CPU_RING_DESCRIPTOR_READ_IDX_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 15, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RING_DESCRIPTOR_STRUCT) + 15, (v))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_READ(r, p)                    MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_CPU_RING_DESCRIPTOR_BASE_ADDR_HIGH_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 15, (v))
/* <<<CPU_RING_DESCRIPTOR_STRUCT */


#define RDD_DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_SIZE     3
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry[ RDD_DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_PTR(core_id)	( DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE */


/* >>>IPTV_CONFIGURATION_TABLE */

/* >>>HW_IPTV_CONFIGURATION_STRUCT */
typedef union
{
    uint32_t word_32[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	fpm_base_token_size 	;
        uint32_t	reserved0           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn_size1            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn_size0            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset0     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset1     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_pool1_stat2_addr	;
#else
        uint32_t	hn_size0            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hn_size1            	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	fpm_base_token_size 	;
        uint32_t	ddr_sop_offset1     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ddr_sop_offset0     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2           	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_pool1_stat2_addr	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) HW_IPTV_CONFIGURATION_STRUCT;

#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT), (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT), (v))
#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_BASE_TOKEN_SIZE_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 2, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 2, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE1_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 3, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 3, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 7, (r))
#define RDD_HW_IPTV_CONFIGURATION_HN_SIZE0_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 7, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 4, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 4, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 4, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET0_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 4, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 6, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 6, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 11, (r))
#define RDD_HW_IPTV_CONFIGURATION_DDR_SOP_OFFSET1_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 11, (v))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 8, (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(HW_IPTV_CONFIGURATION_STRUCT) + 8, (v))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_READ(r, p)                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_HW_IPTV_CONFIGURATION_FPM_POOL1_STAT2_ADDR_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 8, (v))
/* <<<HW_IPTV_CONFIGURATION_STRUCT */


#define RDD_IPTV_CONFIGURATION_TABLE_SIZE     1
typedef struct
{
	HW_IPTV_CONFIGURATION_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_CONFIGURATION_TABLE_STRUCT;

extern uint32_t RDD_IPTV_CONFIGURATION_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_CONFIGURATION_TABLE_PTR(core_id)	( IPTV_CONFIGURATION_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_CONFIGURATION_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPTV_CONFIGURATION_TABLE */


/* >>>LOOPBACK_WAN_FLOW_TABLE */

#define RDD_LOOPBACK_WAN_FLOW_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ LOOPBACK_WAN_FLOW_TABLE_STRUCT;

extern uint32_t RDD_LOOPBACK_WAN_FLOW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_LOOPBACK_WAN_FLOW_TABLE_PTR(core_id)	( LOOPBACK_WAN_FLOW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_LOOPBACK_WAN_FLOW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<LOOPBACK_WAN_FLOW_TABLE */


/* >>>FORCE_DSCP */

#define RDD_FORCE_DSCP_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ FORCE_DSCP_STRUCT;

extern uint32_t RDD_FORCE_DSCP_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FORCE_DSCP_PTR(core_id)	( FORCE_DSCP_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FORCE_DSCP_ADDRESS_ARR[core_id] ))

/* <<<FORCE_DSCP */


/* >>>CORE_ID_TABLE */

#define RDD_CORE_ID_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CORE_ID_TABLE_STRUCT;

extern uint32_t RDD_CORE_ID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CORE_ID_TABLE_PTR(core_id)	( CORE_ID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CORE_ID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CORE_ID_TABLE */


/* >>>CPU_REDIRECT_MODE */

/* >>>CPU_REDIRECT_MODE_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	mode      	;
#else
        uint8_t	mode      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} CPU_REDIRECT_MODE_ENTRY_STRUCT;

#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<CPU_REDIRECT_MODE_ENTRY_STRUCT */


#define RDD_CPU_REDIRECT_MODE_SIZE     1
typedef struct
{
	CPU_REDIRECT_MODE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_REDIRECT_MODE_STRUCT;

extern uint32_t RDD_CPU_REDIRECT_MODE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_REDIRECT_MODE_PTR(core_id)	( CPU_REDIRECT_MODE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_REDIRECT_MODE_ADDRESS_ARR[core_id] ))

/* <<<CPU_REDIRECT_MODE */


/* >>>BITS_CALC_MASKS_TABLE */

#define RDD_BITS_CALC_MASKS_TABLE_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_BITS_CALC_MASKS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BITS_CALC_MASKS_TABLE_STRUCT;

extern uint32_t RDD_BITS_CALC_MASKS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BITS_CALC_MASKS_TABLE_PTR(core_id)	( BITS_CALC_MASKS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BITS_CALC_MASKS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BITS_CALC_MASKS_TABLE */


/* >>>DHD_FPM_THRESHOLDS */

#define RDD_DHD_FPM_THRESHOLDS_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DHD_FPM_THRESHOLDS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_FPM_THRESHOLDS_STRUCT;

extern uint32_t RDD_DHD_FPM_THRESHOLDS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_FPM_THRESHOLDS_PTR(core_id)	( DHD_FPM_THRESHOLDS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_FPM_THRESHOLDS_ADDRESS_ARR[core_id] ))

/* <<<DHD_FPM_THRESHOLDS */


/* >>>DHD_RX_POST_RING_SIZE */

/* >>>DHD_RING_SIZE_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	value     	;
#else
        uint16_t	value     	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) DHD_RING_SIZE_STRUCT;

#define RDD_DHD_RING_SIZE_VALUE_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(DHD_RING_SIZE_STRUCT), (r))
#define RDD_DHD_RING_SIZE_VALUE_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(DHD_RING_SIZE_STRUCT), (v))
#define RDD_DHD_RING_SIZE_VALUE_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_DHD_RING_SIZE_VALUE_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<DHD_RING_SIZE_STRUCT */


#define RDD_DHD_RX_POST_RING_SIZE_SIZE     1
typedef struct
{
	DHD_RING_SIZE_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_POST_RING_SIZE_STRUCT;

extern uint32_t RDD_DHD_RX_POST_RING_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_POST_RING_SIZE_PTR(core_id)	( DHD_RX_POST_RING_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_POST_RING_SIZE_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_POST_RING_SIZE */


/* >>>DHD_RX_COMPLETE_RING_SIZE */

#define RDD_DHD_RX_COMPLETE_RING_SIZE_SIZE     1
typedef struct
{
	DHD_RING_SIZE_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_RX_COMPLETE_RING_SIZE_STRUCT;

extern uint32_t RDD_DHD_RX_COMPLETE_RING_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_RX_COMPLETE_RING_SIZE_PTR(core_id)	( DHD_RX_COMPLETE_RING_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_RX_COMPLETE_RING_SIZE_ADDRESS_ARR[core_id] ))

/* <<<DHD_RX_COMPLETE_RING_SIZE */


/* >>>DHD_DOORBELL_TX_COMPLETE_VALUE */

/* >>>DHD_DOORBELL_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	doorbell_value	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	value                  	; /* Member of doorbell_value union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	dma_type               	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of doorbell_value union */
        uint32_t	frg_id                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of doorbell_value union */
        uint8_t	reg_index_num          	; /* Member of doorbell_value union */
        uint16_t	index_val              	; /* Member of doorbell_value union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	doorbell_value	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	value                  	; /* Member of doorbell_value union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	index_val              	; /* Member of doorbell_value union */
        uint8_t	reg_index_num          	; /* Member of doorbell_value union */
        uint32_t	frg_id                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of doorbell_value union */
        uint32_t	dma_type               	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of doorbell_value union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) DHD_DOORBELL_STRUCT;

#define RDD_DHD_DOORBELL_DOORBELL_VALUE_READ_G(r, g, idx)         GROUP_MREAD_32((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), (r))
#define RDD_DHD_DOORBELL_DOORBELL_VALUE_WRITE_G(v, g, idx)        GROUP_MWRITE_32((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), (v))
#define RDD_DHD_DOORBELL_DOORBELL_VALUE_READ(r, p)                MREAD_32((uint8_t *)(p), (r))
#define RDD_DHD_DOORBELL_DOORBELL_VALUE_WRITE(v, p)               MWRITE_32((uint8_t *)(p), (v))
#define RDD_DHD_DOORBELL_DOORBELL_VALUE_L_READ( wv )              FIELD_GET( wv, 0, 32 )
#define RDD_DHD_DOORBELL_DOORBELL_VALUE_L_WRITE( v, wv )          FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_DOORBELL_VALUE_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), (r))
#define RDD_DHD_DOORBELL_VALUE_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), (v))
#define RDD_DHD_DOORBELL_VALUE_READ(r, p)                         MREAD_32((uint8_t *)(p), (r))
#define RDD_DHD_DOORBELL_VALUE_WRITE(v, p)                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_DHD_DOORBELL_VALUE_L_READ( wv )                       FIELD_GET( wv, 0, 32 )
#define RDD_DHD_DOORBELL_VALUE_L_WRITE( v, wv )                   FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_DOORBELL_DMA_TYPE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), 4, 4, (r))
#define RDD_DHD_DOORBELL_DMA_TYPE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), 4, 4, (v))
#define RDD_DHD_DOORBELL_DMA_TYPE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 4, 4, (r))
#define RDD_DHD_DOORBELL_DMA_TYPE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 4, 4, (v))
#define RDD_DHD_DOORBELL_DMA_TYPE_L_READ( wv )                    FIELD_GET( wv, 28, 4 )
#define RDD_DHD_DOORBELL_DMA_TYPE_L_WRITE( v, wv )                FIELD_SET( v, 28, 4, wv )
#define RDD_DHD_DOORBELL_FRG_ID_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), 0, 4, (r))
#define RDD_DHD_DOORBELL_FRG_ID_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_DOORBELL_STRUCT), 0, 4, (v))
#define RDD_DHD_DOORBELL_FRG_ID_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 0, 4, (r))
#define RDD_DHD_DOORBELL_FRG_ID_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 0, 4, (v))
#define RDD_DHD_DOORBELL_FRG_ID_L_READ( wv )                      FIELD_GET( wv, 24, 4 )
#define RDD_DHD_DOORBELL_FRG_ID_L_WRITE( v, wv )                  FIELD_SET( v, 24, 4, wv )
#define RDD_DHD_DOORBELL_REG_INDEX_NUM_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(DHD_DOORBELL_STRUCT) + 1, (r))
#define RDD_DHD_DOORBELL_REG_INDEX_NUM_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_DOORBELL_STRUCT) + 1, (v))
#define RDD_DHD_DOORBELL_REG_INDEX_NUM_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_DHD_DOORBELL_REG_INDEX_NUM_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_DHD_DOORBELL_REG_INDEX_NUM_L_READ( wv )               FIELD_GET( wv, 16, 8 )
#define RDD_DHD_DOORBELL_REG_INDEX_NUM_L_WRITE( v, wv )           FIELD_SET( v, 16, 8, wv )
#define RDD_DHD_DOORBELL_INDEX_VAL_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(DHD_DOORBELL_STRUCT) + 2, (r))
#define RDD_DHD_DOORBELL_INDEX_VAL_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(DHD_DOORBELL_STRUCT) + 2, (v))
#define RDD_DHD_DOORBELL_INDEX_VAL_READ(r, p)                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_DHD_DOORBELL_INDEX_VAL_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_DHD_DOORBELL_INDEX_VAL_L_READ( wv )                   FIELD_GET( wv, 0, 16 )
#define RDD_DHD_DOORBELL_INDEX_VAL_L_WRITE( v, wv )               FIELD_SET( v, 0, 16, wv )
/* <<<DHD_DOORBELL_STRUCT */


#define RDD_DHD_DOORBELL_TX_COMPLETE_VALUE_SIZE     3
typedef struct
{
	DHD_DOORBELL_STRUCT	entry[ RDD_DHD_DOORBELL_TX_COMPLETE_VALUE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_DOORBELL_TX_COMPLETE_VALUE_STRUCT;

extern uint32_t RDD_DHD_DOORBELL_TX_COMPLETE_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_DOORBELL_TX_COMPLETE_VALUE_PTR(core_id)	( DHD_DOORBELL_TX_COMPLETE_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_DOORBELL_TX_COMPLETE_VALUE_ADDRESS_ARR[core_id] ))

/* <<<DHD_DOORBELL_TX_COMPLETE_VALUE */


/* >>>DHD_TX_COMPLETE_RING_SIZE */

#define RDD_DHD_TX_COMPLETE_RING_SIZE_SIZE     1
typedef struct
{
	DHD_RING_SIZE_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_COMPLETE_RING_SIZE_STRUCT;

extern uint32_t RDD_DHD_TX_COMPLETE_RING_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_COMPLETE_RING_SIZE_PTR(core_id)	( DHD_TX_COMPLETE_RING_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_COMPLETE_RING_SIZE_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_COMPLETE_RING_SIZE */


/* >>>RX_MIRRORING_CONFIGURATION */

/* >>>MIRRORING_DESCRIPTOR_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	mirror_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_vport 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_queue 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	dst_queue 	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	dst_vport 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	mirror_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) MIRRORING_DESCRIPTOR_STRUCT;

#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_MIRRORING_DESCRIPTOR_MIRROR_EN_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 1, 6, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 1, 6, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_VPORT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 1, 6, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(MIRRORING_DESCRIPTOR_STRUCT), 0, 9, (v))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 9, (r))
#define RDD_MIRRORING_DESCRIPTOR_DST_QUEUE_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 9, (v))
/* <<<MIRRORING_DESCRIPTOR_STRUCT */


#define RDD_RX_MIRRORING_CONFIGURATION_SIZE     1
typedef struct
{
	MIRRORING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_MIRRORING_CONFIGURATION_STRUCT;

extern uint32_t RDD_RX_MIRRORING_CONFIGURATION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_MIRRORING_CONFIGURATION_PTR(core_id)	( RX_MIRRORING_CONFIGURATION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_MIRRORING_CONFIGURATION_ADDRESS_ARR[core_id] ))

/* <<<RX_MIRRORING_CONFIGURATION */


/* >>>DHD_DOORBELL_RX_COMPLETE_VALUE */

#define RDD_DHD_DOORBELL_RX_COMPLETE_VALUE_SIZE     3
typedef struct
{
	DHD_DOORBELL_STRUCT	entry[ RDD_DHD_DOORBELL_RX_COMPLETE_VALUE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_DOORBELL_RX_COMPLETE_VALUE_STRUCT;

extern uint32_t RDD_DHD_DOORBELL_RX_COMPLETE_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_DOORBELL_RX_COMPLETE_VALUE_PTR(core_id)	( DHD_DOORBELL_RX_COMPLETE_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_DOORBELL_RX_COMPLETE_VALUE_ADDRESS_ARR[core_id] ))

/* <<<DHD_DOORBELL_RX_COMPLETE_VALUE */


/* >>>DEBUG_PRINT_CORE_LOCK */

#define RDD_DEBUG_PRINT_CORE_LOCK_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEBUG_PRINT_CORE_LOCK_STRUCT;

extern uint32_t RDD_DEBUG_PRINT_CORE_LOCK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEBUG_PRINT_CORE_LOCK_PTR(core_id)	( DEBUG_PRINT_CORE_LOCK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEBUG_PRINT_CORE_LOCK_ADDRESS_ARR[core_id] ))

/* <<<DEBUG_PRINT_CORE_LOCK */


/* >>>SRAM_DUMMY_STORE */

#define RDD_SRAM_DUMMY_STORE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SRAM_DUMMY_STORE_STRUCT;

extern uint32_t RDD_SRAM_DUMMY_STORE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SRAM_DUMMY_STORE_PTR(core_id)	( SRAM_DUMMY_STORE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SRAM_DUMMY_STORE_ADDRESS_ARR[core_id] ))

/* <<<SRAM_DUMMY_STORE */


/* >>>RATE_LIMIT_OVERHEAD */

#define RDD_RATE_LIMIT_OVERHEAD_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RATE_LIMIT_OVERHEAD_STRUCT;

extern uint32_t RDD_RATE_LIMIT_OVERHEAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RATE_LIMIT_OVERHEAD_PTR(core_id)	( RATE_LIMIT_OVERHEAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RATE_LIMIT_OVERHEAD_ADDRESS_ARR[core_id] ))

/* <<<RATE_LIMIT_OVERHEAD */


/* >>>IPTV_CLASSIFICATION_CFG_TABLE */

/* >>>IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	da_prefix_mode_mac	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_ip 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	reserved1         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_ip 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	da_prefix_mode_mac	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT;

#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_MAC_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_DA_PREFIX_MODE_IP_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_IPTV_CLASSIFICATION_CFG_ENTRY_IPTV_EN_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
/* <<<IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT */


#define RDD_IPTV_CLASSIFICATION_CFG_TABLE_SIZE     1
typedef struct
{
	IPTV_CLASSIFICATION_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_CLASSIFICATION_CFG_TABLE_STRUCT;

extern uint32_t RDD_IPTV_CLASSIFICATION_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_CLASSIFICATION_CFG_TABLE_PTR(core_id)	( IPTV_CLASSIFICATION_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_CLASSIFICATION_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPTV_CLASSIFICATION_CFG_TABLE */


/* >>>TX_FLOW_TABLE */

/* >>>TX_FLOW_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	qos_table_ptr	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	qos_table_ptr	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	valid        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TX_FLOW_ENTRY_STRUCT;

#define RDD_TX_FLOW_ENTRY_VALID_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 7, 1, (r))
#define RDD_TX_FLOW_ENTRY_VALID_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 7, 1, (v))
#define RDD_TX_FLOW_ENTRY_VALID_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_TX_FLOW_ENTRY_VALID_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 0, 5, (r))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_FLOW_ENTRY_STRUCT), 0, 5, (v))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 5, (r))
#define RDD_TX_FLOW_ENTRY_QOS_TABLE_PTR_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 5, (v))
/* <<<TX_FLOW_ENTRY_STRUCT */


#define RDD_TX_FLOW_TABLE_SIZE     212
typedef struct
{
	TX_FLOW_ENTRY_STRUCT	entry[ RDD_TX_FLOW_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_FLOW_TABLE_STRUCT;

extern uint32_t RDD_TX_FLOW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_FLOW_TABLE_PTR(core_id)	( TX_FLOW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_FLOW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TX_FLOW_TABLE */


/* >>>INGRESS_FILTER_1588_CFG */

#define RDD_INGRESS_FILTER_1588_CFG_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_1588_CFG_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_1588_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_1588_CFG_PTR(core_id)	( INGRESS_FILTER_1588_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_1588_CFG_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_1588_CFG */


/* >>>RX_MIRRORING_DIRECT_ENABLE */

#define RDD_RX_MIRRORING_DIRECT_ENABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ RX_MIRRORING_DIRECT_ENABLE_STRUCT;

extern uint32_t RDD_RX_MIRRORING_DIRECT_ENABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RX_MIRRORING_DIRECT_ENABLE_PTR(core_id)	( RX_MIRRORING_DIRECT_ENABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RX_MIRRORING_DIRECT_ENABLE_ADDRESS_ARR[core_id] ))

/* <<<RX_MIRRORING_DIRECT_ENABLE */


/* >>>IPTV_DDR_CTX_TABLE_ADDRESS */

/* >>>IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	low       	;
        uint32_t	high      	;
#else
        uint32_t	low       	;
        uint32_t	high      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT;

#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT), (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT), (v))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT) + 4, (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT) + 4, (v))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT */


#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_SIZE     1
typedef struct
{
	IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPTV_DDR_CTX_TABLE_ADDRESS_TABLE_STRUCT;

extern uint32_t RDD_IPTV_DDR_CTX_TABLE_ADDRESS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPTV_DDR_CTX_TABLE_ADDRESS_PTR(core_id)	( IPTV_DDR_CTX_TABLE_ADDRESS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPTV_DDR_CTX_TABLE_ADDRESS_ADDRESS_ARR[core_id] ))

/* <<<IPTV_DDR_CTX_TABLE_ADDRESS */


/* >>>DHD_DOORBELL_RX_POST_VALUE */

#define RDD_DHD_DOORBELL_RX_POST_VALUE_SIZE     3
typedef struct
{
	DHD_DOORBELL_STRUCT	entry[ RDD_DHD_DOORBELL_RX_POST_VALUE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_DOORBELL_RX_POST_VALUE_STRUCT;

extern uint32_t RDD_DHD_DOORBELL_RX_POST_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_DOORBELL_RX_POST_VALUE_PTR(core_id)	( DHD_DOORBELL_RX_POST_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_DOORBELL_RX_POST_VALUE_ADDRESS_ARR[core_id] ))

/* <<<DHD_DOORBELL_RX_POST_VALUE */


/* >>>DHD_CPU_INT_ID */

#define RDD_DHD_CPU_INT_ID_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DHD_CPU_INT_ID_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_CPU_INT_ID_STRUCT;

extern uint32_t RDD_DHD_CPU_INT_ID_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_CPU_INT_ID_PTR(core_id)	( DHD_CPU_INT_ID_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_CPU_INT_ID_ADDRESS_ARR[core_id] ))

/* <<<DHD_CPU_INT_ID */


/* >>>INGRESS_FILTER_PROFILE_TABLE */

/* >>>INGRESS_FILTER_CTRL_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_bypass   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	action_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	enable_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	action_vector	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_bypass   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) INGRESS_FILTER_CTRL_STRUCT;

#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT), 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT), 0, 31, (v))
#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p), 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ENABLE_VECTOR_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p), 0, 31, (v))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 7, 1, (r))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 7, 1, (v))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_INGRESS_FILTER_CTRL_CPU_BYPASS_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(INGRESS_FILTER_CTRL_STRUCT) + 4, 0, 31, (v))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p) + 4, 0, 31, (r))
#define RDD_INGRESS_FILTER_CTRL_ACTION_VECTOR_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p) + 4, 0, 31, (v))
/* <<<INGRESS_FILTER_CTRL_STRUCT */


#define RDD_INGRESS_FILTER_PROFILE_TABLE_SIZE     16
typedef struct
{
	INGRESS_FILTER_CTRL_STRUCT	entry[ RDD_INGRESS_FILTER_PROFILE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_PROFILE_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_PROFILE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_PROFILE_TABLE_PTR(core_id)	( INGRESS_FILTER_PROFILE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_PROFILE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_PROFILE_TABLE */


/* >>>SPDSVC_WLAN_GEN_PARAMS_TABLE */

/* >>>SPDSVC_WLAN_GEN_PARAMS_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	complete_tracked	;
        uint32_t	tx_copies       	;
        uint16_t	spdsvc_free_idx 	;
#else
        uint32_t	complete_tracked	;
        uint32_t	tx_copies       	;
        uint16_t	spdsvc_free_idx 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) SPDSVC_WLAN_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ_G(r, g, idx)                 GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE_G(v, g, idx)                GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ(r, p)                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE(v, p)                       MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ(r, p)                  MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 8, (v))
/* <<<SPDSVC_WLAN_GEN_PARAMS_STRUCT */


#define RDD_SPDSVC_WLAN_GEN_PARAMS_TABLE_SIZE     1
typedef struct
{
	SPDSVC_WLAN_GEN_PARAMS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_WLAN_GEN_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_WLAN_GEN_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_WLAN_GEN_PARAMS_TABLE_PTR(core_id)	( SPDSVC_WLAN_GEN_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_WLAN_GEN_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_WLAN_GEN_PARAMS_TABLE */


/* >>>CPU_FEED_RING_DESCRIPTOR_TABLE */

#define RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_SIZE     1
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_PTR(core_id)	( CPU_FEED_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_DESCRIPTOR_TABLE */


/* >>>UDPSPDT_SCRATCH_TABLE */

/* >>>UDPSPDT_SCRATCH_IPERF3_RX_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_packets_0	;
        uint32_t	rx_packets_1	;
#else
        uint32_t	rx_packets_0	;
        uint32_t	rx_packets_1	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) UDPSPDT_SCRATCH_IPERF3_RX_STRUCT;

#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT), (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT), (v))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_0_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT) + 4, (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_SCRATCH_IPERF3_RX_STRUCT) + 4, (v))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_SCRATCH_IPERF3_RX_RX_PACKETS_1_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<UDPSPDT_SCRATCH_IPERF3_RX_STRUCT */


#define RDD_UDPSPDT_SCRATCH_TABLE_SIZE     1
typedef struct
{
	UDPSPDT_SCRATCH_IPERF3_RX_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ UDPSPDT_SCRATCH_TABLE_STRUCT;

extern uint32_t RDD_UDPSPDT_SCRATCH_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_UDPSPDT_SCRATCH_TABLE_PTR(core_id)	( UDPSPDT_SCRATCH_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_UDPSPDT_SCRATCH_TABLE_ADDRESS_ARR[core_id] ))

/* <<<UDPSPDT_SCRATCH_TABLE */


/* >>>NAT_CACHE_CFG */

/* >>>NAT_CACHE_CFG_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset        	;
        uint16_t	context_offset    	;
        uint16_t	key_offset        	;
        uint32_t	reserved          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	three_tuple_enable	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	esp_filter_action 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	esp_filter_enable 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	context_offset    	;
        uint16_t	res_offset        	;
        uint32_t	esp_filter_enable 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	esp_filter_action 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	three_tuple_enable	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	key_offset        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} NAT_CACHE_CFG_STRUCT;

#define RDD_NAT_CACHE_CFG_RES_OFFSET_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT), (r))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT), (v))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_READ(r, p)                         MREAD_16((uint8_t *)(p), (r))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_WRITE(v, p)                        MWRITE_16((uint8_t *)(p), (v))
#define RDD_NAT_CACHE_CFG_RES_OFFSET_L_READ( wv )                       FIELD_GET( wv, 16, 16 )
#define RDD_NAT_CACHE_CFG_RES_OFFSET_L_WRITE( v, wv )                   FIELD_SET( v, 16, 16, wv )
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 2, (r))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 2, (v))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_READ(r, p)                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_L_READ( wv )                   FIELD_GET( wv, 0, 16 )
#define RDD_NAT_CACHE_CFG_CONTEXT_OFFSET_L_WRITE( v, wv )               FIELD_SET( v, 0, 16, wv )
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_READ_G(r, g, idx)                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_WRITE_G(v, g, idx)                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_READ(r, p)                         MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_WRITE(v, p)                        MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_L_READ( wv )                       FIELD_GET( wv, 16, 16 )
#define RDD_NAT_CACHE_CFG_KEY_OFFSET_L_WRITE( v, wv )                   FIELD_SET( v, 16, 16, wv )
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 2, 1, (r))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 2, 1, (v))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 6, 2, 1, (r))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 6, 2, 1, (v))
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_L_READ( wv )               FIELD_GET( wv, 10, 1 )
#define RDD_NAT_CACHE_CFG_THREE_TUPLE_ENABLE_L_WRITE( v, wv )           FIELD_SET( v, 10, 1, wv )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 1, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 1, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_L_READ( wv )                FIELD_GET( wv, 9, 1 )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ACTION_L_WRITE( v, wv )            FIELD_SET( v, 9, 1, wv )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 0, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_CFG_STRUCT) + 6, 0, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 1, (r))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 1, (v))
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_L_READ( wv )                FIELD_GET( wv, 8, 1 )
#define RDD_NAT_CACHE_CFG_ESP_FILTER_ENABLE_L_WRITE( v, wv )            FIELD_SET( v, 8, 1, wv )
/* <<<NAT_CACHE_CFG_STRUCT */


#define RDD_NAT_CACHE_CFG_SIZE     1
typedef struct
{
	NAT_CACHE_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ NAT_CACHE_CFG_TABLE_STRUCT;

extern uint32_t RDD_NAT_CACHE_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NAT_CACHE_CFG_PTR(core_id)	( NAT_CACHE_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NAT_CACHE_CFG_ADDRESS_ARR[core_id] ))

/* <<<NAT_CACHE_CFG */


/* >>>DEBUG_PRINT_TABLE */

/* >>>DEBUG_PRINT_INFO_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	addr_low  	;
        uint32_t	addr_high 	;
        uint32_t	size      	;
        uint8_t	table_id  	;
        uint32_t	reserved  	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	addr_low  	;
        uint32_t	addr_high 	;
        uint32_t	size      	;
        uint32_t	reserved  	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	table_id  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DEBUG_PRINT_INFO_STRUCT;

#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT), (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_L_READ( wv )                FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_ADDR_LOW_L_WRITE( v, wv )            FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 4, (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_L_READ( wv )               FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_ADDR_HIGH_L_WRITE( v, wv )           FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_SIZE_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (r))
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 8, (v))
#define RDD_DEBUG_PRINT_INFO_SIZE_READ(r, p)                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_DEBUG_PRINT_INFO_SIZE_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_DEBUG_PRINT_INFO_SIZE_L_READ( wv )                    FIELD_GET( wv, 0, 32 )
#define RDD_DEBUG_PRINT_INFO_SIZE_L_WRITE( v, wv )                FIELD_SET( v, 0, 32, wv )
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (r))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(DEBUG_PRINT_INFO_STRUCT) + 12, (v))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_READ(r, p)                  MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_WRITE(v, p)                 MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_L_READ( wv )                FIELD_GET( wv, 24, 8 )
#define RDD_DEBUG_PRINT_INFO_TABLE_ID_L_WRITE( v, wv )            FIELD_SET( v, 24, 8, wv )
/* <<<DEBUG_PRINT_INFO_STRUCT */


#define RDD_DEBUG_PRINT_TABLE_SIZE     1
typedef struct
{
	DEBUG_PRINT_INFO_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DEBUG_PRINT_TABLE_STRUCT;

extern uint32_t RDD_DEBUG_PRINT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DEBUG_PRINT_TABLE_PTR(core_id)	( DEBUG_PRINT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DEBUG_PRINT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DEBUG_PRINT_TABLE */


/* >>>TCAM_GENERIC_FIELDS */

/* >>>TCAM_GENERIC_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	offset    	;
        uint16_t	reserved  	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	layer     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	layer     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved  	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	offset    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) TCAM_GENERIC_STRUCT;

#define RDD_TCAM_GENERIC_OFFSET_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(TCAM_GENERIC_STRUCT), (r))
#define RDD_TCAM_GENERIC_OFFSET_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(TCAM_GENERIC_STRUCT), (v))
#define RDD_TCAM_GENERIC_OFFSET_READ(r, p)                   MREAD_8((uint8_t *)(p), (r))
#define RDD_TCAM_GENERIC_OFFSET_WRITE(v, p)                  MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCAM_GENERIC_OFFSET_L_READ( wv )                 FIELD_GET( wv, 8, 8 )
#define RDD_TCAM_GENERIC_OFFSET_L_WRITE( v, wv )             FIELD_SET( v, 8, 8, wv )
#define RDD_TCAM_GENERIC_LAYER_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_GENERIC_STRUCT) + 1, 0, 2, (r))
#define RDD_TCAM_GENERIC_LAYER_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_GENERIC_STRUCT) + 1, 0, 2, (v))
#define RDD_TCAM_GENERIC_LAYER_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r))
#define RDD_TCAM_GENERIC_LAYER_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v))
#define RDD_TCAM_GENERIC_LAYER_L_READ( wv )                  FIELD_GET( wv, 0, 2 )
#define RDD_TCAM_GENERIC_LAYER_L_WRITE( v, wv )              FIELD_SET( v, 0, 2, wv )
/* <<<TCAM_GENERIC_STRUCT */


#define RDD_TCAM_GENERIC_FIELDS_SIZE     8
typedef struct
{
	TCAM_GENERIC_STRUCT	entry[ RDD_TCAM_GENERIC_FIELDS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCAM_GENERIC_FIELDS_STRUCT;

extern uint32_t RDD_TCAM_GENERIC_FIELDS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCAM_GENERIC_FIELDS_PTR(core_id)	( TCAM_GENERIC_FIELDS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCAM_GENERIC_FIELDS_ADDRESS_ARR[core_id] ))

/* <<<TCAM_GENERIC_FIELDS */


/* >>>FPM_GLOBAL_CFG */

/* >>>FPM_GLOBAL_CFG_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint16_t	fpm_token_size     	;
        uint8_t	fpm_token_shift    	;
        uint8_t	fpm_token_add_shift	;
        uint16_t	fpm_token_inv_mant 	;
        uint8_t	fpm_token_inv_exp  	;
        uint8_t	reserved1          	;
#else
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint8_t	fpm_token_add_shift	;
        uint8_t	fpm_token_shift    	;
        uint16_t	fpm_token_size     	;
        uint8_t	reserved1          	;
        uint8_t	fpm_token_inv_exp  	;
        uint16_t	fpm_token_inv_mant 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FPM_GLOBAL_CFG_STRUCT;

#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ_G(r, g, idx)                 GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE_G(v, g, idx)                GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ(r, p)                        MREAD_32((uint8_t *)(p), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE(v, p)                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ(r, p)                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ(r, p)                      MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ(r, p)                     MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ(r, p)                 MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ(r, p)                  MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ(r, p)                   MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 14, (v))
/* <<<FPM_GLOBAL_CFG_STRUCT */


#define RDD_FPM_GLOBAL_CFG_SIZE     1
typedef struct
{
	FPM_GLOBAL_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ FPM_GLOBAL_CFG_TABLE_STRUCT;

extern uint32_t RDD_FPM_GLOBAL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FPM_GLOBAL_CFG_PTR(core_id)	( FPM_GLOBAL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FPM_GLOBAL_CFG_ADDRESS_ARR[core_id] ))

/* <<<FPM_GLOBAL_CFG */


/* >>>MULTICAST_WHITELIST_CFG_TABLE */

/* >>>MULTICAST_WHITELIST_CFG_STRUCT */
typedef union
{
    uint32_t word_32[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset      	;
        uint16_t	context_offset  	;
        uint16_t	key_offset      	;
        uint8_t	natc_tbl_idx    	;
        uint8_t	ddr_ctx_tbl_high	;
        uint32_t	ddr_ctx_tbl_low 	;
#else
        uint16_t	context_offset  	;
        uint16_t	res_offset      	;
        uint8_t	ddr_ctx_tbl_high	;
        uint8_t	natc_tbl_idx    	;
        uint16_t	key_offset      	;
        uint32_t	ddr_ctx_tbl_low 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) MULTICAST_WHITELIST_CFG_STRUCT;

#define RDD_MULTICAST_WHITELIST_CFG_RES_OFFSET_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT), (r))
#define RDD_MULTICAST_WHITELIST_CFG_RES_OFFSET_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT), (v))
#define RDD_MULTICAST_WHITELIST_CFG_RES_OFFSET_READ(r, p)                       MREAD_16((uint8_t *)(p), (r))
#define RDD_MULTICAST_WHITELIST_CFG_RES_OFFSET_WRITE(v, p)                      MWRITE_16((uint8_t *)(p), (v))
#define RDD_MULTICAST_WHITELIST_CFG_CONTEXT_OFFSET_READ_G(r, g, idx)            GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 2, (r))
#define RDD_MULTICAST_WHITELIST_CFG_CONTEXT_OFFSET_WRITE_G(v, g, idx)           GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 2, (v))
#define RDD_MULTICAST_WHITELIST_CFG_CONTEXT_OFFSET_READ(r, p)                   MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_MULTICAST_WHITELIST_CFG_CONTEXT_OFFSET_WRITE(v, p)                  MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_MULTICAST_WHITELIST_CFG_KEY_OFFSET_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 4, (r))
#define RDD_MULTICAST_WHITELIST_CFG_KEY_OFFSET_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 4, (v))
#define RDD_MULTICAST_WHITELIST_CFG_KEY_OFFSET_READ(r, p)                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_MULTICAST_WHITELIST_CFG_KEY_OFFSET_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_MULTICAST_WHITELIST_CFG_NATC_TBL_IDX_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 6, (r))
#define RDD_MULTICAST_WHITELIST_CFG_NATC_TBL_IDX_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 6, (v))
#define RDD_MULTICAST_WHITELIST_CFG_NATC_TBL_IDX_READ(r, p)                     MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_MULTICAST_WHITELIST_CFG_NATC_TBL_IDX_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_HIGH_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 7, (r))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 7, (v))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_HIGH_READ(r, p)                 MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_HIGH_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 7, (v))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 8, (r))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(MULTICAST_WHITELIST_CFG_STRUCT) + 8, (v))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_MULTICAST_WHITELIST_CFG_DDR_CTX_TBL_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 8, (v))
/* <<<MULTICAST_WHITELIST_CFG_STRUCT */


#define RDD_MULTICAST_WHITELIST_CFG_TABLE_SIZE     1
typedef struct
{
	MULTICAST_WHITELIST_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MULTICAST_WHITELIST_CFG_TABLE_STRUCT;

extern uint32_t RDD_MULTICAST_WHITELIST_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MULTICAST_WHITELIST_CFG_TABLE_PTR(core_id)	( MULTICAST_WHITELIST_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MULTICAST_WHITELIST_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<MULTICAST_WHITELIST_CFG_TABLE */


/* >>>NAT_CACHE_KEY0_MASK */

#define RDD_NAT_CACHE_KEY0_MASK_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ NAT_CACHE_KEY0_MASK_STRUCT;

extern uint32_t RDD_NAT_CACHE_KEY0_MASK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NAT_CACHE_KEY0_MASK_PTR(core_id)	( NAT_CACHE_KEY0_MASK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NAT_CACHE_KEY0_MASK_ADDRESS_ARR[core_id] ))

/* <<<NAT_CACHE_KEY0_MASK */


/* >>>TCAM_TABLE_CFG_TABLE */

/* >>>TCAM_TABLE_CFG_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	all_fields   	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	generic_1              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_2              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_3              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_4              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	ingress_port           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	gem                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	network_layer          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	ssid                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	all_fields   	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	ssid                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	network_layer          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	gem                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	ingress_port           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_4              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_3              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_2              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
        uint8_t	generic_1              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of all_fields union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TCAM_TABLE_CFG_STRUCT;

#define RDD_TCAM_TABLE_CFG_ALL_FIELDS_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), (r))
#define RDD_TCAM_TABLE_CFG_ALL_FIELDS_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), (v))
#define RDD_TCAM_TABLE_CFG_ALL_FIELDS_READ(r, p)                    MREAD_8((uint8_t *)(p), (r))
#define RDD_TCAM_TABLE_CFG_ALL_FIELDS_WRITE(v, p)                   MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_1_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 7, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_1_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 7, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_1_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_1_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_2_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 6, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_2_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 6, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_2_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_2_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_3_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 5, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_3_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 5, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_3_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_3_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_4_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 4, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_4_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 4, 1, (v))
#define RDD_TCAM_TABLE_CFG_GENERIC_4_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_TCAM_TABLE_CFG_GENERIC_4_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_TCAM_TABLE_CFG_INGRESS_PORT_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 3, 1, (r))
#define RDD_TCAM_TABLE_CFG_INGRESS_PORT_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 3, 1, (v))
#define RDD_TCAM_TABLE_CFG_INGRESS_PORT_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_TCAM_TABLE_CFG_INGRESS_PORT_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_TCAM_TABLE_CFG_GEM_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 2, 1, (r))
#define RDD_TCAM_TABLE_CFG_GEM_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 2, 1, (v))
#define RDD_TCAM_TABLE_CFG_GEM_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_TCAM_TABLE_CFG_GEM_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_TCAM_TABLE_CFG_NETWORK_LAYER_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 1, 1, (r))
#define RDD_TCAM_TABLE_CFG_NETWORK_LAYER_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 1, 1, (v))
#define RDD_TCAM_TABLE_CFG_NETWORK_LAYER_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_TCAM_TABLE_CFG_NETWORK_LAYER_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_TCAM_TABLE_CFG_SSID_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 0, 1, (r))
#define RDD_TCAM_TABLE_CFG_SSID_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCAM_TABLE_CFG_STRUCT), 0, 1, (v))
#define RDD_TCAM_TABLE_CFG_SSID_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_TCAM_TABLE_CFG_SSID_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
/* <<<TCAM_TABLE_CFG_STRUCT */


#define RDD_TCAM_TABLE_CFG_TABLE_SIZE     2
typedef struct
{
	TCAM_TABLE_CFG_STRUCT	entry[ RDD_TCAM_TABLE_CFG_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCAM_TABLE_CFG_TABLE_STRUCT;

extern uint32_t RDD_TCAM_TABLE_CFG_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCAM_TABLE_CFG_TABLE_PTR(core_id)	( TCAM_TABLE_CFG_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCAM_TABLE_CFG_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCAM_TABLE_CFG_TABLE */


/* >>>UDPSPDT_STREAM_RX_STAT_TABLE */

/* >>>UDPSPDT_STREAM_RX_STAT_STRUCT */
typedef union
{
    uint32_t word_32[12];
    uint64_t dword_64[6];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_packets_1            	;
        uint32_t	rx_packets_0            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_1               	;
        uint32_t	ts_last_0               	;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_proto_cntr          	;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_out_of_order_1	;
        uint32_t	iperf3_rx_out_of_order_0	;
#else
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_packets_1            	;
        uint32_t	rx_packets_0            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_1               	;
        uint32_t	ts_last_0               	;
        uint16_t	bad_proto_cntr          	;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_out_of_order_1	;
        uint32_t	iperf3_rx_out_of_order_0	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) UDPSPDT_STREAM_RX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ(r, p)                               MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE(v, p)                              MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ(r, p)                               MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ(r, p)                             MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ(r, p)                             MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_G(r, g, idx)                          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_G(v, g, idx)                         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ(r, p)                                 MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE(v, p)                                MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ(r, p)                                MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ(r, p)                                MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ(r, p)                           MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ(r, p)                  MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ(r, p)                  MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ(r, p)                 MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ(r, p)                 MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<UDPSPDT_STREAM_RX_STAT_STRUCT */


#define RDD_UDPSPDT_STREAM_RX_STAT_TABLE_SIZE     4
typedef struct
{
	UDPSPDT_STREAM_RX_STAT_STRUCT	entry[ RDD_UDPSPDT_STREAM_RX_STAT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ UDPSPDT_STREAM_RX_STAT_TABLE_STRUCT;

extern uint32_t RDD_UDPSPDT_STREAM_RX_STAT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_UDPSPDT_STREAM_RX_STAT_TABLE_PTR(core_id)	( UDPSPDT_STREAM_RX_STAT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_UDPSPDT_STREAM_RX_STAT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<UDPSPDT_STREAM_RX_STAT_TABLE */


/* >>>MULTICAST_KEY_MASK */

/* >>>MULTICAST_KEY_MASK_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	vlan_mask 	;
        uint16_t	etype_mask	;
#else
        uint16_t	etype_mask	;
        uint16_t	vlan_mask 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) MULTICAST_KEY_MASK_ENTRY_STRUCT;

#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT), (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_VLAN_MASK_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(MULTICAST_KEY_MASK_ENTRY_STRUCT) + 2, (v))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_MULTICAST_KEY_MASK_ENTRY_ETYPE_MASK_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<MULTICAST_KEY_MASK_ENTRY_STRUCT */


#define RDD_MULTICAST_KEY_MASK_SIZE     1
typedef struct
{
	MULTICAST_KEY_MASK_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MULTICAST_KEY_MASK_STRUCT;

extern uint32_t RDD_MULTICAST_KEY_MASK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MULTICAST_KEY_MASK_PTR(core_id)	( MULTICAST_KEY_MASK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MULTICAST_KEY_MASK_ADDRESS_ARR[core_id] ))

/* <<<MULTICAST_KEY_MASK */


/* >>>NATC_L2_VLAN_KEY_MASK */

#define RDD_NATC_L2_VLAN_KEY_MASK_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ NATC_L2_VLAN_KEY_MASK_STRUCT;

extern uint32_t RDD_NATC_L2_VLAN_KEY_MASK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NATC_L2_VLAN_KEY_MASK_PTR(core_id)	( NATC_L2_VLAN_KEY_MASK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NATC_L2_VLAN_KEY_MASK_ADDRESS_ARR[core_id] ))

/* <<<NATC_L2_VLAN_KEY_MASK */


/* >>>INGRESS_FILTER_CFG */

/* >>>INGRESS_FILTER_CFG_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	res_offset	;
#else
        uint16_t	res_offset	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) INGRESS_FILTER_CFG_STRUCT;

#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(INGRESS_FILTER_CFG_STRUCT), (r))
#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(INGRESS_FILTER_CFG_STRUCT), (v))
#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_INGRESS_FILTER_CFG_RES_OFFSET_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<INGRESS_FILTER_CFG_STRUCT */


#define RDD_INGRESS_FILTER_CFG_SIZE     1
typedef struct
{
	INGRESS_FILTER_CFG_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ INGRESS_FILTER_CFG_TABLE_STRUCT;

extern uint32_t RDD_INGRESS_FILTER_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_INGRESS_FILTER_CFG_PTR(core_id)	( INGRESS_FILTER_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_INGRESS_FILTER_CFG_ADDRESS_ARR[core_id] ))

/* <<<INGRESS_FILTER_CFG */


/* >>>NATC_L2_TOS_MASK */

#define RDD_NATC_L2_TOS_MASK_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ NATC_L2_TOS_MASK_STRUCT;

extern uint32_t RDD_NATC_L2_TOS_MASK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NATC_L2_TOS_MASK_PTR(core_id)	( NATC_L2_TOS_MASK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NATC_L2_TOS_MASK_ADDRESS_ARR[core_id] ))

/* <<<NATC_L2_TOS_MASK */


/* >>>NATC_TBL_CFG */

/* >>>NATC_TBL_CONFIGURATION_STRUCT */
#define RDD_NATC_TBL_CONFIGURATION_RESERVED1_NUMBER	4
typedef union
{
    uint32_t word_32[6];
    uint64_t dword_64[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	key_addr_low                                             	;
        uint32_t	key_addr_high                                            	;
        uint32_t	res_addr_low                                             	;
        uint32_t	res_addr_high                                            	;
        uint32_t	reserved                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	miss_cache_enable                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	key_size                                                 	;
        uint8_t	context_size                                             	;
        uint8_t	reserved0                                                	;
        uint8_t	reserved1[RDD_NATC_TBL_CONFIGURATION_RESERVED1_NUMBER];
#else
        uint32_t	key_addr_low                                             	;
        uint32_t	key_addr_high                                            	;
        uint32_t	res_addr_low                                             	;
        uint32_t	res_addr_high                                            	;
        uint8_t	reserved0                                                	;
        uint8_t	context_size                                             	;
        uint8_t	key_size                                                 	;
        uint32_t	miss_cache_enable                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1[RDD_NATC_TBL_CONFIGURATION_RESERVED1_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) NATC_TBL_CONFIGURATION_STRUCT;

#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT), (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT), (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p), (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p), (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 4, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 4, (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_READ(r, p)                     MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_ADDR_HIGH_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 8, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 8, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 12, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 12, (v))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_READ(r, p)                     MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NATC_TBL_CONFIGURATION_RES_ADDR_HIGH_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 16, 0, 1, (r))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 16, 0, 1, (v))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 16, 0, 1, (r))
#define RDD_NATC_TBL_CONFIGURATION_MISS_CACHE_ENABLE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 16, 0, 1, (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_READ_G(r, g, idx)                   GROUP_MREAD_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 17, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_WRITE_G(v, g, idx)                  GROUP_MWRITE_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 17, (v))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_READ(r, p)                          MREAD_8((uint8_t *)(p) + 17, (r))
#define RDD_NATC_TBL_CONFIGURATION_KEY_SIZE_WRITE(v, p)                         MWRITE_8((uint8_t *)(p) + 17, (v))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 18, (r))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(NATC_TBL_CONFIGURATION_STRUCT) + 18, (v))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_READ(r, p)                      MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_NATC_TBL_CONFIGURATION_CONTEXT_SIZE_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 18, (v))
/* <<<NATC_TBL_CONFIGURATION_STRUCT */


#define RDD_NATC_TBL_CFG_SIZE     4
typedef struct
{
	NATC_TBL_CONFIGURATION_STRUCT	entry[ RDD_NATC_TBL_CFG_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ NATC_TBL_CFG_STRUCT;

extern uint32_t RDD_NATC_TBL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_NATC_TBL_CFG_PTR(core_id)	( NATC_TBL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_NATC_TBL_CFG_ADDRESS_ARR[core_id] ))

/* <<<NATC_TBL_CFG */


/* >>>FC_FLOW_IP_ADDRESSES_TABLE */

/* >>>FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT */
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_NUMBER	32
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_RESERVED0_NUMBER	4
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_RESERVED1_NUMBER	4
typedef union
{
    uint32_t word_32[12];
    uint64_t dword_64[6];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	sa_da_addresses[RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_NUMBER];
        uint8_t	reserved0[RDD_FC_FLOW_IP_ADDRESSES_ENTRY_RESERVED0_NUMBER];
        uint32_t	reference_count                                                           	;
        uint8_t	reserved1[RDD_FC_FLOW_IP_ADDRESSES_ENTRY_RESERVED1_NUMBER];
        uint32_t	is_ipv6_address                                                           	;
#else
        uint8_t	sa_da_addresses[RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_NUMBER];
        uint8_t	reserved0[RDD_FC_FLOW_IP_ADDRESSES_ENTRY_RESERVED0_NUMBER];
        uint32_t	reference_count                                                           	;
        uint8_t	reserved1[RDD_FC_FLOW_IP_ADDRESSES_ENTRY_RESERVED1_NUMBER];
        uint32_t	is_ipv6_address                                                           	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT;

#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT), i, (r))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT), i, (v))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_READ(r, p, i)              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_SA_DA_ADDRESSES_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_REFERENCE_COUNT_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT) + 36, (r))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_REFERENCE_COUNT_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT) + 36, (v))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_REFERENCE_COUNT_READ(r, p)                 MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_REFERENCE_COUNT_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_IS_IPV6_ADDRESS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT) + 44, (r))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_IS_IPV6_ADDRESS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT) + 44, (v))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_IS_IPV6_ADDRESS_READ(r, p)                 MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_FC_FLOW_IP_ADDRESSES_ENTRY_IS_IPV6_ADDRESS_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT */


#define RDD_FC_FLOW_IP_ADDRESSES_TABLE_SIZE     4
typedef struct
{
	FC_FLOW_IP_ADDRESSES_ENTRY_STRUCT	entry[ RDD_FC_FLOW_IP_ADDRESSES_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ FC_FLOW_IP_ADDRESSES_TABLE_STRUCT;

extern uint32_t RDD_FC_FLOW_IP_ADDRESSES_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_FC_FLOW_IP_ADDRESSES_TABLE_PTR(core_id)	( FC_FLOW_IP_ADDRESSES_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_FC_FLOW_IP_ADDRESSES_TABLE_ADDRESS_ARR[core_id] ))

/* <<<FC_FLOW_IP_ADDRESSES_TABLE */

/* CORE_1 */

/* >>>CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR */

#define RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_PTR(core_id)	( CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_INTERRUPT_ID_DDR_ADDR */


/* >>>CPU_RECYCLE_INTERRUPT_COALESCING_TABLE */

/* >>>CPU_INTERRUPT_COALESCING_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	timer_period        	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	not_empty_or_int_vec	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	not_empty                     	; /* Member of not_empty_or_int_vec union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	int_vec                       	; /* Member of not_empty_or_int_vec union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	scratch             	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	recycle_timer_cnt   	;
        uint16_t	recycle_timer_factor	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	timer_period        	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	not_empty_or_int_vec	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	not_empty                     	; /* Member of not_empty_or_int_vec union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	int_vec                       	; /* Member of not_empty_or_int_vec union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	scratch             	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	recycle_timer_factor	;
        uint16_t	recycle_timer_cnt   	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_INTERRUPT_COALESCING_ENTRY_STRUCT;

#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT), (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT), (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_READ(r, p)                         MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_TIMER_PERIOD_WRITE(v, p)                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_OR_INT_VEC_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_READ(r, p)                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_NOT_EMPTY_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_READ(r, p)                              MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_INT_VEC_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 8, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 8, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_READ(r, p)                              MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_SCRATCH_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_READ_G(r, g, idx)             GROUP_MREAD_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 12, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_WRITE_G(v, g, idx)            GROUP_MWRITE_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 12, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_READ(r, p)                    MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_CNT_WRITE(v, p)                   MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 14, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_INTERRUPT_COALESCING_ENTRY_STRUCT) + 14, (v))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_READ(r, p)                 MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_CPU_INTERRUPT_COALESCING_ENTRY_RECYCLE_TIMER_FACTOR_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<CPU_INTERRUPT_COALESCING_ENTRY_STRUCT */


#define RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_SIZE     1
typedef struct
{
	CPU_INTERRUPT_COALESCING_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_PTR(core_id)	( CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_INTERRUPT_COALESCING_TABLE */


/* >>>DS_CPU_REASON_TO_METER_TABLE */

#define RDD_DS_CPU_REASON_TO_METER_TABLE_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DS_CPU_REASON_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_CPU_REASON_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_DS_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_CPU_REASON_TO_METER_TABLE_PTR(core_id)	( DS_CPU_REASON_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_CPU_REASON_TO_METER_TABLE */


/* >>>CPU_INT_INTERRUPT_SCRATCH */

#define RDD_CPU_INT_INTERRUPT_SCRATCH_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_INT_INTERRUPT_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_INT_INTERRUPT_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_INT_INTERRUPT_SCRATCH_PTR(core_id)	( CPU_INT_INTERRUPT_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_INT_INTERRUPT_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_INT_INTERRUPT_SCRATCH */


/* >>>CPU_RX_INTERRUPT_ID_DDR_ADDR */

#define RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_INTERRUPT_ID_DDR_ADDR_STRUCT;

extern uint32_t RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_PTR(core_id)	( CPU_RX_INTERRUPT_ID_DDR_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_INTERRUPT_ID_DDR_ADDR_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_INTERRUPT_ID_DDR_ADDR */


/* >>>CPU_FEED_RING_RSV_TABLE */

#define RDD_CPU_FEED_RING_RSV_TABLE_SIZE     16
typedef struct
{
	BYTES_2_STRUCT	entry[ RDD_CPU_FEED_RING_RSV_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_RSV_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_RSV_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_RSV_TABLE_PTR(core_id)	( CPU_FEED_RING_RSV_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_RSV_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_RSV_TABLE */


/* >>>CPU_RX_SCRATCHPAD */

/* >>>BYTES_8_STRUCT */
#define RDD_BYTES_8_BITS_NUMBER	2
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bits[RDD_BYTES_8_BITS_NUMBER];
#else
        uint32_t	bits[RDD_BYTES_8_BITS_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BYTES_8_STRUCT;

#define RDD_BYTES_8_BITS_READ_G(r, g, idx, i)       GROUP_MREAD_I_32((g), (idx)*sizeof(BYTES_8_STRUCT), i, (r))
#define RDD_BYTES_8_BITS_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_32((g), (idx)*sizeof(BYTES_8_STRUCT), i, (v))
#define RDD_BYTES_8_BITS_READ(r, p, i)              MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_BYTES_8_BITS_WRITE(v, p, i)             MWRITE_I_32((uint8_t *)(p), i, (v))
/* <<<BYTES_8_STRUCT */


#define RDD_CPU_RX_SCRATCHPAD_SIZE     128
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_RX_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_RX_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_SCRATCHPAD_PTR(core_id)	( CPU_RX_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_SCRATCHPAD */


/* >>>TCPSPDTEST_STREAM_TABLE */

/* >>>TCPSPDTEST_STREAM_STRUCT */
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_NUMBER	32
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_NUMBER	8
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_NUMBER	16
typedef union
{
    uint32_t word_32[96];
    uint64_t dword_64[48];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	tcpspdtest_engine_conn_info_cpu_rx_rdd_queue                                                                                   	;
        uint8_t	tcpspdtest_engine_conn_info_up_pppoe_hdr_ofs                                                                                   	;
        uint8_t	tcpspdtest_engine_conn_info_up_peer_rx_scale                                                                                   	;
        uint8_t	tcpspdtest_engine_conn_info_sack_permitted                                                                                     	;
        uint16_t	tcpspdtest_engine_conn_info_up_tx_mss                                                                                          	;
        uint16_t	tcpspdtest_engine_conn_info_up_tx_max_pd_len                                                                                   	;
        uint32_t	tcpspdtest_engine_tcb_rx_pkts                                                                                                  	;
        uint32_t	tcpspdtest_engine_tcb_txed_pkts                                                                                                	;
        uint32_t	tcpspdtest_engine_tcb_freed_pkts                                                                                               	;
        uint32_t	tcpspdtest_engine_tcb_ack_seq                                                                                                  	;
        uint32_t	tcpspdtest_engine_tcb_tx_seq                                                                                                   	;
        uint32_t	tcpspdtest_engine_tcb_bad_pkts                                                                                                 	;
        uint32_t	tcpspdtest_engine_tcb_bad_bytes                                                                                                	;
        uint32_t	tcpspdtest_engine_tcb_bad_bytes_1                                                                                              	;
        uint32_t	tcpspdtest_engine_tcb_rx_bytes                                                                                                 	;
        uint32_t	tcpspdtest_engine_tcb_rx_bytes_1                                                                                               	;
        uint32_t	tcpspdtest_engine_tcb_expected_bytes                                                                                           	;
        uint32_t	tcpspdtest_engine_tcb_expected_bytes_1                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_up_to_send_bytes                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_up_to_send_bytes_1                                                                                       	;
        uint32_t	tcpspdtest_engine_tcb_no_credits                                                                                               	;
        uint32_t	tcpspdtest_engine_tcb_up_cwnd                                                                                                  	;
        uint32_t	tcpspdtest_engine_tcb_up_cwnd_thr                                                                                              	;
        uint32_t	tcpspdtest_engine_tcb_up_cwnd_budget                                                                                           	;
        uint32_t	tcpspdtest_engine_tcb_up_last_ack_seq                                                                                          	;
        uint32_t	tcpspdtest_engine_tcb_up_last_ack_time                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_up_dup_ack_cnt                                                                                           	;
        uint32_t	tcpspdtest_engine_tcb_up_dup_ack_seq_done                                                                                      	;
        uint16_t	tcpspdtest_engine_tcb_up_dup_ack_total_pkts_cnt                                                                                	;
        uint16_t	tcpspdtest_engine_tcb_up_fast_retrans_cnt                                                                                      	;
        uint16_t	tcpspdtest_engine_tcb_reserved1                                                                                                	;
        uint8_t	tcpspdtest_engine_tcb_up_dup_ack_state                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_reserved2                                                                                                	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_engine_tcb_up_is_rx_win_stop                                                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_engine_tcb_up_is_timeout                                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_engine_tcb_up_is_active                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tcpspdtest_engine_pkt_drop_is_drop                                                                                             	;
        uint8_t	tcpspdtest_engine_pkt_drop_is_win_full                                                                                         	;
        uint16_t	tcpspdtest_engine_pkt_drop_num_errs                                                                                            	;
        uint16_t	tcpspdtest_engine_pkt_drop_wr_ofs                                                                                              	;
        uint16_t	tcpspdtest_engine_pkt_drop_rd_ofs                                                                                              	;
        uint32_t	tcpspdtest_engine_pkt_drop_seq[RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_NUMBER];
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_addr_low                                                                                     	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_addr_high                                                                                    	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_send_cnt                                                                                     	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_drop_cnt                                                                                     	;
        uint32_t	tcpspdtest_engine_rto_ring_retrans_addr_low                                                                                    	;
        uint32_t	tcpspdtest_engine_rto_ring_retrans_addr_high                                                                                   	;
        uint32_t	tcpspdtest_engine_rto_ring_retrans_receive_cnt                                                                                 	;
        uint16_t	tcpspdtest_engine_rto_ring_scratchpad_metadata_wr_ofs                                                                          	;
        uint16_t	tcpspdtest_engine_rto_reserved1                                                                                                	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_coalescing_timeout_cnt                                                                       	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_coalescing_fill_pkt_cnt                                                                      	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_coalescing_last_time                                                                         	;
        uint32_t	tcpspdtest_engine_rto_reserved2                                                                                                	;
        uint32_t	tcpspdtest_engine_rto_ring_scratchpad[RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_NUMBER];
        uint32_t	tcpspdtest_engine_rto_ring_scratchpad_metadata[RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_NUMBER];
#else
        uint8_t	tcpspdtest_engine_conn_info_sack_permitted                                                                                     	;
        uint8_t	tcpspdtest_engine_conn_info_up_peer_rx_scale                                                                                   	;
        uint8_t	tcpspdtest_engine_conn_info_up_pppoe_hdr_ofs                                                                                   	;
        uint8_t	tcpspdtest_engine_conn_info_cpu_rx_rdd_queue                                                                                   	;
        uint16_t	tcpspdtest_engine_conn_info_up_tx_max_pd_len                                                                                   	;
        uint16_t	tcpspdtest_engine_conn_info_up_tx_mss                                                                                          	;
        uint32_t	tcpspdtest_engine_tcb_rx_pkts                                                                                                  	;
        uint32_t	tcpspdtest_engine_tcb_txed_pkts                                                                                                	;
        uint32_t	tcpspdtest_engine_tcb_freed_pkts                                                                                               	;
        uint32_t	tcpspdtest_engine_tcb_ack_seq                                                                                                  	;
        uint32_t	tcpspdtest_engine_tcb_tx_seq                                                                                                   	;
        uint32_t	tcpspdtest_engine_tcb_bad_pkts                                                                                                 	;
        uint32_t	tcpspdtest_engine_tcb_bad_bytes                                                                                                	;
        uint32_t	tcpspdtest_engine_tcb_bad_bytes_1                                                                                              	;
        uint32_t	tcpspdtest_engine_tcb_rx_bytes                                                                                                 	;
        uint32_t	tcpspdtest_engine_tcb_rx_bytes_1                                                                                               	;
        uint32_t	tcpspdtest_engine_tcb_expected_bytes                                                                                           	;
        uint32_t	tcpspdtest_engine_tcb_expected_bytes_1                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_up_to_send_bytes                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_up_to_send_bytes_1                                                                                       	;
        uint32_t	tcpspdtest_engine_tcb_no_credits                                                                                               	;
        uint32_t	tcpspdtest_engine_tcb_up_cwnd                                                                                                  	;
        uint32_t	tcpspdtest_engine_tcb_up_cwnd_thr                                                                                              	;
        uint32_t	tcpspdtest_engine_tcb_up_cwnd_budget                                                                                           	;
        uint32_t	tcpspdtest_engine_tcb_up_last_ack_seq                                                                                          	;
        uint32_t	tcpspdtest_engine_tcb_up_last_ack_time                                                                                         	;
        uint32_t	tcpspdtest_engine_tcb_up_dup_ack_cnt                                                                                           	;
        uint32_t	tcpspdtest_engine_tcb_up_dup_ack_seq_done                                                                                      	;
        uint16_t	tcpspdtest_engine_tcb_up_fast_retrans_cnt                                                                                      	;
        uint16_t	tcpspdtest_engine_tcb_up_dup_ack_total_pkts_cnt                                                                                	;
        uint32_t	tcpspdtest_engine_tcb_up_is_active                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_engine_tcb_up_is_timeout                                                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_engine_tcb_up_is_rx_win_stop                                                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_engine_tcb_reserved2                                                                                                	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tcpspdtest_engine_tcb_up_dup_ack_state                                                                                         	;
        uint16_t	tcpspdtest_engine_tcb_reserved1                                                                                                	;
        uint16_t	tcpspdtest_engine_pkt_drop_num_errs                                                                                            	;
        uint8_t	tcpspdtest_engine_pkt_drop_is_win_full                                                                                         	;
        uint8_t	tcpspdtest_engine_pkt_drop_is_drop                                                                                             	;
        uint16_t	tcpspdtest_engine_pkt_drop_rd_ofs                                                                                              	;
        uint16_t	tcpspdtest_engine_pkt_drop_wr_ofs                                                                                              	;
        uint32_t	tcpspdtest_engine_pkt_drop_seq[RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_NUMBER];
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_addr_low                                                                                     	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_addr_high                                                                                    	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_send_cnt                                                                                     	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_drop_cnt                                                                                     	;
        uint32_t	tcpspdtest_engine_rto_ring_retrans_addr_low                                                                                    	;
        uint32_t	tcpspdtest_engine_rto_ring_retrans_addr_high                                                                                   	;
        uint32_t	tcpspdtest_engine_rto_ring_retrans_receive_cnt                                                                                 	;
        uint16_t	tcpspdtest_engine_rto_reserved1                                                                                                	;
        uint16_t	tcpspdtest_engine_rto_ring_scratchpad_metadata_wr_ofs                                                                          	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_coalescing_timeout_cnt                                                                       	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_coalescing_fill_pkt_cnt                                                                      	;
        uint32_t	tcpspdtest_engine_rto_ring_tx_seq_coalescing_last_time                                                                         	;
        uint32_t	tcpspdtest_engine_rto_reserved2                                                                                                	;
        uint32_t	tcpspdtest_engine_rto_ring_scratchpad[RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_NUMBER];
        uint32_t	tcpspdtest_engine_rto_ring_scratchpad_metadata[RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TCPSPDTEST_STREAM_STRUCT;

#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ(r, p)                              MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE(v, p)                             MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ(r, p)                              MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE(v, p)                             MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ(r, p)                              MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE(v, p)                             MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ(r, p)                                MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_G(r, g, idx)                              GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_G(v, g, idx)                             GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ(r, p)                                     MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE(v, p)                                    MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ(r, p)                              MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_1_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_1_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_1_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_BYTES_1_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_G(r, g, idx)                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_G(v, g, idx)                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ(r, p)                                      MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE(v, p)                                     MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_G(r, g, idx)                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_G(v, g, idx)                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ(r, p)                                    MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE(v, p)                                   MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_G(r, g, idx)                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_G(v, g, idx)                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ(r, p)                                    MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE(v, p)                                   MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_CREDITS_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_CREDITS_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_CREDITS_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_CREDITS_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_G(r, g, idx)                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_G(v, g, idx)                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ(r, p)                                      MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE(v, p)                                     MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_G(r, g, idx)                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_G(v, g, idx)                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ(r, p)                                     MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE(v, p)                                    MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_G(r, g, idx)                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_G(v, g, idx)                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ(r, p)                                    MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE(v, p)                                   MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_G(r, g, idx)                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_G(v, g, idx)                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ(r, p)                                      MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE(v, p)                                     MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_G(r, g, idx)                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_G(v, g, idx)                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ(r, p)                                 MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE(v, p)                                MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ(r, p)                           MREAD_16((uint8_t *)(p) + 96, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 96, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_G(r, g, idx)                          GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 98, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_G(v, g, idx)                         GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 98, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ(r, p)                                 MREAD_16((uint8_t *)(p) + 98, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE(v, p)                                MWRITE_16((uint8_t *)(p) + 98, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED1_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED1_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED1_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 100, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED1_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 100, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_G(r, g, idx)                             GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 102, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_G(v, g, idx)                            GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 102, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ(r, p)                                    MREAD_8((uint8_t *)(p) + 102, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE(v, p)                                   MWRITE_8((uint8_t *)(p) + 102, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ_G(r, g, idx)                                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 3, 5, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE_G(v, g, idx)                                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 3, 5, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ(r, p)                                           FIELD_MREAD_8((uint8_t *)(p) + 103, 3, 5, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE(v, p)                                          FIELD_MWRITE_8((uint8_t *)(p) + 103, 3, 5, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 2, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 2, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 103, 2, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 103, 2, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_G(r, g, idx)                                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 1, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_G(v, g, idx)                               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 1, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ(r, p)                                       FIELD_MREAD_8((uint8_t *)(p) + 103, 1, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE(v, p)                                      FIELD_MWRITE_8((uint8_t *)(p) + 103, 1, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_ACTIVE_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 0, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_ACTIVE_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 103, 0, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_ACTIVE_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 103, 0, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_ACTIVE_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 103, 0, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_DROP_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_DROP_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_DROP_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 104, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_DROP_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 104, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_G(r, g, idx)                             GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 105, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_G(v, g, idx)                            GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 105, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ(r, p)                                    MREAD_8((uint8_t *)(p) + 105, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE(v, p)                                   MWRITE_8((uint8_t *)(p) + 105, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 106, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 106, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 108, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 108, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 110, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 110, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_READ_G(r, g, idx, i)                                  GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_WRITE_G(v, g, idx, i)                                 GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_READ(r, p, i)                                         MREAD_I_32((uint8_t *)(p) + 112, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SEQ_WRITE(v, p, i)                                        MWRITE_I_32((uint8_t *)(p) + 112, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_LOW_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 240, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 240, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_LOW_READ(r, p)                                MREAD_32((uint8_t *)(p) + 240, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_LOW_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 240, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 244, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 244, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_HIGH_READ(r, p)                               MREAD_32((uint8_t *)(p) + 244, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_ADDR_HIGH_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 244, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_SEND_CNT_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 248, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 248, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_SEND_CNT_READ(r, p)                                MREAD_32((uint8_t *)(p) + 248, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_SEND_CNT_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 248, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_DROP_CNT_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 252, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 252, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_DROP_CNT_READ(r, p)                                MREAD_32((uint8_t *)(p) + 252, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_DROP_CNT_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 252, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_LOW_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 256, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_LOW_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 256, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_LOW_READ(r, p)                               MREAD_32((uint8_t *)(p) + 256, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_LOW_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 256, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_HIGH_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 260, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_HIGH_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 260, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_HIGH_READ(r, p)                              MREAD_32((uint8_t *)(p) + 260, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_ADDR_HIGH_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 260, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_RECEIVE_CNT_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 264, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_RECEIVE_CNT_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 264, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_RECEIVE_CNT_READ(r, p)                            MREAD_32((uint8_t *)(p) + 264, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_RETRANS_RECEIVE_CNT_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 264, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_WR_OFS_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 268, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_WR_OFS_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 268, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_WR_OFS_READ(r, p)                     MREAD_16((uint8_t *)(p) + 268, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_WR_OFS_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 268, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED1_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 270, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED1_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 270, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED1_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 270, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED1_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 270, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 272, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 272, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_TIMEOUT_CNT_READ(r, p)                  MREAD_32((uint8_t *)(p) + 272, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 272, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 276, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 276, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_FILL_PKT_CNT_READ(r, p)                 MREAD_32((uint8_t *)(p) + 276, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 276, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_LAST_TIME_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 280, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_LAST_TIME_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 280, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_LAST_TIME_READ(r, p)                    MREAD_32((uint8_t *)(p) + 280, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_TX_SEQ_COALESCING_LAST_TIME_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 280, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED2_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 284, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED2_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 284, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED2_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 284, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RESERVED2_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 284, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_READ_G(r, g, idx, i)                           GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 288, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_WRITE_G(v, g, idx, i)                          GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 288, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_READ(r, p, i)                                  MREAD_I_32((uint8_t *)(p) + 288, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_WRITE(v, p, i)                                 MWRITE_I_32((uint8_t *)(p) + 288, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                  GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 320, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                 GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 320, i, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_READ(r, p, i)                         MREAD_I_32((uint8_t *)(p) + 320, i, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RTO_RING_SCRATCHPAD_METADATA_WRITE(v, p, i)                        MWRITE_I_32((uint8_t *)(p) + 320, i, (v))
/* <<<TCPSPDTEST_STREAM_STRUCT */


#define RDD_TCPSPDTEST_STREAM_TABLE_SIZE     4
typedef struct
{
	TCPSPDTEST_STREAM_STRUCT	entry[ RDD_TCPSPDTEST_STREAM_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_STREAM_TABLE_STRUCT;

extern uint32_t RDD_TCPSPDTEST_STREAM_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_STREAM_TABLE_PTR(core_id)	( TCPSPDTEST_STREAM_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_STREAM_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_STREAM_TABLE */


/* >>>US_CPU_REASON_TO_METER_TABLE */

#define RDD_US_CPU_REASON_TO_METER_TABLE_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_US_CPU_REASON_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_CPU_REASON_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_US_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_CPU_REASON_TO_METER_TABLE_PTR(core_id)	( US_CPU_REASON_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_CPU_REASON_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_CPU_REASON_TO_METER_TABLE */


/* >>>CPU_FEED_RING_CACHE_TABLE */

#define RDD_CPU_FEED_RING_CACHE_TABLE_SIZE     16
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_FEED_RING_CACHE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_CACHE_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_CACHE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_CACHE_TABLE_PTR(core_id)	( CPU_FEED_RING_CACHE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_CACHE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_CACHE_TABLE */


/* >>>PKTGEN_TX_STREAM_TABLE */

/* >>>PKTGEN_TX_STREAM_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[34];
    uint64_t dword_64[17];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	ref_pkt_hdr_size              	;
        uint16_t	ref_pkt_hdr_offset            	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_reserved          	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr               	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_1             	;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_2             	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_3             	;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_4             	;
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_5             	;
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_6             	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_7             	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_8             	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_9             	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_10            	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_11            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_12            	;
		};
	};
	/* Union WORD 15 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_13            	;
		};
	};
	/* Union WORD 16 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_14            	;
		};
	};
	/* Union WORD 17 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_15            	;
		};
	};
	/* Union WORD 18 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_16            	;
		};
	};
	/* Union WORD 19 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_17            	;
		};
	};
	/* Union WORD 20 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_18            	;
		};
	};
	/* Union WORD 21 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_19            	;
		};
	};
	/* Union WORD 22 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_20            	;
		};
	};
	/* Union WORD 23 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_21            	;
		};
	};
	/* Union WORD 24 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_22            	;
		};
	};
	/* Union WORD 25 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_23            	;
		};
	};
	/* Union WORD 26 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_24            	;
		};
	};
	/* Union WORD 27 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_25            	;
		};
	};
	/* Union WORD 28 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_26            	;
		};
	};
	/* Union WORD 29 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_27            	;
		};
	};
	/* Union WORD 30 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_28            	;
		};
	};
	/* Union WORD 31 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_29            	;
		};
	};
	/* Union WORD 32 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	entry_parms_wan_flow          	;
        uint16_t	entry_parms_tx_qm_queue       	;
		};
	};
	/* Union WORD 33 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	entry_parms_tcp_udp_parms     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	entry_parms_l2_hdr_len                  	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint8_t	entry_parms_l3_hdr_len                  	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint8_t	entry_parms_l3_protocol                 	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint8_t	entry_parms_tx_hdr_len                  	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	entry_parms_udp_payload_offset          	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint16_t	entry_parms_udp_csum                    	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	ref_pkt_hdr_offset            	;
        uint16_t	ref_pkt_hdr_size              	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_reserved          	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr               	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_1             	;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_2             	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_3             	;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_4             	;
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_5             	;
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_6             	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_7             	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_8             	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_9             	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_10            	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_11            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_12            	;
		};
	};
	/* Union WORD 15 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_13            	;
		};
	};
	/* Union WORD 16 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_14            	;
		};
	};
	/* Union WORD 17 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_15            	;
		};
	};
	/* Union WORD 18 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_16            	;
		};
	};
	/* Union WORD 19 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_17            	;
		};
	};
	/* Union WORD 20 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_18            	;
		};
	};
	/* Union WORD 21 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_19            	;
		};
	};
	/* Union WORD 22 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_20            	;
		};
	};
	/* Union WORD 23 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_21            	;
		};
	};
	/* Union WORD 24 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_22            	;
		};
	};
	/* Union WORD 25 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_23            	;
		};
	};
	/* Union WORD 26 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_24            	;
		};
	};
	/* Union WORD 27 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_25            	;
		};
	};
	/* Union WORD 28 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_26            	;
		};
	};
	/* Union WORD 29 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_27            	;
		};
	};
	/* Union WORD 30 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_28            	;
		};
	};
	/* Union WORD 31 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ref_pkt_hdr_hdr_29            	;
		};
	};
	/* Union WORD 32 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	entry_parms_tx_qm_queue       	;
        uint16_t	entry_parms_wan_flow          	;
		};
	};
	/* Union WORD 33 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	entry_parms_tcp_udp_parms     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	entry_parms_tx_hdr_len                  	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint8_t	entry_parms_l3_protocol                 	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint8_t	entry_parms_l3_hdr_len                  	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint8_t	entry_parms_l2_hdr_len                  	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	entry_parms_udp_csum                    	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
        uint16_t	entry_parms_udp_payload_offset          	; /* Member of ENTRY_PARMS_tcp_udp_parms union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PKTGEN_TX_STREAM_ENTRY_STRUCT;

#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ_G(r, g, idx)                        GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE_G(v, g, idx)                       GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ(r, p)                               MREAD_16((uint8_t *)(p), (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE(v, p)                              MWRITE_16((uint8_t *)(p), (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ(r, p)                             MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ(r, p)                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ(r, p)                                MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ(r, p)                              MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ(r, p)                              MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ(r, p)                              MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ(r, p)                              MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ(r, p)                              MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ(r, p)                              MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ(r, p)                              MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ(r, p)                              MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ(r, p)                              MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ(r, p)                             MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ(r, p)                             MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ(r, p)                             MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ(r, p)                             MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ(r, p)                             MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ(r, p)                             MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ(r, p)                             MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ(r, p)                             MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ(r, p)                             MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ(r, p)                             MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ(r, p)                             MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ(r, p)                             MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ(r, p)                             MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ(r, p)                             MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ(r, p)                             MREAD_32((uint8_t *)(p) + 104, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 104, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ(r, p)                             MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ(r, p)                             MREAD_32((uint8_t *)(p) + 112, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 112, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ(r, p)                             MREAD_32((uint8_t *)(p) + 116, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 116, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ(r, p)                             MREAD_32((uint8_t *)(p) + 120, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 120, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ(r, p)                             MREAD_32((uint8_t *)(p) + 124, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 124, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ(r, p)                           MREAD_16((uint8_t *)(p) + 128, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 128, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_QM_QUEUE_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_QM_QUEUE_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_QM_QUEUE_READ(r, p)                        MREAD_16((uint8_t *)(p) + 130, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_QM_QUEUE_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 130, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ(r, p)                      MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ(r, p)                         MREAD_8((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ(r, p)                         MREAD_8((uint8_t *)(p) + 133, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 133, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ_G(r, g, idx)                 GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE_G(v, g, idx)                GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ(r, p)                        MREAD_8((uint8_t *)(p) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE(v, p)                       MWRITE_8((uint8_t *)(p) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ(r, p)                         MREAD_8((uint8_t *)(p) + 135, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 135, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ(r, p)                 MREAD_16((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ(r, p)                           MREAD_16((uint8_t *)(p) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 134, (v))
/* <<<PKTGEN_TX_STREAM_ENTRY_STRUCT */


#define RDD_PKTGEN_TX_STREAM_TABLE_SIZE     4
typedef struct
{
	PKTGEN_TX_STREAM_ENTRY_STRUCT	entry[ RDD_PKTGEN_TX_STREAM_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_TX_STREAM_TABLE_STRUCT;

extern uint32_t RDD_PKTGEN_TX_STREAM_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_TX_STREAM_TABLE_PTR(core_id)	( PKTGEN_TX_STREAM_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_TX_STREAM_TABLE_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_TX_STREAM_TABLE */


/* >>>IPV4_HOST_ADDRESS_TABLE */

#define RDD_IPV4_HOST_ADDRESS_TABLE_SIZE     8
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_IPV4_HOST_ADDRESS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPV4_HOST_ADDRESS_TABLE_STRUCT;

extern uint32_t RDD_IPV4_HOST_ADDRESS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPV4_HOST_ADDRESS_TABLE_PTR(core_id)	( IPV4_HOST_ADDRESS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPV4_HOST_ADDRESS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPV4_HOST_ADDRESS_TABLE */


/* >>>IPV6_HOST_ADDRESS_CRC_TABLE */

#define RDD_IPV6_HOST_ADDRESS_CRC_TABLE_SIZE     16
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_IPV6_HOST_ADDRESS_CRC_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ IPV6_HOST_ADDRESS_CRC_TABLE_STRUCT;

extern uint32_t RDD_IPV6_HOST_ADDRESS_CRC_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_IPV6_HOST_ADDRESS_CRC_TABLE_PTR(core_id)	( IPV6_HOST_ADDRESS_CRC_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_IPV6_HOST_ADDRESS_CRC_TABLE_ADDRESS_ARR[core_id] ))

/* <<<IPV6_HOST_ADDRESS_CRC_TABLE */


/* >>>DS_CPU_RX_METER_TABLE */

/* >>>CPU_RX_METER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	current_budget  	;
        uint16_t	budget_limit    	;
        uint16_t	allocated_budget	;
        uint8_t	budget_residue  	;
        uint8_t	current_cycle   	;
#else
        uint16_t	budget_limit    	;
        uint16_t	current_budget  	;
        uint8_t	current_cycle   	;
        uint8_t	budget_residue  	;
        uint16_t	allocated_budget	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_RX_METER_ENTRY_STRUCT;

#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_G(r, g, idx)            GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_G(v, g, idx)           GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ(r, p)                   MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE(v, p)                  MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ(r, p)                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ(r, p)                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ(r, p)                   MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ(r, p)                    MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RX_METER_ENTRY_STRUCT */


#define RDD_DS_CPU_RX_METER_TABLE_SIZE     16
typedef struct
{
	CPU_RX_METER_ENTRY_STRUCT	entry[ RDD_DS_CPU_RX_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_CPU_RX_METER_TABLE_STRUCT;

extern uint32_t RDD_DS_CPU_RX_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_CPU_RX_METER_TABLE_PTR(core_id)	( DS_CPU_RX_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_CPU_RX_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_CPU_RX_METER_TABLE */


/* >>>CSO_CONTEXT_TABLE */

/* >>>CSO_CONTEXT_ENTRY_STRUCT */
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER	24
typedef union
{
    uint32_t word_32[38];
    uint64_t dword_64[19];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved                                                     	;
        uint16_t	reserved1                                                    	;
        uint16_t	csum_value                                                   	;
        uint16_t	cam_result                                                   	;
        uint16_t	reserved2                                                    	;
        uint32_t	crc_result                                                   	;
        uint32_t	saved_pkt_desc_0                                             	;
        uint32_t	saved_pkt_desc_1                                             	;
        uint32_t	saved_pkt_desc_2                                             	;
        uint32_t	saved_pkt_desc_3                                             	;
        uint32_t	parser_result[RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER];
        uint32_t	saved_ret_address                                            	;
        uint32_t	good_csum_packets                                            	;
        uint32_t	no_cso_support_packets                                       	;
        uint32_t	bad_ipv4_hdr_csum_packets                                    	;
        uint32_t	bad_tcp_udp_csum_packets                                     	;
        uint16_t	saved_buffer_number                                          	;
        uint16_t	saved_packet_length                                          	;
#else
        uint32_t	reserved                                                     	;
        uint16_t	csum_value                                                   	;
        uint16_t	reserved1                                                    	;
        uint16_t	reserved2                                                    	;
        uint16_t	cam_result                                                   	;
        uint32_t	crc_result                                                   	;
        uint32_t	saved_pkt_desc_0                                             	;
        uint32_t	saved_pkt_desc_1                                             	;
        uint32_t	saved_pkt_desc_2                                             	;
        uint32_t	saved_pkt_desc_3                                             	;
        uint32_t	parser_result[RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_NUMBER];
        uint32_t	saved_ret_address                                            	;
        uint32_t	good_csum_packets                                            	;
        uint32_t	no_cso_support_packets                                       	;
        uint32_t	bad_ipv4_hdr_csum_packets                                    	;
        uint32_t	bad_tcp_udp_csum_packets                                     	;
        uint16_t	saved_packet_length                                          	;
        uint16_t	saved_buffer_number                                          	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CSO_CONTEXT_ENTRY_STRUCT;

#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ_G(r, g, idx)                         GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE_G(v, g, idx)                        GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_READ(r, p)                                MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_CSO_CONTEXT_ENTRY_CSUM_VALUE_WRITE(v, p)                               MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ_G(r, g, idx)                         GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE_G(v, g, idx)                        GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_READ(r, p)                                MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_CSO_CONTEXT_ENTRY_CAM_RESULT_WRITE(v, p)                               MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (r))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 12, (v))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_READ(r, p)                                MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CSO_CONTEXT_ENTRY_CRC_RESULT_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_READ(r, p)                          MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_0_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 20, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_READ(r, p)                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_1_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 24, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_READ(r, p)                          MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_2_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 28, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_READ(r, p)                          MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PKT_DESC_3_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ_G(r, g, idx, i)                   GROUP_MREAD_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, i, (r))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE_G(v, g, idx, i)                  GROUP_MWRITE_I_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 32, i, (v))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_READ(r, p, i)                          MREAD_I_32((uint8_t *)(p) + 32, i, (r))
#define RDD_CSO_CONTEXT_ENTRY_PARSER_RESULT_WRITE(v, p, i)                         MWRITE_I_32((uint8_t *)(p) + 32, i, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 128, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 128, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_READ(r, p)                         MREAD_32((uint8_t *)(p) + 128, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_RET_ADDRESS_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 128, (v))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 132, (r))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 132, (v))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_READ(r, p)                         MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_CSO_CONTEXT_ENTRY_GOOD_CSUM_PACKETS_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 136, (r))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 136, (v))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_READ(r, p)                    MREAD_32((uint8_t *)(p) + 136, (r))
#define RDD_CSO_CONTEXT_ENTRY_NO_CSO_SUPPORT_PACKETS_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 136, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 140, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 140, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_READ(r, p)                 MREAD_32((uint8_t *)(p) + 140, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_IPV4_HDR_CSUM_PACKETS_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 140, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 144, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 144, (v))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_READ(r, p)                  MREAD_32((uint8_t *)(p) + 144, (r))
#define RDD_CSO_CONTEXT_ENTRY_BAD_TCP_UDP_CSUM_PACKETS_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 144, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 148, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 148, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_READ(r, p)                       MREAD_16((uint8_t *)(p) + 148, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_BUFFER_NUMBER_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 148, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 150, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(CSO_CONTEXT_ENTRY_STRUCT) + 150, (v))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_READ(r, p)                       MREAD_16((uint8_t *)(p) + 150, (r))
#define RDD_CSO_CONTEXT_ENTRY_SAVED_PACKET_LENGTH_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 150, (v))
/* <<<CSO_CONTEXT_ENTRY_STRUCT */


#define RDD_CSO_CONTEXT_TABLE_SIZE     1
typedef struct
{
	CSO_CONTEXT_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CSO_CONTEXT_TABLE_STRUCT;

extern uint32_t RDD_CSO_CONTEXT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CSO_CONTEXT_TABLE_PTR(core_id)	( CSO_CONTEXT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CSO_CONTEXT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CSO_CONTEXT_TABLE */


/* >>>CPU_RX_STACK */

#define RDD_CPU_RX_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_RX_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_STACK_STRUCT;

extern uint32_t RDD_CPU_RX_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_STACK_PTR(core_id)	( CPU_RX_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_STACK_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_STACK */


/* >>>SPDSVC_GEN_PARAMS_TABLE */

/* >>>SPDSVC_GEN_PARAMS_STRUCT */
typedef union
{
    uint32_t word_32[15];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	timer_period      	;
        uint16_t	total_length      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#else
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	total_length      	;
        uint16_t	timer_period      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) SPDSVC_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ(r, p)                 MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ(r, p)                 MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ(r, p)                       MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ(r, p)                             MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ(r, p)                       MREAD_16((uint8_t *)(p) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ(r, p)                       MREAD_16((uint8_t *)(p) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ(r, p)                         MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ(r, p)                         MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_G(r, g, idx)                      GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_G(v, g, idx)                     GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ(r, p)                             MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE(v, p)                            MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_G(r, g, idx)                 GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_G(v, g, idx)                GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ(r, p)                        MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE(v, p)                       MWRITE_32((uint8_t *)(p) + 56, (v))
/* <<<SPDSVC_GEN_PARAMS_STRUCT */


#define RDD_SPDSVC_GEN_PARAMS_TABLE_SIZE     1
typedef struct
{
	SPDSVC_GEN_PARAMS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_GEN_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_GEN_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_GEN_PARAMS_TABLE_PTR(core_id)	( SPDSVC_GEN_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_GEN_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_GEN_PARAMS_TABLE */


/* >>>PKTGEN_NO_SBPM_HDRS_CNTR */

#define RDD_PKTGEN_NO_SBPM_HDRS_CNTR_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_NO_SBPM_HDRS_CNTR_STRUCT;

extern uint32_t RDD_PKTGEN_NO_SBPM_HDRS_CNTR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_NO_SBPM_HDRS_CNTR_PTR(core_id)	( PKTGEN_NO_SBPM_HDRS_CNTR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_NO_SBPM_HDRS_CNTR_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_NO_SBPM_HDRS_CNTR */


/* >>>US_CPU_RX_METER_TABLE */

#define RDD_US_CPU_RX_METER_TABLE_SIZE     16
typedef struct
{
	CPU_RX_METER_ENTRY_STRUCT	entry[ RDD_US_CPU_RX_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_CPU_RX_METER_TABLE_STRUCT;

extern uint32_t RDD_US_CPU_RX_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_CPU_RX_METER_TABLE_PTR(core_id)	( US_CPU_RX_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_CPU_RX_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_CPU_RX_METER_TABLE */


/* >>>CPU_REASON_AND_VPORT_TO_METER_TABLE */

#define RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_SIZE     48
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_REASON_AND_VPORT_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_PTR(core_id)	( CPU_REASON_AND_VPORT_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_REASON_AND_VPORT_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_REASON_AND_VPORT_TO_METER_TABLE */


/* >>>CPU_RX_COPY_INT_SCRATCHPAD */

#define RDD_CPU_RX_COPY_INT_SCRATCHPAD_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RX_COPY_INT_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_INT_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_INT_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_INT_SCRATCHPAD_PTR(core_id)	( CPU_RX_COPY_INT_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_INT_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_INT_SCRATCHPAD */


/* >>>CPU_RX_COPY_STACK */

#define RDD_CPU_RX_COPY_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_RX_COPY_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_STACK_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_STACK_PTR(core_id)	( CPU_RX_COPY_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_STACK_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_STACK */


/* >>>TX_ABS_RECYCLE_COUNTERS */

/* >>>TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	total     	;
        uint32_t	spdsvc    	;
#else
        uint32_t	total     	;
        uint32_t	spdsvc    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT;

#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_TOTAL_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT), (r))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_TOTAL_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT), (v))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_TOTAL_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_TOTAL_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_SPDSVC_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT) + 4, (r))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_SPDSVC_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT) + 4, (v))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_SPDSVC_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TX_ABS_RECYCLE_COUNTERS_ENTRY_SPDSVC_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT */


#define RDD_TX_ABS_RECYCLE_COUNTERS_SIZE     1
typedef struct
{
	TX_ABS_RECYCLE_COUNTERS_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_ABS_RECYCLE_COUNTERS_STRUCT;

extern uint32_t RDD_TX_ABS_RECYCLE_COUNTERS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_ABS_RECYCLE_COUNTERS_PTR(core_id)	( TX_ABS_RECYCLE_COUNTERS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_ABS_RECYCLE_COUNTERS_ADDRESS_ARR[core_id] ))

/* <<<TX_ABS_RECYCLE_COUNTERS */


/* >>>CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD */

#define RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_PTR(core_id)	( CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_PSRAM_GET_NEXT_SCRATCHPAD */


/* >>>TCPSPDTEST_SCRATCHPAD */

#define RDD_TCPSPDTEST_SCRATCHPAD_SIZE     16
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_TCPSPDTEST_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_SCRATCHPAD_STRUCT;

extern uint32_t RDD_TCPSPDTEST_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_SCRATCHPAD_PTR(core_id)	( TCPSPDTEST_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_SCRATCHPAD */


/* >>>CPU_REASON_TO_TC */

#define RDD_CPU_REASON_TO_TC_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_REASON_TO_TC_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_REASON_TO_TC_STRUCT;

extern uint32_t RDD_CPU_REASON_TO_TC_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_REASON_TO_TC_PTR(core_id)	( CPU_REASON_TO_TC_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_REASON_TO_TC_ADDRESS_ARR[core_id] ))

/* <<<CPU_REASON_TO_TC */


/* >>>GENERAL_TIMER */

/* >>>GENERAL_TIMER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	counter   	;
        uint16_t	timeout   	;
        uint16_t	func_ptr  	;
        uint8_t	enable    	;
        uint8_t	reserved  	;
#else
        uint16_t	timeout   	;
        uint16_t	counter   	;
        uint8_t	reserved  	;
        uint8_t	enable    	;
        uint16_t	func_ptr  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) GENERAL_TIMER_ENTRY_STRUCT;

#define RDD_GENERAL_TIMER_ENTRY_COUNTER_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT), (r))
#define RDD_GENERAL_TIMER_ENTRY_COUNTER_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT), (v))
#define RDD_GENERAL_TIMER_ENTRY_COUNTER_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_GENERAL_TIMER_ENTRY_COUNTER_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_GENERAL_TIMER_ENTRY_TIMEOUT_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT) + 2, (r))
#define RDD_GENERAL_TIMER_ENTRY_TIMEOUT_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT) + 2, (v))
#define RDD_GENERAL_TIMER_ENTRY_TIMEOUT_READ(r, p)                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_GENERAL_TIMER_ENTRY_TIMEOUT_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_GENERAL_TIMER_ENTRY_FUNC_PTR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT) + 4, (r))
#define RDD_GENERAL_TIMER_ENTRY_FUNC_PTR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT) + 4, (v))
#define RDD_GENERAL_TIMER_ENTRY_FUNC_PTR_READ(r, p)                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_GENERAL_TIMER_ENTRY_FUNC_PTR_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_GENERAL_TIMER_ENTRY_ENABLE_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT) + 6, (r))
#define RDD_GENERAL_TIMER_ENTRY_ENABLE_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(GENERAL_TIMER_ENTRY_STRUCT) + 6, (v))
#define RDD_GENERAL_TIMER_ENTRY_ENABLE_READ(r, p)                   MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_GENERAL_TIMER_ENTRY_ENABLE_WRITE(v, p)                  MWRITE_8((uint8_t *)(p) + 6, (v))
/* <<<GENERAL_TIMER_ENTRY_STRUCT */


#define RDD_GENERAL_TIMER_SIZE     16
typedef struct
{
	GENERAL_TIMER_ENTRY_STRUCT	entry[ RDD_GENERAL_TIMER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ GENERAL_TIMER_STRUCT;

extern uint32_t RDD_GENERAL_TIMER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GENERAL_TIMER_PTR(core_id)	( GENERAL_TIMER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GENERAL_TIMER_ADDRESS_ARR[core_id] ))

/* <<<GENERAL_TIMER */


/* >>>TC_TO_CPU_RXQ */

#define RDD_TC_TO_CPU_RXQ_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_TC_TO_CPU_RXQ_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TC_TO_CPU_RXQ_STRUCT;

extern uint32_t RDD_TC_TO_CPU_RXQ_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TC_TO_CPU_RXQ_PTR(core_id)	( TC_TO_CPU_RXQ_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TC_TO_CPU_RXQ_ADDRESS_ARR[core_id] ))

/* <<<TC_TO_CPU_RXQ */


/* >>>SPDSVC_GEN_STACK */

#define RDD_SPDSVC_GEN_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_SPDSVC_GEN_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_GEN_STACK_STRUCT;

extern uint32_t RDD_SPDSVC_GEN_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_GEN_STACK_PTR(core_id)	( SPDSVC_GEN_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_GEN_STACK_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_GEN_STACK */


/* >>>CPU_RING_DESCRIPTORS_TABLE */

#define RDD_CPU_RING_DESCRIPTORS_TABLE_SIZE     16
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry[ RDD_CPU_RING_DESCRIPTORS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RING_DESCRIPTORS_TABLE_STRUCT;

extern uint32_t RDD_CPU_RING_DESCRIPTORS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RING_DESCRIPTORS_TABLE_PTR(core_id)	( CPU_RING_DESCRIPTORS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RING_DESCRIPTORS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RING_DESCRIPTORS_TABLE */


/* >>>CPU_RING_INTERRUPT_COUNTER_TABLE */

/* >>>CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	counter   	;
        uint32_t	max_size  	;
#else
        uint32_t	counter   	;
        uint32_t	max_size  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT;

#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT), (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_COUNTER_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RING_INTERRUPT_COUNTER_ENTRY_MAX_SIZE_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT */


#define RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_SIZE     18
typedef struct
{
	CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT	entry[ RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RING_INTERRUPT_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_PTR(core_id)	( CPU_RING_INTERRUPT_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RING_INTERRUPT_COUNTER_TABLE */


/* >>>EXC_TC_TO_CPU_RXQ */

#define RDD_EXC_TC_TO_CPU_RXQ_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_EXC_TC_TO_CPU_RXQ_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EXC_TC_TO_CPU_RXQ_STRUCT;

extern uint32_t RDD_EXC_TC_TO_CPU_RXQ_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EXC_TC_TO_CPU_RXQ_PTR(core_id)	( EXC_TC_TO_CPU_RXQ_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EXC_TC_TO_CPU_RXQ_ADDRESS_ARR[core_id] ))

/* <<<EXC_TC_TO_CPU_RXQ */


/* >>>PKTGEN_SESSION_DATA */

/* >>>PKTGEN_TX_PARAMS_STRUCT */
typedef union
{
    uint32_t word_32[8];
    uint64_t dword_64[4];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bbmsg_sbpm_mcast_inc_req_0	;
        uint32_t	bbmsg_sbpm_mcast_inc_req_1	;
        uint32_t	ref_pd_0                  	;
        uint32_t	ref_pd_1                  	;
        uint32_t	ref_pd_2                  	;
        uint32_t	ref_pd_3                  	;
        uint32_t	task_num                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                 	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved2                 	;
        uint16_t	bad_tx_num_of_bns         	;
#else
        uint32_t	bbmsg_sbpm_mcast_inc_req_0	;
        uint32_t	bbmsg_sbpm_mcast_inc_req_1	;
        uint32_t	ref_pd_0                  	;
        uint32_t	ref_pd_1                  	;
        uint32_t	ref_pd_2                  	;
        uint32_t	ref_pd_3                  	;
        uint32_t	reserved1                 	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	task_num                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_tx_num_of_bns         	;
        uint16_t	reserved2                 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PKTGEN_TX_PARAMS_STRUCT;

#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ_G(r, g, idx)                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE_G(v, g, idx)                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ(r, p)                                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE(v, p)                                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ_G(r, g, idx)                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE_G(v, g, idx)                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ(r, p)                                   MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE(v, p)                                  MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ_G(r, g, idx)                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE_G(v, g, idx)                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ(r, p)                                   MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE(v, p)                                  MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ_G(r, g, idx)                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE_G(v, g, idx)                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ(r, p)                                   MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE(v, p)                                  MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (r))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (v))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 24, 4, 4, (r))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 24, 4, 4, (v))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (r))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (v))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ(r, p)                          MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 30, (v))
/* <<<PKTGEN_TX_PARAMS_STRUCT */


#define RDD_PKTGEN_SESSION_DATA_SIZE     1
typedef struct
{
	PKTGEN_TX_PARAMS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_SESSION_DATA_STRUCT;

extern uint32_t RDD_PKTGEN_SESSION_DATA_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_SESSION_DATA_PTR(core_id)	( PKTGEN_SESSION_DATA_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_SESSION_DATA_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_SESSION_DATA */


/* >>>GENERAL_TIMER_STACK */

#define RDD_GENERAL_TIMER_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_GENERAL_TIMER_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ GENERAL_TIMER_STACK_STRUCT;

extern uint32_t RDD_GENERAL_TIMER_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GENERAL_TIMER_STACK_PTR(core_id)	( GENERAL_TIMER_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GENERAL_TIMER_STACK_ADDRESS_ARR[core_id] ))

/* <<<GENERAL_TIMER_STACK */


/* >>>CPU_RECYCLE_STACK */

#define RDD_CPU_RECYCLE_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_RECYCLE_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_STACK_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_STACK_PTR(core_id)	( CPU_RECYCLE_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_STACK_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_STACK */


/* >>>COMMON_REPROCESSING_STACK */

#define RDD_COMMON_REPROCESSING_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_COMMON_REPROCESSING_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ COMMON_REPROCESSING_STACK_STRUCT;

extern uint32_t RDD_COMMON_REPROCESSING_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_COMMON_REPROCESSING_STACK_PTR(core_id)	( COMMON_REPROCESSING_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_COMMON_REPROCESSING_STACK_ADDRESS_ARR[core_id] ))

/* <<<COMMON_REPROCESSING_STACK */


/* >>>CPU_RECYCLE_SRAM_PD_FIFO */

#define RDD_CPU_RECYCLE_SRAM_PD_FIFO_SIZE     16
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_CPU_RECYCLE_SRAM_PD_FIFO_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_SRAM_PD_FIFO_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_SRAM_PD_FIFO_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_SRAM_PD_FIFO_PTR(core_id)	( CPU_RECYCLE_SRAM_PD_FIFO_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_SRAM_PD_FIFO_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_SRAM_PD_FIFO */


/* >>>CPU_RX_COPY_PD_FIFO_TABLE */

#define RDD_CPU_RX_COPY_PD_FIFO_TABLE_SIZE     8
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_CPU_RX_COPY_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_PD_FIFO_TABLE_PTR(core_id)	( CPU_RX_COPY_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_PD_FIFO_TABLE */


/* >>>TCPSPDTEST_PD_FIFO_TABLE */

#define RDD_TCPSPDTEST_PD_FIFO_TABLE_SIZE     4
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_TCPSPDTEST_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_TCPSPDTEST_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_PD_FIFO_TABLE_PTR(core_id)	( TCPSPDTEST_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_PD_FIFO_TABLE */


/* >>>UPDATE_FIFO_TABLE */

#define RDD_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_UPDATE_FIFO_TABLE_PTR(core_id)	( UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<UPDATE_FIFO_TABLE */


/* >>>CPU_RX_INTERRUPT_SCRATCH */

#define RDD_CPU_RX_INTERRUPT_SCRATCH_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_INTERRUPT_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_RX_INTERRUPT_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_INTERRUPT_SCRATCH_PTR(core_id)	( CPU_RX_INTERRUPT_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_INTERRUPT_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_INTERRUPT_SCRATCH */


/* >>>PKTGEN_CURR_SBPM_HDR_PTR */

#define RDD_PKTGEN_CURR_SBPM_HDR_PTR_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_CURR_SBPM_HDR_PTR_STRUCT;

extern uint32_t RDD_PKTGEN_CURR_SBPM_HDR_PTR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_CURR_SBPM_HDR_PTR_PTR(core_id)	( PKTGEN_CURR_SBPM_HDR_PTR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_CURR_SBPM_HDR_PTR_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_CURR_SBPM_HDR_PTR */


/* >>>UDPSPDT_STREAM_TX_STAT_TABLE */

/* >>>UDPSPDT_STREAM_TX_STAT_STRUCT */
typedef union
{
    uint32_t word_32[10];
    uint64_t dword_64[5];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	bad_proto_cntr             	;
        uint16_t	time_slice_expire          	;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	time_slice_expire          	;
        uint16_t	bad_proto_cntr             	;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) UDPSPDT_STREAM_TX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ(r, p)                                MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE(v, p)                               MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ(r, p)                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ(r, p)                            MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_G(r, g, idx)                             GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_G(v, g, idx)                            GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ(r, p)                                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE(v, p)                                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_G(r, g, idx)                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_G(v, g, idx)                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ(r, p)                                   MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE(v, p)                                  MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_G(r, g, idx)                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_G(v, g, idx)                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ(r, p)                                   MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE(v, p)                                  MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ(r, p)                               MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ(r, p)                              MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ(r, p)                              MREAD_16((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ(r, p)                           MREAD_16((uint8_t *)(p) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ(r, p)                 MREAD_16((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 39, 0, 1, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 39, 0, 1, (v))
/* <<<UDPSPDT_STREAM_TX_STAT_STRUCT */


#define RDD_UDPSPDT_STREAM_TX_STAT_TABLE_SIZE     4
typedef struct
{
	UDPSPDT_STREAM_TX_STAT_STRUCT	entry[ RDD_UDPSPDT_STREAM_TX_STAT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ UDPSPDT_STREAM_TX_STAT_TABLE_STRUCT;

extern uint32_t RDD_UDPSPDT_STREAM_TX_STAT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_UDPSPDT_STREAM_TX_STAT_TABLE_PTR(core_id)	( UDPSPDT_STREAM_TX_STAT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_UDPSPDT_STREAM_TX_STAT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<UDPSPDT_STREAM_TX_STAT_TABLE */


/* >>>TCPSPDTEST_ENGINE_GLOBAL_TABLE */

/* >>>TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT */
typedef union
{
    uint32_t word_32[5];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	num_streams               	;
        uint8_t	reserved0                 	;
        uint16_t	num_bns                   	;
        uint32_t	stream_vector             	;
        uint32_t	up_bucket_tokens          	;
        uint32_t	up_bucket_full_tokens     	;
        uint16_t	up_bucket_tokens_fill_rate	;
        uint8_t	up_next_stream_id         	;
        uint32_t	reserved1                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timer_active        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	num_bns                   	;
        uint8_t	reserved0                 	;
        uint8_t	num_streams               	;
        uint32_t	stream_vector             	;
        uint32_t	up_bucket_tokens          	;
        uint32_t	up_bucket_full_tokens     	;
        uint32_t	up_is_timer_active        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	up_next_stream_id         	;
        uint16_t	up_bucket_tokens_fill_rate	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ(r, p)                                MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE(v, p)                               MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ_G(r, g, idx)                             GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE_G(v, g, idx)                            GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ(r, p)                                    MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE(v, p)                                   MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ(r, p)                              MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ(r, p)                           MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ(r, p)                      MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ(r, p)                 MREAD_16((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ_G(r, g, idx)                   GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE_G(v, g, idx)                  GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ(r, p)                          MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE(v, p)                         MWRITE_8((uint8_t *)(p) + 18, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 1, (v))
/* <<<TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT */


#define RDD_TCPSPDTEST_ENGINE_GLOBAL_TABLE_SIZE     1
typedef struct
{
	TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_ENGINE_GLOBAL_TABLE_STRUCT;

extern uint32_t RDD_TCPSPDTEST_ENGINE_GLOBAL_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_ENGINE_GLOBAL_TABLE_PTR(core_id)	( TCPSPDTEST_ENGINE_GLOBAL_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_ENGINE_GLOBAL_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_ENGINE_GLOBAL_TABLE */


/* >>>PKTGEN_NUM_OF_AVAIL_SBPM_HDRS */

#define RDD_PKTGEN_NUM_OF_AVAIL_SBPM_HDRS_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_NUM_OF_AVAIL_SBPM_HDRS_STRUCT;

extern uint32_t RDD_PKTGEN_NUM_OF_AVAIL_SBPM_HDRS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_NUM_OF_AVAIL_SBPM_HDRS_PTR(core_id)	( PKTGEN_NUM_OF_AVAIL_SBPM_HDRS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_NUM_OF_AVAIL_SBPM_HDRS_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_NUM_OF_AVAIL_SBPM_HDRS */


/* >>>PKTGEN_SBPM_END_PTR */

#define RDD_PKTGEN_SBPM_END_PTR_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_SBPM_END_PTR_STRUCT;

extern uint32_t RDD_PKTGEN_SBPM_END_PTR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_SBPM_END_PTR_PTR(core_id)	( PKTGEN_SBPM_END_PTR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_SBPM_END_PTR_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_SBPM_END_PTR */


/* >>>CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE */

#define RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_SIZE     1
typedef struct
{
	CPU_RING_INTERRUPT_COUNTER_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_PTR(core_id)	( CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_RING_INTERRUPT_COUNTER_TABLE */


/* >>>CPU_RX_COPY_UPDATE_FIFO_TABLE */

#define RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_PTR(core_id)	( CPU_RX_COPY_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_UPDATE_FIFO_TABLE */


/* >>>PKTGEN_SBPM_HDR_BNS */

/* >>>PKTGEN_SBPM_HDR_BN_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	first_bn  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ext_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	ext_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	first_bn  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) PKTGEN_SBPM_HDR_BN_STRUCT;

#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 2, 14, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 2, 14, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v))
/* <<<PKTGEN_SBPM_HDR_BN_STRUCT */


#define RDD_PKTGEN_SBPM_HDR_BNS_SIZE     28
typedef struct
{
	PKTGEN_SBPM_HDR_BN_STRUCT	entry[ RDD_PKTGEN_SBPM_HDR_BNS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_SBPM_HDR_BNS_STRUCT;

extern uint32_t RDD_PKTGEN_SBPM_HDR_BNS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_SBPM_HDR_BNS_PTR(core_id)	( PKTGEN_SBPM_HDR_BNS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_SBPM_HDR_BNS_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_SBPM_HDR_BNS */


/* >>>CPU_FEED_RING_INDEX_DDR_ADDR_TABLE */

#define RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_SIZE     1
typedef struct
{
	DDR_ADDRESS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_PTR(core_id)	( CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_INDEX_DDR_ADDR_TABLE */


/* >>>COMMON_REPROCESSING_UPDATE_FIFO_TABLE */

#define RDD_COMMON_REPROCESSING_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_COMMON_REPROCESSING_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ COMMON_REPROCESSING_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_COMMON_REPROCESSING_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_COMMON_REPROCESSING_UPDATE_FIFO_TABLE_PTR(core_id)	( COMMON_REPROCESSING_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_COMMON_REPROCESSING_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<COMMON_REPROCESSING_UPDATE_FIFO_TABLE */


/* >>>CPU_RX_COPY_DISPATCHER_CREDIT_TABLE */

#define RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_COPY_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_COPY_DISPATCHER_CREDIT_TABLE */


/* >>>PKTGEN_BAD_GET_NEXT */

#define RDD_PKTGEN_BAD_GET_NEXT_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_BAD_GET_NEXT_STRUCT;

extern uint32_t RDD_PKTGEN_BAD_GET_NEXT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_BAD_GET_NEXT_PTR(core_id)	( PKTGEN_BAD_GET_NEXT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_BAD_GET_NEXT_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_BAD_GET_NEXT */


/* >>>UDPSPDT_TX_PARAMS_TABLE */

/* >>>UDPSPDT_TX_PARAMS_STRUCT */
typedef union
{
    uint32_t word_32[6];
    uint64_t dword_64[3];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	total_num_of_pkts	;
        uint16_t	packet_size      	;
        uint16_t	reserved1        	;
        uint32_t	curr_bucket      	;
        uint32_t	bucket_budget    	;
        uint32_t	reserved2        	;
        uint32_t	max_bucket_size  	;
#else
        uint32_t	total_num_of_pkts	;
        uint16_t	reserved1        	;
        uint16_t	packet_size      	;
        uint32_t	curr_bucket      	;
        uint32_t	bucket_budget    	;
        uint32_t	reserved2        	;
        uint32_t	max_bucket_size  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) UDPSPDT_TX_PARAMS_STRUCT;

#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ(r, p)                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ(r, p)                       MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ(r, p)                     MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ(r, p)                   MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 20, (v))
/* <<<UDPSPDT_TX_PARAMS_STRUCT */


#define RDD_UDPSPDT_TX_PARAMS_TABLE_SIZE     4
typedef struct
{
	UDPSPDT_TX_PARAMS_STRUCT	entry[ RDD_UDPSPDT_TX_PARAMS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ UDPSPDT_TX_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_UDPSPDT_TX_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_UDPSPDT_TX_PARAMS_TABLE_PTR(core_id)	( UDPSPDT_TX_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_UDPSPDT_TX_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<UDPSPDT_TX_PARAMS_TABLE */


/* >>>SPDSVC_GEN_DISPATCHER_CREDIT_TABLE */

#define RDD_SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_GEN_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_GEN_DISPATCHER_CREDIT_TABLE */


/* >>>PKTGEN_MAX_UT_PKTS */

#define RDD_PKTGEN_MAX_UT_PKTS_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_MAX_UT_PKTS_STRUCT;

extern uint32_t RDD_PKTGEN_MAX_UT_PKTS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_MAX_UT_PKTS_PTR(core_id)	( PKTGEN_MAX_UT_PKTS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_MAX_UT_PKTS_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_MAX_UT_PKTS */


/* >>>TCPSPDTEST_DISPATCHER_CREDIT_TABLE */

#define RDD_TCPSPDTEST_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_TCPSPDTEST_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_TCPSPDTEST_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( TCPSPDTEST_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_DISPATCHER_CREDIT_TABLE */


/* >>>PKTGEN_UT_TRIGGER */

#define RDD_PKTGEN_UT_TRIGGER_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_UT_TRIGGER_STRUCT;

extern uint32_t RDD_PKTGEN_UT_TRIGGER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_UT_TRIGGER_PTR(core_id)	( PKTGEN_UT_TRIGGER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_UT_TRIGGER_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_UT_TRIGGER */


/* >>>CPU_VPORT_TO_METER_TABLE */

#define RDD_CPU_VPORT_TO_METER_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_VPORT_TO_METER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_VPORT_TO_METER_TABLE_STRUCT;

extern uint32_t RDD_CPU_VPORT_TO_METER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_VPORT_TO_METER_TABLE_PTR(core_id)	( CPU_VPORT_TO_METER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_VPORT_TO_METER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_VPORT_TO_METER_TABLE */


/* >>>COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE */

#define RDD_COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<COMMON_REPROCESSING_DISPATCHER_CREDIT_TABLE */


/* >>>TCPSPDTEST_UPDATE_FIFO_TABLE */

#define RDD_TCPSPDTEST_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_TCPSPDTEST_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_TCPSPDTEST_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_UPDATE_FIFO_TABLE_PTR(core_id)	( TCPSPDTEST_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_UPDATE_FIFO_TABLE */


/* >>>TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE */

#define RDD_TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TCPSPDTEST_GEN_DISPATCHER_CREDIT_TABLE */


/* >>>GENERAL_TIMER_ACTION_VEC */

#define RDD_GENERAL_TIMER_ACTION_VEC_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GENERAL_TIMER_ACTION_VEC_STRUCT;

extern uint32_t RDD_GENERAL_TIMER_ACTION_VEC_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GENERAL_TIMER_ACTION_VEC_PTR(core_id)	( GENERAL_TIMER_ACTION_VEC_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GENERAL_TIMER_ACTION_VEC_ADDRESS_ARR[core_id] ))

/* <<<GENERAL_TIMER_ACTION_VEC */


/* >>>CPU_FEED_RING_INTERRUPT_THRESHOLD */

#define RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_INTERRUPT_THRESHOLD_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_PTR(core_id)	( CPU_FEED_RING_INTERRUPT_THRESHOLD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_INTERRUPT_THRESHOLD_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_INTERRUPT_THRESHOLD */


/* >>>CPU_FEED_RING_INTERRUPT_COUNTER */

#define RDD_CPU_FEED_RING_INTERRUPT_COUNTER_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_INTERRUPT_COUNTER_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_INTERRUPT_COUNTER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_INTERRUPT_COUNTER_PTR(core_id)	( CPU_FEED_RING_INTERRUPT_COUNTER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_INTERRUPT_COUNTER_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_INTERRUPT_COUNTER */


/* >>>CPU_RECYCLE_RING_DESCRIPTOR_TABLE */

#define RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_SIZE     1
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_PTR(core_id)	( CPU_RECYCLE_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_RING_DESCRIPTOR_TABLE */


/* >>>PD_FIFO_TABLE */

#define RDD_PD_FIFO_TABLE_SIZE     2
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PD_FIFO_TABLE_PTR(core_id)	( PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<PD_FIFO_TABLE */


/* >>>CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE */

#define RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_SIZE     2
typedef struct
{
	DDR_ADDRESS_STRUCT	entry[ RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_PTR(core_id)	( CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_RING_INDEX_DDR_ADDR_TABLE */


/* >>>CPU_INTERRUPT_COALESCING_TABLE */

#define RDD_CPU_INTERRUPT_COALESCING_TABLE_SIZE     1
typedef struct
{
	CPU_INTERRUPT_COALESCING_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_INTERRUPT_COALESCING_TABLE_STRUCT;

extern uint32_t RDD_CPU_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_INTERRUPT_COALESCING_TABLE_PTR(core_id)	( CPU_INTERRUPT_COALESCING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_INTERRUPT_COALESCING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_INTERRUPT_COALESCING_TABLE */


/* >>>COMMON_REPROCESSING_PD_FIFO_TABLE */

#define RDD_COMMON_REPROCESSING_PD_FIFO_TABLE_SIZE     2
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_COMMON_REPROCESSING_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ COMMON_REPROCESSING_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_COMMON_REPROCESSING_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_COMMON_REPROCESSING_PD_FIFO_TABLE_PTR(core_id)	( COMMON_REPROCESSING_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_COMMON_REPROCESSING_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<COMMON_REPROCESSING_PD_FIFO_TABLE */


/* >>>CPU_RECYCLE_INTERRUPT_SCRATCH */

#define RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_SIZE     2
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_INTERRUPT_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_PTR(core_id)	( CPU_RECYCLE_INTERRUPT_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_INTERRUPT_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_INTERRUPT_SCRATCH */


/* >>>CPU_RX_LOCAL_SCRATCH */

#define RDD_CPU_RX_LOCAL_SCRATCH_SIZE     2
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_RX_LOCAL_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RX_LOCAL_SCRATCH_STRUCT;

extern uint32_t RDD_CPU_RX_LOCAL_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RX_LOCAL_SCRATCH_PTR(core_id)	( CPU_RX_LOCAL_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RX_LOCAL_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<CPU_RX_LOCAL_SCRATCH */


/* >>>VPORT_TO_CPU_OBJ */

#define RDD_VPORT_TO_CPU_OBJ_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_VPORT_TO_CPU_OBJ_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VPORT_TO_CPU_OBJ_STRUCT;

extern uint32_t RDD_VPORT_TO_CPU_OBJ_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VPORT_TO_CPU_OBJ_PTR(core_id)	( VPORT_TO_CPU_OBJ_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VPORT_TO_CPU_OBJ_ADDRESS_ARR[core_id] ))

/* <<<VPORT_TO_CPU_OBJ */


/* >>>PKTGEN_SBPM_EXTS */

/* >>>PKTGEN_SBPM_EXT_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_bns	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn1       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	bn1       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_bns	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) PKTGEN_SBPM_EXT_STRUCT;

#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (r))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (v))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p) + 0, 14, 4, (r))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p) + 0, 14, 4, (v))
#define RDD_PKTGEN_SBPM_EXT_BN1_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (r))
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (v))
#define RDD_PKTGEN_SBPM_EXT_BN1_READ(r, p)                        FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 14, (r))
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE(v, p)                       FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 14, (v))
/* <<<PKTGEN_SBPM_EXT_STRUCT */


#define RDD_PKTGEN_SBPM_EXTS_SIZE     4
typedef struct
{
	PKTGEN_SBPM_EXT_STRUCT	entry[ RDD_PKTGEN_SBPM_EXTS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_SBPM_EXTS_STRUCT;

extern uint32_t RDD_PKTGEN_SBPM_EXTS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_SBPM_EXTS_PTR(core_id)	( PKTGEN_SBPM_EXTS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_SBPM_EXTS_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_SBPM_EXTS */


/* >>>PKTGEN_FPM_UG_MGMT */

/* >>>PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[5];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_ug_cnt_dummy   	;
        uint32_t	fpm_ug_cnt         	;
        uint32_t	fpm_ug_cnt_reg_addr	;
        uint32_t	fpm_ug_threshold   	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_tokens_quantum 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	budget             	;
#else
        uint32_t	fpm_ug_cnt_dummy   	;
        uint32_t	fpm_ug_cnt         	;
        uint32_t	fpm_ug_cnt_reg_addr	;
        uint32_t	fpm_tokens_quantum 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_ug_threshold   	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	budget             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT;

#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ(r, p)                    MREAD_32((uint8_t *)(p), (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE(v, p)                   MWRITE_32((uint8_t *)(p), (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ(r, p)                          MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ(r, p)                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ_G(r, g, idx)             GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ(r, p)                    FIELD_MREAD_32((uint8_t *)(p) + 12, 4, 28, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE(v, p)                   FIELD_MWRITE_32((uint8_t *)(p) + 12, 4, 28, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ(r, p)                              MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 16, (v))
/* <<<PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT */


#define RDD_PKTGEN_FPM_UG_MGMT_SIZE     1
typedef struct
{
	PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_FPM_UG_MGMT_STRUCT;

extern uint32_t RDD_PKTGEN_FPM_UG_MGMT_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_FPM_UG_MGMT_PTR(core_id)	( PKTGEN_FPM_UG_MGMT_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_FPM_UG_MGMT_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_FPM_UG_MGMT */


/* >>>SPDSVC_TCPSPDTEST_COMMON_TABLE */

/* >>>SPDSVC_TCPSPDTEST_COMMON_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	cpu_rx_copy_is_tcpspdtest_timeout_wakeup	;
#else
        uint8_t	cpu_rx_copy_is_tcpspdtest_timeout_wakeup	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} SPDSVC_TCPSPDTEST_COMMON_ENTRY_STRUCT;

#define RDD_SPDSVC_TCPSPDTEST_COMMON_ENTRY_CPU_RX_COPY_IS_TCPSPDTEST_TIMEOUT_WAKEUP_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(SPDSVC_TCPSPDTEST_COMMON_ENTRY_STRUCT), (r))
#define RDD_SPDSVC_TCPSPDTEST_COMMON_ENTRY_CPU_RX_COPY_IS_TCPSPDTEST_TIMEOUT_WAKEUP_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(SPDSVC_TCPSPDTEST_COMMON_ENTRY_STRUCT), (v))
#define RDD_SPDSVC_TCPSPDTEST_COMMON_ENTRY_CPU_RX_COPY_IS_TCPSPDTEST_TIMEOUT_WAKEUP_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_SPDSVC_TCPSPDTEST_COMMON_ENTRY_CPU_RX_COPY_IS_TCPSPDTEST_TIMEOUT_WAKEUP_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<SPDSVC_TCPSPDTEST_COMMON_ENTRY_STRUCT */


#define RDD_SPDSVC_TCPSPDTEST_COMMON_TABLE_SIZE     1
typedef struct
{
	SPDSVC_TCPSPDTEST_COMMON_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_TCPSPDTEST_COMMON_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_TCPSPDTEST_COMMON_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_TCPSPDTEST_COMMON_TABLE_PTR(core_id)	( SPDSVC_TCPSPDTEST_COMMON_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_TCPSPDTEST_COMMON_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_TCPSPDTEST_COMMON_TABLE */


/* >>>CPU_FEED_RING_CACHE_OFFSET */

#define RDD_CPU_FEED_RING_CACHE_OFFSET_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_FEED_RING_CACHE_OFFSET_STRUCT;

extern uint32_t RDD_CPU_FEED_RING_CACHE_OFFSET_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_FEED_RING_CACHE_OFFSET_PTR(core_id)	( CPU_FEED_RING_CACHE_OFFSET_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_FEED_RING_CACHE_OFFSET_ADDRESS_ARR[core_id] ))

/* <<<CPU_FEED_RING_CACHE_OFFSET */


/* >>>PKTGEN_BBMSG_REPLY_SCRATCH */

#define RDD_PKTGEN_BBMSG_REPLY_SCRATCH_SIZE     2
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_PKTGEN_BBMSG_REPLY_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_BBMSG_REPLY_SCRATCH_STRUCT;

extern uint32_t RDD_PKTGEN_BBMSG_REPLY_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_BBMSG_REPLY_SCRATCH_PTR(core_id)	( PKTGEN_BBMSG_REPLY_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_BBMSG_REPLY_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_BBMSG_REPLY_SCRATCH */


/* >>>CPU_RECYCLE_SHADOW_RD_IDX */

#define RDD_CPU_RECYCLE_SHADOW_RD_IDX_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_SHADOW_RD_IDX_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_SHADOW_RD_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_SHADOW_RD_IDX_PTR(core_id)	( CPU_RECYCLE_SHADOW_RD_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_SHADOW_RD_IDX_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_SHADOW_RD_IDX */


/* >>>CSO_DISABLE */

#define RDD_CSO_DISABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CSO_DISABLE_STRUCT;

extern uint32_t RDD_CSO_DISABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CSO_DISABLE_PTR(core_id)	( CSO_DISABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CSO_DISABLE_ADDRESS_ARR[core_id] ))

/* <<<CSO_DISABLE */


/* >>>CPU_RECYCLE_SHADOW_WR_IDX */

#define RDD_CPU_RECYCLE_SHADOW_WR_IDX_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_SHADOW_WR_IDX_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_SHADOW_WR_IDX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_SHADOW_WR_IDX_PTR(core_id)	( CPU_RECYCLE_SHADOW_WR_IDX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_SHADOW_WR_IDX_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_SHADOW_WR_IDX */


/* >>>CPU_RECYCLE_NEXT_PTR_TABLE */

#define RDD_CPU_RECYCLE_NEXT_PTR_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_RECYCLE_NEXT_PTR_TABLE_STRUCT;

extern uint32_t RDD_CPU_RECYCLE_NEXT_PTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_RECYCLE_NEXT_PTR_TABLE_PTR(core_id)	( CPU_RECYCLE_NEXT_PTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_RECYCLE_NEXT_PTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_RECYCLE_NEXT_PTR_TABLE */


/* >>>PKTGEN_TX_STREAM_SCRATCH_TABLE */

/* >>>PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0 	;
        uint16_t	csum_value	;
        uint16_t	reserved1 	;
#else
        uint32_t	reserved0 	;
        uint16_t	reserved1 	;
        uint16_t	csum_value	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT;

#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ(r, p)                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT */


#define RDD_PKTGEN_TX_STREAM_SCRATCH_TABLE_SIZE     1
typedef struct
{
	PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ PKTGEN_TX_STREAM_SCRATCH_TABLE_STRUCT;

extern uint32_t RDD_PKTGEN_TX_STREAM_SCRATCH_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PKTGEN_TX_STREAM_SCRATCH_TABLE_PTR(core_id)	( PKTGEN_TX_STREAM_SCRATCH_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PKTGEN_TX_STREAM_SCRATCH_TABLE_ADDRESS_ARR[core_id] ))

/* <<<PKTGEN_TX_STREAM_SCRATCH_TABLE */

/* CORE_2 */

/* >>>SERVICE_QUEUES_RATE_LIMITER_TABLE */

/* >>>BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rl_type       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2     	:21	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	block_type    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	block_index   	;
        uint32_t	current_budget	;
        uint32_t	alloc_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved      	;
#else
        uint8_t	block_index   	;
        uint32_t	block_type    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2     	:21	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rl_type       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	current_budget	;
        uint32_t	limit_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT;

#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_RL_TYPE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 2, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 2, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_TYPE_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_READ(r, p)                    MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_BLOCK_INDEX_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 10, 2, 14, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 10, 2, 14, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (v))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 2, (r))
#define RDD_BASIC_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 2, (v))
/* <<<BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT */


#define RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_SIZE     66
typedef struct
{
	BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_RATE_LIMITER_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_PTR(core_id)	( SERVICE_QUEUES_RATE_LIMITER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_RATE_LIMITER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_RATE_LIMITER_TABLE */


/* >>>CPU_TX_DBG_CNTRS_TABLE */

/* >>>CPU_TX_DBG_CNTRS_STRUCT */
#define RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER	5
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
#else
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_TX_DBG_CNTRS_STRUCT;

#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ(r, p)                            MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE(v, p)                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ(r, p)                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ(r, p)                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ(r, p)                               MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_G(r, g, idx)                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_G(v, g, idx)                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ(r, p)                               MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE(v, p)                              MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ(r, p)                 MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ(r, p)                       MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ(r, p)                                MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ(r, p)                              MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 40, (v))
/* <<<CPU_TX_DBG_CNTRS_STRUCT */


#define RDD_CPU_TX_DBG_CNTRS_TABLE_SIZE     2
typedef struct
{
	CPU_TX_DBG_CNTRS_STRUCT	entry[ RDD_CPU_TX_DBG_CNTRS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_DBG_CNTRS_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_DBG_CNTRS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_DBG_CNTRS_TABLE_PTR(core_id)	( CPU_TX_DBG_CNTRS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_DBG_CNTRS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_DBG_CNTRS_TABLE */


/* >>>SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE */

/* >>>SCHEDULING_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	prefetch_pd           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropped_recently	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_index       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	block_type            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_enable          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropping        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_index       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	queue_bit_mask        	;
        uint8_t	rate_limiter_index    	;
        uint8_t	quantum_number        	;
        uint16_t	deficit_counter       	;
#else
        uint8_t	queue_bit_mask        	;
        uint32_t	scheduler_index       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropping        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_enable          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	block_type            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_index       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_dropped_recently	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	prefetch_pd           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	deficit_counter       	;
        uint8_t	quantum_number        	;
        uint8_t	rate_limiter_index    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) SCHEDULING_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_PREFETCH_PD_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPED_RECENTLY_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 0, 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT), 0, 6, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BBH_QUEUE_INDEX_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_BLOCK_TYPE_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_ENABLE_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 5, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 5, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 4, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 1, 4, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_ENABLE_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_CODEL_DROPPING_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 0, 7, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 2, 0, 7, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 7, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 7, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_READ(r, p)                         MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUEUE_BIT_MASK_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_READ(r, p)                     MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 5, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 5, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_READ(r, p)                         MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_QUANTUM_NUMBER_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(SCHEDULING_QUEUE_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_READ(r, p)                        MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_SCHEDULING_QUEUE_DESCRIPTOR_DEFICIT_COUNTER_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<SCHEDULING_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_SIZE     32
typedef struct
{
	SCHEDULING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_PTR(core_id)	( SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_SCHEDULING_QUEUE_TABLE */


/* >>>CODEL_SQ_TABLE */

/* >>>CODEL_SQ_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	ts        	;
#else
        uint16_t	ts        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) CODEL_SQ_ENTRY_STRUCT;

#define RDD_CODEL_SQ_ENTRY_TS_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CODEL_SQ_ENTRY_STRUCT), (r))
#define RDD_CODEL_SQ_ENTRY_TS_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_SQ_ENTRY_STRUCT), (v))
#define RDD_CODEL_SQ_ENTRY_TS_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_CODEL_SQ_ENTRY_TS_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<CODEL_SQ_ENTRY_STRUCT */


#define RDD_CODEL_SQ_TABLE_SIZE     32
typedef struct
{
	CODEL_SQ_ENTRY_STRUCT	entry[ RDD_CODEL_SQ_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CODEL_SQ_TABLE_STRUCT;

extern uint32_t RDD_CODEL_SQ_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CODEL_SQ_TABLE_PTR(core_id)	( CODEL_SQ_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CODEL_SQ_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CODEL_SQ_TABLE */


/* >>>CPU_TX_0_STACK */

#define RDD_CPU_TX_0_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_TX_0_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_0_STACK_STRUCT;

extern uint32_t RDD_CPU_TX_0_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_0_STACK_PTR(core_id)	( CPU_TX_0_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_0_STACK_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_0_STACK */


/* >>>CPU_TX_SCRATCHPAD */

#define RDD_CPU_TX_SCRATCHPAD_SIZE     128
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_CPU_TX_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_SCRATCHPAD_STRUCT;

extern uint32_t RDD_CPU_TX_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_SCRATCHPAD_PTR(core_id)	( CPU_TX_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_SCRATCHPAD */


/* >>>SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE */

/* >>>COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT */
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RESERVED3_NUMBER	3
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_NUMBER	32
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_positive_budget                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue                                                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limiter_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_pir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_sir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	last_served_block_pir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	last_served_block_sir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	status_bit_vector                                                   	;
        uint32_t	slot_budget_bit_vector_0                                            	;
        uint32_t	slot_budget_bit_vector_1                                            	;
        uint32_t	is_scheduler_slot                                                   	;
        uint32_t	is_scheduler_basic                                                  	;
        uint32_t	ovl_rl_en                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_exists                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_index                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_slot_index                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                           	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	deficit_counter                                                     	;
        uint8_t	quantum_number                                                      	;
        uint8_t	reserved3[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RESERVED3_NUMBER];
        uint8_t	block_index[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_NUMBER];
#else
        uint32_t	last_served_block_sir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	last_served_block_pir                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_sir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset_pir                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limiter_index                                                  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue                                                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_positive_budget                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	status_bit_vector                                                   	;
        uint32_t	slot_budget_bit_vector_0                                            	;
        uint32_t	slot_budget_bit_vector_1                                            	;
        uint32_t	is_scheduler_slot                                                   	;
        uint32_t	is_scheduler_basic                                                  	;
        uint16_t	deficit_counter                                                     	;
        uint32_t	reserved2                                                           	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_slot_index                                         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_index                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_scheduler_exists                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ovl_rl_en                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved3[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RESERVED3_NUMBER];
        uint8_t	quantum_number                                                      	;
        uint8_t	block_index[RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT;

#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 0, 6, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT), 0, 6, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BBH_QUEUE_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 1, 0, 7, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 1, 0, 7, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 7, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 7, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_PIR_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 2, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 2, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 3, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_SIR_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 3, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 5, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 2, 5, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_PIR_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 2, 5, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 3, 0, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 3, 0, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_LAST_SERVED_BLOCK_SIR_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ(r, p)                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_READ(r, p)                    MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_0_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_READ(r, p)                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_1_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 16, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 16, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_READ(r, p)                           MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_SLOT_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 20, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 20, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_READ(r, p)                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_IS_SCHEDULER_BASIC_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ_G(r, g, idx)                            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 7, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE_G(v, g, idx)                           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 7, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ(r, p)                                   FIELD_MREAD_8((uint8_t *)(p) + 24, 7, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE(v, p)                                  FIELD_MWRITE_8((uint8_t *)(p) + 24, 7, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 24, 6, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 24, 6, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 5, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 5, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 24, 5, 1, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_EXISTS_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 24, 5, 1, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 1, 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 1, 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p) + 24, 1, 4, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_INDEX_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p) + 24, 1, 4, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 4, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 24, 4, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 24, 4, 5, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_PARENT_SCHEDULER_SLOT_INDEX_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 24, 4, 5, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ_G(r, g, idx)                      GROUP_MREAD_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 26, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE_G(v, g, idx)                     GROUP_MWRITE_16((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 26, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ(r, p)                             MREAD_16((uint8_t *)(p) + 26, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE(v, p)                            MWRITE_16((uint8_t *)(p) + 26, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 28, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 28, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ(r, p)                              MREAD_8((uint8_t *)(p) + 28, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE(v, p)                             MWRITE_8((uint8_t *)(p) + 28, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_READ_G(r, g, idx, i)                       GROUP_MREAD_I_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 32, i, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_WRITE_G(v, g, idx, i)                      GROUP_MWRITE_I_8((g), (idx)*sizeof(COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT) + 32, i, (v))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_READ(r, p, i)                              MREAD_I_8((uint8_t *)(p) + 32, i, (r))
#define RDD_COMPLEX_SCHEDULER_DESCRIPTOR_BLOCK_INDEX_WRITE(v, p, i)                             MWRITE_I_8((uint8_t *)(p) + 32, i, (v))
/* <<<COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT */


#define RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_SIZE     1
typedef struct
{
	COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_PTR(core_id)	( SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_COMPLEX_SCHEDULER_TABLE */


/* >>>SERVICE_QUEUES_PD_FIFO_TABLE */

#define RDD_SERVICE_QUEUES_PD_FIFO_TABLE_SIZE     64
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_PD_FIFO_TABLE_PTR(core_id)	( SERVICE_QUEUES_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_PD_FIFO_TABLE */


/* >>>CODEL_BIAS_SLOPE_TABLE */

/* >>>CODEL_BIAS_SLOPE_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	bias      	;
        uint16_t	slope     	;
#else
        uint16_t	slope     	;
        uint16_t	bias      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) CODEL_BIAS_SLOPE_STRUCT;

#define RDD_CODEL_BIAS_SLOPE_BIAS_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(CODEL_BIAS_SLOPE_STRUCT), (r))
#define RDD_CODEL_BIAS_SLOPE_BIAS_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_BIAS_SLOPE_STRUCT), (v))
#define RDD_CODEL_BIAS_SLOPE_BIAS_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_CODEL_BIAS_SLOPE_BIAS_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_CODEL_BIAS_SLOPE_SLOPE_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CODEL_BIAS_SLOPE_STRUCT) + 2, (r))
#define RDD_CODEL_BIAS_SLOPE_SLOPE_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_BIAS_SLOPE_STRUCT) + 2, (v))
#define RDD_CODEL_BIAS_SLOPE_SLOPE_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CODEL_BIAS_SLOPE_SLOPE_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CODEL_BIAS_SLOPE_STRUCT */


#define RDD_CODEL_BIAS_SLOPE_TABLE_SIZE     11
typedef struct
{
	CODEL_BIAS_SLOPE_STRUCT	entry[ RDD_CODEL_BIAS_SLOPE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CODEL_BIAS_SLOPE_TABLE_STRUCT;

extern uint32_t RDD_CODEL_BIAS_SLOPE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CODEL_BIAS_SLOPE_TABLE_PTR(core_id)	( CODEL_BIAS_SLOPE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CODEL_BIAS_SLOPE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CODEL_BIAS_SLOPE_TABLE */


/* >>>DDR_LATENCY_DBG_USEC */

#define RDD_DDR_LATENCY_DBG_USEC_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DDR_LATENCY_DBG_USEC_STRUCT;

extern uint32_t RDD_DDR_LATENCY_DBG_USEC_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DDR_LATENCY_DBG_USEC_PTR(core_id)	( DDR_LATENCY_DBG_USEC_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DDR_LATENCY_DBG_USEC_ADDRESS_ARR[core_id] ))

/* <<<DDR_LATENCY_DBG_USEC */


/* >>>CPU_TX_1_STACK */

#define RDD_CPU_TX_1_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_CPU_TX_1_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_1_STACK_STRUCT;

extern uint32_t RDD_CPU_TX_1_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_1_STACK_PTR(core_id)	( CPU_TX_1_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_1_STACK_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_1_STACK */


/* >>>QUEUE_THRESHOLD_VECTOR */

#define RDD_QUEUE_THRESHOLD_VECTOR_SIZE     9
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_QUEUE_THRESHOLD_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ QUEUE_THRESHOLD_VECTOR_STRUCT;

extern uint32_t RDD_QUEUE_THRESHOLD_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_QUEUE_THRESHOLD_VECTOR_PTR(core_id)	( QUEUE_THRESHOLD_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_QUEUE_THRESHOLD_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<QUEUE_THRESHOLD_VECTOR */


/* >>>DDR_LATENCY_DBG_USEC_MAX */

#define RDD_DDR_LATENCY_DBG_USEC_MAX_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DDR_LATENCY_DBG_USEC_MAX_STRUCT;

extern uint32_t RDD_DDR_LATENCY_DBG_USEC_MAX_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DDR_LATENCY_DBG_USEC_MAX_PTR(core_id)	( DDR_LATENCY_DBG_USEC_MAX_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DDR_LATENCY_DBG_USEC_MAX_ADDRESS_ARR[core_id] ))

/* <<<DDR_LATENCY_DBG_USEC_MAX */


/* >>>BUFFER_ALLOC_REPLY */

#define RDD_BUFFER_ALLOC_REPLY_SIZE     2
typedef struct
{
	BYTES_8_STRUCT	entry[ RDD_BUFFER_ALLOC_REPLY_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BUFFER_ALLOC_REPLY_STRUCT;

extern uint32_t RDD_BUFFER_ALLOC_REPLY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BUFFER_ALLOC_REPLY_PTR(core_id)	( BUFFER_ALLOC_REPLY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BUFFER_ALLOC_REPLY_ADDRESS_ARR[core_id] ))

/* <<<BUFFER_ALLOC_REPLY */


/* >>>SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR */

#define RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_PTR(core_id)	( SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_SCHEDULING_QUEUE_AGING_VECTOR */


/* >>>SERVICE_QUEUES_CODEL_QUEUE_TABLE */

/* >>>CODEL_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	window_ts    	;
        uint16_t	drop_interval	;
#else
        uint16_t	drop_interval	;
        uint16_t	window_ts    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) CODEL_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_CODEL_QUEUE_DESCRIPTOR_WINDOW_TS_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(CODEL_QUEUE_DESCRIPTOR_STRUCT), (r))
#define RDD_CODEL_QUEUE_DESCRIPTOR_WINDOW_TS_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_QUEUE_DESCRIPTOR_STRUCT), (v))
#define RDD_CODEL_QUEUE_DESCRIPTOR_WINDOW_TS_READ(r, p)                     MREAD_16((uint8_t *)(p), (r))
#define RDD_CODEL_QUEUE_DESCRIPTOR_WINDOW_TS_WRITE(v, p)                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_CODEL_QUEUE_DESCRIPTOR_DROP_INTERVAL_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CODEL_QUEUE_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_CODEL_QUEUE_DESCRIPTOR_DROP_INTERVAL_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_QUEUE_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_CODEL_QUEUE_DESCRIPTOR_DROP_INTERVAL_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CODEL_QUEUE_DESCRIPTOR_DROP_INTERVAL_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CODEL_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_SERVICE_QUEUES_CODEL_QUEUE_TABLE_SIZE     32
typedef struct
{
	CODEL_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_SERVICE_QUEUES_CODEL_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_CODEL_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_CODEL_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_CODEL_QUEUE_TABLE_PTR(core_id)	( SERVICE_QUEUES_CODEL_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_CODEL_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_CODEL_QUEUE_TABLE */


/* >>>SERVICE_QUEUES_UPDATE_FIFO_TABLE */

#define RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_PTR(core_id)	( SERVICE_QUEUES_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_UPDATE_FIFO_TABLE */


/* >>>CPU_TX_RING_INDICES_VALUES_TABLE */

/* >>>CPU_TX_RING_INDICES_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	read_idx  	;
        uint16_t	write_idx 	;
#else
        uint16_t	write_idx 	;
        uint16_t	read_idx  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) CPU_TX_RING_INDICES_STRUCT;

#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CPU_TX_RING_INDICES_STRUCT */


#define RDD_CPU_TX_RING_INDICES_VALUES_TABLE_SIZE     2
typedef struct
{
	CPU_TX_RING_INDICES_STRUCT	entry[ RDD_CPU_TX_RING_INDICES_VALUES_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_RING_INDICES_VALUES_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_RING_INDICES_VALUES_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_RING_INDICES_VALUES_TABLE_PTR(core_id)	( CPU_TX_RING_INDICES_VALUES_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_RING_INDICES_VALUES_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_RING_INDICES_VALUES_TABLE */


/* >>>SERVICE_QUEUES_FLUSH_CFG_FW_TABLE */

/* >>>FLUSH_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pd_num            	;
        uint8_t	flush_aggr        	;
        uint8_t	qm_queue          	;
        uint32_t	ug_counter_address	;
        uint16_t	reserved1         	;
        uint16_t	ug_threshold_low  	;
        uint32_t	ug_counter        	;
#else
        uint8_t	qm_queue          	;
        uint8_t	flush_aggr        	;
        uint8_t	pd_num            	;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ug_counter_address	;
        uint16_t	ug_threshold_low  	;
        uint16_t	reserved1         	;
        uint32_t	ug_counter        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) FLUSH_CFG_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ(r, p)                             MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ(r, p)                         MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ_G(r, g, idx)                    GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE_G(v, g, idx)                   GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ(r, p)                           MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE(v, p)                          MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ_G(r, g, idx)            GROUP_MREAD_16((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 10, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE_G(v, g, idx)           GROUP_MWRITE_16((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 10, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ(r, p)                   MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE(v, p)                  MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ(r, p)                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<FLUSH_CFG_ENTRY_STRUCT */


#define RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_PTR(core_id)	( SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FLUSH_CFG_FW_TABLE */


/* >>>RING_CPU_TX_DESCRIPTOR_DATA_TABLE */

/* >>>RING_CPU_TX_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_egress           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sk_buf_ptr_high     	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	reserved1                     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	fpm_fallback        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_dont_drop    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pkt_buf_ptr_high    	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lag_index         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ssid              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_dont_drop  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_pkt_buf_ptr_high  	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	flow_or_port_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lag_index         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ssid              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_dont_drop  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_pkt_buf_ptr_high  	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low               	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved0                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                       	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_bn0                       	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	sk_buf_ptr_high     	;
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_egress           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	pkt_buf_ptr_high    	;
        uint32_t	reserved            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_dont_drop    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_fallback        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_pkt_buf_ptr_high  	;
        uint32_t	reservedSU1_reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_dont_drop  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ssid              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lag_index         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_pkt_buf_ptr_high  	;
        uint32_t	reservedSU2_reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_dont_drop  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ssid              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lag_index         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_fpm_fallback      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_or_port_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	is_vport                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low               	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	fpm_bn0                       	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                       	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved0                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) RING_CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                        FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                       FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                        FIELD_MREAD_32((uint8_t *)(p) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                       FIELD_MWRITE_32((uint8_t *)(p) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ(r, p)                      MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_G(r, g, idx)   GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_G(v, g, idx)  GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ(r, p)          MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE(v, p)         MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ(r, p)                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                            FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                           FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_G(r, g, idx)    GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_G(v, g, idx)   GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ(r, p)           FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE(v, p)          FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_G(r, g, idx)              GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_G(v, g, idx)             GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ(r, p)                     MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE(v, p)                    MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_G(r, g, idx)    GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_G(v, g, idx)   GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ(r, p)           MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE(v, p)          MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ(r, p)                      MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 3, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 3, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ(r, p)                              FIELD_MREAD_16((uint8_t *)(p) + 12, 3, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE(v, p)                             FIELD_MWRITE_16((uint8_t *)(p) + 12, 3, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 19, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 19, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ(r, p)                              FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 19, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE(v, p)                             FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 19, (v))
/* <<<RING_CPU_TX_DESCRIPTOR_STRUCT */


#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_SIZE     2
typedef struct
{
	RING_CPU_TX_DESCRIPTOR_STRUCT	entry[ RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RING_CPU_TX_DESCRIPTOR_DATA_TABLE_STRUCT;

extern uint32_t RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_PTR(core_id)	( RING_CPU_TX_DESCRIPTOR_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RING_CPU_TX_DESCRIPTOR_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<RING_CPU_TX_DESCRIPTOR_DATA_TABLE */


/* >>>CPU_TX_RING_DESCRIPTOR_TABLE */

#define RDD_CPU_TX_RING_DESCRIPTOR_TABLE_SIZE     2
typedef struct
{
	CPU_RING_DESCRIPTOR_STRUCT	entry[ RDD_CPU_TX_RING_DESCRIPTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_RING_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_RING_DESCRIPTOR_TABLE_PTR(core_id)	( CPU_TX_RING_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_RING_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_RING_DESCRIPTOR_TABLE */


/* >>>SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE */

#define RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_PTR(core_id)	( SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FLUSH_CFG_CURRENT_TABLE */


/* >>>SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE */

#define RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_PTR(core_id)	( SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_RATE_LIMITER_VALID_TABLE */


/* >>>SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR */

/* >>>CODEL_DROP_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	max_seq_drops          	;
        uint16_t	flush_task_wakeup_value	;
        uint16_t	flush_cfg_ptr          	;
        uint16_t	flush_enable_ptr       	;
        uint32_t	flush_packet_counter   	;
        uint32_t	flush_enable           	;
#else
        uint16_t	flush_task_wakeup_value	;
        uint16_t	max_seq_drops          	;
        uint16_t	flush_enable_ptr       	;
        uint16_t	flush_cfg_ptr          	;
        uint32_t	flush_packet_counter   	;
        uint32_t	flush_enable           	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CODEL_DROP_DESCRIPTOR_STRUCT;

#define RDD_CODEL_DROP_DESCRIPTOR_MAX_SEQ_DROPS_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT), (r))
#define RDD_CODEL_DROP_DESCRIPTOR_MAX_SEQ_DROPS_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT), (v))
#define RDD_CODEL_DROP_DESCRIPTOR_MAX_SEQ_DROPS_READ(r, p)                           MREAD_16((uint8_t *)(p), (r))
#define RDD_CODEL_DROP_DESCRIPTOR_MAX_SEQ_DROPS_WRITE(v, p)                          MWRITE_16((uint8_t *)(p), (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_TASK_WAKEUP_VALUE_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_TASK_WAKEUP_VALUE_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_TASK_WAKEUP_VALUE_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_TASK_WAKEUP_VALUE_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_CFG_PTR_READ_G(r, g, idx)                    GROUP_MREAD_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_CFG_PTR_WRITE_G(v, g, idx)                   GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_CFG_PTR_READ(r, p)                           MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_CFG_PTR_WRITE(v, p)                          MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_PTR_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_PTR_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_PTR_READ(r, p)                        MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_PTR_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_PACKET_COUNTER_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_PACKET_COUNTER_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_PACKET_COUNTER_READ(r, p)                    MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_PACKET_COUNTER_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(CODEL_DROP_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_READ(r, p)                            MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CODEL_DROP_DESCRIPTOR_FLUSH_ENABLE_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<CODEL_DROP_DESCRIPTOR_STRUCT */


#define RDD_SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR_SIZE     1
typedef struct
{
	CODEL_DROP_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR_PTR(core_id)	( SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_CODEL_DROP_DESCRIPTOR */


/* >>>CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE */

#define RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_EGRESS_DISPATCHER_CREDIT_TABLE */


/* >>>SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE */

/* >>>FLUSH_CFG_ENABLE_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	enable_fw 	;
        uint8_t	enable_cpu	;
#else
        uint8_t	enable_cpu	;
        uint8_t	enable_fw 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) FLUSH_CFG_ENABLE_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ(r, p)                  MREAD_8((uint8_t *)(p), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE(v, p)                 MWRITE_8((uint8_t *)(p), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ(r, p)                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<FLUSH_CFG_ENABLE_ENTRY_STRUCT */


#define RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENABLE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_PTR(core_id)	( SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE */


/* >>>CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE */

#define RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_INGRESS_DISPATCHER_CREDIT_TABLE */


/* >>>SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE */

#define RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_PTR(core_id)	( SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_BUDGET_ALLOCATION_TIMER_VALUE */


/* >>>CPU_TX_SYNC_FIFO_TABLE */

/* >>>CPU_TX_SYNC_FIFO_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	write_ptr 	;
        uint16_t	read_ptr  	;
        uint16_t	fifo      	;
        uint16_t	reserved  	;
#else
        uint16_t	read_ptr  	;
        uint16_t	write_ptr 	;
        uint16_t	reserved  	;
        uint16_t	fifo      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) CPU_TX_SYNC_FIFO_ENTRY_STRUCT;

#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ(r, p)                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ(r, p)                      MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<CPU_TX_SYNC_FIFO_ENTRY_STRUCT */


#define RDD_CPU_TX_SYNC_FIFO_TABLE_SIZE     2
typedef struct
{
	CPU_TX_SYNC_FIFO_ENTRY_STRUCT	entry[ RDD_CPU_TX_SYNC_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ CPU_TX_SYNC_FIFO_TABLE_STRUCT;

extern uint32_t RDD_CPU_TX_SYNC_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_CPU_TX_SYNC_FIFO_TABLE_PTR(core_id)	( CPU_TX_SYNC_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_CPU_TX_SYNC_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<CPU_TX_SYNC_FIFO_TABLE */


/* >>>SERVICE_QUEUES_FIRST_QUEUE_MAPPING */

#define RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_FIRST_QUEUE_MAPPING_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_PTR(core_id)	( SERVICE_QUEUES_FIRST_QUEUE_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_FIRST_QUEUE_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_FIRST_QUEUE_MAPPING */


/* >>>SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE */

#define RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SERVICE_QUEUES_DISPATCHER_CREDIT_TABLE */


/* >>>SQ_TX_QUEUE_DROP_TABLE */

/* >>>PACKETS_AND_BYTES_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	packets   	;
        uint32_t	bytes     	;
#else
        uint32_t	packets   	;
        uint32_t	bytes     	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PACKETS_AND_BYTES_STRUCT;

#define RDD_PACKETS_AND_BYTES_PACKETS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT), (r))
#define RDD_PACKETS_AND_BYTES_PACKETS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT), (v))
#define RDD_PACKETS_AND_BYTES_PACKETS_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_PACKETS_AND_BYTES_PACKETS_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_PACKETS_AND_BYTES_BYTES_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT) + 4, (r))
#define RDD_PACKETS_AND_BYTES_BYTES_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(PACKETS_AND_BYTES_STRUCT) + 4, (v))
#define RDD_PACKETS_AND_BYTES_BYTES_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PACKETS_AND_BYTES_BYTES_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<PACKETS_AND_BYTES_STRUCT */


#define RDD_SQ_TX_QUEUE_DROP_TABLE_SIZE     32
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_SQ_TX_QUEUE_DROP_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ SQ_TX_QUEUE_DROP_TABLE_STRUCT;

extern uint32_t RDD_SQ_TX_QUEUE_DROP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SQ_TX_QUEUE_DROP_TABLE_PTR(core_id)	( SQ_TX_QUEUE_DROP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SQ_TX_QUEUE_DROP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SQ_TX_QUEUE_DROP_TABLE */

/* CORE_3 */

/* >>>DHD_FLOW_RING_CACHE_CTX_TABLE */

/* >>>DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	flow_ring_base_low 	;
        uint8_t	flow_ring_base_high	;
        uint8_t	reserved           	;
        uint16_t	shadow_wr_idx      	;
        uint16_t	size               	;
        uint8_t	ssid               	;
        uint8_t	flags              	;
        uint16_t	rd_idx             	;
        uint16_t	wr_idx             	;
#else
        uint32_t	flow_ring_base_low 	;
        uint16_t	shadow_wr_idx      	;
        uint8_t	reserved           	;
        uint8_t	flow_ring_base_high	;
        uint8_t	flags              	;
        uint8_t	ssid               	;
        uint16_t	size               	;
        uint16_t	wr_idx             	;
        uint16_t	rd_idx             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT;

#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_LOW_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT), (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_LOW_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT), (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_LOW_READ(r, p)                  MREAD_32((uint8_t *)(p), (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_LOW_WRITE(v, p)                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_LOW_L_READ( wv )                FIELD_GET( wv, 0, 32 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_LOW_L_WRITE( v, wv )            FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_HIGH_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 4, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_HIGH_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 4, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_HIGH_READ(r, p)                 MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_HIGH_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_HIGH_L_READ( wv )               FIELD_GET( wv, 24, 8 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLOW_RING_BASE_HIGH_L_WRITE( v, wv )           FIELD_SET( v, 24, 8, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SHADOW_WR_IDX_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 6, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SHADOW_WR_IDX_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 6, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SHADOW_WR_IDX_READ(r, p)                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SHADOW_WR_IDX_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SHADOW_WR_IDX_L_READ( wv )                     FIELD_GET( wv, 0, 16 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SHADOW_WR_IDX_L_WRITE( v, wv )                 FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SIZE_READ_G(r, g, idx)                         GROUP_MREAD_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 8, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SIZE_WRITE_G(v, g, idx)                        GROUP_MWRITE_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 8, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SIZE_READ(r, p)                                MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SIZE_WRITE(v, p)                               MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SIZE_L_READ( wv )                              FIELD_GET( wv, 16, 16 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SIZE_L_WRITE( v, wv )                          FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SSID_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 10, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SSID_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 10, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SSID_READ(r, p)                                MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SSID_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SSID_L_READ( wv )                              FIELD_GET( wv, 8, 8 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_SSID_L_WRITE( v, wv )                          FIELD_SET( v, 8, 8, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLAGS_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 11, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLAGS_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 11, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLAGS_READ(r, p)                               MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLAGS_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLAGS_L_READ( wv )                             FIELD_GET( wv, 0, 8 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_FLAGS_L_WRITE( v, wv )                         FIELD_SET( v, 0, 8, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_RD_IDX_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 12, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_RD_IDX_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 12, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_RD_IDX_READ(r, p)                              MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_RD_IDX_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_RD_IDX_L_READ( wv )                            FIELD_GET( wv, 16, 16 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_RD_IDX_L_WRITE( v, wv )                        FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_WR_IDX_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 14, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_WR_IDX_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT) + 14, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_WR_IDX_READ(r, p)                              MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_WR_IDX_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_WR_IDX_L_READ( wv )                            FIELD_GET( wv, 0, 16 )
#define RDD_DHD_FLOW_RING_CACHE_CTX_ENTRY_WR_IDX_L_WRITE( v, wv )                        FIELD_SET( v, 0, 16, wv )
/* <<<DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT */


#define RDD_DHD_FLOW_RING_CACHE_CTX_TABLE_SIZE     48
typedef struct
{
	DHD_FLOW_RING_CACHE_CTX_ENTRY_STRUCT	entry[ RDD_DHD_FLOW_RING_CACHE_CTX_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_FLOW_RING_CACHE_CTX_TABLE_STRUCT;

extern uint32_t RDD_DHD_FLOW_RING_CACHE_CTX_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_FLOW_RING_CACHE_CTX_TABLE_PTR(core_id)	( DHD_FLOW_RING_CACHE_CTX_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_FLOW_RING_CACHE_CTX_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_FLOW_RING_CACHE_CTX_TABLE */


/* >>>DHD_AUX_INFO_CACHE_TABLE */

/* >>>DHD_AUX_INFO_CACHE_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	backup_first_index    	;
        uint16_t	backup_last_index     	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	backup_num_entries    	;
        uint16_t	phy_size              	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	window_ts             	;
        uint16_t	drop_interval         	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	codel_control_word    	; /* This is a field union */
        uint16_t	codel_drop_counter    	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	codel_dropped_recently          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint32_t	codel_dropping                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint32_t	codel_constant_drop             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint32_t	reserved                        	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint16_t	reservedSU1_codel_drop_counter  	;
		};
		/* Sub Union 2 */
		struct{
        uint16_t	codel_control                   	; /* Member of codel_control_word union */
        uint16_t	reservedSU2_codel_drop_counter  	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	backup_last_index     	;
        uint16_t	backup_first_index    	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	phy_size              	;
        uint16_t	backup_num_entries    	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	drop_interval         	;
        uint16_t	window_ts             	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	codel_drop_counter    	;
        uint16_t	codel_control_word    	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_codel_drop_counter  	;
        uint32_t	reserved                        	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint32_t	codel_constant_drop             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint32_t	codel_dropping                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
        uint32_t	codel_dropped_recently          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of codel_control_word union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_codel_drop_counter  	;
        uint16_t	codel_control                   	; /* Member of codel_control_word union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_AUX_INFO_CACHE_ENTRY_STRUCT;

#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_FIRST_INDEX_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT), (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_FIRST_INDEX_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT), (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_FIRST_INDEX_READ(r, p)                     MREAD_16((uint8_t *)(p), (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_FIRST_INDEX_WRITE(v, p)                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_FIRST_INDEX_L_READ( wv )                   FIELD_GET( wv, 16, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_FIRST_INDEX_L_WRITE( v, wv )               FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_LAST_INDEX_READ_G(r, g, idx)               GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 2, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_LAST_INDEX_WRITE_G(v, g, idx)              GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 2, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_LAST_INDEX_READ(r, p)                      MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_LAST_INDEX_WRITE(v, p)                     MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_LAST_INDEX_L_READ( wv )                    FIELD_GET( wv, 0, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_LAST_INDEX_L_WRITE( v, wv )                FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_NUM_ENTRIES_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 4, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_NUM_ENTRIES_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 4, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_NUM_ENTRIES_READ(r, p)                     MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_NUM_ENTRIES_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_NUM_ENTRIES_L_READ( wv )                   FIELD_GET( wv, 16, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_BACKUP_NUM_ENTRIES_L_WRITE( v, wv )               FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_PHY_SIZE_READ_G(r, g, idx)                        GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 6, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_PHY_SIZE_WRITE_G(v, g, idx)                       GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 6, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_PHY_SIZE_READ(r, p)                               MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_PHY_SIZE_WRITE(v, p)                              MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_PHY_SIZE_L_READ( wv )                             FIELD_GET( wv, 0, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_PHY_SIZE_L_WRITE( v, wv )                         FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_WINDOW_TS_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 8, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_WINDOW_TS_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 8, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_WINDOW_TS_READ(r, p)                              MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_WINDOW_TS_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_WINDOW_TS_L_READ( wv )                            FIELD_GET( wv, 16, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_WINDOW_TS_L_WRITE( v, wv )                        FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_DROP_INTERVAL_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 10, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_DROP_INTERVAL_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 10, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_DROP_INTERVAL_READ(r, p)                          MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_DROP_INTERVAL_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_DROP_INTERVAL_L_READ( wv )                        FIELD_GET( wv, 0, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_DROP_INTERVAL_L_WRITE( v, wv )                    FIELD_SET( v, 0, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WORD_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WORD_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WORD_READ(r, p)                     MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WORD_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WORD_L_READ( wv )                   FIELD_GET( wv, 16, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WORD_L_WRITE( v, wv )               FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPED_RECENTLY_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, 7, 1, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPED_RECENTLY_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, 7, 1, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPED_RECENTLY_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPED_RECENTLY_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPED_RECENTLY_L_READ( wv )               FIELD_GET( wv, 31, 1 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPED_RECENTLY_L_WRITE( v, wv )           FIELD_SET( v, 31, 1, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPING_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, 6, 1, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPING_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, 6, 1, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPING_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPING_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPING_L_READ( wv )                       FIELD_GET( wv, 30, 1 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROPPING_L_WRITE( v, wv )                   FIELD_SET( v, 30, 1, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONSTANT_DROP_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, 5, 1, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONSTANT_DROP_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, 5, 1, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONSTANT_DROP_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONSTANT_DROP_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONSTANT_DROP_L_READ( wv )                  FIELD_GET( wv, 29, 1 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONSTANT_DROP_L_WRITE( v, wv )              FIELD_SET( v, 29, 1, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 12, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_READ(r, p)                          MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_L_READ( wv )                        FIELD_GET( wv, 16, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_CONTROL_L_WRITE( v, wv )                    FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROP_COUNTER_READ_G(r, g, idx)              GROUP_MREAD_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 14, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROP_COUNTER_WRITE_G(v, g, idx)             GROUP_MWRITE_16((g), (idx)*sizeof(DHD_AUX_INFO_CACHE_ENTRY_STRUCT) + 14, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROP_COUNTER_READ(r, p)                     MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROP_COUNTER_WRITE(v, p)                    MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROP_COUNTER_L_READ( wv )                   FIELD_GET( wv, 0, 16 )
#define RDD_DHD_AUX_INFO_CACHE_ENTRY_CODEL_DROP_COUNTER_L_WRITE( v, wv )               FIELD_SET( v, 0, 16, wv )
/* <<<DHD_AUX_INFO_CACHE_ENTRY_STRUCT */


#define RDD_DHD_AUX_INFO_CACHE_TABLE_SIZE     48
typedef struct
{
	DHD_AUX_INFO_CACHE_ENTRY_STRUCT	entry[ RDD_DHD_AUX_INFO_CACHE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_AUX_INFO_CACHE_TABLE_STRUCT;

extern uint32_t RDD_DHD_AUX_INFO_CACHE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_AUX_INFO_CACHE_TABLE_PTR(core_id)	( DHD_AUX_INFO_CACHE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_AUX_INFO_CACHE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_AUX_INFO_CACHE_TABLE */


/* >>>DHD_TX_POST_FLOW_RING_BUFFER */

/* >>>DHD_TX_POST_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[12];
    uint64_t dword_64[6];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	msg_type             	;
        uint8_t	if_id                	;
        uint8_t	common_hdr_flags     	;
        uint8_t	epoch                	;
        uint32_t	request_id           	;
        uint32_t	tx_eth_hdr_0         	;
        uint32_t	tx_eth_hdr_1         	;
        uint32_t	tx_eth_hdr_2         	;
        uint16_t	tx_eth_hdr_3         	;
        uint8_t	flags                	;
        uint8_t	seg_cnt              	;
        uint32_t	metadata_buf_addr_low	;
        uint32_t	metadata_buf_addr_hi 	;
        uint32_t	data_buf_addr_low    	;
        uint32_t	data_buf_addr_hi     	;
        uint16_t	meta_buf_len         	;
        uint16_t	data_len             	;
        uint32_t	reserved             	;
#else
        uint8_t	epoch                	;
        uint8_t	common_hdr_flags     	;
        uint8_t	if_id                	;
        uint8_t	msg_type             	;
        uint32_t	request_id           	;
        uint32_t	tx_eth_hdr_0         	;
        uint32_t	tx_eth_hdr_1         	;
        uint32_t	tx_eth_hdr_2         	;
        uint8_t	seg_cnt              	;
        uint8_t	flags                	;
        uint16_t	tx_eth_hdr_3         	;
        uint32_t	metadata_buf_addr_low	;
        uint32_t	metadata_buf_addr_hi 	;
        uint32_t	data_buf_addr_low    	;
        uint32_t	data_buf_addr_hi     	;
        uint16_t	data_len             	;
        uint16_t	meta_buf_len         	;
        uint32_t	reserved             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_TX_POST_DESCRIPTOR_STRUCT;

#define RDD_DHD_TX_POST_DESCRIPTOR_MSG_TYPE_READ_G(r, g, idx)                       GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT), (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_MSG_TYPE_WRITE_G(v, g, idx)                      GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT), (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_MSG_TYPE_READ(r, p)                              MREAD_8((uint8_t *)(p), (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_MSG_TYPE_WRITE(v, p)                             MWRITE_8((uint8_t *)(p), (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_MSG_TYPE_L_READ( wv )                            FIELD_GET( wv, 24, 8 )
#define RDD_DHD_TX_POST_DESCRIPTOR_MSG_TYPE_L_WRITE( v, wv )                        FIELD_SET( v, 24, 8, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_IF_ID_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_IF_ID_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_IF_ID_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_IF_ID_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_IF_ID_L_READ( wv )                               FIELD_GET( wv, 16, 8 )
#define RDD_DHD_TX_POST_DESCRIPTOR_IF_ID_L_WRITE( v, wv )                           FIELD_SET( v, 16, 8, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_READ_G(r, g, idx)               GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE_G(v, g, idx)              GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_READ(r, p)                      MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_WRITE(v, p)                     MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_L_READ( wv )                    FIELD_GET( wv, 8, 8 )
#define RDD_DHD_TX_POST_DESCRIPTOR_COMMON_HDR_FLAGS_L_WRITE( v, wv )                FIELD_SET( v, 8, 8, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_EPOCH_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_EPOCH_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_EPOCH_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_EPOCH_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_EPOCH_L_READ( wv )                               FIELD_GET( wv, 0, 8 )
#define RDD_DHD_TX_POST_DESCRIPTOR_EPOCH_L_WRITE( v, wv )                           FIELD_SET( v, 0, 8, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_REQUEST_ID_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_REQUEST_ID_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_REQUEST_ID_READ(r, p)                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_REQUEST_ID_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_REQUEST_ID_L_READ( wv )                          FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_REQUEST_ID_L_WRITE( v, wv )                      FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_0_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 8, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_0_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 8, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_0_READ(r, p)                          MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_0_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_0_L_READ( wv )                        FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_0_L_WRITE( v, wv )                    FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_1_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_1_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_1_READ(r, p)                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_1_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_1_L_READ( wv )                        FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_1_L_WRITE( v, wv )                    FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_2_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 16, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_2_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 16, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_2_READ(r, p)                          MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_2_WRITE(v, p)                         MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_2_L_READ( wv )                        FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_2_L_WRITE( v, wv )                    FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_3_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 20, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_3_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 20, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_3_READ(r, p)                          MREAD_16((uint8_t *)(p) + 20, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_3_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 20, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_3_L_READ( wv )                        FIELD_GET( wv, 16, 16 )
#define RDD_DHD_TX_POST_DESCRIPTOR_TX_ETH_HDR_3_L_WRITE( v, wv )                    FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_FLAGS_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 22, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_FLAGS_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 22, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_FLAGS_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 22, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_FLAGS_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 22, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_FLAGS_L_READ( wv )                               FIELD_GET( wv, 8, 8 )
#define RDD_DHD_TX_POST_DESCRIPTOR_FLAGS_L_WRITE( v, wv )                           FIELD_SET( v, 8, 8, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_SEG_CNT_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 23, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_SEG_CNT_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 23, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_SEG_CNT_READ(r, p)                               MREAD_8((uint8_t *)(p) + 23, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_SEG_CNT_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 23, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_SEG_CNT_L_READ( wv )                             FIELD_GET( wv, 0, 8 )
#define RDD_DHD_TX_POST_DESCRIPTOR_SEG_CNT_L_WRITE( v, wv )                         FIELD_SET( v, 0, 8, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 24, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 24, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_READ(r, p)                 MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_L_READ( wv )               FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_LOW_L_WRITE( v, wv )           FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 28, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 28, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_READ(r, p)                  MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_L_READ( wv )                FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_METADATA_BUF_ADDR_HI_L_WRITE( v, wv )            FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 32, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 32, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_READ(r, p)                     MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_L_READ( wv )                   FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_LOW_L_WRITE( v, wv )               FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 36, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 36, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_READ(r, p)                      MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_L_READ( wv )                    FIELD_GET( wv, 0, 32 )
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_BUF_ADDR_HI_L_WRITE( v, wv )                FIELD_SET( v, 0, 32, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_META_BUF_LEN_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 40, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_META_BUF_LEN_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 40, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_META_BUF_LEN_READ(r, p)                          MREAD_16((uint8_t *)(p) + 40, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_META_BUF_LEN_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 40, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_META_BUF_LEN_L_READ( wv )                        FIELD_GET( wv, 16, 16 )
#define RDD_DHD_TX_POST_DESCRIPTOR_META_BUF_LEN_L_WRITE( v, wv )                    FIELD_SET( v, 16, 16, wv )
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_LEN_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 42, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_LEN_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(DHD_TX_POST_DESCRIPTOR_STRUCT) + 42, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_LEN_READ(r, p)                              MREAD_16((uint8_t *)(p) + 42, (r))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_LEN_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 42, (v))
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_LEN_L_READ( wv )                            FIELD_GET( wv, 0, 16 )
#define RDD_DHD_TX_POST_DESCRIPTOR_DATA_LEN_L_WRITE( v, wv )                        FIELD_SET( v, 0, 16, wv )
/* <<<DHD_TX_POST_DESCRIPTOR_STRUCT */


#define RDD_DHD_TX_POST_FLOW_RING_BUFFER_SIZE     3
typedef struct
{
	DHD_TX_POST_DESCRIPTOR_STRUCT	entry[ RDD_DHD_TX_POST_FLOW_RING_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_FLOW_RING_BUFFER_STRUCT;

extern uint32_t RDD_DHD_TX_POST_FLOW_RING_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_FLOW_RING_BUFFER_PTR(core_id)	( DHD_TX_POST_FLOW_RING_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_FLOW_RING_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_FLOW_RING_BUFFER */


/* >>>MIRRORING_SCRATCH */

#define RDD_MIRRORING_SCRATCH_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MIRRORING_SCRATCH_STRUCT;

extern uint32_t RDD_MIRRORING_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MIRRORING_SCRATCH_PTR(core_id)	( MIRRORING_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MIRRORING_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<MIRRORING_SCRATCH */


/* >>>DHD_CODEL_BIAS_SLOPE_TABLE */

/* >>>DHD_CODEL_BIAS_SLOPE_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	bias      	;
        uint16_t	slope     	;
#else
        uint16_t	slope     	;
        uint16_t	bias      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) DHD_CODEL_BIAS_SLOPE_STRUCT;

#define RDD_DHD_CODEL_BIAS_SLOPE_BIAS_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(DHD_CODEL_BIAS_SLOPE_STRUCT), (r))
#define RDD_DHD_CODEL_BIAS_SLOPE_BIAS_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(DHD_CODEL_BIAS_SLOPE_STRUCT), (v))
#define RDD_DHD_CODEL_BIAS_SLOPE_BIAS_READ(r, p)                  MREAD_16((uint8_t *)(p), (r))
#define RDD_DHD_CODEL_BIAS_SLOPE_BIAS_WRITE(v, p)                 MWRITE_16((uint8_t *)(p), (v))
#define RDD_DHD_CODEL_BIAS_SLOPE_SLOPE_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(DHD_CODEL_BIAS_SLOPE_STRUCT) + 2, (r))
#define RDD_DHD_CODEL_BIAS_SLOPE_SLOPE_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(DHD_CODEL_BIAS_SLOPE_STRUCT) + 2, (v))
#define RDD_DHD_CODEL_BIAS_SLOPE_SLOPE_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_DHD_CODEL_BIAS_SLOPE_SLOPE_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<DHD_CODEL_BIAS_SLOPE_STRUCT */


#define RDD_DHD_CODEL_BIAS_SLOPE_TABLE_SIZE     11
typedef struct
{
	DHD_CODEL_BIAS_SLOPE_STRUCT	entry[ RDD_DHD_CODEL_BIAS_SLOPE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_CODEL_BIAS_SLOPE_TABLE_STRUCT;

extern uint32_t RDD_DHD_CODEL_BIAS_SLOPE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_CODEL_BIAS_SLOPE_TABLE_PTR(core_id)	( DHD_CODEL_BIAS_SLOPE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_CODEL_BIAS_SLOPE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_CODEL_BIAS_SLOPE_TABLE */


/* >>>DHD_TX_POST_0_STACK */

#define RDD_DHD_TX_POST_0_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_POST_0_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_0_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_POST_0_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_0_STACK_PTR(core_id)	( DHD_TX_POST_0_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_0_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_0_STACK */


/* >>>DHD_TX_POST_1_STACK */

#define RDD_DHD_TX_POST_1_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_POST_1_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_1_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_POST_1_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_1_STACK_PTR(core_id)	( DHD_TX_POST_1_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_1_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_1_STACK */


/* >>>DHD_POST_COMMON_RADIO_DATA */

/* >>>DHD_POST_COMMON_RADIO_ENTRY_STRUCT */
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_NUMBER	4
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_NUMBER	4
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_NUMBER	4
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_NUMBER	7
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_NUMBER	16
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_RESERVED5_NUMBER	2
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_RESERVED6_NUMBER	4
typedef union
{
    uint32_t word_32[38];
    uint64_t dword_64[19];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_mgmt_fr_base_ptr_low                                                                                	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_mgmt_fr_base_ptr_high                                                                               	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_wr_idx_base_ptr_low                                                                              	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_wr_idx_base_ptr_high                                                                             	;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_rd_idx_base_ptr_low                                                                              	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_rd_idx_base_ptr_high                                                                             	;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	backup_index_fifo_base_low                                                                                  	;
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	backup_index_fifo_base_high                                                                                 	;
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dhd_doorbell_low                                                                                            	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dhd_doorbell_high                                                                                           	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	tx_post_wr_idx                                                                                              	;
        uint16_t	tx_post_qd                                                                                                  	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	tx_post_rd_idx                                                                                              	;
        uint16_t	idma_last_group_fr                                                                                          	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	cam_rslt                                                                                                    	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	add_llcsnap_header                                                                                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aggregation_bypass_cpu_tx                                                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aggregation_bypass_non_udp_tcp                                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_ring_format                                                                                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	idma_active                                                                                                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	codel_active                                                                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	aggregation_bypass_tcp_pktlen                                                                               	;
        uint8_t	cache_ctx_next_write_idx                                                                                    	;
        uint8_t	backup_cache_idx                                                                                            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	per_ac_aggregation_thresholds[RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_NUMBER];
		};
	};
	/* Union WORD 15 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	per_ac_aggregation_timeouts[RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_NUMBER];
		};
	};
	/* Union WORD 16 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	per_ac_aggregation_timeout_cntrs[RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_NUMBER];
		};
	};
	/* Union WORD 17 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	doorbell_value_address                                                                                      	;
		};
	};
	/* Union WORD 18 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	scratchpad[RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_NUMBER];
		};
	};
	/* Union WORD 25 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	backup_rd_idx                                                                                               	;
        uint16_t	backup_wr_idx                                                                                               	;
		};
	};
	/* Union WORD 26 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_valid                                                                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_abs_addr                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_data_len                                                                                             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_prio                                                                                                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_prio                                                                                                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                                                                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_l4_protocol                                                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	rsv_address_high                                                                                            	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_packet_valid                                                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_abs_addr                                                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_data_len                                                                                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_prio                                                                                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_buffer_prio                                                                                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved2                                                                                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_l4_protocol                                                                                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved3                                                                                                             	; /* Member of rsv_address_high union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_packet_valid                                                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_abs_addr                                                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_data_len                                                                                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_prio                                                                                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_buffer_prio                                                                                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved2                                                                                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_l4_protocol                                                                                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	packet_data_ptr_high                                                                                                  	; /* Member of rsv_address_high union */
		};
	};
	/* Union WORD 27 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	fpm_address_low                                                                                             	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	packet_fpm_pool                                                                                                       	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
        uint32_t	packet_packet_sop                                                                                                     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
        uint32_t	reserved4                                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
        uint32_t	packet_bn0                                                                                                            	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	packet_data_ptr_low                                                                                                   	; /* Member of fpm_address_low union */
		};
	};
	/* Union WORD 28 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	request_id                                                                                                  	;
		};
	};
	/* Union WORD 29 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	aggr_timer_scratchpad                                                                                       	;
        uint8_t	cpu_msg_done                                                                                                	;
        uint8_t	coalescing_max_count                                                                                        	;
		};
	};
	/* Union WORD 30 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	doorbell_counters[RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_NUMBER];
		};
	};
	/* Union WORD 34 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reserved1                                                                                                   	;
        uint8_t	coalescing_timeout                                                                                          	;
        uint8_t	coalescing_timeout_cntr                                                                                     	;
        uint8_t	cur_frg_id                                                                                                  	;
		};
	};
	/* Union WORD 35 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_mirroring_en                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_vport                                                                                                   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_queue                                                                                                   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	codel_max_seq_drops                                                                                         	;
		};
	};
	/* Union WORD 36 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	fr_ptrs_size_shift                                                                                          	;
        uint8_t	idma_group_shift                                                                                            	;
        uint8_t	reserved5[RDD_DHD_POST_COMMON_RADIO_ENTRY_RESERVED5_NUMBER];
		};
	};
	/* Union WORD 37 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reserved6[RDD_DHD_POST_COMMON_RADIO_ENTRY_RESERVED6_NUMBER];
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_mgmt_fr_base_ptr_low                                                                                	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_mgmt_fr_base_ptr_high                                                                               	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_wr_idx_base_ptr_low                                                                              	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_wr_idx_base_ptr_high                                                                             	;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_rd_idx_base_ptr_low                                                                              	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tx_post_fr_rd_idx_base_ptr_high                                                                             	;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	backup_index_fifo_base_low                                                                                  	;
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	backup_index_fifo_base_high                                                                                 	;
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dhd_doorbell_low                                                                                            	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dhd_doorbell_high                                                                                           	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	tx_post_qd                                                                                                  	;
        uint16_t	tx_post_wr_idx                                                                                              	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	idma_last_group_fr                                                                                          	;
        uint16_t	tx_post_rd_idx                                                                                              	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	cam_rslt                                                                                                    	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	backup_cache_idx                                                                                            	;
        uint8_t	cache_ctx_next_write_idx                                                                                    	;
        uint8_t	aggregation_bypass_tcp_pktlen                                                                               	;
        uint32_t	codel_active                                                                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	idma_active                                                                                                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_ring_format                                                                                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aggregation_bypass_non_udp_tcp                                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aggregation_bypass_cpu_tx                                                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	add_llcsnap_header                                                                                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	per_ac_aggregation_thresholds[RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_NUMBER];
		};
	};
	/* Union WORD 15 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	per_ac_aggregation_timeouts[RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_NUMBER];
		};
	};
	/* Union WORD 16 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	per_ac_aggregation_timeout_cntrs[RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_NUMBER];
		};
	};
	/* Union WORD 17 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	doorbell_value_address                                                                                      	;
		};
	};
	/* Union WORD 18 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	scratchpad[RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_NUMBER];
		};
	};
	/* Union WORD 25 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	backup_wr_idx                                                                                               	;
        uint16_t	backup_rd_idx                                                                                               	;
		};
	};
	/* Union WORD 26 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	rsv_address_high                                                                                            	; /* This is a field union */
        uint32_t	packet_l4_protocol                                                                                          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                                                                                                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_prio                                                                                                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_prio                                                                                                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_data_len                                                                                             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_abs_addr                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_valid                                                                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reserved3                                                                                                             	; /* Member of rsv_address_high union */
        uint32_t	reservedSU1_packet_l4_protocol                                                                                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved2                                                                                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_buffer_prio                                                                                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_prio                                                                                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_data_len                                                                                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_abs_addr                                                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_valid                                                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	packet_data_ptr_high                                                                                                  	; /* Member of rsv_address_high union */
        uint32_t	reservedSU2_packet_l4_protocol                                                                                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved2                                                                                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_buffer_prio                                                                                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_prio                                                                                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_data_len                                                                                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_abs_addr                                                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_valid                                                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 27 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	fpm_address_low                                                                                             	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	packet_bn0                                                                                                            	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
        uint32_t	reserved4                                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
        uint32_t	packet_packet_sop                                                                                                     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
        uint32_t	packet_fpm_pool                                                                                                       	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of fpm_address_low union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	packet_data_ptr_low                                                                                                   	; /* Member of fpm_address_low union */
		};
	};
	/* Union WORD 28 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	request_id                                                                                                  	;
		};
	};
	/* Union WORD 29 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	coalescing_max_count                                                                                        	;
        uint8_t	cpu_msg_done                                                                                                	;
        uint16_t	aggr_timer_scratchpad                                                                                       	;
		};
	};
	/* Union WORD 30 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	doorbell_counters[RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_NUMBER];
		};
	};
	/* Union WORD 34 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	cur_frg_id                                                                                                  	;
        uint8_t	coalescing_timeout_cntr                                                                                     	;
        uint8_t	coalescing_timeout                                                                                          	;
        uint8_t	reserved1                                                                                                   	;
		};
	};
	/* Union WORD 35 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	codel_max_seq_drops                                                                                         	;
        uint32_t	dst_queue                                                                                                   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_vport                                                                                                   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tx_mirroring_en                                                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 36 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reserved5[RDD_DHD_POST_COMMON_RADIO_ENTRY_RESERVED5_NUMBER];
        uint8_t	idma_group_shift                                                                                            	;
        uint8_t	fr_ptrs_size_shift                                                                                          	;
		};
	};
	/* Union WORD 37 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reserved6[RDD_DHD_POST_COMMON_RADIO_ENTRY_RESERVED6_NUMBER];
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_POST_COMMON_RADIO_ENTRY_STRUCT;

#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_LOW_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT), (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_LOW_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT), (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_LOW_READ(r, p)                     MREAD_32((uint8_t *)(p), (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_LOW_WRITE(v, p)                    MWRITE_32((uint8_t *)(p), (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_HIGH_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 4, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_HIGH_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 4, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_HIGH_READ(r, p)                    MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_MGMT_FR_BASE_PTR_HIGH_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_LOW_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 8, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_LOW_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 8, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_LOW_READ(r, p)                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_LOW_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_HIGH_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 12, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_HIGH_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 12, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_HIGH_READ(r, p)                  MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_WR_IDX_BASE_PTR_HIGH_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_LOW_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 16, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_LOW_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 16, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_LOW_READ(r, p)                   MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_LOW_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_HIGH_READ_G(r, g, idx)           GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 20, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_HIGH_WRITE_G(v, g, idx)          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 20, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_HIGH_READ(r, p)                  MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_FR_RD_IDX_BASE_PTR_HIGH_WRITE(v, p)                 MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_LOW_READ_G(r, g, idx)                GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 24, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_LOW_WRITE_G(v, g, idx)               GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 24, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_LOW_READ(r, p)                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_LOW_WRITE(v, p)                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_HIGH_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 28, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_HIGH_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 28, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_HIGH_READ(r, p)                      MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_INDEX_FIFO_BASE_HIGH_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_READ_G(r, g, idx)                          GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 32, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_WRITE_G(v, g, idx)                         GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 32, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_READ(r, p)                                 MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_LOW_WRITE(v, p)                                MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_READ_G(r, g, idx)                         GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 36, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_WRITE_G(v, g, idx)                        GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 36, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_READ(r, p)                                MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DHD_DOORBELL_HIGH_WRITE(v, p)                               MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_WR_IDX_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 40, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_WR_IDX_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 40, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_WR_IDX_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 40, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_WR_IDX_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 40, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_QD_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 42, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_QD_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 42, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_QD_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 42, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_QD_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 42, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_RD_IDX_READ_G(r, g, idx)                            GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 44, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_RD_IDX_WRITE_G(v, g, idx)                           GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 44, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_RD_IDX_READ(r, p)                                   MREAD_16((uint8_t *)(p) + 44, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_POST_RD_IDX_WRITE(v, p)                                  MWRITE_16((uint8_t *)(p) + 44, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_READ_G(r, g, idx)                        GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 46, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_WRITE_G(v, g, idx)                       GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 46, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_READ(r, p)                               MREAD_16((uint8_t *)(p) + 46, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_LAST_GROUP_FR_WRITE(v, p)                              MWRITE_16((uint8_t *)(p) + 46, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CAM_RSLT_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 48, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CAM_RSLT_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 48, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CAM_RSLT_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CAM_RSLT_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_ADD_LLCSNAP_HEADER_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 7, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_ADD_LLCSNAP_HEADER_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 7, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_ADD_LLCSNAP_HEADER_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 52, 7, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_ADD_LLCSNAP_HEADER_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 52, 7, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_CPU_TX_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 6, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_CPU_TX_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 6, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_CPU_TX_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 52, 6, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_CPU_TX_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 52, 6, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_NON_UDP_TCP_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 5, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_NON_UDP_TCP_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 5, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_NON_UDP_TCP_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 52, 5, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_NON_UDP_TCP_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 52, 5, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_READ_G(r, g, idx)                          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 2, 3, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_WRITE_G(v, g, idx)                         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 2, 3, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_READ(r, p)                                 FIELD_MREAD_8((uint8_t *)(p) + 52, 2, 3, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FLOW_RING_FORMAT_WRITE(v, p)                                FIELD_MWRITE_8((uint8_t *)(p) + 52, 2, 3, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_ACTIVE_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 1, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_ACTIVE_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 1, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_ACTIVE_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 52, 1, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_ACTIVE_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 52, 1, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_ACTIVE_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 0, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_ACTIVE_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 52, 0, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_ACTIVE_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 52, 0, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_ACTIVE_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 52, 0, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_TCP_PKTLEN_READ_G(r, g, idx)             GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 53, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_TCP_PKTLEN_WRITE_G(v, g, idx)            GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 53, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_TCP_PKTLEN_READ(r, p)                    MREAD_8((uint8_t *)(p) + 53, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGREGATION_BYPASS_TCP_PKTLEN_WRITE(v, p)                   MWRITE_8((uint8_t *)(p) + 53, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CACHE_CTX_NEXT_WRITE_IDX_READ_G(r, g, idx)                  GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 54, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CACHE_CTX_NEXT_WRITE_IDX_WRITE_G(v, g, idx)                 GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 54, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CACHE_CTX_NEXT_WRITE_IDX_READ(r, p)                         MREAD_8((uint8_t *)(p) + 54, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CACHE_CTX_NEXT_WRITE_IDX_WRITE(v, p)                        MWRITE_8((uint8_t *)(p) + 54, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_CACHE_IDX_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 55, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_CACHE_IDX_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 55, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_CACHE_IDX_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 55, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_CACHE_IDX_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 55, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_READ_G(r, g, idx, i)          GROUP_MREAD_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 56, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_WRITE_G(v, g, idx, i)         GROUP_MWRITE_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 56, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_READ(r, p, i)                 MREAD_I_8((uint8_t *)(p) + 56, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_THRESHOLDS_WRITE(v, p, i)                MWRITE_I_8((uint8_t *)(p) + 56, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_READ_G(r, g, idx, i)            GROUP_MREAD_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 60, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_WRITE_G(v, g, idx, i)           GROUP_MWRITE_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 60, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_READ(r, p, i)                   MREAD_I_8((uint8_t *)(p) + 60, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUTS_WRITE(v, p, i)                  MWRITE_I_8((uint8_t *)(p) + 60, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_READ_G(r, g, idx, i)       GROUP_MREAD_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 64, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 64, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_READ(r, p, i)              MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PER_AC_AGGREGATION_TIMEOUT_CNTRS_WRITE(v, p, i)             MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_VALUE_ADDRESS_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 68, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_VALUE_ADDRESS_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 68, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_VALUE_ADDRESS_READ(r, p)                           MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_VALUE_ADDRESS_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_READ_G(r, g, idx, i)                             GROUP_MREAD_I_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 72, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 72, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_READ(r, p, i)                                    MREAD_I_32((uint8_t *)(p) + 72, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_SCRATCHPAD_WRITE(v, p, i)                                   MWRITE_I_32((uint8_t *)(p) + 72, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_RD_IDX_READ_G(r, g, idx)                             GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 100, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_RD_IDX_WRITE_G(v, g, idx)                            GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 100, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_RD_IDX_READ(r, p)                                    MREAD_16((uint8_t *)(p) + 100, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_RD_IDX_WRITE(v, p)                                   MWRITE_16((uint8_t *)(p) + 100, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_WR_IDX_READ_G(r, g, idx)                             GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 102, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_WR_IDX_WRITE_G(v, g, idx)                            GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 102, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_WR_IDX_READ(r, p)                                    MREAD_16((uint8_t *)(p) + 102, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BACKUP_WR_IDX_WRITE(v, p)                                   MWRITE_16((uint8_t *)(p) + 102, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_VALID_READ_G(r, g, idx)                              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 104, 7, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_VALID_WRITE_G(v, g, idx)                             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 104, 7, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_VALID_READ(r, p)                                     FIELD_MREAD_8((uint8_t *)(p) + 104, 7, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_VALID_WRITE(v, p)                                    FIELD_MWRITE_8((uint8_t *)(p) + 104, 7, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_ABS_ADDR_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 104, 6, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_ABS_ADDR_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 104, 6, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_ABS_ADDR_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 104, 6, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_ABS_ADDR_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 104, 6, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_LEN_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 104, 0, 14, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_LEN_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 104, 0, 14, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_LEN_READ(r, p)                                  FIELD_MREAD_16((uint8_t *)(p) + 104, 0, 14, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_LEN_WRITE(v, p)                                 FIELD_MWRITE_16((uint8_t *)(p) + 104, 0, 14, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PRIO_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 106, 5, 3, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PRIO_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 106, 5, 3, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PRIO_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 106, 5, 3, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PRIO_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 106, 5, 3, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BUFFER_PRIO_READ_G(r, g, idx)                               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 106, 4, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BUFFER_PRIO_WRITE_G(v, g, idx)                              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 106, 4, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BUFFER_PRIO_READ(r, p)                                      FIELD_MREAD_8((uint8_t *)(p) + 106, 4, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_BUFFER_PRIO_WRITE(v, p)                                     FIELD_MWRITE_8((uint8_t *)(p) + 106, 4, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_L4_PROTOCOL_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 106, 0, 2, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_L4_PROTOCOL_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 106, 0, 2, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_L4_PROTOCOL_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 106, 0, 2, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_L4_PROTOCOL_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 106, 0, 2, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_RSV_ADDRESS_HIGH_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 107, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_RSV_ADDRESS_HIGH_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 107, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_RSV_ADDRESS_HIGH_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 107, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_RSV_ADDRESS_HIGH_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 107, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_HIGH_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 107, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_HIGH_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 107, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_HIGH_READ(r, p)                             MREAD_8((uint8_t *)(p) + 107, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_HIGH_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 107, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FPM_ADDRESS_LOW_READ_G(r, g, idx)                           GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FPM_ADDRESS_LOW_WRITE_G(v, g, idx)                          GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FPM_ADDRESS_LOW_READ(r, p)                                  MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FPM_ADDRESS_LOW_WRITE(v, p)                                 MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_FPM_POOL_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, 6, 2, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_FPM_POOL_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, 6, 2, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_FPM_POOL_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 108, 6, 2, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_FPM_POOL_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 108, 6, 2, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PACKET_SOP_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, 3, 11, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PACKET_SOP_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, 3, 11, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PACKET_SOP_READ(r, p)                                FIELD_MREAD_16((uint8_t *)(p) + 108, 3, 11, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_PACKET_SOP_WRITE(v, p)                               FIELD_MWRITE_16((uint8_t *)(p) + 108, 3, 11, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_BN0_READ_G(r, g, idx)                                GROUP_FIELD_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, 0, 18, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_BN0_WRITE_G(v, g, idx)                               GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, 0, 18, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_BN0_READ(r, p)                                       FIELD_MREAD_32((uint8_t *)(p) + 108, 0, 18, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_BN0_WRITE(v, p)                                      FIELD_MWRITE_32((uint8_t *)(p) + 108, 0, 18, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_LOW_READ_G(r, g, idx)                       GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_LOW_WRITE_G(v, g, idx)                      GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 108, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_LOW_READ(r, p)                              MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_PACKET_DATA_PTR_LOW_WRITE(v, p)                             MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_REQUEST_ID_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 112, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_REQUEST_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 112, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_REQUEST_ID_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 112, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_REQUEST_ID_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 112, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGR_TIMER_SCRATCHPAD_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 116, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGR_TIMER_SCRATCHPAD_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 116, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGR_TIMER_SCRATCHPAD_READ(r, p)                            MREAD_16((uint8_t *)(p) + 116, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_AGGR_TIMER_SCRATCHPAD_WRITE(v, p)                           MWRITE_16((uint8_t *)(p) + 116, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CPU_MSG_DONE_READ_G(r, g, idx)                              GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 118, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CPU_MSG_DONE_WRITE_G(v, g, idx)                             GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 118, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CPU_MSG_DONE_READ(r, p)                                     MREAD_8((uint8_t *)(p) + 118, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CPU_MSG_DONE_WRITE(v, p)                                    MWRITE_8((uint8_t *)(p) + 118, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_MAX_COUNT_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 119, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_MAX_COUNT_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 119, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_MAX_COUNT_READ(r, p)                             MREAD_8((uint8_t *)(p) + 119, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_MAX_COUNT_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 119, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_READ_G(r, g, idx, i)                      GROUP_MREAD_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 120, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_WRITE_G(v, g, idx, i)                     GROUP_MWRITE_I_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 120, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_READ(r, p, i)                             MREAD_I_8((uint8_t *)(p) + 120, i, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DOORBELL_COUNTERS_WRITE(v, p, i)                            MWRITE_I_8((uint8_t *)(p) + 120, i, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 137, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 137, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_READ(r, p)                               MREAD_8((uint8_t *)(p) + 137, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 137, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_CNTR_READ_G(r, g, idx)                   GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 138, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_CNTR_WRITE_G(v, g, idx)                  GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 138, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_CNTR_READ(r, p)                          MREAD_8((uint8_t *)(p) + 138, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_COALESCING_TIMEOUT_CNTR_WRITE(v, p)                         MWRITE_8((uint8_t *)(p) + 138, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CUR_FRG_ID_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 139, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CUR_FRG_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 139, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CUR_FRG_ID_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 139, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CUR_FRG_ID_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 139, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_MIRRORING_EN_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 140, 7, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_MIRRORING_EN_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 140, 7, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_MIRRORING_EN_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p) + 140, 7, 1, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_TX_MIRRORING_EN_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p) + 140, 7, 1, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_VPORT_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 140, 1, 6, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_VPORT_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 140, 1, 6, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_VPORT_READ(r, p)                                        FIELD_MREAD_8((uint8_t *)(p) + 140, 1, 6, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_VPORT_WRITE(v, p)                                       FIELD_MWRITE_8((uint8_t *)(p) + 140, 1, 6, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_QUEUE_READ_G(r, g, idx)                                 GROUP_FIELD_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 140, 0, 9, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_QUEUE_WRITE_G(v, g, idx)                                GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 140, 0, 9, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_QUEUE_READ(r, p)                                        FIELD_MREAD_16((uint8_t *)(p) + 140, 0, 9, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_DST_QUEUE_WRITE(v, p)                                       FIELD_MWRITE_16((uint8_t *)(p) + 140, 0, 9, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_MAX_SEQ_DROPS_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 142, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_MAX_SEQ_DROPS_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 142, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_MAX_SEQ_DROPS_READ(r, p)                              MREAD_16((uint8_t *)(p) + 142, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_CODEL_MAX_SEQ_DROPS_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 142, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 144, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 144, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_READ(r, p)                               MREAD_8((uint8_t *)(p) + 144, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_FR_PTRS_SIZE_SHIFT_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 144, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 145, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(DHD_POST_COMMON_RADIO_ENTRY_STRUCT) + 145, (v))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 145, (r))
#define RDD_DHD_POST_COMMON_RADIO_ENTRY_IDMA_GROUP_SHIFT_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 145, (v))
/* <<<DHD_POST_COMMON_RADIO_ENTRY_STRUCT */


#define RDD_DHD_POST_COMMON_RADIO_DATA_SIZE     3
typedef struct
{
	DHD_POST_COMMON_RADIO_ENTRY_STRUCT	entry[ RDD_DHD_POST_COMMON_RADIO_DATA_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_POST_COMMON_RADIO_DATA_STRUCT;

extern uint32_t RDD_DHD_POST_COMMON_RADIO_DATA_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_POST_COMMON_RADIO_DATA_PTR(core_id)	( DHD_POST_COMMON_RADIO_DATA_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_POST_COMMON_RADIO_DATA_ADDRESS_ARR[core_id] ))

/* <<<DHD_POST_COMMON_RADIO_DATA */


/* >>>DHD_FPM_POOL_NUMBER_MAPPING_TABLE */

#define RDD_DHD_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE     16
typedef struct
{
	FPM_POOL_NUMBER_STRUCT	entry[ RDD_DHD_FPM_POOL_NUMBER_MAPPING_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT;

extern uint32_t RDD_DHD_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_FPM_POOL_NUMBER_MAPPING_TABLE_PTR(core_id)	( DHD_FPM_POOL_NUMBER_MAPPING_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_FPM_POOL_NUMBER_MAPPING_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_FPM_POOL_NUMBER_MAPPING_TABLE */


/* >>>DHD_TIMER_STACK */

#define RDD_DHD_TIMER_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TIMER_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TIMER_STACK_STRUCT;

extern uint32_t RDD_DHD_TIMER_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TIMER_STACK_PTR(core_id)	( DHD_TIMER_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TIMER_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TIMER_STACK */


/* >>>SPDSVC_WLAN_TXPOST_PARAMS_TABLE */

/* >>>SPDSVC_WLAN_TXPOST_PARAMS_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	spdsvc_free_idx	;
#else
        uint16_t	spdsvc_free_idx	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) SPDSVC_WLAN_TXPOST_PARAMS_STRUCT;

#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<SPDSVC_WLAN_TXPOST_PARAMS_STRUCT */


#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_TABLE_SIZE     1
typedef struct
{
	SPDSVC_WLAN_TXPOST_PARAMS_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SPDSVC_WLAN_TXPOST_PARAMS_TABLE_STRUCT;

extern uint32_t RDD_SPDSVC_WLAN_TXPOST_PARAMS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_TABLE_PTR(core_id)	( SPDSVC_WLAN_TXPOST_PARAMS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SPDSVC_WLAN_TXPOST_PARAMS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<SPDSVC_WLAN_TXPOST_PARAMS_TABLE */


/* >>>DHD_BACKUP_BASE_ADDR */

#define RDD_DHD_BACKUP_BASE_ADDR_SIZE     1
typedef struct
{
	BYTES_8_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_BACKUP_BASE_ADDR_STRUCT;

extern uint32_t RDD_DHD_BACKUP_BASE_ADDR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_BACKUP_BASE_ADDR_PTR(core_id)	( DHD_BACKUP_BASE_ADDR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_BACKUP_BASE_ADDR_ADDRESS_ARR[core_id] ))

/* <<<DHD_BACKUP_BASE_ADDR */


/* >>>DHD_TX_POST_2_STACK */

#define RDD_DHD_TX_POST_2_STACK_SIZE     128
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_POST_2_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_2_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_POST_2_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_2_STACK_PTR(core_id)	( DHD_TX_POST_2_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_2_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_2_STACK */


/* >>>DHD_TX_POST_UPDATE_FIFO_TABLE */

#define RDD_DHD_TX_POST_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_DHD_TX_POST_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_DHD_TX_POST_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_UPDATE_FIFO_TABLE_PTR(core_id)	( DHD_TX_POST_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_UPDATE_FIFO_TABLE */


/* >>>DHD_TX_POST_UPDATE_FIFO_STACK */

#define RDD_DHD_TX_POST_UPDATE_FIFO_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_TX_POST_UPDATE_FIFO_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_UPDATE_FIFO_STACK_STRUCT;

extern uint32_t RDD_DHD_TX_POST_UPDATE_FIFO_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_UPDATE_FIFO_STACK_PTR(core_id)	( DHD_TX_POST_UPDATE_FIFO_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_UPDATE_FIFO_STACK_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_UPDATE_FIFO_STACK */


/* >>>DHD_BACKUP_INDEX_CACHE */

/* >>>DHD_BACKUP_IDX_CACHE_TABLE_STRUCT */
#define RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_NUMBER	16
typedef union
{
    uint32_t word_32[8];
    uint64_t dword_64[4];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	indexes[RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_NUMBER];
#else
        uint16_t	indexes[RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) DHD_BACKUP_IDX_CACHE_TABLE_STRUCT;

#define RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_READ_G(r, g, idx, i)       GROUP_MREAD_I_16((g), (idx)*sizeof(DHD_BACKUP_IDX_CACHE_TABLE_STRUCT), i, (r))
#define RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_WRITE_G(v, g, idx, i)      GROUP_MWRITE_I_16((g), (idx)*sizeof(DHD_BACKUP_IDX_CACHE_TABLE_STRUCT), i, (v))
#define RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_READ(r, p, i)              MREAD_I_16((uint8_t *)(p), i, (r))
#define RDD_DHD_BACKUP_IDX_CACHE_TABLE_INDEXES_WRITE(v, p, i)             MWRITE_I_16((uint8_t *)(p), i, (v))
/* <<<DHD_BACKUP_IDX_CACHE_TABLE_STRUCT */


#define RDD_DHD_BACKUP_INDEX_CACHE_SIZE     3
typedef struct
{
	DHD_BACKUP_IDX_CACHE_TABLE_STRUCT	entry[ RDD_DHD_BACKUP_INDEX_CACHE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_BACKUP_INDEX_CACHE_STRUCT;

extern uint32_t RDD_DHD_BACKUP_INDEX_CACHE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_BACKUP_INDEX_CACHE_PTR(core_id)	( DHD_BACKUP_INDEX_CACHE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_BACKUP_INDEX_CACHE_ADDRESS_ARR[core_id] ))

/* <<<DHD_BACKUP_INDEX_CACHE */


/* >>>DHD_DOORBELL_TX_POST_VALUE */

#define RDD_DHD_DOORBELL_TX_POST_VALUE_SIZE     16
typedef struct
{
	DHD_DOORBELL_STRUCT	entry[ RDD_DHD_DOORBELL_TX_POST_VALUE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_DOORBELL_TX_POST_VALUE_STRUCT;

extern uint32_t RDD_DHD_DOORBELL_TX_POST_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_DOORBELL_TX_POST_VALUE_PTR(core_id)	( DHD_DOORBELL_TX_POST_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_DOORBELL_TX_POST_VALUE_ADDRESS_ARR[core_id] ))

/* <<<DHD_DOORBELL_TX_POST_VALUE */


/* >>>DHD_L2_HEADER */

#define RDD_DHD_L2_HEADER_SIZE     72
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DHD_L2_HEADER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_L2_HEADER_STRUCT;

extern uint32_t RDD_DHD_L2_HEADER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_L2_HEADER_PTR(core_id)	( DHD_L2_HEADER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_L2_HEADER_ADDRESS_ARR[core_id] ))

/* <<<DHD_L2_HEADER */


/* >>>DHD_MIRRORING_DISPATCHER_CREDIT_TABLE */

#define RDD_DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_MIRRORING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_MIRRORING_DISPATCHER_CREDIT_TABLE */


/* >>>DHD_TX_POST_PD_FIFO_TABLE */

#define RDD_DHD_TX_POST_PD_FIFO_TABLE_SIZE     12
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_DHD_TX_POST_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_TX_POST_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_DHD_TX_POST_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_TX_POST_PD_FIFO_TABLE_PTR(core_id)	( DHD_TX_POST_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_TX_POST_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_TX_POST_PD_FIFO_TABLE */


/* >>>DHD_FLOW_RING_CACHE_LKP_TABLE */

/* >>>DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	invalid     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved    	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	flow_ring_id	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	flow_ring_id	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved    	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	invalid     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT;

#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_INVALID_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_INVALID_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_INVALID_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_INVALID_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_INVALID_L_READ( wv )                    FIELD_GET( wv, 15, 1 )
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_INVALID_L_WRITE( v, wv )                FIELD_SET( v, 15, 1, wv )
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_FLOW_RING_ID_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT), 0, 10, (r))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_FLOW_RING_ID_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT), 0, 10, (v))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_FLOW_RING_ID_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 10, (r))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_FLOW_RING_ID_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 10, (v))
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_FLOW_RING_ID_L_READ( wv )               FIELD_GET( wv, 0, 10 )
#define RDD_DHD_FLOW_RING_CACHE_LKP_ENTRY_FLOW_RING_ID_L_WRITE( v, wv )           FIELD_SET( v, 0, 10, wv )
/* <<<DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT */


#define RDD_DHD_FLOW_RING_CACHE_LKP_TABLE_SIZE     48
typedef struct
{
	DHD_FLOW_RING_CACHE_LKP_ENTRY_STRUCT	entry[ RDD_DHD_FLOW_RING_CACHE_LKP_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DHD_FLOW_RING_CACHE_LKP_TABLE_STRUCT;

extern uint32_t RDD_DHD_FLOW_RING_CACHE_LKP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DHD_FLOW_RING_CACHE_LKP_TABLE_PTR(core_id)	( DHD_FLOW_RING_CACHE_LKP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DHD_FLOW_RING_CACHE_LKP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DHD_FLOW_RING_CACHE_LKP_TABLE */

/* CORE_4 */

/* >>>DS_TM_PD_FIFO_TABLE */

#define RDD_DS_TM_PD_FIFO_TABLE_SIZE     96
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_PD_FIFO_TABLE_PTR(core_id)	( DS_TM_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_PD_FIFO_TABLE */


/* >>>DS_TM_SCHEDULING_QUEUE_TABLE */

#define RDD_DS_TM_SCHEDULING_QUEUE_TABLE_SIZE     48
typedef struct
{
	SCHEDULING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_SCHEDULING_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_SCHEDULING_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_SCHEDULING_QUEUE_TABLE_PTR(core_id)	( DS_TM_SCHEDULING_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_SCHEDULING_QUEUE_TABLE */


/* >>>BASIC_SCHEDULER_TABLE_DS */

/* >>>BASIC_SCHEDULER_DESCRIPTOR_STRUCT */
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_NUMBER	8
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	rate_limit_enable                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_exists                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dwrr_offset                                                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_index_2                                                   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	slot_budget_bit_vector                                           	;
        uint32_t	parent_index_1                                                   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	last_served_queue                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	status_bit_vector                                                	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_index                                                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint8_t	reservedSU1_slot_budget_bit_vector                                         	;
        uint32_t	complex_scheduler_slot_index                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	reservedSU1_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_status_bit_vector                                              	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_msb                                                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	ovl_rl_en                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	reserved1                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint8_t	reservedSU2_slot_budget_bit_vector                                         	;
        uint32_t	is_positive_budget                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	bbh_queue_lsb                                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	reservedSU2_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_status_bit_vector                                              	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	rate_limiter_index                                               	;
        uint8_t	quantum_number                                                   	;
        uint16_t	deficit_counter                                                  	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	queue_index[RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_NUMBER];
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	status_bit_vector                                                	;
        uint32_t	last_served_queue                                                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	parent_index_1                                                   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	slot_budget_bit_vector                                           	;
        uint32_t	parent_index_2                                                   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	dwrr_offset                                                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_exists                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_enable                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_status_bit_vector                                              	;
        uint32_t	reservedSU1_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	complex_scheduler_slot_index                                               	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint8_t	reservedSU1_slot_budget_bit_vector                                         	;
        uint32_t	complex_scheduler_index                                                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	reservedSU1_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_status_bit_vector                                              	;
        uint32_t	reservedSU2_last_served_queue                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bbh_queue_lsb                                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint32_t	is_positive_budget                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_1 union */
        uint8_t	reservedSU2_slot_budget_bit_vector                                         	;
        uint32_t	reserved1                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	ovl_rl_en                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	bbh_queue_msb                                                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of parent_index_2 union */
        uint32_t	reservedSU2_dwrr_offset                                                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_complex_scheduler_exists                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_rate_limit_enable                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	deficit_counter                                                  	;
        uint8_t	quantum_number                                                   	;
        uint8_t	rate_limiter_index                                               	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	queue_index[RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_NUMBER];
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BASIC_SCHEDULER_DESCRIPTOR_STRUCT;

#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMIT_ENABLE_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_EXISTS_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_READ_G(r, g, idx)                           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 4, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_WRITE_G(v, g, idx)                          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 4, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_READ(r, p)                                  FIELD_MREAD_8((uint8_t *)(p), 4, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DWRR_OFFSET_WRITE(v, p)                                 FIELD_MWRITE_8((uint8_t *)(p), 4, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_2_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 0, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_INDEX_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 0, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 2, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 2, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p), 2, 2, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_MSB_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p), 2, 2, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ_G(r, g, idx)                             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE_G(v, g, idx)                            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_READ(r, p)                                    FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_OVL_RL_EN_WRITE(v, p)                                   FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_READ_G(r, g, idx)                GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_WRITE_G(v, g, idx)               GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_READ(r, p)                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_SLOT_BUDGET_BIT_VECTOR_WRITE(v, p)                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_PARENT_INDEX_1_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_COMPLEX_SCHEDULER_SLOT_INDEX_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_READ(r, p)                           FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_IS_POSITIVE_BUDGET_WRITE(v, p)                          FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 3, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_BBH_QUEUE_LSB_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 0, 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 2, 0, 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_LAST_SERVED_QUEUE_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ_G(r, g, idx)                     GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE_G(v, g, idx)                    GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_READ(r, p)                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_STATUS_BIT_VECTOR_WRITE(v, p)                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ_G(r, g, idx)                    GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE_G(v, g, idx)                   GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_READ(r, p)                           MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_RATE_LIMITER_INDEX_WRITE(v, p)                          MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_READ(r, p)                               MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUANTUM_NUMBER_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ_G(r, g, idx)                       GROUP_MREAD_16((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 6, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE_G(v, g, idx)                      GROUP_MWRITE_16((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 6, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_READ(r, p)                              MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_DEFICIT_COUNTER_WRITE(v, p)                             MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_READ_G(r, g, idx, i)                        GROUP_MREAD_I_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 8, i, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_WRITE_G(v, g, idx, i)                       GROUP_MWRITE_I_8((g), (idx)*sizeof(BASIC_SCHEDULER_DESCRIPTOR_STRUCT) + 8, i, (v))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_READ(r, p, i)                               MREAD_I_8((uint8_t *)(p) + 8, i, (r))
#define RDD_BASIC_SCHEDULER_DESCRIPTOR_QUEUE_INDEX_WRITE(v, p, i)                              MWRITE_I_8((uint8_t *)(p) + 8, i, (v))
/* <<<BASIC_SCHEDULER_DESCRIPTOR_STRUCT */


#define RDD_BASIC_SCHEDULER_TABLE_DS_SIZE     6
typedef struct
{
	BASIC_SCHEDULER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_SCHEDULER_TABLE_DS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_SCHEDULER_TABLE_DS_STRUCT;

extern uint32_t RDD_BASIC_SCHEDULER_TABLE_DS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_SCHEDULER_TABLE_DS_PTR(core_id)	( BASIC_SCHEDULER_TABLE_DS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_SCHEDULER_TABLE_DS_ADDRESS_ARR[core_id] ))

/* <<<BASIC_SCHEDULER_TABLE_DS */


/* >>>REPORTING_QUEUE_DESCRIPTOR_TABLE */

/* >>>REPORTING_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reported_bytes   	;
        uint32_t	reported_overhead	;
#else
        uint32_t	reported_bytes   	;
        uint32_t	reported_overhead	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) REPORTING_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT), (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT), (v))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_READ(r, p)                    MREAD_32((uint8_t *)(p), (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_BYTES_WRITE(v, p)                   MWRITE_32((uint8_t *)(p), (v))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(REPORTING_QUEUE_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_READ(r, p)                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_REPORTING_QUEUE_DESCRIPTOR_REPORTED_OVERHEAD_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<REPORTING_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_SIZE     129
typedef struct
{
	REPORTING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_QUEUE_DESCRIPTOR_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_PTR(core_id)	( REPORTING_QUEUE_DESCRIPTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_QUEUE_DESCRIPTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_QUEUE_DESCRIPTOR_TABLE */


/* >>>DS_TM_CODEL_DROP_DESCRIPTOR */

#define RDD_DS_TM_CODEL_DROP_DESCRIPTOR_SIZE     1
typedef struct
{
	CODEL_DROP_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_CODEL_DROP_DESCRIPTOR_STRUCT;

extern uint32_t RDD_DS_TM_CODEL_DROP_DESCRIPTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_CODEL_DROP_DESCRIPTOR_PTR(core_id)	( DS_TM_CODEL_DROP_DESCRIPTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_CODEL_DROP_DESCRIPTOR_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_CODEL_DROP_DESCRIPTOR */


/* >>>DS_TM_TM_FLOW_CNTR_TABLE */

/* >>>TM_FLOW_CNTR_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	cntr_id   	;
#else
        uint8_t	cntr_id   	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TM_FLOW_CNTR_ENTRY_STRUCT;

#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(TM_FLOW_CNTR_ENTRY_STRUCT), (r))
#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(TM_FLOW_CNTR_ENTRY_STRUCT), (v))
#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_TM_FLOW_CNTR_ENTRY_CNTR_ID_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<TM_FLOW_CNTR_ENTRY_STRUCT */


#define RDD_DS_TM_TM_FLOW_CNTR_TABLE_SIZE     64
typedef struct
{
	TM_FLOW_CNTR_ENTRY_STRUCT	entry[ RDD_DS_TM_TM_FLOW_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_TM_FLOW_CNTR_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_TM_FLOW_CNTR_TABLE_PTR(core_id)	( DS_TM_TM_FLOW_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_TM_FLOW_CNTR_TABLE */


/* >>>REPORTING_STACK */

#define RDD_REPORTING_STACK_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_REPORTING_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_STACK_STRUCT;

extern uint32_t RDD_REPORTING_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_STACK_PTR(core_id)	( REPORTING_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_STACK_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_STACK */


/* >>>REPORTING_QUEUE_ACCUMULATED_TABLE */

/* >>>QM_QUEUE_COUNTER_DATA_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	packets   	;
        uint32_t	bytes     	;
        uint32_t	reserved0 	;
        uint32_t	reserved1 	;
#else
        uint32_t	packets   	;
        uint32_t	bytes     	;
        uint32_t	reserved0 	;
        uint32_t	reserved1 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) QM_QUEUE_COUNTER_DATA_STRUCT;

#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ(r, p)                   MREAD_32((uint8_t *)(p), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE(v, p)                  MWRITE_32((uint8_t *)(p), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ(r, p)                     MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<QM_QUEUE_COUNTER_DATA_STRUCT */


#define RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_SIZE     16
typedef struct
{
	QM_QUEUE_COUNTER_DATA_STRUCT	entry[ RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_QUEUE_ACCUMULATED_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_PTR(core_id)	( REPORTING_QUEUE_ACCUMULATED_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_QUEUE_ACCUMULATED_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_QUEUE_ACCUMULATED_TABLE */


/* >>>PROCESSING_4_TASKS_PACKET_BUFFER */

#define RDD_PROCESSING_4_TASKS_PACKET_BUFFER_SIZE     4
typedef struct
{
	PACKET_BUFFER_STRUCT	entry[ RDD_PROCESSING_4_TASKS_PACKET_BUFFER_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ PROCESSING_4_TASKS_PACKET_BUFFER_STRUCT;

extern uint32_t RDD_PROCESSING_4_TASKS_PACKET_BUFFER_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_PROCESSING_4_TASKS_PACKET_BUFFER_PTR(core_id)	( PROCESSING_4_TASKS_PACKET_BUFFER_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_PROCESSING_4_TASKS_PACKET_BUFFER_ADDRESS_ARR[core_id] ))

/* <<<PROCESSING_4_TASKS_PACKET_BUFFER */


/* >>>COMPLEX_SCHEDULER_TABLE */

#define RDD_COMPLEX_SCHEDULER_TABLE_SIZE     16
typedef struct
{
	COMPLEX_SCHEDULER_DESCRIPTOR_STRUCT	entry[ RDD_COMPLEX_SCHEDULER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ COMPLEX_SCHEDULER_TABLE_STRUCT;

extern uint32_t RDD_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_COMPLEX_SCHEDULER_TABLE_PTR(core_id)	( COMPLEX_SCHEDULER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_COMPLEX_SCHEDULER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<COMPLEX_SCHEDULER_TABLE */


/* >>>DS_TM_BBH_TX_WAKE_UP_DATA_TABLE */

/* >>>BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_in_bbh	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	queue       	;
        uint32_t	reserved1   	;
#else
        uint8_t	queue       	;
        uint32_t	bytes_in_bbh	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1   	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT;

#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT), 8, 19, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT), 8, 19, (v))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p), 8, 19, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_BYTES_IN_BBH_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p), 8, 19, (v))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_READ_G(r, g, idx)                 GROUP_MREAD_8((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT) + 3, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_WRITE_G(v, g, idx)                GROUP_MWRITE_8((g), (idx)*sizeof(BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT) + 3, (v))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_READ(r, p)                        MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BBH_TX_WAKE_UP_DATA_ENTRY_QUEUE_WRITE(v, p)                       MWRITE_8((uint8_t *)(p) + 3, (v))
/* <<<BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT */


#define RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_SIZE     1
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_PTR(core_id)	( DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BBH_TX_WAKE_UP_DATA_TABLE */


/* >>>DS_BUFFER_CONG_MGT_CFG */

/* >>>BUFFER_CONG_MGT_STRUCT */
typedef union
{
    uint32_t word_32[16];
    uint64_t dword_64[8];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	dqm_not_empty_address  	;
        uint32_t	dqm_valid_ctr_address  	;
        uint32_t	ug_counter_address     	;
        uint16_t	ug_threshold_high      	;
        uint16_t	ug_threshold_low       	;
        uint8_t	enabled                	;
        uint8_t	start_queue            	;
        uint8_t	end_queue              	;
        uint8_t	fw_state               	;
        uint16_t	timer_duration         	;
        uint16_t	reserved1              	;
        uint8_t	sq_start_queue         	;
        uint8_t	num_pds_to_flush       	;
        uint16_t	flush_wakeup           	;
        uint16_t	flush_cfg_address      	;
        uint16_t	flush_enable_address   	;
        uint32_t	sq_flush_wakeup        	;
        uint32_t	sq_flush_wakeup_value  	;
        uint32_t	sq_flush_cfg_address   	;
        uint32_t	sq_flush_enable_address	;
        uint16_t	cong_queue_idx         	;
        uint16_t	cong_queue_occupancy   	;
        uint32_t	cong_detected          	;
        uint32_t	cong_cleared           	;
        uint32_t	cong_detection_time    	;
#else
        uint32_t	dqm_not_empty_address  	;
        uint32_t	dqm_valid_ctr_address  	;
        uint32_t	ug_counter_address     	;
        uint16_t	ug_threshold_low       	;
        uint16_t	ug_threshold_high      	;
        uint8_t	fw_state               	;
        uint8_t	end_queue              	;
        uint8_t	start_queue            	;
        uint8_t	enabled                	;
        uint16_t	reserved1              	;
        uint16_t	timer_duration         	;
        uint16_t	flush_wakeup           	;
        uint8_t	num_pds_to_flush       	;
        uint8_t	sq_start_queue         	;
        uint16_t	flush_enable_address   	;
        uint16_t	flush_cfg_address      	;
        uint32_t	sq_flush_wakeup        	;
        uint32_t	sq_flush_wakeup_value  	;
        uint32_t	sq_flush_cfg_address   	;
        uint32_t	sq_flush_enable_address	;
        uint16_t	cong_queue_occupancy   	;
        uint16_t	cong_queue_idx         	;
        uint32_t	cong_detected          	;
        uint32_t	cong_cleared           	;
        uint32_t	cong_detection_time    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BUFFER_CONG_MGT_STRUCT;

#define RDD_BUFFER_CONG_MGT_DQM_NOT_EMPTY_ADDRESS_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT), (r))
#define RDD_BUFFER_CONG_MGT_DQM_NOT_EMPTY_ADDRESS_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT), (v))
#define RDD_BUFFER_CONG_MGT_DQM_NOT_EMPTY_ADDRESS_READ(r, p)                   MREAD_32((uint8_t *)(p), (r))
#define RDD_BUFFER_CONG_MGT_DQM_NOT_EMPTY_ADDRESS_WRITE(v, p)                  MWRITE_32((uint8_t *)(p), (v))
#define RDD_BUFFER_CONG_MGT_DQM_VALID_CTR_ADDRESS_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 4, (r))
#define RDD_BUFFER_CONG_MGT_DQM_VALID_CTR_ADDRESS_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 4, (v))
#define RDD_BUFFER_CONG_MGT_DQM_VALID_CTR_ADDRESS_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_BUFFER_CONG_MGT_DQM_VALID_CTR_ADDRESS_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_BUFFER_CONG_MGT_UG_COUNTER_ADDRESS_READ_G(r, g, idx)               GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 8, (r))
#define RDD_BUFFER_CONG_MGT_UG_COUNTER_ADDRESS_WRITE_G(v, g, idx)              GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 8, (v))
#define RDD_BUFFER_CONG_MGT_UG_COUNTER_ADDRESS_READ(r, p)                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_BUFFER_CONG_MGT_UG_COUNTER_ADDRESS_WRITE(v, p)                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_HIGH_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 12, (r))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_HIGH_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 12, (v))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_HIGH_READ(r, p)                       MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_HIGH_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_LOW_READ_G(r, g, idx)                 GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 14, (r))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_LOW_WRITE_G(v, g, idx)                GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 14, (v))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_LOW_READ(r, p)                        MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_BUFFER_CONG_MGT_UG_THRESHOLD_LOW_WRITE(v, p)                       MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_BUFFER_CONG_MGT_ENABLED_READ_G(r, g, idx)                          GROUP_MREAD_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 16, (r))
#define RDD_BUFFER_CONG_MGT_ENABLED_WRITE_G(v, g, idx)                         GROUP_MWRITE_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 16, (v))
#define RDD_BUFFER_CONG_MGT_ENABLED_READ(r, p)                                 MREAD_8((uint8_t *)(p) + 16, (r))
#define RDD_BUFFER_CONG_MGT_ENABLED_WRITE(v, p)                                MWRITE_8((uint8_t *)(p) + 16, (v))
#define RDD_BUFFER_CONG_MGT_START_QUEUE_READ_G(r, g, idx)                      GROUP_MREAD_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 17, (r))
#define RDD_BUFFER_CONG_MGT_START_QUEUE_WRITE_G(v, g, idx)                     GROUP_MWRITE_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 17, (v))
#define RDD_BUFFER_CONG_MGT_START_QUEUE_READ(r, p)                             MREAD_8((uint8_t *)(p) + 17, (r))
#define RDD_BUFFER_CONG_MGT_START_QUEUE_WRITE(v, p)                            MWRITE_8((uint8_t *)(p) + 17, (v))
#define RDD_BUFFER_CONG_MGT_END_QUEUE_READ_G(r, g, idx)                        GROUP_MREAD_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 18, (r))
#define RDD_BUFFER_CONG_MGT_END_QUEUE_WRITE_G(v, g, idx)                       GROUP_MWRITE_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 18, (v))
#define RDD_BUFFER_CONG_MGT_END_QUEUE_READ(r, p)                               MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_BUFFER_CONG_MGT_END_QUEUE_WRITE(v, p)                              MWRITE_8((uint8_t *)(p) + 18, (v))
#define RDD_BUFFER_CONG_MGT_FW_STATE_READ_G(r, g, idx)                         GROUP_MREAD_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 19, (r))
#define RDD_BUFFER_CONG_MGT_FW_STATE_WRITE_G(v, g, idx)                        GROUP_MWRITE_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 19, (v))
#define RDD_BUFFER_CONG_MGT_FW_STATE_READ(r, p)                                MREAD_8((uint8_t *)(p) + 19, (r))
#define RDD_BUFFER_CONG_MGT_FW_STATE_WRITE(v, p)                               MWRITE_8((uint8_t *)(p) + 19, (v))
#define RDD_BUFFER_CONG_MGT_TIMER_DURATION_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 20, (r))
#define RDD_BUFFER_CONG_MGT_TIMER_DURATION_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 20, (v))
#define RDD_BUFFER_CONG_MGT_TIMER_DURATION_READ(r, p)                          MREAD_16((uint8_t *)(p) + 20, (r))
#define RDD_BUFFER_CONG_MGT_TIMER_DURATION_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 20, (v))
#define RDD_BUFFER_CONG_MGT_SQ_START_QUEUE_READ_G(r, g, idx)                   GROUP_MREAD_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 24, (r))
#define RDD_BUFFER_CONG_MGT_SQ_START_QUEUE_WRITE_G(v, g, idx)                  GROUP_MWRITE_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 24, (v))
#define RDD_BUFFER_CONG_MGT_SQ_START_QUEUE_READ(r, p)                          MREAD_8((uint8_t *)(p) + 24, (r))
#define RDD_BUFFER_CONG_MGT_SQ_START_QUEUE_WRITE(v, p)                         MWRITE_8((uint8_t *)(p) + 24, (v))
#define RDD_BUFFER_CONG_MGT_NUM_PDS_TO_FLUSH_READ_G(r, g, idx)                 GROUP_MREAD_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 25, (r))
#define RDD_BUFFER_CONG_MGT_NUM_PDS_TO_FLUSH_WRITE_G(v, g, idx)                GROUP_MWRITE_8((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 25, (v))
#define RDD_BUFFER_CONG_MGT_NUM_PDS_TO_FLUSH_READ(r, p)                        MREAD_8((uint8_t *)(p) + 25, (r))
#define RDD_BUFFER_CONG_MGT_NUM_PDS_TO_FLUSH_WRITE(v, p)                       MWRITE_8((uint8_t *)(p) + 25, (v))
#define RDD_BUFFER_CONG_MGT_FLUSH_WAKEUP_READ_G(r, g, idx)                     GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 26, (r))
#define RDD_BUFFER_CONG_MGT_FLUSH_WAKEUP_WRITE_G(v, g, idx)                    GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 26, (v))
#define RDD_BUFFER_CONG_MGT_FLUSH_WAKEUP_READ(r, p)                            MREAD_16((uint8_t *)(p) + 26, (r))
#define RDD_BUFFER_CONG_MGT_FLUSH_WAKEUP_WRITE(v, p)                           MWRITE_16((uint8_t *)(p) + 26, (v))
#define RDD_BUFFER_CONG_MGT_FLUSH_CFG_ADDRESS_READ_G(r, g, idx)                GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 28, (r))
#define RDD_BUFFER_CONG_MGT_FLUSH_CFG_ADDRESS_WRITE_G(v, g, idx)               GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 28, (v))
#define RDD_BUFFER_CONG_MGT_FLUSH_CFG_ADDRESS_READ(r, p)                       MREAD_16((uint8_t *)(p) + 28, (r))
#define RDD_BUFFER_CONG_MGT_FLUSH_CFG_ADDRESS_WRITE(v, p)                      MWRITE_16((uint8_t *)(p) + 28, (v))
#define RDD_BUFFER_CONG_MGT_FLUSH_ENABLE_ADDRESS_READ_G(r, g, idx)             GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 30, (r))
#define RDD_BUFFER_CONG_MGT_FLUSH_ENABLE_ADDRESS_WRITE_G(v, g, idx)            GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 30, (v))
#define RDD_BUFFER_CONG_MGT_FLUSH_ENABLE_ADDRESS_READ(r, p)                    MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_BUFFER_CONG_MGT_FLUSH_ENABLE_ADDRESS_WRITE(v, p)                   MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_READ_G(r, g, idx)                  GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 32, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_WRITE_G(v, g, idx)                 GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 32, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_READ(r, p)                         MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_WRITE(v, p)                        MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_VALUE_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 36, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_VALUE_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 36, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_VALUE_READ(r, p)                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_WAKEUP_VALUE_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_CFG_ADDRESS_READ_G(r, g, idx)             GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 40, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_CFG_ADDRESS_WRITE_G(v, g, idx)            GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 40, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_CFG_ADDRESS_READ(r, p)                    MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_CFG_ADDRESS_WRITE(v, p)                   MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_ENABLE_ADDRESS_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 44, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_ENABLE_ADDRESS_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 44, (v))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_ENABLE_ADDRESS_READ(r, p)                 MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_BUFFER_CONG_MGT_SQ_FLUSH_ENABLE_ADDRESS_WRITE(v, p)                MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_IDX_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 48, (r))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_IDX_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 48, (v))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_IDX_READ(r, p)                          MREAD_16((uint8_t *)(p) + 48, (r))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_IDX_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 48, (v))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_OCCUPANCY_READ_G(r, g, idx)             GROUP_MREAD_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 50, (r))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_OCCUPANCY_WRITE_G(v, g, idx)            GROUP_MWRITE_16((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 50, (v))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_OCCUPANCY_READ(r, p)                    MREAD_16((uint8_t *)(p) + 50, (r))
#define RDD_BUFFER_CONG_MGT_CONG_QUEUE_OCCUPANCY_WRITE(v, p)                   MWRITE_16((uint8_t *)(p) + 50, (v))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTED_READ_G(r, g, idx)                    GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 52, (r))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTED_WRITE_G(v, g, idx)                   GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 52, (v))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTED_READ(r, p)                           MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTED_WRITE(v, p)                          MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_BUFFER_CONG_MGT_CONG_CLEARED_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 56, (r))
#define RDD_BUFFER_CONG_MGT_CONG_CLEARED_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 56, (v))
#define RDD_BUFFER_CONG_MGT_CONG_CLEARED_READ(r, p)                            MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_BUFFER_CONG_MGT_CONG_CLEARED_WRITE(v, p)                           MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTION_TIME_READ_G(r, g, idx)              GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 60, (r))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTION_TIME_WRITE_G(v, g, idx)             GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_MGT_STRUCT) + 60, (v))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTION_TIME_READ(r, p)                     MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_BUFFER_CONG_MGT_CONG_DETECTION_TIME_WRITE(v, p)                    MWRITE_32((uint8_t *)(p) + 60, (v))
/* <<<BUFFER_CONG_MGT_STRUCT */


#define RDD_DS_BUFFER_CONG_MGT_CFG_SIZE     1
typedef struct
{
	BUFFER_CONG_MGT_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_BUFFER_CONG_MGT_CFG_STRUCT;

extern uint32_t RDD_DS_BUFFER_CONG_MGT_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_BUFFER_CONG_MGT_CFG_PTR(core_id)	( DS_BUFFER_CONG_MGT_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_BUFFER_CONG_MGT_CFG_ADDRESS_ARR[core_id] ))

/* <<<DS_BUFFER_CONG_MGT_CFG */


/* >>>BUFFER_CONG_DQM_NOT_EMPTY */

#define RDD_BUFFER_CONG_DQM_NOT_EMPTY_SIZE     8
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_BUFFER_CONG_DQM_NOT_EMPTY_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BUFFER_CONG_DQM_NOT_EMPTY_STRUCT;

extern uint32_t RDD_BUFFER_CONG_DQM_NOT_EMPTY_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BUFFER_CONG_DQM_NOT_EMPTY_PTR(core_id)	( BUFFER_CONG_DQM_NOT_EMPTY_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BUFFER_CONG_DQM_NOT_EMPTY_ADDRESS_ARR[core_id] ))

/* <<<BUFFER_CONG_DQM_NOT_EMPTY */


/* >>>BASIC_RATE_LIMITER_TABLE_DS */

#define RDD_BASIC_RATE_LIMITER_TABLE_DS_SIZE     48
typedef struct
{
	BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_RATE_LIMITER_TABLE_DS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_RATE_LIMITER_TABLE_DS_STRUCT;

extern uint32_t RDD_BASIC_RATE_LIMITER_TABLE_DS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_RATE_LIMITER_TABLE_DS_PTR(core_id)	( BASIC_RATE_LIMITER_TABLE_DS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_RATE_LIMITER_TABLE_DS_ADDRESS_ARR[core_id] ))

/* <<<BASIC_RATE_LIMITER_TABLE_DS */


/* >>>VLAN_TX_COUNTERS */

#define RDD_VLAN_TX_COUNTERS_SIZE     129
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_VLAN_TX_COUNTERS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ VLAN_TX_COUNTERS_STRUCT;

extern uint32_t RDD_VLAN_TX_COUNTERS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_VLAN_TX_COUNTERS_PTR(core_id)	( VLAN_TX_COUNTERS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_VLAN_TX_COUNTERS_ADDRESS_ARR[core_id] ))

/* <<<VLAN_TX_COUNTERS */


/* >>>DS_TM_CPU_TX_ABS_COUNTERS */

#define RDD_DS_TM_CPU_TX_ABS_COUNTERS_SIZE     32
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DS_TM_CPU_TX_ABS_COUNTERS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_CPU_TX_ABS_COUNTERS_STRUCT;

extern uint32_t RDD_DS_TM_CPU_TX_ABS_COUNTERS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_CPU_TX_ABS_COUNTERS_PTR(core_id)	( DS_TM_CPU_TX_ABS_COUNTERS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_CPU_TX_ABS_COUNTERS_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_CPU_TX_ABS_COUNTERS */


/* >>>REPORT_BBH_TX_QUEUE_ID_TABLE */

#define RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_SIZE     2
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORT_BBH_TX_QUEUE_ID_TABLE_STRUCT;

extern uint32_t RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_PTR(core_id)	( REPORT_BBH_TX_QUEUE_ID_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORT_BBH_TX_QUEUE_ID_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORT_BBH_TX_QUEUE_ID_TABLE */


/* >>>BUFFER_CONG_SCRATCHPAD */

/* >>>BUFFER_CONG_Q_OCCUPANCY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	packet_cnt	;
        uint32_t	byte_cnt  	;
#else
        uint32_t	packet_cnt	;
        uint32_t	byte_cnt  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BUFFER_CONG_Q_OCCUPANCY_STRUCT;

#define RDD_BUFFER_CONG_Q_OCCUPANCY_PACKET_CNT_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_Q_OCCUPANCY_STRUCT), (r))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_PACKET_CNT_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_Q_OCCUPANCY_STRUCT), (v))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_PACKET_CNT_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_PACKET_CNT_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_BYTE_CNT_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(BUFFER_CONG_Q_OCCUPANCY_STRUCT) + 4, (r))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_BYTE_CNT_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(BUFFER_CONG_Q_OCCUPANCY_STRUCT) + 4, (v))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_BYTE_CNT_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_BUFFER_CONG_Q_OCCUPANCY_BYTE_CNT_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<BUFFER_CONG_Q_OCCUPANCY_STRUCT */


#define RDD_BUFFER_CONG_SCRATCHPAD_SIZE     8
typedef struct
{
	BUFFER_CONG_Q_OCCUPANCY_STRUCT	entry[ RDD_BUFFER_CONG_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BUFFER_CONG_SCRATCHPAD_STRUCT;

extern uint32_t RDD_BUFFER_CONG_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BUFFER_CONG_SCRATCHPAD_PTR(core_id)	( BUFFER_CONG_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BUFFER_CONG_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<BUFFER_CONG_SCRATCHPAD */


/* >>>GHOST_REPORTING_GLOBAL_CFG */

/* >>>GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	mac_type      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	disable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved      	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	timer_interval	;
#else
        uint16_t	timer_interval	;
        uint32_t	reserved      	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	disable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mac_type      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT;

#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 5, 3, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 5, 3, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_MAC_TYPE_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_DISABLE_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_READ(r, p)                 MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_GHOST_REPORTING_GLOBAL_CFG_ENTRY_TIMER_INTERVAL_WRITE(v, p)                MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT */


#define RDD_GHOST_REPORTING_GLOBAL_CFG_SIZE     1
typedef struct
{
	GHOST_REPORTING_GLOBAL_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ GHOST_REPORTING_GLOBAL_CFG_STRUCT;

extern uint32_t RDD_GHOST_REPORTING_GLOBAL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GHOST_REPORTING_GLOBAL_CFG_PTR(core_id)	( GHOST_REPORTING_GLOBAL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GHOST_REPORTING_GLOBAL_CFG_ADDRESS_ARR[core_id] ))

/* <<<GHOST_REPORTING_GLOBAL_CFG */


/* >>>BUDGET_ALLOCATION_TIMER_VALUE */

#define RDD_BUDGET_ALLOCATION_TIMER_VALUE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BUDGET_ALLOCATION_TIMER_VALUE_STRUCT;

extern uint32_t RDD_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BUDGET_ALLOCATION_TIMER_VALUE_PTR(core_id)	( BUDGET_ALLOCATION_TIMER_VALUE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BUDGET_ALLOCATION_TIMER_VALUE_ADDRESS_ARR[core_id] ))

/* <<<BUDGET_ALLOCATION_TIMER_VALUE */


/* >>>DS_TM_FLUSH_CFG_CPU_TABLE */

#define RDD_DS_TM_FLUSH_CFG_CPU_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_CPU_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_CPU_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_CPU_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_CPU_TABLE */


/* >>>DS_TM_SCHEDULING_QUEUE_AGING_VECTOR */

#define RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT;

extern uint32_t RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_PTR(core_id)	( DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_SCHEDULING_QUEUE_AGING_VECTOR */


/* >>>DS_TM_FLUSH_CFG_ENABLE_TABLE */

#define RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENABLE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_ENABLE_TABLE */


/* >>>GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE */

#define RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_STRUCT;

extern uint32_t RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_PTR(core_id)	( GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<GHOST_REPORTING_QUEUE_STATUS_BIT_VECTOR_TABLE */


/* >>>DS_TM_BB_DESTINATION_TABLE */

#define RDD_DS_TM_BB_DESTINATION_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BB_DESTINATION_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BB_DESTINATION_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BB_DESTINATION_TABLE_PTR(core_id)	( DS_TM_BB_DESTINATION_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BB_DESTINATION_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BB_DESTINATION_TABLE */


/* >>>QUEUE_TO_REPORT_BIT_VECTOR */

#define RDD_QUEUE_TO_REPORT_BIT_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_QUEUE_TO_REPORT_BIT_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ QUEUE_TO_REPORT_BIT_VECTOR_STRUCT;

extern uint32_t RDD_QUEUE_TO_REPORT_BIT_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_QUEUE_TO_REPORT_BIT_VECTOR_PTR(core_id)	( QUEUE_TO_REPORT_BIT_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_QUEUE_TO_REPORT_BIT_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<QUEUE_TO_REPORT_BIT_VECTOR */


/* >>>SCHEDULING_FLUSH_GLOBAL_CFG */

#define RDD_SCHEDULING_FLUSH_GLOBAL_CFG_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ SCHEDULING_FLUSH_GLOBAL_CFG_STRUCT;

extern uint32_t RDD_SCHEDULING_FLUSH_GLOBAL_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_SCHEDULING_FLUSH_GLOBAL_CFG_PTR(core_id)	( SCHEDULING_FLUSH_GLOBAL_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_SCHEDULING_FLUSH_GLOBAL_CFG_ADDRESS_ARR[core_id] ))

/* <<<SCHEDULING_FLUSH_GLOBAL_CFG */


/* >>>TX_EXCEPTION */

/* >>>TX_EXCEPTION_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved1   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dbg_stat_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	vlan_cntr_en	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	vlan_cntr_en	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dbg_stat_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} TX_EXCEPTION_ENTRY_STRUCT;

#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
/* <<<TX_EXCEPTION_ENTRY_STRUCT */


#define RDD_TX_EXCEPTION_SIZE     1
typedef struct
{
	TX_EXCEPTION_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_EXCEPTION_STRUCT;

extern uint32_t RDD_TX_EXCEPTION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_EXCEPTION_PTR(core_id)	( TX_EXCEPTION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_EXCEPTION_ADDRESS_ARR[core_id] ))

/* <<<TX_EXCEPTION */


/* >>>BBH_TX_EGRESS_REPORT_COUNTER_TABLE */

/* >>>BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT */
typedef union
{
    uint32_t word_32[2];
    uint64_t dword_64[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	counter   	;
        uint32_t	reserved0 	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1 	;
#else
        uint32_t	reserved0 	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	counter   	;
        uint32_t	reserved1 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT;

#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_READ_G(r, g, idx)            GROUP_MREAD_8((g), (idx)*sizeof(BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT), (r))
#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_WRITE_G(v, g, idx)           GROUP_MWRITE_8((g), (idx)*sizeof(BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT), (v))
#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_READ(r, p)                   MREAD_8((uint8_t *)(p), (r))
#define RDD_BBH_TX_EGRESS_COUNTER_ENTRY_COUNTER_WRITE(v, p)                  MWRITE_8((uint8_t *)(p), (v))
/* <<<BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT */


#define RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_SIZE     1
typedef struct
{
	BBH_TX_EGRESS_COUNTER_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EGRESS_REPORT_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_PTR(core_id)	( BBH_TX_EGRESS_REPORT_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EGRESS_REPORT_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EGRESS_REPORT_COUNTER_TABLE */


/* >>>DS_TM_FLUSH_CFG_FW_TABLE */

#define RDD_DS_TM_FLUSH_CFG_FW_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_FW_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_FW_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_FW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_FW_TABLE */


/* >>>DS_TM_FLUSH_CFG_CURRENT_TABLE */

#define RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_PTR(core_id)	( DS_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_CFG_CURRENT_TABLE */


/* >>>DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE */

#define RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FLUSH_DISPATCHER_CREDIT_TABLE */


/* >>>TX_MIRRORING_CONFIGURATION */

#define RDD_TX_MIRRORING_CONFIGURATION_SIZE     1
typedef struct
{
	MIRRORING_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_MIRRORING_CONFIGURATION_STRUCT;

extern uint32_t RDD_TX_MIRRORING_CONFIGURATION_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_MIRRORING_CONFIGURATION_PTR(core_id)	( TX_MIRRORING_CONFIGURATION_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_MIRRORING_CONFIGURATION_ADDRESS_ARR[core_id] ))

/* <<<TX_MIRRORING_CONFIGURATION */


/* >>>DS_TM_TX_QUEUE_DROP_TABLE */

#define RDD_DS_TM_TX_QUEUE_DROP_TABLE_SIZE     65
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_DS_TM_TX_QUEUE_DROP_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_TX_QUEUE_DROP_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_TX_QUEUE_DROP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_TX_QUEUE_DROP_TABLE_PTR(core_id)	( DS_TM_TX_QUEUE_DROP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_TX_QUEUE_DROP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_TX_QUEUE_DROP_TABLE */


/* >>>DS_TM_FIRST_QUEUE_MAPPING */

#define RDD_DS_TM_FIRST_QUEUE_MAPPING_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_FIRST_QUEUE_MAPPING_STRUCT;

extern uint32_t RDD_DS_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_FIRST_QUEUE_MAPPING_PTR(core_id)	( DS_TM_FIRST_QUEUE_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_FIRST_QUEUE_MAPPING */


/* >>>BACKUP_BBH_INGRESS_COUNTERS_TABLE */

#define RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BACKUP_BBH_INGRESS_COUNTERS_TABLE_STRUCT;

extern uint32_t RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_PTR(core_id)	( BACKUP_BBH_INGRESS_COUNTERS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BACKUP_BBH_INGRESS_COUNTERS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BACKUP_BBH_INGRESS_COUNTERS_TABLE */


/* >>>RATE_LIMITER_VALID_TABLE_DS */

#define RDD_RATE_LIMITER_VALID_TABLE_DS_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_RATE_LIMITER_VALID_TABLE_DS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RATE_LIMITER_VALID_TABLE_DS_STRUCT;

extern uint32_t RDD_RATE_LIMITER_VALID_TABLE_DS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RATE_LIMITER_VALID_TABLE_DS_PTR(core_id)	( RATE_LIMITER_VALID_TABLE_DS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RATE_LIMITER_VALID_TABLE_DS_ADDRESS_ARR[core_id] ))

/* <<<RATE_LIMITER_VALID_TABLE_DS */


/* >>>BACKUP_BBH_EGRESS_COUNTERS_TABLE */

#define RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BACKUP_BBH_EGRESS_COUNTERS_TABLE_STRUCT;

extern uint32_t RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_PTR(core_id)	( BACKUP_BBH_EGRESS_COUNTERS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BACKUP_BBH_EGRESS_COUNTERS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BACKUP_BBH_EGRESS_COUNTERS_TABLE */


/* >>>TX_MIRRORING_DISPATCHER_CREDIT_TABLE */

#define RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ TX_MIRRORING_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( TX_MIRRORING_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_TX_MIRRORING_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<TX_MIRRORING_DISPATCHER_CREDIT_TABLE */


/* >>>BBH_TX_INGRESS_COUNTER_TABLE */

#define RDD_BBH_TX_INGRESS_COUNTER_TABLE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_INGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_INGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_INGRESS_COUNTER_TABLE_PTR(core_id)	( BBH_TX_INGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_INGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_INGRESS_COUNTER_TABLE */


/* >>>DS_TM_BBH_TX_EGRESS_COUNTER_TABLE */

#define RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_SIZE     8
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_PTR(core_id)	( DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BBH_TX_EGRESS_COUNTER_TABLE */


/* >>>XGPON_REPORT_ZERO_SENT_TABLE */

#define RDD_XGPON_REPORT_ZERO_SENT_TABLE_SIZE     10
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_XGPON_REPORT_ZERO_SENT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ XGPON_REPORT_ZERO_SENT_TABLE_STRUCT;

extern uint32_t RDD_XGPON_REPORT_ZERO_SENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_XGPON_REPORT_ZERO_SENT_TABLE_PTR(core_id)	( XGPON_REPORT_ZERO_SENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_XGPON_REPORT_ZERO_SENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<XGPON_REPORT_ZERO_SENT_TABLE */


/* >>>REPORTING_QUEUE_COUNTER_TABLE */

/* >>>REPORTING_QUEUE_COUNTER_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	counter_ptr	;
#else
        uint16_t	counter_ptr	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) REPORTING_QUEUE_COUNTER_STRUCT;

#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_READ_G(r, g, idx)          GROUP_MREAD_16((g), (idx)*sizeof(REPORTING_QUEUE_COUNTER_STRUCT), (r))
#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_WRITE_G(v, g, idx)         GROUP_MWRITE_16((g), (idx)*sizeof(REPORTING_QUEUE_COUNTER_STRUCT), (v))
#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_READ(r, p)                 MREAD_16((uint8_t *)(p), (r))
#define RDD_REPORTING_QUEUE_COUNTER_COUNTER_PTR_WRITE(v, p)                MWRITE_16((uint8_t *)(p), (v))
/* <<<REPORTING_QUEUE_COUNTER_STRUCT */


#define RDD_REPORTING_QUEUE_COUNTER_TABLE_SIZE     129
typedef struct
{
	REPORTING_QUEUE_COUNTER_STRUCT	entry[ RDD_REPORTING_QUEUE_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_QUEUE_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_QUEUE_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_QUEUE_COUNTER_TABLE_PTR(core_id)	( REPORTING_QUEUE_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_QUEUE_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_QUEUE_COUNTER_TABLE */


/* >>>DS_TM_CODEL_QUEUE_TABLE */

#define RDD_DS_TM_CODEL_QUEUE_TABLE_SIZE     48
typedef struct
{
	CODEL_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_CODEL_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_CODEL_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_CODEL_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_CODEL_QUEUE_TABLE_PTR(core_id)	( DS_TM_CODEL_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_CODEL_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_CODEL_QUEUE_TABLE */


/* >>>REPORTING_COUNTER_TABLE */

#define RDD_REPORTING_COUNTER_TABLE_SIZE     40
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_REPORTING_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ REPORTING_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_REPORTING_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_REPORTING_COUNTER_TABLE_PTR(core_id)	( REPORTING_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_REPORTING_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<REPORTING_COUNTER_TABLE */


/* >>>DS_TM_BBH_QUEUE_TABLE */

/* >>>BBH_QUEUE_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[1];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	wan_type_union 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	mirroring_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_type 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bb_destination 	;
        uint8_t	ingress_counter	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	hw_bbh_qid               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
        uint32_t	reservedSU1_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_bb_destination	;
        uint8_t	reservedSU1_ingress_counter	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved                 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
        uint32_t	reservedSU2_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_bb_destination	;
        uint8_t	reservedSU2_ingress_counter	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	ingress_counter	;
        uint8_t	bb_destination 	;
        uint32_t	scheduler_type 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_type_union 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_ingress_counter	;
        uint8_t	reservedSU1_bb_destination	;
        uint32_t	reservedSU1_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_bbh_qid               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_ingress_counter	;
        uint8_t	reservedSU2_bb_destination	;
        uint32_t	reservedSU2_scheduler_type	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_scheduler_index	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mirroring_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_type_union union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(4))) BBH_QUEUE_DESCRIPTOR_STRUCT;

#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_WAN_TYPE_UNION_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 2, 6, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_HW_BBH_QID_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 2, 6, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_MIRRORING_EN_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT), 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_PRIORITY_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 1, 7, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 1, 7, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p) + 1, 1, 7, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_INDEX_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p) + 1, 1, 7, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 1, 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_SCHEDULER_TYPE_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_READ(r, p)                  MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_BB_DESTINATION_WRITE(v, p)                 MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(BBH_QUEUE_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_READ(r, p)                 MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_BBH_QUEUE_DESCRIPTOR_INGRESS_COUNTER_WRITE(v, p)                MWRITE_8((uint8_t *)(p) + 3, (v))
/* <<<BBH_QUEUE_DESCRIPTOR_STRUCT */


#define RDD_DS_TM_BBH_QUEUE_TABLE_SIZE     8
typedef struct
{
	BBH_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_DS_TM_BBH_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DS_TM_BBH_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_DS_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DS_TM_BBH_QUEUE_TABLE_PTR(core_id)	( DS_TM_BBH_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DS_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DS_TM_BBH_QUEUE_TABLE */

/* CORE_5 */

/* >>>US_TM_PD_FIFO_TABLE */

#define RDD_US_TM_PD_FIFO_TABLE_SIZE     264
typedef struct
{
	PROCESSING_TX_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_PD_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_PD_FIFO_TABLE_STRUCT;

extern uint32_t RDD_US_TM_PD_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_PD_FIFO_TABLE_PTR(core_id)	( US_TM_PD_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_PD_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_PD_FIFO_TABLE */


/* >>>US_TM_TX_QUEUE_DROP_TABLE */

#define RDD_US_TM_TX_QUEUE_DROP_TABLE_SIZE     65
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_US_TM_TX_QUEUE_DROP_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TX_QUEUE_DROP_TABLE_STRUCT;

extern uint32_t RDD_US_TM_TX_QUEUE_DROP_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TX_QUEUE_DROP_TABLE_PTR(core_id)	( US_TM_TX_QUEUE_DROP_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TX_QUEUE_DROP_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TX_QUEUE_DROP_TABLE */


/* >>>US_TM_CODEL_DROP_DESCRIPTOR */

#define RDD_US_TM_CODEL_DROP_DESCRIPTOR_SIZE     1
typedef struct
{
	CODEL_DROP_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_CODEL_DROP_DESCRIPTOR_STRUCT;

extern uint32_t RDD_US_TM_CODEL_DROP_DESCRIPTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_CODEL_DROP_DESCRIPTOR_PTR(core_id)	( US_TM_CODEL_DROP_DESCRIPTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_CODEL_DROP_DESCRIPTOR_ADDRESS_ARR[core_id] ))

/* <<<US_TM_CODEL_DROP_DESCRIPTOR */


/* >>>DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD */

#define RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_SIZE     136
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_PTR(core_id)	( DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_RX_MIRRORING_SCRATCHPAD */


/* >>>US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE */

#define RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_SIZE     1
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_PTR(core_id)	( US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_0_BBH_TX_WAKE_UP_DATA_TABLE */


/* >>>DIRECT_FLOW_CNTR_TABLE */

#define RDD_DIRECT_FLOW_CNTR_TABLE_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_CNTR_TABLE_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_CNTR_TABLE_PTR(core_id)	( DIRECT_FLOW_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_CNTR_TABLE */


/* >>>DIRECT_FLOW_STACK */

#define RDD_DIRECT_FLOW_STACK_SIZE     64
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_STACK_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_STACK_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_STACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_STACK_PTR(core_id)	( DIRECT_FLOW_STACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_STACK_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_STACK */


/* >>>US_TM_SCHEDULING_QUEUE_TABLE */

#define RDD_US_TM_SCHEDULING_QUEUE_TABLE_SIZE     132
typedef struct
{
	SCHEDULING_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_SCHEDULING_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_SCHEDULING_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_SCHEDULING_QUEUE_TABLE_PTR(core_id)	( US_TM_SCHEDULING_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_SCHEDULING_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_SCHEDULING_QUEUE_TABLE */


/* >>>US_BUFFER_CONG_MGT_CFG */

#define RDD_US_BUFFER_CONG_MGT_CFG_SIZE     1
typedef struct
{
	BUFFER_CONG_MGT_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_BUFFER_CONG_MGT_CFG_STRUCT;

extern uint32_t RDD_US_BUFFER_CONG_MGT_CFG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_BUFFER_CONG_MGT_CFG_PTR(core_id)	( US_BUFFER_CONG_MGT_CFG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_BUFFER_CONG_MGT_CFG_ADDRESS_ARR[core_id] ))

/* <<<US_BUFFER_CONG_MGT_CFG */


/* >>>US_TM_TM_FLOW_CNTR_TABLE */

#define RDD_US_TM_TM_FLOW_CNTR_TABLE_SIZE     128
typedef struct
{
	TM_FLOW_CNTR_ENTRY_STRUCT	entry[ RDD_US_TM_TM_FLOW_CNTR_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TM_FLOW_CNTR_TABLE_STRUCT;

extern uint32_t RDD_US_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TM_FLOW_CNTR_TABLE_PTR(core_id)	( US_TM_TM_FLOW_CNTR_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TM_FLOW_CNTR_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TM_FLOW_CNTR_TABLE */


/* >>>DIRECT_FLOW_EPON_CONTROL_SCRATCH */

#define RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_SIZE     22
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_EPON_CONTROL_SCRATCH_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_PTR(core_id)	( DIRECT_FLOW_EPON_CONTROL_SCRATCH_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_EPON_CONTROL_SCRATCH_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_EPON_CONTROL_SCRATCH */


/* >>>BBH_TX_EPON_WAKE_UP_DATA_TABLE */

#define RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_SIZE     1
typedef struct
{
	BBH_TX_WAKE_UP_DATA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EPON_WAKE_UP_DATA_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_PTR(core_id)	( BBH_TX_EPON_WAKE_UP_DATA_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EPON_WAKE_UP_DATA_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EPON_WAKE_UP_DATA_TABLE */


/* >>>US_TM_BBH_QUEUE_TABLE */

#define RDD_US_TM_BBH_QUEUE_TABLE_SIZE     40
typedef struct
{
	BBH_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_BBH_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_BBH_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_BBH_QUEUE_TABLE_PTR(core_id)	( US_TM_BBH_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_BBH_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_BBH_QUEUE_TABLE */


/* >>>US_TM_CPU_TX_ABS_COUNTERS */

#define RDD_US_TM_CPU_TX_ABS_COUNTERS_SIZE     32
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_CPU_TX_ABS_COUNTERS_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_CPU_TX_ABS_COUNTERS_STRUCT;

extern uint32_t RDD_US_TM_CPU_TX_ABS_COUNTERS_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_CPU_TX_ABS_COUNTERS_PTR(core_id)	( US_TM_CPU_TX_ABS_COUNTERS_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_CPU_TX_ABS_COUNTERS_ADDRESS_ARR[core_id] ))

/* <<<US_TM_CPU_TX_ABS_COUNTERS */


/* >>>US_TM_SCHEDULING_QUEUE_AGING_VECTOR */

#define RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE     5
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT;

extern uint32_t RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_PTR(core_id)	( US_TM_SCHEDULING_QUEUE_AGING_VECTOR_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_SCHEDULING_QUEUE_AGING_VECTOR_ADDRESS_ARR[core_id] ))

/* <<<US_TM_SCHEDULING_QUEUE_AGING_VECTOR */


/* >>>US_TM_FLUSH_CFG_CPU_TABLE */

#define RDD_US_TM_FLUSH_CFG_CPU_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_CPU_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_CPU_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_CPU_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_CPU_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_CPU_TABLE */


/* >>>US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE */

#define RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_PTR(core_id)	( US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_0_BBH_TX_EGRESS_COUNTER_TABLE */


/* >>>US_TM_FLUSH_CFG_ENABLE_TABLE */

#define RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENABLE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_ENABLE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_ENABLE_TABLE */


/* >>>DIRECT_FLOW_PAUSE_QUANTA */

/* >>>PAUSE_QUANTA_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	ignore    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	time_unit 	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	time_unit 	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ignore    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(2))) PAUSE_QUANTA_ENTRY_STRUCT;

#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 7, 1, (r))
#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 7, 1, (v))
#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PAUSE_QUANTA_ENTRY_IGNORE_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 0, 15, (r))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PAUSE_QUANTA_ENTRY_STRUCT), 0, 15, (v))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p), 0, 15, (r))
#define RDD_PAUSE_QUANTA_ENTRY_TIME_UNIT_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p), 0, 15, (v))
/* <<<PAUSE_QUANTA_ENTRY_STRUCT */


#define RDD_DIRECT_FLOW_PAUSE_QUANTA_SIZE     1
typedef struct
{
	PAUSE_QUANTA_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_PAUSE_QUANTA_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_PAUSE_QUANTA_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_PAUSE_QUANTA_PTR(core_id)	( DIRECT_FLOW_PAUSE_QUANTA_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_PAUSE_QUANTA_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_PAUSE_QUANTA */


/* >>>US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED */

#define RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_SIZE     1
typedef struct
{
	BYTES_4_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_STRUCT;

extern uint32_t RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_PTR(core_id)	( US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED_ADDRESS_ARR[core_id] ))

/* <<<US_TM_BBH_TX_WAN_0_FIFO_BYTES_USED */


/* >>>US_TM_FLUSH_CFG_FW_TABLE */

#define RDD_US_TM_FLUSH_CFG_FW_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_FW_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_FW_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_FW_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_FW_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_FW_TABLE */


/* >>>BASIC_RATE_LIMITER_TABLE_US */

#define RDD_BASIC_RATE_LIMITER_TABLE_US_SIZE     128
typedef struct
{
	BASIC_RATE_LIMITER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_RATE_LIMITER_TABLE_US_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_RATE_LIMITER_TABLE_US_STRUCT;

extern uint32_t RDD_BASIC_RATE_LIMITER_TABLE_US_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_RATE_LIMITER_TABLE_US_PTR(core_id)	( BASIC_RATE_LIMITER_TABLE_US_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_RATE_LIMITER_TABLE_US_ADDRESS_ARR[core_id] ))

/* <<<BASIC_RATE_LIMITER_TABLE_US */


/* >>>US_TM_CODEL_QUEUE_TABLE */

#define RDD_US_TM_CODEL_QUEUE_TABLE_SIZE     132
typedef struct
{
	CODEL_QUEUE_DESCRIPTOR_STRUCT	entry[ RDD_US_TM_CODEL_QUEUE_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_CODEL_QUEUE_TABLE_STRUCT;

extern uint32_t RDD_US_TM_CODEL_QUEUE_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_CODEL_QUEUE_TABLE_PTR(core_id)	( US_TM_CODEL_QUEUE_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_CODEL_QUEUE_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_CODEL_QUEUE_TABLE */


/* >>>BBH_TX_EPON_INGRESS_COUNTER_TABLE */

#define RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_SIZE     40
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EPON_INGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_PTR(core_id)	( BBH_TX_EPON_INGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EPON_INGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EPON_INGRESS_COUNTER_TABLE */


/* >>>US_TM_WAN_0_BB_DESTINATION_TABLE */

#define RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_WAN_0_BB_DESTINATION_TABLE_STRUCT;

extern uint32_t RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_PTR(core_id)	( US_TM_WAN_0_BB_DESTINATION_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_WAN_0_BB_DESTINATION_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_WAN_0_BB_DESTINATION_TABLE */


/* >>>QEMU_SYNC_MEM */

/* >>>QEMU_DATA_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	start_runner_trace        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	stop_runner_trace         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_capture_waves       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	stop_capture_waves        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_send_1_packet_once  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_send_infinise_packet	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	data_path_ready           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	reserved                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	data_path_ready           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_send_infinise_packet	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_send_1_packet_once  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	stop_capture_waves        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_capture_waves       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	stop_runner_trace         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	start_runner_trace        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} QEMU_DATA_STRUCT;

#define RDD_QEMU_DATA_START_RUNNER_TRACE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 7, 1, (r))
#define RDD_QEMU_DATA_START_RUNNER_TRACE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 7, 1, (v))
#define RDD_QEMU_DATA_START_RUNNER_TRACE_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_QEMU_DATA_START_RUNNER_TRACE_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_QEMU_DATA_STOP_RUNNER_TRACE_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 6, 1, (r))
#define RDD_QEMU_DATA_STOP_RUNNER_TRACE_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 6, 1, (v))
#define RDD_QEMU_DATA_STOP_RUNNER_TRACE_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_QEMU_DATA_STOP_RUNNER_TRACE_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_QEMU_DATA_START_CAPTURE_WAVES_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 5, 1, (r))
#define RDD_QEMU_DATA_START_CAPTURE_WAVES_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 5, 1, (v))
#define RDD_QEMU_DATA_START_CAPTURE_WAVES_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_QEMU_DATA_START_CAPTURE_WAVES_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_QEMU_DATA_STOP_CAPTURE_WAVES_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 4, 1, (r))
#define RDD_QEMU_DATA_STOP_CAPTURE_WAVES_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 4, 1, (v))
#define RDD_QEMU_DATA_STOP_CAPTURE_WAVES_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_QEMU_DATA_STOP_CAPTURE_WAVES_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_QEMU_DATA_START_SEND_1_PACKET_ONCE_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 3, 1, (r))
#define RDD_QEMU_DATA_START_SEND_1_PACKET_ONCE_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 3, 1, (v))
#define RDD_QEMU_DATA_START_SEND_1_PACKET_ONCE_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_QEMU_DATA_START_SEND_1_PACKET_ONCE_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_QEMU_DATA_START_SEND_INFINISE_PACKET_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 2, 1, (r))
#define RDD_QEMU_DATA_START_SEND_INFINISE_PACKET_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 2, 1, (v))
#define RDD_QEMU_DATA_START_SEND_INFINISE_PACKET_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_QEMU_DATA_START_SEND_INFINISE_PACKET_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_QEMU_DATA_DATA_PATH_READY_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 1, 1, (r))
#define RDD_QEMU_DATA_DATA_PATH_READY_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(QEMU_DATA_STRUCT), 1, 1, (v))
#define RDD_QEMU_DATA_DATA_PATH_READY_READ(r, p)                            FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_QEMU_DATA_DATA_PATH_READY_WRITE(v, p)                           FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
/* <<<QEMU_DATA_STRUCT */


#define RDD_QEMU_SYNC_MEM_SIZE     1
typedef struct
{
	QEMU_DATA_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ QEMU_SYNC_MEM_STRUCT;

extern uint32_t RDD_QEMU_SYNC_MEM_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_QEMU_SYNC_MEM_PTR(core_id)	( QEMU_SYNC_MEM_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_QEMU_SYNC_MEM_ADDRESS_ARR[core_id] ))

/* <<<QEMU_SYNC_MEM */


/* >>>DIRECT_FLOW_WAN_VIQ_EXCLUSIVE */

#define RDD_DIRECT_FLOW_WAN_VIQ_EXCLUSIVE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_WAN_VIQ_EXCLUSIVE_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_WAN_VIQ_EXCLUSIVE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_WAN_VIQ_EXCLUSIVE_PTR(core_id)	( DIRECT_FLOW_WAN_VIQ_EXCLUSIVE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_WAN_VIQ_EXCLUSIVE_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_WAN_VIQ_EXCLUSIVE */


/* >>>US_TM_TX_PAUSE_NACK */

#define RDD_US_TM_TX_PAUSE_NACK_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TX_PAUSE_NACK_STRUCT;

extern uint32_t RDD_US_TM_TX_PAUSE_NACK_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TX_PAUSE_NACK_PTR(core_id)	( US_TM_TX_PAUSE_NACK_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TX_PAUSE_NACK_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TX_PAUSE_NACK */


/* >>>BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD */

#define RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_SIZE     1
typedef struct
{
	BYTES_2_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_STRUCT;

extern uint32_t RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_PTR(core_id)	( BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_US_WAN_0_FIFO_BYTES_THRESHOLD */


/* >>>US_TM_FLUSH_CFG_CURRENT_TABLE */

#define RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_SIZE     1
typedef struct
{
	FLUSH_CFG_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_PTR(core_id)	( US_TM_FLUSH_CFG_CURRENT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_CFG_CURRENT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_CFG_CURRENT_TABLE */


/* >>>BBH_TX_EPON_EGRESS_COUNTER_TABLE */

#define RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_SIZE     32
typedef struct
{
	BYTE_1_STRUCT	entry[ RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BBH_TX_EPON_EGRESS_COUNTER_TABLE_STRUCT;

extern uint32_t RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_PTR(core_id)	( BBH_TX_EPON_EGRESS_COUNTER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BBH_TX_EPON_EGRESS_COUNTER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<BBH_TX_EPON_EGRESS_COUNTER_TABLE */


/* >>>DIRECT_FLOW_PD_TABLE */

/* >>>PROCESSING_RX_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pd_info           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	fragment_type               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	options                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	reserved0                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	ctrl_key_index              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	ctrl_fragment_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	sfc                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	reserved1                   	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	g9991_tci_sof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_eof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_const             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_sid_1_0           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint8_t	g9991_tci_sid_9_2           	; /* Member of pd_info union */
        uint16_t	g9991_length_time           	; /* Member of pd_info union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	timestamp                   	; /* Member of pd_info union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	serial_num        	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ploam             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_cong      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_or_dsl        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	error_type_or_cpu_tx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_serial_num      	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ploam           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_dsl union */
        uint32_t	reservedSU1_reserved        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	error_type                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reservedSU1_packet_length   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_serial_num      	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ploam           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	xdsl                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_dsl union */
        uint32_t	reservedSU2_reserved        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_tx                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reserved2                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reservedSU2_packet_length   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_serial_num      	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ploam           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs_or_dsl      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reserved        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_25_28                   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reservedSU3_packet_length   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	error             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_port      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	bn1_last_or_abs1  	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                        	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	bn1_last                    	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	abs1                        	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_port    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	ssid                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	bn1_last_truncated          	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_sop	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm                      	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm_pool                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm_num                  	:17	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                      	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint16_t	bn0_first                   	; /* Member of payload_offset_sop union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pd_info           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reserved0                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	options                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	fragment_type               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                   	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	sfc                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	ctrl_fragment_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	ctrl_key_index              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 3 */
		struct{
        uint16_t	g9991_length_time           	; /* Member of pd_info union */
        uint8_t	g9991_tci_sid_9_2           	; /* Member of pd_info union */
        uint32_t	g9991_tci_sid_1_0           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_const             	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_eof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
        uint32_t	g9991_tci_sof               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pd_info union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	timestamp                   	; /* Member of pd_info union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	error_type_or_cpu_tx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_or_dsl        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ingress_cong      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ploam             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	serial_num        	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_packet_length   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	error_type                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reservedSU1_reserved        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_dsl union */
        uint32_t	reservedSU1_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ploam           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_serial_num      	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_packet_length   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	cpu_tx                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reservedSU2_reserved        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	xdsl                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of abs_or_dsl union */
        uint32_t	reservedSU2_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ploam           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_serial_num      	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_packet_length   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_25_28                   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of error_type_or_cpu_tx union */
        uint32_t	reservedSU3_reserved        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs_or_dsl      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ingress_cong    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ploam           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_serial_num      	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_last_or_abs1  	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ingress_port      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cong_state        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	error             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_last                    	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	flow                        	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU1_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs1                        	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	source_port                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_port union */
        uint32_t	reservedSU2_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	bn1_last_truncated          	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	ssid                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	reserved4                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_last_or_abs1 union */
        uint32_t	reservedSU3_ingress_port    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_cong_state      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_error           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	payload_offset_sop	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn_fpm                      	:19	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	sop_fpm                     	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU1_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	bn_fpm_num                  	:17	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_fpm_pool                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reserved3                   	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU2_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	bn0_first                   	; /* Member of payload_offset_sop union */
        uint32_t	sop                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	bn_num                      	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_sop union */
        uint32_t	reservedSU3_target_mem_0    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) PROCESSING_RX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_READ_G(r, g, idx)                     GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_WRITE_G(v, g, idx)                    GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_READ(r, p)                            MREAD_32((uint8_t *)(p), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PD_INFO_WRITE(v, p)                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_READ(r, p)                          FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_KEY_INDEX_WRITE(v, p)                         FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FRAGMENT_TYPE_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 11, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 11, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_READ(r, p)                            FIELD_MREAD_32((uint8_t *)(p), 11, 18, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_OPTIONS_WRITE(v, p)                           FIELD_MWRITE_32((uint8_t *)(p), 11, 18, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_READ_G(r, g, idx)              GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_WRITE_G(v, g, idx)             GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_READ(r, p)                     FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_KEY_INDEX_WRITE(v, p)                    FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_READ_G(r, g, idx)          GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_READ(r, p)                 FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CTRL_FRAGMENT_TYPE_WRITE(v, p)                FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 3, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 3, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_READ(r, p)                                FIELD_MREAD_16((uint8_t *)(p), 3, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SFC_WRITE(v, p)                               FIELD_MWRITE_16((uint8_t *)(p), 3, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SOF_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_READ_G(r, g, idx)               GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_READ(r, p)                      FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_EOF_WRITE(v, p)                     FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_READ_G(r, g, idx)             GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 2, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_WRITE_G(v, g, idx)            GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 2, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_READ(r, p)                    FIELD_MREAD_8((uint8_t *)(p), 2, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_CONST_WRITE(v, p)                   FIELD_MWRITE_8((uint8_t *)(p), 2, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_READ_G(r, g, idx)           GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 0, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_WRITE_G(v, g, idx)          GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), 0, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_READ(r, p)                  FIELD_MREAD_8((uint8_t *)(p), 0, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_1_0_WRITE(v, p)                 FIELD_MWRITE_8((uint8_t *)(p), 0, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_READ_G(r, g, idx)           GROUP_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_WRITE_G(v, g, idx)          GROUP_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_READ(r, p)                  MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_TCI_SID_9_2_WRITE(v, p)                 MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_READ_G(r, g, idx)           GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_WRITE_G(v, g, idx)          GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_READ(r, p)                  MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_G9991_LENGTH_TIME_WRITE(v, p)                 MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_READ_G(r, g, idx)                   GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_WRITE_G(v, g, idx)                  GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_READ(r, p)                          MREAD_32((uint8_t *)(p), (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TIMESTAMP_WRITE(v, p)                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_READ(r, p)                         FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SERIAL_NUM_WRITE(v, p)                        FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PLOAM_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 4, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_CONG_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_DSL_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_DSL_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_DSL_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_OR_DSL_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_READ(r, p)                               FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_XDSL_WRITE(v, p)                              FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_READ_G(r, g, idx)        GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_WRITE_G(v, g, idx)       GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_READ(r, p)               FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_OR_CPU_TX_WRITE(v, p)              FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_READ(r, p)                         FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_TYPE_WRITE(v, p)                        FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 1, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 5, 1, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 5, 1, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CPU_TX_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 5, 1, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_25_28_READ_G(r, g, idx)                   GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_25_28_WRITE_G(v, g, idx)                  GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 4, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_25_28_READ(r, p)                          FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS_25_28_WRITE(v, p)                         FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)               GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)              GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                      FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                     FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_READ_G(r, g, idx)                       GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_WRITE_G(v, g, idx)                      GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_READ(r, p)                              FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ERROR_WRITE(v, p)                             FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 4, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_READ(r, p)                         FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_CONG_STATE_WRITE(v, p)                        FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_LAN_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_READ_G(r, g, idx)                GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_READ(r, p)                       FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_INGRESS_PORT_WRITE(v, p)                      FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_READ(r, p)                               FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_FLOW_WRITE(v, p)                              FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 3, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                        FIELD_MREAD_16((uint8_t *)(p) + 8, 3, 8, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                       FIELD_MWRITE_16((uint8_t *)(p) + 8, 3, 8, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_READ_G(r, g, idx)            GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_READ(r, p)                   FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_OR_ABS1_WRITE(v, p)                  FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_READ_G(r, g, idx)                    GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_WRITE_G(v, g, idx)                   GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_READ(r, p)                           FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_WRITE(v, p)                          FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_READ(r, p)                               FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_ABS1_WRITE(v, p)                              FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_READ_G(r, g, idx)                        GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                       GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_READ(r, p)                               FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SSID_WRITE(v, p)                              FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_READ_G(r, g, idx)          GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_READ(r, p)                 FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN1_LAST_TRUNCATED_WRITE(v, p)                FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_READ(r, p)                             FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_AGG_PD_WRITE(v, p)                            FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)               GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                       FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                      FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ_G(r, g, idx)          GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE_G(v, g, idx)         GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 30, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_READ(r, p)                 FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 30, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_PAYLOAD_OFFSET_SOP_WRITE(v, p)                FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 30, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                     GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 3, 11, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                    GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 3, 11, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_READ(r, p)                            FIELD_MREAD_16((uint8_t *)(p) + 12, 3, 11, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                           FIELD_MWRITE_16((uint8_t *)(p) + 12, 3, 11, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_READ(r, p)                             FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 19, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_WRITE(v, p)                            FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 19, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)                 GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 13, 1, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)                GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 13, 1, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                        FIELD_MREAD_8((uint8_t *)(p) + 13, 1, 2, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                       FIELD_MWRITE_8((uint8_t *)(p) + 13, 1, 2, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)                  GROUP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 17, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)                 GROUP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 0, 17, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                         FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 17, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                        FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 17, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                      GROUP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                     GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 12, 7, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_READ(r, p)                             FIELD_MREAD_16((uint8_t *)(p) + 12, 7, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN_NUM_WRITE(v, p)                            FIELD_MWRITE_16((uint8_t *)(p) + 12, 7, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_READ_G(r, g, idx)                         GROUP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                        GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 13, 0, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_READ(r, p)                                FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 7, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_SOP_WRITE(v, p)                               FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 7, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                   GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                  GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_RX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_READ(r, p)                          MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_RX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                         MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<PROCESSING_RX_DESCRIPTOR_STRUCT */


#define RDD_DIRECT_FLOW_PD_TABLE_SIZE     1
typedef struct
{
	PROCESSING_RX_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_PD_TABLE_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_PD_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_PD_TABLE_PTR(core_id)	( DIRECT_FLOW_PD_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_PD_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_PD_TABLE */


/* >>>OVERALL_RATE_LIMITER_TABLE */

/* >>>OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT */
typedef union
{
    uint32_t word_32[4];
    uint64_t dword_64[2];
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bbh_queue_en_vec	;
        uint32_t	current_budget  	;
        uint32_t	alloc_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1       	;
#else
        uint32_t	bbh_queue_en_vec	;
        uint32_t	current_budget  	;
        uint32_t	limit_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	limit_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_exponent  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	alloc_mantissa  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} __attribute__((aligned(8))) OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT;

#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_READ_G(r, g, idx)          GROUP_MREAD_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT), (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_WRITE_G(v, g, idx)         GROUP_MWRITE_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT), (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_READ(r, p)                 MREAD_32((uint8_t *)(p), (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_BBH_QUEUE_EN_VEC_WRITE(v, p)                MWRITE_32((uint8_t *)(p), (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ_G(r, g, idx)            GROUP_MREAD_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE_G(v, g, idx)           GROUP_MWRITE_32((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_READ(r, p)                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_CURRENT_BUDGET_WRITE(v, p)                  MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 8, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_MANTISSA_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_ALLOC_EXPONENT_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ_G(r, g, idx)            GROUP_FIELD_MREAD_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_16((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 10, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_READ(r, p)                   FIELD_MREAD_16((uint8_t *)(p) + 10, 2, 14, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_MANTISSA_WRITE(v, p)                  FIELD_MWRITE_16((uint8_t *)(p) + 10, 2, 14, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ_G(r, g, idx)            GROUP_FIELD_MREAD_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE_G(v, g, idx)           GROUP_FIELD_MWRITE_8((g), (idx)*sizeof(OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT) + 11, 0, 2, (v))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_READ(r, p)                   FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 2, (r))
#define RDD_OVERALL_RATE_LIMITER_DESCRIPTOR_LIMIT_EXPONENT_WRITE(v, p)                  FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 2, (v))
/* <<<OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT */


#define RDD_OVERALL_RATE_LIMITER_TABLE_SIZE     1
typedef struct
{
	OVERALL_RATE_LIMITER_DESCRIPTOR_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ OVERALL_RATE_LIMITER_TABLE_STRUCT;

extern uint32_t RDD_OVERALL_RATE_LIMITER_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_OVERALL_RATE_LIMITER_TABLE_PTR(core_id)	( OVERALL_RATE_LIMITER_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_OVERALL_RATE_LIMITER_TABLE_ADDRESS_ARR[core_id] ))

/* <<<OVERALL_RATE_LIMITER_TABLE */


/* >>>RATE_LIMITER_VALID_TABLE_US */

#define RDD_RATE_LIMITER_VALID_TABLE_US_SIZE     4
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_RATE_LIMITER_VALID_TABLE_US_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ RATE_LIMITER_VALID_TABLE_US_STRUCT;

extern uint32_t RDD_RATE_LIMITER_VALID_TABLE_US_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_RATE_LIMITER_VALID_TABLE_US_PTR(core_id)	( RATE_LIMITER_VALID_TABLE_US_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_RATE_LIMITER_VALID_TABLE_US_ADDRESS_ARR[core_id] ))

/* <<<RATE_LIMITER_VALID_TABLE_US */


/* >>>US_TM_FLUSH_DISPATCHER_CREDIT_TABLE */

#define RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FLUSH_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FLUSH_DISPATCHER_CREDIT_TABLE */


/* >>>EPON_UPDATE_FIFO_TABLE */

#define RDD_EPON_UPDATE_FIFO_TABLE_SIZE     8
typedef struct
{
	UPDATE_FIFO_ENTRY_STRUCT	entry[ RDD_EPON_UPDATE_FIFO_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ EPON_UPDATE_FIFO_TABLE_STRUCT;

extern uint32_t RDD_EPON_UPDATE_FIFO_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_EPON_UPDATE_FIFO_TABLE_PTR(core_id)	( EPON_UPDATE_FIFO_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_EPON_UPDATE_FIFO_TABLE_ADDRESS_ARR[core_id] ))

/* <<<EPON_UPDATE_FIFO_TABLE */


/* >>>US_TM_TX_OCTETS_COUNTERS_TABLE */

#define RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_SIZE     8
typedef struct
{
	PACKETS_AND_BYTES_STRUCT	entry[ RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_TX_OCTETS_COUNTERS_TABLE_STRUCT;

extern uint32_t RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_PTR(core_id)	( US_TM_TX_OCTETS_COUNTERS_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_TX_OCTETS_COUNTERS_TABLE_ADDRESS_ARR[core_id] ))

/* <<<US_TM_TX_OCTETS_COUNTERS_TABLE */


/* >>>DISPATCHER_CREDIT_TABLE */

#define RDD_DISPATCHER_CREDIT_TABLE_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DISPATCHER_CREDIT_TABLE_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DISPATCHER_CREDIT_TABLE_STRUCT;

extern uint32_t RDD_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DISPATCHER_CREDIT_TABLE_PTR(core_id)	( DISPATCHER_CREDIT_TABLE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DISPATCHER_CREDIT_TABLE_ADDRESS_ARR[core_id] ))

/* <<<DISPATCHER_CREDIT_TABLE */


/* >>>DIRECT_FLOW_PAUSE_DEBUG */

#define RDD_DIRECT_FLOW_PAUSE_DEBUG_SIZE     3
typedef struct
{
	BYTES_4_STRUCT	entry[ RDD_DIRECT_FLOW_PAUSE_DEBUG_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ DIRECT_FLOW_PAUSE_DEBUG_STRUCT;

extern uint32_t RDD_DIRECT_FLOW_PAUSE_DEBUG_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_DIRECT_FLOW_PAUSE_DEBUG_PTR(core_id)	( DIRECT_FLOW_PAUSE_DEBUG_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_DIRECT_FLOW_PAUSE_DEBUG_ADDRESS_ARR[core_id] ))

/* <<<DIRECT_FLOW_PAUSE_DEBUG */


/* >>>MAC_TYPE */

/* >>>MAC_TYPE_ENTRY_STRUCT */
typedef union
{
    struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	type      	;
#else
        uint8_t	type      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
} MAC_TYPE_ENTRY_STRUCT;

#define RDD_MAC_TYPE_ENTRY_TYPE_READ_G(r, g, idx)          GROUP_MREAD_8((g), (idx)*sizeof(MAC_TYPE_ENTRY_STRUCT), (r))
#define RDD_MAC_TYPE_ENTRY_TYPE_WRITE_G(v, g, idx)         GROUP_MWRITE_8((g), (idx)*sizeof(MAC_TYPE_ENTRY_STRUCT), (v))
#define RDD_MAC_TYPE_ENTRY_TYPE_READ(r, p)                 MREAD_8((uint8_t *)(p), (r))
#define RDD_MAC_TYPE_ENTRY_TYPE_WRITE(v, p)                MWRITE_8((uint8_t *)(p), (v))
/* <<<MAC_TYPE_ENTRY_STRUCT */


#define RDD_MAC_TYPE_SIZE     1
typedef struct
{
	MAC_TYPE_ENTRY_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ MAC_TYPE_STRUCT;

extern uint32_t RDD_MAC_TYPE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_MAC_TYPE_PTR(core_id)	( MAC_TYPE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_MAC_TYPE_ADDRESS_ARR[core_id] ))

/* <<<MAC_TYPE */


/* >>>US_TM_FIRST_QUEUE_MAPPING */

#define RDD_US_TM_FIRST_QUEUE_MAPPING_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ US_TM_FIRST_QUEUE_MAPPING_STRUCT;

extern uint32_t RDD_US_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_US_TM_FIRST_QUEUE_MAPPING_PTR(core_id)	( US_TM_FIRST_QUEUE_MAPPING_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_US_TM_FIRST_QUEUE_MAPPING_ADDRESS_ARR[core_id] ))

/* <<<US_TM_FIRST_QUEUE_MAPPING */


/* >>>WAN_0_BBH_TX_FIFO_SIZE */

#define RDD_WAN_0_BBH_TX_FIFO_SIZE_SIZE     1
typedef struct
{
	BYTE_1_STRUCT	entry;
}
__PACKING_ATTRIBUTE_STRUCT_END__ WAN_0_BBH_TX_FIFO_SIZE_STRUCT;

extern uint32_t RDD_WAN_0_BBH_TX_FIFO_SIZE_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_WAN_0_BBH_TX_FIFO_SIZE_PTR(core_id)	( WAN_0_BBH_TX_FIFO_SIZE_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_WAN_0_BBH_TX_FIFO_SIZE_ADDRESS_ARR[core_id] ))

/* <<<WAN_0_BBH_TX_FIFO_SIZE */


/* >>>BASIC_SCHEDULER_TABLE_US */

#define RDD_BASIC_SCHEDULER_TABLE_US_SIZE     33
typedef struct
{
	BASIC_SCHEDULER_DESCRIPTOR_STRUCT	entry[ RDD_BASIC_SCHEDULER_TABLE_US_SIZE ];
}
__PACKING_ATTRIBUTE_STRUCT_END__ BASIC_SCHEDULER_TABLE_US_STRUCT;

extern uint32_t RDD_BASIC_SCHEDULER_TABLE_US_ADDRESS_ARR[GROUPED_EN_SEGMENTS_NUM];

#define RDD_BASIC_SCHEDULER_TABLE_US_PTR(core_id)	( BASIC_SCHEDULER_TABLE_US_STRUCT * )(DEVICE_ADDRESS( rdp_runner_core_addr[core_id] + RDD_BASIC_SCHEDULER_TABLE_US_ADDRESS_ARR[core_id] ))

/* <<<BASIC_SCHEDULER_TABLE_US */


#ifdef BCM6855

/* >>>RDD_DISP_REOR_VIQ */
typedef enum
{
	DISP_REOR_VIQ_FIRST                  = 0,
	DISP_REOR_VIQ_BBH_RX0_NORMAL         = 0,
	DISP_REOR_VIQ_BBH_RX1_NORMAL         = 1,
	DISP_REOR_VIQ_BBH_RX2_NORMAL         = 2,
	DISP_REOR_VIQ_BBH_RX3_NORMAL         = 3,
	DISP_REOR_VIQ_BBH_RX4_NORMAL         = 4,
	DISP_REOR_VIQ_BBH_RX5_NORMAL         = 5,
	DISP_REOR_VIQ_BBH_RX6_NORMAL         = 6,
	DISP_REOR_VIQ_BBH_RX6_EXCL           = 7,
	DISP_REOR_VIQ_EPON_TM                = 8,
	DISP_REOR_VIQ_CPU_TX_EGRESS          = 9,
	DISP_REOR_VIQ_CPU_TX_FORWARD         = 10,
	DISP_REOR_VIQ_TX_MIRRORING           = 11,
	DISP_REOR_VIQ_CPU_RX_COPY            = 12,
	DISP_REOR_VIQ_WAN_LOOPBACK           = 13,
	DISP_REOR_VIQ_DHD_RX_COMPLETE_0      = 14,
	DISP_REOR_VIQ_DHD_RX_COMPLETE_1      = 15,
	DISP_REOR_VIQ_DHD_RX_COMPLETE_2      = 16,
	DISP_REOR_VIQ_SPDSVC_ANALYZER        = 17,
	DISP_REOR_VIQ_DHD_MIRRORING          = 18,
	DISP_REOR_VIQ_TCPSPDTEST_GEN         = 19,
	DISP_REOR_VIQ_DHD_TX_COMPLETE_0      = 20,
	DISP_REOR_VIQ_DHD_TX_COMPLETE_1      = 21,
	DISP_REOR_VIQ_DHD_TX_COMPLETE_2      = 22,
	DISP_REOR_VIQ_SERVICE_QUEUES         = 23,
	DISP_REOR_VIQ_TX_MIRRORING_DS        = 24,
	DISP_REOR_VIQ_COMMON_REPROCESSING    = 25,
	DISP_REOR_VIQ_TCPSPDTEST             = 26,
	DISP_REOR_VIQ_SPDSVC_GEN             = 27,
	DISP_REOR_VIQ_LAST                   = 27
} rdd_disp_reor_viq;
/* <<<RDD_DISP_REOR_VIQ */


/* >>>RDD_GENERAL_COUNTER */
typedef enum
{
	GENERAL_COUNTER_FIRST                          = 0,
	GENERAL_COUNTER_DHD_TX_POST_PKTS_0             = 0,
	GENERAL_COUNTER_DHD_TX_POST_PKTS_1             = 1,
	GENERAL_COUNTER_DHD_TX_POST_PKTS_2             = 2,
	GENERAL_COUNTER_DHD_TX_COMPLETE_PKTS_0         = 3,
	GENERAL_COUNTER_DHD_TX_COMPLETE_PKTS_1         = 4,
	GENERAL_COUNTER_DHD_TX_COMPLETE_PKTS_2         = 5,
	GENERAL_COUNTER_DHD_RX_COMPLETE_PKTS_0         = 6,
	GENERAL_COUNTER_DHD_RX_COMPLETE_PKTS_1         = 7,
	GENERAL_COUNTER_DHD_RX_COMPLETE_PKTS_2         = 8,
	GENERAL_COUNTER_DHD_TX_DROP_PKTS_0             = 9,
	GENERAL_COUNTER_DHD_TX_DROP_PKTS_1             = 10,
	GENERAL_COUNTER_DHD_TX_DROP_PKTS_2             = 11,
	GENERAL_COUNTER_RX_IPTV_VALID_PKT              = 12,
	GENERAL_COUNTER_RX_IPTV_VALID_BYTES            = 13,
	GENERAL_COUNTER_IPTV_TOTAL_DROP_PKT            = 14,
	GENERAL_COUNTER_IPTV_TOTAL_DROP_BYTES          = 15,
	GENERAL_COUNTER_RX_64_OCTETS_PKTS              = 16,
	GENERAL_COUNTER_RX_65_TO_127_OCTETS_PKTS       = 17,
	GENERAL_COUNTER_RX_128_TO_255_OCTETS_PKTS      = 18,
	GENERAL_COUNTER_RX_256_TO_511_OCTETS_PKTS      = 19,
	GENERAL_COUNTER_RX_512_TO_1023_OCTETS_PKTS     = 20,
	GENERAL_COUNTER_RX_1024_TO_1522_OCTETS_PKTS    = 21,
	GENERAL_COUNTER_RX_1523_TO_MTU_OCTETS_PKTS     = 22,
	GENERAL_COUNTER_DHD_SPDSVC_TX_DROPS_0          = 23,
	GENERAL_COUNTER_DHD_SPDSVC_TX_DROPS_1          = 24,
	GENERAL_COUNTER_DHD_SPDSVC_TX_DROPS_2          = 25,
	GENERAL_COUNTER_LAST                           = 25
} rdd_general_counter;
/* <<<RDD_GENERAL_COUNTER */


/* >>>RDD_RDD_WAN_FLOW */
typedef enum
{
	RDD_WAN_FLOW_FIRST  = 255,
	RDD_WAN_FLOW_MAX    = 255,
	RDD_WAN_FLOW_NUM    = 256,
	RDD_WAN_FLOW_LAST   = 256
} rdd_rdd_wan_flow;
/* <<<RDD_RDD_WAN_FLOW */


/* >>>RDD_IMAGE_1_CPU_IF_1_TIMER_INDEX */
typedef enum
{
	IMAGE_1_CPU_IF_1_TIMER_INDEX_FIRST = 1,
	IMAGE_1_CPU_IF_1_TIMER_INDEX_SPDSVC = 1,
	IMAGE_1_CPU_IF_1_TIMER_INDEX_LAST = 1
} rdd_cpu_if_1_timer_index;
/* <<<RDD_IMAGE_1_CPU_IF_1_TIMER_INDEX */


/* >>>RDD_IMAGE_1_SPDSVC_TIMER_INDEX */
typedef enum
{
	IMAGE_1_SPDSVC_TIMER_INDEX_FIRST = 2,
	IMAGE_1_SPDSVC_TIMER_INDEX_GEN = 2,
	IMAGE_1_SPDSVC_TIMER_INDEX_LAST = 2
} rdd_spdsvc_timer_index;
/* <<<RDD_IMAGE_1_SPDSVC_TIMER_INDEX */


/* >>>RDD_IMAGE_2_SERVICE_QUEUES_TIMER_INDEX */
typedef enum
{
	IMAGE_2_SERVICE_QUEUES_TIMER_INDEX_FIRST                      = 1,
	IMAGE_2_SERVICE_QUEUES_TIMER_INDEX_SERVICE_QUEUES_BUDGET_ALLOCATOR = 1,
	IMAGE_2_SERVICE_QUEUES_TIMER_INDEX_LAST                       = 1
} rdd_service_queues_timer_index;
/* <<<RDD_IMAGE_2_SERVICE_QUEUES_TIMER_INDEX */


/* >>>RDD_IMAGE_3_DHD_TIMER_INDEX */
typedef enum
{
	IMAGE_3_DHD_TIMER_INDEX_FIRST = 1,
	IMAGE_3_DHD_TIMER_INDEX_DHD_AGGR = 1,
	IMAGE_3_DHD_TIMER_INDEX_LAST = 1
} rdd_dhd_timer_index;
/* <<<RDD_IMAGE_3_DHD_TIMER_INDEX */


/* >>>RDD_IMAGE_4_DS_TM_TIMER_INDEX */
typedef enum
{
	IMAGE_4_DS_TM_TIMER_INDEX_FIRST       = 1,
	IMAGE_4_DS_TM_TIMER_INDEX_FLUSH       = 1,
	IMAGE_4_DS_TM_TIMER_INDEX_BUDGET_ALLOCATOR = 2,
	IMAGE_4_DS_TM_TIMER_INDEX_REPORTING   = 3,
	IMAGE_4_DS_TM_TIMER_INDEX_BUFFER_CONG_MGT = 4,
	IMAGE_4_DS_TM_TIMER_INDEX_LAST        = 4
} rdd_ds_tm_timer_index;
/* <<<RDD_IMAGE_4_DS_TM_TIMER_INDEX */


/* >>>RDD_IMAGE_5_US_TM_TIMER_INDEX */
typedef enum
{
	IMAGE_5_US_TM_TIMER_INDEX_FIRST           = 1,
	IMAGE_5_US_TM_TIMER_INDEX_FLUSH           = 1,
	IMAGE_5_US_TM_TIMER_INDEX_OVL_BUDGET_ALLOCATOR = 2,
	IMAGE_5_US_TM_TIMER_INDEX_BUDGET_ALLOCATOR = 3,
	IMAGE_5_US_TM_TIMER_INDEX_PAUSE_FRAME     = 4,
	IMAGE_5_US_TM_TIMER_INDEX_BUFFER_CONG_MGT = 5,
	IMAGE_5_US_TM_TIMER_INDEX_LAST            = 5
} rdd_us_tm_timer_index;
/* <<<RDD_IMAGE_5_US_TM_TIMER_INDEX */


/* >>>RDD_QM_QUEUE */
typedef enum
{
	QM_QUEUE_FIRST                         = 8,
	QM_QUEUE_DYNAMIC_EPON                  = 8,
	QM_QUEUE_SERVICE_Q_DEFAULT_QUANTITY    = 16,
	QM_QUEUE_SERVICE_Q_MAX_QUANTITY        = 32,
	QM_QUEUE_DS_DEFAULT_QUANTITY           = 48,
	QM_QUEUE_US_DEFAULT_QUANTITY           = 64,
	QM_QUEUE_TX_ABS_RECYCLE                = 145,
	QM_QUEUE_MAX_DYNAMIC_QUANTITY          = 145,
	QM_QUEUE_PKTGEN_REPROCESSING           = 146,
	QM_QUEUE_CPU_RX                        = 147,
	QM_QUEUE_CPU_RX_COPY_NORMAL            = 148,
	QM_QUEUE_CPU_RX_COPY_EXCLUSIVE         = 149,
	QM_QUEUE_DHD_CPU_TX_POST_0             = 150,
	QM_QUEUE_DHD_TX_POST_0                 = 151,
	QM_QUEUE_DHD_CPU_TX_POST_1             = 152,
	QM_QUEUE_DHD_TX_POST_1                 = 153,
	QM_QUEUE_DHD_CPU_TX_POST_2             = 154,
	QM_QUEUE_DHD_TX_POST_2                 = 155,
	QM_QUEUE_SPDSVC_ANALYZER               = 156,
	QM_QUEUE_TCPSPDTEST                    = 157,
	QM_QUEUE_LAST                          = 157
} rdd_qm_queue;
/* <<<RDD_QM_QUEUE */


/* >>>RDD_IMAGE_0_IMAGE_0 */
typedef enum
{
	IMAGE_0_IMAGE_0_FIRST                      = 0,
	IMAGE_0_IMAGE_0_DHD_TX_COMPLETE_0_THREAD_NUMBER = 0,
	IMAGE_0_IMAGE_0_DHD_TX_COMPLETE_1_THREAD_NUMBER = 1,
	IMAGE_0_IMAGE_0_DHD_TX_COMPLETE_2_THREAD_NUMBER = 2,
	IMAGE_0_IMAGE_0_DHD_RX_COMPLETE_0_THREAD_NUMBER = 3,
	IMAGE_0_IMAGE_0_DHD_RX_COMPLETE_1_THREAD_NUMBER = 4,
	IMAGE_0_IMAGE_0_DHD_RX_COMPLETE_2_THREAD_NUMBER = 5,
	IMAGE_0_IMAGE_0_SPDSVC_ANALYZER_THREAD_NUMBER = 6,
	IMAGE_0_IMAGE_0_PROCESSING0_THREAD_NUMBER  = 8,
	IMAGE_0_IMAGE_0_PROCESSING1_THREAD_NUMBER  = 9,
	IMAGE_0_IMAGE_0_PROCESSING2_THREAD_NUMBER  = 10,
	IMAGE_0_IMAGE_0_PROCESSING3_THREAD_NUMBER  = 11,
	IMAGE_0_IMAGE_0_PROCESSING4_THREAD_NUMBER  = 12,
	IMAGE_0_IMAGE_0_PROCESSING5_THREAD_NUMBER  = 13,
	IMAGE_0_IMAGE_0_PROCESSING6_THREAD_NUMBER  = 14,
	IMAGE_0_IMAGE_0_PROCESSING7_THREAD_NUMBER  = 15,
	IMAGE_0_IMAGE_0_LAST                       = 15
} rdd_image_0;
/* <<<RDD_IMAGE_0_IMAGE_0 */


/* >>>RDD_IMAGE_1_IMAGE_1 */
typedef enum
{
	IMAGE_1_IMAGE_1_FIRST                        = 0,
	IMAGE_1_IMAGE_1_GENERAL_TIMER_THREAD_NUMBER  = 0,
	IMAGE_1_IMAGE_1_COMMON_REPROCESSING_THREAD_NUMBER = 1,
	IMAGE_1_IMAGE_1_CPU_RX_THREAD_NUMBER         = 2,
	IMAGE_1_IMAGE_1_CPU_RECYCLE_THREAD_NUMBER    = 3,
	IMAGE_1_IMAGE_1_CPU_RX_COPY_THREAD_NUMBER    = 4,
	IMAGE_1_IMAGE_1_SPDSVC_GEN_THREAD_NUMBER     = 5,
	IMAGE_1_IMAGE_1_TCPSPDTEST_THREAD_NUMBER     = 6,
	IMAGE_1_IMAGE_1_TCPSPDTEST_GEN_THREAD_NUMBER = 7,
	IMAGE_1_IMAGE_1_PROCESSING0_THREAD_NUMBER    = 8,
	IMAGE_1_IMAGE_1_PROCESSING1_THREAD_NUMBER    = 9,
	IMAGE_1_IMAGE_1_PROCESSING2_THREAD_NUMBER    = 10,
	IMAGE_1_IMAGE_1_PROCESSING3_THREAD_NUMBER    = 11,
	IMAGE_1_IMAGE_1_PROCESSING4_THREAD_NUMBER    = 12,
	IMAGE_1_IMAGE_1_PROCESSING5_THREAD_NUMBER    = 13,
	IMAGE_1_IMAGE_1_PROCESSING6_THREAD_NUMBER    = 14,
	IMAGE_1_IMAGE_1_PROCESSING7_THREAD_NUMBER    = 15,
	IMAGE_1_IMAGE_1_LAST                         = 15
} rdd_image_1;
/* <<<RDD_IMAGE_1_IMAGE_1 */


/* >>>RDD_IMAGE_2_IMAGE_2 */
typedef enum
{
	IMAGE_2_IMAGE_2_FIRST                                     = 0,
	IMAGE_2_IMAGE_2_GENERAL_TIMER_THREAD_NUMBER               = 0,
	IMAGE_2_IMAGE_2_CPU_RECYCLE_THREAD_NUMBER                 = 2,
	IMAGE_2_IMAGE_2_CPU_TX_0_THREAD_NUMBER                    = 3,
	IMAGE_2_IMAGE_2_CPU_TX_1_THREAD_NUMBER                    = 4,
	IMAGE_2_IMAGE_2_SERVICE_QUEUES_UPDATE_FIFO_THREAD_NUMBER  = 5,
	IMAGE_2_IMAGE_2_SERVICE_QUEUES_TX_THREAD_NUMBER           = 6,
	IMAGE_2_IMAGE_2_BUDGET_ALLOCATION_SERVICE_QUEUES_THREAD_NUMBER = 7,
	IMAGE_2_IMAGE_2_PROCESSING0_THREAD_NUMBER                 = 8,
	IMAGE_2_IMAGE_2_PROCESSING1_THREAD_NUMBER                 = 9,
	IMAGE_2_IMAGE_2_PROCESSING2_THREAD_NUMBER                 = 10,
	IMAGE_2_IMAGE_2_PROCESSING3_THREAD_NUMBER                 = 11,
	IMAGE_2_IMAGE_2_PROCESSING4_THREAD_NUMBER                 = 12,
	IMAGE_2_IMAGE_2_PROCESSING5_THREAD_NUMBER                 = 13,
	IMAGE_2_IMAGE_2_PROCESSING6_THREAD_NUMBER                 = 14,
	IMAGE_2_IMAGE_2_PROCESSING7_THREAD_NUMBER                 = 15,
	IMAGE_2_IMAGE_2_LAST                                      = 15
} rdd_image_2;
/* <<<RDD_IMAGE_2_IMAGE_2 */


/* >>>RDD_IMAGE_3_IMAGE_3 */
typedef enum
{
	IMAGE_3_IMAGE_3_FIRST                            = 0,
	IMAGE_3_IMAGE_3_DHD_TIMER_THREAD_NUMBER          = 0,
	IMAGE_3_IMAGE_3_DHD_TX_POST_UPDATE_FIFO_THREAD_NUMBER = 1,
	IMAGE_3_IMAGE_3_DHD_TX_POST_0_THREAD_NUMBER      = 2,
	IMAGE_3_IMAGE_3_DHD_TX_POST_1_THREAD_NUMBER      = 3,
	IMAGE_3_IMAGE_3_DHD_TX_POST_2_THREAD_NUMBER      = 4,
	IMAGE_3_IMAGE_3_PROCESSING0_THREAD_NUMBER        = 8,
	IMAGE_3_IMAGE_3_PROCESSING1_THREAD_NUMBER        = 9,
	IMAGE_3_IMAGE_3_PROCESSING2_THREAD_NUMBER        = 10,
	IMAGE_3_IMAGE_3_PROCESSING3_THREAD_NUMBER        = 11,
	IMAGE_3_IMAGE_3_PROCESSING4_THREAD_NUMBER        = 12,
	IMAGE_3_IMAGE_3_PROCESSING5_THREAD_NUMBER        = 13,
	IMAGE_3_IMAGE_3_PROCESSING6_THREAD_NUMBER        = 14,
	IMAGE_3_IMAGE_3_PROCESSING7_THREAD_NUMBER        = 15,
	IMAGE_3_IMAGE_3_LAST                             = 15
} rdd_image_3;
/* <<<RDD_IMAGE_3_IMAGE_3 */


/* >>>RDD_IMAGE_4_DS_TM */
typedef enum
{
	IMAGE_4_DS_TM_FIRST                      = 0,
	IMAGE_4_DS_TM_BUDGET_ALLOCATION_THREAD_NUMBER = 0,
	IMAGE_4_DS_TM_BUFFER_CONG_MGT_THREAD_NUMBER = 1,
	IMAGE_4_DS_TM_UPDATE_FIFO_THREAD_NUMBER  = 2,
	IMAGE_4_DS_TM_TX_TASK_THREAD_NUMBER      = 3,
	IMAGE_4_DS_TM_REPORTING_THREAD_NUMBER    = 4,
	IMAGE_4_DS_TM_PROCESSING0_THREAD_NUMBER  = 8,
	IMAGE_4_DS_TM_PROCESSING1_THREAD_NUMBER  = 9,
	IMAGE_4_DS_TM_PROCESSING2_THREAD_NUMBER  = 10,
	IMAGE_4_DS_TM_PROCESSING3_THREAD_NUMBER  = 11,
	IMAGE_4_DS_TM_LAST                       = 11
} rdd_ds_tm;
/* <<<RDD_IMAGE_4_DS_TM */


/* >>>RDD_IMAGE_5_US_TM */
typedef enum
{
	IMAGE_5_US_TM_FIRST                          = 0,
	IMAGE_5_US_TM_DIRECT_FLOW_THREAD_NUMBER      = 0,
	IMAGE_5_US_TM_BUDGET_ALLOCATION_THREAD_NUMBER = 1,
	IMAGE_5_US_TM_OVL_BUDGET_ALLOCATION_THREAD_NUMBER = 2,
	IMAGE_5_US_TM_BUFFER_CONG_MGT_THREAD_NUMBER  = 3,
	IMAGE_5_US_TM_UPDATE_FIFO_EPON_THREAD_NUMBER = 4,
	IMAGE_5_US_TM_WAN_EPON_THREAD_NUMBER         = 5,
	IMAGE_5_US_TM_UPDATE_FIFO_THREAD_NUMBER      = 6,
	IMAGE_5_US_TM_WAN_THREAD_NUMBER              = 7,
	IMAGE_5_US_TM_LAST                           = 7
} rdd_us_tm;
/* <<<RDD_IMAGE_5_US_TM */


/* >>>RDD_PROJ_DEFS */
typedef enum
{
	PROJ_DEFS_FIRST                                = 4,
	PROJ_DEFS_NUMBER_OF_NATC_TABLES                = 4,
	PROJ_DEFS_NUMBER_OF_SPDTEST_STREAMS            = 4,
	PROJ_DEFS_NUMBER_OF_EMACS                      = 6,
	PROJ_DEFS_FIRST_PROCESSING_THREAD_ID           = 8,
	PROJ_DEFS_RDD_VPORT_LAST                       = 16,
	PROJ_DEFS_NUMBER_OF_VPORTS                     = 16,
	PROJ_DEFS_NUMBER_OF_CPU_RX_METERS              = 16,
	PROJ_DEFS_DBG_DUMP_TABLE_SIZE                  = 16,
	PROJ_DEFS_NUMBER_OF_VPORTS_MULT_3              = 48,
	PROJ_DEFS_NUMBER_OF_VLANS                      = 128,
	PROJ_DEFS_NUMBER_OF_VLANS_PLUS_1               = 129,
	PROJ_DEFS_NUMBER_OF_SHARED_IC_VLAN_COUNTERS    = 512,
	PROJ_DEFS_NUMBER_OF_IC_COUNTERS                = 512,
	PROJ_DEFS_HASH_NUM_OF_ENTRIES_IN_RAM           = 2048,
	PROJ_DEFS_LAST                                 = 2048
} rdd_proj_defs;
/* <<<RDD_PROJ_DEFS */


/* >>>RDD_RNR */
typedef enum
{
	RNR_FIRST       = 0,
	RNR_CORE0_ID    = 0,
	RNR_CORE1_ID    = 1,
	RNR_CORE2_ID    = 2,
	RNR_CORE3_ID    = 3,
	RNR_CORE4_ID    = 4,
	RNR_CORE5_ID    = 5,
	RNR_LAST        = 5
} rdd_rnr;
/* <<<RDD_RNR */


/* >>>RDD_BB_ID */
typedef enum
{
	BB_ID_FIRST                 = 0,
	BB_ID_RNR0                  = 0,
	BB_ID_RNR1                  = 1,
	BB_ID_RNR2                  = 2,
	BB_ID_RNR3                  = 3,
	BB_ID_RNR4                  = 4,
	BB_ID_RNR5                  = 5,
	BB_ID_BBHLB                 = 16,
	BB_ID_CNPL_0                = 17,
	BB_ID_DISPATCHER_REORDER    = 18,
	BB_ID_SDMA_COPY             = 20,
	BB_ID_QM_CP_SDMA            = 20,
	BB_ID_SDMA0                 = 21,
	BB_ID_SDMA1                 = 22,
	BB_ID_FPM                   = 23,
	BB_ID_HASH_0                = 24,
	BB_ID_NATC_0                = 25,
	BB_ID_QM_RNR_GRID           = 27,
	BB_ID_QM_BBHTX              = 28,
	BB_ID_QM_TOP                = 29,
	BB_ID_QM_CP_MACHINE         = 30,
	BB_ID_RX_BBH_0              = 31,
	BB_ID_TX_LAN                = 32,
	BB_ID_RX_BBH_1              = 33,
	BB_ID_TX_LAN_1              = 34,
	BB_ID_RX_BBH_2              = 35,
	BB_ID_TX_COPY               = 36,
	BB_ID_RX_BBH_3              = 37,
	BB_ID_RX_BBH_4              = 39,
	BB_ID_RX_BBH_5              = 41,
	BB_ID_RX_PON                = 53,
	BB_ID_TX_PON_ETH_PD         = 54,
	BB_ID_TX_PON_ETH_STAT       = 55,
	BB_ID_SBPM                  = 56,
	BB_ID_TCAM_0                = 57,
	BB_ID_TCAM_1                = 58,
	BB_ID_HASH_1                = 59,
	BB_ID_NATC_1                = 60,
	BB_ID_CNPL_1                = 61,
	BB_ID_LAST                  = 61
} rdd_bb_id;
/* <<<RDD_BB_ID */


/* >>>RDD_ACTION */
typedef enum
{
	ACTION_FIRST           = 0,
	ACTION_FORWARD         = 0,
	ACTION_TRAP            = 1,
	ACTION_DROP            = 2,
	ACTION_MULTICAST       = 3,
	ACTION_DROP_LOW_PRI    = 4,
	ACTION_LAST            = 4
} rdd_action;
/* <<<RDD_ACTION */


/* >>>RDD_ENET_HEADER */
typedef enum
{
	ENET_HEADER_FIRST                = 0,
	ENET_HEADER_DA_OFFSET            = 0,
	ENET_HEADER_SA_OFFSET            = 6,
	ENET_HEADER_ETHERTYPE_OFFSET     = 12,
	ENET_HEADER_CTRL_OPCDE_OFFSET    = 14,
	ENET_HEADER_SIZE                 = 16,
	ENET_HEADER_LAST                 = 16
} rdd_enet_header;
/* <<<RDD_ENET_HEADER */


/* >>>RDD_PFC_FRAME */
typedef enum
{
	PFC_FRAME_FIRST                         = 0,
	PFC_FRAME_CLASS_ENABLE_VECTOR_OFFSET    = 0,
	PFC_FRAME_TIME_0_OFFSET                 = 2,
	PFC_FRAME_SIZE                          = 18,
	PFC_FRAME_LAST                          = 18
} rdd_pfc_frame;
/* <<<RDD_PFC_FRAME */


/* >>>RDD_IP_PROTO */
typedef enum
{
	IP_PROTO_FIRST       = 1,
	IP_PROTO_ICMP        = 1,
	IP_PROTO_IPIP        = 4,
	IP_PROTO_TCP         = 6,
	IP_PROTO_UDP         = 17,
	IP_PROTO_IPV6        = 41,
	IP_PROTO_GRE         = 47,
	IP_PROTO_UDP_LITE    = 136,
	IP_PROTO_LAST        = 136
} rdd_ip_proto;
/* <<<RDD_IP_PROTO */


/* >>>RDD_IP_FLAGS */
typedef enum
{
	IP_FLAGS_FIRST                     = 1,
	IP_FLAGS_DO_NOT_FRAGMENT_OFFSET    = 1,
	IP_FLAGS_MORE_FRAGMENTS_OFFSET     = 2,
	IP_FLAGS_LAST                      = 2
} rdd_ip_flags;
/* <<<RDD_IP_FLAGS */


/* >>>RDD_LAYER3_IPV6_HEADER */
typedef enum
{
	LAYER3_IPV6_HEADER_FIRST            = 8,
	LAYER3_IPV6_HEADER_SRC_IP_OFFSET    = 8,
	LAYER3_IPV6_HEADER_DST_IP_OFFSET    = 24,
	LAYER3_IPV6_HEADER_LAST             = 24
} rdd_layer3_ipv6_header;
/* <<<RDD_LAYER3_IPV6_HEADER */


/* >>>RDD_LAYER3_HEADER */
typedef enum
{
	LAYER3_HEADER_FIRST                    = 0,
	LAYER3_HEADER_TRAFIC_CLASS_OFFSET      = 0,
	LAYER3_HEADER_TOS_OFFSET               = 1,
	LAYER3_HEADER_TOTAL_LENGTH_OFFSET      = 2,
	LAYER3_HEADER_PAYLOAD_LENGTH_OFFSET    = 4,
	LAYER3_HEADER_FLAGS_OFFSET             = 6,
	LAYER3_HEADER_HOP_LIMIT_OFFSET         = 7,
	LAYER3_HEADER_TTL_OFFSET               = 8,
	LAYER3_HEADER_PROTOCOL_OFFSET          = 9,
	LAYER3_HEADER_IP_CHECKSUM_OFFSET       = 10,
	LAYER3_HEADER_SRC_IP_OFFSET            = 12,
	LAYER3_HEADER_DST_IP_OFFSET            = 16,
	LAYER3_HEADER_LAST                     = 16
} rdd_layer3_header;
/* <<<RDD_LAYER3_HEADER */


/* >>>RDD_LAYER3_PSEUDO_HEADER */
typedef enum
{
	LAYER3_PSEUDO_HEADER_FIRST                = 0,
	LAYER3_PSEUDO_HEADER_SRC_IP_OFFSET        = 0,
	LAYER3_PSEUDO_HEADER_DST_IP_OFFSET        = 4,
	LAYER3_PSEUDO_HEADER_PROTOCOL_OFFSET      = 8,
	LAYER3_PSEUDO_HEADER_LENGTH_OFFSET        = 10,
	LAYER3_PSEUDO_HEADER_HDR_LENGTH           = 12,
	LAYER3_PSEUDO_HEADER_PROTOCOL_F_WIDTH     = 16,
	LAYER3_PSEUDO_HEADER_PROTOCOL_F_OFFSET    = 16,
	LAYER3_PSEUDO_HEADER_LAST                 = 16
} rdd_layer3_pseudo_header;
/* <<<RDD_LAYER3_PSEUDO_HEADER */


/* >>>RDD_LAYER3_IPV6_PSEUDO_HEADER */
typedef enum
{
	LAYER3_IPV6_PSEUDO_HEADER_FIRST              = 0,
	LAYER3_IPV6_PSEUDO_HEADER_SRC_IP_OFFSET      = 0,
	LAYER3_IPV6_PSEUDO_HEADER_DST_IP_OFFSET      = 16,
	LAYER3_IPV6_PSEUDO_HEADER_LENGTH_OFFSET      = 32,
	LAYER3_IPV6_PSEUDO_HEADER_PROTOCOL_OFFSET    = 36,
	LAYER3_IPV6_PSEUDO_HEADER_HDR_LENGTH         = 40,
	LAYER3_IPV6_PSEUDO_HEADER_LAST               = 40
} rdd_layer3_ipv6_pseudo_header;
/* <<<RDD_LAYER3_IPV6_PSEUDO_HEADER */


/* >>>RDD_LAYER4_HEADER */
typedef enum
{
	LAYER4_HEADER_FIRST                                = 0,
	LAYER4_HEADER_SRC_PORT_OFFSET                      = 0,
	LAYER4_HEADER_ESP_SPI_OFFSET                       = 0,
	LAYER4_HEADER_DST_PORT_OFFSET                      = 2,
	LAYER4_HEADER_UDP_LITE_CHECKSUM_COVERAGE_OFFSET    = 4,
	LAYER4_HEADER_TCP_LENGTH_F_WIDTH                   = 4,
	LAYER4_HEADER_UDP_CHECKSUM_OFFSET                  = 6,
	LAYER4_HEADER_GRE_CALL_ID_OFFSET                   = 6,
	LAYER4_HEADER_UDP_HDR_LENGTH                       = 8,
	LAYER4_HEADER_TCP_LENGTH_OFFSET                    = 12,
	LAYER4_HEADER_TCP_FLAGS_OFFSET                     = 13,
	LAYER4_HEADER_TCP_CHECKSUM_OFFSET                  = 16,
	LAYER4_HEADER_TCP_HDR_MIN_LENGTH                   = 20,
	LAYER4_HEADER_TCP_LENGTH_F_OFFSET                  = 28,
	LAYER4_HEADER_LAST                                 = 28
} rdd_layer4_header;
/* <<<RDD_LAYER4_HEADER */


/* >>>RDD_PARSER_L2_PROTOCOL */
typedef enum
{
	PARSER_L2_PROTOCOL_FIRST             = 1,
	PARSER_L2_PROTOCOL_PPPOE_D           = 1,
	PARSER_L2_PROTOCOL_PPPOE_S           = 2,
	PARSER_L2_PROTOCOL_USER_DEFINED_0    = 8,
	PARSER_L2_PROTOCOL_USER_DEFINED_1    = 9,
	PARSER_L2_PROTOCOL_USER_DEFINED_2    = 10,
	PARSER_L2_PROTOCOL_USER_DEFINED_3    = 11,
	PARSER_L2_PROTOCOL_ARP               = 12,
	PARSER_L2_PROTOCOL__1588             = 13,
	PARSER_L2_PROTOCOL__802_1X           = 14,
	PARSER_L2_PROTOCOL_MASK              = 15,
	PARSER_L2_PROTOCOL__802_1AG_CFM      = 15,
	PARSER_L2_PROTOCOL_LAST              = 15
} rdd_parser_l2_protocol;
/* <<<RDD_PARSER_L2_PROTOCOL */


/* >>>RDD_PARSER_L3_PROTOCOL */
typedef enum
{
	PARSER_L3_PROTOCOL_FIRST    = 0,
	PARSER_L3_PROTOCOL_OTHER    = 0,
	PARSER_L3_PROTOCOL_IPV4     = 1,
	PARSER_L3_PROTOCOL_IPV6     = 2,
	PARSER_L3_PROTOCOL_MASK     = 3,
	PARSER_L3_PROTOCOL_LAST     = 3
} rdd_parser_l3_protocol;
/* <<<RDD_PARSER_L3_PROTOCOL */


/* >>>RDD_PARSER_L4_PROTOCOL */
typedef enum
{
	PARSER_L4_PROTOCOL_FIRST             = 0,
	PARSER_L4_PROTOCOL_OTHER             = 0,
	PARSER_L4_PROTOCOL_TCP               = 1,
	PARSER_L4_PROTOCOL_UDP               = 2,
	PARSER_L4_PROTOCOL_IGMP              = 3,
	PARSER_L4_PROTOCOL_ICMP              = 4,
	PARSER_L4_PROTOCOL_ICMPV6            = 5,
	PARSER_L4_PROTOCOL_ESP               = 6,
	PARSER_L4_PROTOCOL_GRE               = 7,
	PARSER_L4_PROTOCOL_USER_DEFINED_0    = 8,
	PARSER_L4_PROTOCOL_USER_DEFINED_1    = 9,
	PARSER_L4_PROTOCOL_USER_DEFINED_2    = 10,
	PARSER_L4_PROTOCOL_L2TPV3            = 11,
	PARSER_L4_PROTOCOL_USER_DEFINED_3    = 11,
	PARSER_L4_PROTOCOL_RESERVED          = 12,
	PARSER_L4_PROTOCOL_IPV4_OVER_IPV6    = 12,
	PARSER_L4_PROTOCOL_IPV6              = 13,
	PARSER_L4_PROTOCOL_AH                = 14,
	PARSER_L4_PROTOCOL_NOT_PARSED        = 15,
	PARSER_L4_PROTOCOL_MASK              = 15,
	PARSER_L4_PROTOCOL_LAST              = 15
} rdd_parser_l4_protocol;
/* <<<RDD_PARSER_L4_PROTOCOL */


/* >>>RDD_ACTION_ECN */
typedef enum
{
	ACTION_ECN_FIRST               = 0,
	ACTION_ECN_REMARKING_OFFSET    = 0,
	ACTION_ECN_REMARKING_WIDTH     = 2,
	ACTION_ECN_LAST                = 2
} rdd_action_ecn;
/* <<<RDD_ACTION_ECN */


/* >>>RDD_ACTION_DSCP */
typedef enum
{
	ACTION_DSCP_FIRST                             = 2,
	ACTION_DSCP_REMARKING_OFFSET                  = 2,
	ACTION_DSCP_REMARKING_TRAFFIC_CLASS_OFFSET    = 4,
	ACTION_DSCP_REMARKING_WIDTH                   = 6,
	ACTION_DSCP_REMARKING_TRAFFIC_CLASS_WIDTH     = 8,
	ACTION_DSCP_LAST                              = 8
} rdd_action_dscp;
/* <<<RDD_ACTION_DSCP */


/* >>>RDD_ACTION_OUTER */
typedef enum
{
	ACTION_OUTER_FIRST                         = 14,
	ACTION_OUTER_PBITS_REMARKING_VID_OFFSET    = 14,
	ACTION_OUTER_LAST                          = 14
} rdd_action_outer;
/* <<<RDD_ACTION_OUTER */


/* >>>RDD_ACTION_INNER */
typedef enum
{
	ACTION_INNER_FIRST                         = 18,
	ACTION_INNER_PBITS_REMARKING_VID_OFFSET    = 18,
	ACTION_INNER_LAST                          = 18
} rdd_action_inner;
/* <<<RDD_ACTION_INNER */


/* >>>RDD_ACTION_PBITS */
typedef enum
{
	ACTION_PBITS_FIRST                        = 2,
	ACTION_PBITS_REMARKING_DSCP_F_OFFSET      = 2,
	ACTION_PBITS_REMARKING_PACKET_F_WIDTH     = 3,
	ACTION_PBITS_REMARKING_DSCP_F_WIDTH       = 6,
	ACTION_PBITS_REMARKING_PACKET_F_OFFSET    = 13,
	ACTION_PBITS_LAST                         = 13
} rdd_action_pbits;
/* <<<RDD_ACTION_PBITS */


/* >>>RDD_ACTION_DS_LITE */
typedef enum
{
	ACTION_DS_LITE_FIRST   = 40,
	ACTION_DS_LITE_SIZE    = 40,
	ACTION_DS_LITE_LAST    = 40
} rdd_action_ds_lite;
/* <<<RDD_ACTION_DS_LITE */


/* >>>RDD_DS_ACTION_ID */
typedef enum
{
	DS_ACTION_ID_FIRST        = 0,
	DS_ACTION_ID_TRAP         = 0,
	DS_ACTION_ID_TTL          = 2,
	DS_ACTION_ID_DSCP         = 4,
	DS_ACTION_ID_NAT          = 5,
	DS_ACTION_ID_GRE          = 6,
	DS_ACTION_ID_OPBITS       = 7,
	DS_ACTION_ID_IPBITS       = 8,
	DS_ACTION_ID_DS_LITE      = 9,
	DS_ACTION_ID_PPPOE        = 10,
	DS_ACTION_ID_TOTAL_NUM    = 17,
	DS_ACTION_ID_LAST         = 17
} rdd_ds_action_id;
/* <<<RDD_DS_ACTION_ID */


/* >>>RDD_US_ACTION_ID */
typedef enum
{
	US_ACTION_ID_FIRST        = 0,
	US_ACTION_ID_TRAP         = 0,
	US_ACTION_ID_TTL          = 2,
	US_ACTION_ID_DSCP         = 4,
	US_ACTION_ID_NAT          = 5,
	US_ACTION_ID_GRE          = 6,
	US_ACTION_ID_OPBITS       = 7,
	US_ACTION_ID_IPBITS       = 8,
	US_ACTION_ID_DS_LITE      = 9,
	US_ACTION_ID_PPPOE        = 10,
	US_ACTION_ID_TOTAL_NUM    = 17,
	US_ACTION_ID_LAST         = 17
} rdd_us_action_id;
/* <<<RDD_US_ACTION_ID */


/* >>>RDD_RDD_VPORT */
typedef enum
{
	RDD_VPORT_FIRST    = 0,
	RDD_VPORT_ID_0     = 0,
	RDD_VPORT_ID_1     = 1,
	RDD_VPORT_ID_2     = 2,
	RDD_VPORT_ID_3     = 3,
	RDD_VPORT_ID_4     = 4,
	RDD_VPORT_ID_5     = 5,
	RDD_VPORT_ID_6     = 6,
	RDD_VPORT_ID_7     = 7,
	RDD_VPORT_ID_8     = 8,
	RDD_VPORT_ID_9     = 9,
	RDD_VPORT_ID_10    = 10,
	RDD_VPORT_ID_11    = 11,
	RDD_VPORT_ID_12    = 12,
	RDD_VPORT_ID_13    = 13,
	RDD_VPORT_ID_14    = 14,
	RDD_VPORT_ID_15    = 15,
	RDD_VPORT_ID_16    = 16,
	RDD_VPORT_ID_17    = 17,
	RDD_VPORT_ID_18    = 18,
	RDD_VPORT_ID_19    = 19,
	RDD_VPORT_ID_20    = 20,
	RDD_VPORT_ID_21    = 21,
	RDD_VPORT_ID_22    = 22,
	RDD_VPORT_ID_23    = 23,
	RDD_VPORT_ID_24    = 24,
	RDD_VPORT_ID_25    = 25,
	RDD_VPORT_ID_26    = 26,
	RDD_VPORT_ID_27    = 27,
	RDD_VPORT_ID_28    = 28,
	RDD_VPORT_ID_29    = 29,
	RDD_VPORT_ID_30    = 30,
	RDD_VPORT_ID_31    = 31,
	RDD_VPORT_ID_32    = 32,
	RDD_VPORT_ID_33    = 33,
	RDD_VPORT_ID_34    = 34,
	RDD_VPORT_ID_35    = 35,
	RDD_VPORT_ID_36    = 36,
	RDD_VPORT_ID_37    = 37,
	RDD_VPORT_ID_38    = 38,
	RDD_VPORT_ID_39    = 39,
	RDD_VPORT_LAST     = 39
} rdd_rdd_vport;
/* <<<RDD_RDD_VPORT */


/* >>>RDD_DSCP_TO */
typedef enum
{
	DSCP_TO_FIRST                 = 6,
	DSCP_TO_PBITS_SHIFT_OFFSET    = 6,
	DSCP_TO_LAST                  = 6
} rdd_dscp_to;
/* <<<RDD_DSCP_TO */


/* >>>RDD_RESOLUTION_CONTEXT */
typedef enum
{
	RESOLUTION_CONTEXT_FIRST                          = 0,
	RESOLUTION_CONTEXT_VIRTUAL_SRC_PORT_OFFSET        = 0,
	RESOLUTION_CONTEXT_GPE_DMA_OFFSET_WIDTH           = 1,
	RESOLUTION_CONTEXT_GPE_HEADER_LENGTH_WIDTH        = 1,
	RESOLUTION_CONTEXT_GPE_HEADER_IH_PTR_WIDTH        = 2,
	RESOLUTION_CONTEXT_GPE_COMMAND_LIST_PTR_WIDTH     = 2,
	RESOLUTION_CONTEXT_GPE_PACKET_DRR_PTR_WIDTH       = 4,
	RESOLUTION_CONTEXT_GPE_HEADER_LENGTH_OFFSET       = 6,
	RESOLUTION_CONTEXT_GPE_DMA_OFFSET_OFFSET          = 7,
	RESOLUTION_CONTEXT_GPE_COMMAND_LIST_PTR_OFFSET    = 8,
	RESOLUTION_CONTEXT_GPE_HEADER_IH_PTR_OFFSET       = 10,
	RESOLUTION_CONTEXT_GPE_PACKET_DRR_PTR_OFFSET      = 12,
	RESOLUTION_CONTEXT_LAST                           = 12
} rdd_resolution_context;
/* <<<RDD_RESOLUTION_CONTEXT */


/* >>>RDD_FFI */
typedef enum
{
	FFI_FIRST           = 3,
	FFI_8_LOG2_SIZE     = 3,
	FFI_16_LOG2_SIZE    = 4,
	FFI_32_LOG2_SIZE    = 5,
	FFI_8_SIZE          = 8,
	FFI_16_SIZE         = 16,
	FFI_32_SIZE         = 32,
	FFI_LAST            = 32
} rdd_ffi;
/* <<<RDD_FFI */


/* >>>RDD_TUNNEL_TYPE_BIT */
typedef enum
{
	TUNNEL_TYPE_BIT_FIRST      = 0,
	TUNNEL_TYPE_BIT_L3_GRE     = 0,
	TUNNEL_TYPE_BIT_GRE        = 0,
	TUNNEL_TYPE_BIT_L2_GRE     = 0,
	TUNNEL_TYPE_BIT_DS_LITE    = 1,
	TUNNEL_TYPE_BIT_VXLAN      = 2,
	TUNNEL_TYPE_BIT_LAST       = 2
} rdd_tunnel_type_bit;
/* <<<RDD_TUNNEL_TYPE_BIT */


/* >>>RDD_HASH */
typedef enum
{
	HASH_FIRST              = 7,
	HASH_MAX_TABLES_NUM     = 7,
	HASH_CRC_BYTE_SIZE      = 8,
	HASH_MAX_CTX_SIZE       = 18,
	HASH_KEY_SIZE           = 60,
	HASH_CAM_NUM_ENTRIES    = 64,
	HASH_INVALID_IDX        = 65535,
	HASH_LAST               = 65535
} rdd_hash;
/* <<<RDD_HASH */


/* >>>RDD_HASH_LKP */
typedef enum
{
	HASH_LKP_FIRST             = 0,
	HASH_LKP_MISS              = 0,
	HASH_LKP_MATCH_IN_TABLE    = 1,
	HASH_LKP_MATCH_IN_CAM      = 2,
	HASH_LKP_RESERVED          = 3,
	HASH_LKP_LAST              = 3
} rdd_hash_lkp;
/* <<<RDD_HASH_LKP */


/* >>>RDD_ */
typedef enum
{
	BBMSG_SRAM_ADDR_DIV_LOG2     = 3,
	FW_CRC_LEN                   = 4,
	BBMSG_SRAM_ADDR_DIV          = 8,
} rdd_;
/* <<<RDD_ */


/* >>>RDD_OAM_ETHERTYPE */
typedef enum
{
	OAM_ETHERTYPE_FIRST   = 34824,
	OAM_ETHERTYPE_8808    = 34824,
	OAM_ETHERTYPE_8809    = 34825,
	OAM_ETHERTYPE_LAST    = 34825
} rdd_oam_ethertype;
/* <<<RDD_OAM_ETHERTYPE */


/* >>>RDD_MLD_TYPE */
typedef enum
{
	MLD_TYPE_FIRST                           = 130,
	MLD_TYPE_V1_MULTICAST_LISTENER_QUERY     = 130,
	MLD_TYPE_V1_MIN                          = 130,
	MLD_TYPE_V1_MULTICAST_LISTENER_REPORT    = 131,
	MLD_TYPE_V1_MULTICAST_LISTENER_DONE      = 132,
	MLD_TYPE_V1_MAX                          = 132,
	MLD_TYPE_V2_MULTICAST_LISTENER_REPORT    = 143,
	MLD_TYPE_LAST                            = 143
} rdd_mld_type;
/* <<<RDD_MLD_TYPE */


/* >>>RDD_C_DEFS */
typedef enum
{
	C_DEFS_FIRST                                 = 32,
	C_DEFS_CPU_RECYCLE_STACK_SIZE                = 32,
	C_DEFS_CPU_RX_STACK_SIZE                     = 32,
	C_DEFS_GENERAL_TIMER_STACK_SIZE              = 32,
	C_DEFS_DHD_TX_POST_UPDATE_FIFO_STACK_SIZE    = 32,
	C_DEFS_REPORTING_STACK_SIZE                  = 32,
	C_DEFS_COMMON_REPROCESSING_STACK_SIZE        = 32,
	C_DEFS_DHD_TIMER_STACK_SIZE                  = 32,
	C_DEFS_DHD_RX_COMPLETE_STACK_SIZE            = 64,
	C_DEFS_DIRECT_FLOW_STACK_SIZE                = 64,
	C_DEFS_CPU_RX_COPY_STACK_SIZE                = 128,
	C_DEFS_CPU_TX_STACK_SIZE                     = 128,
	C_DEFS_DHD_TX_COMPLETE_STACK_SIZE            = 128,
	C_DEFS_DHD_TX_POST_STACK_SIZE                = 128,
	C_DEFS_SPDSVC_GEN_STACK_SIZE                 = 128,
	C_DEFS_DEFAULT_STACK_SIZE                    = 256,
	C_DEFS_SPDSVC_ANALYZER_STACK_SIZE            = 256,
	C_DEFS_PROCESSING_STACK_SIZE                 = 320,
	C_DEFS_LAST                                  = 320
} rdd_c_defs;
/* <<<RDD_C_DEFS */


/* >>>RDD_CPU_RX_REASON */
typedef enum
{
	CPU_RX_REASON_FIRST                 = 0,
	CPU_RX_REASON_OAM                   = 0,
	CPU_RX_REASON_PLOAM                 = 0,
	CPU_RX_REASON_OMCI                  = 1,
	CPU_RX_REASON_MPCP                  = 1,
	CPU_RX_REASON_FLOW                  = 2,
	CPU_RX_REASON_MULTICAST             = 3,
	CPU_RX_REASON_BROADCAST             = 4,
	CPU_RX_REASON_IGMP                  = 5,
	CPU_RX_REASON_ICMPV6                = 6,
	CPU_RX_REASON_MAC_TRAP_0            = 7,
	CPU_RX_REASON_MAC_TRAP_1            = 8,
	CPU_RX_REASON_MAC_TRAP_2            = 9,
	CPU_RX_REASON_MAC_TRAP_3            = 10,
	CPU_RX_REASON_DHCP                  = 11,
	CPU_RX_REASON_NON_TCP_UDP           = 12,
	CPU_RX_REASON_LOCAL_IP              = 13,
	CPU_RX_REASON_IP_HEADER_ERROR       = 14,
	CPU_RX_REASON_SA_MOVE               = 15,
	CPU_RX_REASON_UNKNOWN_SA            = 16,
	CPU_RX_REASON_UNKNOWN_DA            = 17,
	CPU_RX_REASON_IP_FRAGMENT           = 18,
	CPU_RX_REASON_MAC_SPOOFING          = 19,
	CPU_RX_REASON_MAC_DA_EQ_SA          = 19,
	CPU_RX_REASON_DIRECT_FLOW           = 20,
	CPU_RX_REASON_MCAST_MISS            = 21,
	CPU_RX_REASON_IPSEC                 = 22,
	CPU_RX_REASON_MCAST_FWD_AND_TRAP    = 23,
	CPU_RX_REASON_MCAST_EXCEPTION       = 24,
	CPU_RX_REASON_BRIDGE_DA_MAC         = 25,
	CPU_RX_REASON_L2CP                  = 26,
	CPU_RX_REASON_CPU_MIRRORING         = 27,
	CPU_RX_REASON_ETYPE_UDEF_0          = 28,
	CPU_RX_REASON_ETYPE_UDEF_1          = 29,
	CPU_RX_REASON_ETYPE_UDEF_2          = 30,
	CPU_RX_REASON_ETYPE_UDEF_3          = 31,
	CPU_RX_REASON_ETYPE_PPPOE_D         = 32,
	CPU_RX_REASON_ETYPE_PPPOE_S         = 33,
	CPU_RX_REASON_ETYPE_ARP             = 34,
	CPU_RX_REASON__1588                 = 35,
	CPU_RX_REASON_ETYPE_802_1X          = 36,
	CPU_RX_REASON_ETYPE_802_1AG_CFM     = 37,
	CPU_RX_REASON_RESERVED0             = 38,
	CPU_RX_REASON_UDP_CSUM_0            = 39,
	CPU_RX_REASON_UNKNOWN_DA_FLOOD      = 40,
	CPU_RX_REASON_IP_FLOW_MISS          = 41,
	CPU_RX_REASON_TCP_FLAGS             = 42,
	CPU_RX_REASON_TTL_EXPIRED           = 43,
	CPU_RX_REASON_MTU_EXCEEDED          = 44,
	CPU_RX_REASON_PARSER_ERROR          = 45,
	CPU_RX_REASON_CPU_REDIRECT          = 46,
	CPU_RX_REASON_L4_ESP                = 47,
	CPU_RX_REASON_UDEF_0                = 48,
	CPU_RX_REASON_UDEF_1                = 49,
	CPU_RX_REASON_UDEF_2                = 50,
	CPU_RX_REASON_UDEF_3                = 51,
	CPU_RX_REASON_UDEF_4                = 52,
	CPU_RX_REASON_UDEF_5                = 53,
	CPU_RX_REASON_UDEF_6                = 54,
	CPU_RX_REASON_UDEF_7                = 55,
	CPU_RX_REASON_UDEF_8                = 56,
	CPU_RX_REASON_UDEF_9                = 57,
	CPU_RX_REASON_UDEF_10               = 58,
	CPU_RX_REASON_UDEF_11               = 59,
	CPU_RX_REASON_UDEF_12               = 60,
	CPU_RX_REASON_UDEF_13               = 61,
	CPU_RX_REASON_UDEF_14               = 62,
	CPU_RX_REASON_UDEF_15               = 63,
	CPU_RX_REASON_LAST                  = 63
} rdd_cpu_rx_reason;
/* <<<RDD_CPU_RX_REASON */


/* >>>RDD_CPU_RX_METER */
typedef enum
{
	CPU_RX_METER_FIRST      = 0,
	CPU_RX_METER_ID_0       = 0,
	CPU_RX_METER_ID_1       = 1,
	CPU_RX_METER_ID_2       = 2,
	CPU_RX_METER_ID_3       = 3,
	CPU_RX_METER_ID_4       = 4,
	CPU_RX_METER_ID_5       = 5,
	CPU_RX_METER_ID_6       = 6,
	CPU_RX_METER_ID_7       = 7,
	CPU_RX_METER_ID_8       = 8,
	CPU_RX_METER_ID_9       = 9,
	CPU_RX_METER_ID_10      = 10,
	CPU_RX_METER_ID_11      = 11,
	CPU_RX_METER_ID_12      = 12,
	CPU_RX_METER_ID_13      = 13,
	CPU_RX_METER_ID_14      = 14,
	CPU_RX_METER_ID_15      = 15,
	CPU_RX_METER_DISABLE    = 255,
	CPU_RX_METER_LAST       = 255
} rdd_cpu_rx_meter;
/* <<<RDD_CPU_RX_METER */


/* >>>RDD_CPU_REDIRECT_TYPE */
typedef enum
{
	CPU_REDIRECT_TYPE_FIRST   = 0,
	CPU_REDIRECT_TYPE_NONE    = 0,
	CPU_REDIRECT_TYPE_ALL     = 1,
	CPU_REDIRECT_TYPE_FLOW    = 2,
	CPU_REDIRECT_TYPE_LAST    = 2
} rdd_cpu_redirect_type;
/* <<<RDD_CPU_REDIRECT_TYPE */


/* >>>RDD_CPU_RX_TC */
typedef enum
{
	CPU_RX_TC_FIRST   = 0,
	CPU_RX_TC_ID_0    = 0,
	CPU_RX_TC_ID_1    = 1,
	CPU_RX_TC_ID_2    = 2,
	CPU_RX_TC_ID_3    = 3,
	CPU_RX_TC_ID_4    = 4,
	CPU_RX_TC_ID_5    = 5,
	CPU_RX_TC_ID_6    = 6,
	CPU_RX_TC_ID_7    = 7,
	CPU_RX_TC_LAST    = 7
} rdd_cpu_rx_tc;
/* <<<RDD_CPU_RX_TC */


/* >>>RDD_CPU_RX_TYPE */
typedef enum
{
	CPU_RX_TYPE_FIRST            = 0,
	CPU_RX_TYPE_FWD              = 0,
	CPU_RX_TYPE_EXCEPTION        = 1,
	CPU_RX_TYPE_SPEED_SERVICE    = 2,
	CPU_RX_TYPE_WAN_LOOPBACK     = 3,
	CPU_RX_TYPE_LAST             = 3
} rdd_cpu_rx_type;
/* <<<RDD_CPU_RX_TYPE */


/* >>>RDD_SPDTEST */
typedef enum
{
	SPDTEST_FIRST          = 0,
	SPDTEST_NONE           = 0,
	SPDTEST_BRCM_SPDSVC    = 1,
	SPDTEST_UDP_BASIC      = 2,
	SPDTEST_UDP_IPERF3     = 3,
	SPDTEST_TCP            = 4,
	SPDTEST_TIMER_VALUE    = 100,
	SPDTEST_LAST           = 100
} rdd_spdtest;
/* <<<RDD_SPDTEST */


/* >>>RDD_PKTGEN_TX */
typedef enum
{
	PKTGEN_TX_FIRST               = 4,
	PKTGEN_TX_NUM_OF_DATA_PKTS    = 4,
	PKTGEN_TX_NUM_OF_SBPM_HDRS    = 28,
	PKTGEN_TX_LAST                = 28
} rdd_pktgen_tx;
/* <<<RDD_PKTGEN_TX */


/* >>>RDD_TCPSPDTEST */
typedef enum
{
	TCPSPDTEST_FIRST                                       = 0,
	TCPSPDTEST_DUP_ACK_STATE_NONE                          = 0,
	TCPSPDTEST_DUP_ACK_STATE_WAIT_THR                      = 1,
	TCPSPDTEST_UP_CWND_FACTOR_START                        = 2,
	TCPSPDTEST_DUP_ACK_STATE_WAIT_EFS                      = 2,
	TCPSPDTEST_DUP_ACK_STATE_WAIT_PARTIAL_ACK              = 3,
	TCPSPDTEST_DUP_ACK_STATE_PARTIAL_ACK                   = 4,
	TCPSPDTEST_RTO_RING_RETRANS_ELEMENT_SIZE               = 4,
	TCPSPDTEST_RTO_RING_TX_SEQ_COALESCING_THR              = 8,
	TCPSPDTEST_RTO_RING_TX_SEQ_ELEMENT_SIZE                = 8,
	TCPSPDTEST_RTO_RING_SCRATCHPAD_SIZE                    = 8,
	TCPSPDTEST_UP_CWND_FACTOR_MAX                          = 10,
	TCPSPDTEST_RTO_RING_TX_SEQ_SCRATCHPAD_METADATA_SIZE    = 16,
	TCPSPDTEST_NUM_OF_ERR_COR_BUFS                         = 32,
	TCPSPDTEST_RTO_RING_TX_SEQ_COALESCING_MASK             = 63,
	TCPSPDTEST_ERR_COR_BUF_IDX_MASK                        = 127,
	TCPSPDTEST_RTO_RING_TX_SEQ_COALESCING_TIME_USEC        = 4096,
	TCPSPDTEST_RTO_RING_RETRANS_MASK                       = 8191,
	TCPSPDTEST_RTO_RING_RETRANS_SIZE                       = 8192,
	TCPSPDTEST_RTO_RING_TX_SEQ_MASK                        = 131071,
	TCPSPDTEST_RTO_RING_TX_SEQ_SIZE                        = 131072,
	TCPSPDTEST_LAST                                        = 131072
} rdd_tcpspdtest;
/* <<<RDD_TCPSPDTEST */


/* >>>RDD_DEBUG_PRINT_TABLE */
typedef enum
{
	DEBUG_PRINT_TABLE_FIRST   = 16384,
	DEBUG_PRINT_TABLE_SIZE    = 16384,
	DEBUG_PRINT_TABLE_LAST    = 16384
} rdd_debug_print_table;
/* <<<RDD_DEBUG_PRINT_TABLE */


/* >>>RDD_MCAST_DEFS */
typedef enum
{
	MCAST_DEFS_FIRST                     = 255,
	MCAST_DEFS_MAX_CHANNELS_IN_MASTER    = 255,
	MCAST_DEFS_MAX_CHANNELS_IN_HASH      = 1024,
	MCAST_DEFS_MAX_FLOWS_IN_TOTAL        = 8192,
	MCAST_DEFS_LAST                      = 8192
} rdd_mcast_defs;
/* <<<RDD_MCAST_DEFS */


/* >>>RDD_CTX_SIZE */
typedef enum
{
	CTX_SIZE_FIRST       = 0,
	CTX_SIZE_8           = 0,
	CTX_SIZE_16          = 1,
	CTX_SIZE_24          = 2,
	CTX_SIZE_32          = 3,
	CTX_SIZE_40          = 4,
	CTX_SIZE_48          = 5,
	CTX_SIZE_56          = 6,
	CTX_SIZE_64          = 7,
	CTX_SIZE_72          = 8,
	CTX_SIZE_80          = 9,
	CTX_SIZE_88          = 10,
	CTX_SIZE_96          = 11,
	CTX_SIZE_104         = 12,
	CTX_SIZE_112         = 13,
	CTX_SIZE_120         = 14,
	CTX_SIZE_128         = 15,
	CTX_SIZE_NOT_USED    = 16,
	CTX_SIZE_LAST        = 16
} rdd_ctx_size;
/* <<<RDD_CTX_SIZE */


/* >>>RDD_TCAM_IC_MODULE */
typedef enum
{
	TCAM_IC_MODULE_FIRST                = 0,
	TCAM_IC_MODULE_GENERIC_FILTER_DS    = 0,
	TCAM_IC_MODULE_GENERIC_FILTER_US    = 1,
	TCAM_IC_MODULE_LAST                 = 1
} rdd_tcam_ic_module;
/* <<<RDD_TCAM_IC_MODULE */


/* >>>RDD_GENERIC_LAYER */
typedef enum
{
	GENERIC_LAYER_FIRST = 0,
	GENERIC_LAYER_L2    = 0,
	GENERIC_LAYER_L3    = 1,
	GENERIC_LAYER_L4    = 2,
	GENERIC_LAYER_LAST  = 2
} rdd_generic_layer;
/* <<<RDD_GENERIC_LAYER */


/* >>>RDD_GENERIC_FIELDS */
typedef enum
{
	GENERIC_FIELDS_FIRST        = 4,
	GENERIC_FIELDS_PER_TABLE    = 4,
	GENERIC_FIELDS_LAST         = 4
} rdd_generic_fields;
/* <<<RDD_GENERIC_FIELDS */


/* >>>RDD_BRIDGE_AND_VLAN_LKP_MISS_ACTION */
typedef enum
{
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_FIRST      = 0,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_DROP       = 0,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_TRAP       = 1,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_FORWARD    = 2,
	BRIDGE_AND_VLAN_LKP_MISS_ACTION_LAST       = 2
} rdd_bridge_and_vlan_lkp_miss_action;
/* <<<RDD_BRIDGE_AND_VLAN_LKP_MISS_ACTION */


/* >>>RDD_BRIDGE_ARL_LOOKUP_METHOD */
typedef enum
{
	BRIDGE_ARL_LOOKUP_METHOD_FIRST       = 0,
	BRIDGE_ARL_LOOKUP_METHOD_MAC_ONLY    = 0,
	BRIDGE_ARL_LOOKUP_METHOD_MAC_VID     = 1,
	BRIDGE_ARL_LOOKUP_METHOD_LAST        = 1
} rdd_bridge_arl_lookup_method;
/* <<<RDD_BRIDGE_ARL_LOOKUP_METHOD */


/* >>>RDD_BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD */
typedef enum
{
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_FIRST         = 0,
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_VPORT_ONLY    = 0,
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_VPORT_VID     = 1,
	BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD_LAST          = 1
} rdd_bridge_and_vlan_ctx_lookup_method;
/* <<<RDD_BRIDGE_AND_VLAN_CTX_LOOKUP_METHOD */


/* >>>RDD_BRIDGE_FLOW */
typedef enum
{
	BRIDGE_FLOW_FIRST = 0,
	BRIDGE_FLOW_DS    = 0,
	BRIDGE_FLOW_US    = 1,
	BRIDGE_FLOW_LAST  = 1
} rdd_bridge_flow;
/* <<<RDD_BRIDGE_FLOW */


/* >>>RDD_NO_FWD_ACTION */
typedef enum
{
	NO_FWD_ACTION_FIRST   = 0,
	NO_FWD_ACTION_DROP    = 0,
	NO_FWD_ACTION_TRAP    = 1,
	NO_FWD_ACTION_LAST    = 1
} rdd_no_fwd_action;
/* <<<RDD_NO_FWD_ACTION */


/* >>>RDD_MULTICAST_GROUP_MODE */
typedef enum
{
	MULTICAST_GROUP_MODE_FIRST       = 0,
	MULTICAST_GROUP_MODE_IANA        = 0,
	MULTICAST_GROUP_MODE_ASM_ONLY    = 1,
	MULTICAST_GROUP_MODE_SSM_ONLY    = 2,
	MULTICAST_GROUP_MODE_LAST        = 2
} rdd_multicast_group_mode;
/* <<<RDD_MULTICAST_GROUP_MODE */


/* >>>RDD_INGRESS_FILTER */
typedef enum
{
	INGRESS_FILTER_FIRST                = 0,
	INGRESS_FILTER_DHCP                 = 0,
	INGRESS_FILTER_ETYPE_PPPOE_D        = 1,
	INGRESS_FILTER_ETYPE_PPPOE_S        = 2,
	INGRESS_FILTER_IGMP                 = 3,
	INGRESS_FILTER_MLD                  = 4,
	INGRESS_FILTER_ICMPV6               = 5,
	INGRESS_FILTER_HDR_ERR              = 6,
	INGRESS_FILTER_IP_FRAGMENT          = 7,
	INGRESS_FILTER_ETYPE_UDEF_0         = 8,
	INGRESS_FILTER_ETYPE_UDEF_1         = 9,
	INGRESS_FILTER_ETYPE_UDEF_2         = 10,
	INGRESS_FILTER_ETYPE_UDEF_3         = 11,
	INGRESS_FILTER_ETYPE_ARP            = 12,
	INGRESS_FILTER_ETYPE_PTP_1588       = 13,
	INGRESS_FILTER_ETYPE_802_1X         = 14,
	INGRESS_FILTER_ETYPE_802_1AG_CFM    = 15,
	INGRESS_FILTER_MAC_SPOOFING         = 16,
	INGRESS_FILTER_MAC_DA_EQ_SA         = 16,
	INGRESS_FILTER_IP_MCAST_CONTROL     = 17,
	INGRESS_FILTER_MCAST_IPV4           = 18,
	INGRESS_FILTER_MCAST_IPV6           = 19,
	INGRESS_FILTER_MCAST_L2             = 20,
	INGRESS_FILTER_MCAST                = 21,
	INGRESS_FILTER_BCAST                = 22,
	INGRESS_FILTER_L4_PTP_1588          = 23,
	INGRESS_FILTER_L2CP                 = 24,
	INGRESS_FILTER_LAST                 = 24
} rdd_ingress_filter;
/* <<<RDD_INGRESS_FILTER */


/* >>>RDD_ACTION_POINT_PRIO */
typedef enum
{
	ACTION_POINT_PRIO_FIRST                   = 1,
	ACTION_POINT_PRIO_TCP_FLAGS               = 1,
	ACTION_POINT_PRIO_TUNNEL                  = 1,
	ACTION_POINT_PRIO_FLOW_MISS               = 1,
	ACTION_POINT_PRIO_GENERIC_FILTER          = 1,
	ACTION_POINT_PRIO_MTU                     = 1,
	ACTION_POINT_PRIO_FLOW_CONTROL            = 1,
	ACTION_POINT_PRIO_TTL                     = 1,
	ACTION_POINT_PRIO_UDP_CSUM_0              = 1,
	ACTION_POINT_PRIO_FLOW_POLICER            = 1,
	ACTION_POINT_PRIO_MCAST_WHITELIST_MISS    = 2,
	ACTION_POINT_PRIO_MCAST_CLIENT_MISS       = 2,
	ACTION_POINT_PRIO_INGRESS_CONGESTION      = 3,
	ACTION_POINT_PRIO_INGRESS_FILTERS         = 4,
	ACTION_POINT_PRIO_DOS_ATTACK              = 5,
	ACTION_POINT_PRIO_LAST                    = 5
} rdd_action_point_prio;
/* <<<RDD_ACTION_POINT_PRIO */


/* >>>RDD_DECISION_POINT_THR */
typedef enum
{
	DECISION_POINT_THR_FIRST             = 0,
	DECISION_POINT_THR_FLOW_MISS         = 0,
	DECISION_POINT_THR_PRE_PROCESSING    = 0,
	DECISION_POINT_THR_FLOW_HIT          = 0,
	DECISION_POINT_THR_LAST              = 0
} rdd_decision_point_thr;
/* <<<RDD_DECISION_POINT_THR */


/* >>>RDD_PACKET_HEADER_MAC */
typedef enum
{
	PACKET_HEADER_MAC_FIRST        = 0,
	PACKET_HEADER_MAC_DA_OFFSET    = 0,
	PACKET_HEADER_MAC_SA_OFFSET    = 6,
	PACKET_HEADER_MAC_LAST         = 6
} rdd_packet_header_mac;
/* <<<RDD_PACKET_HEADER_MAC */


/* >>>RDD_GENERAL_TIMER */
typedef enum
{
	GENERAL_TIMER_FIRST          = 0,
	GENERAL_TIMER_INDEX          = 0,
	GENERAL_TIMER_PERIODICITY    = 100,
	GENERAL_TIMER_LAST           = 100
} rdd_general_timer;
/* <<<RDD_GENERAL_TIMER */


/* >>>RDD_TIMER_ACTION */
typedef enum
{
	TIMER_ACTION_FIRST                    = 0,
	TIMER_ACTION_CPU_RX_COALESCING        = 0,
	TIMER_ACTION_RECYCLE_COALESCING       = 1,
	TIMER_ACTION_RX_METER_BUDGET_ALLOC    = 2,
	TIMER_ACTION_LAST                     = 2
} rdd_timer_action;
/* <<<RDD_TIMER_ACTION */


/* >>>RDD_RDPA_TUNNEL_TYPE */
typedef enum
{
	RDPA_TUNNEL_TYPE_FIRST      = 0,
	RDPA_TUNNEL_TYPE_L2_GRE     = 0,
	RDPA_TUNNEL_TYPE_L3_GRE     = 1,
	RDPA_TUNNEL_TYPE_DS_LITE    = 2,
	RDPA_TUNNEL_TYPE_VXLAN      = 4,
	RDPA_TUNNEL_TYPE_LAST       = 4
} rdd_rdpa_tunnel_type;
/* <<<RDD_RDPA_TUNNEL_TYPE */


/* >>>RDD_TUNNEL_INDICATION */
typedef enum
{
	TUNNEL_INDICATION_FIRST = 0,
	TUNNEL_INDICATION_L2    = 0,
	TUNNEL_INDICATION_L3    = 1,
	TUNNEL_INDICATION_LAST  = 1
} rdd_tunnel_indication;
/* <<<RDD_TUNNEL_INDICATION */


/* >>>RDD_RC */
typedef enum
{
	RC_FIRST                  = -2,
	RC_RETRY                  = -2,
	RC_ERROR                  = -1,
	RC_OK                     = 0,
	RC_CONTINUE_PROCESSING    = 1,
	RC_VALID_TUNNEL_RESULT    = 2,
	RC_LAST                   = 2
} rdd_rc;
/* <<<RDD_RC */


/* >>>RDD_COUNTER */
typedef enum
{
	COUNTER_FIRST                                   = 0,
	COUNTER_TM_PD_NOT_VALID_ID                      = 0,
	COUNTER_TM_ACTION_NOT_VALID_ID                  = 1,
	COUNTER_EPON_TM_PD_NOT_VALID_ID                 = 2,
	COUNTER_PROCESSING_ACTION_NOT_VALID_ID          = 4,
	COUNTER_CPU_RECYCLE_RING_CONGESTION             = 5,
	COUNTER_CPU_RX_FEED_RING_CONGESTION             = 6,
	COUNTER_CPU_RX_PSRAM_DROP                       = 7,
	COUNTER_IPTV_HASH_LKP_MISS_DROP                 = 8,
	COUNTER_IPTV_SRC_IP_VID_LKP_MISS_DROP           = 9,
	COUNTER_IPTV_INVALID_CTX_ENTRY_DROP             = 10,
	COUNTER_IPTV_FPM_SBPM_ALLOC_NACK_DROP           = 11,
	COUNTER_IPTV_FIRST_REPL_DISP_ALLOC_NACK_DROP    = 12,
	COUNTER_IPTV_EXCEPTION_DROP                     = 13,
	COUNTER_IPTV_OTHER_REPL_DISP_ALLOC_NACK_DROP    = 14,
	COUNTER_CPU_TX_COPY_NO_FPM                      = 15,
	COUNTER_CPU_TX_COPY_NO_SBPM                     = 16,
	COUNTER_CPU_RX_TC_TO_RXQ_MAP_DROP               = 17,
	COUNTER_CPU_RX_VPORT_TO_CPU_OBJ_MAP_DROP        = 18,
	COUNTER_ETHERNET_FLOW_DROP_ACTION               = 19,
	COUNTER_SBPM_ALLOC_EXCEPTION_DROP               = 20,
	COUNTER_DROP_CONNECTION_ACTION_DROP_ID          = 21,
	COUNTER_DROP_RESOURCE_CONGESTION_INGRESS        = 22,
	COUNTER_DROP_RESOURCE_CONGESTION_EGRESS         = 23,
	COUNTER_INGRESS_FILTER_DROP_FIRST_DS            = 24,
	COUNTER_INGRESS_FILTER_DROP_FIRST_US            = 48,
	COUNTER_INGRESS_RATE_LIMIT_DROP                 = 70,
	COUNTER_INGRESS_FILTER_DROP_LAST                = 71,
	COUNTER_CPU_RX_METER_DROP                       = 72,
	COUNTER_INGRESS_ISOLATION_DROP                  = 73,
	COUNTER_EGRESS_ISOLATION_DROP                   = 74,
	COUNTER_DA_LKP_MISS_DROP                        = 75,
	COUNTER_SA_LKP_MISS_DROP                        = 76,
	COUNTER_BRIDGE_FW_ELIGABILITY_DROP              = 77,
	COUNTER_DA_LKP_MATCH_DROP                       = 78,
	COUNTER_SA_LKP_MATCH_DROP                       = 79,
	COUNTER_CPU_TX_DISABLED_QUEUE_DROP              = 80,
	COUNTER_DISABLED_TX_FLOW_DROP                   = 81,
	COUNTER_CPU_FEED_RING_DISP_CONGESTION           = 82,
	COUNTER_SBPM_LIB_DISP_CONG                      = 83,
	COUNTER_BRIDGE_FLOODING                         = 84,
	COUNTER_DIS_PROTO_DS_IPV4                       = 85,
	COUNTER_DIS_PROTO_DS_IPV6                       = 86,
	COUNTER_DIS_PROTO_DS_PPPOE                      = 87,
	COUNTER_DIS_PROTO_DS_NON_IP                     = 88,
	COUNTER_DIS_PROTO_US_IPV4                       = 89,
	COUNTER_DIS_PROTO_US_IPV6                       = 90,
	COUNTER_DIS_PROTO_US_PPPOE                      = 91,
	COUNTER_DIS_PROTO_US_NON_IP                     = 92,
	COUNTER_DS_MIRROR_NO_SBPM_DROP                  = 93,
	COUNTER_DS_MIRROR_NO_TOKEN_DROP                 = 94,
	COUNTER_US_MIRROR_NO_SBPM_DROP                  = 95,
	COUNTER_US_MIRROR_NO_TOKEN_DROP                 = 96,
	COUNTER_TX_MIRROR_DROP                          = 97,
	COUNTER_INGRESS_CONGESTION_LAN                  = 98,
	COUNTER_INGRESS_CONGESTION_WAN                  = 99,
	COUNTER_SQ_PD_NOT_VALID                         = 100,
	COUNTER_SQ_ACTION_NOT_VALID                     = 101,
	COUNTER_RX_WAN_PORT_DROP                        = 102,
	COUNTER_RX_ERROR_DROP                           = 103,
	COUNTER_PACKET_MODIFY_DROP                      = 104,
	COUNTER_CODEL_QUEUE_BACK_TO_DROP                = 105,
	COUNTER_CODEL_QUEUE_RECOVER                     = 106,
	COUNTER_UNDEFINED_QUEUE_DROP                    = 106,
	COUNTER_CODEL_EMPTY_QUEUE_RECOVER               = 107,
	COUNTER_TUNNEL_NO_SBPM_DROP                     = 108,
	COUNTER_POLICER_RED_COLOR_DROP                  = 109,
	COUNTER_CPU_TX_INGRESS                          = 110,
	COUNTER_CPU_TX_EGRESS                           = 111,
	COUNTER_FLUSH_EGRESS_QUEUE                      = 112,
	COUNTER_DOS_ATTACK_RESERVED_0                   = 113,
	COUNTER_DOS_ATTACK_FIRST                        = 113,
	COUNTER_DOS_ATTACK_MAC_SA_EQ_DA                 = 114,
	COUNTER_DOS_ATTACK_IP_LAND                      = 115,
	COUNTER_DOS_ATTACK_TCP_BLAT                     = 116,
	COUNTER_DOS_ATTACK_UDP_BLAT                     = 117,
	COUNTER_DOS_ATTACK_TCP_NULLSCAN                 = 118,
	COUNTER_DOS_ATTACK_TCP_XMASSCAN                 = 119,
	COUNTER_DOS_ATTACK_TCP_SYNFINSCAN               = 120,
	COUNTER_DOS_ATTACK_TCP_SYNERROR                 = 121,
	COUNTER_DOS_ATTACK_TCP_SHORTHDR                 = 122,
	COUNTER_DOS_ATTACK_TCP_FRAGERROR                = 123,
	COUNTER_DOS_ATTACK_ICMPV4_FRAGMENT              = 124,
	COUNTER_DOS_ATTACK_ICMPV6_FRAGMENT              = 125,
	COUNTER_DOS_ATTACK_ICMPV4_LONGPING              = 126,
	COUNTER_DOS_ATTACK_ICMPV6_LONGPING              = 127,
	COUNTER_DOS_ATTACK_RESERVED_15                  = 128,
	COUNTER_DOS_ATTACK_LAST                         = 128,
	COUNTER_FC_MCAST_BAD_REPLICATIONS_NUM_DROP      = 129,
	COUNTER_FC_MCAST_CLIENT_FLOW_MISS               = 130,
	COUNTER_INVALID                                 = 255,
	COUNTER_LAST                                    = 255
} rdd_counter;
/* <<<RDD_COUNTER */


/* >>>RDD_BUF_MNG */
typedef enum
{
	BUF_MNG_FIRST                = 0,
	BUF_MNG_TOTAL_BUDGET_CNTR    = 0,
	BUF_MNG_WLAN_0_CNTR          = 1,
	BUF_MNG_WLAN_HIGH_0_CNTR     = 2,
	BUF_MNG_WLAN_1_CNTR          = 3,
	BUF_MNG_WLAN_HIGH_1_CNTR     = 4,
	BUF_MNG_WLAN_2_CNTR          = 5,
	BUF_MNG_WLAN_HIGH_2_CNTR     = 6,
	BUF_MNG_WLAN_TOTAL_CNTR      = 7,
	BUF_MNG_CPU_RX_CNTR          = 8,
	BUF_MNG_CPU_RX_HIGH_CNTR     = 9,
	BUF_MNG_LAST                 = 9
} rdd_buf_mng;
/* <<<RDD_BUF_MNG */


/* >>>RDD_POLICER_RESULT_COLOR */
typedef enum
{
	POLICER_RESULT_COLOR_FIRST     = 0,
	POLICER_RESULT_COLOR_RED       = 0,
	POLICER_RESULT_COLOR_YELLOW    = 64,
	POLICER_RESULT_COLOR_GREEN     = 128,
	POLICER_RESULT_COLOR_LAST      = 128
} rdd_policer_result_color;
/* <<<RDD_POLICER_RESULT_COLOR */


/* >>>RDD_CNPL_GROUP */
typedef enum
{
	CNPL_GROUP_FIRST                   = 0,
	CNPL_GROUP_RX_FLOW                 = 0,
	CNPL_GROUP_RX_FLOW_DROP            = 1,
	CNPL_GROUP_TX_FLOW                 = 2,
	CNPL_GROUP_TCAM                    = 3,
	CNPL_GROUP_TWO_BYTE_CNTR           = 4,
	CNPL_GROUP_FOUR_BYTE_CNTR          = 5,
	CNPL_GROUP_TX_QUEUE                = 6,
	CNPL_GROUP_DHD_CTR_CNTRS           = 7,
	CNPL_GROUP_CPU_RX_METER_DROP       = 8,
	CNPL_GROUP_POLICER_GREEN_COLOR     = 9,
	CNPL_GROUP_POLICER_YELLOW_COLOR    = 10,
	CNPL_GROUP_POLICER_RED_COLOR       = 11,
	CNPL_GROUP_PATHSTAT                = 12,
	CNPL_GROUP_DHD_CNTRS               = 13,
	CNPL_GROUP_LAST                    = 13
} rdd_cnpl_group;
/* <<<RDD_CNPL_GROUP */


/* >>>RDD_CNTR_GROUP */
typedef enum
{
	CNTR_GROUP_FIRST                = 0,
	CNTR_GROUP_RX_FLOW              = 0,
	CNTR_GROUP_TX_FLOW              = 1,
	CNTR_GROUP_TCAM_DEF             = 2,
	CNTR_GROUP_VARIOUS              = 3,
	CNTR_GROUP_GENERAL              = 4,
	CNTR_GROUP_TX_QUEUE             = 5,
	CNTR_GROUP_DHD_CTR              = 6,
	CNTR_GROUP_CPU_RX_METER_DROP    = 7,
	CNTR_GROUP_POLICER              = 8,
	CNTR_GROUP_PATHSTAT             = 9,
	CNTR_GROUP_DHD_CNTRS            = 10,
	CNTR_GROUP_IPTV_NATC            = 11,
	CNTR_GROUP_GROUPS_NUMBER        = 12,
	CNTR_GROUP_LAST                 = 12
} rdd_cntr_group;
/* <<<RDD_CNTR_GROUP */


/* >>>RDD_CNPL_POLICER_GROUP */
typedef enum
{
	CNPL_POLICER_GROUP_FIRST                 = 0,
	CNPL_POLICER_GROUP_DUAL_BUCKET_INDEX     = 0,
	CNPL_POLICER_GROUP_FLOW_CONTROL_INDEX    = 2,
	CNPL_POLICER_GROUP_LAST                  = 2
} rdd_cnpl_policer_group;
/* <<<RDD_CNPL_POLICER_GROUP */


/* >>>RDD_DHD_FLOW_PRIO */
typedef enum
{
	DHD_FLOW_PRIO_FIRST     = 0,
	DHD_FLOW_PRIO_NORMAL    = 0,
	DHD_FLOW_PRIO_HIGH      = 1,
	DHD_FLOW_PRIO_EXCL      = 2,
	DHD_FLOW_PRIO_LAST      = 2
} rdd_dhd_flow_prio;
/* <<<RDD_DHD_FLOW_PRIO */


/* >>>RDD_NATC */
typedef enum
{
	NATC_FIRST                     = 3,
	NATC_LOOKUP_DEPTH_SIZE_LOG2    = 3,
	NATC_LOOKUP_DEPTH_SIZE         = 8,
	NATC_MAX_TABLES_NUM            = 8,
	NATC_TABLE_KEY_SIZE            = 16,
	NATC_TABLE_RES_SIZE            = 64,
	NATC_MAX_ENTRY_LEN             = 128,
	NATC_LAST                      = 128
} rdd_natc;
/* <<<RDD_NATC */


/* >>>RDD_NATC_TBL_IDX */
typedef enum
{
	NATC_TBL_IDX_FIRST       = 0,
	NATC_TBL_IDX_DS          = 0,
	NATC_TBL_IDX_US          = 1,
	NATC_TBL_IDX_MCAST       = 2,
	NATC_TBL_IDX_COUNTERS    = 2,
	NATC_TBL_IDX_LAST        = 2
} rdd_natc_tbl_idx;
/* <<<RDD_NATC_TBL_IDX */


/* >>>RDD_NATC_SUB_TBL_IDX */
typedef enum
{
	NATC_SUB_TBL_IDX_FIRST          = 0,
	NATC_SUB_TBL_IDX_L3             = 0,
	NATC_SUB_TBL_IDX_VLAN_ACTION    = 1,
	NATC_SUB_TBL_IDX_L2             = 2,
	NATC_SUB_TBL_IDX_LAST           = 2
} rdd_natc_sub_tbl_idx;
/* <<<RDD_NATC_SUB_TBL_IDX */


/* >>>RDD_HASH_TABLE */
typedef enum
{
	HASH_TABLE_FIRST   = 1,
	HASH_TABLE_IPTV    = 1,
	HASH_TABLE_LAST    = 1
} rdd_hash_table;
/* <<<RDD_HASH_TABLE */


/* >>>RDD_CPU_IF_RDD */
typedef enum
{
	CPU_IF_RDD_FIRST      = 0,
	CPU_IF_RDD_DATA       = 0,
	CPU_IF_RDD_RECYCLE    = 1,
	CPU_IF_RDD_FEED       = 2,
	CPU_IF_RDD_CPU_TX     = 3,
	CPU_IF_RDD_LAST       = 3
} rdd_cpu_if_rdd;
/* <<<RDD_CPU_IF_RDD */


/* >>>RDD_DHD_CTR_GROUP */
typedef enum
{
	DHD_CTR_GROUP_FIRST                      = 0,
	DHD_CTR_GROUP_SPINLOCK_DHD_0             = 0,
	DHD_CTR_GROUP_SPINLOCK_DHD_1             = 1,
	DHD_CTR_GROUP_SPINLOCK_DHD_2             = 2,
	DHD_CTR_GROUP_WRITE_PTR_DHD_0            = 3,
	DHD_CTR_GROUP_WRITE_PTR_DHD_1            = 4,
	DHD_CTR_GROUP_WRITE_PTR_DHD_2            = 5,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_0          = 6,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_1          = 7,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_2          = 8,
	DHD_CTR_GROUP_DHD_TX_FPM_USED_TOTAL      = 9,
	DHD_CTR_GROUP_SPINLOCK_DEBUG_PRINT       = 10,
	DHD_CTR_GROUP_WRITE_PTR_0_DEBUG_PRINT    = 11,
	DHD_CTR_GROUP_WRITE_PTR_1_DEBUG_PRINT    = 12,
	DHD_CTR_GROUP_LAST                       = 12
} rdd_dhd_ctr_group;
/* <<<RDD_DHD_CTR_GROUP */


/* >>>RDD_DHD_CNTR */
typedef enum
{
	DHD_CNTR_FIRST                          = 0,
	DHD_CNTR_DHD_RX_DROP_0                  = 0,
	DHD_CNTR_DHD_RX_DROP_1                  = 1,
	DHD_CNTR_DHD_RX_DROP_2                  = 2,
	DHD_CNTR_DHD_TX_FPM_DROP_0              = 3,
	DHD_CNTR_DHD_TX_FPM_DROP_1              = 4,
	DHD_CNTR_DHD_TX_FPM_DROP_2              = 5,
	DHD_CNTR_DHD_TX_HIGH_PRIO_FPM_DROP_0    = 6,
	DHD_CNTR_DHD_TX_HIGH_PRIO_FPM_DROP_1    = 7,
	DHD_CNTR_DHD_TX_HIGH_PRIO_FPM_DROP_2    = 8,
	DHD_CNTR_DHD_MCAST_SBPM_DROP_0          = 9,
	DHD_CNTR_DHD_MCAST_SBPM_DROP_1          = 10,
	DHD_CNTR_DHD_MCAST_SBPM_DROP_2          = 11,
	DHD_CNTR_DHD_TX_DROP_0_SSID_0           = 12,
	DHD_CNTR_DHD_TX_DROP_1_SSID_0           = 28,
	DHD_CNTR_DHD_TX_DROP_2_SSID_0           = 44,
	DHD_CNTR_DHD_TX_FR_FULL_0_AC_0          = 60,
	DHD_CNTR_DHD_TX_FR_FULL_1_AC_0          = 65,
	DHD_CNTR_DHD_TX_FR_FULL_2_AC_0          = 70,
	DHD_CNTR_DHD_DROP_LAST_CNTR             = 74,
	DHD_CNTR_LAST                           = 74
} rdd_dhd_cntr;
/* <<<RDD_DHD_CNTR */


/* >>>RDD_FLOW_DEST */
typedef enum
{
	FLOW_DEST_FIRST      = 0,
	FLOW_DEST_ETH_ID     = 0,
	FLOW_DEST_IPTV_ID    = 1,
	FLOW_DEST_LAST       = 1
} rdd_flow_dest;
/* <<<RDD_FLOW_DEST */


/* >>>RDD_TUNNEL_KEY */
typedef enum
{
	TUNNEL_KEY_FIRST             = 255,
	TUNNEL_KEY_OFFSET_INVALID    = 255,
	TUNNEL_KEY_LAST              = 255
} rdd_tunnel_key;
/* <<<RDD_TUNNEL_KEY */


/* >>>RDD_BBH_QUEUE */
typedef enum
{
	BBH_QUEUE_FIRST             = 40,
	BBH_QUEUE_WAN_1_ENTRY_ID    = 40,
	BBH_QUEUE_LAST              = 40
} rdd_bbh_queue;
/* <<<RDD_BBH_QUEUE */


/* >>>RDD_DIRECT_FLOW */
typedef enum
{
	DIRECT_FLOW_FIRST                             = 1,
	DIRECT_FLOW_PAUSE_MAC_CTRL_TYPE               = 1,
	DIRECT_FLOW_PAUSE_TIME_QUANTA_SHIFT_FACTOR    = 12,
	DIRECT_FLOW_LAST                              = 12
} rdd_direct_flow;
/* <<<RDD_DIRECT_FLOW */


/* >>>RDD_TM_UPDATE_VECTOR */
typedef enum
{
	TM_UPDATE_VECTOR_FIRST              = 0,
	TM_UPDATE_VECTOR_BS_DWRR_Q          = 0,
	TM_UPDATE_VECTOR_BS_Q_BRL           = 1,
	TM_UPDATE_VECTOR_BS_BRL_Q           = 2,
	TM_UPDATE_VECTOR_CS_DWRR_Q          = 3,
	TM_UPDATE_VECTOR_CS_DWRR_BS         = 4,
	TM_UPDATE_VECTOR_CS_DWRR_CS         = 5,
	TM_UPDATE_VECTOR_CS_BS_Q_BRL        = 6,
	TM_UPDATE_VECTOR_CS_Q_CRL_SIR       = 7,
	TM_UPDATE_VECTOR_CS_Q_CRL_PIR       = 8,
	TM_UPDATE_VECTOR_CS_BS_CRL_SIR_Q    = 9,
	TM_UPDATE_VECTOR_CS_BS_CRL_PIR_Q    = 10,
	TM_UPDATE_VECTOR_CS_CS_CRL_SIR_Q    = 11,
	TM_UPDATE_VECTOR_CS_CS_CRL_PIR_Q    = 12,
	TM_UPDATE_VECTOR_CS_BRL             = 13,
	TM_UPDATE_VECTOR_CS_CS_BRL          = 14,
	TM_UPDATE_VECTOR_OVL_RL             = 15,
	TM_UPDATE_VECTOR_LAST               = 15
} rdd_tm_update_vector;
/* <<<RDD_TM_UPDATE_VECTOR */


/* >>>RDD_COUNTER_TX_FLOW_GROUP */
typedef enum
{
	COUNTER_TX_FLOW_GROUP_FIRST              = 0,
	COUNTER_TX_FLOW_GROUP_TX_GEM_FIRST       = 0,
	COUNTER_TX_FLOW_GROUP_TX_VPORT_FIRST     = 128,
	COUNTER_TX_FLOW_GROUP_PATH_STAT_FIRST    = 144,
	COUNTER_TX_FLOW_GROUP_LAST               = 144
} rdd_counter_tx_flow_group;
/* <<<RDD_COUNTER_TX_FLOW_GROUP */


/* >>>RDD_BBMSG_TYPE */
typedef enum
{
	BBMSG_TYPE_FIRST                                              = 0,
	BBMSG_TYPE_RUNNER_BBH_RX_FLOW_CONTROL                         = 0,
	BBMSG_TYPE_QM_PD_FIFO_CREDIT_FREE                             = 0,
	BBMSG_TYPE_BBH_TX_PACKET_DESCRIPTOR                           = 1,
	BBMSG_TYPE_RUNNER_SBPM_BUFFER_ALLOC_MANUAL_TASK_ID            = 1,
	BBMSG_TYPE_QM_UPDATE_FIFO_CREDIT_FREE                         = 1,
	BBMSG_TYPE_FPM_BUFFER_ALLOC_MANUAL_TASK_ID                    = 1,
	BBMSG_TYPE_RUNNER_SBPM_MCAST_INC_REQUEST_MANUAL_TASK_ID       = 2,
	BBMSG_TYPE_FPM_BUFFER_MCAST_INCREMENT_MANUAL_TASK_ID          = 2,
	BBMSG_TYPE_BBH_TX_NACK                                        = 2,
	BBMSG_TYPE_BBH_TX_ACK                                         = 3,
	BBMSG_TYPE_FPM_BUFFER_FREE_MANUAL_TASK_ID                     = 3,
	BBMSG_TYPE_BBH_SBPM_BUFFER_FREE                               = 3,
	BBMSG_TYPE_BBH_GHOST_DBR                                      = 4,
	BBMSG_TYPE_RUNNER_SBPM_CONNECT_MANUAL_TASK_ID                 = 4,
	BBMSG_TYPE_RUNNER_SBPM_GET_NEXT_MANUAL_TASK_ID                = 5,
	BBMSG_TYPE_BBH_TX_REPORT_ACK                                  = 5,
	BBMSG_TYPE_BBH_SBPM_BUFFER_FREE_WITHOUT_CONTEXT               = 6,
	BBMSG_TYPE_RUNNER_SBPM_BUFFER_FREE_WITHOUT_CONTEXT            = 6,
	BBMSG_TYPE_BBH_TX_REPORT_NACK                                 = 7,
	BBMSG_TYPE_RUNNER_SBPM_INGRESS_TO_EGRESS                      = 7,
	BBMSG_TYPE_RUNNER_REORDER_PD_WRITE                            = 8,
	BBMSG_TYPE_RUNNER_DISPATCHER_PD_ACK_MANUAL_TASK_ID            = 9,
	BBMSG_TYPE_RUNNER_DISPATCHER_PD_WRITE                         = 10,
	BBMSG_TYPE_RUNNER_REORDER_TOKEN_REQUEST                       = 11,
	BBMSG_TYPE_RUNNER_REORDER_BUFFER_CONNECT                      = 12,
	BBMSG_TYPE_RUNNER_DISPATCHER_WAKEUP_PENDING                   = 13,
	BBMSG_TYPE_RUNNER_REORDER_CONNECT_REQUEST_BUFFER_CONNECTED    = 14,
	BBMSG_TYPE_RUNNER_REORDER_BUFFER_MULTICAST_CONNECT_REQUEST    =