/*
 * dni_netfilter_sysctl.c: DNI netfilter sysctl interface to net subsystem.
 *
 * Copyright (C) 2010 Delta Networks Inc.
 *
 */
#ifdef CONFIG_SYSCTL
#include <linux/module.h>
#include <linux/sysctl.h>
#include <net/netfilter/nf_conntrack.h>

unsigned int sysctl_do_flush_conntrack = 0;
unsigned int sysctl_conntrack_refresh_outbound_only = 0;
unsigned int sysctl_ip_option_rr_ssrr_lsrr_pass_through = 0;

EXPORT_SYMBOL(sysctl_conntrack_refresh_outbound_only);
EXPORT_SYMBOL(sysctl_ip_option_rr_ssrr_lsrr_pass_through);

static int proc_flush_conntrack(struct ctl_table * ctl,
				int write,
				void __user * buffer, size_t * lenp,
				loff_t * ppos)
{
	proc_dointvec(ctl, write, buffer, lenp, ppos);
	if (write && (sysctl_do_flush_conntrack != 0))
		do_flush_conntrack_table(sysctl_do_flush_conntrack);
	return 0;
}

struct ctl_table dni_table[] = {
	{
		.procname   = "flush_conntrack_table",
		.data       = &sysctl_do_flush_conntrack,
		.maxlen     = sizeof(unsigned int),
		.mode       = 0644,
		.proc_handler   = proc_flush_conntrack,
	},
	{
		.procname       = "conntrack_refresh_outbound_only",
		.data           = &sysctl_conntrack_refresh_outbound_only,
		.maxlen         = sizeof(unsigned int),
		.mode           = 0644,
		.proc_handler   = proc_dointvec,
	},
    {
        .procname   = "ip_option_rr_ssrr_lsrr_pass_through",
        .data       = &sysctl_ip_option_rr_ssrr_lsrr_pass_through,
        .maxlen     = sizeof(int),
        .mode       = 0644,
        .proc_handler   = proc_dointvec,
    },
	{ }
};

struct ctl_table dni_netfilter_sysctl_table[2] = {
	{
		.procname	= "dni_netfilter",
		.mode		= 0555,
		.child		= dni_table
	},
	{ }
};

EXPORT_SYMBOL(dni_netfilter_sysctl_table);
#endif
