/*
* <:copyright-BRCM:2010:DUAL/GPL:standard
* 
*    Copyright (c) 2010 Broadcom 
*    All Rights Reserved
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as published by
* the Free Software Foundation (the "GPL").
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* 
* A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
* writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
* 
* :>

*/

#ifndef _BCM_LOG_MODULES_
#define _BCM_LOG_MODULES_

typedef enum {
    BCM_LOG_LEVEL_ERROR=0,
    BCM_LOG_LEVEL_NOTICE,
    BCM_LOG_LEVEL_INFO,
    BCM_LOG_LEVEL_DEBUG,
    BCM_LOG_LEVEL_MAX
} bcmLogLevel_t;

/* To support a new module, create a new log ID in bcmLogId_t,
   and a new entry in BCM_LOG_MODULE_INFO */


typedef enum {
    BCM_LOG_ID_LOG=0,
    BCM_LOG_ID_VLAN,
    BCM_LOG_ID_GPON,
    BCM_LOG_ID_PLOAM,
    BCM_LOG_ID_PLOAM_FSM,
    BCM_LOG_ID_PLOAM_HAL,
    BCM_LOG_ID_PLOAM_PORT,
    BCM_LOG_ID_PLOAM_ALARM,
    BCM_LOG_ID_OMCI,
    BCM_LOG_ID_I2C,
    BCM_LOG_ID_ENET,
    BCM_LOG_ID_GPON_SERDES,
    BCM_LOG_ID_AE,
    BCM_LOG_ID_XTM,
    BCM_LOG_ID_IQ,
    BCM_LOG_ID_BPM,
    BCM_LOG_ID_ARL,
    BCM_LOG_ID_EPON,
    BCM_LOG_ID_GMAC,   
    BCM_LOG_ID_RDPA,
    BCM_LOG_ID_RDPA_CMD_DRV,
    BCM_LOG_ID_PKTRUNNER,
    BCM_LOG_ID_SIM_CARD,
    BCM_LOG_ID_PMD,
    BCM_LOG_ID_TM,
    BCM_LOG_ID_SPDSVC,
    BCM_LOG_ID_MCAST,
    BCM_LOG_ID_DPI,
    BCM_LOG_ID_CMDLIST,
    BCM_LOG_ID_ARCHER,
    BCM_LOG_ID_TOD,
    BCM_LOG_ID_PON_PWM,
    BCM_LOG_ID_OPTICALDET,
    BCM_LOG_ID_WANTYPEDET,
    BCM_LOG_ID_XPORT,
    BCM_LOG_ID_BCMLIBS_BIT_POOL,
    BCM_LOG_ID_MPM,
    BCM_LOG_ID_MAX
} bcmLogId_t;

#define BCM_LOG_MODULE_INFO                             \
    {                                                   \
        {.logId = BCM_LOG_ID_LOG, .name = "bcmlog", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_VLAN, .name = "vlan", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_GPON, .name = "gpon", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PLOAM, .name = "ploam", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PLOAM_FSM, .name = "ploamFsm", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PLOAM_HAL, .name = "ploamHal", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PLOAM_PORT, .name = "ploamPort", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PLOAM_ALARM, .name = "ploamAlarm", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_OMCI, .name = "omci", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_I2C, .name = "i2c", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_ENET, .name = "enet", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_GPON_SERDES, .name = "gponSerdes", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_AE, .name = "ae", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_XTM, .name = "xtm", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_IQ, .name = "iq", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_BPM, .name = "bpm", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_ARL, .name = "arl", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_EPON, .name = "eponlue", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_GMAC, .name = "gmac", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_RDPA, .name = "rdpa", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_RDPA_CMD_DRV, .name = "rdpadrv", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PKTRUNNER, .name = "pktrunner", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_SIM_CARD, .name = "sim_card", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PMD, .name = "pmd", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_TM, .name = "tm", .logLevel = BCM_LOG_LEVEL_ERROR}, \
        {.logId = BCM_LOG_ID_SPDSVC, .name = "spdsvc", .logLevel = BCM_LOG_LEVEL_ERROR}, \
        {.logId = BCM_LOG_ID_MCAST, .name = "mcast", .logLevel = BCM_LOG_LEVEL_ERROR}, \
        {.logId = BCM_LOG_ID_DPI, .name = "dpi", .logLevel = BCM_LOG_LEVEL_ERROR}, \
        {.logId = BCM_LOG_ID_CMDLIST, .name = "cmdlist", .logLevel = BCM_LOG_LEVEL_ERROR}, \
        {.logId = BCM_LOG_ID_ARCHER, .name = "archer", .logLevel = BCM_LOG_LEVEL_ERROR}, \
        {.logId = BCM_LOG_ID_TOD, .name = "tod", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_PON_PWM, .name = "pon_pwm", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_OPTICALDET, .name = "opticaldet", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_WANTYPEDET, .name = "wantypedet", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_XPORT, .name = "xport", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_BCMLIBS_BIT_POOL, .name = "bitpool", .logLevel = BCM_LOG_LEVEL_NOTICE}, \
        {.logId = BCM_LOG_ID_MPM, .name = "mpm", .logLevel = BCM_LOG_LEVEL_ERROR}, \
    }

/* To support a new registered function,
 * create a new BCM_FUN_ID */

typedef enum {
    BCM_FUN_ID_RESET_SWITCH=0,
    BCM_FUN_ID_ENET_LINK_CHG,
    BCM_FUN_ID_ENET_CHECK_SWITCH_LOCKUP,
    BCM_FUN_ID_ENET_GET_PORT_BUF_USAGE,
    BCM_FUN_ID_GPON_GET_GEM_PID_QUEUE,
    BCM_FUN_ID_ENET_HANDLE,
    BCM_FUN_ID_EPON_HANDLE,
    BCM_FUN_IN_ENET_CLEAR_ARL_ENTRY,
    BCM_FUN_ID_ENET_IS_WAN_PORT, /* Take Logical port number as argument */
    BCM_FUN_ID_ENET_IS_SWSWITCH_PORT,
    BCM_FUN_ID_ENET_LAG_PORT_GET,
    BCM_FUN_ID_ENET_PORT_ROLE_NOTIFY,
    BCM_FUN_ID_ENET_BOND_RX_PORT_MAP,
    BCM_FUN_ID_ENET_SYSPORT_CONFIG,
    BCM_FUN_ID_ENET_SYSPORT_QUEUE_MAP,
    BCM_FUN_ID_ENET_REMAP_TX_QUEUE,
    BCM_FUN_ID_ENET_PHY_SPEED_SET,
    BCM_FUN_ID_ENET_TM_EN_SET,
    /* The arguments of the BCM TM functions are defined by bcmTmDrv_arg_t */
    BCM_FUN_ID_TM_REGISTER,
    BCM_FUN_ID_TM_PORT_CONFIG,
    BCM_FUN_ID_TM_PORT_ENABLE,
    BCM_FUN_ID_TM_ARBITER_CONFIG,
    BCM_FUN_ID_TM_QUEUE_CONFIG,
    BCM_FUN_ID_TM_APPLY,
    BCM_FUN_ID_TM_ENQUEUE,
    /* The arguments of the Speed Service functions are defined in spdsvc_defs.h */
    BCM_FUN_ID_SPDSVC_TRANSMIT,
    BCM_FUN_ID_SPDSVC_RECEIVE,
    /* Kernel Bonding Driver related function */
    BCM_FUN_ID_BOND_CLR_SLAVE_STAT,
    BCM_FUN_ID_ENET_IS_BONDED_LAN_WAN_PORT, /* Expects Logical port number as argument */
    BCM_FUN_ID_ENET_IS_DEV_IN_SLAVE_PATH, 
    BCM_FUN_ID_BOND_RX_HANDLER, 
    /* DSL Runner Hooks */
    BCM_FUN_ID_RUNNER_PREPEND,
    BCM_FUN_ID_TCPSPDTEST_CONNECT,
    /* Archer Hooks */
    BCM_FUN_ID_ARCHER_HOST_BIND,
    BCM_FUN_ID_ARCHER_XTMRT_BIND,
    BCM_FUN_ID_ARCHER_WFD_BIND,
    BCM_FUN_ID_ARCHER_WFD_CONFIG,
    BCM_FUN_ID_VLAN_LOOKUP_DP,
    /* WLAN Hooks */
    BCM_FUN_ID_WLAN_QUERY_BRIDGEFDB,
    BCM_FUN_ID_WLAN_UPDATE_BRIDGEFDB,
    BCM_FUN_ID_WLAN_PKTC_DEL_BY_MAC,
    BCM_FUN_ID_SPDT_RNR_TRANSMIT,
    BCM_FUN_ID_MAX
} bcmFunId_t;

/* Structures passed in above function calls */
typedef struct {
    struct net_device *slave_dev;   /* Input */
    struct net_device **bond_dev;    /* Input/Output */
}BCM_BondDevInfo;

/* Structures passed in above function calls */
typedef struct {
    uint16_t gemPortIndex; /* Input */
    uint16_t gemPortId;    /* Output */
    uint8_t  usQueueIdx;   /* Output */
}BCM_GponGemPidQueueInfo;

typedef enum {
    BCM_ENET_FUN_TYPE_LEARN_CTRL = 0,
    BCM_ENET_FUN_TYPE_ARL_WRITE,
    BCM_ENET_FUN_TYPE_AGE_PORT,
    BCM_ENET_FUN_TYPE_UNI_UNI_CTRL,
    BCM_ENET_FUN_TYPE_PORT_RX_CTRL,
    BCM_ENET_FUN_TYPE_GET_VPORT_CNT,
    BCM_ENET_FUN_TYPE_GET_IF_NAME_OF_VPORT,
    BCM_ENET_FUN_TYPE_GET_UNIPORT_MASK,
    BCM_ENET_FUN_TYPE_MAX
} bcmFun_Type_t;

typedef struct {
    uint16_t vid;
    uint16_t val;
    uint8_t mac[6];
} arlEntry_t;

typedef struct {
    bcmFun_Type_t type; /* Action Needed in Enet Driver */
    union {
        uint8_t port;
        uint8_t uniport_cnt;
        uint16_t portMask;
        arlEntry_t arl_entry;
    };
    char name[16];
    uint8_t enable;
}BCM_EnetHandle_t;

typedef enum {
    BCM_EPON_FUN_TYPE_UNI_UNI_CTRL = 0,
    BCM_EPON_FUN_TYPE_MAX
} bcmEponFun_Type_t;

typedef struct {
    bcmEponFun_Type_t type; /* Action Needed in Epon Driver */
    uint8_t enable;
}BCM_EponHandle_t;

typedef struct {
    uint8_t port; /* switch port */
    uint8_t enable; /* enable/disable the clock */
}BCM_CmfFfeClk_t;

#define BCM_RUNNER_PREPEND_SIZE_MAX  32 /* Increasing the size of the prepend data buffer will require
                                           recompiling the pktrunner driver files released as binary */

typedef struct {
    void *blog_p;      /* INPUT: Pointer to the Blog_t structure that triggered the Runner flow creation */
    uint8_t data[BCM_RUNNER_PREPEND_SIZE_MAX]; /* INPUT: The data that will be be prepended to all packets
                                                  forwarded by Runner that match the given Blog/Flow.
                                                  The data must be stored in NETWWORK BYTE ORDER */
    unsigned int size; /* OUTPUT: Size of the prepend data, up to 32 bytes long.
                          When no data is to be prepended, specify size = 0 */
} BCM_runnerPrepend_t;

typedef struct {
    unsigned int sysport;
    unsigned int switch_id;
    unsigned int port;
    unsigned int is_wan;
} BCM_EnetPortRole_t;

#define BCM_ENET_SYSPORT_INTF_MAX       2
#define BCM_ENET_SYSPORT_BLOG_CHNL_MAX  8

typedef enum {
    BCM_ENET_SYSPORT_MODE_INVALID = 0,
    BCM_ENET_SYSPORT_MODE_PORT,
    BCM_ENET_SYSPORT_MODE_INTERNAL_BRCM_SW,
    BCM_ENET_SYSPORT_MODE_EXTERNAL_BRCM_SW,
    BCM_ENET_SYSPORT_MODE_STACKED_BRCM_SW,
    BCM_ENET_SYSPORT_MODE_MAX
} bcmSysport_Mode_t;

typedef struct {
    bcmSysport_Mode_t mode;
} bcmSysport_Sysport_t;

typedef struct {
    struct net_device *dev;
    int sysport;
    int switch_id;
    int port;
    int nbr_of_queues;
} bcmSysport_BlogChnl_t;

typedef struct {
    int nbr_of_sysports;
    bcmSysport_Sysport_t sysport[BCM_ENET_SYSPORT_INTF_MAX];
    int nbr_of_blog_channels;
    bcmSysport_BlogChnl_t blog_chnl[BCM_ENET_SYSPORT_BLOG_CHNL_MAX];
    int switch_parent_port;     /* parent port num if external switch exists, otherwise NO_EXT_SWITCH */
#define         NO_EXT_SWITCH           -1
    int ls_port_q_offset;       /* external switch port lightstacking port tx q start offset */
} bcmSysport_Config_t;

#define BCM_ENET_SYSPORT_QUEUE_MAP_PRIORITY_MAX  8

typedef struct {
    int blog_chnl;
    uint8_t priority_to_switch_queue[BCM_ENET_SYSPORT_QUEUE_MAP_PRIORITY_MAX];
} bcmSysport_QueueMap_t;

typedef struct {
    int blog_chnl;
    int blog_chnl_rx;
} bcmEnet_BondRxPortMap_t;

/* Structure used with BCM_FUN_ID_ENET_REMAP_TX_QUEUE */
typedef struct {
    uint8_t tx_queue;
    void *dev;
} bcmEnet_QueueReMap_t;

typedef struct {
    struct net_device *dev;
    int kbps;
} bcmSysport_PhySpeed_t;

#endif /* _BCM_LOG_MODULES_ */

