include $(BUILD_DIR)/dni/make.dni

CMAKE_SOURCE_DIR:=.
CMAKE_BIN:=$(HOSTTOOLS_DIR)/local_install/bin/cmake

CMAKE_C_COMPILER:=$(CC)
CMAKE_CXX_COMPILER:=$(CXX)
CMAKE_C_COMPILER_ARG1:=
CMAKE_CXX_COMPILER_ARG1:=
CMAKE_AR:=$(CROSS_COMPILE)ar
CMAKE_NM:=$(CROSS_COMPILE)nm
CMAKE_RANLIB:=$(CROSS_COMPILE)ranlib

CMAKE_FIND_ROOT_PATH:=$(BCM_FSBUILD_DIR);$(TOOLCHAIN)
CMAKE_HOST_FIND_ROOT_PATH:=$(HOSTTOOLS_DIR)/local_install
CMAKE_SHARED_LDFLAGS:=-Wl,-Bsymbolic-functions

define Build/Configure/Default
	(cd $(PKG_BUILD_DIR); \
		CFLAGS="$(CFLAGS)" \
		CXXFLAGS="$(CFLAGS)" \
		LDFLAGS="$(TARGET_LDFLAGS)" \
		$(CMAKE_BIN) \
			-DCMAKE_SYSTEM_NAME=Linux \
			-DCMAKE_SYSTEM_VERSION=1 \
			-DCMAKE_SYSTEM_PROCESSOR=$(ARCH) \
			-DCMAKE_BUILD_TYPE=Release \
			-DCMAKE_C_FLAGS_RELEASE="-DNDEBUG" \
			-DCMAKE_CXX_FLAGS_RELEASE="-DNDEBUG" \
			-DCMAKE_C_COMPILER="$(CMAKE_C_COMPILER)" \
			-DCMAKE_C_COMPILER_ARG1="$(CMAKE_C_COMPILER_ARG1)" \
			-DCMAKE_CXX_COMPILER="$(CMAKE_CXX_COMPILER)" \
			-DCMAKE_CXX_COMPILER_ARG1="$(CMAKE_CXX_COMPILER_ARG1)" \
			-DCMAKE_ASM_COMPILER="$(CMAKE_C_COMPILER)" \
			-DCMAKE_ASM_COMPILER_ARG1="$(CMAKE_C_COMPILER_ARG1)" \
			-DCMAKE_AR="$(CMAKE_AR)" \
			-DCMAKE_NM="$(CMAKE_NM)" \
			-DCMAKE_RANLIB="$(CMAKE_RANLIB)" \
			-DCMAKE_FIND_ROOT_PATH="$(CMAKE_FIND_ROOT_PATH)" \
			-DCMAKE_FIND_ROOT_PATH_MODE_PROGRAM=BOTH \
			-DCMAKE_FIND_ROOT_PATH_MODE_LIBRARY=ONLY \
			-DCMAKE_FIND_ROOT_PATH_MODE_INCLUDE=ONLY \
			-DCMAKE_STRIP=: \
			-DCMAKE_INSTALL_PREFIX=/usr \
			-DDL_LIBRARY=$(BCM_FSBUILD_DIR) \
			-DCMAKE_PREFIX_PATH=$(BCM_FSBUILD_DIR) \
			-DCMAKE_SKIP_RPATH=TRUE  \
			$(CMAKE_OPTIONS) \
		$(CMAKE_SOURCE_DIR) \
	)
endef

define Build/InstallDev/cmake
	$(INSTALL_BDIR) $(1)
	$(CP) $(PKG_INSTALL_DIR)/* $(1)/
endef

Build/InstallDev = $(if $(CMAKE_INSTALL),$(Build/InstallDev/cmake))
