
#include <common.h>

/*====move this to a .h file===============================================*/
#define SYSPORT_NUM_RX_PKT_DESC_LOG2  (7)

#define SYSPORT_NUM_TX_PKT_DESC_LOG2  (0)

#define SYSPORT_PKT_LEN_LOG2 (11)

/* Number of RX DMA buffers */
#define NUM_RX_DMA_BUFFERS		(1<<SYSPORT_NUM_RX_PKT_DESC_LOG2)

/* Number of RX DMA buffers */
#define NUM_TX_DMA_BUFFERS		(1<<SYSPORT_NUM_TX_PKT_DESC_LOG2)

/* Total number of DMA buffers */
#define NUM_DMA_BUFFERS			(NUM_RX_DMA_BUFFERS + NUM_TX_DMA_BUFFERS)

/* RX/TX DMA buffer size */
#define NET_DMA_BUFSIZE			2048

/* DMA buffer size for SP_RDMA_BSRS_REG register (2048 bytes) */
#define NET_DMA_SHIFT			11

#define ENET_ZLEN                               60

typedef struct PktDesc {
    uint32_t address ;
    uint32_t address_hi :8;
    uint32_t status :10;
    uint32_t length :14;
}PktDesc;

/*===================================================*/

typedef struct sys_port_topctrl {
	uint32_t SYSTEMPORT_TOPCTRL_REV_CNTL;
	uint32_t SYSTEMPORT_TOPCTRL_RX_FLUSH_CNTL;
	uint32_t SYSTEMPORT_TOPCTRL_TX_FLUSH_CNTL;
	uint32_t SYSTEMPORT_TOPCTRL_MISC_CNTL;
	uint32_t SYSTEMPORT_TOPCTRL_PM_CNTL;
	uint32_t SYSTEMPORT_TOPCTRL_PM_STATUS;
	uint32_t SYSTEMPORT_TOPCTRL_TIMER_TICK_CNTL;
	uint32_t SYSTEMPORT_TOPCTRL_WR_REPLY_CFG;
	uint32_t SYSTEMPORT_TOPCTRL_MISC_SWAP_CFG;
	uint32_t SYSTEMPORT_TOPCTRL_UMAC_RXERR_MASK;
	uint32_t SYSTEMPORT_TOPCTRL_MIB_MAX_PKT_SIZE;
	uint32_t SYSTEMPORT_TOPCTRL_TIMER0_TIMEOUT_PERIOD;
	uint32_t reserved[3];
	uint32_t SYSTEMPORT_TOPCTRL_TIMER1_TIMEOUT_PERIOD;
}sys_port_topctrl, SYSTEMPORT_TOPCTRL;


#define FIELD_MASK(bits, shift)  ( ( (1ULL<<(bits)) - 1 ) << shift )


#define SYSPORT_RDMA_CTRL_RDMA_EN_M             FIELD_MASK(1,0)
#if defined(CONFIG_BCM6756)
#define SYSPORT_RDMA_CTRL_RING_CFG_M            FIELD_MASK(2,1)
#define SYSPORT_RDMA_CTRL_RING_CFG_bit0_M       FIELD_MASK(1,1)
#define SYSPORT_RDMA_CTRL_RING_CFG_bit1_M       FIELD_MASK(1,2)
#define SYSPORT_RDMA_CTRL_DISCARD_EN_M          FIELD_MASK(1,3)
#else
#define SYSPORT_RDMA_CTRL_RING_CFG_bit1_M       FIELD_MASK(1,1)
#define SYSPORT_RDMA_CTRL_DISCARD_EN_M          FIELD_MASK(1,2)
#define SYSPORT_RDMA_CTRL_RING_CFG_bit0_M       FIELD_MASK(1,14)
#endif
#define SYSPORT_RDMA_CTRL_DATA_OFFSET_M         FIELD_MASK(10,4)
#define SYSPORT_RDMA_CTRL_DDR_DESC_WR_EN_M      FIELD_MASK(1,15)
#define SYSPORT_RDMA_CTRL_PSB_EN_M              FIELD_MASK(1,18)

#define SYSPORT_RDMA_STATUS_RDMA_DISABLED_M     FIELD_MASK(1,0)
#define SYSPORT_RDMA_STATUS_DESC_RAM_BUSY_M     FIELD_MASK(1,1)

#define SYSTEMPORT_RDMA_LOCRAM_DESCRING_SIZE_MAX            256
#define SYSTEMPORT_RDMA_LOCRAM_DESCRING_SIZE_RING_FLUSH_M   FIELD_MASK(1,16)
#define SYSTEMPORT_RDMA_LOCRAM_DESCRING_SIZE_RING_EN_M      FIELD_MASK(1,17)

#define SYSPORT_RDMA_PSB_INTR_CFG_THRESHOLD_M     FIELD_MASK(16,0)
#define SYSPORT_RDMA_PSB_INTR_CFG_THRESHOLD_S     0
#define SYSPORT_RDMA_PSB_INTR_CFG_TIMEOUT_M       FIELD_MASK(16,16)
#define SYSPORT_RDMA_PSB_INTR_CFG_TIMEOUT_S       16

typedef struct sys_port_rdma {
	uint32_t SYSTEMPORT_RDMA_DESCRIPTOR[1024];
	uint32_t SYSTEMPORT_RDMA_DESC_WRITE_PORT[16];
	uint32_t SYSTEMPORT_RDMA_DESC_READ_PORT[16];
	uint32_t SYSTEMPORT_RDMA_CONTROL;
	uint32_t SYSTEMPORT_RDMA_STATUS;
	uint32_t SYSTEMPORT_RDMA_SYSBUS_BURST;
	uint32_t SYSTEMPORT_RDMA_SWITCH_PORT_BP_EN;
	uint32_t SYSTEMPORT_RDMA_RXQ_TO_SWITCH_EGRESS_QUEUES_BP_MAP[8];
#define SYSPORT_RDMA_RING_EN	(1<<17)
	uint32_t SYSTEMPORT_RDMA_LOCRAM_DESCRING_SIZE[8];
	uint32_t SYSTEMPORT_RDMA_PKTBUF_SIZE[8];
	uint32_t SYSTEMPORT_RDMA_PINDEX[8];
	uint32_t SYSTEMPORT_RDMA_CINDEX[8];
	uint32_t SYSTEMPORT_RDMA_BUFDONE_INTR_CFG[8];
	uint32_t SYSTEMPORT_RDMA_XON_XOFF_CFG[8];
	uint32_t SYSTEMPORT_RDMA_DDR_DESC_RING_START[16];
	uint32_t SYSTEMPORT_RDMA_DDR_DESC_RING_SIZE[8];
	uint32_t SYSTEMPORT_RDMA_DDR_DESC_RING_CTRL[8];
	uint32_t SYSTEMPORT_RDMA_DDR_DESC_RING_WR_PUSH_TIMER[8];
#if defined(CONFIG_BCM6756)
	uint32_t SYSTEMPORT_RDMA_DISCARD_CNT[8];
#endif
	uint32_t SYSTEMPORT_RDMA_BP_STATUS;
	uint32_t SYSTEMPORT_RDMA_DESC_RAM_ARB_CONTROL;
	uint32_t SYSTEMPORT_RDMA_DESC_RAM_RD_ARB_CFG;
	uint32_t SYSTEMPORT_RDMA_DESC_RAM_WR_ARB_CFG;
	uint32_t SYSTEMPORT_RDMA_PSB_INTR_CFG;
	uint32_t SYSTEMPORT_RDMA_PSB_ADDR_LO;
	uint32_t SYSTEMPORT_RDMA_PSB_ADDR_HI;
#if defined(CONFIG_BCM6756)
	uint32_t SYSTEMPORT_RDMA_MPM_CFG;
#endif
	uint32_t SYSTEMPORT_RDMA_TEST;
	uint32_t SYSTEMPORT_RDMA_DEBUG;
}sys_port_rdma, SYSTEMPORT_RDMA;


#define SYSPORT_RBUF_CTRL_RSB_MODE_M          FIELD_MASK(2,0)
#define SYSPORT_RBUF_CTRL_RSB_MODE_S          0
#define SYSPORT_RBUF_CTRL_4B_ALIGN_M          FIELD_MASK(1,2)
#define SYSPORT_RBUF_CTRL_BTAG_STRIP_M        FIELD_MASK(1,3)
#define SYSPORT_RBUF_CTRL_BAD_PKT_DISCARD_M   FIELD_MASK(1,4)
#define SYSPORT_RBUF_CTRL_CRC_REPLACE_M       FIELD_MASK(1,21)

#define SYSPORT_RBUF_CTRL_RSB_MODE_NO_RSB     0
#define SYSPORT_RBUF_CTRL_RSB_MODE_RSB8       1
#define SYSPORT_RBUF_CTRL_RSB_MODE_RSB32      2

#define SYSPORT_RBUF_PACKET_READY_THRESHOLD_PKT_RDY_THRESHOLD_M   FIELD_MASK(10,0)
#define SYSPORT_RBUF_PACKET_READY_THRESHOLD_PKT_RDY_THRESHOLD_S   0
#define SYSPORT_RBUF_PACKET_READY_THRESHOLD_RESUME_THRESHOLD_M    FIELD_MASK(10,16)
#define SYSPORT_RBUF_PACKET_READY_THRESHOLD_RESUME_THRESHOLD_S    16

typedef struct sys_port_rbuf {
	uint32_t SYSTEMPORT_RBUF_RBUF_CONTROL;
	uint32_t SYSTEMPORT_RBUF_RBUF_PACKET_READY_THRESHOLD;
	uint32_t SYSTEMPORT_RBUF_RBUF_STATUS;
	uint32_t SYSTEMPORT_RBUF_RBUF_OVERFLOW_PACKET_DISCARD_COUNT;
	uint32_t SYSTEMPORT_RBUF_RBUF_ERROR_PACKET_COUNT;
}sys_port_rbuf, SYSTEMPORT_RBUF;

#define SYSTEMPORT_TDMA_DESC_RING_MAX        28
#define SYSTEMPORT_TDMA_LOCRAM_DESCRING_MAX  896

#define SYSTEMPORT_TDMA_TIMEOUT_TICK_NSEC    1000 // tick = 1 usec (internal timer)

typedef struct systemport_tdma_descriptor_write_port
{
		uint32_t SYSTEMPORT_TDMA_DESCRIPTOR_XX_WRITE_PORT_LO;
		uint32_t SYSTEMPORT_TDMA_DESCRIPTOR_XX_WRITE_PORT_HI;
}systemport_tdma_descriptor_write_port;

typedef struct systemport_tdma_descriptor_read_port
{
		uint32_t SYSTEMPORT_TDMA_DESCRIPTOR_XX_READ_PORT_LO;
		uint32_t SYSTEMPORT_TDMA_DESCRIPTOR_XX_READ_PORT_HI;
}systemport_tdma_descriptor_read_port;

#define SYSTEMPORT_TDMA_DESC_RING_XX_PRODUCER_CONSUMER_INDEX_CONSUMER_INDEX_S      16
#define SYSTEMPORT_TDMA_DESC_RING_XX_PRODUCER_CONSUMER_INDEX_CONSUMER_INDEX_M      FIELD_MASK(16,16)
#define SYSTEMPORT_TDMA_DESC_RING_XX_PRODUCER_CONSUMER_INDEX_PRODUCER_INDEX_M      FIELD_MASK(16,0)

#define SYSPORT_TDMA_CONTROL_TDMA_EN_M                  FIELD_MASK(1,0)
#define SYSPORT_TDMA_CONTROL_TSB_EN_M                   FIELD_MASK(1,1)
#define SYSPORT_TDMA_CONTROL_DATA_OFFSET_M              FIELD_MASK(10,5)
#define SYSPORT_TDMA_CONTROL_VLAN_EN_M                  FIELD_MASK(1,15)
#define SYSPORT_TDMA_CONTROL_SW_BRCM_TAG_M              FIELD_MASK(1,16)
#define SYSPORT_TDMA_CONTROL_WNC_PKT_SIZE_UPDATE_MODE   FIELD_MASK(1,17)
#define SYSPORT_TDMA_CONTROL_SYNC_PKT_SIZE_UPDATE_MODE  FIELD_MASK(1,18)
#define SYSPORT_TDMA_CONTROL_RING_CFG_M                 FIELD_MASK(1,19)
#define SYSPORT_TDMA_CONTROL_MAX_INFLIGHT_PBUFDMA       FIELD_MASK(5,22)
#define SYSPORT_TDMA_CONTROL_ACB_EN_M                   FIELD_MASK(1,27)
#define SYSPORT_TDMA_CONTROL_CSB_WR_EN                  FIELD_MASK(1,28)
#define SYSPORT_TDMA_CONTROL_TPD_16b_EN                 FIELD_MASK(1,29)

#define SYSPORT_TDMA_DESC_RING_CONTROL_FLUSH_M          FIELD_MASK(1,0)
#define SYSPORT_TDMA_DESC_RING_CONTROL_RING_EN_M        FIELD_MASK(1,1)

#define SYSPORT_TDMA_DESC_RING_INTR_CONTROL_THRESHOLD_S      0
#define SYSPORT_TDMA_DESC_RING_INTR_CONTROL_EMPTY_INTR_EN_M  FIELD_MASK(1,15)
#define SYSPORT_TDMA_DESC_RING_INTR_CONTROL_TIMEOUT_S        16

#define SYSPORT_TDMA_DESC_RING_MAPPING_QID_M            FIELD_MASK(3,0)
#define SYSPORT_TDMA_DESC_RING_MAPPING_QID_S            0
#define SYSPORT_TDMA_DESC_RING_MAPPING_PORT_ID_S        3
#define SYSPORT_TDMA_DESC_RING_MAPPING_IGNORE_STATUS_M  FIELD_MASK(1,6)
#define SYSPORT_TDMA_DESC_RING_MAPPING_CREDIT_S         8

#define SYSTEMPORT_TDMA_ARBITER_MODE_SP           0
#define SYSTEMPORT_TDMA_ARBITER_MODE_RR           1
#define SYSTEMPORT_TDMA_ARBITER_MODE_WRR          2
#define SYSTEMPORT_TDMA_ARBITER_MODE_DRR          3

#define SYSPORT_TDMA_STATUS_TDMA_DISABLED_M       FIELD_MASK(1,0)
#define SYSPORT_TDMA_STATUS_LL_RAM_INIT_BUSY_M    FIELD_MASK(1,1)

#define SYSTEMPORT_TDMA_DDR_DESC_RING_PUSH_TIMER_TIMEOUT_M  FIELD_MASK(16,0)

#define SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL_CREDIT_M             FIELD_MASK(16,4)
#define SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL_CREDIT_S             4
#define SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL_IGNORE_CONGESTION_M  FIELD_MASK(1,2)
#define SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL_IGNORE_CONGESTION_S  2
#define SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL_ARB_MODE_M           FIELD_MASK(2,0)
#define SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL_ARB_MODE_S           0

#define SYSPORT_TDMA_CSB_INTR_CFG_THRESHOLD_M     FIELD_MASK(16,0)
#define SYSPORT_TDMA_CSB_INTR_CFG_THRESHOLD_S     0
#define SYSPORT_TDMA_CSB_INTR_CFG_TIMEOUT_M       FIELD_MASK(16,16)
#define SYSPORT_TDMA_CSB_INTR_CFG_TIMEOUT_S       16

typedef struct sys_port_tdma {
	systemport_tdma_descriptor_write_port SYSTEMPORT_TDMA_DESCRIPTOR_WRITE_PORT[32];
	systemport_tdma_descriptor_read_port  SYSTEMPORT_TDMA_DESCRIPTOR_READ_PORT[32];
#define SYSTEMPORT_TDMA_DESC_RING_CONTROL_RING_EN 0x02
	uint32_t SYSTEMPORT_TDMA_DESC_RING_CONTROL[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_HEAD_TAIL_PTR[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_COUNT[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_MAX_THRESHOLD[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_INTR_CONTROL[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_PRODUCER_CONSUMER_INDEX[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_MAPPING[32];
	uint32_t SYSTEMPORT_TDMA_DESC_RING_PCP_DEI_VID[32];
	uint32_t SYSTEMPORT_TDMA_DDR_DESC_RING_START[64];
	uint32_t SYSTEMPORT_TDMA_DDR_DESC_RING_SIZE[32];
	uint32_t SYSTEMPORT_TDMA_DDR_DESC_RING_CTRL[32];
	uint32_t SYSTEMPORT_TDMA_DDR_DESC_RING_PUSH_TIMER[32];
#if defined(CONFIG_BCM6756)
	uint32_t SYSTEMPORT_TDMA_LS_CFG[32];
#endif
	uint32_t SYSTEMPORT_TDMA_DESC_READ_CMD;
	uint32_t SYSTEMPORT_TDMA_CONTROL;
	uint32_t SYSTEMPORT_TDMA_STATUS;
	uint32_t SYSTEMPORT_TDMA_SYSBUS_BURST;
	uint32_t SYSTEMPORT_TDMA_TIER1_ARBITER_CTRL[8];
	uint32_t SYSTEMPORT_TDMA_TIER1_ARBITER_QUEUE_ENABLE[8];
	uint32_t SYSTEMPORT_TDMA_TIER2_ARBITER_CTRL;
	uint32_t SYSTEMPORT_TDMA_OVER_MAX_THRESHOLD_STATUS;
	uint32_t SYSTEMPORT_TDMA_OVER_HYST_THRESHOLD_STATUS;
	uint32_t SYSTEMPORT_TDMA_TPID;
	uint32_t SYSTEMPORT_TDMA_FREE_LIST_HEAD_TAIL_PTR;
	uint32_t SYSTEMPORT_TDMA_FREE_LIST_COUNT;
	uint32_t SYSTEMPORT_TDMA_CSB_INTR_CFG;
	uint32_t SYSTEMPORT_TDMA_CSB_ADDR_LO;
	uint32_t SYSTEMPORT_TDMA_CSB_ADDR_HI;

#if defined(CONFIG_BCM6756)
	uint32_t SYSTEMPORT_TDMA_MPM_CFG;
	uint32_t SYSTEMPORT_TDMA_RRING_PRODUCER_INDEX;
	uint32_t SYSTEMPORT_TDMA_RRING_CONSUMER_INDEX;
	uint32_t SYSTEMPORT_TDMA_RRING_ADDR_LO;
	uint32_t SYSTEMPORT_TDMA_RRING_ADDR_HI;
	uint32_t SYSTEMPORT_TDMA_RRING_SIZE;
	uint32_t SYSTEMPORT_TDMA_RRING_BURST_CTRL;
	uint32_t SYSTEMPORT_TDMA_RRING_WR_PUSH_TIMER;
	uint32_t SYSTEMPORT_TDMA_RRING_CTRL;
	uint32_t SYSTEMPORT_TDMA_RRING_INTR_CFG;
	uint32_t SYSTEMPORT_TDMA_LS_ETHERTYPE;
#endif
	uint32_t SYSTEMPORT_TDMA_TEST;
	uint32_t SYSTEMPORT_TDMA_DEBUG;

#if defined(CONFIG_BCM6756)
	uint32_t SYSTEMPORT_TDMA_RRING_BP_COUNT;
#endif
}sys_port_tdma, SYSTEMPORT_TDMA;

typedef struct sys_port_gib {
#define SYSPORT_GIB_CONTROL_RX_EN 0x02
#define SYSPORT_GIB_CONTROL_TX_EN 0x01
#define SYSPORT_GIB_CONTROL_RX_FLUSH 0x08
#define SYSPORT_GIB_CONTROL_TX_FLUSH 0x04
	uint32_t SYSTEMPORT_GIB_CONTROL;
	uint32_t SYSTEMPORT_GIB_STATUS;
	uint32_t SYSTEMPORT_GIB_MAC_DA_1;
	uint32_t SYSTEMPORT_GIB_MAC_DA_0;
	uint32_t SYSTEMPORT_GIB_RCVD_PKT_ERR_CNT;
	uint32_t SYSTEMPORT_GIB_PKT_SIZE_CONTROL;
} sys_port_gib, SYSTEMPORT_GIB;


typedef struct sys_port_umac {
	uint32_t SYSTEMPORT_UMAC_UMAC_DUMMY;
	uint32_t SYSTEMPORT_UMAC_HD_BKP_CNTL;             //0x804
#define SYSPORT_UNIMAC_COMMAND_CONFIG_ENA_EXT_CONFIG        FIELD_MASK(1,22)
#define SYSPORT_UNIMAC_COMMAND_CONFIG_RX_EN 0x02
#define SYSPORT_UNIMAC_COMMAND_CONFIG_TX_EN 0x01
	uint32_t SYSTEMPORT_UMAC_CMD;
}sys_port_umac;
