// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (c) 2013 Broadcom
 */
/*
     
*/             

#ifndef __BPM_H_INCLUDED
#define __BPM_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:54:33   */

#include "access_macros.h"
#include "packing.h"
#include "rdp_map.h"

/*****************************************************************************************/
/* BPM module is resposible for DDR buffers pool managment. Total there are 15K buffers  */
/* (BNs). BPM module has an interface with Broad Bus handlers of Ethernet MACs (0-4), GP */
/* ON, Runner A, Runner B, MIPS-C and MIPS-D.                                            */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define BPM_MODULE_REGS_OFFSET 	( 0x00000000 )
#define BPM_MODULE_REGS_ADDRESS	( BPM_MODULE_OFFSET + BPM_MODULE_REGS_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* Request_pointer                                                                       */
/* CPU request a free pointer from BPM by WRITE tp ptr_req (data pattern is not importan */
/* t)  BPM in its turn will de assert bit req indicating that a valid pointer is ready f */
/* or cpu usage  (see ptr bits description). This register returns to default values by  */
/* soft reset.                                                                           */
/*****************************************************************************************/

#define BPM_MODULE_REGS_REQ_PTR_RDY_NOT_READY_VALUE                                          ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_RDY_NOT_READY_VALUE_RESET_VALUE                              ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_RDY_READY_VALUE                                              ( 0x1 )
#define BPM_MODULE_REGS_REQ_PTR_BSY_NOT_BUSY_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_BSY_NOT_BUSY_VALUE_RESET_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_BSY_BUSY_VALUE                                               ( 0x1 )
#define BPM_MODULE_REGS_REQ_PTR_RSV_RSV_VALUE                                                ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_RSV_RSV_VALUE_RESET_VALUE                                    ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_SP_ADDR_SOURCE_ADRESS_OF_PORT_FOR_BN_ALLOC_VALUE             ( 0x6 )
#define BPM_MODULE_REGS_REQ_PTR_SP_ADDR_SOURCE_ADRESS_OF_PORT_FOR_BN_ALLOC_VALUE_RESET_VALUE ( 0x6 )
#define BPM_MODULE_REGS_REQ_PTR_NACK_STATUS_CPU_IN_ACK_STATE_VALUE                           ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_NACK_STATUS_CPU_IN_ACK_STATE_VALUE_RESET_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_NACK_STATUS_CPU_IN_NACK_STATE_VALUE                          ( 0x1 )
#define BPM_MODULE_REGS_REQ_PTR_BN_RSV_VALUE                                                 ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_BN_RSV_VALUE_RESET_VALUE                                     ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_BN_VALID_NOT_VALID_VALUE                                     ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_BN_VALID_NOT_VALID_VALUE_RESET_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_REQ_PTR_BN_VALID_VALID_VALUE                                         ( 0x1 )


#define BPM_MODULE_REGS_REQ_PTR_OFFSET ( 0x00000000 )

#define BPM_MODULE_REGS_REQ_PTR_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_REQ_PTR_OFFSET )
#define BPM_MODULE_REGS_REQ_PTR_READ( r ) 	READ_32( ( BPM_MODULE_REGS_REQ_PTR_ADDRESS ), (r) )
#define BPM_MODULE_REGS_REQ_PTR_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_REQ_PTR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Ready_bit_for_Alloc_request */
	uint32_t rdy        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Busy_bit_for_Alloc_request */
	uint32_t bsy        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* nack_status */
	uint32_t nack_status	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* source_port_address */
	uint32_t sp_addr    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bufer_number */
	uint32_t bn         	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* bufer_number_valid */
	uint32_t bn_valid   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_REQ_PTR ;
#else
typedef struct
	/* bufer_number_valid */
{	uint32_t bn_valid   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* bufer_number_valid */

	uint32_t bn         	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* bufer_number */

	uint32_t sp_addr    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* source_port_address */

	uint32_t nack_status	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* nack_status */

	uint32_t rsv        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* rsv */

	uint32_t bsy        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* Busy_bit_for_Alloc_request */

	uint32_t rdy        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	/* Ready_bit_for_Alloc_request */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_REQ_PTR ;
#endif

/*****************************************************************************************/
/* Free_pointer                                                                          */
/* Free buffer pointer from cpu to bpm. When cpu requests bmp to release an occupied poi */
/* nter, it WRITes ro free_ptrt reg. Once the buffer is free, bpm will de assert the REA */
/* DY bi and de-assert BUSY bit, indicating completion of the free process.   This regis */
/* ter returns to default values by soft reset.                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_FREE_PTR_RDY_VALUE_ON_POWER_OR_REQUEST__IN_PROGRESS_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_RDY_VALUE_ON_POWER_OR_REQUEST__IN_PROGRESS_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_RDY_REQUEST_NOT_IN_PROGRESS_VALUE                            ( 0x1 )
#define BPM_MODULE_REGS_FREE_PTR_BSY_REQUEST_NOT__IN_PROGRESS_VALUE                           ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_BSY_REQUEST_NOT__IN_PROGRESS_VALUE_RESET_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_BSY_REQUEST__IN_PROGRESS_VALUE                               ( 0x1 )
#define BPM_MODULE_REGS_FREE_PTR_RSV2_RESERVED_VALUE                                          ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_RSV2_RESERVED_VALUE_RESET_VALUE                              ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_OWN_SA_RESERVED_VALUE                                        ( 0x6 )
#define BPM_MODULE_REGS_FREE_PTR_OWN_SA_RESERVED_VALUE_RESET_VALUE                            ( 0x6 )
#define BPM_MODULE_REGS_FREE_PTR_RSV1_RESERVED_VALUE                                          ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_RSV1_RESERVED_VALUE_RESET_VALUE                              ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_BN_POINTER_ADDRESS_VALUE                                     ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_BN_POINTER_ADDRESS_VALUE_RESET_VALUE                         ( 0x0 )


#define BPM_MODULE_REGS_FREE_PTR_OFFSET ( 0x00000004 )

#define BPM_MODULE_REGS_FREE_PTR_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_FREE_PTR_OFFSET )
#define BPM_MODULE_REGS_FREE_PTR_READ( r ) 	READ_32( ( BPM_MODULE_REGS_FREE_PTR_ADDRESS ), (r) )
#define BPM_MODULE_REGS_FREE_PTR_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_FREE_PTR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ready */
	uint32_t rdy   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t bsy   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2  	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Owner_Source_Address_of_BN */
	uint32_t own_sa	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bufer_Number */
	uint32_t bn    	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_FREE_PTR ;
#else
typedef struct
{	uint32_t bn    	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bufer_Number */
	uint32_t rsv1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t own_sa	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Owner_Source_Address_of_BN */
	uint32_t rsv2  	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t bsy   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ready */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_FREE_PTR ;
#endif

/*****************************************************************************************/
/* Multi_Cast_Counter_set_for_pointer                                                    */
/* MCNT request pointer from cpu to bpm. When cpu requests bmp to set MCNT an occupied p */
/* ointer, it will set bit req. Once the MCNT of  buffer is set, bpm will de assert the  */
/* bit request, indicating completion of the MCNT setting  process.   This register retu */
/* rns to default values by soft reset.                                                  */
/*****************************************************************************************/

#define BPM_MODULE_REGS_MCNT_PTR_RDY_REQUEST_IN_PROGRESS_OR_POWER_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_RDY_REQUEST_IN_PROGRESS_OR_POWER_RESET_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_RDY_REQUEST_IS_NOT_IN_PROGRESS_VALUE                     ( 0x1 )
#define BPM_MODULE_REGS_MCNT_PTR_BSY_REQUEST_IS_NOT_PROGRESS_VALUE                        ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_BSY_REQUEST_IS_NOT_PROGRESS_VALUE_RESET_VALUE            ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_BSY_REQUEST_IN_PROGRESS_VALUE                            ( 0x1 )
#define BPM_MODULE_REGS_MCNT_PTR_RSV2_RSV_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_RSV2_RSV_VALUE_RESET_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_MCNT_RSV_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_MCNT_RSV_VALUE_RESET_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_RSV1_RSV_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_RSV1_RSV_VALUE_RESET_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_BN_RDY_DEFUALT_VALUE_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_BN_RDY_DEFUALT_VALUE_VALUE_RESET_VALUE                   ( 0x0 )


#define BPM_MODULE_REGS_MCNT_PTR_OFFSET ( 0x00000008 )

#define BPM_MODULE_REGS_MCNT_PTR_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_MCNT_PTR_OFFSET )
#define BPM_MODULE_REGS_MCNT_PTR_READ( r ) 	READ_32( ( BPM_MODULE_REGS_MCNT_PTR_ADDRESS ), (r) )
#define BPM_MODULE_REGS_MCNT_PTR_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_MCNT_PTR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ready */
	uint32_t rdy 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t bsy 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT */
	uint32_t mcnt	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t rsv1	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bufer_Number */
	uint32_t bn  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_MCNT_PTR ;
#else
typedef struct
{	uint32_t bn  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Bufer_Number */
	uint32_t rsv1	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv1 */
	uint32_t mcnt	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT */
	uint32_t rsv2	: 11 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t bsy 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ready */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_MCNT_PTR ;
#endif

/*****************************************************************************************/
/* Init_of_BPM_Core_RAMs                                                                 */
/* Init RAMs request. When cpu requests bmp to init RAMSr, it will WRITE to ram_init reg */
/* ister (pattern is not important). Once the RAMs are initilizied, bpm will de assert t */
/* he busy bit (BSY) and will assrt ready bit (RDY), indicating completion of the init R */
/* AM  process.   This register returns to default values by TM  reset.                  */
/*****************************************************************************************/

#define BPM_MODULE_REGS_RAM_INIT_RDY_NON_BUSY_VALUE              ( 0x0 )
#define BPM_MODULE_REGS_RAM_INIT_RDY_NON_BUSY_VALUE_RESET_VALUE  ( 0x0 )
#define BPM_MODULE_REGS_RAM_INIT_RDY_BUSY_VALUE                  ( 0x1 )
#define BPM_MODULE_REGS_RAM_INIT_BSY_NOT_READY_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_RAM_INIT_BSY_NOT_READY_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_RAM_INIT_BSY_READY_VALUE                 ( 0x1 )
#define BPM_MODULE_REGS_RAM_INIT_RSV_RSV_VALUE                   ( 0x0 )
#define BPM_MODULE_REGS_RAM_INIT_RSV_RSV_VALUE_RESET_VALUE       ( 0x0 )


#define BPM_MODULE_REGS_RAM_INIT_OFFSET ( 0x0000000C )

#define BPM_MODULE_REGS_RAM_INIT_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_RAM_INIT_OFFSET )
#define BPM_MODULE_REGS_RAM_INIT_READ( r ) 	READ_32( ( BPM_MODULE_REGS_RAM_INIT_ADDRESS ), (r) )
#define BPM_MODULE_REGS_RAM_INIT_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_RAM_INIT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ready */
	uint32_t rdy	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t bsy	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_RAM_INIT ;
#else
typedef struct
{	uint32_t rsv	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t bsy	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* busy */
	uint32_t rdy	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ready */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_RAM_INIT ;
#endif

/*****************************************************************************************/
/* free_pointer_interrupt                                                                */
/* Free pointer interrupt indication and pointer number will hold untill read clear by S */
/* W.  This happen if there is a pointer that is already in bpm hand but some user want  */
/* to free it again                                                                      */
/*****************************************************************************************/

#define BPM_MODULE_REGS_FREE_PTR_INT_RSV_DEFUALT_VALUE_VALUE                 ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_INT_RSV_DEFUALT_VALUE_VALUE_RESET_VALUE     ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_INT_INTSP_SOURCE_PORT_IRQ_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_INT_INTSP_SOURCE_PORT_IRQ_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_INT_PTRNUM_DEFUALT_VALUE_VALUE              ( 0x0 )
#define BPM_MODULE_REGS_FREE_PTR_INT_PTRNUM_DEFUALT_VALUE_VALUE_RESET_VALUE  ( 0x0 )


#define BPM_MODULE_REGS_FREE_PTR_INT_OFFSET ( 0x00000010 )

#define BPM_MODULE_REGS_FREE_PTR_INT_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_FREE_PTR_INT_OFFSET )
#define BPM_MODULE_REGS_FREE_PTR_INT_READ( r ) 	READ_32( ( BPM_MODULE_REGS_FREE_PTR_INT_ADDRESS ), (r) )
#define BPM_MODULE_REGS_FREE_PTR_INT_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_FREE_PTR_INT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t rsv   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_Port_IRQ */
	uint32_t intsp 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pointer_number */
	uint32_t ptrnum	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_FREE_PTR_INT ;
#else
typedef struct
{	uint32_t ptrnum	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pointer_number */
	uint32_t intsp 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_Port_IRQ */
	uint32_t rsv   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_FREE_PTR_INT ;
#endif

/*****************************************************************************************/
/* Read_ram_address                                                                      */
/* If CPU wants to read data from one of RAMs, it has to indicate in the register the RA */
/* M number out of 6 RAMs and the address. Issue a req and when data is ready the bit wi */
/* ll go down.    Address field in the selected RAM. Each RAM includes 80 rows. In order */
/*  to re-create BN from the RAM data there is an convention procedure: (1) 5-lowest bit */
/* s in BN says where BN is located in row (2) 7-middle bits says location of row in RAM */
/* , in order to convert middle field of BN from 7-bit row location, please refer to Lil */
/* ac issue 916 in Bugzilla. (3) 3-highest bits say which memory is used for BN storage  */
/*****************************************************************************************/

#define BPM_MODULE_REGS_READ_RAM_ADDR_REQ_DEFUALT_VALUE_VALUE                 ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_REQ_DEFUALT_VALUE_VALUE_RESET_VALUE     ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_RSV_RSV_VALUE                           ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_RSV_RSV_VALUE_RESET_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_SELRAM_DEFUALT_VALUE_VALUE              ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_SELRAM_DEFUALT_VALUE_VALUE_RESET_VALUE  ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_RAMADDR_DEFUALT_VALUE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_ADDR_RAMADDR_DEFUALT_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_READ_RAM_ADDR_OFFSET ( 0x00000014 )

#define BPM_MODULE_REGS_READ_RAM_ADDR_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_READ_RAM_ADDR_OFFSET )
#define BPM_MODULE_REGS_READ_RAM_ADDR_READ( r ) 	READ_32( ( BPM_MODULE_REGS_READ_RAM_ADDR_ADDRESS ), (r) )
#define BPM_MODULE_REGS_READ_RAM_ADDR_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_READ_RAM_ADDR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* req_read */
	uint32_t req    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv    	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* select_1_ram_out_of_6 */
	uint32_t selram 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ram_addr */
	uint32_t ramaddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_ADDR ;
#else
typedef struct
{	uint32_t ramaddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ram_addr */
	uint32_t selram 	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* select_1_ram_out_of_6 */
	uint32_t rsv    	: 21 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t req    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* req_read */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_ADDR ;
#endif

/*****************************************************************************************/
/* MCNT_pointer_interrupt                                                                */
/* MCNT pointer interrupt indication and pointer number will hold untill read clear by s */
/* w.  This happen if there is a pointer that is already in bpm hand but some user want  */
/* to free it again                                                                      */
/*****************************************************************************************/

#define BPM_MODULE_REGS_MCNT_PTR_INT_RSV_DEFUALT_VALUE_VALUE                 ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_INT_RSV_DEFUALT_VALUE_VALUE_RESET_VALUE     ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_INT_INTSP_IRQ_SOURCE_PORT_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_INT_INTSP_IRQ_SOURCE_PORT_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_INT_PTRNUM_DEFUALT_VALUE_VALUE              ( 0x0 )
#define BPM_MODULE_REGS_MCNT_PTR_INT_PTRNUM_DEFUALT_VALUE_VALUE_RESET_VALUE  ( 0x0 )


#define BPM_MODULE_REGS_MCNT_PTR_INT_OFFSET ( 0x00000018 )

#define BPM_MODULE_REGS_MCNT_PTR_INT_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_MCNT_PTR_INT_OFFSET )
#define BPM_MODULE_REGS_MCNT_PTR_INT_READ( r ) 	READ_32( ( BPM_MODULE_REGS_MCNT_PTR_INT_ADDRESS ), (r) )
#define BPM_MODULE_REGS_MCNT_PTR_INT_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_MCNT_PTR_INT_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IRQ_Source_Port */
	uint32_t intsp 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pointer_number */
	uint32_t ptrnum	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_MCNT_PTR_INT ;
#else
typedef struct
{	uint32_t ptrnum	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pointer_number */
	uint32_t intsp 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IRQ_Source_Port */
	uint32_t rsv   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_MCNT_PTR_INT ;
#endif

/*****************************************************************************************/
/* read_ram_data0                                                                        */
/* Read RAM data after a read ram bits 31-0 req                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_READ_RAM_DATA0_DATA_DEFUALT_VALUE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_DATA0_DATA_DEFUALT_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_READ_RAM_DATA0_OFFSET ( 0x0000001C )

#define BPM_MODULE_REGS_READ_RAM_DATA0_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_READ_RAM_DATA0_OFFSET )
#define BPM_MODULE_REGS_READ_RAM_DATA0_READ( r ) 	READ_32( ( BPM_MODULE_REGS_READ_RAM_DATA0_ADDRESS ), (r) )
#define BPM_MODULE_REGS_READ_RAM_DATA0_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_READ_RAM_DATA0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data */
	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_DATA0 ;
#else
typedef struct
{	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_DATA0 ;
#endif

/*****************************************************************************************/
/* read_ram_data1                                                                        */
/* Read RAM data after a read ram bits 63-32 req                                         */
/*****************************************************************************************/

#define BPM_MODULE_REGS_READ_RAM_DATA1_DATA_DEFUALT_VALUE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_DATA1_DATA_DEFUALT_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_READ_RAM_DATA1_OFFSET ( 0x00000020 )

#define BPM_MODULE_REGS_READ_RAM_DATA1_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_READ_RAM_DATA1_OFFSET )
#define BPM_MODULE_REGS_READ_RAM_DATA1_READ( r ) 	READ_32( ( BPM_MODULE_REGS_READ_RAM_DATA1_ADDRESS ), (r) )
#define BPM_MODULE_REGS_READ_RAM_DATA1_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_READ_RAM_DATA1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data */
	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_DATA1 ;
#else
typedef struct
{	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_DATA1 ;
#endif

/*****************************************************************************************/
/* read_ram_data2                                                                        */
/* Read RAM data after a read ram bits 96-64 req                                         */
/*****************************************************************************************/

#define BPM_MODULE_REGS_READ_RAM_DATA2_DATA_DEFUALT_VALUE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_READ_RAM_DATA2_DATA_DEFUALT_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_READ_RAM_DATA2_OFFSET ( 0x00000024 )

#define BPM_MODULE_REGS_READ_RAM_DATA2_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_READ_RAM_DATA2_OFFSET )
#define BPM_MODULE_REGS_READ_RAM_DATA2_READ( r ) 	READ_32( ( BPM_MODULE_REGS_READ_RAM_DATA2_ADDRESS ), (r) )
#define BPM_MODULE_REGS_READ_RAM_DATA2_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_READ_RAM_DATA2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data */
	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_DATA2 ;
#else
typedef struct
{	uint32_t data	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_READ_RAM_DATA2 ;
#endif

/*****************************************************************************************/
/* Source_Port_enable                                                                    */
/* Source Ports Enable                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_SP_EN_RSV_RSV_VALUE                                 ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_RSV_RSV_VALUE_RESET_VALUE                     ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC4_EN_EMAC4_SP_DISABLE_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC4_EN_EMAC4_SP_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC4_EN_EMAC4_SP_ENABLE_VALUE                ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC3_EN_EMAC3_SP_DISABLE_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC3_EN_EMAC3_SP_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC3_EN_EMAC3_SP_ENABLE_VALUE                ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC2_EN_EMAC2_SP_DISABLE_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC2_EN_EMAC2_SP_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC2_EN_EMAC2_SP_ENABLE_VALUE                ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC1_EN_EMAC1_SP_DISABLE_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC1_EN_EMAC1_SP_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC1_EN_EMAC1_SP_ENABLE_VALUE                ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC0_EN_EMAC0_SP_DISABLE_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC0_EN_EMAC0_SP_DISABLE_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_EMAC0_EN_EMAC0_SP_ENABLE_VALUE                ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_GPON_EN_GPON_SP_DISABLE_VALUE                 ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_GPON_EN_GPON_SP_DISABLE_VALUE_RESET_VALUE     ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_GPON_EN_GPON_SP_ENABLE_VALUE                  ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_RNRB_EN_RUNNER_B_SP_DISABLE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_RNRB_EN_RUNNER_B_SP_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_RNRB_EN_RUNNER_B_SP_ENABLE_VALUE              ( 0x1 )
#define BPM_MODULE_REGS_BPM_SP_EN_RNRA_EN_RUNNER_A_DISABLE_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_RNRA_EN_RUNNER_A_DISABLE_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_SP_EN_RNRA_EN_RUNNER_A__ENABLE_VALUE                ( 0x1 )


#define BPM_MODULE_REGS_BPM_SP_EN_OFFSET ( 0x00000028 )

#define BPM_MODULE_REGS_BPM_SP_EN_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_SP_EN_OFFSET )
#define BPM_MODULE_REGS_BPM_SP_EN_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_SP_EN_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_SP_EN_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_SP_EN_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv     	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC4_SP_EN */
	uint32_t emac4_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC3_SP_EN */
	uint32_t emac3_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC2_SP_EN */
	uint32_t emac2_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1_SP_EN */
	uint32_t emac1_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC0_SP_EN */
	uint32_t emac0_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_SP_EN */
	uint32_t gpon_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_B_SP_EN */
	uint32_t rnrb_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_A_SP_EN */
	uint32_t rnra_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_SP_EN ;
#else
typedef struct
{	uint32_t rnra_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_A_SP_EN */
	uint32_t rnrb_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_B_SP_EN */
	uint32_t gpon_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_SP_EN */
	uint32_t emac0_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC0_SP_EN */
	uint32_t emac1_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1_SP_EN */
	uint32_t emac2_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC2_SP_EN */
	uint32_t emac3_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC3_SP_EN */
	uint32_t emac4_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC4_SP_EN */
	uint32_t rsv     	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_SP_EN ;
#endif

/*****************************************************************************************/
/* Global_Threshold                                                                      */
/* Global Threshold for Allocated Buffers. There are 6 options: 1K, 2K,3k 6K buffers.   */
/* BPM will issue BN in the accepted range upon to Global threshold setup.  Ths register */
/*  also holds global hysteresis value for ACK/NACK transition setting                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_GL_TRSH_RSV2_RSV_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                   ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAH_GL_BAH_VALUE                          ( 0x400 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAH_GL_BAH_VALUE_RESET_VALUE              ( 0x400 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_RSV_RSV_VALUE                                ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_RSV_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_2P5K_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_5K_VALUE             ( 0x1 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_5K_VALUE_RESET_VALUE ( 0x1 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_7P5K_VALUE           ( 0x2 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_10K_VALUE            ( 0x3 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_12P5K_VALUE          ( 0x4 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_15K_VALUE            ( 0x5 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_17p5K_VALUE          ( 0x6 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_20K_VALUE            ( 0x7 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_22p5K_VALUE          ( 0x8 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_25K_VALUE            ( 0x9 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_27p5K_VALUE          ( 0xA )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_GLOBAL_THRESHOLD_30K_VALUE            ( 0xB )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_RSV1_VALUE                            ( 0x6 )
#define BPM_MODULE_REGS_BPM_GL_TRSH_GL_BAT_RSV_VALUE                             ( 0x7 )


#define BPM_MODULE_REGS_BPM_GL_TRSH_OFFSET ( 0x0000002C )

#define BPM_MODULE_REGS_BPM_GL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_GL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_GL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_GL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_GL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_GL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAH */
	uint32_t gl_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAT */
	uint32_t gl_bat	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_GL_TRSH ;
#else
typedef struct
{	uint32_t gl_bat	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAT */
	uint32_t rsv   	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t gl_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GL_BAH */
	uint32_t rsv2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_GL_TRSH ;
#endif

/*****************************************************************************************/
/* UG0_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG0  Ths register also holds UG0 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG0_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG0_TRSH_OFFSET ( 0x00000030 )

#define BPM_MODULE_REGS_BPM_UG0_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG0_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG0_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG0_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG0_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG0_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG0_TRSH ;
#endif

/*****************************************************************************************/
/* UG1_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG1  Ths register also holds UG1 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG1_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG1_TRSH_OFFSET ( 0x00000034 )

#define BPM_MODULE_REGS_BPM_UG1_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG1_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG1_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG1_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG1_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG1_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG1_TRSH ;
#endif

/*****************************************************************************************/
/* UG2_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG2  Ths register also holds UG2 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG2_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG2_TRSH_OFFSET ( 0x00000038 )

#define BPM_MODULE_REGS_BPM_UG2_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG2_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG2_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG2_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG2_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG2_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG2_TRSH ;
#endif

/*****************************************************************************************/
/* UG3_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG3  Ths register also holds UG3 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG3_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG3_TRSH_OFFSET ( 0x0000003C )

#define BPM_MODULE_REGS_BPM_UG3_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG3_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG3_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG3_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG3_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG3_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG3_TRSH ;
#endif

/*****************************************************************************************/
/* UG4_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG4  Ths register also holds UG4 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG4_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG4_TRSH_OFFSET ( 0x00000040 )

#define BPM_MODULE_REGS_BPM_UG4_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG4_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG4_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG4_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG4_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG4_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG4_TRSH ;
#endif

/*****************************************************************************************/
/* UG5_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG5  Ths register also holds UG5 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG5_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG5_TRSH_OFFSET ( 0x00000044 )

#define BPM_MODULE_REGS_BPM_UG5_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG5_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG5_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG5_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG5_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG5_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG5_TRSH ;
#endif

/*****************************************************************************************/
/* UG6_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG6  Ths register also holds UG6 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG6_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG6_TRSH_OFFSET ( 0x00000048 )

#define BPM_MODULE_REGS_BPM_UG6_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG6_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG6_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG6_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG6_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG6_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG6_TRSH ;
#endif

/*****************************************************************************************/
/* UG7_Threshold                                                                         */
/* Threshold for Allocated Buffers of UG7  Ths register also holds UG7 hysteresis value  */
/* for ACK/NACK transition setting                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG7_TRSH_RSV2_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_RSV2_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_UG0_BAH_BAH_VALUE             ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_UG0_BAH_BAH_VALUE_RESET_VALUE ( 0x200 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_RSV_RSV1_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_RSV_RSV1_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_UG0_BAT_BAT_VALUE             ( 0x1400 )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_UG0_BAT_BAT_VALUE_RESET_VALUE ( 0x1400 )


#define BPM_MODULE_REGS_BPM_UG7_TRSH_OFFSET ( 0x0000004C )

#define BPM_MODULE_REGS_BPM_UG7_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG7_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG7_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG7_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG7_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG7_TRSH ;
#else
typedef struct
{	uint32_t ug0_bat	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAT */
	uint32_t rsv    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t ug0_bah	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAH */
	uint32_t rsv2   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG7_TRSH ;
#endif

/*****************************************************************************************/
/* BPM_UG_MAP_R0                                                                         */
/* This register is using for mapping of following Source Ports to UG07:  -CPU (or MIPS */
/* C)  -Runner A  -Runner B  -GPON MAC  -Eth0-3 MAC                                      */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC3_EMAC3_MAP_VALUE             ( 0x7 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC3_EMAC3_MAP_VALUE_RESET_VALUE ( 0x7 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC2_EMAC2_MAP_VALUE             ( 0x6 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC2_EMAC2_MAP_VALUE_RESET_VALUE ( 0x6 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC1_EMAC1_MAP_VALUE             ( 0x5 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC1_EMAC1_MAP_VALUE_RESET_VALUE ( 0x5 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC0_EMAC0_MAP_VALUE             ( 0x4 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_EMAC0_EMAC0_MAP_VALUE_RESET_VALUE ( 0x4 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_GPON_GPON_MAP_VALUE               ( 0x3 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_GPON_GPON_MAP_VALUE_RESET_VALUE   ( 0x3 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_RNR_B_RNR_B_MAP_VALUE             ( 0x2 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_RNR_B_RNR_B_MAP_VALUE_RESET_VALUE ( 0x2 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_RNR_A_RNR_A_MAP_VALUE             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_RNR_A_RNR_A_MAP_VALUE_RESET_VALUE ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_CPU__CPU_MAP_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_CPU__CPU_MAP_VALUE_RESET_VALUE    ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG_MAP_R0_OFFSET ( 0x00000050 )

#define BPM_MODULE_REGS_BPM_UG_MAP_R0_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG_MAP_R0_OFFSET )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG_MAP_R0_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG_MAP_R0_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG_MAP_R0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* EMAC3_mapping */
	uint32_t emac3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC2_mapping */
	uint32_t emac2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1_mapping */
	uint32_t emac1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC0_mapping */
	uint32_t emac0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_mapping */
	uint32_t gpon 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_B_mapping */
	uint32_t rnr_b	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_A_mapping */
	uint32_t rnr_a	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CPU_mapping */
	uint32_t cpu_ 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG_MAP_R0 ;
#else
typedef struct
{	uint32_t cpu_ 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CPU_mapping */
	uint32_t rnr_a	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_A_mapping */
	uint32_t rnr_b	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_B_mapping */
	uint32_t gpon 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_mapping */
	uint32_t emac0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC0_mapping */
	uint32_t emac1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC1_mapping */
	uint32_t emac2	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC2_mapping */
	uint32_t emac3	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC3_mapping */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG_MAP_R0 ;
#endif

/*****************************************************************************************/
/* BPM_dbg                                                                               */
/* BPM select the debug bus                                                              */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_DBG_RSV_RSV_VALUE                           ( 0x0 )
#define BPM_MODULE_REGS_BPM_DBG_RSV_RSV_VALUE_RESET_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_DBG_SEL_DBG_DEFUALT_VALUE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_DBG_SEL_DBG_DEFUALT_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_DBG_OFFSET ( 0x00000054 )

#define BPM_MODULE_REGS_BPM_DBG_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_DBG_OFFSET )
#define BPM_MODULE_REGS_BPM_DBG_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_DBG_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_DBG_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_DBG_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* select */
	uint32_t sel	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_DBG ;
#else
typedef struct
{	uint32_t sel	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* select */
	uint32_t rsv	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_DBG ;
#endif

/*****************************************************************************************/
/* BPM_UG0_BAC                                                                           */
/* BPM UG0 allocated BN counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG0_BAC_RSV_RSV_VALUE                ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_BAC_RSV_RSV_VALUE_RESET_VALUE    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_BAC_UG0BAC_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_BAC_UG0BAC_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG0_BAC_OFFSET ( 0x00000058 )

#define BPM_MODULE_REGS_BPM_UG0_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG0_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG0_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG0_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG0_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG0_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t ug0bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG0_BAC ;
#else
typedef struct
{	uint32_t ug0bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG0_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG1_BAC                                                                           */
/* BPM UG1 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG1_BAC_RSV_RSV_VALUE                   ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_BAC_RSV_RSV_VALUE_RESET_VALUE       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_BAC_UG1BAC_UG1BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_BAC_UG1BAC_UG1BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG1_BAC_OFFSET ( 0x0000005C )

#define BPM_MODULE_REGS_BPM_UG1_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG1_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG1_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG1_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG1_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG1_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t ug1bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG1_BAC ;
#else
typedef struct
{	uint32_t ug1bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG1_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG2_BAC                                                                           */
/* BPM UG2 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG2_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_BAC_UG2BAC_UG2_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_BAC_UG2BAC_UG2_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG2_BAC_OFFSET ( 0x00000060 )

#define BPM_MODULE_REGS_BPM_UG2_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG2_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG2_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG2_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG2_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG2_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t ug2bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG2_BAC ;
#else
typedef struct
{	uint32_t ug2bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG2_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG3_BAC                                                                           */
/* BPM UG3 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG3_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_BAC_UG3BAC_UG3_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_BAC_UG3BAC_UG3_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG3_BAC_OFFSET ( 0x00000064 )

#define BPM_MODULE_REGS_BPM_UG3_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG3_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG3_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG3_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG3_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG3_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_BAC */
	uint32_t ug3bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG3_BAC ;
#else
typedef struct
{	uint32_t ug3bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG3_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG4_BAC                                                                           */
/* BPM UG4 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG4_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_BAC_UG4BAC_UG4_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_BAC_UG4BAC_UG4_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG4_BAC_OFFSET ( 0x00000068 )

#define BPM_MODULE_REGS_BPM_UG4_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG4_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG4_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG4_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG4_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG4_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug4bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG4_BAC ;
#else
typedef struct
{	uint32_t ug4bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG4_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG5_BAC                                                                           */
/* BPM UG5 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG5_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_BAC_UG5BAC_UG5_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_BAC_UG5BAC_UG5_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG5_BAC_OFFSET ( 0x0000006C )

#define BPM_MODULE_REGS_BPM_UG5_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG5_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG5_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG5_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG5_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG5_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug5bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG5_BAC ;
#else
typedef struct
{	uint32_t ug5bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG5_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG6_BAC                                                                           */
/* BPM UG6 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG6_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_BAC_UG6BAC_UG6_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_BAC_UG6BAC_UG6_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG6_BAC_OFFSET ( 0x00000070 )

#define BPM_MODULE_REGS_BPM_UG6_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG6_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG6_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG6_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG6_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG6_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug6bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG6_BAC ;
#else
typedef struct
{	uint32_t ug6bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG6_BAC ;
#endif

/*****************************************************************************************/
/* BPM_UG7_BAC                                                                           */
/* BPM UG7 allocated BN Counter                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG7_BAC_RSV_RSV_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_BAC_RSV_RSV_VALUE_RESET_VALUE        ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_BAC_UG7BAC_UG7_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_BAC_UG7BAC_UG7_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG7_BAC_OFFSET ( 0x00000074 )

#define BPM_MODULE_REGS_BPM_UG7_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG7_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_UG7_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG7_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG7_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG7_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t ug7bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG7_BAC ;
#else
typedef struct
{	uint32_t ug7bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv   	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG7_BAC ;
#endif

/*****************************************************************************************/
/* BPM_GL_BAC                                                                            */
/* BPM global BN Counter                                                                 */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_GL_BAC_RSV_RSV_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_BAC_RSV_RSV_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_BAC_BAC_BAC_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_GL_BAC_BAC_BAC_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_GL_BAC_OFFSET ( 0x00000078 )

#define BPM_MODULE_REGS_BPM_GL_BAC_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_GL_BAC_OFFSET )
#define BPM_MODULE_REGS_BPM_GL_BAC_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_GL_BAC_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_GL_BAC_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_GL_BAC_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_GL_BAC ;
#else
typedef struct
{	uint32_t bac	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BAC */
	uint32_t rsv	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_GL_BAC ;
#endif

/*****************************************************************************************/
/* BPM_route_address_register_0                                                          */
/* BPM route addresses of Runner A/B, GPON RX and EMAC0 RX.   Route address configuratio */
/* n is defined according to topological structure of broad bus                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_RADDR0_RSV4_RSV4_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV4_RSV4_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_EMAC0_RX_RADDR_EMAC0_RX_ROUTE_ADDRESS_VALUE             ( 0x1F )
#define BPM_MODULE_REGS_BPM_RADDR0_EMAC0_RX_RADDR_EMAC0_RX_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x1F )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV3_RSV3_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV3_RSV3_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_GPON_RX_RADDR_GPON_RX_ROUTE_ADDRESS_VALUE               ( 0x1 )
#define BPM_MODULE_REGS_BPM_RADDR0_GPON_RX_RADDR_GPON_RX_ROUTE_ADDRESS_VALUE_RESET_VALUE   ( 0x1 )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV2_RSV_VALUE                                          ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV2_RSV_VALUE_RESET_VALUE                              ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RUNB_RADDR_RUNNER_B_ROUTE_ADDRESS_VALUE                 ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RUNB_RADDR_RUNNER_B_ROUTE_ADDRESS_VALUE_RESET_VALUE     ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV_RSV_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RSV_RSV_VALUE_RESET_VALUE                               ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR0_RUNA_RADDR_RUNNER_A_ROUTE_ADDRESS_VALUE                 ( 0x2 )
#define BPM_MODULE_REGS_BPM_RADDR0_RUNA_RADDR_RUNNER_A_ROUTE_ADDRESS_VALUE_RESET_VALUE     ( 0x2 )


#define BPM_MODULE_REGS_BPM_RADDR0_OFFSET ( 0x00000084 )

#define BPM_MODULE_REGS_BPM_RADDR0_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_RADDR0_OFFSET )
#define BPM_MODULE_REGS_BPM_RADDR0_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_RADDR0_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_RADDR0_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_RADDR0_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv4 */
	uint32_t rsv4          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac0_Rx_route_address */
	uint32_t emac0_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t rsv3          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gpon_Rx_route_address */
	uint32_t gpon_rx_raddr 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t rsv2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_B_route_address */
	uint32_t runb_raddr    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_A_route_address */
	uint32_t runa_raddr    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RADDR0 ;
#else
typedef struct
{	uint32_t runa_raddr    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_A_route_address */
	uint32_t rsv           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t runb_raddr    	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* runner_B_route_address */
	uint32_t rsv2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
	uint32_t gpon_rx_raddr 	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gpon_Rx_route_address */
	uint32_t rsv3          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv3 */
	uint32_t emac0_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac0_Rx_route_address */
	uint32_t rsv4          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv4 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RADDR0 ;
#endif

/*****************************************************************************************/
/* BPM_route_address_register_1                                                          */
/* BPM route addresses of EMAC 1/2/3/4 RX.  Route address configuration is defined accor */
/* ding to topological structure of broad bus                                            */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_RADDR1_RSV4_RSV_VALUE                                                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV4_RSV_VALUE_RESET_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC4_RX_RADDR_EMAC4_RX_ROUTE_ADDRESS_VALUE                          ( 0x11 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC4_RX_RADDR_EMAC4_RX_ROUTE_ADDRESS_VALUE_RESET_VALUE              ( 0x11 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV3_RSV_VALUE                                                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV3_RSV_VALUE_RESET_VALUE                                           ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC3_RX_RADDR_CONFIGURABLE_EMAC3_RX_ROUTE_ADDRESS_VALUE             ( 0x9 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC3_RX_RADDR_CONFIGURABLE_EMAC3_RX_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x9 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV2_RSV2_VALUE                                                      ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV2_RSV2_VALUE_RESET_VALUE                                          ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC2_RX_RADDR_EMAC2_ROUTE_ADDRESS_VALUE                             ( 0x17 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC2_RX_RADDR_EMAC2_ROUTE_ADDRESS_VALUE_RESET_VALUE                 ( 0x17 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV_RSV_VALUE                                                        ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_RSV_RSV_VALUE_RESET_VALUE                                            ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC1_RX_RADDR_EMAC1_ROUTE_ADDRESS_VALUE                             ( 0xF )
#define BPM_MODULE_REGS_BPM_RADDR1_EMAC1_RX_RADDR_EMAC1_ROUTE_ADDRESS_VALUE_RESET_VALUE                 ( 0xF )


#define BPM_MODULE_REGS_BPM_RADDR1_OFFSET ( 0x00000088 )

#define BPM_MODULE_REGS_BPM_RADDR1_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_RADDR1_OFFSET )
#define BPM_MODULE_REGS_BPM_RADDR1_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_RADDR1_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_RADDR1_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_RADDR1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv4          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac4_rx_route_address */
	uint32_t emac4_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv3          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac3_rx_route_address */
	uint32_t emac3_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac2_rx_route_address */
	uint32_t emac2_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac1_rx__route_address */
	uint32_t emac1_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RADDR1 ;
#else
typedef struct
{	uint32_t emac1_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac1_rx__route_address */
	uint32_t rsv           	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t emac2_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac2_rx_route_address */
	uint32_t rsv2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t emac3_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac3_rx_route_address */
	uint32_t rsv3          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t emac4_rx_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* emac4_rx_route_address */
	uint32_t rsv4          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RADDR1 ;
#endif

/*****************************************************************************************/
/* BPM_runner_message_control_register                                                   */
/* BPM runner message control register includes enables for wake-up messages, select con */
/* trol bit for transition message and task numbers for wake-up messages to Runners      */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_MIPSD_RPLY_TN_RSV_VALUE                                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_MIPSD_RPLY_TN_RSV_VALUE_RESET_VALUE                                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_TRANS_WKUP_TN_ASK_NUMBER_FOR_RUNNER_ANB_TRANSITION_WAKEUP_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_TRANS_WKUP_TN_ASK_NUMBER_FOR_RUNNER_ANB_TRANSITION_WAKEUP_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RSV3_RSV_VALUE                                                                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RSV3_RSV_VALUE_RESET_VALUE                                                      ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_B_RPLY_WKUP_TN_TASK_NUMBER_FOR_RUNNER_B_WAKE_UP_ON_REPLY_VALUE              ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_B_RPLY_WKUP_TN_TASK_NUMBER_FOR_RUNNER_B_WAKE_UP_ON_REPLY_VALUE_RESET_VALUE  ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RSV2_RSV_VALUE                                                                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RSV2_RSV_VALUE_RESET_VALUE                                                      ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_A_RPLY_WKUP_TN_TASK_NUMBER_FOR_RUNNER_A_WAKE_UP_ON_REPLY_VALUE              ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_A_RPLY_WKUP_TN_TASK_NUMBER_FOR_RUNNER_A_WAKE_UP_ON_REPLY_VALUE_RESET_VALUE  ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_MIPSD_RPLY_WKUP_EN_REPLY_WAKE_UP_DISABLE_VALUE                                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_MIPSD_RPLY_WKUP_EN_REPLY_WAKE_UP_DISABLE_VALUE_RESET_VALUE                      ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_MIPSD_RPLY_WKUP_EN_REPLY_WAKE_UP_ENABLE_VALUE                                   ( 0x1 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_SEL_TRANS_MSG_TRANSITION_MESSAGE_SELECTED_TO_RUNNER_A_VALUE                 ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_SEL_TRANS_MSG_TRANSITION_MESSAGE_SELECTED_TO_RUNNER_A_VALUE_RESET_VALUE     ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_SEL_TRANS_MSG_TRANSITION_MESSAGE_SELECTED_TO_RUNNER_B_VALUE                 ( 0x1 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_TRANS_WKUP_EN_TRANSITION_WAKE_UP_DISABLE_VALUE                              ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_TRANS_WKUP_EN_TRANSITION_WAKE_UP_DISABLE_VALUE_RESET_VALUE                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_TRANS_WKUP_EN_TRANSITION_WAKE_UP_ENABLE_VALUE                               ( 0x1 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_RPLY_WKUP_EN_REPLY_WAKE_UP_DISABLE_VALUE                                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_RPLY_WKUP_EN_REPLY_WAKE_UP_DISABLE_VALUE_RESET_VALUE                        ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_RNR_RPLY_WKUP_EN_REPLY_WAKE_UP_ENABLE_VALUE                                     ( 0x1 )


#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_OFFSET ( 0x0000008C )

#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_OFFSET )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_RNR_MSG_CTRL_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MIPSD_RPLY_TN */
	uint32_t mipsd_rply_tn     	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_Number_for_Runner_Transition_WakeUp */
	uint32_t rnr_trans_wkup_tn 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv3              	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_Number_for_Runner_B_Wake_Up_on_Reply */
	uint32_t rnr_b_rply_wkup_tn	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv2              	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_Number_for_Runner_A_Wake_Up_on_Reply */
	uint32_t rnr_a_rply_wkup_tn	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_Reply_Wake_Up_enable */
	uint32_t mipsd_rply_wkup_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_Selector_for_Transition_Message */
	uint32_t rnr_sel_trans_msg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_Transition_Wake_Up_enable */
	uint32_t rnr_trans_wkup_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_Reply_Wake_Up_enable */
	uint32_t rnr_rply_wkup_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RNR_MSG_CTRL ;
#else
typedef struct
{	uint32_t rnr_rply_wkup_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_Reply_Wake_Up_enable */
	uint32_t rnr_trans_wkup_en 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_Transition_Wake_Up_enable */
	uint32_t rnr_sel_trans_msg 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RNR_Selector_for_Transition_Message */
	uint32_t mipsd_rply_wkup_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_Reply_Wake_Up_enable */
	uint32_t rnr_a_rply_wkup_tn	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_Number_for_Runner_A_Wake_Up_on_Reply */
	uint32_t rsv2              	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rnr_b_rply_wkup_tn	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_Number_for_Runner_B_Wake_Up_on_Reply */
	uint32_t rsv3              	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rnr_trans_wkup_tn 	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Task_Number_for_Runner_Transition_WakeUp */
	uint32_t mipsd_rply_tn     	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_RPLY_TN */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RNR_MSG_CTRL ;
#endif

/*****************************************************************************************/
/* Runner_Target_address_for_Reply_message                                               */
/* Runner Target address for Reply message as results of Alloc request from Runner. The  */
/* register is separeted to two fields: for runner A and B                               */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_RNR_B_TA_TARGET_ADDRESS_FOR_RUNNER_B_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_RNR_B_TA_TARGET_ADDRESS_FOR_RUNNER_B_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_RNR_A_TA_TARGET_ADDRESS_FOR_RUNNER_A_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_RNR_A_TA_TARGET_ADDRESS_FOR_RUNNER_A_VALUE_RESET_VALUE ( 0x0 )


#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_OFFSET ( 0x00000090 )

#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_RNR_RPLY_TA_OFFSET )
#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_RNR_RPLY_TA_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_RNR_RPLY_TA_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_RNR_RPLY_TA_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Target_address_for_Runner_B */
	uint32_t rnr_b_ta	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_Runner_A */
	uint32_t rnr_a_ta	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RNR_RPLY_TA ;
#else
typedef struct
{	uint32_t rnr_a_ta	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_Runner_A */
	uint32_t rnr_b_ta	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_address_for_Runner_B */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RNR_RPLY_TA ;
#endif

/*****************************************************************************************/
/* Runner_Target_Address_for_Wake-Up_message_on_Reply                                    */
/* Runner Target Address for Wake-Up message for both Runners  as result of Reply to All */
/* oc request whenever Wake-Up is on                                                     */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_RNR_B_TADDR_RPLY_WKUP_TARGET_ADDRESS_ON_WAKE_UP_REPLY_TO_RUNNER_B_VALUE             ( 0x8000 )
#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_RNR_B_TADDR_RPLY_WKUP_TARGET_ADDRESS_ON_WAKE_UP_REPLY_TO_RUNNER_B_VALUE_RESET_VALUE ( 0x8000 )
#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_RNR_A_TADDR_RPLY_WKUP_TARGET_ADDRESS_ON_WAKE_UP_REPLY_TO_RUNNER_A_VALUE             ( 0x8000 )
#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_RNR_A_TADDR_RPLY_WKUP_TARGET_ADDRESS_ON_WAKE_UP_REPLY_TO_RUNNER_A_VALUE_RESET_VALUE ( 0x8000 )


#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_OFFSET ( 0x00000094 )

#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_OFFSET )
#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Target_Address_on_Wake_Up_reply_to_Runner_B */
	uint32_t rnr_b_taddr_rply_wkup	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_Address_on_Wake_Up_reply_to_Runner_A */
	uint32_t rnr_a_taddr_rply_wkup	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA ;
#else
typedef struct
{	uint32_t rnr_a_taddr_rply_wkup	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_Address_on_Wake_Up_reply_to_Runner_A */
	uint32_t rnr_b_taddr_rply_wkup	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Target_Address_on_Wake_Up_reply_to_Runner_B */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA ;
#endif

/*****************************************************************************************/
/* User_Group_Status_register                                                            */
/* This register is status set of all 8 Ugs: - ACK/NACK state (according to current numb */
/* er of allocated BNs for the UG and appropriate UG Buffer Allocated Max/Hysteresis thr */
/* esholds)    - EXCLUSIVE/NON_EXCLUSIVE state (according to current number of allocated */
/*  BNs for the UG and appropriate UG Exclusive/Hysteresis thresholds)                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG_STATUS_RSV2_RSV_VALUE                                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_RSV2_RSV_VALUE_RESET_VALUE                           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG7_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG7_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG7_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG6_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG6_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG6_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG5_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG5_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG5_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG4_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG4_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG4_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG3_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG3_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG3_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG2_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG2_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG2_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG1_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG1_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG1_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG0_EXCL_STTS_NON_EXCL_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG0_EXCL_STTS_NON_EXCL_VALUE_RESET_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG0_EXCL_STTS_EXCL_VALUE                             ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_RSV1_GPON_IS_NOT_IN_EXCLUSIVE_MODE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_RSV1_GPON_IS_NOT_IN_EXCLUSIVE_MODE_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_RSV1_GPON_IS_IN_EXCLUSIVE_MODE_VALUE                 ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG7_STTS_UG7_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG7_STTS_UG7_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG7_STTS_UG7_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG6_STTS_UG6_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG6_STTS_UG6_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG6_STTS_UG6_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG5_STTS_UG5_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG5_STTS_UG5_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG5_STTS_UG5_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG4_STTS_UG4_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG4_STTS_UG4_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG4_STTS_UG4_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG3_STTS_UG3_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG3_STTS_UG3_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG3_STTS_UG3_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG2_STTS_UG2_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG2_STTS_UG2_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG2_STTS_UG2_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG1_STTS_UG1_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG1_STTS_UG1_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG1_STTS_UG1_STATUS_ACK_VALUE                        ( 0x1 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG0_STTS_UG0_STATUS_NACK_VALUE                       ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG0_STTS_UG0_STATUS_NACK_VALUE_RESET_VALUE           ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_STATUS_UG0_STTS_UG0_STATUS_ACK_VALUE                        ( 0x1 )


#define BPM_MODULE_REGS_BPM_UG_STATUS_OFFSET ( 0x00000098 )

#define BPM_MODULE_REGS_BPM_UG_STATUS_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG_STATUS_OFFSET )
#define BPM_MODULE_REGS_BPM_UG_STATUS_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG_STATUS_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG_STATUS_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG_STATUS_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv2 */
	uint32_t rsv2         	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG7_excl_status */
	uint32_t ug7_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG6_excl_status */
	uint32_t ug6_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG5_excl_status */
	uint32_t ug5_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG4_excl_status */
	uint32_t ug4_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_excl_status */
	uint32_t ug3_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG2_excl_status */
	uint32_t ug2_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG1_excl_status */
	uint32_t ug1_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_excl_status */
	uint32_t ug0_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1         	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG7_status */
	uint32_t ug7_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG6_status */
	uint32_t ug6_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG5_status */
	uint32_t ug5_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG4_status */
	uint32_t ug4_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_status */
	uint32_t ug3_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG2_status */
	uint32_t ug2_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG1_status */
	uint32_t ug1_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_status */
	uint32_t ug0_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG_STATUS ;
#else
typedef struct
{	uint32_t ug0_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_status */
	uint32_t ug1_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG1_status */
	uint32_t ug2_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG2_status */
	uint32_t ug3_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_status */
	uint32_t ug4_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG4_status */
	uint32_t ug5_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG5_status */
	uint32_t ug6_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG6_status */
	uint32_t ug7_stts     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG7_status */
	uint32_t rsv1         	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t ug0_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_excl_status */
	uint32_t ug1_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG1_excl_status */
	uint32_t ug2_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG2_excl_status */
	uint32_t ug3_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_excl_status */
	uint32_t ug4_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG4_excl_status */
	uint32_t ug5_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG5_excl_status */
	uint32_t ug6_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG6_excl_status */
	uint32_t ug7_excl_stts	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG7_excl_status */
	uint32_t rsv2         	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG_STATUS ;
#endif

/*****************************************************************************************/
/* BPM_ISR_register                                                                      */
/* This register includes status bits of each BPM source interrupt (at also can be cause */
/* d by test interrupt trigger)                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_ISR_RSV_RSV_VALUE                                     ( 0x0 )
#define BPM_MODULE_REGS_BPM_ISR_RSV_RSV_VALUE_RESET_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_ISR_MCNT_ISR_MCNT_ISR_IS_NON_ACTIVE_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_ISR_MCNT_ISR_MCNT_ISR_IS_NON_ACTIVE_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_ISR_MCNT_ISR_MCNT_ISR_IS_ACTIVE_VALUE                 ( 0x1 )
#define BPM_MODULE_REGS_BPM_ISR_FREE_ISR_FREE_ISR_IS_INACTIVE_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_ISR_FREE_ISR_FREE_ISR_IS_INACTIVE_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_ISR_FREE_ISR_FREE_ISR_IS_ACTIVE_VALUE                 ( 0x1 )


#define BPM_MODULE_REGS_BPM_ISR_OFFSET ( 0x0000009C )

#define BPM_MODULE_REGS_BPM_ISR_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_ISR_OFFSET )
#define BPM_MODULE_REGS_BPM_ISR_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_ISR_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_ISR_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_ISR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv     	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT_Interrupt_source */
	uint32_t mcnt_isr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_Interrupt_source */
	uint32_t free_isr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_ISR ;
#else
typedef struct
{	uint32_t free_isr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_Interrupt_source */
	uint32_t mcnt_isr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT_Interrupt_source */
	uint32_t rsv     	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_ISR ;
#endif

/*****************************************************************************************/
/* BPM_IER_register                                                                      */
/* This register includes enable controls per each source. Enable bit affects on BPM IRQ */
/*  output to Interrupt Controller                                                       */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_IER_RSV_RSV_VALUE                                ( 0x0 )
#define BPM_MODULE_REGS_BPM_IER_RSV_RSV_VALUE_RESET_VALUE                    ( 0x0 )
#define BPM_MODULE_REGS_BPM_IER_MCNT_IER_MCNT_IRQ_DISABLED_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_IER_MCNT_IER_MCNT_IRQ_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_IER_MCNT_IER_MCNT_IRQ_ENABLED_VALUE              ( 0x1 )
#define BPM_MODULE_REGS_BPM_IER_FREE_IER_FREE_IRQ_DISABLED_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_IER_FREE_IER_FREE_IRQ_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_IER_FREE_IER_FREE_IRQ_ENABLED_VALUE              ( 0x1 )


#define BPM_MODULE_REGS_BPM_IER_OFFSET ( 0x00000100 )

#define BPM_MODULE_REGS_BPM_IER_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_IER_OFFSET )
#define BPM_MODULE_REGS_BPM_IER_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_IER_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_IER_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_IER_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv     	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Enable_for_MCNT_IRQ */
	uint32_t mcnt_ier	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Enable_for_Free_IRQ */
	uint32_t free_ier	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_IER ;
#else
typedef struct
{	uint32_t free_ier	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Enable_for_Free_IRQ */
	uint32_t mcnt_ier	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Enable_for_MCNT_IRQ */
	uint32_t rsv     	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_IER ;
#endif

/*****************************************************************************************/
/* BPM_ITR_register                                                                      */
/* This register allows emulate BPM IRQs by serring relevant bit in ITR register         */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_ITR_RSV_RSV_VALUE                                     ( 0x0 )
#define BPM_MODULE_REGS_BPM_ITR_RSV_RSV_VALUE_RESET_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_ITR_MCNT_ITR_MCNT_IRQ_DISABLED_VALUE                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_ITR_MCNT_ITR_MCNT_IRQ_DISABLED_VALUE_RESET_VALUE      ( 0x0 )
#define BPM_MODULE_REGS_BPM_ITR_MCNT_ITR_MCNT_IRQ_ENABLED_VALUE                   ( 0x1 )
#define BPM_MODULE_REGS_BPM_ITR_FREE_ITR_FREE_TEST_IRQ_DISABLED_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_ITR_FREE_ITR_FREE_TEST_IRQ_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_ITR_FREE_ITR_FREE_TEST_IRQ_ENABLED_VALUE              ( 0x1 )


#define BPM_MODULE_REGS_BPM_ITR_OFFSET ( 0x00000104 )

#define BPM_MODULE_REGS_BPM_ITR_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_ITR_OFFSET )
#define BPM_MODULE_REGS_BPM_ITR_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_ITR_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_ITR_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_ITR_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv     	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT_Test_IRQ */
	uint32_t mcnt_itr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_Test_IRQ */
	uint32_t free_itr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_ITR ;
#else
typedef struct
{	uint32_t free_itr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_Test_IRQ */
	uint32_t mcnt_itr	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT_Test_IRQ */
	uint32_t rsv     	: 30 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_ITR ;
#endif

/*****************************************************************************************/
/* BPM_UG_MAP_R1                                                                         */
/* Each Source Port is mapped to specified UG. This register is using for mapping of  th */
/* e following Source Ports to UG07:  -Eth MAC4  -MIPSD  -PCIe 0/1  -USB 0/1  -Two spar */
/* e ports                                                                               */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG_MAP_R1_SPARE1_SPARE2_MAP_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_SPARE1_SPARE2_MAP_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_SPARE0_SPARE1_MAP_VALUE             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_SPARE0_SPARE1_MAP_VALUE_RESET_VALUE ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_USB1_SPARE0_MAP_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_USB1_SPARE0_MAP_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_USB0_USB_MAP_VALUE                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_USB0_USB_MAP_VALUE_RESET_VALUE      ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_PCIE1_PCIE1_MAP_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_PCIE1_PCIE1_MAP_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_PCIE0_PCIE0_MAP_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_PCIE0_PCIE0_MAP_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_MIPSD_EMAC5_MAP_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_MIPSD_EMAC5_MAP_VALUE_RESET_VALUE   ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_EMAC4_EMAC4_MAP_VALUE               ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_EMAC4_EMAC4_MAP_VALUE_RESET_VALUE   ( 0x0 )


#define BPM_MODULE_REGS_BPM_UG_MAP_R1_OFFSET ( 0x00000108 )

#define BPM_MODULE_REGS_BPM_UG_MAP_R1_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG_MAP_R1_OFFSET )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG_MAP_R1_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG_MAP_R1_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG_MAP_R1_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Spare1_mapping */
	uint32_t spare1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Spare0_mapping */
	uint32_t spare0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB1_mapping */
	uint32_t usb1  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB0_mapping */
	uint32_t usb0  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE1_mapping */
	uint32_t pcie1 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE0_mapping */
	uint32_t pcie0 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_mapping */
	uint32_t mipsd 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC4_mapping */
	uint32_t emac4 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG_MAP_R1 ;
#else
typedef struct
{	uint32_t emac4 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* EMAC4_mapping */
	uint32_t mipsd 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_mapping */
	uint32_t pcie0 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE0_mapping */
	uint32_t pcie1 	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PCIE1_mapping */
	uint32_t usb0  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB0_mapping */
	uint32_t usb1  	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USB1_mapping */
	uint32_t spare0	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Spare0_mapping */
	uint32_t spare1	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Spare1_mapping */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG_MAP_R1 ;
#endif

/*****************************************************************************************/
/* User_Group_0_Exclusive_Thresholds                                                     */
/* User Group 0 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_OFFSET ( 0x0000010C )

#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_1_Exclusive_Thresholds                                                     */
/* User Group 1 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_OFFSET ( 0x00000110 )

#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_2_Exclusive_Thresholds                                                     */
/* User Group 2 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_OFFSET ( 0x00000114 )

#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_3_Exclusive_Thresholds                                                     */
/* User Group 3 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_OFFSET ( 0x00000118 )

#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_4_Exclusive_Thresholds                                                     */
/* User Group 4 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_OFFSET ( 0x0000011C )

#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_5_Exclusive_Thresholds                                                     */
/* User Group 5 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_OFFSET ( 0x00000120 )

#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_6_Exclusive_Thresholds                                                     */
/* User Group 6 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_OFFSET ( 0x00000124 )

#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* User_Group_7_Exclusive_Thresholds                                                     */
/* User Group 7 Exclusive Thresholds: high exclusive threshold (when the high threshold  */
/* is crossed up - BPM sends Enter EXCLUSIVE message to al BBH clients in this group) an */
/* d hysteresis to low threshold (when this threshold is crossed down - BPM sends Exit E */
/* XCLUSIVE message to al BBH clients in this group). The exclusive status is also aplie */
/* d in reply messages                                                                   */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_RSV2_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_RSV2_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE             ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_UG_EXCL_HYST_UG_EXCLUSIVE_HYSTERESIS_VALUE_RESET_VALUE ( 0x100 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_RSV1_RSV_VALUE                                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_RSV1_RSV_VALUE_RESET_VALUE                             ( 0x0 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE                ( 0x1000 )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_UG_EXCL_TR_UG_EXCLUSIVE_THRESHOLD_VALUE_RESET_VALUE    ( 0x1000 )


#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_OFFSET ( 0x00000128 )

#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_OFFSET )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH ;
#else
typedef struct
{	uint32_t ug_excl_tr  	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_high_threshold */
	uint32_t rsv1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
	uint32_t ug_excl_hyst	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG_exclusive_hysteresis */
	uint32_t rsv2        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH ;
#endif

/*****************************************************************************************/
/* BPM_route_address_register_2                                                          */
/* BPM route addresses of MIPSD                                                          */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_RADDR2_RSV_RSV_VALUE                                     ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR2_RSV_RSV_VALUE_RESET_VALUE                         ( 0x0 )
#define BPM_MODULE_REGS_BPM_RADDR2_MIPSD_RADDR_MIPSD_ROUTE_ADDRESS_VALUE             ( 0x6 )
#define BPM_MODULE_REGS_BPM_RADDR2_MIPSD_RADDR_MIPSD_ROUTE_ADDRESS_VALUE_RESET_VALUE ( 0x6 )


#define BPM_MODULE_REGS_BPM_RADDR2_OFFSET ( 0x0000012C )

#define BPM_MODULE_REGS_BPM_RADDR2_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_RADDR2_OFFSET )
#define BPM_MODULE_REGS_BPM_RADDR2_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_RADDR2_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_RADDR2_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_RADDR2_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* rsv */
	uint32_t rsv        	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_route_address */
	uint32_t mipsd_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RADDR2 ;
#else
typedef struct
{	uint32_t mipsd_raddr	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MIPSD_route_address */
	uint32_t rsv        	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rsv */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_RADDR2 ;
#endif

/*****************************************************************************************/
/* BPM_MIPSD_RPLY_TA                                                                     */
/* Target address for Reply message as results of Alloc request from MIPSD. The register */
/*  is separeted to two fields:   (1) for regular reply on Alloc   (2) for wake-up reply */
/*  (as regular Runner default = 0x8000)                                                 */
/*****************************************************************************************/

#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_RPLY_TA_BROADBUS_ADDRESS_VALUE                  ( 0x0 )
#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_RPLY_TA_BROADBUS_ADDRESS_VALUE_RESET_VALUE      ( 0x0 )
#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_WKUP_RPLY_TA_BROADBUS_ADDRESS_VALUE             ( 0x8000 )
#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_WKUP_RPLY_TA_BROADBUS_ADDRESS_VALUE_RESET_VALUE ( 0x8000 )


#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_OFFSET ( 0x00000130 )

#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_OFFSET )
#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA_ADDRESS ), (v) )

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RPLY_TA */
	uint32_t rply_ta     	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* WKUP_RPLY_TA */
	uint32_t wkup_rply_ta	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA ;
#else
typedef struct
{	uint32_t wkup_rply_ta	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* WKUP_RPLY_TA */
	uint32_t rply_ta     	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RPLY_TA */
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA ;
#endif

#define BPM_MODULE_REGS_BPM_SPARE_BN_MSG_FORMAT_14_BIT_BN_WIDTH                           ( 0x0 )
#define BPM_MODULE_REGS_BPM_SPARE_BN_MSG_FORMAT_15_BIT_BN_WIDTH                           ( 0x1 )
#define BPM_MODULE_REGS_BPM_SPARE_OFFSET ( 0x0000013C )
#define BPM_MODULE_REGS_BPM_SPARE_ADDRESS   	( BPM_MODULE_REGS_ADDRESS + BPM_MODULE_REGS_BPM_SPARE_OFFSET )
#define BPM_MODULE_REGS_BPM_SPARE_READ( r ) 	READ_32( ( BPM_MODULE_REGS_BPM_SPARE_ADDRESS ), (r) )
#define BPM_MODULE_REGS_BPM_SPARE_WRITE( v )	WRITE_32( ( BPM_MODULE_REGS_BPM_SPARE_ADDRESS ), (v) )
#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	uint32_t rsv        	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t bn_msg_format 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t spare_bits		: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_SPARE ;
#else
typedef struct
{	uint32_t spare_bits		: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t bn_msg_format 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	uint32_t rsv        	: 23 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS_BPM_SPARE ;
#endif
typedef struct
{
	/* Request_pointer */
	BPM_MODULE_REGS_REQ_PTR req_ptr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Free_pointer */
	BPM_MODULE_REGS_FREE_PTR free_ptr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Multi_Cast_Counter_set_for_pointer */
	BPM_MODULE_REGS_MCNT_PTR mcnt_ptr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Init_of_BPM_Core_RAMs */
	BPM_MODULE_REGS_RAM_INIT ram_init __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* free_pointer_interrupt */
	BPM_MODULE_REGS_FREE_PTR_INT free_ptr_int __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Read_ram_address */
	BPM_MODULE_REGS_READ_RAM_ADDR read_ram_addr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MCNT_pointer_interrupt */
	BPM_MODULE_REGS_MCNT_PTR_INT mcnt_ptr_int __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_ram_data0 */
	BPM_MODULE_REGS_READ_RAM_DATA0 read_ram_data0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_ram_data1 */
	BPM_MODULE_REGS_READ_RAM_DATA1 read_ram_data1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* read_ram_data2 */
	BPM_MODULE_REGS_READ_RAM_DATA2 read_ram_data2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Source_Port_enable */
	BPM_MODULE_REGS_BPM_SP_EN bpm_sp_en __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Threshold */
	BPM_MODULE_REGS_BPM_GL_TRSH bpm_gl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG0_Threshold */
	BPM_MODULE_REGS_BPM_UG0_TRSH bpm_ug0_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG1_Threshold */
	BPM_MODULE_REGS_BPM_UG1_TRSH bpm_ug1_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG2_Threshold */
	BPM_MODULE_REGS_BPM_UG2_TRSH bpm_ug2_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG3_Threshold */
	BPM_MODULE_REGS_BPM_UG3_TRSH bpm_ug3_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG4_Threshold */
	BPM_MODULE_REGS_BPM_UG4_TRSH bpm_ug4_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG5_Threshold */
	BPM_MODULE_REGS_BPM_UG5_TRSH bpm_ug5_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG6_Threshold */
	BPM_MODULE_REGS_BPM_UG6_TRSH bpm_ug6_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UG7_Threshold */
	BPM_MODULE_REGS_BPM_UG7_TRSH bpm_ug7_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG_MAP_R0 */
	BPM_MODULE_REGS_BPM_UG_MAP_R0 bpm_ug_map_r0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_dbg */
	BPM_MODULE_REGS_BPM_DBG bpm_dbg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG0_BAC */
	BPM_MODULE_REGS_BPM_UG0_BAC bpm_ug0_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG1_BAC */
	BPM_MODULE_REGS_BPM_UG1_BAC bpm_ug1_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG2_BAC */
	BPM_MODULE_REGS_BPM_UG2_BAC bpm_ug2_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG3_BAC */
	BPM_MODULE_REGS_BPM_UG3_BAC bpm_ug3_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG4_BAC */
	BPM_MODULE_REGS_BPM_UG4_BAC bpm_ug4_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG5_BAC */
	BPM_MODULE_REGS_BPM_UG5_BAC bpm_ug5_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG6_BAC */
	BPM_MODULE_REGS_BPM_UG6_BAC bpm_ug6_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG7_BAC */
	BPM_MODULE_REGS_BPM_UG7_BAC bpm_ug7_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_GL_BAC */
	BPM_MODULE_REGS_BPM_GL_BAC bpm_gl_bac __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route_address_register_0 */
	BPM_MODULE_REGS_BPM_RADDR0 bpm_raddr0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route_address_register_1 */
	BPM_MODULE_REGS_BPM_RADDR1 bpm_raddr1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_runner_message_control_register */
	BPM_MODULE_REGS_BPM_RNR_MSG_CTRL bpm_rnr_msg_ctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_Target_address_for_Reply_message */
	BPM_MODULE_REGS_BPM_RNR_RPLY_TA bpm_rnr_rply_ta __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Runner_Target_Address_for_Wake-Up_message_on_Reply */
	BPM_MODULE_REGS_BPM_RNR_WKUP_RPLY_TA bpm_rnr_wkup_rply_ta __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_Status_register */
	BPM_MODULE_REGS_BPM_UG_STATUS bpm_ug_status __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_ISR_register */
	BPM_MODULE_REGS_BPM_ISR bpm_isr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 96 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_IER_register */
	BPM_MODULE_REGS_BPM_IER bpm_ier __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_ITR_register */
	BPM_MODULE_REGS_BPM_ITR bpm_itr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_UG_MAP_R1 */
	BPM_MODULE_REGS_BPM_UG_MAP_R1 bpm_ug_map_r1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_0_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG0_EXCL_TRSH bpm_ug0_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_1_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG1_EXCL_TRSH bpm_ug1_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_2_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG2_EXCL_TRSH bpm_ug2_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_3_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG3_EXCL_TRSH bpm_ug3_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_4_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG4_EXCL_TRSH bpm_ug4_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_5_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG5_EXCL_TRSH bpm_ug5_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_6_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG6_EXCL_TRSH bpm_ug6_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* User_Group_7_Exclusive_Thresholds */
	BPM_MODULE_REGS_BPM_UG7_EXCL_TRSH bpm_ug7_excl_trsh __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_route_address_register_2 */
	BPM_MODULE_REGS_BPM_RADDR2 bpm_raddr2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BPM_MIPSD_RPLY_TA */
	BPM_MODULE_REGS_BPM_MIPSD_RPLY_TA bpm_mipsd_rply_ta __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
	BPM_MODULE_REGS_BPM_SPARE bpm_spare __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE_REGS ;

typedef struct
{
	/* regs function */
	BPM_MODULE_REGS regs __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
BPM_MODULE ;

typedef struct
{
	/* MODULE */
	BPM_MODULE module __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
BPM_FOR_ALL ;
#endif /* BPM_H_INCLUDED */

