/* SPDX-License-Identifier: GPL-2.0+
 *
 *  Copyright 2020 Broadcom Ltd.
 */
#ifndef _SKP_H
#define _SKP_H

/* KSR defs */
#define KSR_BASE 0xff805000

#define KSR_STATUS_KEY_LOADED_SHIFT	24
#define KSR_STATUS_KEY_LOADED_MASK	0x1
#define KSR_STATUS_READY_SHIFT		21
#define KSR_STATUS_READY_MASK		0x1
#define KSR_STATUS_DESC_VALID_SHIFT	20
#define KSR_STATUS_DESC_VALID_MASK	0x1
#define KSR_RD_DESC_DGOOD_MASK          0x1
#define KSR_RD_DESC_DGOOD_SHIFT         29
#define KSR_RD_DGOOD(_V_)      ((_V_>>KSR_RD_DESC_DGOOD_SHIFT)&KSR_RD_DESC_DGOOD_MASK) 

#define	KSR_PORTAL_VALID(_V_)	(	((_V_>>KSR_STATUS_KEY_LOADED_SHIFT)&KSR_STATUS_KEY_LOADED_MASK) &\
					((_V_>>KSR_STATUS_READY_SHIFT)&KSR_STATUS_READY_MASK)		&\
 					((_V_>>KSR_STATUS_DESC_VALID_SHIFT)&KSR_STATUS_DESC_VALID_MASK) )

#define	KSR_PORTAL_READY(_V_)		((_V_>>KSR_STATUS_READY_SHIFT)&KSR_STATUS_READY_MASK)
#define KSR_STATUS_ECC_DATA_SHIFT	23
#define KSR_STATUS_ECC_DATA_MASK	0x1
#define KSR_STATUS_ECC_DESC_SHIFT	22
#define KSR_STATUS_ECC_DESC_MASK	0x1
#define KSR_PORTAL_ECC_DATA_ERR(_V_)	((_V_>>KSR_STATUS_ECC_DATA_SHIFT)&KSR_STATUS_ECC_DATA_MASK)
#define KSR_PORTAL_ECC_DESC_ERR(_V_)	((_V_>>KSR_STATUS_ECC_DESC_SHIFT)&KSR_STATUS_ECC_DESC_MASK)
#define	KSR_PORTAL_KEY_LOADED(_V_) 	((_V_>>KSR_STATUS_KEY_LOADED_SHIFT)&KSR_STATUS_KEY_LOADED_MASK)


#define KSR_PORTAL_OTP_PGM_DESC_VALID_SHIFT	31
#define KSR_PORTAL_OTP_PGM_DESC_VALID_MASK	0x1

#define KSR_PORTAL_PGM_DESC_PERM_SHIFT		0
#define KSR_PORTAL_PGM_DESC_PERM_MASK		0xf

#define KSR_PORTAL_PGM_DESC_LOCK_MASK		0x1	

#define KSR_PORTAL_PGM_DESC_BLK_SW_LOCK_SHIFT	7
#define KSR_PORTAL_PGM_DESC_BLK_SR_LOCK_SHIFT	6
#define KSR_PORTAL_PGM_DESC_BLK_NSW_LOCK_SHIFT	5
#define KSR_PORTAL_PGM_DESC_BLK_NSR_LOCK_SHIFT	4
#define KSR_PORTAL_PGM_DESC_PERM_SW_LOCK_SHIFT	3	
#define KSR_PORTAL_PGM_DESC_PERM_SR_LOCK_SHIFT	2
#define KSR_PORTAL_PGM_DESC_PERM_NSW_LOCK_SHIFT	1
#define KSR_PORTAL_PGM_DESC_PERM_NSR_LOCK_SHIFT	0

#define KSR_PERM_BLK_SR_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_BLK_SR_LOCK_SHIFT)
#define KSR_PERM_BLK_NSR_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_BLK_NSR_LOCK_SHIFT)

#define KSR_PERM_BLK_SW_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_BLK_SW_LOCK_SHIFT)
#define KSR_PERM_BLK_NSW_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_BLK_NSW_LOCK_SHIFT)

#define KSR_PERM_PAC_SR_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_PERM_SR_LOCK_SHIFT)
#define KSR_PERM_PAC_NSR_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_PERM_NSR_LOCK_SHIFT)

#define KSR_PERM_PAC_SW_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_PERM_SW_LOCK_SHIFT)
#define KSR_PERM_PAC_NSW_LOCK	(0x1<<KSR_PORTAL_PGM_DESC_PERM_NSW_LOCK_SHIFT)

#define KSR_PERM_LOCK_ALL	0xff
/* Allways keep access to PERM fields locked for NSEC */
#define KSR_PERM_UNLOCK_ALL	(KSR_PERM_PAC_NSR_LOCK | KSR_PERM_PAC_NSW_LOCK)
#define KSR_PERM_LOCK_NS					\
				(KSR_PERM_BLK_NSR_LOCK 	| 	\
				KSR_PERM_BLK_NSW_LOCK 	| 	\
				KSR_PERM_PAC_NSR_LOCK 	| 	\
				KSR_PERM_PAC_NSW_LOCK)
/* Unlocking NONSEC BLK access should unlock SEC BLK access as well */
#define KSR_PERM_UNLOCK_NS	(KSR_PERM_UNLOCK_ALL)
/* Locking SEC BLK access should also lock NONSEC BLK acces as well */
#define KSR_PERM_LOCK_S		(KSR_PERM_LOCK_ALL)
/* Unlocking SEC BLK access should lock NONSEC BLK access as well */
#define KSR_PERM_UNLOCK_S	(KSR_PERM_LOCK_NS)


#define KSR_PORTAL_PGM_DESC_NRW_PERM					\
		(0x1<<KSR_PORTAL_OTP_PGM_DESC_VALID_SHIFT)

#define KSR_PORTAL_PGM_DESC_SRW_PERM					\
		((0x1<<KSR_PORTAL_OTP_PGM_DESC_VALID_SHIFT)    |	\
		(0x1<<KSR_PORTAL_PGM_DESC_BLK_NSW_LOCK_SHIFT)  |	\
		(0x1<<KSR_PORTAL_PGM_DESC_BLK_NSR_LOCK_SHIFT)  |	\
		(0x1<<KSR_PORTAL_PGM_DESC_PERM_NSW_LOCK_SHIFT) |	\
		(0x1<<KSR_PORTAL_PGM_DESC_PERM_NSR_LOCK_SHIFT))

#define KSR_PORTAL_OTP_CMD_MASK			0xf
#define KSR_PORTAL_OTP_CMD_SHIFT		0x0

#define KSR_PORTAL_OTP_CMD_PGM_DESC_WORD	0x8
#define KSR_PORTAL_OTP_CMD_PGM_DESC_ECC		0x9
#define KSR_PORTAL_OTP_CMD_PGM_KEY		0x2

#define KSR_OTP_CMD_PGM_DESC_WORD		((KSR_PORTAL_OTP_CMD_MASK&KSR_PORTAL_OTP_CMD_PGM_DESC_WORD)<<KSR_PORTAL_OTP_CMD_SHIFT)
#define KSR_OTP_CMD_PGM_DESC_ECC		((KSR_PORTAL_OTP_CMD_MASK&KSR_PORTAL_OTP_CMD_PGM_DESC_ECC)<<KSR_PORTAL_OTP_CMD_SHIFT)
#define KSR_OTP_CMD_PGM_KEY			((KSR_PORTAL_OTP_CMD_MASK&KSR_PORTAL_OTP_CMD_PGM_KEY)<<KSR_PORTAL_OTP_CMD_SHIFT)


#define KSR_OTP_STATUS_CMD_ACTIVE_SHIFT	31
#define KSR_OTP_STATUS_CMD_ACTIVE_MASK	0x1
#define KSR_OTP_STATUS_ACTIVE(_V_)		\
		((_V_>>KSR_OTP_STATUS_CMD_ACTIVE_SHIFT)&KSR_OTP_STATUS_CMD_ACTIVE_MASK)
#define KSR_OTP_STATUS_OPCODE_SHIFT	16
#define KSR_OTP_STATUS_OPCODE_MASK	0xf
#define KSR_OTP_STATUS_CMD_ERR_SHIFT	0x0
#define KSR_OTP_STATUS_CMD_ERR_MASK	0xff

#define KSR_OTP_STATUS_CMD_ERROR(_V_)		\
		((_V_>>KSR_OTP_STATUS_CMD_ERR_SHIFT)&KSR_OTP_STATUS_CMD_ERR_MASK)


#define KSR_PAC_OFFSET                 	 	0x00       
#define KSR_OTP_CMD_OFFSET                  	0x04       
#define KSR_OTP_STATUS_OFFSET               	0x08       
#define KSR_RD_DESC_OFFSET                  	0x0c       
#define KSR_PGM_DESC_OFFSET                 	0x10       
#define KSR_PORTAL_STATUS_OFFSET            	0x14       
#define KSR_DATA_OFFSET		    		0x20

#define KSR_SIZE  0x80 
#define KSR_OFFSET 0x0 
#define KSR_START_ROW_ADDR			0
#define KSR_MAX_ROW_ADDR			(KSR_START_ROW_ADDR+6)


/* FSR defs */
#define FSR_BASE 0xff805300 

#define FSR_PORTAL_OTP_CMD_READ_DATA		0x2		
#define FSR_PORTAL_OTP_CMD_READ_DESC		0x3
#define FSR_PORTAL_OTP_CMD_WRITE_DATA		0x4
#define FSR_PORTAL_OTP_CMD_WRITE_DATA_ECC	0x5
#define FSR_PORTAL_OTP_CMD_WRITE_DESC		0x8
#define FSR_PORTAL_OTP_CMD_WRITE_DESC_ECC	0x9
#define FSR_PORTAL_OTP_CMD_RELOAD_DATA		0xc
#define FSR_PORTAL_OTP_CMD_RELOAD_DESC		0xd	

#define FSR_PORTAL_OTP_CMD_WORD_SEL_MASK	0xfff
#define FSR_PORTAL_OTP_CMD_WORD_SEL_SHIFT	0x4

#define FSR_PORTAL_OTP_CMD_MASK			0xf
#define FSR_PORTAL_OTP_CMD_SHIFT		0x0


#define FSR_OTP_CMD_READ_DATA		((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_READ_DATA)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_READ_DESC		((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_READ_DESC)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_PGM_DATA		((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_WRITE_DATA)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_PGM_DATA_ECC	((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_WRITE_DATA_ECC)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_PGM_DESC		((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_WRITE_DESC)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_PGM_DESC_ECC	((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_WRITE_DESC_ECC)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_RELOAD_DATA		((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_RELOAD_DATA)<<FSR_PORTAL_OTP_CMD_SHIFT)
#define FSR_OTP_CMD_RELOAD_DESC		((FSR_PORTAL_OTP_CMD_MASK&FSR_PORTAL_OTP_CMD_RELOAD_DESC)<<FSR_PORTAL_OTP_CMD_SHIFT)

#define FSR_PORTAL_STATUS_ECC_PGM_DIS_SHIFT	23
#define FSR_PORTAL_STATUS_ECC_PGM_DIS_MASK	0x1
#define FSR_PORTAL_STATUS_RLOCK_SHIFT	22
#define FSR_PORTAL_STATUS_RLOCK_MASK	0x1
#define FSR_PORTAL_STATUS_READY_SHIFT		21
#define FSR_PORTAL_STATUS_READY_MASK		0x1
#define FSR_PORTAL_STATUS_DESC_VALID_SHIFT	20
#define FSR_PORTAL_STATUS_DESC_VALID_MASK	0x1

#define	FSR_PORTAL_RLOCK(_V_)	(	((_V_>>	FSR_PORTAL_STATUS_RLOCK_SHIFT)&\
						FSR_PORTAL_STATUS_RLOCK_MASK)	 	)

#define	FSR_PORTAL_ECC_DIS(_V_)	(	((_V_>>	FSR_PORTAL_STATUS_ECC_PGM_DIS_SHIFT)&\
						FSR_PORTAL_STATUS_ECC_PGM_DIS_MASK)	)

#define	FSR_PORTAL_VALID(_V_)	(	((_V_>>	FSR_PORTAL_STATUS_READY_SHIFT)&\
						FSR_PORTAL_STATUS_READY_MASK)		&\
 					((_V_>>	FSR_PORTAL_STATUS_DESC_VALID_SHIFT)&\
						FSR_PORTAL_STATUS_DESC_VALID_MASK)	)

#define FSR_RD_DESC_VALID_SHIFT         31
#define FSR_RD_DESC_VALID_MASK          0x1
#define FSR_RD_DESC_ECC_PGM_DIS_SHIFT	29
#define FSR_RD_DESC_ECC_PGM_DIS_MASK	0x1
#define FSR_RD_DESC_RLOCK_SHIFT		28
#define FSR_RD_DESC_RLOCK_MASK		0x1
#define FSR_RD_DESC_SIZE_SHIFT		12
#define FSR_RD_DESC_SIZE_MASK		0xfff

#define FSR_RD_DDATA_SIZE(_V_)	((_V_>>FSR_RD_DESC_SIZE_SHIFT)&FSR_RD_DESC_SIZE_MASK)
#define FSR_RD_DGOOD(_V_)      	((_V_>>FSR_RD_DESC_VALID_SHIFT)&FSR_RD_DESC_VALID_MASK) 

#define FSR_OTP_STATUS_CMD_ACTIVE_SHIFT	31
#define FSR_OTP_STATUS_CMD_ACTIVE_MASK	0x1
#define FSR_OTP_STATUS_OPCODE_SHIFT	16
#define FSR_OTP_STATUS_OPCODE_MASK	0xf
#define FSR_OTP_STATUS_CMD_ERR_SHIFT	0x0
#define FSR_OTP_STATUS_CMD_ERR_MASK	0xff

#define FSR_OTP_STATUS_ACTIVE(_V_)		\
		((_V_>>FSR_OTP_STATUS_CMD_ACTIVE_SHIFT)&FSR_OTP_STATUS_CMD_ACTIVE_MASK)
#define FSR_OTP_STATUS_CMD_ERROR(_V_)		\
		((_V_>>FSR_OTP_STATUS_CMD_ERR_SHIFT)&FSR_OTP_STATUS_CMD_ERR_MASK)

#define FSR_PORTAL_RD_ECC_MASK			0x3ff

#define FSR_PORTAL_PGM_BLK_SW_LOCK_SHIFT	7
#define FSR_PORTAL_PGM_BLK_SR_LOCK_SHIFT	6
#define FSR_PORTAL_PGM_BLK_NSW_LOCK_SHIFT	5
#define FSR_PORTAL_PGM_BLK_NSR_LOCK_SHIFT	4
#define FSR_PORTAL_PGM_PERM_SW_LOCK_SHIFT	3	
#define FSR_PORTAL_PGM_PERM_SR_LOCK_SHIFT	2
#define FSR_PORTAL_PGM_PERM_NSW_LOCK_SHIFT	1
#define FSR_PORTAL_PGM_PERM_NSR_LOCK_SHIFT	0

#define FSR_PERM_BLK_SR_LOCK	(0x1<<FSR_PORTAL_PGM_BLK_SR_LOCK_SHIFT)
#define FSR_PERM_BLK_NSR_LOCK	(0x1<<FSR_PORTAL_PGM_BLK_NSR_LOCK_SHIFT)

#define FSR_PERM_BLK_SW_LOCK	(0x1<<FSR_PORTAL_PGM_BLK_SW_LOCK_SHIFT)
#define FSR_PERM_BLK_NSW_LOCK	(0x1<<FSR_PORTAL_PGM_BLK_NSW_LOCK_SHIFT)

#define FSR_PERM_PAC_SR_LOCK	(0x1<<FSR_PORTAL_PGM_PERM_SR_LOCK_SHIFT)
#define FSR_PERM_PAC_NSR_LOCK	(0x1<<FSR_PORTAL_PGM_PERM_NSR_LOCK_SHIFT)

#define FSR_PERM_PAC_SW_LOCK	(0x1<<FSR_PORTAL_PGM_PERM_SW_LOCK_SHIFT)
#define FSR_PERM_PAC_NSW_LOCK	(0x1<<FSR_PORTAL_PGM_PERM_NSW_LOCK_SHIFT)

#define FSR_PERM_LOCK_ALL	0xff
/* Allways keep access to PERM fields locked for NSEC */
#define FSR_PERM_UNLOCK_ALL	(FSR_PERM_PAC_NSR_LOCK | FSR_PERM_PAC_NSW_LOCK)
#define FSR_PERM_LOCK_NS					\
				(FSR_PERM_BLK_NSR_LOCK 	| 	\
				FSR_PERM_BLK_NSW_LOCK 	| 	\
				FSR_PERM_PAC_NSR_LOCK 	| 	\
				FSR_PERM_PAC_NSW_LOCK)
/* Unlocking NONSEC BLK access should UNLOCK SEC BLK access as well */
#define FSR_PERM_UNLOCK_NS	(FSR_PERM_UNLOCK_ALL)
/* Locking SEC BLK access should also LOCK NONSEC BLK acces as well */
#define FSR_PERM_LOCK_S		(FSR_PERM_LOCK_ALL)
/* Unlocking SEC BLK access should LOCK NONSEC BLK access as well */
#define FSR_PERM_UNLOCK_S	(FSR_PERM_LOCK_NS)


#define FSR_OTP_CMD_OFFSET                  	0x00       
#define FSR_OTP_STATUS_OFFSET               	0x04       
#define FSR_DATA_OFFSET		    		0x08
#define FSR_RD_ECC_OFFSET                  	0x0c       
#define FSR_PORTAL_STATUS_OFFSET            	0x10       
#define FSR_PAC_OFFSET                 	 	0x18       

#define FSR_SIZE  0x20 
#define FSR_OFFSET 0x300 
#define FSR_START_ROW_ADDR			6
#define FSR_MAX_ROW_ADDR			(FSR_START_ROW_ADDR+8)
	
/* An SOTP row initializer that maps actual row number with mask and shift to a feature name;
 * this allows to use features vs. rows for common functionality, 
 * such as secure keys reading and fusing 
 * prevent ifdef dependencies when used outside of arch directories for common among SoCs logic
 * */
#define	DEFINE_SOTP_MAP_ROW_INITLR(__VV__)														\
static otp_hw_cmn_row_t __VV__[ ] = {															\
		{.feat = SOTP_MAP_FLD_ROE,          .addr = (KSR_START_ROW_ADDR+0), .range = 8, .conf = {.perm = KSR_PORTAL_PGM_DESC_SRW_PERM, .op_type = OTP_HW_CMN_CTL_OTPCMD_ECC}},	\
		{.feat = SOTP_MAP_FLD_HMID,         .addr = (KSR_START_ROW_ADDR+1), .range = 8, .conf = {.perm = KSR_PORTAL_PGM_DESC_SRW_PERM, .op_type = OTP_HW_CMN_CTL_OTPCMD_ECC}},	\
		{.feat = SOTP_MAP_KEY_DEV_SPECIFIC, .addr = (KSR_START_ROW_ADDR+2), .range = 8, .conf = {.perm = (KSR_PORTAL_PGM_DESC_NRW_PERM), .op_type = OTP_HW_CMN_CTL_OTPCMD_ECC}},\
		{.feat = SOTP_MAP_SER_NUM,          .addr = (KSR_START_ROW_ADDR+3), .range = 8, .conf = {.perm = (KSR_PORTAL_PGM_DESC_NRW_PERM), .op_type = OTP_HW_CMN_CTL_OTPCMD_ECC}},\
		{.feat = SOTP_MAP_KEY_SECT_1,       .addr = (KSR_START_ROW_ADDR+4), .range = 8, .conf = {.perm = (KSR_PORTAL_PGM_DESC_NRW_PERM), .op_type = OTP_HW_CMN_CTL_OTPCMD_ECC}},\
		{.feat = SOTP_MAP_KEY_SECT_2,       .addr = (KSR_START_ROW_ADDR+5), .range = 8, .conf = {.perm = (KSR_PORTAL_PGM_DESC_NRW_PERM), .op_type = OTP_HW_CMN_CTL_OTPCMD_ECC}},\
		{.feat = SOTP_MAP_ANTI_ROLLBACK,    .addr = (FSR_START_ROW_ADDR+0), .range = 4, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_1,         .addr = (FSR_START_ROW_ADDR+1), .range = 4, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_2,         .addr = (FSR_START_ROW_ADDR+2), .range = 8, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_3,         .addr = (FSR_START_ROW_ADDR+3), .range = 8, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_4,         .addr = (FSR_START_ROW_ADDR+4), .range = 2, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_5,         .addr = (FSR_START_ROW_ADDR+5), .range = 4, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_6,         .addr = (FSR_START_ROW_ADDR+6), .range = 4, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
		{.feat = SOTP_MAP_UNUSED_7,         .addr = (FSR_START_ROW_ADDR+7), .range = 2, .conf = {.op_type = OTP_HW_CMN_CTL_CONF}},	\
	};
	
/* Not implemented yet*/
typedef struct FsrPortal {
#define FSR_FP_OTP_CMD_READ_DATA		0x2
#define FSR_FP_OTP_CMD_READ_OPCODE_MASK		0xf
#define FSR_FP_OTP_CMD_READ_OPCODE_SHIFT	0
#define FSR_FP_OTP_CMD_WORD_SEL_MASK		0xfff
#define FSR_FP_OTP_CMD_WORD_SEL_SHIFT		4
	u32 fp_otp_cmd;                 	/* 0x0       */
#define FSR_FP_OTP_STATUS_ACTIVE_MASK		0x1	
#define FSR_FP_OTP_STATUS_ACTIVE_SHIFT		31	
#define FSR_FP_OTP_STATUS_ERR_MASK		0xff
#define FSR_FP_OTP_STATUS_ERR_SHIFT		0	
	u32 fp_otp_status;              	/* 0x04       */
	u32 fp_data;                 	/* 0x08      */
	u32 fp_rd_ecc;                	/* 0x0c       */
#define FSR_FP_PORTAL_STATUS_READY_MASK		0x1
#define FSR_FP_PORTAL_STATUS_READY_SHIFT	21
#define FSR_FP_PORTAL_STATUS_DESC_VALID_MASK	0x1
#define FSR_FP_PORTAL_STATUS_DESC_VALID_SHIFT	20
	u32 fp_portal_status;           /* 0x10       */
	u32 fp_rsvd[3];
} fsr_portal_t;

#define FSR_PORTAL_0 ((volatile fsr_portal_t * const) FSR_BASE)




#endif

