/* SPDX-License-Identifier: GPL-2.0+
 *
 *  Copyright 2019 Broadcom Ltd.
 */

#include <common.h>
#include <asm/arch/ddr.h>

#include "spl_ddrinit.h"

/*
	op - operation type
		0 - read, 32 bit read operation
		1 - write, 32 bit write operation
		2 - poll read, read until the value read mactches read_value&mask
*/
#define REG_OP_READ	0x0
#define REG_OP_WRITE	0x1
#define REG_OP_POLL	0x2

typedef struct _reg_entry {
	uint32_t op;
	uint32_t addr;
	uint32_t mask;
	uint32_t value;
} reg_entry;

reg_entry reg_table[] = {
#ifdef CONFIG_BCM63146
        {1, 0x800400b8, 0, 0x12345678},
        {0, 0x800400b8, 0, 0x12345678},
        {0, 0x80040e88, 0, 0x00030003},
        {1, 0x80040e88, 0, 0x80030003},
        {0, 0x80040914, 0, 0x00000011},
        {0, 0x80040008, 0, 0x01000000},
        {1, 0x80040008, 0, 0x01000000},
        {1, 0x8004091c, 0, 0x00000307},
        {1, 0x80060364, 0, 0x00000001},
        {1, 0x80060228, 0, 0x02000000},
        {1, 0x8006022c, 0, 0x00000a0e},
        {1, 0x80060230, 0, 0x00000000},
        {1, 0x80060030, 0, 0x00000000},
        {1, 0x8006002c, 0, 0x00000000},
        {1, 0x80060014, 0, 0x00000003},
        {1, 0x80060018, 0, 0x00000000},
        {1, 0x80060020, 0, 0x00000032},
        {1, 0x80060024, 0, 0x02a99999},
        {0, 0x80060034, 0, 0x00000001},
        {1, 0x80060034, 0, 0x00000003},
        {1, 0x80060044, 0, 0x00000101},
        {1, 0x80060018, 0, 0x00000001},
        {0, 0x8006000c, 0, 0x00004001},
        {1, 0x80060018, 0, 0x00000001},
        {0, 0x80040008, 0, 0x01000000},
        {1, 0x80040008, 0, 0x01000000},
        {1, 0x80040008, 0, 0x01000200},
        {1, 0x8006002c, 0, 0x00000000},
        {0, 0x8006035c, 0, 0x00000011},
        {1, 0x8006035c, 0, 0x00000010},
        {1, 0x80060064, 0, 0x00072020},
        {0, 0x80060388, 0, 0x07f8f0f0},
        {1, 0x80060388, 0, 0x27f8f0f0},
        {0, 0x8006035c, 0, 0x00000010},
        {1, 0x8006035c, 0, 0x00000000},
        {1, 0x8006035c, 0, 0x00000008},
        {1, 0x8006034c, 0, 0x00000000},
        {1, 0x80060354, 0, 0x00000000},
        {1, 0x80060344, 0, 0x00000000},
        {1, 0x8006020c, 0, 0x00031bff},
        {1, 0x80060210, 0, 0x00031bff},
        {1, 0x80060078, 0, 0x00031bff},
        {1, 0x8006007c, 0, 0x00031bff},
        {1, 0x80060720, 0, 0x00031bff},
        {1, 0x80060724, 0, 0x00031bff},
        {1, 0x80060728, 0, 0x00031bff},
        {1, 0x80060920, 0, 0x00031bff},
        {1, 0x80060924, 0, 0x00031bff},
        {1, 0x80060928, 0, 0x00031bff},
        {0, 0x80060220, 0, 0x40000002},
        {1, 0x80060220, 0, 0x40000002},
        {0, 0x80060050, 0, 0x0000000c},
        {1, 0x80060050, 0, 0x0000000c},
        {0, 0x80060068, 0, 0x00180000},
        {1, 0x80060068, 0, 0x00180000},
        {1, 0x80060368, 0, 0x00001000},
        {0, 0x800606d0, 0, 0x00000000},
        {1, 0x80060734, 0, 0x0000083c},
        {0, 0x800608d0, 0, 0x00000000},
        {1, 0x80060934, 0, 0x0000083c},
        {1, 0x80060380, 0, 0x00000000},
        {1, 0x80060718, 0, 0x00000000},
        {1, 0x80060918, 0, 0x00000000},
        {0, 0x8006072c, 0, 0x00020000},
        {1, 0x8006072c, 0, 0x00020000},
        {1, 0x8006092c, 0, 0x00020000},
        {1, 0x80060730, 0, 0x001241c3},
        {1, 0x80060930, 0, 0x001241c3},
        {0, 0x8006071c, 0, 0x00c0000a},
        {1, 0x8006071c, 0, 0x0000000a},
        {1, 0x8006091c, 0, 0x0000000a},
        {0, 0x80060388, 0, 0x27f8f0f0},
        {1, 0x80060388, 0, 0x07f8f0f0},
        {1, 0x80060364, 0, 0x00000001},
        {0, 0x80060364, 0, 0x00000003},
        {0, 0x80060388, 0, 0x07f8f0f0},
        {1, 0x80060388, 0, 0x27f8f0f0},
        {0, 0x80060388, 0, 0x27f8f0f0},
        {1, 0x80060388, 0, 0x2ff8f0f0},
        {0, 0x8006038c, 0, 0x00000000},
        {1, 0x8006038c, 0, 0x00000040},
        {0, 0x80060304, 0, 0x00000000},
        {0, 0x80060304, 0, 0x00000000},
        {1, 0x800602d4, 0, 0xe0820228},
        {1, 0x800602e0, 0, 0x80820228},
        {1, 0x800602ec, 0, 0x60820228},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0830000},
        {1, 0x800602e0, 0, 0x80830000},
        {1, 0x800602ec, 0, 0x60830000},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0810006},
        {1, 0x800602e0, 0, 0x80810006},
        {1, 0x800602ec, 0, 0x60810006},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0801124},
        {1, 0x800602e0, 0, 0x80801124},
        {1, 0x800602ec, 0, 0x60801124},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0300400},
        {1, 0x800602e0, 0, 0x80300400},
        {1, 0x800602ec, 0, 0x60300400},
        {1, 0x80060364, 0, 0x00000000},
        {0, 0x80060364, 0, 0x00000000},
        {0, 0x80060308, 0, 0x00011124},
        {0, 0x8006030c, 0, 0x00010006},
        {0, 0x80060310, 0, 0x00010228},
        {0, 0x80060314, 0, 0x00010000},
        {1, 0x80040918, 0, 0x000003f1},
        {0, 0x80040008, 0, 0x01000200},
        {1, 0x80040008, 0, 0x01000600},
        {1, 0x800403a8, 0, 0x00000011},
        {1, 0x800403b8, 0, 0x0000000a},
        {1, 0x80040390, 0, 0x100f0e0d},
        {1, 0x8004038c, 0, 0x14131211},
        {1, 0x80040388, 0, 0x18171615},
        {1, 0x80040384, 0, 0x001b1a19},
        {1, 0x80040380, 0, 0x00000000},
        {1, 0x800403a4, 0, 0x000c0b0a},
	/* SKIP MEMC SRAM disable. Used by MMU table */
#if 0
        {0, 0x80040310, 0, 0x80000001},
        {1, 0x80040310, 0, 0x00000001},
#endif
        {1, 0x8004092c, 0, 0x000e0a0e},
        {1, 0x80040930, 0, 0x00040007},
        {1, 0x80040934, 0, 0x00000000},
        {1, 0x80040938, 0, 0x26000e24},
        {1, 0x8004093c, 0, 0x00081000},
        {1, 0x80040940, 0, 0x00000000},
        {1, 0x80040944, 0, 0x00000408},
        {1, 0x80040948, 0, 0x0002000b},
        {1, 0x8004094c, 0, 0x01560056},
        {1, 0x80040954, 0, 0x40001100},
        {1, 0x80040958, 0, 0x008d0118},
        {0, 0x80040048, 0, 0x04100002},
        {1, 0x80040048, 0, 0x04100002},
        {1, 0x8004004c, 0, 0x00000380},
        {1, 0x80040050, 0, 0x00000000},
        {1, 0x80040054, 0, 0x08080808},
        {1, 0x80040058, 0, 0x000000e4},
        {0, 0x80040908, 0, 0x00000000},
        {1, 0x80040908, 0, 0x00000001},
        {0, 0x80040910, 0, 0x00000000},
        {1, 0x80040910, 0, 0x00000005},
        {0, 0x80040008, 0, 0x01000600},
        {1, 0x80040008, 0, 0x81000700},
        {0, 0x80040008, 0, 0x81000700},
	{0, 0, 0, 0x9},   /* hijack last entry value for total ddr size */
#endif

#if defined(CONFIG_BCM4912) || defined(CONFIG_BCM6813)
	/* 2x4096Mbit DDR3 1067Mz */
        {1, 0x800400b8, 0, 0x12345678},
        {0, 0x800400b8, 0, 0x12345678},
        {0, 0x80040e88, 0, 0x00030003},
        {1, 0x80040e88, 0, 0x80030003},
        {0, 0x80040914, 0, 0x00000011},
        {0, 0x80040008, 0, 0x01000000},
        {1, 0x80040008, 0, 0x01000000},
        {1, 0x8004091c, 0, 0x00000307},
        {1, 0x80060364, 0, 0x00000001},
        {1, 0x80060228, 0, 0x00000000},
        {1, 0x8006022c, 0, 0x00000a0e},
        {1, 0x80060230, 0, 0x00000000},
        {1, 0x80060030, 0, 0x00000000},
        {1, 0x8006002c, 0, 0x00000000},
        {1, 0x80060014, 0, 0x00000003},
        {1, 0x80060018, 0, 0x00000000},
        {1, 0x80060020, 0, 0x00000032},
        {1, 0x80060024, 0, 0x02a99999},
        {1, 0x80060044, 0, 0x00000101},
        {1, 0x80060018, 0, 0x00000001},
        {0, 0x8006000c, 0, 0x00004001},
        {1, 0x80060018, 0, 0x00000003},
        {0, 0x80040008, 0, 0x01000000},
        {1, 0x80040008, 0, 0x01000000},
        {1, 0x80040008, 0, 0x01000200},
        {1, 0x8006002c, 0, 0x00000000},
        {0, 0x8006035c, 0, 0x00000011},
        {1, 0x8006035c, 0, 0x00000010},
        {1, 0x80060064, 0, 0x00072020},
        {0, 0x80060388, 0, 0x07f8f0f0},
        {1, 0x80060388, 0, 0x27f8f0f0},
        {0, 0x8006035c, 0, 0x00000010},
        {1, 0x8006035c, 0, 0x00000000},
        {1, 0x8006035c, 0, 0x00000008},
        {1, 0x8006034c, 0, 0x00000000},
        {1, 0x80060354, 0, 0x00000000},
        {1, 0x80060344, 0, 0x00000000},
        {1, 0x8006020c, 0, 0x00031bff},
        {1, 0x80060210, 0, 0x00031bff},
        {1, 0x80060078, 0, 0x00031bff},
        {1, 0x8006007c, 0, 0x00031bff},
        {1, 0x80060720, 0, 0x00031bff},
        {1, 0x80060724, 0, 0x00031bff},
        {1, 0x80060728, 0, 0x00031bff},
        {1, 0x80060920, 0, 0x00031bff},
        {1, 0x80060924, 0, 0x00031bff},
        {1, 0x80060928, 0, 0x00031bff},
        {1, 0x80060b20, 0, 0x00031bff},
        {1, 0x80060b24, 0, 0x00031bff},
        {1, 0x80060b28, 0, 0x00031bff},
        {1, 0x80060d20, 0, 0x00031bff},
        {1, 0x80060d24, 0, 0x00031bff},
        {1, 0x80060d28, 0, 0x00031bff},
        {0, 0x80060220, 0, 0x40000002},
        {1, 0x80060220, 0, 0x40000002},
        {0, 0x80060050, 0, 0x0000000c},
        {1, 0x80060050, 0, 0x0000000c},
        {0, 0x80060068, 0, 0x00180000},
        {1, 0x80060068, 0, 0x00180000},
        {1, 0x80060368, 0, 0x00001000},
        {0, 0x800606d0, 0, 0x00000000},
        {1, 0x80060734, 0, 0x0000083c},
        {0, 0x800608d0, 0, 0x00000000},
        {1, 0x80060934, 0, 0x0000083c},
        {0, 0x80060ad0, 0, 0x00000000},
        {1, 0x80060b34, 0, 0x0000083c},
        {0, 0x80060cd0, 0, 0x00000000},
        {1, 0x80060d34, 0, 0x0000083c},
        {1, 0x80060380, 0, 0x00000000},
        {1, 0x80060718, 0, 0x00000000},
        {1, 0x80060918, 0, 0x00000000},
        {1, 0x80060b18, 0, 0x00000000},
        {1, 0x80060d18, 0, 0x00000000},
        {0, 0x8006072c, 0, 0x00020000},
        {1, 0x8006072c, 0, 0x00020000},
        {1, 0x8006092c, 0, 0x00020000},
        {1, 0x80060b2c, 0, 0x00020000},
        {1, 0x80060d2c, 0, 0x00020000},
        {1, 0x80060730, 0, 0x001241c3},
        {1, 0x80060930, 0, 0x001241c3},
        {1, 0x80060b30, 0, 0x001241c3},
        {1, 0x80060d30, 0, 0x001241c3},
        {0, 0x8006071c, 0, 0x00c0000a},
        {1, 0x8006071c, 0, 0x0000000a},
        {1, 0x8006091c, 0, 0x0000000a},
        {1, 0x80060b1c, 0, 0x0000000a},
        {1, 0x80060d1c, 0, 0x0000000a},
        {0, 0x80060388, 0, 0x27f8f0f0},
        {1, 0x80060388, 0, 0x07f8f0f0},
        {1, 0x80060364, 0, 0x00000001},
        {0, 0x80060364, 0, 0x00000003},
        {0, 0x80060388, 0, 0x07f8f0f0},
        {1, 0x80060388, 0, 0x27f8f0f0},
        {0, 0x80060388, 0, 0x27f8f0f0},
        {1, 0x80060388, 0, 0x2ff8f0f0},
        {0, 0x8006038c, 0, 0x00000000},
        {1, 0x8006038c, 0, 0x00000040},
        {0, 0x80060304, 0, 0x00000000},
        {0, 0x80060304, 0, 0x00000000},
        {1, 0x800602d4, 0, 0xe0820228},
        {1, 0x800602e0, 0, 0x80820228},
        {1, 0x800602ec, 0, 0x60820228},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0830000},
        {1, 0x800602e0, 0, 0x80830000},
        {1, 0x800602ec, 0, 0x60830000},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0810006},
        {1, 0x800602e0, 0, 0x80810006},
        {1, 0x800602ec, 0, 0x60810006},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0801124},
        {1, 0x800602e0, 0, 0x80801124},
        {1, 0x800602ec, 0, 0x60801124},
        {0, 0x80060304, 0, 0x00000002},
        {0, 0x80060304, 0, 0x00000002},
        {1, 0x80060304, 0, 0x00000002},
        {1, 0x800602d4, 0, 0xe0300400},
        {1, 0x800602e0, 0, 0x80300400},
        {1, 0x800602ec, 0, 0x60300400},
        {1, 0x80060364, 0, 0x00000000},
        {0, 0x80060364, 0, 0x00000000},
        {0, 0x80060308, 0, 0x00011124},
        {0, 0x8006030c, 0, 0x00010006},
        {0, 0x80060310, 0, 0x00010228},
        {0, 0x80060314, 0, 0x00010000},
        {1, 0x80040918, 0, 0x000000a1},
        {0, 0x80040008, 0, 0x01000200},
        {1, 0x80040008, 0, 0x01000600},
        {1, 0x800403a8, 0, 0x00000021},
        {1, 0x800403b8, 0, 0x0000000a},
        {1, 0x80040390, 0, 0x100f0e0d},
        {1, 0x8004038c, 0, 0x14131211},
        {1, 0x80040388, 0, 0x18171615},
        {1, 0x80040384, 0, 0x001b1a19},
        {1, 0x80040380, 0, 0x00000000},
        {1, 0x800403a4, 0, 0x000c0b0a},
	/* SKIP MEMC SRAM disable. Used by MMU table */
#if 0
        {0, 0x80040310, 0, 0x80000001},
        {1, 0x80040310, 0, 0x00000001},
#endif
        {1, 0x8004092c, 0, 0x000e0a0e},
        {1, 0x80040930, 0, 0x00040007},
        {1, 0x80040934, 0, 0x00000000},
        {1, 0x80040938, 0, 0x26000e24},
        {1, 0x8004093c, 0, 0x00081000},
        {1, 0x80040940, 0, 0x00000000},
        {1, 0x80040944, 0, 0x00000408},
        {1, 0x80040948, 0, 0x0002000b},
        {1, 0x8004094c, 0, 0x01560056},
        {1, 0x80040954, 0, 0x40001100},
        {1, 0x80040958, 0, 0x008d0118},
        {0, 0x80040048, 0, 0x04100002},
        {1, 0x80040048, 0, 0x04100002},
        {1, 0x8004004c, 0, 0x00000380},
        {1, 0x80040050, 0, 0x00000000},
        {1, 0x80040054, 0, 0x08080808},
        {1, 0x80040058, 0, 0x000000e4},
        {0, 0x80040908, 0, 0x00000000},
        {1, 0x80040908, 0, 0x00000001},
        {0, 0x80040910, 0, 0x00000007},
        {1, 0x80040910, 0, 0x00000005},
        {0, 0x80040008, 0, 0x01000600},
        {1, 0x80040008, 0, 0x81000700},
        {0, 0x80040008, 0, 0x81000700},
	{0, 0, 0, 0xa},   /* 1GB hijack last entry value for total ddr size */
#endif
};

static uint32_t run_reg_init(void)
{
	reg_entry* entry = &reg_table[0];
	uint32_t value;

	while (entry->addr) {
		switch(entry->op) {
			case REG_OP_READ:
				value = *((volatile uint32_t*)(uintptr_t)entry->addr);
				/* printf("ddr_regs         read32   : addr=0x00%08x, data=0x%08x\n", entry->addr, value); */
			break;

			case REG_OP_WRITE:
				*((volatile uint32_t*)(uintptr_t)entry->addr) = entry->value;
				/* printf("ddr_regs         write32  : addr=0x00%08x, data=0x%08x\n", entry->addr, entry->value); */
			break;

			case REG_OP_POLL:
				while ((value = *((volatile uint32_t*)(uintptr_t)entry->addr))
					!= (entry->value&entry->mask));
			break;
		}
		entry++;
	}

	return 1<<(entry->value);
}

/* return 1 if there is alias, 0 no alias.  memsize in MB */
static int memc_alias_test(uint32_t memsize)
{
	int ret = 0;
	volatile uint32_t *base_addr;
	volatile uint32_t *test_addr;
	uint64_t test_size, total_size;
#ifdef CONFIG_BCMBCA_IKOS
	uint32_t data;
#endif


	total_size = ((uint64_t) (memsize)) << 20;
	base_addr = (volatile uint32_t *)((uintptr_t) CONFIG_SYS_SDRAM_BASE);

	for (test_size = 256; test_size < total_size;
	     test_size = test_size << 1) {
		test_addr =
		    (volatile uint32_t *)((uintptr_t) base_addr +
					  (uintptr_t) test_size);
#if defined(PHYS_SDRAM_2)
		/* if we are over the lower memory region from 0 to 2GB, we shift to the upper memory region */
		if (test_size >= PHYS_SDRAM_1_SIZE)
			test_addr =
			    (volatile uint32_t *)((uintptr_t) test_addr +
						  PHYS_SDRAM_1_SIZE);
#endif
#ifdef CONFIG_BCMBCA_IKOS
		data = *test_addr;
#endif
		*base_addr = 0;
		*test_addr = 0xaa55beef;
		if (*base_addr == *test_addr) {
			ret = 1;
			break;
		}
#ifdef CONFIG_BCMBCA_IKOS
		*test_addr = data;
#endif
	}

	return ret;
}

/* return 1 if there is error, 0 no error.  memsize in MB */
static int memc_memory_test(uint32_t memsize)
{
	volatile uint32_t *temp;
	volatile uint32_t *addr;
	int i, ret = 0;
	uint32_t data;

	addr = (volatile uint32_t *)CONFIG_SYS_SDRAM_BASE;
	for (temp = addr, i = 0; i < 1024; i++)
		*temp++ = i;

	for (temp = addr, i = 0; i < 1024; i++) {
		data = *temp++;
		if (data != i)
			break;
	}

	if (i == 1024)
		printf("DDR test done successfully\n\r");
	else {
		printf("DDR test failed i=%d\n\r", i);
		ret = -2;
	}

	return ret;
}

int ddr_init_reg(ddr_init_param * ddrinit_params)
{
	int ret;
	uint32_t ddr_size_MB;

	ddr_size_MB = run_reg_init();
	printf("ddr init done total size %dMB\n", ddr_size_MB);

	/* make sure configure register write are really carried over to target block */
	__asm__ __volatile__("dsb	sy");
	__asm__ __volatile__("isb");

	if (memc_alias_test(ddr_size_MB)) {
		printf("\nMemory alias detected. Probably wrong memory size is specified or memory subsystem not working\n");
		return -3;
	}

	if (ret = memc_memory_test(ddr_size_MB))
		return ret;

	if (ddrinit_params && ddrinit_params->ddr_size != NULL)
		*ddrinit_params->ddr_size = ddr_size_MB;

	return ret;
}
