/* SPDX-License-Identifier: GPL-2.0+
 *
 *  Copyright 2020 Broadcom Ltd.
 */

#ifndef _6756_ETHSW_H
#define _6756_ETHSW_H

#include <config.h>
#include <stdlib.h>

typedef struct {
    uint32_t led_ctrl;
#define SPDLNK_LED1_ACT_POL_SEL_SHIFT 7
#define SPDLNK_LED1_ACT_POL_SEL_MASK (0x1 << SPDLNK_LED1_ACT_POL_SEL_SHIFT)
#define ACT_LED_ACT_SEL_SHIFT 5
#define ACT_LED_ACT_SEL_MASK (0x1 << ACT_LED_ACT_SEL_SHIFT)
#define SPDLNK_LED0_ACT_SEL_SHIFT 2
#define SPDLNK_LED0_ACT_SEL_MASK (0x1 << SPDLNK_LED0_ACT_SEL_SHIFT)
#define RESERVED0_SHIFT 16
#define RESERVED0_MASK (0xffff << RESERVED0_SHIFT)
#define SPDLNK_LED0_ACT_POL_SEL_SHIFT 6
#define SPDLNK_LED0_ACT_POL_SEL_MASK (0x1 << SPDLNK_LED0_ACT_POL_SEL_SHIFT)
#define AGGREGATE_LED_CNTRL_RESERVED0_SHIFT 19
#define AGGREGATE_LED_CNTRL_RESERVED0_MASK (0x1fff << AGGREGATE_LED_CNTRL_RESERVED0_SHIFT)
#define AGGREGATE_LED_CNTRL_ACT_POL_SEL_SHIFT 17
#define AGGREGATE_LED_CNTRL_ACT_POL_SEL_MASK (0x1 << AGGREGATE_LED_CNTRL_ACT_POL_SEL_SHIFT)
#define SPDLNK_LED2_ACT_SEL_SHIFT 4
#define SPDLNK_LED2_ACT_SEL_MASK (0x1 << SPDLNK_LED2_ACT_SEL_SHIFT)
#define LED_SPD_OVRD_SHIFT 10
#define LED_SPD_OVRD_MASK (0x7 << LED_SPD_OVRD_SHIFT)
#define SPDLNK_LED2_ACT_POL_SEL_SHIFT 8
#define SPDLNK_LED2_ACT_POL_SEL_MASK (0x1 << SPDLNK_LED2_ACT_POL_SEL_SHIFT)
#define SPD_OVRD_EN_SHIFT 14
#define SPD_OVRD_EN_MASK (0x1 << SPD_OVRD_EN_SHIFT)
#define TX_ACT_EN_SHIFT 1
#define TX_ACT_EN_MASK (0x1 << TX_ACT_EN_SHIFT)
#define AGGREGATE_LED_CNTRL_ACT_SEL_SHIFT 16
#define AGGREGATE_LED_CNTRL_ACT_SEL_MASK (0x1 << AGGREGATE_LED_CNTRL_ACT_SEL_SHIFT)
#define LNK_STATUS_OVRD_SHIFT 13
#define LNK_STATUS_OVRD_MASK (0x1 << LNK_STATUS_OVRD_SHIFT)
#define RX_ACT_EN_SHIFT 0
#define RX_ACT_EN_MASK (0x1 << RX_ACT_EN_SHIFT)
#define AGGREGATE_LED_CNTRL_LNK_POL_SEL_SHIFT 18
#define AGGREGATE_LED_CNTRL_LNK_POL_SEL_MASK (0x1 << AGGREGATE_LED_CNTRL_LNK_POL_SEL_SHIFT)
#define SPDLNK_LED1_ACT_SEL_SHIFT 3
#define SPDLNK_LED1_ACT_SEL_MASK (0x1 << SPDLNK_LED1_ACT_SEL_SHIFT)
#define ACT_LED_POL_SEL_SHIFT 9
#define ACT_LED_POL_SEL_MASK (0x1 << ACT_LED_POL_SEL_SHIFT)
#define LNK_OVRD_EN_SHIFT 15
#define LNK_OVRD_EN_MASK (0x1 << LNK_OVRD_EN_SHIFT)
#define AGGREGATE_LED_CNTRL_PORT_EN_SHIFT 0
#define AGGREGATE_LED_CNTRL_PORT_EN_MASK (0xffff << AGGREGATE_LED_CNTRL_PORT_EN_SHIFT)
    uint32_t led_encoding_sel;
    uint32_t led_encoding;
#define LINK_AND_SPEED_ENCODING_M10G_ENCODE_SHIFT 15
#define LINK_AND_SPEED_ENCODING_M10G_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_M10G_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_SEL_SEL_10M_ENCODE_SHIFT 3
#define LINK_AND_SPEED_ENCODING_SEL_SEL_10M_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_SEL_SEL_10M_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_SEL_SEL_100M_ENCODE_SHIFT 6
#define LINK_AND_SPEED_ENCODING_SEL_SEL_100M_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_SEL_SEL_100M_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_SEL_SEL_10G_ENCODE_SHIFT 15
#define LINK_AND_SPEED_ENCODING_SEL_SEL_10G_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_SEL_SEL_10G_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_M10_ENCODE_SHIFT 3
#define LINK_AND_SPEED_ENCODING_M10_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_M10_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_M1000_ENCODE_SHIFT 9
#define LINK_AND_SPEED_ENCODING_M1000_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_M1000_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_SEL_SEL_2500M_ENCODE_SHIFT 12
#define LINK_AND_SPEED_ENCODING_SEL_SEL_2500M_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_SEL_SEL_2500M_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_M100_ENCODE_SHIFT 6
#define LINK_AND_SPEED_ENCODING_M100_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_M100_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_SEL_SEL_1000M_ENCODE_SHIFT 9
#define LINK_AND_SPEED_ENCODING_SEL_SEL_1000M_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_SEL_SEL_1000M_ENCODE_SHIFT)
#define LINK_AND_SPEED_ENCODING_M2500_ENCODE_SHIFT 12
#define LINK_AND_SPEED_ENCODING_M2500_ENCODE_MASK (0x7 << LINK_AND_SPEED_ENCODING_M2500_ENCODE_SHIFT)

}LED_CFG;

/* leaving the definition of the QPHY register for compilation only */
#define ETHSW_QPHY_CTRL_PHYAD_BASE_SHIFT     12
#define ETHSW_QPHY_CTRL_PHYAD_BASE_MASK      (0x1f<<ETHSW_QPHY_CTRL_PHYAD_BASE_SHIFT)
#define ETHSW_QPHY_CTRL_RESET_SHIFT          8
#define ETHSW_QPHY_CTRL_RESET_MASK           (0x1<<ETHSW_QPHY_CTRL_RESET_SHIFT )
#define ETHSW_QPHY_CTRL_CK25_DIS_SHIFT       7
#define ETHSW_QPHY_CTRL_CK25_DIS_MASK        (0x1<<ETHSW_QPHY_CTRL_CK25_DIS_SHIFT)
#define ETHSW_QPHY_CTRL_EXT_PWR_DOWN_SHIFT   1
#define ETHSW_QPHY_CTRL_EXT_PWR_DOWN_MASK    (0xf<<ETHSW_QPHY_CTRL_EXT_PWR_DOWN_SHIFT)
#define ETHSW_QPHY_CTRL_IDDQ_BIAS_SHIFT      0
#define ETHSW_QPHY_CTRL_IDDQ_BIAS_MASK       (0x1<<ETHSW_QPHY_CTRL_IDDQ_BIAS_SHIFT)
#define ETHSW_QPHY_CTRL_IDDQ_GLOBAL_PWR_SHIFT      6
#define ETHSW_QPHY_CTRL_IDDQ_GLOBAL_PWR_MASK       (0x1<<ETHSW_QPHY_CTRL_IDDQ_GLOBAL_PWR_SHIFT)

typedef struct EthernetSwitchReg
{
    uint32_t switch_ctrl;                      /* 0x0000 */
#define ETHSW_SWITCH_CTRL_SWITCH_CLK_SEL_SHIFT  27
#define ETHSW_SWITCH_CTRL_SWITCH_CLK_SEL_MASK   (0x3<<ETHSW_SWITCH_CTRL_SWITCH_CLK_SEL_SHIFT)
#define ETHSW_SWITCH_CTRL_SYSPORT_CLK_SEL_SHIFT 24
#define ETHSW_SWITCH_CTRL_SYSPORT_CLK_SEL_MASK  (0x3<<ETHSW_SWITCH_CTRL_SYSPORT_CLK_SEL_SHIFT)
#define ETHSW_SWITCH_CTRL_P8_CLK_SEL_SHIFT      3
#define ETHSW_SWITCH_CTRL_P8_CLK_SEL_MASK       (0x3<<ETHSW_SWITCH_CTRL_P8_CLK_SEL_SHIFT)
    uint32_t switch_status;                    /* 0x0004 */
    uint32_t dir_data_write_reg;               /* 0x0008 */
    uint32_t dir_data_read_reg;                /* 0x000c */
    uint32_t switch_rev;                       /* 0x0010 */
    uint32_t phy_rev;                          /* 0x0014 */
    uint32_t phy_test_ctrl;                    /* 0x0018 */
    uint32_t reserved1[2];                     /* 0x001c */
    uint32_t sphy_ctrl;                        /* 0x0024 */
#define ETHSW_SPHY_CTRL_REF_CLK_SHIFT       15
#define ETHSW_SPHY_CTRL_REF_CLK_50MHZ       (2<<ETHSW_SPHY_CTRL_REF_CLK_SHIFT)
#define ETHSW_SPHY_CTRL_PHYAD_SHIFT          8
#define ETHSW_SPHY_CTRL_PHYAD_MASK           (0x1f<<ETHSW_SPHY_CTRL_PHYAD_SHIFT)
#define ETHSW_SPHY_CTRL_RESET_SHIFT          5
#define ETHSW_SPHY_CTRL_RESET_MASK           (0x1<<ETHSW_SPHY_CTRL_RESET_SHIFT )
#define ETHSW_SPHY_CTRL_CK25_DIS_SHIFT       4
#define ETHSW_SPHY_CTRL_CK25_DIS_MASK        (0x1<<ETHSW_SPHY_CTRL_CK25_DIS_SHIFT)
#define ETHSW_SPHY_CTRL_EXT_PWR_DOWN_SHIFT   1
#define ETHSW_SPHY_CTRL_EXT_PWR_DOWN_MASK    (0x1<<ETHSW_SPHY_CTRL_EXT_PWR_DOWN_SHIFT)
#define ETHSW_SPHY_CTRL_IDDQ_BIAS_SHIFT      0
#define ETHSW_SPHY_CTRL_IDDQ_BIAS_MASK       (0x1<<ETHSW_SPHY_CTRL_IDDQ_BIAS_SHIFT)
#define ETHSW_SPHY_CTRL_IDDQ_GLOBAL_PWR_SHIFT      3
#define ETHSW_SPHY_CTRL_IDDQ_GLOBAL_PWR_MASK       (0x1<<ETHSW_SPHY_CTRL_IDDQ_GLOBAL_PWR_SHIFT)
    uint32_t sphy_status;                      /* 0x0028 */
    uint32_t switch_phy_intr_ctrl;             /* 0x002c */
    uint32_t reserved30[2];                    /* 0x0030 - 0x0037 */
    uint32_t led_pwm_ctrl;                     /* 0x0038 */
    uint32_t led_intensity_ctrl;               /* 0x003c */
    LED_CFG led_ctrl[10];                    /* 0x0040 - 0x00b7 */  //6756: port 0,1,5,6 are populated
#define ETHSW_LED_CTRL_SPD0_ON               0x0
#define ETHSW_LED_CTRL_SPD0_OFF              0x1
#define ETHSW_LED_CTRL_SPD1_ON               0x0
#define ETHSW_LED_CTRL_SPD1_OFF              0x2
#define ETHSW_LED_CTRL_1000M_SHIFT           9
#define ETHSW_LED_CTRL_100M_SHIFT            6
#define ETHSW_LED_CTRL_10M_SHIFT             3
#define ETHSW_LED_CTRL_NOLINK_SHIFT          0
#define ETHSW_LED_CTRL_ALL_SPEED_MASK        0x3ffff
#define ETHSW_LED_CTRL_SPEED_MASK            0x7
    uint32_t led_blink_rate_ctrl;              /* 0x00b8 */
    uint32_t reserved_bc;                      /* 0x00bc */           //63178: led_serial_ctrl not populated
    uint32_t led_refresh_period_ctrl;          /* 0x00c0 */
    uint32_t aggregate_led_ctrl;               /* 0x00c4 */
#define ETHSW_AGGREGATE_LED_CTRL_PORT_EN_MASK            0xffff
#define ETHSW_AGGREGATE_LED_CTRL_ACT_SEL_MASK            0x10000
#define ETHSW_AGGREGATE_LED_CTRL_ACT_POL_SEL_MASK        0x20000
#define ETHSW_AGGREGATE_LED_CTRL_LNK_POL_SEL_MASK        0x40000
    uint32_t aggregate_blink_rate_ctrl;        /* 0x00c8 */
    uint32_t aggregate_led_pwm_ctrl;           /* 0x00cc */
    uint32_t aggregate_led_intensity_ctrl;     /* 0x00d0 */
    uint32_t resereved_d4[6];                  /* 0x00d4 - 0x00eb */
    uint32_t rgmii_1_ctrl;                     /* 0x00ec */
#define ETHSW_RC_MII_MODE_MASK               0x1c
#define ETHSW_RC_EXT_RVMII                   0x10
#define ETHSW_RC_EXT_GPHY                    0x0c
#define ETHSW_RC_EXT_EPHY                    0x08
#define ETHSW_RC_INT_GPHY                    0x04
#define ETHSW_RC_INT_EPHY                    0x00
#define ETHSW_RC_ID_MODE_DIS                 0x02
#define ETHSW_RC_RGMII_EN                    0x01
    uint32_t rgmii_1_ib_status;                /* 0x00f0 */
    uint32_t rgmii_1_rx_clk_delay_ctrl;        /* 0x00f4 */
#define ETHSW_RXCLK_IDDQ                     (1<<4)
#define ETHSW_RXCLK_BYPASS                   (1<<5)

    uint32_t reserved_f8[210];                 /* 0x00f8 - 0x043f */
    uint32_t moca_bp_mapping_port1;            /* 0x0440*/
} EthernetSwitchReg;


typedef struct {
    unsigned int led_f;
    unsigned int reserved;
} LED_F;

typedef struct EthernetSwitchCore
{
	uint64_t port_traffic_ctrl[9];                // 0x00000 - 00047      only p0, p1, p5, p6, p8 are valid
	uint8_t dummy1[8];
	uint64_t SWITCH_CORE_RX_GLOBAL_CTL;           // 0x00050
#define ETHSW_SM_RETRY_LIMIT_DIS                  0x04
#define ETHSW_SM_FORWARDING_EN                    0x02
#define ETHSW_SM_MANAGED_MODE                     0x01
	uint32_t switch_mode;
	uint8_t dummy2[148];
	uint32_t SWITCH_CORE_DEBUG_REG;
	uint8_t dummy3[20];
	uint64_t SWITCH_CORE_NEW_CTRL;
	uint32_t switch_ctrl;
#define ETHSW_SC_MII_DUMP_FORWARDING_EN           0x40
#define ETHSW_SC_MII2_VOL_SEL                     0x02
	uint8_t dummy4[12];
	uint32_t SWITCH_CORE_PROTECTED_SEL;
	uint8_t dummy5[12];
	uint32_t SWITCH_CORE_WAN_PORT_SEL;
	uint8_t dummy6[68];
	uint32_t SWITCH_CORE_RSV_MCAST_CTRL;
	uint8_t dummy7[12];
	uint64_t SWITCH_CORE_TXQ_FLUSH_MODE;
	uint32_t SWITCH_CORE_ULF_DROP_MAP;
	uint8_t dummy8[12];
	uint32_t SWITCH_CORE_MLF_DROP_MAP;
	uint8_t dummy9[12];
	uint32_t SWITCH_CORE_MLF_IPMC_FWD_MAP;
	uint8_t dummy10[12];
	uint32_t SWITCH_CORE_RX_PAUSE_PASS;
	uint8_t dummy11[12];
	uint32_t SWITCH_CORE_TX_PAUSE_PASS;
	uint8_t dummy12[12];
	uint32_t SWITCH_CORE_DIS_LEARN;
	uint8_t dummy13[12];
	uint32_t SWITCH_CORE_SFT_LRN_CTL;
	uint8_t dummy14[12];
	uint32_t SWITCH_CORE_LOW_POWER_EXP1;
	uint8_t dummy15[156];
	uint32_t SWITCH_CORE_CTLREG_REG_SPARE;
	uint8_t dummy16[292];
	uint64_t software_reset;
	uint32_t SWITCH_CORE_WATCH_DOG_RPT1;
	uint8_t dummy17[12];
	uint32_t SWITCH_CORE_WATCH_DOG_RPT2;
	uint8_t dummy18[12];
	uint32_t SWITCH_CORE_WATCH_DOG_RPT3;
	uint8_t dummy19[12];
	uint64_t SWITCH_CORE_PAUSE_FRM_CTRL;
	uint32_t SWITCH_CORE_PAUSE_ST_ADDR;
	uint8_t dummy20[52];
	uint64_t SWITCH_CORE_FAST_AGE_CTRL;
	uint64_t SWITCH_CORE_FAST_AGE_PORT;
	uint32_t SWITCH_CORE_FAST_AGE_VID;
	uint8_t dummy21[668];
	uint32_t SWITCH_CORE_LOW_POWER_CTRL;
	uint8_t dummy22[76];
	uint32_t SWITCH_CORE_TCAM_CTRL;
	uint8_t dummy23[12];
	uint32_t SWITCH_CORE_TCAM_CHKSUM_STS;
	uint8_t dummy24[12];
	uint32_t SWITCH_CORE_LIGHTSTACK_CTRL;
	uint8_t dummy25[156];
	uint32_t SWITCH_CORE_LNKSTS;
	uint8_t dummy26[12];
	uint32_t SWITCH_CORE_LNKSTSCHG;
	uint8_t dummy27[12];
	uint32_t SWITCH_CORE_SPDSTS;
	uint8_t dummy28[28];
	uint32_t SWITCH_CORE_DUPSTS;
	uint8_t dummy29[12];
	uint32_t SWITCH_CORE_PAUSESTS;
	uint8_t dummy30[28];
	uint32_t SWITCH_CORE_SRCADRCHG;
	uint8_t dummy31[12];
	uint32_t SWITCH_CORE_LSA_PORT_P0;
	uint8_t dummy32[44];
	uint32_t SWITCH_CORE_LSA_PORT_P1;
	uint8_t dummy33[44];
	uint32_t SWITCH_CORE_LSA_PORT_P2;
	uint8_t dummy34[44];
	uint32_t SWITCH_CORE_LSA_PORT_P3;
	uint8_t dummy35[44];
	uint32_t SWITCH_CORE_LSA_PORT_P4;
	uint8_t dummy36[44];
	uint32_t SWITCH_CORE_LSA_PORT_P5;
	uint8_t dummy37[44];
	uint32_t SWITCH_CORE_LSA_PORT_P6;
	uint8_t dummy38[44];
	uint32_t SWITCH_CORE_LSA_PORT_P7;
	uint8_t dummy39[44];
	uint32_t SWITCH_CORE_LSA_PORT_P8;
	uint8_t dummy40[44];
	uint32_t SWITCH_CORE_BIST_STS0;
	uint8_t dummy41[44];
	uint32_t SWITCH_CORE_BIST_STS1;
	uint8_t dummy42[28];
	uint32_t SWITCH_CORE_PBPTRFIFO_0;
	uint8_t dummy43[44];
	uint32_t SWITCH_CORE_PBPTRFIFO_1;
	uint8_t dummy44[460];
	uint32_t SWITCH_CORE_RESET_STATUS;
	uint8_t dummy45[124];
	uint32_t SWITCH_CORE_STREG_REG_SPARE0;
	uint8_t dummy46[28];
	uint32_t SWITCH_CORE_STREG_REG_SPARE1;
	uint8_t dummy47[732];
	uint64_t SWITCH_CORE_GMNGCFG;
	uint64_t SWITCH_CORE_IMP0_PRT_ID;
	uint64_t SWITCH_CORE_IMP1_PRT_ID;
	uint32_t brcm_hdr_ctrl;
	uint8_t dummy48[20];
	uint32_t SWITCH_CORE_SPTAGT;
	uint8_t dummy49[28];
	uint32_t SWITCH_CORE_BRCM_HDR_CTRL2;
	uint8_t dummy50[12];
	uint32_t SWITCH_CORE_IPG_SHRNK_CTRL;
	uint8_t dummy51[28];
	uint32_t SWITCH_CORE_MIRCAPCTL;
	uint8_t dummy52[12];
	uint32_t SWITCH_CORE_IGMIRCTL;
	uint8_t dummy53[12];
	uint32_t SWITCH_CORE_IGMIRDIV;
	uint8_t dummy54[12];
	uint32_t SWITCH_CORE_IGMIRMAC;
	uint8_t dummy55[44];
	uint32_t SWITCH_CORE_EGMIRCTL;
	uint8_t dummy56[12];
	uint32_t SWITCH_CORE_EGMIRDIV;
	uint8_t dummy57[12];
	uint32_t SWITCH_CORE_EGMIRMAC;
	uint8_t dummy58[44];
	uint32_t SWITCH_CORE_SPANCTL;
	uint8_t dummy59[28];
	uint32_t SWITCH_CORE_RSPANVLAN;
	uint8_t dummy60[300];
	uint32_t SWITCH_CORE_HL_PRTC_CTRL;
	uint8_t dummy61[28];
	uint32_t SWITCH_CORE_RST_MIB_CNT_EN;
	uint8_t dummy62[28];
	uint32_t SWITCH_CORE_IPG_SHRINK_2G_WA;
	uint8_t dummy63[60];
	uint32_t SWITCH_CORE_BRCM_HDR_RX_DIS;
	uint8_t dummy64[12];
	uint32_t SWITCH_CORE_BRCM_HDR_TX_DIS;
	uint8_t dummy65[108];
	uint32_t SWITCH_CORE_MNGMODE_REG_SPARE0;
	uint8_t dummy66[28];
	uint32_t SWITCH_CORE_MNGMODE_REG_SPARE1;
	uint8_t dummy67[1116];
	uint32_t SWITCH_CORE_INT_STS;
	uint8_t dummy68[60];
	uint32_t SWITCH_CORE_INT_EN;
	uint8_t dummy69[60];
	uint32_t SWITCH_CORE_SLEEP_TIMER_IMP;
	uint8_t dummy70[12];
	uint32_t SWITCH_CORE_PORT7_SLEEP_TIMER;
	uint8_t dummy71[12];
	uint32_t SWITCH_CORE_WAN_SLEEP_TIMER;
	uint8_t dummy72[28];
	uint32_t SWITCH_CORE_PORT_SLEEP_STS;
	uint8_t dummy73[92];
	uint32_t SWITCH_CORE_LINK_STS_INT_EN;
	uint8_t dummy74[28];
	uint32_t SWITCH_CORE_ENG_DET_INT_EN;
	uint8_t dummy75[12];
	uint32_t SWITCH_CORE_LPI_STS_CHG_INT_EN;
	uint8_t dummy76[428];
	uint32_t SWITCH_CORE_MEM_ECC_ERR_INT_STS;
	uint8_t dummy77[12];
	uint32_t SWITCH_CORE_MEM_ECC_ERR_INT_EN;
	uint8_t dummy78[12];
	uint32_t SWITCH_CORE_PORT_EVT_ECC_ERR_STS;
	uint8_t dummy79[12];
	uint32_t SWITCH_CORE_PORT_MIB_ECC_ERR_STS;
	uint8_t dummy80[12];
	uint32_t SWITCH_CORE_PORT_TXQ_ECC_ERR_STS;
	uint8_t dummy81[60];
	uint32_t SWITCH_CORE_PROBE_BUS_CTL;
	uint8_t dummy82[28];
	uint32_t SWITCH_CORE_MDC_EXTEND_CTRL;
	uint8_t dummy83[92];
	uint32_t SWITCH_CORE_PPPOE_SESSION_PARSE_EN;
	uint8_t dummy84[124];
	uint32_t SWITCH_CORE_CTLREG_1_REG_SPARE0;
	uint8_t dummy85[28];
	uint32_t SWITCH_CORE_CTLREG_1_REG_SPARE1;
	uint8_t dummy86[860];
	uint32_t SWITCH_CORE_GARLCFG;
	uint8_t dummy87[28];
	uint32_t SWITCH_CORE_BPDU_MCADDR;
	uint8_t dummy88[76];
	uint32_t SWITCH_CORE_MULTI_PORT_CTL;
	uint8_t dummy89[12];
	uint32_t SWITCH_CORE_MULTIPORT_ADDR0;
	uint8_t dummy90[60];
	uint32_t SWITCH_CORE_MPORTVEC0;
	uint8_t dummy91[60];
	uint32_t SWITCH_CORE_MULTIPORT_ADDR1;
	uint8_t dummy92[60];
	uint32_t SWITCH_CORE_MPORTVEC1;
	uint8_t dummy93[60];
	uint32_t SWITCH_CORE_MULTIPORT_ADDR2;
	uint8_t dummy94[60];
	uint32_t SWITCH_CORE_MPORTVEC2;
	uint8_t dummy95[60];
	uint32_t SWITCH_CORE_MULTIPORT_ADDR3;
	uint8_t dummy96[60];
	uint32_t SWITCH_CORE_MPORTVEC3;
	uint8_t dummy97[60];
	uint32_t SWITCH_CORE_MULTIPORT_ADDR4;
	uint8_t dummy98[60];
	uint32_t SWITCH_CORE_MPORTVEC4;
	uint8_t dummy99[60];
	uint32_t SWITCH_CORE_MULTIPORT_ADDR5;
	uint8_t dummy100[60];
	uint32_t SWITCH_CORE_MPORTVEC5;
	uint8_t dummy101[60];
	uint32_t SWITCH_CORE_ARL_BIN_FULL_CNTR;
	uint8_t dummy102[28];
	uint32_t SWITCH_CORE_ARL_BIN_FULL_FWD;
	uint8_t dummy103[12];
	uint32_t SWITCH_CORE_ARL_SEED;
	uint8_t dummy104[76];
	uint32_t SWITCH_CORE_ARLCTL_REG_SPARE0;
	uint8_t dummy105[28];
	uint32_t SWITCH_CORE_ARLCTL_REG_SPARE1;
	uint8_t dummy106[92];
	uint32_t SWITCH_CORE_ARL_TCAM_CTRL;
	uint8_t dummy107[28];
	uint32_t SWITCH_CORE_ARL_TCAM_STS;
	uint8_t dummy108[28];
	uint32_t SWITCH_CORE_ARL_TCAM_FULL_CNTR;
	uint8_t dummy109[28];
	uint32_t SWITCH_CORE_ARL_CPU_PORTMAP;
	uint8_t dummy110[796];
	uint32_t SWITCH_CORE_ARLA_RWCTL;
	uint8_t dummy111[12];
	uint32_t SWITCH_CORE_ARLA_MAC;
	uint8_t dummy112[44];
	uint32_t SWITCH_CORE_ARLA_VID;
	uint8_t dummy113[60];
	uint32_t SWITCH_CORE_ARLA_MACVID_ENTRY0;
	uint8_t dummy114[60];
	uint32_t SWITCH_CORE_ARLA_FWD_ENTRY0;
	uint8_t dummy115[60];
	uint32_t SWITCH_CORE_ARLA_MACVID_ENTRY1;
	uint8_t dummy116[60];
	uint32_t SWITCH_CORE_ARLA_FWD_ENTRY1;
	uint8_t dummy117[60];
	uint32_t SWITCH_CORE_ARLA_MACVID_ENTRY2;
	uint8_t dummy118[60];
	uint32_t SWITCH_CORE_ARLA_FWD_ENTRY2;
	uint8_t dummy119[60];
	uint32_t SWITCH_CORE_ARLA_MACVID_ENTRY3;
	uint8_t dummy120[60];
	uint32_t SWITCH_CORE_ARLA_FWD_ENTRY3;
	uint8_t dummy121[60];
	uint64_t SWITCH_CORE_ARLA_SRCH_CTL;
	uint32_t SWITCH_CORE_ARLA_SRCH_ADR;
	uint8_t dummy122[116];
	uint32_t SWITCH_CORE_ARLA_SRCH_RSLT_0_MACVID;
	uint8_t dummy123[60];
	uint32_t SWITCH_CORE_ARLA_SRCH_RSLT_0;
	uint8_t dummy124[60];
	uint32_t SWITCH_CORE_ARLA_SRCH_RSLT_1_MACVID;
	uint8_t dummy125[60];
	uint32_t SWITCH_CORE_ARLA_SRCH_RSLT_1;
	uint8_t dummy126[60];
	uint64_t SWITCH_CORE_ARLA_VTBL_RWCTRL;
	uint32_t SWITCH_CORE_ARLA_VTBL_ADDR;
	uint8_t dummy127[12];
	uint32_t SWITCH_CORE_ARLA_VTBL_ENTRY;
	uint8_t dummy128[100];
	uint32_t SWITCH_CORE_ARLACCS_REG_SPARE0;
	uint8_t dummy129[28];
	uint32_t SWITCH_CORE_ARLACCS_REG_SPARE1;
	uint8_t dummy130[4956];
	uint64_t SWITCH_CORE_MEM_CTRL;
	uint32_t SWITCH_CORE_MEM_ADDR;
	uint8_t dummy131[52];
	uint32_t SWITCH_CORE_MEM_DEBUG_DATA_0_0;
	uint8_t dummy132[60];
	uint32_t SWITCH_CORE_MEM_DEBUG_DATA_0_1;
	uint8_t dummy133[12];
	uint32_t SWITCH_CORE_MEM_DEBUG_DATA_1_0;
	uint8_t dummy134[60];
	uint32_t SWITCH_CORE_MEM_DEBUG_DATA_1_1;
	uint8_t dummy135[44];
	uint32_t SWITCH_CORE_MEM_FRM_ADDR;
	uint8_t dummy136[124];
	uint32_t SWITCH_CORE_MEM_FRM_DATA0;
	uint8_t dummy137[60];
	uint32_t SWITCH_CORE_MEM_FRM_DATA1;
	uint8_t dummy138[60];
	uint32_t SWITCH_CORE_MEM_FRM_DATA2;
	uint8_t dummy139[60];
	uint32_t SWITCH_CORE_MEM_FRM_DATA3;
	uint8_t dummy140[60];
	uint32_t SWITCH_CORE_MEM_BTM_DATA0;
	uint8_t dummy141[60];
	uint32_t SWITCH_CORE_MEM_BTM_DATA1;
	uint8_t dummy142[60];
	uint32_t SWITCH_CORE_MEM_BFC_ADDR;
	uint8_t dummy143[12];
	uint32_t SWITCH_CORE_MEM_BFC_DATA;
	uint8_t dummy144[108];
	uint64_t SWITCH_CORE_PRS_FIFO_DEBUG_CTRL;
	uint32_t SWITCH_CORE_PRS_FIFO_DEBUG_DATA;
	uint8_t dummy145[116];
	uint32_t SWITCH_CORE_MIBKILLOVR;
	uint8_t dummy146[316];
	uint32_t SWITCH_CORE_MEM_REG_SPARE0;
	uint8_t dummy147[28];
	uint32_t SWITCH_CORE_MEM_REG_SPARE1;
	uint8_t dummy148[28];
	uint32_t SWITCH_CORE_MEM_MISC_CTRL;
	uint8_t dummy149[28];
	uint32_t SWITCH_CORE_MEM_TEST_CTRL0;
	uint8_t dummy150[28];
	uint32_t SWITCH_CORE_MEM_TEST_CTRL1;
	uint8_t dummy151[28];
	uint32_t SWITCH_CORE_MEM_TEST_CTRL2;
	uint8_t dummy152[28];
	uint32_t SWITCH_CORE_MEM_TEST_CTRL3;
	uint8_t dummy153[28];
	uint32_t SWITCH_CORE_MEM_TEST_CTRL4;
	uint8_t dummy154[28];
	uint32_t SWITCH_CORE_MEM_TEST_CTRL5;
	uint8_t dummy155[188];
	uint32_t SWITCH_CORE_MEM_PSM_VDD_CTRL;
	uint8_t dummy156[252];
	uint32_t SWITCH_CORE_PORT0_DEBUG;
	uint8_t dummy157[124];
	uint32_t SWITCH_CORE_PORT1_DEBUG;
	uint8_t dummy158[124];
	uint32_t SWITCH_CORE_PORT2_DEBUG;
	uint8_t dummy159[124];
	uint32_t SWITCH_CORE_PORT3_DEBUG;
	uint8_t dummy160[124];
	uint32_t SWITCH_CORE_PORT4_DEBUG;
	uint8_t dummy161[124];
	uint32_t SWITCH_CORE_PORT5_DEBUG;
	uint8_t dummy162[124];
	uint32_t SWITCH_CORE_PORT6_DEBUG;
	uint8_t dummy163[124];
	uint32_t SWITCH_CORE_PORT7_DEBUG;
	uint8_t dummy164[124];
	uint32_t SWITCH_CORE_PORT8_DEBUG;
	uint8_t dummy165[1020];
	uint32_t SWITCH_CORE_FC_DIAG_CTRL;
	uint8_t dummy166[12];
	uint64_t SWITCH_CORE_FC_CTRL_MODE;
	uint64_t SWITCH_CORE_FC_CTRL_PORT;
	uint32_t SWITCH_CORE_FC_OOB_PAUSE_EN;
	uint8_t dummy167[92];
	uint32_t SWITCH_CORE_PAUSE_TIME_MAX;
	uint8_t dummy168[12];
	uint32_t SWITCH_CORE_PAUSE_TIME_MIN;
	uint8_t dummy169[12];
	uint32_t SWITCH_CORE_PAUSE_TIME_RESET_THD;
	uint8_t dummy170[12];
	uint32_t SWITCH_CORE_PAUSE_TIME_UPDATE_PERIOD;
	uint8_t dummy171[12];
	uint32_t SWITCH_CORE_PAUSE_TIME_DEFAULT;
	uint8_t dummy172[12];
	uint32_t SWITCH_CORE_FC_MCAST_DROP_CTRL;
	uint8_t dummy173[12];
	uint32_t SWITCH_CORE_FC_PAUSE_DROP_CTRL;
	uint8_t dummy174[12];
	uint32_t SWITCH_CORE_FC_TXQ_THD_PAUSE_OFF;
	uint8_t dummy175[12];
	uint32_t SWITCH_CORE_FC_RX_RUNOFF;
	uint8_t dummy176[12];
	uint32_t SWITCH_CORE_FC_RX_RSV_THD;
	uint8_t dummy177[12];
	uint32_t SWITCH_CORE_FC_RX_HYST_THD;
	uint8_t dummy178[12];
	uint32_t SWITCH_CORE_FC_RX_MAX_PTR;
	uint8_t dummy179[12];
	uint32_t SWITCH_CORE_FC_SPARE_ZERO_REG;
	uint8_t dummy180[12];
	uint32_t SWITCH_CORE_FC_SPARE_ONE_REG;
	uint8_t dummy181[44];
	uint32_t SWITCH_CORE_FC_MON_TX_Q0;
	uint8_t dummy182[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q1;
	uint8_t dummy183[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q2;
	uint8_t dummy184[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q3;
	uint8_t dummy185[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q4;
	uint8_t dummy186[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q5;
	uint8_t dummy187[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q6;
	uint8_t dummy188[12];
	uint32_t SWITCH_CORE_FC_MON_TX_Q7;
	uint8_t dummy189[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q0;
	uint8_t dummy190[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q1;
	uint8_t dummy191[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q2;
	uint8_t dummy192[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q3;
	uint8_t dummy193[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q4;
	uint8_t dummy194[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q5;
	uint8_t dummy195[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q6;
	uint8_t dummy196[12];
	uint32_t SWITCH_CORE_FC_PEAK_TX_Q7;
	uint8_t dummy197[12];
	uint32_t SWITCH_CORE_FC_PEAK_TOTAL_USED;
	uint8_t dummy198[12];
	uint32_t SWITCH_CORE_FC_TOTAL_USED;
	uint8_t dummy199[12];
	uint32_t SWITCH_CORE_FC_PEAK_RX_CNT;
	uint8_t dummy200[12];
	uint32_t SWITCH_CORE_FC_LINK_PORTMAP;
	uint8_t dummy201[12];
	uint32_t SWITCH_CORE_FC_GIGA_PORTMAP;
	uint8_t dummy202[60];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P0;
	uint8_t dummy203[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P1;
	uint8_t dummy204[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P2;
	uint8_t dummy205[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P3;
	uint8_t dummy206[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P4;
	uint8_t dummy207[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P5;
	uint8_t dummy208[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P6;
	uint8_t dummy209[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P7;
	uint8_t dummy210[12];
	uint32_t SWITCH_CORE_FC_CONG_PORTMAP_P8;
	uint8_t dummy211[60];
	uint32_t SWITCH_CORE_FC_PAUSE_HIS;
	uint8_t dummy212[12];
	uint32_t SWITCH_CORE_FC_TX_QUANTUM_PAUSE_HIS;
	uint8_t dummy213[12];
	uint32_t SWITCH_CORE_FC_RX_PAUSE_HIS;
	uint8_t dummy214[12];
	uint32_t SWITCH_CORE_FC_RXBUF_ERR_HIS;
	uint8_t dummy215[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P0;
	uint8_t dummy216[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P1;
	uint8_t dummy217[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P2;
	uint8_t dummy218[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P3;
	uint8_t dummy219[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P4;
	uint8_t dummy220[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P5;
	uint8_t dummy221[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P6;
	uint8_t dummy222[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P7;
	uint8_t dummy223[12];
	uint32_t SWITCH_CORE_FC_TXQ_CONG_PORTMAP_P8;
	uint8_t dummy224[76];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P0;
	uint8_t dummy225[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P1;
	uint8_t dummy226[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P2;
	uint8_t dummy227[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P3;
	uint8_t dummy228[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P4;
	uint8_t dummy229[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P5;
	uint8_t dummy230[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P6;
	uint8_t dummy231[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P7;
	uint8_t dummy232[12];
	uint32_t SWITCH_CORE_FC_TOTAL_CONG_PORTMAP_P8;
	uint8_t dummy233[684];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q0;
	uint8_t dummy234[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q1;
	uint8_t dummy235[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q2;
	uint8_t dummy236[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q3;
	uint8_t dummy237[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q4;
	uint8_t dummy238[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q5;
	uint8_t dummy239[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q6;
	uint8_t dummy240[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_RSV_Q7;
	uint8_t dummy241[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q0;
	uint8_t dummy242[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q1;
	uint8_t dummy243[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q2;
	uint8_t dummy244[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q3;
	uint8_t dummy245[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q4;
	uint8_t dummy246[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q5;
	uint8_t dummy247[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q6;
	uint8_t dummy248[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_HYST_Q7;
	uint8_t dummy249[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q0;
	uint8_t dummy250[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q1;
	uint8_t dummy251[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q2;
	uint8_t dummy252[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q3;
	uint8_t dummy253[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q4;
	uint8_t dummy254[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q5;
	uint8_t dummy255[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q6;
	uint8_t dummy256[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_PAUSE_Q7;
	uint8_t dummy257[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q0;
	uint8_t dummy258[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q1;
	uint8_t dummy259[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q2;
	uint8_t dummy260[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q3;
	uint8_t dummy261[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q4;
	uint8_t dummy262[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q5;
	uint8_t dummy263[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q6;
	uint8_t dummy264[12];
	uint32_t SWITCH_CORE_FC_LAN_TXQ_THD_DROP_Q7;
	uint8_t dummy265[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q0;
	uint8_t dummy266[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q1;
	uint8_t dummy267[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q2;
	uint8_t dummy268[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q3;
	uint8_t dummy269[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q4;
	uint8_t dummy270[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q5;
	uint8_t dummy271[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q6;
	uint8_t dummy272[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_HYST_Q7;
	uint8_t dummy273[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q0;
	uint8_t dummy274[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q1;
	uint8_t dummy275[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q2;
	uint8_t dummy276[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q3;
	uint8_t dummy277[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q4;
	uint8_t dummy278[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q5;
	uint8_t dummy279[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q6;
	uint8_t dummy280[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_PAUSE_Q7;
	uint8_t dummy281[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q0;
	uint8_t dummy282[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q1;
	uint8_t dummy283[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q2;
	uint8_t dummy284[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q3;
	uint8_t dummy285[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q4;
	uint8_t dummy286[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q5;
	uint8_t dummy287[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q6;
	uint8_t dummy288[12];
	uint32_t SWITCH_CORE_FC_LAN_TOTAL_THD_DROP_Q7;
	uint8_t dummy289[1164];
	uint32_t SWITCH_CORE_P0_DEBUG_MUX;
	uint8_t dummy290[28];
	uint32_t SWITCH_CORE_P1_DEBUG_MUX;
	uint8_t dummy291[28];
	uint32_t SWITCH_CORE_P2_DEBUG_MUX;
	uint8_t dummy292[28];
	uint32_t SWITCH_CORE_P3_DEBUG_MUX;
	uint8_t dummy293[28];
	uint32_t SWITCH_CORE_P4_DEBUG_MUX;
	uint8_t dummy294[28];
	uint32_t SWITCH_CORE_P5_DEBUG_MUX;
	uint8_t dummy295[28];
	uint32_t SWITCH_CORE_P6_DEBUG_MUX;
	uint8_t dummy296[28];
	uint32_t SWITCH_CORE_DEBUG_MUX_P7;
	uint8_t dummy297[28];
	uint32_t SWITCH_CORE_DEBUG_MUX_IMP;
	uint8_t dummy298[28];
	uint32_t SWITCH_CORE_CFP_DEBUG_BUS_0;
	uint8_t dummy299[28];
	uint32_t SWITCH_CORE_CFP_DEBUG_BUS_1;
	uint8_t dummy300[28];
	uint32_t SWITCH_CORE_WRED_DEBUG_0;
	uint8_t dummy301[28];
	uint32_t SWITCH_CORE_WRED_DEBUG_1;
	uint8_t dummy302[28];
	uint32_t SWITCH_CORE_TOP_MISC_DEBUG_0;
	uint8_t dummy303[28];
	uint32_t SWITCH_CORE_TOP_MISC_DEBUG_1;
	uint8_t dummy304[28];
	uint32_t SWITCH_CORE_DIAGREG_BUFCON;
	uint8_t dummy305[28];
	uint32_t SWITCH_CORE_TESTBUS_P1588;
	uint8_t dummy306[28];
	uint32_t SWITCH_CORE_FLOWCON_DEBUG_BUS;
	uint8_t dummy307[1500];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q0;
	uint8_t dummy308[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q1;
	uint8_t dummy309[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q2;
	uint8_t dummy310[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q3;
	uint8_t dummy311[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q4;
	uint8_t dummy312[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q5;
	uint8_t dummy313[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q6;
	uint8_t dummy314[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_RSV_Q7;
	uint8_t dummy315[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q0;
	uint8_t dummy316[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q1;
	uint8_t dummy317[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q2;
	uint8_t dummy318[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q3;
	uint8_t dummy319[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q4;
	uint8_t dummy320[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q5;
	uint8_t dummy321[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q6;
	uint8_t dummy322[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_HYST_Q7;
	uint8_t dummy323[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q0;
	uint8_t dummy324[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q1;
	uint8_t dummy325[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q2;
	uint8_t dummy326[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q3;
	uint8_t dummy327[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q4;
	uint8_t dummy328[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q5;
	uint8_t dummy329[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q6;
	uint8_t dummy330[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_PAUSE_Q7;
	uint8_t dummy331[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q0;
	uint8_t dummy332[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q1;
	uint8_t dummy333[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q2;
	uint8_t dummy334[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q3;
	uint8_t dummy335[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q4;
	uint8_t dummy336[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q5;
	uint8_t dummy337[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q6;
	uint8_t dummy338[12];
	uint32_t SWITCH_CORE_FC_IMP0_TXQ_THD_DROP_Q7;
	uint8_t dummy339[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q0;
	uint8_t dummy340[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q1;
	uint8_t dummy341[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q2;
	uint8_t dummy342[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q3;
	uint8_t dummy343[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q4;
	uint8_t dummy344[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q5;
	uint8_t dummy345[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q6;
	uint8_t dummy346[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_HYST_Q7;
	uint8_t dummy347[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q0;
	uint8_t dummy348[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q1;
	uint8_t dummy349[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q2;
	uint8_t dummy350[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q3;
	uint8_t dummy351[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q4;
	uint8_t dummy352[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q5;
	uint8_t dummy353[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q6;
	uint8_t dummy354[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_PAUSE_Q7;
	uint8_t dummy355[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q0;
	uint8_t dummy356[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q1;
	uint8_t dummy357[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q2;
	uint8_t dummy358[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q3;
	uint8_t dummy359[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q4;
	uint8_t dummy360[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q5;
	uint8_t dummy361[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q6;
	uint8_t dummy362[12];
	uint32_t SWITCH_CORE_FC_IMP0_TOTAL_THD_DROP_Q7;
	uint8_t dummy363[12];
	uint32_t SWITCH_CORE_FC_IMP0_REG_SPARE0;
	uint8_t dummy364[12];
	uint32_t SWITCH_CORE_FC_IMP0_REG_SPARE1;
	uint8_t dummy365[1132];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q0;
	uint8_t dummy366[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q1;
	uint8_t dummy367[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q2;
	uint8_t dummy368[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q3;
	uint8_t dummy369[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q4;
	uint8_t dummy370[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q5;
	uint8_t dummy371[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q6;
	uint8_t dummy372[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_RSV_Q7;
	uint8_t dummy373[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q0;
	uint8_t dummy374[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q1;
	uint8_t dummy375[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q2;
	uint8_t dummy376[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q3;
	uint8_t dummy377[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q4;
	uint8_t dummy378[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q5;
	uint8_t dummy379[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q6;
	uint8_t dummy380[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_HYST_Q7;
	uint8_t dummy381[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q0;
	uint8_t dummy382[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q1;
	uint8_t dummy383[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q2;
	uint8_t dummy384[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q3;
	uint8_t dummy385[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q4;
	uint8_t dummy386[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q5;
	uint8_t dummy387[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q6;
	uint8_t dummy388[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_PAUSE_Q7;
	uint8_t dummy389[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q0;
	uint8_t dummy390[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q1;
	uint8_t dummy391[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q2;
	uint8_t dummy392[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q3;
	uint8_t dummy393[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q4;
	uint8_t dummy394[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q5;
	uint8_t dummy395[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q6;
	uint8_t dummy396[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TXQ_THD_DROP_Q7;
	uint8_t dummy397[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q0;
	uint8_t dummy398[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q1;
	uint8_t dummy399[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q2;
	uint8_t dummy400[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q3;
	uint8_t dummy401[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q4;
	uint8_t dummy402[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q5;
	uint8_t dummy403[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q6;
	uint8_t dummy404[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_HYST_Q7;
	uint8_t dummy405[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q0;
	uint8_t dummy406[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q1;
	uint8_t dummy407[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q2;
	uint8_t dummy408[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q3;
	uint8_t dummy409[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q4;
	uint8_t dummy410[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q5;
	uint8_t dummy411[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q6;
	uint8_t dummy412[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_PAUSE_Q7;
	uint8_t dummy413[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q0;
	uint8_t dummy414[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q1;
	uint8_t dummy415[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q2;
	uint8_t dummy416[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q3;
	uint8_t dummy417[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q4;
	uint8_t dummy418[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q5;
	uint8_t dummy419[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q6;
	uint8_t dummy420[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_TOTAL_THD_DROP_Q7;
	uint8_t dummy421[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_REG_SPARE0;
	uint8_t dummy422[12];
	uint32_t SWITCH_CORE_FC_WAN_IMP1_REG_SPARE1;
	uint8_t dummy423[35948];
	uint32_t SWITCH_CORE_TxOctets_P0;
	uint8_t dummy424[60];
	uint32_t SWITCH_CORE_TxDropPkts_P0;
	uint8_t dummy425[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P0;
	uint8_t dummy426[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P0;
	uint8_t dummy427[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P0;
	uint8_t dummy428[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P0;
	uint8_t dummy429[28];
	uint32_t SWITCH_CORE_TxCollisions_P0;
	uint8_t dummy430[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P0;
	uint8_t dummy431[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P0;
	uint8_t dummy432[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P0;
	uint8_t dummy433[28];
	uint32_t SWITCH_CORE_TxLateCollision_P0;
	uint8_t dummy434[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P0;
	uint8_t dummy435[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P0;
	uint8_t dummy436[28];
	uint32_t SWITCH_CORE_TxPausePkts_P0;
	uint8_t dummy437[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P0;
	uint8_t dummy438[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P0;
	uint8_t dummy439[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P0;
	uint8_t dummy440[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P0;
	uint8_t dummy441[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P0;
	uint8_t dummy442[28];
	uint32_t SWITCH_CORE_RxOctets_P0;
	uint8_t dummy443[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P0;
	uint8_t dummy444[28];
	uint32_t SWITCH_CORE_RxPausePkts_P0;
	uint8_t dummy445[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P0;
	uint8_t dummy446[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P0;
	uint8_t dummy447[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P0;
	uint8_t dummy448[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P0;
	uint8_t dummy449[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P0;
	uint8_t dummy450[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P0;
	uint8_t dummy451[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P0;
	uint8_t dummy452[28];
	uint32_t SWITCH_CORE_RxJabbers_P0;
	uint8_t dummy453[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P0;
	uint8_t dummy454[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P0;
	uint8_t dummy455[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P0;
	uint8_t dummy456[60];
	uint32_t SWITCH_CORE_RxDropPkts_P0;
	uint8_t dummy457[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P0;
	uint8_t dummy458[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P0;
	uint8_t dummy459[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P0;
	uint8_t dummy460[28];
	uint32_t SWITCH_CORE_RxSAChanges_P0;
	uint8_t dummy461[28];
	uint32_t SWITCH_CORE_RxFragments_P0;
	uint8_t dummy462[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P0;
	uint8_t dummy463[28];
	uint32_t SWITCH_CORE_RxSymblErr_P0;
	uint8_t dummy464[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P0;
	uint8_t dummy465[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P0;
	uint8_t dummy466[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P0;
	uint8_t dummy467[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P0;
	uint8_t dummy468[28];
	uint32_t SWITCH_CORE_RxDiscard_P0;
	uint8_t dummy469[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P0;
	uint8_t dummy470[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P0;
	uint8_t dummy471[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P0;
	uint8_t dummy472[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P0;
	uint8_t dummy473[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P0;
	uint8_t dummy474[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P0;
	uint8_t dummy475[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P0;
	uint8_t dummy476[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P0;
	uint8_t dummy477[220];
	uint32_t SWITCH_CORE_TxOctets_P1;
	uint8_t dummy478[60];
	uint32_t SWITCH_CORE_TxDropPkts_P1;
	uint8_t dummy479[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P1;
	uint8_t dummy480[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P1;
	uint8_t dummy481[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P1;
	uint8_t dummy482[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P1;
	uint8_t dummy483[28];
	uint32_t SWITCH_CORE_TxCollisions_P1;
	uint8_t dummy484[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P1;
	uint8_t dummy485[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P1;
	uint8_t dummy486[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P1;
	uint8_t dummy487[28];
	uint32_t SWITCH_CORE_TxLateCollision_P1;
	uint8_t dummy488[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P1;
	uint8_t dummy489[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P1;
	uint8_t dummy490[28];
	uint32_t SWITCH_CORE_TxPausePkts_P1;
	uint8_t dummy491[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P1;
	uint8_t dummy492[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P1;
	uint8_t dummy493[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P1;
	uint8_t dummy494[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P1;
	uint8_t dummy495[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P1;
	uint8_t dummy496[28];
	uint32_t SWITCH_CORE_RxOctets_P1;
	uint8_t dummy497[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P1;
	uint8_t dummy498[28];
	uint32_t SWITCH_CORE_RxPausePkts_P1;
	uint8_t dummy499[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P1;
	uint8_t dummy500[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P1;
	uint8_t dummy501[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P1;
	uint8_t dummy502[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P1;
	uint8_t dummy503[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P1;
	uint8_t dummy504[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P1;
	uint8_t dummy505[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P1;
	uint8_t dummy506[28];
	uint32_t SWITCH_CORE_RxJabbers_P1;
	uint8_t dummy507[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P1;
	uint8_t dummy508[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P1;
	uint8_t dummy509[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P1;
	uint8_t dummy510[60];
	uint32_t SWITCH_CORE_RxDropPkts_P1;
	uint8_t dummy511[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P1;
	uint8_t dummy512[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P1;
	uint8_t dummy513[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P1;
	uint8_t dummy514[28];
	uint32_t SWITCH_CORE_RxSAChanges_P1;
	uint8_t dummy515[28];
	uint32_t SWITCH_CORE_RxFragments_P1;
	uint8_t dummy516[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P1;
	uint8_t dummy517[28];
	uint32_t SWITCH_CORE_RxSymblErr_P1;
	uint8_t dummy518[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P1;
	uint8_t dummy519[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P1;
	uint8_t dummy520[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P1;
	uint8_t dummy521[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P1;
	uint8_t dummy522[28];
	uint32_t SWITCH_CORE_RxDiscard_P1;
	uint8_t dummy523[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P1;
	uint8_t dummy524[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P1;
	uint8_t dummy525[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P1;
	uint8_t dummy526[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P1;
	uint8_t dummy527[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P1;
	uint8_t dummy528[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P1;
	uint8_t dummy529[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P1;
	uint8_t dummy530[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P1;
	uint8_t dummy531[220];
	uint32_t SWITCH_CORE_TxOctets_P2;
	uint8_t dummy532[60];
	uint32_t SWITCH_CORE_TxDropPkts_P2;
	uint8_t dummy533[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P2;
	uint8_t dummy534[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P2;
	uint8_t dummy535[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P2;
	uint8_t dummy536[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P2;
	uint8_t dummy537[28];
	uint32_t SWITCH_CORE_TxCollisions_P2;
	uint8_t dummy538[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P2;
	uint8_t dummy539[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P2;
	uint8_t dummy540[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P2;
	uint8_t dummy541[28];
	uint32_t SWITCH_CORE_TxLateCollision_P2;
	uint8_t dummy542[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P2;
	uint8_t dummy543[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P2;
	uint8_t dummy544[28];
	uint32_t SWITCH_CORE_TxPausePkts_P2;
	uint8_t dummy545[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P2;
	uint8_t dummy546[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P2;
	uint8_t dummy547[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P2;
	uint8_t dummy548[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P2;
	uint8_t dummy549[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P2;
	uint8_t dummy550[28];
	uint32_t SWITCH_CORE_RxOctets_P2;
	uint8_t dummy551[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P2;
	uint8_t dummy552[28];
	uint32_t SWITCH_CORE_RxPausePkts_P2;
	uint8_t dummy553[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P2;
	uint8_t dummy554[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P2;
	uint8_t dummy555[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P2;
	uint8_t dummy556[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P2;
	uint8_t dummy557[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P2;
	uint8_t dummy558[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P2;
	uint8_t dummy559[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P2;
	uint8_t dummy560[28];
	uint32_t SWITCH_CORE_RxJabbers_P2;
	uint8_t dummy561[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P2;
	uint8_t dummy562[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P2;
	uint8_t dummy563[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P2;
	uint8_t dummy564[60];
	uint32_t SWITCH_CORE_RxDropPkts_P2;
	uint8_t dummy565[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P2;
	uint8_t dummy566[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P2;
	uint8_t dummy567[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P2;
	uint8_t dummy568[28];
	uint32_t SWITCH_CORE_RxSAChanges_P2;
	uint8_t dummy569[28];
	uint32_t SWITCH_CORE_RxFragments_P2;
	uint8_t dummy570[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P2;
	uint8_t dummy571[28];
	uint32_t SWITCH_CORE_RxSymblErr_P2;
	uint8_t dummy572[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P2;
	uint8_t dummy573[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P2;
	uint8_t dummy574[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P2;
	uint8_t dummy575[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P2;
	uint8_t dummy576[28];
	uint32_t SWITCH_CORE_RxDiscard_P2;
	uint8_t dummy577[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P2;
	uint8_t dummy578[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P2;
	uint8_t dummy579[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P2;
	uint8_t dummy580[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P2;
	uint8_t dummy581[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P2;
	uint8_t dummy582[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P2;
	uint8_t dummy583[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P2;
	uint8_t dummy584[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P2;
	uint8_t dummy585[220];
	uint32_t SWITCH_CORE_TxOctets_P3;
	uint8_t dummy586[60];
	uint32_t SWITCH_CORE_TxDropPkts_P3;
	uint8_t dummy587[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P3;
	uint8_t dummy588[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P3;
	uint8_t dummy589[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P3;
	uint8_t dummy590[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P3;
	uint8_t dummy591[28];
	uint32_t SWITCH_CORE_TxCollisions_P3;
	uint8_t dummy592[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P3;
	uint8_t dummy593[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P3;
	uint8_t dummy594[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P3;
	uint8_t dummy595[28];
	uint32_t SWITCH_CORE_TxLateCollision_P3;
	uint8_t dummy596[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P3;
	uint8_t dummy597[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P3;
	uint8_t dummy598[28];
	uint32_t SWITCH_CORE_TxPausePkts_P3;
	uint8_t dummy599[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P3;
	uint8_t dummy600[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P3;
	uint8_t dummy601[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P3;
	uint8_t dummy602[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P3;
	uint8_t dummy603[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P3;
	uint8_t dummy604[28];
	uint32_t SWITCH_CORE_RxOctets_P3;
	uint8_t dummy605[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P3;
	uint8_t dummy606[28];
	uint32_t SWITCH_CORE_RxPausePkts_P3;
	uint8_t dummy607[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P3;
	uint8_t dummy608[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P3;
	uint8_t dummy609[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P3;
	uint8_t dummy610[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P3;
	uint8_t dummy611[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P3;
	uint8_t dummy612[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P3;
	uint8_t dummy613[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P3;
	uint8_t dummy614[28];
	uint32_t SWITCH_CORE_RxJabbers_P3;
	uint8_t dummy615[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P3;
	uint8_t dummy616[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P3;
	uint8_t dummy617[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P3;
	uint8_t dummy618[60];
	uint32_t SWITCH_CORE_RxDropPkts_P3;
	uint8_t dummy619[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P3;
	uint8_t dummy620[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P3;
	uint8_t dummy621[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P3;
	uint8_t dummy622[28];
	uint32_t SWITCH_CORE_RxSAChanges_P3;
	uint8_t dummy623[28];
	uint32_t SWITCH_CORE_RxFragments_P3;
	uint8_t dummy624[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P3;
	uint8_t dummy625[28];
	uint32_t SWITCH_CORE_RxSymblErr_P3;
	uint8_t dummy626[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P3;
	uint8_t dummy627[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P3;
	uint8_t dummy628[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P3;
	uint8_t dummy629[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P3;
	uint8_t dummy630[28];
	uint32_t SWITCH_CORE_RxDiscard_P3;
	uint8_t dummy631[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P3;
	uint8_t dummy632[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P3;
	uint8_t dummy633[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P3;
	uint8_t dummy634[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P3;
	uint8_t dummy635[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P3;
	uint8_t dummy636[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P3;
	uint8_t dummy637[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P3;
	uint8_t dummy638[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P3;
	uint8_t dummy639[220];
	uint32_t SWITCH_CORE_TxOctets_P4;
	uint8_t dummy640[60];
	uint32_t SWITCH_CORE_TxDropPkts_P4;
	uint8_t dummy641[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P4;
	uint8_t dummy642[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P4;
	uint8_t dummy643[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P4;
	uint8_t dummy644[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P4;
	uint8_t dummy645[28];
	uint32_t SWITCH_CORE_TxCollisions_P4;
	uint8_t dummy646[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P4;
	uint8_t dummy647[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P4;
	uint8_t dummy648[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P4;
	uint8_t dummy649[28];
	uint32_t SWITCH_CORE_TxLateCollision_P4;
	uint8_t dummy650[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P4;
	uint8_t dummy651[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P4;
	uint8_t dummy652[28];
	uint32_t SWITCH_CORE_TxPausePkts_P4;
	uint8_t dummy653[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P4;
	uint8_t dummy654[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P4;
	uint8_t dummy655[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P4;
	uint8_t dummy656[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P4;
	uint8_t dummy657[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P4;
	uint8_t dummy658[28];
	uint32_t SWITCH_CORE_RxOctets_P4;
	uint8_t dummy659[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P4;
	uint8_t dummy660[28];
	uint32_t SWITCH_CORE_RxPausePkts_P4;
	uint8_t dummy661[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P4;
	uint8_t dummy662[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P4;
	uint8_t dummy663[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P4;
	uint8_t dummy664[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P4;
	uint8_t dummy665[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P4;
	uint8_t dummy666[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P4;
	uint8_t dummy667[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P4;
	uint8_t dummy668[28];
	uint32_t SWITCH_CORE_RxJabbers_P4;
	uint8_t dummy669[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P4;
	uint8_t dummy670[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P4;
	uint8_t dummy671[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P4;
	uint8_t dummy672[60];
	uint32_t SWITCH_CORE_RxDropPkts_P4;
	uint8_t dummy673[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P4;
	uint8_t dummy674[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P4;
	uint8_t dummy675[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P4;
	uint8_t dummy676[28];
	uint32_t SWITCH_CORE_RxSAChanges_P4;
	uint8_t dummy677[28];
	uint32_t SWITCH_CORE_RxFragments_P4;
	uint8_t dummy678[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P4;
	uint8_t dummy679[28];
	uint32_t SWITCH_CORE_RxSymblErr_P4;
	uint8_t dummy680[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P4;
	uint8_t dummy681[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P4;
	uint8_t dummy682[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P4;
	uint8_t dummy683[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P4;
	uint8_t dummy684[28];
	uint32_t SWITCH_CORE_RxDiscard_P4;
	uint8_t dummy685[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P4;
	uint8_t dummy686[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P4;
	uint8_t dummy687[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P4;
	uint8_t dummy688[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P4;
	uint8_t dummy689[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P4;
	uint8_t dummy690[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P4;
	uint8_t dummy691[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P4;
	uint8_t dummy692[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P4;
	uint8_t dummy693[220];
	uint32_t SWITCH_CORE_TxOctets_P5;
	uint8_t dummy694[60];
	uint32_t SWITCH_CORE_TxDropPkts_P5;
	uint8_t dummy695[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P5;
	uint8_t dummy696[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P5;
	uint8_t dummy697[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P5;
	uint8_t dummy698[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P5;
	uint8_t dummy699[28];
	uint32_t SWITCH_CORE_TxCollisions_P5;
	uint8_t dummy700[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P5;
	uint8_t dummy701[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P5;
	uint8_t dummy702[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P5;
	uint8_t dummy703[28];
	uint32_t SWITCH_CORE_TxLateCollision_P5;
	uint8_t dummy704[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P5;
	uint8_t dummy705[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P5;
	uint8_t dummy706[28];
	uint32_t SWITCH_CORE_TxPausePkts_P5;
	uint8_t dummy707[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P5;
	uint8_t dummy708[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P5;
	uint8_t dummy709[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P5;
	uint8_t dummy710[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P5;
	uint8_t dummy711[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P5;
	uint8_t dummy712[28];
	uint32_t SWITCH_CORE_RxOctets_P5;
	uint8_t dummy713[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P5;
	uint8_t dummy714[28];
	uint32_t SWITCH_CORE_RxPausePkts_P5;
	uint8_t dummy715[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P5;
	uint8_t dummy716[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P5;
	uint8_t dummy717[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P5;
	uint8_t dummy718[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P5;
	uint8_t dummy719[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P5;
	uint8_t dummy720[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P5;
	uint8_t dummy721[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P5;
	uint8_t dummy722[28];
	uint32_t SWITCH_CORE_RxJabbers_P5;
	uint8_t dummy723[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P5;
	uint8_t dummy724[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P5;
	uint8_t dummy725[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P5;
	uint8_t dummy726[60];
	uint32_t SWITCH_CORE_RxDropPkts_P5;
	uint8_t dummy727[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P5;
	uint8_t dummy728[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P5;
	uint8_t dummy729[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P5;
	uint8_t dummy730[28];
	uint32_t SWITCH_CORE_RxSAChanges_P5;
	uint8_t dummy731[28];
	uint32_t SWITCH_CORE_RxFragments_P5;
	uint8_t dummy732[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P5;
	uint8_t dummy733[28];
	uint32_t SWITCH_CORE_RxSymblErr_P5;
	uint8_t dummy734[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P5;
	uint8_t dummy735[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P5;
	uint8_t dummy736[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P5;
	uint8_t dummy737[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P5;
	uint8_t dummy738[28];
	uint32_t SWITCH_CORE_RxDiscard_P5;
	uint8_t dummy739[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P5;
	uint8_t dummy740[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P5;
	uint8_t dummy741[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P5;
	uint8_t dummy742[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P5;
	uint8_t dummy743[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P5;
	uint8_t dummy744[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P5;
	uint8_t dummy745[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P5;
	uint8_t dummy746[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P5;
	uint8_t dummy747[220];
	uint32_t SWITCH_CORE_TxOctets_P6;
	uint8_t dummy748[60];
	uint32_t SWITCH_CORE_TxDropPkts_P6;
	uint8_t dummy749[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P6;
	uint8_t dummy750[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P6;
	uint8_t dummy751[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P6;
	uint8_t dummy752[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P6;
	uint8_t dummy753[28];
	uint32_t SWITCH_CORE_TxCollisions_P6;
	uint8_t dummy754[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P6;
	uint8_t dummy755[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P6;
	uint8_t dummy756[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P6;
	uint8_t dummy757[28];
	uint32_t SWITCH_CORE_TxLateCollision_P6;
	uint8_t dummy758[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P6;
	uint8_t dummy759[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P6;
	uint8_t dummy760[28];
	uint32_t SWITCH_CORE_TxPausePkts_P6;
	uint8_t dummy761[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P6;
	uint8_t dummy762[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P6;
	uint8_t dummy763[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P6;
	uint8_t dummy764[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P6;
	uint8_t dummy765[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P6;
	uint8_t dummy766[28];
	uint32_t SWITCH_CORE_RxOctets_P6;
	uint8_t dummy767[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P6;
	uint8_t dummy768[28];
	uint32_t SWITCH_CORE_RxPausePkts_P6;
	uint8_t dummy769[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P6;
	uint8_t dummy770[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P6;
	uint8_t dummy771[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P6;
	uint8_t dummy772[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P6;
	uint8_t dummy773[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P6;
	uint8_t dummy774[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P6;
	uint8_t dummy775[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P6;
	uint8_t dummy776[28];
	uint32_t SWITCH_CORE_RxJabbers_P6;
	uint8_t dummy777[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P6;
	uint8_t dummy778[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P6;
	uint8_t dummy779[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P6;
	uint8_t dummy780[60];
	uint32_t SWITCH_CORE_RxDropPkts_P6;
	uint8_t dummy781[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P6;
	uint8_t dummy782[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P6;
	uint8_t dummy783[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P6;
	uint8_t dummy784[28];
	uint32_t SWITCH_CORE_RxSAChanges_P6;
	uint8_t dummy785[28];
	uint32_t SWITCH_CORE_RxFragments_P6;
	uint8_t dummy786[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P6;
	uint8_t dummy787[28];
	uint32_t SWITCH_CORE_RxSymblErr_P6;
	uint8_t dummy788[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P6;
	uint8_t dummy789[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P6;
	uint8_t dummy790[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P6;
	uint8_t dummy791[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P6;
	uint8_t dummy792[28];
	uint32_t SWITCH_CORE_RxDiscard_P6;
	uint8_t dummy793[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P6;
	uint8_t dummy794[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P6;
	uint8_t dummy795[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P6;
	uint8_t dummy796[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P6;
	uint8_t dummy797[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P6;
	uint8_t dummy798[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P6;
	uint8_t dummy799[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P6;
	uint8_t dummy800[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P6;
	uint8_t dummy801[220];
	uint32_t SWITCH_CORE_TxOctets_P7;
	uint8_t dummy802[60];
	uint32_t SWITCH_CORE_TxDropPkts_P7;
	uint8_t dummy803[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_P7;
	uint8_t dummy804[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_P7;
	uint8_t dummy805[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_P7;
	uint8_t dummy806[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_P7;
	uint8_t dummy807[28];
	uint32_t SWITCH_CORE_TxCollisions_P7;
	uint8_t dummy808[28];
	uint32_t SWITCH_CORE_TxSingleCollision_P7;
	uint8_t dummy809[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_P7;
	uint8_t dummy810[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_P7;
	uint8_t dummy811[28];
	uint32_t SWITCH_CORE_TxLateCollision_P7;
	uint8_t dummy812[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_P7;
	uint8_t dummy813[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_P7;
	uint8_t dummy814[28];
	uint32_t SWITCH_CORE_TxPausePkts_P7;
	uint8_t dummy815[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_P7;
	uint8_t dummy816[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_P7;
	uint8_t dummy817[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_P7;
	uint8_t dummy818[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_P7;
	uint8_t dummy819[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_P7;
	uint8_t dummy820[28];
	uint32_t SWITCH_CORE_RxOctets_P7;
	uint8_t dummy821[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_P7;
	uint8_t dummy822[28];
	uint32_t SWITCH_CORE_RxPausePkts_P7;
	uint8_t dummy823[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_P7;
	uint8_t dummy824[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_P7;
	uint8_t dummy825[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_P7;
	uint8_t dummy826[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_P7;
	uint8_t dummy827[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_P7;
	uint8_t dummy828[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_P7;
	uint8_t dummy829[28];
	uint32_t SWITCH_CORE_RxOversizePkts_P7;
	uint8_t dummy830[28];
	uint32_t SWITCH_CORE_RxJabbers_P7;
	uint8_t dummy831[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_P7;
	uint8_t dummy832[28];
	uint32_t SWITCH_CORE_RxFCSErrors_P7;
	uint8_t dummy833[28];
	uint32_t SWITCH_CORE_RxGoodOctets_P7;
	uint8_t dummy834[60];
	uint32_t SWITCH_CORE_RxDropPkts_P7;
	uint8_t dummy835[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_P7;
	uint8_t dummy836[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_P7;
	uint8_t dummy837[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_P7;
	uint8_t dummy838[28];
	uint32_t SWITCH_CORE_RxSAChanges_P7;
	uint8_t dummy839[28];
	uint32_t SWITCH_CORE_RxFragments_P7;
	uint8_t dummy840[28];
	uint32_t SWITCH_CORE_RxJumboPkt_P7;
	uint8_t dummy841[28];
	uint32_t SWITCH_CORE_RxSymblErr_P7;
	uint8_t dummy842[28];
	uint32_t SWITCH_CORE_InRangeErrCount_P7;
	uint8_t dummy843[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_P7;
	uint8_t dummy844[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_P7;
	uint8_t dummy845[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_P7;
	uint8_t dummy846[28];
	uint32_t SWITCH_CORE_RxDiscard_P7;
	uint8_t dummy847[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_P7;
	uint8_t dummy848[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_P7;
	uint8_t dummy849[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_P7;
	uint8_t dummy850[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_P7;
	uint8_t dummy851[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_P7;
	uint8_t dummy852[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_P7;
	uint8_t dummy853[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_P7;
	uint8_t dummy854[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_P7;
	uint8_t dummy855[220];
	uint32_t SWITCH_CORE_TxOctets_IMP;
	uint8_t dummy856[60];
	uint32_t SWITCH_CORE_TxDropPkts_IMP;
	uint8_t dummy857[28];
	uint32_t SWITCH_CORE_TxQPKTQ0_IMP;
	uint8_t dummy858[28];
	uint32_t SWITCH_CORE_TxBroadcastPkts_IMP;
	uint8_t dummy859[28];
	uint32_t SWITCH_CORE_TxMulticastPkts_IMP;
	uint8_t dummy860[28];
	uint32_t SWITCH_CORE_TxUnicastPkts_IMP;
	uint8_t dummy861[28];
	uint32_t SWITCH_CORE_TxCollisions_IMP;
	uint8_t dummy862[28];
	uint32_t SWITCH_CORE_TxSingleCollision_IMP;
	uint8_t dummy863[28];
	uint32_t SWITCH_CORE_TxMultipleCollision_IMP;
	uint8_t dummy864[28];
	uint32_t SWITCH_CORE_TxDeferredTransmit_IMP;
	uint8_t dummy865[28];
	uint32_t SWITCH_CORE_TxLateCollision_IMP;
	uint8_t dummy866[28];
	uint32_t SWITCH_CORE_TxExcessiveCollision_IMP;
	uint8_t dummy867[28];
	uint32_t SWITCH_CORE_TxFrameInDisc_IMP;
	uint8_t dummy868[28];
	uint32_t SWITCH_CORE_TxPausePkts_IMP;
	uint8_t dummy869[28];
	uint32_t SWITCH_CORE_TxQPKTQ1_IMP;
	uint8_t dummy870[28];
	uint32_t SWITCH_CORE_TxQPKTQ2_IMP;
	uint8_t dummy871[28];
	uint32_t SWITCH_CORE_TxQPKTQ3_IMP;
	uint8_t dummy872[28];
	uint32_t SWITCH_CORE_TxQPKTQ4_IMP;
	uint8_t dummy873[28];
	uint32_t SWITCH_CORE_TxQPKTQ5_IMP;
	uint8_t dummy874[28];
	uint32_t SWITCH_CORE_RxOctets_IMP;
	uint8_t dummy875[60];
	uint32_t SWITCH_CORE_RxUndersizePkts_IMP;
	uint8_t dummy876[28];
	uint32_t SWITCH_CORE_RxPausePkts_IMP;
	uint8_t dummy877[28];
	uint32_t SWITCH_CORE_RxPkts64Octets_IMP;
	uint8_t dummy878[28];
	uint32_t SWITCH_CORE_RxPkts65to127Octets_IMP;
	uint8_t dummy879[28];
	uint32_t SWITCH_CORE_RxPkts128to255Octets_IMP;
	uint8_t dummy880[28];
	uint32_t SWITCH_CORE_RxPkts256to511Octets_IMP;
	uint8_t dummy881[28];
	uint32_t SWITCH_CORE_RxPkts512to1023Octets_IMP;
	uint8_t dummy882[28];
	uint32_t SWITCH_CORE_RxPkts1024toMaxPktOctets_IMP;
	uint8_t dummy883[28];
	uint32_t SWITCH_CORE_RxOversizePkts_IMP;
	uint8_t dummy884[28];
	uint32_t SWITCH_CORE_RxJabbers_IMP;
	uint8_t dummy885[28];
	uint32_t SWITCH_CORE_RxAlignmentErrors_IMP;
	uint8_t dummy886[28];
	uint32_t SWITCH_CORE_RxFCSErrors_IMP;
	uint8_t dummy887[28];
	uint32_t SWITCH_CORE_RxGoodOctets_IMP;
	uint8_t dummy888[60];
	uint32_t SWITCH_CORE_RxDropPkts_IMP;
	uint8_t dummy889[28];
	uint32_t SWITCH_CORE_RxUnicastPkts_IMP;
	uint8_t dummy890[28];
	uint32_t SWITCH_CORE_RxMulticastPkts_IMP;
	uint8_t dummy891[28];
	uint32_t SWITCH_CORE_RxBroadcastPkts_IMP;
	uint8_t dummy892[28];
	uint32_t SWITCH_CORE_RxSAChanges_IMP;
	uint8_t dummy893[28];
	uint32_t SWITCH_CORE_RxFragments_IMP;
	uint8_t dummy894[28];
	uint32_t SWITCH_CORE_RxJumboPkt_IMP;
	uint8_t dummy895[28];
	uint32_t SWITCH_CORE_RxSymblErr_IMP;
	uint8_t dummy896[28];
	uint32_t SWITCH_CORE_InRangeErrCount_IMP;
	uint8_t dummy897[28];
	uint32_t SWITCH_CORE_OutRangeErrCount_IMP;
	uint8_t dummy898[28];
	uint32_t SWITCH_CORE_EEE_LPI_EVENT_IMP;
	uint8_t dummy899[28];
	uint32_t SWITCH_CORE_EEE_LPI_DURATION_IMP;
	uint8_t dummy900[28];
	uint32_t SWITCH_CORE_RxDiscard_IMP;
	uint8_t dummy901[60];
	uint32_t SWITCH_CORE_TxQPKTQ6_IMP;
	uint8_t dummy902[28];
	uint32_t SWITCH_CORE_TxQPKTQ7_IMP;
	uint8_t dummy903[28];
	uint32_t SWITCH_CORE_TxPkts64Octets_IMP;
	uint8_t dummy904[28];
	uint32_t SWITCH_CORE_TxPkts65to127Octets_IMP;
	uint8_t dummy905[28];
	uint32_t SWITCH_CORE_TxPkts128to255Octets_IMP;
	uint8_t dummy906[28];
	uint32_t SWITCH_CORE_TxPkts256to511Octets_IMP;
	uint8_t dummy907[28];
	uint32_t SWITCH_CORE_TxPkts512to1023Octets_IMP;
	uint8_t dummy908[28];
	uint32_t SWITCH_CORE_TxPkts1024toMaxPktOctets_IMP;
	uint8_t dummy909[14556];
	uint32_t SWITCH_CORE_QOS_GLOBAL_CTRL;
	uint8_t dummy910[28];
	uint32_t SWITCH_CORE_QOS_1P_EN;
	uint8_t dummy911[12];
	uint32_t SWITCH_CORE_QOS_EN_DIFFSERV;
	uint8_t dummy912[76];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P0;
	uint8_t dummy913[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P1;
	uint8_t dummy914[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P2;
	uint8_t dummy915[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P3;
	uint8_t dummy916[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P4;
	uint8_t dummy917[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P5;
	uint8_t dummy918[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P6;
	uint8_t dummy919[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_P7;
	uint8_t dummy920[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI0_IMP;
	uint8_t dummy921[28];
	uint32_t SWITCH_CORE_QOS_DIFF_DSCP0;
	uint8_t dummy922[44];
	uint32_t SWITCH_CORE_QOS_DIFF_DSCP1;
	uint8_t dummy923[44];
	uint32_t SWITCH_CORE_QOS_DIFF_DSCP2;
	uint8_t dummy924[44];
	uint32_t SWITCH_CORE_QOS_DIFF_DSCP3;
	uint8_t dummy925[44];
	uint32_t SWITCH_CORE_PID2TC;
	uint8_t dummy926[60];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P0;
	uint8_t dummy927[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P1;
	uint8_t dummy928[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P2;
	uint8_t dummy929[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P3;
	uint8_t dummy930[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P4;
	uint8_t dummy931[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P5;
	uint8_t dummy932[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P6;
	uint8_t dummy933[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_P7;
	uint8_t dummy934[12];
	uint32_t SWITCH_CORE_TC_SEL_TABLE_IMP;
	uint8_t dummy935[28];
	uint32_t SWITCH_CORE_CPU2COS_MAP;
	uint8_t dummy936[60];
	uint32_t SWITCH_CORE_TC2COS_MAP_P0;
	uint8_t dummy937[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P1;
	uint8_t dummy938[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P2;
	uint8_t dummy939[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P3;
	uint8_t dummy940[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P4;
	uint8_t dummy941[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P5;
	uint8_t dummy942[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P6;
	uint8_t dummy943[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_P7;
	uint8_t dummy944[28];
	uint32_t SWITCH_CORE_TC2COS_MAP_IMP;
	uint8_t dummy945[188];
	uint32_t SWITCH_CORE_QOS_REG_SPARE0;
	uint8_t dummy946[28];
	uint32_t SWITCH_CORE_QOS_REG_SPARE1;
	uint8_t dummy947[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P0;
	uint8_t dummy948[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P1;
	uint8_t dummy949[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P2;
	uint8_t dummy950[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P3;
	uint8_t dummy951[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P4;
	uint8_t dummy952[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P5;
	uint8_t dummy953[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P6;
	uint8_t dummy954[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_P7;
	uint8_t dummy955[28];
	uint32_t SWITCH_CORE_PCP2TC_DEI1_IMP;
	uint8_t dummy956[380];
	uint32_t port_vlan_ctrl[4*9];
	uint8_t dummy965[112];
	uint32_t SWITCH_CORE_VLAN_REG_SPARE0;
	uint8_t dummy966[28];
	uint32_t SWITCH_CORE_VLAN_REG_SPARE1;
	uint8_t dummy967[1756];
	uint32_t SWITCH_CORE_MAC_TRUNK_CTL;
	uint8_t dummy968[12];
	uint32_t SWITCH_CORE_IMP0_GRP_CTL;
	uint8_t dummy969[108];
	uint32_t SWITCH_CORE_TRUNK_GRP_CTL0;
	uint8_t dummy970[12];
	uint32_t SWITCH_CORE_TRUNK_GRP_CTL1;
	uint8_t dummy971[12];
	uint32_t SWITCH_CORE_TRUNK_GRP_CTL2;
	uint8_t dummy972[12];
	uint32_t SWITCH_CORE_TRUNK_GRP_CTL3;
	uint8_t dummy973[76];
	uint32_t SWITCH_CORE_TRUNK_HASH_OVRRD;
	uint8_t dummy974[252];
	uint32_t SWITCH_CORE_TRUNK_REG_SPARE0;
	uint8_t dummy975[28];
	uint32_t SWITCH_CORE_TRUNK_REG_SPARE1;
	uint8_t dummy976[3548];
	uint64_t SWITCH_CORE_VLAN_CTRL0;
	uint64_t SWITCH_CORE_VLAN_CTRL1;
	uint64_t SWITCH_CORE_VLAN_CTRL2;
	uint32_t SWITCH_CORE_VLAN_CTRL3;
	uint8_t dummy977[12];
	uint64_t SWITCH_CORE_VLAN_CTRL4;
	uint64_t SWITCH_CORE_VLAN_CTRL5;
	uint32_t SWITCH_CORE_VLAN_CTRL6;
	uint8_t dummy978[20];
	uint32_t SWITCH_CORE_VLAN_MULTI_PORT_ADDR_CTL;
	uint8_t dummy979[44];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P0;
	uint8_t dummy980[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P1;
	uint8_t dummy981[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P2;
	uint8_t dummy982[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P3;
	uint8_t dummy983[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P4;
	uint8_t dummy984[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P5;
	uint8_t dummy985[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P6;
	uint8_t dummy986[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_P7;
	uint8_t dummy987[12];
	uint32_t SWITCH_CORE_DEFAULT_1Q_TAG_IMP;
	uint8_t dummy988[124];
	uint32_t SWITCH_CORE_DTAG_TPID;
	uint8_t dummy989[12];
	uint32_t SWITCH_CORE_ISP_SEL_PORTMAP;
	uint8_t dummy990[108];
	uint32_t SWITCH_CORE_EGRESS_VID_RMK_TBL_ACS;
	uint8_t dummy991[28];
	uint32_t SWITCH_CORE_EGRESS_VID_RMK_TBL_DATA;
	uint8_t dummy992[92];
	uint32_t SWITCH_CORE_JOIN_ALL_VLAN_EN;
	uint8_t dummy993[12];
	uint32_t SWITCH_CORE_PORT_IVL_SVL_CTRL;
	uint8_t dummy994[108];
	uint32_t SWITCH_CORE_BCM8021Q_REG_SPARE0;
	uint8_t dummy995[28];
	uint32_t SWITCH_CORE_BCM8021Q_REG_SPARE1;
	uint8_t dummy996[3292];
	uint32_t SWITCH_CORE_DOS_CTRL;
	uint8_t dummy997[28];
	uint32_t SWITCH_CORE_MINIMUM_TCP_HDR_SZ;
	uint8_t dummy998[28];
	uint32_t SWITCH_CORE_MAX_ICMPV4_SIZE_REG;
	uint8_t dummy999[28];
	uint32_t SWITCH_CORE_MAX_ICMPV6_SIZE_REG;
	uint8_t dummy1000[28];
	uint32_t SWITCH_CORE_DOS_DIS_LRN_REG;
	uint8_t dummy1001[124];
	uint32_t SWITCH_CORE_DOS_REG_SPARE0;
	uint8_t dummy1002[28];
	uint32_t SWITCH_CORE_DOS_REG_SPARE1;
	uint8_t dummy1003[20196];
	uint32_t SWITCH_CORE_JUMBO_PORT_MASK;
	uint8_t dummy1004[28];
	uint32_t SWITCH_CORE_MIB_GD_FM_MAX_SIZE;
	uint8_t dummy1005[84];
	uint32_t SWITCH_CORE_JUMBO_CTRL_REG_SPARE0;
	uint8_t dummy1006[28];
	uint32_t SWITCH_CORE_JUMBO_CTRL_REG_SPARE1;
	uint8_t dummy1007[1884];
	uint32_t SWITCH_CORE_COMM_IRC_CON;
	uint8_t dummy1008[28];
	uint32_t SWITCH_CORE_IRC_VIRTUAL_ZERO_THD;
	uint8_t dummy1009[12];
	uint32_t SWITCH_CORE_IRC_ALARM_THD;
	uint8_t dummy1010[76];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P0;
	uint8_t dummy1011[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P1;
	uint8_t dummy1012[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P2;
	uint8_t dummy1013[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P3;
	uint8_t dummy1014[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P4;
	uint8_t dummy1015[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P5;
	uint8_t dummy1016[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P6;
	uint8_t dummy1017[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_P7;
	uint8_t dummy1018[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_IMP;
	uint8_t dummy1019[28];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P0;
	uint8_t dummy1020[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P1;
	uint8_t dummy1021[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P2;
	uint8_t dummy1022[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P3;
	uint8_t dummy1023[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P4;
	uint8_t dummy1024[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P5;
	uint8_t dummy1025[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P6;
	uint8_t dummy1026[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_P7;
	uint8_t dummy1027[12];
	uint32_t SWITCH_CORE_BC_SUP_RATECTRL_1_IMP;
	uint8_t dummy1028[92];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P0;
	uint8_t dummy1029[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P1;
	uint8_t dummy1030[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P2;
	uint8_t dummy1031[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P3;
	uint8_t dummy1032[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P4;
	uint8_t dummy1033[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P5;
	uint8_t dummy1034[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P6;
	uint8_t dummy1035[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_P7;
	uint8_t dummy1036[28];
	uint32_t SWITCH_CORE_BC_SUP_PKTDROP_CNT_IMP;
	uint8_t dummy1037[764];
	uint32_t SWITCH_CORE_BC_SUPPRESS_REG_SPARE0;
	uint8_t dummy1038[28];
	uint32_t SWITCH_CORE_BC_SUPPRESS_REG_SPARE1;
	uint8_t dummy1039[348];
	uint64_t SWITCH_CORE_EAP_GLO_CON;
	uint64_t SWITCH_CORE_EAP_MULTI_ADDR_CTRL;
	uint32_t SWITCH_CORE_EAP_DIP0;
	uint8_t dummy1040[60];
	uint32_t SWITCH_CORE_EAP_DIP1;
	uint8_t dummy1041[172];
	uint32_t SWITCH_CORE_EAP_CON_P0;
	uint8_t dummy1042[60];
	uint32_t SWITCH_CORE_EAP_CON_P1;
	uint8_t dummy1043[60];
	uint32_t SWITCH_CORE_EAP_CON_P2;
	uint8_t dummy1044[60];
	uint32_t SWITCH_CORE_EAP_CON_P3;
	uint8_t dummy1045[60];
	uint32_t SWITCH_CORE_EAP_CON_P4;
	uint8_t dummy1046[60];
	uint32_t SWITCH_CORE_EAP_CON_P5;
	uint8_t dummy1047[60];
	uint32_t SWITCH_CORE_EAP_CON_P6;
	uint8_t dummy1048[60];
	uint32_t SWITCH_CORE_EAP_CON_P7;
	uint8_t dummy1049[60];
	uint32_t SWITCH_CORE_EAP_CON_IMP;
	uint8_t dummy1050[124];
	uint32_t SWITCH_CORE_IEEE8021X_REG_SPARE0;
	uint8_t dummy1051[28];
	uint32_t SWITCH_CORE_IEEE8021X_REG_SPARE1;
	uint8_t dummy1052[1116];
	uint32_t SWITCH_CORE_MST_CON;
	uint8_t dummy1053[12];
	uint32_t SWITCH_CORE_MST_AGE;
	uint8_t dummy1054[108];
	uint32_t SWITCH_CORE_MST_TAB0;
	uint8_t dummy1055[28];
	uint32_t SWITCH_CORE_MST_TAB1;
	uint8_t dummy1056[28];
	uint32_t SWITCH_CORE_MST_TAB2;
	uint8_t dummy1057[28];
	uint32_t SWITCH_CORE_MST_TAB3;
	uint8_t dummy1058[28];
	uint32_t SWITCH_CORE_MST_TAB4;
	uint8_t dummy1059[28];
	uint32_t SWITCH_CORE_MST_TAB5;
	uint8_t dummy1060[28];
	uint32_t SWITCH_CORE_MST_TAB6;
	uint8_t dummy1061[28];
	uint32_t SWITCH_CORE_MST_TAB7;
	uint8_t dummy1062[284];
	uint32_t SWITCH_CORE_SPT_MULTI_ADDR_BPS_CTRL;
	uint8_t dummy1063[124];
	uint32_t SWITCH_CORE_IEEE8021S_REG_SPARE0;
	uint8_t dummy1064[28];
	uint32_t SWITCH_CORE_IEEE8021S_REG_SPARE1;
	uint8_t dummy1065[3292];
	uint32_t SWITCH_CORE_SA_LIMIT_ENABLE;
	uint8_t dummy1066[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_RST;
	uint8_t dummy1067[12];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_RST;
	uint8_t dummy1068[92];
	uint32_t SWITCH_CORE_TOTAL_SA_LIMIT_CTL;
	uint8_t dummy1069[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P0;
	uint8_t dummy1070[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P1;
	uint8_t dummy1071[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P2;
	uint8_t dummy1072[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P3;
	uint8_t dummy1073[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P4;
	uint8_t dummy1074[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P5;
	uint8_t dummy1075[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P6;
	uint8_t dummy1076[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P7;
	uint8_t dummy1077[12];
	uint32_t SWITCH_CORE_SA_LIMIT_CTL_P8;
	uint8_t dummy1078[108];
	uint32_t SWITCH_CORE_TOTAL_SA_LRN_CNTR;
	uint8_t dummy1079[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P0;
	uint8_t dummy1080[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P1;
	uint8_t dummy1081[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P2;
	uint8_t dummy1082[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P3;
	uint8_t dummy1083[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P4;
	uint8_t dummy1084[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P5;
	uint8_t dummy1085[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P6;
	uint8_t dummy1086[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P7;
	uint8_t dummy1087[12];
	uint32_t SWITCH_CORE_SA_LRN_CNTR_P8;
	uint8_t dummy1088[108];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P0;
	uint8_t dummy1089[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P1;
	uint8_t dummy1090[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P2;
	uint8_t dummy1091[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P3;
	uint8_t dummy1092[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P4;
	uint8_t dummy1093[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P5;
	uint8_t dummy1094[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P6;
	uint8_t dummy1095[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P7;
	uint8_t dummy1096[28];
	uint32_t SWITCH_CORE_SA_OVERLIMIT_CNTR_P8;
	uint8_t dummy1097[28];
	uint32_t SWITCH_CORE_SA_OVER_LIMIT_COPY_REDIRECT;
	uint8_t dummy1098[92];
	uint32_t SWITCH_CORE_MAC_LIMIT_REG_SPARE0;
	uint8_t dummy1099[28];
	uint32_t SWITCH_CORE_MAC_LIMIT_REG_SPARE1;
	uint8_t dummy1100[988];
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P0;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P1;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P2;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P3;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P4;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P5;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P6;
	uint64_t SWITCH_CORE_QOS_PRI_CTL_P7;
	uint32_t SWITCH_CORE_QOS_PRI_CTL_IMP;
	uint8_t dummy1101[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P0;
	uint8_t dummy1102[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P1;
	uint8_t dummy1103[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P2;
	uint8_t dummy1104[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P3;
	uint8_t dummy1105[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P4;
	uint8_t dummy1106[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P5;
	uint8_t dummy1107[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P6;
	uint8_t dummy1108[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_P7;
	uint8_t dummy1109[60];
	uint32_t SWITCH_CORE_QOS_WEIGHT_IMP;
	uint8_t dummy1110[124];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P0;
	uint8_t dummy1111[12];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P1;
	uint8_t dummy1112[12];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P2;
	uint8_t dummy1113[12];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P3;
	uint8_t dummy1114[12];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P4;
	uint8_t dummy1115[12];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P5;
	uint8_t dummy1116[12];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P6;
	uint8_t dummy1117[28];
	uint32_t SWITCH_CORE_WDRR_PENALTY_P7;
	uint8_t dummy1118[12];
	uint32_t SWITCH_CORE_P8_WDRR_PENALTY;
	uint8_t dummy1119[108];
	uint32_t SWITCH_CORE_SCHEDULER_REG_SPARE0;
	uint8_t dummy1120[28];
	uint32_t SWITCH_CORE_SCHEDULER_REG_SPARE1;
	uint8_t dummy1121[988];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P0;
	uint8_t dummy1122[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P1;
	uint8_t dummy1123[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P2;
	uint8_t dummy1124[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P3;
	uint8_t dummy1125[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P4;
	uint8_t dummy1126[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P5;
	uint8_t dummy1127[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P6;
	uint8_t dummy1128[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_P7;
	uint8_t dummy1129[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_REFRESH_IMP;
	uint8_t dummy1130[124];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P0;
	uint8_t dummy1131[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P1;
	uint8_t dummy1132[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P2;
	uint8_t dummy1133[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P3;
	uint8_t dummy1134[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P4;
	uint8_t dummy1135[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P5;
	uint8_t dummy1136[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P6;
	uint8_t dummy1137[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_P7;
	uint8_t dummy1138[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_BYTE_BASED_MAX_THD_SEL_IMP;
	uint8_t dummy1139[124];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P0;
	uint8_t dummy1140[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P1;
	uint8_t dummy1141[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P2;
	uint8_t dummy1142[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P3;
	uint8_t dummy1143[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P4;
	uint8_t dummy1144[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P5;
	uint8_t dummy1145[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P6;
	uint8_t dummy1146[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_P7;
	uint8_t dummy1147[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_STS_IMP;
	uint8_t dummy1148[124];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P0;
	uint8_t dummy1149[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P1;
	uint8_t dummy1150[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P2;
	uint8_t dummy1151[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P3;
	uint8_t dummy1152[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P4;
	uint8_t dummy1153[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P5;
	uint8_t dummy1154[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P6;
	uint8_t dummy1155[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_P7;
	uint8_t dummy1156[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_REFRESH_IMP;
	uint8_t dummy1157[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_CTLREG_REG_SPARE0;
	uint8_t dummy1158[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_CTLREG_REG_SPARE1;
	uint8_t dummy1159[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P0;
	uint8_t dummy1160[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P1;
	uint8_t dummy1161[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P2;
	uint8_t dummy1162[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P3;
	uint8_t dummy1163[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P4;
	uint8_t dummy1164[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P5;
	uint8_t dummy1165[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P6;
	uint8_t dummy1166[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_P7;
	uint8_t dummy1167[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_PACKET_BASED_MAX_THD_SEL_IMP;
	uint8_t dummy1168[28];
	uint32_t SWITCH_CORE_PORT_SHAPER_AVB_SHAPING_MODE;
	uint8_t dummy1169[12];
	uint32_t SWITCH_CORE_PORT_SHAPER_ENABLE;
	uint8_t dummy1170[12];
	uint32_t SWITCH_CORE_PORT_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1171[12];
	uint32_t SWITCH_CORE_PORT_SHAPER_BLOCKING;
	uint8_t dummy1172[28];
	uint32_t SWITCH_CORE_IFG_BYTES;
	uint8_t dummy1173[140];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P0;
	uint8_t dummy1174[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P1;
	uint8_t dummy1175[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P2;
	uint8_t dummy1176[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P3;
	uint8_t dummy1177[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P4;
	uint8_t dummy1178[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P5;
	uint8_t dummy1179[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P6;
	uint8_t dummy1180[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_P7;
	uint8_t dummy1181[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_REFRESH_IMP;
	uint8_t dummy1182[124];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P0;
	uint8_t dummy1183[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P1;
	uint8_t dummy1184[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P2;
	uint8_t dummy1185[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P3;
	uint8_t dummy1186[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P4;
	uint8_t dummy1187[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P5;
	uint8_t dummy1188[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P6;
	uint8_t dummy1189[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_P7;
	uint8_t dummy1190[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_THD_SEL_IMP;
	uint8_t dummy1191[124];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P0;
	uint8_t dummy1192[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P1;
	uint8_t dummy1193[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P2;
	uint8_t dummy1194[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P3;
	uint8_t dummy1195[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P4;
	uint8_t dummy1196[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P5;
	uint8_t dummy1197[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P6;
	uint8_t dummy1198[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_P7;
	uint8_t dummy1199[28];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_STS_IMP;
	uint8_t dummy1200[124];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1201[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1202[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1203[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1204[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1205[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1206[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1207[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1208[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1209[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q0_CONFIG_REG_SPARE0;
	uint8_t dummy1210[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q0_CONFIG_REG_SPARE1;
	uint8_t dummy1211[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1212[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1213[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1214[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1215[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1216[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1217[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1218[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1219[28];
	uint32_t SWITCH_CORE_QUEUE0_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1220[28];
	uint32_t SWITCH_CORE_QUEUE0_AVB_SHAPING_MODE;
	uint8_t dummy1221[12];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_ENABLE;
	uint8_t dummy1222[12];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1223[12];
	uint32_t SWITCH_CORE_QUEUE0_SHAPER_BLOCKING;
	uint8_t dummy1224[172];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P0;
	uint8_t dummy1225[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P1;
	uint8_t dummy1226[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P2;
	uint8_t dummy1227[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P3;
	uint8_t dummy1228[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P4;
	uint8_t dummy1229[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P5;
	uint8_t dummy1230[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P6;
	uint8_t dummy1231[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_P7;
	uint8_t dummy1232[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_REFRESH_IMP;
	uint8_t dummy1233[124];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P0;
	uint8_t dummy1234[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P1;
	uint8_t dummy1235[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P2;
	uint8_t dummy1236[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P3;
	uint8_t dummy1237[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P4;
	uint8_t dummy1238[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P5;
	uint8_t dummy1239[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P6;
	uint8_t dummy1240[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_P7;
	uint8_t dummy1241[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_THD_SEL_IMP;
	uint8_t dummy1242[124];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P0;
	uint8_t dummy1243[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P1;
	uint8_t dummy1244[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P2;
	uint8_t dummy1245[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P3;
	uint8_t dummy1246[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P4;
	uint8_t dummy1247[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P5;
	uint8_t dummy1248[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P6;
	uint8_t dummy1249[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_P7;
	uint8_t dummy1250[28];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_STS_IMP;
	uint8_t dummy1251[124];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1252[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1253[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1254[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1255[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1256[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1257[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1258[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1259[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1260[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q1_CONFIG_REG_SPARE0;
	uint8_t dummy1261[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q1_CONFIG_REG_SPARE1;
	uint8_t dummy1262[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1263[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1264[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1265[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1266[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1267[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1268[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1269[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1270[28];
	uint32_t SWITCH_CORE_QUEUE1_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1271[28];
	uint32_t SWITCH_CORE_QUEUE1_AVB_SHAPING_MODE;
	uint8_t dummy1272[12];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_ENABLE;
	uint8_t dummy1273[12];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1274[12];
	uint32_t SWITCH_CORE_QUEUE1_SHAPER_BLOCKING;
	uint8_t dummy1275[172];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P0;
	uint8_t dummy1276[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P1;
	uint8_t dummy1277[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P2;
	uint8_t dummy1278[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P3;
	uint8_t dummy1279[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P4;
	uint8_t dummy1280[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P5;
	uint8_t dummy1281[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P6;
	uint8_t dummy1282[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_P7;
	uint8_t dummy1283[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_REFRESH_IMP;
	uint8_t dummy1284[124];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P0;
	uint8_t dummy1285[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P1;
	uint8_t dummy1286[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P2;
	uint8_t dummy1287[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P3;
	uint8_t dummy1288[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P4;
	uint8_t dummy1289[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P5;
	uint8_t dummy1290[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P6;
	uint8_t dummy1291[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_P7;
	uint8_t dummy1292[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_THD_SEL_IMP;
	uint8_t dummy1293[124];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P0;
	uint8_t dummy1294[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P1;
	uint8_t dummy1295[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P2;
	uint8_t dummy1296[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P3;
	uint8_t dummy1297[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P4;
	uint8_t dummy1298[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P5;
	uint8_t dummy1299[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P6;
	uint8_t dummy1300[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_P7;
	uint8_t dummy1301[28];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_STS_IMP;
	uint8_t dummy1302[124];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1303[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1304[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1305[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1306[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1307[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1308[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1309[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1310[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1311[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q2_CONFIG_REG_SPARE0;
	uint8_t dummy1312[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q2_CONFIG_REG_SPARE1;
	uint8_t dummy1313[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1314[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1315[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1316[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1317[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1318[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1319[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1320[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1321[28];
	uint32_t SWITCH_CORE_QUEUE2_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1322[28];
	uint32_t SWITCH_CORE_QUEUE2_AVB_SHAPING_MODE;
	uint8_t dummy1323[12];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_ENABLE;
	uint8_t dummy1324[12];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1325[12];
	uint32_t SWITCH_CORE_QUEUE2_SHAPER_BLOCKING;
	uint8_t dummy1326[172];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P0;
	uint8_t dummy1327[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P1;
	uint8_t dummy1328[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P2;
	uint8_t dummy1329[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P3;
	uint8_t dummy1330[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P4;
	uint8_t dummy1331[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P5;
	uint8_t dummy1332[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P6;
	uint8_t dummy1333[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_P7;
	uint8_t dummy1334[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_REFRESH_IMP;
	uint8_t dummy1335[124];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P0;
	uint8_t dummy1336[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P1;
	uint8_t dummy1337[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P2;
	uint8_t dummy1338[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P3;
	uint8_t dummy1339[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P4;
	uint8_t dummy1340[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P5;
	uint8_t dummy1341[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P6;
	uint8_t dummy1342[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_P7;
	uint8_t dummy1343[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_THD_SEL_IMP;
	uint8_t dummy1344[124];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P0;
	uint8_t dummy1345[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P1;
	uint8_t dummy1346[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P2;
	uint8_t dummy1347[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P3;
	uint8_t dummy1348[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P4;
	uint8_t dummy1349[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P5;
	uint8_t dummy1350[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P6;
	uint8_t dummy1351[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_P7;
	uint8_t dummy1352[28];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_STS_IMP;
	uint8_t dummy1353[124];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1354[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1355[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1356[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1357[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1358[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1359[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1360[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1361[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1362[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q3_CONFIG_REG_SPARE0;
	uint8_t dummy1363[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q3_CONFIG_REG_SPARE1;
	uint8_t dummy1364[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1365[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1366[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1367[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1368[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1369[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1370[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1371[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1372[28];
	uint32_t SWITCH_CORE_QUEUE3_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1373[28];
	uint32_t SWITCH_CORE_QUEUE3_AVB_SHAPING_MODE;
	uint8_t dummy1374[12];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_ENABLE;
	uint8_t dummy1375[12];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1376[12];
	uint32_t SWITCH_CORE_QUEUE3_SHAPER_BLOCKING;
	uint8_t dummy1377[172];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P0;
	uint8_t dummy1378[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P1;
	uint8_t dummy1379[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P2;
	uint8_t dummy1380[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P3;
	uint8_t dummy1381[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P4;
	uint8_t dummy1382[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P5;
	uint8_t dummy1383[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P6;
	uint8_t dummy1384[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_P7;
	uint8_t dummy1385[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_REFRESH_IMP;
	uint8_t dummy1386[124];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P0;
	uint8_t dummy1387[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P1;
	uint8_t dummy1388[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P2;
	uint8_t dummy1389[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P3;
	uint8_t dummy1390[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P4;
	uint8_t dummy1391[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P5;
	uint8_t dummy1392[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P6;
	uint8_t dummy1393[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_P7;
	uint8_t dummy1394[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_THD_SEL_IMP;
	uint8_t dummy1395[124];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P0;
	uint8_t dummy1396[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P1;
	uint8_t dummy1397[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P2;
	uint8_t dummy1398[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P3;
	uint8_t dummy1399[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P4;
	uint8_t dummy1400[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P5;
	uint8_t dummy1401[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P6;
	uint8_t dummy1402[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_P7;
	uint8_t dummy1403[28];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_STS_IMP;
	uint8_t dummy1404[124];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1405[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1406[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1407[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1408[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1409[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1410[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1411[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1412[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1413[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q4_CONFIG_REG_SPARE0;
	uint8_t dummy1414[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q4_CONFIG_REG_SPARE1;
	uint8_t dummy1415[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1416[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1417[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1418[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1419[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1420[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1421[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1422[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1423[28];
	uint32_t SWITCH_CORE_QUEUE4_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1424[28];
	uint32_t SWITCH_CORE_QUEUE4_AVB_SHAPING_MODE;
	uint8_t dummy1425[12];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_ENABLE;
	uint8_t dummy1426[12];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1427[12];
	uint32_t SWITCH_CORE_QUEUE4_SHAPER_BLOCKING;
	uint8_t dummy1428[172];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P0;
	uint8_t dummy1429[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P1;
	uint8_t dummy1430[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P2;
	uint8_t dummy1431[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P3;
	uint8_t dummy1432[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P4;
	uint8_t dummy1433[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P5;
	uint8_t dummy1434[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P6;
	uint8_t dummy1435[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_P7;
	uint8_t dummy1436[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_REFRESH_IMP;
	uint8_t dummy1437[124];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P0;
	uint8_t dummy1438[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P1;
	uint8_t dummy1439[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P2;
	uint8_t dummy1440[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P3;
	uint8_t dummy1441[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P4;
	uint8_t dummy1442[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P5;
	uint8_t dummy1443[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P6;
	uint8_t dummy1444[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_P7;
	uint8_t dummy1445[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_THD_SEL_IMP;
	uint8_t dummy1446[124];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P0;
	uint8_t dummy1447[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P1;
	uint8_t dummy1448[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P2;
	uint8_t dummy1449[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P3;
	uint8_t dummy1450[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P4;
	uint8_t dummy1451[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P5;
	uint8_t dummy1452[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P6;
	uint8_t dummy1453[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_P7;
	uint8_t dummy1454[28];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_STS_IMP;
	uint8_t dummy1455[124];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1456[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1457[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1458[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1459[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1460[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1461[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1462[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1463[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1464[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q5_CONFIG_REG_SPARE0;
	uint8_t dummy1465[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q5_CONFIG_REG_SPARE1;
	uint8_t dummy1466[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1467[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1468[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1469[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1470[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1471[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1472[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1473[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1474[28];
	uint32_t SWITCH_CORE_QUEUE5_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1475[28];
	uint32_t SWITCH_CORE_QUEUE5_AVB_SHAPING_MODE;
	uint8_t dummy1476[12];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_ENABLE;
	uint8_t dummy1477[12];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1478[12];
	uint32_t SWITCH_CORE_QUEUE5_SHAPER_BLOCKING;
	uint8_t dummy1479[172];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P0;
	uint8_t dummy1480[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P1;
	uint8_t dummy1481[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P2;
	uint8_t dummy1482[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P3;
	uint8_t dummy1483[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P4;
	uint8_t dummy1484[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P5;
	uint8_t dummy1485[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P6;
	uint8_t dummy1486[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_P7;
	uint8_t dummy1487[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_REFRESH_IMP;
	uint8_t dummy1488[124];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P0;
	uint8_t dummy1489[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P1;
	uint8_t dummy1490[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P2;
	uint8_t dummy1491[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P3;
	uint8_t dummy1492[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P4;
	uint8_t dummy1493[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P5;
	uint8_t dummy1494[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P6;
	uint8_t dummy1495[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_P7;
	uint8_t dummy1496[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_THD_SEL_IMP;
	uint8_t dummy1497[124];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P0;
	uint8_t dummy1498[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P1;
	uint8_t dummy1499[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P2;
	uint8_t dummy1500[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P3;
	uint8_t dummy1501[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P4;
	uint8_t dummy1502[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P5;
	uint8_t dummy1503[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P6;
	uint8_t dummy1504[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_P7;
	uint8_t dummy1505[28];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_STS_IMP;
	uint8_t dummy1506[124];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1507[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1508[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1509[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1510[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1511[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1512[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1513[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1514[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1515[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q6_CONFIG_REG_SPARE0;
	uint8_t dummy1516[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q6_CONFIG_REG_SPARE1;
	uint8_t dummy1517[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1518[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1519[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1520[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1521[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1522[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1523[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1524[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1525[28];
	uint32_t SWITCH_CORE_QUEUE6_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1526[28];
	uint32_t SWITCH_CORE_QUEUE6_AVB_SHAPING_MODE;
	uint8_t dummy1527[12];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_ENABLE;
	uint8_t dummy1528[12];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1529[12];
	uint32_t SWITCH_CORE_QUEUE6_SHAPER_BLOCKING;
	uint8_t dummy1530[172];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P0;
	uint8_t dummy1531[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P1;
	uint8_t dummy1532[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P2;
	uint8_t dummy1533[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P3;
	uint8_t dummy1534[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P4;
	uint8_t dummy1535[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P5;
	uint8_t dummy1536[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P6;
	uint8_t dummy1537[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_P7;
	uint8_t dummy1538[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_REFRESH_IMP;
	uint8_t dummy1539[124];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P0;
	uint8_t dummy1540[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P1;
	uint8_t dummy1541[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P2;
	uint8_t dummy1542[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P3;
	uint8_t dummy1543[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P4;
	uint8_t dummy1544[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P5;
	uint8_t dummy1545[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P6;
	uint8_t dummy1546[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_P7;
	uint8_t dummy1547[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_THD_SEL_IMP;
	uint8_t dummy1548[124];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P0;
	uint8_t dummy1549[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P1;
	uint8_t dummy1550[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P2;
	uint8_t dummy1551[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P3;
	uint8_t dummy1552[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P4;
	uint8_t dummy1553[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P5;
	uint8_t dummy1554[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P6;
	uint8_t dummy1555[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_P7;
	uint8_t dummy1556[28];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_STS_IMP;
	uint8_t dummy1557[124];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P0;
	uint8_t dummy1558[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P1;
	uint8_t dummy1559[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P2;
	uint8_t dummy1560[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P3;
	uint8_t dummy1561[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P4;
	uint8_t dummy1562[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P5;
	uint8_t dummy1563[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P6;
	uint8_t dummy1564[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_P7;
	uint8_t dummy1565[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_REFRESH_IMP;
	uint8_t dummy1566[60];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q7_CONFIG_REG_SPARE0;
	uint8_t dummy1567[28];
	uint32_t SWITCH_CORE_EGRESS_SHAPER_Q7_CONFIG_REG_SPARE1;
	uint8_t dummy1568[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P0;
	uint8_t dummy1569[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P1;
	uint8_t dummy1570[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P2;
	uint8_t dummy1571[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P3;
	uint8_t dummy1572[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P4;
	uint8_t dummy1573[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P5;
	uint8_t dummy1574[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P6;
	uint8_t dummy1575[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_P7;
	uint8_t dummy1576[28];
	uint32_t SWITCH_CORE_QUEUE7_MAX_PACKET_THD_SEL_IMP;
	uint8_t dummy1577[28];
	uint32_t SWITCH_CORE_QUEUE7_AVB_SHAPING_MODE;
	uint8_t dummy1578[12];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_ENABLE;
	uint8_t dummy1579[12];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_BUCKET_COUNT_SELECT;
	uint8_t dummy1580[12];
	uint32_t SWITCH_CORE_QUEUE7_SHAPER_BLOCKING;
	uint8_t dummy1581[65708];
	uint32_t SWITCH_CORE_MIB_SNAPSHOT_CTL;
	uint8_t dummy1582[2044];
	uint32_t SWITCH_CORE_S_TxOctets;
	uint8_t dummy1583[60];
	uint32_t SWITCH_CORE_S_TxDropPkts;
	uint8_t dummy1584[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ0;
	uint8_t dummy1585[28];
	uint32_t SWITCH_CORE_S_TxBroadcastPkts;
	uint8_t dummy1586[28];
	uint32_t SWITCH_CORE_S_TxMulticastPkts;
	uint8_t dummy1587[28];
	uint32_t SWITCH_CORE_S_TxUnicastPkts;
	uint8_t dummy1588[28];
	uint32_t SWITCH_CORE_S_TxCollisions;
	uint8_t dummy1589[28];
	uint32_t SWITCH_CORE_S_TxSingleCollision;
	uint8_t dummy1590[28];
	uint32_t SWITCH_CORE_S_TxMultipleCollision;
	uint8_t dummy1591[28];
	uint32_t SWITCH_CORE_S_TxDeferredTransmit;
	uint8_t dummy1592[28];
	uint32_t SWITCH_CORE_S_TxLateCollision;
	uint8_t dummy1593[28];
	uint32_t SWITCH_CORE_S_TxExcessiveCollision;
	uint8_t dummy1594[28];
	uint32_t SWITCH_CORE_S_TxFrameInDisc;
	uint8_t dummy1595[28];
	uint32_t SWITCH_CORE_S_TxPausePkts;
	uint8_t dummy1596[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ1;
	uint8_t dummy1597[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ2;
	uint8_t dummy1598[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ3;
	uint8_t dummy1599[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ4;
	uint8_t dummy1600[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ5;
	uint8_t dummy1601[28];
	uint32_t SWITCH_CORE_S_RxOctets;
	uint8_t dummy1602[60];
	uint32_t SWITCH_CORE_S_RxUndersizePkts;
	uint8_t dummy1603[28];
	uint32_t SWITCH_CORE_S_RxPausePkts;
	uint8_t dummy1604[28];
	uint32_t SWITCH_CORE_S_RxPkts64Octets;
	uint8_t dummy1605[28];
	uint32_t SWITCH_CORE_S_RxPkts65to127Octets;
	uint8_t dummy1606[28];
	uint32_t SWITCH_CORE_S_RxPkts128to255Octets;
	uint8_t dummy1607[28];
	uint32_t SWITCH_CORE_S_RxPkts256to511Octets;
	uint8_t dummy1608[28];
	uint32_t SWITCH_CORE_S_RxPkts512to1023Octets;
	uint8_t dummy1609[28];
	uint32_t SWITCH_CORE_S_RxPkts1024toMaxPktOctets;
	uint8_t dummy1610[28];
	uint32_t SWITCH_CORE_S_RxOversizePkts;
	uint8_t dummy1611[28];
	uint32_t SWITCH_CORE_S_RxJabbers;
	uint8_t dummy1612[28];
	uint32_t SWITCH_CORE_S_RxAlignmentErrors;
	uint8_t dummy1613[28];
	uint32_t SWITCH_CORE_S_RxFCSErrors;
	uint8_t dummy1614[28];
	uint32_t SWITCH_CORE_S_RxGoodOctets;
	uint8_t dummy1615[60];
	uint32_t SWITCH_CORE_S_RxDropPkts;
	uint8_t dummy1616[28];
	uint32_t SWITCH_CORE_S_RxUnicastPkts;
	uint8_t dummy1617[28];
	uint32_t SWITCH_CORE_S_RxMulticastPkts;
	uint8_t dummy1618[28];
	uint32_t SWITCH_CORE_S_RxBroadcastPkts;
	uint8_t dummy1619[28];
	uint32_t SWITCH_CORE_S_RxSAChanges;
	uint8_t dummy1620[28];
	uint32_t SWITCH_CORE_S_RxFragments;
	uint8_t dummy1621[28];
	uint32_t SWITCH_CORE_S_RxJumboPkt;
	uint8_t dummy1622[28];
	uint32_t SWITCH_CORE_S_RxSymblErr;
	uint8_t dummy1623[28];
	uint32_t SWITCH_CORE_S_InRangeErrCount;
	uint8_t dummy1624[28];
	uint32_t SWITCH_CORE_S_OutRangeErrCount;
	uint8_t dummy1625[28];
	uint32_t SWITCH_CORE_S_EEE_LPI_EVENT;
	uint8_t dummy1626[28];
	uint32_t SWITCH_CORE_S_EEE_LPI_DURATION;
	uint8_t dummy1627[28];
	uint32_t SWITCH_CORE_S_RxDiscard;
	uint8_t dummy1628[60];
	uint32_t SWITCH_CORE_S_TxQPKTQ6;
	uint8_t dummy1629[28];
	uint32_t SWITCH_CORE_S_TxQPKTQ7;
	uint8_t dummy1630[28];
	uint32_t SWITCH_CORE_S_TxPkts64Octets;
	uint8_t dummy1631[28];
	uint32_t SWITCH_CORE_S_TxPkts65to127Octets;
	uint8_t dummy1632[28];
	uint32_t SWITCH_CORE_S_TxPkts128to255Octets;
	uint8_t dummy1633[28];
	uint32_t SWITCH_CORE_S_TxPkts256to511Octets;
	uint8_t dummy1634[28];
	uint32_t SWITCH_CORE_S_TxPkts512to1023Octets;
	uint8_t dummy1635[28];
	uint32_t SWITCH_CORE_S_TxPkts1024toMaxPktOctets;
	uint8_t dummy1636[220];
	uint32_t SWITCH_CORE_LPDET_CFG;
	uint8_t dummy1637[12];
	uint64_t SWITCH_CORE_DF_TIMER;
	uint32_t SWITCH_CORE_LED_PORTMAP;
	uint8_t dummy1638[12];
	uint32_t SWITCH_CORE_MODULE_ID0;
	uint8_t dummy1639[44];
	uint32_t SWITCH_CORE_MODULE_ID1;
	uint8_t dummy1640[44];
	uint32_t SWITCH_CORE_LPDET_SA;
	uint8_t dummy1641[116];
	uint32_t SWITCH_CORE_LPDET_REG_SPARE0;
	uint8_t dummy1642[28];
	uint32_t SWITCH_CORE_LPDET_REG_SPARE1;
	uint8_t dummy1643[1756];
	uint64_t SWITCH_CORE_BPM_CTRL;
	uint64_t SWITCH_CORE_BPM_PSM_OVR_CTRL;
	uint32_t SWITCH_CORE_BPM_PSM_TIME_CFG;
	uint8_t dummy1644[12];
	uint32_t SWITCH_CORE_BPM_PSM_THD_CFG;
	uint8_t dummy1645[28];
	uint32_t SWITCH_CORE_ROW_VMASK_OVR_CTRL;
	uint8_t dummy1646[28];
	uint32_t SWITCH_CORE_BPM_STS;
	uint8_t dummy1647[28];
	uint32_t SWITCH_CORE_BPM_PDA_OVR_CTRL;
	uint8_t dummy1648[12];
	uint32_t SWITCH_CORE_PDA_TIMEOUT_CFG;
	uint8_t dummy1649[12];
	uint32_t SWITCH_CORE_PDA_SETUP_TIME_CFG;
	uint8_t dummy1650[12];
	uint32_t SWITCH_CORE_PDA_HOLD_TIME_CFG;
	uint8_t dummy1651[12];
	uint32_t SWITCH_CORE_PBB_VBUFCNT_P0;
	uint8_t dummy1652[12];
	uint32_t SWITCH_CORE_PBB_VBUFCNT_P1;
	uint8_t dummy1653[12];
	uint32_t SWITCH_CORE_PBB_VBUFCNT_P2;
	uint8_t dummy1654[12];
	uint32_t SWITCH_CORE_RCY_TIME_CFG;
	uint8_t dummy1655[12];
	uint32_t SWITCH_CORE_PBB_PWRDWN_MON_CTRL;
	uint8_t dummy1656[60];
	uint32_t SWITCH_CORE_PBB_PWRDWN_MON0;
	uint8_t dummy1657[60];
	uint32_t SWITCH_CORE_PBB_PWRDWN_MON1;
	uint8_t dummy1658[60];
	uint32_t SWITCH_CORE_PBB_PWRDWN_MON2;
	uint8_t dummy1659[316];
	uint32_t SWITCH_CORE_BPM_REG_SPARE0;
	uint8_t dummy1660[28];
	uint32_t SWITCH_CORE_BPM_REG_SPARE1;
	uint8_t dummy1661[60636];
	uint32_t SWITCH_CORE_TRREG_CTRL0;
	uint8_t dummy1662[28];
	uint32_t SWITCH_CORE_TRREG_CTRL1;
	uint8_t dummy1663[28];
	uint32_t SWITCH_CORE_TRREG_CTRL2;
	uint8_t dummy1664[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P0;
	uint8_t dummy1665[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P1;
	uint8_t dummy1666[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P2;
	uint8_t dummy1667[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P3;
	uint8_t dummy1668[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P4;
	uint8_t dummy1669[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P5;
	uint8_t dummy1670[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P6;
	uint8_t dummy1671[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_P7;
	uint8_t dummy1672[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2PCP_MAP_IMP;
	uint8_t dummy1673[124];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P0;
	uint8_t dummy1674[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P1;
	uint8_t dummy1675[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P2;
	uint8_t dummy1676[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P3;
	uint8_t dummy1677[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P4;
	uint8_t dummy1678[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P5;
	uint8_t dummy1679[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P6;
	uint8_t dummy1680[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_P7;
	uint8_t dummy1681[60];
	uint32_t SWITCH_CORE_EGRESS_PKT_TC2CPCP_MAP_IMP;
	uint8_t dummy1682[124];
	uint32_t SWITCH_CORE_TRREG_REG_SPARE0;
	uint8_t dummy1683[28];
	uint32_t SWITCH_CORE_TRREG_REG_SPARE1;
	uint8_t dummy1684[604];
	uint32_t SWITCH_CORE_EEE_EN_CTRL;
	uint8_t dummy1685[12];
	uint32_t SWITCH_CORE_EEE_LPI_ASSERT;
	uint8_t dummy1686[12];
	uint32_t SWITCH_CORE_EEE_LPI_INDICATE;
	uint8_t dummy1687[12];
	uint32_t SWITCH_CORE_EEE_RX_IDLE_SYMBOL;
	uint8_t dummy1688[12];
	uint32_t SWITCH_CORE_EEE_LPI_SYMBOL_TX_DISABLE;
	uint8_t dummy1689[28];
	uint32_t SWITCH_CORE_EEE_PIPELINE_TIMER;
	uint8_t dummy1690[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P0;
	uint8_t dummy1691[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P1;
	uint8_t dummy1692[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P2;
	uint8_t dummy1693[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P3;
	uint8_t dummy1694[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P4;
	uint8_t dummy1695[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P5;
	uint8_t dummy1696[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P6;
	uint8_t dummy1697[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_P7;
	uint8_t dummy1698[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_G_IMP;
	uint8_t dummy1699[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P0;
	uint8_t dummy1700[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P1;
	uint8_t dummy1701[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P2;
	uint8_t dummy1702[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P3;
	uint8_t dummy1703[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P4;
	uint8_t dummy1704[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P5;
	uint8_t dummy1705[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P6;
	uint8_t dummy1706[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_P7;
	uint8_t dummy1707[28];
	uint32_t SWITCH_CORE_EEE_SLEEP_TIMER_H_IMP;
	uint8_t dummy1708[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P0;
	uint8_t dummy1709[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P1;
	uint8_t dummy1710[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P2;
	uint8_t dummy1711[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P3;
	uint8_t dummy1712[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P4;
	uint8_t dummy1713[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P5;
	uint8_t dummy1714[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P6;
	uint8_t dummy1715[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_P7;
	uint8_t dummy1716[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_G_IMP;
	uint8_t dummy1717[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P0;
	uint8_t dummy1718[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P1;
	uint8_t dummy1719[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P2;
	uint8_t dummy1720[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P3;
	uint8_t dummy1721[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P4;
	uint8_t dummy1722[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P5;
	uint8_t dummy1723[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P6;
	uint8_t dummy1724[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_P7;
	uint8_t dummy1725[28];
	uint32_t SWITCH_CORE_EEE_MIN_LP_TIMER_H_IMP;
	uint8_t dummy1726[28];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P0;
	uint8_t dummy1727[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P1;
	uint8_t dummy1728[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P2;
	uint8_t dummy1729[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P3;
	uint8_t dummy1730[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P4;
	uint8_t dummy1731[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P5;
	uint8_t dummy1732[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P6;
	uint8_t dummy1733[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P7;
	uint8_t dummy1734[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_G_P8;
	uint8_t dummy1735[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P0;
	uint8_t dummy1736[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P1;
	uint8_t dummy1737[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P2;
	uint8_t dummy1738[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P3;
	uint8_t dummy1739[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P4;
	uint8_t dummy1740[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P5;
	uint8_t dummy1741[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P6;
	uint8_t dummy1742[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_P7;
	uint8_t dummy1743[12];
	uint32_t SWITCH_CORE_EEE_WAKE_TIMER_H_IMP;
	uint8_t dummy1744[12];
	uint32_t SWITCH_CORE_EEE_GLB_CONG_TH;
	uint8_t dummy1745[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q0;
	uint8_t dummy1746[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q1;
	uint8_t dummy1747[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q2;
	uint8_t dummy1748[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q3;
	uint8_t dummy1749[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q4;
	uint8_t dummy1750[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q5;
	uint8_t dummy1751[20];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q6;
	uint8_t dummy1752[12];
	uint32_t SWITCH_CORE_EEE_TX_CONG_TH_Q7;
	uint8_t dummy1753[44];
	uint32_t SWITCH_CORE_EEE_CTL_REG_SPARE0;
	uint8_t dummy1754[36];
	uint32_t SWITCH_CORE_EEE_CTL_REG_SPARE1;
	uint8_t dummy1755[52];
	uint64_t SWITCH_CORE_EEE_DEBUG;
	uint32_t SWITCH_CORE_EEE_LINK_DLY_TIMER;
	uint8_t dummy1756[28];
	uint32_t SWITCH_CORE_EEE_STATE;
	uint8_t dummy1757[156];
	uint32_t SWITCH_CORE_PORT_ENABLE;
	uint8_t dummy1758[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P0;
	uint8_t dummy1759[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P1;
	uint8_t dummy1760[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P2;
	uint8_t dummy1761[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P3;
	uint8_t dummy1762[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P4;
	uint8_t dummy1763[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P5;
	uint8_t dummy1764[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_P7;
	uint8_t dummy1765[12];
	uint32_t SWITCH_CORE_TX_MODE_PORT_IMP;
	uint8_t dummy1766[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P0;
	uint8_t dummy1767[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P1;
	uint8_t dummy1768[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P2;
	uint8_t dummy1769[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P3;
	uint8_t dummy1770[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P4;
	uint8_t dummy1771[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P5;
	uint8_t dummy1772[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_P7;
	uint8_t dummy1773[12];
	uint32_t SWITCH_CORE_RX_MODE_PORT_IMP;
	uint8_t dummy1774[12];
	uint32_t SWITCH_CORE_TX_TS_CAP;
	uint8_t dummy1775[12];
	uint32_t SWITCH_CORE_RX_TS_CAP;
	uint8_t dummy1776[12];
	uint32_t SWITCH_CORE_RX_TX_OPTION;
	uint8_t dummy1777[12];
	uint32_t SWITCH_CORE_RX_PORT_0_LINK_DELAY_LSB;
	uint8_t dummy1778[12];
	uint32_t SWITCH_CORE_RX_PORT_0_LINK_DELAY_MSB;
	uint8_t dummy1779[12];
	uint32_t SWITCH_CORE_RX_PORT_1_LINK_DELAY_LSB;
	uint8_t dummy1780[12];
	uint32_t SWITCH_CORE_RX_PORT_1_LINK_DELAY_MSB;
	uint8_t dummy1781[12];
	uint32_t SWITCH_CORE_RX_PORT_2_LINK_DELAY_LSB;
	uint8_t dummy1782[12];
	uint32_t SWITCH_CORE_RX_PORT_2_LINK_DELAY_MSB;
	uint8_t dummy1783[12];
	uint32_t SWITCH_CORE_RX_PORT_3_LINK_DELAY_LSB;
	uint8_t dummy1784[12];
	uint32_t SWITCH_CORE_RX_PORT_3_LINK_DELAY_MSB;
	uint8_t dummy1785[12];
	uint32_t SWITCH_CORE_RX_PORT_4_LINK_DELAY_LSB;
	uint8_t dummy1786[12];
	uint32_t SWITCH_CORE_RX_PORT_4_LINK_DELAY_MSB;
	uint8_t dummy1787[12];
	uint32_t SWITCH_CORE_RX_PORT_5_LINK_DELAY_LSB;
	uint8_t dummy1788[12];
	uint32_t SWITCH_CORE_RX_PORT_5_LINK_DELAY_MSB;
	uint8_t dummy1789[12];
	uint32_t SWITCH_CORE_RX_PORT_7_LINK_DELAY_LSB;
	uint8_t dummy1790[12];
	uint32_t SWITCH_CORE_RX_PORT_7_LINK_DELAY_MSB;
	uint8_t dummy1791[12];
	uint32_t SWITCH_CORE_RX_PORT_8_LINK_DELAY_LSB;
	uint8_t dummy1792[12];
	uint32_t SWITCH_CORE_RX_PORT_8_LINK_DELAY_MSB;
	uint8_t dummy1793[12];
	uint32_t SWITCH_CORE_RX_PORT_0_TS_OFFSET_LSB;
	uint8_t dummy1794[12];
	uint32_t SWITCH_CORE_RX_PORT_0_TS_OFFSET_MSB;
	uint8_t dummy1795[12];
	uint32_t SWITCH_CORE_RX_PORT_1_TS_OFFSET_LSB;
	uint8_t dummy1796[12];
	uint32_t SWITCH_CORE_RX_PORT_1_TS_OFFSET_MSB;
	uint8_t dummy1797[12];
	uint32_t SWITCH_CORE_RX_PORT_2_TS_OFFSET_LSB;
	uint8_t dummy1798[12];
	uint32_t SWITCH_CORE_RX_PORT_2_TS_OFFSET_MSB;
	uint8_t dummy1799[12];
	uint32_t SWITCH_CORE_RX_PORT_3_TS_OFFSET_LSB;
	uint8_t dummy1800[12];
	uint32_t SWITCH_CORE_RX_PORT_3_TS_OFFSET_MSB;
	uint8_t dummy1801[12];
	uint32_t SWITCH_CORE_RX_PORT_4_TS_OFFSET_LSB;
	uint8_t dummy1802[12];
	uint32_t SWITCH_CORE_RX_PORT_4_TS_OFFSET_MSB;
	uint8_t dummy1803[12];
	uint32_t SWITCH_CORE_RX_PORT_5_TS_OFFSET_LSB;
	uint8_t dummy1804[12];
	uint32_t SWITCH_CORE_RX_PORT_5_TS_OFFSET_MSB;
	uint8_t dummy1805[12];
	uint32_t SWITCH_CORE_RX_PORT_7_TS_OFFSET_LSB;
	uint8_t dummy1806[12];
	uint32_t SWITCH_CORE_RX_PORT_7_TS_OFFSET_MSB;
	uint8_t dummy1807[12];
	uint32_t SWITCH_CORE_RX_PORT_8_TS_OFFSET_LSB;
	uint8_t dummy1808[12];
	uint32_t SWITCH_CORE_RX_PORT_8_TS_OFFSET_MSB;
	uint8_t dummy1809[12];
	uint32_t SWITCH_CORE_TX_PORT_0_TS_OFFSET_LSB;
	uint8_t dummy1810[12];
	uint32_t SWITCH_CORE_TX_PORT_0_TS_OFFSET_MSB;
	uint8_t dummy1811[12];
	uint32_t SWITCH_CORE_TX_PORT_1_TS_OFFSET_LSB;
	uint8_t dummy1812[12];
	uint32_t SWITCH_CORE_TX_PORT_1_TS_OFFSET_MSB;
	uint8_t dummy1813[12];
	uint32_t SWITCH_CORE_TX_PORT_2_TS_OFFSET_LSB;
	uint8_t dummy1814[12];
	uint32_t SWITCH_CORE_TX_PORT_2_TS_OFFSET_MSB;
	uint8_t dummy1815[12];
	uint32_t SWITCH_CORE_TX_PORT_3_TS_OFFSET_LSB;
	uint8_t dummy1816[12];
	uint32_t SWITCH_CORE_TX_PORT_3_TS_OFFSET_MSB;
	uint8_t dummy1817[12];
	uint32_t SWITCH_CORE_TX_PORT_4_TS_OFFSET_LSB;
	uint8_t dummy1818[12];
	uint32_t SWITCH_CORE_TX_PORT_4_TS_OFFSET_MSB;
	uint8_t dummy1819[12];
	uint32_t SWITCH_CORE_TX_PORT_5_TS_OFFSET_LSB;
	uint8_t dummy1820[12];
	uint32_t SWITCH_CORE_TX_PORT_5_TS_OFFSET_MSB;
	uint8_t dummy1821[12];
	uint32_t SWITCH_CORE_TX_PORT_7_TS_OFFSET_LSB;
	uint8_t dummy1822[12];
	uint32_t SWITCH_CORE_TX_PORT_7_TS_OFFSET_MSB;
	uint8_t dummy1823[12];
	uint32_t SWITCH_CORE_TX_PORT_8_TS_OFFSET_LSB;
	uint8_t dummy1824[12];
	uint32_t SWITCH_CORE_TX_PORT_8_TS_OFFSET_MSB;
	uint8_t dummy1825[12];
	uint32_t SWITCH_CORE_TIME_CODE_N_P0;
	uint8_t dummy1826[12];
	uint32_t SWITCH_CORE_TIME_CODE_N_P1;
	uint8_t dummy1827[12];
	uint32_t SWITCH_CORE_TIME_CODE_N_P2;
	uint8_t dummy1828[12];
	uint32_t SWITCH_CORE_TIME_CODE_N_P3;
	uint8_t dummy1829[12];
	uint32_t SWITCH_CORE_TIME_CODE_N_P4;
	uint8_t dummy1830[12];
	uint32_t SWITCH_CORE_DPLL_DB_LSB;
	uint8_t dummy1831[12];
	uint32_t SWITCH_CORE_DPLL_DB_MSB;
	uint8_t dummy1832[12];
	uint32_t SWITCH_CORE_DPLL_DB_SEL;
	uint8_t dummy1833[12];
	uint32_t SWITCH_CORE_SHD_CTL;
	uint8_t dummy1834[12];
	uint32_t SWITCH_CORE_SHD_LD;
	uint8_t dummy1835[12];
	uint32_t SWITCH_CORE_INT_MASK;
	uint8_t dummy1836[12];
	uint32_t SWITCH_CORE_INT_STAT;
	uint8_t dummy1837[12];
	uint32_t SWITCH_CORE_TX_CTL;
	uint8_t dummy1838[12];
	uint32_t SWITCH_CORE_RX_CTL;
	uint8_t dummy1839[12];
	uint32_t SWITCH_CORE_RX_TX_CTL;
	uint8_t dummy1840[12];
	uint32_t SWITCH_CORE_VLAN_ITPID;
	uint8_t dummy1841[12];
	uint32_t SWITCH_CORE_VLAN_OTPID;
	uint8_t dummy1842[12];
	uint32_t SWITCH_CORE_OTHER_OTPID;
	uint8_t dummy1843[12];
	uint32_t SWITCH_CORE_NSE_DPLL_1;
	uint8_t dummy1844[12];
	uint32_t SWITCH_CORE_NSE_DPLL_2_N_P0;
	uint8_t dummy1845[12];
	uint32_t SWITCH_CORE_NSE_DPLL_2_N_P1;
	uint8_t dummy1846[12];
	uint32_t SWITCH_CORE_NSE_DPLL_2_N_P2;
	uint8_t dummy1847[12];
	uint32_t SWITCH_CORE_NSE_DPLL_3_N_P0;
	uint8_t dummy1848[12];
	uint32_t SWITCH_CORE_NSE_DPLL_3_N_P1;
	uint8_t dummy1849[12];
	uint32_t SWITCH_CORE_NSE_DPLL_4;
	uint8_t dummy1850[12];
	uint32_t SWITCH_CORE_NSE_DPLL_5;
	uint8_t dummy1851[12];
	uint32_t SWITCH_CORE_NSE_DPLL_6;
	uint8_t dummy1852[12];
	uint32_t SWITCH_CORE_NSE_DPLL_7_N_P0;
	uint8_t dummy1853[12];
	uint32_t SWITCH_CORE_NSE_DPLL_7_N_P1;
	uint8_t dummy1854[12];
	uint32_t SWITCH_CORE_NSE_DPLL_7_N_P2;
	uint8_t dummy1855[12];
	uint32_t SWITCH_CORE_NSE_DPLL_7_N_P3;
	uint8_t dummy1856[12];
	uint32_t SWITCH_CORE_NSE_NCO_1_N_P0;
	uint8_t dummy1857[12];
	uint32_t SWITCH_CORE_NSE_NCO_1_N_P1;
	uint8_t dummy1858[12];
	uint32_t SWITCH_CORE_NSE_NCO_2_N_P0;
	uint8_t dummy1859[12];
	uint32_t SWITCH_CORE_NSE_NCO_2_N_P1;
	uint8_t dummy1860[12];
	uint32_t SWITCH_CORE_NSE_NCO_2_N_P2;
	uint8_t dummy1861[12];
	uint32_t SWITCH_CORE_NSE_NCO_3_0;
	uint8_t dummy1862[12];
	uint32_t SWITCH_CORE_NSE_NCO_3_1;
	uint8_t dummy1863[12];
	uint32_t SWITCH_CORE_NSE_NCO_3_2;
	uint8_t dummy1864[12];
	uint32_t SWITCH_CORE_NSE_NCO_4;
	uint8_t dummy1865[12];
	uint32_t SWITCH_CORE_NSE_NCO_5_0;
	uint8_t dummy1866[12];
	uint32_t SWITCH_CORE_NSE_NCO_5_1;
	uint8_t dummy1867[12];
	uint32_t SWITCH_CORE_NSE_NCO_5_2;
	uint8_t dummy1868[12];
	uint32_t SWITCH_CORE_NSE_NCO_6;
	uint8_t dummy1869[12];
	uint32_t SWITCH_CORE_NSE_NCO_7_0;
	uint8_t dummy1870[12];
	uint32_t SWITCH_CORE_NSE_NCO_7_1;
	uint8_t dummy1871[12];
	uint32_t SWITCH_CORE_TX_COUNTER;
	uint8_t dummy1872[12];
	uint32_t SWITCH_CORE_RX_COUNTER;
	uint8_t dummy1873[12];
	uint32_t SWITCH_CORE_RX_TX_1588_COUNTER;
	uint8_t dummy1874[12];
	uint32_t SWITCH_CORE_TS_READ_START_END;
	uint8_t dummy1875[12];
	uint32_t SWITCH_CORE_HEARTBEAT_0;
	uint8_t dummy1876[12];
	uint32_t SWITCH_CORE_HEARTBEAT_1;
	uint8_t dummy1877[140];
	uint32_t SWITCH_CORE_HEARTBEAT_2;
	uint8_t dummy1878[12];
	uint32_t SWITCH_CORE_TIME_STAMP_N_P0;
	uint8_t dummy1879[12];
	uint32_t SWITCH_CORE_TIME_STAMP_N_P1;
	uint8_t dummy1880[12];
	uint32_t SWITCH_CORE_TIME_STAMP_N_P2;
	uint8_t dummy1881[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_N_P0;
	uint8_t dummy1882[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_N_P1;
	uint8_t dummy1883[12];
	uint32_t SWITCH_CORE_CNTR_DBG;
	uint8_t dummy1884[12];
	uint32_t SWITCH_CORE_MPLS_SPARE1;
	uint8_t dummy1885[12];
	uint32_t SWITCH_CORE_MPLS_SPARE2;
	uint8_t dummy1886[12];
	uint32_t SWITCH_CORE_MPLS_SPARE3;
	uint8_t dummy1887[12];
	uint32_t SWITCH_CORE_MPLS_SPARE4;
	uint8_t dummy1888[12];
	uint32_t SWITCH_CORE_MPLS_SPARE5;
	uint8_t dummy1889[12];
	uint32_t SWITCH_CORE_MPLS_SPARE6;
	uint8_t dummy1890[12];
	uint32_t SWITCH_CORE_MPLS_TX_CNTL;
	uint8_t dummy1891[12];
	uint32_t SWITCH_CORE_MPLS_RX_CNTL;
	uint8_t dummy1892[12];
	uint32_t SWITCH_CORE_MPLS_LABEL1_MASK_LSB;
	uint8_t dummy1893[12];
	uint32_t SWITCH_CORE_MPLS_LABEL1_MASK_MSB;
	uint8_t dummy1894[12];
	uint32_t SWITCH_CORE_MPLS_LABEL1_VALUE_LSB;
	uint8_t dummy1895[12];
	uint32_t SWITCH_CORE_MPLS_LABEL1_VALUE_MSB;
	uint8_t dummy1896[12];
	uint32_t SWITCH_CORE_MPLS_LABEL2_MASK_LSB;
	uint8_t dummy1897[12];
	uint32_t SWITCH_CORE_MPLS_LABEL2_MASK_MSB;
	uint8_t dummy1898[12];
	uint32_t SWITCH_CORE_MPLS_LABEL2_VALUE_LSB;
	uint8_t dummy1899[12];
	uint32_t SWITCH_CORE_MPLS_LABEL2_VALUE_MSB;
	uint8_t dummy1900[12];
	uint32_t SWITCH_CORE_MPLS_LABEL3_MASK_LSB;
	uint8_t dummy1901[12];
	uint32_t SWITCH_CORE_MPLS_LABEL3_MASK_MSB;
	uint8_t dummy1902[12];
	uint32_t SWITCH_CORE_MPLS_LABEL3_VALUE_LSB;
	uint8_t dummy1903[12];
	uint32_t SWITCH_CORE_MPLS_LABEL3_VALUE_MSB;
	uint8_t dummy1904[12];
	uint32_t SWITCH_CORE_MPLS_LABEL4_MASK_LSB;
	uint8_t dummy1905[12];
	uint32_t SWITCH_CORE_MPLS_LABEL4_MASK_MSB;
	uint8_t dummy1906[12];
	uint32_t SWITCH_CORE_MPLS_LABEL4_VALUE_LSB;
	uint8_t dummy1907[12];
	uint32_t SWITCH_CORE_MPLS_LABEL4_VALUE_MSB;
	uint8_t dummy1908[12];
	uint32_t SWITCH_CORE_MPLS_LABEL5_MASK_LSB;
	uint8_t dummy1909[12];
	uint32_t SWITCH_CORE_MPLS_LABEL5_MASK_MSB;
	uint8_t dummy1910[12];
	uint32_t SWITCH_CORE_MPLS_LABEL5_VALUE_LSB;
	uint8_t dummy1911[12];
	uint32_t SWITCH_CORE_MPLS_LABEL5_VALUE_MSB;
	uint8_t dummy1912[12];
	uint32_t SWITCH_CORE_MPLS_LABEL6_MASK_LSB;
	uint8_t dummy1913[12];
	uint32_t SWITCH_CORE_MPLS_LABEL6_MASK_MSB;
	uint8_t dummy1914[12];
	uint32_t SWITCH_CORE_MPLS_LABEL6_VALUE_LSB;
	uint8_t dummy1915[12];
	uint32_t SWITCH_CORE_MPLS_LABEL6_VALUE_MSB;
	uint8_t dummy1916[12];
	uint32_t SWITCH_CORE_MPLS_LABEL7_MASK_LSB;
	uint8_t dummy1917[12];
	uint32_t SWITCH_CORE_MPLS_LABEL7_MASK_MSB;
	uint8_t dummy1918[12];
	uint32_t SWITCH_CORE_MPLS_LABEL7_VALUE_LSB;
	uint8_t dummy1919[12];
	uint32_t SWITCH_CORE_MPLS_LABEL7_VALUE_MSB;
	uint8_t dummy1920[12];
	uint32_t SWITCH_CORE_MPLS_LABEL8_MASK_LSB;
	uint8_t dummy1921[12];
	uint32_t SWITCH_CORE_MPLS_LABEL8_MASK_MSB;
	uint8_t dummy1922[12];
	uint32_t SWITCH_CORE_MPLS_LABEL8_VALUE_LSB;
	uint8_t dummy1923[12];
	uint32_t SWITCH_CORE_MPLS_LABEL8_VALUE_MSB;
	uint8_t dummy1924[12];
	uint32_t SWITCH_CORE_MPLS_LABEL9_MASK_LSB;
	uint8_t dummy1925[12];
	uint32_t SWITCH_CORE_MPLS_LABEL9_MASK_MSB;
	uint8_t dummy1926[12];
	uint32_t SWITCH_CORE_MPLS_LABEL9_VALUE_LSB;
	uint8_t dummy1927[12];
	uint32_t SWITCH_CORE_MPLS_LABEL9_VALUE_MSB;
	uint8_t dummy1928[12];
	uint32_t SWITCH_CORE_MPLS_LABEL10_MASK_LSB;
	uint8_t dummy1929[12];
	uint32_t SWITCH_CORE_MPLS_LABEL10_MASK_MSB;
	uint8_t dummy1930[12];
	uint32_t SWITCH_CORE_MPLS_LABEL10_VALUE_LSB;
	uint8_t dummy1931[12];
	uint32_t SWITCH_CORE_MPLS_LABEL10_VALUE_MSB;
	uint8_t dummy1932[12];
	uint32_t SWITCH_CORE_RX_TX_1588_COUNTER1;
	uint8_t dummy1933[12];
	uint32_t SWITCH_CORE_RX_CF_SPEC;
	uint8_t dummy1934[12];
	uint32_t SWITCH_CORE_TX_CF_SPEC;
	uint8_t dummy1935[12];
	uint32_t SWITCH_CORE_MPLS_PACKET_ENABLE;
	uint8_t dummy1936[12];
	uint32_t SWITCH_CORE_TIMECODE_SEL;
	uint8_t dummy1937[12];
	uint32_t SWITCH_CORE_TIME_STAMP_3;
	uint8_t dummy1938[12];
	uint32_t SWITCH_CORE_TIME_STAMP;
	uint8_t dummy1939[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_TX_CONTROL;
	uint8_t dummy1940[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_RX_CONTROL;
	uint8_t dummy1941[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE1;
	uint8_t dummy1942[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE2;
	uint8_t dummy1943[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE3;
	uint8_t dummy1944[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE4;
	uint8_t dummy1945[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE5;
	uint8_t dummy1946[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE6;
	uint8_t dummy1947[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE7;
	uint8_t dummy1948[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE8;
	uint8_t dummy1949[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE9;
	uint8_t dummy1950[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE10;
	uint8_t dummy1951[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE11;
	uint8_t dummy1952[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE12;
	uint8_t dummy1953[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_ETYPE13;
	uint8_t dummy1954[12];
	uint32_t SWITCH_CORE_DELAY_MEASUREMENT_IETF_OFFSET;
	uint8_t dummy1955[12];
	uint32_t SWITCH_CORE_NTP_TIME_STAMP_N_P0;
	uint8_t dummy1956[12];
	uint32_t SWITCH_CORE_NTP_TIME_STAMP_N_P1;
	uint8_t dummy1957[12];
	uint32_t SWITCH_CORE_NTP_TIME_STAMP_N_P2;
	uint8_t dummy1958[12];
	uint32_t SWITCH_CORE_NTP_TIME_STAMP_N_P3;
	uint8_t dummy1959[12];
	uint32_t SWITCH_CORE_NTP_NCO_FREQ_0;
	uint8_t dummy1960[12];
	uint32_t SWITCH_CORE_NTP_NCO_FREQ_1;
	uint8_t dummy1961[12];
	uint32_t SWITCH_CORE_NTP_DOWN_CNTER_0;
	uint8_t dummy1962[12];
	uint32_t SWITCH_CORE_NTP_DOWN_CNTER_1;
	uint8_t dummy1963[12];
	uint32_t SWITCH_CORE_NTP_ERR_LSB;
	uint8_t dummy1964[12];
	uint32_t SWITCH_CORE_NTP_ERR_MSB;
	uint8_t dummy1965[12];
	uint32_t SWITCH_CORE_DM_MAC_L1_0;
	uint8_t dummy1966[12];
	uint32_t SWITCH_CORE_DM_MAC_L1_1;
	uint8_t dummy1967[12];
	uint32_t SWITCH_CORE_DM_MAC_L1_2;
	uint8_t dummy1968[12];
	uint32_t SWITCH_CORE_DM_MAC_L2_0;
	uint8_t dummy1969[12];
	uint32_t SWITCH_CORE_DM_MAC_L2_1;
	uint8_t dummy1970[12];
	uint32_t SWITCH_CORE_DM_MAC_L2_2;
	uint8_t dummy1971[12];
	uint32_t SWITCH_CORE_DM_MAC_L3_0;
	uint8_t dummy1972[12];
	uint32_t SWITCH_CORE_DM_MAC_L3_1;
	uint8_t dummy1973[12];
	uint32_t SWITCH_CORE_DM_MAC_L3_2;
	uint8_t dummy1974[12];
	uint32_t SWITCH_CORE_DM_MAC_CTL_0;
	uint8_t dummy1975[12];
	uint32_t SWITCH_CORE_DM_MAC_CTL_1;
	uint8_t dummy1976[12];
	uint32_t SWITCH_CORE_DM_MAC_CTL_2;
	uint8_t dummy1977[12];
	uint32_t SWITCH_CORE_HEARTBEAT_3;
	uint8_t dummy1978[12];
	uint32_t SWITCH_CORE_HEARTBEAT_4;
	uint8_t dummy1979[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P0;
	uint8_t dummy1980[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P1;
	uint8_t dummy1981[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P2;
	uint8_t dummy1982[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P3;
	uint8_t dummy1983[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P4;
	uint8_t dummy1984[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P5;
	uint8_t dummy1985[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P6;
	uint8_t dummy1986[12];
	uint32_t SWITCH_CORE_INBAND_CNTL_N_P7;
	uint8_t dummy1987[12];
	uint32_t SWITCH_CORE_MEM_COUNTER;
	uint8_t dummy1988[12];
	uint32_t SWITCH_CORE_TIMESTAMP_DELTA;
	uint8_t dummy1989[12];
	uint32_t SWITCH_CORE_SOP_SEL;
	uint8_t dummy1990[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_3;
	uint8_t dummy1991[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_4;
	uint8_t dummy1992[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_5;
	uint8_t dummy1993[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_6;
	uint8_t dummy1994[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_7;
	uint8_t dummy1995[12];
	uint32_t SWITCH_CORE_TIME_STAMP_INFO_8;
	uint8_t dummy1996[12];
	uint32_t SWITCH_CORE_INBAND_SPARE1;
	uint8_t dummy1997[140];
	uint32_t SWITCH_CORE_RED_CONTROL;
	uint8_t dummy1998[12];
	uint32_t SWITCH_CORE_TC2RED_PROFILE_TABLE;
	uint8_t dummy1999[12];
	uint32_t SWITCH_CORE_RED_EGRESS_BYPASS;
	uint8_t dummy2000[12];
	uint32_t SWITCH_CORE_RED_AQD_CONTROL;
	uint8_t dummy2001[12];
	uint32_t SWITCH_CORE_RED_EXPONENT;
	uint8_t dummy2002[12];
	uint32_t SWITCH_CORE_RED_DROP_ADD_TO_MIB;
	uint8_t dummy2003[44];
	uint32_t SWITCH_CORE_RED_PROFILE_DEFAULT;
	uint8_t dummy2004[28];
	uint32_t SWITCH_CORE_WRED_REG_SPARE0;
	uint8_t dummy2005[28];
	uint32_t SWITCH_CORE_WRED_REG_SPARE1;
	uint8_t dummy2006[60];
	uint32_t SWITCH_CORE_RED_PROFILE0;
	uint8_t dummy2007[28];
	uint32_t SWITCH_CORE_RED_PROFILE1;
	uint8_t dummy2008[28];
	uint32_t SWITCH_CORE_RED_PROFILE2;
	uint8_t dummy2009[28];
	uint32_t SWITCH_CORE_RED_PROFILE3;
	uint8_t dummy2010[28];
	uint32_t SWITCH_CORE_RED_PROFILE4;
	uint8_t dummy2011[28];
	uint32_t SWITCH_CORE_RED_PROFILE5;
	uint8_t dummy2012[28];
	uint32_t SWITCH_CORE_RED_PROFILE6;
	uint8_t dummy2013[28];
	uint32_t SWITCH_CORE_RED_PROFILE7;
	uint8_t dummy2014[28];
	uint32_t SWITCH_CORE_RED_PROFILE8;
	uint8_t dummy2015[28];
	uint32_t SWITCH_CORE_RED_PROFILE9;
	uint8_t dummy2016[28];
	uint32_t SWITCH_CORE_RED_PROFILE10;
	uint8_t dummy2017[28];
	uint32_t SWITCH_CORE_RED_PROFILE11;
	uint8_t dummy2018[28];
	uint32_t SWITCH_CORE_RED_PROFILE12;
	uint8_t dummy2019[28];
	uint32_t SWITCH_CORE_RED_PROFILE13;
	uint8_t dummy2020[28];
	uint32_t SWITCH_CORE_RED_PROFILE14;
	uint8_t dummy2021[28];
	uint32_t SWITCH_CORE_RED_PROFILE15;
	uint8_t dummy2022[124];
	uint32_t SWITCH_CORE_RED_DROP_CNTR_RST;
	uint8_t dummy2023[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P0;
	uint8_t dummy2024[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P1;
	uint8_t dummy2025[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P2;
	uint8_t dummy2026[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P3;
	uint8_t dummy2027[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P4;
	uint8_t dummy2028[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P5;
	uint8_t dummy2029[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P6;
	uint8_t dummy2030[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_P7;
	uint8_t dummy2031[28];
	uint32_t SWITCH_CORE_RED_PKT_DROP_CNTR_IMP;
	uint8_t dummy2032[124];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P0;
	uint8_t dummy2033[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P1;
	uint8_t dummy2034[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P2;
	uint8_t dummy2035[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P3;
	uint8_t dummy2036[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P4;
	uint8_t dummy2037[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P5;
	uint8_t dummy2038[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P6;
	uint8_t dummy2039[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_P7;
	uint8_t dummy2040[60];
	uint32_t SWITCH_CORE_RED_BYTE_DROP_CNTR_IMP;
	uint8_t dummy2041[20732];
	uint32_t SWITCH_CORE_CFP_ACC;
	uint8_t dummy2042[28];
	uint32_t SWITCH_CORE_RATE_METER_GLOBAL_CTL;
	uint8_t dummy2043[92];
	uint32_t SWITCH_CORE_CFP_DATA0;
	uint8_t dummy2044[28];
	uint32_t SWITCH_CORE_CFP_DATA1;
	uint8_t dummy2045[28];
	uint32_t SWITCH_CORE_CFP_DATA2;
	uint8_t dummy2046[28];
	uint32_t SWITCH_CORE_CFP_DATA3;
	uint8_t dummy2047[28];
	uint32_t SWITCH_CORE_CFP_DATA4;
	uint8_t dummy2048[28];
	uint32_t SWITCH_CORE_CFP_DATA5;
	uint8_t dummy2049[28];
	uint32_t SWITCH_CORE_CFP_DATA6;
	uint8_t dummy2050[28];
	uint32_t SWITCH_CORE_CFP_DATA7;
	uint8_t dummy2051[28];
	uint32_t SWITCH_CORE_CFP_MASK0;
	uint8_t dummy2052[28];
	uint32_t SWITCH_CORE_CFP_MASK1;
	uint8_t dummy2053[28];
	uint32_t SWITCH_CORE_CFP_MASK2;
	uint8_t dummy2054[28];
	uint32_t SWITCH_CORE_CFP_MASK3;
	uint8_t dummy2055[28];
	uint32_t SWITCH_CORE_CFP_MASK4;
	uint8_t dummy2056[28];
	uint32_t SWITCH_CORE_CFP_MASK5;
	uint8_t dummy2057[28];
	uint32_t SWITCH_CORE_CFP_MASK6;
	uint8_t dummy2058[28];
	uint32_t SWITCH_CORE_CFP_MASK7;
	uint8_t dummy2059[28];
	uint32_t SWITCH_CORE_ACT_POL_DATA0;
	uint8_t dummy2060[28];
	uint32_t SWITCH_CORE_ACT_POL_DATA1;
	uint8_t dummy2061[28];
	uint32_t SWITCH_CORE_ACT_POL_DATA2;
	uint8_t dummy2062[60];
	uint32_t SWITCH_CORE_RATE_METER0;
	uint8_t dummy2063[28];
	uint32_t SWITCH_CORE_RATE_METER1;
	uint8_t dummy2064[28];
	uint32_t SWITCH_CORE_RATE_METER2;
	uint8_t dummy2065[28];
	uint32_t SWITCH_CORE_RATE_METER3;
	uint8_t dummy2066[28];
	uint32_t SWITCH_CORE_RATE_METER4;
	uint8_t dummy2067[28];
	uint32_t SWITCH_CORE_RATE_METER5;
	uint8_t dummy2068[28];
	uint32_t SWITCH_CORE_RATE_METER6;
	uint8_t dummy2069[28];
	uint32_t SWITCH_CORE_TC2COLOR;
	uint8_t dummy2070[28];
	uint32_t SWITCH_CORE_STAT_GREEN_CNTR;
	uint8_t dummy2071[28];
	uint32_t SWITCH_CORE_STAT_YELLOW_CNTR;
	uint8_t dummy2072[28];
	uint32_t SWITCH_CORE_STAT_RED_CNTR;
	uint8_t dummy2073[188];
	uint32_t SWITCH_CORE_TCAM_BIST_CONTROL;
	uint8_t dummy2074[28];
	uint32_t SWITCH_CORE_TCAM_BIST_STATUS;
	uint8_t dummy2075[28];
	uint32_t SWITCH_CORE_TCAM_TEST_COMPARE_STATUS;
	uint8_t dummy2076[60];
	uint32_t SWITCH_CORE_CFP_REG_SPARE0;
	uint8_t dummy2077[28];
	uint32_t SWITCH_CORE_CFP_REG_SPARE1;
	uint8_t dummy2078[604];
	uint32_t SWITCH_CORE_CFP_CTL_REG;
	uint8_t dummy2079[124];
	uint64_t SWITCH_CORE_UDF_0_A_0_8_0;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_1;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_2;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_3;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_4;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_5;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_6;
	uint64_t SWITCH_CORE_UDF_0_A_0_8_7;
	uint32_t SWITCH_CORE_UDF_0_A_0_8_8;
	uint8_t dummy2080[60];
	uint64_t SWITCH_CORE_UDF_1_A_0_8_0;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_1;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_2;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_3;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_4;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_5;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_6;
	uint64_t SWITCH_CORE_UDF_1_A_0_8_7;
	uint32_t SWITCH_CORE_UDF_1_A_0_8_8;
	uint8_t dummy2081[60];
	uint64_t SWITCH_CORE_UDF_2_A_0_8_0;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_1;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_2;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_3;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_4;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_5;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_6;
	uint64_t SWITCH_CORE_UDF_2_A_0_8_7;
	uint32_t SWITCH_CORE_UDF_2_A_0_8_8;
	uint8_t dummy2082[60];
	uint64_t SWITCH_CORE_UDF_0_B_0_8_0;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_1;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_2;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_3;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_4;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_5;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_6;
	uint64_t SWITCH_CORE_UDF_0_B_0_8_7;
	uint32_t SWITCH_CORE_UDF_0_B_0_8_8;
	uint8_t dummy2083[60];
	uint64_t SWITCH_CORE_UDF_1_B_0_8_0;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_1;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_2;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_3;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_4;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_5;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_6;
	uint64_t SWITCH_CORE_UDF_1_B_0_8_7;
	uint32_t SWITCH_CORE_UDF_1_B_0_8_8;
	uint8_t dummy2084[60];
	uint64_t SWITCH_CORE_UDF_2_B_0_8_0;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_1;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_2;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_3;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_4;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_5;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_6;
	uint64_t SWITCH_CORE_UDF_2_B_0_8_7;
	uint32_t SWITCH_CORE_UDF_2_B_0_8_8;
	uint8_t dummy2085[60];
	uint64_t SWITCH_CORE_UDF_0_C_0_8_0;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_1;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_2;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_3;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_4;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_5;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_6;
	uint64_t SWITCH_CORE_UDF_0_C_0_8_7;
	uint32_t SWITCH_CORE_UDF_0_C_0_8_8;
	uint8_t dummy2086[60];
	uint64_t SWITCH_CORE_UDF_1_C_0_8_0;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_1;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_2;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_3;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_4;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_5;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_6;
	uint64_t SWITCH_CORE_UDF_1_C_0_8_7;
	uint32_t SWITCH_CORE_UDF_1_C_0_8_8;
	uint8_t dummy2087[60];
	uint64_t SWITCH_CORE_UDF_2_C_0_8_0;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_1;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_2;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_3;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_4;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_5;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_6;
	uint64_t SWITCH_CORE_UDF_2_C_0_8_7;
	uint32_t SWITCH_CORE_UDF_2_C_0_8_8;
	uint8_t dummy2088[60];
	uint64_t SWITCH_CORE_UDF_0_D_0_11_0;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_1;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_2;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_3;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_4;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_5;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_6;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_7;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_8;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_9;
	uint64_t SWITCH_CORE_UDF_0_D_0_11_10;
	uint32_t SWITCH_CORE_UDF_0_D_0_11_11;
	uint8_t dummy2089[29348];
	uint32_t SWITCH_CORE_ARL_TCAM_ACC;
	uint8_t dummy2090[28];
	uint32_t SWITCH_CORE_ARL_TCAM_DATA_P0;
	uint8_t dummy2091[28];
	uint32_t SWITCH_CORE_ARL_TCAM_DATA_P1;
	uint8_t dummy2092[92];
	uint32_t SWITCH_CORE_ARL_SMEM_DATA;
	uint8_t dummy2093[92];
	uint32_t SWITCH_CORE_ARL_TCAM_BIST_CTRL;
	uint8_t dummy2094[28];
	uint32_t SWITCH_CORE_ARL_TCAM_BIST_STS;
	uint8_t dummy2095[100060];
	uint32_t SWITCH_CORE_PLL_NDIV_INT;
	uint8_t dummy2096[12];
	uint32_t SWITCH_CORE_PLL_NDIV_FRAC;
	uint8_t dummy2097[28];
	uint32_t SWITCH_CORE_PLL_SDMOD_CTRL;
	uint8_t dummy2098[12];
	uint32_t SWITCH_CORE_PLL_MOD_CTRL_0;
	uint8_t dummy2099[28];
	uint32_t SWITCH_CORE_PLL_MOD_CTRL_1;
	uint8_t dummy2100[28];
	uint32_t SWITCH_CORE_PLL_MOD_CTRL_2;
	uint8_t dummy2101[28];
	uint32_t SWITCH_CORE_PLL_MISC_CTRL;
	uint8_t dummy2102[12];
	uint32_t SWITCH_CORE_PLL_DELOCK_MIB;
	uint8_t dummy2103[28];
	uint32_t SWITCH_CORE_PLL_SS_CTL;
	uint8_t dummy2104[44];
	uint32_t SWITCH_CORE_PLL_CTRL;
	uint8_t dummy2105[12];
	uint32_t SWITCH_CORE_PLL_STS;
	uint8_t dummy2106[60];
	uint32_t SWITCH_CORE_PLL_FREQ_SEL;
	uint8_t dummy2107[44];
	uint32_t SWITCH_CORE_PLL_TEST_CTRL_I;
	uint8_t dummy2108[12];
	uint32_t SWITCH_CORE_PLL_TEST_CTRL_II;
	uint8_t dummy2109[108];
	uint32_t SWITCH_CORE_GREEN_MODE_DATA;
	uint8_t dummy2110[60];
	uint32_t SWITCH_CORE_GREEN_MODE_SELECT;
	uint8_t dummy2111[444];
	uint32_t SWITCH_CORE_TOP_LOW_POWER_CTRL;
	uint8_t dummy2112[12];
	uint32_t SWITCH_CORE_TOP_IDDQ_CTL;
	uint8_t dummy2113[108];
	uint32_t SWITCH_CORE_IP_PLL_BYPASS;
	uint8_t dummy2114[636];
	uint32_t SWITCH_CORE_TOP_MODULE_CTL_SPARE0;
	uint8_t dummy2115[28];
	uint32_t SWITCH_CORE_TOP_MODULE_CTL_SPARE1;
	uint8_t dummy2116[220];
	uint32_t SWITCH_CORE_EGPHY_CTRL;
	uint8_t dummy2117[12];
	uint32_t SWITCH_CORE_EGPHY_PWRMGNT;
	uint8_t dummy2118[12];
	uint32_t SWITCH_CORE_EGPHY_PWR_DOWN;
	uint8_t dummy2119[44];
	uint32_t SWITCH_CORE_EGPHY_STRAP;
	uint8_t dummy2120[12];
	uint32_t SWITCH_CORE_EGPHY_STS;
	uint8_t dummy2121[12];
	uint32_t SWITCH_CORE_EGPHY_INT_STS;
	uint8_t dummy2122[12];
	uint32_t SWITCH_CORE_EGPHY_MODE_STS;
	uint8_t dummy2123[12];
	uint32_t SWITCH_CORE_EGPHY_LPI_STS;
	uint8_t dummy2124[12];
	uint32_t SWITCH_CORE_EGPHY_ENG_DET_STS;
	uint8_t dummy2125[12];
	uint32_t SWITCH_CORE_EGPHY_ENG_DET_STS_CHG;
	uint8_t dummy2126[12];
	uint32_t SWITCH_CORE_EGPHY_RESET_STATUS;
	uint8_t dummy2127[1596];
	uint32_t SWITCH_CORE_EGPHY_CTL_SPARE0;
	uint8_t dummy2128[28];
	uint32_t SWITCH_CORE_EGPHY_CTL_SPARE1;
	uint8_t dummy2129[220];
	uint32_t SWITCH_CORE_BRPHY_CTRL;
	uint8_t dummy2130[12];
	uint32_t SWITCH_CORE_BRPHY_PWRMGNT;
	uint8_t dummy2131[12];
	uint32_t SWITCH_CORE_BRPHY_PWR_DOWN;
	uint8_t dummy2132[28];
	uint32_t SWITCH_CORE_BRPHY_PLL_CTRL;
	uint8_t dummy2133[28];
	uint32_t SWITCH_CORE_BRPHY_STS;
	uint8_t dummy2134[12];
	uint32_t SWITCH_CORE_BRPHY_INT_STS;
	uint8_t dummy2135[44];
	uint32_t SWITCH_CORE_BRPHY_ENG_DET_STS;
	uint8_t dummy2136[12];
	uint32_t SWITCH_CORE_BRPHY_ENG_DET_STS_CHG;
	uint8_t dummy2137[12];
	uint32_t SWITCH_CORE_BRPHY_RESET_STATUS;
	uint8_t dummy2138[1596];
	uint32_t SWITCH_CORE_BRPHY_CTL_SPARE0;
	uint8_t dummy2139[28];
	uint32_t SWITCH_CORE_BRPHY_CTL_SPARE1;
	uint8_t dummy2140[220];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P0;
	uint8_t dummy2141[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P1;
	uint8_t dummy2142[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P2;
	uint8_t dummy2143[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P3;
	uint8_t dummy2144[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P4;
	uint8_t dummy2145[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P5;
	uint8_t dummy2146[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_P6;
	uint8_t dummy2147[12];
	uint32_t SWITCH_CORE_STS_OVERRIDE_GMII_P7;
	uint8_t dummy2148[12];
	uint32_t imp_port_state;
#define ETHSW_IPS_USE_MII_HW_STS                  0x00
#define ETHSW_IPS_USE_REG_CONTENTS                0x80
#define ETHSW_IPS_GMII_SPEED_UP_NORMAL            0x00
#define ETHSW_IPS_GMII_SPEED_UP_2G                0x40
#define ETHSW_IPS_TXFLOW_NOT_PAUSE_CAPABLE        0x00
#define ETHSW_IPS_TXFLOW_PAUSE_CAPABLE            0x20
#define ETHSW_IPS_RXFLOW_NOT_PAUSE_CAPABLE        0x00
#define ETHSW_IPS_RXFLOW_PAUSE_CAPABLE            0x10
#define ETHSW_IPS_SW_PORT_SPEED_1000M_2000M       0x08
#define ETHSW_IPS_DUPLEX_MODE                     0x02
#define ETHSW_IPS_LINK_FAIL                       0x00
#define ETHSW_IPS_LINK_PASS                       0x01
	uint8_t dummy2149[60];
	uint32_t SWITCH_CORE_PAUSE_CAP;
	uint8_t dummy2150[124];
	uint32_t SWITCH_CORE_PORT4_RGMII_CTL_GP;
	uint8_t dummy2151[12];
	uint32_t SWITCH_CORE_PORT5_RGMII_CTL_GP;
	uint8_t dummy2152[12];
	uint32_t SWITCH_CORE_PORT6_RGMII_CTL_GP;
	uint8_t dummy2153[28];
	uint32_t SWITCH_CORE_RGMII_CTL_GP_IMP;
	uint8_t dummy2154[188];
	uint32_t SWITCH_CORE_P4_RGMII_TIME_DLY_GP;
	uint8_t dummy2155[12];
	uint32_t SWITCH_CORE_P5_RGMII_TIME_DLY_GP;
	uint8_t dummy2156[12];
	uint32_t SWITCH_CORE_P6_RGMII_TIME_DLY_GP;
	uint8_t dummy2157[28];
	uint32_t SWITCH_CORE_RGMII_TIME_DLY_GP_IMP;
	uint8_t dummy2158[124];
	uint32_t SWITCH_CORE_RM_PINS_DEBUG;
	uint8_t dummy2159[12];
	uint32_t SWITCH_CORE_MII_IDDQ_CTRL;
	uint8_t dummy2160[12];
	uint32_t SWITCH_CORE_MII_LOW_POWER_CTRL;
	uint8_t dummy2161[12];
	uint32_t SWITCH_CORE_LED_OPTIONS;
	uint8_t dummy2162[972];
	uint32_t SWITCH_CORE_PORT_INFO_SPARE0;
	uint8_t dummy2163[28];
	uint32_t SWITCH_CORE_PORT_INFO_SPARE1;
	uint8_t dummy2164[220];
	uint32_t SWITCH_CORE_IO_SR_CTL;
	uint8_t dummy2165[28];
	uint32_t SWITCH_CORE_IO_DS_SEL0;
	uint8_t dummy2166[60];
	uint32_t SWITCH_CORE_IO_DS_SEL2;
	uint8_t dummy2167[28];
	uint32_t SWITCH_CORE_GMII_IO_SR_CTL;
	uint8_t dummy2168[28];
	uint32_t SWITCH_CORE_GMII_IO_DS_SEL0;
	uint8_t dummy2169[28];
	uint32_t SWITCH_CORE_GMII_IO_DS_SEL1;
	uint8_t dummy2170[28];
	uint32_t SWITCH_CORE_GMII_VOL_SEL;
	uint8_t dummy2171[12];
	uint32_t SWITCH_CORE_PINS_DEBUG_IMP;
	uint8_t dummy2172[28];
	uint32_t SWITCH_CORE_BONDING_PAD_STATUS;
	uint8_t dummy2173[12];
	uint32_t SWITCH_CORE_STRAP_PIN_STATUS;
	uint8_t dummy2174[28];
	uint32_t SWITCH_CORE_DIRECT_INPUT_CTRL_VALUE;
	uint8_t dummy2175[60];
	uint32_t SWITCH_CORE_EMB_CPU_STATUS;
	uint8_t dummy2176[1404];
	uint32_t SWITCH_CORE_CHIP_CTL_SPARE0;
	uint8_t dummy2177[28];
	uint32_t SWITCH_CORE_CHIP_CTL_SPARE1;

} EthernetSwitchCore;

#define PBMAP_MIPS 0x100

#endif /* _6756_ETHSW_H */
