/*
   Copyright (c) 2015 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/
/** @file merlin16_shortfin_field_access.h
 * Registers and field access
 */

#ifndef MERLIN16_SHORTFIN_API_FIELD_ACCESS_H
#define MERLIN16_SHORTFIN_API_FIELD_ACCESS_H

#include "merlin16_shortfin_ipconfig.h"
#include "common/srds_api_err_code.h"
#include "merlin16_shortfin_dependencies.h"

/* Extract a bitfield from a register value. */
#define extract_field(reg_value,msb,lsb) (((uint16_t)(reg_value) & ((1 << ((msb) + 1)) - 1)) >> (lsb))

/** Read a register field as an unsigned value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts to move field to bit0        [shift_right = (15 - msb + shift_right)]
 * @param *val_p 16-bit unsigned value read from the field
 * @return Error Code generated by API (returns ERR_CODE_NONE if no errors)
 */
err_code_t _merlin16_shortfin_pmd_rdt_field(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, uint16_t *val_p);

/** Read a register field as an signed value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts to move field to bit0        [shift_right = (15 - msb + lsb)]
 * @param *val_p 16-bit signed value read from the field
 * @return Error Code generated by API (returns ERR_CODE_NONE if no errors)
 */
err_code_t _merlin16_shortfin_pmd_rdt_field_signed(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, int16_t *val_p);


/*-------------------------------*/
/* Byte Write and Read Functions */
/*-------------------------------*/

/** Write a contiguous bit field in a register.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param mask 16-bit mask indicating the position of the field with bits of 1s
 * @param lsb  LSB of the field, the width of the field is implied by mask.
 * @param val  8bit value to write into the field.
 * @return Error Code generated by API (returns ERR_CODE_NONE if no errors)
 */
err_code_t _merlin16_shortfin_pmd_mwr_reg_byte(srds_access_t *sa__, uint16_t addr, uint16_t mask, uint8_t lsb, uint8_t val);

/** Read a register field as an 8-bit unsigned value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts to move field to bit0        [shift_right = (15 - msb + lsb)]
 * @param *val_p 8-bit unsigned value read from the field
 * @return Error Code generated by API (returns ERR_CODE_NONE if no errors)
 */
err_code_t _merlin16_shortfin_pmd_rdt_field_byte(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, uint8_t *val_p);

/** Read a register field as an 8-bit signed value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts to move field to bit0        [shift_right = (15 - msb + lsb)]
 * @param *val_p 8-bit signed value read from the field
 * @return Error Code generated by API (returns ERR_CODE_NONE if no errors)
 */
err_code_t _merlin16_shortfin_pmd_rdt_field_signed_byte(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, int8_t *val_p);


/*****************************************************************************
   The following functions are being retained for legacy purposes and
   for Serdes DVT, characterization backwards compatability
******************************************************************************/

/** Read a register.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param err_code_p error code returned through pointer
 * @return 16-bit value read from the register
 */
uint16_t _merlin16_shortfin_pmd_rde_reg(srds_access_t *sa__, uint16_t addr, err_code_t *err_code_p);

/** Read a register field as an unsigned value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts to move field to bit0        [shift_right = (15 - msb + lsb)]
 * @param err_code_p error code returned through pointer
 * @return 16-bit unsigned value read from the field
 */
uint16_t _merlin16_shortfin_pmd_rde_field(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, err_code_t *err_code_p);

/** Read a register field as a signed value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts with sign extension          [shift_right = (15 - msb + lsb)]
 * @param err_code_p error code returned through pointer
 * @return 16-bit signed value read from the field
 */
int16_t  _merlin16_shortfin_pmd_rde_field_signed(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, err_code_t *err_code_p);

/** Read a bit field as an unsigned value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign_bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts to move field to bit0        [shift_right = (15 - msb + lsb)]
 * @param err_code_p error code returned through pointer
 * @return 8-bit unsigned value read from the field
 */
uint8_t _merlin16_shortfin_pmd_rde_field_byte(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, err_code_t *err_code_p);

/** Read a bit field as a signed value.
 * @param sa__ is an opaque state vector passed through to device access functions.
 * @param addr 16-bit register address.
 * @param shift_left  Number of bits sign bit should be moved to the left [shift_left  = (15 - msb)]
 * @param shift_right Number of right shifts with sign extension          [shift_right = (15 - msb + lsb)]
 * @param err_code_p error code returned through pointer
 * @return 8-bit signed value read from the field
 */
int8_t  _merlin16_shortfin_pmd_rde_field_signed_byte(srds_access_t *sa__, uint16_t addr, uint8_t shift_left, uint8_t shift_right, err_code_t *err_code_p);

#endif /* FIELD_ACCESS_H_ */
