#!/bin/sh

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# sigilgen build.xml ..

function a2s() {
  find ${1:?} -name '*.java' -o -name '*.spring' -o -name '*.sca' |
  perl -e '
    use strict;
    use FileHandle;

    my %imports;
    my %exports;

    while (<>) {
	chomp($_);
	my $path = $_;
	my $fh = new FileHandle($path);

	my $testFile = ($path =~ m!Test[^/]+$!);

	while (my $line = <$fh>) {
	  chomp($line);

	  if ($line =~ /^\s*package\s+([\w.]+)\s*;\s*$/) {
	    my $exp = $1;
	    if (!($testFile && ($exp !~ /^test[.]/))) {
	      $exports{$exp} = 1;
	    }
	  } 
	  elsif ($line =~ /^\s*import\s+([a-z_0-9.]+)([.][A-Z][^.]+)+;\s*$/) {
	    my $imp = $1;
	    $imports{$imp} = 1 unless ($imp =~ /^java[.]/);
	  }
	  elsif (($line !~ m!^\s*(//|\*|\@)!) &&
		($line =~ /(\W)((([a-z0-9]{2,})[.]){3,})[A-Z]/)) {
	    my $quot = $1;
	    my $imp = $2;
	    $imp =~ s/.$//;

	    if (($imp !~ /^java[.]/) &&
	    	($quot ne "\"" || ($path !~ /[.]java$/))) {
	      $imports{$imp} = 1;
	    }
	  }
	}
	$fh->close();
    }

    if (keys(%exports) == () && keys(%imports) == ()) {
      exit(1);
    }

    print "-exports: \\\n";
    foreach my $key (sort keys(%exports)) {
	print "\t$key, \\\n";
    }
    print "\n";

    print "-imports: \\\n";
    foreach my $key (sort keys(%imports)) {
	print "\t$key, \\\n";
    }
    print "\n";

    exit(0);
  '
  return $?
}

for file in $*; do
  echo "converting $file"
  name=$(perl -ne 'print $1 if (/project name="([^"]*)"/);' $file)
  dir=$(dirname $file)

  if [ -f $dir/sigil.properties ]; then
    rm -f $dir/sigil.properties.old
    mv $dir/sigil.properties $dir/sigil.properties.old
  fi

  (
    echo "# generated by sigilgen on $(date)"
    echo
    echo "-bundles: $name"
    echo
    a2s $dir && mv $dir/sigil.properties-part $dir/sigil.properties
  ) > $dir/sigil.properties-part

  rm -f $dir/sigil.properties-part

done
