/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.felix.sigil.utils.properties;


import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;


public class ResourceTypePropertyTester extends PropertyTester
{

    public boolean test( Object receiver, String property, Object[] args, Object expectedValue )
    {
        if ( !( receiver instanceof IResource ) )
        {
            return false;
        }

        boolean result = false;

        IResource resource = ( IResource ) receiver;
        if ( "isResourceOfType".equals( property ) )
        {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor( resource.getName() );

            for ( IContentType type : types )
            {
                if ( type.getId().equals( expectedValue ) )
                {
                    result = true;
                    break;
                }
            }
        }

        return result;
    }

}
