package org.apache.felix.ipojo.test.scenarios.manipulation;

import java.util.Map;
import java.util.Properties;

import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.test.scenarios.component.InnerClasses;
import org.apache.felix.ipojo.test.scenarios.component.InnerClasses.PublicNested;
import org.apache.felix.ipojo.test.scenarios.manipulation.service.CheckService;
import org.osgi.framework.ServiceReference;

public class NestedClassesTests extends OSGiTestCase {
    
    private ComponentInstance instance;
    private CheckService service; 
    
    IPOJOHelper helper;
    
    
    public void setUp() {
        helper = new IPOJOHelper(this);
        Properties map = new Properties();
        map.put("publicObject", "publicObject");
        map.put("publicInt", new Integer(0));
        map.put("packageObject", "packageObject");
        map.put("packageInt", new Integer(1));
        map.put("protectedObject", "protectedObject");
        map.put("protectedInt", new Integer(2));
        map.put("privateObject", "privateObject");
        map.put("privateInt", new Integer(3));
        map.put("nonObject", "nonObject");
        map.put("nonInt", new Integer(4));
        instance = helper.createComponentInstance("inners", map);
        
        ServiceReference ref = helper.getServiceReferenceByName(CheckService.class.getName(), instance.getInstanceName());
        assertNotNull("Check service availability", ref);
        service = (CheckService) getServiceObject(ref);
    }
    
    public void tearDown() {
        helper.dispose();
        service = null;
    }
    
    public void testPrivateInnerClass() {
        Map data = (Map) service.getProps().get("privateInner");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
    
    }
    
    public void testProtectedInnerClass() {
        Map data = (Map) service.getProps().get("protectedInner");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
    
    }
    
    public void testPackageInnerClass() {
        Map data = (Map) service.getProps().get("packageInner");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
    
    }
    
    public void testPublicInnerClass() {
        Map data = (Map) service.getProps().get("publicInner");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
    
    }
    
    public void testConstructorInnerClass() {
        Map data = (Map) service.getProps().get("constructorInner");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
    
    }
    
    public void testStaticInnerClass() {
        Map data = (Map) service.getProps().get("staticInner");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check static", new Boolean(true), data.get("static"));
        assertEquals("Check static int", new Integer(6), data.get("staticint"));
    
    }
    
    public void testAnonymousInnerClass() {
        Map data = (Map) service.getProps().get("anonymous");
        assertNotNull("Check data existency", data);
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
    
    }
    
    public void testInnerAccess() {
        Map map = (Map) service.getProps();
        assertNotNull("Check map existency", map);
        
        InnerClasses.PublicNested p = (PublicNested) map.get("public");
        Map data = p.doSomething();
        
        assertEquals("Check public object", "publicObject", data.get("publicObject"));
        assertEquals("Check public int", new Integer(0), data.get("publicInt"));
        assertEquals("Check protected object", "protectedObject", data.get("protectedObject"));
        assertEquals("Check protected int", new Integer(2), data.get("protectedInt"));
        assertEquals("Check package object", "packageObject", data.get("packageObject"));
        assertEquals("Check package int", new Integer(1), data.get("packageInt"));
        assertEquals("Check private object", "privateObject", data.get("privateObject"));
        assertEquals("Check private int", new Integer(3), data.get("privateInt"));
        assertEquals("Check non-managed object", "not-managed", data.get("nonObject"));
        assertEquals("Check non-managed int", new Integer(5), data.get("nonInt"));
        
    }

}
