/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.felix.dm.test.bundle.annotation.multiple;

import org.apache.felix.dm.annotation.api.Composition;
import org.apache.felix.dm.annotation.api.Service;
import org.apache.felix.dm.annotation.api.Start;
import org.apache.felix.dm.annotation.api.Stop;
import org.apache.felix.dm.annotation.api.ServiceDependency;
import org.apache.felix.dm.test.bundle.annotation.sequencer.Sequencer;

@Service(provide = { ServiceProvider2.class }, factoryMethod="create")
public class ServiceProvider2
{
    Composite m_composite = new Composite();
    Sequencer m_sequencer;

    static ServiceProvider2 create() {
        return new ServiceProvider2();
    }
    
    @ServiceDependency(required = false, filter = "(foo=bar)") // NullObject
    Runnable m_runnable;

    @ServiceDependency(service = Sequencer.class)
    void bind(Sequencer seq)
    {
        m_sequencer = seq;
        m_sequencer.step(1);
    }

    @Start
    void start()
    {
        m_sequencer.step(3);
        m_runnable.run(); // NullObject
    }

    public void step(int step) { // called by ServiceProvider.start() method
        m_sequencer.step(step);
    }
    
    @Stop
    void stop()
    {
        m_sequencer.step(11);
    }

    @Composition
    Object[] getComposition()
    {
        return new Object[] { this, m_composite };
    }
}
