#!/bin/sh

source "/opt/bitdefender/share/scripts/lib/setter.sh"
source "/opt/bitdefender/share/scripts/lib/skel.sh"

run() {
    LD_LIBRARY_PATH="/opt/bitdefender/lib:${LD_LIBRARY_PATH}" $@
}

init_fingerprint() {
    local fingerprint="$(get_key /karma/fipr)"
    [ -z "${fingerprint}" ] && {
        fingerprint="$(dd if=/dev/urandom bs=1 count=256 | sha256sum | grep -iEoe '^[a-f0-9]+')"
        set_key "/karma/fipr" "${fingerprint}"
    }
}

__handle_mark() {
    [ "$#" -ne "2" ] && return 1

    local __action="$1"
    local __mark_file="$2"

    if [ "${__action}" = "create" ]; then
        [ -e "/proc/uptime" ] || return 1
        cat "/proc/uptime" | cut -d'.' -f1 >"${__mark_file}" 2>/dev/null
    elif [ "${__action}" = "delete" ]; then
        rm -f "${__mark_file}"
    else
        return 1
    fi
}

create_bdcontainer_mark() {
    __handle_mark "create" "/tmp/.bdcontainer.mark"
}

delete_bdcontainer_mark() {
    __handle_mark "delete" "/tmp/.bdcontainer.mark"
}

create_bdagent_mark() {
    __handle_mark "create" "/tmp/.bdagent.mark"
}

delete_bdagent_mark() {
    __handle_mark "delete" "/tmp/.bdagent.mark"
}

# Specific to the agents that use the 'self register' flow (JWT-based registration flow).
check_self_register_cloud() {
    [ -n "${BDAGENT_DOCKER}" ] && return 0

    # Mirror the logic from bdsupervisor.
    local new_cloud_key="/daemons/bdcloudd/registration/register/temp_cloud"
    local old_cloud_key="/daemons/bdcloudd/registration/register/cloud"

    local new_cloud=$(get_key "${new_cloud_key}")
    [ -z "${new_cloud}" ] && new_cloud="production"
    new_cloud=$(echo "${new_cloud}" | tr '[:upper:]' '[:lower:]')

    local old_cloud=$(get_key "${old_cloud_key}")
    [ -z "${old_cloud}" ] && old_cloud="production"
    old_cloud=$(echo "${old_cloud}" | tr '[:upper:]' '[:lower:]')

    if [ "${new_cloud}" != "${old_cloud}" ]; then
        echo "Registration cloud changed: '${new_cloud}' (new) vs '${old_cloud}' (old) - deleting registration metadata"

        del_key_if_exists "/daemons/bdcloudd/user_token" || return 1
        del_key_if_exists "/daemons/bdcloudd/device_id" || return 1
        del_key_if_exists "/daemons/bdcloudd/registration/register/router_id" || return 1
        del_key_if_exists "/daemons/bdcloudd/registration/refresh/refresh_token" || return 1
        del_key_if_exists "/daemons/bdcloudd/registration/register/expires_on" || return 1
    fi

    echo "Setting current registration cloud to '${new_cloud}'"
    set_key "${old_cloud_key}" "${new_cloud}" || return 1

    del_key_if_exists "${new_cloud_key}" || return 1

    return 0
}

get_update_overwritable_locations()
{
    local PREFIX
    [ -n "$1" ] && PREFIX=$1/

    echo "${PREFIX}bdnc.client_id" \
         "${PREFIX}bdnc.ini" \
         "${PREFIX}certs" \
         "${PREFIX}default_settings_public.pem" \
         "${PREFIX}env_keys.json" \
         "${PREFIX}guster_locations.json" \
         "${PREFIX}jsonrules" \
         "${PREFIX}logging" \
         "${PREFIX}parental_categories.json" \
         "${PREFIX}signal_mapper.json" \
         "${PREFIX}subscription.conf" \
         "${PREFIX}updater.conf"
}

get_update_overwritable_locations_v2()
{
    local PREFIX=${1:-/opt/bitdefender/etc}

    ls "$PREFIX" \
        | grep -v "bdnc.uuid" \
        | grep -v "guster" \
        | grep -v "storage.data"
}
