#!/bin/sh

# Relink bdroot/var/* temporary dirs to tmp_bdroot subdirs.
# This is a NOP on read-only filesystems (hardcoded links from the image - check dockerify.sh).
#
# Note: It can be used at build and run time.
skel_link_tmp_dirs() {
    local bdroot="${1}"
    local tmp_bdroot="${2}"

    # Internal bdagent services use bd_$entry.
    for entry in "arks" "crash" "run"; do
        local bd_entry="${bdroot}/var/${entry}"
        if [ ! -L "${bd_entry}" ]; then
            rm -rf "${bd_entry}" || true
            ln -sfn "${tmp_bdroot}/${entry}" "${bd_entry}"
        fi
    done

    # Internal bdagent services use bd_tmp.
    local bd_tmp="${bdroot}/var/tmp"
    if [ ! -L "${bd_tmp}" ]; then
        rm -rf "${bd_tmp}" || true
        ln -sfn "${tmp_bdroot}" "${bd_tmp}"
    fi
}

# "Always there" temporary dirs.
#
# Note: It must be used at run time.
skel_init_tmp_bdroot() {
    local bdroot="/opt/bitdefender"
    local tmp_bdroot="/tmp/bdtmp"

    mkdir -p "${tmp_bdroot}"
    for entry in "arks" "crash" "devices" "guster" "log" "run" "stats" "vpn"; do
        if [ ! -d "${tmp_bdroot}/${entry}" ]; then
            rm -rf "${tmp_bdroot}/${entry}" || true
            mkdir -p "${tmp_bdroot}/${entry}"
        fi
    done

    # Internal bdagent services expect "guster_ipc.pipe" to be in the run directory.
    # (also check updater.conf)
    ln -sfn "${tmp_bdroot}/guster/guster_ipc.pipe" "${tmp_bdroot}/run/guster_ipc.pipe"

    skel_link_tmp_dirs "${bdroot}" "${tmp_bdroot}"
}

# Init the guster tree.
#
# Note: It must be used at run time.
skel_init_guster() {
    # absolute path for guster runtime: $BDROOT/lib
    #
    # Notes:
    # * NOP on boxv2 because the runtime is always set to /lib from 01-init-data at boot
    # * readlink/realpath missing on phase1.
    local guster_runtime=$(ls -l "/opt/bitdefender/guster/runtime" 2>/dev/null | awk '{print $NF}')
    if [ "${guster_runtime}" != "/lib" ]; then
        rm -f "/opt/bitdefender/guster/runtime" || true
        ln -sf "/opt/bitdefender/lib" "/opt/bitdefender/guster/runtime"
    fi
}

# "Always there" persistent dirs.
#
# Note: It must be used at run time.
skel_init_bdroot() {
    skel_init_guster
}

# "Always there" persistent & temporary dirs.
#
# Note: It must be used at run time.
skel_init() {
    skel_init_tmp_bdroot
    skel_init_bdroot
}
