#!/bin/sh

setter_storage_paths() {
    paths=""
    if [ -f /tmp/storage_paths.list ]; then
        for i in $(cat /tmp/storage_paths.list); do
            if [ -z "${paths}" ]; then
                paths="${i}"
            else
                paths="${paths},${i}"
            fi
        done
    else
        paths="/opt/bitdefender/etc/storage.data"
    fi
    echo "${paths}"
}

start_setter() {
    # Start from init.d only after 09-set-files-capabilities was run.
    if [ -e /tmp/.bdsetter_user_mark ]; then
        /etc/init.d/bbox-bdsetter start || true
    else
        /opt/bitdefender/bin/bdsetter -start -save-to "$(setter_storage_paths)" || true
    fi
}

stop_setter() {
    # Stop only if not started from init.d.
    if [ ! -e /tmp/.bdsetter_user_mark ]; then
        /opt/bitdefender/bin/bdsetter -stop || true
        killall -9 bdsetter 2>/dev/null || true
    fi
}

get_key() {
    local r=0
    /opt/bitdefender/bin/bdsett -get-key "$1" || r="$?"
    return $r
}

set_key() {
    local r=0
    /opt/bitdefender/bin/bdsett -set-key "$1" -to-string "$2" || r="$?"
    return $r
}

del_key() {
    local r=0
    /opt/bitdefender/bin/bdsett -del-key "$1" || r="$?"
    return $r
}

del_key_if_exists() {
    local r=0
    /opt/bitdefender/bin/bdsett -del-key "$1" -ignore-missing 1 || r="$?"
    return $r
}
