#!/bin/sh

LD_LIBRARY_PATH=/opt/bitdefender/lib /opt/bitdefender/bin/bdsett -get-key /karma/fipr > /opt/bitdefender/etc/guster/.deviceid 2>/dev/null

unset LD_LIBRARY_PATH
export PATH="/opt/bitdefender/bin:${PATH}"
sh /opt/bitdefender/guster/scripts/create_chain.sh $@

init_whitelist_chain() {
    if [ -z "${GC_MARK_SHIFT}" ]; then
        echo "GC_MARK_SHIFT not provided"
        return 1
    fi

    [ "$1" = "6" ] && IPTABLES="ip6tables" || IPTABLES="iptables"
    [ "$1" = "6" ] && TEST_IP="FE80::903A:1C1A:E802:11E4" || TEST_IP="127.42.42.42"

    mark_whitelist=$((0x3 << ${GC_MARK_SHIFT}))
    mark_mask=$((0xf << ${GC_MARK_SHIFT}))

    # Check the availability of the "BDCONNMARK" target
    connmark="CONNMARK"
    ${IPTABLES} -A OUTPUT -d ${TEST_IP} -j BDCONNMARK --set-mark 0x0/0x0 >/dev/null 2>&1 && connmark="BDCONNMARK"
    ${IPTABLES} -D OUTPUT -d ${TEST_IP} -j BDCONNMARK --set-mark 0x0/0x0 >/dev/null 2>&1

    $IPTABLES -F WHITELIST >/dev/null 2>&1
    $IPTABLES -A WHITELIST -m mark --mark 0x0/${mark_mask} -p tcp -j ${connmark} --set-mark ${mark_whitelist}/${mark_mask}
    $IPTABLES -A WHITELIST -m mark --mark ${mark_whitelist}/${mark_mask} -p tcp -j ${connmark} --save-mark
    $IPTABLES -A WHITELIST -m mark --mark ${mark_whitelist}/${mark_mask} -j ACCEPT
}

uninit_whitelist_chain() {
    [ "$1" = "6" ] && IPTABLES="ip6tables" || IPTABLES="iptables"

    $IPTABLES -F WHITELIST >/dev/null 2>&1
}

if [ "$1" = "-6" ]; then
    IP_VER="6"
    shift
else
    IP_VER="4"
fi

if [ "$1" = "clean" ]; then
    uninit_whitelist_chain ${IP_VER}
else
    init_whitelist_chain ${IP_VER}
fi

