#!/bin/sh

if [ -z "/opt/bitdefender" ]; then
    echo "__BDROOT is empty" >&2
    exit 1
fi

if [ -z "$SEAL_CONFIG_FILE" ]; then
    SEAL_CONFIG_FILE=/etc/netgear.conf
fi

if [ ! -f "$SEAL_CONFIG_FILE" ]; then
    exit 0
fi

source "/opt/bitdefender/share/scripts/lib/utils.sh"

make_symlink() {
    local SOURCE="$1"
    local TARGET="$2"
    local IS_DIR="$3"
    shift 3

    if [ ! -d "$TARGET" ]; then
        echo "$TARGET does not exist" >&2
        return 1
    fi

    local BD_TARGET_PARENT="$TARGET"/bitdefender
    local BD_TARGET="$BD_TARGET_PARENT"/"$(basename "$SOURCE")"
    if [ "$BD_TARGET" = "$(readlink -f "$SOURCE")" ]; then
        return 0
    fi

    if "$IS_DIR"; then
        if ! mkdir -p "$BD_TARGET"; then
            echo "Cannot create $BD_TARGET" >&2
            return 1
        fi

        # Cleanup a subset or all the old files from target
        local OVERWRITE_ONLY=${*:-$(ls -A "$BD_TARGET")}
        for entry in $OVERWRITE_ONLY; do
            rm -rf "${BD_TARGET:?}"/"$entry"
        done

        # Move new files
        if [ -d "$SOURCE" ]; then
            for entry in "$SOURCE"/*; do
                mv -n "$entry" "$BD_TARGET"
            done
        fi
    else
        if ! mkdir -p "$BD_TARGET_PARENT"; then
            echo "Cannot create $BD_TARGET_PARENT" >&2
            return 1
        fi

        if [ -f "$SOURCE" ]; then
            cp -L "$SOURCE" "$BD_TARGET"
        fi
    fi

    rm -rf "$SOURCE"
    mkdir -p "$(dirname "$SOURCE")"
    if ! ln -s "$BD_TARGET" "$SOURCE"; then
        echo "Failed linking $BD_TARGET to $SOURCE" >&2
        return 1
    fi

    return 0;
}

extract_field() {
    cut -d ';' -f 1 "$SEAL_CONFIG_FILE" | sed -n -e '/\[seal_service\]/,/\[/ p' | grep "^[ \t]*$1" | cut -d '=' -f 2 | head -n 1 | xargs
}

CACHE_DIR=$(extract_field cache_dir)
if ! make_symlink "/opt/bitdefender"/etc "$CACHE_DIR" true $(get_update_overwritable_locations_v2); then
    echo "Failed to link /opt/bitdefender/etc" >&2
    exit 1
fi

LOG_DIR=$(extract_field log_dir)
if ! make_symlink "/tmp/bdtmp/log" "$LOG_DIR" true; then
    echo "Failed to link /tmp/bdtmp/log" >&2
fi

if ! make_symlink /tmp/bitdefender_logs.tar.gz "$LOG_DIR" false; then
    echo "Failed to link /tmp/bitdefender_logs.tar.gz" >&2
fi

exit 0