#!/bin/sh

DIR="/opt/bitdefender"
BIN_DIR="$DIR/bin"
BOX_IPTABLES="$BIN_DIR/iptables"
BOX_IP6TABLES="$BIN_DIR/ip6tables"

add_pro_feature_rules() {
    [ "$1" = "-6" ] && IPTABLES="${BOX_IP6TABLES}" || IPTABLES="${BOX_IPTABLES}"
    [ "$1" = "-6" ] && ICMP_VER="icmpv6" || ICMP_VER="icmp"

    $IPTABLES -L BD_FILTER >/dev/null 2>&1
    [ $? -ne 0 ] && exit 0

    $IPTABLES -C BD_FILTER -p udp --dport  80 -j GUSTER >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -p udp --dport  80 -j GUSTER
    $IPTABLES -C BD_FILTER -p udp --sport  80 -j GUSTER >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -p udp --sport  80 -j GUSTER
    $IPTABLES -C BD_FILTER -p udp --dport 443 -j GUSTER >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -p udp --dport 443 -j GUSTER
    $IPTABLES -C BD_FILTER -p udp --sport 443 -j GUSTER >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -p udp --sport 443 -j GUSTER
    $IPTABLES -C BD_FILTER -p $ICMP_VER       -j GUSTER >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -p $ICMP_VER       -j GUSTER
}

del_pro_feature_rules() {
    [ "$1" = "-6" ] && IPTABLES="${BOX_IP6TABLES}" || IPTABLES="${BOX_IPTABLES}"
    [ "$1" = "-6" ] && ICMP_VER="icmpv6" || ICMP_VER="icmp"

    $IPTABLES -L BD_FILTER >/dev/null 2>&1
    [ $? -ne 0 ] && exit 0

    $IPTABLES -D BD_FILTER -p udp --dport  80 -j GUSTER >/dev/null 2>&1
    $IPTABLES -D BD_FILTER -p udp --sport  80 -j GUSTER >/dev/null 2>&1
    $IPTABLES -D BD_FILTER -p udp --dport 443 -j GUSTER >/dev/null 2>&1
    $IPTABLES -D BD_FILTER -p udp --sport 443 -j GUSTER >/dev/null 2>&1
    $IPTABLES -D BD_FILTER -p $ICMP_VER       -j GUSTER >/dev/null 2>&1

    return 0
}

[ $# -ne 1 ] && exit 1

case "$1" in
    add)
        add_pro_feature_rules
        add_pro_feature_rules -6
    ;;
    del)
        del_pro_feature_rules
        del_pro_feature_rules -6
    ;;
    *)
        exit 1
    ;;
esac

