#!/bin/sh

source "/opt/bitdefender/share/scripts/lib/utils.sh"

PERSISTENT_ROOT="/persistent-data"
SHADOW_ROOT="/opt/bitdefender/share/shadow"
INITSCRIPTS_ROOT="/opt/bitdefender/share/scripts/init_sync.d"

set -e
set -x

create_bdcontainer_mark || true

detect_agent_libc() {
    local libc="musl"
    ls -l "/opt/bitdefender"/lib/ld-musl-* >/dev/null || libc="uclibc"
    echo "${libc}"
}

rotate_log_files() {
    local max_files=6

    for path in $(ls -1tr ${1}.*); do
        local i=${path##*.}
        mv -f ${path} ${path%.*}.$((i + 1))
    done

    for path in $(ls ${1}.*); do
        if [ ${path##*.} -ge $max_files ]; then
            rm -f ${path} || true
        fi
    done
}

copy_always_overwritten() {
    DST_ROOT="$1"
    SRC_ROOT="$2"
    shift 2
    TO_OVERWRITE="$@"

    if [ -d "${SRC_ROOT}" ]; then
        for ENTRY in ${TO_OVERWRITE}; do
            if [ -d "${DST_ROOT}/${ENTRY}" ]; then
                rm -rf "${DST_ROOT}/${ENTRY}" || true
                mkdir -p "${DST_ROOT}/${ENTRY}"
                cp -RP "${SRC_ROOT}/${ENTRY}"/* "${DST_ROOT}/${ENTRY}"
            elif [ -f "${DST_ROOT}/${ENTRY}" ]; then
                mkdir -p "${DST_ROOT}/$(dirname ${ENTRY})"
                cp -P "${SRC_ROOT}/${ENTRY}" "${DST_ROOT}/${ENTRY}"
            elif [ ! -e "${DST_ROOT}/${ENTRY}" ]; then
                mkdir -p "${DST_ROOT}/$(dirname ${ENTRY})"
                cp -RP "${SRC_ROOT}/${ENTRY}" "${DST_ROOT}/${ENTRY}"
            fi
        done
    elif [ -f "${SRC_ROOT}" ] && [ "${SRC_ROOT: -7}" = ".tar.gz" -o "${SRC_ROOT: -4}" = ".tgz" ]; then
        for ENTRY in ${TO_OVERWRITE}; do
            rm -rf "${DST_ROOT}/${ENTRY}" || true
        done
        tar -C "${DST_ROOT}" -xzf "${SRC_ROOT}" ${TO_OVERWRITE} || true
    else
        echo "${SRC_ROOT} is neither a directory, nor a gzipped tar file."
        false
    fi
}

rotate_log_files "${PERSISTENT_ROOT}/$(basename ${0}).log" || true

# Remove existing guster if switching to a different libc
AGENT_LIBC="$(detect_agent_libc)"
if [ -f "${PERSISTENT_ROOT}"/guster-libc ]; then
    source "${PERSISTENT_ROOT}"/guster-libc
fi

if [ ! "${AGENT_LIBC}" = "${PERSISTENT_GUSTER_LIBC}" ]; then
    if [ -e "${PERSISTENT_ROOT}"/guster ]; then
        rm -rf "${PERSISTENT_ROOT}"/guster
    fi
fi

# Shadow persistent dirs - if missing or empty, copy from shadow.
for ENTRY in "etc" "guster"; do
    if [ ! -d "${PERSISTENT_ROOT}/${ENTRY}" ] || [ -z "$(ls -A ${PERSISTENT_ROOT}/${ENTRY})" ]; then
        rm -rf "${PERSISTENT_ROOT}/${ENTRY}" || true
        tar -C "${PERSISTENT_ROOT}" -xzf "${SHADOW_ROOT}/${ENTRY}.tar.gz"
    fi
done

if [ ! "${AGENT_LIBC}" = "${PERSISTENT_GUSTER_LIBC}" ]; then
    echo "PERSISTENT_GUSTER_LIBC='${AGENT_LIBC}'" > "${PERSISTENT_ROOT}"/guster-libc
fi

copy_always_overwritten "${PERSISTENT_ROOT}" "${SHADOW_ROOT}/etc.tar.gz" $(get_update_overwritable_locations etc)

# "Always there" temporary dirs.
skel_init

# "Always there" persistent dirs.
for ENTRY in "var/log" "var/upd"; do
    if [ ! -d "${PERSISTENT_ROOT}/${ENTRY}" ]; then
        rm -rf "${PERSISTENT_ROOT}/${ENTRY}" || true
        mkdir -p "${PERSISTENT_ROOT}/${ENTRY}"
    fi
done

if [ -d "${INITSCRIPTS_ROOT}" ]; then
    for SCRIPT in $(echo "${INITSCRIPTS_ROOT}"/*.sh | sort); do
        "${SCRIPT}" || exit 1
    done
fi
