#!/bin/sh

BD_BIN="/opt/bitdefender/bin"
BOX_IPTABLES="${BD_BIN}/iptables"
BOX_IP6TABLES="${BD_BIN}/ip6tables"

source "/opt/bitdefender/share/scripts/lib/utils.sh"

init_chains() {
    [ "$1" = "-6" ] && IPTABLES="${BOX_IP6TABLES}" || IPTABLES="${BOX_IPTABLES}"

    # iptables: the jump from FORWARD to BD_FILTER is not managed by the BD agent.
    $IPTABLES -N BD_FILTER >/dev/null 2>&1

    # Create WHITELIST chain
    $IPTABLES -N WHITELIST >/dev/null 2>&1

    # Create and append IGNORED_DEVICES chain to BD_FILTER
    $IPTABLES -N IGNORED_DEVICES >/dev/null 2>&1
    $IPTABLES -F IGNORED_DEVICES >/dev/null 2>&1
    $IPTABLES -C BD_FILTER -j IGNORED_DEVICES >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -j IGNORED_DEVICES

    # Create and append GUSTER chain to BD_FILTER (the first rule in FORWARD will be a jump to BD_FILTER).
    $IPTABLES -N GUSTER >/dev/null 2>&1
    $IPTABLES -C BD_FILTER -p tcp ! --dport 53 ! --sport 53 -j GUSTER >/dev/null 2>&1 || $IPTABLES -A BD_FILTER -p tcp ! --dport 53 ! --sport 53 -j GUSTER
}

uninit_chains() {
    [ "$1" = "-6" ] && IPTABLES="${BOX_IP6TABLES}" || IPTABLES="${BOX_IPTABLES}"

    for chain in BD_FILTER WHITELIST IGNORED_DEVICES GUSTER; do
        $IPTABLES -F ${chain} >/dev/null 2>&1
    done
}

case "$1" in
    start)
        init_chains
        init_chains -6
    ;;
    stop)
        uninit_chains
        uninit_chains -6
    ;;
    *)
        init_chains
        init_chains -6
        run "${BD_BIN}/bdexchange-pump" -t ":reinit_guster_chain" >/dev/null 2>&1
        run "${BD_BIN}/bdexchange-pump" -t ":reinit_block_chains" >/dev/null 2>&1
    ;;
esac
