/* soapC.c
   Generated by gSOAP 2.7.11 from LeafNets.h
   Copyright(C) 2000-2008, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.11 2008-09-23 03:08:38 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header));
		soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_ns1__getSystemNotifications:
		return soap_in_ns1__getSystemNotifications(soap, NULL, NULL, "ns1:getSystemNotifications");
	case SOAP_TYPE_ns1__getSystemNotificationsResponse:
		return soap_in_ns1__getSystemNotificationsResponse(soap, NULL, NULL, "ns1:getSystemNotificationsResponse");
	case SOAP_TYPE_ns1__getNotifications:
		return soap_in_ns1__getNotifications(soap, NULL, NULL, "ns1:getNotifications");
	case SOAP_TYPE_ns1__getNotificationsResponse:
		return soap_in_ns1__getNotificationsResponse(soap, NULL, NULL, "ns1:getNotificationsResponse");
	case SOAP_TYPE_ns1__getNetwork:
		return soap_in_ns1__getNetwork(soap, NULL, NULL, "ns1:getNetwork");
	case SOAP_TYPE_ns1__getNetworkResponse:
		return soap_in_ns1__getNetworkResponse(soap, NULL, NULL, "ns1:getNetworkResponse");
	case SOAP_TYPE_ns1__getNetworks:
		return soap_in_ns1__getNetworks(soap, NULL, NULL, "ns1:getNetworks");
	case SOAP_TYPE_ns1__getNetworksResponse:
		return soap_in_ns1__getNetworksResponse(soap, NULL, NULL, "ns1:getNetworksResponse");
	case SOAP_TYPE_ns1__leaveNetwork:
		return soap_in_ns1__leaveNetwork(soap, NULL, NULL, "ns1:leaveNetwork");
	case SOAP_TYPE_ns1__leaveNetworkResponse:
		return soap_in_ns1__leaveNetworkResponse(soap, NULL, NULL, "ns1:leaveNetworkResponse");
	case SOAP_TYPE_ns1__deleteNetworkMember:
		return soap_in_ns1__deleteNetworkMember(soap, NULL, NULL, "ns1:deleteNetworkMember");
	case SOAP_TYPE_ns1__deleteNetworkMemberResponse:
		return soap_in_ns1__deleteNetworkMemberResponse(soap, NULL, NULL, "ns1:deleteNetworkMemberResponse");
	case SOAP_TYPE_ns1__declineNetworkInvite:
		return soap_in_ns1__declineNetworkInvite(soap, NULL, NULL, "ns1:declineNetworkInvite");
	case SOAP_TYPE_ns1__declineNetworkInviteResponse:
		return soap_in_ns1__declineNetworkInviteResponse(soap, NULL, NULL, "ns1:declineNetworkInviteResponse");
	case SOAP_TYPE_ns1__acceptNetworkInvite:
		return soap_in_ns1__acceptNetworkInvite(soap, NULL, NULL, "ns1:acceptNetworkInvite");
	case SOAP_TYPE_ns1__acceptNetworkInviteResponse:
		return soap_in_ns1__acceptNetworkInviteResponse(soap, NULL, NULL, "ns1:acceptNetworkInviteResponse");
	case SOAP_TYPE_ns1__inviteNetworkMemberByUser:
		return soap_in_ns1__inviteNetworkMemberByUser(soap, NULL, NULL, "ns1:inviteNetworkMemberByUser");
	case SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse:
		return soap_in_ns1__inviteNetworkMemberByUserResponse(soap, NULL, NULL, "ns1:inviteNetworkMemberByUserResponse");
	case SOAP_TYPE_ns1__inviteNetworkMemberByEmail:
		return soap_in_ns1__inviteNetworkMemberByEmail(soap, NULL, NULL, "ns1:inviteNetworkMemberByEmail");
	case SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse:
		return soap_in_ns1__inviteNetworkMemberByEmailResponse(soap, NULL, NULL, "ns1:inviteNetworkMemberByEmailResponse");
	case SOAP_TYPE_ns1__inviteNetworkMember:
		return soap_in_ns1__inviteNetworkMember(soap, NULL, NULL, "ns1:inviteNetworkMember");
	case SOAP_TYPE_ns1__inviteNetworkMemberResponse:
		return soap_in_ns1__inviteNetworkMemberResponse(soap, NULL, NULL, "ns1:inviteNetworkMemberResponse");
	case SOAP_TYPE_ns1__deleteNetwork:
		return soap_in_ns1__deleteNetwork(soap, NULL, NULL, "ns1:deleteNetwork");
	case SOAP_TYPE_ns1__deleteNetworkResponse:
		return soap_in_ns1__deleteNetworkResponse(soap, NULL, NULL, "ns1:deleteNetworkResponse");
	case SOAP_TYPE_ns1__addNetwork:
		return soap_in_ns1__addNetwork(soap, NULL, NULL, "ns1:addNetwork");
	case SOAP_TYPE_ns1__addNetworkResponse:
		return soap_in_ns1__addNetworkResponse(soap, NULL, NULL, "ns1:addNetworkResponse");
	case SOAP_TYPE_ns1__lookupContacts:
		return soap_in_ns1__lookupContacts(soap, NULL, NULL, "ns1:lookupContacts");
	case SOAP_TYPE_ns1__lookupContactsResponse:
		return soap_in_ns1__lookupContactsResponse(soap, NULL, NULL, "ns1:lookupContactsResponse");
	case SOAP_TYPE_ns1__getContact:
		return soap_in_ns1__getContact(soap, NULL, NULL, "ns1:getContact");
	case SOAP_TYPE_ns1__getContactResponse:
		return soap_in_ns1__getContactResponse(soap, NULL, NULL, "ns1:getContactResponse");
	case SOAP_TYPE_ns1__updateContact:
		return soap_in_ns1__updateContact(soap, NULL, NULL, "ns1:updateContact");
	case SOAP_TYPE_ns1__updateContactResponse:
		return soap_in_ns1__updateContactResponse(soap, NULL, NULL, "ns1:updateContactResponse");
	case SOAP_TYPE_ns1__changePassword:
		return soap_in_ns1__changePassword(soap, NULL, NULL, "ns1:changePassword");
	case SOAP_TYPE_ns1__changePasswordResponse:
		return soap_in_ns1__changePasswordResponse(soap, NULL, NULL, "ns1:changePasswordResponse");
	case SOAP_TYPE_ns1__deleteUser:
		return soap_in_ns1__deleteUser(soap, NULL, NULL, "ns1:deleteUser");
	case SOAP_TYPE_ns1__deleteUserResponse:
		return soap_in_ns1__deleteUserResponse(soap, NULL, NULL, "ns1:deleteUserResponse");
	case SOAP_TYPE_ns1__vrfyLogin:
		return soap_in_ns1__vrfyLogin(soap, NULL, NULL, "ns1:vrfyLogin");
	case SOAP_TYPE_ns1__vrfyLoginResponse:
		return soap_in_ns1__vrfyLoginResponse(soap, NULL, NULL, "ns1:vrfyLoginResponse");
	case SOAP_TYPE_ns4__UpdateMemberContactNotification:
		return soap_in_ns4__UpdateMemberContactNotification(soap, NULL, NULL, "ns4:UpdateMemberContactNotification");
	case SOAP_TYPE_ns4__SignupNetworkMemberNotification:
		return soap_in_ns4__SignupNetworkMemberNotification(soap, NULL, NULL, "ns4:SignupNetworkMemberNotification");
	case SOAP_TYPE_ns4__DeleteNetworkMemberNotification:
		return soap_in_ns4__DeleteNetworkMemberNotification(soap, NULL, NULL, "ns4:DeleteNetworkMemberNotification");
	case SOAP_TYPE_ns4__DeclineNetworkInviteNotification:
		return soap_in_ns4__DeclineNetworkInviteNotification(soap, NULL, NULL, "ns4:DeclineNetworkInviteNotification");
	case SOAP_TYPE_ns4__AddNetworkMemberNotification:
		return soap_in_ns4__AddNetworkMemberNotification(soap, NULL, NULL, "ns4:AddNetworkMemberNotification");
	case SOAP_TYPE_ns5__PeerSynPktEvent:
		return soap_in_ns5__PeerSynPktEvent(soap, NULL, NULL, "ns5:PeerSynPktEvent");
	case SOAP_TYPE_ns5__PeerDisconnectedEvent:
		return soap_in_ns5__PeerDisconnectedEvent(soap, NULL, NULL, "ns5:PeerDisconnectedEvent");
	case SOAP_TYPE_ns5__PeerConnectedEvent:
		return soap_in_ns5__PeerConnectedEvent(soap, NULL, NULL, "ns5:PeerConnectedEvent");
	case SOAP_TYPE_ns5__PeerConnectRequestEvent:
		return soap_in_ns5__PeerConnectRequestEvent(soap, NULL, NULL, "ns5:PeerConnectRequestEvent");
	case SOAP_TYPE_ns5__PeerConnectRejectEvent:
		return soap_in_ns5__PeerConnectRejectEvent(soap, NULL, NULL, "ns5:PeerConnectRejectEvent");
	case SOAP_TYPE_ns5__PeerConnectEvent:
		return soap_in_ns5__PeerConnectEvent(soap, NULL, NULL, "ns5:PeerConnectEvent");
	case SOAP_TYPE_ns5__PeerConnectErrorEvent:
		return soap_in_ns5__PeerConnectErrorEvent(soap, NULL, NULL, "ns5:PeerConnectErrorEvent");
	case SOAP_TYPE_ns5__PeerConnectBusyEvent:
		return soap_in_ns5__PeerConnectBusyEvent(soap, NULL, NULL, "ns5:PeerConnectBusyEvent");
	case SOAP_TYPE_ns4__InviteNetworkNotification:
		return soap_in_ns4__InviteNetworkNotification(soap, NULL, NULL, "ns4:InviteNetworkNotification");
	case SOAP_TYPE_ns4__DeleteNetworkNotification:
		return soap_in_ns4__DeleteNetworkNotification(soap, NULL, NULL, "ns4:DeleteNetworkNotification");
	case SOAP_TYPE_ns4__NetworkMemberNotification:
		return soap_in_ns4__NetworkMemberNotification(soap, NULL, NULL, "ns4:NetworkMemberNotification");
	case SOAP_TYPE_ns5__PeerEventIndex:
		return soap_in_ns5__PeerEventIndex(soap, NULL, NULL, "ns5:PeerEventIndex");
	case SOAP_TYPE_ns5__PeerConnectionEvent:
		return soap_in_ns5__PeerConnectionEvent(soap, NULL, NULL, "ns5:PeerConnectionEvent");
	case SOAP_TYPE_ns4__NotificationIndex:
		return soap_in_ns4__NotificationIndex(soap, NULL, NULL, "ns4:NotificationIndex");
	case SOAP_TYPE_ns4__NetworkNotification:
		return soap_in_ns4__NetworkNotification(soap, NULL, NULL, "ns4:NetworkNotification");
	case SOAP_TYPE_ns2__Usert:
		return soap_in_ns2__Usert(soap, NULL, NULL, "ns2:Usert");
	case SOAP_TYPE_ns5__PeerRegister:
		return soap_in_ns5__PeerRegister(soap, NULL, NULL, "ns5:PeerRegister");
	case SOAP_TYPE_ns5__PeerEventType:
		return soap_in_ns5__PeerEventType(soap, NULL, NULL, "ns5:PeerEventType");
	case SOAP_TYPE_ns5__PeerConnectionType:
		return soap_in_ns5__PeerConnectionType(soap, NULL, NULL, "ns5:PeerConnectionType");
	case SOAP_TYPE_ns5__PeerConnectionStats:
		return soap_in_ns5__PeerConnectionStats(soap, NULL, NULL, "ns5:PeerConnectionStats");
	case SOAP_TYPE_ns5__PeerConnectionState:
		return soap_in_ns5__PeerConnectionState(soap, NULL, NULL, "ns5:PeerConnectionState");
	case SOAP_TYPE_ns5__PeerConnectionInfo:
		return soap_in_ns5__PeerConnectionInfo(soap, NULL, NULL, "ns5:PeerConnectionInfo");
	case SOAP_TYPE_ns5__PeerConnectionConnectedStatus:
		return soap_in_ns5__PeerConnectionConnectedStatus(soap, NULL, NULL, "ns5:PeerConnectionConnectedStatus");
	case SOAP_TYPE_ns5__PeerConnectionConnectStatus:
		return soap_in_ns5__PeerConnectionConnectStatus(soap, NULL, NULL, "ns5:PeerConnectionConnectStatus");
	case SOAP_TYPE_ns5__PeerConnection:
		return soap_in_ns5__PeerConnection(soap, NULL, NULL, "ns5:PeerConnection");
	case SOAP_TYPE_ns5__PeerEvent:
		return soap_in_ns5__PeerEvent(soap, NULL, NULL, "ns5:PeerEvent");
	case SOAP_TYPE_ns5__PeerAssistAttr:
		return soap_in_ns5__PeerAssistAttr(soap, NULL, NULL, "ns5:PeerAssistAttr");
	case SOAP_TYPE_ns5__PeerAssist:
		return soap_in_ns5__PeerAssist(soap, NULL, NULL, "ns5:PeerAssist");
	case SOAP_TYPE_ns5__PeerAccess:
		return soap_in_ns5__PeerAccess(soap, NULL, NULL, "ns5:PeerAccess");
	case SOAP_TYPE_ns4__NotificationType:
		return soap_in_ns4__NotificationType(soap, NULL, NULL, "ns4:NotificationType");
	case SOAP_TYPE_ns4__Notification:
		return soap_in_ns4__Notification(soap, NULL, NULL, "ns4:Notification");
	case SOAP_TYPE_ns3__Vector:
		return soap_in_ns3__Vector(soap, NULL, NULL, "ns3:Vector");
	case SOAP_TYPE_ns2__UserStats:
		return soap_in_ns2__UserStats(soap, NULL, NULL, "ns2:UserStats");
	case SOAP_TYPE_ns2__UserAttr:
		return soap_in_ns2__UserAttr(soap, NULL, NULL, "ns2:UserAttr");
	case SOAP_TYPE_ns2__SystemNotification:
		return soap_in_ns2__SystemNotification(soap, NULL, NULL, "ns2:SystemNotification");
	case SOAP_TYPE_ns2__IPAttr:
		return soap_in_ns2__IPAttr(soap, NULL, NULL, "ns2:IPAttr");
	case SOAP_TYPE_ns2__IPAddress:
		return soap_in_ns2__IPAddress(soap, NULL, NULL, "ns2:IPAddress");
	case SOAP_TYPE_ns2__User:
		return soap_in_ns2__User(soap, NULL, NULL, "ns2:User");
	case SOAP_TYPE_ns2__Member:
		return soap_in_ns2__Member(soap, NULL, NULL, "ns2:Member");
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType:
		return soap_in_ArrayOf_USCORExsd_USCOREanyType(soap, NULL, NULL, "xsd:anyType");
	case SOAP_TYPE_ns2__Network:
		return soap_in_ns2__Network(soap, NULL, NULL, "ns2:Network");
	case SOAP_TYPE_ns2__Contact:
		return soap_in_ns2__Contact(soap, NULL, NULL, "ns2:Contact");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTons1__getSystemNotificationsResponse:
		return soap_in_PointerTons1__getSystemNotificationsResponse(soap, NULL, NULL, "ns1:getSystemNotificationsResponse");
	case SOAP_TYPE_PointerTons1__getNotificationsResponse:
		return soap_in_PointerTons1__getNotificationsResponse(soap, NULL, NULL, "ns1:getNotificationsResponse");
	case SOAP_TYPE_PointerTons1__getNetworkResponse:
		return soap_in_PointerTons1__getNetworkResponse(soap, NULL, NULL, "ns1:getNetworkResponse");
	case SOAP_TYPE_PointerTons1__getNetworksResponse:
		return soap_in_PointerTons1__getNetworksResponse(soap, NULL, NULL, "ns1:getNetworksResponse");
	case SOAP_TYPE_PointerTons1__leaveNetworkResponse:
		return soap_in_PointerTons1__leaveNetworkResponse(soap, NULL, NULL, "ns1:leaveNetworkResponse");
	case SOAP_TYPE_PointerTons1__deleteNetworkMemberResponse:
		return soap_in_PointerTons1__deleteNetworkMemberResponse(soap, NULL, NULL, "ns1:deleteNetworkMemberResponse");
	case SOAP_TYPE_PointerTons1__declineNetworkInviteResponse:
		return soap_in_PointerTons1__declineNetworkInviteResponse(soap, NULL, NULL, "ns1:declineNetworkInviteResponse");
	case SOAP_TYPE_PointerTons1__acceptNetworkInviteResponse:
		return soap_in_PointerTons1__acceptNetworkInviteResponse(soap, NULL, NULL, "ns1:acceptNetworkInviteResponse");
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberByUserResponse:
		return soap_in_PointerTons1__inviteNetworkMemberByUserResponse(soap, NULL, NULL, "ns1:inviteNetworkMemberByUserResponse");
	case SOAP_TYPE_PointerTons2__User:
		return soap_in_PointerTons2__User(soap, NULL, NULL, "ns2:User");
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberByEmailResponse:
		return soap_in_PointerTons1__inviteNetworkMemberByEmailResponse(soap, NULL, NULL, "ns1:inviteNetworkMemberByEmailResponse");
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberResponse:
		return soap_in_PointerTons1__inviteNetworkMemberResponse(soap, NULL, NULL, "ns1:inviteNetworkMemberResponse");
	case SOAP_TYPE_PointerTons2__Member:
		return soap_in_PointerTons2__Member(soap, NULL, NULL, "ns2:Member");
	case SOAP_TYPE_PointerTons1__deleteNetworkResponse:
		return soap_in_PointerTons1__deleteNetworkResponse(soap, NULL, NULL, "ns1:deleteNetworkResponse");
	case SOAP_TYPE_PointerTons1__addNetworkResponse:
		return soap_in_PointerTons1__addNetworkResponse(soap, NULL, NULL, "ns1:addNetworkResponse");
	case SOAP_TYPE_PointerTons2__Network:
		return soap_in_PointerTons2__Network(soap, NULL, NULL, "ns2:Network");
	case SOAP_TYPE_PointerTons1__lookupContactsResponse:
		return soap_in_PointerTons1__lookupContactsResponse(soap, NULL, NULL, "ns1:lookupContactsResponse");
	case SOAP_TYPE_PointerTons1__getContactResponse:
		return soap_in_PointerTons1__getContactResponse(soap, NULL, NULL, "ns1:getContactResponse");
	case SOAP_TYPE_PointerTons1__updateContactResponse:
		return soap_in_PointerTons1__updateContactResponse(soap, NULL, NULL, "ns1:updateContactResponse");
	case SOAP_TYPE_PointerTons2__Contact:
		return soap_in_PointerTons2__Contact(soap, NULL, NULL, "ns2:Contact");
	case SOAP_TYPE_PointerTons1__changePasswordResponse:
		return soap_in_PointerTons1__changePasswordResponse(soap, NULL, NULL, "ns1:changePasswordResponse");
	case SOAP_TYPE_PointerTons1__deleteUserResponse:
		return soap_in_PointerTons1__deleteUserResponse(soap, NULL, NULL, "ns1:deleteUserResponse");
	case SOAP_TYPE_PointerTons1__vrfyLoginResponse:
		return soap_in_PointerTons1__vrfyLoginResponse(soap, NULL, NULL, "ns1:vrfyLoginResponse");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTotime:
		return soap_in_PointerTotime(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREanyType:
		return soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, NULL, NULL, "ArrayOf_xsd_anyType");
	case SOAP_TYPE_PointerToLONG64:
		return soap_in_PointerToLONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSystemNotifications"))
		{	*type = SOAP_TYPE_ns1__getSystemNotifications;
			return soap_in_ns1__getSystemNotifications(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSystemNotificationsResponse"))
		{	*type = SOAP_TYPE_ns1__getSystemNotificationsResponse;
			return soap_in_ns1__getSystemNotificationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNotifications"))
		{	*type = SOAP_TYPE_ns1__getNotifications;
			return soap_in_ns1__getNotifications(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNotificationsResponse"))
		{	*type = SOAP_TYPE_ns1__getNotificationsResponse;
			return soap_in_ns1__getNotificationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNetwork"))
		{	*type = SOAP_TYPE_ns1__getNetwork;
			return soap_in_ns1__getNetwork(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNetworkResponse"))
		{	*type = SOAP_TYPE_ns1__getNetworkResponse;
			return soap_in_ns1__getNetworkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNetworks"))
		{	*type = SOAP_TYPE_ns1__getNetworks;
			return soap_in_ns1__getNetworks(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getNetworksResponse"))
		{	*type = SOAP_TYPE_ns1__getNetworksResponse;
			return soap_in_ns1__getNetworksResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:leaveNetwork"))
		{	*type = SOAP_TYPE_ns1__leaveNetwork;
			return soap_in_ns1__leaveNetwork(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:leaveNetworkResponse"))
		{	*type = SOAP_TYPE_ns1__leaveNetworkResponse;
			return soap_in_ns1__leaveNetworkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteNetworkMember"))
		{	*type = SOAP_TYPE_ns1__deleteNetworkMember;
			return soap_in_ns1__deleteNetworkMember(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteNetworkMemberResponse"))
		{	*type = SOAP_TYPE_ns1__deleteNetworkMemberResponse;
			return soap_in_ns1__deleteNetworkMemberResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:declineNetworkInvite"))
		{	*type = SOAP_TYPE_ns1__declineNetworkInvite;
			return soap_in_ns1__declineNetworkInvite(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:declineNetworkInviteResponse"))
		{	*type = SOAP_TYPE_ns1__declineNetworkInviteResponse;
			return soap_in_ns1__declineNetworkInviteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:acceptNetworkInvite"))
		{	*type = SOAP_TYPE_ns1__acceptNetworkInvite;
			return soap_in_ns1__acceptNetworkInvite(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:acceptNetworkInviteResponse"))
		{	*type = SOAP_TYPE_ns1__acceptNetworkInviteResponse;
			return soap_in_ns1__acceptNetworkInviteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:inviteNetworkMemberByUser"))
		{	*type = SOAP_TYPE_ns1__inviteNetworkMemberByUser;
			return soap_in_ns1__inviteNetworkMemberByUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:inviteNetworkMemberByUserResponse"))
		{	*type = SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse;
			return soap_in_ns1__inviteNetworkMemberByUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:inviteNetworkMemberByEmail"))
		{	*type = SOAP_TYPE_ns1__inviteNetworkMemberByEmail;
			return soap_in_ns1__inviteNetworkMemberByEmail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:inviteNetworkMemberByEmailResponse"))
		{	*type = SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse;
			return soap_in_ns1__inviteNetworkMemberByEmailResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:inviteNetworkMember"))
		{	*type = SOAP_TYPE_ns1__inviteNetworkMember;
			return soap_in_ns1__inviteNetworkMember(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:inviteNetworkMemberResponse"))
		{	*type = SOAP_TYPE_ns1__inviteNetworkMemberResponse;
			return soap_in_ns1__inviteNetworkMemberResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteNetwork"))
		{	*type = SOAP_TYPE_ns1__deleteNetwork;
			return soap_in_ns1__deleteNetwork(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteNetworkResponse"))
		{	*type = SOAP_TYPE_ns1__deleteNetworkResponse;
			return soap_in_ns1__deleteNetworkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:addNetwork"))
		{	*type = SOAP_TYPE_ns1__addNetwork;
			return soap_in_ns1__addNetwork(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:addNetworkResponse"))
		{	*type = SOAP_TYPE_ns1__addNetworkResponse;
			return soap_in_ns1__addNetworkResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lookupContacts"))
		{	*type = SOAP_TYPE_ns1__lookupContacts;
			return soap_in_ns1__lookupContacts(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lookupContactsResponse"))
		{	*type = SOAP_TYPE_ns1__lookupContactsResponse;
			return soap_in_ns1__lookupContactsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getContact"))
		{	*type = SOAP_TYPE_ns1__getContact;
			return soap_in_ns1__getContact(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getContactResponse"))
		{	*type = SOAP_TYPE_ns1__getContactResponse;
			return soap_in_ns1__getContactResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:updateContact"))
		{	*type = SOAP_TYPE_ns1__updateContact;
			return soap_in_ns1__updateContact(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:updateContactResponse"))
		{	*type = SOAP_TYPE_ns1__updateContactResponse;
			return soap_in_ns1__updateContactResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:changePassword"))
		{	*type = SOAP_TYPE_ns1__changePassword;
			return soap_in_ns1__changePassword(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:changePasswordResponse"))
		{	*type = SOAP_TYPE_ns1__changePasswordResponse;
			return soap_in_ns1__changePasswordResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteUser"))
		{	*type = SOAP_TYPE_ns1__deleteUser;
			return soap_in_ns1__deleteUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteUserResponse"))
		{	*type = SOAP_TYPE_ns1__deleteUserResponse;
			return soap_in_ns1__deleteUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:vrfyLogin"))
		{	*type = SOAP_TYPE_ns1__vrfyLogin;
			return soap_in_ns1__vrfyLogin(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:vrfyLoginResponse"))
		{	*type = SOAP_TYPE_ns1__vrfyLoginResponse;
			return soap_in_ns1__vrfyLoginResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:UpdateMemberContactNotification"))
		{	*type = SOAP_TYPE_ns4__UpdateMemberContactNotification;
			return soap_in_ns4__UpdateMemberContactNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:SignupNetworkMemberNotification"))
		{	*type = SOAP_TYPE_ns4__SignupNetworkMemberNotification;
			return soap_in_ns4__SignupNetworkMemberNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:DeleteNetworkMemberNotification"))
		{	*type = SOAP_TYPE_ns4__DeleteNetworkMemberNotification;
			return soap_in_ns4__DeleteNetworkMemberNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:DeclineNetworkInviteNotification"))
		{	*type = SOAP_TYPE_ns4__DeclineNetworkInviteNotification;
			return soap_in_ns4__DeclineNetworkInviteNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:AddNetworkMemberNotification"))
		{	*type = SOAP_TYPE_ns4__AddNetworkMemberNotification;
			return soap_in_ns4__AddNetworkMemberNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerSynPktEvent"))
		{	*type = SOAP_TYPE_ns5__PeerSynPktEvent;
			return soap_in_ns5__PeerSynPktEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerDisconnectedEvent"))
		{	*type = SOAP_TYPE_ns5__PeerDisconnectedEvent;
			return soap_in_ns5__PeerDisconnectedEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectedEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectedEvent;
			return soap_in_ns5__PeerConnectedEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectRequestEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectRequestEvent;
			return soap_in_ns5__PeerConnectRequestEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectRejectEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectRejectEvent;
			return soap_in_ns5__PeerConnectRejectEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectEvent;
			return soap_in_ns5__PeerConnectEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectErrorEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectErrorEvent;
			return soap_in_ns5__PeerConnectErrorEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectBusyEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectBusyEvent;
			return soap_in_ns5__PeerConnectBusyEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:InviteNetworkNotification"))
		{	*type = SOAP_TYPE_ns4__InviteNetworkNotification;
			return soap_in_ns4__InviteNetworkNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:DeleteNetworkNotification"))
		{	*type = SOAP_TYPE_ns4__DeleteNetworkNotification;
			return soap_in_ns4__DeleteNetworkNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:NetworkMemberNotification"))
		{	*type = SOAP_TYPE_ns4__NetworkMemberNotification;
			return soap_in_ns4__NetworkMemberNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerEventIndex"))
		{	*type = SOAP_TYPE_ns5__PeerEventIndex;
			return soap_in_ns5__PeerEventIndex(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionEvent"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionEvent;
			return soap_in_ns5__PeerConnectionEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:NotificationIndex"))
		{	*type = SOAP_TYPE_ns4__NotificationIndex;
			return soap_in_ns4__NotificationIndex(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:NetworkNotification"))
		{	*type = SOAP_TYPE_ns4__NetworkNotification;
			return soap_in_ns4__NetworkNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:Usert"))
		{	*type = SOAP_TYPE_ns2__Usert;
			return soap_in_ns2__Usert(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerRegister"))
		{	*type = SOAP_TYPE_ns5__PeerRegister;
			return soap_in_ns5__PeerRegister(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerEventType"))
		{	*type = SOAP_TYPE_ns5__PeerEventType;
			return soap_in_ns5__PeerEventType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionType"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionType;
			return soap_in_ns5__PeerConnectionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionStats"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionStats;
			return soap_in_ns5__PeerConnectionStats(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionState"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionState;
			return soap_in_ns5__PeerConnectionState(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionInfo"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionInfo;
			return soap_in_ns5__PeerConnectionInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionConnectedStatus"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionConnectedStatus;
			return soap_in_ns5__PeerConnectionConnectedStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnectionConnectStatus"))
		{	*type = SOAP_TYPE_ns5__PeerConnectionConnectStatus;
			return soap_in_ns5__PeerConnectionConnectStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerConnection"))
		{	*type = SOAP_TYPE_ns5__PeerConnection;
			return soap_in_ns5__PeerConnection(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerEvent"))
		{	*type = SOAP_TYPE_ns5__PeerEvent;
			return soap_in_ns5__PeerEvent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerAssistAttr"))
		{	*type = SOAP_TYPE_ns5__PeerAssistAttr;
			return soap_in_ns5__PeerAssistAttr(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerAssist"))
		{	*type = SOAP_TYPE_ns5__PeerAssist;
			return soap_in_ns5__PeerAssist(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns5:PeerAccess"))
		{	*type = SOAP_TYPE_ns5__PeerAccess;
			return soap_in_ns5__PeerAccess(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:NotificationType"))
		{	*type = SOAP_TYPE_ns4__NotificationType;
			return soap_in_ns4__NotificationType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:Notification"))
		{	*type = SOAP_TYPE_ns4__Notification;
			return soap_in_ns4__Notification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:Vector"))
		{	*type = SOAP_TYPE_ns3__Vector;
			return soap_in_ns3__Vector(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:UserStats"))
		{	*type = SOAP_TYPE_ns2__UserStats;
			return soap_in_ns2__UserStats(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:UserAttr"))
		{	*type = SOAP_TYPE_ns2__UserAttr;
			return soap_in_ns2__UserAttr(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:SystemNotification"))
		{	*type = SOAP_TYPE_ns2__SystemNotification;
			return soap_in_ns2__SystemNotification(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:IPAttr"))
		{	*type = SOAP_TYPE_ns2__IPAttr;
			return soap_in_ns2__IPAttr(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:IPAddress"))
		{	*type = SOAP_TYPE_ns2__IPAddress;
			return soap_in_ns2__IPAddress(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:User"))
		{	*type = SOAP_TYPE_ns2__User;
			return soap_in_ns2__User(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:Member"))
		{	*type = SOAP_TYPE_ns2__Member;
			return soap_in_ns2__Member(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:anyType"))
		{	*type = SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType;
			return soap_in_ArrayOf_USCORExsd_USCOREanyType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:Network"))
		{	*type = SOAP_TYPE_ns2__Network;
			return soap_in_ns2__Network(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:Contact"))
		{	*type = SOAP_TYPE_ns2__Contact;
			return soap_in_ns2__Contact(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_ns1__getSystemNotifications:
		return soap_out_ns1__getSystemNotifications(soap, tag, id, (const struct ns1__getSystemNotifications *)ptr, "ns1:getSystemNotifications");
	case SOAP_TYPE_ns1__getSystemNotificationsResponse:
		return soap_out_ns1__getSystemNotificationsResponse(soap, tag, id, (const struct ns1__getSystemNotificationsResponse *)ptr, "ns1:getSystemNotificationsResponse");
	case SOAP_TYPE_ns1__getNotifications:
		return soap_out_ns1__getNotifications(soap, tag, id, (const struct ns1__getNotifications *)ptr, "ns1:getNotifications");
	case SOAP_TYPE_ns1__getNotificationsResponse:
		return soap_out_ns1__getNotificationsResponse(soap, tag, id, (const struct ns1__getNotificationsResponse *)ptr, "ns1:getNotificationsResponse");
	case SOAP_TYPE_ns1__getNetwork:
		return soap_out_ns1__getNetwork(soap, tag, id, (const struct ns1__getNetwork *)ptr, "ns1:getNetwork");
	case SOAP_TYPE_ns1__getNetworkResponse:
		return soap_out_ns1__getNetworkResponse(soap, tag, id, (const struct ns1__getNetworkResponse *)ptr, "ns1:getNetworkResponse");
	case SOAP_TYPE_ns1__getNetworks:
		return soap_out_ns1__getNetworks(soap, tag, id, (const struct ns1__getNetworks *)ptr, "ns1:getNetworks");
	case SOAP_TYPE_ns1__getNetworksResponse:
		return soap_out_ns1__getNetworksResponse(soap, tag, id, (const struct ns1__getNetworksResponse *)ptr, "ns1:getNetworksResponse");
	case SOAP_TYPE_ns1__leaveNetwork:
		return soap_out_ns1__leaveNetwork(soap, tag, id, (const struct ns1__leaveNetwork *)ptr, "ns1:leaveNetwork");
	case SOAP_TYPE_ns1__leaveNetworkResponse:
		return soap_out_ns1__leaveNetworkResponse(soap, tag, id, (const struct ns1__leaveNetworkResponse *)ptr, "ns1:leaveNetworkResponse");
	case SOAP_TYPE_ns1__deleteNetworkMember:
		return soap_out_ns1__deleteNetworkMember(soap, tag, id, (const struct ns1__deleteNetworkMember *)ptr, "ns1:deleteNetworkMember");
	case SOAP_TYPE_ns1__deleteNetworkMemberResponse:
		return soap_out_ns1__deleteNetworkMemberResponse(soap, tag, id, (const struct ns1__deleteNetworkMemberResponse *)ptr, "ns1:deleteNetworkMemberResponse");
	case SOAP_TYPE_ns1__declineNetworkInvite:
		return soap_out_ns1__declineNetworkInvite(soap, tag, id, (const struct ns1__declineNetworkInvite *)ptr, "ns1:declineNetworkInvite");
	case SOAP_TYPE_ns1__declineNetworkInviteResponse:
		return soap_out_ns1__declineNetworkInviteResponse(soap, tag, id, (const struct ns1__declineNetworkInviteResponse *)ptr, "ns1:declineNetworkInviteResponse");
	case SOAP_TYPE_ns1__acceptNetworkInvite:
		return soap_out_ns1__acceptNetworkInvite(soap, tag, id, (const struct ns1__acceptNetworkInvite *)ptr, "ns1:acceptNetworkInvite");
	case SOAP_TYPE_ns1__acceptNetworkInviteResponse:
		return soap_out_ns1__acceptNetworkInviteResponse(soap, tag, id, (const struct ns1__acceptNetworkInviteResponse *)ptr, "ns1:acceptNetworkInviteResponse");
	case SOAP_TYPE_ns1__inviteNetworkMemberByUser:
		return soap_out_ns1__inviteNetworkMemberByUser(soap, tag, id, (const struct ns1__inviteNetworkMemberByUser *)ptr, "ns1:inviteNetworkMemberByUser");
	case SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse:
		return soap_out_ns1__inviteNetworkMemberByUserResponse(soap, tag, id, (const struct ns1__inviteNetworkMemberByUserResponse *)ptr, "ns1:inviteNetworkMemberByUserResponse");
	case SOAP_TYPE_ns1__inviteNetworkMemberByEmail:
		return soap_out_ns1__inviteNetworkMemberByEmail(soap, tag, id, (const struct ns1__inviteNetworkMemberByEmail *)ptr, "ns1:inviteNetworkMemberByEmail");
	case SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse:
		return soap_out_ns1__inviteNetworkMemberByEmailResponse(soap, tag, id, (const struct ns1__inviteNetworkMemberByEmailResponse *)ptr, "ns1:inviteNetworkMemberByEmailResponse");
	case SOAP_TYPE_ns1__inviteNetworkMember:
		return soap_out_ns1__inviteNetworkMember(soap, tag, id, (const struct ns1__inviteNetworkMember *)ptr, "ns1:inviteNetworkMember");
	case SOAP_TYPE_ns1__inviteNetworkMemberResponse:
		return soap_out_ns1__inviteNetworkMemberResponse(soap, tag, id, (const struct ns1__inviteNetworkMemberResponse *)ptr, "ns1:inviteNetworkMemberResponse");
	case SOAP_TYPE_ns1__deleteNetwork:
		return soap_out_ns1__deleteNetwork(soap, tag, id, (const struct ns1__deleteNetwork *)ptr, "ns1:deleteNetwork");
	case SOAP_TYPE_ns1__deleteNetworkResponse:
		return soap_out_ns1__deleteNetworkResponse(soap, tag, id, (const struct ns1__deleteNetworkResponse *)ptr, "ns1:deleteNetworkResponse");
	case SOAP_TYPE_ns1__addNetwork:
		return soap_out_ns1__addNetwork(soap, tag, id, (const struct ns1__addNetwork *)ptr, "ns1:addNetwork");
	case SOAP_TYPE_ns1__addNetworkResponse:
		return soap_out_ns1__addNetworkResponse(soap, tag, id, (const struct ns1__addNetworkResponse *)ptr, "ns1:addNetworkResponse");
	case SOAP_TYPE_ns1__lookupContacts:
		return soap_out_ns1__lookupContacts(soap, tag, id, (const struct ns1__lookupContacts *)ptr, "ns1:lookupContacts");
	case SOAP_TYPE_ns1__lookupContactsResponse:
		return soap_out_ns1__lookupContactsResponse(soap, tag, id, (const struct ns1__lookupContactsResponse *)ptr, "ns1:lookupContactsResponse");
	case SOAP_TYPE_ns1__getContact:
		return soap_out_ns1__getContact(soap, tag, id, (const struct ns1__getContact *)ptr, "ns1:getContact");
	case SOAP_TYPE_ns1__getContactResponse:
		return soap_out_ns1__getContactResponse(soap, tag, id, (const struct ns1__getContactResponse *)ptr, "ns1:getContactResponse");
	case SOAP_TYPE_ns1__updateContact:
		return soap_out_ns1__updateContact(soap, tag, id, (const struct ns1__updateContact *)ptr, "ns1:updateContact");
	case SOAP_TYPE_ns1__updateContactResponse:
		return soap_out_ns1__updateContactResponse(soap, tag, id, (const struct ns1__updateContactResponse *)ptr, "ns1:updateContactResponse");
	case SOAP_TYPE_ns1__changePassword:
		return soap_out_ns1__changePassword(soap, tag, id, (const struct ns1__changePassword *)ptr, "ns1:changePassword");
	case SOAP_TYPE_ns1__changePasswordResponse:
		return soap_out_ns1__changePasswordResponse(soap, tag, id, (const struct ns1__changePasswordResponse *)ptr, "ns1:changePasswordResponse");
	case SOAP_TYPE_ns1__deleteUser:
		return soap_out_ns1__deleteUser(soap, tag, id, (const struct ns1__deleteUser *)ptr, "ns1:deleteUser");
	case SOAP_TYPE_ns1__deleteUserResponse:
		return soap_out_ns1__deleteUserResponse(soap, tag, id, (const struct ns1__deleteUserResponse *)ptr, "ns1:deleteUserResponse");
	case SOAP_TYPE_ns1__vrfyLogin:
		return soap_out_ns1__vrfyLogin(soap, tag, id, (const struct ns1__vrfyLogin *)ptr, "ns1:vrfyLogin");
	case SOAP_TYPE_ns1__vrfyLoginResponse:
		return soap_out_ns1__vrfyLoginResponse(soap, tag, id, (const struct ns1__vrfyLoginResponse *)ptr, "ns1:vrfyLoginResponse");
	case SOAP_TYPE_ns4__UpdateMemberContactNotification:
		return soap_out_ns4__UpdateMemberContactNotification(soap, tag, id, (const struct ns4__UpdateMemberContactNotification *)ptr, "ns4:UpdateMemberContactNotification");
	case SOAP_TYPE_ns4__SignupNetworkMemberNotification:
		return soap_out_ns4__SignupNetworkMemberNotification(soap, tag, id, (const struct ns4__SignupNetworkMemberNotification *)ptr, "ns4:SignupNetworkMemberNotification");
	case SOAP_TYPE_ns4__DeleteNetworkMemberNotification:
		return soap_out_ns4__DeleteNetworkMemberNotification(soap, tag, id, (const struct ns4__DeleteNetworkMemberNotification *)ptr, "ns4:DeleteNetworkMemberNotification");
	case SOAP_TYPE_ns4__DeclineNetworkInviteNotification:
		return soap_out_ns4__DeclineNetworkInviteNotification(soap, tag, id, (const struct ns4__DeclineNetworkInviteNotification *)ptr, "ns4:DeclineNetworkInviteNotification");
	case SOAP_TYPE_ns4__AddNetworkMemberNotification:
		return soap_out_ns4__AddNetworkMemberNotification(soap, tag, id, (const struct ns4__AddNetworkMemberNotification *)ptr, "ns4:AddNetworkMemberNotification");
	case SOAP_TYPE_ns5__PeerSynPktEvent:
		return soap_out_ns5__PeerSynPktEvent(soap, tag, id, (const struct ns5__PeerSynPktEvent *)ptr, "ns5:PeerSynPktEvent");
	case SOAP_TYPE_ns5__PeerDisconnectedEvent:
		return soap_out_ns5__PeerDisconnectedEvent(soap, tag, id, (const struct ns5__PeerDisconnectedEvent *)ptr, "ns5:PeerDisconnectedEvent");
	case SOAP_TYPE_ns5__PeerConnectedEvent:
		return soap_out_ns5__PeerConnectedEvent(soap, tag, id, (const struct ns5__PeerConnectedEvent *)ptr, "ns5:PeerConnectedEvent");
	case SOAP_TYPE_ns5__PeerConnectRequestEvent:
		return soap_out_ns5__PeerConnectRequestEvent(soap, tag, id, (const struct ns5__PeerConnectRequestEvent *)ptr, "ns5:PeerConnectRequestEvent");
	case SOAP_TYPE_ns5__PeerConnectRejectEvent:
		return soap_out_ns5__PeerConnectRejectEvent(soap, tag, id, (const struct ns5__PeerConnectRejectEvent *)ptr, "ns5:PeerConnectRejectEvent");
	case SOAP_TYPE_ns5__PeerConnectEvent:
		return soap_out_ns5__PeerConnectEvent(soap, tag, id, (const struct ns5__PeerConnectEvent *)ptr, "ns5:PeerConnectEvent");
	case SOAP_TYPE_ns5__PeerConnectErrorEvent:
		return soap_out_ns5__PeerConnectErrorEvent(soap, tag, id, (const struct ns5__PeerConnectErrorEvent *)ptr, "ns5:PeerConnectErrorEvent");
	case SOAP_TYPE_ns5__PeerConnectBusyEvent:
		return soap_out_ns5__PeerConnectBusyEvent(soap, tag, id, (const struct ns5__PeerConnectBusyEvent *)ptr, "ns5:PeerConnectBusyEvent");
	case SOAP_TYPE_ns4__InviteNetworkNotification:
		return soap_out_ns4__InviteNetworkNotification(soap, tag, id, (const struct ns4__InviteNetworkNotification *)ptr, "ns4:InviteNetworkNotification");
	case SOAP_TYPE_ns4__DeleteNetworkNotification:
		return soap_out_ns4__DeleteNetworkNotification(soap, tag, id, (const struct ns4__DeleteNetworkNotification *)ptr, "ns4:DeleteNetworkNotification");
	case SOAP_TYPE_ns4__NetworkMemberNotification:
		return soap_out_ns4__NetworkMemberNotification(soap, tag, id, (const struct ns4__NetworkMemberNotification *)ptr, "ns4:NetworkMemberNotification");
	case SOAP_TYPE_ns5__PeerEventIndex:
		return soap_out_ns5__PeerEventIndex(soap, tag, id, (const struct ns5__PeerEventIndex *)ptr, "ns5:PeerEventIndex");
	case SOAP_TYPE_ns5__PeerConnectionEvent:
		return soap_out_ns5__PeerConnectionEvent(soap, tag, id, (const struct ns5__PeerConnectionEvent *)ptr, "ns5:PeerConnectionEvent");
	case SOAP_TYPE_ns4__NotificationIndex:
		return soap_out_ns4__NotificationIndex(soap, tag, id, (const struct ns4__NotificationIndex *)ptr, "ns4:NotificationIndex");
	case SOAP_TYPE_ns4__NetworkNotification:
		return soap_out_ns4__NetworkNotification(soap, tag, id, (const struct ns4__NetworkNotification *)ptr, "ns4:NetworkNotification");
	case SOAP_TYPE_ns2__Usert:
		return soap_out_ns2__Usert(soap, tag, id, (const struct ns2__Usert *)ptr, "ns2:Usert");
	case SOAP_TYPE_ns5__PeerRegister:
		return soap_out_ns5__PeerRegister(soap, tag, id, (const struct ns5__PeerRegister *)ptr, "ns5:PeerRegister");
	case SOAP_TYPE_ns5__PeerEventType:
		return soap_out_ns5__PeerEventType(soap, tag, id, (const struct ns5__PeerEventType *)ptr, "ns5:PeerEventType");
	case SOAP_TYPE_ns5__PeerConnectionType:
		return soap_out_ns5__PeerConnectionType(soap, tag, id, (const struct ns5__PeerConnectionType *)ptr, "ns5:PeerConnectionType");
	case SOAP_TYPE_ns5__PeerConnectionStats:
		return soap_out_ns5__PeerConnectionStats(soap, tag, id, (const struct ns5__PeerConnectionStats *)ptr, "ns5:PeerConnectionStats");
	case SOAP_TYPE_ns5__PeerConnectionState:
		return soap_out_ns5__PeerConnectionState(soap, tag, id, (const struct ns5__PeerConnectionState *)ptr, "ns5:PeerConnectionState");
	case SOAP_TYPE_ns5__PeerConnectionInfo:
		return soap_out_ns5__PeerConnectionInfo(soap, tag, id, (const struct ns5__PeerConnectionInfo *)ptr, "ns5:PeerConnectionInfo");
	case SOAP_TYPE_ns5__PeerConnectionConnectedStatus:
		return soap_out_ns5__PeerConnectionConnectedStatus(soap, tag, id, (const struct ns5__PeerConnectionConnectedStatus *)ptr, "ns5:PeerConnectionConnectedStatus");
	case SOAP_TYPE_ns5__PeerConnectionConnectStatus:
		return soap_out_ns5__PeerConnectionConnectStatus(soap, tag, id, (const struct ns5__PeerConnectionConnectStatus *)ptr, "ns5:PeerConnectionConnectStatus");
	case SOAP_TYPE_ns5__PeerConnection:
		return soap_out_ns5__PeerConnection(soap, tag, id, (const struct ns5__PeerConnection *)ptr, "ns5:PeerConnection");
	case SOAP_TYPE_ns5__PeerEvent:
		return soap_out_ns5__PeerEvent(soap, tag, id, (const struct ns5__PeerEvent *)ptr, "ns5:PeerEvent");
	case SOAP_TYPE_ns5__PeerAssistAttr:
		return soap_out_ns5__PeerAssistAttr(soap, tag, id, (const struct ns5__PeerAssistAttr *)ptr, "ns5:PeerAssistAttr");
	case SOAP_TYPE_ns5__PeerAssist:
		return soap_out_ns5__PeerAssist(soap, tag, id, (const struct ns5__PeerAssist *)ptr, "ns5:PeerAssist");
	case SOAP_TYPE_ns5__PeerAccess:
		return soap_out_ns5__PeerAccess(soap, tag, id, (const struct ns5__PeerAccess *)ptr, "ns5:PeerAccess");
	case SOAP_TYPE_ns4__NotificationType:
		return soap_out_ns4__NotificationType(soap, tag, id, (const struct ns4__NotificationType *)ptr, "ns4:NotificationType");
	case SOAP_TYPE_ns4__Notification:
		return soap_out_ns4__Notification(soap, tag, id, (const struct ns4__Notification *)ptr, "ns4:Notification");
	case SOAP_TYPE_ns3__Vector:
		return soap_out_ns3__Vector(soap, tag, id, (const struct ns3__Vector *)ptr, "ns3:Vector");
	case SOAP_TYPE_ns2__UserStats:
		return soap_out_ns2__UserStats(soap, tag, id, (const struct ns2__UserStats *)ptr, "ns2:UserStats");
	case SOAP_TYPE_ns2__UserAttr:
		return soap_out_ns2__UserAttr(soap, tag, id, (const struct ns2__UserAttr *)ptr, "ns2:UserAttr");
	case SOAP_TYPE_ns2__SystemNotification:
		return soap_out_ns2__SystemNotification(soap, tag, id, (const struct ns2__SystemNotification *)ptr, "ns2:SystemNotification");
	case SOAP_TYPE_ns2__IPAttr:
		return soap_out_ns2__IPAttr(soap, tag, id, (const struct ns2__IPAttr *)ptr, "ns2:IPAttr");
	case SOAP_TYPE_ns2__IPAddress:
		return soap_out_ns2__IPAddress(soap, tag, id, (const struct ns2__IPAddress *)ptr, "ns2:IPAddress");
	case SOAP_TYPE_ns2__User:
		return soap_out_ns2__User(soap, tag, id, (const struct ns2__User *)ptr, "ns2:User");
	case SOAP_TYPE_ns2__Member:
		return soap_out_ns2__Member(soap, tag, id, (const struct ns2__Member *)ptr, "ns2:Member");
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType:
		return soap_out_ArrayOf_USCORExsd_USCOREanyType(soap, tag, id, (const struct ArrayOf_USCORExsd_USCOREanyType *)ptr, "xsd:anyType");
	case SOAP_TYPE_ns2__Network:
		return soap_out_ns2__Network(soap, tag, id, (const struct ns2__Network *)ptr, "ns2:Network");
	case SOAP_TYPE_ns2__Contact:
		return soap_out_ns2__Contact(soap, tag, id, (const struct ns2__Contact *)ptr, "ns2:Contact");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTons1__getSystemNotificationsResponse:
		return soap_out_PointerTons1__getSystemNotificationsResponse(soap, tag, id, (struct ns1__getSystemNotificationsResponse *const*)ptr, "ns1:getSystemNotificationsResponse");
	case SOAP_TYPE_PointerTons1__getNotificationsResponse:
		return soap_out_PointerTons1__getNotificationsResponse(soap, tag, id, (struct ns1__getNotificationsResponse *const*)ptr, "ns1:getNotificationsResponse");
	case SOAP_TYPE_PointerTons1__getNetworkResponse:
		return soap_out_PointerTons1__getNetworkResponse(soap, tag, id, (struct ns1__getNetworkResponse *const*)ptr, "ns1:getNetworkResponse");
	case SOAP_TYPE_PointerTons1__getNetworksResponse:
		return soap_out_PointerTons1__getNetworksResponse(soap, tag, id, (struct ns1__getNetworksResponse *const*)ptr, "ns1:getNetworksResponse");
	case SOAP_TYPE_PointerTons1__leaveNetworkResponse:
		return soap_out_PointerTons1__leaveNetworkResponse(soap, tag, id, (struct ns1__leaveNetworkResponse *const*)ptr, "ns1:leaveNetworkResponse");
	case SOAP_TYPE_PointerTons1__deleteNetworkMemberResponse:
		return soap_out_PointerTons1__deleteNetworkMemberResponse(soap, tag, id, (struct ns1__deleteNetworkMemberResponse *const*)ptr, "ns1:deleteNetworkMemberResponse");
	case SOAP_TYPE_PointerTons1__declineNetworkInviteResponse:
		return soap_out_PointerTons1__declineNetworkInviteResponse(soap, tag, id, (struct ns1__declineNetworkInviteResponse *const*)ptr, "ns1:declineNetworkInviteResponse");
	case SOAP_TYPE_PointerTons1__acceptNetworkInviteResponse:
		return soap_out_PointerTons1__acceptNetworkInviteResponse(soap, tag, id, (struct ns1__acceptNetworkInviteResponse *const*)ptr, "ns1:acceptNetworkInviteResponse");
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberByUserResponse:
		return soap_out_PointerTons1__inviteNetworkMemberByUserResponse(soap, tag, id, (struct ns1__inviteNetworkMemberByUserResponse *const*)ptr, "ns1:inviteNetworkMemberByUserResponse");
	case SOAP_TYPE_PointerTons2__User:
		return soap_out_PointerTons2__User(soap, tag, id, (struct ns2__User *const*)ptr, "ns2:User");
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberByEmailResponse:
		return soap_out_PointerTons1__inviteNetworkMemberByEmailResponse(soap, tag, id, (struct ns1__inviteNetworkMemberByEmailResponse *const*)ptr, "ns1:inviteNetworkMemberByEmailResponse");
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberResponse:
		return soap_out_PointerTons1__inviteNetworkMemberResponse(soap, tag, id, (struct ns1__inviteNetworkMemberResponse *const*)ptr, "ns1:inviteNetworkMemberResponse");
	case SOAP_TYPE_PointerTons2__Member:
		return soap_out_PointerTons2__Member(soap, tag, id, (struct ns2__Member *const*)ptr, "ns2:Member");
	case SOAP_TYPE_PointerTons1__deleteNetworkResponse:
		return soap_out_PointerTons1__deleteNetworkResponse(soap, tag, id, (struct ns1__deleteNetworkResponse *const*)ptr, "ns1:deleteNetworkResponse");
	case SOAP_TYPE_PointerTons1__addNetworkResponse:
		return soap_out_PointerTons1__addNetworkResponse(soap, tag, id, (struct ns1__addNetworkResponse *const*)ptr, "ns1:addNetworkResponse");
	case SOAP_TYPE_PointerTons2__Network:
		return soap_out_PointerTons2__Network(soap, tag, id, (struct ns2__Network *const*)ptr, "ns2:Network");
	case SOAP_TYPE_PointerTons1__lookupContactsResponse:
		return soap_out_PointerTons1__lookupContactsResponse(soap, tag, id, (struct ns1__lookupContactsResponse *const*)ptr, "ns1:lookupContactsResponse");
	case SOAP_TYPE_PointerTons1__getContactResponse:
		return soap_out_PointerTons1__getContactResponse(soap, tag, id, (struct ns1__getContactResponse *const*)ptr, "ns1:getContactResponse");
	case SOAP_TYPE_PointerTons1__updateContactResponse:
		return soap_out_PointerTons1__updateContactResponse(soap, tag, id, (struct ns1__updateContactResponse *const*)ptr, "ns1:updateContactResponse");
	case SOAP_TYPE_PointerTons2__Contact:
		return soap_out_PointerTons2__Contact(soap, tag, id, (struct ns2__Contact *const*)ptr, "ns2:Contact");
	case SOAP_TYPE_PointerTons1__changePasswordResponse:
		return soap_out_PointerTons1__changePasswordResponse(soap, tag, id, (struct ns1__changePasswordResponse *const*)ptr, "ns1:changePasswordResponse");
	case SOAP_TYPE_PointerTons1__deleteUserResponse:
		return soap_out_PointerTons1__deleteUserResponse(soap, tag, id, (struct ns1__deleteUserResponse *const*)ptr, "ns1:deleteUserResponse");
	case SOAP_TYPE_PointerTons1__vrfyLoginResponse:
		return soap_out_PointerTons1__vrfyLoginResponse(soap, tag, id, (struct ns1__vrfyLoginResponse *const*)ptr, "ns1:vrfyLoginResponse");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (struct xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTotime:
		return soap_out_PointerTotime(soap, tag, id, (time_t *const*)ptr, "xsd:dateTime");
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREanyType:
		return soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, tag, id, (struct ArrayOf_USCORExsd_USCOREanyType *const*)ptr, "ArrayOf_xsd_anyType");
	case SOAP_TYPE_PointerToLONG64:
		return soap_out_PointerToLONG64(soap, tag, id, (LONG64 *const*)ptr, "xsd:long");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_ns1__getSystemNotifications:
		soap_serialize_ns1__getSystemNotifications(soap, (const struct ns1__getSystemNotifications *)ptr);
		break;
	case SOAP_TYPE_ns1__getSystemNotificationsResponse:
		soap_serialize_ns1__getSystemNotificationsResponse(soap, (const struct ns1__getSystemNotificationsResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__getNotifications:
		soap_serialize_ns1__getNotifications(soap, (const struct ns1__getNotifications *)ptr);
		break;
	case SOAP_TYPE_ns1__getNotificationsResponse:
		soap_serialize_ns1__getNotificationsResponse(soap, (const struct ns1__getNotificationsResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__getNetwork:
		soap_serialize_ns1__getNetwork(soap, (const struct ns1__getNetwork *)ptr);
		break;
	case SOAP_TYPE_ns1__getNetworkResponse:
		soap_serialize_ns1__getNetworkResponse(soap, (const struct ns1__getNetworkResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__getNetworks:
		soap_serialize_ns1__getNetworks(soap, (const struct ns1__getNetworks *)ptr);
		break;
	case SOAP_TYPE_ns1__getNetworksResponse:
		soap_serialize_ns1__getNetworksResponse(soap, (const struct ns1__getNetworksResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__leaveNetwork:
		soap_serialize_ns1__leaveNetwork(soap, (const struct ns1__leaveNetwork *)ptr);
		break;
	case SOAP_TYPE_ns1__leaveNetworkResponse:
		soap_serialize_ns1__leaveNetworkResponse(soap, (const struct ns1__leaveNetworkResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__deleteNetworkMember:
		soap_serialize_ns1__deleteNetworkMember(soap, (const struct ns1__deleteNetworkMember *)ptr);
		break;
	case SOAP_TYPE_ns1__deleteNetworkMemberResponse:
		soap_serialize_ns1__deleteNetworkMemberResponse(soap, (const struct ns1__deleteNetworkMemberResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__declineNetworkInvite:
		soap_serialize_ns1__declineNetworkInvite(soap, (const struct ns1__declineNetworkInvite *)ptr);
		break;
	case SOAP_TYPE_ns1__declineNetworkInviteResponse:
		soap_serialize_ns1__declineNetworkInviteResponse(soap, (const struct ns1__declineNetworkInviteResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__acceptNetworkInvite:
		soap_serialize_ns1__acceptNetworkInvite(soap, (const struct ns1__acceptNetworkInvite *)ptr);
		break;
	case SOAP_TYPE_ns1__acceptNetworkInviteResponse:
		soap_serialize_ns1__acceptNetworkInviteResponse(soap, (const struct ns1__acceptNetworkInviteResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__inviteNetworkMemberByUser:
		soap_serialize_ns1__inviteNetworkMemberByUser(soap, (const struct ns1__inviteNetworkMemberByUser *)ptr);
		break;
	case SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse:
		soap_serialize_ns1__inviteNetworkMemberByUserResponse(soap, (const struct ns1__inviteNetworkMemberByUserResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__inviteNetworkMemberByEmail:
		soap_serialize_ns1__inviteNetworkMemberByEmail(soap, (const struct ns1__inviteNetworkMemberByEmail *)ptr);
		break;
	case SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse:
		soap_serialize_ns1__inviteNetworkMemberByEmailResponse(soap, (const struct ns1__inviteNetworkMemberByEmailResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__inviteNetworkMember:
		soap_serialize_ns1__inviteNetworkMember(soap, (const struct ns1__inviteNetworkMember *)ptr);
		break;
	case SOAP_TYPE_ns1__inviteNetworkMemberResponse:
		soap_serialize_ns1__inviteNetworkMemberResponse(soap, (const struct ns1__inviteNetworkMemberResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__deleteNetwork:
		soap_serialize_ns1__deleteNetwork(soap, (const struct ns1__deleteNetwork *)ptr);
		break;
	case SOAP_TYPE_ns1__deleteNetworkResponse:
		soap_serialize_ns1__deleteNetworkResponse(soap, (const struct ns1__deleteNetworkResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__addNetwork:
		soap_serialize_ns1__addNetwork(soap, (const struct ns1__addNetwork *)ptr);
		break;
	case SOAP_TYPE_ns1__addNetworkResponse:
		soap_serialize_ns1__addNetworkResponse(soap, (const struct ns1__addNetworkResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__lookupContacts:
		soap_serialize_ns1__lookupContacts(soap, (const struct ns1__lookupContacts *)ptr);
		break;
	case SOAP_TYPE_ns1__lookupContactsResponse:
		soap_serialize_ns1__lookupContactsResponse(soap, (const struct ns1__lookupContactsResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__getContact:
		soap_serialize_ns1__getContact(soap, (const struct ns1__getContact *)ptr);
		break;
	case SOAP_TYPE_ns1__getContactResponse:
		soap_serialize_ns1__getContactResponse(soap, (const struct ns1__getContactResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__updateContact:
		soap_serialize_ns1__updateContact(soap, (const struct ns1__updateContact *)ptr);
		break;
	case SOAP_TYPE_ns1__updateContactResponse:
		soap_serialize_ns1__updateContactResponse(soap, (const struct ns1__updateContactResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__changePassword:
		soap_serialize_ns1__changePassword(soap, (const struct ns1__changePassword *)ptr);
		break;
	case SOAP_TYPE_ns1__changePasswordResponse:
		soap_serialize_ns1__changePasswordResponse(soap, (const struct ns1__changePasswordResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__deleteUser:
		soap_serialize_ns1__deleteUser(soap, (const struct ns1__deleteUser *)ptr);
		break;
	case SOAP_TYPE_ns1__deleteUserResponse:
		soap_serialize_ns1__deleteUserResponse(soap, (const struct ns1__deleteUserResponse *)ptr);
		break;
	case SOAP_TYPE_ns1__vrfyLogin:
		soap_serialize_ns1__vrfyLogin(soap, (const struct ns1__vrfyLogin *)ptr);
		break;
	case SOAP_TYPE_ns1__vrfyLoginResponse:
		soap_serialize_ns1__vrfyLoginResponse(soap, (const struct ns1__vrfyLoginResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__UpdateMemberContactNotification:
		soap_serialize_ns4__UpdateMemberContactNotification(soap, (const struct ns4__UpdateMemberContactNotification *)ptr);
		break;
	case SOAP_TYPE_ns4__SignupNetworkMemberNotification:
		soap_serialize_ns4__SignupNetworkMemberNotification(soap, (const struct ns4__SignupNetworkMemberNotification *)ptr);
		break;
	case SOAP_TYPE_ns4__DeleteNetworkMemberNotification:
		soap_serialize_ns4__DeleteNetworkMemberNotification(soap, (const struct ns4__DeleteNetworkMemberNotification *)ptr);
		break;
	case SOAP_TYPE_ns4__DeclineNetworkInviteNotification:
		soap_serialize_ns4__DeclineNetworkInviteNotification(soap, (const struct ns4__DeclineNetworkInviteNotification *)ptr);
		break;
	case SOAP_TYPE_ns4__AddNetworkMemberNotification:
		soap_serialize_ns4__AddNetworkMemberNotification(soap, (const struct ns4__AddNetworkMemberNotification *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerSynPktEvent:
		soap_serialize_ns5__PeerSynPktEvent(soap, (const struct ns5__PeerSynPktEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerDisconnectedEvent:
		soap_serialize_ns5__PeerDisconnectedEvent(soap, (const struct ns5__PeerDisconnectedEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectedEvent:
		soap_serialize_ns5__PeerConnectedEvent(soap, (const struct ns5__PeerConnectedEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectRequestEvent:
		soap_serialize_ns5__PeerConnectRequestEvent(soap, (const struct ns5__PeerConnectRequestEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectRejectEvent:
		soap_serialize_ns5__PeerConnectRejectEvent(soap, (const struct ns5__PeerConnectRejectEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectEvent:
		soap_serialize_ns5__PeerConnectEvent(soap, (const struct ns5__PeerConnectEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectErrorEvent:
		soap_serialize_ns5__PeerConnectErrorEvent(soap, (const struct ns5__PeerConnectErrorEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectBusyEvent:
		soap_serialize_ns5__PeerConnectBusyEvent(soap, (const struct ns5__PeerConnectBusyEvent *)ptr);
		break;
	case SOAP_TYPE_ns4__InviteNetworkNotification:
		soap_serialize_ns4__InviteNetworkNotification(soap, (const struct ns4__InviteNetworkNotification *)ptr);
		break;
	case SOAP_TYPE_ns4__DeleteNetworkNotification:
		soap_serialize_ns4__DeleteNetworkNotification(soap, (const struct ns4__DeleteNetworkNotification *)ptr);
		break;
	case SOAP_TYPE_ns4__NetworkMemberNotification:
		soap_serialize_ns4__NetworkMemberNotification(soap, (const struct ns4__NetworkMemberNotification *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerEventIndex:
		soap_serialize_ns5__PeerEventIndex(soap, (const struct ns5__PeerEventIndex *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionEvent:
		soap_serialize_ns5__PeerConnectionEvent(soap, (const struct ns5__PeerConnectionEvent *)ptr);
		break;
	case SOAP_TYPE_ns4__NotificationIndex:
		soap_serialize_ns4__NotificationIndex(soap, (const struct ns4__NotificationIndex *)ptr);
		break;
	case SOAP_TYPE_ns4__NetworkNotification:
		soap_serialize_ns4__NetworkNotification(soap, (const struct ns4__NetworkNotification *)ptr);
		break;
	case SOAP_TYPE_ns2__Usert:
		soap_serialize_ns2__Usert(soap, (const struct ns2__Usert *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerRegister:
		soap_serialize_ns5__PeerRegister(soap, (const struct ns5__PeerRegister *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerEventType:
		soap_serialize_ns5__PeerEventType(soap, (const struct ns5__PeerEventType *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionType:
		soap_serialize_ns5__PeerConnectionType(soap, (const struct ns5__PeerConnectionType *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionStats:
		soap_serialize_ns5__PeerConnectionStats(soap, (const struct ns5__PeerConnectionStats *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionState:
		soap_serialize_ns5__PeerConnectionState(soap, (const struct ns5__PeerConnectionState *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionInfo:
		soap_serialize_ns5__PeerConnectionInfo(soap, (const struct ns5__PeerConnectionInfo *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionConnectedStatus:
		soap_serialize_ns5__PeerConnectionConnectedStatus(soap, (const struct ns5__PeerConnectionConnectedStatus *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnectionConnectStatus:
		soap_serialize_ns5__PeerConnectionConnectStatus(soap, (const struct ns5__PeerConnectionConnectStatus *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerConnection:
		soap_serialize_ns5__PeerConnection(soap, (const struct ns5__PeerConnection *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerEvent:
		soap_serialize_ns5__PeerEvent(soap, (const struct ns5__PeerEvent *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerAssistAttr:
		soap_serialize_ns5__PeerAssistAttr(soap, (const struct ns5__PeerAssistAttr *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerAssist:
		soap_serialize_ns5__PeerAssist(soap, (const struct ns5__PeerAssist *)ptr);
		break;
	case SOAP_TYPE_ns5__PeerAccess:
		soap_serialize_ns5__PeerAccess(soap, (const struct ns5__PeerAccess *)ptr);
		break;
	case SOAP_TYPE_ns4__NotificationType:
		soap_serialize_ns4__NotificationType(soap, (const struct ns4__NotificationType *)ptr);
		break;
	case SOAP_TYPE_ns4__Notification:
		soap_serialize_ns4__Notification(soap, (const struct ns4__Notification *)ptr);
		break;
	case SOAP_TYPE_ns3__Vector:
		soap_serialize_ns3__Vector(soap, (const struct ns3__Vector *)ptr);
		break;
	case SOAP_TYPE_ns2__UserStats:
		soap_serialize_ns2__UserStats(soap, (const struct ns2__UserStats *)ptr);
		break;
	case SOAP_TYPE_ns2__UserAttr:
		soap_serialize_ns2__UserAttr(soap, (const struct ns2__UserAttr *)ptr);
		break;
	case SOAP_TYPE_ns2__SystemNotification:
		soap_serialize_ns2__SystemNotification(soap, (const struct ns2__SystemNotification *)ptr);
		break;
	case SOAP_TYPE_ns2__IPAttr:
		soap_serialize_ns2__IPAttr(soap, (const struct ns2__IPAttr *)ptr);
		break;
	case SOAP_TYPE_ns2__IPAddress:
		soap_serialize_ns2__IPAddress(soap, (const struct ns2__IPAddress *)ptr);
		break;
	case SOAP_TYPE_ns2__User:
		soap_serialize_ns2__User(soap, (const struct ns2__User *)ptr);
		break;
	case SOAP_TYPE_ns2__Member:
		soap_serialize_ns2__Member(soap, (const struct ns2__Member *)ptr);
		break;
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType:
		soap_serialize_ArrayOf_USCORExsd_USCOREanyType(soap, (const struct ArrayOf_USCORExsd_USCOREanyType *)ptr);
		break;
	case SOAP_TYPE_ns2__Network:
		soap_serialize_ns2__Network(soap, (const struct ns2__Network *)ptr);
		break;
	case SOAP_TYPE_ns2__Contact:
		soap_serialize_ns2__Contact(soap, (const struct ns2__Contact *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_PointerTons1__getSystemNotificationsResponse:
		soap_serialize_PointerTons1__getSystemNotificationsResponse(soap, (struct ns1__getSystemNotificationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__getNotificationsResponse:
		soap_serialize_PointerTons1__getNotificationsResponse(soap, (struct ns1__getNotificationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__getNetworkResponse:
		soap_serialize_PointerTons1__getNetworkResponse(soap, (struct ns1__getNetworkResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__getNetworksResponse:
		soap_serialize_PointerTons1__getNetworksResponse(soap, (struct ns1__getNetworksResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__leaveNetworkResponse:
		soap_serialize_PointerTons1__leaveNetworkResponse(soap, (struct ns1__leaveNetworkResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__deleteNetworkMemberResponse:
		soap_serialize_PointerTons1__deleteNetworkMemberResponse(soap, (struct ns1__deleteNetworkMemberResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__declineNetworkInviteResponse:
		soap_serialize_PointerTons1__declineNetworkInviteResponse(soap, (struct ns1__declineNetworkInviteResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__acceptNetworkInviteResponse:
		soap_serialize_PointerTons1__acceptNetworkInviteResponse(soap, (struct ns1__acceptNetworkInviteResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberByUserResponse:
		soap_serialize_PointerTons1__inviteNetworkMemberByUserResponse(soap, (struct ns1__inviteNetworkMemberByUserResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__User:
		soap_serialize_PointerTons2__User(soap, (struct ns2__User *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberByEmailResponse:
		soap_serialize_PointerTons1__inviteNetworkMemberByEmailResponse(soap, (struct ns1__inviteNetworkMemberByEmailResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__inviteNetworkMemberResponse:
		soap_serialize_PointerTons1__inviteNetworkMemberResponse(soap, (struct ns1__inviteNetworkMemberResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__Member:
		soap_serialize_PointerTons2__Member(soap, (struct ns2__Member *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__deleteNetworkResponse:
		soap_serialize_PointerTons1__deleteNetworkResponse(soap, (struct ns1__deleteNetworkResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__addNetworkResponse:
		soap_serialize_PointerTons1__addNetworkResponse(soap, (struct ns1__addNetworkResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__Network:
		soap_serialize_PointerTons2__Network(soap, (struct ns2__Network *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__lookupContactsResponse:
		soap_serialize_PointerTons1__lookupContactsResponse(soap, (struct ns1__lookupContactsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__getContactResponse:
		soap_serialize_PointerTons1__getContactResponse(soap, (struct ns1__getContactResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__updateContactResponse:
		soap_serialize_PointerTons1__updateContactResponse(soap, (struct ns1__updateContactResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__Contact:
		soap_serialize_PointerTons2__Contact(soap, (struct ns2__Contact *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__changePasswordResponse:
		soap_serialize_PointerTons1__changePasswordResponse(soap, (struct ns1__changePasswordResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__deleteUserResponse:
		soap_serialize_PointerTons1__deleteUserResponse(soap, (struct ns1__deleteUserResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__vrfyLoginResponse:
		soap_serialize_PointerTons1__vrfyLoginResponse(soap, (struct ns1__vrfyLoginResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (struct xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotime:
		soap_serialize_PointerTotime(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREanyType:
		soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, (struct ArrayOf_USCORExsd_USCOREanyType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToLONG64:
		soap_serialize_PointerToLONG64(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag_fault = 1;
	size_t soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getSystemNotifications(struct soap *soap, struct ns1__getSystemNotifications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getSystemNotifications(struct soap *soap, const struct ns1__getSystemNotifications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getSystemNotifications(struct soap *soap, const struct ns1__getSystemNotifications *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getSystemNotifications);
	if (soap_out_ns1__getSystemNotifications(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getSystemNotifications(struct soap *soap, const char *tag, int id, const struct ns1__getSystemNotifications *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getSystemNotifications), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getSystemNotifications * SOAP_FMAC4 soap_get_ns1__getSystemNotifications(struct soap *soap, struct ns1__getSystemNotifications *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getSystemNotifications(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getSystemNotifications * SOAP_FMAC4 soap_in_ns1__getSystemNotifications(struct soap *soap, const char *tag, struct ns1__getSystemNotifications *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getSystemNotifications *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getSystemNotifications, sizeof(struct ns1__getSystemNotifications), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getSystemNotifications(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getSystemNotifications *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getSystemNotifications, 0, sizeof(struct ns1__getSystemNotifications), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getSystemNotificationsResponse(struct soap *soap, struct ns1__getSystemNotificationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->getSystemNotificationsReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getSystemNotificationsResponse(struct soap *soap, const struct ns1__getSystemNotificationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->getSystemNotificationsReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getSystemNotificationsResponse(struct soap *soap, const struct ns1__getSystemNotificationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getSystemNotificationsResponse);
	if (soap_out_ns1__getSystemNotificationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getSystemNotificationsResponse(struct soap *soap, const char *tag, int id, const struct ns1__getSystemNotificationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getSystemNotificationsResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "getSystemNotificationsReturn", -1, &a->getSystemNotificationsReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getSystemNotificationsResponse * SOAP_FMAC4 soap_get_ns1__getSystemNotificationsResponse(struct soap *soap, struct ns1__getSystemNotificationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getSystemNotificationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getSystemNotificationsResponse * SOAP_FMAC4 soap_in_ns1__getSystemNotificationsResponse(struct soap *soap, const char *tag, struct ns1__getSystemNotificationsResponse *a, const char *type)
{
	size_t soap_flag_getSystemNotificationsReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getSystemNotificationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getSystemNotificationsResponse, sizeof(struct ns1__getSystemNotificationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getSystemNotificationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_getSystemNotificationsReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "getSystemNotificationsReturn", &a->getSystemNotificationsReturn, ""))
				{	soap_flag_getSystemNotificationsReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getSystemNotificationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getSystemNotificationsResponse, 0, sizeof(struct ns1__getSystemNotificationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getNotifications(struct soap *soap, struct ns1__getNotifications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getNotifications(struct soap *soap, const struct ns1__getNotifications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getNotifications(struct soap *soap, const struct ns1__getNotifications *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getNotifications);
	if (soap_out_ns1__getNotifications(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getNotifications(struct soap *soap, const char *tag, int id, const struct ns1__getNotifications *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getNotifications), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getNotifications * SOAP_FMAC4 soap_get_ns1__getNotifications(struct soap *soap, struct ns1__getNotifications *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getNotifications(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNotifications * SOAP_FMAC4 soap_in_ns1__getNotifications(struct soap *soap, const char *tag, struct ns1__getNotifications *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getNotifications *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getNotifications, sizeof(struct ns1__getNotifications), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getNotifications(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getNotifications *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getNotifications, 0, sizeof(struct ns1__getNotifications), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getNotificationsResponse(struct soap *soap, struct ns1__getNotificationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getNotificationsReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getNotificationsResponse(struct soap *soap, const struct ns1__getNotificationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->_getNotificationsReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getNotificationsResponse(struct soap *soap, const struct ns1__getNotificationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getNotificationsResponse);
	if (soap_out_ns1__getNotificationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getNotificationsResponse(struct soap *soap, const char *tag, int id, const struct ns1__getNotificationsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getNotificationsResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "getNotificationsReturn", -1, &a->_getNotificationsReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getNotificationsResponse * SOAP_FMAC4 soap_get_ns1__getNotificationsResponse(struct soap *soap, struct ns1__getNotificationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getNotificationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNotificationsResponse * SOAP_FMAC4 soap_in_ns1__getNotificationsResponse(struct soap *soap, const char *tag, struct ns1__getNotificationsResponse *a, const char *type)
{
	size_t soap_flag__getNotificationsReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getNotificationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getNotificationsResponse, sizeof(struct ns1__getNotificationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getNotificationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getNotificationsReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, NULL, &a->_getNotificationsReturn, ""))
				{	soap_flag__getNotificationsReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getNotificationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getNotificationsResponse, 0, sizeof(struct ns1__getNotificationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getNetwork(struct soap *soap, struct ns1__getNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getNetwork(struct soap *soap, const struct ns1__getNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getNetwork(struct soap *soap, const struct ns1__getNetwork *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getNetwork);
	if (soap_out_ns1__getNetwork(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getNetwork(struct soap *soap, const char *tag, int id, const struct ns1__getNetwork *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getNetwork), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getNetwork * SOAP_FMAC4 soap_get_ns1__getNetwork(struct soap *soap, struct ns1__getNetwork *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getNetwork(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNetwork * SOAP_FMAC4 soap_in_ns1__getNetwork(struct soap *soap, const char *tag, struct ns1__getNetwork *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getNetwork *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getNetwork, sizeof(struct ns1__getNetwork), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getNetwork(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getNetwork *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getNetwork, 0, sizeof(struct ns1__getNetwork), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getNetworkResponse(struct soap *soap, struct ns1__getNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getNetworkReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getNetworkResponse(struct soap *soap, const struct ns1__getNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Network(soap, &a->_getNetworkReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getNetworkResponse(struct soap *soap, const struct ns1__getNetworkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getNetworkResponse);
	if (soap_out_ns1__getNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getNetworkResponse(struct soap *soap, const char *tag, int id, const struct ns1__getNetworkResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getNetworkResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__Network(soap, "getNetworkReturn", -1, &a->_getNetworkReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getNetworkResponse * SOAP_FMAC4 soap_get_ns1__getNetworkResponse(struct soap *soap, struct ns1__getNetworkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNetworkResponse * SOAP_FMAC4 soap_in_ns1__getNetworkResponse(struct soap *soap, const char *tag, struct ns1__getNetworkResponse *a, const char *type)
{
	size_t soap_flag__getNetworkReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getNetworkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getNetworkResponse, sizeof(struct ns1__getNetworkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getNetworkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getNetworkReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Network(soap, NULL, &a->_getNetworkReturn, "ns2:Network"))
				{	soap_flag__getNetworkReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getNetworkResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getNetworkResponse, 0, sizeof(struct ns1__getNetworkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getNetworks(struct soap *soap, struct ns1__getNetworks *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getNetworks(struct soap *soap, const struct ns1__getNetworks *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getNetworks(struct soap *soap, const struct ns1__getNetworks *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getNetworks);
	if (soap_out_ns1__getNetworks(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getNetworks(struct soap *soap, const char *tag, int id, const struct ns1__getNetworks *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getNetworks), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getNetworks * SOAP_FMAC4 soap_get_ns1__getNetworks(struct soap *soap, struct ns1__getNetworks *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getNetworks(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNetworks * SOAP_FMAC4 soap_in_ns1__getNetworks(struct soap *soap, const char *tag, struct ns1__getNetworks *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getNetworks *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getNetworks, sizeof(struct ns1__getNetworks), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getNetworks(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getNetworks *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getNetworks, 0, sizeof(struct ns1__getNetworks), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getNetworksResponse(struct soap *soap, struct ns1__getNetworksResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getNetworksReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getNetworksResponse(struct soap *soap, const struct ns1__getNetworksResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->_getNetworksReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getNetworksResponse(struct soap *soap, const struct ns1__getNetworksResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getNetworksResponse);
	if (soap_out_ns1__getNetworksResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getNetworksResponse(struct soap *soap, const char *tag, int id, const struct ns1__getNetworksResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getNetworksResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "getNetworksReturn", -1, &a->_getNetworksReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getNetworksResponse * SOAP_FMAC4 soap_get_ns1__getNetworksResponse(struct soap *soap, struct ns1__getNetworksResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getNetworksResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNetworksResponse * SOAP_FMAC4 soap_in_ns1__getNetworksResponse(struct soap *soap, const char *tag, struct ns1__getNetworksResponse *a, const char *type)
{
	size_t soap_flag__getNetworksReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getNetworksResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getNetworksResponse, sizeof(struct ns1__getNetworksResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getNetworksResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getNetworksReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, NULL, &a->_getNetworksReturn, ""))
				{	soap_flag__getNetworksReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getNetworksResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getNetworksResponse, 0, sizeof(struct ns1__getNetworksResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__leaveNetwork(struct soap *soap, struct ns1__leaveNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__leaveNetwork(struct soap *soap, const struct ns1__leaveNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__leaveNetwork(struct soap *soap, const struct ns1__leaveNetwork *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__leaveNetwork);
	if (soap_out_ns1__leaveNetwork(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__leaveNetwork(struct soap *soap, const char *tag, int id, const struct ns1__leaveNetwork *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__leaveNetwork), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__leaveNetwork * SOAP_FMAC4 soap_get_ns1__leaveNetwork(struct soap *soap, struct ns1__leaveNetwork *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__leaveNetwork(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__leaveNetwork * SOAP_FMAC4 soap_in_ns1__leaveNetwork(struct soap *soap, const char *tag, struct ns1__leaveNetwork *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__leaveNetwork *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__leaveNetwork, sizeof(struct ns1__leaveNetwork), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__leaveNetwork(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__leaveNetwork *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__leaveNetwork, 0, sizeof(struct ns1__leaveNetwork), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__leaveNetworkResponse(struct soap *soap, struct ns1__leaveNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__leaveNetworkResponse(struct soap *soap, const struct ns1__leaveNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__leaveNetworkResponse(struct soap *soap, const struct ns1__leaveNetworkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__leaveNetworkResponse);
	if (soap_out_ns1__leaveNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__leaveNetworkResponse(struct soap *soap, const char *tag, int id, const struct ns1__leaveNetworkResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__leaveNetworkResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__leaveNetworkResponse * SOAP_FMAC4 soap_get_ns1__leaveNetworkResponse(struct soap *soap, struct ns1__leaveNetworkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__leaveNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__leaveNetworkResponse * SOAP_FMAC4 soap_in_ns1__leaveNetworkResponse(struct soap *soap, const char *tag, struct ns1__leaveNetworkResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__leaveNetworkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__leaveNetworkResponse, sizeof(struct ns1__leaveNetworkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__leaveNetworkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__leaveNetworkResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__leaveNetworkResponse, 0, sizeof(struct ns1__leaveNetworkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__deleteNetworkMember(struct soap *soap, struct ns1__deleteNetworkMember *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__deleteNetworkMember(struct soap *soap, const struct ns1__deleteNetworkMember *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__deleteNetworkMember(struct soap *soap, const struct ns1__deleteNetworkMember *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__deleteNetworkMember);
	if (soap_out_ns1__deleteNetworkMember(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__deleteNetworkMember(struct soap *soap, const char *tag, int id, const struct ns1__deleteNetworkMember *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__deleteNetworkMember), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__deleteNetworkMember * SOAP_FMAC4 soap_get_ns1__deleteNetworkMember(struct soap *soap, struct ns1__deleteNetworkMember *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__deleteNetworkMember(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteNetworkMember * SOAP_FMAC4 soap_in_ns1__deleteNetworkMember(struct soap *soap, const char *tag, struct ns1__deleteNetworkMember *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__deleteNetworkMember *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__deleteNetworkMember, sizeof(struct ns1__deleteNetworkMember), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__deleteNetworkMember(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteNetworkMember *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__deleteNetworkMember, 0, sizeof(struct ns1__deleteNetworkMember), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__deleteNetworkMemberResponse(struct soap *soap, struct ns1__deleteNetworkMemberResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__deleteNetworkMemberResponse(struct soap *soap, const struct ns1__deleteNetworkMemberResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__deleteNetworkMemberResponse(struct soap *soap, const struct ns1__deleteNetworkMemberResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__deleteNetworkMemberResponse);
	if (soap_out_ns1__deleteNetworkMemberResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__deleteNetworkMemberResponse(struct soap *soap, const char *tag, int id, const struct ns1__deleteNetworkMemberResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__deleteNetworkMemberResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__deleteNetworkMemberResponse * SOAP_FMAC4 soap_get_ns1__deleteNetworkMemberResponse(struct soap *soap, struct ns1__deleteNetworkMemberResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__deleteNetworkMemberResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteNetworkMemberResponse * SOAP_FMAC4 soap_in_ns1__deleteNetworkMemberResponse(struct soap *soap, const char *tag, struct ns1__deleteNetworkMemberResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__deleteNetworkMemberResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__deleteNetworkMemberResponse, sizeof(struct ns1__deleteNetworkMemberResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__deleteNetworkMemberResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteNetworkMemberResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__deleteNetworkMemberResponse, 0, sizeof(struct ns1__deleteNetworkMemberResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__declineNetworkInvite(struct soap *soap, struct ns1__declineNetworkInvite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__declineNetworkInvite(struct soap *soap, const struct ns1__declineNetworkInvite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__declineNetworkInvite(struct soap *soap, const struct ns1__declineNetworkInvite *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__declineNetworkInvite);
	if (soap_out_ns1__declineNetworkInvite(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__declineNetworkInvite(struct soap *soap, const char *tag, int id, const struct ns1__declineNetworkInvite *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__declineNetworkInvite), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__declineNetworkInvite * SOAP_FMAC4 soap_get_ns1__declineNetworkInvite(struct soap *soap, struct ns1__declineNetworkInvite *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__declineNetworkInvite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__declineNetworkInvite * SOAP_FMAC4 soap_in_ns1__declineNetworkInvite(struct soap *soap, const char *tag, struct ns1__declineNetworkInvite *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__declineNetworkInvite *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__declineNetworkInvite, sizeof(struct ns1__declineNetworkInvite), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__declineNetworkInvite(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__declineNetworkInvite *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__declineNetworkInvite, 0, sizeof(struct ns1__declineNetworkInvite), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__declineNetworkInviteResponse(struct soap *soap, struct ns1__declineNetworkInviteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__declineNetworkInviteResponse(struct soap *soap, const struct ns1__declineNetworkInviteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__declineNetworkInviteResponse(struct soap *soap, const struct ns1__declineNetworkInviteResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__declineNetworkInviteResponse);
	if (soap_out_ns1__declineNetworkInviteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__declineNetworkInviteResponse(struct soap *soap, const char *tag, int id, const struct ns1__declineNetworkInviteResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__declineNetworkInviteResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__declineNetworkInviteResponse * SOAP_FMAC4 soap_get_ns1__declineNetworkInviteResponse(struct soap *soap, struct ns1__declineNetworkInviteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__declineNetworkInviteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__declineNetworkInviteResponse * SOAP_FMAC4 soap_in_ns1__declineNetworkInviteResponse(struct soap *soap, const char *tag, struct ns1__declineNetworkInviteResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__declineNetworkInviteResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__declineNetworkInviteResponse, sizeof(struct ns1__declineNetworkInviteResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__declineNetworkInviteResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__declineNetworkInviteResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__declineNetworkInviteResponse, 0, sizeof(struct ns1__declineNetworkInviteResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__acceptNetworkInvite(struct soap *soap, struct ns1__acceptNetworkInvite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__acceptNetworkInvite(struct soap *soap, const struct ns1__acceptNetworkInvite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__acceptNetworkInvite(struct soap *soap, const struct ns1__acceptNetworkInvite *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__acceptNetworkInvite);
	if (soap_out_ns1__acceptNetworkInvite(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__acceptNetworkInvite(struct soap *soap, const char *tag, int id, const struct ns1__acceptNetworkInvite *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__acceptNetworkInvite), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__acceptNetworkInvite * SOAP_FMAC4 soap_get_ns1__acceptNetworkInvite(struct soap *soap, struct ns1__acceptNetworkInvite *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__acceptNetworkInvite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__acceptNetworkInvite * SOAP_FMAC4 soap_in_ns1__acceptNetworkInvite(struct soap *soap, const char *tag, struct ns1__acceptNetworkInvite *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__acceptNetworkInvite *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__acceptNetworkInvite, sizeof(struct ns1__acceptNetworkInvite), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__acceptNetworkInvite(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__acceptNetworkInvite *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__acceptNetworkInvite, 0, sizeof(struct ns1__acceptNetworkInvite), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__acceptNetworkInviteResponse(struct soap *soap, struct ns1__acceptNetworkInviteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__acceptNetworkInviteResponse(struct soap *soap, const struct ns1__acceptNetworkInviteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__acceptNetworkInviteResponse(struct soap *soap, const struct ns1__acceptNetworkInviteResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__acceptNetworkInviteResponse);
	if (soap_out_ns1__acceptNetworkInviteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__acceptNetworkInviteResponse(struct soap *soap, const char *tag, int id, const struct ns1__acceptNetworkInviteResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__acceptNetworkInviteResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__acceptNetworkInviteResponse * SOAP_FMAC4 soap_get_ns1__acceptNetworkInviteResponse(struct soap *soap, struct ns1__acceptNetworkInviteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__acceptNetworkInviteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__acceptNetworkInviteResponse * SOAP_FMAC4 soap_in_ns1__acceptNetworkInviteResponse(struct soap *soap, const char *tag, struct ns1__acceptNetworkInviteResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__acceptNetworkInviteResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__acceptNetworkInviteResponse, sizeof(struct ns1__acceptNetworkInviteResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__acceptNetworkInviteResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__acceptNetworkInviteResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__acceptNetworkInviteResponse, 0, sizeof(struct ns1__acceptNetworkInviteResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__inviteNetworkMemberByUser(struct soap *soap, struct ns1__inviteNetworkMemberByUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	a->_in1 = NULL;
	a->_in2 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__inviteNetworkMemberByUser(struct soap *soap, const struct ns1__inviteNetworkMemberByUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_PointerTons2__User(soap, &a->_in1);
	soap_serialize_PointerTons2__Contact(soap, &a->_in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__inviteNetworkMemberByUser(struct soap *soap, const struct ns1__inviteNetworkMemberByUser *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__inviteNetworkMemberByUser);
	if (soap_out_ns1__inviteNetworkMemberByUser(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__inviteNetworkMemberByUser(struct soap *soap, const char *tag, int id, const struct ns1__inviteNetworkMemberByUser *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__inviteNetworkMemberByUser), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_PointerTons2__User(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_PointerTons2__Contact(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByUser * SOAP_FMAC4 soap_get_ns1__inviteNetworkMemberByUser(struct soap *soap, struct ns1__inviteNetworkMemberByUser *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__inviteNetworkMemberByUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByUser * SOAP_FMAC4 soap_in_ns1__inviteNetworkMemberByUser(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberByUser *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__inviteNetworkMemberByUser *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__inviteNetworkMemberByUser, sizeof(struct ns1__inviteNetworkMemberByUser), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__inviteNetworkMemberByUser(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__User(soap, NULL, &a->_in1, "ns2:User"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Contact(soap, NULL, &a->_in2, "ns2:Contact"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberByUser *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__inviteNetworkMemberByUser, 0, sizeof(struct ns1__inviteNetworkMemberByUser), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__inviteNetworkMemberByUserResponse(struct soap *soap, struct ns1__inviteNetworkMemberByUserResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_inviteNetworkMemberByUserReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__inviteNetworkMemberByUserResponse(struct soap *soap, const struct ns1__inviteNetworkMemberByUserResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Member(soap, &a->_inviteNetworkMemberByUserReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__inviteNetworkMemberByUserResponse(struct soap *soap, const struct ns1__inviteNetworkMemberByUserResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse);
	if (soap_out_ns1__inviteNetworkMemberByUserResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__inviteNetworkMemberByUserResponse(struct soap *soap, const char *tag, int id, const struct ns1__inviteNetworkMemberByUserResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__Member(soap, "inviteNetworkMemberByUserReturn", -1, &a->_inviteNetworkMemberByUserReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByUserResponse * SOAP_FMAC4 soap_get_ns1__inviteNetworkMemberByUserResponse(struct soap *soap, struct ns1__inviteNetworkMemberByUserResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__inviteNetworkMemberByUserResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByUserResponse * SOAP_FMAC4 soap_in_ns1__inviteNetworkMemberByUserResponse(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberByUserResponse *a, const char *type)
{
	size_t soap_flag__inviteNetworkMemberByUserReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__inviteNetworkMemberByUserResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse, sizeof(struct ns1__inviteNetworkMemberByUserResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__inviteNetworkMemberByUserResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inviteNetworkMemberByUserReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Member(soap, NULL, &a->_inviteNetworkMemberByUserReturn, "ns2:Member"))
				{	soap_flag__inviteNetworkMemberByUserReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberByUserResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse, 0, sizeof(struct ns1__inviteNetworkMemberByUserResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__inviteNetworkMemberByEmail(struct soap *soap, struct ns1__inviteNetworkMemberByEmail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__inviteNetworkMemberByEmail(struct soap *soap, const struct ns1__inviteNetworkMemberByEmail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__inviteNetworkMemberByEmail(struct soap *soap, const struct ns1__inviteNetworkMemberByEmail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__inviteNetworkMemberByEmail);
	if (soap_out_ns1__inviteNetworkMemberByEmail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__inviteNetworkMemberByEmail(struct soap *soap, const char *tag, int id, const struct ns1__inviteNetworkMemberByEmail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__inviteNetworkMemberByEmail), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByEmail * SOAP_FMAC4 soap_get_ns1__inviteNetworkMemberByEmail(struct soap *soap, struct ns1__inviteNetworkMemberByEmail *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__inviteNetworkMemberByEmail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByEmail * SOAP_FMAC4 soap_in_ns1__inviteNetworkMemberByEmail(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberByEmail *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__inviteNetworkMemberByEmail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__inviteNetworkMemberByEmail, sizeof(struct ns1__inviteNetworkMemberByEmail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__inviteNetworkMemberByEmail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberByEmail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__inviteNetworkMemberByEmail, 0, sizeof(struct ns1__inviteNetworkMemberByEmail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__inviteNetworkMemberByEmailResponse(struct soap *soap, struct ns1__inviteNetworkMemberByEmailResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_inviteNetworkMemberByEmailReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__inviteNetworkMemberByEmailResponse(struct soap *soap, const struct ns1__inviteNetworkMemberByEmailResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Member(soap, &a->_inviteNetworkMemberByEmailReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__inviteNetworkMemberByEmailResponse(struct soap *soap, const struct ns1__inviteNetworkMemberByEmailResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse);
	if (soap_out_ns1__inviteNetworkMemberByEmailResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__inviteNetworkMemberByEmailResponse(struct soap *soap, const char *tag, int id, const struct ns1__inviteNetworkMemberByEmailResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__Member(soap, "inviteNetworkMemberByEmailReturn", -1, &a->_inviteNetworkMemberByEmailReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByEmailResponse * SOAP_FMAC4 soap_get_ns1__inviteNetworkMemberByEmailResponse(struct soap *soap, struct ns1__inviteNetworkMemberByEmailResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__inviteNetworkMemberByEmailResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByEmailResponse * SOAP_FMAC4 soap_in_ns1__inviteNetworkMemberByEmailResponse(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberByEmailResponse *a, const char *type)
{
	size_t soap_flag__inviteNetworkMemberByEmailReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__inviteNetworkMemberByEmailResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse, sizeof(struct ns1__inviteNetworkMemberByEmailResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__inviteNetworkMemberByEmailResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inviteNetworkMemberByEmailReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Member(soap, NULL, &a->_inviteNetworkMemberByEmailReturn, "ns2:Member"))
				{	soap_flag__inviteNetworkMemberByEmailReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberByEmailResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse, 0, sizeof(struct ns1__inviteNetworkMemberByEmailResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__inviteNetworkMember(struct soap *soap, struct ns1__inviteNetworkMember *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__inviteNetworkMember(struct soap *soap, const struct ns1__inviteNetworkMember *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__inviteNetworkMember(struct soap *soap, const struct ns1__inviteNetworkMember *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__inviteNetworkMember);
	if (soap_out_ns1__inviteNetworkMember(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__inviteNetworkMember(struct soap *soap, const char *tag, int id, const struct ns1__inviteNetworkMember *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__inviteNetworkMember), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__inviteNetworkMember * SOAP_FMAC4 soap_get_ns1__inviteNetworkMember(struct soap *soap, struct ns1__inviteNetworkMember *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__inviteNetworkMember(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMember * SOAP_FMAC4 soap_in_ns1__inviteNetworkMember(struct soap *soap, const char *tag, struct ns1__inviteNetworkMember *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__inviteNetworkMember *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__inviteNetworkMember, sizeof(struct ns1__inviteNetworkMember), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__inviteNetworkMember(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMember *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__inviteNetworkMember, 0, sizeof(struct ns1__inviteNetworkMember), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__inviteNetworkMemberResponse(struct soap *soap, struct ns1__inviteNetworkMemberResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_inviteNetworkMemberReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__inviteNetworkMemberResponse(struct soap *soap, const struct ns1__inviteNetworkMemberResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Member(soap, &a->_inviteNetworkMemberReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__inviteNetworkMemberResponse(struct soap *soap, const struct ns1__inviteNetworkMemberResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__inviteNetworkMemberResponse);
	if (soap_out_ns1__inviteNetworkMemberResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__inviteNetworkMemberResponse(struct soap *soap, const char *tag, int id, const struct ns1__inviteNetworkMemberResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__inviteNetworkMemberResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__Member(soap, "inviteNetworkMemberReturn", -1, &a->_inviteNetworkMemberReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberResponse * SOAP_FMAC4 soap_get_ns1__inviteNetworkMemberResponse(struct soap *soap, struct ns1__inviteNetworkMemberResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__inviteNetworkMemberResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberResponse * SOAP_FMAC4 soap_in_ns1__inviteNetworkMemberResponse(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberResponse *a, const char *type)
{
	size_t soap_flag__inviteNetworkMemberReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__inviteNetworkMemberResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__inviteNetworkMemberResponse, sizeof(struct ns1__inviteNetworkMemberResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__inviteNetworkMemberResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inviteNetworkMemberReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Member(soap, NULL, &a->_inviteNetworkMemberReturn, "ns2:Member"))
				{	soap_flag__inviteNetworkMemberReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__inviteNetworkMemberResponse, 0, sizeof(struct ns1__inviteNetworkMemberResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__deleteNetwork(struct soap *soap, struct ns1__deleteNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__deleteNetwork(struct soap *soap, const struct ns1__deleteNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_in0, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__deleteNetwork(struct soap *soap, const struct ns1__deleteNetwork *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__deleteNetwork);
	if (soap_out_ns1__deleteNetwork(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__deleteNetwork(struct soap *soap, const char *tag, int id, const struct ns1__deleteNetwork *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__deleteNetwork), type))
		return soap->error;
	if (soap_out_LONG64(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__deleteNetwork * SOAP_FMAC4 soap_get_ns1__deleteNetwork(struct soap *soap, struct ns1__deleteNetwork *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__deleteNetwork(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteNetwork * SOAP_FMAC4 soap_in_ns1__deleteNetwork(struct soap *soap, const char *tag, struct ns1__deleteNetwork *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__deleteNetwork *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__deleteNetwork, sizeof(struct ns1__deleteNetwork), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__deleteNetwork(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, NULL, &a->_in0, "xsd:long"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteNetwork *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__deleteNetwork, 0, sizeof(struct ns1__deleteNetwork), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__deleteNetworkResponse(struct soap *soap, struct ns1__deleteNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__deleteNetworkResponse(struct soap *soap, const struct ns1__deleteNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__deleteNetworkResponse(struct soap *soap, const struct ns1__deleteNetworkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__deleteNetworkResponse);
	if (soap_out_ns1__deleteNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__deleteNetworkResponse(struct soap *soap, const char *tag, int id, const struct ns1__deleteNetworkResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__deleteNetworkResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__deleteNetworkResponse * SOAP_FMAC4 soap_get_ns1__deleteNetworkResponse(struct soap *soap, struct ns1__deleteNetworkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__deleteNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteNetworkResponse * SOAP_FMAC4 soap_in_ns1__deleteNetworkResponse(struct soap *soap, const char *tag, struct ns1__deleteNetworkResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__deleteNetworkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__deleteNetworkResponse, sizeof(struct ns1__deleteNetworkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__deleteNetworkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteNetworkResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__deleteNetworkResponse, 0, sizeof(struct ns1__deleteNetworkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__addNetwork(struct soap *soap, struct ns1__addNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	a->_in2 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__addNetwork(struct soap *soap, const struct ns1__addNetwork *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->_in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__addNetwork(struct soap *soap, const struct ns1__addNetwork *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__addNetwork);
	if (soap_out_ns1__addNetwork(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__addNetwork(struct soap *soap, const char *tag, int id, const struct ns1__addNetwork *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__addNetwork), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__addNetwork * SOAP_FMAC4 soap_get_ns1__addNetwork(struct soap *soap, struct ns1__addNetwork *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__addNetwork(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__addNetwork * SOAP_FMAC4 soap_in_ns1__addNetwork(struct soap *soap, const char *tag, struct ns1__addNetwork *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__addNetwork *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__addNetwork, sizeof(struct ns1__addNetwork), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__addNetwork(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, NULL, &a->_in2, ""))
				{	soap_flag__in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__addNetwork *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__addNetwork, 0, sizeof(struct ns1__addNetwork), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__addNetworkResponse(struct soap *soap, struct ns1__addNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_addNetworkReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__addNetworkResponse(struct soap *soap, const struct ns1__addNetworkResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Network(soap, &a->_addNetworkReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__addNetworkResponse(struct soap *soap, const struct ns1__addNetworkResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__addNetworkResponse);
	if (soap_out_ns1__addNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__addNetworkResponse(struct soap *soap, const char *tag, int id, const struct ns1__addNetworkResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__addNetworkResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__Network(soap, "addNetworkReturn", -1, &a->_addNetworkReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__addNetworkResponse * SOAP_FMAC4 soap_get_ns1__addNetworkResponse(struct soap *soap, struct ns1__addNetworkResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__addNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__addNetworkResponse * SOAP_FMAC4 soap_in_ns1__addNetworkResponse(struct soap *soap, const char *tag, struct ns1__addNetworkResponse *a, const char *type)
{
	size_t soap_flag__addNetworkReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__addNetworkResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__addNetworkResponse, sizeof(struct ns1__addNetworkResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__addNetworkResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__addNetworkReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Network(soap, NULL, &a->_addNetworkReturn, "ns2:Network"))
				{	soap_flag__addNetworkReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__addNetworkResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__addNetworkResponse, 0, sizeof(struct ns1__addNetworkResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__lookupContacts(struct soap *soap, struct ns1__lookupContacts *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_in0 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__lookupContacts(struct soap *soap, const struct ns1__lookupContacts *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Contact(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__lookupContacts(struct soap *soap, const struct ns1__lookupContacts *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__lookupContacts);
	if (soap_out_ns1__lookupContacts(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__lookupContacts(struct soap *soap, const char *tag, int id, const struct ns1__lookupContacts *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__lookupContacts), type))
		return soap->error;
	if (soap_out_PointerTons2__Contact(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__lookupContacts * SOAP_FMAC4 soap_get_ns1__lookupContacts(struct soap *soap, struct ns1__lookupContacts *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__lookupContacts(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__lookupContacts * SOAP_FMAC4 soap_in_ns1__lookupContacts(struct soap *soap, const char *tag, struct ns1__lookupContacts *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__lookupContacts *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__lookupContacts, sizeof(struct ns1__lookupContacts), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__lookupContacts(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Contact(soap, NULL, &a->_in0, "ns2:Contact"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__lookupContacts *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__lookupContacts, 0, sizeof(struct ns1__lookupContacts), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__lookupContactsResponse(struct soap *soap, struct ns1__lookupContactsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_lookupContactsReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__lookupContactsResponse(struct soap *soap, const struct ns1__lookupContactsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->_lookupContactsReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__lookupContactsResponse(struct soap *soap, const struct ns1__lookupContactsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__lookupContactsResponse);
	if (soap_out_ns1__lookupContactsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__lookupContactsResponse(struct soap *soap, const char *tag, int id, const struct ns1__lookupContactsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__lookupContactsResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "lookupContactsReturn", -1, &a->_lookupContactsReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__lookupContactsResponse * SOAP_FMAC4 soap_get_ns1__lookupContactsResponse(struct soap *soap, struct ns1__lookupContactsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__lookupContactsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__lookupContactsResponse * SOAP_FMAC4 soap_in_ns1__lookupContactsResponse(struct soap *soap, const char *tag, struct ns1__lookupContactsResponse *a, const char *type)
{
	size_t soap_flag__lookupContactsReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__lookupContactsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__lookupContactsResponse, sizeof(struct ns1__lookupContactsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__lookupContactsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__lookupContactsReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, NULL, &a->_lookupContactsReturn, ""))
				{	soap_flag__lookupContactsReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__lookupContactsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__lookupContactsResponse, 0, sizeof(struct ns1__lookupContactsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getContact(struct soap *soap, struct ns1__getContact *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getContact(struct soap *soap, const struct ns1__getContact *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getContact(struct soap *soap, const struct ns1__getContact *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getContact);
	if (soap_out_ns1__getContact(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getContact(struct soap *soap, const char *tag, int id, const struct ns1__getContact *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getContact), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getContact * SOAP_FMAC4 soap_get_ns1__getContact(struct soap *soap, struct ns1__getContact *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getContact(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getContact * SOAP_FMAC4 soap_in_ns1__getContact(struct soap *soap, const char *tag, struct ns1__getContact *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getContact *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getContact, sizeof(struct ns1__getContact), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getContact(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getContact *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getContact, 0, sizeof(struct ns1__getContact), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__getContactResponse(struct soap *soap, struct ns1__getContactResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getContactReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__getContactResponse(struct soap *soap, const struct ns1__getContactResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Contact(soap, &a->_getContactReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__getContactResponse(struct soap *soap, const struct ns1__getContactResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__getContactResponse);
	if (soap_out_ns1__getContactResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__getContactResponse(struct soap *soap, const char *tag, int id, const struct ns1__getContactResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__getContactResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__Contact(soap, "getContactReturn", -1, &a->_getContactReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__getContactResponse * SOAP_FMAC4 soap_get_ns1__getContactResponse(struct soap *soap, struct ns1__getContactResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__getContactResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getContactResponse * SOAP_FMAC4 soap_in_ns1__getContactResponse(struct soap *soap, const char *tag, struct ns1__getContactResponse *a, const char *type)
{
	size_t soap_flag__getContactReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__getContactResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__getContactResponse, sizeof(struct ns1__getContactResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__getContactResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getContactReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Contact(soap, NULL, &a->_getContactReturn, "ns2:Contact"))
				{	soap_flag__getContactReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__getContactResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__getContactResponse, 0, sizeof(struct ns1__getContactResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__updateContact(struct soap *soap, struct ns1__updateContact *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_in0 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__updateContact(struct soap *soap, const struct ns1__updateContact *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__Contact(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__updateContact(struct soap *soap, const struct ns1__updateContact *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__updateContact);
	if (soap_out_ns1__updateContact(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__updateContact(struct soap *soap, const char *tag, int id, const struct ns1__updateContact *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__updateContact), type))
		return soap->error;
	if (soap_out_PointerTons2__Contact(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__updateContact * SOAP_FMAC4 soap_get_ns1__updateContact(struct soap *soap, struct ns1__updateContact *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__updateContact(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__updateContact * SOAP_FMAC4 soap_in_ns1__updateContact(struct soap *soap, const char *tag, struct ns1__updateContact *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__updateContact *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__updateContact, sizeof(struct ns1__updateContact), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__updateContact(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__Contact(soap, NULL, &a->_in0, "ns2:Contact"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__updateContact *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__updateContact, 0, sizeof(struct ns1__updateContact), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__updateContactResponse(struct soap *soap, struct ns1__updateContactResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__updateContactResponse(struct soap *soap, const struct ns1__updateContactResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__updateContactResponse(struct soap *soap, const struct ns1__updateContactResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__updateContactResponse);
	if (soap_out_ns1__updateContactResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__updateContactResponse(struct soap *soap, const char *tag, int id, const struct ns1__updateContactResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__updateContactResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__updateContactResponse * SOAP_FMAC4 soap_get_ns1__updateContactResponse(struct soap *soap, struct ns1__updateContactResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__updateContactResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__updateContactResponse * SOAP_FMAC4 soap_in_ns1__updateContactResponse(struct soap *soap, const char *tag, struct ns1__updateContactResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__updateContactResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__updateContactResponse, sizeof(struct ns1__updateContactResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__updateContactResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__updateContactResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__updateContactResponse, 0, sizeof(struct ns1__updateContactResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__changePassword(struct soap *soap, struct ns1__changePassword *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__changePassword(struct soap *soap, const struct ns1__changePassword *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__changePassword(struct soap *soap, const struct ns1__changePassword *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__changePassword);
	if (soap_out_ns1__changePassword(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__changePassword(struct soap *soap, const char *tag, int id, const struct ns1__changePassword *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__changePassword), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__changePassword * SOAP_FMAC4 soap_get_ns1__changePassword(struct soap *soap, struct ns1__changePassword *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__changePassword(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__changePassword * SOAP_FMAC4 soap_in_ns1__changePassword(struct soap *soap, const char *tag, struct ns1__changePassword *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__changePassword *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__changePassword, sizeof(struct ns1__changePassword), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__changePassword(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__changePassword *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__changePassword, 0, sizeof(struct ns1__changePassword), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__changePasswordResponse(struct soap *soap, struct ns1__changePasswordResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__changePasswordResponse(struct soap *soap, const struct ns1__changePasswordResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__changePasswordResponse(struct soap *soap, const struct ns1__changePasswordResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__changePasswordResponse);
	if (soap_out_ns1__changePasswordResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__changePasswordResponse(struct soap *soap, const char *tag, int id, const struct ns1__changePasswordResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__changePasswordResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__changePasswordResponse * SOAP_FMAC4 soap_get_ns1__changePasswordResponse(struct soap *soap, struct ns1__changePasswordResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__changePasswordResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__changePasswordResponse * SOAP_FMAC4 soap_in_ns1__changePasswordResponse(struct soap *soap, const char *tag, struct ns1__changePasswordResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__changePasswordResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__changePasswordResponse, sizeof(struct ns1__changePasswordResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__changePasswordResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__changePasswordResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__changePasswordResponse, 0, sizeof(struct ns1__changePasswordResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__deleteUser(struct soap *soap, struct ns1__deleteUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__deleteUser(struct soap *soap, const struct ns1__deleteUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__deleteUser(struct soap *soap, const struct ns1__deleteUser *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__deleteUser);
	if (soap_out_ns1__deleteUser(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__deleteUser(struct soap *soap, const char *tag, int id, const struct ns1__deleteUser *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__deleteUser), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__deleteUser * SOAP_FMAC4 soap_get_ns1__deleteUser(struct soap *soap, struct ns1__deleteUser *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__deleteUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteUser * SOAP_FMAC4 soap_in_ns1__deleteUser(struct soap *soap, const char *tag, struct ns1__deleteUser *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__deleteUser *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__deleteUser, sizeof(struct ns1__deleteUser), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__deleteUser(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteUser *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__deleteUser, 0, sizeof(struct ns1__deleteUser), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__deleteUserResponse(struct soap *soap, struct ns1__deleteUserResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__deleteUserResponse(struct soap *soap, const struct ns1__deleteUserResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__deleteUserResponse(struct soap *soap, const struct ns1__deleteUserResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__deleteUserResponse);
	if (soap_out_ns1__deleteUserResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__deleteUserResponse(struct soap *soap, const char *tag, int id, const struct ns1__deleteUserResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__deleteUserResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__deleteUserResponse * SOAP_FMAC4 soap_get_ns1__deleteUserResponse(struct soap *soap, struct ns1__deleteUserResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__deleteUserResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteUserResponse * SOAP_FMAC4 soap_in_ns1__deleteUserResponse(struct soap *soap, const char *tag, struct ns1__deleteUserResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__deleteUserResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__deleteUserResponse, sizeof(struct ns1__deleteUserResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__deleteUserResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteUserResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__deleteUserResponse, 0, sizeof(struct ns1__deleteUserResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__vrfyLogin(struct soap *soap, struct ns1__vrfyLogin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__vrfyLogin(struct soap *soap, const struct ns1__vrfyLogin *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__vrfyLogin(struct soap *soap, const struct ns1__vrfyLogin *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__vrfyLogin);
	if (soap_out_ns1__vrfyLogin(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__vrfyLogin(struct soap *soap, const char *tag, int id, const struct ns1__vrfyLogin *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__vrfyLogin), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__vrfyLogin * SOAP_FMAC4 soap_get_ns1__vrfyLogin(struct soap *soap, struct ns1__vrfyLogin *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__vrfyLogin(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__vrfyLogin * SOAP_FMAC4 soap_in_ns1__vrfyLogin(struct soap *soap, const char *tag, struct ns1__vrfyLogin *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__vrfyLogin *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__vrfyLogin, sizeof(struct ns1__vrfyLogin), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__vrfyLogin(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__vrfyLogin *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__vrfyLogin, 0, sizeof(struct ns1__vrfyLogin), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__vrfyLoginResponse(struct soap *soap, struct ns1__vrfyLoginResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__vrfyLoginResponse(struct soap *soap, const struct ns1__vrfyLoginResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__vrfyLoginResponse(struct soap *soap, const struct ns1__vrfyLoginResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__vrfyLoginResponse);
	if (soap_out_ns1__vrfyLoginResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__vrfyLoginResponse(struct soap *soap, const char *tag, int id, const struct ns1__vrfyLoginResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__vrfyLoginResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns1__vrfyLoginResponse * SOAP_FMAC4 soap_get_ns1__vrfyLoginResponse(struct soap *soap, struct ns1__vrfyLoginResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__vrfyLoginResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__vrfyLoginResponse * SOAP_FMAC4 soap_in_ns1__vrfyLoginResponse(struct soap *soap, const char *tag, struct ns1__vrfyLoginResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__vrfyLoginResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__vrfyLoginResponse, sizeof(struct ns1__vrfyLoginResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__vrfyLoginResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__vrfyLoginResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__vrfyLoginResponse, 0, sizeof(struct ns1__vrfyLoginResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__UpdateMemberContactNotification(struct soap *soap, struct ns4__UpdateMemberContactNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->member);
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__UpdateMemberContactNotification(struct soap *soap, const struct ns4__UpdateMemberContactNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->member);
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__UpdateMemberContactNotification(struct soap *soap, const struct ns4__UpdateMemberContactNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__UpdateMemberContactNotification);
	if (soap_out_ns4__UpdateMemberContactNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__UpdateMemberContactNotification(struct soap *soap, const char *tag, int id, const struct ns4__UpdateMemberContactNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__UpdateMemberContactNotification), type))
		return soap->error;
	if (soap_out_string(soap, "member", -1, &a->member, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__UpdateMemberContactNotification * SOAP_FMAC4 soap_get_ns4__UpdateMemberContactNotification(struct soap *soap, struct ns4__UpdateMemberContactNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__UpdateMemberContactNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__UpdateMemberContactNotification * SOAP_FMAC4 soap_in_ns4__UpdateMemberContactNotification(struct soap *soap, const char *tag, struct ns4__UpdateMemberContactNotification *a, const char *type)
{
	size_t soap_flag_member = 1;
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__UpdateMemberContactNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__UpdateMemberContactNotification, sizeof(struct ns4__UpdateMemberContactNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__UpdateMemberContactNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_member && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "member", &a->member, "xsd:string"))
				{	soap_flag_member--;
					continue;
				}
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__UpdateMemberContactNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__UpdateMemberContactNotification, 0, sizeof(struct ns4__UpdateMemberContactNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__SignupNetworkMemberNotification(struct soap *soap, struct ns4__SignupNetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->member);
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->prevmember);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__SignupNetworkMemberNotification(struct soap *soap, const struct ns4__SignupNetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->member);
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->prevmember);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__SignupNetworkMemberNotification(struct soap *soap, const struct ns4__SignupNetworkMemberNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__SignupNetworkMemberNotification);
	if (soap_out_ns4__SignupNetworkMemberNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__SignupNetworkMemberNotification(struct soap *soap, const char *tag, int id, const struct ns4__SignupNetworkMemberNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__SignupNetworkMemberNotification), type))
		return soap->error;
	if (soap_out_string(soap, "member", -1, &a->member, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "prevmember", -1, &a->prevmember, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__SignupNetworkMemberNotification * SOAP_FMAC4 soap_get_ns4__SignupNetworkMemberNotification(struct soap *soap, struct ns4__SignupNetworkMemberNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__SignupNetworkMemberNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__SignupNetworkMemberNotification * SOAP_FMAC4 soap_in_ns4__SignupNetworkMemberNotification(struct soap *soap, const char *tag, struct ns4__SignupNetworkMemberNotification *a, const char *type)
{
	size_t soap_flag_member = 1;
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_prevmember = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__SignupNetworkMemberNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__SignupNetworkMemberNotification, sizeof(struct ns4__SignupNetworkMemberNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__SignupNetworkMemberNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_member && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "member", &a->member, "xsd:string"))
				{	soap_flag_member--;
					continue;
				}
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_prevmember && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "prevmember", &a->prevmember, "xsd:string"))
				{	soap_flag_prevmember--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__SignupNetworkMemberNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__SignupNetworkMemberNotification, 0, sizeof(struct ns4__SignupNetworkMemberNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__DeleteNetworkMemberNotification(struct soap *soap, struct ns4__DeleteNetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->member);
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__DeleteNetworkMemberNotification(struct soap *soap, const struct ns4__DeleteNetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->member);
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__DeleteNetworkMemberNotification(struct soap *soap, const struct ns4__DeleteNetworkMemberNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__DeleteNetworkMemberNotification);
	if (soap_out_ns4__DeleteNetworkMemberNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__DeleteNetworkMemberNotification(struct soap *soap, const char *tag, int id, const struct ns4__DeleteNetworkMemberNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__DeleteNetworkMemberNotification), type))
		return soap->error;
	if (soap_out_string(soap, "member", -1, &a->member, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__DeleteNetworkMemberNotification * SOAP_FMAC4 soap_get_ns4__DeleteNetworkMemberNotification(struct soap *soap, struct ns4__DeleteNetworkMemberNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__DeleteNetworkMemberNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__DeleteNetworkMemberNotification * SOAP_FMAC4 soap_in_ns4__DeleteNetworkMemberNotification(struct soap *soap, const char *tag, struct ns4__DeleteNetworkMemberNotification *a, const char *type)
{
	size_t soap_flag_member = 1;
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__DeleteNetworkMemberNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__DeleteNetworkMemberNotification, sizeof(struct ns4__DeleteNetworkMemberNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__DeleteNetworkMemberNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_member && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "member", &a->member, "xsd:string"))
				{	soap_flag_member--;
					continue;
				}
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__DeleteNetworkMemberNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__DeleteNetworkMemberNotification, 0, sizeof(struct ns4__DeleteNetworkMemberNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__DeclineNetworkInviteNotification(struct soap *soap, struct ns4__DeclineNetworkInviteNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->member);
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__DeclineNetworkInviteNotification(struct soap *soap, const struct ns4__DeclineNetworkInviteNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->member);
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__DeclineNetworkInviteNotification(struct soap *soap, const struct ns4__DeclineNetworkInviteNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__DeclineNetworkInviteNotification);
	if (soap_out_ns4__DeclineNetworkInviteNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__DeclineNetworkInviteNotification(struct soap *soap, const char *tag, int id, const struct ns4__DeclineNetworkInviteNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__DeclineNetworkInviteNotification), type))
		return soap->error;
	if (soap_out_string(soap, "member", -1, &a->member, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__DeclineNetworkInviteNotification * SOAP_FMAC4 soap_get_ns4__DeclineNetworkInviteNotification(struct soap *soap, struct ns4__DeclineNetworkInviteNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__DeclineNetworkInviteNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__DeclineNetworkInviteNotification * SOAP_FMAC4 soap_in_ns4__DeclineNetworkInviteNotification(struct soap *soap, const char *tag, struct ns4__DeclineNetworkInviteNotification *a, const char *type)
{
	size_t soap_flag_member = 1;
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__DeclineNetworkInviteNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__DeclineNetworkInviteNotification, sizeof(struct ns4__DeclineNetworkInviteNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__DeclineNetworkInviteNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_member && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "member", &a->member, "xsd:string"))
				{	soap_flag_member--;
					continue;
				}
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__DeclineNetworkInviteNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__DeclineNetworkInviteNotification, 0, sizeof(struct ns4__DeclineNetworkInviteNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__AddNetworkMemberNotification(struct soap *soap, struct ns4__AddNetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->member);
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__AddNetworkMemberNotification(struct soap *soap, const struct ns4__AddNetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->member);
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__AddNetworkMemberNotification(struct soap *soap, const struct ns4__AddNetworkMemberNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__AddNetworkMemberNotification);
	if (soap_out_ns4__AddNetworkMemberNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__AddNetworkMemberNotification(struct soap *soap, const char *tag, int id, const struct ns4__AddNetworkMemberNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__AddNetworkMemberNotification), type))
		return soap->error;
	if (soap_out_string(soap, "member", -1, &a->member, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__AddNetworkMemberNotification * SOAP_FMAC4 soap_get_ns4__AddNetworkMemberNotification(struct soap *soap, struct ns4__AddNetworkMemberNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__AddNetworkMemberNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__AddNetworkMemberNotification * SOAP_FMAC4 soap_in_ns4__AddNetworkMemberNotification(struct soap *soap, const char *tag, struct ns4__AddNetworkMemberNotification *a, const char *type)
{
	size_t soap_flag_member = 1;
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__AddNetworkMemberNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__AddNetworkMemberNotification, sizeof(struct ns4__AddNetworkMemberNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__AddNetworkMemberNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_member && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "member", &a->member, "xsd:string"))
				{	soap_flag_member--;
					continue;
				}
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__AddNetworkMemberNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__AddNetworkMemberNotification, 0, sizeof(struct ns4__AddNetworkMemberNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerSynPktEvent(struct soap *soap, struct ns5__PeerSynPktEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	a->packet = NULL;
	soap_default_string(soap, &a->peer);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerSynPktEvent(struct soap *soap, const struct ns5__PeerSynPktEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_PointerToxsd__base64Binary(soap, &a->packet);
	soap_serialize_string(soap, &a->peer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerSynPktEvent(struct soap *soap, const struct ns5__PeerSynPktEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerSynPktEvent);
	if (soap_out_ns5__PeerSynPktEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerSynPktEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerSynPktEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerSynPktEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_PointerToxsd__base64Binary(soap, "packet", -1, &a->packet, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerSynPktEvent * SOAP_FMAC4 soap_get_ns5__PeerSynPktEvent(struct soap *soap, struct ns5__PeerSynPktEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerSynPktEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerSynPktEvent * SOAP_FMAC4 soap_in_ns5__PeerSynPktEvent(struct soap *soap, const char *tag, struct ns5__PeerSynPktEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_packet = 1;
	size_t soap_flag_peer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerSynPktEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerSynPktEvent, sizeof(struct ns5__PeerSynPktEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerSynPktEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_packet && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "packet", &a->packet, "xsd:base64Binary"))
				{	soap_flag_packet--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerSynPktEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerSynPktEvent, 0, sizeof(struct ns5__PeerSynPktEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerDisconnectedEvent(struct soap *soap, struct ns5__PeerDisconnectedEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->peer);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerDisconnectedEvent(struct soap *soap, const struct ns5__PeerDisconnectedEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->peer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerDisconnectedEvent(struct soap *soap, const struct ns5__PeerDisconnectedEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerDisconnectedEvent);
	if (soap_out_ns5__PeerDisconnectedEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerDisconnectedEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerDisconnectedEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerDisconnectedEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerDisconnectedEvent * SOAP_FMAC4 soap_get_ns5__PeerDisconnectedEvent(struct soap *soap, struct ns5__PeerDisconnectedEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerDisconnectedEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerDisconnectedEvent * SOAP_FMAC4 soap_in_ns5__PeerDisconnectedEvent(struct soap *soap, const char *tag, struct ns5__PeerDisconnectedEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_peer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerDisconnectedEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerDisconnectedEvent, sizeof(struct ns5__PeerDisconnectedEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerDisconnectedEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerDisconnectedEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerDisconnectedEvent, 0, sizeof(struct ns5__PeerDisconnectedEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectedEvent(struct soap *soap, struct ns5__PeerConnectedEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->peer);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectedEvent(struct soap *soap, const struct ns5__PeerConnectedEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->peer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectedEvent(struct soap *soap, const struct ns5__PeerConnectedEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectedEvent);
	if (soap_out_ns5__PeerConnectedEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectedEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectedEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectedEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectedEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectedEvent(struct soap *soap, struct ns5__PeerConnectedEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectedEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectedEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectedEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectedEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_peer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectedEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectedEvent, sizeof(struct ns5__PeerConnectedEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectedEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectedEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectedEvent, 0, sizeof(struct ns5__PeerConnectedEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectRequestEvent(struct soap *soap, struct ns5__PeerConnectRequestEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->appData);
	a->cntype = NULL;
	soap_default_string(soap, &a->peer);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectRequestEvent(struct soap *soap, const struct ns5__PeerConnectRequestEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->appData);
	soap_serialize_PointerToint(soap, &a->cntype);
	soap_serialize_string(soap, &a->peer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectRequestEvent(struct soap *soap, const struct ns5__PeerConnectRequestEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectRequestEvent);
	if (soap_out_ns5__PeerConnectRequestEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectRequestEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectRequestEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectRequestEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "appData", -1, &a->appData, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntype", -1, &a->cntype, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectRequestEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectRequestEvent(struct soap *soap, struct ns5__PeerConnectRequestEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectRequestEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectRequestEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectRequestEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectRequestEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_appData = 1;
	size_t soap_flag_cntype = 1;
	size_t soap_flag_peer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectRequestEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectRequestEvent, sizeof(struct ns5__PeerConnectRequestEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectRequestEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_appData && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "appData", &a->appData, "xsd:string"))
				{	soap_flag_appData--;
					continue;
				}
			if (soap_flag_cntype && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntype", &a->cntype, "xsd:int"))
				{	soap_flag_cntype--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectRequestEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectRequestEvent, 0, sizeof(struct ns5__PeerConnectRequestEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectRejectEvent(struct soap *soap, struct ns5__PeerConnectRejectEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->peer);
	soap_default_string(soap, &a->rejectstr);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectRejectEvent(struct soap *soap, const struct ns5__PeerConnectRejectEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->peer);
	soap_serialize_string(soap, &a->rejectstr);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectRejectEvent(struct soap *soap, const struct ns5__PeerConnectRejectEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectRejectEvent);
	if (soap_out_ns5__PeerConnectRejectEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectRejectEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectRejectEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectRejectEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	if (soap_out_string(soap, "rejectstr", -1, &a->rejectstr, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectRejectEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectRejectEvent(struct soap *soap, struct ns5__PeerConnectRejectEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectRejectEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectRejectEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectRejectEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectRejectEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_peer = 1;
	size_t soap_flag_rejectstr = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectRejectEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectRejectEvent, sizeof(struct ns5__PeerConnectRejectEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectRejectEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap_flag_rejectstr && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "rejectstr", &a->rejectstr, "xsd:string"))
				{	soap_flag_rejectstr--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectRejectEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectRejectEvent, 0, sizeof(struct ns5__PeerConnectRejectEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectEvent(struct soap *soap, struct ns5__PeerConnectEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->ip);
	soap_default_string(soap, &a->peer);
	a->port = NULL;
	a->role = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectEvent(struct soap *soap, const struct ns5__PeerConnectEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->ip);
	soap_serialize_string(soap, &a->peer);
	soap_serialize_PointerToint(soap, &a->port);
	soap_serialize_PointerToint(soap, &a->role);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectEvent(struct soap *soap, const struct ns5__PeerConnectEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectEvent);
	if (soap_out_ns5__PeerConnectEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "ip", -1, &a->ip, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "port", -1, &a->port, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "role", -1, &a->role, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectEvent(struct soap *soap, struct ns5__PeerConnectEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_ip = 1;
	size_t soap_flag_peer = 1;
	size_t soap_flag_port = 1;
	size_t soap_flag_role = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectEvent, sizeof(struct ns5__PeerConnectEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_ip && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ip", &a->ip, "xsd:string"))
				{	soap_flag_ip--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap_flag_port && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "port", &a->port, "xsd:int"))
				{	soap_flag_port--;
					continue;
				}
			if (soap_flag_role && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "role", &a->role, "xsd:int"))
				{	soap_flag_role--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectEvent, 0, sizeof(struct ns5__PeerConnectEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectErrorEvent(struct soap *soap, struct ns5__PeerConnectErrorEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->errorstr);
	soap_default_string(soap, &a->peer);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectErrorEvent(struct soap *soap, const struct ns5__PeerConnectErrorEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->errorstr);
	soap_serialize_string(soap, &a->peer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectErrorEvent(struct soap *soap, const struct ns5__PeerConnectErrorEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectErrorEvent);
	if (soap_out_ns5__PeerConnectErrorEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectErrorEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectErrorEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectErrorEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "errorstr", -1, &a->errorstr, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectErrorEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectErrorEvent(struct soap *soap, struct ns5__PeerConnectErrorEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectErrorEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectErrorEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectErrorEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectErrorEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_errorstr = 1;
	size_t soap_flag_peer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectErrorEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectErrorEvent, sizeof(struct ns5__PeerConnectErrorEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectErrorEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_errorstr && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "errorstr", &a->errorstr, "xsd:string"))
				{	soap_flag_errorstr--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectErrorEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectErrorEvent, 0, sizeof(struct ns5__PeerConnectErrorEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectBusyEvent(struct soap *soap, struct ns5__PeerConnectBusyEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->peer);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectBusyEvent(struct soap *soap, const struct ns5__PeerConnectBusyEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->peer);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectBusyEvent(struct soap *soap, const struct ns5__PeerConnectBusyEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectBusyEvent);
	if (soap_out_ns5__PeerConnectBusyEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectBusyEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectBusyEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectBusyEvent), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "peer", -1, &a->peer, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectBusyEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectBusyEvent(struct soap *soap, struct ns5__PeerConnectBusyEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectBusyEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectBusyEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectBusyEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectBusyEvent *a, const char *type)
{
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_peer = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectBusyEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectBusyEvent, sizeof(struct ns5__PeerConnectBusyEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectBusyEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_peer && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "peer", &a->peer, "xsd:string"))
				{	soap_flag_peer--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectBusyEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectBusyEvent, 0, sizeof(struct ns5__PeerConnectBusyEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__InviteNetworkNotification(struct soap *soap, struct ns4__InviteNetworkNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__InviteNetworkNotification(struct soap *soap, const struct ns4__InviteNetworkNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__InviteNetworkNotification(struct soap *soap, const struct ns4__InviteNetworkNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__InviteNetworkNotification);
	if (soap_out_ns4__InviteNetworkNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__InviteNetworkNotification(struct soap *soap, const char *tag, int id, const struct ns4__InviteNetworkNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__InviteNetworkNotification), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__InviteNetworkNotification * SOAP_FMAC4 soap_get_ns4__InviteNetworkNotification(struct soap *soap, struct ns4__InviteNetworkNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__InviteNetworkNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__InviteNetworkNotification * SOAP_FMAC4 soap_in_ns4__InviteNetworkNotification(struct soap *soap, const char *tag, struct ns4__InviteNetworkNotification *a, const char *type)
{
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__InviteNetworkNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__InviteNetworkNotification, sizeof(struct ns4__InviteNetworkNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__InviteNetworkNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__InviteNetworkNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__InviteNetworkNotification, 0, sizeof(struct ns4__InviteNetworkNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__DeleteNetworkNotification(struct soap *soap, struct ns4__DeleteNetworkNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__DeleteNetworkNotification(struct soap *soap, const struct ns4__DeleteNetworkNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__DeleteNetworkNotification(struct soap *soap, const struct ns4__DeleteNetworkNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__DeleteNetworkNotification);
	if (soap_out_ns4__DeleteNetworkNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__DeleteNetworkNotification(struct soap *soap, const char *tag, int id, const struct ns4__DeleteNetworkNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__DeleteNetworkNotification), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__DeleteNetworkNotification * SOAP_FMAC4 soap_get_ns4__DeleteNetworkNotification(struct soap *soap, struct ns4__DeleteNetworkNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__DeleteNetworkNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__DeleteNetworkNotification * SOAP_FMAC4 soap_in_ns4__DeleteNetworkNotification(struct soap *soap, const char *tag, struct ns4__DeleteNetworkNotification *a, const char *type)
{
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__DeleteNetworkNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__DeleteNetworkNotification, sizeof(struct ns4__DeleteNetworkNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__DeleteNetworkNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__DeleteNetworkNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__DeleteNetworkNotification, 0, sizeof(struct ns4__DeleteNetworkNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__NetworkMemberNotification(struct soap *soap, struct ns4__NetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->network = NULL;
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	soap_default_string(soap, &a->member);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__NetworkMemberNotification(struct soap *soap, const struct ns4__NetworkMemberNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->network);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_string(soap, &a->member);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__NetworkMemberNotification(struct soap *soap, const struct ns4__NetworkMemberNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__NetworkMemberNotification);
	if (soap_out_ns4__NetworkMemberNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__NetworkMemberNotification(struct soap *soap, const char *tag, int id, const struct ns4__NetworkMemberNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__NetworkMemberNotification), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_string(soap, "member", -1, &a->member, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__NetworkMemberNotification * SOAP_FMAC4 soap_get_ns4__NetworkMemberNotification(struct soap *soap, struct ns4__NetworkMemberNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__NetworkMemberNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__NetworkMemberNotification * SOAP_FMAC4 soap_in_ns4__NetworkMemberNotification(struct soap *soap, const char *tag, struct ns4__NetworkMemberNotification *a, const char *type)
{
	size_t soap_flag_network = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_member = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__NetworkMemberNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__NetworkMemberNotification, sizeof(struct ns4__NetworkMemberNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__NetworkMemberNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_member && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "member", &a->member, "xsd:string"))
				{	soap_flag_member--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__NetworkMemberNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__NetworkMemberNotification, 0, sizeof(struct ns4__NetworkMemberNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerEventIndex(struct soap *soap, struct ns5__PeerEventIndex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerEventIndex(struct soap *soap, const struct ns5__PeerEventIndex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerEventIndex(struct soap *soap, const struct ns5__PeerEventIndex *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerEventIndex);
	if (soap_out_ns5__PeerEventIndex(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerEventIndex(struct soap *soap, const char *tag, int id, const struct ns5__PeerEventIndex *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerEventIndex), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerEventIndex * SOAP_FMAC4 soap_get_ns5__PeerEventIndex(struct soap *soap, struct ns5__PeerEventIndex *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerEventIndex(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerEventIndex * SOAP_FMAC4 soap_in_ns5__PeerEventIndex(struct soap *soap, const char *tag, struct ns5__PeerEventIndex *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerEventIndex *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerEventIndex, sizeof(struct ns5__PeerEventIndex), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerEventIndex(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerEventIndex *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerEventIndex, 0, sizeof(struct ns5__PeerEventIndex), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionEvent(struct soap *soap, struct ns5__PeerConnectionEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	a->cndir = NULL;
	a->cntry = NULL;
	a->connection = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionEvent(struct soap *soap, const struct ns5__PeerConnectionEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToLONG64(soap, &a->connection);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionEvent(struct soap *soap, const struct ns5__PeerConnectionEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionEvent);
	if (soap_out_ns5__PeerConnectionEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionEvent), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "connection", -1, &a->connection, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionEvent * SOAP_FMAC4 soap_get_ns5__PeerConnectionEvent(struct soap *soap, struct ns5__PeerConnectionEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionEvent * SOAP_FMAC4 soap_in_ns5__PeerConnectionEvent(struct soap *soap, const char *tag, struct ns5__PeerConnectionEvent *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_connection = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionEvent, sizeof(struct ns5__PeerConnectionEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_connection && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "connection", &a->connection, "xsd:long"))
				{	soap_flag_connection--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionEvent, 0, sizeof(struct ns5__PeerConnectionEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__NotificationIndex(struct soap *soap, struct ns4__NotificationIndex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__NotificationIndex(struct soap *soap, const struct ns4__NotificationIndex *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__NotificationIndex(struct soap *soap, const struct ns4__NotificationIndex *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__NotificationIndex);
	if (soap_out_ns4__NotificationIndex(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__NotificationIndex(struct soap *soap, const char *tag, int id, const struct ns4__NotificationIndex *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__NotificationIndex), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__NotificationIndex * SOAP_FMAC4 soap_get_ns4__NotificationIndex(struct soap *soap, struct ns4__NotificationIndex *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__NotificationIndex(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__NotificationIndex * SOAP_FMAC4 soap_in_ns4__NotificationIndex(struct soap *soap, const char *tag, struct ns4__NotificationIndex *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__NotificationIndex *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__NotificationIndex, sizeof(struct ns4__NotificationIndex), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__NotificationIndex(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__NotificationIndex *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__NotificationIndex, 0, sizeof(struct ns4__NotificationIndex), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__NetworkNotification(struct soap *soap, struct ns4__NetworkNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
	a->network = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__NetworkNotification(struct soap *soap, const struct ns4__NetworkNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
	soap_serialize_PointerToLONG64(soap, &a->network);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__NetworkNotification(struct soap *soap, const struct ns4__NetworkNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__NetworkNotification);
	if (soap_out_ns4__NetworkNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__NetworkNotification(struct soap *soap, const char *tag, int id, const struct ns4__NetworkNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__NetworkNotification), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "network", -1, &a->network, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__NetworkNotification * SOAP_FMAC4 soap_get_ns4__NetworkNotification(struct soap *soap, struct ns4__NetworkNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__NetworkNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__NetworkNotification * SOAP_FMAC4 soap_in_ns4__NetworkNotification(struct soap *soap, const char *tag, struct ns4__NetworkNotification *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_network = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__NetworkNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__NetworkNotification, sizeof(struct ns4__NetworkNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__NetworkNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_network && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "network", &a->network, "xsd:long"))
				{	soap_flag_network--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__NetworkNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__NetworkNotification, 0, sizeof(struct ns4__NetworkNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__Usert(struct soap *soap, struct ns2__Usert *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->password);
	a->status = NULL;
	soap_default_string(soap, &a->username);
	a->timestamp = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__Usert(struct soap *soap, const struct ns2__Usert *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->password);
	soap_serialize_PointerToint(soap, &a->status);
	soap_serialize_string(soap, &a->username);
	soap_serialize_PointerTotime(soap, &a->timestamp);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__Usert(struct soap *soap, const struct ns2__Usert *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__Usert);
	if (soap_out_ns2__Usert(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__Usert(struct soap *soap, const char *tag, int id, const struct ns2__Usert *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__Usert), type))
		return soap->error;
	if (soap_out_string(soap, "password", -1, &a->password, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "status", -1, &a->status, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__Usert * SOAP_FMAC4 soap_get_ns2__Usert(struct soap *soap, struct ns2__Usert *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__Usert(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Usert * SOAP_FMAC4 soap_in_ns2__Usert(struct soap *soap, const char *tag, struct ns2__Usert *a, const char *type)
{
	size_t soap_flag_password = 1;
	size_t soap_flag_status = 1;
	size_t soap_flag_username = 1;
	size_t soap_flag_timestamp = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__Usert *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__Usert, sizeof(struct ns2__Usert), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__Usert(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_password && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "password", &a->password, "xsd:string"))
				{	soap_flag_password--;
					continue;
				}
			if (soap_flag_status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "status", &a->status, "xsd:int"))
				{	soap_flag_status--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__Usert *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__Usert, 0, sizeof(struct ns2__Usert), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerRegister(struct soap *soap, struct ns5__PeerRegister *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->timestamp = NULL;
	a->updatenum = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerRegister(struct soap *soap, const struct ns5__PeerRegister *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToLONG64(soap, &a->updatenum);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerRegister(struct soap *soap, const struct ns5__PeerRegister *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerRegister);
	if (soap_out_ns5__PeerRegister(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerRegister(struct soap *soap, const char *tag, int id, const struct ns5__PeerRegister *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerRegister), type))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "updatenum", -1, &a->updatenum, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerRegister * SOAP_FMAC4 soap_get_ns5__PeerRegister(struct soap *soap, struct ns5__PeerRegister *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerRegister(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerRegister * SOAP_FMAC4 soap_in_ns5__PeerRegister(struct soap *soap, const char *tag, struct ns5__PeerRegister *a, const char *type)
{
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_updatenum = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerRegister *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerRegister, sizeof(struct ns5__PeerRegister), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerRegister(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_updatenum && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "updatenum", &a->updatenum, "xsd:long"))
				{	soap_flag_updatenum--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerRegister *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerRegister, 0, sizeof(struct ns5__PeerRegister), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerEventType(struct soap *soap, struct ns5__PeerEventType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerEventType(struct soap *soap, const struct ns5__PeerEventType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerEventType(struct soap *soap, const struct ns5__PeerEventType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerEventType);
	if (soap_out_ns5__PeerEventType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerEventType(struct soap *soap, const char *tag, int id, const struct ns5__PeerEventType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerEventType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerEventType * SOAP_FMAC4 soap_get_ns5__PeerEventType(struct soap *soap, struct ns5__PeerEventType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerEventType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerEventType * SOAP_FMAC4 soap_in_ns5__PeerEventType(struct soap *soap, const char *tag, struct ns5__PeerEventType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerEventType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerEventType, sizeof(struct ns5__PeerEventType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerEventType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerEventType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerEventType, 0, sizeof(struct ns5__PeerEventType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionType(struct soap *soap, struct ns5__PeerConnectionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionType(struct soap *soap, const struct ns5__PeerConnectionType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionType(struct soap *soap, const struct ns5__PeerConnectionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionType);
	if (soap_out_ns5__PeerConnectionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionType(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionType * SOAP_FMAC4 soap_get_ns5__PeerConnectionType(struct soap *soap, struct ns5__PeerConnectionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionType * SOAP_FMAC4 soap_in_ns5__PeerConnectionType(struct soap *soap, const char *tag, struct ns5__PeerConnectionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionType, sizeof(struct ns5__PeerConnectionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionType, 0, sizeof(struct ns5__PeerConnectionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionStats(struct soap *soap, struct ns5__PeerConnectionStats *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->numFormed = NULL;
	a->numOpened = NULL;
	a->numTotal = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionStats(struct soap *soap, const struct ns5__PeerConnectionStats *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->numFormed);
	soap_serialize_PointerToLONG64(soap, &a->numOpened);
	soap_serialize_PointerToLONG64(soap, &a->numTotal);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionStats(struct soap *soap, const struct ns5__PeerConnectionStats *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionStats);
	if (soap_out_ns5__PeerConnectionStats(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionStats(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionStats *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionStats), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "numFormed", -1, &a->numFormed, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "numOpened", -1, &a->numOpened, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "numTotal", -1, &a->numTotal, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionStats * SOAP_FMAC4 soap_get_ns5__PeerConnectionStats(struct soap *soap, struct ns5__PeerConnectionStats *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionStats(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionStats * SOAP_FMAC4 soap_in_ns5__PeerConnectionStats(struct soap *soap, const char *tag, struct ns5__PeerConnectionStats *a, const char *type)
{
	size_t soap_flag_numFormed = 1;
	size_t soap_flag_numOpened = 1;
	size_t soap_flag_numTotal = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionStats *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionStats, sizeof(struct ns5__PeerConnectionStats), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionStats(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_numFormed && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "numFormed", &a->numFormed, "xsd:long"))
				{	soap_flag_numFormed--;
					continue;
				}
			if (soap_flag_numOpened && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "numOpened", &a->numOpened, "xsd:long"))
				{	soap_flag_numOpened--;
					continue;
				}
			if (soap_flag_numTotal && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "numTotal", &a->numTotal, "xsd:long"))
				{	soap_flag_numTotal--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionStats *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionStats, 0, sizeof(struct ns5__PeerConnectionStats), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionState(struct soap *soap, struct ns5__PeerConnectionState *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionState(struct soap *soap, const struct ns5__PeerConnectionState *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionState(struct soap *soap, const struct ns5__PeerConnectionState *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionState);
	if (soap_out_ns5__PeerConnectionState(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionState(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionState *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionState), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionState * SOAP_FMAC4 soap_get_ns5__PeerConnectionState(struct soap *soap, struct ns5__PeerConnectionState *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionState(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionState * SOAP_FMAC4 soap_in_ns5__PeerConnectionState(struct soap *soap, const char *tag, struct ns5__PeerConnectionState *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionState *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionState, sizeof(struct ns5__PeerConnectionState), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionState(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionState *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionState, 0, sizeof(struct ns5__PeerConnectionState), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionInfo(struct soap *soap, struct ns5__PeerConnectionInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->connectedStatus = NULL;
	soap_default_string(soap, &a->inip);
	a->inport = NULL;
	soap_default_string(soap, &a->ip);
	a->port = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionInfo(struct soap *soap, const struct ns5__PeerConnectionInfo *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->connectedStatus);
	soap_serialize_string(soap, &a->inip);
	soap_serialize_PointerToint(soap, &a->inport);
	soap_serialize_string(soap, &a->ip);
	soap_serialize_PointerToint(soap, &a->port);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionInfo(struct soap *soap, const struct ns5__PeerConnectionInfo *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionInfo);
	if (soap_out_ns5__PeerConnectionInfo(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionInfo(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionInfo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionInfo), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "connectedStatus", -1, &a->connectedStatus, ""))
		return soap->error;
	if (soap_out_string(soap, "inip", -1, &a->inip, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "inport", -1, &a->inport, ""))
		return soap->error;
	if (soap_out_string(soap, "ip", -1, &a->ip, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "port", -1, &a->port, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionInfo * SOAP_FMAC4 soap_get_ns5__PeerConnectionInfo(struct soap *soap, struct ns5__PeerConnectionInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionInfo * SOAP_FMAC4 soap_in_ns5__PeerConnectionInfo(struct soap *soap, const char *tag, struct ns5__PeerConnectionInfo *a, const char *type)
{
	size_t soap_flag_connectedStatus = 1;
	size_t soap_flag_inip = 1;
	size_t soap_flag_inport = 1;
	size_t soap_flag_ip = 1;
	size_t soap_flag_port = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionInfo *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionInfo, sizeof(struct ns5__PeerConnectionInfo), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionInfo(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_connectedStatus && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "connectedStatus", &a->connectedStatus, "xsd:int"))
				{	soap_flag_connectedStatus--;
					continue;
				}
			if (soap_flag_inip && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "inip", &a->inip, "xsd:string"))
				{	soap_flag_inip--;
					continue;
				}
			if (soap_flag_inport && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "inport", &a->inport, "xsd:int"))
				{	soap_flag_inport--;
					continue;
				}
			if (soap_flag_ip && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ip", &a->ip, "xsd:string"))
				{	soap_flag_ip--;
					continue;
				}
			if (soap_flag_port && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "port", &a->port, "xsd:int"))
				{	soap_flag_port--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionInfo, 0, sizeof(struct ns5__PeerConnectionInfo), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionConnectedStatus(struct soap *soap, struct ns5__PeerConnectionConnectedStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionConnectedStatus(struct soap *soap, const struct ns5__PeerConnectionConnectedStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionConnectedStatus(struct soap *soap, const struct ns5__PeerConnectionConnectedStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionConnectedStatus);
	if (soap_out_ns5__PeerConnectionConnectedStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionConnectedStatus(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionConnectedStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionConnectedStatus), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionConnectedStatus * SOAP_FMAC4 soap_get_ns5__PeerConnectionConnectedStatus(struct soap *soap, struct ns5__PeerConnectionConnectedStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionConnectedStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionConnectedStatus * SOAP_FMAC4 soap_in_ns5__PeerConnectionConnectedStatus(struct soap *soap, const char *tag, struct ns5__PeerConnectionConnectedStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionConnectedStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionConnectedStatus, sizeof(struct ns5__PeerConnectionConnectedStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionConnectedStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionConnectedStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionConnectedStatus, 0, sizeof(struct ns5__PeerConnectionConnectedStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnectionConnectStatus(struct soap *soap, struct ns5__PeerConnectionConnectStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnectionConnectStatus(struct soap *soap, const struct ns5__PeerConnectionConnectStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnectionConnectStatus(struct soap *soap, const struct ns5__PeerConnectionConnectStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnectionConnectStatus);
	if (soap_out_ns5__PeerConnectionConnectStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnectionConnectStatus(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnectionConnectStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnectionConnectStatus), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnectionConnectStatus * SOAP_FMAC4 soap_get_ns5__PeerConnectionConnectStatus(struct soap *soap, struct ns5__PeerConnectionConnectStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnectionConnectStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnectionConnectStatus * SOAP_FMAC4 soap_in_ns5__PeerConnectionConnectStatus(struct soap *soap, const char *tag, struct ns5__PeerConnectionConnectStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnectionConnectStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnectionConnectStatus, sizeof(struct ns5__PeerConnectionConnectStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnectionConnectStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnectionConnectStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnectionConnectStatus, 0, sizeof(struct ns5__PeerConnectionConnectStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerConnection(struct soap *soap, struct ns5__PeerConnection *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->assistId = NULL;
	a->cndir = NULL;
	a->cntry = NULL;
	a->cntype = NULL;
	a->connectStatus = NULL;
	a->id = NULL;
	a->info = NULL;
	soap_default_string(soap, &a->initiator);
	a->state = NULL;
	a->timestamp = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerConnection(struct soap *soap, const struct ns5__PeerConnection *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->assistId);
	soap_serialize_PointerToint(soap, &a->cndir);
	soap_serialize_PointerToint(soap, &a->cntry);
	soap_serialize_PointerToint(soap, &a->cntype);
	soap_serialize_PointerToint(soap, &a->connectStatus);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->info);
	soap_serialize_string(soap, &a->initiator);
	soap_serialize_PointerToint(soap, &a->state);
	soap_serialize_PointerTotime(soap, &a->timestamp);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerConnection(struct soap *soap, const struct ns5__PeerConnection *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerConnection);
	if (soap_out_ns5__PeerConnection(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerConnection(struct soap *soap, const char *tag, int id, const struct ns5__PeerConnection *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerConnection), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "assistId", -1, &a->assistId, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cndir", -1, &a->cndir, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntry", -1, &a->cntry, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "cntype", -1, &a->cntype, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "connectStatus", -1, &a->connectStatus, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "info", -1, &a->info, ""))
		return soap->error;
	if (soap_out_string(soap, "initiator", -1, &a->initiator, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "state", -1, &a->state, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerConnection * SOAP_FMAC4 soap_get_ns5__PeerConnection(struct soap *soap, struct ns5__PeerConnection *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerConnection(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerConnection * SOAP_FMAC4 soap_in_ns5__PeerConnection(struct soap *soap, const char *tag, struct ns5__PeerConnection *a, const char *type)
{
	size_t soap_flag_assistId = 1;
	size_t soap_flag_cndir = 1;
	size_t soap_flag_cntry = 1;
	size_t soap_flag_cntype = 1;
	size_t soap_flag_connectStatus = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_info = 1;
	size_t soap_flag_initiator = 1;
	size_t soap_flag_state = 1;
	size_t soap_flag_timestamp = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerConnection *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerConnection, sizeof(struct ns5__PeerConnection), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerConnection(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_assistId && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "assistId", &a->assistId, "xsd:long"))
				{	soap_flag_assistId--;
					continue;
				}
			if (soap_flag_cndir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cndir", &a->cndir, "xsd:int"))
				{	soap_flag_cndir--;
					continue;
				}
			if (soap_flag_cntry && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntry", &a->cntry, "xsd:int"))
				{	soap_flag_cntry--;
					continue;
				}
			if (soap_flag_cntype && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "cntype", &a->cntype, "xsd:int"))
				{	soap_flag_cntype--;
					continue;
				}
			if (soap_flag_connectStatus && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "connectStatus", &a->connectStatus, "xsd:int"))
				{	soap_flag_connectStatus--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_info && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "info", &a->info, ""))
				{	soap_flag_info--;
					continue;
				}
			if (soap_flag_initiator && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "initiator", &a->initiator, "xsd:string"))
				{	soap_flag_initiator--;
					continue;
				}
			if (soap_flag_state && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "state", &a->state, "xsd:int"))
				{	soap_flag_state--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerConnection *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerConnection, 0, sizeof(struct ns5__PeerConnection), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerEvent(struct soap *soap, struct ns5__PeerEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->timestamp = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerEvent(struct soap *soap, const struct ns5__PeerEvent *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerEvent(struct soap *soap, const struct ns5__PeerEvent *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerEvent);
	if (soap_out_ns5__PeerEvent(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerEvent(struct soap *soap, const char *tag, int id, const struct ns5__PeerEvent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerEvent), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerEvent * SOAP_FMAC4 soap_get_ns5__PeerEvent(struct soap *soap, struct ns5__PeerEvent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerEvent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerEvent * SOAP_FMAC4 soap_in_ns5__PeerEvent(struct soap *soap, const char *tag, struct ns5__PeerEvent *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerEvent *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerEvent, sizeof(struct ns5__PeerEvent), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerEvent(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerEvent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerEvent, 0, sizeof(struct ns5__PeerEvent), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerAssistAttr(struct soap *soap, struct ns5__PeerAssistAttr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->name);
	a->timestamp = NULL;
	soap_default_string(soap, &a->value);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerAssistAttr(struct soap *soap, const struct ns5__PeerAssistAttr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->name);
	soap_serialize_PointerTotime(soap, &a->timestamp);
	soap_serialize_string(soap, &a->value);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerAssistAttr(struct soap *soap, const struct ns5__PeerAssistAttr *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerAssistAttr);
	if (soap_out_ns5__PeerAssistAttr(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerAssistAttr(struct soap *soap, const char *tag, int id, const struct ns5__PeerAssistAttr *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerAssistAttr), type))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &a->name, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "timestamp", -1, &a->timestamp, ""))
		return soap->error;
	if (soap_out_string(soap, "value", -1, &a->value, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerAssistAttr * SOAP_FMAC4 soap_get_ns5__PeerAssistAttr(struct soap *soap, struct ns5__PeerAssistAttr *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerAssistAttr(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerAssistAttr * SOAP_FMAC4 soap_in_ns5__PeerAssistAttr(struct soap *soap, const char *tag, struct ns5__PeerAssistAttr *a, const char *type)
{
	size_t soap_flag_name = 1;
	size_t soap_flag_timestamp = 1;
	size_t soap_flag_value = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerAssistAttr *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerAssistAttr, sizeof(struct ns5__PeerAssistAttr), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerAssistAttr(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &a->name, "xsd:string"))
				{	soap_flag_name--;
					continue;
				}
			if (soap_flag_timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "timestamp", &a->timestamp, "xsd:dateTime"))
				{	soap_flag_timestamp--;
					continue;
				}
			if (soap_flag_value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &a->value, "xsd:string"))
				{	soap_flag_value--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerAssistAttr *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerAssistAttr, 0, sizeof(struct ns5__PeerAssistAttr), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerAssist(struct soap *soap, struct ns5__PeerAssist *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->addr);
	a->id = NULL;
	soap_default_string(soap, &a->name);
	a->port = NULL;
	a->state = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerAssist(struct soap *soap, const struct ns5__PeerAssist *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->addr);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_string(soap, &a->name);
	soap_serialize_PointerToint(soap, &a->port);
	soap_serialize_PointerToint(soap, &a->state);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerAssist(struct soap *soap, const struct ns5__PeerAssist *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerAssist);
	if (soap_out_ns5__PeerAssist(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerAssist(struct soap *soap, const char *tag, int id, const struct ns5__PeerAssist *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerAssist), type))
		return soap->error;
	if (soap_out_string(soap, "addr", -1, &a->addr, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &a->name, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "port", -1, &a->port, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "state", -1, &a->state, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerAssist * SOAP_FMAC4 soap_get_ns5__PeerAssist(struct soap *soap, struct ns5__PeerAssist *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerAssist(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerAssist * SOAP_FMAC4 soap_in_ns5__PeerAssist(struct soap *soap, const char *tag, struct ns5__PeerAssist *a, const char *type)
{
	size_t soap_flag_addr = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_name = 1;
	size_t soap_flag_port = 1;
	size_t soap_flag_state = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerAssist *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerAssist, sizeof(struct ns5__PeerAssist), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerAssist(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_addr && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "addr", &a->addr, "xsd:string"))
				{	soap_flag_addr--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &a->name, "xsd:string"))
				{	soap_flag_name--;
					continue;
				}
			if (soap_flag_port && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "port", &a->port, "xsd:int"))
				{	soap_flag_port--;
					continue;
				}
			if (soap_flag_state && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "state", &a->state, "xsd:int"))
				{	soap_flag_state--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerAssist *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerAssist, 0, sizeof(struct ns5__PeerAssist), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns5__PeerAccess(struct soap *soap, struct ns5__PeerAccess *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->access = NULL;
	a->updatenum = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns5__PeerAccess(struct soap *soap, const struct ns5__PeerAccess *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTotime(soap, &a->access);
	soap_serialize_PointerToLONG64(soap, &a->updatenum);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns5__PeerAccess(struct soap *soap, const struct ns5__PeerAccess *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns5__PeerAccess);
	if (soap_out_ns5__PeerAccess(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns5__PeerAccess(struct soap *soap, const char *tag, int id, const struct ns5__PeerAccess *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns5__PeerAccess), type))
		return soap->error;
	if (soap_out_PointerTotime(soap, "access", -1, &a->access, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "updatenum", -1, &a->updatenum, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns5__PeerAccess * SOAP_FMAC4 soap_get_ns5__PeerAccess(struct soap *soap, struct ns5__PeerAccess *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns5__PeerAccess(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns5__PeerAccess * SOAP_FMAC4 soap_in_ns5__PeerAccess(struct soap *soap, const char *tag, struct ns5__PeerAccess *a, const char *type)
{
	size_t soap_flag_access = 1;
	size_t soap_flag_updatenum = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns5__PeerAccess *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns5__PeerAccess, sizeof(struct ns5__PeerAccess), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns5__PeerAccess(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_access && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "access", &a->access, "xsd:dateTime"))
				{	soap_flag_access--;
					continue;
				}
			if (soap_flag_updatenum && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "updatenum", &a->updatenum, "xsd:long"))
				{	soap_flag_updatenum--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns5__PeerAccess *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns5__PeerAccess, 0, sizeof(struct ns5__PeerAccess), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__NotificationType(struct soap *soap, struct ns4__NotificationType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__NotificationType(struct soap *soap, const struct ns4__NotificationType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__NotificationType(struct soap *soap, const struct ns4__NotificationType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__NotificationType);
	if (soap_out_ns4__NotificationType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__NotificationType(struct soap *soap, const char *tag, int id, const struct ns4__NotificationType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__NotificationType), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__NotificationType * SOAP_FMAC4 soap_get_ns4__NotificationType(struct soap *soap, struct ns4__NotificationType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__NotificationType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__NotificationType * SOAP_FMAC4 soap_in_ns4__NotificationType(struct soap *soap, const char *tag, struct ns4__NotificationType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__NotificationType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__NotificationType, sizeof(struct ns4__NotificationType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__NotificationType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__NotificationType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__NotificationType, 0, sizeof(struct ns4__NotificationType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__Notification(struct soap *soap, struct ns4__Notification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->type = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__Notification(struct soap *soap, const struct ns4__Notification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToint(soap, &a->type);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__Notification(struct soap *soap, const struct ns4__Notification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__Notification);
	if (soap_out_ns4__Notification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__Notification(struct soap *soap, const char *tag, int id, const struct ns4__Notification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__Notification), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "type", -1, &a->type, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__Notification * SOAP_FMAC4 soap_get_ns4__Notification(struct soap *soap, struct ns4__Notification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__Notification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__Notification * SOAP_FMAC4 soap_in_ns4__Notification(struct soap *soap, const char *tag, struct ns4__Notification *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_type = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__Notification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__Notification, sizeof(struct ns4__Notification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__Notification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_type && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "type", &a->type, "xsd:int"))
				{	soap_flag_type--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__Notification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__Notification, 0, sizeof(struct ns4__Notification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns3__Vector(struct soap *soap, struct ns3__Vector *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeitem = 0;
	a->item = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns3__Vector(struct soap *soap, const struct ns3__Vector *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns3__Vector(struct soap *soap, const struct ns3__Vector *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns3__Vector);
	if (soap_out_ns3__Vector(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__Vector(struct soap *soap, const char *tag, int id, const struct ns3__Vector *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__Vector), type))
		return soap->error;
	if (a->item)
	{	int i;
		for (i = 0; i < a->__sizeitem; i++)
			soap_outliteral(soap, "item", a->item + i, NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns3__Vector * SOAP_FMAC4 soap_get_ns3__Vector(struct soap *soap, struct ns3__Vector *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__Vector(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns3__Vector * SOAP_FMAC4 soap_in_ns3__Vector(struct soap *soap, const char *tag, struct ns3__Vector *a, const char *type)
{
	struct soap_blist *soap_blist_item = NULL;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns3__Vector *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__Vector, sizeof(struct ns3__Vector), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns3__Vector(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH && !soap_element_begin_in(soap, "item", 1, NULL))
			{	if (a->item == NULL)
				{	if (soap_blist_item == NULL)
						soap_blist_item = soap_new_block(soap);
					a->item = (char **)soap_push_block(soap, soap_blist_item, sizeof(char *));
					if (a->item == NULL)
						return NULL;
					*a->item = NULL;
				}soap_revert(soap);
				if (soap_inliteral(soap, "item", a->item))
				{	a->__sizeitem++;
					a->item = NULL;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (a->item)
			soap_pop_block(soap, soap_blist_item);
		if (a->__sizeitem)
			a->item = (char **)soap_save_block(soap, soap_blist_item, NULL, 1);
		else
		{	a->item = NULL;
			if (soap_blist_item)
				soap_end_block(soap, soap_blist_item);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns3__Vector *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__Vector, 0, sizeof(struct ns3__Vector), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__UserStats(struct soap *soap, struct ns2__UserStats *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->numActive = NULL;
	a->numSignup = NULL;
	a->numTotal = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__UserStats(struct soap *soap, const struct ns2__UserStats *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->numActive);
	soap_serialize_PointerToLONG64(soap, &a->numSignup);
	soap_serialize_PointerToLONG64(soap, &a->numTotal);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__UserStats(struct soap *soap, const struct ns2__UserStats *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__UserStats);
	if (soap_out_ns2__UserStats(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__UserStats(struct soap *soap, const char *tag, int id, const struct ns2__UserStats *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__UserStats), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "numActive", -1, &a->numActive, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "numSignup", -1, &a->numSignup, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "numTotal", -1, &a->numTotal, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__UserStats * SOAP_FMAC4 soap_get_ns2__UserStats(struct soap *soap, struct ns2__UserStats *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__UserStats(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__UserStats * SOAP_FMAC4 soap_in_ns2__UserStats(struct soap *soap, const char *tag, struct ns2__UserStats *a, const char *type)
{
	size_t soap_flag_numActive = 1;
	size_t soap_flag_numSignup = 1;
	size_t soap_flag_numTotal = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__UserStats *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__UserStats, sizeof(struct ns2__UserStats), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__UserStats(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_numActive && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "numActive", &a->numActive, "xsd:long"))
				{	soap_flag_numActive--;
					continue;
				}
			if (soap_flag_numSignup && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "numSignup", &a->numSignup, "xsd:long"))
				{	soap_flag_numSignup--;
					continue;
				}
			if (soap_flag_numTotal && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "numTotal", &a->numTotal, "xsd:long"))
				{	soap_flag_numTotal--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__UserStats *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__UserStats, 0, sizeof(struct ns2__UserStats), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__UserAttr(struct soap *soap, struct ns2__UserAttr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->lvalue = NULL;
	soap_default_string(soap, &a->name);
	soap_default_string(soap, &a->value);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__UserAttr(struct soap *soap, const struct ns2__UserAttr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->lvalue);
	soap_serialize_string(soap, &a->name);
	soap_serialize_string(soap, &a->value);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__UserAttr(struct soap *soap, const struct ns2__UserAttr *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__UserAttr);
	if (soap_out_ns2__UserAttr(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__UserAttr(struct soap *soap, const char *tag, int id, const struct ns2__UserAttr *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__UserAttr), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "lvalue", -1, &a->lvalue, ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &a->name, ""))
		return soap->error;
	if (soap_out_string(soap, "value", -1, &a->value, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__UserAttr * SOAP_FMAC4 soap_get_ns2__UserAttr(struct soap *soap, struct ns2__UserAttr *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__UserAttr(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__UserAttr * SOAP_FMAC4 soap_in_ns2__UserAttr(struct soap *soap, const char *tag, struct ns2__UserAttr *a, const char *type)
{
	size_t soap_flag_lvalue = 1;
	size_t soap_flag_name = 1;
	size_t soap_flag_value = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__UserAttr *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__UserAttr, sizeof(struct ns2__UserAttr), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__UserAttr(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lvalue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "lvalue", &a->lvalue, "xsd:long"))
				{	soap_flag_lvalue--;
					continue;
				}
			if (soap_flag_name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &a->name, "xsd:string"))
				{	soap_flag_name--;
					continue;
				}
			if (soap_flag_value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &a->value, "xsd:string"))
				{	soap_flag_value--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__UserAttr *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__UserAttr, 0, sizeof(struct ns2__UserAttr), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__SystemNotification(struct soap *soap, struct ns2__SystemNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->active = NULL;
	soap_default_string(soap, &a->description);
	a->enddate = NULL;
	a->id = NULL;
	soap_default_string(soap, &a->reminder);
	a->startdate = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__SystemNotification(struct soap *soap, const struct ns2__SystemNotification *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->active);
	soap_serialize_string(soap, &a->description);
	soap_serialize_PointerTotime(soap, &a->enddate);
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_string(soap, &a->reminder);
	soap_serialize_PointerTotime(soap, &a->startdate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__SystemNotification(struct soap *soap, const struct ns2__SystemNotification *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__SystemNotification);
	if (soap_out_ns2__SystemNotification(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__SystemNotification(struct soap *soap, const char *tag, int id, const struct ns2__SystemNotification *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__SystemNotification), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "active", -1, &a->active, ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &a->description, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "enddate", -1, &a->enddate, ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_string(soap, "reminder", -1, &a->reminder, ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "startdate", -1, &a->startdate, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__SystemNotification * SOAP_FMAC4 soap_get_ns2__SystemNotification(struct soap *soap, struct ns2__SystemNotification *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__SystemNotification(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__SystemNotification * SOAP_FMAC4 soap_in_ns2__SystemNotification(struct soap *soap, const char *tag, struct ns2__SystemNotification *a, const char *type)
{
	size_t soap_flag_active = 1;
	size_t soap_flag_description = 1;
	size_t soap_flag_enddate = 1;
	size_t soap_flag_id = 1;
	size_t soap_flag_reminder = 1;
	size_t soap_flag_startdate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__SystemNotification *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__SystemNotification, sizeof(struct ns2__SystemNotification), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__SystemNotification(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_active && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "active", &a->active, "xsd:int"))
				{	soap_flag_active--;
					continue;
				}
			if (soap_flag_description && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &a->description, "xsd:string"))
				{	soap_flag_description--;
					continue;
				}
			if (soap_flag_enddate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "enddate", &a->enddate, "xsd:dateTime"))
				{	soap_flag_enddate--;
					continue;
				}
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_reminder && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "reminder", &a->reminder, "xsd:string"))
				{	soap_flag_reminder--;
					continue;
				}
			if (soap_flag_startdate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "startdate", &a->startdate, "xsd:dateTime"))
				{	soap_flag_startdate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__SystemNotification *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__SystemNotification, 0, sizeof(struct ns2__SystemNotification), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__IPAttr(struct soap *soap, struct ns2__IPAttr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->lvalue = NULL;
	soap_default_string(soap, &a->name);
	soap_default_string(soap, &a->value);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__IPAttr(struct soap *soap, const struct ns2__IPAttr *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->lvalue);
	soap_serialize_string(soap, &a->name);
	soap_serialize_string(soap, &a->value);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__IPAttr(struct soap *soap, const struct ns2__IPAttr *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__IPAttr);
	if (soap_out_ns2__IPAttr(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__IPAttr(struct soap *soap, const char *tag, int id, const struct ns2__IPAttr *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__IPAttr), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "lvalue", -1, &a->lvalue, ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &a->name, ""))
		return soap->error;
	if (soap_out_string(soap, "value", -1, &a->value, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__IPAttr * SOAP_FMAC4 soap_get_ns2__IPAttr(struct soap *soap, struct ns2__IPAttr *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__IPAttr(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__IPAttr * SOAP_FMAC4 soap_in_ns2__IPAttr(struct soap *soap, const char *tag, struct ns2__IPAttr *a, const char *type)
{
	size_t soap_flag_lvalue = 1;
	size_t soap_flag_name = 1;
	size_t soap_flag_value = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__IPAttr *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__IPAttr, sizeof(struct ns2__IPAttr), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__IPAttr(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_lvalue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "lvalue", &a->lvalue, "xsd:long"))
				{	soap_flag_lvalue--;
					continue;
				}
			if (soap_flag_name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &a->name, "xsd:string"))
				{	soap_flag_name--;
					continue;
				}
			if (soap_flag_value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "value", &a->value, "xsd:string"))
				{	soap_flag_value--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__IPAttr *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__IPAttr, 0, sizeof(struct ns2__IPAttr), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__IPAddress(struct soap *soap, struct ns2__IPAddress *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->ip);
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__IPAddress(struct soap *soap, const struct ns2__IPAddress *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->ip);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__IPAddress(struct soap *soap, const struct ns2__IPAddress *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__IPAddress);
	if (soap_out_ns2__IPAddress(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__IPAddress(struct soap *soap, const char *tag, int id, const struct ns2__IPAddress *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__IPAddress), type))
		return soap->error;
	if (soap_out_string(soap, "ip", -1, &a->ip, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__IPAddress * SOAP_FMAC4 soap_get_ns2__IPAddress(struct soap *soap, struct ns2__IPAddress *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__IPAddress(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__IPAddress * SOAP_FMAC4 soap_in_ns2__IPAddress(struct soap *soap, const char *tag, struct ns2__IPAddress *a, const char *type)
{
	size_t soap_flag_ip = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__IPAddress *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__IPAddress, sizeof(struct ns2__IPAddress), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__IPAddress(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ip && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ip", &a->ip, "xsd:string"))
				{	soap_flag_ip--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__IPAddress *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__IPAddress, 0, sizeof(struct ns2__IPAddress), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__User(struct soap *soap, struct ns2__User *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->password);
	a->status = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__User(struct soap *soap, const struct ns2__User *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->password);
	soap_serialize_PointerToint(soap, &a->status);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__User(struct soap *soap, const struct ns2__User *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__User);
	if (soap_out_ns2__User(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__User(struct soap *soap, const char *tag, int id, const struct ns2__User *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__User), type))
		return soap->error;
	if (soap_out_string(soap, "password", -1, &a->password, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "status", -1, &a->status, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__User * SOAP_FMAC4 soap_get_ns2__User(struct soap *soap, struct ns2__User *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__User(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__User * SOAP_FMAC4 soap_in_ns2__User(struct soap *soap, const char *tag, struct ns2__User *a, const char *type)
{
	size_t soap_flag_password = 1;
	size_t soap_flag_status = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__User *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__User, sizeof(struct ns2__User), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__User(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_password && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "password", &a->password, "xsd:string"))
				{	soap_flag_password--;
					continue;
				}
			if (soap_flag_status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "status", &a->status, "xsd:int"))
				{	soap_flag_status--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__User *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__User, 0, sizeof(struct ns2__User), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__Member(struct soap *soap, struct ns2__Member *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->status = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__Member(struct soap *soap, const struct ns2__Member *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToint(soap, &a->status);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__Member(struct soap *soap, const struct ns2__Member *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__Member);
	if (soap_out_ns2__Member(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__Member(struct soap *soap, const char *tag, int id, const struct ns2__Member *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__Member), type))
		return soap->error;
	if (soap_out_PointerToint(soap, "status", -1, &a->status, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__Member * SOAP_FMAC4 soap_get_ns2__Member(struct soap *soap, struct ns2__Member *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__Member(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Member * SOAP_FMAC4 soap_in_ns2__Member(struct soap *soap, const char *tag, struct ns2__Member *a, const char *type)
{
	size_t soap_flag_status = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__Member *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__Member, sizeof(struct ns2__Member), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__Member(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "status", &a->status, "xsd:int"))
				{	soap_flag_status--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__Member *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__Member, 0, sizeof(struct ns2__Member), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ArrayOf_USCORExsd_USCOREanyType(struct soap *soap, struct ArrayOf_USCORExsd_USCOREanyType *a)
{
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ArrayOf_USCORExsd_USCOREanyType(struct soap *soap, struct ArrayOf_USCORExsd_USCOREanyType const*a)
{
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ArrayOf_USCORExsd_USCOREanyType(struct soap *soap, const struct ArrayOf_USCORExsd_USCOREanyType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType);
	if (soap_out_ArrayOf_USCORExsd_USCOREanyType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCORExsd_USCOREanyType(struct soap *soap, const char *tag, int id, const struct ArrayOf_USCORExsd_USCOREanyType *a, const char *type)
{
	int i, n = a->__size;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType);
	if (id < 0)
		return soap->error;
	if (soap_element_begin_out(soap, tag, id, type))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap_outliteral(soap, "item", &a->__ptr[i], NULL);
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ArrayOf_USCORExsd_USCOREanyType * SOAP_FMAC4 soap_get_ArrayOf_USCORExsd_USCOREanyType(struct soap *soap, struct ArrayOf_USCORExsd_USCOREanyType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCORExsd_USCOREanyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOf_USCORExsd_USCOREanyType * SOAP_FMAC4 soap_in_ArrayOf_USCORExsd_USCOREanyType(struct soap *soap, const char *tag, struct ArrayOf_USCORExsd_USCOREanyType *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_array(soap, "") && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ArrayOf_USCORExsd_USCOREanyType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType, sizeof(struct ArrayOf_USCORExsd_USCOREanyType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ArrayOf_USCORExsd_USCOREanyType(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_inliteral(soap, NULL, a->__ptr + i))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, NULL, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_inliteral(soap, NULL, p))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ArrayOf_USCORExsd_USCOREanyType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType, 0, sizeof(struct ArrayOf_USCORExsd_USCOREanyType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__Network(struct soap *soap, struct ns2__Network *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->id = NULL;
	a->members = NULL;
	soap_default_string(soap, &a->name);
	soap_default_string(soap, &a->owner);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__Network(struct soap *soap, const struct ns2__Network *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToLONG64(soap, &a->id);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(soap, &a->members);
	soap_serialize_string(soap, &a->name);
	soap_serialize_string(soap, &a->owner);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__Network(struct soap *soap, const struct ns2__Network *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__Network);
	if (soap_out_ns2__Network(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__Network(struct soap *soap, const char *tag, int id, const struct ns2__Network *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__Network), type))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &a->id, ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "members", -1, &a->members, ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &a->name, ""))
		return soap->error;
	if (soap_out_string(soap, "owner", -1, &a->owner, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__Network * SOAP_FMAC4 soap_get_ns2__Network(struct soap *soap, struct ns2__Network *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__Network(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Network * SOAP_FMAC4 soap_in_ns2__Network(struct soap *soap, const char *tag, struct ns2__Network *a, const char *type)
{
	size_t soap_flag_id = 1;
	size_t soap_flag_members = 1;
	size_t soap_flag_name = 1;
	size_t soap_flag_owner = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__Network *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__Network, sizeof(struct ns2__Network), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__Network(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &a->id, "xsd:long"))
				{	soap_flag_id--;
					continue;
				}
			if (soap_flag_members && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, "members", &a->members, ""))
				{	soap_flag_members--;
					continue;
				}
			if (soap_flag_name && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &a->name, "xsd:string"))
				{	soap_flag_name--;
					continue;
				}
			if (soap_flag_owner && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "owner", &a->owner, "xsd:string"))
				{	soap_flag_owner--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__Network *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__Network, 0, sizeof(struct ns2__Network), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__Contact(struct soap *soap, struct ns2__Contact *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->email);
	soap_default_string(soap, &a->fname);
	soap_default_string(soap, &a->lname);
	a->userStatus = NULL;
	soap_default_string(soap, &a->username);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__Contact(struct soap *soap, const struct ns2__Contact *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->email);
	soap_serialize_string(soap, &a->fname);
	soap_serialize_string(soap, &a->lname);
	soap_serialize_PointerToint(soap, &a->userStatus);
	soap_serialize_string(soap, &a->username);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__Contact(struct soap *soap, const struct ns2__Contact *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__Contact);
	if (soap_out_ns2__Contact(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__Contact(struct soap *soap, const char *tag, int id, const struct ns2__Contact *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__Contact), type))
		return soap->error;
	if (soap_out_string(soap, "email", -1, &a->email, ""))
		return soap->error;
	if (soap_out_string(soap, "fname", -1, &a->fname, ""))
		return soap->error;
	if (soap_out_string(soap, "lname", -1, &a->lname, ""))
		return soap->error;
	if (soap_out_PointerToint(soap, "userStatus", -1, &a->userStatus, ""))
		return soap->error;
	if (soap_out_string(soap, "username", -1, &a->username, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns2__Contact * SOAP_FMAC4 soap_get_ns2__Contact(struct soap *soap, struct ns2__Contact *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__Contact(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Contact * SOAP_FMAC4 soap_in_ns2__Contact(struct soap *soap, const char *tag, struct ns2__Contact *a, const char *type)
{
	size_t soap_flag_email = 1;
	size_t soap_flag_fname = 1;
	size_t soap_flag_lname = 1;
	size_t soap_flag_userStatus = 1;
	size_t soap_flag_username = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__Contact *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__Contact, sizeof(struct ns2__Contact), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__Contact(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_email && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "email", &a->email, "xsd:string"))
				{	soap_flag_email--;
					continue;
				}
			if (soap_flag_fname && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "fname", &a->fname, "xsd:string"))
				{	soap_flag_fname--;
					continue;
				}
			if (soap_flag_lname && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "lname", &a->lname, "xsd:string"))
				{	soap_flag_lname--;
					continue;
				}
			if (soap_flag_userStatus && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "userStatus", &a->userStatus, "xsd:int"))
				{	soap_flag_userStatus--;
					continue;
				}
			if (soap_flag_username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "username", &a->username, "xsd:string"))
				{	soap_flag_username--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__Contact *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__Contact, 0, sizeof(struct ns2__Contact), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->id = NULL;
	a->type = NULL;
	a->options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary const*a)
{
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__base64Binary))
		if (a->id || a->type)
			soap->mode |= SOAP_ENC_DIME;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__base64Binary(struct soap *soap, const struct xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (soap_out_xsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const struct xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_xsd__base64Binary);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
#endif
	if (id < 0)
		return soap->error;
	if (soap_element_begin_out(soap, tag, id, type))
		return soap->error;
	if (soap_putbase64(soap, a->__ptr, a->__size))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__base64Binary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__base64Binary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (struct xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(struct xsd__base64Binary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__getSystemNotificationsResponse(struct soap *soap, struct ns1__getSystemNotificationsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__getSystemNotificationsResponse))
		soap_serialize_ns1__getSystemNotificationsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__getSystemNotificationsResponse(struct soap *soap, struct ns1__getSystemNotificationsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__getSystemNotificationsResponse);
	if (soap_out_PointerTons1__getSystemNotificationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__getSystemNotificationsResponse(struct soap *soap, const char *tag, int id, struct ns1__getSystemNotificationsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__getSystemNotificationsResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__getSystemNotificationsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__getSystemNotificationsResponse ** SOAP_FMAC4 soap_get_PointerTons1__getSystemNotificationsResponse(struct soap *soap, struct ns1__getSystemNotificationsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__getSystemNotificationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getSystemNotificationsResponse ** SOAP_FMAC4 soap_in_PointerTons1__getSystemNotificationsResponse(struct soap *soap, const char *tag, struct ns1__getSystemNotificationsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__getSystemNotificationsResponse **)soap_malloc(soap, sizeof(struct ns1__getSystemNotificationsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__getSystemNotificationsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__getSystemNotificationsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__getSystemNotificationsResponse, sizeof(struct ns1__getSystemNotificationsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__getNotificationsResponse(struct soap *soap, struct ns1__getNotificationsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__getNotificationsResponse))
		soap_serialize_ns1__getNotificationsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__getNotificationsResponse(struct soap *soap, struct ns1__getNotificationsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__getNotificationsResponse);
	if (soap_out_PointerTons1__getNotificationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__getNotificationsResponse(struct soap *soap, const char *tag, int id, struct ns1__getNotificationsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__getNotificationsResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__getNotificationsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__getNotificationsResponse ** SOAP_FMAC4 soap_get_PointerTons1__getNotificationsResponse(struct soap *soap, struct ns1__getNotificationsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__getNotificationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNotificationsResponse ** SOAP_FMAC4 soap_in_PointerTons1__getNotificationsResponse(struct soap *soap, const char *tag, struct ns1__getNotificationsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__getNotificationsResponse **)soap_malloc(soap, sizeof(struct ns1__getNotificationsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__getNotificationsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__getNotificationsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__getNotificationsResponse, sizeof(struct ns1__getNotificationsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__getNetworkResponse(struct soap *soap, struct ns1__getNetworkResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__getNetworkResponse))
		soap_serialize_ns1__getNetworkResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__getNetworkResponse(struct soap *soap, struct ns1__getNetworkResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__getNetworkResponse);
	if (soap_out_PointerTons1__getNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__getNetworkResponse(struct soap *soap, const char *tag, int id, struct ns1__getNetworkResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__getNetworkResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__getNetworkResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__getNetworkResponse ** SOAP_FMAC4 soap_get_PointerTons1__getNetworkResponse(struct soap *soap, struct ns1__getNetworkResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__getNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNetworkResponse ** SOAP_FMAC4 soap_in_PointerTons1__getNetworkResponse(struct soap *soap, const char *tag, struct ns1__getNetworkResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__getNetworkResponse **)soap_malloc(soap, sizeof(struct ns1__getNetworkResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__getNetworkResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__getNetworkResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__getNetworkResponse, sizeof(struct ns1__getNetworkResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__getNetworksResponse(struct soap *soap, struct ns1__getNetworksResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__getNetworksResponse))
		soap_serialize_ns1__getNetworksResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__getNetworksResponse(struct soap *soap, struct ns1__getNetworksResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__getNetworksResponse);
	if (soap_out_PointerTons1__getNetworksResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__getNetworksResponse(struct soap *soap, const char *tag, int id, struct ns1__getNetworksResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__getNetworksResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__getNetworksResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__getNetworksResponse ** SOAP_FMAC4 soap_get_PointerTons1__getNetworksResponse(struct soap *soap, struct ns1__getNetworksResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__getNetworksResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getNetworksResponse ** SOAP_FMAC4 soap_in_PointerTons1__getNetworksResponse(struct soap *soap, const char *tag, struct ns1__getNetworksResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__getNetworksResponse **)soap_malloc(soap, sizeof(struct ns1__getNetworksResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__getNetworksResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__getNetworksResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__getNetworksResponse, sizeof(struct ns1__getNetworksResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__leaveNetworkResponse(struct soap *soap, struct ns1__leaveNetworkResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__leaveNetworkResponse))
		soap_serialize_ns1__leaveNetworkResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__leaveNetworkResponse(struct soap *soap, struct ns1__leaveNetworkResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__leaveNetworkResponse);
	if (soap_out_PointerTons1__leaveNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__leaveNetworkResponse(struct soap *soap, const char *tag, int id, struct ns1__leaveNetworkResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__leaveNetworkResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__leaveNetworkResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__leaveNetworkResponse ** SOAP_FMAC4 soap_get_PointerTons1__leaveNetworkResponse(struct soap *soap, struct ns1__leaveNetworkResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__leaveNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__leaveNetworkResponse ** SOAP_FMAC4 soap_in_PointerTons1__leaveNetworkResponse(struct soap *soap, const char *tag, struct ns1__leaveNetworkResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__leaveNetworkResponse **)soap_malloc(soap, sizeof(struct ns1__leaveNetworkResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__leaveNetworkResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__leaveNetworkResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__leaveNetworkResponse, sizeof(struct ns1__leaveNetworkResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__deleteNetworkMemberResponse(struct soap *soap, struct ns1__deleteNetworkMemberResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__deleteNetworkMemberResponse))
		soap_serialize_ns1__deleteNetworkMemberResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__deleteNetworkMemberResponse(struct soap *soap, struct ns1__deleteNetworkMemberResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__deleteNetworkMemberResponse);
	if (soap_out_PointerTons1__deleteNetworkMemberResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__deleteNetworkMemberResponse(struct soap *soap, const char *tag, int id, struct ns1__deleteNetworkMemberResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__deleteNetworkMemberResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__deleteNetworkMemberResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__deleteNetworkMemberResponse ** SOAP_FMAC4 soap_get_PointerTons1__deleteNetworkMemberResponse(struct soap *soap, struct ns1__deleteNetworkMemberResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__deleteNetworkMemberResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteNetworkMemberResponse ** SOAP_FMAC4 soap_in_PointerTons1__deleteNetworkMemberResponse(struct soap *soap, const char *tag, struct ns1__deleteNetworkMemberResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__deleteNetworkMemberResponse **)soap_malloc(soap, sizeof(struct ns1__deleteNetworkMemberResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__deleteNetworkMemberResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteNetworkMemberResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__deleteNetworkMemberResponse, sizeof(struct ns1__deleteNetworkMemberResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__declineNetworkInviteResponse(struct soap *soap, struct ns1__declineNetworkInviteResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__declineNetworkInviteResponse))
		soap_serialize_ns1__declineNetworkInviteResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__declineNetworkInviteResponse(struct soap *soap, struct ns1__declineNetworkInviteResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__declineNetworkInviteResponse);
	if (soap_out_PointerTons1__declineNetworkInviteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__declineNetworkInviteResponse(struct soap *soap, const char *tag, int id, struct ns1__declineNetworkInviteResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__declineNetworkInviteResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__declineNetworkInviteResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__declineNetworkInviteResponse ** SOAP_FMAC4 soap_get_PointerTons1__declineNetworkInviteResponse(struct soap *soap, struct ns1__declineNetworkInviteResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__declineNetworkInviteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__declineNetworkInviteResponse ** SOAP_FMAC4 soap_in_PointerTons1__declineNetworkInviteResponse(struct soap *soap, const char *tag, struct ns1__declineNetworkInviteResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__declineNetworkInviteResponse **)soap_malloc(soap, sizeof(struct ns1__declineNetworkInviteResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__declineNetworkInviteResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__declineNetworkInviteResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__declineNetworkInviteResponse, sizeof(struct ns1__declineNetworkInviteResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__acceptNetworkInviteResponse(struct soap *soap, struct ns1__acceptNetworkInviteResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__acceptNetworkInviteResponse))
		soap_serialize_ns1__acceptNetworkInviteResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__acceptNetworkInviteResponse(struct soap *soap, struct ns1__acceptNetworkInviteResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__acceptNetworkInviteResponse);
	if (soap_out_PointerTons1__acceptNetworkInviteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__acceptNetworkInviteResponse(struct soap *soap, const char *tag, int id, struct ns1__acceptNetworkInviteResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__acceptNetworkInviteResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__acceptNetworkInviteResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__acceptNetworkInviteResponse ** SOAP_FMAC4 soap_get_PointerTons1__acceptNetworkInviteResponse(struct soap *soap, struct ns1__acceptNetworkInviteResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__acceptNetworkInviteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__acceptNetworkInviteResponse ** SOAP_FMAC4 soap_in_PointerTons1__acceptNetworkInviteResponse(struct soap *soap, const char *tag, struct ns1__acceptNetworkInviteResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__acceptNetworkInviteResponse **)soap_malloc(soap, sizeof(struct ns1__acceptNetworkInviteResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__acceptNetworkInviteResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__acceptNetworkInviteResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__acceptNetworkInviteResponse, sizeof(struct ns1__acceptNetworkInviteResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__inviteNetworkMemberByUserResponse(struct soap *soap, struct ns1__inviteNetworkMemberByUserResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse))
		soap_serialize_ns1__inviteNetworkMemberByUserResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__inviteNetworkMemberByUserResponse(struct soap *soap, struct ns1__inviteNetworkMemberByUserResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__inviteNetworkMemberByUserResponse);
	if (soap_out_PointerTons1__inviteNetworkMemberByUserResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__inviteNetworkMemberByUserResponse(struct soap *soap, const char *tag, int id, struct ns1__inviteNetworkMemberByUserResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__inviteNetworkMemberByUserResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByUserResponse ** SOAP_FMAC4 soap_get_PointerTons1__inviteNetworkMemberByUserResponse(struct soap *soap, struct ns1__inviteNetworkMemberByUserResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__inviteNetworkMemberByUserResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByUserResponse ** SOAP_FMAC4 soap_in_PointerTons1__inviteNetworkMemberByUserResponse(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberByUserResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__inviteNetworkMemberByUserResponse **)soap_malloc(soap, sizeof(struct ns1__inviteNetworkMemberByUserResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__inviteNetworkMemberByUserResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberByUserResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__inviteNetworkMemberByUserResponse, sizeof(struct ns1__inviteNetworkMemberByUserResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__User(struct soap *soap, struct ns2__User *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__User))
		soap_serialize_ns2__User(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__User(struct soap *soap, struct ns2__User *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__User);
	if (soap_out_PointerTons2__User(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__User(struct soap *soap, const char *tag, int id, struct ns2__User *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__User);
	if (id < 0)
		return soap->error;
	return soap_out_ns2__User(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns2__User ** SOAP_FMAC4 soap_get_PointerTons2__User(struct soap *soap, struct ns2__User **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__User(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__User ** SOAP_FMAC4 soap_in_PointerTons2__User(struct soap *soap, const char *tag, struct ns2__User **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns2__User **)soap_malloc(soap, sizeof(struct ns2__User *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns2__User(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns2__User **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__User, sizeof(struct ns2__User), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__inviteNetworkMemberByEmailResponse(struct soap *soap, struct ns1__inviteNetworkMemberByEmailResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse))
		soap_serialize_ns1__inviteNetworkMemberByEmailResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__inviteNetworkMemberByEmailResponse(struct soap *soap, struct ns1__inviteNetworkMemberByEmailResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__inviteNetworkMemberByEmailResponse);
	if (soap_out_PointerTons1__inviteNetworkMemberByEmailResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__inviteNetworkMemberByEmailResponse(struct soap *soap, const char *tag, int id, struct ns1__inviteNetworkMemberByEmailResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__inviteNetworkMemberByEmailResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByEmailResponse ** SOAP_FMAC4 soap_get_PointerTons1__inviteNetworkMemberByEmailResponse(struct soap *soap, struct ns1__inviteNetworkMemberByEmailResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__inviteNetworkMemberByEmailResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberByEmailResponse ** SOAP_FMAC4 soap_in_PointerTons1__inviteNetworkMemberByEmailResponse(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberByEmailResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__inviteNetworkMemberByEmailResponse **)soap_malloc(soap, sizeof(struct ns1__inviteNetworkMemberByEmailResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__inviteNetworkMemberByEmailResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberByEmailResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__inviteNetworkMemberByEmailResponse, sizeof(struct ns1__inviteNetworkMemberByEmailResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__inviteNetworkMemberResponse(struct soap *soap, struct ns1__inviteNetworkMemberResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__inviteNetworkMemberResponse))
		soap_serialize_ns1__inviteNetworkMemberResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__inviteNetworkMemberResponse(struct soap *soap, struct ns1__inviteNetworkMemberResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__inviteNetworkMemberResponse);
	if (soap_out_PointerTons1__inviteNetworkMemberResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__inviteNetworkMemberResponse(struct soap *soap, const char *tag, int id, struct ns1__inviteNetworkMemberResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__inviteNetworkMemberResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__inviteNetworkMemberResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberResponse ** SOAP_FMAC4 soap_get_PointerTons1__inviteNetworkMemberResponse(struct soap *soap, struct ns1__inviteNetworkMemberResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__inviteNetworkMemberResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__inviteNetworkMemberResponse ** SOAP_FMAC4 soap_in_PointerTons1__inviteNetworkMemberResponse(struct soap *soap, const char *tag, struct ns1__inviteNetworkMemberResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__inviteNetworkMemberResponse **)soap_malloc(soap, sizeof(struct ns1__inviteNetworkMemberResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__inviteNetworkMemberResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__inviteNetworkMemberResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__inviteNetworkMemberResponse, sizeof(struct ns1__inviteNetworkMemberResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__Member(struct soap *soap, struct ns2__Member *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__Member))
		soap_serialize_ns2__Member(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__Member(struct soap *soap, struct ns2__Member *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__Member);
	if (soap_out_PointerTons2__Member(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__Member(struct soap *soap, const char *tag, int id, struct ns2__Member *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__Member);
	if (id < 0)
		return soap->error;
	return soap_out_ns2__Member(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns2__Member ** SOAP_FMAC4 soap_get_PointerTons2__Member(struct soap *soap, struct ns2__Member **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__Member(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Member ** SOAP_FMAC4 soap_in_PointerTons2__Member(struct soap *soap, const char *tag, struct ns2__Member **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns2__Member **)soap_malloc(soap, sizeof(struct ns2__Member *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns2__Member(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns2__Member **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__Member, sizeof(struct ns2__Member), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__deleteNetworkResponse(struct soap *soap, struct ns1__deleteNetworkResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__deleteNetworkResponse))
		soap_serialize_ns1__deleteNetworkResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__deleteNetworkResponse(struct soap *soap, struct ns1__deleteNetworkResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__deleteNetworkResponse);
	if (soap_out_PointerTons1__deleteNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__deleteNetworkResponse(struct soap *soap, const char *tag, int id, struct ns1__deleteNetworkResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__deleteNetworkResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__deleteNetworkResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__deleteNetworkResponse ** SOAP_FMAC4 soap_get_PointerTons1__deleteNetworkResponse(struct soap *soap, struct ns1__deleteNetworkResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__deleteNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteNetworkResponse ** SOAP_FMAC4 soap_in_PointerTons1__deleteNetworkResponse(struct soap *soap, const char *tag, struct ns1__deleteNetworkResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__deleteNetworkResponse **)soap_malloc(soap, sizeof(struct ns1__deleteNetworkResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__deleteNetworkResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteNetworkResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__deleteNetworkResponse, sizeof(struct ns1__deleteNetworkResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__addNetworkResponse(struct soap *soap, struct ns1__addNetworkResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__addNetworkResponse))
		soap_serialize_ns1__addNetworkResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__addNetworkResponse(struct soap *soap, struct ns1__addNetworkResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__addNetworkResponse);
	if (soap_out_PointerTons1__addNetworkResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__addNetworkResponse(struct soap *soap, const char *tag, int id, struct ns1__addNetworkResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__addNetworkResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__addNetworkResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__addNetworkResponse ** SOAP_FMAC4 soap_get_PointerTons1__addNetworkResponse(struct soap *soap, struct ns1__addNetworkResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__addNetworkResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__addNetworkResponse ** SOAP_FMAC4 soap_in_PointerTons1__addNetworkResponse(struct soap *soap, const char *tag, struct ns1__addNetworkResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__addNetworkResponse **)soap_malloc(soap, sizeof(struct ns1__addNetworkResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__addNetworkResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__addNetworkResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__addNetworkResponse, sizeof(struct ns1__addNetworkResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__Network(struct soap *soap, struct ns2__Network *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__Network))
		soap_serialize_ns2__Network(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__Network(struct soap *soap, struct ns2__Network *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__Network);
	if (soap_out_PointerTons2__Network(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__Network(struct soap *soap, const char *tag, int id, struct ns2__Network *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__Network);
	if (id < 0)
		return soap->error;
	return soap_out_ns2__Network(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns2__Network ** SOAP_FMAC4 soap_get_PointerTons2__Network(struct soap *soap, struct ns2__Network **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__Network(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Network ** SOAP_FMAC4 soap_in_PointerTons2__Network(struct soap *soap, const char *tag, struct ns2__Network **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns2__Network **)soap_malloc(soap, sizeof(struct ns2__Network *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns2__Network(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns2__Network **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__Network, sizeof(struct ns2__Network), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__lookupContactsResponse(struct soap *soap, struct ns1__lookupContactsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__lookupContactsResponse))
		soap_serialize_ns1__lookupContactsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__lookupContactsResponse(struct soap *soap, struct ns1__lookupContactsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__lookupContactsResponse);
	if (soap_out_PointerTons1__lookupContactsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__lookupContactsResponse(struct soap *soap, const char *tag, int id, struct ns1__lookupContactsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__lookupContactsResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__lookupContactsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__lookupContactsResponse ** SOAP_FMAC4 soap_get_PointerTons1__lookupContactsResponse(struct soap *soap, struct ns1__lookupContactsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__lookupContactsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__lookupContactsResponse ** SOAP_FMAC4 soap_in_PointerTons1__lookupContactsResponse(struct soap *soap, const char *tag, struct ns1__lookupContactsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__lookupContactsResponse **)soap_malloc(soap, sizeof(struct ns1__lookupContactsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__lookupContactsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__lookupContactsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__lookupContactsResponse, sizeof(struct ns1__lookupContactsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__getContactResponse(struct soap *soap, struct ns1__getContactResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__getContactResponse))
		soap_serialize_ns1__getContactResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__getContactResponse(struct soap *soap, struct ns1__getContactResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__getContactResponse);
	if (soap_out_PointerTons1__getContactResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__getContactResponse(struct soap *soap, const char *tag, int id, struct ns1__getContactResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__getContactResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__getContactResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__getContactResponse ** SOAP_FMAC4 soap_get_PointerTons1__getContactResponse(struct soap *soap, struct ns1__getContactResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__getContactResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__getContactResponse ** SOAP_FMAC4 soap_in_PointerTons1__getContactResponse(struct soap *soap, const char *tag, struct ns1__getContactResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__getContactResponse **)soap_malloc(soap, sizeof(struct ns1__getContactResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__getContactResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__getContactResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__getContactResponse, sizeof(struct ns1__getContactResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__updateContactResponse(struct soap *soap, struct ns1__updateContactResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__updateContactResponse))
		soap_serialize_ns1__updateContactResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__updateContactResponse(struct soap *soap, struct ns1__updateContactResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__updateContactResponse);
	if (soap_out_PointerTons1__updateContactResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__updateContactResponse(struct soap *soap, const char *tag, int id, struct ns1__updateContactResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__updateContactResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__updateContactResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__updateContactResponse ** SOAP_FMAC4 soap_get_PointerTons1__updateContactResponse(struct soap *soap, struct ns1__updateContactResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__updateContactResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__updateContactResponse ** SOAP_FMAC4 soap_in_PointerTons1__updateContactResponse(struct soap *soap, const char *tag, struct ns1__updateContactResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__updateContactResponse **)soap_malloc(soap, sizeof(struct ns1__updateContactResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__updateContactResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__updateContactResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__updateContactResponse, sizeof(struct ns1__updateContactResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons2__Contact(struct soap *soap, struct ns2__Contact *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns2__Contact))
		soap_serialize_ns2__Contact(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons2__Contact(struct soap *soap, struct ns2__Contact *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons2__Contact);
	if (soap_out_PointerTons2__Contact(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons2__Contact(struct soap *soap, const char *tag, int id, struct ns2__Contact *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns2__Contact);
	if (id < 0)
		return soap->error;
	return soap_out_ns2__Contact(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns2__Contact ** SOAP_FMAC4 soap_get_PointerTons2__Contact(struct soap *soap, struct ns2__Contact **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons2__Contact(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__Contact ** SOAP_FMAC4 soap_in_PointerTons2__Contact(struct soap *soap, const char *tag, struct ns2__Contact **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns2__Contact **)soap_malloc(soap, sizeof(struct ns2__Contact *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns2__Contact(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns2__Contact **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns2__Contact, sizeof(struct ns2__Contact), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__changePasswordResponse(struct soap *soap, struct ns1__changePasswordResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__changePasswordResponse))
		soap_serialize_ns1__changePasswordResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__changePasswordResponse(struct soap *soap, struct ns1__changePasswordResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__changePasswordResponse);
	if (soap_out_PointerTons1__changePasswordResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__changePasswordResponse(struct soap *soap, const char *tag, int id, struct ns1__changePasswordResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__changePasswordResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__changePasswordResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__changePasswordResponse ** SOAP_FMAC4 soap_get_PointerTons1__changePasswordResponse(struct soap *soap, struct ns1__changePasswordResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__changePasswordResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__changePasswordResponse ** SOAP_FMAC4 soap_in_PointerTons1__changePasswordResponse(struct soap *soap, const char *tag, struct ns1__changePasswordResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__changePasswordResponse **)soap_malloc(soap, sizeof(struct ns1__changePasswordResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__changePasswordResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__changePasswordResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__changePasswordResponse, sizeof(struct ns1__changePasswordResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__deleteUserResponse(struct soap *soap, struct ns1__deleteUserResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__deleteUserResponse))
		soap_serialize_ns1__deleteUserResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__deleteUserResponse(struct soap *soap, struct ns1__deleteUserResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__deleteUserResponse);
	if (soap_out_PointerTons1__deleteUserResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__deleteUserResponse(struct soap *soap, const char *tag, int id, struct ns1__deleteUserResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__deleteUserResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__deleteUserResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__deleteUserResponse ** SOAP_FMAC4 soap_get_PointerTons1__deleteUserResponse(struct soap *soap, struct ns1__deleteUserResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__deleteUserResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__deleteUserResponse ** SOAP_FMAC4 soap_in_PointerTons1__deleteUserResponse(struct soap *soap, const char *tag, struct ns1__deleteUserResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__deleteUserResponse **)soap_malloc(soap, sizeof(struct ns1__deleteUserResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__deleteUserResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__deleteUserResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__deleteUserResponse, sizeof(struct ns1__deleteUserResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__vrfyLoginResponse(struct soap *soap, struct ns1__vrfyLoginResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__vrfyLoginResponse))
		soap_serialize_ns1__vrfyLoginResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__vrfyLoginResponse(struct soap *soap, struct ns1__vrfyLoginResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__vrfyLoginResponse);
	if (soap_out_PointerTons1__vrfyLoginResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__vrfyLoginResponse(struct soap *soap, const char *tag, int id, struct ns1__vrfyLoginResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__vrfyLoginResponse);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__vrfyLoginResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__vrfyLoginResponse ** SOAP_FMAC4 soap_get_PointerTons1__vrfyLoginResponse(struct soap *soap, struct ns1__vrfyLoginResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__vrfyLoginResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__vrfyLoginResponse ** SOAP_FMAC4 soap_in_PointerTons1__vrfyLoginResponse(struct soap *soap, const char *tag, struct ns1__vrfyLoginResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__vrfyLoginResponse **)soap_malloc(soap, sizeof(struct ns1__vrfyLoginResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__vrfyLoginResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__vrfyLoginResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__vrfyLoginResponse, sizeof(struct ns1__vrfyLoginResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a)
{
	if (*a)
		soap_serialize_xsd__base64Binary(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__base64Binary);
	if (soap_out_PointerToxsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__base64Binary(struct soap *soap, const char *tag, int id, struct xsd__base64Binary *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__base64Binary(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_get_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_in_PointerToxsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xsd__base64Binary **)soap_malloc(soap, sizeof(struct xsd__base64Binary *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__base64Binary(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xsd__base64Binary **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTotime(struct soap *soap, time_t *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_time);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTotime(struct soap *soap, time_t *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTotime);
	if (soap_out_PointerTotime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTotime(struct soap *soap, const char *tag, int id, time_t *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_time);
	if (id < 0)
		return soap->error;
	return soap_out_time(soap, tag, id, *a, type);
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_get_PointerTotime(struct soap *soap, time_t **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTotime(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_in_PointerTotime(struct soap *soap, const char *tag, time_t **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (time_t **)soap_malloc(soap, sizeof(time_t *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_time(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (time_t **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_time, sizeof(time_t), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToArrayOf_USCORExsd_USCOREanyType(struct soap *soap, struct ArrayOf_USCORExsd_USCOREanyType *const*a)
{
	if (*a)
		soap_serialize_ArrayOf_USCORExsd_USCOREanyType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToArrayOf_USCORExsd_USCOREanyType(struct soap *soap, struct ArrayOf_USCORExsd_USCOREanyType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREanyType);
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToArrayOf_USCORExsd_USCOREanyType(struct soap *soap, const char *tag, int id, struct ArrayOf_USCORExsd_USCOREanyType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType);
	if (id < 0)
		return soap->error;
	return soap_out_ArrayOf_USCORExsd_USCOREanyType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ArrayOf_USCORExsd_USCOREanyType ** SOAP_FMAC4 soap_get_PointerToArrayOf_USCORExsd_USCOREanyType(struct soap *soap, struct ArrayOf_USCORExsd_USCOREanyType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOf_USCORExsd_USCOREanyType ** SOAP_FMAC4 soap_in_PointerToArrayOf_USCORExsd_USCOREanyType(struct soap *soap, const char *tag, struct ArrayOf_USCORExsd_USCOREanyType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ArrayOf_USCORExsd_USCOREanyType **)soap_malloc(soap, sizeof(struct ArrayOf_USCORExsd_USCOREanyType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ArrayOf_USCORExsd_USCOREanyType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ArrayOf_USCORExsd_USCOREanyType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ArrayOf_USCORExsd_USCOREanyType, sizeof(struct ArrayOf_USCORExsd_USCOREanyType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToLONG64(struct soap *soap, LONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToLONG64(struct soap *soap, LONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToLONG64);
	if (soap_out_PointerToLONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToLONG64(struct soap *soap, const char *tag, int id, LONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_LONG64);
	if (id < 0)
		return soap->error;
	return soap_out_LONG64(soap, tag, id, *a, type);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_get_PointerToLONG64(struct soap *soap, LONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToLONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_in_PointerToLONG64(struct soap *soap, const char *tag, LONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (LONG64 **)soap_malloc(soap, sizeof(LONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_LONG64(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (LONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_LONG64, sizeof(LONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
	if (soap_out_PointerToint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
	if (id < 0)
		return soap->error;
	return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of soapC.c */
