#! /bin/sh

opmode=$(uci get wireless.wifi1.opmode)
debug="off"
dev="$(ls /sys/class/net/ | grep ath | head -n 1)"
PID=`pidof udhcpc`
connect_info="/tmp/connect_info"

led_status_file="/tmp/led_status"
if [ -e "$led_status_file" ]; then
    led_status=$(cat $led_status_file)
else
    touch $led_status_file
fi

if [ "$opmode" == "wds_bridge" ]; then
  if [ -n "$(wlanconfig $dev list)" ]; then
	rssi=-199
	for i in $(seq 0 7)
	do
		mac=$(wlanconfig $dev nawds list | grep "$i: " | awk -F " " '{print $2}')
		if [ "$mac" != "00:00:00:00:00:00" ]; then
			rssi_tmp=$(wlanconfig $dev list | grep $mac | awk -F " " '{print $6}')
			[ -n "$rssi_tmp" ] && {
				[ $debug == "on" ] && echo "==i[$i], mac[$mac], rssi_tmp[$rssi_tmp]==" > /dev/console
				[ $rssi_tmp -gt $rssi ] && rssi=$rssi_tmp
			}
		fi
	done
	[ $debug == "on" ] && echo "===rssi[$rssi]===" > /dev/console
	if [ $rssi -ge -70 ]; then
		(echo 0 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
		(echo 0 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
		(echo 1 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
	elif [ $rssi -ge -85 ] && [ $rssi -lt -70 ]; then
		(echo 0 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
		(echo 1 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
		(echo 0 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
	elif [ $rssi -lt -85 ]; then
		(echo 1 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
		(echo 0 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
		(echo 0 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
	fi

    if [ "$led_status" != "1" ]; then
        /etc/init.d/led restart
        #1. release
        /bin/kill -SIGUSR2 $PID
        #2. renew
        /bin/kill -SIGUSR1 $PID
        echo 1 > $led_status_file
        logger "The device is in the state of connection" -t connect -p 5
    fi
  else
	(echo 0 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
	(echo 0 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
	(echo 0 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
    
    if [ "$led_status" != "0" ]; then
        /etc/init.d/led restart
        #1. release
        /bin/kill -SIGUSR2 $PID
        #2. renew
        /bin/kill -SIGUSR1 $PID
        echo 0 > $led_status_file
        logger "The device is in the state of disconnection" -t connect -p 5
    fi
  fi
else

getnot="$(iwconfig ${dev} 2>/dev/null | grep "Point:" | sed "s/\///" | grep "Not")"
if_process_running=$(ps | grep "led_pattern" | grep -v "grep" | wc -l)
if [ "$getnot" != "" ]; then
	assoc="Not"
fi
if [ "$assoc" != "Not" ]; then
	#echo "associated!"
    if [ $if_process_running -ne 0 ]; then
        killall -9 led_pattern.sh
    fi

	assocSNR="$(iwconfig ${dev} 2>/dev/null | grep "Quality" | cut -c 24-25 | sed "s/\///")"
	#echo $assocSNR
	if [ $assocSNR -ge 60 ]; then
		(echo 0 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
                (echo 0 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
                (echo 1 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
	elif [ $assocSNR -ge 40 ] && [ $assocSNR -lt 60 ]; then
		(echo 0 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
                (echo 1 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
                (echo 0 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
	elif [ $assocSNR -lt 40 ]; then
		(echo 1 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
                (echo 0 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
                (echo 0 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
	fi

    if [ "$led_status" != "1" ]; then
        /etc/init.d/led restart
        #1. release
        /bin/kill -SIGUSR2 $PID
        #2. renew
        /bin/kill -SIGUSR1 $PID
        echo 1 > $led_status_file

        ap_ssid="$(iwconfig ${dev} 2>/dev/null |grep "ESSID" |awk -F '"' '{print $2}')"
        ap_mac="$(iwconfig ${dev} 2>/dev/null |grep "Access Point" |awk -F ' ' '{print $6}')"
        echo "$ap_ssid $ap_mac" >$connect_info
        #echo "====ap_ssid:$ap_ssid===ap_mac:$ap_mac" >/dev/console
        logger "$ap_ssid $ap_mac IEEE802.11: associated" -t connect -p 5
    fi

else
    #echo "Not associated!"
    airbridge=$(uci get wireless.wifi1.qboost_enable)
    opmode=$(uci get wireless.wifi1.opmode)
    airbridge_ssid=$(uci get wireless.wifi1_wds_sta.ssid)

    if [ "$airbridge" == "1" -a "$opmode" == "wds_sta" -a "$airbridge_ssid" != "AP SSID_5G" ];then
	if [ $if_process_running -eq 0 ]; then
	    #killall -9 led_pattern.sh
	    [ -x "/usr/sbin/led_pattern.sh" ] && /usr/sbin/led_pattern.sh&
	fi
    else
	(echo 0 > /sys/class/leds/WLAN_LOW_LED/brightness) 2>/dev/null
        (echo 0 > /sys/class/leds/WLAN_GOOD_LED/brightness) 2>/dev/null
        (echo 0 > /sys/class/leds/WLAN_STRONG_LED/brightness) 2>/dev/null
    fi

	

    if [ "$led_status" != "0" ]; then
        /etc/init.d/led restart
        #1. release
        /bin/kill -SIGUSR2 $PID
        #2. renew
        /bin/kill -SIGUSR1 $PID
        echo 0 > $led_status_file

        ap_ssid=$(cat $connect_info |awk -F ' ' '{print $1}')
        ap_mac=$(cat $connect_info |awk -F ' ' '{print $2}')
        #echo "====ap_ssid:$ap_ssid===ap_mac:$ap_mac" >/dev/console
        logger "$ap_ssid $ap_mac IEEE802.11: disassociated" -t connect -p 5
        rm $connect_info
    fi
fi

fi
