#
# Copyright (c) 2013 Qualcomm Atheros, Inc..
#

hostapd_set_bss_options() {
	local var="$1"
	local vif="$2"
	local enc wep_rekey wpa_group_rekey wpa_strict_rekey wpa_pair_rekey wpa_master_rekey wps_possible

	local nasid nasport nasip nasid_enable nasport_enable nasip_enable
	local func_enable_radius_nas=$(uci get functionlist.functionlist.SUPPORT_ALL_ENCRYPTION_HAS_RADIUS_SETTING)
	local func_enable_radius_nas_ip=$(uci get functionlist.functionlist.SUPPORT_NAS_IP_ADDR)
	local func_enable_radius_acc=$(uci get functionlist.functionlist.SUPPORT_ALL_ENCRYPTION_HAS_RADIUS_ACCOUNTING)

	config_get enc "$vif" encryption "none"
	config_get wep_rekey        "$vif" wep_rekey        # 300
	config_get wpa_group_rekey  "$vif" wpa_group_rekey  # 300
	config_get wpa_strict_rekey  "$vif" wpa_strict_rekey  # 300
	config_get wpa_pair_rekey   "$vif" wpa_pair_rekey   # 300
	config_get wpa_master_rekey "$vif" wpa_master_rekey # 640
	config_get_bool ap_isolate "$vif" isolate 0

	config_get device "$vif" device
	config_get hwmode "$device" hwmode
	config_get phy "$device" phy

	append "$var" "ctrl_interface=/var/run/hostapd-$phy" "$N"

	if [ "$ap_isolate" -gt 0 ]; then
		append "$var" "ap_isolate=$ap_isolate" "$N"
	fi

	# Examples:
	# psk-mixed/tkip 	=> WPA1+2 PSK, TKIP
	# wpa-psk2/tkip+aes	=> WPA2 PSK, CCMP+TKIP
	# wpa2/tkip+aes 	=> WPA2 RADIUS, CCMP+TKIP
	# ...

	# TODO: move this parsing function somewhere generic, so that
	# later it can be reused by drivers that don't use hostapd

	# crypto defaults: WPA2 vs WPA1
	case "$enc" in
		wpa2*|*psk2*)
			wpa=2
			crypto="CCMP"
		;;
		*mixed*)
			wpa=3
			crypto="CCMP TKIP"
		;;
		*)
			wpa=1
			crypto="TKIP"
		;;
	esac

	# explicit override for crypto setting
	case "$enc" in
		*tkip+aes|*tkip+ccmp|*aes+tkip|*ccmp+tkip) crypto="CCMP TKIP";;
		*aes|*ccmp) crypto="CCMP";;
		*tkip) crypto="TKIP";;
	esac

	### SENAO ### read fastroaming
	#config_get wifi_dev "$vif" device
	#config_get fastroaming_en "$wifi_dev" fastroamingEnable
	config_get fastroaming_en "$vif" fastroamingEnable

	# enforce CCMP for 11ng and 11na
	#case "$hwmode:$crypto" in
	#	*ng:TKIP|*na:TKIP|*ac:TKIP) crypto="CCMP TKIP";;
	#esac

	# use crypto/auth settings for building the hostapd config
	case "$enc" in
		none)
			# NAS-ID/NAS-PORT
			if [ "$func_enable_radius_nas" == "1" ]; then
				config_get nasid_enable "$vif" nasid_enable
				config_get nasport_enable "$vif" nasport_enable
				config_get nasid "$vif" nasid
				config_get nasport "$vif" nasport
				if [ "$func_enable_radius_nas_ip" == "1" ]; then
					config_get nasip_enable "$vif" nasip_enable
					config_get nasip "$vif" nasip
				fi

				[ "$nasid_enable" == "1" ] && append "$var" "nas_identifier=$nasid" "$N"
				[ "$nasport_enable" == "1" ] && append "$var" "nas_port=$nasport" "$N"
			else
				nasid=""
				append "$var" "nas_identifier=$nasid" "$N"
			fi

			# Radius Accounting
			if [ "$func_enable_radius_acc" == "1" ]; then
				config_get acct_enabled "$vif" acct_enabled
				if [ "$acct_enabled" -eq 1 ]; then
					
					config_load network 
					own_ip_addr=`ifconfig br-lan | awk '/inet addr/{print substr($2,6)}'`
					if [ -z "$own_ip_addr" ]; then
						config_get own_ip_addr lan ipaddr "0.0.0.0"
					fi
					if [ "$func_enable_radius_nas_ip" == "1" -a -n "$nasip" -a "$nasip_enable" == "1" ]; then
						append "$var" "own_ip_addr=$nasip" "$N"
					else
					append "$var" "own_ip_addr=$own_ip_addr" "$N"			
					fi
					# Radius Accounting Server
					config_get acct_server "$vif" acct_server
					[ -n "$acct_server" ] && append "$var" "acct_server_addr=$acct_server" "$N"
					
					# Radius Accounting Port
					config_get acct_port "$vif" acct_port
					[ -n "$acct_port" ] && acct_port=${acct_port:-1813}
					[ -n "$acct_port" ] && append "$var" "acct_server_port=$acct_port" "$N"
					
					# Radius Accounting Secret
					config_get acct_secret "$vif" acct_secret
					[ -n "$acct_secret" ] && append "$var" "acct_server_shared_secret=$acct_secret" "$N"
					
					# Interim Accounting Interval
					config_get acct_interval "$vif" acct_interval
					[ -n "$acct_interval" ] && append "$var" "radius_acct_interim_interval=$acct_interval" "$N"
				fi
			fi
			auth_algs=
			wps_possible=1
			wpa=0
			crypto=
			# Here we make the assumption that if we're in open mode
			# with WPS enabled, we got to be in unconfigured state.
			wps_not_configured=1
		;;
		*psk*)
			config_get psk "$vif" key
			if [ ${#psk} -eq 64 ]; then
				append "$var" "wpa_psk=$psk" "$N"
			else
				append "$var" "wpa_passphrase=$psk" "$N"
			fi
			wps_possible=1
			[ -n "$wpa_group_rekey"  ] && append "$var" "wpa_group_rekey=$wpa_group_rekey" "$N"
			[ -n "$wpa_strict_rekey"  ] && append "$var" "wpa_strict_rekey=$wpa_strict_rekey" "$N"
			[ -n "$wpa_pair_rekey"   ] && append "$var" "wpa_ptk_rekey=$wpa_pair_rekey"    "$N"
			[ -n "$wpa_master_rekey" ] && append "$var" "wpa_gmk_rekey=$wpa_master_rekey"  "$N"

			# NAS-ID/NAS-PORT
			if [ "$func_enable_radius_nas" == "1" ]; then
				config_get nasid_enable "$vif" nasid_enable
				config_get nasport_enable "$vif" nasport_enable
				config_get nasid "$vif" nasid
				config_get nasport "$vif" nasport
				if [ "$func_enable_radius_nas_ip" == "1" ]; then
					config_get nasip_enable "$vif" nasip_enable
					config_get nasip "$vif" nasip
				fi

				[ "$nasid_enable" == "1" ] && append "$var" "nas_identifier=$nasid" "$N"
				[ "$nasport_enable" == "1" ] && append "$var" "nas_port=$nasport" "$N"
			else
				nasid=""
				append "$var" "nas_identifier=$nasid" "$N"
			fi

			# Radius Accounting
			if [ "$func_enable_radius_acc" == "1" ]; then
				config_get acct_enabled "$vif" acct_enabled
				if [ "$acct_enabled" -eq 1 ]; then
					
					config_load network 
					own_ip_addr=`ifconfig br-lan | awk '/inet addr/{print substr($2,6)}'`
					if [ -z "$own_ip_addr" ]; then
						config_get own_ip_addr lan ipaddr "0.0.0.0"
					fi
					if [ "$func_enable_radius_nas_ip" == "1" -a -n "$nasip" -a "$nasip_enable" == "1" ]; then
						append "$var" "own_ip_addr=$nasip" "$N"
					else
					append "$var" "own_ip_addr=$own_ip_addr" "$N"			
					fi
					# Radius Accounting Server
					config_get acct_server "$vif" acct_server
					[ -n "$acct_server" ] && append "$var" "acct_server_addr=$acct_server" "$N"
					
					# Radius Accounting Port
					config_get acct_port "$vif" acct_port
					[ -n "$acct_port" ] && acct_port=${acct_port:-1813}
					[ -n "$acct_port" ] && append "$var" "acct_server_port=$acct_port" "$N"
					
					# Radius Accounting Secret
					config_get acct_secret "$vif" acct_secret
					[ -n "$acct_secret" ] && append "$var" "acct_server_shared_secret=$acct_secret" "$N"
					
					# Interim Accounting Interval
					config_get acct_interval "$vif" acct_interval
					[ -n "$acct_interval" ] && append "$var" "radius_acct_interim_interval=$acct_interval" "$N"
				fi
			fi
			
			if [ "$fastroaming_en" == "1" ] && [ ${wpa:-0} -gt 1 ] && [ "${crypto:0:4}" == "CCMP" ]; then
				echo "WPA-PSK 11r enable" > /dev/ttyS0
				if [ -z  "$nasid" ]; then
					nasid=""
				fi
				local AP_MAC=`ifconfig $ifname |awk '{ if( $4 == "HWaddr" )print $5 }'`
				local ROAMING_KEY="0f0e0d0c0b0a09080706050403020100"
				local R0KH="$AP_MAC $nasid $ROAMING_KEY"
				local R1KH="$AP_MAC $AP_MAC $ROAMING_KEY"
				local R1_KEY_HOLDER=`echo $AP_MAC |awk 'BEGIN {FS=":"}; {print $1$2$3$4$5$6}'`

				append "$var" "nas_identifier=$nasid" "$N"
				append "$var" "wpa_key_mgmt=FT-PSK WPA-PSK" "$N"
				append "$var" "r0kh=$R0KH" "$N"
				append "$var" "r1kh=$R1KH" "$N"
				append "$var" "rsn_preauth=1" "$N"
				append "$var" "rsn_preauth_interfaces=br-lan" "$N"
				append "$var" "pmk_r1_push=1" "$N"
				append "$var" "ft_over_ds=0" "$N"
				append "$var" "mobility_domain=a1b2" "$N"
				append "$var" "r0_key_lifetime=10000" "$N"
				append "$var" "r1_key_holder=$R1_KEY_HOLDER" "$N"
				append "$var" "reassociation_deadline=1000" "$N"
			else
				echo "WPA-PSK 11r disable" > /dev/ttyS0
				append "$var" "wpa_key_mgmt=WPA-PSK" "$N"
                        fi
		;;
		*wpa*)
			# required fields? formats?
			# hostapd is particular, maybe a default configuration for failures
			config_get auth_server "$vif" auth_server
			[ -z "$auth_server" ] && config_get auth_server "$vif" server
			append "$var" "auth_server_addr=$auth_server" "$N"
			config_get auth_port "$vif" auth_port
			[ -z "$auth_port" ] && config_get auth_port "$vif" port
			auth_port=${auth_port:-1812}
			append "$var" "auth_server_port=$auth_port" "$N"
			config_get auth_secret "$vif" auth_secret
			[ -z "$auth_secret" ] && config_get auth_secret "$vif" key
			append "$var" "auth_server_shared_secret=$auth_secret" "$N"
			config_get eap_reauth_period "$vif" eap_reauth_period
			[ -n "$eap_reauth_period" ] && append "$var" "eap_reauth_period=$eap_reauth_period" "$N"
			config_get wep_key_len_broadcast "$vif" wep_key_len_broadcast
			config_get wep_key_len_unicast "$vif" wep_key_len_unicast

			# NAS-ID/NAS-PORT
			if [ "$func_enable_radius_nas" == "1" ]; then
				config_get nasid_enable "$vif" nasid_enable
				config_get nasport_enable "$vif" nasport_enable
				config_get nasid "$vif" nasid
				config_get nasport "$vif" nasport
				if [ "$func_enable_radius_nas_ip" == "1" ]; then
					config_get nasip_enable "$vif" nasip_enable
					config_get nasip "$vif" nasip
				fi

				[ "$nasid_enable" == "1" ] && append "$var" "nas_identifier=$nasid" "$N"
				[ "$nasport_enable" == "1" ] && append "$var" "nas_port=$nasport" "$N"
			else
				nasid=""
				append "$var" "nas_identifier=$nasid" "$N"
			fi

			# Radius Accounting
				config_get acct_enabled "$vif" acct_enabled
				if [ "$acct_enabled" -eq 1 ]; then
					
					# Radius Accounting Server
					config_get acct_server "$vif" acct_server
					[ -n "$acct_server" ] && append "$var" "acct_server_addr=$acct_server" "$N"
					
					# Radius Accounting Port
					config_get acct_port "$vif" acct_port
					[ -n "$acct_port" ] && acct_port=${acct_port:-1813}
					[ -n "$acct_port" ] && append "$var" "acct_server_port=$acct_port" "$N"
					
					# Radius Accounting Secret
					config_get acct_secret "$vif" acct_secret
					[ -n "$acct_secret" ] && append "$var" "acct_server_shared_secret=$acct_secret" "$N"
					
					# Interim Accounting Interval
					config_get acct_interval "$vif" acct_interval
					[ -n "$acct_interval" ] && append "$var" "radius_acct_interim_interval=$acct_interval" "$N"
				fi

			append "$var" "eapol_key_index_workaround=1" "$N"
			append "$var" "ieee8021x=1" "$N"
			if [ "$fastroaming_en" == "1" ] && [ ${wpa:-0} -gt 1 ] && [ "${crypto:0:4}" == "CCMP" ]; then
				### Senao 802.11r fastroaming
				echo "WPA-EAP 11r enable" > /dev/ttyS0
				if [ -z  "$nasid" ]; then
					nasid=""
				fi
				local AP_MAC=`ifconfig $ifname |awk '{ if( $4 == "HWaddr" )print $5 }'`
				local ROAMING_KEY="0f0e0d0c0b0a09080706050403020100"
				local R0KH="$AP_MAC $nasid $ROAMING_KEY"
				local R1KH="$AP_MAC $AP_MAC $ROAMING_KEY"
				local R1_KEY_HOLDER=`echo $AP_MAC |awk 'BEGIN {FS=":"}; {print $1$2$3$4$5$6}'`
				
				append "$var" "wpa_key_mgmt=FT-EAP WPA-EAP" "$N"
				append "$var" "r0kh=$R0KH" "$N"
				append "$var" "r1kh=$R1KH" "$N"
				append "$var" "rsn_preauth=1" "$N"
				append "$var" "rsn_preauth_interfaces=br-lan" "$N"
				append "$var" "pmk_r1_push=1" "$N"
				append "$var" "ft_over_ds=0" "$N"
				append "$var" "mobility_domain=a1b2" "$N"
				append "$var" "r0_key_lifetime=10000" "$N"
				append "$var" "r1_key_holder=$R1_KEY_HOLDER" "$N"
				append "$var" "reassociation_deadline=1000" "$N"

				### Senao OKC fastroaming
				echo "WPA-EAP OKC enable\n" > /dev/ttyS0
				append "$var" "sokc_enable=1" "$N"
				append "$var" "sokc_check_mac=1" "$N"
				if [ $wifi_dev == "wifi0" ]; then
					echo "OKC 2.4G gid=1" > /dev/ttyS0
					append "$var" "sokc_group_index=1" "$N"
				elif [ $wifi_dev == "wifi1" ]; then
					echo "OKC 5G gid=2" > /dev/ttyS0
					append "$var" "sokc_group_index=2" "$N"
				fi
                        else
				echo "WPA-EAP OKC disable\n" > /dev/ttyS0
				append "$var" "wpa_key_mgmt=WPA-EAP" "$N"
                        fi

			[ -n "$nasid" ] && append "$var" "nas_identifier=$nasid" "$N"
			[ -n "$wpa_group_rekey"  ] && append "$var" "wpa_group_rekey=$wpa_group_rekey" "$N"
			[ -n "$wpa_strict_rekey"  ] && append "$var" "wpa_strict_rekey=$wpa_strict_rekey" "$N"
			[ -n "$wpa_pair_rekey"   ] && append "$var" "wpa_ptk_rekey=$wpa_pair_rekey"    "$N"
			[ -n "$wpa_master_rekey" ] && append "$var" "wpa_gmk_rekey=$wpa_master_rekey"  "$N"
			[ -n "$wep_key_len_broadcast" ] && append "$var" "wep_key_len_broadcast=$wep_key_len_broadcast" "$N"
			[ -n "$wep_key_len_unicast" ] && append "$var" "wep_key_len_unicast=$wep_key_len_unicast" "$N"
			[ -n "$wep_rekey" ] && append "$var" "wep_rekey_period=$wep_rekey" "$N"
					config_load network 
					own_ip_addr=`ifconfig br-lan | awk '/inet addr/{print substr($2,6)}'`
					if [ -z "$own_ip_addr" ]; then
						config_get own_ip_addr lan ipaddr "0.0.0.0"
					fi
			if [ "$func_enable_radius_nas_ip" == "1" -a -n "$nasip" -a "$nasip_enable" == "1" ]; then
				append "$var" "own_ip_addr=$nasip" "$N"
			else
					append "$var" "own_ip_addr=$own_ip_addr" "$N"
			fi
		;;
		*wep*)
			config_get key "$vif" key_id
			config_get wep_key "$vif" key$key
			config_get ifname "$vif" ifname
			key="${key:-1}"
			#case "$key" in
			#	[1234])
			#		[ -n "$wep_key" ] && \
			#			append "$var" "wep_key$(($key - 1))=$(prepare_key_wep "$wep_key")" "$N"
			#		append "$var" "wep_default_key=$(($key - 1))"  "$N"
			#	;;
			#	*)
			#		append "$var" "wep_key0=$(prepare_key_wep "$key")" "$N"
			#		append "$var" "wep_default_key=0" "$N"
			#		[ -n "$wep_rekey" ] && append "$var" "wep_rekey_period=$wep_rekey" "$N"
			#	;;
			#esac
			
			# NAS-ID/NAS-PORT
			if [ "$func_enable_radius_nas" == "1" ]; then
				config_get nasid_enable "$vif" nasid_enable
				config_get nasport_enable "$vif" nasport_enable
				config_get nasid "$vif" nasid
				config_get nasport "$vif" nasport
				if [ "$func_enable_radius_nas_ip" == "1" ]; then
					config_get nasip_enable "$vif" nasip_enable
					config_get nasip "$vif" nasip
				fi

				[ "$nasid_enable" == "1" ] && append "$var" "nas_identifier=$nasid" "$N"
				[ "$nasport_enable" == "1" ] && append "$var" "nas_port=$nasport" "$N"
			else
				nasid=""
				append "$var" "nas_identifier=$nasid" "$N"
			fi

			# Radius Accounting
			if [ "$func_enable_radius_acc" == "1" ]; then
				config_get acct_enabled "$vif" acct_enabled
				if [ "$acct_enabled" -eq 1 ]; then
					
					config_load network 
					own_ip_addr=`ifconfig br-lan | awk '/inet addr/{print substr($2,6)}'`
					if [ -z "$own_ip_addr" ]; then
						config_get own_ip_addr lan ipaddr "0.0.0.0"
					fi
					if [ "$func_enable_radius_nas_ip" == "1" -a -n "$nasip" -a "$nasip_enable" == "1" ]; then
						append "$var" "own_ip_addr=$nasip" "$N"
					else
					append "$var" "own_ip_addr=$own_ip_addr" "$N"			
					fi
					# Radius Accounting Server
					config_get acct_server "$vif" acct_server
					[ -n "$acct_server" ] && append "$var" "acct_server_addr=$acct_server" "$N"
					
					# Radius Accounting Port
					config_get acct_port "$vif" acct_port
					[ -n "$acct_port" ] && acct_port=${acct_port:-1813}
					[ -n "$acct_port" ] && append "$var" "acct_server_port=$acct_port" "$N"
					
					# Radius Accounting Secret
					config_get acct_secret "$vif" acct_secret
					[ -n "$acct_secret" ] && append "$var" "acct_server_shared_secret=$acct_secret" "$N"
					
					# Interim Accounting Interval
					config_get acct_interval "$vif" acct_interval
					[ -n "$acct_interval" ] && append "$var" "radius_acct_interim_interval=$acct_interval" "$N"
				fi
			fi

			case "$enc" in
				*shared*)
					auth_algs=2
					iwconfig $ifname key [$key] $wep_key
				;;
				*open*)
					auth_algs=1
				;;
			esac
			wpa=0
			crypto=
		;;
		8021x)
			# For Dynamic WEP 802.1x,maybe need more fields
			config_get auth_server "$vif" auth_server
			[ -z "$auth_server" ] && config_get auth_server "$vif" server
			append "$var" "auth_server_addr=$auth_server" "$N"
			config_get auth_port "$vif" auth_port
			[ -z "$auth_port" ] && config_get auth_port "$vif" port
			auth_port=${auth_port:-1812}
			append "$var" "auth_server_port=$auth_port" "$N"
			config_get auth_secret "$vif" auth_secret
			[ -z "$auth_secret" ] && config_get auth_secret "$vif" key
			config_get eap_reauth_period "$vif" eap_reauth_period
			[ -n "$eap_reauth_period" ] && append "$var" "eap_reauth_period=$eap_reauth_period" "$N"
			config_get nasid "$vif" nasid
			append "$var" "nas_identifier=$nasid" "$N"
			append "$var" "ieee8021x=1" "$N"
			append "$var" "auth_server_shared_secret=$auth_secret" "$N"
			append "$var" "wep_rekey_period=300" "$N"
			append "$var" "eap_server=0" "$N"
			append "$var" "eapol_version=2" "$N"
			append "$var" "eapol_key_index_workaround=0" "$N"
			append "$var" "wep_key_len_broadcast=13" "$N"
			append "$var" "wep_key_len_unicast=13" "$N"
			auth_algs=1
			wpa=0
			crypto=
		;;
		*)
			wpa=0
			crypto=
		;;
	esac
	append "$var" "auth_algs=${auth_algs:-1}" "$N"
	append "$var" "wpa=$wpa" "$N"
	[ -n "$crypto" ] && append "$var" "wpa_pairwise=$crypto" "$N"
	[ -n "$wpa_group_rekey" ] && append "$var" "wpa_group_rekey=$wpa_group_rekey" "$N"
	[ -n "$wpa_strict_rekey" ] && append "$var" "wpa_strict_rekey=$wpa_strict_rekey" "$N"

	config_get ssid "$vif" ssid
	config_get bridge "$vif" bridge
	config_get ieee80211d "$vif" ieee80211d
	config_get iapp_interface "$vif" iapp_interface

	config_get_bool wps_enable "$vif" wps_enable 0
	config_get_bool wps_pbc "$vif" wps_pbc 0
	config_get_bool wps_label "$vif" wps_label 0
	config_get_bool wps_display "$vif" wps_display 0
	config_get_bool wps_keypad "$vif" wps_keypad 0
	config_get config_methods "$vif" wps_config

	[ "$wps_enable" -gt 0 ] && {
	    [ "$wps_pbc" -gt 0 ] && append config_methods push_button
	    [ "$wps_label" -gt 0 ] && append config_methods label
	    [ "$wps_display" -gt 0 ] && append config_methods display
	    [ "$wps_keypad" -gt 0 ] && append config_methods keypad
	}

	# WPS 2.0 test case 4.1.7:
	# if we're configured to enable WPS and we hide our SSID, then
	# we have to require an "explicit user operation to continue"
	config_get_bool hidden "$vif" hidden 0
	[ -n "$wps_possible" -a -n "$config_methods" -a "$hidden" -gt 0 ] && {
		echo "Hidden SSID is enabled on \"$ifname\", WPS will be automatically disabled"
		echo "Please press any key to continue."
		read -s -n 1
		wps_possible=
	}

	[ -n "$wps_possible" -a -n "$config_methods" ] && {
		#config_get device_type "$vif" wps_device_type "6-0050F204-1"
		config_get device_name "$vif" wps_device_name "OpenWrt AP"
		config_get wps_state "$vif" wps_state 0
		config_get manufacturer "$vif" wps_manufacturer "openwrt.org"
		config_get model_name "$vif" wps_model_name
		config_get model_number "$vif" wps_model_number
		#config_get os_version "$vif" wps_os_version
		config_get upnp_iface "$vif" ifname
		config_get friendly_name "$vif" wps_friendly_name
		config_get manufacturer_url "$vif" wps_manufacturer_url
		config_get model_description "$vif" wps_model_description
		config_get model_url "$vif" wps_model_url
		config_get wps_pin "$vif" wps_pin "12345670"
		config_get disabled_pin "$vif" wps_disabled_pin "0"

		config_get pbc_in_m1 "$vif" wps_pbc_in_m1
		[ -n "$pbc_in_m1" ] && append "$var" "pbc_in_m1=$pbc_in_m1" "$N"

		config_get_bool ext_registrar "$vif" wps_ext_registrar 0
		[ "$ext_registrar" -gt 0 -a -n "$bridge" ] && append "$var" "upnp_iface=$bridge" "$N"

		append "$var" "eap_server=1" "$N"
		append "$var" "wps_state=$wps_state" "$N"
		append "$var" "ap_setup_locked=0" "$N"
		append "$var" "device_type=6-0050F204-1" "$N"
		[ -n "$device_name" ] && append "$var" "device_name=$device_name" "$N"
		[ -n "$manufacturer" ] && append "$var" "manufacturer=$manufacturer" "$N"
		[ -n "$config_methods" ] && append "$var" "config_methods=$config_methods" "$N"
		append "$var" "wps_pin_requests=/var/run/hostapd.pin-req" "$N"
		[ -n "$model_name" ] && append "$var" "model_name=$model_name" "$N"
		[ -n "$model_number" ] && append "$var" "model_number=$model_number" "$N"
		[ -n "$model_number" ] || append "$var" "model_number=$(uci get system.@system[0].ModelName)" "$N"
		#[ -n "$serial_number" ] && append "$var" "serial_number=$serial_number" "$N"
		append "$var" "serial_number=$(setconfig -g 0)" "$N"
		append "$var" "os_version=01020300" "$N"
		# fix the overlap session of WPS PBC for dual band AP
		[ -n "$ifname" ] && {
			macaddr=$(cat /sys/class/net/${ifname}/address)
			uuid=$(echo "$macaddr" | sed 's/://g')
		}
		[ -n "$uuid" ] && {
			append "$var" "uuid=18de43f8-677c-4d3a-8920-$uuid" "$N"
		}
		[ -n "$wps_pin" ] && append "$var" "ap_pin=$wps_pin" "$N"
		[ -n "$friendly_name" ] && append "$var" "friendly_name=$friendly_name" "$N"
		[ -n "$manufacturer_url" ] && append "$var" "manufacturer_url=$manufacturer_url" "$N"
		[ -n "$model_description" ] && append "$var" "model_description=$model_description" "$N"
		[ -n "$model_url" ] && append "$var" "model_url=$model_url" "$N"
		append "$var" "upc=123456789012" "$N"
		[ -n "$disabled_pin" ] && append "$var" "disable_pin=$disabled_pin" "$N"
	}

	append "$var" "ssid=$ssid" "$N"
	[ -n "$bridge" ] && append "$var" "bridge=$bridge" "$N"
	[ -n "$ieee80211d" ] && append "$var" "ieee80211d=$ieee80211d" "$N"
	[ -n "$iapp_interface" ] && append "$var" iapp_interface=$(uci_get_state network "$iapp_interface" ifname "$iapp_interface") "$N"

	if [ "$wpa" -ge "2" ]
	then
		# RSN -> allow preauthentication
		config_get rsn_preauth "$vif" rsn_preauth
		if [ -n "$bridge" -a "$rsn_preauth" = 1 ]
		then
			append "$var" "rsn_preauth=1" "$N"
			append "$var" "rsn_preauth_interfaces=$bridge" "$N"
		fi

		# RSN -> allow management frame protection
		config_get ieee80211w "$vif" ieee80211w
		case "$ieee80211w" in
			[012])
				append "$var" "ieee80211w=$ieee80211w" "$N"
				[ "$ieee80211w" -gt "0" ] && {
					config_get ieee80211w_max_timeout "$vif" ieee80211w_max_timeout
					config_get ieee80211w_retry_timeout "$vif" ieee80211w_retry_timeout
					[ -n "$ieee80211w_max_timeout" ] && \
						append "$var" "assoc_sa_query_max_timeout=$ieee80211w_max_timeout" "$N"
					[ -n "$ieee80211w_retry_timeout" ] && \
						append "$var" "assoc_sa_query_retry_timeout=$ieee80211w_retry_timeout" "$N"
				}
			;;
		esac
	fi
}

hostapd_set_log_options() {
	local var="$1"
	local cfg="$2"
	local log_level log_80211 log_8021x log_radius log_wpa log_driver log_iapp log_mlme

	config_get log_level "$cfg" log_level 2

	config_get_bool log_80211  "$cfg" log_80211  1
	config_get_bool log_8021x  "$cfg" log_8021x  1
	config_get_bool log_radius "$cfg" log_radius 1
	config_get_bool log_wpa    "$cfg" log_wpa    1
	config_get_bool log_driver "$cfg" log_driver 1
	config_get_bool log_iapp   "$cfg" log_iapp   1
	config_get_bool log_mlme   "$cfg" log_mlme   1

	local log_mask=$((       \
		($log_80211  << 0) | \
		($log_8021x  << 1) | \
		($log_radius << 2) | \
		($log_wpa    << 3) | \
		($log_driver << 4) | \
		($log_iapp   << 5) | \
		($log_mlme   << 6)   \
	))

	append "$var" "logger_syslog=$log_mask" "$N"
	append "$var" "logger_syslog_level=$log_level" "$N"
	append "$var" "logger_stdout=$log_mask" "$N"
	append "$var" "logger_stdout_level=$log_level" "$N"
}

hostapd_setup_vif() {
	local vif="$1" && shift
	local driver="$1" && shift
	local no_nconfig
	local ifname device channel hwmode

	hostapd_cfg=

	# These are flags that may or may not be used when calling
	# "hostapd_setup_vif()". These are not mandatory and may be called in
	# any order
	while [ $# -ne 0 ]; do
		local tmparg="$1" && shift
		case "$tmparg" in
		no_nconfig)
			no_nconfig=1
			;;
		esac
	done

	config_get ifname "$vif" ifname
	config_get device "$vif" device
	config_get channel "$device" channel
	config_get hwmode "$device" hwmode

	hostapd_set_log_options hostapd_cfg "$device"
	hostapd_set_bss_options hostapd_cfg "$vif"

	case "$hwmode" in
		*bg|*gdt|*gst|*fh) hwmode=g;;
		*adt|*ast) hwmode=a;;
	esac
	[ "$channel" = auto ] && channel=
	[ -n "$channel" -a -z "$hwmode" ] && wifi_fixup_hwmode "$device"
	cat > /var/run/hostapd-$ifname.conf <<EOF
driver=$driver
interface=$ifname
${channel:+channel=$channel}
$hostapd_cfg
EOF
	[ -z "${no_nconfig}" ] &&
		echo ${hwmode:+hw_mode=${hwmode#11}} >> /var/run/hostapd-$ifname.conf
	hostapd -P /var/run/wifi-$ifname.pid -B /var/run/hostapd-$ifname.conf
}

