#!/bin/sh

country_id="$1"
sku="$2"
green="$3"
outdoor="$4"
dfs="$5"
tri_band="$6"

get_country_band() {
	local sku="$1"
	local outdoor="$2"
	local green="$3"
        local tri_band="$4"                                                          
	band_list=""

	case "$sku:$outdoor:$green" in
		*:*:0) band_list="$f3";;
		*:0:1) [ -n "$tri_band" ] && band_list="$f6" || band_list="$f4";;
		*:1:1) [ -n "$tri_band" ] && band_list="$f6" || band_list="$f5";;
		*) band_list="1,2,3,4";;
	esac

	echo "$band_list"
}

get_band_bit_map() {
	local sku="$1"
	local band_list="$2"
        local country_name="$3"
        local green="$4"
        local outdoor="$5"
	local band1=$(echo $band_list | grep 1  > /dev/null 2>&1 && echo 1 || echo 0)
	local band2=$(echo $band_list | grep 2  > /dev/null 2>&1 && echo 2 || echo 0)
	local band3=$(echo $band_list | grep 3  > /dev/null 2>&1 && echo 4 || echo 0)
        local band4=$(echo $band_list | grep 4  > /dev/null 2>&1 && echo 8 || echo 0)

        if [ $sku == "1" -a $green == "1" -a $outdoor == "1" -a $country_name != "Russia" ]; then
                band1=0
                band2=0
                band4=0
        fi
	echo "$(($band4+$band3+$band2+$band1))"
}

get_disable_band() {
	local band_bit_map="$1"
	local green="$2"
	local dfs="$3"

	if [ $green == "1" ]; then
		case "$dfs" in
			0) band_bit_map=$(($band_bit_map & 9));;
			1) band_bit_map=$(($band_bit_map & 11));;
			2) band_bit_map=$(($band_bit_map & 13));;
			3) band_bit_map=$(($band_bit_map & 15));;
		esac
	fi

	echo "$band_bit_map"
}

while read f1 f2 f3 f4 f5 f6 f7
do
	if [ "$country_id" == "$f2" ]; then
                country_name="$f1"
		country_band="$(get_country_band $sku $outdoor $green $tri_band)";
                band_bit_map="$(get_band_bit_map $sku $country_band $country_name $green $outdoor)";
		disable_band="$(get_disable_band $band_bit_map $green $dfs)";
		if [ -n "$f7" ]; then
			echo -n "$disable_band" "$f7"
		else
			echo -n "$disable_band"
		fi
	fi
done < /lib/wifi/RegularDomain.csv 
