ezmcloud=$(test -f /etc/config/ezmcloud && echo 1 || echo 0)
if [ $ezmcloud -eq 0 ];then
    captived=$(uci get apcontroller.capwap.enable)
else
    # cloud always captived.
    captived=1
fi
portal_en=$(uci -q get portal.general.enable)

func_enable_bonding=$(uci -q get network.lacp.lacp_enable)
if [ $func_enable_bonding -eq 1 ]; then
	lan_ifnames="bond0"
else
	lan_ifnames=$(uci -q get /rom/etc/config/network.lan.ifname)
fi
mesh_off=$(uci -q get mesh.wifi.disabled)
is_wds_ap=$(uci show wireless | grep wifi[0-1].opmode | cut -d "=" -f 2 | xargs | grep wds_ap )
is_wds_bridge=$(uci show wireless | grep wifi[0-1].opmode | cut -d "=" -f 2 | xargs | grep wds_bridge )

if [ -n "$is_wds_ap" ]; then
	if [ "`uci -q get wireless.wifi0.opmode`" == "wds_ap" ]; then
		wds_ifname=$(uci -q get wireless.wifi0_wds_0.ifname)
	else
		wds_ifname=$(uci -q get wireless.wifi1_wds_0.ifname)
	fi
elif [ -n "$is_wds_bridge" ]; then
	if [ "`uci -q get wireless.wifi0.opmode`" == "wds_bridge" ]; then
		wds_ifname=$(uci -q get wireless.wifi0_wds.ifname)
	else
		wds_ifname=$(uci -q get wireless.wifi1_wds.ifname)
	fi
fi

if [ "$mesh_off" = "0" ]; then
    echo "do mesh_bridge"
elif [ -n "$is_wds_ap" -o -n "$is_wds_bridge" ]; then
	lan_ifnames="$lan_ifnames $wds_ifname"
fi

enables="/tmp/enables.txt"
repeat="/tmp/vlan_repeat.txt"
filter_vlanIDs="/tmp/filter_vlanIDs.txt"

lan_mac_address=$(setconfig -g 6)

is_enjet_on=$(uci -q get wireless.wifi1.qboost_enable)

