. /lib/senao-shell-libs/network.sh

remove_empty_bridges()
{
	for brname in $(ls /sys/class/net/ |grep ^br-)
	do
		local brifname=$(get_bridge_name $brname || echo "x")
		if [ -z "$brifname" ]
		then
			ifconfig $brname down
			brctl delbr $brname
		fi
	done
}

append_eth_vid()
{
	for eif in $lan_ifnames
	do
		if [ -n "${1}" ]
		then
			eth_vlanifs="${eth_vlanifs} ${eif}.${1}"
		fi
	done
	echo ${eth_vlanifs:-$lan_ifnames}
}

clear_network_configs()
{
	# clear all of network.ifname
	local configs=$(echo "`uci show network|grep ifname|cut -d "." -f 2`")

	for option in $configs; do
		if [ "${option//[0-9]/}" = "" ]; then
			uci set network.${option}.ifname="na"
		fi
		if [ "${option/*vlan}" = "" -o "${option/vlan*}" = "" ];then
			uci set network.${option}.ifname="na"
		fi
	done
}

add_network_config()
{
	uci -q get network.$1 || uci set network.$1=interface
	uci set network.$1.type='bridge'
	uci set network.$1.proto='none'
	uci set network.$1.ifname="$2"
}

guest_network_vlan_settings()
{
	local vlanbridge="br-vlanguest"
	local tablename=$vlanbridge
	local brname=${vlanbridge#br-}
	local is_guestvlan_en=$(uci -q get network.sys.GuestVLANEnable)
	local guestvlantag=$(uci -q get network.sys.GuestVLANID)

	# clear table
	ip route flush table $tablename 2>/dev/null
	while ip rule delete table $tablename 2>/dev/null;do true;done

	if [ "${is_guestvlan_en:-0}" = "1" -a "${guestvlantag:-0}" != "0" ]
	then
		local eth_vlanif=$(append_eth_vid $guestvlantag)
		if [ "$(cat ${enables}|grep -w vlan_id=${guestvlantag})" != "" ]
		then
			add_network_config $brname "na"
		else
			add_network_config $brname "$eth_vlanif"
		fi
	else
		add_network_config $brname "na"
	fi
	uci commit network
}

get_wifi_configs()
{
	local device=$1
	local wifi_mode=$(uci -q get wireless.${device}.opmode)
	local configs
	local enabled_configs

	if [ "$wifi_mode" = "ap" -o "$wifi_mode" = "wds_ap" ]
	then
		if [ "$is_enjet_on" = "1" ]
		then
			configs="${device}_enjet"
		else
			configs=$(foreach wireless wifi-iface mode_display $wifi_mode|grep "^${device}_" |grep -v '_guest$\|_lsp$\|_mgmt$\|_enjet$\|_sta$')
		fi

		for option in $configs
		do
			local disabled=$(uci -q get wireless.${option}.disabled)
			if [ "${disabled:-1}" != "1" ]
			then
				enabled_configs="${option:+$enabled_configs $option}"
			fi
		done
	fi

	echo $enabled_configs
}

get_bridge_prefix()
{
	local device=$1
	local prefix=ssid

	if [ "$is_enjet_on" = "1" ]
	then
		local wifi_mode="enjet"
	else
		local wifi_mode=$(uci -q get wireless.${device}.opmode)
	fi

	case $wifi_mode in
		ap)
			prefix=ssid
		;;
		wds_ap)
			prefix=wds
		;;
		enjet)
			prefix=enjet
		;;
	esac
	echo $prefix
}

isolation_network_options()
{
	local device="$1"

	wifi_configs=$(get_wifi_configs $device)
	bridge_prefix=$(get_bridge_prefix $device)

	# Gather the ssid which enable and isolate for further check
	for option in $wifi_configs; do
		local isolation=$(uci -q get wireless.${option}.isolation)
		[ "${isolation:-0}" = "0" ] && continue

		local vlanID=$(uci -q get wireless.${option}.vlan_id)
		[ "${vlanID:-0}" = "0" ] && continue

		echo "wireless.${option}.disabled=${disabled}" >> $enables
		echo "wireless.${option}.vlan_id=${vlanID}" >> $enables
	done

	if [ -r $enables ]; then
		cat ${enables}|grep vlan_id|cut -d "=" -f 2 > $filter_vlanIDs
	fi

	# look for repeat vlanID
	if [ -r $filter_vlanIDs ]; then
		sort $filter_vlanIDs | uniq -d > $repeat
	fi

	# It's necessary to scan all wifi configs for new settings.
	for option in $wifi_configs; do
		local isolation=$(uci -q get wireless.${option}.isolation)
		local vlanID=$(uci -q get wireless.${option}.vlan_id)
		local guest_network=$(uci -q get wireless.${option}.guest_network)
		local wireless_ifname=$(uci -q get wireless.${option}.ifname)

		local iface_ssid=${bridge_prefix}$(get_ssid_num $wireless_ifname)
		vlan_network=${iface_ssid}vlan

		if [ "$vlanEnable" = 1 -a "${isolation:-0}" = 0 ]; then
			if [ "${guest_network:-Disable}" != "Disable" ];then
				uci set wireless.${option}.network="guest"
			else
				uci set wireless.${option}.network="99"
			fi
		elif [ "$vlanEnable" = 1 -a "$MvlanID" = "$vlanID" -o "${isolation:-0}" = "0" ]; then
			if [ "${guest_network:-Disable}" != "Disable" ];then
				if [ "${captived:-0}" = "1" ] && [ "${portal_en:-0}" = "1" ]; then
					if [ "${guest_network}" = "NAT" ] || [ "${guest_network}" = "Bridge" ];then
						add_network_config $iface_ssid "na"
						uci set wireless.$option.network="$iface_ssid"
					else
						# Enable
						uci set wireless.$option.network="guest"
					fi
				else
					uci set wireless.$option.network="guest"
				fi
			else
				add_network_config $vlan_network "na"
				uci set network.$vlan_network.macaddr=$lan_mac_address
				uci set wireless.${option}.network="`uci -q get /rom/etc/config/wireless.${option}.network`"
			fi
		else
			local vlanifnames=$(append_eth_vid ${vlanID})

			if [ -r "$repeat" -a -n "$(grep -w ${vlanID} ${repeat})" ]; then
				local new=$(cat ${enables}|grep -w vlan_id=${vlanID}|head -n 1|cut -d "." -f 2)
				local new_option=${new#wifi[0-9]_}
				if [ "${option#wifi[0-9]_}" != "$new_option" ]; then
					new_prefix=${new_option%_*}
					add_network_config $vlan_network "na"
					vlan_ifname=$(uci -q get wireless.${new}.ifname)
					vlan_network=${new_prefix}$(get_ssid_num $vlan_ifname)vlan
				fi
			fi

			add_network_config $vlan_network "$vlanifnames"
			uci set network.$vlan_network.macaddr=$lan_mac_address

			if [ "${guest_network:-Disable}" != "Disable" ];then
				if [ "${captived:-0}" = "1" ] && [ "${portal_en:-0}" = "1" ]; then
					if [ "${guest_network}" = "NAT" ] || [ "${guest_network}" = "Bridge" ];then
						add_network_config $iface_ssid "na"
						uci set wireless.$option.network="$iface_ssid"
					else
						uci set wireless.$option.network="guest"
					fi
				else
					uci set wireless.$option.network="guest"
				fi
			else
				uci set wireless.$option.network=$vlan_network
			fi
		fi
	done

	uci commit
}

isolation_vlan_settings()
{
	clear_network_configs
	# needn't remove empty bridge. if empty bridge exist, netifd status is wrong, call ubus to remove it.
	#remove_empty_bridges
	MvlanID=$(uci -q get network.sys.ManagementVLANID)
	vlanEnable=$(uci -q get network.sys.WLANVLANEnable)

	if [ "$vlanEnable" = "1" ]; then
		if [ -n "$is_wds_ap" ]; then
			if [ "`uci -q get wireless.wifi0.opmode`" == "wds_ap" ]; then
				uci set wireless.wifi0_wds_0.network="99"
				uci set wireless.wifi1_wds_0.network="lan"
			elif [ "`uci -q get wireless.wifi1.opmode`" == "wds_ap" ]; then
				uci set wireless.wifi0_wds_0.network="lan"
				uci set wireless.wifi1_wds_0.network="99"
			fi
		elif [ -n "$is_wds_bridge" ]; then
			if [ "`uci -q get wireless.wifi0.opmode`" == "wds_bridge" ]; then
				uci set wireless.wifi0_wds.network="99"
				uci set wireless.wifi1_wds.network="lan"
			elif [ "`uci -q get wireless.wifi1.opmode`" == "wds_bridge" ]; then
				uci set wireless.wifi0_wds.network="lan"
				uci set wireless.wifi1_wds.network="99"
			fi
		fi
		uci set network.lan.ifname="$(append_eth_vid ${MvlanID})"
		uci set network.99.ifname="$lan_ifnames"
	else
		uci set wireless.wifi0_wds_0.network="lan"
		uci set wireless.wifi1_wds_0.network="lan"
		uci set wireless.wifi0_wds.network="lan"
		uci set wireless.wifi1_wds.network="lan"

		uci set network.lan.ifname="$lan_ifnames"
		uci set network.99.ifname="na"
	fi

	isolation_network_options wifi0
	isolation_network_options wifi1
	guest_network_vlan_settings

	[ -r $repeat ] && rm -rf $repeat
	[ -r $enables ] && rm -rf $enables
	[ -r $filter_vlanIDs ] && rm -rf $filter_vlanIDs
}

mesh_bridge()
{
	if [ "$mesh_off" = "0" ]; then
		local uci_commands="`uci show network |grep "ifname=" |grep "eth1\|eth0"| grep -v "bat0"`"
		_IFS=$IFS
		IFS=$'\n'
		for cmd in $uci_commands
		do
			local ifnames="${cmd#*=}"
			ifnames=${ifnames//\'/}
			IFS=$' '
			for ifname in $ifnames
			do
				local vlanid=${ifname#*.}
				if [ "$vlanid" = "$ifname" ]
				then
					vlanid=
				fi
				local batname=bat0${vlanid:+.}$vlanid
				break
			done
			echo uci set ${cmd%=*}=\"$ifnames $batname\"
			uci set ${cmd%=*}="$ifnames $batname"
			IFS=$'\n'
		done
		IFS=$_IFS
		uci commit network
		ubus call network reload
	fi
}
