#!/bin/sh

dhcp_renew()
{
	PID=`pidof udhcpc`
	#1. release
	/bin/kill -SIGUSR2 $PID
	#2. renew
	/bin/kill -SIGUSR1 $PID
}

get_bridge_name() {
	if [ "${1%%-*}" = "br" ];then
		ifname=$(ls /sys/class/net/$1/brif/)
		echo $ifname
	else
		bridge_path=$(ls /sys/class/net/br-*/brif/$1/state 2>/dev/null)
		if [ "$bridge_path" != "" ];then
			bridge_path=${bridge_path#/sys/class/net/}
			echo ${bridge_path%%/*}
		else
			echo
		fi
	fi
}

# only for SSID-based
get_ssid_num() {
	local input=$1
	if [ "${input%%-*}" = "br" ];then
		# filter bridge_prefix, ssid or wds
		ssidnum=${input#br-ssid}
		ssidnum=${ssidnum#br-wds}
	else
		ssidnum=${input#ath[0-9]}
		ssidnum=${ssidnum#enjet[0-9]}
		ssidnum=$((${ssidnum:-0}+1))
	fi
	echo ${ssidnum:-1}
}

get_iface() {
	opt=$1
	ifname=$2
	case "$opt" in
		ip)
			ifconfig $ifname | awk '/inet addr/{print substr($2,6)}'
			;;
		mask)
			ifconfig $ifname | awk '/Mask:/{print substr($4,6)}'
			;;
		mac|macnc|machypen)
			local mac=$(ifconfig $ifname | awk '/HWaddr/{print $5}')
			if [ $opt = "macnc" ]; then
				echo $mac |tr -d ":"
			elif [ $opt = "machypen" ]; then
				echo $mac | sed 's/:/-/g'
			else
				echo $mac
			fi
			;;
	esac
}

get_ipv6_ll() {
	local mac=$1
	if [ "$mac" = "" ];then
		mac=$(get_iface mac br-lan)
		mac=${mac:-`setconfig -g 6`}
		mac=$(tolower $mac)
	fi
	IFS=':'; set $mac; unset IFS
	echo "fe80::$(printf %02x $((0x$1 ^ 2)))$2:${3}ff:fe$4:$5$6"
}

tolower() {
	echo $1 | tr [A-Z] [a-z]
}
