#!/bin/sh

RESET_BTN=17

check_ipaddr_format() {
	[ -n "$1" ] && [ -z "$(echo "$1" | sed -e "s/^[0-9]\{1,3\}\(\.[0-9]\{1,3\}\)\{3\}//g")" ] && echo "$1"
}
	
increase_ipaddr() {
	count="0"
	ipaddr=""
	for ip in $(check_ipaddr_format $2 | tr "." " "); do
		count="$(($count + 1))"
		[ "$1" = "$count" ] && ip="$((($ip + 1) % 256))"
		ipaddr="$ipaddr.$ip"
	done
	echo $ipaddr | cut -c 2- && ipaddr=""
}

[ -n "$1" -a -n "$2" -a -n "$3" -a -f "$3" -a -n "$4" -a -f "$4" ] && {
	. $3 && [ "$final" = "1" ] && rm -rf $3 
	[ ! "$art" = "0" ] && art="1"
	echo "art=$art" >>$4
	for i in artnode network telnet done art; do
		case $i in
			"network")
				[ "$2" = "boot" ] && {
					echo "$(uci get system.@system[0].hostname)" >/proc/sys/kernel/hostname
					for mod in ag7100_mod ag7240_mod athrs_gmac; do
						(insmod $mod sw_only=0 || insmod $mod) 2>&- && break
					done
					[ "$art" = "0" ] && {
						for mod in adf asf ath_hal ath_rate_atheros ath_dfs ath_spectral ath_dev umac ath_pktlog; do
							insmod $mod 2>&-
						done
						for if in $(ls /sys/class/net/ | grep "wifi[0-9]\+"); do
							wlanconfig ath create wlandev $if wlanmode ap 2>&-
						done
						for if in $(ls /sys/class/net/ | grep "ath[0-9]\+"); do
							ifconfig $if up 2>&-
						done
						sleep 1
						for if in $(ls /sys/class/net/ | grep "ath[0-9]\+"); do
							iwconfig $if txpower 9 2>&-
						done
					}
					[ ! "$network" = "0" ] && {
						[ -z "$network" ] && {
							network="2"
						}
						[ -z "$(check_ipaddr_format "$ipaddr")" ] && {
							ipaddr="$(uci get network.lan.ipaddr 2>&-)"
							[ -z "$(check_ipaddr_format "$ipaddr")" ] && \
								ipaddr="192.168.1.1"
						}
						[ -z "$(check_ipaddr_format "$netmask")" ] && {
							netmask="$(uci get network.lan.netmask 2>&-)"
							[ -z "$(check_ipaddr_format "$netmask")" ] && \
								netmask="255.255.255.0"
						}
						interfaces="$(ls /sys/class/net/ | grep "eth[0-9]\+")"
						macaddr="00026fffffff"
						for if in $interfaces; do
							ifconfig $if hw ether $macaddr
							macaddr="$(printf "%012x" "$((0x${macaddr} - 1))")"
						done
						[ "$network" = "1" ] && {
							brif="br-lan"
							brctl addbr $brif setfd $brif 0 stp $brif 0
							for if in $interfaces; do
								ifconfig $if up 2>&- && brctl addif $brif $if 2>&-
							done
							interfaces="$brif"
						}
						for if in $interfaces; do
							ifconfig $if $ipaddr netmask $netmask up
							arping -bc 5 -UI $if -s $ipaddr 0.0.0.0
							ipaddr="$(increase_ipaddr 3 $ipaddr)"
						done&
						[ -d "/sys/class/net/lo" ] && \
							ifconfig lo 127.0.0.1 netmask 255.0.0.0 up
						
						for item in $(ls /sys/class/leds); do
                                                	(echo none > /sys/class/leds/$item/trigger) 2>&-
                                                	(echo 1 > /sys/class/leds/$item/brightness) 2>&-
                                                done
						echo 0 > /proc/Lan_Led	
						for mod in $(lsmod | grep gpio_button_hotplug) ; do
                        				case ${mod} in
                                				gpio_button_hotplug) rmmod ${mod};;
                        				esac
                				done

        					[ -e /sys/class/gpio/ ] && {
                					echo $RESET_BTN  > /sys/class/gpio/export
        					}
					}
				}
				;;
			"telnet")
				[ "$2" = "boot" ] && {
					login="/tmp/login.sh"
					(cat <<EOF
#!/bin/sh

. $4 2>&-
. /lib/auth.sh 2>&-

mode="ART"
sku_file="/tmp/_sys/sku"
sn_file="/tmp/_sys/sn"
[ "\$art" = "0" ] && mode="WIFI"
echo "[FACTORY-\$mode]"
while [ true ]; do
	read -rp "console> " input arg1 arg2
	case \$input in
		"1d68d24ea0d9bb6e19949676058f1b93")
			read -rp "login as: " username
			read -rp "\$username's password: " password
			if [ "\$(get_username)" = "\$username" -a "\$(get_password)" = "\$(psencry "\$password")" ]; then
				exec /bin/ash --login
			else
				echo "Access denied"
			fi
			;;
		"status")
			var="\$(cat /sys/class/gpio/gpio$RESET_BTN/value)"
                        if [ "\$var" = "1" ]; then
                                reserve_var=0
                                button_status="Released"
                        else
                                reserve_var=1
                                button_status="Pressed"
                        fi
                        echo "BUTTON_RESET (00-01): [0\$reserve_var] (\$button_status)"

			for item in \$(ls /sys/class/leds); do
                        	var="\$(cat /sys/class/leds/$item/brightness)"
				if [ "\$var" = "1" ]; then
	                                reserve_var=0
        	                        led_status="OFF"
                	        else
                        	        reserve_var=1
                                	led_status="ON"
                        	fi
				case "\$item" in
					"lan")
						tag_name="LED_LAN"
					;;
					"power")
						tag_name="LED_POWER"
					;;
					"wlan-2g")
						tag_name="LED_WLAN2G"
					;;
					"wlan-5g")
						tag_name="LED_WLAN5G"
					;;
				esac
				echo "\$tag_name (00-01): [0\$reserve_var] (\$led_status)"
			done
			;;
		"led-on" | "led-off")
			var="1"
                        if [ "\$input" = "led-on" ]; then
				var="0"
				echo 1 > /proc/Lan_Led
			else
				echo 0 > /proc/Lan_Led
			fi
                        for item in \$(ls /sys/class/leds); do
                                (echo none >/sys/class/leds/\$item/trigger) 2>&-
                                (echo \$var >/sys/class/leds/\$item/brightness) 2>&-
                        done
			
			;;
		"eth"[0-9]*"loop")
			var="\$(ls /sys/class/net/ | grep "^\$(echo \$input | sed -e "s/^\(eth[0-9]\+\)loop\$/\1/g")\$")"
			[ -n "\$var" ] && {
				(echo 1 > /proc/hwctrl/diagnostic_ethloop) 2>&-
				ethSocketIO \$var X 1000
				(echo 0 > /proc/hwctrl/diagnostic_ethloop) 2>&-
			}
			;;
		"art" | "wifi")
			[ -f "$3" ] && {
				var="0"
				[ "\$input" = "art" ] && var="1"
				var="\$(cat $3 2>&- | grep -v "^[ \t]*art=" && echo "art=\$var")"
				[ -n "\$var" ] && echo "\$var" >$3 && sync
			}
			;;
		"final")
			[ -f "$3" ] && {
				var="\$(cat $3 2>&- | grep -v "^[ \t]*final=" && echo "final=1")"
				[ -n "\$var" ] && echo "\$var" >$3 && sync
			}
			;;
		"sku")
                        read -rp "sku 0/1/2/g (0:FCC, 1:ETSI, 2:INT, g:GET): " sku_domain
                        if [ "\$sku_domain" = "0" -o "\$sku_domain" = "1" -o "\$sku_domain" = "2" -o "\$sku_domain" = "g" ]; then

                                case \$sku_domain in
                                        "0")
                                                var=FCC
                                                ;;
                                        "1")
                                                var=ETSI
                                                ;;
                                        "2")
                                                var=INT
                                                ;;
                                        "g")
                                                cat \$sku_file
                                                ;;

                                esac
                                if [ "\$sku_domain" != "g" ]; then
                                        echo \$var > \$sku_file
                                fi
                        else
                                echo "Incorrect Sku, it SHOULD be 0, 1, or 2"
                        fi
                        ;;
		"sn")
			if [ "\$arg1" == "set" ]; then
				echo \$arg2 > \$sn_file
			elif [ "\$arg1" == "get" ]; then
				cat \$sn_file 2>/dev/null
			fi
			;;
		"ok")
			rm -rf $3 && reboot
			;;
		"exit" | "quit" | "q")
			exit
			;;
		"?" | "help")
                        echo "Useage:"
                        echo "  status:                 Display the current status of LED and push button"
                        echo "  led-on/off:             Turn on/off led of WIFI"
                        echo "  sku:                    Display SKU"
                        echo "  exit|q|quit:            Close the session of MP"
                        echo "  ok:                     End of MP and change to user mode"
                        ;;
		*)
			;;
	esac
done
EOF
					) >$login && chmod a+x $login && telnetd -l $login
				}
				[ "$2" = "stop" ] && {
					killall telnetd
				}
				;;
			"art")
				# Iven 20180620: 
				# QCA SPF5.x does not support QCA9880 for "art2" calibration 
				# We will load qca-wifi-10.2.4 driver & art from tftp server for calibration
				#/etc/init.d/art start
				for item in $(ls /sys/class/leds | grep "^wlan-"); do
                                        (echo none > /sys/class/leds/$item/trigger) 2>&-
                                        (echo 1 > /sys/class/leds/$item/brightness) 2>&-
                                done
				;;
			*)
				[ -x /etc/init.d/$i ] && /etc/init.d/$i $2 2>&1
				;;
		esac
	done >/dev/null
}
