/*
    <:copyright-BRCM:2015:DUAL/GPL:standard
    
       Copyright (c) 2015 Broadcom 
       All Rights Reserved
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
    :>
*/

#include "rdp_subsystem_common.h"
#include "rdp_drv_rnr.h"
#include "rdp_common.h"
#include "rdd_fw_defs.h"
#include "XRDP_AG.h"
#include "fw_binary_auto.h"
#include "rdd_runner_proj_defs.h"
#include "rdd_map_auto.h"
#include "rdd_data_structures_auto.h"
#include "rdd_defs.h"
#if CHIP_VER < RDP_GEN_62
#include "xrdp_drv_ubus_slv_ag.h"
#else
#include "xrdp_drv_ubus_resp_ag.h"
#endif


#define RNR_NOP_OPCODE  0xFC000000

static int _num_of_cores = NUM_OF_RUNNER_CORES;

uintptr_t rdp_runner_core_addr[NUM_OF_RUNNER_CORES];


int drv_rnr_dma_cfg(rnr_dma_regs_cfg_t *rnr_dma_cfg)
{
    uint8_t rnr_idx;
    int rc = BDMF_ERR_OK;

    for (rnr_idx = 0; rnr_idx < _num_of_cores; rnr_idx++)
    {

#if CHIP_VER < RDP_GEN_60
        rc = ag_drv_rnr_regs_cfg_ddr_cfg_set(rnr_idx, rnr_dma_cfg->ddr.dma_base, rnr_dma_cfg->ddr.dma_buf_size, rnr_dma_cfg->ddr.dma_static_offset);
#else
        rc = ag_drv_rnr_regs_cfg_ddr_cfg_set(rnr_idx, rnr_dma_cfg->ddr.dma_base, rnr_dma_cfg->ddr.dma_buf_size, 1, rnr_dma_cfg->ddr.dma_static_offset);
#endif
        /* each quad should go to a different UBUS slave in PSRAM */
#if defined(BCM6858)
        rc = rc ? rc : ag_drv_rnr_regs_cfg_psram_cfg_set(rnr_idx, (rnr_dma_cfg->psram.dma_base + (rnr_idx/4)), rnr_dma_cfg->psram.dma_buf_size, rnr_dma_cfg->psram.dma_static_offset);
#elif CHIP_VER >= RDP_GEN_60
        rc = rc ? rc : ag_drv_rnr_regs_cfg_psram_cfg_set(rnr_idx, rnr_dma_cfg->psram.dma_base, rnr_dma_cfg->psram.dma_buf_size, 0, rnr_dma_cfg->psram.dma_static_offset);
#else
        rc = rc ? rc : ag_drv_rnr_regs_cfg_psram_cfg_set(rnr_idx, rnr_dma_cfg->psram.dma_base, rnr_dma_cfg->psram.dma_buf_size, rnr_dma_cfg->psram.dma_static_offset);
#endif
	}
    return rc;
}

void drv_rnr_cores_addr_init(void)
{
    uint32_t i;

    for (i = 0; i < _num_of_cores; i++)
    {
        rdp_runner_core_addr[i] = RU_BLK(RNR_MEM).addr[i] + RU_REG_OFFSET(RNR_MEM, HIGH);
        ACCESS_LOG(ACCESS_LOG_OP_SET_CORE_ADDR, rdp_runner_core_addr[i], i, 0);
    }
}

inline void drv_rnr_profiling_clear_trace(uint8_t core_id)
{

}

void drv_rnr_profiling_core_init(uint8_t core_id)
{

}

void drv_rnr_quad_profiling_quad_init(rnr_quad_id_e quad_id)
{

}

void drv_rnr_mem_init(void)
{
    uint8_t rnr_idx;
    uint32_t mem_byte_num, mem_cntxt_byte_num;

    mem_byte_num = 2 * (RU_REG_RAM_CNT(RNR_MEM, HIGH) + 1) * sizeof(uint32_t);
    mem_cntxt_byte_num = (RU_REG_RAM_CNT(RNR_CNTXT, MEM_ENTRY) + 1) * sizeof(uint32_t);

    for (rnr_idx = 0; rnr_idx < _num_of_cores; rnr_idx++)
    {
        /* reset SRAM memory */
        MEMSET((uint32_t *)DEVICE_ADDRESS(RU_BLK(RNR_MEM).addr[rnr_idx] + RU_REG_OFFSET(RNR_MEM, HIGH)), 0, mem_byte_num);

        /* reset SRAM context memory */
        MEMSET((uint32_t *)DEVICE_ADDRESS(RU_BLK(RNR_CNTXT).addr[rnr_idx] + RU_REG_OFFSET(RNR_CNTXT, MEM_ENTRY)), 0, mem_cntxt_byte_num);
    }
}

void drv_rnr_load_microcode(void)
{
    uint8_t rnr_idx;
    uint32_t inst;
    uint32_t mem_inst_word_num = (RU_REG_RAM_CNT(RNR_INST, MEM_ENTRY) + 1) ;
#if (defined(CONFIG_BRCM_IKOS) && (!(defined(PHYS_ADDR_64BIT) && !defined(CONFIG_GPL_RDP_GEN))))
    uint8_t nops;
#endif
    for (rnr_idx = 0; rnr_idx < _num_of_cores; rnr_idx++)
    {
#if (defined(CONFIG_BRCM_IKOS) && (!(defined(PHYS_ADDR_64BIT) && !defined(CONFIG_GPL_RDP_GEN))))
    	nops = 0;
#endif
#if defined(PHYS_ADDR_64BIT) && !defined(CONFIG_GPL_RDP_GEN)
        for (inst = 0; inst < mem_inst_word_num; inst += 2)
        {
            MWRITE_I_64(DEVICE_ADDRESS(RU_BLK(RNR_INST).addr[rnr_idx]), inst >> 1,
                *(uint64_t*)&fw_inst_binaries[rnr_idx][inst]);
        }
#else
        /* Pre-init instruction memory with NOPs */
        MEMSET_32(DEVICE_ADDRESS(RU_BLK(RNR_INST).addr[rnr_idx]), RNR_NOP_OPCODE, mem_inst_word_num);

        for (inst = 0; inst < mem_inst_word_num; inst ++)
        {
#ifdef CONFIG_BRCM_IKOS
            if (nops > 25)
                break;
            if (fw_inst_binaries[rnr_idx][inst+1] == 0xFC000000)
            {
                if (fw_inst_binaries[rnr_idx][inst] == 0xFC000000)
                    nops +=2;
                else
                    nops = 1;
            }
            else
            {
                nops = 0;
            }
#endif
            if (*(uint32_t*)&fw_inst_binaries[rnr_idx][inst] != RNR_NOP_OPCODE)
            {
                MWRITE_I_32(DEVICE_ADDRESS(RU_BLK(RNR_INST).addr[rnr_idx]), inst,
                    *(uint32_t*)&fw_inst_binaries[rnr_idx][inst]);
            }
        }
#endif
    }
}

static void memcpyl_prediction(void *__to, void *__from, unsigned int __n)
{
    uint8_t *src = (uint8_t *)__from;
    uint8_t *dst = (uint8_t *)__to;

    int i;
    for (i = 0; i < (__n / 2); i++, src += 2, dst += 4)
        MWRITE_32(dst, (unsigned int)(*(volatile unsigned short *)src));
}

void drv_rnr_load_prediction(void)
{
    uint8_t rnr_idx;
    uint32_t mem_pred_byte_num = (RU_REG_RAM_CNT(RNR_PRED, MEM_ENTRY) + 1) * sizeof(uint16_t);

    for (rnr_idx = 0; rnr_idx < _num_of_cores; rnr_idx++)
    {
        memcpyl_prediction((void *)(DEVICE_ADDRESS(RU_BLK(RNR_PRED).addr[rnr_idx] + RU_REG_OFFSET(RNR_PRED, MEM_ENTRY))), fw_pred_binaries[rnr_idx], mem_pred_byte_num);
    }
}

void rdp_rnr_write_context(void *__to, void *__from, unsigned int __n)
{
    uint8_t *src = (uint8_t *)__from;
    uint8_t *dst = (uint8_t *)__to;
    int i, n = __n / 4;

    for (i = 0; i < n; i++, src += 4, dst += 4)
    {
/* In 68460: and 63158, context memory has logical size 96x128 */
#if defined(BCM6858) || defined(BCM6836)
        if ((i & 0x3) == 3)
            continue;
#endif
        MWRITE_32(dst, *(volatile unsigned int *)src);
    }
}

int drv_rnr_config_clock_autogate(bdmf_boolean auto_gate, uint8_t timer_val)
{

     rnr_quad_general_config_powersave_config rnr_ctrl;
     uint8_t block_id = 0;

     for (block_id = 0; block_id < RU_BLK(RNR_QUAD).addr_count; block_id++) {
         ag_drv_rnr_quad_general_config_powersave_config_get(block_id, &rnr_ctrl);
         rnr_ctrl.enable_powersave_core_0 = auto_gate ? 1 : 0;
         rnr_ctrl.enable_powersave_core_1 = auto_gate ? 1 : 0;
         rnr_ctrl.enable_powersave_core_2 = auto_gate ? 1 : 0;
#if !defined(BCM6846) && !defined(BCM6878) && !defined(BCM63146) && !defined(BCM4912)
         rnr_ctrl.enable_powersave_core_3 = auto_gate ? 1 : 0;
#ifndef BCM6858
         rnr_ctrl.enable_powersave_core_4 = auto_gate ? 1 : 0;
         rnr_ctrl.enable_powersave_core_5 = auto_gate ? 1 : 0;
#endif
#endif
         rnr_ctrl.time_counter = timer_val;
         ag_drv_rnr_quad_general_config_powersave_config_set(block_id, &rnr_ctrl);
     }

     return 0;
}

void drv_rnr_num_of_cores_set(int num_of_cores)
{
    _num_of_cores = num_of_cores;
}

