/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/



/* This is an automated file. Do not edit its contents. */


#ifndef _RDD_DATA_STRUCTURES_AUTO_H_
#define _RDD_DATA_STRUCTURES_AUTO_H_

#define NUM_OF_RUNNER_CORES       8
#define INVALID_TABLE_ADDRESS         0xFFFFFF

#ifdef __clang__
    #define ALIGNMENT(x) __attribute__((align_value((x))))
    #else
    #define ALIGNMENT(x)
    #endif
    


/* >>>QM_QUEUE_COUNTER_DATA_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
        uint32_t	packets   	;
        uint32_t	bytes     	;
        uint32_t	reserved0 	;
        uint32_t	reserved1 	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) QM_QUEUE_COUNTER_DATA_STRUCT;

#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (r), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (v), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ(r, p)                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (r), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (v), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<QM_QUEUE_COUNTER_DATA_STRUCT */


/* >>>SERVICE_QUEUES_CONTEXT_DATA_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
        uint16_t	tx_queue  	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) SERVICE_QUEUES_CONTEXT_DATA_STRUCT;

#define RDD_SERVICE_QUEUES_CONTEXT_DATA_TX_QUEUE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(SERVICE_QUEUES_CONTEXT_DATA_STRUCT), (r))
#define RDD_SERVICE_QUEUES_CONTEXT_DATA_TX_QUEUE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(SERVICE_QUEUES_CONTEXT_DATA_STRUCT), (v))
#define RDD_SERVICE_QUEUES_CONTEXT_DATA_TX_QUEUE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(SERVICE_QUEUES_CONTEXT_DATA_STRUCT), (r), core_id)
#define RDD_SERVICE_QUEUES_CONTEXT_DATA_TX_QUEUE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(SERVICE_QUEUES_CONTEXT_DATA_STRUCT), (v), core_id)
#define RDD_SERVICE_QUEUES_CONTEXT_DATA_TX_QUEUE_READ(r, p)                                       MREAD_16((uint8_t *)(p), (r))
#define RDD_SERVICE_QUEUES_CONTEXT_DATA_TX_QUEUE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p), (v))
/* <<<SERVICE_QUEUES_CONTEXT_DATA_STRUCT */


/* >>>MCAST_RESOLUTION_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	egress_ports_vector	;
        uint8_t	iptv_repl_0_sop    	;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	egress_ports_vector	;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_repl_0_sop    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) MCAST_RESOLUTION_STRUCT;

#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r), core_id)
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v), core_id)
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r), core_id)
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v), core_id)
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r), core_id)
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v), core_id)
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r), core_id)
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v), core_id)
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r), core_id)
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v), core_id)
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r), core_id)
#define RDD_MCAST_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v), core_id)
#define RDD_MCAST_RESOLUTION_TC_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 0, 3, (v))
/* <<<MCAST_RESOLUTION_STRUCT */


/* >>>NAT_CACHE_L3_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx          	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lookup_port         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_ip_3_0          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_extend          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pbit_protocol       	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_client_idx        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tcp_pure_ack      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lookup_port       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dst_ip_3_0        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sub_table_id      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_key_extend        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	protocol                      	; /* Member of pbit_protocol union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_client_idx        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tcp_pure_ack      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lookup_port       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dst_ip_3_0        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sub_table_id      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_key_extend        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	unused                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pbit_protocol union */
        uint32_t	pbit                          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pbit_protocol union */
        uint32_t	protocol_code                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pbit_protocol union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	src_port            	;
        uint16_t	dst_port            	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_ip              	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip              	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	pbit_protocol       	; /* This is a field union */
        uint32_t	key_extend          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dst_ip_3_0          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lookup_port         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx          	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	protocol                      	; /* Member of pbit_protocol union */
        uint32_t	reservedSU1_key_extend        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sub_table_id      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dst_ip_3_0        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lookup_port       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tcp_pure_ack      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_client_idx        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	protocol_code                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pbit_protocol union */
        uint32_t	pbit                          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pbit_protocol union */
        uint32_t	unused                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pbit_protocol union */
        uint32_t	reservedSU2_key_extend        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sub_table_id      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dst_ip_3_0        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lookup_port       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_context_extension	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tcp_pure_ack      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_client_idx        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	dst_port            	;
        uint16_t	src_port            	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_ip              	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip              	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_L3_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_VALID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_CLIENT_IDX_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 0, 7, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_CLIENT_IDX_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 0, 7, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_CLIENT_IDX_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 0, 7, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_CLIENT_IDX_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT), 0, 7, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_CLIENT_IDX_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 7, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_CLIENT_IDX_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 7, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 7, 1, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 7, 1, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_TCP_PURE_ACK_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_LOOKUP_PORT_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 0, 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_LOOKUP_PORT_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 0, 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_LOOKUP_PORT_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_LOOKUP_PORT_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_LOOKUP_PORT_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_LOOKUP_PORT_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 4, 4, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 4, 4, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_3_0_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 1, 3, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 1, 3, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 0, 1, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 2, 0, 1, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_KEY_EXTEND_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_PROTOCOL_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_PROTOCOL_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_PROTOCOL_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_PROTOCOL_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_PROTOCOL_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_PROTOCOL_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_UNUSED_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_UNUSED_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_UNUSED_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 7, 1, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_UNUSED_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 7, 1, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_UNUSED_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_UNUSED_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 4, 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 4, 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 4, 3, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 4, 3, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 4, 3, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PBIT_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 4, 3, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_CODE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 0, 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_CODE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 0, 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_CODE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 0, 4, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_CODE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 3, 0, 4, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_CODE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_PROTOCOL_CODE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_PORT_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_PORT_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_SRC_IP_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L3_LKP_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_L3_LKP_ENTRY_DST_IP_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<NAT_CACHE_L3_LKP_ENTRY_STRUCT */


/* >>>NAT_CACHE_L2_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx             	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_llc_snap            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lookup_port            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_mac_dst_mac_crc_3_0	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcp_pure_ack           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	wan_flow               	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	etype                  	;
        uint8_t	tos_union              	; /* This is a field union */
        uint32_t	num_of_vlans           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tpid_vlan_0            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tpid_vlan_1            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_etype                	;
        uint8_t	tos                              	; /* Member of tos_union union */
        uint32_t	reservedSU1_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_etype                	;
        uint32_t	dscp                             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	ecn                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	reservedSU2_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	vlan_0_union           	; /* This is a field union */
        uint16_t	vlan_1_union           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	vlan0                            	; /* Member of vlan_0_union union */
        uint16_t	vlan1                            	; /* Member of vlan_1_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	vid0                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	dei0                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	pbit0                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	vid1                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	dei1                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	pbit1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_mac_dst_mac_crc    	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	wan_flow               	;
        uint32_t	tcp_pure_ack           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_mac_dst_mac_crc_3_0	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lookup_port            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_context_extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_llc_snap            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx             	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tpid_vlan_1            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tpid_vlan_0            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_vlans           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos_union              	; /* This is a field union */
        uint16_t	etype                  	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos                              	; /* Member of tos_union union */
        uint16_t	reservedSU1_etype                	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_tpid_vlan_1          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tpid_vlan_0          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_of_vlans         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	dscp                             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint16_t	reservedSU2_etype                	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	vlan_1_union           	; /* This is a field union */
        uint16_t	vlan_0_union           	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	vlan1                            	; /* Member of vlan_1_union union */
        uint16_t	vlan0                            	; /* Member of vlan_0_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	pbit1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	dei1                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	vid1                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_1_union union */
        uint32_t	pbit0                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	dei0                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
        uint32_t	vid0                             	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_0_union union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_mac_dst_mac_crc    	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_L2_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VALID_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_CLIENT_IDX_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 0, 7, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_CLIENT_IDX_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 0, 7, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_CLIENT_IDX_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 0, 7, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_CLIENT_IDX_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT), 0, 7, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_CLIENT_IDX_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 7, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_CLIENT_IDX_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 7, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ZERO_RESERVED_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ZERO_RESERVED_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ZERO_RESERVED_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 7, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ZERO_RESERVED_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 7, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ZERO_RESERVED_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ZERO_RESERVED_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_LLC_SNAP_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 5, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 5, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 5, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 5, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_IS_CONTEXT_EXTENSION_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 0, 5, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 0, 5, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 0, 5, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 1, 0, 5, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 5, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_LOOKUP_PORT_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 5, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 4, 4, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 4, 4, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_3_0_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 1, 3, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 1, 3, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 0, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 2, 0, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TCP_PURE_ACK_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_WAN_FLOW_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ETYPE_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_READ_G(r, g, idx)                                              GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_WRITE_G(v, g, idx)                                             GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_READ(r, p)                                                     MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_UNION_WRITE(v, p)                                                    MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_READ_G(r, g, idx)                                                    GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_READ(r, p)                                                           MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TOS_WRITE(v, p)                                                          MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 2, 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 2, 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 2, 6, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 2, 6, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 2, 6, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DSCP_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 2, 6, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 0, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 0, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 0, 2, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 6, 0, 2, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_ECN_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 6, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 6, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 6, 2, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 6, 2, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 6, 2, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_NUM_OF_VLANS_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 6, 2, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 3, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 3, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 3, 3, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 3, 3, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 3, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_0_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 3, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 0, 3, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 7, 0, 3, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_TPID_VLAN_1_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_READ_G(r, g, idx)                                           GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_WRITE_G(v, g, idx)                                          GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_READ(r, p)                                                  MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_0_UNION_WRITE(v, p)                                                 MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN0_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, 4, 12, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 8, 4, 12, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_READ(r, p)                                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID0_WRITE(v, p)                                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI0_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 0, 3, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 9, 0, 3, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT0_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_READ_G(r, g, idx)                                           GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_WRITE_G(v, g, idx)                                          GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_READ(r, p)                                                  MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN_1_UNION_WRITE(v, p)                                                 MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VLAN1_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 10, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, 4, 12, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 10, 4, 12, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_READ(r, p)                                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 4, 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_VID1_WRITE(v, p)                                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 4, 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 3, 1, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 3, 1, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 3, 1, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_DEI1_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 3, 1, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 0, 3, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 11, 0, 3, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 3, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_PBIT1_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 3, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_L2_LKP_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_L2_LKP_ENTRY_SRC_MAC_DST_MAC_CRC_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<NAT_CACHE_L2_LKP_ENTRY_STRUCT */


/* >>>NAT_CACHE_MC_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_ip         	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip         	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	vlans_etype_crc	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	tos_union      	; /* This is a field union */
        uint32_t	rx_vport       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_vlans   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ipv6        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_ip_msb     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	var_size_ctx   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	tos                      	; /* Member of tos_union union */
        uint32_t	reservedSU1_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	dscp                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	ecn                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	reservedSU2_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	src_ip         	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	dst_ip         	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	vlans_etype_crc	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	var_size_ctx   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	client_idx     	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	src_ip_msb     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ipv6        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	zero_reserved  	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_vlans   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rx_vport       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos_union      	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos                      	; /* Member of tos_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_var_size_ctx 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_client_idx   	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_src_ip_msb   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ipv6      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_zero_reserved	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_num_of_vlans 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_rx_vport     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
        uint32_t	dscp                     	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_union union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_MC_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VALID_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 0, 31, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 0, 31, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 0, 31, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT), 0, 31, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_READ(r, p)                                                RDP_FIELD_MREAD_32((uint8_t *)(p), 0, 31, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_WRITE(v, p)                                               RDP_FIELD_MWRITE_32((uint8_t *)(p), 0, 31, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DST_IP_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VLANS_ETYPE_CRC_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_UNION_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_TOS_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 2, 6, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 2, 6, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_DSCP_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 2, 6, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 12, 0, 2, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 0, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ECN_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 0, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 3, 5, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 3, 5, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 3, 5, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 3, 5, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 3, 5, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_RX_VPORT_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 3, 5, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 0, 3, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 0, 3, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 0, 3, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 13, 0, 3, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 3, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_NUM_OF_VLANS_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 3, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 2, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 6, 2, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 6, 2, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_ZERO_RESERVED_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 6, 2, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 5, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 5, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 5, 1, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 5, 1, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 5, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_IS_IPV6_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 5, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 1, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 1, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 4, 1, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_SRC_IP_MSB_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 4, 1, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 8, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 14, 4, 8, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_READ(r, p)                                            RDP_FIELD_MREAD_16((uint8_t *)(p) + 14, 4, 8, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_CLIENT_IDX_WRITE(v, p)                                           RDP_FIELD_MWRITE_16((uint8_t *)(p) + 14, 4, 8, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (r), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_MC_LKP_ENTRY_STRUCT) + 15, 0, 4, (v), core_id)
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_MC_LKP_ENTRY_VAR_SIZE_CTX_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
/* <<<NAT_CACHE_MC_LKP_ENTRY_STRUCT */


/* >>>NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	;
        uint32_t	reserved5   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	port        	;
        uint16_t	rule        	;
#else
        uint32_t	reserved2   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sub_table_id	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1   	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	;
        uint16_t	rule        	;
        uint8_t	port        	;
        uint32_t	extension   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT;

#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_VALID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 2, 1, 3, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 2, 1, 3, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 3, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 3, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, 0, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, 0, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, 0, 1, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 12, 0, 1, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 0, 1, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_EXTENSION_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 0, 1, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 13, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 13, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 13, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 13, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_PORT_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 13, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ_G(r, g, idx)                                        GROUP_MREAD_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE_G(v, g, idx)                                       GROUP_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, (v))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_16((g), (idx)*sizeof(NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_READ(r, p)                                               MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_NAT_CACHE_VLAN_ACTION_KEY_ENTRY_RULE_WRITE(v, p)                                              MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<NAT_CACHE_VLAN_ACTION_KEY_ENTRY_STRUCT */


/* >>>NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sub_table_id	;
        uint16_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	reserved1   	;
        uint8_t	sub_table_id	;
        uint32_t	reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT;

#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 12, 4, 13, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ(r, p)                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 4, 13, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE(v, p)                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 4, 13, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (r), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT) + 15, 0, 4, (v), core_id)
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
/* <<<NAT_CACHE_COUNTER_LKP_ENTRY_STRUCT */


/* >>>NATC_COMMAND_COUNTER_STRUCT */
typedef union
    {
    uint8_t word_8[24];
    uint16_t word_16[12];
    uint32_t word_32[6];
    uint64_t dword_64[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	command_overwritten                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_num                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	decr                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cache_flush                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                               	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	packet_len                              	;
        uint32_t	nat_cache_counter_lkp_entry_valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	nat_cache_counter_lkp_entry_sub_table_id	;
        uint16_t	nat_cache_counter_lkp_entry_reserved1   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved2   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved3   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_written                             	;
#else
        uint16_t	packet_len                              	;
        uint32_t	reserved0                               	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cache_flush                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	decr                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	table_num                               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	command_overwritten                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	nat_cache_counter_lkp_entry_reserved1   	;
        uint8_t	nat_cache_counter_lkp_entry_sub_table_id	;
        uint32_t	nat_cache_counter_lkp_entry_reserved0   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_valid       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_reserved2   	;
        uint32_t	nat_cache_counter_lkp_entry_reserved3   	;
        uint32_t	nat_cache_counter_lkp_entry_not_used    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_counter_key 	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	nat_cache_counter_lkp_entry_reserved4   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_written                             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NATC_COMMAND_COUNTER_STRUCT;

#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (r))
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (v))
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 6, 2, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_NATC_COMMAND_COUNTER_COMMAND_OVERWRITTEN_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_READ_G(r, g, idx)                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (r))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_WRITE_G(v, g, idx)                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (v))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_READ_CORE(r, g, idx, core_id)                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_WRITE_CORE(v, g, idx, core_id)                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 3, 3, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_READ(r, p)                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 3, (r))
#define RDD_NATC_COMMAND_COUNTER_TABLE_NUM_WRITE(v, p)                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 3, (v))
#define RDD_NATC_COMMAND_COUNTER_DECR_READ_G(r, g, idx)                                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_DECR_WRITE_G(v, g, idx)                                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_DECR_READ_CORE(r, g, idx, core_id)                                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_DECR_WRITE_CORE(v, g, idx, core_id)                                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 2, 1, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_DECR_READ(r, p)                                                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_DECR_WRITE(v, p)                                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT), 1, 1, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_CACHE_FLUSH_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_READ_G(r, g, idx)                                                              GROUP_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (r))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (v))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 2, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_READ(r, p)                                                                     MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_NATC_COMMAND_COUNTER_PACKET_LEN_WRITE(v, p)                                                                    MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_VALID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 4, 0, 7, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 7, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED0_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 7, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 5, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_SUB_TABLE_ID_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 6, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED1_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 8, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED2_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 12, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED3_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 1, 15, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_READ(r, p)                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 16, 1, 15, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_RESERVED4_WRITE(v, p)                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 16, 1, 15, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 16, 4, 13, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_READ(r, p)                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 16, 4, 13, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_COUNTER_KEY_WRITE(v, p)                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 16, 4, 13, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (v))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 19, 0, 4, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 4, (r))
#define RDD_NATC_COMMAND_COUNTER_NAT_CACHE_COUNTER_LKP_ENTRY_NOT_USED_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 4, (v))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_READ_G(r, g, idx)                                                             GROUP_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (r))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (v))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (r), core_id)
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_32((g), (idx)*sizeof(NATC_COMMAND_COUNTER_STRUCT) + 20, (v), core_id)
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_READ(r, p)                                                                    MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_NATC_COMMAND_COUNTER_NOT_WRITTEN_WRITE(v, p)                                                                   MWRITE_32((uint8_t *)(p) + 20, (v))
/* <<<NATC_COMMAND_COUNTER_STRUCT */


/* >>>NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	reserved4   	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	var_size_ctx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	;
        uint32_t	var_size_ctx	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT;

#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (r))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (v))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (r), core_id)
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT) + 15, 4, 4, (v), core_id)
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 4, 4, (r))
#define RDD_NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_VAR_SIZE_CTX_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 4, 4, (v))
/* <<<NAT_CACHE_LKP_ENTRY_VAR_SIZE_CTX_STRUCT */


/* >>>NATC_COMMAND_DATA_EXT_STRUCT */
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_NUMBER	40
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_NUMBER	16
typedef union
    {
    uint8_t word_8[56];
    uint16_t word_16[28];
    uint32_t word_32[14];
    uint64_t dword_64[7];
        struct {
        uint8_t natc_command_data_reserved[40];
        uint8_t natc_l2_crc_buf[16];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) NATC_COMMAND_DATA_EXT_STRUCT;

#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (r), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT), i, (v), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_COMMAND_DATA_RESERVED_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ_G(r, g, idx, i)                                        GROUP_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE_G(v, g, idx, i)                                       GROUP_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (v))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ_CORE(r, g, idx, i, core_id)                            CORE_MREAD_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (r), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE_CORE(v, g, idx, i, core_id)                           CORE_MWRITE_I_8((g), (idx)*sizeof(NATC_COMMAND_DATA_EXT_STRUCT) + 40, i, (v), core_id)
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_READ(r, p, i)                                               MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_NATC_COMMAND_DATA_EXT_NATC_L2_CRC_BUF_WRITE(v, p, i)                                              MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
/* <<<NATC_COMMAND_DATA_EXT_STRUCT */


/* >>>HASH_COMMAND_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	configuration	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aging        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_1        	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_0        	;
#else
        uint32_t	key_1        	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	aging        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	configuration	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	key_0        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) HASH_COMMAND_STRUCT;

#define RDD_HASH_COMMAND_CONFIGURATION_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (r))
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (v))
#define RDD_HASH_COMMAND_CONFIGURATION_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (r), core_id)
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 5, 3, (v), core_id)
#define RDD_HASH_COMMAND_CONFIGURATION_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_HASH_COMMAND_CONFIGURATION_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_HASH_COMMAND_AGING_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (r))
#define RDD_HASH_COMMAND_AGING_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (v))
#define RDD_HASH_COMMAND_AGING_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (r), core_id)
#define RDD_HASH_COMMAND_AGING_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 4, 1, (v), core_id)
#define RDD_HASH_COMMAND_AGING_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_HASH_COMMAND_AGING_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_HASH_COMMAND_KEY_1_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (r))
#define RDD_HASH_COMMAND_KEY_1_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (v))
#define RDD_HASH_COMMAND_KEY_1_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (r), core_id)
#define RDD_HASH_COMMAND_KEY_1_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT), 0, 28, (v), core_id)
#define RDD_HASH_COMMAND_KEY_1_READ(r, p)                                               RDP_FIELD_MREAD_32((uint8_t *)(p), 0, 28, (r))
#define RDD_HASH_COMMAND_KEY_1_WRITE(v, p)                                              RDP_FIELD_MWRITE_32((uint8_t *)(p), 0, 28, (v))
#define RDD_HASH_COMMAND_KEY_0_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (r))
#define RDD_HASH_COMMAND_KEY_0_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (v))
#define RDD_HASH_COMMAND_KEY_0_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (r), core_id)
#define RDD_HASH_COMMAND_KEY_0_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(HASH_COMMAND_STRUCT) + 4, (v), core_id)
#define RDD_HASH_COMMAND_KEY_0_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_HASH_COMMAND_KEY_0_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<HASH_COMMAND_STRUCT */


/* >>>PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT */
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_NUMBER	16
typedef union
    {
    uint8_t word_8[52];
    uint16_t word_16[26];
    uint32_t word_32[13];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	pi2_queue_mask[RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_NUMBER];
        uint16_t	timer_value                                                                  	;
        uint8_t	calc_iter                                                                    	;
        uint8_t	target_delay                                                                 	;
        uint16_t	alpha_coeff                                                                  	;
        uint16_t	beta_coeff                                                                   	;
        uint8_t	ticks_per_run                                                                	;
        uint8_t	ticks_left                                                                   	;
        uint8_t	ds_start_iter                                                                	;
        uint8_t	sr_start_iter                                                                	;
        uint16_t	us_aqm_q_table                                                               	;
        uint16_t	ds_aqm_q_table                                                               	;
        uint16_t	sr_aqm_q_table                                                               	;
        uint16_t	reserved1                                                                    	;
#else
        uint16_t	pi2_queue_mask[RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_NUMBER];
        uint8_t	target_delay                                                                 	;
        uint8_t	calc_iter                                                                    	;
        uint16_t	timer_value                                                                  	;
        uint16_t	beta_coeff                                                                   	;
        uint16_t	alpha_coeff                                                                  	;
        uint8_t	sr_start_iter                                                                	;
        uint8_t	ds_start_iter                                                                	;
        uint8_t	ticks_left                                                                   	;
        uint8_t	ticks_per_run                                                                	;
        uint16_t	ds_aqm_q_table                                                               	;
        uint16_t	us_aqm_q_table                                                               	;
        uint16_t	reserved1                                                                    	;
        uint16_t	sr_aqm_q_table                                                               	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT;

#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_READ_G(r, g, idx, i)                             GROUP_MREAD_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT), i, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_READ(r, p, i)                                    MREAD_I_16((uint8_t *)(p), i, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_PI2_QUEUE_MASK_WRITE(v, p, i)                                   MWRITE_I_16((uint8_t *)(p), i, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 32, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 32, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TIMER_VALUE_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 32, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 34, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 34, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_CALC_ITER_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 34, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 35, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 35, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TARGET_DELAY_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 35, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 36, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 36, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_ALPHA_COEFF_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 36, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 38, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 38, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_BETA_COEFF_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 38, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 40, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 40, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_PER_RUN_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 40, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 41, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 41, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_TICKS_LEFT_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 41, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 42, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 42, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_START_ITER_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 42, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 43, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 43, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_START_ITER_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 43, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 44, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 44, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_US_AQM_Q_TABLE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 44, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 46, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 46, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_DS_AQM_Q_TABLE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 46, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (v))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (r), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT) + 48, (v), core_id)
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 48, (r))
#define RDD_PI2_PROBABILITY_CALC_DESCRIPTOR_SR_AQM_Q_TABLE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 48, (v))
/* <<<PI2_PROBABILITY_CALC_DESCRIPTOR_STRUCT */


/* >>>RULE_BASED_RESOLUTION_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	egress_is_cpu       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc       	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	disabled_protocols  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	rule2bridge_resolution	; /* This is a field union */
        uint16_t	reserved4           	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	egress_port_resolved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved1                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	bridge_egress_vport           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint8_t	reserved2                     	; /* Member of rule2bridge_resolution union */
        uint16_t	reservedSU1_reserved4         	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	tc_to_queue                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_to_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	dei_color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	vlan_action                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	forw_mode                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	drop_precedence               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_remark                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	service_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved3                     	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint16_t	reservedSU2_reserved4         	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	disabled_protocols  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0           	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc       	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_is_cpu       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	reserved4           	;
        uint16_t	rule2bridge_resolution	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_reserved4         	;
        uint8_t	reserved2                     	; /* Member of rule2bridge_resolution union */
        uint32_t	bridge_egress_vport           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved1                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	egress_port_resolved          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_reserved4         	;
        uint32_t	reserved3                     	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	service_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_remark                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	drop_precedence               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	forw_mode                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	vlan_action                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	dei_color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_to_queue                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc_to_queue                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_RESOLUTION_STRUCT;

#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 7, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 7, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 4, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 4, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 4, 3, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 4, 3, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 0, 12, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 0, 12, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 0, 12, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT), 0, 12, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 3, 0, 4, (r))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 3, 0, 4, (v))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 3, 0, 4, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 3, 0, 4, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_G(r, g, idx)                              GROUP_MREAD_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, (r))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_G(v, g, idx)                             GROUP_MWRITE_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, (v))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_CORE(r, g, idx, core_id)                  CORE_MREAD_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_CORE(v, g, idx, core_id)                 CORE_MWRITE_16((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ(r, p)                                     MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE(v, p)                                    MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (r))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (v))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_RULE_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_TO_QUEUE_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DEI_COLOR_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_VLAN_ACTION_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_FORW_MODE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_TC_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 3, (r))
#define RDD_RULE_BASED_RESOLUTION_TC_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 3, (v))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 7, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 7, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 7, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_DROP_PRECEDENCE_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 7, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 6, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 6, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_REMARK_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 5, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 5, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_SERVICE_QUEUE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 4, 1, (v))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 4, 1, (r), core_id)
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_RESOLUTION_STRUCT) + 5, 4, 1, (v), core_id)
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_RULE_BASED_RESOLUTION_PBIT_COLOR_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
/* <<<RULE_BASED_RESOLUTION_STRUCT */


/* >>>FLOW_BASED_RESOLUTION_STRUCT */
#define RDD_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER	2
#define RDD_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER	4
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	egress_is_cpu                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc                                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved                                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved0[RDD_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER];
        uint8_t	reserved1[RDD_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER];
#else
        uint8_t	reserved0[RDD_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER];
        uint32_t	egress_cpu_reserved                                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc                                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_is_cpu                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1[RDD_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FLOW_BASED_RESOLUTION_STRUCT;

#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<FLOW_BASED_RESOLUTION_STRUCT */


/* >>>INGRESS_QOS_MAPPING_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) INGRESS_QOS_MAPPING_STRUCT;

#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT), 0, 6, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT), 0, 6, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT), 0, 6, (r), core_id)
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT), 0, 6, (v), core_id)
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 3, 2, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 3, 2, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 3, 2, (r), core_id)
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 3, 2, (v), core_id)
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 3, 2, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 3, 2, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 0, 3, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 0, 3, (v))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 0, 3, (r), core_id)
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(INGRESS_QOS_MAPPING_STRUCT) + 1, 0, 3, (v), core_id)
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 3, (r))
#define RDD_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 3, (v))
/* <<<INGRESS_QOS_MAPPING_STRUCT */


/* >>>COMMON_RESOLUTION_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	loopback                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_redirect_flag                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dma_header_update                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	long_header_write                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_0                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_lan                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	rx_flow                                 	;
        uint8_t	tx_flow                                 	;
        uint8_t	reserved_1                              	;
        uint32_t	ingress_qos_mapping_reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	g9991_egress_vport                      	;
        uint32_t	timestamp                               	;
        uint8_t	lookup_port                             	;
        uint8_t	reserved_2                              	;
        uint8_t	mcast_current_replication               	;
        uint8_t	tunnel_header_length                    	;
#else
        uint8_t	reserved_1                              	;
        uint8_t	tx_flow                                 	;
        uint8_t	rx_flow                                 	;
        uint32_t	is_lan                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_0                              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	long_header_write                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dma_header_update                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_redirect_flag                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	g9991_egress_vport                      	;
        uint32_t	ingress_qos_mapping_ingress_pbit        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_num_of_vlans	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_reserved0           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_ingress_dscp        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_qos_mapping_reserved1           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	timestamp                               	;
        uint8_t	tunnel_header_length                    	;
        uint8_t	mcast_current_replication               	;
        uint8_t	reserved_2                              	;
        uint8_t	lookup_port                             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) COMMON_RESOLUTION_STRUCT;

#define RDD_COMMON_RESOLUTION_LOOPBACK_READ_G(r, g, idx)                                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_COMMON_RESOLUTION_LOOPBACK_WRITE_G(v, g, idx)                                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_COMMON_RESOLUTION_LOOPBACK_READ_CORE(r, g, idx, core_id)                                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 7, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_LOOPBACK_WRITE_CORE(v, g, idx, core_id)                                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 7, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_LOOPBACK_READ(r, p)                                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_COMMON_RESOLUTION_LOOPBACK_WRITE(v, p)                                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 6, 1, (r))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 6, 1, (v))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 6, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 6, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 5, 1, (r))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 5, 1, (v))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 5, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 5, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 4, 1, (r))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 4, 1, (v))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 4, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 4, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_GDX_RX_READ_G(r, g, idx)                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 3, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_GDX_RX_WRITE_G(v, g, idx)                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 3, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 3, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 3, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_IS_GDX_RX_READ(r, p)                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_GDX_RX_WRITE(v, p)                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_LAN_READ_G(r, g, idx)                                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE_G(v, g, idx)                                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_LAN_READ_CORE(r, g, idx, core_id)                                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE_CORE(v, g, idx, core_id)                                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_IS_LAN_READ(r, p)                                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE(v, p)                                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ_G(r, g, idx)                                                                 GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (r))
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE_G(v, g, idx)                                                                GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (v))
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ_CORE(r, g, idx, core_id)                                                     CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE_CORE(v, g, idx, core_id)                                                    CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ(r, p)                                                                        MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE(v, p)                                                                       MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ_G(r, g, idx)                                                                 GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, (r))
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE_G(v, g, idx)                                                                GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, (v))
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ_CORE(r, g, idx, core_id)                                                     CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, (r), core_id)
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE_CORE(v, g, idx, core_id)                                                    CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, (v), core_id)
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ(r, p)                                                                        MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE(v, p)                                                                       MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 6, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 6, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 6, 2, (r), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 6, 2, (v), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 0, 6, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 0, 6, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 0, 6, (r), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 4, 0, 6, (v), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 5, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 5, 3, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 5, 3, (r), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 5, 3, (v), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 3, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 3, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 3, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 3, 2, (r), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 3, 2, (v), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 2, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 2, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 0, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 0, 3, (v))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 0, 3, (r), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, 0, 3, (v), core_id)
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 3, (r))
#define RDD_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 3, (v))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ_G(r, g, idx)                                                      GROUP_MREAD_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (r))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (v))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (r), core_id)
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (v), core_id)
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ(r, p)                                                             MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE(v, p)                                                            MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 8, (r))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 8, (v))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 8, (r), core_id)
#define RDD_COMMON_RESOLUTION_TIMESTAMP_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 8, (v), core_id)
#define RDD_COMMON_RESOLUTION_TIMESTAMP_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_COMMON_RESOLUTION_TIMESTAMP_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ_G(r, g, idx)                                                             GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 12, (r))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 12, (v))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 12, (r), core_id)
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 12, (v), core_id)
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ(r, p)                                                                    MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE(v, p)                                                                   MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 14, (r))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 14, (v))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 14, (r), core_id)
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 14, (v), core_id)
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ_G(r, g, idx)                                                    GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 15, (r))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 15, (v))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 15, (r), core_id)
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 15, (v), core_id)
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ(r, p)                                                           MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE(v, p)                                                          MWRITE_8((uint8_t *)(p) + 15, (v))
/* <<<COMMON_RESOLUTION_STRUCT */


/* >>>PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT */
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_NUMBER	2
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_NUMBER	4
typedef union
    {
    uint8_t word_8[24];
    uint16_t word_16[12];
    uint32_t word_32[6];
    uint64_t dword_64[3];
        struct {
        COMMON_RESOLUTION_STRUCT common_resolution;
        union {
            MCAST_RESOLUTION_STRUCT mcast_resolution;
            RULE_BASED_RESOLUTION_STRUCT rule_based_resolution;
            FLOW_BASED_RESOLUTION_STRUCT flow_based_resolution;
        };
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT;

#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_READ_G(r, g, idx)                                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_WRITE_G(v, g, idx)                                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_READ_CORE(r, g, idx, core_id)                                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_WRITE_CORE(v, g, idx, core_id)                                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_READ(r, p)                                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOPBACK_WRITE(v, p)                                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_CPU_REDIRECT_FLAG_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_DMA_HEADER_UPDATE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LONG_HEADER_WRITE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_GDX_RX_READ_G(r, g, idx)                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_GDX_RX_WRITE_G(v, g, idx)                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_GDX_RX_READ(r, p)                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_GDX_RX_WRITE(v, p)                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ_G(r, g, idx)                                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE_G(v, g, idx)                                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ_CORE(r, g, idx, core_id)                                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 2, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE_CORE(v, g, idx, core_id)                                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 2, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ(r, p)                                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE(v, p)                                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ_G(r, g, idx)                                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE_G(v, g, idx)                                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ_CORE(r, g, idx, core_id)                                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE_CORE(v, g, idx, core_id)                                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ(r, p)                                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE(v, p)                                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ_G(r, g, idx)                                                                 GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE_G(v, g, idx)                                                                GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ_CORE(r, g, idx, core_id)                                                     CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE_CORE(v, g, idx, core_id)                                                    CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ(r, p)                                                                        MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE(v, p)                                                                       MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ_G(r, g, idx)                                                                 GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE_G(v, g, idx)                                                                GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ_CORE(r, g, idx, core_id)                                                     CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE_CORE(v, g, idx, core_id)                                                    CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ(r, p)                                                                        MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE(v, p)                                                                       MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ_G(r, g, idx)                                                              GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ(r, p)                                                                     MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE(v, p)                                                                    MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 2, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 2, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED1_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_DSCP_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_RESERVED0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 3, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 3, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 3, 2, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 3, 2, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 3, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_NUM_OF_VLANS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 3, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 0, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 0, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_INGRESS_QOS_MAPPING_INGRESS_PBIT_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ_G(r, g, idx)                                                      GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_READ(r, p)                                                             MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_G9991_EGRESS_VPORT_WRITE(v, p)                                                            MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TIMESTAMP_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ_G(r, g, idx)                                                             GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ(r, p)                                                                    MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE(v, p)                                                                   MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_READ_G(r, g, idx)                                                              GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_READ(r, p)                                                                     MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_WRITE(v, p)                                                                    MWRITE_8((uint8_t *)(p) + 13, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ_G(r, g, idx)                                                    GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_READ(r, p)                                                           MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TUNNEL_HEADER_LENGTH_WRITE(v, p)                                                          MWRITE_8((uint8_t *)(p) + 15, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 6, 2, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 6, 2, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 0, 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 21, 0, 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 3, 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 3, 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 3, 5, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 3, 5, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 3, 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 3, 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 0, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 23, 0, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, 4, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, 4, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, 4, 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, 4, 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 18, 4, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 18, 4, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 19, 0, 4, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 19, 0, 4, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 19, 0, 4, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 19, 0, 4, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 4, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_DISABLED_PROTOCOLS_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 4, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_G(r, g, idx)                              GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_G(v, g, idx)                             GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_CORE(r, g, idx, core_id)                  CORE_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_CORE(v, g, idx, core_id)                 CORE_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ(r, p)                                     MREAD_16((uint8_t *)(p) + 20, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE(v, p)                                    MWRITE_16((uint8_t *)(p) + 20, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ_G(r, g, idx)                                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE_G(v, g, idx)                                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ_CORE(r, g, idx, core_id)                                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE_CORE(v, g, idx, core_id)                                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ(r, p)                                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE(v, p)                                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ_G(r, g, idx)                                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE_G(v, g, idx)                                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ(r, p)                                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE(v, p)                                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ_G(r, g, idx)                                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE_G(v, g, idx)                                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ_CORE(r, g, idx, core_id)                                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ(r, p)                                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE(v, p)                                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ_G(r, g, idx)                                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE_G(v, g, idx)                                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ_CORE(r, g, idx, core_id)                                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ(r, p)                                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE(v, p)                                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_READ_G(r, g, idx)                                                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_WRITE_G(v, g, idx)                                                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_READ_CORE(r, g, idx, core_id)                                                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_WRITE_CORE(v, g, idx, core_id)                                                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_READ(r, p)                                                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DEI_COLOR_WRITE(v, p)                                                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ_G(r, g, idx)                                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE_G(v, g, idx)                                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ_CORE(r, g, idx, core_id)                                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE_CORE(v, g, idx, core_id)                                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ(r, p)                                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE(v, p)                                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ_G(r, g, idx)                                                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE_G(v, g, idx)                                                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ_CORE(r, g, idx, core_id)                                                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE_CORE(v, g, idx, core_id)                                                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ(r, p)                                                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE(v, p)                                                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ_G(r, g, idx)                                                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE_G(v, g, idx)                                                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ_CORE(r, g, idx, core_id)                                                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE_CORE(v, g, idx, core_id)                                                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ(r, p)                                                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE(v, p)                                                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_READ_G(r, g, idx)                                                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_WRITE_G(v, g, idx)                                                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_READ_CORE(r, g, idx, core_id)                                                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_WRITE_CORE(v, g, idx, core_id)                                                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_READ(r, p)                                                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DROP_PRECEDENCE_WRITE(v, p)                                                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_READ_G(r, g, idx)                                                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_WRITE_G(v, g, idx)                                                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_READ_CORE(r, g, idx, core_id)                                                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 6, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_WRITE_CORE(v, g, idx, core_id)                                                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 6, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_READ(r, p)                                                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_REMARK_WRITE(v, p)                                                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_READ_G(r, g, idx)                                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_WRITE_G(v, g, idx)                                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 5, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_READ(r, p)                                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_SERVICE_QUEUE_WRITE(v, p)                                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_READ_G(r, g, idx)                                                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_WRITE_G(v, g, idx)                                                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_READ_CORE(r, g, idx, core_id)                                                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 4, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_WRITE_CORE(v, g, idx, core_id)                                                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, 4, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_READ(r, p)                                                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_COLOR_WRITE(v, p)                                                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_READ_G(r, g, idx)                                           GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_WRITE_G(v, g, idx)                                          GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 22, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_READ(r, p)                                                  MREAD_16((uint8_t *)(p) + 22, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_RULE_BASED_RESOLUTION_RESERVED4_WRITE(v, p)                                                 MWRITE_16((uint8_t *)(p) + 22, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 4, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 16, 0, 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 16, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 16, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_READ_G(r, g, idx, i)                                        GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_WRITE_G(v, g, idx, i)                                       GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_READ_CORE(r, g, idx, i, core_id)                            CORE_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, i, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_WRITE_CORE(v, g, idx, i, core_id)                           CORE_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 18, i, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_READ(r, p, i)                                               MREAD_I_8((uint8_t *)(p) + 18, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED0_WRITE(v, p, i)                                              MWRITE_I_8((uint8_t *)(p) + 18, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ_G(r, g, idx, i)                                        GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE_G(v, g, idx, i)                                       GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ_CORE(r, g, idx, i, core_id)                            CORE_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, i, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE_CORE(v, g, idx, i, core_id)                           CORE_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 20, i, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ(r, p, i)                                               MREAD_I_8((uint8_t *)(p) + 20, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE(v, p, i)                                              MWRITE_I_8((uint8_t *)(p) + 20, i, (v))
/* <<<PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT */


/* >>>FLOW_BASED_CONTEXT_STRUCT */
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER	64
#define RDD_FLOW_BASED_CONTEXT_RESERVED_NUMBER	48
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER	16
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint8_t flow_cache[64];
        uint8_t reserved[48];
        uint8_t tcam_ip_flow_result[16];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FLOW_BASED_CONTEXT_STRUCT;

#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (r))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (v))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ(r, p, i)                                             MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE(v, p, i)                                            MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (r))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (v))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (r), core_id)
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (v), core_id)
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 112, i, (r))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 112, i, (v))
/* <<<FLOW_BASED_CONTEXT_STRUCT */


/* >>>MC_FLOW_CONTEXT_STRUCT */
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER	128
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint8_t	mc_flow_context[RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) MC_FLOW_CONTEXT_STRUCT;

#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_G(r, g, idx, i)                        GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_G(v, g, idx, i)                       GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_CORE(r, g, idx, i, core_id)            CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)           CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ(r, p, i)                               MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE(v, p, i)                              MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_MASTER_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (r))
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (v))
#define RDD_MC_FLOW_CONTEXT_MASTER_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_MASTER_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<MC_FLOW_CONTEXT_STRUCT */


/* >>>RULE_BASED_CONTEXT_STRUCT */
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_NUMBER	4
#define RDD_RULE_BASED_CONTEXT_RESERVED0_NUMBER	4
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER	64
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_RESERVED1_NUMBER	8
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint8_t tcam_result[16];
        uint8_t tcam_acl_result[16];
        uint8_t bridge_port_vector[4];
        uint8_t reserved0[4];
        uint8_t natc_context[64];
        uint8_t tcam_qos_result[16];
        uint8_t reserved1[8];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_CONTEXT_STRUCT;

#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ(r, p, i)                                           MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE(v, p, i)                                          MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p) + 16, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p) + 16, i, (v))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 32, i, (r))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 32, i, (v))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 32, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 32, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 32, i, (r))
#define RDD_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 32, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_G(r, g, idx, i)                                   GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_G(v, g, idx, i)                                  GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_CORE(r, g, idx, i, core_id)                       CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                      CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ(r, p, i)                                          MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE(v, p, i)                                         MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p) + 104, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p) + 104, i, (v))
/* <<<RULE_BASED_CONTEXT_STRUCT */


/* >>>RULE_BASED_NATC_CONTEXT_STRUCT */
#define RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER	8
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER	52
#define RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER	64
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint32_t	natc_control                                               	;
        uint8_t	reserved0[RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER];
        uint8_t	cmd_list[RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER];
        uint8_t	reserved1[RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_NATC_CONTEXT_STRUCT;

#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (r))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (v))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (r), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (v), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (r))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (v))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (r), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (v), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 12, i, (r))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 12, i, (v))
/* <<<RULE_BASED_NATC_CONTEXT_STRUCT */


/* >>>IPTV_CONTEXT_STRUCT */
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER	32
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint32_t	iptv_context[RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_CONTEXT_STRUCT;

#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ(r, p, i)                                       MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE(v, p, i)                                      MWRITE_I_32((uint8_t *)(p), i, (v))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (r))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (v))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (r), core_id)
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (v), core_id)
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ(r, p, i)                                           MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE(v, p, i)                                          MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<IPTV_CONTEXT_STRUCT */


/* >>>CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT */
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER	64
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_NUMBER	48
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_NUMBER	4
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_NUMBER	4
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER	64
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER	16
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_NUMBER	8
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER	8
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER	52
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER	64
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER	32
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER	128
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        union {
            FLOW_BASED_CONTEXT_STRUCT flow_based_context;
            RULE_BASED_CONTEXT_STRUCT rule_based_context;
            RULE_BASED_NATC_CONTEXT_STRUCT rule_based_natc_context;
            IPTV_CONTEXT_STRUCT iptv_context;
            MC_FLOW_CONTEXT_STRUCT mc_flow_context;
        };
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT;

#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_READ(r, p, i)                                             MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE(v, p, i)                                            MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_READ_G(r, g, idx, i)                                        GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_WRITE_G(v, g, idx, i)                                       GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_READ_CORE(r, g, idx, i, core_id)                            CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_WRITE_CORE(v, g, idx, i, core_id)                           CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_READ(r, p, i)                                               MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_RESERVED_WRITE(v, p, i)                                              MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 112, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 112, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 112, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 112, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 112, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 112, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_READ_G(r, g, idx, i)                                     GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_G(v, g, idx, i)                                    GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_READ_CORE(r, g, idx, i, core_id)                         CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_CORE(v, g, idx, i, core_id)                        CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_READ(r, p, i)                                            MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE(v, p, i)                                           MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 16, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 16, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 16, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 16, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 16, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_ACL_RESULT_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 16, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ_G(r, g, idx, i)                              GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 32, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE_G(v, g, idx, i)                             GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 32, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ_CORE(r, g, idx, i, core_id)                  CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 32, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE_CORE(v, g, idx, i, core_id)                 CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 32, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_READ(r, p, i)                                     MREAD_I_8((uint8_t *)(p) + 32, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_BRIDGE_PORT_VECTOR_WRITE(v, p, i)                                    MWRITE_I_8((uint8_t *)(p) + 32, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_READ_G(r, g, idx, i)                                       GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 36, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_WRITE_G(v, g, idx, i)                                      GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 36, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_READ_CORE(r, g, idx, i, core_id)                           CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 36, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_WRITE_CORE(v, g, idx, i, core_id)                          CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 36, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_READ(r, p, i)                                              MREAD_I_8((uint8_t *)(p) + 36, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED0_WRITE(v, p, i)                                             MWRITE_I_8((uint8_t *)(p) + 36, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 40, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 40, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 40, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 40, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_READ(r, p, i)                                           MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE(v, p, i)                                          MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 104, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 104, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 104, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 104, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 104, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 104, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_READ_G(r, g, idx, i)                                       GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 120, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_WRITE_G(v, g, idx, i)                                      GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 120, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_READ_CORE(r, g, idx, i, core_id)                           CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 120, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_WRITE_CORE(v, g, idx, i, core_id)                          CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 120, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_READ(r, p, i)                                              MREAD_I_8((uint8_t *)(p) + 120, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_CONTEXT_RESERVED1_WRITE(v, p, i)                                             MWRITE_I_8((uint8_t *)(p) + 120, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ(r, p)                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_READ_G(r, g, idx, i)                                  GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 4, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_WRITE_G(v, g, idx, i)                                 GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 4, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_READ_CORE(r, g, idx, i, core_id)                      CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 4, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_WRITE_CORE(v, g, idx, i, core_id)                     CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 4, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_READ(r, p, i)                                         MREAD_I_8((uint8_t *)(p) + 4, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED0_WRITE(v, p, i)                                        MWRITE_I_8((uint8_t *)(p) + 4, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_G(r, g, idx, i)                                   GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 12, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_G(v, g, idx, i)                                  GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 12, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_CORE(r, g, idx, i, core_id)                       CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 12, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_CORE(v, g, idx, i, core_id)                      CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 12, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ(r, p, i)                                          MREAD_I_8((uint8_t *)(p) + 12, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE(v, p, i)                                         MWRITE_I_8((uint8_t *)(p) + 12, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_READ_G(r, g, idx, i)                                  GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_WRITE_G(v, g, idx, i)                                 GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_READ_CORE(r, g, idx, i, core_id)                      CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_WRITE_CORE(v, g, idx, i, core_id)                     CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_READ(r, p, i)                                         MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_RULE_BASED_NATC_CONTEXT_RESERVED1_WRITE(v, p, i)                                        MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_READ_G(r, g, idx, i)                                          GROUP_MREAD_I_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_G(v, g, idx, i)                                         GROUP_MWRITE_I_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_READ_CORE(r, g, idx, i, core_id)                              CORE_MREAD_I_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                             CORE_MWRITE_I_32((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_READ(r, p, i)                                                 MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CONTEXT_IPTV_CONTEXT_WRITE(v, p, i)                                                MWRITE_I_32((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_READ_G(r, g, idx, i)                                                       GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_WRITE_G(v, g, idx, i)                                                      GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_READ_CORE(r, g, idx, i, core_id)                                           CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_WRITE_CORE(v, g, idx, i, core_id)                                          CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_READ(r, p, i)                                                              MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_NATC_COMMAND_WRITE(v, p, i)                                                             MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_READ_G(r, g, idx, i)                                                    GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_WRITE_G(v, g, idx, i)                                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_READ_CORE(r, g, idx, i, core_id)                                        CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_WRITE_CORE(v, g, idx, i, core_id)                                       CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_READ(r, p, i)                                                           MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_VLAN_ACTION_CTX_WRITE(v, p, i)                                                          MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_READ_G(r, g, idx, i)                                                           GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_WRITE_G(v, g, idx, i)                                                          GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_READ_CORE(r, g, idx, i, core_id)                                               CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_WRITE_CORE(v, g, idx, i, core_id)                                              CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_READ(r, p, i)                                                                  MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_IPTV_CTX_WRITE(v, p, i)                                                                 MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ(r, p, i)                                           MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE(v, p, i)                                          MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_READ_G(r, g, idx, i)                                                             GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_WRITE_G(v, g, idx, i)                                                            GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_READ_CORE(r, g, idx, i, core_id)                                                 CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_WRITE_CORE(v, g, idx, i, core_id)                                                CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_READ(r, p, i)                                                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_CLIENT_WRITE(v, p, i)                                                                   MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_READ_G(r, g, idx, i)                                                             GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_WRITE_G(v, g, idx, i)                                                            GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_READ_CORE(r, g, idx, i, core_id)                                                 CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_WRITE_CORE(v, g, idx, i, core_id)                                                CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT) + 64, i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_READ(r, p, i)                                                                    MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_MASTER_WRITE(v, p, i)                                                                   MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_READ_G(r, g, idx, i)                                                         GROUP_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_WRITE_G(v, g, idx, i)                                                        GROUP_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_READ_CORE(r, g, idx, i, core_id)                                             CORE_MREAD_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (r), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_WRITE_CORE(v, g, idx, i, core_id)                                            CORE_MWRITE_I_8((g), (idx)*sizeof(CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT), i, (v), core_id)
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_READ(r, p, i)                                                                MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_CLASSIFICATION_CONTEXTS_LIST_ENTRY_LAYER2_CRC_WRITE(v, p, i)                                                               MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<CLASSIFICATION_CONTEXTS_LIST_ENTRY_STRUCT */


/* >>>FLOW_CACHE_CONTEXT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[60];
    uint16_t word_16[30];
    uint32_t word_32[15];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	natc_control            	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	tos_or_dscp_ecn         	; /* This is a field union */
        uint32_t	actions_vector          	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	dscp_value                        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_or_dscp_ecn union */
        uint32_t	ecn_value                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_or_dscp_ecn union */
        uint32_t	reservedSU1_actions_vector        	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	traffic_class                     	; /* Member of tos_or_dscp_ecn union */
        uint32_t	reservedSU2_actions_vector        	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	egress_vport_union      	; /* This is a field union */
        uint32_t	ucast_or_mcast0         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	cpu_reason              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio_or_metadata_1_1	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_wfd                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ctx_ext              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ucast_or_mcast2         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pathstat_idx                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	qos_mapping_mode                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	egress_vport                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	fwd_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	trap_type                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU1_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU1_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id                        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reserved11                        	; /* Member of egress_vport_union union */
        uint32_t	to_eth                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	tx_flow                           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	fwd_and_trap                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reserved0                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU2_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU2_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wlan_mcast_idx                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
		};
		/* Sub Union 3 */
		struct{
        uint16_t	reservedSU3_egress_vport_union    	;
        uint32_t	is_trap                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reserved1                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	reservedSU3_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_ctx_data_15_14                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU3_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_ucast_or_mcast2       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_tcpspdtest           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	params_union            	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint16_t	nat_port_or_spdtest_stream_id	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_metadata_0_0                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_0_1                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_1_0                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint16_t	nat_port                          	; /* Member of nat_port_or_spdtest_stream_id union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	dhd_wifi_priority                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	dhd_flow_ring_id                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	spdtest_stream_id                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	tcpspdtest_is_upload              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_group_master                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved3                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint8_t	queue                             	; /* Member of params_union union */
        uint16_t	reservedSU3_nat_port_or_spdtest_stream_id	;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_priority                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved4                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	gdx_ctx_data_13_4                 	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint16_t	reservedSU4_nat_port_or_spdtest_stream_id	;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	nat_ip                  	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	gdx_ctx_data_or_metadata	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	service_q_or_tunnel_id  	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_l2_pppoe_passthrough 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ucast                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_flood                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_vid_offset        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_vport        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility_en     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	metadata_1_2                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of gdx_ctx_data_or_metadata union */
        uint32_t	service_queue                     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reservedSU1_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_flood              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_gdx_tx             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	gdx_cdx_data_3_0                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of gdx_ctx_data_or_metadata union */
        uint32_t	tunnel_id                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reserved5                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	reservedSU2_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_flood              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_gdx_tx             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	l2_size_clients_vector  	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	clients_vector                    	; /* Member of l2_size_clients_vector union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	l2_size                           	; /* Member of l2_size_clients_vector union */
        uint8_t	l2_offset                         	; /* Member of l2_size_clients_vector union */
        uint8_t	l2_header                         	; /* Member of l2_size_clients_vector union */
        uint8_t	l2_header_1                       	; /* Member of l2_size_clients_vector union */
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_head_or_is_flood     	; /* This is a field union */
        uint8_t	l2_header_3             	;
        uint16_t	l2_head_or_max_pkt_len  	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	l2_header_2                       	; /* Member of l2_head_or_is_flood union */
        uint8_t	reservedSU1_l2_header_3           	;
        uint16_t	max_pkt_len                       	; /* Member of l2_head_or_max_pkt_len union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	is_routed                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l2_head_or_is_flood union */
        uint32_t	reserved6                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l2_head_or_is_flood union */
        uint8_t	reservedSU2_l2_header_3           	;
        uint8_t	l2_header_4                       	; /* Member of l2_head_or_max_pkt_len union */
        uint8_t	l2_header_5                       	; /* Member of l2_head_or_max_pkt_len union */
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_6             	;
        uint8_t	l2_header_7             	;
        uint8_t	l2_header_8             	;
        uint8_t	l2_header_9             	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_10            	;
        uint8_t	l2_header_11            	;
        uint8_t	l2_header_12            	;
        uint8_t	l2_header_13            	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_14            	;
        uint8_t	l2_header_15            	;
        uint8_t	l2_header_16            	;
        uint8_t	l2_header_17            	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_18            	;
        uint8_t	l2_header_19            	;
        uint8_t	l2_header_20            	;
        uint8_t	l2_header_21            	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_22            	;
        uint8_t	l2_header_23            	;
        uint8_t	l2_header_24            	;
        uint8_t	l2_header_25            	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_26            	;
        uint8_t	l2_header_27            	;
        uint8_t	l2_header_28            	;
        uint8_t	l2_header_29            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	ip_checksum_delta       	;
        uint16_t	l4_checksum_delta       	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	natc_control            	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	actions_vector          	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos_or_dscp_ecn         	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_actions_vector        	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ecn_value                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_or_dscp_ecn union */
        uint32_t	dscp_value                        	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tos_or_dscp_ecn union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_actions_vector        	:24	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	traffic_class                     	; /* Member of tos_or_dscp_ecn union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	ucast_or_mcast2         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_ctx_ext              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_wfd                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio_or_metadata_1_1	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	cpu_reason              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ucast_or_mcast0         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint16_t	egress_vport_union      	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	policer_id                        	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
        uint32_t	reservedSU1_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_prio                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU1_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	trap_type                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	fwd_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	egress_vport                      	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	qos_mapping_mode                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	pathstat_idx                      	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	wlan_mcast_idx                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast2 union */
        uint32_t	reservedSU2_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1                      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU2_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	fwd_and_trap                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	tx_flow                           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint32_t	to_eth                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_vport_union union */
        uint8_t	reserved11                        	; /* Member of egress_vport_union union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_ucast_or_mcast2       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_ctx_ext            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_wfd                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_ctx_data_15_14                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flow_prio_or_metadata_1_1 union */
        uint32_t	reservedSU3_cpu_reason            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint32_t	is_trap                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ucast_or_mcast0 union */
        uint16_t	reservedSU3_egress_vport_union    	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	nat_port_or_spdtest_stream_id	; /* This is a field union */
        uint32_t	params_union            	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_tcpspdtest           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint16_t	nat_port                          	; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	cpu_metadata_1_0                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_0_1                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	cpu_metadata_0_0                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU1_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	tcpspdtest_is_upload              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	spdtest_stream_id                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	reserved                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of nat_port_or_spdtest_stream_id union */
        uint32_t	dhd_flow_ring_id                  	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	dhd_wifi_priority                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved2                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU2_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	reservedSU3_nat_port_or_spdtest_stream_id	;
        uint8_t	queue                             	; /* Member of params_union union */
        uint32_t	reserved3                         	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	is_group_master                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU3_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint16_t	reservedSU4_nat_port_or_spdtest_stream_id	;
        uint32_t	gdx_ctx_data_13_4                 	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reserved4                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	gdx_priority                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of params_union union */
        uint32_t	reservedSU4_is_tcpspdtest         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 4 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	nat_ip                  	;
		};
	};
	/* Union WORD 5 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit_remap_action 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop_eligibility_en     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_vport        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_vid_offset        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_flood                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ucast                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_l2_pppoe_passthrough 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                    	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_q_or_tunnel_id  	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	gdx_ctx_data_or_metadata	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_gdx_tx             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_flood              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue                     	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	metadata_1_2                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of gdx_ctx_data_or_metadata union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_l2_header_number_of_tags	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_gdx_tx             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_inner_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_pbit_remap_action	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop_eligibility_en   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_cpu_vport      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_outer_vid_offset      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_flood              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_ucast              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_l2_pppoe_passthrough	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_ssid                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	tunnel_id                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of service_q_or_tunnel_id union */
        uint32_t	gdx_cdx_data_3_0                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of gdx_ctx_data_or_metadata union */
		};
	};
	/* Union WORD 6 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	l2_size_clients_vector  	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	clients_vector                    	; /* Member of l2_size_clients_vector union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	l2_header_1                       	; /* Member of l2_size_clients_vector union */
        uint8_t	l2_header                         	; /* Member of l2_size_clients_vector union */
        uint8_t	l2_offset                         	; /* Member of l2_size_clients_vector union */
        uint8_t	l2_size                           	; /* Member of l2_size_clients_vector union */
		};
	};
	/* Union WORD 7 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	l2_head_or_max_pkt_len  	; /* This is a field union */
        uint8_t	l2_header_3             	;
        uint8_t	l2_head_or_is_flood     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	max_pkt_len                       	; /* Member of l2_head_or_max_pkt_len union */
        uint8_t	reservedSU1_l2_header_3           	;
        uint8_t	l2_header_2                       	; /* Member of l2_head_or_is_flood union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	l2_header_5                       	; /* Member of l2_head_or_max_pkt_len union */
        uint8_t	l2_header_4                       	; /* Member of l2_head_or_max_pkt_len union */
        uint8_t	reservedSU2_l2_header_3           	;
        uint32_t	reserved6                         	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l2_head_or_is_flood union */
        uint32_t	is_routed                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of l2_head_or_is_flood union */
		};
	};
	/* Union WORD 8 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_9             	;
        uint8_t	l2_header_8             	;
        uint8_t	l2_header_7             	;
        uint8_t	l2_header_6             	;
		};
	};
	/* Union WORD 9 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_13            	;
        uint8_t	l2_header_12            	;
        uint8_t	l2_header_11            	;
        uint8_t	l2_header_10            	;
		};
	};
	/* Union WORD 10 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_17            	;
        uint8_t	l2_header_16            	;
        uint8_t	l2_header_15            	;
        uint8_t	l2_header_14            	;
		};
	};
	/* Union WORD 11 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_21            	;
        uint8_t	l2_header_20            	;
        uint8_t	l2_header_19            	;
        uint8_t	l2_header_18            	;
		};
	};
	/* Union WORD 12 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_25            	;
        uint8_t	l2_header_24            	;
        uint8_t	l2_header_23            	;
        uint8_t	l2_header_22            	;
		};
	};
	/* Union WORD 13 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	l2_header_29            	;
        uint8_t	l2_header_28            	;
        uint8_t	l2_header_27            	;
        uint8_t	l2_header_26            	;
		};
	};
	/* Union WORD 14 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	l4_checksum_delta       	;
        uint16_t	ip_checksum_delta       	;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FLOW_CACHE_CONTEXT_ENTRY_STRUCT;

#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT), (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_READ(r, p)                                                   MREAD_32((uint8_t *)(p), (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NATC_CONTROL_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p), (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TOS_OR_DSCP_ECN_READ_G(r, g, idx)                                         GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TOS_OR_DSCP_ECN_WRITE_G(v, g, idx)                                        GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TOS_OR_DSCP_ECN_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TOS_OR_DSCP_ECN_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TOS_OR_DSCP_ECN_READ(r, p)                                                MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TOS_OR_DSCP_ECN_WRITE(v, p)                                               MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 2, 6, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 2, 6, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DSCP_VALUE_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ECN_VALUE_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAFFIC_CLASS_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAFFIC_CLASS_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAFFIC_CLASS_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAFFIC_CLASS_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAFFIC_CLASS_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAFFIC_CLASS_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 24, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 4, 0, 24, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_READ(r, p)                                                 RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 0, 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_ACTIONS_VECTOR_WRITE(v, p)                                                RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 0, 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_UNION_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 2, 6, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 2, 6, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QOS_MAPPING_MODE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 8, 0, 9, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_READ(r, p)                                                   RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 0, 9, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_VPORT_WRITE(v, p)                                                  RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 0, 9, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_ETH_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_ETH_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_ETH_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_ETH_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_ETH_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TO_ETH_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TX_FLOW_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TX_FLOW_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TX_FLOW_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 0, 7, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TX_FLOW_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 9, 0, 7, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TX_FLOW_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TX_FLOW_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST0_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_ACTION_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_ACTION_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_ACTION_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_ACTION_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_ACTION_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_ACTION_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAP_TYPE_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAP_TYPE_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAP_TYPE_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAP_TYPE_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 6, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAP_TYPE_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TRAP_TYPE_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TRAP_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TRAP_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TRAP_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TRAP_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TRAP_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TRAP_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 3, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 3, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 3, 3, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 3, 3, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 3, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_REASON_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 3, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_READ_G(r, g, idx)                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_WRITE_G(v, g, idx)                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_READ_CORE(r, g, idx, core_id)                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_WRITE_CORE(v, g, idx, core_id)                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_READ(r, p)                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_OR_METADATA_1_1_WRITE(v, p)                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_FLOW_PRIO_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_1_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_1_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_1_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_1_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_1_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_1_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_15_14_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_15_14_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_15_14_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_15_14_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 1, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_15_14_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_15_14_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_WFD_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_CTX_EXT_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_UCAST_OR_MCAST2_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_POLICER_ID_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_WLAN_MCAST_IDX_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_WLAN_MCAST_IDX_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_WLAN_MCAST_IDX_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_WLAN_MCAST_IDX_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 11, 0, 7, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_WLAN_MCAST_IDX_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 7, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_WLAN_MCAST_IDX_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 7, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_TCPSPDTEST_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 15, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 15, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 15, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 15, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_READ(r, p)                                                   RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 0, 15, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_PARAMS_UNION_WRITE(v, p)                                                  RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 0, 15, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_0_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 3, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_0_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 3, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_0_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 3, 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_0_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 3, 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_0_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 3, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_0_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 3, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_1_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_1_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_1_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_1_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_1_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 2, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_0_1_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 2, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_1_0_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_1_0_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_1_0_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_1_0_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_1_0_READ(r, p)                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 0, 10, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CPU_METADATA_1_0_WRITE(v, p)                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 0, 10, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_WIFI_PRIORITY_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_WIFI_PRIORITY_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_WIFI_PRIORITY_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_WIFI_PRIORITY_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 2, 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_WIFI_PRIORITY_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 2, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_WIFI_PRIORITY_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 2, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_FLOW_RING_ID_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_FLOW_RING_ID_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_FLOW_RING_ID_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_FLOW_RING_ID_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_FLOW_RING_ID_READ(r, p)                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 0, 10, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DHD_FLOW_RING_ID_WRITE(v, p)                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 0, 10, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GROUP_MASTER_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GROUP_MASTER_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GROUP_MASTER_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GROUP_MASTER_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GROUP_MASTER_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GROUP_MASTER_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QUEUE_READ_G(r, g, idx)                                                   GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 13, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QUEUE_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 13, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QUEUE_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 13, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QUEUE_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 13, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QUEUE_READ(r, p)                                                          MREAD_8((uint8_t *)(p) + 13, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_QUEUE_WRITE(v, p)                                                         MWRITE_8((uint8_t *)(p) + 13, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_PRIORITY_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_PRIORITY_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_PRIORITY_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_PRIORITY_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_PRIORITY_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_PRIORITY_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_13_4_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_13_4_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_13_4_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_13_4_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 12, 0, 10, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_13_4_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 0, 10, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_13_4_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 0, 10, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                           GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                          GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)               CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)              CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_READ(r, p)                                  MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_OR_SPDTEST_STREAM_ID_WRITE(v, p)                                 MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_READ_G(r, g, idx)                                                GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_WRITE_G(v, g, idx)                                               GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_READ(r, p)                                                       MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_PORT_WRITE(v, p)                                                      MWRITE_16((uint8_t *)(p) + 14, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SPDTEST_STREAM_ID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 1, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 1, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 1, 3, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 1, 3, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SPDTEST_STREAM_ID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 1, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SPDTEST_STREAM_ID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 1, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 0, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 15, 0, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_NAT_IP_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_OR_METADATA_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_OR_METADATA_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_OR_METADATA_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_OR_METADATA_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_OR_METADATA_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 20, 4, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CTX_DATA_OR_METADATA_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 20, 4, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 20, 4, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_METADATA_1_2_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 20, 4, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CDX_DATA_3_0_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CDX_DATA_3_0_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CDX_DATA_3_0_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CDX_DATA_3_0_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 4, 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CDX_DATA_3_0_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 20, 4, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_GDX_CDX_DATA_3_0_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 20, 4, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_READ(r, p)                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 20, 7, 5, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_Q_OR_TUNNEL_ID_WRITE(v, p)                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 20, 7, 5, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 7, 5, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 20, 7, 5, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 20, 7, 5, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TUNNEL_ID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 2, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TUNNEL_ID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 2, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TUNNEL_ID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 2, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TUNNEL_ID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 20, 2, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TUNNEL_ID_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 20, 2, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TUNNEL_ID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 20, 2, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SSID_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 3, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SSID_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 3, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SSID_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 3, 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SSID_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 3, 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SSID_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 3, 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_SSID_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 3, 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 2, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 2, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 2, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 2, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 2, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_L2_PPPOE_PASSTHROUGH_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 2, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 1, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 1, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 1, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 1, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 1, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_UCAST_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 1, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_FLOOD_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_FLOOD_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_FLOOD_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 0, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_FLOOD_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 21, 0, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_FLOOD_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 21, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_FLOOD_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 21, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 5, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 5, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 5, 3, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 5, 3, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 22, 5, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_VID_OFFSET_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 22, 5, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 4, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 4, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 4, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 4, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 22, 4, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_EGRESS_CPU_VPORT_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 22, 4, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TC_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 1, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TC_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 1, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TC_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 1, 3, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TC_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 1, 3, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TC_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 22, 1, 3, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_TC_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 22, 1, 3, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 0, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 22, 0, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 22, 0, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_EN_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 22, 0, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_DROP_ELIGIBILITY_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 5, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 5, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 5, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 5, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 5, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_OUTER_PBIT_REMAP_ACTION_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 5, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 3, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 3, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 3, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 3, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 3, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_INNER_PBIT_REMAP_ACTION_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 3, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GDX_TX_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 2, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GDX_TX_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 2, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GDX_TX_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 2, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GDX_TX_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 2, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GDX_TX_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 2, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_GDX_TX_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 2, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 0, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 0, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 0, 2, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 23, 0, 2, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 23, 0, 2, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_NUMBER_OF_TAGS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 23, 0, 2, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_CLIENTS_VECTOR_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_CLIENTS_VECTOR_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_CLIENTS_VECTOR_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_CLIENTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_CLIENTS_VECTOR_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_CLIENTS_VECTOR_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CLIENTS_VECTOR_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CLIENTS_VECTOR_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CLIENTS_VECTOR_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_READ_G(r, g, idx)                                                 GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_WRITE_G(v, g, idx)                                                GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_READ(r, p)                                                        MREAD_8((uint8_t *)(p) + 24, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_SIZE_WRITE(v, p)                                                       MWRITE_8((uint8_t *)(p) + 24, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 25, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 25, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 25, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 25, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 25, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_OFFSET_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 25, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 26, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 26, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 26, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 26, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 26, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 26, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 27, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 27, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 27, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 27, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 27, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_1_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 27, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_IS_FLOOD_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_IS_FLOOD_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_IS_FLOOD_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_IS_FLOOD_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_IS_FLOOD_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 28, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_IS_FLOOD_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 28, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 28, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_2_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 28, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, 7, 1, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 28, 7, 1, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 28, 7, 1, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IS_ROUTED_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 28, 7, 1, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 29, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 29, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 29, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 29, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 29, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_3_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 29, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_MAX_PKT_LEN_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_MAX_PKT_LEN_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_MAX_PKT_LEN_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_MAX_PKT_LEN_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_MAX_PKT_LEN_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEAD_OR_MAX_PKT_LEN_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_READ_G(r, g, idx)                                             GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE_G(v, g, idx)                                            GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_READ(r, p)                                                    MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE(v, p)                                                   MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 30, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 30, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_4_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 30, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 31, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 31, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 31, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 31, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 31, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_5_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 31, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 32, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 32, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 32, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 32, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 32, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_6_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 32, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 33, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 33, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 33, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 33, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 33, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_7_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 33, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 34, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 34, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 34, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 34, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 34, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_8_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 34, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_READ_G(r, g, idx)                                             GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 35, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_WRITE_G(v, g, idx)                                            GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 35, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 35, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 35, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_READ(r, p)                                                    MREAD_8((uint8_t *)(p) + 35, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_9_WRITE(v, p)                                                   MWRITE_8((uint8_t *)(p) + 35, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 36, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 36, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 36, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 36, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 36, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_10_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 36, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 37, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 37, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 37, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 37, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 37, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_11_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 37, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 38, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 38, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 38, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 38, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 38, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_12_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 38, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 39, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 39, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 39, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 39, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 39, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_13_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 39, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 40, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 40, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 40, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 40, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 40, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_14_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 40, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 41, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 41, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 41, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 41, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 41, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_15_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 41, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 42, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 42, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 42, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 42, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 42, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_16_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 42, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 43, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 43, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 43, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 43, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 43, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_17_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 43, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 44, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 44, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 44, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 44, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 44, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_18_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 44, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 45, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 45, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 45, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 45, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 45, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_19_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 45, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 46, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 46, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 46, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 46, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 46, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_20_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 46, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 47, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 47, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 47, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 47, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 47, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_21_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 47, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 48, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 48, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 48, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 48, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 48, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_22_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 48, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 49, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 49, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 49, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 49, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 49, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_23_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 49, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 50, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 50, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 50, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 50, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 50, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_24_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 50, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 51, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 51, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 51, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 51, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 51, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_25_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 51, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 52, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 52, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 52, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 52, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 52, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_26_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 52, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 53, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 53, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 53, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 53, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 53, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_27_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 53, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 54, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 54, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 54, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 54, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 54, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_28_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 54, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 55, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 55, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 55, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 55, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 55, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L2_HEADER_29_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 55, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 56, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 56, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 56, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 56, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 56, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_IP_CHECKSUM_DELTA_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 56, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 58, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 58, (v))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 58, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_ENTRY_STRUCT) + 58, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 58, (r))
#define RDD_FLOW_CACHE_CONTEXT_ENTRY_L4_CHECKSUM_DELTA_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 58, (v))
/* <<<FLOW_CACHE_CONTEXT_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT */
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_RESERVED6_NUMBER	4
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_NUMBER	2
typedef union
    {
    uint8_t word_8[40];
    uint16_t word_16[20];
    uint32_t word_32[10];
    uint64_t dword_64[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0                                                                	;
        uint32_t	reserved1                                                                	;
        uint32_t	reserved2                                                                	;
        uint32_t	reserved3                                                                	;
        uint32_t	reserved4                                                                	;
        uint32_t	reserved5                                                                	;
        uint8_t	reserved6[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_RESERVED6_NUMBER];
        uint32_t	clients_vector[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_NUMBER];
        uint32_t	fwd_and_trap                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved7                                                                	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved0                                                                	;
        uint32_t	reserved1                                                                	;
        uint32_t	reserved2                                                                	;
        uint32_t	reserved3                                                                	;
        uint32_t	reserved4                                                                	;
        uint32_t	reserved5                                                                	;
        uint8_t	reserved6[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_RESERVED6_NUMBER];
        uint32_t	clients_vector[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_NUMBER];
        uint32_t	reserved7                                                                	:30	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fwd_and_trap                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_READ_G(r, g, idx, i)                             GROUP_MREAD_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 28, i, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 28, i, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 28, i, (r), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 28, i, (v), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_READ(r, p, i)                                    MREAD_I_32((uint8_t *)(p) + 28, i, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE(v, p, i)                                   MWRITE_I_32((uint8_t *)(p) + 28, i, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 7, 1, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 7, 1, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 36, 7, 1, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 36, 7, 1, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_IS_ROUTED_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 6, 1, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_IS_ROUTED_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 6, 1, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_IS_ROUTED_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 6, 1, (r), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_IS_ROUTED_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 36, 6, 1, (v), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_IS_ROUTED_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 36, 6, 1, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_IS_ROUTED_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 36, 6, 1, (v))
/* <<<FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT */


/* >>>FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT */
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_NUMBER	52
typedef union
    {
    uint8_t word_8[60];
    uint16_t word_16[30];
    uint32_t word_32[15];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	natc_control                                                	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	flags                                                       	;
        uint8_t	data_length                                                 	;
        uint16_t	optional_data                                               	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_flags                                                     	;
        uint8_t	reservedSU1_data_length                                               	;
        uint16_t	mapt_l4_csum                                                          	; /* Member of optional_data union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	data[RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_NUMBER];
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	natc_control                                                	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	optional_data                                               	; /* This is a field union */
        uint8_t	data_length                                                 	;
        uint8_t	flags                                                       	;
		};
		/* Sub Union 1 */
		struct{
        uint16_t	mapt_l4_csum                                                          	; /* Member of optional_data union */
        uint8_t	reservedSU1_data_length                                               	;
        uint8_t	reservedSU1_flags                                                     	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	data[RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_NUMBER];
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT;

#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_NATC_CONTROL_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT), (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_NATC_CONTROL_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT), (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT), (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT), (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_NATC_CONTROL_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_NATC_CONTROL_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_FLAGS_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_FLAGS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_FLAGS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_FLAGS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_FLAGS_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_FLAGS_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_LENGTH_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 5, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_LENGTH_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 5, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_LENGTH_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 5, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_LENGTH_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 5, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_LENGTH_READ(r, p)                                        MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_LENGTH_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_OPTIONAL_DATA_READ_G(r, g, idx)                               GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_OPTIONAL_DATA_WRITE_G(v, g, idx)                              GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_OPTIONAL_DATA_READ_CORE(r, g, idx, core_id)                   CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_OPTIONAL_DATA_WRITE_CORE(v, g, idx, core_id)                  CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_OPTIONAL_DATA_READ(r, p)                                      MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_OPTIONAL_DATA_WRITE(v, p)                                     MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_MAPT_L4_CSUM_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_MAPT_L4_CSUM_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_MAPT_L4_CSUM_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_MAPT_L4_CSUM_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_MAPT_L4_CSUM_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_MAPT_L4_CSUM_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_READ_G(r, g, idx, i)                                     GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 8, i, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_WRITE_G(v, g, idx, i)                                    GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 8, i, (v))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_READ_CORE(r, g, idx, i, core_id)                         CORE_MREAD_I_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 8, i, (r), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_WRITE_CORE(v, g, idx, i, core_id)                        CORE_MWRITE_I_8((g), (idx)*sizeof(FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT) + 8, i, (v), core_id)
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_READ(r, p, i)                                            MREAD_I_8((uint8_t *)(p) + 8, i, (r))
#define RDD_FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_DATA_WRITE(v, p, i)                                           MWRITE_I_8((uint8_t *)(p) + 8, i, (v))
/* <<<FLOW_CACHE_CONTEXT_EXTENSION_ENTRY_STRUCT */


/* >>>CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	df        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	reserved  	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	df        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT;

#define RDD_CONTEXT_EXTENSION_FLAGS_ENTRY_DF_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT), 7, 1, (r))
#define RDD_CONTEXT_EXTENSION_FLAGS_ENTRY_DF_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT), 7, 1, (v))
#define RDD_CONTEXT_EXTENSION_FLAGS_ENTRY_DF_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_CONTEXT_EXTENSION_FLAGS_ENTRY_DF_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_CONTEXT_EXTENSION_FLAGS_ENTRY_DF_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_CONTEXT_EXTENSION_FLAGS_ENTRY_DF_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
/* <<<CONTEXT_EXTENSION_FLAGS_ENTRY_STRUCT */


/* >>>RULE_BASED_CONTEXT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pbit_to_gem              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc_to_q                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dei_color                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	no_fwd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_value               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd_action            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_based_forward       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	skip                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_disable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_not_flood_path        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_enable           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	queue_union              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dei_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU1_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_skip                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_bytes_cntr_disable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_not_flood_path      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved1              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	queue                              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dei_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_common_actions_exit           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU2_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_skip                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_bytes_cntr_disable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_not_flood_path      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved1              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	tc                                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dei_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_skip                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_bytes_cntr_disable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_not_flood_path      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reserved1              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	trap_reason                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved4                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gem_mapping_table        	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	to_eth                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	rule                     	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	cntr_id                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	include_mcast            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_disable             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_mode       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ttl                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	qos_rule_wan_flow_overrun	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	opbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ipbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	service_queue            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved6                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tunnel_enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tunnel_id                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_id            	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	queue_union              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	policer_enable           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_not_flood_path        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bytes_cntr_disable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	skip                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_based_forward       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd_action            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_value               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	dei_color                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc_to_q                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_to_gem              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	queue                              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reservedSU1_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved1              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_not_flood_path      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_bytes_cntr_disable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_skip                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU1_dei_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	tc                                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reserved2                          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reservedSU2_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved1              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_not_flood_path      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_bytes_cntr_disable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_skip                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_common_actions_exit           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU2_dei_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	trap_reason                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reserved3                          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reservedSU3_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reserved1              	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_is_not_flood_path      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_bytes_cntr_disable     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_skip                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dei_color              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	rule                     	;
        uint32_t	flow                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	to_eth                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gem_mapping_table        	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	inner_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ipbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	opbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	qos_rule_wan_flow_overrun	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ttl                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_mode       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_disable             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	include_mcast            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bytes_cntr_id            	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tunnel_id                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tunnel_enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved6                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_CONTEXT_ENTRY_STRUCT;

#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_COLOR_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_COLOR_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_COLOR_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_COLOR_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_COLOR_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_COLOR_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_READ_G(r, g, idx)                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_WRITE_G(v, g, idx)                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_READ_CORE(r, g, idx, core_id)           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_WRITE_CORE(v, g, idx, core_id)          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_READ(r, p)                              RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_WRITE(v, p)                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SKIP_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SKIP_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SKIP_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SKIP_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SKIP_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SKIP_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_DISABLE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_DISABLE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_DISABLE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 6, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_DISABLE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 6, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_DISABLE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_DISABLE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IS_NOT_FLOOD_PATH_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IS_NOT_FLOOD_PATH_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IS_NOT_FLOOD_PATH_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IS_NOT_FLOOD_PATH_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IS_NOT_FLOOD_PATH_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IS_NOT_FLOOD_PATH_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_COLOR_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_COLOR_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_COLOR_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_COLOR_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_COLOR_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_COLOR_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 1, 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 1, 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 1, 5, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 1, 5, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 1, 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 1, 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 0, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 0, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 0, 7, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, 0, 7, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_READ_G(r, g, idx)                                                     GROUP_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_READ(r, p)                                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_WRITE(v, p)                                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_READ(r, p)                                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 5, 11, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_WRITE(v, p)                                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 5, 11, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INCLUDE_MCAST_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INCLUDE_MCAST_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INCLUDE_MCAST_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_INCLUDE_MCAST_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_INCLUDE_MCAST_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INCLUDE_MCAST_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_LOOPBACK_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_LOOPBACK_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_LOOPBACK_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_LOOPBACK_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_LOOPBACK_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_LOOPBACK_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TTL_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TTL_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TTL_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TTL_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TTL_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TTL_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 3, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 3, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 3, 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 3, 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PORT_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 4, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PORT_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 4, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PORT_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 4, 7, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PORT_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 4, 7, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PORT_READ(r, p)                                                            RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 4, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PORT_WRITE(v, p)                                                           RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 4, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ENABLE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ENABLE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ENABLE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ENABLE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ENABLE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ENABLE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ID_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 3, 4, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ID_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 3, 4, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ID_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 3, 4, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ID_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 3, 4, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ID_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 14, 3, 4, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TUNNEL_ID_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 14, 3, 4, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_ID_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 0, 11, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_ID_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 0, 11, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_ID_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 0, 11, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 14, 0, 11, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_ID_READ(r, p)                                                   RDP_FIELD_MREAD_16((uint8_t *)(p) + 14, 0, 11, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_BYTES_CNTR_ID_WRITE(v, p)                                                  RDP_FIELD_MWRITE_16((uint8_t *)(p) + 14, 0, 11, (v))
/* <<<RULE_BASED_CONTEXT_ENTRY_STRUCT */


/* >>>CPU_TX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_data1           	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	abs_data0           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	bn1_or_abs2_or_1588 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	ssid                          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	fpm_fallback                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	sbpm_copy                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	bn1_first                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	flow_or_port_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	_ssid                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_fpm_fallback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_sbpm_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	abs2                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buffer_number_0_or_abs_0	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop                           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn0_first                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs1                          	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	abs0                          	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	abs_data1           	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_data0           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_or_abs2_or_1588 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	sbpm_copy                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	fpm_fallback                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	ssid                          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	wan_flow_source_port          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs2                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_sbpm_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_fpm_fallback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_ssid                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	flow_or_port_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	is_vport                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0_or_abs_0	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn0_first                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop                           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs0                          	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	abs1                          	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_CPU_TX_DESCRIPTOR_VALID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_VALID_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_VALID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 0, 22, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 0, 22, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_CPU_TX_DESCRIPTOR_DROP_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_DROP_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DROP_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DROP_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DROP_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_LAN_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_LAN_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_LAN_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_LAN_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_G(r, g, idx)                          GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_G(v, g, idx)                         GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_CORE(r, g, idx, core_id)              CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_CORE(v, g, idx, core_id)             CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ(r, p)                                 RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE(v, p)                                RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_CPU_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_IS_VPORT_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r))
#define RDD_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v))
#define RDD_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ(r, p)                                            RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 7, (r))
#define RDD_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE(v, p)                                           RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 7, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_READ(r, p)                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_WRITE(v, p)                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                                       RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                                      RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR__SSID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR__SSID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR__SSID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SSID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SSID_READ(r, p)                                                      RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR__SSID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS2_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS2_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_G(r, g, idx)                             GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_G(v, g, idx)                            GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_CORE(r, g, idx, core_id)                 CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_CORE(v, g, idx, core_id)                CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ(r, p)                                    RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE(v, p)                                   RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_SOP_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_SOP_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SOP_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SOP_READ(r, p)                                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_SOP_WRITE(v, p)                                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS1_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS1_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_G(r, g, idx)                            GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_G(v, g, idx)                           GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_CORE(r, g, idx, core_id)                CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_CORE(v, g, idx, core_id)               CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ(r, p)                                   RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE(v, p)                                  RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS0_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS0_READ(r, p)                                                       RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_WRITE(v, p)                                                      RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
/* <<<CPU_TX_DESCRIPTOR_STRUCT */


/* >>>TC_TO_QUEUE_8_STRUCT */
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_NUMBER	8
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint8_t queue_offset[8];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TC_TO_QUEUE_8_STRUCT;

#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (r))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (v))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (r), core_id)
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (v), core_id)
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<TC_TO_QUEUE_8_STRUCT */


/* >>>TC_TO_QUEUE_32_STRUCT */
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_NUMBER	32
typedef union
    {
    uint8_t word_8[32];
    uint16_t word_16[16];
    uint32_t word_32[8];
    uint64_t dword_64[4];
        struct {
        uint8_t queue_offset[32];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TC_TO_QUEUE_32_STRUCT;

#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (r))
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (v))
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (r), core_id)
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (v), core_id)
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<TC_TO_QUEUE_32_STRUCT */


/* >>>PBIT_TO_QUEUE_8_STRUCT */
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_NUMBER	8
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint8_t queue_offset[8];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PBIT_TO_QUEUE_8_STRUCT;

#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(PBIT_TO_QUEUE_8_STRUCT), i, (r))
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(PBIT_TO_QUEUE_8_STRUCT), i, (v))
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(PBIT_TO_QUEUE_8_STRUCT), i, (r), core_id)
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(PBIT_TO_QUEUE_8_STRUCT), i, (v), core_id)
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_PBIT_TO_QUEUE_8_QUEUE_OFFSET_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<PBIT_TO_QUEUE_8_STRUCT */


/* >>>VPORT_CFG_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	congestion_flow_control              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	discard_prty                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_control                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_en                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_isolation_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_miss_action                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	da_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	reserved1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bridge_id                            	;
        uint32_t	bridge_and_vlan_ingress_lookup_method	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
        uint32_t	bridge_and_vlan_egress_lookup_method 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
        uint32_t	anti_spoofing_bypass                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_default_vid_set                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	protocol_filters_dis                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_map                 	;
#else
        uint32_t	protocol_filters_dis                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_default_vid_set                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	anti_spoofing_bypass                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_and_vlan_egress_lookup_method 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
        uint32_t	bridge_and_vlan_ingress_lookup_method	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
        uint8_t	bridge_id                            	;
        uint32_t	reserved1                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	sa_lookup_miss_action                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	da_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_isolation_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_en                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_control                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	discard_prty                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	congestion_flow_control              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_map                 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) VPORT_CFG_ENTRY_STRUCT;

#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_FLOW_CONTROL_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (r))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (r), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 5, 3, (v), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 3, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 3, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 3, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 3, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 3, 2, (r), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 3, 2, (v), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 3, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 3, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_READ_G(r, g, idx)                                                            GROUP_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_READ(r, p)                                                                   MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_ID_WRITE(v, p)                                                                  MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (r), core_id) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (v), core_id) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 6, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 6, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 6, 1, (r), core_id) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 6, 1, (v), core_id) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_ANTI_SPOOFING_BYPASS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 4, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 4, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_IS_DEFAULT_VID_SET_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 4, (r))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 4, (v))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 4, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 4, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<VPORT_CFG_ENTRY_STRUCT */


/* >>>VPORT_CFG_EX_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	loopback_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_mac_addr_idx     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	emac_idx              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	prop_tag_enable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_unknown_da 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_broadcast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_multicast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_all_traffic	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_dbg_stat_en      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_idx           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	policer_idx           	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_dbg_stat_en      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_all_traffic	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_multicast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_broadcast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rate_limit_unknown_da 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	viq                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	prop_tag_enable       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	emac_idx              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	port_mac_addr_idx     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback_en           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) VPORT_CFG_EX_ENTRY_STRUCT;

#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_LOOPBACK_EN_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 6, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 6, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_MIRRORING_EN_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 0, 6, (r))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 0, 6, (v))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 0, 6, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT), 0, 6, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 6, (r))
#define RDD_VPORT_CFG_EX_ENTRY_INGRESS_FILTER_PROFILE_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 6, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 5, 3, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 5, 3, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_MAC_ADDR_IDX_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 2, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 2, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 2, 3, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 2, 3, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_EMAC_IDX_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PROP_TAG_ENABLE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 1, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PROP_TAG_ENABLE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 1, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PROP_TAG_ENABLE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 1, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_PROP_TAG_ENABLE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 1, 1, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_PROP_TAG_ENABLE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 1, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PROP_TAG_ENABLE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 1, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 5, 3, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 5, 3, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 3, (r))
#define RDD_VPORT_CFG_EX_ENTRY_VIQ_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 3, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 4, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 4, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 4, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 4, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_UNKNOWN_DA_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 3, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 3, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 3, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 3, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 3, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_BROADCAST_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 3, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 2, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 2, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 2, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 2, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 2, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_MULTICAST_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 2, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 1, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 1, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 1, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 2, 1, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_RATE_LIMIT_ALL_TRAFFIC_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 7, 1, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 7, 1, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r))
#define RDD_VPORT_CFG_EX_ENTRY_PORT_DBG_STAT_EN_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 0, 7, (r))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 0, 7, (v))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 0, 7, (r), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_EX_ENTRY_STRUCT) + 3, 0, 7, (v), core_id)
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 7, (r))
#define RDD_VPORT_CFG_EX_ENTRY_POLICER_IDX_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 7, (v))
/* <<<VPORT_CFG_EX_ENTRY_STRUCT */


/* >>>VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
        uint8_t	rl_overhead	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT;

#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (r))
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (v))
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (r), core_id)
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (v), core_id)
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
/* <<<VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT */


/* >>>DDR_TOKEN_INFO_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	is_xpm_valid 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bufmng_cnt_id	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pool_id      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	pool_id      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bufmng_cnt_id	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	is_xpm_valid 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } DDR_TOKEN_INFO_ENTRY_STRUCT;

#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (r), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (v), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 5, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 5, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (r), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (v), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 2, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 2, (v))
/* <<<DDR_TOKEN_INFO_ENTRY_STRUCT */


/* >>>TX_EXCEPTION_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	reserved1   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dbg_stat_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	vlan_cntr_en	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	vlan_cntr_en	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	dbg_stat_en 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved1   	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } TX_EXCEPTION_ENTRY_STRUCT;

#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (r), core_id)
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 1, 1, (v), core_id)
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_DBG_STAT_EN_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (v))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (r), core_id)
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TX_EXCEPTION_ENTRY_STRUCT), 0, 1, (v), core_id)
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_TX_EXCEPTION_ENTRY_VLAN_CNTR_EN_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
/* <<<TX_EXCEPTION_ENTRY_STRUCT */


/* >>>FLUSH_CFG_ENABLE_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	enable_fw 	;
        uint8_t	enable_cpu	;
#else
        uint8_t	enable_cpu	;
        uint8_t	enable_fw 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) FLUSH_CFG_ENABLE_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (r), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (v), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ(r, p)                                        MREAD_8((uint8_t *)(p), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<FLUSH_CFG_ENABLE_ENTRY_STRUCT */


/* >>>FLUSH_CFG_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pd_num            	;
        uint8_t	flush_aggr        	;
        uint8_t	qm_queue          	;
        uint32_t	ug_counter_address	;
        uint32_t	ug_threshold_low  	;
        uint32_t	ug_counter        	;
#else
        uint8_t	qm_queue          	;
        uint8_t	flush_aggr        	;
        uint8_t	pd_num            	;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ug_counter_address	;
        uint32_t	ug_threshold_low  	;
        uint32_t	ug_counter        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FLUSH_CFG_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<FLUSH_CFG_ENTRY_STRUCT */


/* >>>EMAC_FLOW_CTRL_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
        uint32_t	rate          	;
        uint32_t	max_burst_size	;
        uint32_t	threshold     	;
        uint32_t	reserved      	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) EMAC_FLOW_CTRL_ENTRY_STRUCT;

#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT), (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT), (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT), (r), core_id)
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT), (v), core_id)
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_READ(r, p)                                                 MREAD_32((uint8_t *)(p), (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_RATE_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p), (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 4, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 4, (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_MAX_BURST_SIZE_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 8, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 8, (v))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_EMAC_FLOW_CTRL_ENTRY_THRESHOLD_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 8, (v))
/* <<<EMAC_FLOW_CTRL_ENTRY_STRUCT */


/* >>>EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
        uint32_t	budget    	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT;

#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT), (r))
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT), (v))
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT), (r), core_id)
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT), (v), core_id)
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_EMAC_FLOW_CTRL_BUDGET_ENTRY_BUDGET_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
/* <<<EMAC_FLOW_CTRL_BUDGET_ENTRY_STRUCT */


/* >>>CBS_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
        uint32_t	committed_burst_size	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) CBS_ENTRY_STRUCT;

#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(CBS_ENTRY_STRUCT), (r))
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(CBS_ENTRY_STRUCT), (v))
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(CBS_ENTRY_STRUCT), (r), core_id)
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(CBS_ENTRY_STRUCT), (v), core_id)
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_CBS_ENTRY_COMMITTED_BURST_SIZE_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
/* <<<CBS_ENTRY_STRUCT */


/* >>>FW_POLICER_BUDGET_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	budget_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	budget_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	budget_exponent	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	budget_mantissa	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) FW_POLICER_BUDGET_ENTRY_STRUCT;

#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT), 2, 14, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT), 2, 14, (v))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT), 2, 14, (r), core_id)
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT), 2, 14, (v), core_id)
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 2, 14, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_MANTISSA_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 2, 14, (v))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT) + 1, 0, 2, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT) + 1, 0, 2, (v))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT) + 1, 0, 2, (r), core_id)
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FW_POLICER_BUDGET_ENTRY_STRUCT) + 1, 0, 2, (v), core_id)
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r))
#define RDD_FW_POLICER_BUDGET_ENTRY_BUDGET_EXPONENT_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v))
/* <<<FW_POLICER_BUDGET_ENTRY_STRUCT */


/* >>>FPM_GLOBAL_CFG_STRUCT */
typedef union
    {
    uint8_t word_8[20];
    uint16_t word_16[10];
    uint32_t word_32[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint16_t	fpm_token_size     	;
        uint8_t	fpm_token_shift    	;
        uint8_t	fpm_token_add_shift	;
        uint16_t	fpm_token_inv_mant 	;
        uint8_t	fpm_token_inv_exp  	;
        uint8_t	reserved1          	;
        uint8_t	fpm_token_num_pool0	;
        uint8_t	fpm_token_num_pool1	;
        uint8_t	fpm_token_num_pool2	;
        uint8_t	fpm_token_num_pool3	;
#else
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint8_t	fpm_token_add_shift	;
        uint8_t	fpm_token_shift    	;
        uint16_t	fpm_token_size     	;
        uint8_t	reserved1          	;
        uint8_t	fpm_token_inv_exp  	;
        uint16_t	fpm_token_inv_mant 	;
        uint8_t	fpm_token_num_pool3	;
        uint8_t	fpm_token_num_pool2	;
        uint8_t	fpm_token_num_pool1	;
        uint8_t	fpm_token_num_pool0	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FPM_GLOBAL_CFG_STRUCT;

#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ(r, p)                                              MREAD_32((uint8_t *)(p), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 16, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 16, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 17, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 17, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 18, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 19, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 19, (v))
/* <<<FPM_GLOBAL_CFG_STRUCT */


/* >>>DEFAULT_VLAN_VID_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	reserved   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	default_vid	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	default_vid	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) DEFAULT_VLAN_VID_ENTRY_STRUCT;

#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(DEFAULT_VLAN_VID_ENTRY_STRUCT), 0, 12, (r))
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(DEFAULT_VLAN_VID_ENTRY_STRUCT), 0, 12, (v))
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(DEFAULT_VLAN_VID_ENTRY_STRUCT), 0, 12, (r), core_id)
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(DEFAULT_VLAN_VID_ENTRY_STRUCT), 0, 12, (v), core_id)
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_DEFAULT_VLAN_VID_ENTRY_DEFAULT_VID_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<DEFAULT_VLAN_VID_ENTRY_STRUCT */


/* >>>PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	is_mcast              	;
        uint16_t	clients_size_in_word  	;
        uint16_t	exception_drop_cntr_id	;
        uint16_t	flow_miss_drop_cntr_id	;
        uint32_t	reg_bck_up_0          	;
        uint32_t	reg_bck_up_1          	;
#else
        uint16_t	clients_size_in_word  	;
        uint16_t	is_mcast              	;
        uint16_t	flow_miss_drop_cntr_id	;
        uint16_t	exception_drop_cntr_id	;
        uint32_t	reg_bck_up_0          	;
        uint32_t	reg_bck_up_1          	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT;

#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_READ_G(r, g, idx)                                              GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_WRITE_G(v, g, idx)                                             GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_READ(r, p)                                                     MREAD_16((uint8_t *)(p), (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_WRITE(v, p)                                                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT */


/* >>>ACTION_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	type             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	natc_rollback    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	priority         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	reason_or_counter	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU1_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	needed_priority            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	reserved_priority          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint8_t	trap_reason                	; /* Member of reason_or_counter union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_priority       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	drop_counter               	; /* Member of reason_or_counter union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reason_or_counter	; /* This is a field union */
        uint16_t	priority         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint16_t	natc_rollback    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	type             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	trap_reason                	; /* Member of reason_or_counter union */
        uint16_t	reserved_priority          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	needed_priority            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	reservedSU1_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU1_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	drop_counter               	; /* Member of reason_or_counter union */
        uint16_t	reservedSU2_priority       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) ACTION_STRUCT;

#define RDD_ACTION_TYPE_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (r))
#define RDD_ACTION_TYPE_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (v))
#define RDD_ACTION_TYPE_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (r), core_id)
#define RDD_ACTION_TYPE_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (v), core_id)
#define RDD_ACTION_TYPE_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_ACTION_TYPE_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_ACTION_NATC_ROLLBACK_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (r))
#define RDD_ACTION_NATC_ROLLBACK_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (v))
#define RDD_ACTION_NATC_ROLLBACK_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (r), core_id)
#define RDD_ACTION_NATC_ROLLBACK_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (v), core_id)
#define RDD_ACTION_NATC_ROLLBACK_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_ACTION_NATC_ROLLBACK_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_ACTION_PRIORITY_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (r))
#define RDD_ACTION_PRIORITY_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (v))
#define RDD_ACTION_PRIORITY_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (r), core_id)
#define RDD_ACTION_PRIORITY_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (v), core_id)
#define RDD_ACTION_PRIORITY_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 5, (r))
#define RDD_ACTION_PRIORITY_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 5, (v))
#define RDD_ACTION_NEEDED_PRIORITY_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (r))
#define RDD_ACTION_NEEDED_PRIORITY_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (v))
#define RDD_ACTION_NEEDED_PRIORITY_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (r), core_id)
#define RDD_ACTION_NEEDED_PRIORITY_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (v), core_id)
#define RDD_ACTION_NEEDED_PRIORITY_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 3, (r))
#define RDD_ACTION_NEEDED_PRIORITY_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 3, (v))
#define RDD_ACTION_REASON_OR_COUNTER_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_REASON_OR_COUNTER_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_REASON_OR_COUNTER_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_REASON_OR_COUNTER_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_REASON_OR_COUNTER_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_REASON_OR_COUNTER_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_ACTION_TRAP_REASON_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_TRAP_REASON_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_TRAP_REASON_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_TRAP_REASON_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_TRAP_REASON_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_TRAP_REASON_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_ACTION_DROP_COUNTER_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_DROP_COUNTER_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_DROP_COUNTER_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_DROP_COUNTER_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_DROP_COUNTER_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_DROP_COUNTER_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<ACTION_STRUCT */


/* >>>VLAN_TAG_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	pbits     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	cfi       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	vid       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	vid       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	cfi       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbits     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) VLAN_TAG_STRUCT;

#define RDD_VLAN_TAG_PBITS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (r))
#define RDD_VLAN_TAG_PBITS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (v))
#define RDD_VLAN_TAG_PBITS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (r), core_id)
#define RDD_VLAN_TAG_PBITS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (v), core_id)
#define RDD_VLAN_TAG_PBITS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_VLAN_TAG_PBITS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_VLAN_TAG_CFI_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (r))
#define RDD_VLAN_TAG_CFI_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (v))
#define RDD_VLAN_TAG_CFI_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (r), core_id)
#define RDD_VLAN_TAG_CFI_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (v), core_id)
#define RDD_VLAN_TAG_CFI_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_VLAN_TAG_CFI_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_VLAN_TAG_VID_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (r))
#define RDD_VLAN_TAG_VID_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (v))
#define RDD_VLAN_TAG_VID_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (r), core_id)
#define RDD_VLAN_TAG_VID_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (v), core_id)
#define RDD_VLAN_TAG_VID_READ(r, p)                                         RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_VLAN_TAG_VID_WRITE(v, p)                                        RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<VLAN_TAG_STRUCT */


/* >>>CPU_RECYCLE_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	skb_ptr_low   	;
        uint32_t	reserved0     	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	from_feed_ring	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	skb_ptr_hi    	;
#else
        uint32_t	skb_ptr_low   	;
        uint8_t	skb_ptr_hi    	;
        uint32_t	abs           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	from_feed_ring	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0     	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RECYCLE_DESCRIPTOR_STRUCT;

#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ(r, p)                                          MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RECYCLE_DESCRIPTOR_STRUCT */


/* >>>PROCESSING_CPU_RX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	mc_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	type_or_service_queue_wlan 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reason_or_forwarding       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588_or_dsl_rx        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent_or_forwarding     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved0                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU1_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	type                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	cpu_redirect_0                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_reason                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU1_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	coherent                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	metadata_1_2                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU1_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_chksum_verified                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU2_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_is_wlan                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	service_queue_wlan_frw_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	tc                                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	metadata_0_0                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU2_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dsl_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	ucast                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	spdtest_stream_id                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	tcpspdtest_is_upload                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU2_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_redirect_1                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	wan_flow_1                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU3_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU3_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_3_0                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU3_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_flow_priority                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reserved1                            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU4_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	l3_offset                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU5_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	priority                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	metadata_1_0                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU1_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	spdtest_l3_l4_hdr_len                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU2_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	egress_queue                         	; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	wan_flow_0                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU3_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	gdx_pd_data_13_4                     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU4_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport                      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid_or_metadata_2_or_cpu_redirect	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	bn1_or_abs3                	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	ssid                                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	bn1_first                            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port                          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reserved4                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	metadata_2                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved5                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	abs3                                 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	port_id                              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	omci_enc_key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved7                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reservedSU3_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_vport                    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved8                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	is_gdx_rx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	gdx_pd_data_15_14                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reservedSU4_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_or_abs_1    	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buffer_number_0_or_abs_0   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop                                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn0_first                            	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs1                                 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	abs0                                 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                              	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	fpm_pool                             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint16_t	fpm_num                              	; /* Member of buffer_number_0_or_abs_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved0                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent_or_forwarding     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	flag_1588_or_dsl_rx        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reason_or_forwarding       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	type_or_service_queue_wlan 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	force_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	headroom                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_2                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	coherent                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	flag_1588                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU1_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_reason                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_redirect_0                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	type                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	reservedSU1_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU1_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	spdtest_stream_id                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	ucast                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	dsl_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU2_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_0                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	tc                                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	service_queue_wlan_frw_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	service_queue_is_wlan                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	reservedSU2_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_chksum_verified                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU2_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_3_0                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU3_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU3_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_1                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_redirect_1                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU3_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	dhd_flow_priority                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU4_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_offset                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reserved2                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU5_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_0                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_l3_l4_hdr_len                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_0                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint8_t	egress_queue                         	; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_13_4                     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_or_abs3                	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid_or_metadata_2_or_cpu_redirect	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	vport                      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	ssid                                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	flow                                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reservedSU1_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs3                                 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	reserved5                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	metadata_2                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved4                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	source_port                          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reservedSU2_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved7                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	omci_enc_key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	port_id                              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	is_vport                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reservedSU3_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_15_14                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	is_gdx_rx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved8                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reservedSU4_vport                    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0_or_abs_0   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	payload_offset_or_abs_1    	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn0_first                            	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop                                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU1_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs0                                 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	abs1                                 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU2_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	fpm_num                              	; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	fpm_pool                             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop_fpm                              	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU3_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PROCESSING_CPU_RX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ_G(r, g, idx)                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE_G(v, g, idx)                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ_CORE(r, g, idx, core_id)                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE_CORE(v, g, idx, core_id)                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ(r, p)                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE(v, p)                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 7, 9, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 7, 9, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_READ(r, p)                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_WRITE(v, p)                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ_G(r, g, idx)        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE_G(v, g, idx)       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ_CORE(r, g, idx, core_id)CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE_CORE(v, g, idx, core_id)CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ(r, p)               RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE(v, p)              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ(r, p)                                                      RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ(r, p)                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE(v, p)                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ(r, p)                                                            RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE(v, p)                                                           RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_READ(r, p)                                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_WRITE(v, p)                                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_READ_G(r, g, idx)                         GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_WRITE_G(v, g, idx)                        GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_READ_CORE(r, g, idx, core_id)             CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_WRITE_CORE(v, g, idx, core_id)            CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_READ(r, p)                                RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_WRITE(v, p)                               RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ(r, p)                                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE(v, p)                                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ(r, p)                                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ(r, p)                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE(v, p)                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ(r, p)                                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE(v, p)                                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ(r, p)                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE(v, p)                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ(r, p)                                                         RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                                                        RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ(r, p)                                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE(v, p)                                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ_G(r, g, idx)                                                    GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ(r, p)                                                           MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE(v, p)                                                          MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<PROCESSING_CPU_RX_DESCRIPTOR_STRUCT */


/* >>>CPU_RX_METER_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	current_budget  	;
        uint16_t	budget_limit    	;
        uint16_t	allocated_budget	;
        uint8_t	budget_residue  	;
        uint8_t	current_cycle   	;
#else
        uint16_t	budget_limit    	;
        uint16_t	current_budget  	;
        uint8_t	current_cycle   	;
        uint8_t	budget_residue  	;
        uint16_t	allocated_budget	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RX_METER_ENTRY_STRUCT;

#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ(r, p)                                         MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_G(r, g, idx)                                   GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_G(v, g, idx)                                  GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ(r, p)                                          MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE(v, p)                                         MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RX_METER_ENTRY_STRUCT */


/* >>>CPU_REDIRECT_MODE_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
        uint8_t	mode      	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } CPU_REDIRECT_MODE_ENTRY_STRUCT;

#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
/* <<<CPU_REDIRECT_MODE_ENTRY_STRUCT */


/* >>>UDPSPDT_STREAM_RX_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[48];
    uint16_t word_16[24];
    uint32_t word_32[12];
    uint64_t dword_64[6];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_packets_0            	;
        uint32_t	rx_packets_1            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_0               	;
        uint32_t	ts_last_1               	;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_proto_cntr          	;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_out_of_order_0	;
        uint32_t	iperf3_rx_out_of_order_1	;
#else
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_packets_0            	;
        uint32_t	rx_packets_1            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_0               	;
        uint32_t	ts_last_1               	;
        uint16_t	bad_proto_cntr          	;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_out_of_order_0	;
        uint32_t	iperf3_rx_out_of_order_1	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_STREAM_RX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ(r, p)                                                     MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<UDPSPDT_STREAM_RX_STAT_STRUCT */


/* >>>SPDSVC_RX_TS_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDSVC_RX_TS_STAT_STRUCT;

#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ(r, p)                                           MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 1, (v))
/* <<<SPDSVC_RX_TS_STAT_STRUCT */


/* >>>RING_CPU_TX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_egress                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_or_ingress_1       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	packet_length             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sk_buf_ptr_high           	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q                       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU1_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_sk_buf_ptr_high         	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_8_0                     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU2_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_sk_buf_ptr_high         	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                      	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	data_1588                           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	bufmng_cnt_id                       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	reserved1                           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	fpm_fallback              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tgtmem_or_l3pkt           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_or_egress_0       	; /* This is a field union */
        uint8_t	pkt_buf_ptr_high          	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU1_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	ssid                                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	egress_dont_drop                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reserved                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint8_t	reservedSU1_pkt_buf_ptr_high        	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	flow_or_port_id                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_packet                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU2_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_or_bcast                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	bcast                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reserved_ingress_or_egress          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint8_t	reservedSU2_pkt_buf_ptr_high        	;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tgtmem_or_l3pkt         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_15_9                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	is_gdx_rx                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint8_t	reservedSU3_pkt_buf_ptr_high        	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low                     	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved0                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_bn0                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reserved2                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_pool                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint16_t	bn_fpm_num                          	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	sk_buf_ptr_high           	;
        uint32_t	packet_length             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_or_ingress_1       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_egress                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_sk_buf_ptr_high         	;
        uint32_t	reservedSU1_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q                       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU1_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_sk_buf_ptr_high         	;
        uint32_t	reservedSU2_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_8_0                     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU2_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                      	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	bufmng_cnt_id                       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	data_1588                           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	pkt_buf_ptr_high          	;
        uint8_t	ingress_or_egress_0       	; /* This is a field union */
        uint32_t	abs                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tgtmem_or_l3pkt           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	sbpm_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_fallback              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_pkt_buf_ptr_high        	;
        uint32_t	reserved                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	egress_dont_drop                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	ssid                                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	lag_index                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU1_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU1_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_pkt_buf_ptr_high        	;
        uint32_t	reserved_ingress_or_egress          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	bcast                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	mcast_or_bcast                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU2_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_packet                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU2_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_or_port_id                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	is_vport                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	reservedSU3_pkt_buf_ptr_high        	;
        uint32_t	is_gdx_rx                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	gdx_pd_data_15_9                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU3_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tgtmem_or_l3pkt         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low                     	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	fpm_bn0                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved0                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 3 */
		struct{
        uint16_t	bn_fpm_num                          	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_pool                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved2                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RING_CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                                    RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                                   RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                                    RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                                   RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_G(r, g, idx)                               GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_G(v, g, idx)                              GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_CORE(r, g, idx, core_id)                   CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                  CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ(r, p)                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE(v, p)                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ(r, p)                                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE(v, p)                                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ(r, p)                                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE(v, p)                                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)                                                GROUP_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)                                               GROUP_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                                                       MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                                                      MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<RING_CPU_TX_DESCRIPTOR_STRUCT */


/* >>>CPU_TX_RING_INDICES_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	read_idx  	;
        uint16_t	write_idx 	;
#else
        uint16_t	write_idx 	;
        uint16_t	read_idx  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) CPU_TX_RING_INDICES_STRUCT;

#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r), core_id)
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v), core_id)
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ(r, p)                                        MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r), core_id)
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v), core_id)
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CPU_TX_RING_INDICES_STRUCT */


/* >>>CPU_TX_SYNC_FIFO_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	write_ptr 	;
        uint16_t	read_ptr  	;
        uint16_t	fifo      	;
        uint16_t	reserved  	;
#else
        uint16_t	read_ptr  	;
        uint16_t	write_ptr 	;
        uint16_t	reserved  	;
        uint16_t	fifo      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_SYNC_FIFO_ENTRY_STRUCT;

#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ(r, p)                                       MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<CPU_TX_SYNC_FIFO_ENTRY_STRUCT */


/* >>>CPU_TX_DBG_CNTRS_STRUCT */
#define RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER	5
typedef union
    {
    uint8_t word_8[64];
    uint16_t word_16[32];
    uint32_t word_32[16];
    uint64_t dword_64[8];
        struct {
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_DBG_CNTRS_STRUCT;

#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ(r, p)                                                  MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 40, (v))
/* <<<CPU_TX_DBG_CNTRS_STRUCT */


/* >>>SPDSVC_GEN_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[60];
    uint16_t word_16[30];
    uint32_t word_32[15];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	timer_period      	;
        uint16_t	total_length      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#else
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	total_length      	;
        uint16_t	timer_period      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDSVC_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 56, (v))
/* <<<SPDSVC_GEN_PARAMS_STRUCT */


/* >>>SPDTEST_GEN_CFG_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	interrupt_id      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved1         	;
#else
        uint16_t	reserved1         	;
        uint32_t	interrupt_id      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDTEST_GEN_CFG_STRUCT;

#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (r))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (v))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 5, (r))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 5, (v))
/* <<<SPDTEST_GEN_CFG_STRUCT */


/* >>>UDPSPDT_TX_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[24];
    uint16_t word_16[12];
    uint32_t word_32[6];
    uint64_t dword_64[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	total_num_of_pkts    	;
        uint16_t	packet_size          	;
        uint16_t	last_packet_size     	;
        uint32_t	curr_bucket          	;
        uint32_t	bucket_budget        	;
        uint32_t	last_packet_start_idx	;
        uint32_t	max_bucket_size      	;
#else
        uint32_t	total_num_of_pkts    	;
        uint16_t	last_packet_size     	;
        uint16_t	packet_size          	;
        uint32_t	curr_bucket          	;
        uint32_t	bucket_budget        	;
        uint32_t	last_packet_start_idx	;
        uint32_t	max_bucket_size      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_TX_PARAMS_STRUCT;

#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ(r, p)                                           MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 20, (v))
/* <<<UDPSPDT_TX_PARAMS_STRUCT */


/* >>>UDPSPDT_STREAM_TX_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[40];
    uint16_t word_16[20];
    uint32_t word_32[10];
    uint64_t dword_64[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	bad_proto_cntr             	;
        uint16_t	time_slice_expire          	;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	time_slice_expire          	;
        uint16_t	bad_proto_cntr             	;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_STREAM_TX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ(r, p)                                                      MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                                             GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                                            GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ(r, p)                                                    MREAD_16((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                                                   MWRITE_16((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r), core_id)
#d