/*
    <:copyright-BRCM:2014:DUAL/GPL:standard
    
       Copyright (c) 2014 Broadcom 
       All Rights Reserved
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#ifndef _RDD_RUNNER_PROJ_DEFS_H
#define _RDD_RUNNER_PROJ_DEFS_H

#define NUM_OF_GLOBAL_REGS                                      0
#define NUM_OF_LOCAL_REGS                                       32
#define NUM_OF_MAIN_RUNNER_THREADS                              16
#define NUM_OF_RUNNER_CORES                                     6

/* TIMER DEFINES */
#define GHOST_REPORTING_TIMER_INTERVAL_IN_USEC                  40
#define DS_RATE_LIMITER_TIMER_PERIOD_IN_USEC                    100
#define US_RATE_LIMITER_TIMER_PERIOD_IN_USEC                    100
#define TIMER_COMMON_PERIOD_IN_USEC                             100
#define CPU_RX_METER_TIMER_PERIOD                               10000
#define CPU_RX_METER_TIMER_PERIOD_IN_USEC                       (CPU_RX_METER_TIMER_PERIOD)
#define GHOST_REPORTING_TIMER_INTERVAL                          (GHOST_REPORTING_TIMER_INTERVAL_IN_USEC)
#define DS_RATE_LIMITER_TIMER_PERIOD                            (DS_RATE_LIMITER_TIMER_PERIOD_IN_USEC)
#define US_RATE_LIMITER_TIMER_PERIOD                            (US_RATE_LIMITER_TIMER_PERIOD_IN_USEC)
#define TIMER_COMMON_PERIOD                                     (TIMER_COMMON_PERIOD_IN_USEC)

/* NATC */
/* bit 0 of KEY_MASK register[0] corresponds to key bit 0,
 * bit 31 of KEY_MASK register [7] corresponds to key bit 255 */
#define NATC_16BYTE_KEY_MASK            {.data = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff} }

#define ag_drv_natc_cfg_cli_init        ag_drv_natc_tbl_cli_init
#define ag_drv_natc_cfg_key_addr_set    ag_drv_natc_tbl_key_addr_set
#define ag_drv_natc_cfg_res_addr_set    ag_drv_natc_tbl_res_addr_set

#define cli_natc_cfg_key_addr           cli_natc_tbl_key_addr
#define cli_natc_cfg_res_addr           cli_natc_tbl_res_addr

#define RDD_LAN0_VPORT       RDD_VPORT_ID_0
#define RDD_LAN1_VPORT       RDD_VPORT_ID_1
#define RDD_LAN2_VPORT       RDD_VPORT_ID_2
#define RDD_LAN3_VPORT       RDD_VPORT_ID_3
#define RDD_LAN4_VPORT       RDD_VPORT_ID_4
#define RDD_LAN5_VPORT       RDD_VPORT_ID_5
#define RDD_LAN_VPORT_LAST   RDD_LAN5_VPORT

#define RDD_WAN0_VPORT       RDD_VPORT_ID_6
#define RDD_PON_WAN_VPORT    RDD_WAN0_VPORT
#define RDD_WAN1_VPORT       RDD_VPORT_ID_7

#define RDD_CPU0_VPORT       (RDD_WAN1_VPORT + 1)
#define RDD_CPU_VPORT_FIRST  RDD_CPU0_VPORT
#define RDD_CPU1_VPORT       (RDD_CPU_VPORT_FIRST + 1)
#define RDD_CPU2_VPORT       (RDD_CPU_VPORT_FIRST + 2)
#define RDD_GDX_VPORT        RDD_CPU2_VPORT
#define RDD_CPU3_VPORT       (RDD_CPU_VPORT_FIRST + 3)
#define RDD_CPU4_VPORT       (RDD_CPU_VPORT_FIRST + 4)
#define RDD_WLAN0_VPORT      RDD_CPU4_VPORT
#define RDD_CPU5_VPORT       (RDD_CPU_VPORT_FIRST + 5)
#define RDD_WLAN1_VPORT      RDD_CPU5_VPORT
#define RDD_CPU6_VPORT       (RDD_CPU_VPORT_FIRST + 6)
#define RDD_WLAN2_VPORT      RDD_CPU6_VPORT

#define RDD_CPU_VPORT_LAST   RDD_WLAN2_VPORT

#define RDD_BOND0_VPORT      (RDD_CPU_VPORT_LAST + 1)
#define RDD_BOND1_VPORT      (RDD_CPU_VPORT_LAST + 2)

#define RDD_VPORT_MAX RDD_BOND1_VPORT

#define RDD_CPU_VPORT_MASK ((1 << RDD_CPU0_VPORT) | (1 << RDD_CPU1_VPORT) | (1 << RDD_CPU2_VPORT) | \
    (1 << RDD_CPU3_VPORT) | (1 << RDD_CPU4_VPORT) | (1 << RDD_CPU5_VPORT) | (1 << RDD_CPU6_VPORT))

#define RDD_VPORT_ID(id) (1 << id)
#define RDD_WLAN_VPORT_MASK ((1 << RDD_WLAN0_VPORT) | (1 << RDD_WLAN1_VPORT) | (1 << RDD_WLAN2_VPORT))

/* TM */
#define DS_TM_UPDATE_FIFO_THREAD_NUMBER  IMAGE_4_DS_TM_UPDATE_FIFO_THREAD_NUMBER
#define RDD_TM_FLOW_CNTR_TABLE_SIZE      RDD_IMAGE_5_US_TM_TM_FLOW_CNTR_TABLE_SIZE
#define RDD_TM_ACTION_PTR_TABLE_SIZE     RDD_US_TM_TM_ACTION_PTR_TABLE_SIZE
#define RDD_BASIC_SCHEDULER_TABLE_SIZE   RDD_BASIC_SCHEDULER_TABLE_US_SIZE
#define US_TM_BBH_QUEUE_TABLE_SIZE       RDD_IMAGE_5_US_TM_BBH_QUEUE_TABLE_SIZE
#define DS_TM_BBH_QUEUE_TABLE_SIZE       RDD_IMAGE_4_DS_TM_BBH_QUEUE_TABLE_SIZE

#define RDD_DS_TM_FLOW_CNTR_TABLE_SIZE  RDD_IMAGE_4_DS_TM_TM_FLOW_CNTR_TABLE_SIZE
#define TM_BUDGET_ALLOCATION_US_THREAD_NUMBER IMAGE_5_US_TM_BUDGET_ALLOCATION_THREAD_NUMBER
#define TM_OVL_BUDGET_ALLOCATION_US_THREAD_NUMBER IMAGE_5_US_TM_OVL_BUDGET_ALLOCATION_THREAD_NUMBER
#define DS_TM_BUDGET_ALLOCATION_THREAD_NUMBER IMAGE_4_DS_TM_BUDGET_ALLOCATION_THREAD_NUMBER

#define US_TM_UPDATE_FIFO_THREAD_NUMBER  IMAGE_5_US_TM_UPDATE_FIFO_THREAD_NUMBER

#define SERVICE_QUEUES_UPDATE_FIFO_THREAD_NUMBER  IMAGE_2_IMAGE_2_SERVICE_QUEUES_UPDATE_FIFO_THREAD_NUMBER
#define SERVICE_QUEUES_AQM_TIMER_THREAD_NUMBER    IMAGE_2_IMAGE_2_SERVICE_QUEUES_AQM_TIMER_THREAD_NUMBER
/* Service queues AQM timer task interval in us */
#define AQM_TIMER_TASK_TIMER_INTERVAL    100

#define US_TM_BUFFER_CONG_MGT_THREAD_NUMBER         IMAGE_5_US_TM_BUFFER_CONG_MGT_THREAD_NUMBER
#define DS_TM_BUFFER_CONG_MGT_THREAD_NUMBER         IMAGE_4_DS_TM_BUFFER_CONG_MGT_THREAD_NUMBER

#define DS_TM_PI2_THREAD_NUMBER          IMAGE_4_DS_TM_PI2_THREAD_NUMBER
#define US_TM_PI2_THREAD_NUMBER          IMAGE_5_US_TM_PI2_THREAD_NUMBER

/* flush */
#define RDD_DS_TM_FLUSH_CFG_FW_TABLE_ADDRESS IMAGE_4_DS_TM_FLUSH_CFG_FW_TABLE_ADDRESS
#define RDD_DS_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS IMAGE_4_DS_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS
#define RDD_US_TM_FLUSH_CFG_FW_TABLE_ADDRESS IMAGE_5_US_TM_FLUSH_CFG_FW_TABLE_ADDRESS
#define RDD_US_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS IMAGE_5_US_TM_FLUSH_CFG_ENABLE_TABLE_ADDRESS
#define RDD_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_ADDRESS IMAGE_2_SERVICE_QUEUES_FLUSH_CFG_FW_TABLE_ADDRESS
#define RDD_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_ADDRESS IMAGE_2_SERVICE_QUEUES_FLUSH_CFG_ENABLE_TABLE_ADDRESS

#define RDD_BBH_QUEUE_TABLE_SIZE  40
#define RDD_BASIC_RATE_LIMITER_TABLE_SIZE RDD_BASIC_RATE_LIMITER_TABLE_US_SIZE

#define TIMER_COMMON_THREAD_NUMBER          IMAGE_2_IMAGE_2_TIMER_COMMON_THREAD_NUMBER

#ifdef COMPLEX_SCHEDULER_IN_DS
  #define RDD_BASIC_SCHEDULER_TABLE_MAX_SIZE RDD_BASIC_SCHEDULER_TABLE_US_SIZE
  #define RDD_COMPLEX_SCHEDULER_TABLE_MAX_SIZE\
      (RDD_COMPLEX_SCHEDULER_TABLE_US_SIZE > RDD_COMPLEX_SCHEDULER_TABLE_DS_SIZE ? RDD_COMPLEX_SCHEDULER_TABLE_US_SIZE : RDD_COMPLEX_SCHEDULER_TABLE_DS_SIZE)
#else
  #define RDD_BASIC_SCHEDULER_TABLE_MAX_SIZE\
      (RDD_BASIC_SCHEDULER_TABLE_US_SIZE > RDD_BASIC_SCHEDULER_TABLE_DS_SIZE ? RDD_BASIC_SCHEDULER_TABLE_US_SIZE : RDD_BASIC_SCHEDULER_TABLE_DS_SIZE)
  #define RDD_COMPLEX_SCHEDULER_TABLE_MAX_SIZE RDD_COMPLEX_SCHEDULER_TABLE_US_SIZE
#endif

/* REPORTING */
#define REPORTING_THREAD_NUMBER                                 IMAGE_4_DS_TM_REPORTING_THREAD_NUMBER
#define REPORTING_COUNTER_ADDRESS                               IMAGE_4_REPORTING_COUNTER_TABLE_ADDRESS

/* Ingress Filters */
#define INGRESS_FILTER_L2_REASON_TABLE_SIZE                     RDD_IMAGE_2_INGRESS_FILTER_L2_REASON_TABLE_SIZE

/* CPU RX */

#define CPU_RX_THREAD_NUMBER                                    IMAGE_0_IMAGE_0_CPU_RX_THREAD_NUMBER
#define CPU_RX_COPY_THREAD_NUMBER                               IMAGE_0_IMAGE_0_CPU_RX_COPY_THREAD_NUMBER
#define PKTGEN_TX_THREAD_NUMBER                                 IMAGE_0_IMAGE_0_CPU_RX_COPY_THREAD_NUMBER
#define CPU_RX_TIMER_TASK                                       IMAGE_0_IMAGE_0_GENERAL_TIMER_THREAD_NUMBER
#define CPU_RX_METER_BUDGET_ALLOCATOR_THREAD_NUMBER             IMAGE_0_IMAGE_0_GENERAL_TIMER_THREAD_NUMBER

/* DHD */
#define DHD_TX_POST_0_THREAD_NUMBER                             IMAGE_3_IMAGE_3_DHD_TX_POST_0_THREAD_NUMBER

/* CPU TX */
#define RECYCLE_INTERRUPT_COALESCING_THREAD_NUMBER              IMAGE_2_IMAGE_2_INTERRUPT_COALESCING_THREAD_NUMBER
#define CPU_TX_0_THREAD_NUMBER                                  IMAGE_2_IMAGE_2_CPU_TX_0_THREAD_NUMBER
#define CPU_TX_TIMER_TASK                                       IMAGE_2_IMAGE_2_GENERAL_TIMER_THREAD_NUMBER
#define IMAGE_CPU_TX_SYNC_FIFO_TABLE_ADDRESS                    IMAGE_2_CPU_TX_SYNC_FIFO_TABLE_ADDRESS

#define CPU_RINGS_FPM_REFILL_THREAD_NUMBER                      IMAGE_3_IMAGE_3_CPU_FPM_RINGS_AND_BUFMNG_REFILL_THREAD_NUMBER
#define CPU_RINGS_FPM_REFILL_CORE_NUMBER                        image_3_runner_image

#define CPU_TX_SYNC_FIFO_ENTRY_BYTE_SIZE 8 /* should be same as RDD_CPU_TX_SYNC_FIFO_ENTRY_BYTE_SIZE */

/* Speed Test */
#define SPDSVC_GEN_THREAD_NUMBER                                IMAGE_1_IMAGE_1_SPDSVC_GEN_THREAD_NUMBER
#ifdef TCP_SPDTEST_C_CODE
#define TCPSPDTEST_UPLOAD_TIMER_THREAD_NUMBER                   IMAGE_1_IMAGE_1_TCPSPDTEST_UPLOAD_TIMER_THREAD_NUMBER
#define TCPSPDTEST_DOWNLOAD_THREAD_NUMBER                       IMAGE_1_IMAGE_1_TCPSPDTEST_DOWNLOAD_THREAD_NUMBER
#define TCPSPDTEST_UPLOAD_THREAD_NUMBER                         IMAGE_1_IMAGE_1_TCPSPDTEST_UPLOAD_THREAD_NUMBER
#else
#define TCPSPDTEST_GEN_THREAD_NUMBER                            IMAGE_1_IMAGE_1_TCPSPDTEST_GEN_THREAD_NUMBER
#define TCPSPDTEST_THREAD_NUMBER                                IMAGE_1_IMAGE_1_TCPSPDTEST_THREAD_NUMBER
#endif


/* Ingress classifier and VLAN actions */
#define RDD_US_IC_RULE_CFG_TABLE_SIZE                           128
#define RDD_DS_IC_RULE_CFG_TABLE_SIZE                           128
#define RDD_DS_DEFAULT_FLOW_CONTEXT_TABLE_SIZE                  128
#define RDD_US_DEFAULT_FLOW_CONTEXT_TABLE_SIZE                  8
#define RDD_DEFAULT_FLOW_CONTEXT_TABLE_SIZE                     (RDD_DS_DEFAULT_FLOW_CONTEXT_TABLE_SIZE + RDD_US_DEFAULT_FLOW_CONTEXT_TABLE_SIZE)
#define RDD_IC_SHARED_CONTEXT_TABLE_SIZE                        512
#define RDD_DS_IC_CONTEXT_TABLE_SIZE                            RDD_IC_SHARED_CONTEXT_TABLE_SIZE
#define RDD_US_IC_CONTEXT_TABLE_SIZE                            RDD_IC_SHARED_CONTEXT_TABLE_SIZE
#define NUM_OF_GENERIC_RULE_CFG                                 4
#define RDD_VLAN_COMMAND_SKIP                                   128
#define QM_QUEUE_DROP                                           0xFF

#endif
