/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/



/* This is an automated file. Do not edit its contents. */


#ifndef _RDD_DATA_STRUCTURES_AUTO_H_
#define _RDD_DATA_STRUCTURES_AUTO_H_

#define NUM_OF_RUNNER_CORES       6
#define INVALID_TABLE_ADDRESS         0xFFFFFF

#ifdef __clang__
    #define ALIGNMENT(x) __attribute__((align_value((x))))
    #else
    #define ALIGNMENT(x)
    #endif
    


/* >>>MCAST_RESOLUTION_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	egress_ports_vector	;
        uint8_t	iptv_repl_0_sop    	;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	egress_ports_vector	;
        uint32_t	tc                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_vport      	;
        uint32_t	replications       	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pool_num           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	iptv_repl_0_sop    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) MCAST_RESOLUTION_STRUCT;

#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (r), core_id)
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT), (v), core_id)
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (r), core_id)
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 4, (v), core_id)
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (r), core_id)
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 6, 2, (v), core_id)
#define RDD_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (r), core_id)
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 5, 0, 6, (v), core_id)
#define RDD_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 6, (r))
#define RDD_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (r), core_id)
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 6, (v), core_id)
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v))
#define RDD_MCAST_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (r), core_id)
#define RDD_MCAST_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(MCAST_RESOLUTION_STRUCT) + 7, 0, 3, (v), core_id)
#define RDD_MCAST_RESOLUTION_TC_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 0, 3, (r))
#define RDD_MCAST_RESOLUTION_TC_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 0, 3, (v))
/* <<<MCAST_RESOLUTION_STRUCT */


/* >>>PACKET_BUFFER_SCRATCH_ENTRY_STRUCT */
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_NUMBER	8
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_RESERVED_NUMBER	128
typedef union
    {
    uint8_t word_8[136];
    uint16_t word_16[68];
    uint32_t word_32[34];
    uint64_t dword_64[17];
        struct {
        uint8_t natc_cfg[8];
        uint8_t reserved[128];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PACKET_BUFFER_SCRATCH_ENTRY_STRUCT;

#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_SCRATCH_ENTRY_STRUCT), i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_SCRATCH_ENTRY_STRUCT), i, (v))
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_SCRATCH_ENTRY_STRUCT), i, (r), core_id)
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_SCRATCH_ENTRY_STRUCT), i, (v), core_id)
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_PACKET_BUFFER_SCRATCH_ENTRY_NATC_CFG_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<PACKET_BUFFER_SCRATCH_ENTRY_STRUCT */


/* >>>FLOW_BASED_RESOLUTION_STRUCT */
#define RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER	3
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	egress_is_cpu                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc                                             	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved                                       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_dei                                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reserved2                                                 	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	rule2bridge_resolution                                    	; /* This is a field union */
        uint8_t	reserved_4[RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER];
		};
		/* Sub Union 1 */
		struct{
        uint32_t	egress_port_resolved                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved3                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	bridge_egress_vport                                                 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint8_t	reservedSU1_reserved_4[RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER];
		};
		/* Sub Union 2 */
		struct{
        uint32_t	ds_resolution                                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc_to_queue                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_to_queue                                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	vlan_action                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	forw_mode                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc                                                                  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint8_t	reservedSU2_reserved_4[RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER];
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reserved2                                                 	;
        uint32_t	policer_dei                                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_reserved                                       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_cpu_tc                                             	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_is_cpu                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reserved_4[RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER];
        uint8_t	rule2bridge_resolution                                    	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_reserved_4[RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER];
        uint32_t	bridge_egress_vport                                                 	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	reserved3                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	egress_port_resolved                                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_reserved_4[RDD_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER];
        uint32_t	tc                                                                  	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	forw_mode                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	vlan_action                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	pbit_to_queue                                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	tc_to_queue                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
        uint32_t	ds_resolution                                                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of rule2bridge_resolution union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FLOW_BASED_RESOLUTION_STRUCT;

#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 7, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 4, 3, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT), 0, 12, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
#define RDD_FLOW_BASED_RESOLUTION_POLICER_DEI_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 2, 0, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_POLICER_DEI_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 2, 0, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_POLICER_DEI_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 2, 0, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_POLICER_DEI_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 2, 0, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_POLICER_DEI_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_POLICER_DEI_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_G(r, g, idx)                              GROUP_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, (r))
#define RDD_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_G(v, g, idx)                             GROUP_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, (v))
#define RDD_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_CORE(r, g, idx, core_id)                  CORE_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_CORE(v, g, idx, core_id)                 CORE_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ(r, p)                                     MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE(v, p)                                    MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_EGRESS_PORT_RESOLVED_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (r))
#define RDD_FLOW_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (v))
#define RDD_FLOW_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 6, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_FLOW_BASED_RESOLUTION_BRIDGE_EGRESS_VPORT_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_FLOW_BASED_RESOLUTION_DS_RESOLUTION_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_DS_RESOLUTION_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_DS_RESOLUTION_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_DS_RESOLUTION_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_DS_RESOLUTION_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_DS_RESOLUTION_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_TC_TO_QUEUE_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_TC_TO_QUEUE_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_TC_TO_QUEUE_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_TC_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 6, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_TC_TO_QUEUE_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_TC_TO_QUEUE_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_PBIT_TO_QUEUE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_PBIT_TO_QUEUE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 5, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_PBIT_TO_QUEUE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_PBIT_TO_QUEUE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_VLAN_ACTION_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_VLAN_ACTION_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_VLAN_ACTION_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_VLAN_ACTION_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 4, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_VLAN_ACTION_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_VLAN_ACTION_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_FORW_MODE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_FORW_MODE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_FORW_MODE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_FORW_MODE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 3, 1, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_FORW_MODE_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_FLOW_BASED_RESOLUTION_FORW_MODE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_FLOW_BASED_RESOLUTION_TC_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_TC_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (v))
#define RDD_FLOW_BASED_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (r), core_id)
#define RDD_FLOW_BASED_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLOW_BASED_RESOLUTION_STRUCT) + 4, 0, 3, (v), core_id)
#define RDD_FLOW_BASED_RESOLUTION_TC_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 3, (r))
#define RDD_FLOW_BASED_RESOLUTION_TC_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 3, (v))
/* <<<FLOW_BASED_RESOLUTION_STRUCT */


/* >>>COMMON_RESOLUTION_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved_0               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_lan                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	rx_flow                  	;
        uint32_t	reserved_1               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	rx_mirroring_flag        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	lookup_port              	;
        uint8_t	reserved_2               	;
        uint8_t	mcast_current_replication	;
        uint16_t	tx_flow                  	;
#else
        uint8_t	lookup_port              	;
        uint32_t	rx_mirroring_flag        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_1               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	rx_flow                  	;
        uint32_t	is_lan                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved_0               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	tx_flow                  	;
        uint8_t	mcast_current_replication	;
        uint8_t	reserved_2               	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) COMMON_RESOLUTION_STRUCT;

#define RDD_COMMON_RESOLUTION_IS_LAN_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (v))
#define RDD_COMMON_RESOLUTION_IS_LAN_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT), 0, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_IS_LAN_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_COMMON_RESOLUTION_IS_LAN_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ_G(r, g, idx)                                                  GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (r))
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (v))
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_RX_FLOW_READ(r, p)                                                         MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_COMMON_RESOLUTION_RX_FLOW_WRITE(v, p)                                                        MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_COMMON_RESOLUTION_RX_MIRRORING_FLAG_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, 0, 1, (r))
#define RDD_COMMON_RESOLUTION_RX_MIRRORING_FLAG_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, 0, 1, (v))
#define RDD_COMMON_RESOLUTION_RX_MIRRORING_FLAG_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, 0, 1, (r), core_id)
#define RDD_COMMON_RESOLUTION_RX_MIRRORING_FLAG_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 2, 0, 1, (v), core_id)
#define RDD_COMMON_RESOLUTION_RX_MIRRORING_FLAG_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_COMMON_RESOLUTION_RX_MIRRORING_FLAG_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ_G(r, g, idx)                                              GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 3, (r))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 3, (v))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 3, (r), core_id)
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 3, (v), core_id)
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_READ(r, p)                                                     MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_COMMON_RESOLUTION_LOOKUP_PORT_WRITE(v, p)                                                    MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, (r))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, (v))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, (r), core_id)
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 5, (v), core_id)
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (r))
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (v))
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (r), core_id)
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(COMMON_RESOLUTION_STRUCT) + 6, (v), core_id)
#define RDD_COMMON_RESOLUTION_TX_FLOW_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_COMMON_RESOLUTION_TX_FLOW_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<COMMON_RESOLUTION_STRUCT */


/* >>>PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT */
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_NUMBER	3
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
        COMMON_RESOLUTION_STRUCT common_resolution;
        union {
            MCAST_RESOLUTION_STRUCT mcast_resolution;
            FLOW_BASED_RESOLUTION_STRUCT flow_based_resolution;
        };
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT;

#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 7, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 7, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 7, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 1, 7, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 7, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_0_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 7, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ_G(r, g, idx)                                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE_G(v, g, idx)                                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ_CORE(r, g, idx, core_id)                                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE_CORE(v, g, idx, core_id)                                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT), 0, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_READ(r, p)                                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_IS_LAN_WRITE(v, p)                                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ_G(r, g, idx)                                                                GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE_G(v, g, idx)                                                               GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ_CORE(r, g, idx, core_id)                                                    CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE_CORE(v, g, idx, core_id)                                                   CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_READ(r, p)                                                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_FLOW_WRITE(v, p)                                                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 1, 7, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 1, 7, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 1, 7, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 1, 7, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 7, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_1_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 7, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_MIRRORING_FLAG_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_MIRRORING_FLAG_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_MIRRORING_FLAG_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 0, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_MIRRORING_FLAG_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 2, 0, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_MIRRORING_FLAG_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RX_MIRRORING_FLAG_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ_G(r, g, idx)                                                            GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_READ(r, p)                                                                   MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_LOOKUP_PORT_WRITE(v, p)                                                                  MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_READ_G(r, g, idx)                                                             GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_READ(r, p)                                                                    MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_RESERVED_2_WRITE(v, p)                                                                   MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_G(r, g, idx)                                              GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_G(v, g, idx)                                             GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 5, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_READ(r, p)                                                     MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_MCAST_CURRENT_REPLICATION_WRITE(v, p)                                                    MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ_G(r, g, idx)                                                                GROUP_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE_G(v, g, idx)                                                               GROUP_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ_CORE(r, g, idx, core_id)                                                    CORE_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE_CORE(v, g, idx, core_id)                                                   CORE_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_READ(r, p)                                                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_COMMON_RESOLUTION_TX_FLOW_WRITE(v, p)                                                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_EGRESS_PORTS_VECTOR_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_G(r, g, idx)                                         GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_G(v, g, idx)                                        GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_READ(r, p)                                                MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_IPTV_REPL_0_SOP_WRITE(v, p)                                               MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 6, 2, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 6, 2, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 6, 2, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_POOL_NUM_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 6, 2, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 0, 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, 0, 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_REPLICATIONS_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_INGRESS_VPORT_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 3, 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 3, 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 3, 5, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 3, 5, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 3, 5, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_RESERVED1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 3, 5, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 0, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 15, 0, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_MCAST_RESOLUTION_TC_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_IS_CPU_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 4, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 4, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_TC_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 0, 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 8, 0, 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 0, 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_EGRESS_CPU_RESERVED_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 0, 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 1, 7, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 1, 7, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 1, 7, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 1, 7, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 7, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED1_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 7, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_POLICER_DEI_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_POLICER_DEI_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_POLICER_DEI_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_POLICER_DEI_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_POLICER_DEI_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_POLICER_DEI_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED2_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 11, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED2_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 11, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED2_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 11, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED2_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 11, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED2_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED2_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_G(r, g, idx)                             GROUP_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_G(v, g, idx)                            GROUP_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ_CORE(r, g, idx, core_id)                 CORE_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE_CORE(v, g, idx, core_id)                CORE_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_READ(r, p)                                    MREAD_8((uint8_t *)(p) + 12, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RULE2BRIDGE_RESOLUTION_WRITE(v, p)                                   MWRITE_8((uint8_t *)(p) + 12, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ_G(r, g, idx)                                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE_G(v, g, idx)                                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ_CORE(r, g, idx, core_id)                                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE_CORE(v, g, idx, core_id)                                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_READ(r, p)                                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_EGRESS_PORT_RESOLVED_WRITE(v, p)                                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ_G(r, g, idx)                                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE_G(v, g, idx)                                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ_CORE(r, g, idx, core_id)                                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE_CORE(v, g, idx, core_id)                                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 6, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_READ(r, p)                                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 6, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_BRIDGE_EGRESS_VPORT_WRITE(v, p)                                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 6, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DS_RESOLUTION_READ_G(r, g, idx)                                                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DS_RESOLUTION_WRITE_G(v, g, idx)                                                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DS_RESOLUTION_READ_CORE(r, g, idx, core_id)                                                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DS_RESOLUTION_WRITE_CORE(v, g, idx, core_id)                                                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DS_RESOLUTION_READ(r, p)                                                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_DS_RESOLUTION_WRITE(v, p)                                                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ_G(r, g, idx)                                                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE_G(v, g, idx)                                                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ_CORE(r, g, idx, core_id)                                                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                                                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 6, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_READ(r, p)                                                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_TO_QUEUE_WRITE(v, p)                                                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ_G(r, g, idx)                                                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE_G(v, g, idx)                                                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ_CORE(r, g, idx, core_id)                                                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE_CORE(v, g, idx, core_id)                                                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 5, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_READ(r, p)                                                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 5, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_PBIT_TO_QUEUE_WRITE(v, p)                                                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 5, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ_G(r, g, idx)                                                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE_G(v, g, idx)                                                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ_CORE(r, g, idx, core_id)                                                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE_CORE(v, g, idx, core_id)                                                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 4, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_READ(r, p)                                                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 4, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_VLAN_ACTION_WRITE(v, p)                                                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 4, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ_G(r, g, idx)                                                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE_G(v, g, idx)                                                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ_CORE(r, g, idx, core_id)                                                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE_CORE(v, g, idx, core_id)                                                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 3, 1, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_READ(r, p)                                                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 3, 1, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FORW_MODE_WRITE(v, p)                                                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 3, 1, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ_G(r, g, idx)                                                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE_G(v, g, idx)                                                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ_CORE(r, g, idx, core_id)                                                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE_CORE(v, g, idx, core_id)                                                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 4, 0, 3, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_READ(r, p)                                                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 3, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_TC_WRITE(v, p)                                                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 3, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, i, (v))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, i, (r), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_8((g), (idx)*sizeof(PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT) + 13, i, (v), core_id)
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_READ(r, p, i)                                             MREAD_I_8((uint8_t *)(p) + 13, i, (r))
#define RDD_PACKET_BUFFER_RESOLUTION_ENTRY_FLOW_RESOLUTION_FLOW_BASED_RESOLUTION_RESERVED_4_WRITE(v, p, i)                                            MWRITE_I_8((uint8_t *)(p) + 13, i, (v))
/* <<<PACKET_BUFFER_RESOLUTION_ENTRY_STRUCT */


/* >>>FLOW_BASED_CONTEXT_STRUCT */
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_NUMBER	64
#define RDD_FLOW_BASED_CONTEXT_RESERVED_NUMBER	48
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_NUMBER	16
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint8_t flow_cache[64];
        uint8_t reserved[48];
        uint8_t tcam_ip_flow_result[16];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FLOW_BASED_CONTEXT_STRUCT;

#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (r))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (v))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_READ(r, p, i)                                             MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_FLOW_BASED_CONTEXT_FLOW_CACHE_WRITE(v, p, i)                                            MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (r))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (v))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (r), core_id)
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(FLOW_BASED_CONTEXT_STRUCT) + 112, i, (v), core_id)
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 112, i, (r))
#define RDD_FLOW_BASED_CONTEXT_TCAM_IP_FLOW_RESULT_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 112, i, (v))
/* <<<FLOW_BASED_CONTEXT_STRUCT */


/* >>>RULE_BASED_CONTEXT_STRUCT */
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_NUMBER	8
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_NUMBER	16
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_NUMBER	64
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_NUMBER	8
#define RDD_RULE_BASED_CONTEXT_RESERVED_NUMBER	16
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint8_t tcam_result[16];
        uint8_t natc_key[8];
        uint8_t natc_key_data[16];
        uint8_t natc_context[64];
        uint8_t tcam_qos_result[8];
        uint8_t reserved[16];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_CONTEXT_STRUCT;

#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_RESULT_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 16, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_READ(r, p, i)                                           MREAD_I_8((uint8_t *)(p) + 16, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_WRITE(v, p, i)                                          MWRITE_I_8((uint8_t *)(p) + 16, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_READ_G(r, g, idx, i)                               GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 24, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_WRITE_G(v, g, idx, i)                              GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 24, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_READ_CORE(r, g, idx, i, core_id)                   CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 24, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_WRITE_CORE(v, g, idx, i, core_id)                  CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 24, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_READ(r, p, i)                                      MREAD_I_8((uint8_t *)(p) + 24, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_KEY_DATA_WRITE(v, p, i)                                     MWRITE_I_8((uint8_t *)(p) + 24, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (v))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 40, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p) + 40, i, (r))
#define RDD_RULE_BASED_CONTEXT_NATC_CONTEXT_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p) + 40, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (v))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_STRUCT) + 104, i, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 104, i, (r))
#define RDD_RULE_BASED_CONTEXT_TCAM_QOS_RESULT_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 104, i, (v))
/* <<<RULE_BASED_CONTEXT_STRUCT */


/* >>>RULE_BASED_NATC_CONTEXT_STRUCT */
#define RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER	8
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER	52
#define RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER	64
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint32_t	natc_control                                               	;
        uint8_t	reserved0[RDD_RULE_BASED_NATC_CONTEXT_RESERVED0_NUMBER];
        uint8_t	cmd_list[RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_NUMBER];
        uint8_t	reserved1[RDD_RULE_BASED_NATC_CONTEXT_RESERVED1_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_NATC_CONTEXT_STRUCT;

#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (r))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (v))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (r), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT), (v), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_RULE_BASED_NATC_CONTEXT_NATC_CONTROL_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (r))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (v))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (r), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(RULE_BASED_NATC_CONTEXT_STRUCT) + 12, i, (v), core_id)
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p) + 12, i, (r))
#define RDD_RULE_BASED_NATC_CONTEXT_CMD_LIST_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p) + 12, i, (v))
/* <<<RULE_BASED_NATC_CONTEXT_STRUCT */


/* >>>IPTV_CONTEXT_STRUCT */
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER	32
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint32_t	iptv_context[RDD_IPTV_CONTEXT_IPTV_CONTEXT_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_CONTEXT_STRUCT;

#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ_G(r, g, idx, i)                                GROUP_MREAD_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_32((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_READ(r, p, i)                                       MREAD_I_32((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CONTEXT_WRITE(v, p, i)                                      MWRITE_I_32((uint8_t *)(p), i, (v))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_IPTV_CONTEXT_NATC_COMMAND_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_NATC_COMMAND_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (r))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (v))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (r), core_id)
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT) + 64, i, (v), core_id)
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_IPTV_CONTEXT_VLAN_ACTION_CTX_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v))
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_IPTV_CONTEXT_IPTV_CTX_READ(r, p, i)                                           MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_CONTEXT_IPTV_CTX_WRITE(v, p, i)                                          MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<IPTV_CONTEXT_STRUCT */


/* >>>IPTV_PORT_CONTEXT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	state                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0             	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_header_length      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_push               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_command_list_length	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_offset             	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved1             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_wred_high_prio     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_phy            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_info           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	egress_port           	;
        uint8_t	queue                 	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_reserved1           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_wred_high_prio   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_egress_phy          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_port                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint8_t	reservedSU1_egress_port         	;
        uint8_t	reservedSU1_queue               	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_reserved1           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_wred_high_prio   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_egress_phy          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_phy_ext                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	egress_mode                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint8_t	reservedSU2_egress_port         	;
        uint8_t	reservedSU2_queue               	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	l2_offset             	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_command_list_length	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_push               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l2_header_length      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0             	:13	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	state                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	queue                 	;
        uint8_t	egress_port           	;
        uint32_t	egress_info           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	egress_phy            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_wred_high_prio     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_queue               	;
        uint8_t	reservedSU1_egress_port         	;
        uint32_t	lag_port                        	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	reservedSU1_egress_phy          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_is_wred_high_prio   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved1           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_queue               	;
        uint8_t	reservedSU2_egress_port         	;
        uint32_t	egress_mode                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	egress_phy_ext                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	reservedSU2_egress_phy          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_is_wred_high_prio   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved1           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_PORT_CONTEXT_ENTRY_STRUCT;

#define RDD_IPTV_PORT_CONTEXT_ENTRY_STATE_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT), 7, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_STATE_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT), 7, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_STATE_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_STATE_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_STATE_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_STATE_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_HEADER_LENGTH_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 0, 13, 5, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_HEADER_LENGTH_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 0, 13, 5, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_HEADER_LENGTH_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 0, 13, 5, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_HEADER_LENGTH_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 0, 13, 5, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_HEADER_LENGTH_READ(r, p)                                             RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 13, 5, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_HEADER_LENGTH_WRITE(v, p)                                            RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 13, 5, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_PUSH_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_PUSH_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_PUSH_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_PUSH_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 4, 1, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_PUSH_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 4, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_PUSH_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 4, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_COMMAND_LIST_LENGTH_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 5, 7, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_COMMAND_LIST_LENGTH_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 5, 7, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_COMMAND_LIST_LENGTH_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 5, 7, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_COMMAND_LIST_LENGTH_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 2, 5, 7, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_COMMAND_LIST_LENGTH_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 5, 7, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_COMMAND_LIST_LENGTH_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 5, 7, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_OFFSET_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 3, 0, 5, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_OFFSET_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 3, 0, 5, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_OFFSET_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 3, 0, 5, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_OFFSET_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 3, 0, 5, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_OFFSET_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 5, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_L2_OFFSET_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 5, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 4, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 4, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 4, 1, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 4, 1, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 4, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 4, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 2, 2, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 2, 2, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 2, 2, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 2, 2, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 2, 2, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 2, 2, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_INFO_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_INFO_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_INFO_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_INFO_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_INFO_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 2, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_INFO_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 2, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_LAG_PORT_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_LAG_PORT_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_LAG_PORT_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_LAG_PORT_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 2, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_LAG_PORT_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 2, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_LAG_PORT_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 2, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_EXT_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 1, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_EXT_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 1, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_EXT_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 1, 1, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_EXT_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 1, 1, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_EXT_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 1, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PHY_EXT_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 1, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_MODE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_MODE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_MODE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 1, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_MODE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 5, 0, 1, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_MODE_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 0, 1, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_MODE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 0, 1, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PORT_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PORT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PORT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PORT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PORT_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_EGRESS_PORT_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_QUEUE_READ_G(r, g, idx)                                                 GROUP_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 7, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_QUEUE_WRITE_G(v, g, idx)                                                GROUP_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 7, (v))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_QUEUE_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 7, (r), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_QUEUE_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_8((g), (idx)*sizeof(IPTV_PORT_CONTEXT_ENTRY_STRUCT) + 7, (v), core_id)
#define RDD_IPTV_PORT_CONTEXT_ENTRY_QUEUE_READ(r, p)                                                        MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_IPTV_PORT_CONTEXT_ENTRY_QUEUE_WRITE(v, p)                                                       MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<IPTV_PORT_CONTEXT_ENTRY_STRUCT */


/* >>>IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT */
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_NUMBER	56
typedef union
    {
    uint8_t word_8[64];
    uint16_t word_16[32];
    uint32_t word_32[16];
    uint64_t dword_64[8];
        struct {
        uint8_t	header[RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_NUMBER];
        uint32_t	context_0                                               	;
        uint32_t	context_1                                               	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT;

#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_READ_G(r, g, idx, i)                                GROUP_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT), i, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_WRITE_G(v, g, idx, i)                               GROUP_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT), i, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_READ_CORE(r, g, idx, i, core_id)                    CORE_MREAD_I_8((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT), i, (r), core_id)
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_WRITE_CORE(v, g, idx, i, core_id)                   CORE_MWRITE_I_8((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT), i, (v), core_id)
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_READ(r, p, i)                                       MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_HEADER_WRITE(v, p, i)                                      MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 56, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 56, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 56, (r), core_id)
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 56, (v), core_id)
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 60, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 60, (v))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 60, (r), core_id)
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT) + 60, (v), core_id)
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_IPTV_DDR_PORT_BUFFER_ENTRY_CONTEXT_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 60, (v))
/* <<<IPTV_DDR_PORT_BUFFER_ENTRY_STRUCT */


/* >>>MC_FLOW_CONTEXT_STRUCT */
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER	128
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
        uint8_t	mc_flow_context[RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) MC_FLOW_CONTEXT_STRUCT;

#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_G(r, g, idx, i)                            GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_G(v, g, idx, i)                           GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ_CORE(r, g, idx, i, core_id)                CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE_CORE(v, g, idx, i, core_id)               CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_READ(r, p, i)                                   MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_MC_FLOW_CONTEXT_WRITE(v, p, i)                                  MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_MASTER_READ_G(r, g, idx, i)                                     GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (r))
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE_G(v, g, idx, i)                                    GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (v))
#define RDD_MC_FLOW_CONTEXT_MASTER_READ_CORE(r, g, idx, i, core_id)                         CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE_CORE(v, g, idx, i, core_id)                        CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 64, i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_MASTER_READ(r, p, i)                                            MREAD_I_8((uint8_t *)(p) + 64, i, (r))
#define RDD_MC_FLOW_CONTEXT_MASTER_WRITE(v, p, i)                                           MWRITE_I_8((uint8_t *)(p) + 64, i, (v))
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ_G(r, g, idx, i)                                     GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE_G(v, g, idx, i)                                    GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ_CORE(r, g, idx, i, core_id)                         CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE_CORE(v, g, idx, i, core_id)                        CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_CLIENT_READ(r, p, i)                                            MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_CLIENT_WRITE(v, p, i)                                           MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ_G(r, g, idx, i)                                 GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE_G(v, g, idx, i)                                GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ_CORE(r, g, idx, i, core_id)                     CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE_CORE(v, g, idx, i, core_id)                    CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT), i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_READ(r, p, i)                                        MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_MC_FLOW_CONTEXT_LAYER2_CRC_WRITE(v, p, i)                                       MWRITE_I_8((uint8_t *)(p), i, (v))
#define RDD_MC_FLOW_CONTEXT_POLICER_RESULT_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 8, i, (r))
#define RDD_MC_FLOW_CONTEXT_POLICER_RESULT_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 8, i, (v))
#define RDD_MC_FLOW_CONTEXT_POLICER_RESULT_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 8, i, (r), core_id)
#define RDD_MC_FLOW_CONTEXT_POLICER_RESULT_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(MC_FLOW_CONTEXT_STRUCT) + 8, i, (v), core_id)
#define RDD_MC_FLOW_CONTEXT_POLICER_RESULT_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p) + 8, i, (r))
#define RDD_MC_FLOW_CONTEXT_POLICER_RESULT_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p) + 8, i, (v))
/* <<<MC_FLOW_CONTEXT_STRUCT */


/* >>>FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT */
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_NUMBER	104
typedef union
    {
    uint8_t word_8[124];
    uint16_t word_16[62];
    uint32_t word_32[31];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	natc_control                                                          	;
        uint32_t	multicast_flag                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	overflow                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	max_pkt_len                                                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdsvc_flow                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	connection_direction                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	command_list_length_32                                                	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_wred_high_prio                                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_mapt_us                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_tos_mangle                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_l2_accel                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                                                                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_unicast_wfd_nic                                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_unicast_wfd_any                                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority                                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wfd_prio                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wfd_idx                                                               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_hit_trap                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_phy                                                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ingqos_high_prio                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_tcpspdtest                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	link_specific_union                                                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_addresses_table_index                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_stream_id                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_flow_priority                                                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_reason                                                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	tos                                                                   	;
        uint8_t	pathstat_idx                                                          	;
        uint32_t	is_service_queue                                                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_id                                                      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_flood                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport                                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                                                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	command_list[RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_NUMBER];
#else
        uint32_t	natc_control                                                          	;
        uint32_t	reserved0                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                                                                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_l2_accel                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_tos_mangle                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_routed                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_mapt_us                                                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_wred_high_prio                                                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	command_list_length_32                                                	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	connection_direction                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdsvc_flow                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	max_pkt_len                                                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	overflow                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	multicast_flag                                                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	link_specific_union                                                   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_tcpspdtest                                                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_ingqos_high_prio                                                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_phy                                                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_hit_trap                                                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wfd_idx                                                               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wfd_prio                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority                                                              	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_unicast_wfd_any                                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_unicast_wfd_nic                                                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pathstat_idx                                                          	;
        uint8_t	tos                                                                   	;
        uint32_t	cpu_reason                                                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_flow_priority                                                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_stream_id                                                     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload                                                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ip_addresses_table_index                                              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                                                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport                                                                 	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_flood                                                              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_id                                                      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_service_queue                                                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	command_list[RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_NATC_CONTROL_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT), (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_NATC_CONTROL_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT), (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_NATC_CONTROL_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT), (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_NATC_CONTROL_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT), (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_NATC_CONTROL_READ(r, p)                                                   MREAD_32((uint8_t *)(p), (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_NATC_CONTROL_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p), (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MULTICAST_FLAG_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MULTICAST_FLAG_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MULTICAST_FLAG_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MULTICAST_FLAG_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MULTICAST_FLAG_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MULTICAST_FLAG_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_OVERFLOW_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_OVERFLOW_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_OVERFLOW_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 6, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_OVERFLOW_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 6, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_OVERFLOW_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_OVERFLOW_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MAX_PKT_LEN_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 0, 14, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 0, 14, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MAX_PKT_LEN_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 0, 14, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 4, 0, 14, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MAX_PKT_LEN_READ(r, p)                                                    RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 0, 14, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_MAX_PKT_LEN_WRITE(v, p)                                                   RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 0, 14, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDSVC_FLOW_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDSVC_FLOW_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDSVC_FLOW_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDSVC_FLOW_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDSVC_FLOW_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDSVC_FLOW_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DROP_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DROP_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DROP_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 6, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DROP_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 6, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DROP_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DROP_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CONNECTION_DIRECTION_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 5, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CONNECTION_DIRECTION_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 5, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CONNECTION_DIRECTION_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 5, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CONNECTION_DIRECTION_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 5, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CONNECTION_DIRECTION_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 5, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CONNECTION_DIRECTION_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 5, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_LENGTH_32_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 0, 5, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_LENGTH_32_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 0, 5, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_LENGTH_32_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 0, 5, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_LENGTH_32_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 6, 0, 5, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_LENGTH_32_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 5, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_LENGTH_32_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 5, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_WRED_HIGH_PRIO_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_MAPT_US_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_MAPT_US_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_MAPT_US_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 6, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_MAPT_US_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 6, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_MAPT_US_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_MAPT_US_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_ROUTED_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 4, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_ROUTED_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 4, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_ROUTED_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 4, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_ROUTED_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 4, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_ROUTED_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 4, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_ROUTED_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 4, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TOS_MANGLE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 3, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TOS_MANGLE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 3, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TOS_MANGLE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 3, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TOS_MANGLE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 3, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TOS_MANGLE_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 3, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TOS_MANGLE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 3, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_L2_ACCEL_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 2, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_L2_ACCEL_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 2, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_L2_ACCEL_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 2, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_L2_ACCEL_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 2, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_L2_ACCEL_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 2, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_L2_ACCEL_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 2, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VALID_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VALID_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VALID_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 1, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VALID_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 7, 1, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VALID_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 7, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VALID_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 7, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_NIC_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_NIC_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_NIC_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_NIC_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_NIC_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_NIC_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_ANY_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_ANY_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_ANY_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_ANY_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_ANY_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_UNICAST_WFD_ANY_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PRIORITY_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 2, 4, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PRIORITY_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 2, 4, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PRIORITY_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 2, 4, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PRIORITY_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 2, 4, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PRIORITY_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 4, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PRIORITY_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 4, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_PRIO_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_PRIO_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_PRIO_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_PRIO_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 1, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_PRIO_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_PRIO_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_IDX_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_IDX_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_IDX_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 2, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_IDX_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 7, 2, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_IDX_READ(r, p)                                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 7, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_WFD_IDX_WRITE(v, p)                                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 7, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_HIT_TRAP_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_HIT_TRAP_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_HIT_TRAP_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 6, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_HIT_TRAP_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 6, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_HIT_TRAP_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 6, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_HIT_TRAP_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 6, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_EGRESS_PHY_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 4, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_EGRESS_PHY_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 4, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_EGRESS_PHY_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 4, 2, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_EGRESS_PHY_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 4, 2, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_EGRESS_PHY_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 4, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_EGRESS_PHY_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 4, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_INGQOS_HIGH_PRIO_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_INGQOS_HIGH_PRIO_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_INGQOS_HIGH_PRIO_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_INGQOS_HIGH_PRIO_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_INGQOS_HIGH_PRIO_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_INGQOS_HIGH_PRIO_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TCPSPDTEST_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TCPSPDTEST_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TCPSPDTEST_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TCPSPDTEST_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 9, 2, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TCPSPDTEST_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_TCPSPDTEST_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_LINK_SPECIFIC_UNION_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 0, 18, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_LINK_SPECIFIC_UNION_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 0, 18, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_LINK_SPECIFIC_UNION_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 0, 18, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_LINK_SPECIFIC_UNION_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 8, 0, 18, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_LINK_SPECIFIC_UNION_READ(r, p)                                            RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_LINK_SPECIFIC_UNION_WRITE(v, p)                                           RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IP_ADDRESSES_TABLE_INDEX_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 5, 3, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IP_ADDRESSES_TABLE_INDEX_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 5, 3, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IP_ADDRESSES_TABLE_INDEX_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 5, 3, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IP_ADDRESSES_TABLE_INDEX_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 5, 3, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IP_ADDRESSES_TABLE_INDEX_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 3, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IP_ADDRESSES_TABLE_INDEX_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 3, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_GDX_TX_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 4, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_GDX_TX_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 4, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_GDX_TX_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 4, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_GDX_TX_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 4, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_GDX_TX_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 4, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_GDX_TX_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 4, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 3, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 3, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 3, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 3, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 3, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TCPSPDTEST_IS_UPLOAD_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 3, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDTEST_STREAM_ID_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 0, 3, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 0, 3, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 0, 3, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 12, 0, 3, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDTEST_STREAM_ID_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 0, 3, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SPDTEST_STREAM_ID_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 0, 3, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DHD_FLOW_PRIORITY_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DHD_FLOW_PRIORITY_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DHD_FLOW_PRIORITY_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DHD_FLOW_PRIORITY_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 6, 2, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DHD_FLOW_PRIORITY_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 6, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_DHD_FLOW_PRIORITY_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 6, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CPU_REASON_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CPU_REASON_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CPU_REASON_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CPU_REASON_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 13, 0, 6, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CPU_REASON_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 6, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_CPU_REASON_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 6, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TOS_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 14, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TOS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 14, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TOS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 14, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TOS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 14, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TOS_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_TOS_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PATHSTAT_IDX_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 15, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 15, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PATHSTAT_IDX_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 15, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 15, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PATHSTAT_IDX_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 15, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_PATHSTAT_IDX_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 15, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_SERVICE_QUEUE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_SERVICE_QUEUE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_SERVICE_QUEUE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 7, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_SERVICE_QUEUE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 7, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SERVICE_QUEUE_ID_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 5, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SERVICE_QUEUE_ID_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 5, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SERVICE_QUEUE_ID_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 5, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SERVICE_QUEUE_ID_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 5, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SERVICE_QUEUE_ID_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 2, 5, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_SERVICE_QUEUE_ID_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 2, 5, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_FLOOD_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_FLOOD_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_FLOOD_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 1, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_FLOOD_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 1, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_FLOOD_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_IS_FLOOD_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VPORT_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 7, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VPORT_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 7, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VPORT_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 7, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VPORT_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 16, 2, 7, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VPORT_READ(r, p)                                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 16, 2, 7, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_VPORT_WRITE(v, p)                                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 16, 2, 7, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_READ_G(r, g, idx, i)                                         GROUP_MREAD_I_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 20, i, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_WRITE_G(v, g, idx, i)                                        GROUP_MWRITE_I_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 20, i, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_READ_CORE(r, g, idx, i, core_id)                             CORE_MREAD_I_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 20, i, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_WRITE_CORE(v, g, idx, i, core_id)                            CORE_MWRITE_I_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT) + 20, i, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_READ(r, p, i)                                                MREAD_I_8((uint8_t *)(p) + 20, i, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ENTRY_COMMAND_LIST_WRITE(v, p, i)                                               MWRITE_I_8((uint8_t *)(p) + 20, i, (v))
/* <<<FC_UCAST_FLOW_CONTEXT_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved1     	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved2     	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved3     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_info   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	egress_port   	;
        uint8_t	queue         	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_reserved3   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_port                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint8_t	reservedSU1_egress_port 	;
        uint8_t	reservedSU1_queue       	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_reserved3   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_phy_ext          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	egress_mode             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint8_t	reservedSU2_egress_port 	;
        uint8_t	reservedSU2_queue       	;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved1     	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved2     	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	queue         	;
        uint8_t	egress_port   	;
        uint32_t	egress_info   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved3     	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_queue       	;
        uint8_t	reservedSU1_egress_port 	;
        uint32_t	lag_port                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	reservedSU1_reserved3   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_queue       	;
        uint8_t	reservedSU2_egress_port 	;
        uint32_t	egress_mode             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	egress_phy_ext          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_info union */
        uint32_t	reservedSU2_reserved3   	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_INFO_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_INFO_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_INFO_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_INFO_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_INFO_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_INFO_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_LAG_PORT_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_LAG_PORT_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_LAG_PORT_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_LAG_PORT_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_LAG_PORT_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_LAG_PORT_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PHY_EXT_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PHY_EXT_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PHY_EXT_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PHY_EXT_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PHY_EXT_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PHY_EXT_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_MODE_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_MODE_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_MODE_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_MODE_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_MODE_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_MODE_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PORT_READ_G(r, g, idx)                                   GROUP_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PORT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 10, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PORT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 10, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PORT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 10, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PORT_READ(r, p)                                          MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_EGRESS_PORT_WRITE(v, p)                                         MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_QUEUE_READ_G(r, g, idx)                                         GROUP_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 11, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_QUEUE_WRITE_G(v, g, idx)                                        GROUP_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 11, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_QUEUE_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 11, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_QUEUE_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT) + 11, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_QUEUE_READ(r, p)                                                MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_QUEUE_WRITE(v, p)                                               MWRITE_8((uint8_t *)(p) + 11, (v))
/* <<<FC_UCAST_FLOW_CONTEXT_ETH_XTM_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1 	;
        uint32_t	reserved2 	;
        uint32_t	reserved3 	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_mcast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	chain_idx 	;
#else
        uint32_t	reserved1 	;
        uint32_t	reserved2 	;
        uint16_t	chain_idx 	;
        uint32_t	is_mcast  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3 	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_IS_MCAST_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_IS_MCAST_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_IS_MCAST_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_IS_MCAST_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_IS_MCAST_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_IS_MCAST_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_CHAIN_IDX_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_CHAIN_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 10, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_CHAIN_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 10, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_CHAIN_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT) + 10, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_CHAIN_IDX_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_CHAIN_IDX_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 10, (v))
/* <<<FC_UCAST_FLOW_CONTEXT_WFD_NIC_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_mcast    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wifi_ssid   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_ring_id	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	flow_ring_id	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wifi_ssid   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_mcast    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_IS_MCAST_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_IS_MCAST_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_IS_MCAST_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_IS_MCAST_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_IS_MCAST_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_IS_MCAST_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_WIFI_SSID_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 2, 4, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_WIFI_SSID_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 2, 4, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_WIFI_SSID_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 2, 4, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_WIFI_SSID_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 2, 4, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_WIFI_SSID_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_WIFI_SSID_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_FLOW_RING_ID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 0, 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_FLOW_RING_ID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 0, 10, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_FLOW_RING_ID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 0, 10, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_FLOW_RING_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT) + 10, 0, 10, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_FLOW_RING_ID_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_FLOW_RING_ID_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 10, (v))
/* <<<FC_UCAST_FLOW_CONTEXT_WFD_DHD_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	llcsnap_flag	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	radio_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wifi_ssid   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_ring_id	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	flow_ring_id	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wifi_ssid   	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	radio_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	llcsnap_flag	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_LLCSNAP_FLAG_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_LLCSNAP_FLAG_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_LLCSNAP_FLAG_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_LLCSNAP_FLAG_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_LLCSNAP_FLAG_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_LLCSNAP_FLAG_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_RADIO_IDX_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 6, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_RADIO_IDX_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 6, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_RADIO_IDX_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_RADIO_IDX_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_RADIO_IDX_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_RADIO_IDX_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_WIFI_SSID_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 2, 4, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_WIFI_SSID_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 2, 4, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_WIFI_SSID_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 2, 4, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_WIFI_SSID_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 2, 4, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_WIFI_SSID_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_WIFI_SSID_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_FLOW_RING_ID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 0, 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_FLOW_RING_ID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 0, 10, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_FLOW_RING_ID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 0, 10, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_FLOW_RING_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT) + 10, 0, 10, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_FLOW_RING_ID_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_FLOW_RING_ID_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 10, (v))
/* <<<FC_UCAST_FLOW_CONTEXT_RNR_DHD_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint32_t	reserved3   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_priority	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	gdx_ctx_data	;
#else
        uint32_t	reserved1   	;
        uint32_t	reserved2   	;
        uint16_t	gdx_ctx_data	;
        uint32_t	gdx_priority	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_PRIORITY_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_PRIORITY_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_PRIORITY_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_PRIORITY_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_PRIORITY_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_PRIORITY_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_CTX_DATA_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_CTX_DATA_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 10, (v))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_CTX_DATA_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 10, (r), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_CTX_DATA_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT) + 10, (v), core_id)
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_CTX_DATA_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 10, (r))
#define RDD_FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_GDX_CTX_DATA_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 10, (v))
/* <<<FC_UCAST_FLOW_CONTEXT_GDX_ENTRY_STRUCT */


/* >>>FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT */
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_NUMBER	2
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_RESERVED6_NUMBER	100
typedef union
    {
    uint8_t word_8[124];
    uint16_t word_16[62];
    uint32_t word_32[31];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved2                                                                	;
        uint32_t	reserved3                                                                	;
        uint32_t	clients_vector[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_NUMBER];
        uint32_t	fwd_and_trap                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4                                                                	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                                                                	;
        uint8_t	reserved6[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_RESERVED6_NUMBER];
#else
        uint32_t	reserved2                                                                	;
        uint32_t	reserved3                                                                	;
        uint32_t	clients_vector[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_NUMBER];
        uint32_t	reserved4                                                                	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fwd_and_trap                                                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                                                                	;
        uint8_t	reserved6[RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_RESERVED6_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT;

#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_READ_G(r, g, idx, i)                             GROUP_MREAD_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 8, i, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 8, i, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 8, i, (r), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_32((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 8, i, (v), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_READ(r, p, i)                                    MREAD_I_32((uint8_t *)(p) + 8, i, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_CLIENTS_VECTOR_WRITE(v, p, i)                                   MWRITE_I_32((uint8_t *)(p) + 8, i, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (v))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (r), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT) + 16, 7, 1, (v), core_id)
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 16, 7, 1, (r))
#define RDD_FC_UCAST_FLOOD_CONTEXT_ENTRY_FWD_AND_TRAP_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 16, 7, 1, (v))
/* <<<FC_UCAST_FLOOD_CONTEXT_ENTRY_STRUCT */


/* >>>RULE_BASED_CONTEXT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pbit_to_gem              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc_to_q                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	dei                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_value               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd_action            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_based_forward       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gem_mapping_table        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_enable           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	queue_union              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU1_dei                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_gem_mapping_table      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved1              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	queue                              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_common_actions_exit           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU2_dei                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_gem_mapping_table      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved1              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	tc                                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dei                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_gem_mapping_table      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reserved1              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	trap_reason                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved4                	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	to_eth                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	flow                     	;
        uint16_t	rule                     	;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	cntr_id                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_disable             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_mode       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	qos_rule_wan_flow_overrun	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	opbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ipbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	inner_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	service_queue            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved6                	:27	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	queue_union              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	policer_enable           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gem_mapping_table        	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_based_forward       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd_action            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_value               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dscp_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	no_fwd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dei                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	pbit_remark              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tc_to_q                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	pbit_to_gem              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	queue                              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reservedSU1_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reserved1              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_gem_mapping_table      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_dei                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vlan_action                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU1_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	tc                                 	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reserved2                          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reservedSU2_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reserved1              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_gem_mapping_table      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_dei                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iptv_common_actions_exit           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vlan_action_or_iptv_common_actions union */
        uint32_t	reservedSU2_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	trap_reason                        	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reserved3                          	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of queue_union union */
        uint32_t	reservedSU3_policer_enable         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reserved1              	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_gem_mapping_table      	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flow_based_forward     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd_action          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_value             	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dscp_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_no_fwd                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dei                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_vlan_action_or_iptv_common_actions	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_remark            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_to_q              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tc_to_q                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_pbit_to_gem            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	rule                     	;
        uint8_t	flow                     	;
        uint32_t	to_eth                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved4                	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	inner_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	outer_pbit               	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ipbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	opbit_remark_mode        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	qos_rule_wan_flow_overrun	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	policer_id               	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved5                	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_mode       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_disable             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cntr_id                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved6                	:27	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RULE_BASED_CONTEXT_ENTRY_STRUCT;

#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_GEM_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_TO_Q_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_TO_Q_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_PBIT_REMARK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_READ_G(r, g, idx)                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_WRITE_G(v, g, idx)                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_READ_CORE(r, g, idx, core_id)           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_WRITE_CORE(v, g, idx, core_id)          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_READ(r, p)                              RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_OR_IPTV_COMMON_ACTIONS_WRITE(v, p)                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_VLAN_ACTION_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPTV_COMMON_ACTIONS_EXIT_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 2, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DEI_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT), 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_REMARK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 2, 6, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_DSCP_VALUE_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_NO_FWD_ACTION_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 1, 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_BASED_FORWARD_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 5, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 5, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_GEM_MAPPING_TABLE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 5, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 1, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 1, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ENABLE_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 1, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_UNION_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 2, 0, 9, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 9, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QUEUE_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 9, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TC_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 3, 0, 4, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 4, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TRAP_REASON_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 4, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 4, 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 4, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_TO_ETH_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 4, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 5, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_FLOW_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_READ_G(r, g, idx)                                                     GROUP_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_READ(r, p)                                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_RULE_WRITE(v, p)                                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 8, 5, 11, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_READ(r, p)                                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 5, 11, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_ID_WRITE(v, p)                                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 5, 11, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 4, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 4, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_CNTR_DISABLE_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 4, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_MODE_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 1, 7, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 7, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_POLICER_ID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 7, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_QOS_RULE_WAN_FLOW_OVERRUN_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 7, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 7, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OPBIT_REMARK_MODE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 7, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 6, 1, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 6, 1, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_IPBIT_REMARK_MODE_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 6, 1, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 3, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 3, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_OUTER_PBIT_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 3, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 11, 0, 3, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 3, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_INNER_PBIT_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 3, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (v))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (r), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RULE_BASED_CONTEXT_ENTRY_STRUCT) + 12, 3, 5, (v), core_id)
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 3, 5, (r))
#define RDD_RULE_BASED_CONTEXT_ENTRY_SERVICE_QUEUE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 3, 5, (v))
/* <<<RULE_BASED_CONTEXT_ENTRY_STRUCT */


/* >>>CPU_TX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_data1           	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	abs_data0           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn1_or_abs2_or_1588 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ssid                          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	fpm_fallback                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	sbpm_copy                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	bn1_first                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	_ssid                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_fpm_fallback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_sbpm_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	abs2                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint16_t	reserved2                     	; /* Member of bn1_or_abs2_or_1588 union */
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buffer_number_0_or_abs_0	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop                           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn0_first                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs1                          	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	abs0                          	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	abs_data1           	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs_data0           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_or_abs2_or_1588 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                     	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	sbpm_copy                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	fpm_fallback                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	ssid                          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	reservedSU1_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs2                          	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_sbpm_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_fpm_fallback                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	_ssid                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	reservedSU2_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	data_1588                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	reservedSU3_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint16_t	reserved2                     	; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	lag_index                     	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs2_or_1588 union */
        uint32_t	reservedSU4_wan_flow_source_port	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_do_not_recycle    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_drop              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0_or_abs_0	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	payload_offset_or_abs_1	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn0_first                     	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop                           	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU1_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs0                          	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	abs1                          	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU2_abs               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_CPU_TX_DESCRIPTOR_VALID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_VALID_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_VALID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 0, 0, 22, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 0, 22, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA1_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 0, 22, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_DATA0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_CPU_TX_DESCRIPTOR_DROP_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_DROP_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DROP_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DROP_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DROP_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_LAN_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_LAN_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_LAN_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_LAN_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_READ(r, p)                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_OR_ABS2_OR_1588_WRITE(v, p)                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                                       RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                                      RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR__SSID_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR__SSID_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR__SSID_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SSID_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SSID_READ(r, p)                                                      RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_CPU_TX_DESCRIPTOR__SSID_WRITE(v, p)                                                     RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__FPM_FALLBACK_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 4, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 4, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR__SBPM_COPY_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 4, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS2_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS2_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS2_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 8, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_LAG_INDEX_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_AGG_PD_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_G(r, g, idx)                             GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_G(v, g, idx)                            GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_CORE(r, g, idx, core_id)                 CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_CORE(v, g, idx, core_id)                CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ(r, p)                                    RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE(v, p)                                   RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_SOP_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_SOP_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SOP_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_SOP_READ(r, p)                                                        RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_SOP_WRITE(v, p)                                                       RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS1_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS1_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS1_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_G(r, g, idx)                            GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_G(v, g, idx)                           GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_CORE(r, g, idx, core_id)                CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_CORE(v, g, idx, core_id)               CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ(r, p)                                   RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE(v, p)                                  RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_READ(r, p)                                                  RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                                                 RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS0_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_CPU_TX_DESCRIPTOR_ABS0_READ(r, p)                                                       RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_CPU_TX_DESCRIPTOR_ABS0_WRITE(v, p)                                                      RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
/* <<<CPU_TX_DESCRIPTOR_STRUCT */


/* >>>TC_TO_QUEUE_8_STRUCT */
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_NUMBER	8
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint8_t queue_offset[8];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TC_TO_QUEUE_8_STRUCT;

#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (r))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (v))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (r), core_id)
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_8_STRUCT), i, (v), core_id)
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_TC_TO_QUEUE_8_QUEUE_OFFSET_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<TC_TO_QUEUE_8_STRUCT */


/* >>>TC_TO_QUEUE_32_STRUCT */
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_NUMBER	32
typedef union
    {
    uint8_t word_8[32];
    uint16_t word_16[16];
    uint32_t word_32[8];
    uint64_t dword_64[4];
        struct {
        uint8_t queue_offset[32];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TC_TO_QUEUE_32_STRUCT;

#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_READ_G(r, g, idx, i)                             GROUP_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (r))
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_WRITE_G(v, g, idx, i)                            GROUP_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (v))
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_READ_CORE(r, g, idx, i, core_id)                 CORE_MREAD_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (r), core_id)
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_WRITE_CORE(v, g, idx, i, core_id)                CORE_MWRITE_I_8((g), (idx)*sizeof(TC_TO_QUEUE_32_STRUCT), i, (v), core_id)
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_READ(r, p, i)                                    MREAD_I_8((uint8_t *)(p), i, (r))
#define RDD_TC_TO_QUEUE_32_QUEUE_OFFSET_WRITE(v, p, i)                                   MWRITE_I_8((uint8_t *)(p), i, (v))
/* <<<TC_TO_QUEUE_32_STRUCT */


/* >>>VPORT_CFG_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	loopback_en                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_en                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_isolation_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_and_vlan_ingress_lookup_method	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
        uint32_t	bridge_and_vlan_egress_lookup_method 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
        uint32_t	protocol_filters_dis                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	da_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	congestion_flow_control              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	discard_prty                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	natc_tbl_id                          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ls_fc_cfg                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_map                 	;
#else
        uint32_t	ls_fc_cfg                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	natc_tbl_id                          	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved3                            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_whitelist_skip                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ingress_filter_profile               	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	discard_prty                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	congestion_flow_control              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	sa_lookup_miss_action                	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_action enumeration*/
        uint32_t	protocol_filters_dis                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bridge_and_vlan_egress_lookup_method 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
        uint32_t	bridge_and_vlan_ingress_lookup_method	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
        uint32_t	ingress_isolation_en                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_en                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	da_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sa_lookup_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mirroring_en                         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	loopback_en                          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_isolation_map                 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) VPORT_CFG_ENTRY_STRUCT;

#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_READ_G(r, g, idx)                                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_WRITE_G(v, g, idx)                                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_READ_CORE(r, g, idx, core_id)                                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_WRITE_CORE(v, g, idx, core_id)                                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_READ(r, p)                                                                 RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_LOOPBACK_EN_WRITE(v, p)                                                                RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MIRRORING_EN_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_EN_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_EN_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 3, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_EN_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 2, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_ISOLATION_EN_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (r), core_id) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 1, 1, (v), core_id) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_INGRESS_LOOKUP_METHOD_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_ingress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (r), core_id) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT), 0, 1, (v), core_id) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_BRIDGE_AND_VLAN_EGRESS_LOOKUP_METHOD_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v)) /*defined by rdd_bridge_and_vlan_ctx_egress_lookup_method enumeration*/
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 4, 4, (r))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 4, 4, (v))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 4, 4, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 4, 4, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 4, (r))
#define RDD_VPORT_CFG_ENTRY_PROTOCOL_FILTERS_DIS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 4, (v))
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 2, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 2, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 2, 2, (r), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 2, 2, (v), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 2, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_SA_LOOKUP_MISS_ACTION_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 2, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 0, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 0, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 0, 2, (r), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 1, 0, 2, (v), core_id) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_READ(r, p)                                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_DA_LOOKUP_MISS_ACTION_WRITE(v, p)                                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v)) /*defined by rdd_action enumeration*/
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 7, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 7, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_CONGESTION_FLOW_CONTROL_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 6, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 6, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 6, 1, (r))
#define RDD_VPORT_CFG_ENTRY_DISCARD_PRTY_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 6, 1, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 0, 6, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 0, 6, (v))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 0, 6, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 2, 0, 6, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 2, 0, 6, (r))
#define RDD_VPORT_CFG_ENTRY_INGRESS_FILTER_PROFILE_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 2, 0, 6, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 7, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 7, 1, (r))
#define RDD_VPORT_CFG_ENTRY_MCAST_WHITELIST_SKIP_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 7, 1, (v))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_READ_G(r, g, idx)                                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 1, 3, (r))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_WRITE_G(v, g, idx)                                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 1, 3, (v))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_READ_CORE(r, g, idx, core_id)                                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 1, 3, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_WRITE_CORE(v, g, idx, core_id)                                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 1, 3, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_READ(r, p)                                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 3, (r))
#define RDD_VPORT_CFG_ENTRY_NATC_TBL_ID_WRITE(v, p)                                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 3, (v))
#define RDD_VPORT_CFG_ENTRY_LS_FC_CFG_READ_G(r, g, idx)                                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 1, (r))
#define RDD_VPORT_CFG_ENTRY_LS_FC_CFG_WRITE_G(v, g, idx)                                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 1, (v))
#define RDD_VPORT_CFG_ENTRY_LS_FC_CFG_READ_CORE(r, g, idx, core_id)                                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 1, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_LS_FC_CFG_WRITE_CORE(v, g, idx, core_id)                                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 3, 0, 1, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_LS_FC_CFG_READ(r, p)                                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 0, 1, (r))
#define RDD_VPORT_CFG_ENTRY_LS_FC_CFG_WRITE(v, p)                                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 0, 1, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(VPORT_CFG_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_VPORT_CFG_ENTRY_EGRESS_ISOLATION_MAP_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<VPORT_CFG_ENTRY_STRUCT */


/* >>>FPM_GLOBAL_CFG_STRUCT */
typedef union
    {
    uint8_t word_8[20];
    uint16_t word_16[10];
    uint32_t word_32[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint16_t	fpm_token_size     	;
        uint8_t	fpm_token_shift    	;
        uint8_t	fpm_token_add_shift	;
        uint16_t	fpm_token_inv_mant 	;
        uint8_t	fpm_token_inv_exp  	;
        uint8_t	reserved1          	;
        uint8_t	fpm_token_num_pool0	;
        uint8_t	fpm_token_num_pool1	;
        uint8_t	fpm_token_num_pool2	;
        uint8_t	fpm_token_num_pool3	;
#else
        uint32_t	fpm_base_low       	;
        uint32_t	fpm_base_high      	;
        uint8_t	fpm_token_add_shift	;
        uint8_t	fpm_token_shift    	;
        uint16_t	fpm_token_size     	;
        uint8_t	reserved1          	;
        uint8_t	fpm_token_inv_exp  	;
        uint16_t	fpm_token_inv_mant 	;
        uint8_t	fpm_token_num_pool3	;
        uint8_t	fpm_token_num_pool2	;
        uint8_t	fpm_token_num_pool1	;
        uint8_t	fpm_token_num_pool0	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) FPM_GLOBAL_CFG_STRUCT;

#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT), (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_READ(r, p)                                              MREAD_32((uint8_t *)(p), (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_LOW_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p), (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 4, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_BASE_HIGH_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 8, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SIZE_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 8, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 10, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_SHIFT_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 11, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_ADD_SHIFT_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 12, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 12, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_MANT_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 12, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 14, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 14, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_INV_EXP_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 14, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 16, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 16, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL0_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 16, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 17, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 17, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL1_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 17, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 18, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL2_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 18, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (v))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (r), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FPM_GLOBAL_CFG_STRUCT) + 19, (v), core_id)
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 19, (r))
#define RDD_FPM_GLOBAL_CFG_FPM_TOKEN_NUM_POOL3_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 19, (v))
/* <<<FPM_GLOBAL_CFG_STRUCT */


/* >>>DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	next_sched	;
        uint8_t	status    	;
#else
        uint8_t	status    	;
        uint8_t	next_sched	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT;

#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_NEXT_SCHED_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT), (r))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_NEXT_SCHED_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT), (v))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_NEXT_SCHED_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT), (r), core_id)
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_NEXT_SCHED_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT), (v), core_id)
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_NEXT_SCHED_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_NEXT_SCHED_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_STATUS_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT) + 1, (r))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_STATUS_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT) + 1, (v))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_STATUS_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_STATUS_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_STATUS_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_DS_TM_EGRESS_PORT_RR_ENTRY_STATUS_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<DS_TM_EGRESS_PORT_RR_ENTRY_STRUCT */


/* >>>QM_QUEUE_COUNTER_DATA_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
        uint32_t	packets   	;
        uint32_t	bytes     	;
        uint32_t	reserved0 	;
        uint32_t	reserved1 	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) QM_QUEUE_COUNTER_DATA_STRUCT;

#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (r), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT), (v), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_READ(r, p)                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_QM_QUEUE_COUNTER_DATA_PACKETS_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (v))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (r), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(QM_QUEUE_COUNTER_DATA_STRUCT) + 4, (v), core_id)
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_QM_QUEUE_COUNTER_DATA_BYTES_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<QM_QUEUE_COUNTER_DATA_STRUCT */


/* >>>DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	port_sel  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pkt_eop   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	frag_size 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	frag_size 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pkt_eop   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved0 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	port_sel  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT;

#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PORT_SEL_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 7, 1, (r))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PORT_SEL_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 7, 1, (v))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PORT_SEL_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PORT_SEL_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PORT_SEL_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PORT_SEL_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PKT_EOP_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 4, 1, (r))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PKT_EOP_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 4, 1, (v))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PKT_EOP_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PKT_EOP_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PKT_EOP_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_PKT_EOP_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_FRAG_SIZE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 0, 12, (r))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_FRAG_SIZE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 0, 12, (v))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_FRAG_SIZE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 0, 12, (r), core_id)
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_FRAG_SIZE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT), 0, 12, (v), core_id)
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_FRAG_SIZE_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_DSL_PTM_BOND_TX_HDR_ENTRY_FRAG_SIZE_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<DSL_PTM_BOND_TX_HDR_ENTRY_STRUCT */


/* >>>FLUSH_CFG_ENABLE_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	enable_fw 	;
        uint8_t	enable_cpu	;
#else
        uint8_t	enable_cpu	;
        uint8_t	enable_fw 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) FLUSH_CFG_ENABLE_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ_G(r, g, idx)                                 GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE_G(v, g, idx)                                GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (r), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT), (v), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_READ(r, p)                                        MREAD_8((uint8_t *)(p), (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_FW_WRITE(v, p)                                       MWRITE_8((uint8_t *)(p), (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENABLE_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENABLE_ENTRY_ENABLE_CPU_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<FLUSH_CFG_ENABLE_ENTRY_STRUCT */


/* >>>FLUSH_CFG_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pd_num            	;
        uint8_t	flush_aggr        	;
        uint8_t	qm_queue          	;
        uint32_t	ug_counter_address	;
        uint32_t	ug_threshold_low  	;
        uint32_t	ug_counter        	;
#else
        uint8_t	qm_queue          	;
        uint8_t	flush_aggr        	;
        uint8_t	pd_num            	;
        uint32_t	reserved          	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	buffer_cong_mgt   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	hw_flush_en       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drain_q           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	enable            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ug_counter_address	;
        uint32_t	ug_threshold_low  	;
        uint32_t	ug_counter        	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) FLUSH_CFG_ENTRY_STRUCT;

#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_ENABLE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_ENABLE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 6, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_DRAIN_Q_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 5, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_HW_FLUSH_EN_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT), 4, 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_READ(r, p)                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_FLUSH_CFG_ENTRY_BUFFER_CONG_MGT_WRITE(v, p)                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 1, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_FLUSH_CFG_ENTRY_PD_NUM_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_FLUSH_CFG_ENTRY_FLUSH_AGGR_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 3, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_FLUSH_CFG_ENTRY_QM_QUEUE_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_ADDRESS_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_THRESHOLD_LOW_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (v))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(FLUSH_CFG_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_FLUSH_CFG_ENTRY_UG_COUNTER_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<FLUSH_CFG_ENTRY_STRUCT */


/* >>>PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	is_mcast              	;
        uint16_t	clients_size_in_word  	;
        uint16_t	exception_drop_cntr_id	;
        uint16_t	flow_miss_drop_cntr_id	;
        uint32_t	reg_bck_up_0          	;
        uint32_t	reg_bck_up_1          	;
#else
        uint16_t	clients_size_in_word  	;
        uint16_t	is_mcast              	;
        uint16_t	flow_miss_drop_cntr_id	;
        uint16_t	exception_drop_cntr_id	;
        uint32_t	reg_bck_up_0          	;
        uint32_t	reg_bck_up_1          	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT;

#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_READ_G(r, g, idx)                                              GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_WRITE_G(v, g, idx)                                             GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT), (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_READ(r, p)                                                     MREAD_16((uint8_t *)(p), (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_IS_MCAST_WRITE(v, p)                                                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_CLIENTS_SIZE_IN_WORD_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_EXCEPTION_DROP_CNTR_ID_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_FLOW_MISS_DROP_CNTR_ID_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_0_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (v))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PROCESSING_GROUP_PARAMS_GEN4_ENTRY_REG_BCK_UP_1_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 12, (v))
/* <<<PROCESSING_GROUP_PARAMS_GEN4_ENTRY_STRUCT */


/* >>>VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
        uint8_t	rl_overhead	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT;

#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (r))
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (v))
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (r), core_id)
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT), (v), core_id)
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_VPORT_TO_RL_OVERHEAD_ENTRY_RL_OVERHEAD_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
/* <<<VPORT_TO_RL_OVERHEAD_ENTRY_STRUCT */


/* >>>DDR_TOKEN_INFO_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	is_xpm_valid 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bufmng_cnt_id	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	pool_id      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	pool_id      	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	bufmng_cnt_id	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	is_xpm_valid 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } DDR_TOKEN_INFO_ENTRY_STRUCT;

#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (r), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 7, 1, (v), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_IS_XPM_VALID_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (r), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 2, 5, (v), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 5, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_BUFMNG_CNT_ID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 5, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (v))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (r), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(DDR_TOKEN_INFO_ENTRY_STRUCT), 0, 2, (v), core_id)
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 2, (r))
#define RDD_DDR_TOKEN_INFO_ENTRY_POOL_ID_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 2, (v))
/* <<<DDR_TOKEN_INFO_ENTRY_STRUCT */


/* >>>ACTION_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	type             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	natc_rollback    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	priority         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint8_t	reason_or_counter	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint16_t	reservedSU1_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU1_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	needed_priority            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	reserved_priority          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint8_t	trap_reason                	; /* Member of reason_or_counter union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	reservedSU2_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_priority       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	drop_counter               	; /* Member of reason_or_counter union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	reason_or_counter	; /* This is a field union */
        uint16_t	priority         	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint16_t	natc_rollback    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	type             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	trap_reason                	; /* Member of reason_or_counter union */
        uint16_t	reserved_priority          	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	needed_priority            	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of priority union */
        uint16_t	reservedSU1_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU1_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	drop_counter               	; /* Member of reason_or_counter union */
        uint16_t	reservedSU2_priority       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_natc_rollback  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reservedSU2_type           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) ACTION_STRUCT;

#define RDD_ACTION_TYPE_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (r))
#define RDD_ACTION_TYPE_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (v))
#define RDD_ACTION_TYPE_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (r), core_id)
#define RDD_ACTION_TYPE_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 6, 2, (v), core_id)
#define RDD_ACTION_TYPE_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 2, (r))
#define RDD_ACTION_TYPE_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 2, (v))
#define RDD_ACTION_NATC_ROLLBACK_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (r))
#define RDD_ACTION_NATC_ROLLBACK_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (v))
#define RDD_ACTION_NATC_ROLLBACK_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (r), core_id)
#define RDD_ACTION_NATC_ROLLBACK_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 5, 1, (v), core_id)
#define RDD_ACTION_NATC_ROLLBACK_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_ACTION_NATC_ROLLBACK_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_ACTION_PRIORITY_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (r))
#define RDD_ACTION_PRIORITY_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (v))
#define RDD_ACTION_PRIORITY_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (r), core_id)
#define RDD_ACTION_PRIORITY_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 0, 5, (v), core_id)
#define RDD_ACTION_PRIORITY_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 5, (r))
#define RDD_ACTION_PRIORITY_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 5, (v))
#define RDD_ACTION_NEEDED_PRIORITY_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (r))
#define RDD_ACTION_NEEDED_PRIORITY_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (v))
#define RDD_ACTION_NEEDED_PRIORITY_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (r), core_id)
#define RDD_ACTION_NEEDED_PRIORITY_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT), 2, 3, (v), core_id)
#define RDD_ACTION_NEEDED_PRIORITY_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 3, (r))
#define RDD_ACTION_NEEDED_PRIORITY_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 3, (v))
#define RDD_ACTION_REASON_OR_COUNTER_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_REASON_OR_COUNTER_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_REASON_OR_COUNTER_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_REASON_OR_COUNTER_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_REASON_OR_COUNTER_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_REASON_OR_COUNTER_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_ACTION_TRAP_REASON_READ_G(r, g, idx)                                      GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_TRAP_REASON_WRITE_G(v, g, idx)                                     GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_TRAP_REASON_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_TRAP_REASON_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_TRAP_REASON_READ(r, p)                                             MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_TRAP_REASON_WRITE(v, p)                                            MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_ACTION_DROP_COUNTER_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r))
#define RDD_ACTION_DROP_COUNTER_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v))
#define RDD_ACTION_DROP_COUNTER_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (r), core_id)
#define RDD_ACTION_DROP_COUNTER_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(ACTION_STRUCT) + 1, (v), core_id)
#define RDD_ACTION_DROP_COUNTER_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_ACTION_DROP_COUNTER_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 1, (v))
/* <<<ACTION_STRUCT */


/* >>>VLAN_TAG_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	pbits     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	cfi       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	vid       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	vid       	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	cfi       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	pbits     	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) VLAN_TAG_STRUCT;

#define RDD_VLAN_TAG_PBITS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (r))
#define RDD_VLAN_TAG_PBITS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (v))
#define RDD_VLAN_TAG_PBITS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (r), core_id)
#define RDD_VLAN_TAG_PBITS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 5, 3, (v), core_id)
#define RDD_VLAN_TAG_PBITS_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 3, (r))
#define RDD_VLAN_TAG_PBITS_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 3, (v))
#define RDD_VLAN_TAG_CFI_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (r))
#define RDD_VLAN_TAG_CFI_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (v))
#define RDD_VLAN_TAG_CFI_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (r), core_id)
#define RDD_VLAN_TAG_CFI_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(VLAN_TAG_STRUCT), 4, 1, (v), core_id)
#define RDD_VLAN_TAG_CFI_READ(r, p)                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_VLAN_TAG_CFI_WRITE(v, p)                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_VLAN_TAG_VID_READ_G(r, g, idx)                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (r))
#define RDD_VLAN_TAG_VID_WRITE_G(v, g, idx)                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (v))
#define RDD_VLAN_TAG_VID_READ_CORE(r, g, idx, core_id)                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (r), core_id)
#define RDD_VLAN_TAG_VID_WRITE_CORE(v, g, idx, core_id)                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(VLAN_TAG_STRUCT), 0, 12, (v), core_id)
#define RDD_VLAN_TAG_VID_READ(r, p)                                         RDP_FIELD_MREAD_16((uint8_t *)(p), 0, 12, (r))
#define RDD_VLAN_TAG_VID_WRITE(v, p)                                        RDP_FIELD_MWRITE_16((uint8_t *)(p), 0, 12, (v))
/* <<<VLAN_TAG_STRUCT */


/* >>>CPU_RECYCLE_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	skb_ptr_low   	;
        uint32_t	reserved0     	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	from_feed_ring	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	skb_ptr_hi    	;
#else
        uint32_t	skb_ptr_low   	;
        uint8_t	skb_ptr_hi    	;
        uint32_t	abs           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	from_feed_ring	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0     	:22	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RECYCLE_DESCRIPTOR_STRUCT;

#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT), (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_READ(r, p)                                          MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_LOW_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 1, 1, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_FROM_FEED_RING_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 6, 0, 1, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 0, 1, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_ABS_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 0, 1, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ_G(r, g, idx)                                    GROUP_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE_G(v, g, idx)                                   GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (v))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (r), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_8((g), (idx)*sizeof(CPU_RECYCLE_DESCRIPTOR_STRUCT) + 7, (v), core_id)
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_READ(r, p)                                           MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RECYCLE_DESCRIPTOR_SKB_PTR_HI_WRITE(v, p)                                          MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RECYCLE_DESCRIPTOR_STRUCT */


/* >>>PROCESSING_CPU_RX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	valid                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	headroom                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	mc_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	force_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	type_or_service_queue_wlan 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reason_or_forwarding       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588_or_dsl_rx        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent_or_forwarding     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	reserved0                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU1_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	type                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	cpu_redirect_0                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_reason                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU1_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	coherent                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	metadata_1_2                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU1_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_chksum_verified                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU2_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	service_queue_is_wlan                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	service_queue_wlan_frw_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	tc                                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	metadata_0_0                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU2_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dsl_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	ucast                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	spdtest_stream_id                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	tcpspdtest_is_upload                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU2_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_redirect_1                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	wan_flow_1                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU3_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU3_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_3_0                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU3_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dhd_flow_priority                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reserved1                            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU4_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	l3_offset                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU5_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	priority                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	packet_length              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	metadata_1_0                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU1_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	spdtest_l3_l4_hdr_len                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU2_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	egress_queue                         	; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	wan_flow_0                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU3_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	gdx_pd_data_13_4                     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint32_t	reservedSU4_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	drop                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	vport                      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid_or_metadata_2_or_cpu_redirect	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	bn1_or_abs3                	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow                                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	ssid                                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	bn1_first                            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	source_port                          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reserved4                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	metadata_2                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved5                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	abs3                                 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	port_id                              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	omci_enc_key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved7                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reservedSU3_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_vport                    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved8                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	is_gdx_rx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	gdx_pd_data_15_14                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reservedSU4_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	agg_pd                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	payload_offset_or_abs_1    	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	buffer_number_0_or_abs_0   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop                                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	bn0_first                            	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	abs1                                 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	abs0                                 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sop_fpm                              	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	fpm_pool                             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint16_t	fpm_num                              	; /* Member of buffer_number_0_or_abs_0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	reserved0                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	coherent_or_forwarding     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	flag_1588_or_dsl_rx        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	first_level_q              	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reason_or_forwarding       	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	type_or_service_queue_wlan 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	force_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reprocess                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mc_copy                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	headroom                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	valid                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_2                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	coherent                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	flag_1588                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU1_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	cpu_reason                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_redirect_0                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	type                                 	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	reservedSU1_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dont_agg                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU1_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tcpspdtest_is_upload                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	spdtest_stream_id                    	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	ucast                                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of coherent_or_forwarding union */
        uint32_t	dsl_rx                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU2_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_0                         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	tc                                   	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	service_queue_wlan_frw_type          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	service_queue_is_wlan                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of type_or_service_queue_wlan union */
        uint32_t	reservedSU2_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_chksum_verified                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of dont_agg_or_is_chksum_verified union */
        uint32_t	reservedSU2_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_3_0                      	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of metadata_1_2_or_spdtest_stream_id union */
        uint32_t	reservedSU3_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_gdx_tx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of flag_1588_or_dsl_rx union */
        uint32_t	reservedSU3_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_1                           	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	cpu_redirect_1                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU3_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                            	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	dhd_flow_priority                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU4_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 5 */
		struct{
        uint32_t	reservedSU5_reserved0                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_metadata_1_2_or_spdtest_stream_id	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_coherent_or_forwarding   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_flag_1588_or_dsl_rx      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_first_level_q            	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_offset                            	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reserved2                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of reason_or_forwarding union */
        uint32_t	reservedSU5_type_or_service_queue_wlan	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_force_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_color                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_reprocess                	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_mc_copy                  	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_dont_agg_or_is_chksum_verified	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_headroom                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU5_valid                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	packet_length              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn_num                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	priority                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_0                         	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	spdtest_l3_l4_hdr_len                	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_0                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
        uint8_t	egress_queue                         	; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_packet_length            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_bn_num                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_priority                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_13_4                     	:10	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of num_of_avail_dhd_repl_or_metadata_1_or_cpu_redirect union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	bn1_or_abs3                	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	ssid_or_metadata_2_or_cpu_redirect	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	vport                      	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_1_1               	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	metadata_0_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_1               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	drop                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn1_first                            	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	ssid                                 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	flow                                 	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reservedSU1_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs3                                 	:12	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	reserved5                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of bn1_or_abs3 union */
        uint32_t	metadata_2                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved4                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	source_port                          	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reservedSU2_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved7                            	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	omci_enc_key_index                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	port_id                              	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	is_vport                             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of vport union */
        uint32_t	reservedSU3_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 4 */
		struct{
        uint32_t	reservedSU4_bn1_or_abs3              	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_15_14                    	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	is_gdx_rx                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reserved8                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ssid_or_metadata_2_or_cpu_redirect union */
        uint32_t	reservedSU4_vport                    	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_lan                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_1_1             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_metadata_0_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_target_mem_1             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU4_drop                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	buffer_number_0_or_abs_0   	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	payload_offset_or_abs_1    	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	agg_pd                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	bn0_first                            	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop                                  	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU1_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	abs0                                 	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	abs1                                 	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU2_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint16_t	fpm_num                              	; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	fpm_pool                             	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of buffer_number_0_or_abs_0 union */
        uint32_t	sop_fpm                              	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of payload_offset_or_abs_1 union */
        uint32_t	reservedSU3_abs                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_target_mem_0             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_agg_pd                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PROCESSING_CPU_RX_DESCRIPTOR_STRUCT;

#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VALID_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_HEADROOM_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ_G(r, g, idx)                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE_G(v, g, idx)                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ_CORE(r, g, idx, core_id)                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE_CORE(v, g, idx, core_id)                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_READ(r, p)                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_OR_IS_CHKSUM_VERIFIED_WRITE(v, p)                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DONT_AGG_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_CHKSUM_VERIFIED_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 4, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_READ(r, p)                                                           RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_MC_COPY_WRITE(v, p)                                                          RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 3, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REPROCESS_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COLOR_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FORCE_COPY_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_READ(r, p)                                        RDP_FIELD_MREAD_16((uint8_t *)(p), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_OR_SERVICE_QUEUE_WLAN_WRITE(v, p)                                       RDP_FIELD_MWRITE_16((uint8_t *)(p), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 7, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 7, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TYPE_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 7, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT), 0, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_IS_WLAN_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SERVICE_QUEUE_WLAN_FRW_TYPE_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_REASON_OR_FORWARDING_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_0_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REASON_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 4, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 4, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TC_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 4, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_CPU_REDIRECT_1_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_1_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 5, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 5, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DHD_FLOW_PRIORITY_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 5, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 1, 0, 6, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 6, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_L3_OFFSET_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 6, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 2, 7, 9, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 7, 9, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 7, 9, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_G(r, g, idx)                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_G(v, g, idx)                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ_CORE(r, g, idx, core_id)                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_READ(r, p)                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_OR_DSL_RX_WRITE(v, p)                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DSL_RX_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_TX_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_OR_FORWARDING_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_COHERENT_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_UCAST_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_READ(r, p)                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_OR_SPDTEST_STREAM_ID_WRITE(v, p)                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_2_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 2, 3, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 2, 3, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_STREAM_ID_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 2, 3, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_READ(r, p)                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TCPSPDTEST_IS_UPLOAD_WRITE(v, p)                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 3, 1, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 3, 1, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_3_0_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 3, 1, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ_G(r, g, idx)        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE_G(v, g, idx)       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ_CORE(r, g, idx, core_id)CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE_CORE(v, g, idx, core_id)CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_READ(r, p)               RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_NUM_OF_AVAIL_DHD_REPL_OR_METADATA_1_OR_CPU_REDIRECT_WRITE(v, p)              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_READ(r, p)                                                      RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_READ(r, p)                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SPDTEST_L3_L4_HDR_LEN_WRITE(v, p)                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_EGRESS_QUEUE_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_WAN_FLOW_0_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 6, 10, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 4, 6, 10, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_13_4_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 4, 6, 10, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 5, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 5, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PRIORITY_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 5, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 4, 14, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_READ(r, p)                                                            RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN_NUM_WRITE(v, p)                                                           RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 6, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                                     RDP_FIELD_MREAD_16((uint8_t *)(p) + 6, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                                    RDP_FIELD_MWRITE_16((uint8_t *)(p) + 6, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_DROP_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_0_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 3, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_1_1_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 2, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_LAN_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 2, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_READ(r, p)                                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_VPORT_WRITE(v, p)                                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FLOW_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 8, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 8, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOURCE_PORT_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 8, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 1, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 1, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 1, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 2, 7, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 2, 7, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PORT_ID_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 2, 7, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_READ_G(r, g, idx)                         GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_WRITE_G(v, g, idx)                        GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_READ_CORE(r, g, idx, core_id)             CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_WRITE_CORE(v, g, idx, core_id)            CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_READ(r, p)                                RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_OR_METADATA_2_OR_CPU_REDIRECT_WRITE(v, p)                               RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 8, 14, 4, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_READ(r, p)                                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 8, 14, 4, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SSID_WRITE(v, p)                                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 8, 14, 4, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_METADATA_2_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_OMCI_ENC_KEY_INDEX_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_IS_GDX_RX_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_GDX_PD_DATA_15_14_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ_G(r, g, idx)                                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE_G(v, g, idx)                                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ_CORE(r, g, idx, core_id)                                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE_CORE(v, g, idx, core_id)                                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_READ(r, p)                                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_OR_ABS3_WRITE(v, p)                                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_READ(r, p)                                                         RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN1_FIRST_WRITE(v, p)                                                        RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 10, 0, 12, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 10, 0, 12, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS3_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 10, 0, 12, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 7, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 7, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_AGG_PD_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 7, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 6, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 6, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 6, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 5, 1, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_READ(r, p)                                                               RDP_FIELD_MREAD_8((uint8_t *)(p) + 12, 5, 1, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS_WRITE(v, p)                                                              RDP_FIELD_MWRITE_8((uint8_t *)(p) + 12, 5, 1, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_READ(r, p)                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_PAYLOAD_OFFSET_OR_ABS_1_WRITE(v, p)                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ_G(r, g, idx)                                                        GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE_G(v, g, idx)                                                       GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ_CORE(r, g, idx, core_id)                                            CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE_CORE(v, g, idx, core_id)                                           CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_READ(r, p)                                                               RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_WRITE(v, p)                                                              RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_READ(r, p)                                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS1_WRITE(v, p)                                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ_G(r, g, idx)                                                    GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE_G(v, g, idx)                                                   GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ_CORE(r, g, idx, core_id)                                        CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE_CORE(v, g, idx, core_id)                                       CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_READ(r, p)                                                           RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_SOP_FPM_WRITE(v, p)                                                          RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_READ(r, p)                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BUFFER_NUMBER_0_OR_ABS_0_WRITE(v, p)                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_READ(r, p)                                                         RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_BN0_FIRST_WRITE(v, p)                                                        RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_READ(r, p)                                                              RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_ABS0_WRITE(v, p)                                                             RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 2, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_POOL_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 2, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ_G(r, g, idx)                                                    GROUP_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (r), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_16((g), (idx)*sizeof(PROCESSING_CPU_RX_DESCRIPTOR_STRUCT) + 14, (v), core_id)
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_READ(r, p)                                                           MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_PROCESSING_CPU_RX_DESCRIPTOR_FPM_NUM_WRITE(v, p)                                                          MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<PROCESSING_CPU_RX_DESCRIPTOR_STRUCT */


/* >>>CPU_RX_METER_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	current_budget  	;
        uint16_t	budget_limit    	;
        uint16_t	allocated_budget	;
        uint8_t	budget_residue  	;
        uint8_t	current_cycle   	;
#else
        uint16_t	budget_limit    	;
        uint16_t	current_budget  	;
        uint8_t	current_cycle   	;
        uint8_t	budget_residue  	;
        uint16_t	allocated_budget	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_RX_METER_ENTRY_STRUCT;

#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_READ(r, p)                                         MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_BUDGET_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_READ(r, p)                                           MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_LIMIT_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_RX_METER_ENTRY_ALLOCATED_BUDGET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 6, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_CPU_RX_METER_ENTRY_BUDGET_RESIDUE_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_G(r, g, idx)                                   GROUP_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_G(v, g, idx)                                  GROUP_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (r), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_8((g), (idx)*sizeof(CPU_RX_METER_ENTRY_STRUCT) + 7, (v), core_id)
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_READ(r, p)                                          MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_CPU_RX_METER_ENTRY_CURRENT_CYCLE_WRITE(v, p)                                         MWRITE_8((uint8_t *)(p) + 7, (v))
/* <<<CPU_RX_METER_ENTRY_STRUCT */


/* >>>CPU_REDIRECT_MODE_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[1];
        struct {
        uint8_t	mode      	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } CPU_REDIRECT_MODE_ENTRY_STRUCT;

#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(CPU_REDIRECT_MODE_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_CPU_REDIRECT_MODE_ENTRY_MODE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
/* <<<CPU_REDIRECT_MODE_ENTRY_STRUCT */


/* >>>UDPSPDT_STREAM_RX_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[48];
    uint16_t word_16[24];
    uint32_t word_32[12];
    uint64_t dword_64[6];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_packets_0            	;
        uint32_t	rx_packets_1            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_0               	;
        uint32_t	ts_last_1               	;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_proto_cntr          	;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_out_of_order_0	;
        uint32_t	iperf3_rx_out_of_order_1	;
#else
        uint32_t	rx_bytes_0              	;
        uint32_t	rx_bytes_1              	;
        uint32_t	rx_packets_0            	;
        uint32_t	rx_packets_1            	;
        uint32_t	ts_first                	;
        uint32_t	ts_last_0               	;
        uint32_t	ts_last_1               	;
        uint16_t	bad_proto_cntr          	;
        uint32_t	reserved                	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_rx_packet_lost_0 	;
        uint32_t	iperf3_rx_packet_lost_1 	;
        uint32_t	iperf3_rx_out_of_order_0	;
        uint32_t	iperf3_rx_out_of_order_1	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_STREAM_RX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT), (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_READ(r, p)                                                     MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_0_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_BYTES_1_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_0_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_RX_PACKETS_1_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_0_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 24, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_LAST_1_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 28, 7, 1, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 28, 7, 1, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_TS_FIRST_SET_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 28, 7, 1, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 30, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 32, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_0_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 36, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_PACKET_LOST_1_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 40, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (r), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_RX_STAT_STRUCT) + 44, (v), core_id)
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_UDPSPDT_STREAM_RX_STAT_IPERF3_RX_OUT_OF_ORDER_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<UDPSPDT_STREAM_RX_STAT_STRUCT */


/* >>>SPDSVC_RX_TS_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[12];
    uint16_t word_16[6];
    uint32_t word_32[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	ts_first    	;
        uint32_t	ts_last     	;
        uint32_t	ts_first_set	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved    	:31	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDSVC_RX_TS_STAT_STRUCT;

#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT), (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_READ(r, p)                                           MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_LAST_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (r), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDSVC_RX_TS_STAT_STRUCT) + 11, 0, 1, (v), core_id)
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 11, 0, 1, (r))
#define RDD_SPDSVC_RX_TS_STAT_TS_FIRST_SET_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 11, 0, 1, (v))
/* <<<SPDSVC_RX_TS_STAT_STRUCT */


/* >>>RING_CPU_TX_DESCRIPTOR_STRUCT */
typedef union
    {
    uint8_t word_8[16];
    uint16_t word_16[8];
    uint32_t word_32[4];
    uint64_t dword_64[2];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	is_egress                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_or_ingress_1       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	packet_length             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	sk_buf_ptr_high           	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q                       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU1_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU1_sk_buf_ptr_high         	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_8_0                     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU2_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	reservedSU2_sk_buf_ptr_high         	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                      	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	data_1588                           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	bufmng_cnt_id                       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	reserved1                           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lan                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	fpm_fallback              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	sbpm_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tgtmem_or_l3pkt           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	abs                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	ingress_or_egress_0       	; /* This is a field union */
        uint8_t	pkt_buf_ptr_high          	;
		};
		/* Sub Union 1 */
		struct{
        uint32_t	reservedSU1_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU1_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	lag_index                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	ssid                                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	egress_dont_drop                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reserved                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint8_t	reservedSU1_pkt_buf_ptr_high        	;
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reservedSU2_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_vport                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	flow_or_port_id                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_packet                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU2_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	mcast_or_bcast                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	bcast                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reserved_ingress_or_egress          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint8_t	reservedSU2_pkt_buf_ptr_high        	;
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reservedSU3_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tgtmem_or_l3pkt         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_15_9                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	is_gdx_rx                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint8_t	reservedSU3_pkt_buf_ptr_high        	;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low                     	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved0                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_bn0                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 3 */
		struct{
        uint32_t	reserved2                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_pool                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint16_t	bn_fpm_num                          	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	sk_buf_ptr_high           	;
        uint32_t	packet_length             	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	egress_or_ingress_1       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	is_egress                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_sk_buf_ptr_high         	;
        uint32_t	reservedSU1_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_level_q                       	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU1_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_sk_buf_ptr_high         	;
        uint32_t	reservedSU2_packet_length           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	gdx_pd_data_8_0                     	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of egress_or_ingress_1 union */
        uint32_t	reservedSU2_is_egress               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	sk_buf_ptr_low_or_data_1588	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	sk_buf_ptr_low                      	; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	reserved1                           	:9	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	bufmng_cnt_id                       	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
        uint32_t	data_1588                           	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of sk_buf_ptr_low_or_data_1588 union */
		};
	};
	/* Union WORD 2 */
	union{
		/* Sub Union 0 */
		struct{
        uint8_t	pkt_buf_ptr_high          	;
        uint8_t	ingress_or_egress_0       	; /* This is a field union */
        uint32_t	abs                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	tgtmem_or_l3pkt           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	sbpm_copy                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_fallback              	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* This is a field union */
        uint32_t	lan                       	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flag_1588                 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	do_not_recycle            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	color                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 1 */
		struct{
        uint8_t	reservedSU1_pkt_buf_ptr_high        	;
        uint32_t	reserved                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	egress_dont_drop                    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	ssid                                	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	lag_index                           	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU1_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	target_mem_0                        	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU1_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	wan_flow_source_port                	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU1_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU1_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 2 */
		struct{
        uint8_t	reservedSU2_pkt_buf_ptr_high        	;
        uint32_t	reserved_ingress_or_egress          	:6	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	bcast                               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	mcast_or_bcast                      	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU2_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	l3_packet                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of tgtmem_or_l3pkt union */
        uint32_t	reservedSU2_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	flow_or_port_id                     	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	is_vport                            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of wan_flow_source_port_union union */
        uint32_t	reservedSU2_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU2_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
		/* Sub Union 3 */
		struct{
        uint8_t	reservedSU3_pkt_buf_ptr_high        	;
        uint32_t	is_gdx_rx                           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	gdx_pd_data_15_9                    	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of ingress_or_egress_0 union */
        uint32_t	reservedSU3_abs                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_tgtmem_or_l3pkt         	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_sbpm_copy               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_fpm_fallback            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_wan_flow_source_port_union	:8	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_lan                     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_flag_1588               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_do_not_recycle          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reservedSU3_color                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
		};
	};
	/* Union WORD 3 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	pkt_buf_ptr_low_or_fpm_bn0	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint32_t	pkt_buf_ptr_low                     	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 2 */
		struct{
        uint32_t	fpm_bn0                             	:18	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	fpm_sop                             	:11	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved0                           	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
		/* Sub Union 3 */
		struct{
        uint16_t	bn_fpm_num                          	; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	bn_fpm_pool                         	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
        uint32_t	reserved2                           	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__; /* Member of pkt_buf_ptr_low_or_fpm_bn0 union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) RING_CPU_TX_DESCRIPTOR_STRUCT;

#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_EGRESS_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_OR_INGRESS_1_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_READ(r, p)                                                    RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FIRST_LEVEL_Q_WRITE(v, p)                                                   RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT), 6, 9, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p), 6, 9, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_8_0_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p), 6, 9, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 0, 8, 14, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_READ(r, p)                                                    RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 8, 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PACKET_LENGTH_WRITE(v, p)                                                   RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 8, 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 3, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_HIGH_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_G(r, g, idx)                               GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_G(v, g, idx)                              GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ_CORE(r, g, idx, core_id)                   CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                  CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_READ(r, p)                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_OR_DATA_1588_WRITE(v, p)                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SK_BUF_PTR_LOW_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 4, 14, 18, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_READ(r, p)                                                        RDP_FIELD_MREAD_32((uint8_t *)(p) + 4, 14, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DATA_1588_WRITE(v, p)                                                       RDP_FIELD_MWRITE_32((uint8_t *)(p) + 4, 14, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 6, 1, 5, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 6, 1, 5, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BUFMNG_CNT_ID_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 6, 1, 5, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_COLOR_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 6, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_DO_NOT_RECYCLE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 5, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 5, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLAG_1588_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 5, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 4, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAN_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 4, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_UNION_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 8, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_READ(r, p)                                             RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 8, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_WAN_FLOW_SOURCE_PORT_WRITE(v, p)                                            RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 8, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 8, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_VPORT_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 8, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 8, 4, 7, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_READ(r, p)                                                  RDP_FIELD_MREAD_16((uint8_t *)(p) + 8, 4, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FLOW_OR_PORT_ID_WRITE(v, p)                                                 RDP_FIELD_MWRITE_16((uint8_t *)(p) + 8, 4, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 3, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 3, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_FALLBACK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 3, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 2, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 2, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SBPM_COPY_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 2, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TGTMEM_OR_L3PKT_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_TARGET_MEM_0_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_L3_PACKET_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_G(r, g, idx)                                                       GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_G(v, g, idx)                                                      GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ_CORE(r, g, idx, core_id)                                           CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE_CORE(v, g, idx, core_id)                                          CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 9, 0, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_READ(r, p)                                                              RDP_FIELD_MREAD_8((uint8_t *)(p) + 9, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_ABS_WRITE(v, p)                                                             RDP_FIELD_MWRITE_8((uint8_t *)(p) + 9, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 10, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_INGRESS_OR_EGRESS_0_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 10, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_LAG_INDEX_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 2, 4, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 2, 4, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_SSID_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 2, 4, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_EGRESS_DONT_DROP_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 7, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 7, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_MCAST_OR_BCAST_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 7, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 6, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 6, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BCAST_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 6, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 1, 7, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 1, 7, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_GDX_PD_DATA_15_9_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 1, 7, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ_G(r, g, idx)                                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE_G(v, g, idx)                                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ_CORE(r, g, idx, core_id)                                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE_CORE(v, g, idx, core_id)                                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 10, 0, 1, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_READ(r, p)                                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 10, 0, 1, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_IS_GDX_RX_WRITE(v, p)                                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 10, 0, 1, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 11, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_HIGH_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_OR_FPM_BN0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_PKT_BUF_PTR_LOW_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 2, 11, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_READ(r, p)                                                          RDP_FIELD_MREAD_16((uint8_t *)(p) + 12, 2, 11, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_SOP_WRITE(v, p)                                                         RDP_FIELD_MWRITE_16((uint8_t *)(p) + 12, 2, 11, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 12, 0, 18, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_READ(r, p)                                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 0, 18, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_FPM_BN0_WRITE(v, p)                                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 0, 18, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 13, 0, 2, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 13, 0, 2, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_POOL_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 13, 0, 2, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ_G(r, g, idx)                                                GROUP_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_G(v, g, idx)                                               GROUP_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (v))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (r), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_16((g), (idx)*sizeof(RING_CPU_TX_DESCRIPTOR_STRUCT) + 14, (v), core_id)
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_READ(r, p)                                                       MREAD_16((uint8_t *)(p) + 14, (r))
#define RDD_RING_CPU_TX_DESCRIPTOR_BN_FPM_NUM_WRITE(v, p)                                                      MWRITE_16((uint8_t *)(p) + 14, (v))
/* <<<RING_CPU_TX_DESCRIPTOR_STRUCT */


/* >>>CPU_TX_RING_INDICES_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	read_idx  	;
        uint16_t	write_idx 	;
#else
        uint16_t	write_idx 	;
        uint16_t	read_idx  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) CPU_TX_RING_INDICES_STRUCT;

#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (r), core_id)
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT), (v), core_id)
#define RDD_CPU_TX_RING_INDICES_READ_IDX_READ(r, p)                                        MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_RING_INDICES_READ_IDX_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (r), core_id)
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_RING_INDICES_STRUCT) + 2, (v), core_id)
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_RING_INDICES_WRITE_IDX_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 2, (v))
/* <<<CPU_TX_RING_INDICES_STRUCT */


/* >>>CPU_TX_SYNC_FIFO_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	write_ptr 	;
        uint16_t	read_ptr  	;
        uint16_t	fifo      	;
        uint16_t	reserved  	;
#else
        uint16_t	read_ptr  	;
        uint16_t	write_ptr 	;
        uint16_t	reserved  	;
        uint16_t	fifo      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_SYNC_FIFO_ENTRY_STRUCT;

#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT), (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_READ(r, p)                                       MREAD_16((uint8_t *)(p), (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_WRITE_PTR_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p), (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_READ_PTR_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(CPU_TX_SYNC_FIFO_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_SYNC_FIFO_ENTRY_FIFO_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<CPU_TX_SYNC_FIFO_ENTRY_STRUCT */


/* >>>CPU_TX_DBG_CNTRS_STRUCT */
#define RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER	5
typedef union
    {
    uint8_t word_8[64];
    uint16_t word_16[32];
    uint32_t word_32[16];
    uint64_t dword_64[8];
        struct {
        uint32_t	sbpm_no_next                                     	;
        uint32_t	sbpm_no_first                                    	;
        uint32_t	tx_flow_disable                                  	;
        uint32_t	no_fpm                                           	;
        uint32_t	task_exit                                        	;
        uint32_t	sync_wait                                        	;
        uint32_t	no_dispatcher_scheduler                          	;
        uint32_t	recycle_fifo_full                                	;
        uint32_t	drop_pkt                                         	;
        uint32_t	task_start                                       	;
        uint32_t	no_fwd                                           	;
        uint32_t	reserved[RDD_CPU_TX_DBG_CNTRS_RESERVED_NUMBER];
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) CPU_TX_DBG_CNTRS_STRUCT;

#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT), (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_READ(r, p)                                                  MREAD_32((uint8_t *)(p), (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_NEXT_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p), (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 4, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_CPU_TX_DBG_CNTRS_SBPM_NO_FIRST_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 8, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_CPU_TX_DBG_CNTRS_TX_FLOW_DISABLE_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 12, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FPM_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 16, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_EXIT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 20, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_CPU_TX_DBG_CNTRS_SYNC_WAIT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 24, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_DISPATCHER_SCHEDULER_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 28, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_CPU_TX_DBG_CNTRS_RECYCLE_FIFO_FULL_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 32, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_CPU_TX_DBG_CNTRS_DROP_PKT_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 36, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_CPU_TX_DBG_CNTRS_TASK_START_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (r), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(CPU_TX_DBG_CNTRS_STRUCT) + 40, (v), core_id)
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_CPU_TX_DBG_CNTRS_NO_FWD_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 40, (v))
/* <<<CPU_TX_DBG_CNTRS_STRUCT */


/* >>>SPDSVC_GEN_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[60];
    uint16_t word_16[30];
    uint32_t word_32[15];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	timer_period      	;
        uint16_t	total_length      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#else
        uint32_t	processing_tx_pd_0	;
        uint32_t	processing_tx_pd_1	;
        uint32_t	reserved0         	;
        uint32_t	reserved1         	;
        uint32_t	reserved2         	;
        uint32_t	reserved3         	;
        uint32_t	processing_tx_pd_2	;
        uint32_t	processing_tx_pd_3	;
        uint32_t	total_copies      	;
        uint32_t	bucket            	;
        uint16_t	total_length      	;
        uint16_t	timer_period      	;
        uint32_t	tx_packets        	;
        uint32_t	tx_dropped        	;
        uint32_t	tokens            	;
        uint32_t	bucket_size       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDSVC_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 24, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_2_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 28, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_SPDSVC_GEN_PARAMS_PROCESSING_TX_PD_3_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 32, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_COPIES_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 36, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 40, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 40, (r))
#define RDD_SPDSVC_GEN_PARAMS_TIMER_PERIOD_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 40, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_G(r, g, idx)                                      GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_G(v, g, idx)                                     GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 42, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_READ(r, p)                                             MREAD_16((uint8_t *)(p) + 42, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOTAL_LENGTH_WRITE(v, p)                                            MWRITE_16((uint8_t *)(p) + 42, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 44, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_PACKETS_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 48, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_SPDSVC_GEN_PARAMS_TX_DROPPED_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 52, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_SPDSVC_GEN_PARAMS_TOKENS_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (r), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_GEN_PARAMS_STRUCT) + 56, (v), core_id)
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_SPDSVC_GEN_PARAMS_BUCKET_SIZE_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 56, (v))
/* <<<SPDSVC_GEN_PARAMS_STRUCT */


/* >>>SPDTEST_GEN_CFG_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	interrupt_id      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved1         	;
#else
        uint16_t	reserved1         	;
        uint32_t	interrupt_id      	:5	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0         	:3	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	iperf3_64bit_pktid	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	not_valid_license 	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_endless_tx     	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_on             	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	test_type         	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) SPDTEST_GEN_CFG_STRUCT;

#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_G(r, g, idx)                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_G(v, g, idx)                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ_CORE(r, g, idx, core_id)                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE_CORE(v, g, idx, core_id)                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 4, 4, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_READ(r, p)                                                RDP_FIELD_MREAD_8((uint8_t *)(p), 4, 4, (r))
#define RDD_SPDTEST_GEN_CFG_TEST_TYPE_WRITE(v, p)                                               RDP_FIELD_MWRITE_8((uint8_t *)(p), 4, 4, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_G(r, g, idx)                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_G(v, g, idx)                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ_CORE(r, g, idx, core_id)                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE_CORE(v, g, idx, core_id)                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 3, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ON_READ(r, p)                                                    RDP_FIELD_MREAD_8((uint8_t *)(p), 3, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ON_WRITE(v, p)                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p), 3, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_G(r, g, idx)                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_G(v, g, idx)                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ_CORE(r, g, idx, core_id)                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE_CORE(v, g, idx, core_id)                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 2, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_READ(r, p)                                            RDP_FIELD_MREAD_8((uint8_t *)(p), 2, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IS_ENDLESS_TX_WRITE(v, p)                                           RDP_FIELD_MWRITE_8((uint8_t *)(p), 2, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 1, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p), 1, 1, (r))
#define RDD_SPDTEST_GEN_CFG_NOT_VALID_LICENSE_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p), 1, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT), 0, 1, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p), 0, 1, (r))
#define RDD_SPDTEST_GEN_CFG_IPERF3_64BIT_PKTID_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p), 0, 1, (v))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ_G(r, g, idx)                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (r))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE_G(v, g, idx)                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (v))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ_CORE(r, g, idx, core_id)                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (r), core_id)
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE_CORE(v, g, idx, core_id)                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(SPDTEST_GEN_CFG_STRUCT) + 1, 0, 5, (v), core_id)
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_READ(r, p)                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 5, (r))
#define RDD_SPDTEST_GEN_CFG_INTERRUPT_ID_WRITE(v, p)                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 5, (v))
/* <<<SPDTEST_GEN_CFG_STRUCT */


/* >>>UDPSPDT_TX_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[24];
    uint16_t word_16[12];
    uint32_t word_32[6];
    uint64_t dword_64[3];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	total_num_of_pkts    	;
        uint16_t	packet_size          	;
        uint16_t	last_packet_size     	;
        uint32_t	curr_bucket          	;
        uint32_t	bucket_budget        	;
        uint32_t	last_packet_start_idx	;
        uint32_t	max_bucket_size      	;
#else
        uint32_t	total_num_of_pkts    	;
        uint16_t	last_packet_size     	;
        uint16_t	packet_size          	;
        uint32_t	curr_bucket          	;
        uint32_t	bucket_budget        	;
        uint32_t	last_packet_start_idx	;
        uint32_t	max_bucket_size      	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_TX_PARAMS_STRUCT;

#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT), (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_READ(r, p)                                           MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_TX_PARAMS_TOTAL_NUM_OF_PKTS_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_TX_PARAMS_PACKET_SIZE_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ_G(r, g, idx)                                     GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE_G(v, g, idx)                                    GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 6, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_READ(r, p)                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_SIZE_WRITE(v, p)                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_TX_PARAMS_CURR_BUCKET_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_TX_PARAMS_BUCKET_BUDGET_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (v))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_TX_PARAMS_LAST_PACKET_START_IDX_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_TX_PARAMS_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_TX_PARAMS_MAX_BUCKET_SIZE_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 20, (v))
/* <<<UDPSPDT_TX_PARAMS_STRUCT */


/* >>>UDPSPDT_STREAM_TX_STAT_STRUCT */
typedef union
    {
    uint8_t word_8[40];
    uint16_t word_16[20];
    uint32_t word_32[10];
    uint64_t dword_64[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	bad_proto_cntr             	;
        uint16_t	time_slice_expire          	;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	tx_packets_1               	;
        uint32_t	tx_packets_0               	;
        uint32_t	tx_drops_no_spbm           	;
        uint32_t	first_ts                   	;
        uint32_t	last_ts_1                  	;
        uint32_t	last_ts_0                  	;
        uint32_t	iperf3_ts_sec              	;
        uint32_t	iperf3_ts_usec             	;
        uint16_t	time_slice_expire          	;
        uint16_t	bad_proto_cntr             	;
        uint32_t	first_ts_set               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved                   	:15	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	tx_drops_no_sbpm_timer_stop	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) UDPSPDT_STREAM_TX_STAT_STRUCT;

#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT), (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_READ(r, p)                                                      MREAD_32((uint8_t *)(p), (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_1_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p), (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 4, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_PACKETS_0_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 8, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SPBM_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 12, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 16, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 20, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_LAST_TS_0_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 24, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_SEC_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 28, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_IPERF3_TS_USEC_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_G(r, g, idx)                                             GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_G(v, g, idx)                                            GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 32, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_READ(r, p)                                                    MREAD_16((uint8_t *)(p) + 32, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_BAD_PROTO_CNTR_WRITE(v, p)                                                   MWRITE_16((uint8_t *)(p) + 32, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 34, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 34, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TIME_SLICE_EXPIRE_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 34, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 36, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 36, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_TX_DROPS_NO_SBPM_TIMER_STOP_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 36, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (v))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (r), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(UDPSPDT_STREAM_TX_STAT_STRUCT) + 39, 0, 1, (v), core_id)
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 39, 0, 1, (r))
#define RDD_UDPSPDT_STREAM_TX_STAT_FIRST_TS_SET_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 39, 0, 1, (v))
/* <<<UDPSPDT_STREAM_TX_STAT_STRUCT */


/* >>>SPDSVC_WLAN_GEN_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[10];
    uint16_t word_16[5];
        struct {
        uint32_t	complete_tracked	;
        uint32_t	tx_copies       	;
        uint16_t	spdsvc_free_idx 	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) SPDSVC_WLAN_GEN_PARAMS_STRUCT;

#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_COMPLETE_TRACKED_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_TX_COPIES_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ_G(r, g, idx)                                 GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE_G(v, g, idx)                                GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (v))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_GEN_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_READ(r, p)                                        MREAD_16((uint8_t *)(p) + 8, (r))
#define RDD_SPDSVC_WLAN_GEN_PARAMS_SPDSVC_FREE_IDX_WRITE(v, p)                                       MWRITE_16((uint8_t *)(p) + 8, (v))
/* <<<SPDSVC_WLAN_GEN_PARAMS_STRUCT */


/* >>>SPDSVC_WLAN_TXPOST_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
        uint16_t	spdsvc_free_idx	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) SPDSVC_WLAN_TXPOST_PARAMS_STRUCT;

#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (r))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (v))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (r), core_id)
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(SPDSVC_WLAN_TXPOST_PARAMS_STRUCT), (v), core_id)
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_READ(r, p)                                       MREAD_16((uint8_t *)(p), (r))
#define RDD_SPDSVC_WLAN_TXPOST_PARAMS_SPDSVC_FREE_IDX_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p), (v))
/* <<<SPDSVC_WLAN_TXPOST_PARAMS_STRUCT */


/* >>>PKTGEN_TX_PARAMS_STRUCT */
typedef union
    {
    uint8_t word_8[32];
    uint16_t word_16[16];
    uint32_t word_32[8];
    uint64_t dword_64[4];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	bbmsg_sbpm_mcast_inc_req_0	;
        uint32_t	bbmsg_sbpm_mcast_inc_req_1	;
        uint32_t	ref_pd_0                  	;
        uint32_t	ref_pd_1                  	;
        uint32_t	ref_pd_2                  	;
        uint32_t	ref_pd_3                  	;
        uint32_t	task_num                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                 	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	reserved2                 	;
        uint16_t	bad_tx_num_of_bns         	;
#else
        uint32_t	bbmsg_sbpm_mcast_inc_req_0	;
        uint32_t	bbmsg_sbpm_mcast_inc_req_1	;
        uint32_t	ref_pd_0                  	;
        uint32_t	ref_pd_1                  	;
        uint32_t	ref_pd_2                  	;
        uint32_t	ref_pd_3                  	;
        uint32_t	reserved1                 	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	task_num                  	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	bad_tx_num_of_bns         	;
        uint16_t	reserved2                 	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PKTGEN_TX_PARAMS_STRUCT;

#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT), (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_0_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_PARAMS_BBMSG_SBPM_MCAST_INC_REQ_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 8, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_0_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 12, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 16, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_2_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (v))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 20, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_PKTGEN_TX_PARAMS_REF_PD_3_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ_G(r, g, idx)                                                  GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (r))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE_G(v, g, idx)                                                 GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (v))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ_CORE(r, g, idx, core_id)                                      CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE_CORE(v, g, idx, core_id)                                     CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 24, 4, 4, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_READ(r, p)                                                         RDP_FIELD_MREAD_8((uint8_t *)(p) + 24, 4, 4, (r))
#define RDD_PKTGEN_TX_PARAMS_TASK_NUM_WRITE(v, p)                                                        RDP_FIELD_MWRITE_8((uint8_t *)(p) + 24, 4, 4, (v))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ_G(r, g, idx)                                         GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (r))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE_G(v, g, idx)                                        GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (v))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (r), core_id)
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_PARAMS_STRUCT) + 30, (v), core_id)
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_READ(r, p)                                                MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_PKTGEN_TX_PARAMS_BAD_TX_NUM_OF_BNS_WRITE(v, p)                                               MWRITE_16((uint8_t *)(p) + 30, (v))
/* <<<PKTGEN_TX_PARAMS_STRUCT */


/* >>>PKTGEN_SBPM_HDR_BN_STRUCT */
typedef union
    {
    uint8_t word_8[2];
    uint16_t word_16[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	first_bn  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	ext_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint16_t	ext_idx   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint16_t	first_bn  	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(2))) PKTGEN_SBPM_HDR_BN_STRUCT;

#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (r), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT), 2, 14, (v), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_READ(r, p)                                       RDP_FIELD_MREAD_16((uint8_t *)(p), 2, 14, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_FIRST_BN_WRITE(v, p)                                      RDP_FIELD_MWRITE_16((uint8_t *)(p), 2, 14, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (v))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (r), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_SBPM_HDR_BN_STRUCT) + 1, 0, 2, (v), core_id)
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 1, 0, 2, (r))
#define RDD_PKTGEN_SBPM_HDR_BN_EXT_IDX_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 1, 0, 2, (v))
/* <<<PKTGEN_SBPM_HDR_BN_STRUCT */


/* >>>PKTGEN_SBPM_EXT_STRUCT */
typedef union
    {
    uint8_t word_8[4];
    uint16_t word_16[2];
    uint32_t word_32[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_bns	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	bn1       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	bn1       	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	num_of_bns	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved0 	:14	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PKTGEN_SBPM_EXT_STRUCT;

#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (r))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (v))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (r), core_id)
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 0, 14, 4, (v), core_id)
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_READ(r, p)                                       RDP_FIELD_MREAD_32((uint8_t *)(p) + 0, 14, 4, (r))
#define RDD_PKTGEN_SBPM_EXT_NUM_OF_BNS_WRITE(v, p)                                      RDP_FIELD_MWRITE_32((uint8_t *)(p) + 0, 14, 4, (v))
#define RDD_PKTGEN_SBPM_EXT_BN1_READ_G(r, g, idx)                                       GROUP_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (r))
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE_G(v, g, idx)                                      GROUP_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (v))
#define RDD_PKTGEN_SBPM_EXT_BN1_READ_CORE(r, g, idx, core_id)                           CORE_RDP_FIELD_MREAD_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (r), core_id)
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE_CORE(v, g, idx, core_id)                          CORE_RDP_FIELD_MWRITE_16((g), (idx)*sizeof(PKTGEN_SBPM_EXT_STRUCT) + 2, 0, 14, (v), core_id)
#define RDD_PKTGEN_SBPM_EXT_BN1_READ(r, p)                                              RDP_FIELD_MREAD_16((uint8_t *)(p) + 2, 0, 14, (r))
#define RDD_PKTGEN_SBPM_EXT_BN1_WRITE(v, p)                                             RDP_FIELD_MWRITE_16((uint8_t *)(p) + 2, 0, 14, (v))
/* <<<PKTGEN_SBPM_EXT_STRUCT */


/* >>>PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[20];
    uint16_t word_16[10];
    uint32_t word_32[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	fpm_ug_cnt_dummy   	;
        uint32_t	fpm_ug_cnt         	;
        uint32_t	fpm_ug_cnt_reg_addr	;
        uint32_t	fpm_ug_threshold   	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_tokens_quantum 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	budget             	;
#else
        uint32_t	fpm_ug_cnt_dummy   	;
        uint32_t	fpm_ug_cnt         	;
        uint32_t	fpm_ug_cnt_reg_addr	;
        uint32_t	fpm_tokens_quantum 	:4	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	fpm_ug_threshold   	:28	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	budget             	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT;

#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT), (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_READ(r, p)                                          MREAD_32((uint8_t *)(p), (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_DUMMY_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p), (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_CNT_REG_ADDR_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ_G(r, g, idx)                                   GROUP_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE_G(v, g, idx)                                  GROUP_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ_CORE(r, g, idx, core_id)                       CORE_RDP_FIELD_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE_CORE(v, g, idx, core_id)                      CORE_RDP_FIELD_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 12, 4, 28, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_READ(r, p)                                          RDP_FIELD_MREAD_32((uint8_t *)(p) + 12, 4, 28, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_UG_THRESHOLD_WRITE(v, p)                                         RDP_FIELD_MWRITE_32((uint8_t *)(p) + 12, 4, 28, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ_G(r, g, idx)                                 GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE_G(v, g, idx)                                GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ_CORE(r, g, idx, core_id)                     CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE_CORE(v, g, idx, core_id)                    CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 15, 0, 4, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_READ(r, p)                                        RDP_FIELD_MREAD_8((uint8_t *)(p) + 15, 0, 4, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_FPM_TOKENS_QUANTUM_WRITE(v, p)                                       RDP_FIELD_MWRITE_8((uint8_t *)(p) + 15, 0, 4, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (v))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_FPM_UG_MGMT_ENTRY_BUDGET_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 16, (v))
/* <<<PKTGEN_FPM_UG_MGMT_ENTRY_STRUCT */


/* >>>ENTRY_PARMS_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	wan_flow          	;
        uint16_t	reserved          	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tcp_udp_parms     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	l2_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l3_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l3_protocol                 	; /* Member of tcp_udp_parms union */
        uint8_t	tx_hdr_len                  	; /* Member of tcp_udp_parms union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	udp_payload_offset          	; /* Member of tcp_udp_parms union */
        uint16_t	udp_csum                    	; /* Member of tcp_udp_parms union */
		};
	};
#else
	/* Union WORD 0 */
	union{
		/* Sub Union 0 */
		struct{
        uint16_t	reserved          	;
        uint16_t	wan_flow          	;
		};
	};
	/* Union WORD 1 */
	union{
		/* Sub Union 0 */
		struct{
        uint32_t	tcp_udp_parms     	; /* This is a field union */
		};
		/* Sub Union 1 */
		struct{
        uint8_t	tx_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l3_protocol                 	; /* Member of tcp_udp_parms union */
        uint8_t	l3_hdr_len                  	; /* Member of tcp_udp_parms union */
        uint8_t	l2_hdr_len                  	; /* Member of tcp_udp_parms union */
		};
		/* Sub Union 2 */
		struct{
        uint16_t	udp_csum                    	; /* Member of tcp_udp_parms union */
        uint16_t	udp_payload_offset          	; /* Member of tcp_udp_parms union */
		};
	};
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) ENTRY_PARMS_STRUCT;

#define RDD_ENTRY_PARMS_WAN_FLOW_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (r))
#define RDD_ENTRY_PARMS_WAN_FLOW_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (v))
#define RDD_ENTRY_PARMS_WAN_FLOW_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (r), core_id)
#define RDD_ENTRY_PARMS_WAN_FLOW_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT), (v), core_id)
#define RDD_ENTRY_PARMS_WAN_FLOW_READ(r, p)                                                 MREAD_16((uint8_t *)(p), (r))
#define RDD_ENTRY_PARMS_WAN_FLOW_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p), (v))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r), core_id)
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v), core_id)
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_ENTRY_PARMS_TCP_UDP_PARMS_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r), core_id)
#define RDD_ENTRY_PARMS_L2_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v), core_id)
#define RDD_ENTRY_PARMS_L2_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 4, (r))
#define RDD_ENTRY_PARMS_L2_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 4, (v))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (r))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (v))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (r), core_id)
#define RDD_ENTRY_PARMS_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 5, (v), core_id)
#define RDD_ENTRY_PARMS_L3_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 5, (r))
#define RDD_ENTRY_PARMS_L3_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 5, (v))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r), core_id)
#define RDD_ENTRY_PARMS_L3_PROTOCOL_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v), core_id)
#define RDD_ENTRY_PARMS_L3_PROTOCOL_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 6, (r))
#define RDD_ENTRY_PARMS_L3_PROTOCOL_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 6, (v))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (r))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (v))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (r), core_id)
#define RDD_ENTRY_PARMS_TX_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 7, (v), core_id)
#define RDD_ENTRY_PARMS_TX_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 7, (r))
#define RDD_ENTRY_PARMS_TX_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 7, (v))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (r), core_id)
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 4, (v), core_id)
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_ENTRY_PARMS_UDP_CSUM_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r))
#define RDD_ENTRY_PARMS_UDP_CSUM_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v))
#define RDD_ENTRY_PARMS_UDP_CSUM_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (r), core_id)
#define RDD_ENTRY_PARMS_UDP_CSUM_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(ENTRY_PARMS_STRUCT) + 6, (v), core_id)
#define RDD_ENTRY_PARMS_UDP_CSUM_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_ENTRY_PARMS_UDP_CSUM_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<ENTRY_PARMS_STRUCT */


/* >>>REF_PKT_HDR_STRUCT */
typedef union
    {
    uint8_t word_8[128];
    uint16_t word_16[64];
    uint32_t word_32[32];
    uint64_t dword_64[16];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint16_t	size      	;
        uint16_t	offset    	;
        uint32_t	reserved  	;
        uint32_t	hdr       	;
        uint32_t	hdr_1     	;
        uint32_t	hdr_2     	;
        uint32_t	hdr_3     	;
        uint32_t	hdr_4     	;
        uint32_t	hdr_5     	;
        uint32_t	hdr_6     	;
        uint32_t	hdr_7     	;
        uint32_t	hdr_8     	;
        uint32_t	hdr_9     	;
        uint32_t	hdr_10    	;
        uint32_t	hdr_11    	;
        uint32_t	hdr_12    	;
        uint32_t	hdr_13    	;
        uint32_t	hdr_14    	;
        uint32_t	hdr_15    	;
        uint32_t	hdr_16    	;
        uint32_t	hdr_17    	;
        uint32_t	hdr_18    	;
        uint32_t	hdr_19    	;
        uint32_t	hdr_20    	;
        uint32_t	hdr_21    	;
        uint32_t	hdr_22    	;
        uint32_t	hdr_23    	;
        uint32_t	hdr_24    	;
        uint32_t	hdr_25    	;
        uint32_t	hdr_26    	;
        uint32_t	hdr_27    	;
        uint32_t	hdr_28    	;
        uint32_t	hdr_29    	;
#else
        uint16_t	offset    	;
        uint16_t	size      	;
        uint32_t	reserved  	;
        uint32_t	hdr       	;
        uint32_t	hdr_1     	;
        uint32_t	hdr_2     	;
        uint32_t	hdr_3     	;
        uint32_t	hdr_4     	;
        uint32_t	hdr_5     	;
        uint32_t	hdr_6     	;
        uint32_t	hdr_7     	;
        uint32_t	hdr_8     	;
        uint32_t	hdr_9     	;
        uint32_t	hdr_10    	;
        uint32_t	hdr_11    	;
        uint32_t	hdr_12    	;
        uint32_t	hdr_13    	;
        uint32_t	hdr_14    	;
        uint32_t	hdr_15    	;
        uint32_t	hdr_16    	;
        uint32_t	hdr_17    	;
        uint32_t	hdr_18    	;
        uint32_t	hdr_19    	;
        uint32_t	hdr_20    	;
        uint32_t	hdr_21    	;
        uint32_t	hdr_22    	;
        uint32_t	hdr_23    	;
        uint32_t	hdr_24    	;
        uint32_t	hdr_25    	;
        uint32_t	hdr_26    	;
        uint32_t	hdr_27    	;
        uint32_t	hdr_28    	;
        uint32_t	hdr_29    	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) REF_PKT_HDR_STRUCT;

#define RDD_REF_PKT_HDR_SIZE_READ_G(r, g, idx)                                    GROUP_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (r))
#define RDD_REF_PKT_HDR_SIZE_WRITE_G(v, g, idx)                                   GROUP_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (v))
#define RDD_REF_PKT_HDR_SIZE_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (r), core_id)
#define RDD_REF_PKT_HDR_SIZE_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT), (v), core_id)
#define RDD_REF_PKT_HDR_SIZE_READ(r, p)                                           MREAD_16((uint8_t *)(p), (r))
#define RDD_REF_PKT_HDR_SIZE_WRITE(v, p)                                          MWRITE_16((uint8_t *)(p), (v))
#define RDD_REF_PKT_HDR_OFFSET_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (r))
#define RDD_REF_PKT_HDR_OFFSET_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (v))
#define RDD_REF_PKT_HDR_OFFSET_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (r), core_id)
#define RDD_REF_PKT_HDR_OFFSET_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 2, (v), core_id)
#define RDD_REF_PKT_HDR_OFFSET_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_REF_PKT_HDR_OFFSET_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_REF_PKT_HDR_HDR_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (r))
#define RDD_REF_PKT_HDR_HDR_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (v))
#define RDD_REF_PKT_HDR_HDR_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 8, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_REF_PKT_HDR_HDR_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_REF_PKT_HDR_HDR_1_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (r))
#define RDD_REF_PKT_HDR_HDR_1_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (v))
#define RDD_REF_PKT_HDR_HDR_1_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_1_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 12, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_1_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_REF_PKT_HDR_HDR_1_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_REF_PKT_HDR_HDR_2_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (r))
#define RDD_REF_PKT_HDR_HDR_2_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (v))
#define RDD_REF_PKT_HDR_HDR_2_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_2_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 16, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_2_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_REF_PKT_HDR_HDR_2_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_REF_PKT_HDR_HDR_3_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (r))
#define RDD_REF_PKT_HDR_HDR_3_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (v))
#define RDD_REF_PKT_HDR_HDR_3_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_3_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 20, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_3_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_REF_PKT_HDR_HDR_3_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_REF_PKT_HDR_HDR_4_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (r))
#define RDD_REF_PKT_HDR_HDR_4_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (v))
#define RDD_REF_PKT_HDR_HDR_4_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_4_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 24, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_4_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_REF_PKT_HDR_HDR_4_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_REF_PKT_HDR_HDR_5_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (r))
#define RDD_REF_PKT_HDR_HDR_5_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (v))
#define RDD_REF_PKT_HDR_HDR_5_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_5_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 28, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_5_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_REF_PKT_HDR_HDR_5_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_REF_PKT_HDR_HDR_6_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (r))
#define RDD_REF_PKT_HDR_HDR_6_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (v))
#define RDD_REF_PKT_HDR_HDR_6_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_6_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 32, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_6_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_REF_PKT_HDR_HDR_6_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_REF_PKT_HDR_HDR_7_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (r))
#define RDD_REF_PKT_HDR_HDR_7_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (v))
#define RDD_REF_PKT_HDR_HDR_7_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_7_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 36, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_7_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_REF_PKT_HDR_HDR_7_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_REF_PKT_HDR_HDR_8_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (r))
#define RDD_REF_PKT_HDR_HDR_8_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (v))
#define RDD_REF_PKT_HDR_HDR_8_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_8_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 40, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_8_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_REF_PKT_HDR_HDR_8_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_REF_PKT_HDR_HDR_9_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (r))
#define RDD_REF_PKT_HDR_HDR_9_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (v))
#define RDD_REF_PKT_HDR_HDR_9_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_9_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 44, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_9_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_REF_PKT_HDR_HDR_9_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_REF_PKT_HDR_HDR_10_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (r))
#define RDD_REF_PKT_HDR_HDR_10_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (v))
#define RDD_REF_PKT_HDR_HDR_10_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_10_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 48, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_10_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_REF_PKT_HDR_HDR_10_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_REF_PKT_HDR_HDR_11_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (r))
#define RDD_REF_PKT_HDR_HDR_11_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (v))
#define RDD_REF_PKT_HDR_HDR_11_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_11_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 52, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_11_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_REF_PKT_HDR_HDR_11_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_REF_PKT_HDR_HDR_12_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (r))
#define RDD_REF_PKT_HDR_HDR_12_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (v))
#define RDD_REF_PKT_HDR_HDR_12_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_12_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 56, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_12_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_REF_PKT_HDR_HDR_12_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_REF_PKT_HDR_HDR_13_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (r))
#define RDD_REF_PKT_HDR_HDR_13_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (v))
#define RDD_REF_PKT_HDR_HDR_13_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_13_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 60, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_13_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_REF_PKT_HDR_HDR_13_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_REF_PKT_HDR_HDR_14_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (r))
#define RDD_REF_PKT_HDR_HDR_14_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (v))
#define RDD_REF_PKT_HDR_HDR_14_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_14_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 64, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_14_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_REF_PKT_HDR_HDR_14_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_REF_PKT_HDR_HDR_15_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (r))
#define RDD_REF_PKT_HDR_HDR_15_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (v))
#define RDD_REF_PKT_HDR_HDR_15_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_15_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 68, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_15_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_REF_PKT_HDR_HDR_15_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_REF_PKT_HDR_HDR_16_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (r))
#define RDD_REF_PKT_HDR_HDR_16_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (v))
#define RDD_REF_PKT_HDR_HDR_16_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_16_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 72, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_16_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_REF_PKT_HDR_HDR_16_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_REF_PKT_HDR_HDR_17_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (r))
#define RDD_REF_PKT_HDR_HDR_17_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (v))
#define RDD_REF_PKT_HDR_HDR_17_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_17_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 76, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_17_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_REF_PKT_HDR_HDR_17_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_REF_PKT_HDR_HDR_18_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (r))
#define RDD_REF_PKT_HDR_HDR_18_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (v))
#define RDD_REF_PKT_HDR_HDR_18_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_18_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 80, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_18_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_REF_PKT_HDR_HDR_18_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_REF_PKT_HDR_HDR_19_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (r))
#define RDD_REF_PKT_HDR_HDR_19_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (v))
#define RDD_REF_PKT_HDR_HDR_19_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_19_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 84, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_19_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_REF_PKT_HDR_HDR_19_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_REF_PKT_HDR_HDR_20_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (r))
#define RDD_REF_PKT_HDR_HDR_20_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (v))
#define RDD_REF_PKT_HDR_HDR_20_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_20_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 88, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_20_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_REF_PKT_HDR_HDR_20_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_REF_PKT_HDR_HDR_21_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (r))
#define RDD_REF_PKT_HDR_HDR_21_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (v))
#define RDD_REF_PKT_HDR_HDR_21_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_21_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 92, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_21_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_REF_PKT_HDR_HDR_21_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_REF_PKT_HDR_HDR_22_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (r))
#define RDD_REF_PKT_HDR_HDR_22_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (v))
#define RDD_REF_PKT_HDR_HDR_22_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_22_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 96, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_22_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_REF_PKT_HDR_HDR_22_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_REF_PKT_HDR_HDR_23_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (r))
#define RDD_REF_PKT_HDR_HDR_23_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (v))
#define RDD_REF_PKT_HDR_HDR_23_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_23_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 100, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_23_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_REF_PKT_HDR_HDR_23_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_REF_PKT_HDR_HDR_24_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (r))
#define RDD_REF_PKT_HDR_HDR_24_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (v))
#define RDD_REF_PKT_HDR_HDR_24_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_24_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 104, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_24_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 104, (r))
#define RDD_REF_PKT_HDR_HDR_24_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 104, (v))
#define RDD_REF_PKT_HDR_HDR_25_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (r))
#define RDD_REF_PKT_HDR_HDR_25_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (v))
#define RDD_REF_PKT_HDR_HDR_25_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_25_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 108, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_25_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_REF_PKT_HDR_HDR_25_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_REF_PKT_HDR_HDR_26_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (r))
#define RDD_REF_PKT_HDR_HDR_26_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (v))
#define RDD_REF_PKT_HDR_HDR_26_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_26_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 112, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_26_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 112, (r))
#define RDD_REF_PKT_HDR_HDR_26_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 112, (v))
#define RDD_REF_PKT_HDR_HDR_27_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (r))
#define RDD_REF_PKT_HDR_HDR_27_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (v))
#define RDD_REF_PKT_HDR_HDR_27_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_27_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 116, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_27_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 116, (r))
#define RDD_REF_PKT_HDR_HDR_27_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 116, (v))
#define RDD_REF_PKT_HDR_HDR_28_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (r))
#define RDD_REF_PKT_HDR_HDR_28_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (v))
#define RDD_REF_PKT_HDR_HDR_28_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_28_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 120, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_28_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 120, (r))
#define RDD_REF_PKT_HDR_HDR_28_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 120, (v))
#define RDD_REF_PKT_HDR_HDR_29_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (r))
#define RDD_REF_PKT_HDR_HDR_29_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (v))
#define RDD_REF_PKT_HDR_HDR_29_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (r), core_id)
#define RDD_REF_PKT_HDR_HDR_29_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(REF_PKT_HDR_STRUCT) + 124, (v), core_id)
#define RDD_REF_PKT_HDR_HDR_29_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 124, (r))
#define RDD_REF_PKT_HDR_HDR_29_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 124, (v))
/* <<<REF_PKT_HDR_STRUCT */


/* >>>PKTGEN_TX_STREAM_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[136];
    uint16_t word_16[68];
    uint32_t word_32[34];
    uint64_t dword_64[17];
        struct {
        REF_PKT_HDR_STRUCT ref_pkt_hdr;
        ENTRY_PARMS_STRUCT entry_parms;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PKTGEN_TX_STREAM_ENTRY_STRUCT;

#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ_G(r, g, idx)                                              GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE_G(v, g, idx)                                             GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT), (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_READ(r, p)                                                     MREAD_16((uint8_t *)(p), (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_SIZE_WRITE(v, p)                                                    MWRITE_16((uint8_t *)(p), (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 2, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_OFFSET_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_RESERVED_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 8, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 12, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_1_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 16, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_2_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 20, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_3_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 24, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_4_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 28, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_5_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 32, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_6_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 36, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_7_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 40, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_8_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 44, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_9_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 48, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_10_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 52, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_11_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 56, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_12_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 60, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_13_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 64, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_14_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 68, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_15_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 72, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_16_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 76, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_17_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 80, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_18_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 84, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_19_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 88, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_20_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 92, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_21_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 96, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_22_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 100, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_23_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 104, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 104, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_24_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 104, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 108, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 108, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_25_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 108, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 112, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 112, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_26_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 112, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 116, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 116, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_27_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 116, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 120, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 120, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_28_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 120, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 124, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 124, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_REF_PKT_HDR_HDR_29_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 124, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 128, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 128, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_WAN_FLOW_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 128, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 130, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 130, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_RESERVED_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 130, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TCP_UDP_PARMS_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L2_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 133, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 133, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 133, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ_G(r, g, idx)                                       GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE_G(v, g, idx)                                      GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_READ(r, p)                                              MREAD_8((uint8_t *)(p) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_L3_PROTOCOL_WRITE(v, p)                                             MWRITE_8((uint8_t *)(p) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_8((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 135, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_READ(r, p)                                               MREAD_8((uint8_t *)(p) + 135, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_TX_HDR_LEN_WRITE(v, p)                                              MWRITE_8((uint8_t *)(p) + 135, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 132, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 132, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_PAYLOAD_OFFSET_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 132, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ_G(r, g, idx)                                          GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE_G(v, g, idx)                                         GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_ENTRY_STRUCT) + 134, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_READ(r, p)                                                 MREAD_16((uint8_t *)(p) + 134, (r))
#define RDD_PKTGEN_TX_STREAM_ENTRY_ENTRY_PARMS_UDP_CSUM_WRITE(v, p)                                                MWRITE_16((uint8_t *)(p) + 134, (v))
/* <<<PKTGEN_TX_STREAM_ENTRY_STRUCT */


/* >>>PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	reserved0 	;
        uint16_t	csum_value	;
        uint16_t	reserved1 	;
#else
        uint32_t	reserved0 	;
        uint16_t	reserved1 	;
        uint16_t	csum_value	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT;

#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (v))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (r), core_id)
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT) + 4, (v), core_id)
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_PKTGEN_TX_STREAM_SCRATCH_ENTRY_CSUM_VALUE_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 4, (v))
/* <<<PKTGEN_TX_STREAM_SCRATCH_ENTRY_STRUCT */


/* >>>TCPSPDTEST_RING_MNG_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	write_offset	;
        uint32_t	read_offset 	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_RING_MNG_STRUCT;

#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (r))
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (v))
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_RING_MNG_WRITE_OFFSET_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_MNG_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_READ(r, p)                                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_RING_MNG_READ_OFFSET_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_RING_MNG_STRUCT */


/* >>>TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	rx_l3_payload_len	;
        uint32_t	rx_l4_seq        	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT;

#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (v))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_READ(r, p)                                       MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L3_PAYLOAD_LEN_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_DOWNLOAD_RING_METADATA_RX_L4_SEQ_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_DOWNLOAD_RING_METADATA_STRUCT */


/* >>>TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	time      	;
        uint32_t	tx_seq    	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT;

#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (v))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_READ(r, p)                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TIME_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_TX_SEQ_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_RTO_RING_TX_SEQ_METADATA_STRUCT */


/* >>>TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
        uint32_t	left_edge 	;
        uint32_t	right_edge	;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT;

#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_READ_G(r, g, idx)                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_WRITE_G(v, g, idx)                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (v))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_READ_CORE(r, g, idx, core_id)                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_WRITE_CORE(v, g, idx, core_id)                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_READ(r, p)                                        MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_LEFT_EDGE_WRITE(v, p)                                       MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_RING_SACK_OPT_METADATA_RIGHT_EDGE_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 4, (v))
/* <<<TCPSPDTEST_RING_SACK_OPT_METADATA_STRUCT */


/* >>>TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT */
typedef union
    {
    uint8_t word_8[20];
    uint16_t word_16[10];
    uint32_t word_32[5];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	num_streams                 	;
        uint8_t	wakeup_stream_id            	;
        uint8_t	dn_pkt_drop_fw_wakeup_vector	;
        uint8_t	num_bns                     	;
        uint32_t	stream_vector               	;
        uint32_t	up_bucket_tokens            	;
        uint32_t	up_bucket_full_tokens       	;
        uint16_t	up_bucket_tokens_fill_rate  	;
        uint8_t	up_next_stream_id           	;
        uint32_t	reserved1                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timer_active          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint8_t	num_bns                     	;
        uint8_t	dn_pkt_drop_fw_wakeup_vector	;
        uint8_t	wakeup_stream_id            	;
        uint8_t	num_streams                 	;
        uint32_t	stream_vector               	;
        uint32_t	up_bucket_tokens            	;
        uint32_t	up_bucket_full_tokens       	;
        uint32_t	up_is_timer_active          	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved1                   	:7	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	up_next_stream_id           	;
        uint16_t	up_bucket_tokens_fill_rate  	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(4))) TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ_G(r, g, idx)                                                 GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE_G(v, g, idx)                                                GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_READ(r, p)                                                        MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_STREAMS_WRITE(v, p)                                                       MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_WAKEUP_STREAM_ID_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_DN_PKT_DROP_FW_WAKEUP_VECTOR_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 3, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_NUM_BNS_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_STREAM_VECTOR_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_FULL_TOKENS_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ_G(r, g, idx)                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE_G(v, g, idx)                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_READ(r, p)                                         MREAD_16((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_BUCKET_TOKENS_FILL_RATE_WRITE(v, p)                                        MWRITE_16((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 18, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 18, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_NEXT_STREAM_ID_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 18, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT) + 19, 0, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 19, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_GLOBAL_INFO_UP_IS_TIMER_ACTIVE_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 19, 0, 1, (v))
/* <<<TCPSPDTEST_ENGINE_GLOBAL_INFO_STRUCT */


/* >>>TCPSPDTEST_ENGINE_CONN_INFO_STRUCT */
typedef union
    {
    uint8_t word_8[8];
    uint16_t word_16[4];
    uint32_t word_32[2];
    uint64_t dword_64[1];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	cpu_rx_rdd_queue	;
        uint8_t	up_pppoe_hdr_ofs	;
        uint8_t	up_peer_rx_scale	;
        uint8_t	sack_permitted  	;
        uint16_t	up_tx_mss       	;
        uint16_t	up_tx_max_pd_len	;
#else
        uint8_t	sack_permitted  	;
        uint8_t	up_peer_rx_scale	;
        uint8_t	up_pppoe_hdr_ofs	;
        uint8_t	cpu_rx_rdd_queue	;
        uint16_t	up_tx_max_pd_len	;
        uint16_t	up_tx_mss       	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_CONN_INFO_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ(r, p)                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_G(r, g, idx)                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_G(v, g, idx)                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ(r, p)                                       MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE(v, p)                                      MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_G(r, g, idx)                                  GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_G(v, g, idx)                                 GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 3, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ(r, p)                                         MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE(v, p)                                        MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_CONN_INFO_STRUCT) + 6, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 6, (v))
/* <<<TCPSPDTEST_ENGINE_CONN_INFO_STRUCT */


/* >>>TCPSPDTEST_ENGINE_TCB_STRUCT */
typedef union
    {
    uint8_t word_8[112];
    uint16_t word_16[56];
    uint32_t word_32[28];
    uint64_t dword_64[14];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rx_pkts                     	;
        uint32_t	txed_pkts                   	;
        uint32_t	freed_pkts                  	;
        uint32_t	ack_seq                     	;
        uint32_t	tx_seq                      	;
        uint16_t	bad_pkts                    	;
        uint16_t	src_port                    	;
        uint32_t	rx_bytes                    	;
        uint32_t	rx_bytes_1                  	;
        uint32_t	expected_bytes              	;
        uint32_t	expected_bytes_1            	;
        uint32_t	up_to_send_bytes            	;
        uint32_t	up_to_send_bytes_1          	;
        uint16_t	no_dispatcher_credits       	;
        uint16_t	no_pktgen_tx_credits        	;
        uint32_t	up_cwnd                     	;
        uint32_t	up_cwnd_thr                 	;
        uint32_t	up_cwnd_initial             	;
        uint32_t	up_cwnd_max                 	;
        uint32_t	up_cwnd_budget              	;
        uint32_t	up_last_ack_seq             	;
        uint32_t	up_last_ack_time            	;
        uint32_t	up_sack_bytes               	;
        uint32_t	up_fast_retrans_trig_cnt    	;
        uint32_t	up_dup_ack_cnt              	;
        uint32_t	up_dup_ack_seq_done         	;
        uint16_t	up_dup_ack_total_pkts_cnt   	;
        uint16_t	up_fast_retrans_cnt         	;
        uint8_t	up_err_dn_pkt_cnt           	;
        uint8_t	dn_err_up_pkt_cnt           	;
        uint8_t	up_cwnd_rtt_factor          	;
        uint8_t	err_dst_port_cnt            	;
        uint16_t	dynack_bytes_thr            	;
        uint16_t	dynack_bytes_thr_cnt        	;
        uint8_t	dynack_thr_upd_rate         	;
        uint8_t	dynack_thr_upd_rate_cnt     	;
        uint8_t	up_dup_ack_state            	;
        uint32_t	reserved2                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_driver_wakeup	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_force_ack    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_rx_win_stop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timeout               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_stream_active            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_upload                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
#else
        uint32_t	rx_pkts                     	;
        uint32_t	txed_pkts                   	;
        uint32_t	freed_pkts                  	;
        uint32_t	ack_seq                     	;
        uint32_t	tx_seq                      	;
        uint16_t	src_port                    	;
        uint16_t	bad_pkts                    	;
        uint32_t	rx_bytes                    	;
        uint32_t	rx_bytes_1                  	;
        uint32_t	expected_bytes              	;
        uint32_t	expected_bytes_1            	;
        uint32_t	up_to_send_bytes            	;
        uint32_t	up_to_send_bytes_1          	;
        uint16_t	no_pktgen_tx_credits        	;
        uint16_t	no_dispatcher_credits       	;
        uint32_t	up_cwnd                     	;
        uint32_t	up_cwnd_thr                 	;
        uint32_t	up_cwnd_initial             	;
        uint32_t	up_cwnd_max                 	;
        uint32_t	up_cwnd_budget              	;
        uint32_t	up_last_ack_seq             	;
        uint32_t	up_last_ack_time            	;
        uint32_t	up_sack_bytes               	;
        uint32_t	up_fast_retrans_trig_cnt    	;
        uint32_t	up_dup_ack_cnt              	;
        uint32_t	up_dup_ack_seq_done         	;
        uint16_t	up_fast_retrans_cnt         	;
        uint16_t	up_dup_ack_total_pkts_cnt   	;
        uint8_t	err_dst_port_cnt            	;
        uint8_t	up_cwnd_rtt_factor          	;
        uint8_t	dn_err_up_pkt_cnt           	;
        uint8_t	up_err_dn_pkt_cnt           	;
        uint16_t	dynack_bytes_thr_cnt        	;
        uint16_t	dynack_bytes_thr            	;
        uint32_t	is_upload                   	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	is_stream_active            	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_timeout               	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	up_is_rx_win_stop           	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_force_ack    	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	dn_is_pkt_drop_driver_wakeup	:1	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint32_t	reserved2                   	:2	__PACKING_ATTRIBUTE_FIELD_LEVEL__;
        uint8_t	up_dup_ack_state            	;
        uint8_t	dynack_thr_upd_rate_cnt     	;
        uint8_t	dynack_thr_upd_rate         	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_TCB_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_G(r, g, idx)                                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ(r, p)                                                            MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE(v, p)                                                           MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_G(r, g, idx)                                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ(r, p)                                                            MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE(v, p)                                                           MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_G(r, g, idx)                                                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ(r, p)                                                           MREAD_16((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE(v, p)                                                          MWRITE_16((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_G(r, g, idx)                                                    GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 22, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ(r, p)                                                           MREAD_16((uint8_t *)(p) + 22, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE(v, p)                                                          MWRITE_16((uint8_t *)(p) + 22, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_G(r, g, idx)                                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 48, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ(r, p)                                              MREAD_16((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE(v, p)                                             MWRITE_16((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_G(r, g, idx)                                        GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_G(v, g, idx)                                       GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 50, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ(r, p)                                               MREAD_16((uint8_t *)(p) + 50, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE(v, p)                                              MWRITE_16((uint8_t *)(p) + 50, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_G(r, g, idx)                                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 52, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ(r, p)                                                            MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE(v, p)                                                           MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 56, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 60, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 64, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 68, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 72, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 76, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_G(r, g, idx)                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_G(v, g, idx)                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 80, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ(r, p)                                                      MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE(v, p)                                                     MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 84, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 88, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_G(r, g, idx)                                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_G(v, g, idx)                                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 92, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ(r, p)                                                MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE(v, p)                                               MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_G(r, g, idx)                                   GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 96, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ(r, p)                                          MREAD_16((uint8_t *)(p) + 96, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE(v, p)                                         MWRITE_16((uint8_t *)(p) + 96, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_G(r, g, idx)                                         GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_G(v, g, idx)                                        GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 98, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ(r, p)                                                MREAD_16((uint8_t *)(p) + 98, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE(v, p)                                               MWRITE_16((uint8_t *)(p) + 98, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 100, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 100, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 100, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_G(r, g, idx)                                           GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_G(v, g, idx)                                          GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 101, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ(r, p)                                                  MREAD_8((uint8_t *)(p) + 101, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE(v, p)                                                 MWRITE_8((uint8_t *)(p) + 101, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_G(r, g, idx)                                          GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_G(v, g, idx)                                         GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 102, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ(r, p)                                                 MREAD_8((uint8_t *)(p) + 102, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE(v, p)                                                MWRITE_8((uint8_t *)(p) + 102, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 103, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 103, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 103, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_G(r, g, idx)                                            GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_G(v, g, idx)                                           GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 104, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ(r, p)                                                   MREAD_16((uint8_t *)(p) + 104, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE(v, p)                                                  MWRITE_16((uint8_t *)(p) + 104, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_G(r, g, idx)                                        GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_G(v, g, idx)                                       GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 106, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ(r, p)                                               MREAD_16((uint8_t *)(p) + 106, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE(v, p)                                              MWRITE_16((uint8_t *)(p) + 106, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_G(r, g, idx)                                         GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_G(v, g, idx)                                        GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_CORE(r, g, idx, core_id)                             CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_CORE(v, g, idx, core_id)                            CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 108, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ(r, p)                                                MREAD_8((uint8_t *)(p) + 108, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE(v, p)                                               MWRITE_8((uint8_t *)(p) + 108, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_G(r, g, idx)                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_G(v, g, idx)                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 109, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ(r, p)                                            MREAD_8((uint8_t *)(p) + 109, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE(v, p)                                           MWRITE_8((uint8_t *)(p) + 109, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_G(r, g, idx)                                            GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_G(v, g, idx)                                           GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 110, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ(r, p)                                                   MREAD_8((uint8_t *)(p) + 110, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE(v, p)                                                  MWRITE_8((uint8_t *)(p) + 110, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_G(r, g, idx)                                GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_G(v, g, idx)                               GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_CORE(r, g, idx, core_id)                    CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_CORE(v, g, idx, core_id)                   CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 5, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ(r, p)                                       RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 5, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE(v, p)                                      RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 5, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_G(r, g, idx)                                    GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_G(v, g, idx)                                   GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_CORE(r, g, idx, core_id)                        CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_CORE(v, g, idx, core_id)                       CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 4, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ(r, p)                                           RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 4, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE(v, p)                                          RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 4, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_G(r, g, idx)                                           GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_G(v, g, idx)                                          GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_CORE(r, g, idx, core_id)                               CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_CORE(v, g, idx, core_id)                              CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 3, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ(r, p)                                                  RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 3, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE(v, p)                                                 RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 3, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_G(r, g, idx)                                               GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_G(v, g, idx)                                              GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_CORE(r, g, idx, core_id)                                   CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_CORE(v, g, idx, core_id)                                  CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 2, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ(r, p)                                                      RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 2, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE(v, p)                                                     RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 2, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_G(r, g, idx)                                            GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_G(v, g, idx)                                           GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_CORE(r, g, idx, core_id)                                CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_CORE(v, g, idx, core_id)                               CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 1, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ(r, p)                                                   RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 1, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE(v, p)                                                  RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 1, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_G(r, g, idx)                                                   GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_G(v, g, idx)                                                  GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (v))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                                       CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                                      CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_TCB_STRUCT) + 111, 0, 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ(r, p)                                                          RDP_FIELD_MREAD_8((uint8_t *)(p) + 111, 0, 1, (r))
#define RDD_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE(v, p)                                                         RDP_FIELD_MWRITE_8((uint8_t *)(p) + 111, 0, 1, (v))
/* <<<TCPSPDTEST_ENGINE_TCB_STRUCT */


/* >>>TCPSPDTEST_ENGINE_PKT_DROP_STRUCT */
typedef union
    {
    uint8_t word_8[48];
    uint16_t word_16[24];
    uint32_t word_32[12];
    uint64_t dword_64[6];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint8_t	drop_state                 	;
        uint8_t	is_win_full                	;
        uint16_t	num_errs                   	;
        uint16_t	wr_ofs                     	;
        uint16_t	rd_ofs                     	;
        uint32_t	ack_seq_err_start          	;
        uint32_t	saved_rx_l4_seq            	;
        uint32_t	saved_ring_rd_wr_ofs       	;
        uint32_t	saved_ring_rd_wr_ofs_1     	;
        uint32_t	saved_rx_l3_hdr_len        	;
        uint32_t	saved_rx_l3_payload_len    	;
        uint32_t	saved_packet_descriptor_0  	;
        uint32_t	saved_packet_descriptor_0_1	;
        uint32_t	saved_packet_descriptor_2  	;
        uint32_t	saved_packet_descriptor_2_1	;
#else
        uint16_t	num_errs                   	;
        uint8_t	is_win_full                	;
        uint8_t	drop_state                 	;
        uint16_t	rd_ofs                     	;
        uint16_t	wr_ofs                     	;
        uint32_t	ack_seq_err_start          	;
        uint32_t	saved_rx_l4_seq            	;
        uint32_t	saved_ring_rd_wr_ofs       	;
        uint32_t	saved_ring_rd_wr_ofs_1     	;
        uint32_t	saved_rx_l3_hdr_len        	;
        uint32_t	saved_rx_l3_payload_len    	;
        uint32_t	saved_packet_descriptor_0  	;
        uint32_t	saved_packet_descriptor_0_1	;
        uint32_t	saved_packet_descriptor_2  	;
        uint32_t	saved_packet_descriptor_2_1	;
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_PKT_DROP_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_G(r, g, idx)                                                 GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_G(v, g, idx)                                                GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ(r, p)                                                        MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE(v, p)                                                       MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ(r, p)                                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_G(r, g, idx)                                                   GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ(r, p)                                                          MREAD_16((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE(v, p)                                                         MWRITE_16((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_G(r, g, idx)                                                     GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ(r, p)                                                            MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE(v, p)                                                           MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_G(r, g, idx)                                                     GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 6, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ(r, p)                                                            MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE(v, p)                                                           MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_G(r, g, idx)                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_G(v, g, idx)                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_CORE(r, g, idx, core_id)                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_CORE(v, g, idx, core_id)                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ(r, p)                                              MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE(v, p)                                             MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_G(r, g, idx)                                     GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_G(v, g, idx)                                    GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_CORE(r, g, idx, core_id)                         CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_CORE(v, g, idx, core_id)                        CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ(r, p)                                            MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE(v, p)                                           MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_G(r, g, idx)                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_G(v, g, idx)                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_CORE(r, g, idx, core_id)                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_CORE(v, g, idx, core_id)                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ(r, p)                                         MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE(v, p)                                        MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_G(r, g, idx)                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_G(v, g, idx)                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_PKT_DROP_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ(r, p)                                       MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE(v, p)                                      MWRITE_32((uint8_t *)(p) + 44, (v))
/* <<<TCPSPDTEST_ENGINE_PKT_DROP_STRUCT */


/* >>>TCPSPDTEST_ENGINE_RING_STRUCT */
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER	8
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER	16
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER	8
typedef union
    {
    uint8_t word_8[208];
    uint16_t word_16[104];
    uint32_t word_32[52];
    uint64_t dword_64[26];
        struct {
#ifndef FIRMWARE_LITTLE_ENDIAN
        uint32_t	rto_tx_seq_addr_low                                                                                 	;
        uint32_t	rto_tx_seq_addr_high                                                                                	;
        uint32_t	rto_tx_seq_send_cnt                                                                                 	;
        uint32_t	rto_tx_seq_drop_cnt                                                                                 	;
        uint32_t	rto_retrans_addr_low                                                                                	;
        uint32_t	rto_retrans_addr_high                                                                               	;
        uint32_t	sack_opt_addr_low                                                                                   	;
        uint32_t	sack_opt_addr_high                                                                                  	;
        uint32_t	sack_opt_send_cnt                                                                                   	;
        uint32_t	sack_opt_drop_cnt                                                                                   	;
        uint32_t	pkt_drop_rx_seq_addr_low                                                                            	;
        uint32_t	pkt_drop_rx_seq_addr_high                                                                           	;
        uint32_t	pkt_drop_rx_seq_send_cnt                                                                            	;
        uint32_t	pkt_drop_rx_seq_drop_cnt                                                                            	;
        uint32_t	sack_opt_total_parsed_cnt                                                                           	;
        uint32_t	rto_retrans_receive_cnt                                                                             	;
        uint16_t	rto_tx_seq_scratchpad_metadata_wr_ofs                                                               	;
        uint16_t	reserved1                                                                                           	;
        uint32_t	rto_tx_seq_coalescing_timeout_cnt                                                                   	;
        uint32_t	rto_tx_seq_coalescing_fill_pkt_cnt                                                                  	;
        uint32_t	rto_tx_seq_coalescing_last_time                                                                     	;
        uint32_t	scratchpad[RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER];
        uint32_t	rto_tx_seq_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER];
        uint32_t	sack_opt_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER];
#else
        uint32_t	rto_tx_seq_addr_low                                                                                 	;
        uint32_t	rto_tx_seq_addr_high                                                                                	;
        uint32_t	rto_tx_seq_send_cnt                                                                                 	;
        uint32_t	rto_tx_seq_drop_cnt                                                                                 	;
        uint32_t	rto_retrans_addr_low                                                                                	;
        uint32_t	rto_retrans_addr_high                                                                               	;
        uint32_t	sack_opt_addr_low                                                                                   	;
        uint32_t	sack_opt_addr_high                                                                                  	;
        uint32_t	sack_opt_send_cnt                                                                                   	;
        uint32_t	sack_opt_drop_cnt                                                                                   	;
        uint32_t	pkt_drop_rx_seq_addr_low                                                                            	;
        uint32_t	pkt_drop_rx_seq_addr_high                                                                           	;
        uint32_t	pkt_drop_rx_seq_send_cnt                                                                            	;
        uint32_t	pkt_drop_rx_seq_drop_cnt                                                                            	;
        uint32_t	sack_opt_total_parsed_cnt                                                                           	;
        uint32_t	rto_retrans_receive_cnt                                                                             	;
        uint16_t	reserved1                                                                                           	;
        uint16_t	rto_tx_seq_scratchpad_metadata_wr_ofs                                                               	;
        uint32_t	rto_tx_seq_coalescing_timeout_cnt                                                                   	;
        uint32_t	rto_tx_seq_coalescing_fill_pkt_cnt                                                                  	;
        uint32_t	rto_tx_seq_coalescing_last_time                                                                     	;
        uint32_t	scratchpad[RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER];
        uint32_t	rto_tx_seq_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER];
        uint32_t	sack_opt_scratchpad_metadata[RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER];
#endif
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_ENGINE_RING_STRUCT;

#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_READ(r, p)                                                         MREAD_32((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_LOW_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_ADDR_HIGH_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SEND_CNT_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_DROP_CNT_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ_G(r, g, idx)                                                 GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE_G(v, g, idx)                                                GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_READ(r, p)                                                        MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_LOW_WRITE(v, p)                                                       MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_ADDR_HIGH_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_LOW_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_ADDR_HIGH_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SEND_CNT_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_DROP_CNT_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_LOW_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_ADDR_HIGH_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 48, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_SEND_CNT_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 52, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_PKT_DROP_RX_SEQ_DROP_CNT_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ_G(r, g, idx)                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE_G(v, g, idx)                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ_CORE(r, g, idx, core_id)                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE_CORE(v, g, idx, core_id)                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 56, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_READ(r, p)                                                   MREAD_32((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_TOTAL_PARSED_CNT_WRITE(v, p)                                                  MWRITE_32((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 60, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_RETRANS_RECEIVE_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ_G(r, g, idx)                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE_G(v, g, idx)                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ_CORE(r, g, idx, core_id)                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE_CORE(v, g, idx, core_id)                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 64, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_READ(r, p)                                       MREAD_16((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WR_OFS_WRITE(v, p)                                      MWRITE_16((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_G(r, g, idx)                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_G(v, g, idx)                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ_CORE(r, g, idx, core_id)                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE_CORE(v, g, idx, core_id)                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 68, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_READ(r, p)                                           MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_TIMEOUT_CNT_WRITE(v, p)                                          MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_G(r, g, idx)                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_G(v, g, idx)                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ_CORE(r, g, idx, core_id)                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 72, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_READ(r, p)                                          MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_FILL_PKT_CNT_WRITE(v, p)                                         MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 76, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_COALESCING_LAST_TIME_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ_G(r, g, idx, i)                                                        GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE_G(v, g, idx, i)                                                       GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ_CORE(r, g, idx, i, core_id)                                            CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE_CORE(v, g, idx, i, core_id)                                           CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 80, i, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_READ(r, p, i)                                                               MREAD_I_32((uint8_t *)(p) + 80, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_WRITE(v, p, i)                                                              MWRITE_I_32((uint8_t *)(p) + 80, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                                    GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                                   GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ_CORE(r, g, idx, i, core_id)                        CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE_CORE(v, g, idx, i, core_id)                       CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 112, i, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_READ(r, p, i)                                           MREAD_I_32((uint8_t *)(p) + 112, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_WRITE(v, p, i)                                          MWRITE_I_32((uint8_t *)(p) + 112, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ_G(r, g, idx, i)                                      GROUP_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE_G(v, g, idx, i)                                     GROUP_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (v))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ_CORE(r, g, idx, i, core_id)                          CORE_MREAD_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (r), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE_CORE(v, g, idx, i, core_id)                         CORE_MWRITE_I_32((g), (idx)*sizeof(TCPSPDTEST_ENGINE_RING_STRUCT) + 176, i, (v), core_id)
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_READ(r, p, i)                                             MREAD_I_32((uint8_t *)(p) + 176, i, (r))
#define RDD_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_WRITE(v, p, i)                                            MWRITE_I_32((uint8_t *)(p) + 176, i, (v))
/* <<<TCPSPDTEST_ENGINE_RING_STRUCT */


/* >>>TCPSPDTEST_STREAM_STRUCT */
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SCRATCHPAD_NUMBER	8
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_RTO_TX_SEQ_SCRATCHPAD_METADATA_NUMBER	16
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_RING_SACK_OPT_SCRATCHPAD_METADATA_NUMBER	8
typedef union
    {
    uint8_t word_8[376];
    uint16_t word_16[188];
    uint32_t word_32[94];
    uint64_t dword_64[47];
        struct {
        TCPSPDTEST_ENGINE_CONN_INFO_STRUCT tcpspdtest_engine_conn_info;
        TCPSPDTEST_ENGINE_TCB_STRUCT tcpspdtest_engine_tcb;
        TCPSPDTEST_ENGINE_PKT_DROP_STRUCT tcpspdtest_engine_pkt_drop;
        TCPSPDTEST_ENGINE_RING_STRUCT tcpspdtest_engine_ring;
    } __PACKING_ATTRIBUTE_STRUCT_END__ ;
    } __attribute__((aligned(8))) TCPSPDTEST_STREAM_STRUCT;

#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT), (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_READ(r, p)                                                       MREAD_8((uint8_t *)(p), (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_CPU_RX_RDD_QUEUE_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p), (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_READ(r, p)                                                       MREAD_8((uint8_t *)(p) + 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PPPOE_HDR_OFS_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p) + 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_G(r, g, idx)                                                GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_G(v, g, idx)                                               GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 2, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_READ(r, p)                                                       MREAD_8((uint8_t *)(p) + 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_PEER_RX_SCALE_WRITE(v, p)                                                      MWRITE_8((uint8_t *)(p) + 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_G(r, g, idx)                                                  GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 3, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_READ(r, p)                                                         MREAD_8((uint8_t *)(p) + 3, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_SACK_PERMITTED_WRITE(v, p)                                                        MWRITE_8((uint8_t *)(p) + 3, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_G(r, g, idx)                                                       GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 4, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_READ(r, p)                                                              MREAD_16((uint8_t *)(p) + 4, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MSS_WRITE(v, p)                                                             MWRITE_16((uint8_t *)(p) + 4, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_G(r, g, idx)                                                GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_G(v, g, idx)                                               GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 6, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_READ(r, p)                                                       MREAD_16((uint8_t *)(p) + 6, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_CONN_INFO_UP_TX_MAX_PD_LEN_WRITE(v, p)                                                      MWRITE_16((uint8_t *)(p) + 6, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 8, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 8, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_PKTS_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 8, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_G(r, g, idx)                                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_G(v, g, idx)                                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ_CORE(r, g, idx, core_id)                                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE_CORE(v, g, idx, core_id)                                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 12, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_READ(r, p)                                                                    MREAD_32((uint8_t *)(p) + 12, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TXED_PKTS_WRITE(v, p)                                                                   MWRITE_32((uint8_t *)(p) + 12, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_G(r, g, idx)                                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 16, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_READ(r, p)                                                                   MREAD_32((uint8_t *)(p) + 16, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_FREED_PKTS_WRITE(v, p)                                                                  MWRITE_32((uint8_t *)(p) + 16, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 20, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 20, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ACK_SEQ_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 20, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_G(r, g, idx)                                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_G(v, g, idx)                                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ_CORE(r, g, idx, core_id)                                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE_CORE(v, g, idx, core_id)                                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 24, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_READ(r, p)                                                                       MREAD_32((uint8_t *)(p) + 24, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_TX_SEQ_WRITE(v, p)                                                                      MWRITE_32((uint8_t *)(p) + 24, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_G(r, g, idx)                                                              GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 28, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_READ(r, p)                                                                     MREAD_16((uint8_t *)(p) + 28, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_BAD_PKTS_WRITE(v, p)                                                                    MWRITE_16((uint8_t *)(p) + 28, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_G(r, g, idx)                                                              GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 30, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_READ(r, p)                                                                     MREAD_16((uint8_t *)(p) + 30, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_SRC_PORT_WRITE(v, p)                                                                    MWRITE_16((uint8_t *)(p) + 30, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_G(r, g, idx)                                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_G(v, g, idx)                                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ_CORE(r, g, idx, core_id)                                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE_CORE(v, g, idx, core_id)                                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 32, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_READ(r, p)                                                                     MREAD_32((uint8_t *)(p) + 32, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_WRITE(v, p)                                                                    MWRITE_32((uint8_t *)(p) + 32, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_G(r, g, idx)                                                            GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_G(v, g, idx)                                                           GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ_CORE(r, g, idx, core_id)                                                CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                               CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 36, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_READ(r, p)                                                                   MREAD_32((uint8_t *)(p) + 36, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RX_BYTES_1_WRITE(v, p)                                                                  MWRITE_32((uint8_t *)(p) + 36, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_G(r, g, idx)                                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_G(v, g, idx)                                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ_CORE(r, g, idx, core_id)                                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE_CORE(v, g, idx, core_id)                                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 40, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_READ(r, p)                                                               MREAD_32((uint8_t *)(p) + 40, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_WRITE(v, p)                                                              MWRITE_32((uint8_t *)(p) + 40, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 44, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 44, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_EXPECTED_BYTES_1_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 44, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 48, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 48, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 48, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_G(r, g, idx)                                                    GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 52, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_READ(r, p)                                                           MREAD_32((uint8_t *)(p) + 52, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_TO_SEND_BYTES_1_WRITE(v, p)                                                          MWRITE_32((uint8_t *)(p) + 52, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_G(r, g, idx)                                                 GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_G(v, g, idx)                                                GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ_CORE(r, g, idx, core_id)                                     CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE_CORE(v, g, idx, core_id)                                    CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 56, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_READ(r, p)                                                        MREAD_16((uint8_t *)(p) + 56, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_DISPATCHER_CREDITS_WRITE(v, p)                                                       MWRITE_16((uint8_t *)(p) + 56, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 58, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 58, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_NO_PKTGEN_TX_CREDITS_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 58, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_G(r, g, idx)                                                               GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_G(v, g, idx)                                                              GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ_CORE(r, g, idx, core_id)                                                   CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE_CORE(v, g, idx, core_id)                                                  CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 60, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_READ(r, p)                                                                      MREAD_32((uint8_t *)(p) + 60, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_WRITE(v, p)                                                                     MWRITE_32((uint8_t *)(p) + 60, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_G(r, g, idx)                                                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 64, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_READ(r, p)                                                                  MREAD_32((uint8_t *)(p) + 64, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_THR_WRITE(v, p)                                                                 MWRITE_32((uint8_t *)(p) + 64, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_G(r, g, idx)                                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 68, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_READ(r, p)                                                              MREAD_32((uint8_t *)(p) + 68, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_INITIAL_WRITE(v, p)                                                             MWRITE_32((uint8_t *)(p) + 68, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_G(r, g, idx)                                                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 72, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_READ(r, p)                                                                  MREAD_32((uint8_t *)(p) + 72, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_MAX_WRITE(v, p)                                                                 MWRITE_32((uint8_t *)(p) + 72, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_G(r, g, idx)                                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_G(v, g, idx)                                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ_CORE(r, g, idx, core_id)                                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE_CORE(v, g, idx, core_id)                                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 76, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_READ(r, p)                                                               MREAD_32((uint8_t *)(p) + 76, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_BUDGET_WRITE(v, p)                                                              MWRITE_32((uint8_t *)(p) + 76, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_G(r, g, idx)                                                       GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 80, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_READ(r, p)                                                              MREAD_32((uint8_t *)(p) + 80, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_SEQ_WRITE(v, p)                                                             MWRITE_32((uint8_t *)(p) + 80, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_G(r, g, idx)                                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 84, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_READ(r, p)                                                             MREAD_32((uint8_t *)(p) + 84, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_LAST_ACK_TIME_WRITE(v, p)                                                            MWRITE_32((uint8_t *)(p) + 84, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_G(r, g, idx)                                                         GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_G(v, g, idx)                                                        GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ_CORE(r, g, idx, core_id)                                             CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE_CORE(v, g, idx, core_id)                                            CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 88, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_READ(r, p)                                                                MREAD_32((uint8_t *)(p) + 88, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_SACK_BYTES_WRITE(v, p)                                                               MWRITE_32((uint8_t *)(p) + 88, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 92, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 92, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_TRIG_CNT_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 92, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_G(r, g, idx)                                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_G(v, g, idx)                                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ_CORE(r, g, idx, core_id)                                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE_CORE(v, g, idx, core_id)                                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 96, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_READ(r, p)                                                               MREAD_32((uint8_t *)(p) + 96, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_CNT_WRITE(v, p)                                                              MWRITE_32((uint8_t *)(p) + 96, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_G(r, g, idx)                                                   GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 100, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_READ(r, p)                                                          MREAD_32((uint8_t *)(p) + 100, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_SEQ_DONE_WRITE(v, p)                                                         MWRITE_32((uint8_t *)(p) + 100, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_G(r, g, idx)                                             GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_G(v, g, idx)                                            GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 104, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_READ(r, p)                                                    MREAD_16((uint8_t *)(p) + 104, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_TOTAL_PKTS_CNT_WRITE(v, p)                                                   MWRITE_16((uint8_t *)(p) + 104, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_G(r, g, idx)                                                   GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 106, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_READ(r, p)                                                          MREAD_16((uint8_t *)(p) + 106, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_FAST_RETRANS_CNT_WRITE(v, p)                                                         MWRITE_16((uint8_t *)(p) + 106, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 108, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 108, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_ERR_DN_PKT_CNT_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 108, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_G(r, g, idx)                                                     GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_G(v, g, idx)                                                    GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ_CORE(r, g, idx, core_id)                                         CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE_CORE(v, g, idx, core_id)                                        CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 109, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_READ(r, p)                                                            MREAD_8((uint8_t *)(p) + 109, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_ERR_UP_PKT_CNT_WRITE(v, p)                                                           MWRITE_8((uint8_t *)(p) + 109, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_G(r, g, idx)                                                    GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_G(v, g, idx)                                                   GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ_CORE(r, g, idx, core_id)                                        CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE_CORE(v, g, idx, core_id)                                       CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 110, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_READ(r, p)                                                           MREAD_8((uint8_t *)(p) + 110, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_CWND_RTT_FACTOR_WRITE(v, p)                                                          MWRITE_8((uint8_t *)(p) + 110, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_G(r, g, idx)                                                      GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 111, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_READ(r, p)                                                             MREAD_8((uint8_t *)(p) + 111, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_ERR_DST_PORT_CNT_WRITE(v, p)                                                            MWRITE_8((uint8_t *)(p) + 111, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_G(r, g, idx)                                                      GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 112, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_READ(r, p)                                                             MREAD_16((uint8_t *)(p) + 112, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_WRITE(v, p)                                                            MWRITE_16((uint8_t *)(p) + 112, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_G(r, g, idx)                                                  GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 114, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_READ(r, p)                                                         MREAD_16((uint8_t *)(p) + 114, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_BYTES_THR_CNT_WRITE(v, p)                                                        MWRITE_16((uint8_t *)(p) + 114, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_G(r, g, idx)                                                   GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_G(v, g, idx)                                                  GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ_CORE(r, g, idx, core_id)                                       CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE_CORE(v, g, idx, core_id)                                      CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 116, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_READ(r, p)                                                          MREAD_8((uint8_t *)(p) + 116, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_WRITE(v, p)                                                         MWRITE_8((uint8_t *)(p) + 116, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_G(r, g, idx)                                               GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_G(v, g, idx)                                              GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ_CORE(r, g, idx, core_id)                                   CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE_CORE(v, g, idx, core_id)                                  CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 117, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_READ(r, p)                                                      MREAD_8((uint8_t *)(p) + 117, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DYNACK_THR_UPD_RATE_CNT_WRITE(v, p)                                                     MWRITE_8((uint8_t *)(p) + 117, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_G(r, g, idx)                                                      GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 118, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_READ(r, p)                                                             MREAD_8((uint8_t *)(p) + 118, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_DUP_ACK_STATE_WRITE(v, p)                                                            MWRITE_8((uint8_t *)(p) + 118, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 6, 2, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 6, 2, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_RESERVED2_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 6, 2, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_G(r, g, idx)                                          GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_G(v, g, idx)                                         GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ_CORE(r, g, idx, core_id)                              CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE_CORE(v, g, idx, core_id)                             CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 5, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_READ(r, p)                                                 RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 5, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_DRIVER_WAKEUP_WRITE(v, p)                                                RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 5, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_G(r, g, idx)                                              GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_G(v, g, idx)                                             GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ_CORE(r, g, idx, core_id)                                  CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE_CORE(v, g, idx, core_id)                                 CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 4, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_READ(r, p)                                                     RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 4, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_DN_IS_PKT_DROP_FORCE_ACK_WRITE(v, p)                                                    RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 4, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_G(r, g, idx)                                                     GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_G(v, g, idx)                                                    GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ_CORE(r, g, idx, core_id)                                         CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE_CORE(v, g, idx, core_id)                                        CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 3, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_READ(r, p)                                                            RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 3, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_RX_WIN_STOP_WRITE(v, p)                                                           RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 3, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_G(r, g, idx)                                                         GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_G(v, g, idx)                                                        GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ_CORE(r, g, idx, core_id)                                             CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE_CORE(v, g, idx, core_id)                                            CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 2, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_READ(r, p)                                                                RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 2, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_UP_IS_TIMEOUT_WRITE(v, p)                                                               RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 2, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_G(r, g, idx)                                                      GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_G(v, g, idx)                                                     GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ_CORE(r, g, idx, core_id)                                          CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE_CORE(v, g, idx, core_id)                                         CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 1, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_READ(r, p)                                                             RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 1, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_STREAM_ACTIVE_WRITE(v, p)                                                            RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 1, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_G(r, g, idx)                                                             GROUP_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_G(v, g, idx)                                                            GROUP_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ_CORE(r, g, idx, core_id)                                                 CORE_RDP_FIELD_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE_CORE(v, g, idx, core_id)                                                CORE_RDP_FIELD_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 119, 0, 1, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_READ(r, p)                                                                    RDP_FIELD_MREAD_8((uint8_t *)(p) + 119, 0, 1, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_TCB_IS_UPLOAD_WRITE(v, p)                                                                   RDP_FIELD_MWRITE_8((uint8_t *)(p) + 119, 0, 1, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_G(r, g, idx)                                                       GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_G(v, g, idx)                                                      GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ_CORE(r, g, idx, core_id)                                           CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE_CORE(v, g, idx, core_id)                                          CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 120, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_READ(r, p)                                                              MREAD_8((uint8_t *)(p) + 120, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_DROP_STATE_WRITE(v, p)                                                             MWRITE_8((uint8_t *)(p) + 120, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_G(r, g, idx)                                                      GROUP_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_G(v, g, idx)                                                     GROUP_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ_CORE(r, g, idx, core_id)                                          CORE_MREAD_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE_CORE(v, g, idx, core_id)                                         CORE_MWRITE_8((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 121, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_READ(r, p)                                                             MREAD_8((uint8_t *)(p) + 121, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_IS_WIN_FULL_WRITE(v, p)                                                            MWRITE_8((uint8_t *)(p) + 121, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_G(r, g, idx)                                                         GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_G(v, g, idx)                                                        GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ_CORE(r, g, idx, core_id)                                             CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE_CORE(v, g, idx, core_id)                                            CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 122, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_READ(r, p)                                                                MREAD_16((uint8_t *)(p) + 122, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_NUM_ERRS_WRITE(v, p)                                                               MWRITE_16((uint8_t *)(p) + 122, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_G(r, g, idx)                                                           GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 124, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_READ(r, p)                                                                  MREAD_16((uint8_t *)(p) + 124, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_WR_OFS_WRITE(v, p)                                                                 MWRITE_16((uint8_t *)(p) + 124, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_G(r, g, idx)                                                           GROUP_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_G(v, g, idx)                                                          GROUP_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ_CORE(r, g, idx, core_id)                                               CORE_MREAD_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE_CORE(v, g, idx, core_id)                                              CORE_MWRITE_16((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 126, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_READ(r, p)                                                                  MREAD_16((uint8_t *)(p) + 126, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_RD_OFS_WRITE(v, p)                                                                 MWRITE_16((uint8_t *)(p) + 126, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_G(r, g, idx)                                                GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_G(v, g, idx)                                               GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ_CORE(r, g, idx, core_id)                                    CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE_CORE(v, g, idx, core_id)                                   CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 128, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_READ(r, p)                                                       MREAD_32((uint8_t *)(p) + 128, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_ACK_SEQ_ERR_START_WRITE(v, p)                                                      MWRITE_32((uint8_t *)(p) + 128, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_G(r, g, idx)                                                  GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_G(v, g, idx)                                                 GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ_CORE(r, g, idx, core_id)                                      CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE_CORE(v, g, idx, core_id)                                     CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 132, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_READ(r, p)                                                         MREAD_32((uint8_t *)(p) + 132, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L4_SEQ_WRITE(v, p)                                                        MWRITE_32((uint8_t *)(p) + 132, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_G(r, g, idx)                                             GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_G(v, g, idx)                                            GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ_CORE(r, g, idx, core_id)                                 CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE_CORE(v, g, idx, core_id)                                CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 136, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_READ(r, p)                                                    MREAD_32((uint8_t *)(p) + 136, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_WRITE(v, p)                                                   MWRITE_32((uint8_t *)(p) + 136, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_G(r, g, idx)                                           GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_G(v, g, idx)                                          GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ_CORE(r, g, idx, core_id)                               CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE_CORE(v, g, idx, core_id)                              CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 140, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_READ(r, p)                                                  MREAD_32((uint8_t *)(p) + 140, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RING_RD_WR_OFS_1_WRITE(v, p)                                                 MWRITE_32((uint8_t *)(p) + 140, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_G(r, g, idx)                                              GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_G(v, g, idx)                                             GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ_CORE(r, g, idx, core_id)                                  CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE_CORE(v, g, idx, core_id)                                 CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 144, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_READ(r, p)                                                     MREAD_32((uint8_t *)(p) + 144, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_HDR_LEN_WRITE(v, p)                                                    MWRITE_32((uint8_t *)(p) + 144, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_G(r, g, idx)                                          GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_G(v, g, idx)                                         GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ_CORE(r, g, idx, core_id)                              CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE_CORE(v, g, idx, core_id)                             CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 148, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_READ(r, p)                                                 MREAD_32((uint8_t *)(p) + 148, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_RX_L3_PAYLOAD_LEN_WRITE(v, p)                                                MWRITE_32((uint8_t *)(p) + 148, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 152, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 152, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 152, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ_CORE(r, g, idx, core_id)                          CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE_CORE(v, g, idx, core_id)                         CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 156, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_READ(r, p)                                             MREAD_32((uint8_t *)(p) + 156, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_0_1_WRITE(v, p)                                            MWRITE_32((uint8_t *)(p) + 156, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_G(r, g, idx)                                        GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_G(v, g, idx)                                       GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ_CORE(r, g, idx, core_id)                            CORE_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (r), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE_CORE(v, g, idx, core_id)                           CORE_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 160, (v), core_id)
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_READ(r, p)                                               MREAD_32((uint8_t *)(p) + 160, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_WRITE(v, p)                                              MWRITE_32((uint8_t *)(p) + 160, (v))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_READ_G(r, g, idx)                                      GROUP_MREAD_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 164, (r))
#define RDD_TCPSPDTEST_STREAM_TCPSPDTEST_ENGINE_PKT_DROP_SAVED_PACKET_DESCRIPTOR_2_1_WRITE_G(v, g, idx)                                     GROUP_MWRITE_32((g), (idx)*sizeof(TCPSPDTEST_STREAM_STRUCT) + 164, (v))
#define RDD_TCPSPDTEST_ST