/*
    <:copyright-BRCM:2013:DUAL/GPL:standard
    
       Copyright (c) 2013 Broadcom 
       All Rights Reserved
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

/**** This is an autogenerated file with definitions common to FW and SW ****/

#ifndef _RDD_IH_DEFS_H
#define _RDD_IH_DEFS_H

#include "rdd_runner_defs.h"
#include "rdp_drv_ih.h"

/* default runner for DS */
#define DRV_RDD_IH_DS_DEFAULT_RUNNER   ( DRV_IH_RUNNER_CLUSTER_A )/* constant */
/* default runner for US */
#define DRV_RDD_IH_US_DEFAULT_RUNNER   ( DRV_IH_RUNNER_CLUSTER_B )/* constant */

/* common for all ports */
#define DRV_RDD_IH_PACKET_HEADER_OFFSET   ( 18 )

#define DRV_RDD_IH_RUNNER_0_MAXIMAL_NUMBER_OF_BUFFERS   ( 32 )
#define DRV_RDD_IH_RUNNER_1_MAXIMAL_NUMBER_OF_BUFFERS   ( 32 )

#define DRV_RDD_IH_CAM_SEARCH_ENABLE_UPON_INVALID_LUT_ENTRY   ( 0 )/* constant */

#define DRV_RDD_IH_RUNNER_0_IH_MANAGED_RB_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_RUNNER_1_IH_MANAGED_RB_BASE_ADDRESS   ( 0x0 )

/* not in use in 1st phase */
#define DRV_RDD_IH_RUNNER_0_RUNNER_MANAGED_RB_BASE_ADDRESS   ( 0 )/* constant */
#define DRV_RDD_IH_RUNNER_1_RUNNER_MANAGED_RB_BASE_ADDRESS   ( 0 )/* constant */

/* not in use in 1st phase */
#define DRV_RDD_IH_RUNNER_0_IH_CONGESTION_REPORT_ADDRESS   ( 0 )/* constant */
#define DRV_RDD_IH_RUNNER_1_IH_CONGESTION_REPORT_ADDRESS   ( 0 )/* constant */

/* not in use in 1st phase */
#define DRV_RDD_IH_RUNNER_0_IH_CONGESTION_REPORT_ENABLE   ( 0 )/* constant */
#define DRV_RDD_IH_RUNNER_1_IH_CONGESTION_REPORT_ENABLE   ( 0 )/* constant */

/* Lookup tables configuration */

#define DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_1 )
#define DRV_RDD_IH_LOOKUP_TABLE_IPTV_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_2 )
#define DRV_RDD_IH_LOOKUP_TABLE_DS_INGRESS_CLASSIFICATION_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_3 )
#define DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_4 )
#define DRV_RDD_IH_LOOKUP_TABLE_IPTV_SRC_IP_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_6 )
#define DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_BROADCOM_SWITCH_LAN_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_8 )
#define DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX			( DRV_IH_CLASS_SEARCH_LOOKUP_TABLE_9 )

#define DRV_RDD_IH_LOOKUP_TABLE_1_BASE_ADDRESS   MAC_TABLE_ADDRESS
#define DRV_RDD_IH_LOOKUP_TABLE_2_BASE_ADDRESS   ( 0x2000 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_BASE_ADDRESS   ( 0xA000 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_BASE_ADDRESS   ( 0xA800 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_BASE_ADDRESS   ( 0x3300 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_BASE_ADDRESS   MAC_TABLE_ADDRESS
#define DRV_RDD_IH_LOOKUP_TABLE_9_BASE_ADDRESS   MAC_TABLE_ADDRESS

#define DRV_RDD_IH_LOOKUP_TABLE_1_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_64_ENTRIES )
#define DRV_RDD_IH_LOOKUP_TABLE_2_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_256_ENTRIES )
#define DRV_RDD_IH_LOOKUP_TABLE_3_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_256_ENTRIES )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_256_ENTRIES )
#define DRV_RDD_IH_LOOKUP_TABLE_6_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_32_ENTRIES )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_64_ENTRIES )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SIZE   ( DRV_IH_LOOKUP_TABLE_SIZE_64_ENTRIES )

#define DRV_RDD_IH_LOOKUP_TABLE_1_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_4_STEPS )
#define DRV_RDD_IH_LOOKUP_TABLE_2_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_32_STEPS )
#define DRV_RDD_IH_LOOKUP_TABLE_3_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_32_STEPS )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_32_STEPS )
#define DRV_RDD_IH_LOOKUP_TABLE_6_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_32_STEPS )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_4_STEPS )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SEARCH_DEPTH   ( DRV_IH_LOOKUP_TABLE_MAXIMAL_SEARCH_DEPTH_4_STEPS )


/* same for all lookup tables */
#define DRV_RDD_IH_LOOKUP_TABLE_1_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_HASH_TYPE   ( DRV_IH_LOOKUP_TABLE_HASH_TYPE_CRC16 )

#define DRV_RDD_IH_LOOKUP_TABLE_1_SA_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_SA_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_SA_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SA_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_SA_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SA_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SA_ENABLE   ( 1 )

#define DRV_RDD_IH_LOOKUP_TABLE_1_AGING_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_AGING_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_AGING_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_AGING_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_AGING_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_AGING_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_AGING_ENABLE   ( 0 )

#define DRV_RDD_IH_LOOKUP_TABLE_1_CAM_ENABLE   ( 1 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_CAM_ENABLE   ( 1 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_CAM_ENABLE   ( 1 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_CAM_ENABLE   ( 1 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_CAM_ENABLE   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_CAM_ENABLE   ( 1 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_CAM_ENABLE   ( 1 )

#define DRV_RDD_IH_LOOKUP_TABLE_1_CAM_BASE_ADDRESS   MAC_TABLE_CAM_ADDRESS
#define DRV_RDD_IH_LOOKUP_TABLE_2_CAM_BASE_ADDRESS   ( 0x3100 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_CAM_BASE_ADDRESS   ( 0x9300 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_CAM_BASE_ADDRESS   ( 0x9C00 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_CAM_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_CAM_BASE_ADDRESS   MAC_TABLE_CAM_ADDRESS
#define DRV_RDD_IH_LOOKUP_TABLE_9_CAM_BASE_ADDRESS   MAC_TABLE_CAM_ADDRESS

#define DRV_RDD_IH_CONTEXT_TABLE_1_BASE_ADDRESS   MAC_CONTEXT_TABLE_ADDRESS
#define DRV_RDD_IH_CONTEXT_TABLE_2_BASE_ADDRESS   ( 0x3000 )
#define DRV_RDD_IH_CONTEXT_TABLE_3_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_CONTEXT_TABLE_4_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_CONTEXT_TABLE_6_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_CONTEXT_TABLE_8_BASE_ADDRESS   MAC_CONTEXT_TABLE_ADDRESS
#define DRV_RDD_IH_CONTEXT_TABLE_9_BASE_ADDRESS   MAC_CONTEXT_TABLE_ADDRESS

#define DRV_RDD_IH_CONTEXT_TABLE_1_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_2_BYTES )
#define DRV_RDD_IH_CONTEXT_TABLE_2_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_1_BYTE )
#define DRV_RDD_IH_CONTEXT_TABLE_3_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_INTERNAL_ENTRY )
#define DRV_RDD_IH_CONTEXT_TABLE_4_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_INTERNAL_ENTRY )
#define DRV_RDD_IH_CONTEXT_TABLE_6_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_INTERNAL_ENTRY )
#define DRV_RDD_IH_CONTEXT_TABLE_8_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_2_BYTES )
#define DRV_RDD_IH_CONTEXT_TABLE_9_ENTRY_SIZE   ( DRV_IH_LOOKUP_CONTEXT_TABLE_ENTRY_SIZE_2_BYTES )

#define DRV_RDD_IH_CONTEXT_TABLE_1_CAM_BASE_ADDRESS   MAC_CONTEXT_TABLE_CAM_ADDRESS
#define DRV_RDD_IH_CONTEXT_TABLE_2_CAM_BASE_ADDRESS   ( 0x38E0 )
#define DRV_RDD_IH_CONTEXT_TABLE_3_CAM_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_CONTEXT_TABLE_4_CAM_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_CONTEXT_TABLE_6_CAM_BASE_ADDRESS   ( 0x0 )
#define DRV_RDD_IH_CONTEXT_TABLE_8_CAM_BASE_ADDRESS   MAC_CONTEXT_TABLE_CAM_ADDRESS
#define DRV_RDD_IH_CONTEXT_TABLE_9_CAM_BASE_ADDRESS   MAC_CONTEXT_TABLE_CAM_ADDRESS

/* Table 1: DST_MAC_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_0_START_OFFSET   ( 2 )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_0_MASK_HIGH      ( 0xFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_1_DST_MAC_KEY_GLOBAL_MASK           ( 0xFFF )

/* Table 9: SRC_MAC_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_0_START_OFFSET   ( 4 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_0_MASK_HIGH      ( 0xFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_9_SRC_MAC_KEY_GLOBAL_MASK           ( 0xFFF )

/* Table 8: SRC_MAC_BROADCOM_SWITCH_LAN_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_0_START_OFFSET   ( 4 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_0_MASK_HIGH      ( 0xFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_8_SRC_MAC_BROADCOM_SWITCH_LAN_KEY_GLOBAL_MASK           ( 0xFFF )

/* Table 2: IPTV_DA_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_0_START_OFFSET   ( 2 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_0_MASK_HIGH      ( 0xFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_KEY_GLOBAL_MASK           ( 0xFFF )

/* Table 2: IPTV_DA_VID_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_0_START_OFFSET   ( 2 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_1_START_OFFSET   ( 2 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_0_MASK_HIGH      ( 0xFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_DA_VID_KEY_GLOBAL_MASK           ( 0x7FFF )

/* Table 2: IPTV_L3_DIP_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_0_START_OFFSET   ( 10 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_KEY_GLOBAL_MASK           ( 0xFF )

/* Table 2: IPTV_L3_DIP_SIP_VID_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_0_START_OFFSET   ( 10 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_1_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_PART_1_MASK_HIGH      ( 0xFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_2_IPTV_L3_DIP_SIP_VID_KEY_GLOBAL_MASK           ( 0x7FF )

/* Table 6 */
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_0_START_OFFSET   ( 10 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_0_SHIFT          ( 8 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_0_MASK_LOW       ( 0xFFFFFFFF )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_6_KEY_GLOBAL_MASK           ( 0x1FF )

/* Table 3: VID_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_0_MASK_LOW       ( 0x1FFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 3: PBITS_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_0_MASK_LOW       ( 0xF00000 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 3: VID_PBITS_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_0_MASK_LOW       ( 0xFFFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 3: VID_GEM_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_GEM_FLOW_ID )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_0_MASK_LOW       ( 0x1FFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_GEM_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 3: PBITS_GEM_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_GEM_FLOW_ID )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_0_MASK_LOW       ( 0xF00000 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_PBITS_GEM_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 3: VID_PBITS_GEM_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_GEM_FLOW_ID )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_0_MASK_LOW       ( 0xFFFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_VID_PBITS_GEM_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 3: GEM_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_0_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_GEM_FLOW_ID )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_0_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_3_GEM_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: VID_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_0_MASK_LOW       ( 0x1FFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: PBITS_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_0_MASK_LOW       ( 0xF00000 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: VID_PBITS_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_DISABLE )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_0_MASK_LOW       ( 0xFFFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: VID_SRC_PORT_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_SOURCE_PORT )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_0_MASK_LOW       ( 0x1FFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_SRC_PORT_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: PBITS_SRC_PORT_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_SOURCE_PORT )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_0_MASK_LOW       ( 0xF00000 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_PBITS_SRC_PORT_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: VID_PBITS_SRC_PORT_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_0_START_OFFSET   ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_0_SHIFT          ( 6 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_SOURCE_PORT )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_0_MASK_LOW       ( 0xFFFF00 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_VID_PBITS_SRC_PORT_KEY_GLOBAL_MASK           ( 0x1F3F )

/* Table 4: SRC_PORT_METHOD */
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_0_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_0_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_1_START_OFFSET   ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_1_SHIFT          ( 0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_KEY_EXTENSION         ( DRV_IH_LOOKUP_KEY_EXTENSION_SOURCE_PORT )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_0_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_0_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_1_MASK_LOW       ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_PART_1_MASK_HIGH      ( 0x0 )
#define DRV_RDD_IH_LOOKUP_TABLE_4_SRC_PORT_KEY_GLOBAL_MASK           ( 0x1F3F )


/**** Classes configuration ****/

/* Classes indices */
#define DRV_RDD_IH_CLASS_WAN_CONTROL_INDEX			( 0 )
#define DRV_RDD_IH_CLASS_IPTV_INDEX			( 1 )
#define DRV_RDD_IH_CLASS_PCI_INDEX			( 2 )
#define DRV_RDD_IH_CLASS_WAN_BRIDGED_HIGH_INDEX			( 8 )
#define DRV_RDD_IH_CLASS_WAN_BRIDGED_LOW_INDEX			( 9 )
#define DRV_RDD_IH_CLASS_LAN_BRIDGED_ETH0_INDEX			( 10 )
#define DRV_RDD_IH_CLASS_LAN_BRIDGED_ETH1_INDEX			( 11 )
#define DRV_RDD_IH_CLASS_LAN_BRIDGED_ETH2_INDEX			( 12 )
#define DRV_RDD_IH_CLASS_LAN_BRIDGED_ETH3_INDEX			( 13 )
#define DRV_RDD_IH_CLASS_LAN_BRIDGED_ETH4_INDEX			( 14 )

/* Class 0: WAN_CONTROL */
#define DRV_RDD_IH_CLASS_0_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_0_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_0_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_0_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_DS_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_0_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_0_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_0_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_0_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_0_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_0_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_0_TARGET_MEMORY_OVERRIDE                 ( 1 )
#define DRV_RDD_IH_CLASS_0_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_0_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_0_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_DS_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_0_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_0_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_DS_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_0_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_0_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 1: IPTV */
#define DRV_RDD_IH_CLASS_1_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_IPTV_INDEX )
#define DRV_RDD_IH_CLASS_1_CLASS_SEARCH_2                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_1_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_1_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_DS_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_1_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_1_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_1_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_1_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_1_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_1_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_1_TARGET_MEMORY_OVERRIDE                 ( 0 )
#define DRV_RDD_IH_CLASS_1_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_1_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_1_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_DS_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_1_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_1_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_DS_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_1_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_1_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 2: PCI */
#define DRV_RDD_IH_CLASS_2_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_2_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_2_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_2_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_2_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_2_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_2_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_2_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_2_DIRECT_MODE_OVERRIDE                   ( 1 )
#define DRV_RDD_IH_CLASS_2_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_2_TARGET_MEMORY_OVERRIDE                 ( 0 )
#define DRV_RDD_IH_CLASS_2_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_2_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_2_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_2_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_2_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_2_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_2_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 8: WAN_BRIDGED_HIGH */
#define DRV_RDD_IH_CLASS_8_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_8_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_8_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_8_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_DS_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_8_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_8_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_8_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_8_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_8_DIRECT_MODE_OVERRIDE                   ( 1 )
#define DRV_RDD_IH_CLASS_8_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_8_TARGET_MEMORY_OVERRIDE                 ( 0 )
#define DRV_RDD_IH_CLASS_8_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_HIGH )
#define DRV_RDD_IH_CLASS_8_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_8_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_DS_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_8_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 1 )
#define DRV_RDD_IH_CLASS_8_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_8_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_8_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 9: WAN_BRIDGED_LOW */
#define DRV_RDD_IH_CLASS_9_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_9_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_9_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_9_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_DS_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_9_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_9_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_9_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_9_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_9_DIRECT_MODE_OVERRIDE                   ( 1 )
#define DRV_RDD_IH_CLASS_9_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_9_TARGET_MEMORY_OVERRIDE                 ( 0 )
#define DRV_RDD_IH_CLASS_9_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_9_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_9_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_DS_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_9_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 1 )
#define DRV_RDD_IH_CLASS_9_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_9_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_9_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 10: LAN_BRIDGED_ETH0 */
#define DRV_RDD_IH_CLASS_10_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_10_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_10_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_10_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_10_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_10_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_10_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_10_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_10_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_10_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_10_TARGET_MEMORY_OVERRIDE                 ( 1 )
#define DRV_RDD_IH_CLASS_10_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_10_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_10_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_10_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_10_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_10_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_10_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 11: LAN_BRIDGED_ETH1 */
#define DRV_RDD_IH_CLASS_11_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_11_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_11_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_11_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_11_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_11_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_11_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_11_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_11_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_11_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_11_TARGET_MEMORY_OVERRIDE                 ( 1 )
#define DRV_RDD_IH_CLASS_11_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_11_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_11_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_11_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_11_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_11_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_11_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 12: LAN_BRIDGED_ETH2 */
#define DRV_RDD_IH_CLASS_12_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_12_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_12_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_12_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_12_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_12_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_12_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_12_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_12_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_12_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_12_TARGET_MEMORY_OVERRIDE                 ( 1 )
#define DRV_RDD_IH_CLASS_12_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_12_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_12_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_12_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_12_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_12_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_12_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 13: LAN_BRIDGED_ETH3 */
#define DRV_RDD_IH_CLASS_13_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_13_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_13_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_13_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_13_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_13_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_13_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_13_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_13_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_13_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_13_TARGET_MEMORY_OVERRIDE                 ( 1 )
#define DRV_RDD_IH_CLASS_13_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_13_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_13_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_13_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_13_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_13_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_13_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class 14: LAN_BRIDGED_ETH4 */
#define DRV_RDD_IH_CLASS_14_CLASS_SEARCH_1                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_DA_INDEX )
#define DRV_RDD_IH_CLASS_14_CLASS_SEARCH_2                         ( DRV_RDD_IH_LOOKUP_TABLE_MAC_SA_INDEX )
#define DRV_RDD_IH_CLASS_14_CLASS_SEARCH_3                         ( DRV_IH_CLASS_SEARCH_DISABLED )
#define DRV_RDD_IH_CLASS_14_CLASS_SEARCH_4                         ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_14_DESTINATION_PORT_EXTRACTION            ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_BASED_ON_SEARCH1 )
#define DRV_RDD_IH_CLASS_14_DROP_ON_MISS                           ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )
#define DRV_RDD_IH_CLASS_14_DSCP_TO_PBITS_TABLE_INDEX              ( 0 )
#define DRV_RDD_IH_CLASS_14_DIRECT_MODE_DEFAULT                    ( 0 )
#define DRV_RDD_IH_CLASS_14_DIRECT_MODE_OVERRIDE                   ( 0 )
#define DRV_RDD_IH_CLASS_14_TARGET_MEMORY_DEFAULT                  ( DRV_IH_TARGET_MEMORY_DDR )
#define DRV_RDD_IH_CLASS_14_TARGET_MEMORY_OVERRIDE                 ( 1 )
#define DRV_RDD_IH_CLASS_14_INGRESS_QOS_DEFAULT                    ( DRV_IH_INGRESS_QOS_LOW )
#define DRV_RDD_IH_CLASS_14_INGRESS_QOS_OVERRIDE                   ( DRV_IH_OPERATION_BASED_ON_CLASS_SEARCH_OPERATION_DISABLED )/* constant */
#define DRV_RDD_IH_CLASS_14_TARGET_RUNNER_DEFAULT                  ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_14_TARGET_RUNNER_OVERRIDE_IN_DIRECT_MODE  ( 0 )
#define DRV_RDD_IH_CLASS_14_TARGET_RUNNER_FOR_DIRECT_MODE          ( DRV_RDD_IH_US_DEFAULT_RUNNER )
#define DRV_RDD_IH_CLASS_14_LOAD_BALANCING_ENABLE                  ( 0 )/* constant */
#define DRV_RDD_IH_CLASS_14_PREFERENCE_LOAD_BALANCING_ENABLE       ( 0 )/* constant */

/* Class search alternatives, according to user configuration.*/
#define DRV_RDD_IH_CLASS_10_CLASS_SEARCH_4_ALTERNATIVE  ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_11_CLASS_SEARCH_4_ALTERNATIVE  ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_12_CLASS_SEARCH_4_ALTERNATIVE  ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_13_CLASS_SEARCH_4_ALTERNATIVE  ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_14_CLASS_SEARCH_4_ALTERNATIVE  ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_2_CLASS_SEARCH_4_ALTERNATIVE  ( DRV_RDD_IH_LOOKUP_TABLE_US_INGRESS_CLASSIFICATION_INDEX )
#define DRV_RDD_IH_CLASS_1_CLASS_SEARCH_2_ALTERNATIVE  ( DRV_IH_CLASS_SEARCH_DISABLED )
#endif
