// <:copyright-BRCM:2013:DUAL/GPL:standard
// 
//    Copyright (c) 2013 Broadcom 
//    All Rights Reserved
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License, version 2, as published by
// the Free Software Foundation (the "GPL").
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// 
// A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
// writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
// 
// :>

#ifndef _RDPA_USER_H_
#define _RDPA_USER_H_

#include <bcmtypes.h> /* BCM_IOC_PTR */
#include <bdmf_system.h> /* bdmf_handles */
#include <bdmf_interface.h> /* bdmf_handles */

#define DRIVER_IOCTL 0x11
#define RDPA_USR_DEV_NAME "/dev/rdpa_user"


typedef struct {
    int32_t                         ret;     
    BCM_IOC_PTR(bdmf_type_handle,   drv);    
    BCM_IOC_PTR(bdmf_object_handle, mo);
    BCM_IOC_PTR(bdmf_object_handle, object);
    uint32_t                        cmd;
    bdmf_ptr                        ptr;
    uint64_t                        parm;
    bdmf_ptr                        ai_ptr;
    bdmf_index                      ai;
    uint32_t                        size;
        
} rdpa_ioctl_cmd_t;


typedef struct {
    int32_t                         ret;   
    BCM_IOC_PTR(bdmf_type_handle,   drv);
    BCM_IOC_PTR(bdmf_object_handle, mo_or_us);
    BCM_IOC_PTR(bdmf_object_handle, owner_or_ds);
    BCM_IOC_PTR(bdmf_mattr_handle,  mattr);
    BCM_IOC_PTR(bdmf_link_handle,   link);
    BCM_IOC_PTR(const char *,       str);
} bdmf_ioctl_t;


typedef union {
    bdmf_ioctl_t bdmf_pa;
    rdpa_ioctl_cmd_t rdpa_pa;
} ioctl_pa_t;

#define RDPA_PORT_IOCTL         _IOWR(DRIVER_IOCTL, 100, ioctl_pa_t)
#define RDPA_EGRESS_TM_IOCTL    _IOWR(DRIVER_IOCTL, 101, ioctl_pa_t)
#define RDPA_TCONT_IOCTL        _IOWR(DRIVER_IOCTL, 102, ioctl_pa_t)
#define RDPA_VLAN_IOCTL         _IOWR(DRIVER_IOCTL, 103, ioctl_pa_t)
#define RDPA_VLAN_ACTION_IOCTL  _IOWR(DRIVER_IOCTL, 104, ioctl_pa_t)
#define RDPA_SYSTEM_IOCTL       _IOWR(DRIVER_IOCTL, 105, ioctl_pa_t)
#define RDPA_IPTV_IOCTL         _IOWR(DRIVER_IOCTL, 106, ioctl_pa_t)
#define RDPA_TC_TO_QUEUE_IOCTL  _IOWR(DRIVER_IOCTL, 107, ioctl_pa_t)
#define RDPA_LLID_IOCTL         _IOWR(DRIVER_IOCTL, 108, ioctl_pa_t)
#define RDPA_INGRESS_CLASS_IOCTL  _IOWR(DRIVER_IOCTL, 109, ioctl_pa_t)
#define RDPA_POLICER_IOCTL        _IOWR(DRIVER_IOCTL, 110, ioctl_pa_t)
#define RDPA_PBIT_TO_QUEUE_IOCTL  _IOWR(DRIVER_IOCTL, 111, ioctl_pa_t)
#define RDPA_PBIT_TO_GEM_IOCTL    _IOWR(DRIVER_IOCTL, 112, ioctl_pa_t)
#define RDPA_DSCP_TO_PBIT_IOCTL   _IOWR(DRIVER_IOCTL, 113, ioctl_pa_t)
#define RDPA_UDPSPDTEST_IOCTL   _IOWR(DRIVER_IOCTL, 114, ioctl_pa_t)
#define RDPA_CAPWAP_IOCTL       _IOWR(DRIVER_IOCTL, 115, ioctl_pa_t)
#define RDPA_CAPWAP_REASSEMBLY_IOCTL _IOWR(DRIVER_IOCTL, 116, ioctl_pa_t)
#define RDPA_MLLID_IOCTL        _IOWR(DRIVER_IOCTL, 117, ioctl_pa_t)
#define RDPA_CAPWAP_FRAGMENTATION_IOCTL _IOWR(DRIVER_IOCTL, 118, ioctl_pa_t)
#define RDPA_MCAST_WHITELIST_IOCTL _IOWR(DRIVER_IOCTL, 119, ioctl_pa_t)
#define RDPA_FILTER_IOCTL _IOWR(DRIVER_IOCTL, 120, ioctl_pa_t)
#define RDPA_CPU_IOCTL _IOWR(DRIVER_IOCTL, 121, ioctl_pa_t)
#define RDPA_IP_CLASS_IOCTL _IOWR(DRIVER_IOCTL, 122, ioctl_pa_t)
#define RDPA_XTM_IOCTL          _IOWR(DRIVER_IOCTL, 123, ioctl_pa_t)
#define RDPA_XTMCHANNEL_IOCTL   _IOWR(DRIVER_IOCTL, 124, ioctl_pa_t)
#define RDPA_XTMFLOW_IOCTL      _IOWR(DRIVER_IOCTL, 125, ioctl_pa_t)
#define RDPA_RATE_LIMIT_IOCTL   _IOWR(DRIVER_IOCTL, 126, ioctl_pa_t)


#define PORT_OBJECT 1
#define SYSTEM_OBJECT 1
#define EGRESS_TM_OBJECT 1
#define CPU_OBJECT 1
/* #if defined(CONFIG_BCM_EPON) */
/* EPON/GPON are included in builds unconditionally and entangled a lot at different
 * places in the code --- need some effort to clean things up */
#if !(defined(CONFIG_BCM963146) || defined(CONFIG_BCM94912))
#define LLID_OBJECT 1
#define MLLID_OBJECT 1
#endif

#if defined(POLICER_SUPPORT)
#define POLICER_OBJECT 1
#endif

#define RATE_LIMIT_OBJECT 1

#if defined(BCM_PON) || defined(CONFIG_BCM_PON)
#if (!defined(CONFIG_BCM96855) && !defined(CONFIG_BCM96888) && !defined(CONFIG_BCM96837) && !defined(CONFIG_BCM968880))
#define VLAN_OBJECT 1
#define VLAN_ACTION_OBJECT 1
#define IPTV_OBJECT 1
#if defined(CONFIG_BCM_PLATFORM_RDP_PRV)
#define TC_TO_QUEUE_OBJECT 1  
#endif
#define PBIT_TO_QUEUE_OBJECT 1
#define PBIT_TO_GEM_OBJECT 1
#define DSCP_TO_PBIT_OBJECT 1
#define IP_CLASS_OBJECT 1
#endif
#endif /* defined(BCM_PON) || defined(CONFIG_BCM_PON)*/

#if defined(BCM_PON) || defined(CONFIG_BCM_PON) || defined(CONFIG_BCM963158) || defined(CONFIG_BCM96813)
#define TCONT_OBJECT 1
#define INGRESS_CLASS_OBJECT 1
#if !defined(CONFIG_BCM_PLATFORM_RDP_PRV)
#define MCAST_WHITELIST_OBJECT 1
#endif
#endif /* defined(BCM_PON) || defined(CONFIG_BCM_PON) || defined(CONFIG_BCM963158) */

#if (defined(CONFIG_BCM_SPDSVC_SUPPORT) || defined(CONFIG_BCM_SPDTEST)) && !defined(BCM_DSL_RDP)
#define UDPSPDTEST_OBJECT 1
#endif

#define FILTER_OBJECT 1

#if defined(CONFIG_BCM_CAPWAP)
#define CAPWAP_OBJECT 1
#endif

#if defined(CONFIG_BCM963138) || defined(CONFIG_BCM963148) || defined(CONFIG_BCM963158) || defined(CONFIG_BCM963146)
#define XTM_OBJECT 1
#define XTMCHANNEL_OBJECT 1
#define XTMFLOW_OBJECT 1
#endif

#ifndef __KERNEL__ 

#define CC_RDPA_USR_DEBUG 1 

#if defined(CC_RDPA_USR_DEBUG)
#define rdpa_usr_debug(fmt, arg...) printf("%s.%u: " fmt "\n", __FUNCTION__, __LINE__, ##arg)
#else
#define rdpa_usr_debug(fmt, arg...)
#endif

#define rdpa_usr_error(fmt, arg...) printf("ERROR[%s.%u]: " fmt "\n", __FUNCTION__, __LINE__, ##arg)

#endif /* __KERNEL__ */
#endif /* _RDPA_USER_H_ */
