// <:copyright-BRCM:2013:DUAL/GPL:standard
// 
//    Copyright (c) 2013 Broadcom 
//    All Rights Reserved
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License, version 2, as published by
// the Free Software Foundation (the "GPL").
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// 
// A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
// writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
// 
// :>
/*
 * system object ioctl functions implementation file.
 * This ioctl file is generated automatically. Do not edit!
 */
#include "rdpa_api.h"
#include "rdpa_user.h"
#include "rdpa_user_int.h"
#include "rdpa_system_user_ioctl_ag.h"

static int rdpa_user_system_drv(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside rdpa_user_system_drv\n");

	if (!(pa->drv = rdpa_system_drv()))
	{
		BDMF_TRACE_DBG("rdpa_system_drv failed\n");
	}

	return 0;
}

static int rdpa_user_system_get(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside rdpa_user_system_drv\n");

	if ((pa->ret = rdpa_system_get(&pa->mo)))
	{
		BDMF_TRACE_DBG("rdpa_system_get failed ret: %d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_init_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_init_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_init_cfg_get\n");

	if ((pa->ret = rdpa_system_init_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_init_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_system_init_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_init_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_init_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_init_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_system_init_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_init_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_init_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_cfg_get\n");

	if ((pa->ret = rdpa_system_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_system_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_system_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_sw_version_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_sw_version_t  parm;

	BDMF_TRACE_DBG("inside system_user_sw_version_get\n");

	if ((pa->ret = rdpa_system_sw_version_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_sw_version_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_sw_version_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_clock_gate_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside system_user_clock_gate_get\n");

	if ((pa->ret = rdpa_system_clock_gate_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_clock_gate_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_clock_gate_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_clock_gate_set\n");

	if ((pa->ret = rdpa_system_clock_gate_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_clock_gate_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_stat_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_stat_t  parm;

	BDMF_TRACE_DBG("inside system_user_stat_get\n");

	if ((pa->ret = rdpa_system_stat_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_stat_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_system_stat_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_stat_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_stat_t  parm;

	BDMF_TRACE_DBG("inside system_user_stat_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_system_stat_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_stat_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_stat_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_drop_precedence_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_dp_key_t  ai;
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside system_user_drop_precedence_get\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(rdpa_dp_key_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_drop_precedence_get(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_drop_precedence_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_drop_precedence_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_dp_key_t  ai;

	BDMF_TRACE_DBG("inside system_user_drop_precedence_set\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(rdpa_dp_key_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_drop_precedence_set(pa->mo, &ai, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_drop_precedence_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_drop_precedence_get_next(rdpa_ioctl_cmd_t *pa)
{
	rdpa_dp_key_t  ai;

	BDMF_TRACE_DBG("inside system_user_drop_precedence_get_next\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(rdpa_dp_key_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_drop_precedence_get_next(pa->mo, &ai)))
	{
		BDMF_TRACE_DBG("rdpa_system_drop_precedence_get_next failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(rdpa_dp_key_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_tpid_detect_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_tpid_detect_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_tpid_detect_get\n");

	if ((pa->ret = rdpa_system_tpid_detect_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_tpid_detect_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_tpid_detect_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_tpid_detect_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_tpid_detect_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_tpid_detect_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_tpid_detect_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_tpid_detect_set(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_tpid_detect_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_tod_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_tod_t  parm;

	BDMF_TRACE_DBG("inside system_user_tod_get\n");

	if ((pa->ret = rdpa_system_tod_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_tod_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_system_tod_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_cpu_reason_to_tc_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside system_user_cpu_reason_to_tc_get\n");

	if ((pa->ret = rdpa_system_cpu_reason_to_tc_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_cpu_reason_to_tc_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_cpu_reason_to_tc_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_cpu_reason_to_tc_set\n");

	if ((pa->ret = rdpa_system_cpu_reason_to_tc_set(pa->mo, pa->ai, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_cpu_reason_to_tc_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_ipv4_host_address_table_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_ipv4 parm;

	BDMF_TRACE_DBG("inside system_user_ipv4_host_address_table_get\n");

	if ((pa->ret = rdpa_system_ipv4_host_address_table_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ipv4_host_address_table_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_ipv4)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ipv4_host_address_table_add(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;

	BDMF_TRACE_DBG("inside system_user_ipv4_host_address_table_add\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_ipv4_host_address_table_add(pa->mo, &ai, (bdmf_ipv4)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ipv4_host_address_table_add failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ipv4_host_address_table_delete(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside system_ipv4_host_address_table_delete\n");

	if ((pa->ret = rdpa_system_ipv4_host_address_table_delete(pa->mo, (bdmf_index)pa->ai)))
	{
		BDMF_TRACE_ERR("rdpa_system_ipv4_host_address_table_delete failed\n");
	}

	return 0;
}

static int rdpa_user_system_ipv4_host_address_table_find(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	bdmf_ipv4 parm;

	BDMF_TRACE_DBG("inside system_user_ipv4_host_address_table_find\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(bdmf_ipv4)))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_ipv4_host_address_table_find(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ipv4_host_address_table_find failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_ipv4)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ipv6_host_address_table_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_ipv6_t  parm;

	BDMF_TRACE_DBG("inside system_user_ipv6_host_address_table_get\n");

	if ((pa->ret = rdpa_system_ipv6_host_address_table_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ipv6_host_address_table_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_ipv6_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ipv6_host_address_table_add(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	bdmf_ipv6_t  parm;

	BDMF_TRACE_DBG("inside system_user_ipv6_host_address_table_add\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(bdmf_ipv6_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_ipv6_host_address_table_add(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ipv6_host_address_table_add failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ipv6_host_address_table_delete(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside system_ipv6_host_address_table_delete\n");

	if ((pa->ret = rdpa_system_ipv6_host_address_table_delete(pa->mo, (bdmf_index)pa->ai)))
	{
		BDMF_TRACE_ERR("rdpa_system_ipv6_host_address_table_delete failed\n");
	}

	return 0;
}

static int rdpa_user_system_ipv6_host_address_table_find(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	bdmf_ipv6_t  parm;

	BDMF_TRACE_DBG("inside system_user_ipv6_host_address_table_find\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(bdmf_ipv6_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_ipv6_host_address_table_find(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ipv6_host_address_table_find failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_ipv6_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_qm_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_qm_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_qm_cfg_get\n");

	if ((pa->ret = rdpa_system_qm_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_qm_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_qm_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_qm_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_qm_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_qm_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_qm_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_qm_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_qm_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_packet_buffer_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_packet_buffer_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_packet_buffer_cfg_get\n");

	if ((pa->ret = rdpa_system_packet_buffer_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_packet_buffer_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_packet_buffer_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_packet_buffer_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_packet_buffer_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_packet_buffer_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_packet_buffer_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_packet_buffer_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_packet_buffer_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_high_prio_tc_threshold_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_cpu_tc parm;

	BDMF_TRACE_DBG("inside system_user_high_prio_tc_threshold_get\n");

	if ((pa->ret = rdpa_system_high_prio_tc_threshold_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_high_prio_tc_threshold_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_cpu_tc)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_high_prio_tc_threshold_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_high_prio_tc_threshold_set\n");

	if ((pa->ret = rdpa_system_high_prio_tc_threshold_set(pa->mo, (rdpa_cpu_tc)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_high_prio_tc_threshold_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_counter_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_counter_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_counter_cfg_get\n");

	if ((pa->ret = rdpa_system_counter_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_counter_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_counter_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_counter_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_counter_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_counter_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_counter_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_counter_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_counter_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_fpm_isr_delay_timer_period_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside system_user_fpm_isr_delay_timer_period_get\n");

	if ((pa->ret = rdpa_system_fpm_isr_delay_timer_period_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpm_isr_delay_timer_period_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_fpm_isr_delay_timer_period_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_fpm_isr_delay_timer_period_set\n");

	if ((pa->ret = rdpa_system_fpm_isr_delay_timer_period_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpm_isr_delay_timer_period_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_natc_counter_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_natc_cntr_t  parm;

	BDMF_TRACE_DBG("inside system_user_natc_counter_get\n");

	if ((pa->ret = rdpa_system_natc_counter_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_natc_counter_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_natc_cntr_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_natc_counter_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_natc_cntr_t  parm;

	BDMF_TRACE_DBG("inside system_user_natc_counter_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_natc_cntr_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_natc_counter_set(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_natc_counter_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_ih_cong_threshold_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside system_user_ih_cong_threshold_get\n");

	if ((pa->ret = rdpa_system_ih_cong_threshold_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ih_cong_threshold_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ih_cong_threshold_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_ih_cong_threshold_set\n");

	if ((pa->ret = rdpa_system_ih_cong_threshold_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ih_cong_threshold_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_ingress_congestion_ctrl_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside system_user_ingress_congestion_ctrl_get\n");

	if ((pa->ret = rdpa_system_ingress_congestion_ctrl_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ingress_congestion_ctrl_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_ingress_congestion_ctrl_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_ingress_congestion_ctrl_set\n");

	if ((pa->ret = rdpa_system_ingress_congestion_ctrl_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_ingress_congestion_ctrl_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_parser_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_parser_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_parser_cfg_get\n");

	if ((pa->ret = rdpa_system_parser_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_parser_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_parser_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_parser_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_parser_cfg_t  parm;

	BDMF_TRACE_DBG("inside system_user_parser_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_parser_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_parser_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_parser_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_dos_attack_reason_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside system_user_dos_attack_reason_get\n");

	if ((pa->ret = rdpa_system_dos_attack_reason_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_dos_attack_reason_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_dos_attack_reason_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_dos_attack_reason_set\n");

	if ((pa->ret = rdpa_system_dos_attack_reason_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_dos_attack_reason_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_system_resources_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_system_resources_t  parm;

	BDMF_TRACE_DBG("inside system_user_system_resources_get\n");

	if ((pa->ret = rdpa_system_system_resources_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_system_resources_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_system_resources_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_fpm_resources_get(rdpa_ioctl_cmd_t *pa)
{
	rdp_fpm_resources_t  parm;

	BDMF_TRACE_DBG("inside system_user_fpm_resources_get\n");

	if ((pa->ret = rdpa_system_fpm_resources_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpm_resources_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdp_fpm_resources_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_host_mac_address_table_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_mac_t  parm;

	BDMF_TRACE_DBG("inside system_user_host_mac_address_table_get\n");

	if ((pa->ret = rdpa_system_host_mac_address_table_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_host_mac_address_table_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_mac_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_host_mac_address_table_add(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	bdmf_mac_t  parm;

	BDMF_TRACE_DBG("inside system_user_host_mac_address_table_add\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(bdmf_mac_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_host_mac_address_table_add(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_host_mac_address_table_add failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_host_mac_address_table_delete(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside system_host_mac_address_table_delete\n");

	if ((pa->ret = rdpa_system_host_mac_address_table_delete(pa->mo, (bdmf_index)pa->ai)))
	{
		BDMF_TRACE_ERR("rdpa_system_host_mac_address_table_delete failed\n");
	}

	return 0;
}

static int rdpa_user_system_host_mac_address_table_get_next(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;

	BDMF_TRACE_DBG("inside system_user_host_mac_address_table_get_next\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_host_mac_address_table_get_next(pa->mo, &ai)))
	{
		BDMF_TRACE_DBG("rdpa_system_host_mac_address_table_get_next failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_host_mac_address_table_find(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	bdmf_mac_t  parm;

	BDMF_TRACE_DBG("inside system_user_host_mac_address_table_find\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(bdmf_mac_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_system_host_mac_address_table_find(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_host_mac_address_table_find failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_mac_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_fpi_mode_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_fpi_mode_t parm;

	BDMF_TRACE_DBG("inside system_user_fpi_mode_get\n");

	if ((pa->ret = rdpa_system_fpi_mode_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpi_mode_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_fpi_mode_t)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_fpi_mode_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_fpi_mode_set\n");

	if ((pa->ret = rdpa_system_fpi_mode_set(pa->mo, (rdpa_fpi_mode_t)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpi_mode_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_system_fpi_default_priority_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside system_user_fpi_default_priority_get\n");

	if ((pa->ret = rdpa_system_fpi_default_priority_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpi_default_priority_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_system_fpi_default_priority_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside system_user_fpi_default_priority_set\n");

	if ((pa->ret = rdpa_system_fpi_default_priority_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_system_fpi_default_priority_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

long rdpa_system_ag_ioctl(unsigned int op, rdpa_ioctl_cmd_t *pa)
{
	int ret;

	switch (op){
		case RDPA_SYSTEM_DRV:
			ret = rdpa_user_system_drv(pa);
			break;

		case RDPA_SYSTEM_GET:
			ret = rdpa_user_system_get(pa);
			break;

		case RDPA_SYSTEM_INIT_CFG_GET:
			ret = rdpa_user_system_init_cfg_get(pa);
			break;

		case RDPA_SYSTEM_INIT_CFG_SET:
			ret = rdpa_user_system_init_cfg_set(pa);
			break;

		case RDPA_SYSTEM_CFG_GET:
			ret = rdpa_user_system_cfg_get(pa);
			break;

		case RDPA_SYSTEM_CFG_SET:
			ret = rdpa_user_system_cfg_set(pa);
			break;

		case RDPA_SYSTEM_SW_VERSION_GET:
			ret = rdpa_user_system_sw_version_get(pa);
			break;

		case RDPA_SYSTEM_CLOCK_GATE_GET:
			ret = rdpa_user_system_clock_gate_get(pa);
			break;

		case RDPA_SYSTEM_CLOCK_GATE_SET:
			ret = rdpa_user_system_clock_gate_set(pa);
			break;

		case RDPA_SYSTEM_STAT_GET:
			ret = rdpa_user_system_stat_get(pa);
			break;

		case RDPA_SYSTEM_STAT_SET:
			ret = rdpa_user_system_stat_set(pa);
			break;

		case RDPA_SYSTEM_DROP_PRECEDENCE_GET:
			ret = rdpa_user_system_drop_precedence_get(pa);
			break;

		case RDPA_SYSTEM_DROP_PRECEDENCE_SET:
			ret = rdpa_user_system_drop_precedence_set(pa);
			break;

		case RDPA_SYSTEM_DROP_PRECEDENCE_GET_NEXT:
			ret = rdpa_user_system_drop_precedence_get_next(pa);
			break;

		case RDPA_SYSTEM_TPID_DETECT_GET:
			ret = rdpa_user_system_tpid_detect_get(pa);
			break;

		case RDPA_SYSTEM_TPID_DETECT_SET:
			ret = rdpa_user_system_tpid_detect_set(pa);
			break;

		case RDPA_SYSTEM_TOD_GET:
			ret = rdpa_user_system_tod_get(pa);
			break;

		case RDPA_SYSTEM_CPU_REASON_TO_TC_GET:
			ret = rdpa_user_system_cpu_reason_to_tc_get(pa);
			break;

		case RDPA_SYSTEM_CPU_REASON_TO_TC_SET:
			ret = rdpa_user_system_cpu_reason_to_tc_set(pa);
			break;

		case RDPA_SYSTEM_IPV4_HOST_ADDRESS_TABLE_GET:
			ret = rdpa_user_system_ipv4_host_address_table_get(pa);
			break;

		case RDPA_SYSTEM_IPV4_HOST_ADDRESS_TABLE_ADD:
			ret = rdpa_user_system_ipv4_host_address_table_add(pa);
			break;

		case RDPA_SYSTEM_IPV4_HOST_ADDRESS_TABLE_DELETE:
			ret = rdpa_user_system_ipv4_host_address_table_delete(pa);
			break;

		case RDPA_SYSTEM_IPV4_HOST_ADDRESS_TABLE_FIND:
			ret = rdpa_user_system_ipv4_host_address_table_find(pa);
			break;

		case RDPA_SYSTEM_IPV6_HOST_ADDRESS_TABLE_GET:
			ret = rdpa_user_system_ipv6_host_address_table_get(pa);
			break;

		case RDPA_SYSTEM_IPV6_HOST_ADDRESS_TABLE_ADD:
			ret = rdpa_user_system_ipv6_host_address_table_add(pa);
			break;

		case RDPA_SYSTEM_IPV6_HOST_ADDRESS_TABLE_DELETE:
			ret = rdpa_user_system_ipv6_host_address_table_delete(pa);
			break;

		case RDPA_SYSTEM_IPV6_HOST_ADDRESS_TABLE_FIND:
			ret = rdpa_user_system_ipv6_host_address_table_find(pa);
			break;

		case RDPA_SYSTEM_QM_CFG_GET:
			ret = rdpa_user_system_qm_cfg_get(pa);
			break;

		case RDPA_SYSTEM_QM_CFG_SET:
			ret = rdpa_user_system_qm_cfg_set(pa);
			break;

		case RDPA_SYSTEM_PACKET_BUFFER_CFG_GET:
			ret = rdpa_user_system_packet_buffer_cfg_get(pa);
			break;

		case RDPA_SYSTEM_PACKET_BUFFER_CFG_SET:
			ret = rdpa_user_system_packet_buffer_cfg_set(pa);
			break;

		case RDPA_SYSTEM_HIGH_PRIO_TC_THRESHOLD_GET:
			ret = rdpa_user_system_high_prio_tc_threshold_get(pa);
			break;

		case RDPA_SYSTEM_HIGH_PRIO_TC_THRESHOLD_SET:
			ret = rdpa_user_system_high_prio_tc_threshold_set(pa);
			break;

		case RDPA_SYSTEM_COUNTER_CFG_GET:
			ret = rdpa_user_system_counter_cfg_get(pa);
			break;

		case RDPA_SYSTEM_COUNTER_CFG_SET:
			ret = rdpa_user_system_counter_cfg_set(pa);
			break;

		case RDPA_SYSTEM_FPM_ISR_DELAY_TIMER_PERIOD_GET:
			ret = rdpa_user_system_fpm_isr_delay_timer_period_get(pa);
			break;

		case RDPA_SYSTEM_FPM_ISR_DELAY_TIMER_PERIOD_SET:
			ret = rdpa_user_system_fpm_isr_delay_timer_period_set(pa);
			break;

		case RDPA_SYSTEM_NATC_COUNTER_GET:
			ret = rdpa_user_system_natc_counter_get(pa);
			break;

		case RDPA_SYSTEM_NATC_COUNTER_SET:
			ret = rdpa_user_system_natc_counter_set(pa);
			break;

		case RDPA_SYSTEM_IH_CONG_THRESHOLD_GET:
			ret = rdpa_user_system_ih_cong_threshold_get(pa);
			break;

		case RDPA_SYSTEM_IH_CONG_THRESHOLD_SET:
			ret = rdpa_user_system_ih_cong_threshold_set(pa);
			break;

		case RDPA_SYSTEM_INGRESS_CONGESTION_CTRL_GET:
			ret = rdpa_user_system_ingress_congestion_ctrl_get(pa);
			break;

		case RDPA_SYSTEM_INGRESS_CONGESTION_CTRL_SET:
			ret = rdpa_user_system_ingress_congestion_ctrl_set(pa);
			break;

		case RDPA_SYSTEM_PARSER_CFG_GET:
			ret = rdpa_user_system_parser_cfg_get(pa);
			break;

		case RDPA_SYSTEM_PARSER_CFG_SET:
			ret = rdpa_user_system_parser_cfg_set(pa);
			break;

		case RDPA_SYSTEM_DOS_ATTACK_REASON_GET:
			ret = rdpa_user_system_dos_attack_reason_get(pa);
			break;

		case RDPA_SYSTEM_DOS_ATTACK_REASON_SET:
			ret = rdpa_user_system_dos_attack_reason_set(pa);
			break;

		case RDPA_SYSTEM_SYSTEM_RESOURCES_GET:
			ret = rdpa_user_system_system_resources_get(pa);
			break;

		case RDPA_SYSTEM_FPM_RESOURCES_GET:
			ret = rdpa_user_system_fpm_resources_get(pa);
			break;

		case RDPA_SYSTEM_HOST_MAC_ADDRESS_TABLE_GET:
			ret = rdpa_user_system_host_mac_address_table_get(pa);
			break;

		case RDPA_SYSTEM_HOST_MAC_ADDRESS_TABLE_ADD:
			ret = rdpa_user_system_host_mac_address_table_add(pa);
			break;

		case RDPA_SYSTEM_HOST_MAC_ADDRESS_TABLE_DELETE:
			ret = rdpa_user_system_host_mac_address_table_delete(pa);
			break;

		case RDPA_SYSTEM_HOST_MAC_ADDRESS_TABLE_GET_NEXT:
			ret = rdpa_user_system_host_mac_address_table_get_next(pa);
			break;

		case RDPA_SYSTEM_HOST_MAC_ADDRESS_TABLE_FIND:
			ret = rdpa_user_system_host_mac_address_table_find(pa);
			break;

		case RDPA_SYSTEM_FPI_MODE_GET:
			ret = rdpa_user_system_fpi_mode_get(pa);
			break;

		case RDPA_SYSTEM_FPI_MODE_SET:
			ret = rdpa_user_system_fpi_mode_set(pa);
			break;

		case RDPA_SYSTEM_FPI_DEFAULT_PRIORITY_GET:
			ret = rdpa_user_system_fpi_default_priority_get(pa);
			break;

		case RDPA_SYSTEM_FPI_DEFAULT_PRIORITY_SET:
			ret = rdpa_user_system_fpi_default_priority_set(pa);
			break;

		default:
			BDMF_TRACE_ERR("no such ioctl cmd: %u\n", op);
			ret = EINVAL;
		}

	return ret;
}
