// <:copyright-BRCM:2013:DUAL/GPL:standard
// 
//    Copyright (c) 2013 Broadcom 
//    All Rights Reserved
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License, version 2, as published by
// the Free Software Foundation (the "GPL").
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// 
// A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
// writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
// 
// :>
/*
 * port object ioctl functions implementation file.
 * This ioctl file is generated automatically. Do not edit!
 */
#include "rdpa_api.h"
#include "rdpa_user.h"
#include "rdpa_user_int.h"
#include "rdpa_port_user_ioctl_ag.h"

static int rdpa_user_port_drv(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside rdpa_user_port_drv\n");

	if (!(pa->drv = rdpa_port_drv()))
	{
		BDMF_TRACE_DBG("rdpa_port_drv failed\n");
	}

	return 0;
}

static int rdpa_user_port_get(rdpa_ioctl_cmd_t *pa)
{
	char parm[32] = {0};

	BDMF_TRACE_DBG("inside rdpa_user_port_drv\n");

	if (copy_from_user((void *)parm, (void *)(long)pa->ptr, 31))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}
	if ((pa->ret = rdpa_port_get(parm, &pa->mo)))
	{
		BDMF_TRACE_DBG("rdpa_port_get failed ret: %d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_name_get(rdpa_ioctl_cmd_t *pa)
{
	char parm[16] = {0};

	BDMF_TRACE_DBG("inside port_user_name_get\n");

	if (copy_from_user((void *)parm, (void *)(long)pa->ptr, 15))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_name_get(pa->mo, parm, pa->size)))
	{
		BDMF_TRACE_DBG("rdpa_port_name_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)parm, 16))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_name_set(rdpa_ioctl_cmd_t *pa)
{
	char parm[16] = {0};

	BDMF_TRACE_DBG("inside port_user_name_set\n");

	if (copy_from_user((void *)parm, (void *)(long)pa->ptr, 15))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_name_set(pa->mo, parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_name_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_index_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_index_get\n");

	if ((pa->ret = rdpa_port_index_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_index_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_index_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_index_set\n");

	if ((pa->ret = rdpa_port_index_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_index_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_is_wan_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside port_user_is_wan_get\n");

	if ((pa->ret = rdpa_port_is_wan_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_is_wan_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_is_wan_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_is_wan_set\n");

	if ((pa->ret = rdpa_port_is_wan_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_is_wan_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_type_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_type parm;

	BDMF_TRACE_DBG("inside port_user_type_get\n");

	if ((pa->ret = rdpa_port_type_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_type_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_type)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_type_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_type_set\n");

	if ((pa->ret = rdpa_port_type_set(pa->mo, (rdpa_port_type)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_type_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_handle_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_handle_get\n");

	if ((pa->ret = rdpa_port_handle_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_handle_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_handle_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_handle_set\n");

	if ((pa->ret = rdpa_port_handle_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_handle_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_speed_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_speed_type parm;

	BDMF_TRACE_DBG("inside port_user_speed_get\n");

	if ((pa->ret = rdpa_port_speed_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_speed_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_speed_type)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_speed_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_speed_set\n");

	if ((pa->ret = rdpa_port_speed_set(pa->mo, (rdpa_speed_type)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_speed_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_dp_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_cfg_get\n");

	if ((pa->ret = rdpa_port_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_dp_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_dp_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_dp_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_tm_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_tm_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_tm_cfg_get\n");

	if ((pa->ret = rdpa_port_tm_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_tm_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_tm_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_tm_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_tm_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_tm_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_tm_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_tm_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_tm_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_def_flow_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_ic_result_t   parm;

	BDMF_TRACE_DBG("inside port_user_def_flow_get\n");

	if ((pa->ret = rdpa_port_def_flow_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_def_flow_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_ic_result_t  )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_def_flow_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_ic_result_t   parm;

	BDMF_TRACE_DBG("inside port_user_def_flow_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_ic_result_t  )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_def_flow_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_def_flow_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_stat_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_stat_t  parm;

	BDMF_TRACE_DBG("inside port_user_stat_get\n");

	if ((pa->ret = rdpa_port_stat_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_stat_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_stat_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_stat_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_stat_t  parm;

	BDMF_TRACE_DBG("inside port_user_stat_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_stat_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_stat_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_stat_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_flow_control_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_flow_ctrl_t  parm;

	BDMF_TRACE_DBG("inside port_user_flow_control_get\n");

	if ((pa->ret = rdpa_port_flow_control_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_flow_control_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_flow_ctrl_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_flow_control_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_flow_ctrl_t  parm;

	BDMF_TRACE_DBG("inside port_user_flow_control_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_flow_ctrl_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_flow_control_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_flow_control_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_ingress_rate_limit_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_ingress_rate_limit_t  parm;

	BDMF_TRACE_DBG("inside port_user_ingress_rate_limit_get\n");

	if ((pa->ret = rdpa_port_ingress_rate_limit_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_ingress_rate_limit_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_ingress_rate_limit_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_ingress_rate_limit_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_ingress_rate_limit_t  parm;

	BDMF_TRACE_DBG("inside port_user_ingress_rate_limit_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_ingress_rate_limit_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_ingress_rate_limit_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_ingress_rate_limit_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_rl_overhead_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_rl_overhead_get\n");

	if ((pa->ret = rdpa_port_rl_overhead_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_rl_overhead_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_rl_overhead_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_rl_overhead_set\n");

	if ((pa->ret = rdpa_port_rl_overhead_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_rl_overhead_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_mirror_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_mirror_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_mirror_cfg_get\n");

	if ((pa->ret = rdpa_port_mirror_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_mirror_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_mirror_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_mirror_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_mirror_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_mirror_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_mirror_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_mirror_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_mirror_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_bufmng_cfg_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_bufmng_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_bufmng_cfg_get\n");

	if ((pa->ret = rdpa_port_bufmng_cfg_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_bufmng_cfg_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_bufmng_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_bufmng_cfg_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_bufmng_cfg_t  parm;

	BDMF_TRACE_DBG("inside port_user_bufmng_cfg_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_bufmng_cfg_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_bufmng_cfg_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_bufmng_cfg_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_vlan_isolation_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_vlan_isolation_t  parm;

	BDMF_TRACE_DBG("inside port_user_vlan_isolation_get\n");

	if ((pa->ret = rdpa_port_vlan_isolation_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_vlan_isolation_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_vlan_isolation_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_vlan_isolation_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_vlan_isolation_t  parm;

	BDMF_TRACE_DBG("inside port_user_vlan_isolation_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_vlan_isolation_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_vlan_isolation_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_vlan_isolation_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_loopback_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_loopback_t  parm;

	BDMF_TRACE_DBG("inside port_user_loopback_get\n");

	if ((pa->ret = rdpa_port_loopback_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_loopback_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_port_loopback_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_loopback_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_port_loopback_t  parm;

	BDMF_TRACE_DBG("inside port_user_loopback_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_port_loopback_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_loopback_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_loopback_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_max_pkt_size_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_max_pkt_size_get\n");

	if ((pa->ret = rdpa_port_max_pkt_size_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_max_pkt_size_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_max_pkt_size_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_max_pkt_size_set\n");

	if ((pa->ret = rdpa_port_max_pkt_size_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_max_pkt_size_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_cpu_obj_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_object_handle parm;

	BDMF_TRACE_DBG("inside port_user_cpu_obj_get\n");

	if ((pa->ret = rdpa_port_cpu_obj_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_cpu_obj_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_object_handle)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_cpu_obj_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_cpu_obj_set\n");

	if ((pa->ret = rdpa_port_cpu_obj_set(pa->mo, pa->object)))
	{
		BDMF_TRACE_DBG("rdpa_port_cpu_obj_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_pbit_to_queue_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_object_handle parm;

	BDMF_TRACE_DBG("inside port_user_pbit_to_queue_get\n");

	if ((pa->ret = rdpa_port_pbit_to_queue_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pbit_to_queue_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_object_handle)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_cpu_meter_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_cpu_meter_get\n");

	if ((pa->ret = rdpa_port_cpu_meter_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_cpu_meter_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_cpu_meter_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_cpu_meter_set\n");

	if ((pa->ret = rdpa_port_cpu_meter_set(pa->mo, pa->ai, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_cpu_meter_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_ingress_filter_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_filter_ctrl_t  parm;

	BDMF_TRACE_DBG("inside port_user_ingress_filter_get\n");

	if ((pa->ret = rdpa_port_ingress_filter_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_ingress_filter_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_filter_ctrl_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_ingress_filter_set(rdpa_ioctl_cmd_t *pa)
{
	rdpa_filter_ctrl_t  parm;

	BDMF_TRACE_DBG("inside port_user_ingress_filter_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_filter_ctrl_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_ingress_filter_set(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_ingress_filter_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_ingress_filter_get_next(rdpa_ioctl_cmd_t *pa)
{
	rdpa_filter  ai;

	BDMF_TRACE_DBG("inside port_user_ingress_filter_get_next\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(rdpa_filter )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_ingress_filter_get_next(pa->mo, &ai)))
	{
		BDMF_TRACE_DBG("rdpa_port_ingress_filter_get_next failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(rdpa_filter )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_protocol_filters_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_proto_filters_mask_t parm;

	BDMF_TRACE_DBG("inside port_user_protocol_filters_get\n");

	if ((pa->ret = rdpa_port_protocol_filters_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_protocol_filters_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_proto_filters_mask_t)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_protocol_filters_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_protocol_filters_set\n");

	if ((pa->ret = rdpa_port_protocol_filters_set(pa->mo, (rdpa_proto_filters_mask_t)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_protocol_filters_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_enable_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside port_user_enable_get\n");

	if ((pa->ret = rdpa_port_enable_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_enable_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_enable_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_enable_set\n");

	if ((pa->ret = rdpa_port_enable_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_enable_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_is_empty_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside port_user_is_empty_get\n");

	if ((pa->ret = rdpa_port_is_empty_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_is_empty_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_uninit_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_uninit_set\n");

	if ((pa->ret = rdpa_port_uninit_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_uninit_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_mac_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_mac_t  parm;

	BDMF_TRACE_DBG("inside port_user_mac_get\n");

	if ((pa->ret = rdpa_port_mac_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_mac_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_mac_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_mac_set(rdpa_ioctl_cmd_t *pa)
{
	bdmf_mac_t  parm;

	BDMF_TRACE_DBG("inside port_user_mac_set\n");

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(bdmf_mac_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_port_mac_set(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_mac_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_pkt_size_stat_en_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside port_user_pkt_size_stat_en_get\n");

	if ((pa->ret = rdpa_port_pkt_size_stat_en_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pkt_size_stat_en_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_pkt_size_stat_en_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_pkt_size_stat_en_set\n");

	if ((pa->ret = rdpa_port_pkt_size_stat_en_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pkt_size_stat_en_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_pbit_to_dp_map_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_discard_prty parm;

	BDMF_TRACE_DBG("inside port_user_pbit_to_dp_map_get\n");

	if ((pa->ret = rdpa_port_pbit_to_dp_map_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pbit_to_dp_map_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_discard_prty)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_pbit_to_dp_map_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_pbit_to_dp_map_set\n");

	if ((pa->ret = rdpa_port_pbit_to_dp_map_set(pa->mo, pa->ai, (rdpa_discard_prty)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pbit_to_dp_map_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_options_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_options_get\n");

	if ((pa->ret = rdpa_port_options_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_options_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_options_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_options_set\n");

	if ((pa->ret = rdpa_port_options_set(pa->mo, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_options_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_pfc_tx_enable_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside port_user_pfc_tx_enable_get\n");

	if ((pa->ret = rdpa_port_pfc_tx_enable_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pfc_tx_enable_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_pfc_tx_enable_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_pfc_tx_enable_set\n");

	if ((pa->ret = rdpa_port_pfc_tx_enable_set(pa->mo, (bdmf_boolean)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pfc_tx_enable_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_port_pfc_tx_timer_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_number parm;

	BDMF_TRACE_DBG("inside port_user_pfc_tx_timer_get\n");

	if ((pa->ret = rdpa_port_pfc_tx_timer_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pfc_tx_timer_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_number)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_port_pfc_tx_timer_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside port_user_pfc_tx_timer_set\n");

	if ((pa->ret = rdpa_port_pfc_tx_timer_set(pa->mo, pa->ai, (bdmf_number)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_port_pfc_tx_timer_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

long rdpa_port_ag_ioctl(unsigned int op, rdpa_ioctl_cmd_t *pa)
{
	int ret;

	switch (op){
		case RDPA_PORT_DRV:
			ret = rdpa_user_port_drv(pa);
			break;

		case RDPA_PORT_GET:
			ret = rdpa_user_port_get(pa);
			break;

		case RDPA_PORT_NAME_GET:
			ret = rdpa_user_port_name_get(pa);
			break;

		case RDPA_PORT_NAME_SET:
			ret = rdpa_user_port_name_set(pa);
			break;

		case RDPA_PORT_INDEX_GET:
			ret = rdpa_user_port_index_get(pa);
			break;

		case RDPA_PORT_INDEX_SET:
			ret = rdpa_user_port_index_set(pa);
			break;

		case RDPA_PORT_IS_WAN_GET:
			ret = rdpa_user_port_is_wan_get(pa);
			break;

		case RDPA_PORT_IS_WAN_SET:
			ret = rdpa_user_port_is_wan_set(pa);
			break;

		case RDPA_PORT_TYPE_GET:
			ret = rdpa_user_port_type_get(pa);
			break;

		case RDPA_PORT_TYPE_SET:
			ret = rdpa_user_port_type_set(pa);
			break;

		case RDPA_PORT_HANDLE_GET:
			ret = rdpa_user_port_handle_get(pa);
			break;

		case RDPA_PORT_HANDLE_SET:
			ret = rdpa_user_port_handle_set(pa);
			break;

		case RDPA_PORT_SPEED_GET:
			ret = rdpa_user_port_speed_get(pa);
			break;

		case RDPA_PORT_SPEED_SET:
			ret = rdpa_user_port_speed_set(pa);
			break;

		case RDPA_PORT_CFG_GET:
			ret = rdpa_user_port_cfg_get(pa);
			break;

		case RDPA_PORT_CFG_SET:
			ret = rdpa_user_port_cfg_set(pa);
			break;

		case RDPA_PORT_TM_CFG_GET:
			ret = rdpa_user_port_tm_cfg_get(pa);
			break;

		case RDPA_PORT_TM_CFG_SET:
			ret = rdpa_user_port_tm_cfg_set(pa);
			break;

		case RDPA_PORT_DEF_FLOW_GET:
			ret = rdpa_user_port_def_flow_get(pa);
			break;

		case RDPA_PORT_DEF_FLOW_SET:
			ret = rdpa_user_port_def_flow_set(pa);
			break;

		case RDPA_PORT_STAT_GET:
			ret = rdpa_user_port_stat_get(pa);
			break;

		case RDPA_PORT_STAT_SET:
			ret = rdpa_user_port_stat_set(pa);
			break;

		case RDPA_PORT_FLOW_CONTROL_GET:
			ret = rdpa_user_port_flow_control_get(pa);
			break;

		case RDPA_PORT_FLOW_CONTROL_SET:
			ret = rdpa_user_port_flow_control_set(pa);
			break;

		case RDPA_PORT_INGRESS_RATE_LIMIT_GET:
			ret = rdpa_user_port_ingress_rate_limit_get(pa);
			break;

		case RDPA_PORT_INGRESS_RATE_LIMIT_SET:
			ret = rdpa_user_port_ingress_rate_limit_set(pa);
			break;

		case RDPA_PORT_RL_OVERHEAD_GET:
			ret = rdpa_user_port_rl_overhead_get(pa);
			break;

		case RDPA_PORT_RL_OVERHEAD_SET:
			ret = rdpa_user_port_rl_overhead_set(pa);
			break;

		case RDPA_PORT_MIRROR_CFG_GET:
			ret = rdpa_user_port_mirror_cfg_get(pa);
			break;

		case RDPA_PORT_MIRROR_CFG_SET:
			ret = rdpa_user_port_mirror_cfg_set(pa);
			break;

		case RDPA_PORT_BUFMNG_CFG_GET:
			ret = rdpa_user_port_bufmng_cfg_get(pa);
			break;

		case RDPA_PORT_BUFMNG_CFG_SET:
			ret = rdpa_user_port_bufmng_cfg_set(pa);
			break;

		case RDPA_PORT_VLAN_ISOLATION_GET:
			ret = rdpa_user_port_vlan_isolation_get(pa);
			break;

		case RDPA_PORT_VLAN_ISOLATION_SET:
			ret = rdpa_user_port_vlan_isolation_set(pa);
			break;

		case RDPA_PORT_LOOPBACK_GET:
			ret = rdpa_user_port_loopback_get(pa);
			break;

		case RDPA_PORT_LOOPBACK_SET:
			ret = rdpa_user_port_loopback_set(pa);
			break;

		case RDPA_PORT_MAX_PKT_SIZE_GET:
			ret = rdpa_user_port_max_pkt_size_get(pa);
			break;

		case RDPA_PORT_MAX_PKT_SIZE_SET:
			ret = rdpa_user_port_max_pkt_size_set(pa);
			break;

		case RDPA_PORT_CPU_OBJ_GET:
			ret = rdpa_user_port_cpu_obj_get(pa);
			break;

		case RDPA_PORT_CPU_OBJ_SET:
			ret = rdpa_user_port_cpu_obj_set(pa);
			break;

		case RDPA_PORT_PBIT_TO_QUEUE_GET:
			ret = rdpa_user_port_pbit_to_queue_get(pa);
			break;

		case RDPA_PORT_CPU_METER_GET:
			ret = rdpa_user_port_cpu_meter_get(pa);
			break;

		case RDPA_PORT_CPU_METER_SET:
			ret = rdpa_user_port_cpu_meter_set(pa);
			break;

		case RDPA_PORT_INGRESS_FILTER_GET:
			ret = rdpa_user_port_ingress_filter_get(pa);
			break;

		case RDPA_PORT_INGRESS_FILTER_SET:
			ret = rdpa_user_port_ingress_filter_set(pa);
			break;

		case RDPA_PORT_INGRESS_FILTER_GET_NEXT:
			ret = rdpa_user_port_ingress_filter_get_next(pa);
			break;

		case RDPA_PORT_PROTOCOL_FILTERS_GET:
			ret = rdpa_user_port_protocol_filters_get(pa);
			break;

		case RDPA_PORT_PROTOCOL_FILTERS_SET:
			ret = rdpa_user_port_protocol_filters_set(pa);
			break;

		case RDPA_PORT_ENABLE_GET:
			ret = rdpa_user_port_enable_get(pa);
			break;

		case RDPA_PORT_ENABLE_SET:
			ret = rdpa_user_port_enable_set(pa);
			break;

		case RDPA_PORT_IS_EMPTY_GET:
			ret = rdpa_user_port_is_empty_get(pa);
			break;

		case RDPA_PORT_UNINIT_SET:
			ret = rdpa_user_port_uninit_set(pa);
			break;

		case RDPA_PORT_MAC_GET:
			ret = rdpa_user_port_mac_get(pa);
			break;

		case RDPA_PORT_MAC_SET:
			ret = rdpa_user_port_mac_set(pa);
			break;

		case RDPA_PORT_PKT_SIZE_STAT_EN_GET:
			ret = rdpa_user_port_pkt_size_stat_en_get(pa);
			break;

		case RDPA_PORT_PKT_SIZE_STAT_EN_SET:
			ret = rdpa_user_port_pkt_size_stat_en_set(pa);
			break;

		case RDPA_PORT_PBIT_TO_DP_MAP_GET:
			ret = rdpa_user_port_pbit_to_dp_map_get(pa);
			break;

		case RDPA_PORT_PBIT_TO_DP_MAP_SET:
			ret = rdpa_user_port_pbit_to_dp_map_set(pa);
			break;

		case RDPA_PORT_OPTIONS_GET:
			ret = rdpa_user_port_options_get(pa);
			break;

		case RDPA_PORT_OPTIONS_SET:
			ret = rdpa_user_port_options_set(pa);
			break;

		case RDPA_PORT_PFC_TX_ENABLE_GET:
			ret = rdpa_user_port_pfc_tx_enable_get(pa);
			break;

		case RDPA_PORT_PFC_TX_ENABLE_SET:
			ret = rdpa_user_port_pfc_tx_enable_set(pa);
			break;

		case RDPA_PORT_PFC_TX_TIMER_GET:
			ret = rdpa_user_port_pfc_tx_timer_get(pa);
			break;

		case RDPA_PORT_PFC_TX_TIMER_SET:
			ret = rdpa_user_port_pfc_tx_timer_set(pa);
			break;

		default:
			BDMF_TRACE_ERR("no such ioctl cmd: %u\n", op);
			ret = EINVAL;
		}

	return ret;
}
