// <:copyright-BRCM:2013:DUAL/GPL:standard
// 
//    Copyright (c) 2013 Broadcom 
//    All Rights Reserved
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License, version 2, as published by
// the Free Software Foundation (the "GPL").
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// 
// A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
// writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
// 
// :>
/*
 * mcast_whitelist object ioctl functions implementation file.
 * This ioctl file is generated automatically. Do not edit!
 */
#include "rdpa_api.h"
#include "rdpa_user.h"
#include "rdpa_user_int.h"
#include "rdpa_mcast_whitelist_user_ioctl_ag.h"

static int rdpa_user_mcast_whitelist_drv(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside rdpa_user_mcast_whitelist_drv\n");

	if (!(pa->drv = rdpa_mcast_whitelist_drv()))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_drv failed\n");
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_get(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside rdpa_user_mcast_whitelist_drv\n");

	if ((pa->ret = rdpa_mcast_whitelist_get(&pa->mo)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_get failed ret: %d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_entry_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_mcast_whitelist_t  parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_entry_get\n");

	if ((pa->ret = rdpa_mcast_whitelist_entry_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_entry_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_mcast_whitelist_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_entry_add(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	rdpa_mcast_whitelist_t  parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_entry_add\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_mcast_whitelist_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_mcast_whitelist_entry_add(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_entry_add failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_entry_delete(rdpa_ioctl_cmd_t *pa)
{
	BDMF_TRACE_DBG("inside mcast_whitelist_entry_delete\n");

	if ((pa->ret = rdpa_mcast_whitelist_entry_delete(pa->mo, (bdmf_index)pa->ai)))
	{
		BDMF_TRACE_ERR("rdpa_mcast_whitelist_entry_delete failed\n");
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_entry_find(rdpa_ioctl_cmd_t *pa)
{
	bdmf_index  ai;
	rdpa_mcast_whitelist_t  parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_entry_find\n");

	if (copy_from_user((void *)&ai, (void *)(long)pa->ai_ptr, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if (copy_from_user((void *)&parm, (void *)(long)pa->ptr, sizeof(rdpa_mcast_whitelist_t )))
	{
		BDMF_TRACE_ERR("failed to copy from user\n");
		return -1;
	}

	if ((pa->ret = rdpa_mcast_whitelist_entry_find(pa->mo, &ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_entry_find failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ai_ptr, (void *)&ai, sizeof(bdmf_index )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_mcast_whitelist_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_port_enable_get(rdpa_ioctl_cmd_t *pa)
{
	bdmf_boolean parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_port_enable_get\n");

	if ((pa->ret = rdpa_mcast_whitelist_port_enable_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_port_enable_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(bdmf_boolean)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_stat_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_stat_t  parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_stat_get\n");

	if ((pa->ret = rdpa_mcast_whitelist_stat_get(pa->mo, pa->ai, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_stat_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_stat_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_global_stat_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_mcast_whitelist_stat_t  parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_global_stat_get\n");

	if ((pa->ret = rdpa_mcast_whitelist_global_stat_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_global_stat_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_mcast_whitelist_stat_t )))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_lookup_method_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_iptv_lookup_method parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_lookup_method_get\n");

	if ((pa->ret = rdpa_mcast_whitelist_lookup_method_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_lookup_method_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_iptv_lookup_method)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_lookup_method_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside mcast_whitelist_user_lookup_method_set\n");

	if ((pa->ret = rdpa_mcast_whitelist_lookup_method_set(pa->mo, (rdpa_iptv_lookup_method)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_lookup_method_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_mcast_prefix_filter_get(rdpa_ioctl_cmd_t *pa)
{
	rdpa_mcast_filter_method parm;

	BDMF_TRACE_DBG("inside mcast_whitelist_user_mcast_prefix_filter_get\n");

	if ((pa->ret = rdpa_mcast_whitelist_mcast_prefix_filter_get(pa->mo, &parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_mcast_prefix_filter_get failed, ret:%d\n", pa->ret);
	}

	if (copy_to_user((void *)(long)pa->ptr, (void *)&parm, sizeof(rdpa_mcast_filter_method)))
	{
		BDMF_TRACE_ERR("failed to copy to user\n");
		return -1;
	}

	return 0;
}

static int rdpa_user_mcast_whitelist_mcast_prefix_filter_set(rdpa_ioctl_cmd_t *pa)
{

	BDMF_TRACE_DBG("inside mcast_whitelist_user_mcast_prefix_filter_set\n");

	if ((pa->ret = rdpa_mcast_whitelist_mcast_prefix_filter_set(pa->mo, (rdpa_mcast_filter_method)(long)pa->parm)))
	{
		BDMF_TRACE_DBG("rdpa_mcast_whitelist_mcast_prefix_filter_set failed, ret:%d\n", pa->ret);
	}

	return 0;
}

long rdpa_mcast_whitelist_ag_ioctl(unsigned int op, rdpa_ioctl_cmd_t *pa)
{
	int ret;

	switch (op){
		case RDPA_MCAST_WHITELIST_DRV:
			ret = rdpa_user_mcast_whitelist_drv(pa);
			break;

		case RDPA_MCAST_WHITELIST_GET:
			ret = rdpa_user_mcast_whitelist_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_ENTRY_GET:
			ret = rdpa_user_mcast_whitelist_entry_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_ENTRY_ADD:
			ret = rdpa_user_mcast_whitelist_entry_add(pa);
			break;

		case RDPA_MCAST_WHITELIST_ENTRY_DELETE:
			ret = rdpa_user_mcast_whitelist_entry_delete(pa);
			break;

		case RDPA_MCAST_WHITELIST_ENTRY_FIND:
			ret = rdpa_user_mcast_whitelist_entry_find(pa);
			break;

		case RDPA_MCAST_WHITELIST_PORT_ENABLE_GET:
			ret = rdpa_user_mcast_whitelist_port_enable_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_STAT_GET:
			ret = rdpa_user_mcast_whitelist_stat_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_GLOBAL_STAT_GET:
			ret = rdpa_user_mcast_whitelist_global_stat_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_LOOKUP_METHOD_GET:
			ret = rdpa_user_mcast_whitelist_lookup_method_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_LOOKUP_METHOD_SET:
			ret = rdpa_user_mcast_whitelist_lookup_method_set(pa);
			break;

		case RDPA_MCAST_WHITELIST_MCAST_PREFIX_FILTER_GET:
			ret = rdpa_user_mcast_whitelist_mcast_prefix_filter_get(pa);
			break;

		case RDPA_MCAST_WHITELIST_MCAST_PREFIX_FILTER_SET:
			ret = rdpa_user_mcast_whitelist_mcast_prefix_filter_set(pa);
			break;

		default:
			BDMF_TRACE_ERR("no such ioctl cmd: %u\n", op);
			ret = EINVAL;
		}

	return ret;
}
