// <:copyright-BRCM:2013:DUAL/GPL:standard
// 
//    Copyright (c) 2013 Broadcom 
//    All Rights Reserved
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License, version 2, as published by
// the Free Software Foundation (the "GPL").
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// 
// A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
// writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
// 
// :>
/*
 * mcast_whitelist object header file.
 * This header file is generated automatically. Do not edit!
 */
#ifndef _RDPA_AG_MCAST_WHITELIST_H_
#define _RDPA_AG_MCAST_WHITELIST_H_

/** \addtogroup mcast_whitelist
 * @{
 */


/** Get mcast_whitelist type handle.
 *
 * This handle should be passed to bdmf_new_and_set() function in
 * order to create a mcast_whitelist object.
 * \return mcast_whitelist type handle
 */
bdmf_type_handle rdpa_mcast_whitelist_drv(void);

/* mcast_whitelist: Attribute types */
typedef enum {
    rdpa_mcast_whitelist_attr_entry = 0, /* entry : RWADF : aggregate[] mcast_whitelist(rdpa_mcast_whitelist_t) : Multicast whitelist entry */
    rdpa_mcast_whitelist_attr_port_enable = 1, /* port_enable : RF : bool[] : Multicast whitelist port enable */
    rdpa_mcast_whitelist_attr_stat = 2, /* stat : RF : aggregate[] rdpa_stat(rdpa_stat_t) : Multicast whitelist statistics */
    rdpa_mcast_whitelist_attr_global_stat = 3, /* global_stat : R : aggregate mcast_whitelist_stat(rdpa_mcast_whitelist_stat_t) : Multicast whitelist global statistics */
    rdpa_mcast_whitelist_attr_lookup_method = 4, /* lookup_method : RW : enum : IPTV Lookup Method */
    rdpa_mcast_whitelist_attr_mcast_prefix_filter = 5, /* mcast_prefix_filter : RW : enum :  Multicast Prefix Filtering Method */
} rdpa_mcast_whitelist_attr_types;

extern int (*f_rdpa_mcast_whitelist_get)(bdmf_object_handle *pmo);

/** Get mcast_whitelist object.

 * This function returns mcast_whitelist object instance.
 * \param[out] mcast_whitelist_obj    Object handle
 * \return    0=OK or error <0
 */
int rdpa_mcast_whitelist_get(bdmf_object_handle *mcast_whitelist_obj);

/** Get mcast_whitelist/entry attribute entry.
 *
 * Get Multicast whitelist entry.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in]   ai_ Attribute array index
 * \param[out]  entry_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_entry_get(bdmf_object_handle mo_, bdmf_index ai_, rdpa_mcast_whitelist_t * entry_)
{
    return bdmf_attrelem_get_as_buf(mo_, rdpa_mcast_whitelist_attr_entry, (bdmf_index)ai_, entry_, sizeof(*entry_));
}


/** Add mcast_whitelist/entry attribute entry.
 *
 * Add Multicast whitelist entry.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in,out]   ai_ Attribute array index
 * \param[in]   entry_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_entry_add(bdmf_object_handle mo_, bdmf_index * ai_, const rdpa_mcast_whitelist_t * entry_)
{
    int rc;
    rc = bdmf_attrelem_add_as_buf(mo_, rdpa_mcast_whitelist_attr_entry, (bdmf_index *)ai_, entry_, sizeof(*entry_));
    return rc;
}


/** Delete mcast_whitelist/entry attribute entry.
 *
 * Delete Multicast whitelist entry.
 * \param[in]   mo_ mcast_whitelist object handle
 * \param[in]   ai_ Attribute array index
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_entry_delete(bdmf_object_handle mo_, bdmf_index ai_)
{
    return bdmf_attrelem_delete(mo_, rdpa_mcast_whitelist_attr_entry, (bdmf_index)ai_);
}


/** Find mcast_whitelist/entry attribute entry.
 *
 * Find Multicast whitelist entry.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in,out]   ai_ Attribute array index
 * \param[in,out]   entry_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_entry_find(bdmf_object_handle mo_, bdmf_index * ai_, rdpa_mcast_whitelist_t * entry_)
{
    int rc;
    rc = bdmf_attrelem_find(mo_, rdpa_mcast_whitelist_attr_entry, (bdmf_index *)ai_, entry_, sizeof(*entry_));
    return rc;
}


/** Get mcast_whitelist/port_enable attribute entry.
 *
 * Get Multicast whitelist port enable.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in]   ai_ Attribute array index
 * \param[out]  port_enable_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_port_enable_get(bdmf_object_handle mo_, bdmf_index ai_, bdmf_boolean *port_enable_)
{
    bdmf_number _nn_;
    int _rc_;
    _rc_ = bdmf_attrelem_get_as_num(mo_, rdpa_mcast_whitelist_attr_port_enable, (bdmf_index)ai_, &_nn_);
    *port_enable_ = (bdmf_boolean)_nn_;
    return _rc_;
}


/** Get mcast_whitelist/stat attribute entry.
 *
 * Get Multicast whitelist statistics.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in]   ai_ Attribute array index
 * \param[out]  stat_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_stat_get(bdmf_object_handle mo_, bdmf_index ai_, rdpa_stat_t * stat_)
{
    return bdmf_attrelem_get_as_buf(mo_, rdpa_mcast_whitelist_attr_stat, (bdmf_index)ai_, stat_, sizeof(*stat_));
}


/** Get mcast_whitelist/global_stat attribute.
 *
 * Get Multicast whitelist global statistics.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[out]  global_stat_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_global_stat_get(bdmf_object_handle mo_, rdpa_mcast_whitelist_stat_t * global_stat_)
{
    return bdmf_attr_get_as_buf(mo_, rdpa_mcast_whitelist_attr_global_stat, global_stat_, sizeof(*global_stat_));
}


/** Get mcast_whitelist/lookup_method attribute.
 *
 * Get IPTV Lookup Method.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[out]  lookup_method_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task and softirq contexts.
 */
static inline int rdpa_mcast_whitelist_lookup_method_get(bdmf_object_handle mo_, rdpa_iptv_lookup_method *lookup_method_)
{
    bdmf_number _nn_;
    int _rc_;
    _rc_ = bdmf_attr_get_as_num(mo_, rdpa_mcast_whitelist_attr_lookup_method, &_nn_);
    *lookup_method_ = (rdpa_iptv_lookup_method)_nn_;
    return _rc_;
}


/** Set mcast_whitelist/lookup_method attribute.
 *
 * Set IPTV Lookup Method.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in]   lookup_method_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task and softirq contexts.
 */
static inline int rdpa_mcast_whitelist_lookup_method_set(bdmf_object_handle mo_, rdpa_iptv_lookup_method lookup_method_)
{
    return bdmf_attr_set_as_num(mo_, rdpa_mcast_whitelist_attr_lookup_method, lookup_method_);
}


/** Get mcast_whitelist/mcast_prefix_filter attribute.
 *
 * Get  Multicast Prefix Filtering Method.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[out]  mcast_prefix_filter_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_mcast_prefix_filter_get(bdmf_object_handle mo_, rdpa_mcast_filter_method *mcast_prefix_filter_)
{
    bdmf_number _nn_;
    int _rc_;
    _rc_ = bdmf_attr_get_as_num(mo_, rdpa_mcast_whitelist_attr_mcast_prefix_filter, &_nn_);
    *mcast_prefix_filter_ = (rdpa_mcast_filter_method)_nn_;
    return _rc_;
}


/** Set mcast_whitelist/mcast_prefix_filter attribute.
 *
 * Set  Multicast Prefix Filtering Method.
 * \param[in]   mo_ mcast_whitelist object handle or mattr transaction handle
 * \param[in]   mcast_prefix_filter_ Attribute value
 * \return 0 or error code < 0
 * The function can be called in task context only.
 */
static inline int rdpa_mcast_whitelist_mcast_prefix_filter_set(bdmf_object_handle mo_, rdpa_mcast_filter_method mcast_prefix_filter_)
{
    return bdmf_attr_set_as_num(mo_, rdpa_mcast_whitelist_attr_mcast_prefix_filter, mcast_prefix_filter_);
}

/** @} end of mcast_whitelist Doxygen group */




#endif /* _RDPA_AG_MCAST_WHITELIST_H_ */
