/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#ifndef _XRDP_DRV_UNIMAC_RDP_AG_H_
#define _XRDP_DRV_UNIMAC_RDP_AG_H_

#include "access_macros.h"
#include "bdmf_interface.h"
#ifdef USE_BDMF_SHELL
#include "bdmf_shell.h"
#endif
#include "rdp_common.h"


/**************************************************************************************************/
/* eth_speed_bit2:  - This is bit 2 for ETH_SPEED. See ETH_SPEED below.                           */
/* runt_filter_dis:  - When set, disable runt filtering.                                          */
/* oob_efc_disab:  - When this bit is set, out-of-band egress flow control will be disabled. When */
/*                 this bit is 0 (out-of-band egress flow control enabled) and input pin ext_tx_f */
/*                low_control is 1, frame transmissions may be stopped - see OOB_EFC_MODE for det */
/*                ails.
Out-of-band egress flow control operation is similar to halting the trans */
/*                mit datapath due to reception of a Pause Frame with a non-zero timer value. Thi */
/*                s bit however has no effect on regular Rx Pause Frame based egress flow control */
/*                .                                                                               */
/* ignore_tx_pause:  - Ignores the back pressure signaling from the system and hence no Tx pause  */
/*                  generation, when set.                                                         */
/* fd_tx_urun_fix_en:  - Tx Underflow detection can be improved by accounting for residue bytes i */
/*                    n 128b to 8b convertor. The fix is valid only for full duplex mode and can  */
/*                    be enabled by setting this bit.                                             */
/* line_loopback:  - Enable Line Loopback i.e. MAC FIFO side loopback (RX to TX) when set to '1', */
/*                 normal operation when set to '0' (Reset value).                                */
/* no_lgth_check:  - Payload Length Check Disable. When set to '0', the Core checks the frame's p */
/*                ayload length with the Frame
Length/Type field, when set to '1'(Reset value), t */
/*                he payload length check is disabled.                                            */
/* cntl_frm_ena:  - MAC Control Frame Enable. When set to '1', MAC Control frames with any 
Opcod */
/*               e other than 0x0001 are accepted and forward to the Client interface. 
When set  */
/*               to '0' (Reset value), MAC Control frames with any Opcode other 
than 0x0001 are  */
/*               silently discarded.                                                              */
/* ena_ext_config:  - Enable Configuration with External Pins. When set to '0' (Reset value) 
the */
/*                  Core speed and Mode is programmed with the register bits ETH_SPEED(2:0) 
and  */
/*                 HD_ENA. When set to '1', the Core is configured with the pins 
set_speed(1:0)  */
/*                 and set_duplex.                                                                */
/* en_internal_tx_crs:  - If enabled, then CRS input to Unimac is ORed with tds[8] (tx data valid */
/*                      output). This is helpful when TX CRS is disabled inside PHY.              */
/* bypass_oob_efc_synchronizer:  - 1=> bypass the OOB external flow control signal synchronizer,  */
/*                              to e.g. reduce latency. In this case it is assumed/required that  */
/*                              Unimac input ext_tx_flow_control is already in tx_clk clock domai */
/*                              n (so there is no need to synchronize it)
0=> locally synchronize */
/*                               the OOB egress flow control signal to tx_clk. In this case it is */
/*                               assumed/required that ext_tx_flow_control is glitchless (e.g. re */
/*                              gistered in its native clock domain).                             */
/* oob_efc_mode:  - 0=> strict/full OOB egress backpressure mode:
- pause frames and PFC frames,  */
/*               as well as regular packets, are all affected by Unimac input ext_tx_flow_control */
/*               , as long as OOB_EFC_DISAB is 0
- in this mode, OOB backpressure will be active  */
/*               as long as ext_tx_flow_control is asserted and i_oob_efc_disab is 0, regardless  */
/*               of whether the MAC operates in half duplex mode or full duplex mode
1=> legacy m */
/*               ode:
- ext_tx_flow_control does not affect (does not prevent) transmission of Pa */
/*               use and PFC frames, i.e. in this mode OOB egress backpressure may only affect tr */
/*               ansmission of regular packets
- OOB egress backpressure is fully disabled (ignor */
/*               ed) when the MAC operates in half duplex mode.                                   */
/* sw_override_rx:  - If set, enables the SW programmed Rx pause capability config bits to overwr */
/*                 ite the auto negotiated Rx pause capabilities when ena_ext_config (autoconfig) */
/*                  is set.
If cleared, and when ena_ext_config (autoconfig) is set, then SW prog */
/*                 rammed Rx pause capability config bits has no effect over auto negotiated capa */
/*                 bilities.                                                                      */
/* sw_override_tx:  - If set, enables the SW programmed Tx pause capability config bits to overwr */
/*                 ite the auto negotiated Tx pause capabilities when ena_ext_config (autoconfig) */
/*                  is set.
If cleared, and when ena_ext_config (autoconfig) is set, then SW prog */
/*                 rammed Tx pause capability config bits has no effect over auto negotiated capa */
/*                 bilities.                                                                      */
/* mac_loop_con:  - Transmit packets to PHY while in MAC local loopback, when set to '1', otherwi */
/*               se transmit to PHY is disabled (normal operation),
when set to '0' (Reset value) */
/*               .                                                                                */
/* loop_ena:  - Enable GMII/MII loopback (TX to RX) when set to '1', normal operation when set to */
/*            '0' (Reset value).                                                                  */
/* fcs_corrupt_urun_en:  - Corrupt Tx FCS, on underrun, when set to '1', No FCS corruption when s */
/*                      et to '0' (Reset value).                                                  */
/* sw_reset:  - Software Reset Command. When asserted, the TX and RX are 
disabled. Config regist */
/*           ers are not affected by sw reset. Write a 0 to de-assert the sw reset.               */
/* overflow_en:  - If set, enables Rx FIFO overflow logic. In this case, the RXFIFO_STAT[1] regis */
/*              ter bit is not operational (always set to 0).
If cleared, disables RX FIFO overfl */
/*              ow logic. In this case, the RXFIFO_STAT[1] register bit is operational (Sticky se */
/*              t when overrun occurs, clearable only by SW_Reset).                               */
/* rx_low_latency_en:  - This works only when runt filter is disabled. It reduces the receive lat */
/*                    ency by 48 MAC clock time.                                                  */
/* hd_ena:  - Half duplex enable. When set to '1', enables half duplex mode, when set 
to '0', th */
/*         e MAC operates in full duplex mode.
Ignored at ethernet speeds 1G/2.5G or when the reg */
/*         ister ENA_EXT_CONFIG is set to '1'.                                                    */
/* tx_addr_ins:  - Set MAC address on transmit. If enabled (Set to '1') the MAC overwrites 
the s */
/*              ource MAC address with the programmed MAC address in registers MAC_0 
and MAC_1.  */
/*              If disabled (Set to reset value '0'), the source MAC address 
received from the t */
/*              ransmit application transmitted is not modified by the MAC.                       */
/* pause_ignore:  - Ignore Pause Frame Quanta. If enabled (Set to '1') received pause frames 
are */
/*                ignored by the MAC. When disabled (Set to reset value '0') the transmit 
proces */
/*               s is stopped for the amount of time specified in the pause quanta 
received with */
/*               in the pause frame.                                                              */
/* pause_fwd:  - Terminate/Forward Pause Frames. If enabled (Set to '1') pause frames are 
forwar */
/*            ded to the user application.  If disabled (Set to reset value '0'), 
pause frames a */
/*            re terminated and discarded in the MAC.                                             */
/* crc_fwd:  - Terminate/Forward Received CRC. If enabled (1) the CRC field of received 
frames a */
/*          re transmitted to the user application.
If disabled (Set to reset value '0') the CRC  */
/*          field is stripped from the frame.
Note: If padding function (bit PAD_EN set to '1') i */
/*          s enabled. CRC_FWD is 
ignored and the CRC field is checked and always terminated and */
/*           removed.                                                                             */
/* pad_en:  - Enable/Disable Frame Padding. If enabled (Set to '1'), then padding is removed from */
/*          the received frame before it is transmitted to the user
application. If disabled (set */
/*          to reset value '0'), then no padding is removed on receive by the MAC. 
This bit has  */
/*         no effect on Tx padding and hence Transmit always pad runts to guarantee a minimum fra */
/*         me size of 64 octets.                                                                  */
/* promis_en:  - Enable/Disable MAC promiscuous operation. When asserted (Set to '1'), 
all frame */
/*            s are received without Unicast address filtering.                                   */
/* eth_speed:  - Set MAC speed. Bit 1:0 for ETH_SPEED[2:0]. Bit 2 is in ETH_SPEED_BIT2. Ignored w */
/*            hen the register bit ENA_EXT_CONFIG is set to '1'.  When the Register bit ENA_EXT_C */
/*            ONFIG is set to '0', used to set the core mode of operation: 000: Enable 10Mbps Eth */
/*            ernet mode 001: Enable 100Mbps Ethernet mode 010: Enable Gigabit Ethernet mode 011: */
/*             Enable 2.5Gigabit Ethernet mode 101: Enable 5Gigabit Ethernet mode 100 Enable 10Gi */
/*            gabit Ethernet mode                                                                 */
/* rx_ena:  - Enable/Disable MAC receive path. When set to '0' (Reset value), the MAC 
receive fu */
/*         nction is disable.  When set to '1', the MAC receive function is enabled.              */
/* tx_ena:  - Enable/Disable MAC transmit path for data packets & pause/pfc packets sent in the n */
/*         ormal data path.
Pause/pfc packets generated internally are allowed if ignore_tx_pause */
/*          is not set. When set to '0' (Reset value), the MAC 
transmit function is disable.  Wh */
/*         en set to '1', the MAC transmit function is enabled.                                   */
/**************************************************************************************************/
typedef struct
{
    bdmf_boolean eth_speed_bit2;
    bdmf_boolean runt_filter_dis;
    bdmf_boolean oob_efc_disab;
    bdmf_boolean ignore_tx_pause;
    bdmf_boolean fd_tx_urun_fix_en;
    bdmf_boolean line_loopback;
    bdmf_boolean no_lgth_check;
    bdmf_boolean cntl_frm_ena;
    bdmf_boolean ena_ext_config;
    bdmf_boolean en_internal_tx_crs;
    bdmf_boolean bypass_oob_efc_synchronizer;
    bdmf_boolean oob_efc_mode;
    bdmf_boolean sw_override_rx;
    bdmf_boolean sw_override_tx;
    bdmf_boolean mac_loop_con;
    bdmf_boolean loop_ena;
    bdmf_boolean fcs_corrupt_urun_en;
    bdmf_boolean sw_reset;
    bdmf_boolean overflow_en;
    bdmf_boolean rx_low_latency_en;
    bdmf_boolean hd_ena;
    bdmf_boolean tx_addr_ins;
    bdmf_boolean pause_ignore;
    bdmf_boolean pause_fwd;
    bdmf_boolean crc_fwd;
    bdmf_boolean pad_en;
    bdmf_boolean promis_en;
    uint8_t eth_speed;
    bdmf_boolean rx_ena;
    bdmf_boolean tx_ena;
} unimac_rdp_command_config;


/**************************************************************************************************/
/* mac_speed_bit2:  - Bit 2 of MAC_SPEED[2:0]                                                     */
/* link_status:  - Link Status Indication. Set to '0', when link_status input is low.
Set to '1', */
/*               when link_status input is High.                                                  */
/* mac_tx_pause:  - MAC Pause Enabled in Transmit. 
0: MAC Pause Disabled in Transmit
1: MAC Paus */
/*               e Enabled in Transmit                                                            */
/* mac_rx_pause:  - MAC Pause Enabled in Receive. 
0: MAC Pause Disabled in Receive
1: MAC Pause  */
/*               Enabled in Receive                                                               */
/* mac_duplex:  - MAC Duplex. 
0: Full Duplex Mode enabled
1: Half Duplex Mode enabled            */
/* mac_speed:  - MAC Speed[2:0]. Bit 2 is in MAC_SPEED_BIT2.
000: 10Mbps Ethernet Mode enabled
00 */
/*            1: 100Mbps Ethernet Mode enabled
010: Gigabit Ethernet Mode enabled
011: 2.5Gigabit */
/*             Ethernet Mode enabled
101: 5Gigabit Ethernet Mode enabled
100: 10Gigabit Ethernet  */
/*            Mode enabled                                                                        */
/**************************************************************************************************/
typedef struct
{
    bdmf_boolean mac_speed_bit2;
    bdmf_boolean link_status;
    bdmf_boolean mac_tx_pause;
    bdmf_boolean mac_rx_pause;
    bdmf_boolean mac_duplex;
    uint8_t mac_speed;
} unimac_rdp_mac_mode;


/**************************************************************************************************/
/* lp_idle_prediction_mode:  - When set to 1, enables LP_IDLE Prediction. When set to 0, disables */
/*                           LP_IDLE Prediction.
It is an experimental feature and not recommende */
/*                          d to use for the production SW.                                       */
/* dis_eee_10m:  - When this bit is set and link is established at 10Mbps, LPI is not supported ( */
/*              saving is achieved by reduced PHY's output swing). UNIMAC ignores EEE feature on  */
/*              both Tx & Rx in 10Mbps.
When cleared, Unimac doesn't differentiate between speeds */
/*               for EEE feature.                                                                 */
/* eee_txclk_dis:  - If enabled, UNIMAC will shut down TXCLK to PHY, when in LPI state.           */
/* rx_fifo_check:  - If enabled, lpi_rx_detect is set whenever the LPI_IDLES are being received o */
/*                n the RX line and Unimac Rx FIFO is empty.
By default, lpi_rx_detect is set onl */
/*                y when whenever the LPI_IDLES are being received on the RX line.                */
/* eee_en:  - If set, the TX LPI policy control engine is enabled and the MAC inserts LPI_idle co */
/*         des if the link is idle. The rx_lpi_detect assertion is independent of this configurat */
/*         ion. Reset default depends on EEE_en_strap input, which if tied to 1, defaults to enab */
/*         led, otherwise if tied to 0, defaults to disabled.                                     */
/**************************************************************************************************/
typedef struct
{
    bdmf_boolean lp_idle_prediction_mode;
    bdmf_boolean dis_eee_10m;
    bdmf_boolean eee_txclk_dis;
    bdmf_boolean rx_fifo_check;
    bdmf_boolean eee_en;
} unimac_rdp_umac_eee_ctrl;


/**************************************************************************************************/
/* pfc_stats_en:  - When clear, none of PFC related counters should increment. 
Otherwise, PFC co */
/*               unters is in full function. 
Note: it is programming requirement to set this bit */
/*                when PFC function is enable.                                                    */
/* rx_pass_pfc_frm:  - When set, MAC pass PFC frame to the system. Otherwise, PFC frame is discar */
/*                  ded.                                                                          */
/* force_pfc_xon:  - Instructs MAC to send Xon message to all classes of service.                 */
/* pfc_rx_enbl:  - Enables the PFC-Rx functionality.                                              */
/* pfc_tx_enbl:  - Enables the PFC-Tx functionality.                                              */
/**************************************************************************************************/
typedef struct
{
    bdmf_boolean pfc_stats_en;
    bdmf_boolean rx_pass_pfc_frm;
    bdmf_boolean force_pfc_xon;
    bdmf_boolean pfc_rx_enbl;
    bdmf_boolean pfc_tx_enbl;
} unimac_rdp_mac_pfc_ctrl;


/**************************************************************************************************/
/* autoconfig_en:  - When set XIB will set N and M for clock swallower automatically based on the */
/*                 XGMII clock/data rate.Note: This is only applicable to case when the internal  */
/*                serdes is source of the clock used to generate XIB?s GMII clocks.Note: The defa */
/*                ult is the value to which i_autoconfig_en_strap is tied.                        */
/* gmii_tx_clk_gate_en:  - When set XIB will gate GMII TX clock if the TX FIFO occupancy becomes  */
/*                      greater or equal to its XOFF threshold. It will re-enable the clock when  */
/*                      the TX FIFO occupancy is equal or below its XON threshold.Should not be e */
/*                      nabled when TX_BACKPRESSURE_EN = 1.                                       */
/* xgmii_sel_ovrd:  - When set enables XGMII_SEL to select XIB PHY interface. When 0 interface is */
/*                  selected based on the HW pin.                                                 */
/* min_rx_ipg:  - This value guaranties minimum IPG between any two of received packets. When set */
/*              to 0 minimum RX IPG is not enforced that is it equals XGMII IPG (plus/minus IDLEs */
/*              inserted/deleted in clock compensation purposes).                                 */
/* tx_ipg:  - An average number of XGMII IDLE characters that will be inserted between two packet */
/*         s on TX. The actual number of IDLEs between any two packets can be larger or smaller t */
/*         han this number, depending on the programmed IDLE insertion algorithm. Note that IEEE  */
/*         802.3 specifies 5B as minimum IPG (TERMINATE + 4B of IDLE).                            */
/* strict_preamble_dis:  - When this bit is set XIB will support packets with shorter or longer t */
/*                      han standard (i.e. less or more than 6B of 0x55) preamble. XIB will accep */
/*                      t any number of preamble bytes (0x55) until SFD is detected. If SFD is no */
/*                      t detected but instead SOP or EFD, current data are discarded and XIB res */
/*                      tarts the parsing.When cleared packets with non-standard preamble are dis */
/*                      carded.                                                                   */
/* gmii_rx_clk_gate_en:  - When set XIB will gate GMII RX clock if RX FIFO becomes empty in the m */
/*                      iddle of the packet, in order to prevent packet corruption.               */
/* rx_start_threshold:  - Packet receive in GMII clock domain starts only when at least RX_START_ */
/*                     THRESHOLD words are available in XIB RX FIFO.                              */
/* dic_dis:  - When cleared GIB TX deploys DIC (Deficit Idle Counter) algorithm. This algorithms  */
/*          maintains 10Gbps data rate by inserting more or less idles than specified via TX_IPG. */
/*          When set minimum of TX_IPG IDLEs are insert between packets leading to data rate that */
/*           is lower than 10Gbps due to the SOP alignment rules.                                 */
/* xgmii_sel:  - When cleared XIB is by bypassed that is PHY's GMII interfaces is passed through. */
/*             This bit is valid only when XGMII_SEL_OVRD = 1.                                    */
/* standard_mux_en:  - When set glitch-less clock muxes behave as a regular clock muxes.This is d */
/*                  ebug only feature.                                                            */
/* link_down_rst_en:  - When set MAC flushes its RX and TX pipe when the loss of link is detected */
/*                   . It stays in reset until valid link status is indicated by PHY.             */
/* tx_flush_en:  - When set MAC transmit pipe is flushed (control registers are not affected). Mu */
/*              st be cleared by SW.                                                              */
/* rx_flush_en:  - When set MAC receive pipe is flushed (control registers are not affected). Mus */
/*              t be cleared by SW.                                                               */
/* xib_tx_en:  - When set enables transmit MAC. When cleared all data received from the system ar */
/*            e ignored and no data are transmitted to the wire (IDLEs are transmit instead).     */
/* xib_rx_en:  - When set enables receive MAC. When cleared, all data received from PHY are ignor */
/*            ed by RX MAC and no data are passed to the system.                                  */
/**************************************************************************************************/
typedef struct
{
    bdmf_boolean autoconfig_en;
    bdmf_boolean gmii_tx_clk_gate_en;
    bdmf_boolean xgmii_sel_ovrd;
    uint8_t min_rx_ipg;
    uint8_t tx_ipg;
    bdmf_boolean strict_preamble_dis;
    bdmf_boolean gmii_rx_clk_gate_en;
    uint16_t rx_start_threshold;
    bdmf_boolean dic_dis;
    bdmf_boolean xgmii_sel;
    bdmf_boolean standard_mux_en;
    bdmf_boolean link_down_rst_en;
    bdmf_boolean tx_flush_en;
    bdmf_boolean rx_flush_en;
    bdmf_boolean xib_tx_en;
    bdmf_boolean xib_rx_en;
} unimac_rdp_control;


/**************************************************************************************************/
/* rx_fault_status:  - Received faults status encoded as:2'b00 - No Fault2'b01 - Local Fault2'b10 */
/*                   - Remote Fault2'b11 - Link InterruptionCleared on read.                      */
/* tx_fifo_overrun:  - When set indicates that TX FIFO had overflow.Cleared on read.              */
/* tx_fifo_underrun:  - When set indicates that TX FIFO become empty in the middle of the frame.C */
/*                   leared on read.                                                              */
/* rx_fifo_underrun:  - When set indicates that RX FIFO become empty in the middle of the frame.C */
/*                   leared on read.                                                              */
/* rx_fifo_overrun:  - When set indicates that RX FIFO had overflow.Cleared on read.              */
/**************************************************************************************************/
typedef struct
{
    uint8_t rx_fault_status;
    bdmf_boolean tx_fifo_overrun;
    bdmf_boolean tx_fifo_underrun;
    bdmf_boolean rx_fifo_underrun;
    bdmf_boolean rx_fifo_overrun;
} unimac_rdp_status;

bdmf_error_t ag_drv_unimac_rdp_ipg_hd_bkp_cntl_set(uint8_t umac_id, uint8_t ipg_config_rx, bdmf_boolean hd_fc_bkoff_ok, bdmf_boolean hd_fc_ena);
bdmf_error_t ag_drv_unimac_rdp_ipg_hd_bkp_cntl_get(uint8_t umac_id, uint8_t *ipg_config_rx, bdmf_boolean *hd_fc_bkoff_ok, bdmf_boolean *hd_fc_ena);
bdmf_error_t ag_drv_unimac_rdp_command_config_set(uint8_t umac_id, const unimac_rdp_command_config *command_config);
bdmf_error_t ag_drv_unimac_rdp_command_config_get(uint8_t umac_id, unimac_rdp_command_config *command_config);
bdmf_error_t ag_drv_unimac_rdp_mac_0_set(uint8_t umac_id, uint32_t mac_addr0);
bdmf_error_t ag_drv_unimac_rdp_mac_0_get(uint8_t umac_id, uint32_t *mac_addr0);
bdmf_error_t ag_drv_unimac_rdp_mac_1_set(uint8_t umac_id, uint16_t mac_addr1);
bdmf_error_t ag_drv_unimac_rdp_mac_1_get(uint8_t umac_id, uint16_t *mac_addr1);
bdmf_error_t ag_drv_unimac_rdp_frm_length_set(uint8_t umac_id, uint16_t maxfr);
bdmf_error_t ag_drv_unimac_rdp_frm_length_get(uint8_t umac_id, uint16_t *maxfr);
bdmf_error_t ag_drv_unimac_rdp_pause_quant_set(uint8_t umac_id, uint16_t pause_quant);
bdmf_error_t ag_drv_unimac_rdp_pause_quant_get(uint8_t umac_id, uint16_t *pause_quant);
bdmf_error_t ag_drv_unimac_rdp_tx_ts_seq_id_get(uint8_t umac_id, bdmf_boolean *tsts_valid, uint16_t *tsts_seq_id);
bdmf_error_t ag_drv_unimac_rdp_sfd_offset_set(uint8_t umac_id, uint8_t sfd_offset);
bdmf_error_t ag_drv_unimac_rdp_sfd_offset_get(uint8_t umac_id, uint8_t *sfd_offset);
bdmf_error_t ag_drv_unimac_rdp_mac_mode_get(uint8_t umac_id, unimac_rdp_mac_mode *mac_mode);
bdmf_error_t ag_drv_unimac_rdp_tag_0_set(uint8_t umac_id, bdmf_boolean config_outer_tpid_enable, uint16_t frm_tag_0);
bdmf_error_t ag_drv_unimac_rdp_tag_0_get(uint8_t umac_id, bdmf_boolean *config_outer_tpid_enable, uint16_t *frm_tag_0);
bdmf_error_t ag_drv_unimac_rdp_tag_1_set(uint8_t umac_id, bdmf_boolean config_inner_tpid_enable, uint16_t frm_tag_1);
bdmf_error_t ag_drv_unimac_rdp_tag_1_get(uint8_t umac_id, bdmf_boolean *config_inner_tpid_enable, uint16_t *frm_tag_1);
bdmf_error_t ag_drv_unimac_rdp_rx_pause_quanta_scale_set(uint8_t umac_id, bdmf_boolean scale_fix, bdmf_boolean scale_control, uint16_t scale_value);
bdmf_error_t ag_drv_unimac_rdp_rx_pause_quanta_scale_get(uint8_t umac_id, bdmf_boolean *scale_fix, bdmf_boolean *scale_control, uint16_t *scale_value);
bdmf_error_t ag_drv_unimac_rdp_tx_preamble_set(uint8_t umac_id, uint8_t tx_preamble);
bdmf_error_t ag_drv_unimac_rdp_tx_preamble_get(uint8_t umac_id, uint8_t *tx_preamble);
bdmf_error_t ag_drv_unimac_rdp_tx_ipg_length_set(uint8_t umac_id, uint8_t tx_min_pkt_size, uint8_t tx_ipg_length);
bdmf_error_t ag_drv_unimac_rdp_tx_ipg_length_get(uint8_t umac_id, uint8_t *tx_min_pkt_size, uint8_t *tx_ipg_length);
bdmf_error_t ag_drv_unimac_rdp_pfc_xoff_timer_set(uint8_t umac_id, uint16_t pfc_xoff_timer);
bdmf_error_t ag_drv_unimac_rdp_pfc_xoff_timer_get(uint8_t umac_id, uint16_t *pfc_xoff_timer);
bdmf_error_t ag_drv_unimac_rdp_umac_eee_ctrl_set(uint8_t umac_id, const unimac_rdp_umac_eee_ctrl *umac_eee_ctrl);
bdmf_error_t ag_drv_unimac_rdp_umac_eee_ctrl_get(uint8_t umac_id, unimac_rdp_umac_eee_ctrl *umac_eee_ctrl);
bdmf_error_t ag_drv_unimac_rdp_mii_eee_delay_entry_timer_set(uint8_t umac_id, uint32_t mii_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_mii_eee_delay_entry_timer_get(uint8_t umac_id, uint32_t *mii_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_eee_delay_entry_timer_set(uint8_t umac_id, uint32_t gmii_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_eee_delay_entry_timer_get(uint8_t umac_id, uint32_t *gmii_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_umac_eee_ref_count_set(uint8_t umac_id, uint16_t eee_ref_count);
bdmf_error_t ag_drv_unimac_rdp_umac_eee_ref_count_get(uint8_t umac_id, uint16_t *eee_ref_count);
bdmf_error_t ag_drv_unimac_rdp_umac_timestamp_adjust_set(uint8_t umac_id, bdmf_boolean auto_adjust, bdmf_boolean en_1588, uint16_t adjust);
bdmf_error_t ag_drv_unimac_rdp_umac_timestamp_adjust_get(uint8_t umac_id, bdmf_boolean *auto_adjust, bdmf_boolean *en_1588, uint16_t *adjust);
bdmf_error_t ag_drv_unimac_rdp_umac_rx_pkt_drop_status_set(uint8_t umac_id, bdmf_boolean rx_ipg_inval);
bdmf_error_t ag_drv_unimac_rdp_umac_rx_pkt_drop_status_get(uint8_t umac_id, bdmf_boolean *rx_ipg_inval);
bdmf_error_t ag_drv_unimac_rdp_umac_symmetric_idle_threshold_set(uint8_t umac_id, uint16_t threshold_value);
bdmf_error_t ag_drv_unimac_rdp_umac_symmetric_idle_threshold_get(uint8_t umac_id, uint16_t *threshold_value);
bdmf_error_t ag_drv_unimac_rdp_mii_eee_wake_timer_set(uint8_t umac_id, uint16_t mii_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_mii_eee_wake_timer_get(uint8_t umac_id, uint16_t *mii_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_eee_wake_timer_set(uint8_t umac_id, uint16_t gmii_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_eee_wake_timer_get(uint8_t umac_id, uint16_t *gmii_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_umac_rev_id_get(uint8_t umac_id, uint8_t *revision_id_major, uint8_t *revision_id_minor, uint8_t *patch);
bdmf_error_t ag_drv_unimac_rdp_gmii_2p5g_eee_delay_entry_timer_set(uint8_t umac_id, uint32_t gmii_2p5g_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_2p5g_eee_delay_entry_timer_get(uint8_t umac_id, uint32_t *gmii_2p5g_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_5g_eee_delay_entry_timer_set(uint8_t umac_id, uint32_t gmii_5g_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_5g_eee_delay_entry_timer_get(uint8_t umac_id, uint32_t *gmii_5g_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_10g_eee_delay_entry_timer_set(uint8_t umac_id, uint32_t gmii_10g_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_10g_eee_delay_entry_timer_get(uint8_t umac_id, uint32_t *gmii_10g_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_2p5g_eee_wake_timer_set(uint8_t umac_id, uint16_t gmii_2p5g_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_2p5g_eee_wake_timer_get(uint8_t umac_id, uint16_t *gmii_2p5g_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_5g_eee_wake_timer_set(uint8_t umac_id, uint16_t gmii_5g_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_5g_eee_wake_timer_get(uint8_t umac_id, uint16_t *gmii_5g_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_10g_eee_wake_timer_set(uint8_t umac_id, uint16_t gmii_10g_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_gmii_10g_eee_wake_timer_get(uint8_t umac_id, uint16_t *gmii_10g_eee_wake_timer);
bdmf_error_t ag_drv_unimac_rdp_active_eee_delay_entry_timer_get(uint8_t umac_id, uint32_t *active_eee_lpi_timer);
bdmf_error_t ag_drv_unimac_rdp_active_eee_wake_timer_get(uint8_t umac_id, uint16_t *active_eee_wake_time);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_type_set(uint8_t umac_id, uint16_t pfc_eth_type);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_type_get(uint8_t umac_id, uint16_t *pfc_eth_type);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_opcode_set(uint8_t umac_id, uint16_t pfc_opcode);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_opcode_get(uint8_t umac_id, uint16_t *pfc_opcode);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_da_0_set(uint8_t umac_id, uint32_t pfc_macda_0);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_da_0_get(uint8_t umac_id, uint32_t *pfc_macda_0);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_da_1_set(uint8_t umac_id, uint16_t pfc_macda_1);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_da_1_get(uint8_t umac_id, uint16_t *pfc_macda_1);
bdmf_error_t ag_drv_unimac_rdp_macsec_prog_tx_crc_set(uint8_t umac_id, uint32_t macsec_prog_tx_crc);
bdmf_error_t ag_drv_unimac_rdp_macsec_prog_tx_crc_get(uint8_t umac_id, uint32_t *macsec_prog_tx_crc);
bdmf_error_t ag_drv_unimac_rdp_macsec_cntrl_set(uint8_t umac_id, bdmf_boolean dis_pause_data_var_ipg, bdmf_boolean tx_crc_program, bdmf_boolean tx_crc_corupt_en, bdmf_boolean tx_launch_en);
bdmf_error_t ag_drv_unimac_rdp_macsec_cntrl_get(uint8_t umac_id, bdmf_boolean *dis_pause_data_var_ipg, bdmf_boolean *tx_crc_program, bdmf_boolean *tx_crc_corupt_en, bdmf_boolean *tx_launch_en);
bdmf_error_t ag_drv_unimac_rdp_ts_status_get(uint8_t umac_id, uint8_t *word_avail, bdmf_boolean *tx_ts_fifo_empty, bdmf_boolean *tx_ts_fifo_full);
bdmf_error_t ag_drv_unimac_rdp_tx_ts_data_get(uint8_t umac_id, uint32_t *tx_ts_data);
bdmf_error_t ag_drv_unimac_rdp_pause_refresh_ctrl_set(uint8_t umac_id, bdmf_boolean enable, uint32_t refresh_timer);
bdmf_error_t ag_drv_unimac_rdp_pause_refresh_ctrl_get(uint8_t umac_id, bdmf_boolean *enable, uint32_t *refresh_timer);
bdmf_error_t ag_drv_unimac_rdp_flush_control_set(uint8_t umac_id, bdmf_boolean flush);
bdmf_error_t ag_drv_unimac_rdp_flush_control_get(uint8_t umac_id, bdmf_boolean *flush);
bdmf_error_t ag_drv_unimac_rdp_rxfifo_stat_get(uint8_t umac_id, bdmf_boolean *rxfifo_overrun, bdmf_boolean *rxfifo_underrun);
bdmf_error_t ag_drv_unimac_rdp_txfifo_stat_get(uint8_t umac_id, bdmf_boolean *txfifo_overrun, bdmf_boolean *txfifo_underrun);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_ctrl_set(uint8_t umac_id, const unimac_rdp_mac_pfc_ctrl *mac_pfc_ctrl);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_ctrl_get(uint8_t umac_id, unimac_rdp_mac_pfc_ctrl *mac_pfc_ctrl);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_refresh_ctrl_set(uint8_t umac_id, uint16_t pfc_refresh_timer, bdmf_boolean pfc_refresh_en);
bdmf_error_t ag_drv_unimac_rdp_mac_pfc_refresh_ctrl_get(uint8_t umac_id, uint16_t *pfc_refresh_timer, bdmf_boolean *pfc_refresh_en);
bdmf_error_t ag_drv_unimac_rdp_gr64_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr64_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr64_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr64_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr127_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr127_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr127_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr127_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr255_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr255_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr255_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr255_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr511_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr511_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr511_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr511_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr1023_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr1023_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr1023_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr1023_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr1518_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr1518_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr1518_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr1518_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grmgv_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grmgv_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grmgv_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grmgv_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr2047_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr2047_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr2047_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr2047_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr4095_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr4095_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr4095_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr4095_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr9216_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gr9216_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gr9216_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gr9216_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grpkt_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grpkt_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grpkt_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grpkt_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grbyt_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grbyt_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grbyt_upper_set(uint8_t umac_id, uint16_t count_u16);
bdmf_error_t ag_drv_unimac_rdp_grbyt_upper_get(uint8_t umac_id, uint16_t *count_u16);
bdmf_error_t ag_drv_unimac_rdp_grmca_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grmca_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grmca_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grmca_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grbca_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grbca_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grbca_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grbca_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grfcs_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grfcs_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grfcs_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grfcs_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grxcf_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grxcf_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grxcf_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grxcf_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grxpf_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grxpf_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grxpf_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grxpf_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grxuo_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grxuo_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grxuo_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grxuo_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_graln_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_graln_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_graln_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_graln_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grflr_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grflr_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grflr_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grflr_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grcde_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grcde_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grcde_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grcde_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grfcr_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grfcr_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grfcr_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grfcr_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grovr_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grovr_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grovr_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grovr_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grjbr_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grjbr_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grjbr_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grjbr_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grmtue_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grmtue_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grmtue_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grmtue_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grpok_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grpok_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grpok_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grpok_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gruc_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gruc_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gruc_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gruc_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grppp_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grppp_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grppp_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grppp_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_grcrc_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_grcrc_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_grcrc_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_grcrc_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr64_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr64_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr64_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr64_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr127_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr127_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr127_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr127_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr255_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr255_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr255_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr255_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr511_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr511_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr511_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr511_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr1023_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr1023_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr1023_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr1023_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr1518_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr1518_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr1518_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr1518_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_trmgv_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_trmgv_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_trmgv_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_trmgv_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr2047_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr2047_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr2047_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr2047_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr4095_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr4095_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr4095_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr4095_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr9216_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_tr9216_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_tr9216_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_tr9216_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtpkt_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtpkt_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtpkt_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtpkt_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtmca_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtmca_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtmca_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtmca_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtbca_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtbca_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtbca_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtbca_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtxpf_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtxpf_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtxpf_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtxpf_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtxcf_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtxcf_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtxcf_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtxcf_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtfcs_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtfcs_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtfcs_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtfcs_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtovr_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtovr_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtovr_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtovr_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtdrf_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtdrf_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtdrf_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtdrf_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtedf_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtedf_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtedf_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtedf_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtscl_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtscl_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtscl_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtscl_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtmcl_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtmcl_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtmcl_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtmcl_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtlcl_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtlcl_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtlcl_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtlcl_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtxcl_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtxcl_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtxcl_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtxcl_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtfrg_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtfrg_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtfrg_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtfrg_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtncl_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtncl_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtncl_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtncl_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtjbr_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtjbr_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtjbr_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtjbr_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtbyt_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtbyt_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtbyt_upper_set(uint8_t umac_id, uint16_t count_u16);
bdmf_error_t ag_drv_unimac_rdp_gtbyt_upper_get(uint8_t umac_id, uint16_t *count_u16);
bdmf_error_t ag_drv_unimac_rdp_gtpok_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtpok_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtpok_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtpok_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtuc_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_gtuc_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_gtuc_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_gtuc_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrpkt_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_rrpkt_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_rrpkt_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrpkt_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrund_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_rrund_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_rrund_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrund_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrfrg_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_rrfrg_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_rrfrg_upper_set(uint8_t umac_id, uint8_t count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrfrg_upper_get(uint8_t umac_id, uint8_t *count_u8);
bdmf_error_t ag_drv_unimac_rdp_rrbyt_set(uint8_t umac_id, uint32_t count);
bdmf_error_t ag_drv_unimac_rdp_rrbyt_get(uint8_t umac_id, uint32_t *count);
bdmf_error_t ag_drv_unimac_rdp_rrbyt_upper_set(uint8_t umac_id, uint16_t count_u16);
bdmf_error_t ag_drv_unimac_rdp_rrbyt_upper_get(uint8_t umac_id, uint16_t *count_u16);
bdmf_error_t ag_drv_unimac_rdp_mib_cntrl_set(uint8_t umac_id, bdmf_boolean tx_cnt_rst, bdmf_boolean runt_cnt_rst, bdmf_boolean rx_cnt_rst);
bdmf_error_t ag_drv_unimac_rdp_mib_cntrl_get(uint8_t umac_id, bdmf_boolean *tx_cnt_rst, bdmf_boolean *runt_cnt_rst, bdmf_boolean *rx_cnt_rst);
bdmf_error_t ag_drv_unimac_rdp_mib_read_data_set(uint8_t umac_id, uint32_t data32);
bdmf_error_t ag_drv_unimac_rdp_mib_read_data_get(uint8_t umac_id, uint32_t *data32);
bdmf_error_t ag_drv_unimac_rdp_mib_write_data_set(uint8_t umac_id, uint32_t data32);
bdmf_error_t ag_drv_unimac_rdp_mib_write_data_get(uint8_t umac_id, uint32_t *data32);
bdmf_error_t ag_drv_unimac_rdp_psw_ms_set(uint8_t umac_id, uint16_t psw_47_32);
bdmf_error_t ag_drv_unimac_rdp_psw_ms_get(uint8_t umac_id, uint16_t *psw_47_32);
bdmf_error_t ag_drv_unimac_rdp_psw_ls_set(uint8_t umac_id, uint32_t psw_31_0);
bdmf_error_t ag_drv_unimac_rdp_psw_ls_get(uint8_t umac_id, uint32_t *psw_31_0);
bdmf_error_t ag_drv_unimac_rdp_control_set(uint8_t umac_id, const unimac_rdp_control *control);
bdmf_error_t ag_drv_unimac_rdp_control_get(uint8_t umac_id, unimac_rdp_control *control);
bdmf_error_t ag_drv_unimac_rdp_extended_control_set(uint8_t umac_id, bdmf_boolean tx_backpressure_en, uint16_t tx_xon_threshold, uint16_t tx_xoff_threshold, uint16_t tx_start_threshold);
bdmf_error_t ag_drv_unimac_rdp_extended_control_get(uint8_t umac_id, bdmf_boolean *tx_backpressure_en, uint16_t *tx_xon_threshold, uint16_t *tx_xoff_threshold, uint16_t *tx_start_threshold);
bdmf_error_t ag_drv_unimac_rdp_tx_idle_stuffing_control_set(uint8_t umac_id, uint8_t tx_idle_stuffing_ctrl);
bdmf_error_t ag_drv_unimac_rdp_tx_idle_stuffing_control_get(uint8_t umac_id, uint8_t *tx_idle_stuffing_ctrl);
bdmf_error_t ag_drv_unimac_rdp_actual_data_rate_set(uint8_t umac_id, uint8_t actual_data_rate);
bdmf_error_t ag_drv_unimac_rdp_actual_data_rate_get(uint8_t umac_id, uint8_t *actual_data_rate);
bdmf_error_t ag_drv_unimac_rdp_gmii_clock_swallower_control_set(uint8_t umac_id, uint8_t mdiv, uint8_t ndiv);
bdmf_error_t ag_drv_unimac_rdp_gmii_clock_swallower_control_get(uint8_t umac_id, uint8_t *mdiv, uint8_t *ndiv);
bdmf_error_t ag_drv_unimac_rdp_xgmii_data_rate_status_get(uint8_t umac_id, uint8_t *xgmii_data_rate);
bdmf_error_t ag_drv_unimac_rdp_status_get(uint8_t umac_id, unimac_rdp_status *status);
bdmf_error_t ag_drv_unimac_rdp_rx_discard_packet_counter_set(uint8_t umac_id, uint32_t pkt_count);
bdmf_error_t ag_drv_unimac_rdp_rx_discard_packet_counter_get(uint8_t umac_id, uint32_t *pkt_count);
bdmf_error_t ag_drv_unimac_rdp_tx_discard_packet_counter_set(uint8_t umac_id, uint32_t pkt_count);
bdmf_error_t ag_drv_unimac_rdp_tx_discard_packet_counter_get(uint8_t umac_id, uint32_t *pkt_count);
bdmf_error_t ag_drv_unimac_rdp_rev_get(uint8_t umac_id, uint16_t *sys_port_rev);
bdmf_error_t ag_drv_unimac_rdp_umac_rxerr_mask_set(uint8_t umac_id, uint32_t mac_rxerr_mask);
bdmf_error_t ag_drv_unimac_rdp_umac_rxerr_mask_get(uint8_t umac_id, uint32_t *mac_rxerr_mask);
bdmf_error_t ag_drv_unimac_rdp_mib_max_pkt_size_set(uint8_t umac_id, uint16_t max_pkt_size);
bdmf_error_t ag_drv_unimac_rdp_mib_max_pkt_size_get(uint8_t umac_id, uint16_t *max_pkt_size);

#ifdef USE_BDMF_SHELL
enum
{
    cli_unimac_rdp_ipg_hd_bkp_cntl,
    cli_unimac_rdp_command_config,
    cli_unimac_rdp_mac_0,
    cli_unimac_rdp_mac_1,
    cli_unimac_rdp_frm_length,
    cli_unimac_rdp_pause_quant,
    cli_unimac_rdp_tx_ts_seq_id,
    cli_unimac_rdp_sfd_offset,
    cli_unimac_rdp_mac_mode,
    cli_unimac_rdp_tag_0,
    cli_unimac_rdp_tag_1,
    cli_unimac_rdp_rx_pause_quanta_scale,
    cli_unimac_rdp_tx_preamble,
    cli_unimac_rdp_tx_ipg_length,
    cli_unimac_rdp_pfc_xoff_timer,
    cli_unimac_rdp_umac_eee_ctrl,
    cli_unimac_rdp_mii_eee_delay_entry_timer,
    cli_unimac_rdp_gmii_eee_delay_entry_timer,
    cli_unimac_rdp_umac_eee_ref_count,
    cli_unimac_rdp_umac_timestamp_adjust,
    cli_unimac_rdp_umac_rx_pkt_drop_status,
    cli_unimac_rdp_umac_symmetric_idle_threshold,
    cli_unimac_rdp_mii_eee_wake_timer,
    cli_unimac_rdp_gmii_eee_wake_timer,
    cli_unimac_rdp_umac_rev_id,
    cli_unimac_rdp_gmii_2p5g_eee_delay_entry_timer,
    cli_unimac_rdp_gmii_5g_eee_delay_entry_timer,
    cli_unimac_rdp_gmii_10g_eee_delay_entry_timer,
    cli_unimac_rdp_gmii_2p5g_eee_wake_timer,
    cli_unimac_rdp_gmii_5g_eee_wake_timer,
    cli_unimac_rdp_gmii_10g_eee_wake_timer,
    cli_unimac_rdp_active_eee_delay_entry_timer,
    cli_unimac_rdp_active_eee_wake_timer,
    cli_unimac_rdp_mac_pfc_type,
    cli_unimac_rdp_mac_pfc_opcode,
    cli_unimac_rdp_mac_pfc_da_0,
    cli_unimac_rdp_mac_pfc_da_1,
    cli_unimac_rdp_macsec_prog_tx_crc,
    cli_unimac_rdp_macsec_cntrl,
    cli_unimac_rdp_ts_status,
    cli_unimac_rdp_tx_ts_data,
    cli_unimac_rdp_pause_refresh_ctrl,
    cli_unimac_rdp_flush_control,
    cli_unimac_rdp_rxfifo_stat,
    cli_unimac_rdp_txfifo_stat,
    cli_unimac_rdp_mac_pfc_ctrl,
    cli_unimac_rdp_mac_pfc_refresh_ctrl,
    cli_unimac_rdp_gr64,
    cli_unimac_rdp_gr64_upper,
    cli_unimac_rdp_gr127,
    cli_unimac_rdp_gr127_upper,
    cli_unimac_rdp_gr255,
    cli_unimac_rdp_gr255_upper,
    cli_unimac_rdp_gr511,
    cli_unimac_rdp_gr511_upper,
    cli_unimac_rdp_gr1023,
    cli_unimac_rdp_gr1023_upper,
    cli_unimac_rdp_gr1518,
    cli_unimac_rdp_gr1518_upper,
    cli_unimac_rdp_grmgv,
    cli_unimac_rdp_grmgv_upper,
    cli_unimac_rdp_gr2047,
    cli_unimac_rdp_gr2047_upper,
    cli_unimac_rdp_gr4095,
    cli_unimac_rdp_gr4095_upper,
    cli_unimac_rdp_gr9216,
    cli_unimac_rdp_gr9216_upper,
    cli_unimac_rdp_grpkt,
    cli_unimac_rdp_grpkt_upper,
    cli_unimac_rdp_grbyt,
    cli_unimac_rdp_grbyt_upper,
    cli_unimac_rdp_grmca,
    cli_unimac_rdp_grmca_upper,
    cli_unimac_rdp_grbca,
    cli_unimac_rdp_grbca_upper,
    cli_unimac_rdp_grfcs,
    cli_unimac_rdp_grfcs_upper,
    cli_unimac_rdp_grxcf,
    cli_unimac_rdp_grxcf_upper,
    cli_unimac_rdp_grxpf,
    cli_unimac_rdp_grxpf_upper,
    cli_unimac_rdp_grxuo,
    cli_unimac_rdp_grxuo_upper,
    cli_unimac_rdp_graln,
    cli_unimac_rdp_graln_upper,
    cli_unimac_rdp_grflr,
    cli_unimac_rdp_grflr_upper,
    cli_unimac_rdp_grcde,
    cli_unimac_rdp_grcde_upper,
    cli_unimac_rdp_grfcr,
    cli_unimac_rdp_grfcr_upper,
    cli_unimac_rdp_grovr,
    cli_unimac_rdp_grovr_upper,
    cli_unimac_rdp_grjbr,
    cli_unimac_rdp_grjbr_upper,
    cli_unimac_rdp_grmtue,
    cli_unimac_rdp_grmtue_upper,
    cli_unimac_rdp_grpok,
    cli_unimac_rdp_grpok_upper,
    cli_unimac_rdp_gruc,
    cli_unimac_rdp_gruc_upper,
    cli_unimac_rdp_grppp,
    cli_unimac_rdp_grppp_upper,
    cli_unimac_rdp_grcrc,
    cli_unimac_rdp_grcrc_upper,
    cli_unimac_rdp_tr64,
    cli_unimac_rdp_tr64_upper,
    cli_unimac_rdp_tr127,
    cli_unimac_rdp_tr127_upper,
    cli_unimac_rdp_tr255,
    cli_unimac_rdp_tr255_upper,
    cli_unimac_rdp_tr511,
    cli_unimac_rdp_tr511_upper,
    cli_unimac_rdp_tr1023,
    cli_unimac_rdp_tr1023_upper,
    cli_unimac_rdp_tr1518,
    cli_unimac_rdp_tr1518_upper,
    cli_unimac_rdp_trmgv,
    cli_unimac_rdp_trmgv_upper,
    cli_unimac_rdp_tr2047,
    cli_unimac_rdp_tr2047_upper,
    cli_unimac_rdp_tr4095,
    cli_unimac_rdp_tr4095_upper,
    cli_unimac_rdp_tr9216,
    cli_unimac_rdp_tr9216_upper,
    cli_unimac_rdp_gtpkt,
    cli_unimac_rdp_gtpkt_upper,
    cli_unimac_rdp_gtmca,
    cli_unimac_rdp_gtmca_upper,
    cli_unimac_rdp_gtbca,
    cli_unimac_rdp_gtbca_upper,
    cli_unimac_rdp_gtxpf,
    cli_unimac_rdp_gtxpf_upper,
    cli_unimac_rdp_gtxcf,
    cli_unimac_rdp_gtxcf_upper,
    cli_unimac_rdp_gtfcs,
    cli_unimac_rdp_gtfcs_upper,
    cli_unimac_rdp_gtovr,
    cli_unimac_rdp_gtovr_upper,
    cli_unimac_rdp_gtdrf,
    cli_unimac_rdp_gtdrf_upper,
    cli_unimac_rdp_gtedf,
    cli_unimac_rdp_gtedf_upper,
    cli_unimac_rdp_gtscl,
    cli_unimac_rdp_gtscl_upper,
    cli_unimac_rdp_gtmcl,
    cli_unimac_rdp_gtmcl_upper,
    cli_unimac_rdp_gtlcl,
    cli_unimac_rdp_gtlcl_upper,
    cli_unimac_rdp_gtxcl,
    cli_unimac_rdp_gtxcl_upper,
    cli_unimac_rdp_gtfrg,
    cli_unimac_rdp_gtfrg_upper,
    cli_unimac_rdp_gtncl,
    cli_unimac_rdp_gtncl_upper,
    cli_unimac_rdp_gtjbr,
    cli_unimac_rdp_gtjbr_upper,
    cli_unimac_rdp_gtbyt,
    cli_unimac_rdp_gtbyt_upper,
    cli_unimac_rdp_gtpok,
    cli_unimac_rdp_gtpok_upper,
    cli_unimac_rdp_gtuc,
    cli_unimac_rdp_gtuc_upper,
    cli_unimac_rdp_rrpkt,
    cli_unimac_rdp_rrpkt_upper,
    cli_unimac_rdp_rrund,
    cli_unimac_rdp_rrund_upper,
    cli_unimac_rdp_rrfrg,
    cli_unimac_rdp_rrfrg_upper,
    cli_unimac_rdp_rrbyt,
    cli_unimac_rdp_rrbyt_upper,
    cli_unimac_rdp_mib_cntrl,
    cli_unimac_rdp_mib_read_data,
    cli_unimac_rdp_mib_write_data,
    cli_unimac_rdp_psw_ms,
    cli_unimac_rdp_psw_ls,
    cli_unimac_rdp_control,
    cli_unimac_rdp_extended_control,
    cli_unimac_rdp_tx_idle_stuffing_control,
    cli_unimac_rdp_actual_data_rate,
    cli_unimac_rdp_gmii_clock_swallower_control,
    cli_unimac_rdp_xgmii_data_rate_status,
    cli_unimac_rdp_status,
    cli_unimac_rdp_rx_discard_packet_counter,
    cli_unimac_rdp_tx_discard_packet_counter,
    cli_unimac_rdp_rev,
    cli_unimac_rdp_umac_rxerr_mask,
    cli_unimac_rdp_mib_max_pkt_size,
};

int bcm_unimac_rdp_cli_get(bdmf_session_handle session, const bdmfmon_cmd_parm_t parm[], uint16_t n_parms);
bdmfmon_handle_t ag_drv_unimac_rdp_cli_init(bdmfmon_handle_t driver_dir);
#endif


#endif

