/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#ifndef _XRDP_DRV_UNIMAC_MISC_AG_H_
#define _XRDP_DRV_UNIMAC_MISC_AG_H_

#include "access_macros.h"
#include "bdmf_interface.h"
#ifdef USE_BDMF_SHELL
#include "bdmf_shell.h"
#endif
#include "rdp_common.h"


/**************************************************************************************************/
/* rxfifo_pause_threshold: rxfifo_pause_threshold - RX FIFO Threshold - This is the fifo located  */
/*                         between the UNIMAC IP and BBH. Once the threshold is reached, pause is */
/*                          sent. This configuration is in 16-byte resolution (the number of byte */
/*                         s in a FIFO line).Max Value is 0x100.                                  */
/* backpressure_enable_int: backpressure_enable_int - Backpressure enable for internal unimac     */
/* backpressure_enable_ext: backpressure_enable_ext - Backpressure enable for external switch     */
/* fifo_overrun_ctl_en: fifo_overrun_ctl_en - Enable the mechanism for always receiving data from */
/*                       UNIMAC IP and dropping overrun words in the unimac_glue FIFO.            */
/* remote_loopback_en: remote_loopback_en - When setting this bit, RX recovered clock will also i */
/*                     nput the clk25/pll_ref_clk in the UNIMAC.                                  */
/**************************************************************************************************/
typedef struct
{
    uint16_t rxfifo_pause_threshold;
    bdmf_boolean backpressure_enable_int;
    bdmf_boolean backpressure_enable_ext;
    bdmf_boolean fifo_overrun_ctl_en;
    bdmf_boolean remote_loopback_en;
} unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg2;


/**************************************************************************************************/
/* port_rate: port_data_rate - Port data rate, to be used in LED block.                           */
/*                   encoded as:3b000:   10Mb/s3b001:  100Mb/s3b010: 1000Mb/s3b011: 2500Mb/s3b100 */
/*            :   10Gb/s or higher3b101:    5Gb/s3b110: reserved3b111: reserved                   */
/* lpi_tx_detect: lpi_tx_detect - Transmit LPI State - Set to 1 whenever LPI_IDLES are being Sent */
/*                 out on the TX Line                                                             */
/* lpi_rx_detect: lpi_rx_detect - Receive LPI State - Set to 1 whenever LPI_IDLES are being recei */
/*                ved on the RX Line                                                              */
/* pp_stats: pp_stats - The XOFF/XON status of the receiving PPP control frame                    */
/* pp_stats_valid: pp_stats_valid - MAC to indicate a PPP control frame is received               */
/**************************************************************************************************/
typedef struct
{
    uint8_t port_rate;
    bdmf_boolean lpi_tx_detect;
    bdmf_boolean lpi_rx_detect;
    uint8_t pp_stats;
    bdmf_boolean pp_stats_valid;
} unimac_misc_unimac_top_unimac_misc_unimac_stat;

bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_cfg_set(uint8_t umac_misc_id, bdmf_boolean mac_crc_fwd, bdmf_boolean mac_crc_owrt);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_cfg_get(uint8_t umac_misc_id, bdmf_boolean *mac_crc_fwd, bdmf_boolean *mac_crc_owrt);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg1_set(uint8_t umac_misc_id, uint16_t max_pkt_size, uint16_t rxfifo_congestion_threshold);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg1_get(uint8_t umac_misc_id, uint16_t *max_pkt_size, uint16_t *rxfifo_congestion_threshold);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg2_set(uint8_t umac_misc_id, const unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg2 *unimac_top_unimac_misc_unimac_ext_cfg2);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg2_get(uint8_t umac_misc_id, unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg2 *unimac_top_unimac_misc_unimac_ext_cfg2);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_stat_get(uint8_t umac_misc_id, unimac_misc_unimac_top_unimac_misc_unimac_stat *unimac_top_unimac_misc_unimac_stat);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_debug_set(uint8_t umac_misc_id, uint8_t debug_sel);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_debug_get(uint8_t umac_misc_id, uint8_t *debug_sel);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_rst_set(uint8_t umac_misc_id, bdmf_boolean unimac_rst);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_rst_get(uint8_t umac_misc_id, bdmf_boolean *unimac_rst);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_overrun_counter_get(uint8_t umac_misc_id, uint32_t *overrun_counter);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_1588_set(uint8_t umac_misc_id, bdmf_boolean tsi_sign_ext, bdmf_boolean osts_timer_dis, bdmf_boolean egr_1588_ts_mode);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_misc_unimac_1588_get(uint8_t umac_misc_id, bdmf_boolean *tsi_sign_ext, bdmf_boolean *osts_timer_dis, bdmf_boolean *egr_1588_ts_mode);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_isr_set(uint8_t umac_misc_id, bdmf_boolean gen_int);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_isr_get(uint8_t umac_misc_id, bdmf_boolean *gen_int);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_ier_set(uint8_t umac_misc_id, bdmf_boolean value);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_ier_get(uint8_t umac_misc_id, bdmf_boolean *value);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_itr_set(uint8_t umac_misc_id, bdmf_boolean value);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_itr_get(uint8_t umac_misc_id, bdmf_boolean *value);
bdmf_error_t ag_drv_unimac_misc_unimac_top_unimac_ints_ism_get(uint8_t umac_misc_id, bdmf_boolean *value);

#ifdef USE_BDMF_SHELL
enum
{
    cli_unimac_misc_unimac_top_unimac_misc_unimac_cfg,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg1,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_ext_cfg2,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_stat,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_debug,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_rst,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_overrun_counter,
    cli_unimac_misc_unimac_top_unimac_misc_unimac_1588,
    cli_unimac_misc_unimac_top_unimac_ints_isr,
    cli_unimac_misc_unimac_top_unimac_ints_ier,
    cli_unimac_misc_unimac_top_unimac_ints_itr,
    cli_unimac_misc_unimac_top_unimac_ints_ism,
};

int bcm_unimac_misc_cli_get(bdmf_session_handle session, const bdmfmon_cmd_parm_t parm[], uint16_t n_parms);
bdmfmon_handle_t ag_drv_unimac_misc_cli_init(bdmfmon_handle_t driver_dir);
#endif


#endif

