/*
   Copyright (c) 2015 Broadcom
   All Rights Reserved

    <:label-BRCM:2015:DUAL/GPL:standard
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
:>
*/

#include "rdp_common.h"
#include "xrdp_drv_drivers_common_ag.h"
#include "xrdp_drv_natc_key_ag.h"

#define BLOCK_ADDR_COUNT_BITS 3
#define BLOCK_ADDR_COUNT (1<<BLOCK_ADDR_COUNT_BITS)

bdmf_error_t ag_drv_natc_key_mask_set(uint8_t tbl_idx, uint8_t zero, const natc_key_mask *mask)
{
#ifdef VALIDATE_PARMS
    if(!mask)
    {
        bdmf_trace("ERROR driver %s:%u| err=%s (%d)\n", __FILE__, __LINE__, bdmf_strerror(BDMF_ERR_PARM), BDMF_ERR_PARM);
        return BDMF_ERR_PARM;
    }
    if((tbl_idx >= BLOCK_ADDR_COUNT) ||
       (zero >= 1))
    {
        bdmf_trace("ERROR driver %s:%u| err=%s (%d)\n", __FILE__, __LINE__, bdmf_strerror(BDMF_ERR_RANGE), BDMF_ERR_RANGE);
        return BDMF_ERR_RANGE;
    }
#endif

    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 0, NATC_KEY, MASK, mask->data[0]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 1, NATC_KEY, MASK, mask->data[1]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 2, NATC_KEY, MASK, mask->data[2]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 3, NATC_KEY, MASK, mask->data[3]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 4, NATC_KEY, MASK, mask->data[4]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 5, NATC_KEY, MASK, mask->data[5]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 6, NATC_KEY, MASK, mask->data[6]);
    RU_REG_RAM_WRITE(tbl_idx, zero *8 + 7, NATC_KEY, MASK, mask->data[7]);

    return BDMF_ERR_OK;
}

bdmf_error_t ag_drv_natc_key_mask_get(uint8_t tbl_idx, uint8_t zero, natc_key_mask *mask)
{
#ifdef VALIDATE_PARMS
    if(!mask)
    {
        bdmf_trace("ERROR driver %s:%u| err=%s (%d)\n", __FILE__, __LINE__, bdmf_strerror(BDMF_ERR_PARM), BDMF_ERR_PARM);
        return BDMF_ERR_PARM;
    }
    if((tbl_idx >= BLOCK_ADDR_COUNT) ||
       (zero >= 1))
    {
        bdmf_trace("ERROR driver %s:%u| err=%s (%d)\n", __FILE__, __LINE__, bdmf_strerror(BDMF_ERR_RANGE), BDMF_ERR_RANGE);
        return BDMF_ERR_RANGE;
    }
#endif

    RU_REG_RAM_READ(tbl_idx, zero *8 + 0, NATC_KEY, MASK, mask->data[0]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 1, NATC_KEY, MASK, mask->data[1]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 2, NATC_KEY, MASK, mask->data[2]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 3, NATC_KEY, MASK, mask->data[3]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 4, NATC_KEY, MASK, mask->data[4]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 5, NATC_KEY, MASK, mask->data[5]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 6, NATC_KEY, MASK, mask->data[6]);
    RU_REG_RAM_READ(tbl_idx, zero *8 + 7, NATC_KEY, MASK, mask->data[7]);

    return BDMF_ERR_OK;
}

#ifdef USE_BDMF_SHELL
typedef enum
{
    bdmf_address_mask,
}
bdmf_address;

static int bcm_natc_key_cli_set(bdmf_session_handle session, const bdmfmon_cmd_parm_t parm[], uint16_t n_parms)
{
    bdmf_error_t err = BDMF_ERR_OK;

    switch(parm[0].value.unumber)
    {
    case cli_natc_key_mask:
    {
        natc_key_mask mask = { .data = { parm[3].value.unumber, parm[4].value.unumber, parm[5].value.unumber, parm[6].value.unumber, parm[7].value.unumber, parm[8].value.unumber, parm[9].value.unumber, parm[10].value.unumber}};
        err = ag_drv_natc_key_mask_set(parm[1].value.unumber, parm[2].value.unumber, &mask);
        break;
    }
    default:
        err = BDMF_ERR_NOT_SUPPORTED;
        break;
    }
    return err;
}

int bcm_natc_key_cli_get(bdmf_session_handle session, const bdmfmon_cmd_parm_t parm[], uint16_t n_parms)
{
    bdmf_error_t err = BDMF_ERR_OK;

    switch(parm[0].value.unumber)
    {
    case cli_natc_key_mask:
    {
        natc_key_mask mask;
        err = ag_drv_natc_key_mask_get(parm[1].value.unumber, parm[2].value.unumber, &mask);
        bdmf_session_print(session, "data[0] = %u (0x%x)\n", mask.data[0], mask.data[0]);
        bdmf_session_print(session, "data[1] = %u (0x%x)\n", mask.data[1], mask.data[1]);
        bdmf_session_print(session, "data[2] = %u (0x%x)\n", mask.data[2], mask.data[2]);
        bdmf_session_print(session, "data[3] = %u (0x%x)\n", mask.data[3], mask.data[3]);
        bdmf_session_print(session, "data[4] = %u (0x%x)\n", mask.data[4], mask.data[4]);
        bdmf_session_print(session, "data[5] = %u (0x%x)\n", mask.data[5], mask.data[5]);
        bdmf_session_print(session, "data[6] = %u (0x%x)\n", mask.data[6], mask.data[6]);
        bdmf_session_print(session, "data[7] = %u (0x%x)\n", mask.data[7], mask.data[7]);
        break;
    }
    default:
        err = BDMF_ERR_NOT_SUPPORTED;
        break;
    }
    return err;
}

static int bcm_natc_key_cli_test(bdmf_session_handle session, const bdmfmon_cmd_parm_t parm[], uint16_t n_parms)
{
    bdmf_test_method m = parm[0].value.unumber;
    uint8_t tbl_idx = parm[1].value.unumber;
    bdmf_error_t err = BDMF_ERR_OK;

    {
        uint8_t zero=gtmv(m, 0);
        natc_key_mask mask = {.data={gtmv(m, 32), gtmv(m, 32), gtmv(m, 32), gtmv(m, 32), gtmv(m, 32), gtmv(m, 32), gtmv(m, 32), gtmv(m, 32)}};
        bdmf_session_print(session, "ag_drv_natc_key_mask_set(%u %u %u %u %u %u %u %u %u %u)\n", tbl_idx, zero, mask.data[0], mask.data[1], mask.data[2], mask.data[3], mask.data[4], mask.data[5], mask.data[6], mask.data[7]);
        (void)ag_drv_natc_key_mask_set(tbl_idx, zero, &mask);
        (void)ag_drv_natc_key_mask_get(tbl_idx, zero, &mask);
        bdmf_session_print(session, "ag_drv_natc_key_mask_get(%u %u %u %u %u %u %u %u %u %u)\n", tbl_idx, zero, mask.data[0], mask.data[1], mask.data[2], mask.data[3], mask.data[4], mask.data[5], mask.data[6], mask.data[7]);
        if(mask.data[0]!=gtmv(m, 32) || mask.data[1]!=gtmv(m, 32) || mask.data[2]!=gtmv(m, 32) || mask.data[3]!=gtmv(m, 32) || mask.data[4]!=gtmv(m, 32) || mask.data[5]!=gtmv(m, 32) || mask.data[6]!=gtmv(m, 32) || mask.data[7]!=gtmv(m, 32))
            return BDMF_ERR_IO;
    }
    return err;
}

static int bcm_natc_key_cli_address(bdmf_session_handle session, const bdmfmon_cmd_parm_t parm[], uint16_t n_parms)
{
    uint32_t i;
    uint32_t j;
    uint32_t index1_start=0;
    uint32_t index1_stop;
    uint32_t index2_start=0;
    uint32_t index2_stop;
    bdmfmon_cmd_parm_t * bdmf_parm;
    const ru_reg_rec * reg;
    const ru_block_rec * blk;
    const char * enum_string = bdmfmon_enum_parm_stringval(session, 0, parm[0].value.unumber);

    if(!enum_string)
        return BDMF_ERR_INTERNAL;

    switch (parm[0].value.unumber)
    {
    case bdmf_address_mask : reg = &RU_REG(NATC_KEY, MASK); blk = &RU_BLK(NATC_KEY); break;
    default :
        return BDMF_ERR_NOT_SUPPORTED;
        break;
    }
    if((bdmf_parm = bdmfmon_find_named_parm(session,"index1")))
    {
        index1_start = bdmf_parm->value.unumber;
        index1_stop = index1_start + 1;
    }
    else
        index1_stop = blk->addr_count;
    if((bdmf_parm = bdmfmon_find_named_parm(session,"index2")))
    {
        index2_start = bdmf_parm->value.unumber;
        index2_stop = index2_start + 1;
    }
    else
        index2_stop = reg->ram_count + 1;
    if(index1_stop > blk->addr_count)
    {
        bdmf_session_print(session, "index1 (%u) is out of range (%u).\n", index1_stop, blk->addr_count);
        return BDMF_ERR_RANGE;
    }
    if(index2_stop > (reg->ram_count + 1))
    {
        bdmf_session_print(session, "index2 (%u) is out of range (%u).\n", index2_stop, reg->ram_count + 1);
        return BDMF_ERR_RANGE;
    }
    if(reg->ram_count)
        for (i = index1_start; i < index1_stop; i++)
        {
            bdmf_session_print(session, "index1 = %u\n", i);
            for (j = index2_start; j < index2_stop; j++)
                bdmf_session_print(session, 	 "(%5u) 0x%lX\n", j, (blk->addr[i] + reg->addr + j));
        }
    else
        for (i = index1_start; i < index1_stop; i++)
            bdmf_session_print(session, "(%3u) 0x%lX\n", i, blk->addr[i]+reg->addr);
    return 0;
}

bdmfmon_handle_t ag_drv_natc_key_cli_init(bdmfmon_handle_t driver_dir)
{
    bdmfmon_handle_t dir;

    if ((dir = bdmfmon_dir_find(driver_dir, "natc_key"))!=NULL)
        return dir;
    dir = bdmfmon_dir_add(driver_dir, "natc_key", "natc_key", BDMF_ACCESS_ADMIN, NULL);

    {
        static bdmfmon_cmd_parm_t set_mask[]={
            BDMFMON_MAKE_PARM_ENUM("tbl_idx", "tbl_idx", tbl_idx_enum_table, 0),
            BDMFMON_MAKE_PARM("zero", "zero", BDMFMON_PARM_NUMBER, 0),
            BDMFMON_MAKE_PARM("data0", "data0", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data1", "data1", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data2", "data2", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data3", "data3", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data4", "data4", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data5", "data5", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data6", "data6", BDMFMON_PARM_HEX, 0),
            BDMFMON_MAKE_PARM("data7", "data7", BDMFMON_PARM_HEX, 0),
            BDMFMON_PARM_LIST_TERMINATOR
        };
        static bdmfmon_enum_val_t selector_table[] = {
            { .name="mask", .val=cli_natc_key_mask, .parms=set_mask },
            BDMFMON_ENUM_LAST
        };
        BDMFMON_MAKE_CMD(dir, "set", "set", bcm_natc_key_cli_set,
            BDMFMON_MAKE_PARM_SELECTOR("purpose", "purpose", selector_table, 0));
    }
    {
        static bdmfmon_cmd_parm_t set_mask[]={
            BDMFMON_MAKE_PARM("tbl_idx", "tbl_idx", BDMFMON_PARM_NUMBER, 0),
            BDMFMON_MAKE_PARM("zero", "zero", BDMFMON_PARM_NUMBER, 0),
            BDMFMON_PARM_LIST_TERMINATOR
        };
        static bdmfmon_enum_val_t selector_table[] = {
            { .name="mask", .val=cli_natc_key_mask, .parms=set_mask },
            BDMFMON_ENUM_LAST
        };
        BDMFMON_MAKE_CMD(dir, "get", "get", bcm_natc_key_cli_get,
            BDMFMON_MAKE_PARM_SELECTOR("purpose", "purpose", selector_table, 0));
    }
    {
        static bdmfmon_enum_val_t enum_table_test_method[] = {
            { .name="low" , .val=bdmf_test_method_low },
            { .name="mid" , .val=bdmf_test_method_mid },
            { .name="high" , .val=bdmf_test_method_high },
            BDMFMON_ENUM_LAST
        };
        BDMFMON_MAKE_CMD(dir, "test", "test", bcm_natc_key_cli_test,
            BDMFMON_MAKE_PARM_ENUM("method", "low: 0000, mid: 1000, high: 1111", enum_table_test_method, 0),
            BDMFMON_MAKE_PARM_ENUM("tbl_idx", "tbl_idx", tbl_idx_enum_table, 0));
    }
    {
        static bdmfmon_enum_val_t enum_table_address[] = {
            { .name="MASK" , .val=bdmf_address_mask },
            BDMFMON_ENUM_LAST
        };
        BDMFMON_MAKE_CMD(dir, "address", "address", bcm_natc_key_cli_address,
            BDMFMON_MAKE_PARM_ENUM("method", "method", enum_table_address, 0),
            BDMFMON_MAKE_PARM_ENUM("index1", "tbl_idx", tbl_idx_enum_table, 0),
            BDMFMON_MAKE_PARM("index2", "onu_id/alloc_id/port_id/etc...", BDMFMON_PARM_NUMBER, BDMFMON_PARM_FLAG_OPTIONAL));
    }
    return dir;
}
#endif /* USE_BDMF_SHELL */

