/*
    <:copyright-BRCM:2015:DUAL/GPL:standard
    
       Copyright (c) 2015 Broadcom 
       All Rights Reserved
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as published by
    the Free Software Foundation (the "GPL").
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    
    A copy of the GPL is available at http://www.broadcom.com/licenses/GPLv2.php, or by
    writing to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
    
    :>
*/
#ifndef _RDP_DRV_CNPL_H_
#define _RDP_DRV_CNPL_H_

#include "xrdp_drv_drivers_common_ag.h"
#include "xrdp_drv_cnpl_ag.h"

#if CHIP_VER >= RDP_GEN_62
#include "xrdp_drv_bufmng_ag.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif
#if ((CHIP_VER < RDP_GEN_62))
#define CNPL_PERIOD_CYCLES                      8192
#else
#define CNPL_PERIOD_CYCLES                      16384
#endif
#define BITS_4_VAL                              0xF
/* Quanta for 500MHZ (XRDP broadbus) -> 16382ns */
/* Quanta for 466MHZ (XRDP broadbus) -> 17579ns */
#define CNPL_PERIODIC_UPDATE_QUANTA_NS          (CNPL_PERIOD_CYCLES * 1000 / UBUS_SLV_FREQ_IN_MHZ)
#define CNPL_PERIODIC_UPDATE_HALF_QUANTA_NS     (CNPL_PERIODIC_UPDATE_QUANTA_NS / 2)
#define CNPL_PERIODIC_UPDATE_MINIMUM            1

#if defined(POLICER_SHIFT_N_WA)
/* policer HW bug */
#define CNPL_SECOND_TO_US                       1000000000
#else
#define CNPL_SECOND_TO_US                       1000000
#endif

#define POLICER_TIMER_PERIOD                    (CNPL_SECOND_TO_US / CNPL_PERIODIC_UPDATE_US)
#define BUCKET_SIZE_RATE_MULT_MAX               15

#define CNPL_READ_DONE                          0
#define CNPL_READ_PROCESS                       1
#define CNPL_READ_TIMEOUT                       0xffff
#define CNPL_READ_COUNTER_BUFFER                8
#define CNPL_READ_POLICER_BUFFER                2

#define CNPL_MAX_COUNTER_GROUPS                 16
#define CNPL_MAX_COUNTER_INDEX                  16384
#define CNPL_MAX_POLICER_INDEX                  96

#if CHIP_VER >= RDP_GEN_62
#define CNPL_MAX_BUFMNG_INDEX                   32
#else
#define CNPL_MAX_BUFMNG_INDEX                   16
#endif

#if CHIP_VER >= RDP_GEN_60
#define CNPL_COMMAND_OFFSET                     28
#define CNPL_COUNTER_READ_COMMAND_GROUP_OFFSET  24
#define CNPL_COUNTER_READ_COMMAND_START_OFFSET  10
#define CNPL_COUNTER_READ_COMMAND_SIZE_OFFSET   2
#else
#define CNPL_COMMAND_OFFSET                     30
#define CNPL_COUNTER_READ_COMMAND_GROUP_OFFSET  26
#define CNPL_COUNTER_READ_COMMAND_START_OFFSET  12
#define CNPL_COUNTER_READ_COMMAND_SIZE_OFFSET   4
#endif
#define CNPL_COUNTER_READ_COMMAND               1
#define CNPL_MAX_POLICER_GROUPS                 4
#define CNPL_POLICER_POLICE_COMMAND             2
#define CNPL_POLICER_COMMAND_GROUP_OFFSET       28
#define CNPL_POLICER_COMMAND_START_OFFSET       20
#define CNPL_POLICER_COMMAND_PACKET_LEN_OFFSET  4
#define CNPL_POLICER_READ_COMMAND               3
#define CNPL_POLICER_COMMAND_CLEAR_OFFSET       19

uint8_t drv_cnpl_periodic_update_us_to_n_get(uint32_t microseconds);
bdmf_error_t drv_cnpl_memory_data_init(void);
bdmf_error_t drv_cnpl_counter_read_command_set(uint8_t group, uint16_t start_counter, uint8_t num_of_counters);
bdmf_error_t drv_cnpl_counter_read_command_get(uint32_t *counters, uint8_t num_of_counters, bdmf_boolean cn_double, uint8_t cn0_byts, bdmf_boolean is_start_counter_odd);
bdmf_error_t drv_cnpl_policer_police_command_set(uint8_t group, uint8_t policer_num, uint16_t packet_len);
bdmf_error_t drv_cnpl_policer_read_command_get(void *policers, uint8_t num_of_policers, bdmf_boolean single);
bdmf_error_t drv_cnpl_policer_police(uint8_t *result, uint8_t group, uint8_t policer_num, uint16_t packet_len);
bdmf_error_t drv_cnpl_policer_read_command_set(uint8_t group, uint8_t policer_num, bdmf_boolean reset_after_read);
bdmf_error_t drv_cnpl_policer_read(void *policers, uint8_t group, uint8_t num_of_policers, bdmf_boolean reset);
bdmf_error_t drv_cnpl_counter_read(void *counters, uint8_t group, uint16_t start_counter, uint8_t num_of_counters);
bdmf_error_t drv_cnpl_counter_clr(uint8_t group, uint32_t cntr_id);
bdmf_error_t drv_cnpl_counter_set(uint8_t group, uint32_t cntr_id, uint32_t value);
int drv_cnpl_cli_bufmng_sanity_get(bdmf_session_handle session, bdmfmon_cmd_parm_t parm[], uint16_t n_parms);

#if CHIP_VER >= RDP_GEN_62
#define ag_drv_cnpl_cnpl_stat_order_get                        ag_drv_bufmng_counters_cfg_stat_ordr_get
#define ag_drv_cnpl_cnpl_stat_order_set                        ag_drv_bufmng_counters_cfg_stat_ordr_set
#define ag_drv_cnpl_cnpl_stat_max_thr_get                      ag_drv_bufmng_counters_cfg_stat_max_thr_get
#define ag_drv_cnpl_cnpl_stat_max_thr_set                      ag_drv_bufmng_counters_cfg_stat_max_thr_set
#define ag_drv_cnpl_cnpl_stat_rsrv_thr_get                     ag_drv_bufmng_counters_cfg_stat_rsrv_thr_get
#define ag_drv_cnpl_cnpl_stat_rsrv_thr_set                     ag_drv_bufmng_counters_cfg_stat_rsrv_thr_set
#define ag_drv_cnpl_cnpl_stat_hipri_thr_get                    ag_drv_bufmng_counters_cfg_stat_hipri_thr_get
#define ag_drv_cnpl_cnpl_stat_hipri_thr_set                    ag_drv_bufmng_counters_cfg_stat_hipri_thr_set
#define ag_drv_cnpl_cnpl_stat_ctrs_val_get                     ag_drv_bufmng_counters_cfg_stat_ctrs_val_get
#define ag_drv_cnpl_cnpl_stat_ctrs_val_set                     ag_drv_bufmng_counters_cfg_stat_ctrs_val_set
#define ag_drv_cnpl_buf_mng_counters_cfg_stat_cntr_init_set    ag_drv_bufmng_counters_cfg_stat_cntr_init_set
#define ag_drv_cnpl_buf_mng_counters_cfg_stat_hi_wmrk_cfg_set  ag_drv_bufmng_counters_cfg_stat_hi_wmrk_cfg_set
#define ag_drv_cnpl_buf_mng_counters_cfg_stat_cntr_neg_st_get  ag_drv_bufmng_counters_cfg_stat_cntr_neg_st_get
#define ag_drv_cnpl_cnpl_stat_neg_cap_cnt_get                  ag_drv_bufmng_counters_cfg_stat_cnt_neg_cap_cnt_get
#endif


#if defined(BCM4912) || defined(BCM6813)
#define ag_drv_cnpl_cnpl_stat_neg_cap_cnt_get                  ag_drv_cnpl_cnpl_stat_cap_cnt_get
#endif

#if defined(BCM63146)
#define ag_drv_cnpl_cnpl_stat_neg_cap_cnt_get                  ag_drv_cnpl_cnpl_stat_cnt_neg_cap_cnt_get
#endif

#ifdef USE_BDMF_SHELL
int drv_cnpl_cli_config_get(bdmf_session_handle session, bdmfmon_cmd_parm_t parm[], uint16_t n_parms);
int drv_cnpl_cli_bufmng_config_get(bdmf_session_handle session, bdmfmon_cmd_parm_t parm[], uint16_t n_parms);
void drv_cnpl_cli_init(bdmfmon_handle_t driver_dir);
void drv_cnpl_cli_exit(bdmfmon_handle_t driver_dir);
#endif

#define MAX_NUM_OF_COUNTERS_PER_READ   6

#define CNPL_POLICER_COLOR_AWARE_ENABLE 1
#define CNPL_POLICER_COLOR_AWARE_DISABLE 0

/* Data path init helpers */
int drv_cnpl_data_path_init(bdmf_boolean is_gateway, bdmf_boolean vlan_stats_enable, bdmf_boolean en_color_aware, 
    bdmf_boolean reset_arb_prm);

#ifdef __cplusplus
}
#endif

#endif
